/* File:       e-gdbus-egdbusbook.c
 *
 * GType name: EGdbusBook
 * D-Bus name: org.gnome.evolution.dataserver.AddressBook
 *
 * Generated by GDBus Binding Tool 0.1. DO NOT EDIT.
 */

/**
 * SECTION:e-gdbus-egdbusbook
 * @title: EGdbusBook
 * @short_description: Wraps the org.gnome.evolution.dataserver.AddressBook D-Bus interface
 * @include: gio/gio.h
 *
 * The abstract #EGdbusBook interface type wraps the <literal>org.gnome.evolution.dataserver.AddressBook</literal> D-Bus interface. Two concrete implementations of this type are included: #EGdbusBookProxy and #EGdbusBookStub.
 *
 * The generated proxy type #EGdbusBookProxy is typically used with the generated constructors e_gdbus_book_proxy_new(), e_gdbus_book_proxy_new_sync() and e_gdbus_book_proxy_new_for_bus(), e_gdbus_book_proxy_new_for_bus_sync().
 *
 * The generated stub type #EGdbusBookStub takes care of handling properties, method invocations and signal emissions. Simply use e_gdbus_book_stub_new(), set some properties and connect to any of the handle-* signals to handle method invocations. Finally use e_gdbus_book_register_object() to export the object on a #GDBusConnection.
 * |[
 * /<!-- -->* You can also use g_object_new() with E_GDBUS_TYPE_BOOK_STUB
 *  * to set properties at construction time.
 *  *<!-- -->/
 * object = e_gdbus_book_stub_new ();
 * e_gdbus_book_set_&lt;property_name&gt; (object, &lt;value_for_property&gt;);
 * [...]
 *
 * g_signal_connect (object,
 *                   "handle-&lt;method-name&gt;",
 *                   G_CALLBACK (on_handle_&lt;method_name&gt;),
 *                   some_user_data);
 * [...]
 *
 * error = NULL;
 * id = e_gdbus_book_register_object (object,
 *                                    connection,
 *                                    "/path/of/object",
 *                                    &error);
 * ]|
 *
 * You don't <emphasis>have</emphasis> to use the generated stub type to export
 * objects. Any type implementing the #EGdbusBook interface may be used with
 * e_gdbus_book_register_object().
 *
 * Once exported, you can make the exported object emit D-Bus signals by simply
 * emitting the corresponding GType signals. For better type-safety, you can use,
 * the provided e_gdbus_book_emit_*() helpers.
 *
 * For property changes, #GObject::notify signal emissions on exported objects
 * will be intercepted and queued. In an idle handler, the queued notifications
 * are processed and a single <literal>PropertiesChanged</literal> signal (on the
 * <literal>org.freedesktop.DBus.Properties</literal> interface) will be emitted
 * for all the properties that changed (possibly containing several properties).
 * Use e_gdbus_book_drain_notify() to drain the queue immediately.
 */

#include "e-gdbus-egdbusbook.h"
#include "e-gdbus-typemappers.h"
#include "e-gdbus-marshallers.h"

typedef EGdbusBookIface EGdbusBookInterface;
G_DEFINE_INTERFACE (EGdbusBook, e_gdbus_book, G_TYPE_OBJECT);

enum
{
  _0_SIGNAL,
  __WRITABLE_SIGNAL,
  __CONNECTION_SIGNAL,
  __AUTH_REQUIRED_SIGNAL,
  __OPEN_METHOD,
  __REMOVE_METHOD,
  __GET_CONTACT_METHOD,
  __GET_CONTACT_LIST_METHOD,
  __AUTHENTICATE_USER_METHOD,
  __ADD_CONTACT_METHOD,
  __REMOVE_CONTACTS_METHOD,
  __MODIFY_CONTACT_METHOD,
  __GET_STATIC_CAPABILITIES_METHOD,
  __GET_REQUIRED_FIELDS_METHOD,
  __GET_SUPPORTED_FIELDS_METHOD,
  __GET_SUPPORTED_AUTH_METHODS_METHOD,
  __GET_BOOK_VIEW_METHOD,
  __GET_CHANGES_METHOD,
  __CANCEL_OPERATION_METHOD,
  __CLOSE_METHOD,
  __LAST_SIGNAL
};

static guint signals[__LAST_SIGNAL] = {0};

enum
{
  PROP_0,
};

/* ------------------------------------------------------------------------- */

/* Various lookup tables */

static GHashTable *_method_name_to_id = NULL;
static GHashTable *_signal_name_to_id = NULL;
static GHashTable *_property_name_to_id = NULL;
static GHashTable *_property_gname_to_name = NULL;
static GHashTable *_property_name_to_gname = NULL;

static guint
lookup_method_id_from_method_name (const gchar *method_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_method_name_to_id, method_name));
}

static guint
lookup_signal_id_from_signal_name (const gchar *signal_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_signal_name_to_id, signal_name));
}

static guint
lookup_property_id_from_property_name (const gchar *property_name)
{
  return GPOINTER_TO_UINT (g_hash_table_lookup (_property_name_to_id, property_name));
}

static const gchar *
lookup_property_name_from_property_gname (const gchar *property_gname)
{
  return g_hash_table_lookup (_property_gname_to_name, property_gname);
}

static const gchar *
lookup_property_gname_from_property_name (const gchar *property_name)
{
  return g_hash_table_lookup (_property_name_to_gname, property_name);
}

/* ------------------------------------------------------------------------- */
static gboolean
signal_emission_hook_cb_writable (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new_boolean (g_value_get_boolean (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
				 NULL,
				 path,
                                 "org.gnome.evolution.dataserver.AddressBook",
                                 "writable",
				 params,
				 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_connection (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;
  GVariant *item;
  GVariantBuilder *builder;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  builder = g_variant_builder_new (G_VARIANT_TYPE_TUPLE);
  g_assert_cmpint (n_param_values - 1, ==, 1);
  param_values++;
  item = g_variant_new_boolean (g_value_get_boolean (param_values));
  g_variant_builder_add_value (builder, item);
  param_values++;
  params = g_variant_builder_end (builder);
  g_variant_builder_unref (builder);

  g_dbus_connection_emit_signal (connection,
				 NULL,
				 path,
                                 "org.gnome.evolution.dataserver.AddressBook",
                                 "connection",
				 params,
				 NULL);
out:
  return TRUE;
}

static gboolean
signal_emission_hook_cb_auth_required (GSignalInvocationHint *ihint,
                         guint                  n_param_values,
                         const GValue          *param_values,
                         gpointer               user_data)
{
  GObject *object;
  GDBusConnection *connection;
  const gchar *path;
  GVariant *params;

  if (n_param_values < 1 || !G_VALUE_HOLDS (&param_values[0], G_TYPE_OBJECT))
    goto out;
  object = g_value_get_object (&param_values[0]);
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  params = NULL;

  g_dbus_connection_emit_signal (connection,
				 NULL,
				 path,
                                 "org.gnome.evolution.dataserver.AddressBook",
                                 "auth_required",
				 params,
				 NULL);
out:
  return TRUE;
}

static void
e_gdbus_book_default_init (EGdbusBookIface *iface)
{

  /* Build lookup structures */
  _method_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _signal_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _property_name_to_id = g_hash_table_new (g_str_hash, g_str_equal);
  _property_gname_to_name = g_hash_table_new (g_str_hash, g_str_equal);
  _property_name_to_gname = g_hash_table_new (g_str_hash, g_str_equal);
  g_hash_table_insert (_method_name_to_id, (gpointer) "open", GUINT_TO_POINTER (__OPEN_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "remove", GUINT_TO_POINTER (__REMOVE_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getContact", GUINT_TO_POINTER (__GET_CONTACT_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getContactList", GUINT_TO_POINTER (__GET_CONTACT_LIST_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "authenticateUser", GUINT_TO_POINTER (__AUTHENTICATE_USER_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "addContact", GUINT_TO_POINTER (__ADD_CONTACT_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "removeContacts", GUINT_TO_POINTER (__REMOVE_CONTACTS_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "modifyContact", GUINT_TO_POINTER (__MODIFY_CONTACT_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getStaticCapabilities", GUINT_TO_POINTER (__GET_STATIC_CAPABILITIES_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getRequiredFields", GUINT_TO_POINTER (__GET_REQUIRED_FIELDS_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getSupportedFields", GUINT_TO_POINTER (__GET_SUPPORTED_FIELDS_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getSupportedAuthMethods", GUINT_TO_POINTER (__GET_SUPPORTED_AUTH_METHODS_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getBookView", GUINT_TO_POINTER (__GET_BOOK_VIEW_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "getChanges", GUINT_TO_POINTER (__GET_CHANGES_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "cancelOperation", GUINT_TO_POINTER (__CANCEL_OPERATION_METHOD));
  g_hash_table_insert (_method_name_to_id, (gpointer) "close", GUINT_TO_POINTER (__CLOSE_METHOD));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "writable", GUINT_TO_POINTER (__WRITABLE_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "connection", GUINT_TO_POINTER (__CONNECTION_SIGNAL));
  g_hash_table_insert (_signal_name_to_id, (gpointer) "auth_required", GUINT_TO_POINTER (__AUTH_REQUIRED_SIGNAL));

  /* GObject signals definitions for D-Bus signals: */
  /**
   * EGdbusBook::writable:
   * @object: The object emitting the signal.
   * @value: Parameter.
   *
   * Represents the D-Bus signal <literal>writable</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_book_emit_writable() to do this.
   */  signals[__WRITABLE_SIGNAL] =
    g_signal_new ("writable",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, writable),
		  NULL,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_VOID__BOOLEAN,
		  G_TYPE_NONE,
		  1,
		  G_TYPE_BOOLEAN);
  g_signal_add_emission_hook (signals[__WRITABLE_SIGNAL],
			      0,
			      signal_emission_hook_cb_writable,
                              (gpointer) "writable",
			      NULL);

  /**
   * EGdbusBook::connection:
   * @object: The object emitting the signal.
   * @connected: Parameter.
   *
   * Represents the D-Bus signal <literal>connection</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_book_emit_connection() to do this.
   */  signals[__CONNECTION_SIGNAL] =
    g_signal_new ("connection",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, connection),
		  NULL,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_VOID__BOOLEAN,
		  G_TYPE_NONE,
		  1,
		  G_TYPE_BOOLEAN);
  g_signal_add_emission_hook (signals[__CONNECTION_SIGNAL],
			      0,
			      signal_emission_hook_cb_connection,
                              (gpointer) "connection",
			      NULL);

  /**
   * EGdbusBook::auth-required:
   * @object: The object emitting the signal.
   *
   * Represents the D-Bus signal <literal>auth_required</literal>.
   *
   * On proxies, connect to this signal to get notified whenever the remote
   * object instances emits the signal (similar to how the
   * #GDBusProxy::g-signal works). The signal is emitted in the
   * thread-default main loop of the thread that the proxy was created in.
   *
   * On exported objects, emitting this signal causes the actual D-Bus signal to be emitted. You can use e_gdbus_book_emit_auth_required() to do this.
   */  signals[__AUTH_REQUIRED_SIGNAL] =
    g_signal_new ("auth-required",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, auth_required),
		  NULL,
		  NULL,
		  g_cclosure_marshal_VOID__VOID,
		  G_TYPE_NONE,
		  0);
  g_signal_add_emission_hook (signals[__AUTH_REQUIRED_SIGNAL],
			      0,
			      signal_emission_hook_cb_auth_required,
                              (gpointer) "auth_required",
			      NULL);

  /* GObject signals definitions for D-Bus methods: */
  /**
   * EGdbusBook::handle-open:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @only_if_exists: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>open</literal> D-Bus method on @object. Use e_gdbus_book_complete_open() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__OPEN_METHOD] =
    g_signal_new ("handle-open",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_open),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_BOOLEAN,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_BOOLEAN);
  /**
   * EGdbusBook::handle-remove:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>remove</literal> D-Bus method on @object. Use e_gdbus_book_complete_remove() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__REMOVE_METHOD] =
    g_signal_new ("handle-remove",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_remove),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusBook::handle-get-contact:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @uid: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getContact</literal> D-Bus method on @object. Use e_gdbus_book_complete_get_contact() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_CONTACT_METHOD] =
    g_signal_new ("handle-get-contact",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_get_contact),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusBook::handle-get-contact-list:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @query: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getContactList</literal> D-Bus method on @object. Use e_gdbus_book_complete_get_contact_list() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_CONTACT_LIST_METHOD] =
    g_signal_new ("handle-get-contact-list",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_get_contact_list),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusBook::handle-authenticate-user:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @user: Parameter.
   * @passwd: Parameter.
   * @auth_method: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>authenticateUser</literal> D-Bus method on @object. Use e_gdbus_book_complete_authenticate_user() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__AUTHENTICATE_USER_METHOD] =
    g_signal_new ("handle-authenticate-user",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_authenticate_user),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING_STRING_STRING,
		  G_TYPE_BOOLEAN,
		  4,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING,
		  G_TYPE_STRING,
		  G_TYPE_STRING);
  /**
   * EGdbusBook::handle-add-contact:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @vcard: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>addContact</literal> D-Bus method on @object. Use e_gdbus_book_complete_add_contact() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__ADD_CONTACT_METHOD] =
    g_signal_new ("handle-add-contact",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_add_contact),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusBook::handle-remove-contacts:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @list: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>removeContacts</literal> D-Bus method on @object. Use e_gdbus_book_complete_remove_contacts() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__REMOVE_CONTACTS_METHOD] =
    g_signal_new ("handle-remove-contacts",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_remove_contacts),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_BOXED,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRV);
  /**
   * EGdbusBook::handle-modify-contact:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @vcard: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>modifyContact</literal> D-Bus method on @object. Use e_gdbus_book_complete_modify_contact() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__MODIFY_CONTACT_METHOD] =
    g_signal_new ("handle-modify-contact",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_modify_contact),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusBook::handle-get-static-capabilities:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getStaticCapabilities</literal> D-Bus method on @object. Use e_gdbus_book_complete_get_static_capabilities() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_STATIC_CAPABILITIES_METHOD] =
    g_signal_new ("handle-get-static-capabilities",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_get_static_capabilities),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusBook::handle-get-required-fields:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getRequiredFields</literal> D-Bus method on @object. Use e_gdbus_book_complete_get_required_fields() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_REQUIRED_FIELDS_METHOD] =
    g_signal_new ("handle-get-required-fields",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_get_required_fields),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusBook::handle-get-supported-fields:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getSupportedFields</literal> D-Bus method on @object. Use e_gdbus_book_complete_get_supported_fields() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_SUPPORTED_FIELDS_METHOD] =
    g_signal_new ("handle-get-supported-fields",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_get_supported_fields),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusBook::handle-get-supported-auth-methods:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getSupportedAuthMethods</literal> D-Bus method on @object. Use e_gdbus_book_complete_get_supported_auth_methods() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_SUPPORTED_AUTH_METHODS_METHOD] =
    g_signal_new ("handle-get-supported-auth-methods",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_get_supported_auth_methods),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusBook::handle-get-book-view:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @query: Parameter.
   * @max_results: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getBookView</literal> D-Bus method on @object. Use e_gdbus_book_complete_get_book_view() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_BOOK_VIEW_METHOD] =
    g_signal_new ("handle-get-book-view",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_get_book_view),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING_UINT,
		  G_TYPE_BOOLEAN,
		  3,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING,
		  G_TYPE_UINT);
  /**
   * EGdbusBook::handle-get-changes:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   * @change_id: Parameter.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>getChanges</literal> D-Bus method on @object. Use e_gdbus_book_complete_get_changes() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__GET_CHANGES_METHOD] =
    g_signal_new ("handle-get-changes",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_get_changes),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT_STRING,
		  G_TYPE_BOOLEAN,
		  2,
		  G_TYPE_DBUS_METHOD_INVOCATION,
		  G_TYPE_STRING);
  /**
   * EGdbusBook::handle-cancel-operation:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>cancelOperation</literal> D-Bus method on @object. Use e_gdbus_book_complete_cancel_operation() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__CANCEL_OPERATION_METHOD] =
    g_signal_new ("handle-cancel-operation",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_cancel_operation),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);
  /**
   * EGdbusBook::handle-close:
   * @object: The exported object emitting the signal.
   * @invocation: A #GDBusMethodInvocation object that can be used to return a value or error.
   *
   * On exported objects, this signal is emitted when a remote process (identified by @invocation) invokes the <literal>close</literal> D-Bus method on @object. Use e_gdbus_book_complete_close() to return a value or g_dbus_method_invocation_return_error() to return an error.
   *
   * The signal is emitted in the thread-default main loop of the thread that e_gdbus_book_register_object() was called from.
   *
   * On proxies, this signal is never emitted.
   *
   * Returns: %TRUE if you want to handle the method call (will stop further handlers from being called), %FALSE otherwise.
   */
  signals[__CLOSE_METHOD] =
    g_signal_new ("handle-close",
		  G_TYPE_FROM_INTERFACE (iface),
		  G_SIGNAL_RUN_LAST,
		  G_STRUCT_OFFSET (EGdbusBookIface, handle_close),
		  g_signal_accumulator_true_handled,
		  NULL,
		  _e_gdbus_gdbus_cclosure_marshaller_BOOLEAN__OBJECT,
		  G_TYPE_BOOLEAN,
		  1,
		  G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject property definitions for D-Bus properties: */
}

/* C Bindings for properties */

/**
 * e_gdbus_book_call_open:
 * @proxy: A #EGdbusBook.
 * @in_only_if_exists: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.open</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_open_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_open_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_open (
        EGdbusBook *proxy,
        gboolean in_only_if_exists,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(b)",
			   in_only_if_exists);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "open",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_open_finish:
 * @proxy: A #EGdbusBook.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_open().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.open</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_open_finish (
        EGdbusBook *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_open_sync:
 * @proxy: A #EGdbusBook.
 * @in_only_if_exists: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.open</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_open() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_open_sync (
        EGdbusBook *proxy,
        gboolean in_only_if_exists,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(b)",
			   in_only_if_exists);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "open",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_remove:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.remove</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_remove_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_remove_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_remove (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "remove",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_remove_finish:
 * @proxy: A #EGdbusBook.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_remove().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.remove</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_remove_finish (
        EGdbusBook *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_remove_sync:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.remove</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_remove() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_remove_sync (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "remove",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_contact:
 * @proxy: A #EGdbusBook.
 * @in_uid: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_get_contact_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_get_contact_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_get_contact (
        EGdbusBook *proxy,
        const gchar *in_uid,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_uid);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getContact",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_get_contact_finish:
 * @proxy: A #EGdbusBook.
 * @out_vcard: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_get_contact().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.getContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_contact_finish (
        EGdbusBook *proxy,
        gchar **out_vcard,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_vcard);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_contact_sync:
 * @proxy: A #EGdbusBook.
 * @in_uid: Method parameter.
 * @out_vcard: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_get_contact() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_contact_sync (
        EGdbusBook *proxy,
        const gchar *in_uid,
        gchar **out_vcard,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_uid);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getContact",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_vcard);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_contact_list:
 * @proxy: A #EGdbusBook.
 * @in_query: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getContactList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_get_contact_list_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_get_contact_list_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_get_contact_list (
        EGdbusBook *proxy,
        const gchar *in_query,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_query);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getContactList",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_get_contact_list_finish:
 * @proxy: A #EGdbusBook.
 * @out_vcards: Return location for out parameter or %NULL. Free with g_strfreev().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_get_contact_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.getContactList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_contact_list_finish (
        EGdbusBook *proxy,
        gchar ***out_vcards,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_vcards);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_contact_list_sync:
 * @proxy: A #EGdbusBook.
 * @in_query: Method parameter.
 * @out_vcards: Return location for out parameter or %NULL. Free with g_strfreev().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getContactList</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_get_contact_list() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_contact_list_sync (
        EGdbusBook *proxy,
        const gchar *in_query,
        gchar ***out_vcards,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_query);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getContactList",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_vcards);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_authenticate_user:
 * @proxy: A #EGdbusBook.
 * @in_user: Method parameter.
 * @in_passwd: Method parameter.
 * @in_auth_method: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.authenticateUser</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_authenticate_user_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_authenticate_user_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_authenticate_user (
        EGdbusBook *proxy,
        const gchar *in_user,
        const gchar *in_passwd,
        const gchar *in_auth_method,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(sss)",
			   in_user,
			   in_passwd,
			   in_auth_method);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "authenticateUser",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_authenticate_user_finish:
 * @proxy: A #EGdbusBook.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_authenticate_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.authenticateUser</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_authenticate_user_finish (
        EGdbusBook *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_authenticate_user_sync:
 * @proxy: A #EGdbusBook.
 * @in_user: Method parameter.
 * @in_passwd: Method parameter.
 * @in_auth_method: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.authenticateUser</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_authenticate_user() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_authenticate_user_sync (
        EGdbusBook *proxy,
        const gchar *in_user,
        const gchar *in_passwd,
        const gchar *in_auth_method,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(sss)",
			   in_user,
			   in_passwd,
			   in_auth_method);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "authenticateUser",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_add_contact:
 * @proxy: A #EGdbusBook.
 * @in_vcard: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.addContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_add_contact_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_add_contact_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_add_contact (
        EGdbusBook *proxy,
        const gchar *in_vcard,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_vcard);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "addContact",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_add_contact_finish:
 * @proxy: A #EGdbusBook.
 * @out_uid: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_add_contact().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.addContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_add_contact_finish (
        EGdbusBook *proxy,
        gchar **out_uid,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_uid);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_add_contact_sync:
 * @proxy: A #EGdbusBook.
 * @in_vcard: Method parameter.
 * @out_uid: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.addContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_add_contact() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_add_contact_sync (
        EGdbusBook *proxy,
        const gchar *in_vcard,
        gchar **out_uid,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_vcard);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "addContact",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_uid);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_remove_contacts:
 * @proxy: A #EGdbusBook.
 * @in_list: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.removeContacts</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_remove_contacts_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_remove_contacts_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_remove_contacts (
        EGdbusBook *proxy,
        const gchar * const *in_list,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(^as)",
			   in_list);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "removeContacts",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_remove_contacts_finish:
 * @proxy: A #EGdbusBook.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_remove_contacts().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.removeContacts</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_remove_contacts_finish (
        EGdbusBook *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_remove_contacts_sync:
 * @proxy: A #EGdbusBook.
 * @in_list: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.removeContacts</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_remove_contacts() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_remove_contacts_sync (
        EGdbusBook *proxy,
        const gchar * const *in_list,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(^as)",
			   in_list);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "removeContacts",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_modify_contact:
 * @proxy: A #EGdbusBook.
 * @in_vcard: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.modifyContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_modify_contact_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_modify_contact_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_modify_contact (
        EGdbusBook *proxy,
        const gchar *in_vcard,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_vcard);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "modifyContact",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_modify_contact_finish:
 * @proxy: A #EGdbusBook.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_modify_contact().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.modifyContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_modify_contact_finish (
        EGdbusBook *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_modify_contact_sync:
 * @proxy: A #EGdbusBook.
 * @in_vcard: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.modifyContact</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_modify_contact() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_modify_contact_sync (
        EGdbusBook *proxy,
        const gchar *in_vcard,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_vcard);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "modifyContact",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_static_capabilities:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getStaticCapabilities</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_get_static_capabilities_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_get_static_capabilities_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_get_static_capabilities (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getStaticCapabilities",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_get_static_capabilities_finish:
 * @proxy: A #EGdbusBook.
 * @out_capabilities: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_get_static_capabilities().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.getStaticCapabilities</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_static_capabilities_finish (
        EGdbusBook *proxy,
        gchar **out_capabilities,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_capabilities);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_static_capabilities_sync:
 * @proxy: A #EGdbusBook.
 * @out_capabilities: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getStaticCapabilities</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_get_static_capabilities() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_static_capabilities_sync (
        EGdbusBook *proxy,
        gchar **out_capabilities,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getStaticCapabilities",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(s)",
		   out_capabilities);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_required_fields:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getRequiredFields</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_get_required_fields_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_get_required_fields_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_get_required_fields (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getRequiredFields",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_get_required_fields_finish:
 * @proxy: A #EGdbusBook.
 * @out_fields: Return location for out parameter or %NULL. Free with g_strfreev().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_get_required_fields().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.getRequiredFields</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_required_fields_finish (
        EGdbusBook *proxy,
        gchar ***out_fields,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_fields);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_required_fields_sync:
 * @proxy: A #EGdbusBook.
 * @out_fields: Return location for out parameter or %NULL. Free with g_strfreev().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getRequiredFields</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_get_required_fields() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_required_fields_sync (
        EGdbusBook *proxy,
        gchar ***out_fields,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getRequiredFields",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_fields);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_supported_fields:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getSupportedFields</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_get_supported_fields_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_get_supported_fields_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_get_supported_fields (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getSupportedFields",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_get_supported_fields_finish:
 * @proxy: A #EGdbusBook.
 * @out_fields: Return location for out parameter or %NULL. Free with g_strfreev().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_get_supported_fields().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.getSupportedFields</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_supported_fields_finish (
        EGdbusBook *proxy,
        gchar ***out_fields,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_fields);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_supported_fields_sync:
 * @proxy: A #EGdbusBook.
 * @out_fields: Return location for out parameter or %NULL. Free with g_strfreev().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getSupportedFields</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_get_supported_fields() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_supported_fields_sync (
        EGdbusBook *proxy,
        gchar ***out_fields,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getSupportedFields",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_fields);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_supported_auth_methods:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getSupportedAuthMethods</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_get_supported_auth_methods_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_get_supported_auth_methods_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_get_supported_auth_methods (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getSupportedAuthMethods",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_get_supported_auth_methods_finish:
 * @proxy: A #EGdbusBook.
 * @out_auth_methods: Return location for out parameter or %NULL. Free with g_strfreev().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_get_supported_auth_methods().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.getSupportedAuthMethods</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_supported_auth_methods_finish (
        EGdbusBook *proxy,
        gchar ***out_auth_methods,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_auth_methods);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_supported_auth_methods_sync:
 * @proxy: A #EGdbusBook.
 * @out_auth_methods: Return location for out parameter or %NULL. Free with g_strfreev().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getSupportedAuthMethods</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_get_supported_auth_methods() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_supported_auth_methods_sync (
        EGdbusBook *proxy,
        gchar ***out_auth_methods,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getSupportedAuthMethods",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(^as)",
		   out_auth_methods);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_book_view:
 * @proxy: A #EGdbusBook.
 * @in_query: Method parameter.
 * @in_max_results: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getBookView</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_get_book_view_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_get_book_view_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_get_book_view (
        EGdbusBook *proxy,
        const gchar *in_query,
        guint in_max_results,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(su)",
			   in_query,
			   in_max_results);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getBookView",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_get_book_view_finish:
 * @proxy: A #EGdbusBook.
 * @out_view: Return location for out parameter or %NULL. Free with g_free().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_get_book_view().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.getBookView</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_book_view_finish (
        EGdbusBook *proxy,
        gchar **out_view,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(o)",
		   out_view);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_book_view_sync:
 * @proxy: A #EGdbusBook.
 * @in_query: Method parameter.
 * @in_max_results: Method parameter.
 * @out_view: Return location for out parameter or %NULL. Free with g_free().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getBookView</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_get_book_view() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_book_view_sync (
        EGdbusBook *proxy,
        const gchar *in_query,
        guint in_max_results,
        gchar **out_view,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(su)",
			   in_query,
			   in_max_results);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getBookView",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(o)",
		   out_view);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_changes:
 * @proxy: A #EGdbusBook.
 * @in_change_id: Method parameter.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getChanges</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_get_changes_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_get_changes_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_get_changes (
        EGdbusBook *proxy,
        const gchar *in_change_id,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   in_change_id);
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "getChanges",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_get_changes_finish:
 * @proxy: A #EGdbusBook.
 * @out_changes: Return location for out parameter or %NULL. Free with g_variant_unref().
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_get_changes().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.getChanges</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_changes_finish (
        EGdbusBook *proxy,
        GVariant **out_changes,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(*)",
		   out_changes);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_get_changes_sync:
 * @proxy: A #EGdbusBook.
 * @in_change_id: Method parameter.
 * @out_changes: Return location for out parameter or %NULL. Free with g_variant_unref().
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.getChanges</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_get_changes() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_get_changes_sync (
        EGdbusBook *proxy,
        const gchar *in_change_id,
        GVariant **out_changes,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = g_variant_new ("(s)",
			   in_change_id);
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "getChanges",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  {
    g_variant_get (_result,
                   "(*)",
		   out_changes);
  }
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_cancel_operation:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.cancelOperation</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_cancel_operation_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_cancel_operation_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_cancel_operation (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "cancelOperation",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_cancel_operation_finish:
 * @proxy: A #EGdbusBook.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_cancel_operation().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.cancelOperation</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_cancel_operation_finish (
        EGdbusBook *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_cancel_operation_sync:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.cancelOperation</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_cancel_operation() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_cancel_operation_sync (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "cancelOperation",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_close:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL if you don't care about the result of the method invocation.
 * @user_data: Data to pass to @callback.
 *
 * Invokes the <literal>org.gnome.evolution.dataserver.AddressBook.close</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * This is an asynchronous method. When the operation is finished,
 * callback will be invoked in the thread-default main loop of the
 * thread you are calling this method from. You can then call
 * e_gdbus_book_call_close_finish() to get the result of the operation.
 *
 * See e_gdbus_book_call_close_sync() for the synchronous version of this method.
 */
void e_gdbus_book_call_close (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GAsyncReadyCallback callback,
        gpointer user_data)
{
  GVariant *_params;
  _params = NULL;
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
                     "close",
		     _params,
		     G_DBUS_CALL_FLAGS_NONE,
		     G_MAXINT,
		     cancellable,
		     callback,
		     user_data);
}

/**
 * e_gdbus_book_call_close_finish:
 * @proxy: A #EGdbusBook.
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback passed to e_gdbus_book_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes invoking the <literal>org.gnome.evolution.dataserver.AddressBook.close</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_close_finish (
        EGdbusBook *proxy,
        GAsyncResult *res,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_result;
  _result = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_call_close_sync:
 * @proxy: A #EGdbusBook.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <literal>org.gnome.evolution.dataserver.AddressBook.close</literal>
 * D-Bus method on the remote object represented by @proxy.
 *
 * The calling thread is blocked until a reply is received. See
 * e_gdbus_book_call_close() for the asynchronous version of this method.
 *
 * Returns: %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean e_gdbus_book_call_close_sync (
        EGdbusBook *proxy,
        GCancellable *cancellable,
        GError **error)
{
  gboolean _ret = FALSE;
  GVariant *_params;
  GVariant *_result;
  _params = NULL;
  _result = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
                                   "close",
				   _params,
				   G_DBUS_CALL_FLAGS_NONE,
				   G_MAXINT,
				   cancellable,
				   error);
  if (_result == NULL)
    goto _out;
  g_variant_unref (_result);
  _ret = TRUE;
_out:
  return _ret;
}

/**
 * e_gdbus_book_complete_open:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.open</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_open (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_complete_remove:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.remove</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_remove (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_complete_get_contact:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_vcard: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.getContact</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_get_contact (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_vcard)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_vcard);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_get_contact_list:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_vcards: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.getContactList</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_get_contact_list (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_vcards)
{
  GVariant *_params;
  _params = g_variant_new ("(^as)",
			   out_vcards);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_authenticate_user:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.authenticateUser</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_authenticate_user (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_complete_add_contact:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_uid: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.addContact</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_add_contact (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_uid)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_uid);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_remove_contacts:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.removeContacts</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_remove_contacts (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_complete_modify_contact:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.modifyContact</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_modify_contact (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_complete_get_static_capabilities:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_capabilities: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.getStaticCapabilities</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_get_static_capabilities (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_capabilities)
{
  GVariant *_params;
  _params = g_variant_new ("(s)",
			   out_capabilities);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_get_required_fields:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_fields: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.getRequiredFields</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_get_required_fields (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_fields)
{
  GVariant *_params;
  _params = g_variant_new ("(^as)",
			   out_fields);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_get_supported_fields:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_fields: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.getSupportedFields</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_get_supported_fields (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_fields)
{
  GVariant *_params;
  _params = g_variant_new ("(^as)",
			   out_fields);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_get_supported_auth_methods:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_auth_methods: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.getSupportedAuthMethods</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_get_supported_auth_methods (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        const gchar * const *out_auth_methods)
{
  GVariant *_params;
  _params = g_variant_new ("(^as)",
			   out_auth_methods);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_get_book_view:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_view: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.getBookView</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_get_book_view (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        const gchar *out_view)
{
  GVariant *_params;
  _params = g_variant_new ("(o)",
			   out_view);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_get_changes:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 * @out_changes: Value to return.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.getChanges</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_get_changes (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation,
        GVariant *out_changes)
{
  GVariant *_params;
  _params = g_variant_new ("(*)",
			   out_changes);
  g_dbus_method_invocation_return_value (invocation, _params);
}

/**
 * e_gdbus_book_complete_cancel_operation:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.cancelOperation</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_cancel_operation (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_complete_close:
 * @object: A #EGdbusBook.
 * @invocation: A #GDBusMethodInvocation.
 *
 * Completes handling the <literal>org.gnome.evolution.dataserver.AddressBook.close</literal>
 * D-Bus method invocation by returning a value.
 *
 * If you want to return an error, use g_dbus_method_invocation_return_error()
 * or similar instead.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void e_gdbus_book_complete_close (
        EGdbusBook *object,
        GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation, NULL);
}

/**
 * e_gdbus_book_emit_writable:
 * @object: A #EGdbusBook.
 * @arg_value: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.AddressBook.writable</literal>
 * D-Bus signal.
 */
void e_gdbus_book_emit_writable (
        EGdbusBook *object,
        gboolean arg_value)
{
  g_signal_emit (object, signals[__WRITABLE_SIGNAL], 0, arg_value);
}

/**
 * e_gdbus_book_emit_connection:
 * @object: A #EGdbusBook.
 * @arg_connected: Signal parameter.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.AddressBook.connection</literal>
 * D-Bus signal.
 */
void e_gdbus_book_emit_connection (
        EGdbusBook *object,
        gboolean arg_connected)
{
  g_signal_emit (object, signals[__CONNECTION_SIGNAL], 0, arg_connected);
}

/**
 * e_gdbus_book_emit_auth_required:
 * @object: A #EGdbusBook.
 *
 * Emits the <literal>org.gnome.evolution.dataserver.AddressBook.auth_required</literal>
 * D-Bus signal.
 */
void e_gdbus_book_emit_auth_required (
        EGdbusBook *object)
{
  g_signal_emit (object, signals[__AUTH_REQUIRED_SIGNAL], 0);
}

static const GDBusArgInfo e_gdbus_book_signal_writable_value =
{
  -1,
  (gchar *) "value",
  (gchar *) "b",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_signal_writable_arg_pointers[] =
{
  &e_gdbus_book_signal_writable_value,
  NULL
};

static const GDBusSignalInfo e_gdbus_book_signal_writable =
{
  -1,
  (gchar *) "writable",
  (GDBusArgInfo **) &e_gdbus_book_signal_writable_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_signal_connection_connected =
{
  -1,
  (gchar *) "connected",
  (gchar *) "b",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_signal_connection_arg_pointers[] =
{
  &e_gdbus_book_signal_connection_connected,
  NULL
};

static const GDBusSignalInfo e_gdbus_book_signal_connection =
{
  -1,
  (gchar *) "connection",
  (GDBusArgInfo **) &e_gdbus_book_signal_connection_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusSignalInfo e_gdbus_book_signal_auth_required =
{
  -1,
  (gchar *) "auth_required",
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusSignalInfo * const e_gdbus_book_signal_info_pointers[] =
{
  &e_gdbus_book_signal_writable,
  &e_gdbus_book_signal_connection,
  &e_gdbus_book_signal_auth_required,
  NULL
};

static const GDBusArgInfo e_gdbus_book_method_in_open_only_if_exists =
{
  -1,
  (gchar *) "only_if_exists",
  (gchar *) "b",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_open_arg_pointers[] =
{
  &e_gdbus_book_method_in_open_only_if_exists,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_open =
{
  -1,
  (gchar *) "open",
  (GDBusArgInfo **) &e_gdbus_book_method_in_open_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_book_method_remove =
{
  -1,
  (gchar *) "remove",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_in_getContact_uid =
{
  -1,
  (gchar *) "uid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_getContact_arg_pointers[] =
{
  &e_gdbus_book_method_in_getContact_uid,
  NULL
};

static const GDBusArgInfo e_gdbus_book_method_out_getContact_vcard =
{
  -1,
  (gchar *) "vcard",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_getContact_arg_pointers[] =
{
  &e_gdbus_book_method_out_getContact_vcard,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_getContact =
{
  -1,
  (gchar *) "getContact",
  (GDBusArgInfo **) &e_gdbus_book_method_in_getContact_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_book_method_out_getContact_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_in_getContactList_query =
{
  -1,
  (gchar *) "query",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_getContactList_arg_pointers[] =
{
  &e_gdbus_book_method_in_getContactList_query,
  NULL
};

static const GDBusArgInfo e_gdbus_book_method_out_getContactList_vcards =
{
  -1,
  (gchar *) "vcards",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_getContactList_arg_pointers[] =
{
  &e_gdbus_book_method_out_getContactList_vcards,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_getContactList =
{
  -1,
  (gchar *) "getContactList",
  (GDBusArgInfo **) &e_gdbus_book_method_in_getContactList_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_book_method_out_getContactList_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_in_authenticateUser_user =
{
  -1,
  (gchar *) "user",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_book_method_in_authenticateUser_passwd =
{
  -1,
  (gchar *) "passwd",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_book_method_in_authenticateUser_auth_method =
{
  -1,
  (gchar *) "auth_method",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_authenticateUser_arg_pointers[] =
{
  &e_gdbus_book_method_in_authenticateUser_user,
  &e_gdbus_book_method_in_authenticateUser_passwd,
  &e_gdbus_book_method_in_authenticateUser_auth_method,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_authenticateUser =
{
  -1,
  (gchar *) "authenticateUser",
  (GDBusArgInfo **) &e_gdbus_book_method_in_authenticateUser_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_in_addContact_vcard =
{
  -1,
  (gchar *) "vcard",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_addContact_arg_pointers[] =
{
  &e_gdbus_book_method_in_addContact_vcard,
  NULL
};

static const GDBusArgInfo e_gdbus_book_method_out_addContact_uid =
{
  -1,
  (gchar *) "uid",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_addContact_arg_pointers[] =
{
  &e_gdbus_book_method_out_addContact_uid,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_addContact =
{
  -1,
  (gchar *) "addContact",
  (GDBusArgInfo **) &e_gdbus_book_method_in_addContact_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_book_method_out_addContact_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_in_removeContacts_list =
{
  -1,
  (gchar *) "list",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_removeContacts_arg_pointers[] =
{
  &e_gdbus_book_method_in_removeContacts_list,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_removeContacts =
{
  -1,
  (gchar *) "removeContacts",
  (GDBusArgInfo **) &e_gdbus_book_method_in_removeContacts_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_in_modifyContact_vcard =
{
  -1,
  (gchar *) "vcard",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_modifyContact_arg_pointers[] =
{
  &e_gdbus_book_method_in_modifyContact_vcard,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_modifyContact =
{
  -1,
  (gchar *) "modifyContact",
  (GDBusArgInfo **) &e_gdbus_book_method_in_modifyContact_arg_pointers,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_out_getStaticCapabilities_capabilities =
{
  -1,
  (gchar *) "capabilities",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_getStaticCapabilities_arg_pointers[] =
{
  &e_gdbus_book_method_out_getStaticCapabilities_capabilities,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_getStaticCapabilities =
{
  -1,
  (gchar *) "getStaticCapabilities",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_book_method_out_getStaticCapabilities_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_out_getRequiredFields_fields =
{
  -1,
  (gchar *) "fields",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_getRequiredFields_arg_pointers[] =
{
  &e_gdbus_book_method_out_getRequiredFields_fields,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_getRequiredFields =
{
  -1,
  (gchar *) "getRequiredFields",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_book_method_out_getRequiredFields_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_out_getSupportedFields_fields =
{
  -1,
  (gchar *) "fields",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_getSupportedFields_arg_pointers[] =
{
  &e_gdbus_book_method_out_getSupportedFields_fields,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_getSupportedFields =
{
  -1,
  (gchar *) "getSupportedFields",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_book_method_out_getSupportedFields_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_out_getSupportedAuthMethods_auth_methods =
{
  -1,
  (gchar *) "auth_methods",
  (gchar *) "as",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_getSupportedAuthMethods_arg_pointers[] =
{
  &e_gdbus_book_method_out_getSupportedAuthMethods_auth_methods,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_getSupportedAuthMethods =
{
  -1,
  (gchar *) "getSupportedAuthMethods",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) &e_gdbus_book_method_out_getSupportedAuthMethods_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_in_getBookView_query =
{
  -1,
  (gchar *) "query",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo e_gdbus_book_method_in_getBookView_max_results =
{
  -1,
  (gchar *) "max_results",
  (gchar *) "u",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_getBookView_arg_pointers[] =
{
  &e_gdbus_book_method_in_getBookView_query,
  &e_gdbus_book_method_in_getBookView_max_results,
  NULL
};

static const GDBusArgInfo e_gdbus_book_method_out_getBookView_view =
{
  -1,
  (gchar *) "view",
  (gchar *) "o",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_getBookView_arg_pointers[] =
{
  &e_gdbus_book_method_out_getBookView_view,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_getBookView =
{
  -1,
  (gchar *) "getBookView",
  (GDBusArgInfo **) &e_gdbus_book_method_in_getBookView_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_book_method_out_getBookView_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusArgInfo e_gdbus_book_method_in_getChanges_change_id =
{
  -1,
  (gchar *) "change_id",
  (gchar *) "s",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_in_getChanges_arg_pointers[] =
{
  &e_gdbus_book_method_in_getChanges_change_id,
  NULL
};

static const GDBusArgInfo e_gdbus_book_method_out_getChanges_changes =
{
  -1,
  (gchar *) "changes",
  (gchar *) "a(us)",
  (GDBusAnnotationInfo **) NULL,
};
static const GDBusArgInfo * const e_gdbus_book_method_out_getChanges_arg_pointers[] =
{
  &e_gdbus_book_method_out_getChanges_changes,
  NULL
};

static const GDBusMethodInfo e_gdbus_book_method_getChanges =
{
  -1,
  (gchar *) "getChanges",
  (GDBusArgInfo **) &e_gdbus_book_method_in_getChanges_arg_pointers,
  (GDBusArgInfo **) &e_gdbus_book_method_out_getChanges_arg_pointers,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_book_method_cancelOperation =
{
  -1,
  (gchar *) "cancelOperation",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo e_gdbus_book_method_close =
{
  -1,
  (gchar *) "close",
  (GDBusArgInfo **) NULL,
  (GDBusArgInfo **) NULL,
  (GDBusAnnotationInfo **) NULL,
};

static const GDBusMethodInfo * const e_gdbus_book_method_info_pointers[] =
{
  &e_gdbus_book_method_open,
  &e_gdbus_book_method_remove,
  &e_gdbus_book_method_getContact,
  &e_gdbus_book_method_getContactList,
  &e_gdbus_book_method_authenticateUser,
  &e_gdbus_book_method_addContact,
  &e_gdbus_book_method_removeContacts,
  &e_gdbus_book_method_modifyContact,
  &e_gdbus_book_method_getStaticCapabilities,
  &e_gdbus_book_method_getRequiredFields,
  &e_gdbus_book_method_getSupportedFields,
  &e_gdbus_book_method_getSupportedAuthMethods,
  &e_gdbus_book_method_getBookView,
  &e_gdbus_book_method_getChanges,
  &e_gdbus_book_method_cancelOperation,
  &e_gdbus_book_method_close,
  NULL
};

static const GDBusInterfaceInfo _e_gdbus_book_interface_info =
{
  -1,
  (gchar *) "org.gnome.evolution.dataserver.AddressBook",
  (GDBusMethodInfo **) &e_gdbus_book_method_info_pointers,
  (GDBusSignalInfo **) &e_gdbus_book_signal_info_pointers,
  (GDBusPropertyInfo **) NULL,
};

static void
handle_method_call (GDBusConnection       *connection,
                    const gchar           *sender,
                    const gchar           *object_path,
                    const gchar           *interface_name,
                    const gchar           *method_name,
                    GVariant              *parameters,
                    GDBusMethodInvocation *invocation,
                    gpointer               user_data)
{
  guint method_id;
  method_id = lookup_method_id_from_method_name (method_name);
  switch (method_id)
    {
    case __OPEN_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	gboolean arg_only_if_exists;
	g_variant_get (parameters,
                       "(b)",
		       &arg_only_if_exists);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_only_if_exists, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __REMOVE_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_CONTACT_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	const gchar *arg_uid;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_uid);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_uid, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_CONTACT_LIST_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	const gchar *arg_query;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_query);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_query, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __AUTHENTICATE_USER_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	const gchar *arg_user;
	const gchar *arg_passwd;
	const gchar *arg_auth_method;
	g_variant_get (parameters,
                       "(&s&s&s)",
		       &arg_user,
		       &arg_passwd,
		       &arg_auth_method);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_user, arg_passwd, arg_auth_method, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __ADD_CONTACT_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	const gchar *arg_vcard;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_vcard);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_vcard, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __REMOVE_CONTACTS_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	const gchar * const *arg_list;
	g_variant_get (parameters,
                       "(^a&s)",
		       &arg_list);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_list, &handled);
	g_free ((gpointer) arg_list);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __MODIFY_CONTACT_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	const gchar *arg_vcard;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_vcard);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_vcard, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_STATIC_CAPABILITIES_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_REQUIRED_FIELDS_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_SUPPORTED_FIELDS_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_SUPPORTED_AUTH_METHODS_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_BOOK_VIEW_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	const gchar *arg_query;
	guint arg_max_results;
	g_variant_get (parameters,
                       "(&su)",
		       &arg_query,
		       &arg_max_results);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_query, arg_max_results, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __GET_CHANGES_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	const gchar *arg_change_id;
	g_variant_get (parameters,
                       "(&s)",
		       &arg_change_id);
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, arg_change_id, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __CANCEL_OPERATION_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    case __CLOSE_METHOD:
      {
	EGdbusBook *object = E_GDBUS_BOOK (user_data);
	gboolean handled;
	g_signal_emit (object,
		       signals[method_id],
		       0, invocation, &handled);
	if (!handled)
	  goto not_implemented;
      }
      break;

    default:
not_implemented:
      g_dbus_method_invocation_return_error (invocation,
					     G_DBUS_ERROR,
					     G_DBUS_ERROR_NOT_SUPPORTED,
                                             "Method `%s' is not implemented",
					     method_name);
      break;
    }
};

static GVariant *
get_property (GDBusConnection  *connection,
              const gchar      *sender,
              const gchar      *object_path,
              const gchar      *interface_name,
              const gchar      *property_name,
              GError          **error,
              gpointer          user_data)
{
  GVariant *ret;
  guint prop_id;
  prop_id = lookup_property_id_from_property_name (property_name);
  ret = NULL;
  switch (prop_id)
    {
    default:
      g_set_error (error,
		   G_DBUS_ERROR,
		   G_DBUS_ERROR_NOT_SUPPORTED,
                   "This implementation does not support property `%s'",
		   property_name);
      break;
    }

  return ret;
};

static gboolean
set_property (GDBusConnection  *connection,
              const gchar      *sender,
              const gchar      *object_path,
              const gchar      *interface_name,
              const gchar      *property_name,
              GVariant         *value,
              GError          **error,
              gpointer          user_data)
{
  gboolean ret;
  guint prop_id;
  prop_id = lookup_property_id_from_property_name (property_name);
  ret = TRUE;
  switch (prop_id)
    {
    default:
      g_set_error (error,
		   G_DBUS_ERROR,
		   G_DBUS_ERROR_NOT_SUPPORTED,
                   "This implementation does not support property `%s'",
		   property_name);
      ret = FALSE;
      break;
    }

  return ret;
};

static const GDBusInterfaceVTable e_gdbus_book_interface_vtable =
{
  handle_method_call,
  get_property,
  set_property,
};

static gboolean
emit_notifications_in_idle (gpointer user_data)
{
  GObject *object = G_OBJECT (user_data);
  GDBusConnection *connection;
  const gchar *path;
  GHashTable *notification_queue;
  GHashTableIter iter;
  const gchar *property_name;
  GVariant *value;
  GVariantBuilder *builder;
  GVariantBuilder *invalidated_builder;
  GHashTable *pvc;
  gboolean has_changes;

  notification_queue = g_object_get_data (object, "gdbus-codegen-notification-queue");
  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  pvc = g_object_get_data (object, "gdbus-codegen-pvc");
  g_assert (notification_queue != NULL && path != NULL && connection != NULL && pvc != NULL);

  builder = g_variant_builder_new (G_VARIANT_TYPE_ARRAY);
  invalidated_builder = g_variant_builder_new (G_VARIANT_TYPE ("as"));
  g_hash_table_iter_init (&iter, notification_queue);
  has_changes = FALSE;
  while (g_hash_table_iter_next (&iter, (gpointer) &property_name, (gpointer) &value))
    {
      GVariant *cached_value;
      cached_value = g_hash_table_lookup (pvc, property_name);
      if (cached_value == NULL || !g_variant_equal (cached_value, value))
	{
	  g_hash_table_insert (pvc, (gpointer) property_name, (gpointer) g_variant_ref (value));
          g_variant_builder_add (builder, "{sv}", property_name, value);
	  has_changes = TRUE;
	}
    }

  if (has_changes)
    {
      g_dbus_connection_emit_signal (connection,
				     NULL,
				     path,
                                     "org.freedesktop.DBus.Properties",
                                     "PropertiesChanged",
                                     g_variant_new ("(sa{sv}as)",
                                                    "org.gnome.evolution.dataserver.AddressBook",
						    builder,
						    invalidated_builder),
				     NULL);
    }
  else
    {
      g_variant_builder_unref (builder);
      g_variant_builder_unref (invalidated_builder);
    }

  g_hash_table_remove_all (notification_queue);
  g_object_set_data (object, "gdbus-codegen-notification-idle-id", GUINT_TO_POINTER (0));
  return FALSE;
}

static void
queue_notification (GObject     *object,
                    const gchar *property_name,
                    GVariant    *value)
{
  GHashTable *notification_queue;
  guint idle_id;
  notification_queue = g_object_get_data (object, "gdbus-codegen-notification-queue");
  if (notification_queue == NULL)
    {
      notification_queue = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_variant_unref);
      g_object_set_data_full (object, "gdbus-codegen-notification-queue", notification_queue, (GDestroyNotify) g_hash_table_unref);
    }
  g_hash_table_insert (notification_queue, (gpointer) property_name, (gpointer) value); /* adopts value */
  idle_id = GPOINTER_TO_UINT (g_object_get_data (object, "gdbus-codegen-notification-idle-id"));
  if (idle_id == 0)
    {
      GSource *idle_source;
      idle_source = g_idle_source_new ();
      g_source_set_priority (idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (idle_source,
			     emit_notifications_in_idle,
			     g_object_ref (object),
			     (GDestroyNotify) g_object_unref);
      idle_id = g_source_attach (idle_source, g_main_context_get_thread_default ());
      g_source_unref (idle_source);
      g_object_set_data (object, "gdbus-codegen-notification-idle-id", GUINT_TO_POINTER (idle_id));
    }
}

/**
 * e_gdbus_book_drain_notify:
 * @object: A #EGdbusBook that is exported.
 *
 * If @object has queued notifications, empty the queue forcing
 * the <literal>PropertiesChanged</literal> signal to be emitted.
 * See <xref linkend="EGdbusBook.description"/> for more background information.
 */
void
e_gdbus_book_drain_notify (EGdbusBook *object)
{
  gint idle_id;
  idle_id = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (object), "gdbus-codegen-notification-idle-id"));
  if (idle_id > 0)
    {
      emit_notifications_in_idle (object);
      g_source_remove (idle_id);
    }
}

static void
on_notify (GObject    *object,
           GParamSpec *pspec,
           gpointer    user_data)
{
  GDBusConnection *connection;
  const gchar *path;
  GVariant *value;
  const gchar *property_name;
  guint prop_id;

  path = g_object_get_data (object, "gdbus-codegen-path");
  connection = g_object_get_data (object, "gdbus-codegen-connection");
  if (connection == NULL || path == NULL)
    goto out;

  property_name = lookup_property_name_from_property_gname (pspec->name);
  if (property_name == NULL)
    goto out;
  prop_id = lookup_property_id_from_property_name (property_name);

  value = NULL;
  switch (prop_id)
    {
  }

  if (value != NULL && property_name != NULL)
    {
      queue_notification (object, property_name, g_variant_ref_sink (value));
    }
out:
  ;
}

static void
on_object_unregistered (GObject *object)
{
  gint idle_id;
  idle_id = GPOINTER_TO_UINT (g_object_get_data (G_OBJECT (object), "gdbus-codegen-notification-idle-id"));
  if (idle_id > 0)
    {
      g_source_remove (idle_id);
    }
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-path", NULL);
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-connection", NULL);
  g_signal_handlers_disconnect_by_func (object, on_notify, NULL);
}

/**
 * e_gdbus_book_register_object:
 * @object: An instance of a #GObject<!-- -->-derived type implementing the #EGdbusBook interface.
 * @connection: A #GDBusConnection.
 * @object_path: The object to register the object at.
 * @error: Return location for error or %NULL.
 *
 * Registers @object at @object_path on @connection.
 *
 * See <xref linkend="EGdbusBook.description"/>
 * for how properties, methods and signals are handled.
 *
 * Returns: 0 if @error is set, otherwise a registration id (never 0) that can be used with g_dbus_connection_unregister_object().
 */
guint
e_gdbus_book_register_object (EGdbusBook *object,
           GDBusConnection *connection,
           const gchar *object_path,
           GError **error)
{
  G_GNUC_UNUSED GVariant *value;
  GHashTable *pvc;

  pvc = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, (GDestroyNotify) g_variant_unref);

  g_object_set_data_full (G_OBJECT (object), "gdbus-codegen-path", (gpointer) g_strdup (object_path), g_free);
  g_object_set_data (G_OBJECT (object), "gdbus-codegen-connection", (gpointer) connection);
  g_object_set_data_full (G_OBJECT (object), "gdbus-codegen-pvc", (gpointer) pvc, (GDestroyNotify) g_hash_table_unref);
  g_signal_connect (object, "notify", G_CALLBACK (on_notify), NULL);
  return g_dbus_connection_register_object (connection,
	  object_path,
	  (GDBusInterfaceInfo *) &_e_gdbus_book_interface_info,
	  &e_gdbus_book_interface_vtable,
	  object,
	  (GDestroyNotify) on_object_unregistered,
	  error);
}

/**
 * e_gdbus_book_interface_info:
 *
 * Gets interface description for the <literal>org.gnome.evolution.dataserver.AddressBook</literal> D-Bus interface.
 *
 * Returns: A #GDBusInterfaceInfo. Do not free, the object is statically allocated.
 */
const GDBusInterfaceInfo *
e_gdbus_book_interface_info (void)
{
  return &_e_gdbus_book_interface_info;
}

/* ---------------------------------------------------------------------- */

static void proxy_iface_init (EGdbusBookIface *iface);

G_DEFINE_TYPE_WITH_CODE (EGdbusBookProxy, e_gdbus_book_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (E_GDBUS_TYPE_BOOK, proxy_iface_init));

static void
e_gdbus_book_proxy_init (EGdbusBookProxy *proxy)
{
  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy),
				   (GDBusInterfaceInfo *) &_e_gdbus_book_interface_info);
}

static void
g_signal (GDBusProxy  *proxy,
          const gchar *sender_name,
          const gchar *signal_name,
          GVariant    *parameters)
{
  guint signal_id;
  signal_id = lookup_signal_id_from_signal_name (signal_name);
  switch (signal_id)
    {
    case __WRITABLE_SIGNAL:
      {
	gboolean arg_value;
	g_variant_get (parameters,
                       "(b)",
		       &arg_value);
	g_signal_emit (proxy,
		       signals[signal_id],
		       0, arg_value);
      }
      break;

    case __CONNECTION_SIGNAL:
      {
	gboolean arg_connected;
	g_variant_get (parameters,
                       "(b)",
		       &arg_connected);
	g_signal_emit (proxy,
		       signals[signal_id],
		       0, arg_connected);
      }
      break;

    case __AUTH_REQUIRED_SIGNAL:
      {
	g_signal_emit (proxy,
		       signals[signal_id],
		       0);
      }
      break;

    }
}

static void
e_gdbus_book_proxy_get_property (GObject      *object,
                       guint         prop_id,
                       GValue       *value,
                       GParamSpec   *pspec)
{
  G_GNUC_UNUSED GVariant *cached;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
property_set_cb (GDBusProxy   *proxy,
                 GAsyncResult *res,
                 gpointer      user_data)
{
  const gchar *property_name = user_data;
  GError *error;
  GVariant *result;

  error = NULL;
  result = g_dbus_proxy_call_finish (proxy, res, &error);
  if (result == NULL)
    {
      g_warning ("Error setting property `%s': %s", property_name, error->message);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (result);
    }
}

static void
e_gdbus_book_proxy_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  GVariant *new_value;
  const gchar *property_name;
  new_value = NULL;
  property_name = NULL;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }

  if (new_value != NULL)
    {
      g_variant_ref_sink (new_value);
      g_dbus_proxy_call (G_DBUS_PROXY (object),
                         "org.freedesktop.DBus.Properties.Set",
                         g_variant_new ("(ssv)",
                                        "org.gnome.evolution.dataserver.AddressBook",
					property_name,
					new_value),
			 G_DBUS_CALL_FLAGS_NONE,
			 G_MAXINT,
			 NULL,
			 (GAsyncReadyCallback) property_set_cb,
			 (gpointer) property_name);
      g_variant_unref (new_value);
    }

}

static void
g_properties_changed (GDBusProxy         *proxy,
                      GVariant           *changed_properties,
                      const gchar * const *invalidated_properties)
{
  guint n;
  const gchar *key;
  GVariantIter *iter;
  const gchar *gname;

  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      gname = lookup_property_gname_from_property_name (key);
      if (gname != NULL)
	g_object_notify (G_OBJECT (proxy), gname);
    }

  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      gname = lookup_property_gname_from_property_name (invalidated_properties[n]);
      if (gname != NULL)
	g_object_notify (G_OBJECT (proxy), gname);
    }

}

static void
e_gdbus_book_proxy_class_init (EGdbusBookProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->get_property = e_gdbus_book_proxy_get_property;
  gobject_class->set_property = e_gdbus_book_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = g_signal;
  proxy_class->g_properties_changed = g_properties_changed;

}

static void
proxy_iface_init (EGdbusBookIface *iface)
{
}

/**
 * e_gdbus_book_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Like g_dbus_proxy_new() but returns a #EGdbusBookProxy.
 *
 * This is a failable asynchronous constructor - when the proxy is ready, callback will be invoked and you can use e_gdbus_book_proxy_new_finish() to get the result.
 */
void e_gdbus_book_proxy_new (GDBusConnection     *connection,
                   GDBusProxyFlags      flags,
                   const gchar         *name,
                   const gchar         *object_path,
                   GCancellable        *cancellable,
                   GAsyncReadyCallback  callback,
                   gpointer             user_data)
{
  g_async_initable_new_async (E_GDBUS_TYPE_BOOK_PROXY,
			      G_PRIORITY_DEFAULT,
			      cancellable,
			      callback,
			      user_data,
                              "g-flags", flags,
                              "g-name", name,
                              "g-connection", connection,
                              "g-object-path", object_path,
                              "g-interface-name", "org.gnome.evolution.dataserver.AddressBook",
			      NULL);
}

/**
 * e_gdbus_book_proxy_new_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to e_gdbus_book_proxy_new().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #EGdbusBookProxy.
 *
 * Returns: A #EGdbusBookProxy or %NULL if @error is set. Free with g_object_unref().
 */
EGdbusBook *e_gdbus_book_proxy_new_finish (GAsyncResult  *res,
                        GError       **error)
{
  GObject *object;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  g_assert (source_object != NULL);
  object = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object),
					res,
					error);
  g_object_unref (source_object);
  if (object != NULL)
    return E_GDBUS_BOOK (object);
  else
    return NULL;
}

/**
 * e_gdbus_book_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_new_sync() but returns a #EGdbusBookProxy.
 *
 * This is a synchronous failable constructor. See e_gdbus_book_proxy_new() and e_gdbus_book_proxy_new_finish() for the asynchronous version.
 *
 * Returns: A #EGdbusBookProxy or %NULL if error is set. Free with g_object_unref().
 */
EGdbusBook *e_gdbus_book_proxy_new_sync (GDBusConnection     *connection,
                       GDBusProxyFlags      flags,
                       const gchar         *name,
                       const gchar         *object_path,
                       GCancellable        *cancellable,
                       GError             **error)
{
  GInitable *initable;
  initable = g_initable_new (E_GDBUS_TYPE_BOOK_PROXY,
			     cancellable,
			     error,
                             "g-flags", flags,
                             "g-name", name,
                             "g-connection", connection,
                             "g-object-path", object_path,
                             "g-interface-name", "org.gnome.evolution.dataserver.AddressBook",
			     NULL);
  if (initable != NULL)
    return E_GDBUS_BOOK (initable);
  else
    return NULL;
}

/**
 * e_gdbus_book_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @callback: Callback function to invoke when the proxy is ready.
 * @user_data: User data to pass to @callback.
 *
 * Like g_dbus_proxy_new_for_bus() but returns a #EGdbusBookProxy.
 *
 * This is a failable asynchronous constructor - when the proxy is ready, callback will be invoked and you can use e_gdbus_book_proxy_new_for_bus_finish() to get the result.
 */
void e_gdbus_book_proxy_new_for_bus (GBusType             bus_type,
                           GDBusProxyFlags      flags,
                           const gchar         *name,
                           const gchar         *object_path,
                           GCancellable        *cancellable,
                           GAsyncReadyCallback  callback,
                           gpointer             user_data)
{
  g_async_initable_new_async (E_GDBUS_TYPE_BOOK_PROXY,
			      G_PRIORITY_DEFAULT,
			      cancellable,
			      callback,
			      user_data,
                              "g-flags", flags,
                              "g-name", name,
                              "g-bus-type", bus_type,
                              "g-object-path", object_path,
                              "g-interface-name", "org.gnome.evolution.dataserver.AddressBook",
			      NULL);
}

/**
 * e_gdbus_book_proxy_new_for_bus_finish:
 * @res: A #GAsyncResult obtained from the #GAsyncReadyCallback function passed to e_gdbus_book_proxy_new_for_bus().
 * @error: Return location for error or %NULL.
 *
 * Finishes creating a #EGdbusBookProxy.
 *
 * Returns: A #EGdbusBookProxy or %NULL if @error is set. Free with g_object_unref().
 */
EGdbusBook *e_gdbus_book_proxy_new_for_bus_finish (GAsyncResult  *res,
                                GError       **error)
{
  GObject *object;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  g_assert (source_object != NULL);
  object = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object),
					res,
					error);
  g_object_unref (source_object);
  if (object != NULL)
    return E_GDBUS_BOOK (object);
  else
    return NULL;
}

/**
 * e_gdbus_book_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags used when constructing the proxy.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Like g_dbus_proxy_new_for_bus_sync() but returns a #EGdbusBookProxy.
 *
 * This is a synchronous failable constructor. See e_gdbus_book_proxy_new_for_bus() and e_gdbus_book_proxy_new_for_bus_finish() for the asynchronous version.
 *
 * Returns: A #EGdbusBookProxy or %NULL if error is set. Free with g_object_unref().
 */
EGdbusBook *e_gdbus_book_proxy_new_for_bus_sync (GBusType             bus_type,
                               GDBusProxyFlags      flags,
                               const gchar         *name,
                               const gchar         *object_path,
                               GCancellable        *cancellable,
                               GError             **error)
{
  GInitable *initable;
  initable = g_initable_new (E_GDBUS_TYPE_BOOK_PROXY,
			     cancellable,
			     error,
                             "g-flags", flags,
                             "g-name", name,
                             "g-bus-type", bus_type,
                             "g-object-path", object_path,
                             "g-interface-name", "org.gnome.evolution.dataserver.AddressBook",
			     NULL);
  if (initable != NULL)
    return E_GDBUS_BOOK (initable);
  else
    return NULL;
}

/* ---------------------------------------------------------------------- */

struct _EGdbusBookStubPrivate
{
  gint foo;
};

static void stub_iface_init (EGdbusBookIface *iface);

G_DEFINE_TYPE_WITH_CODE (EGdbusBookStub, e_gdbus_book_stub, G_TYPE_OBJECT,
                         G_IMPLEMENT_INTERFACE (E_GDBUS_TYPE_BOOK, stub_iface_init));

static void
e_gdbus_book_stub_finalize (GObject *object)
{
  G_GNUC_UNUSED EGdbusBookStub *stub = (EGdbusBookStub *) object;
  if (G_OBJECT_CLASS (e_gdbus_book_stub_parent_class)->finalize != NULL)
    G_OBJECT_CLASS (e_gdbus_book_stub_parent_class)->finalize (object);
}

static void
e_gdbus_book_stub_get_property (GObject      *object,
                      guint         prop_id,
                      GValue       *value,
                      GParamSpec   *pspec)
{
  G_GNUC_UNUSED static gchar **strv_of_len_zero = {NULL};
  G_GNUC_UNUSED EGdbusBookStub *stub = (EGdbusBookStub *) object;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
e_gdbus_book_stub_set_property (GObject      *object,
                      guint         prop_id,
                      const GValue *value,
                      GParamSpec   *pspec)
{
  G_GNUC_UNUSED EGdbusBookStub *stub = (EGdbusBookStub *) object;
  switch (prop_id)
    {

    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
e_gdbus_book_stub_init (EGdbusBookStub *stub)
{
  stub->priv = G_TYPE_INSTANCE_GET_PRIVATE (stub, E_GDBUS_TYPE_BOOK_STUB, EGdbusBookStubPrivate);
}

static void
e_gdbus_book_stub_class_init (EGdbusBookStubClass *klass)
{
  GObjectClass *gobject_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = e_gdbus_book_stub_finalize;
  gobject_class->get_property = e_gdbus_book_stub_get_property;
  gobject_class->set_property = e_gdbus_book_stub_set_property;
  g_type_class_add_private (klass, sizeof (EGdbusBookStubPrivate));
}

static void
stub_iface_init (EGdbusBookIface *iface)
{
}

/**
 * e_gdbus_book_stub_new:
 *
 * Creates a new stub object that can be exported via e_gdbus_book_register_object().
 *
 * Returns: A #EGdbusBookStub instance. Free with g_object_unref().
 */
EGdbusBook *
e_gdbus_book_stub_new (void)
{
  return E_GDBUS_BOOK (g_object_new (E_GDBUS_TYPE_BOOK_STUB, NULL));
}
