/* collection.c generated by valac 0.18.0.57-8d977, the Vala compiler
 * generated from collection.vala, do not modify */

/* collection.vala
 *
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <string.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_SET (gee_abstract_set_get_type ())
#define GEE_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSet))
#define GEE_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))
#define GEE_IS_ABSTRACT_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_SET))
#define GEE_IS_ABSTRACT_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_SET))
#define GEE_ABSTRACT_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_SET, GeeAbstractSetClass))

typedef struct _GeeAbstractSet GeeAbstractSet;
typedef struct _GeeAbstractSetClass GeeAbstractSetClass;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

typedef guint (*GeeHashDataFunc) (gconstpointer v, void* user_data);
typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, void* user_data);
struct _GeeSetIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeSet* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeSet* self);
	GDestroyNotify (*get_g_destroy_func) (GeeSet* self);
	GeeSet* (*get_read_only_view) (GeeSet* self);
};



GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gboolean gee_collection_remove (GeeCollection* self, gconstpointer item);
void gee_collection_clear (GeeCollection* self);
gboolean gee_collection_add_all (GeeCollection* self, GeeCollection* collection);
static gboolean gee_collection_real_add_all (GeeCollection* self, GeeCollection* collection);
gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static gboolean __lambda15_ (GeeCollection* self, gpointer item, gboolean changed);
static gpointer ___lambda15__gee_fold_func (gpointer g, gpointer a, gpointer self);
gboolean gee_collection_contains_all (GeeCollection* self, GeeCollection* collection);
static gboolean gee_collection_real_contains_all (GeeCollection* self, GeeCollection* collection);
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target);
static gboolean __lambda16_ (GeeCollection* self, gpointer item);
static gboolean ___lambda16__gee_forall_func (gpointer g, gpointer self);
gboolean gee_collection_remove_all (GeeCollection* self, GeeCollection* collection);
static gboolean gee_collection_real_remove_all (GeeCollection* self, GeeCollection* collection);
static gboolean __lambda17_ (GeeCollection* self, gpointer item, gboolean changed);
static gpointer ___lambda17__gee_fold_func (gpointer g, gpointer a, gpointer self);
gboolean gee_collection_retain_all (GeeCollection* self, GeeCollection* collection);
static gboolean gee_collection_real_retain_all (GeeCollection* self, GeeCollection* collection);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
void gee_iterator_remove (GeeIterator* self);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
static gpointer* gee_collection_real_to_array (GeeCollection* self, int* result_length1);
static gboolean* gee_collection_to_bool_array (GeeCollection* coll, int* result_length1);
static gchar* gee_collection_to_char_array (GeeCollection* coll, int* result_length1);
static guchar* gee_collection_to_uchar_array (GeeCollection* coll, int* result_length1);
static gint* gee_collection_to_int_array (GeeCollection* coll, int* result_length1);
static guint* gee_collection_to_uint_array (GeeCollection* coll, int* result_length1);
static gint64* gee_collection_to_int64_array (GeeCollection* coll, int* result_length1);
static guint64* gee_collection_to_uint64_array (GeeCollection* coll, int* result_length1);
static glong* gee_collection_to_long_array (GeeCollection* coll, int* result_length1);
static gulong* gee_collection_to_ulong_array (GeeCollection* coll, int* result_length1);
static gfloat** gee_collection_to_float_array (GeeCollection* coll, int* result_length1);
static gdouble** gee_collection_to_double_array (GeeCollection* coll, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
static gfloat* _float_dup (gfloat* self);
static gdouble* _double_dup (gdouble* self);
GeeCollection* gee_collection_empty (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeHashDataFunc hash_func, void* hash_func_target, GDestroyNotify hash_func_target_destroy_notify, GeeEqualDataFunc equal_func, void* equal_func_target, GDestroyNotify equal_func_target_destroy_notify);
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_set_get_type (void) G_GNUC_CONST;
GType gee_hash_set_get_type (void) G_GNUC_CONST;
GType gee_set_get_type (void) G_GNUC_CONST;
GeeSet* gee_abstract_set_get_read_only_view (GeeAbstractSet* self);
gboolean gee_collection_get_is_empty (GeeCollection* self);
gboolean gee_collection_get_read_only (GeeCollection* self);
GeeCollection* gee_collection_get_read_only_view (GeeCollection* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Determines whether this collection contains the specified item.
 *
 * @param item the item to locate in the collection
 *
 * @return     ``true`` if item is found, ``false`` otherwise
 */
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item) {
#line 51 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 51 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->contains (self, item);
#line 273 "collection.c"
}


/**
 * Adds an item to this collection. Must not be called on read-only
 * collections.
 *
 * @param item the item to add to the collection
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean gee_collection_add (GeeCollection* self, gconstpointer item) {
#line 61 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->add (self, item);
#line 290 "collection.c"
}


/**
 * Removes the first occurence of an item from this collection. Must not
 * be called on read-only collections.
 *
 * @param item the item to remove from the collection
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
gboolean gee_collection_remove (GeeCollection* self, gconstpointer item) {
#line 71 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 71 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->remove (self, item);
#line 307 "collection.c"
}


/**
 * Removes all items from this collection. Must not be called on
 * read-only collections.
 */
void gee_collection_clear (GeeCollection* self) {
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_if_fail (self != NULL);
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	GEE_COLLECTION_GET_INTERFACE (self)->clear (self);
#line 320 "collection.c"
}


/**
 * Adds all items in the input collection to this collection.
 *
 * @param collection the collection which items will be added to this
 *                   collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean __lambda15_ (GeeCollection* self, gpointer item, gboolean changed) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gconstpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = changed;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = item;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = gee_collection_add (self, _tmp1_);
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp0_ | _tmp2_;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 349 "collection.c"
}


static gpointer ___lambda15__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda15_ (self, g, a);
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 358 "collection.c"
}


static gboolean gee_collection_real_add_all (GeeCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	GeeCollection* _tmp0_;
	gpointer _tmp1_ = NULL;
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = collection;
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_traversable_fold ((GeeTraversable*) _tmp0_, G_TYPE_BOOLEAN, NULL, NULL, ___lambda15__gee_fold_func, self, (gpointer) ((gintptr) FALSE));
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = (gboolean) ((gintptr) _tmp1_);
#line 88 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 376 "collection.c"
}


gboolean gee_collection_add_all (GeeCollection* self, GeeCollection* collection) {
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->add_all (self, collection);
#line 385 "collection.c"
}


/**
 * Returns ``true`` it this collection contains all items as the input
 * collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean __lambda16_ (GeeCollection* self, gpointer item) {
	gboolean result = FALSE;
	gconstpointer _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = item;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_contains (self, _tmp0_);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp1_;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 412 "collection.c"
}


static gboolean ___lambda16__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda16_ (self, g);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 421 "collection.c"
}


static gboolean gee_collection_real_contains_all (GeeCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	GeeCollection* _tmp0_;
	gboolean _tmp1_ = FALSE;
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = collection;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_traversable_foreach ((GeeTraversable*) _tmp0_, ___lambda16__gee_forall_func, self);
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp1_;
#line 101 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 439 "collection.c"
}


gboolean gee_collection_contains_all (GeeCollection* self, GeeCollection* collection) {
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 100 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->contains_all (self, collection);
#line 448 "collection.c"
}


/**
 * Removes the subset of items in this collection corresponding to the
 * elments in the input collection. If there is several occurrences of
 * the same value in this collection they are decremented of the number
 * of occurrences in the input collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean __lambda17_ (GeeCollection* self, gpointer item, gboolean changed) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gconstpointer _tmp1_;
	gboolean _tmp2_ = FALSE;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = changed;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = item;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = gee_collection_remove (self, _tmp1_);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp0_ | _tmp2_;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 480 "collection.c"
}


static gpointer ___lambda17__gee_fold_func (gpointer g, gpointer a, gpointer self) {
	gpointer result;
	result = __lambda17_ (self, g, a);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 489 "collection.c"
}


static gboolean gee_collection_real_remove_all (GeeCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	GeeCollection* _tmp0_;
	gpointer _tmp1_ = NULL;
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = collection;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_traversable_fold ((GeeTraversable*) _tmp0_, G_TYPE_BOOLEAN, NULL, NULL, ___lambda17__gee_fold_func, self, (gpointer) ((gintptr) FALSE));
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = (gboolean) ((gintptr) _tmp1_);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 507 "collection.c"
}


gboolean gee_collection_remove_all (GeeCollection* self, GeeCollection* collection) {
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->remove_all (self, collection);
#line 516 "collection.c"
}


/**
 * Removes all items in this collection that are not contained in the input
 * collection. In other words all common items of both collections are
 * retained in this collection.
 *
 * @param collection the collection which items will be compared with
 *                   this collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean gee_collection_real_retain_all (GeeCollection* self, GeeCollection* collection) {
	gboolean result = FALSE;
	gboolean changed;
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	changed = FALSE;
#line 537 "collection.c"
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* iter;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) self);
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iter = _tmp0_;
#line 545 "collection.c"
		{
			gboolean _tmp1_;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp1_ = TRUE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			while (TRUE) {
#line 552 "collection.c"
				gboolean _tmp2_;
				GeeIterator* _tmp3_;
				gboolean _tmp4_ = FALSE;
				GeeIterator* _tmp5_;
				gpointer _tmp6_ = NULL;
				gpointer item;
				GeeCollection* _tmp7_;
				gconstpointer _tmp8_;
				gboolean _tmp9_ = FALSE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp2_ = _tmp1_;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (!_tmp2_) {
#line 566 "collection.c"
				}
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp1_ = FALSE;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp3_ = iter;
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp4_ = gee_iterator_next (_tmp3_);
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (!_tmp4_) {
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					break;
#line 578 "collection.c"
				}
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp5_ = iter;
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp6_ = gee_iterator_get (_tmp5_);
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				item = _tmp6_;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp7_ = collection;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp8_ = item;
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp9_ = gee_collection_contains (_tmp7_, _tmp8_);
#line 133 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (!_tmp9_) {
#line 594 "collection.c"
					GeeIterator* _tmp10_;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp10_ = iter;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					gee_iterator_remove (_tmp10_);
#line 135 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					changed = TRUE;
#line 602 "collection.c"
				}
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				((item == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 606 "collection.c"
			}
		}
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (iter);
#line 611 "collection.c"
	}
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = changed;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 617 "collection.c"
}


gboolean gee_collection_retain_all (GeeCollection* self, GeeCollection* collection) {
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 129 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->retain_all (self, collection);
#line 626 "collection.c"
}


/**
 * Returns an array containing all of items from this collection.
 *
 * @return an array containing all of items from this collection
 */
static gpointer* gee_collection_real_to_array (GeeCollection* self, int* result_length1) {
	gpointer* result = NULL;
	GType t;
	GType _tmp0_;
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	t = GEE_COLLECTION_GET_INTERFACE (self)->get_g_type (self);
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = t;
#line 148 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (_tmp0_ == G_TYPE_BOOLEAN) {
#line 645 "collection.c"
		gint _tmp1_ = 0;
		gboolean* _tmp2_ = NULL;
		gpointer* _tmp3_;
		gint _tmp3__length1;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp2_ = gee_collection_to_bool_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp1_);
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp3_ = (gpointer*) _tmp2_;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp3__length1 = _tmp1_;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		if (result_length1) {
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			*result_length1 = _tmp3__length1;
#line 660 "collection.c"
		}
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		result = _tmp3_;
#line 149 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		return result;
#line 666 "collection.c"
	} else {
		GType _tmp4_;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = t;
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		if (_tmp4_ == G_TYPE_CHAR) {
#line 673 "collection.c"
			gint _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
			gpointer* _tmp7_;
			gint _tmp7__length1;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = gee_collection_to_char_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp5_);
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = (gpointer*) _tmp6_;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7__length1 = _tmp5_;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (result_length1) {
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				*result_length1 = _tmp7__length1;
#line 688 "collection.c"
			}
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			result = _tmp7_;
#line 151 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			return result;
#line 694 "collection.c"
		} else {
			GType _tmp8_;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = t;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (_tmp8_ == G_TYPE_UCHAR) {
#line 701 "collection.c"
				gint _tmp9_ = 0;
				guchar* _tmp10_ = NULL;
				gpointer* _tmp11_;
				gint _tmp11__length1;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp10_ = gee_collection_to_uchar_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp9_);
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp11_ = (gpointer*) _tmp10_;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp11__length1 = _tmp9_;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (result_length1) {
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					*result_length1 = _tmp11__length1;
#line 716 "collection.c"
				}
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				result = _tmp11_;
#line 153 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				return result;
#line 722 "collection.c"
			} else {
				GType _tmp12_;
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				_tmp12_ = t;
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				if (_tmp12_ == G_TYPE_INT) {
#line 729 "collection.c"
					gint _tmp13_ = 0;
					gint* _tmp14_ = NULL;
					gpointer* _tmp15_;
					gint _tmp15__length1;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp14_ = gee_collection_to_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp13_);
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp15_ = (gpointer*) _tmp14_;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp15__length1 = _tmp13_;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					if (result_length1) {
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						*result_length1 = _tmp15__length1;
#line 744 "collection.c"
					}
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					result = _tmp15_;
#line 155 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					return result;
#line 750 "collection.c"
				} else {
					GType _tmp16_;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					_tmp16_ = t;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
					if (_tmp16_ == G_TYPE_UINT) {
#line 757 "collection.c"
						gint _tmp17_ = 0;
						guint* _tmp18_ = NULL;
						gpointer* _tmp19_;
						gint _tmp19__length1;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						_tmp18_ = gee_collection_to_uint_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp17_);
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						_tmp19_ = (gpointer*) _tmp18_;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						_tmp19__length1 = _tmp17_;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						if (result_length1) {
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							*result_length1 = _tmp19__length1;
#line 772 "collection.c"
						}
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						result = _tmp19_;
#line 157 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						return result;
#line 778 "collection.c"
					} else {
						GType _tmp20_;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						_tmp20_ = t;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
						if (_tmp20_ == G_TYPE_INT64) {
#line 785 "collection.c"
							gint _tmp21_ = 0;
							gint64* _tmp22_ = NULL;
							gpointer* _tmp23_;
							gint _tmp23__length1;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							_tmp22_ = gee_collection_to_int64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp21_);
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							_tmp23_ = (gpointer*) _tmp22_;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							_tmp23__length1 = _tmp21_;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							if (result_length1) {
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								*result_length1 = _tmp23__length1;
#line 800 "collection.c"
							}
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							result = _tmp23_;
#line 159 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							return result;
#line 806 "collection.c"
						} else {
							GType _tmp24_;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							_tmp24_ = t;
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
							if (_tmp24_ == G_TYPE_UINT64) {
#line 813 "collection.c"
								gint _tmp25_ = 0;
								guint64* _tmp26_ = NULL;
								gpointer* _tmp27_;
								gint _tmp27__length1;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								_tmp26_ = gee_collection_to_uint64_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp25_);
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								_tmp27_ = (gpointer*) _tmp26_;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								_tmp27__length1 = _tmp25_;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								if (result_length1) {
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									*result_length1 = _tmp27__length1;
#line 828 "collection.c"
								}
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								result = _tmp27_;
#line 161 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								return result;
#line 834 "collection.c"
							} else {
								GType _tmp28_;
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								_tmp28_ = t;
#line 162 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
								if (_tmp28_ == G_TYPE_LONG) {
#line 841 "collection.c"
									gint _tmp29_ = 0;
									glong* _tmp30_ = NULL;
									gpointer* _tmp31_;
									gint _tmp31__length1;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									_tmp30_ = gee_collection_to_long_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp29_);
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									_tmp31_ = (gpointer*) _tmp30_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									_tmp31__length1 = _tmp29_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									if (result_length1) {
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										*result_length1 = _tmp31__length1;
#line 856 "collection.c"
									}
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									result = _tmp31_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									return result;
#line 862 "collection.c"
								} else {
									GType _tmp32_;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									_tmp32_ = t;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
									if (_tmp32_ == G_TYPE_ULONG) {
#line 869 "collection.c"
										gint _tmp33_ = 0;
										gulong* _tmp34_ = NULL;
										gpointer* _tmp35_;
										gint _tmp35__length1;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										_tmp34_ = gee_collection_to_ulong_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp33_);
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										_tmp35_ = (gpointer*) _tmp34_;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										_tmp35__length1 = _tmp33_;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										if (result_length1) {
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											*result_length1 = _tmp35__length1;
#line 884 "collection.c"
										}
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										result = _tmp35_;
#line 165 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										return result;
#line 890 "collection.c"
									} else {
										GType _tmp36_;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										_tmp36_ = t;
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
										if (_tmp36_ == G_TYPE_FLOAT) {
#line 897 "collection.c"
											gint _tmp37_ = 0;
											gfloat** _tmp38_ = NULL;
											gpointer* _tmp39_;
											gint _tmp39__length1;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											_tmp38_ = gee_collection_to_float_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp37_);
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											_tmp39_ = (gpointer*) _tmp38_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											_tmp39__length1 = _tmp37_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											if (result_length1) {
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												*result_length1 = _tmp39__length1;
#line 912 "collection.c"
											}
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											result = _tmp39_;
#line 167 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											return result;
#line 918 "collection.c"
										} else {
											GType _tmp40_;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											_tmp40_ = t;
#line 168 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
											if (_tmp40_ == G_TYPE_DOUBLE) {
#line 925 "collection.c"
												gint _tmp41_ = 0;
												gdouble** _tmp42_ = NULL;
												gpointer* _tmp43_;
												gint _tmp43__length1;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp42_ = gee_collection_to_double_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp41_);
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp43_ = (gpointer*) _tmp42_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp43__length1 = _tmp41_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												if (result_length1) {
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													*result_length1 = _tmp43__length1;
#line 940 "collection.c"
												}
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												result = _tmp43_;
#line 169 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												return result;
#line 946 "collection.c"
											} else {
												gint _tmp44_;
												gint _tmp45_;
												gpointer* _tmp46_ = NULL;
												gpointer* array;
												gint array_length1;
												gint _array_size_;
												gint index;
												gpointer* _tmp57_;
												gint _tmp57__length1;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp44_ = gee_collection_get_size (self);
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp45_ = _tmp44_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp46_ = g_new0 (gpointer, _tmp45_);
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												array = _tmp46_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												array_length1 = _tmp45_;
#line 171 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_array_size_ = array_length1;
#line 172 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												index = 0;
#line 971 "collection.c"
												{
													GeeIterator* _tmp47_ = NULL;
													GeeIterator* _element_it;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													_tmp47_ = gee_iterable_iterator ((GeeIterable*) self);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													_element_it = _tmp47_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													while (TRUE) {
#line 981 "collection.c"
														GeeIterator* _tmp48_;
														gboolean _tmp49_ = FALSE;
														GeeIterator* _tmp50_;
														gpointer _tmp51_ = NULL;
														gpointer element;
														gpointer* _tmp52_;
														gint _tmp52__length1;
														gint _tmp53_;
														gconstpointer _tmp54_;
														gpointer _tmp55_;
														gpointer _tmp56_;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp48_ = _element_it;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp49_ = gee_iterator_next (_tmp48_);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														if (!_tmp49_) {
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
															break;
#line 1001 "collection.c"
														}
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp50_ = _element_it;
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp51_ = gee_iterator_get (_tmp50_);
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														element = _tmp51_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp52_ = array;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp52__length1 = array_length1;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp53_ = index;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														index = _tmp53_ + 1;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp54_ = element;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp55_ = ((_tmp54_ != NULL) && (GEE_COLLECTION_GET_INTERFACE (self)->get_g_dup_func (self) != NULL)) ? GEE_COLLECTION_GET_INTERFACE (self)->get_g_dup_func (self) ((gpointer) _tmp54_) : ((gpointer) _tmp54_);
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														((_tmp52_[_tmp53_] == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (_tmp52_[_tmp53_] = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (_tmp52_[_tmp53_]), NULL));
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp52_[_tmp53_] = _tmp55_;
#line 174 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														_tmp56_ = _tmp52_[_tmp53_];
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
														((element == NULL) || (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (element = (GEE_COLLECTION_GET_INTERFACE (self)->get_g_destroy_func (self) (element), NULL));
#line 1029 "collection.c"
													}
#line 173 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													_g_object_unref0 (_element_it);
#line 1033 "collection.c"
												}
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp57_ = array;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												_tmp57__length1 = array_length1;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												if (result_length1) {
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
													*result_length1 = _tmp57__length1;
#line 1043 "collection.c"
												}
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												result = _tmp57_;
#line 176 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
												return result;
#line 1049 "collection.c"
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1) {
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->to_array (self, result_length1);
#line 1069 "collection.c"
}


static gboolean* gee_collection_to_bool_array (GeeCollection* coll, int* result_length1) {
	gboolean* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean* _tmp3_ = NULL;
	gboolean* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gboolean* _tmp14_;
	gint _tmp14__length1;
#line 180 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gboolean, _tmp2_);
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 181 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 182 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1103 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1116 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gboolean element;
			gboolean* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1135 "collection.c"
			}
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (gboolean) ((gintptr) _tmp9_);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1157 "collection.c"
		}
#line 183 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1161 "collection.c"
	}
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1171 "collection.c"
	}
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1177 "collection.c"
}


static gchar* gee_collection_to_char_array (GeeCollection* coll, int* result_length1) {
	gchar* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gchar* _tmp14_;
	gint _tmp14__length1;
#line 189 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gchar, _tmp2_);
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 190 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 191 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1211 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1224 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar element;
			gchar* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gchar _tmp12_;
			gchar _tmp13_;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1243 "collection.c"
			}
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (gchar) ((gintptr) _tmp9_);
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 193 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1265 "collection.c"
		}
#line 192 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1269 "collection.c"
	}
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1279 "collection.c"
	}
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 195 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1285 "collection.c"
}


static guchar* gee_collection_to_uchar_array (GeeCollection* coll, int* result_length1) {
	guchar* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guchar* _tmp3_ = NULL;
	guchar* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	guchar* _tmp14_;
	gint _tmp14__length1;
#line 198 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (guchar, _tmp2_);
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 199 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 200 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1319 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1332 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			guchar element;
			guchar* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			guchar _tmp12_;
			guchar _tmp13_;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1351 "collection.c"
			}
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (guchar) ((guintptr) _tmp9_);
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 202 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1373 "collection.c"
		}
#line 201 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1377 "collection.c"
	}
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1387 "collection.c"
	}
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 204 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1393 "collection.c"
}


static gint* gee_collection_to_int_array (GeeCollection* coll, int* result_length1) {
	gint* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint* _tmp3_ = NULL;
	gint* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gint* _tmp14_;
	gint _tmp14__length1;
#line 207 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gint, _tmp2_);
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1427 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1440 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gint element;
			gint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1459 "collection.c"
			}
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (gint) ((gintptr) _tmp9_);
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 211 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1481 "collection.c"
		}
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1485 "collection.c"
	}
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1495 "collection.c"
	}
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1501 "collection.c"
}


static guint* gee_collection_to_uint_array (GeeCollection* coll, int* result_length1) {
	guint* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint* _tmp3_ = NULL;
	guint* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	guint* _tmp14_;
	gint _tmp14__length1;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (guint, _tmp2_);
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1535 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1548 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			guint element;
			guint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			guint _tmp12_;
			guint _tmp13_;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1567 "collection.c"
			}
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (guint) ((guintptr) _tmp9_);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1589 "collection.c"
		}
#line 219 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1593 "collection.c"
	}
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1603 "collection.c"
	}
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1609 "collection.c"
}


static gint64* gee_collection_to_int64_array (GeeCollection* coll, int* result_length1) {
	gint64* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint64* _tmp3_ = NULL;
	gint64* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gint64* _tmp16_;
	gint _tmp16__length1;
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gint64, _tmp2_);
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 226 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 227 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1643 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1656 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gint64* _tmp10_;
			gint64 _tmp11_;
			gint64 element;
			gint64* _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			gint64 _tmp14_;
			gint64 _tmp15_;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1677 "collection.c"
			}
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = (gint64*) _tmp9_;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = *_tmp10_;
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp10_);
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = _tmp11_;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = array;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12__length1 = array_length1;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = index;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp13_ + 1;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp14_ = element;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_[_tmp13_] = _tmp14_;
#line 229 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp15_ = _tmp12_[_tmp13_];
#line 1705 "collection.c"
		}
#line 228 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1709 "collection.c"
	}
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp16_ = array;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp16__length1 = array_length1;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp16__length1;
#line 1719 "collection.c"
	}
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp16_;
#line 231 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1725 "collection.c"
}


static guint64* gee_collection_to_uint64_array (GeeCollection* coll, int* result_length1) {
	guint64* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint64* _tmp3_ = NULL;
	guint64* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	guint64* _tmp16_;
	gint _tmp16__length1;
#line 234 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (guint64, _tmp2_);
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 235 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 236 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1759 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1772 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			guint64* _tmp10_;
			guint64 _tmp11_;
			guint64 element;
			guint64* _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			guint64 _tmp14_;
			guint64 _tmp15_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1793 "collection.c"
			}
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = (guint64*) _tmp9_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = *_tmp10_;
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp10_);
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = _tmp11_;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = array;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12__length1 = array_length1;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = index;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp13_ + 1;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp14_ = element;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_[_tmp13_] = _tmp14_;
#line 238 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp15_ = _tmp12_[_tmp13_];
#line 1821 "collection.c"
		}
#line 237 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1825 "collection.c"
	}
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp16_ = array;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp16__length1 = array_length1;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp16__length1;
#line 1835 "collection.c"
	}
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp16_;
#line 240 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1841 "collection.c"
}


static glong* gee_collection_to_long_array (GeeCollection* coll, int* result_length1) {
	glong* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	glong* _tmp3_ = NULL;
	glong* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	glong* _tmp14_;
	gint _tmp14__length1;
#line 243 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (glong, _tmp2_);
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 244 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 245 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1875 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1888 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			glong element;
			glong* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			glong _tmp12_;
			glong _tmp13_;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 1907 "collection.c"
			}
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (glong) ((gintptr) _tmp9_);
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 247 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 1929 "collection.c"
		}
#line 246 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 1933 "collection.c"
	}
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 1943 "collection.c"
	}
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 1949 "collection.c"
}


static gulong* gee_collection_to_ulong_array (GeeCollection* coll, int* result_length1) {
	gulong* result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gulong* _tmp3_ = NULL;
	gulong* array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gulong* _tmp14_;
	gint _tmp14__length1;
#line 252 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gulong, _tmp2_);
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 1983 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 1996 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gulong element;
			gulong* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gulong _tmp12_;
			gulong _tmp13_;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 2015 "collection.c"
			}
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = (gulong) ((guintptr) _tmp9_);
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = array;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10__length1 = array_length1;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = index;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp11_ + 1;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = element;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_[_tmp11_] = _tmp12_;
#line 256 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = _tmp10_[_tmp11_];
#line 2037 "collection.c"
		}
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 2041 "collection.c"
	}
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14_ = array;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp14__length1 = array_length1;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp14__length1;
#line 2051 "collection.c"
	}
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp14_;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2057 "collection.c"
}


static gfloat* _float_dup (gfloat* self) {
	gfloat* dup;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	dup = g_new0 (gfloat, 1);
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	memcpy (dup, self, sizeof (gfloat));
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return dup;
#line 2069 "collection.c"
}


static gpointer __float_dup0 (gpointer self) {
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return self ? _float_dup (self) : NULL;
#line 2076 "collection.c"
}


static gfloat** gee_collection_to_float_array (GeeCollection* coll, int* result_length1) {
	gfloat** result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gfloat** _tmp3_ = NULL;
	gfloat** array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gfloat** _tmp17_;
	gint _tmp17__length1;
#line 261 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gfloat*, _tmp2_);
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 2110 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 2123 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gfloat* _tmp10_;
			gfloat _tmp11_;
			gfloat element;
			gfloat** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			gfloat _tmp14_;
			gfloat* _tmp15_;
			gfloat* _tmp16_;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 2145 "collection.c"
			}
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = (gfloat*) _tmp9_;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = *_tmp10_;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp10_);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = _tmp11_;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = array;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12__length1 = array_length1;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = index;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp13_ + 1;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp14_ = element;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp15_ = __float_dup0 (&_tmp14_);
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp12_[_tmp13_]);
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_[_tmp13_] = _tmp15_;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp16_ = _tmp12_[_tmp13_];
#line 2177 "collection.c"
		}
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 2181 "collection.c"
	}
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp17_ = array;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp17__length1 = array_length1;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp17__length1;
#line 2191 "collection.c"
	}
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp17_;
#line 267 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2197 "collection.c"
}


static gdouble* _double_dup (gdouble* self) {
	gdouble* dup;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	dup = g_new0 (gdouble, 1);
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	memcpy (dup, self, sizeof (gdouble));
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return dup;
#line 2209 "collection.c"
}


static gpointer __double_dup0 (gpointer self) {
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return self ? _double_dup (self) : NULL;
#line 2216 "collection.c"
}


static gdouble** gee_collection_to_double_array (GeeCollection* coll, int* result_length1) {
	gdouble** result = NULL;
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble** _tmp3_ = NULL;
	gdouble** array;
	gint array_length1;
	gint _array_size_;
	gint index;
	gdouble** _tmp17_;
	gint _tmp17__length1;
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (coll != NULL, NULL);
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = coll;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = gee_collection_get_size (_tmp0_);
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = _tmp1_;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = g_new0 (gdouble*, _tmp2_);
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array = _tmp3_;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	array_length1 = _tmp2_;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_array_size_ = array_length1;
#line 272 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	index = 0;
#line 2250 "collection.c"
	{
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _element_it;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp4_ = coll;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_element_it = _tmp5_;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		while (TRUE) {
#line 2263 "collection.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			gdouble* _tmp10_;
			gdouble _tmp11_;
			gdouble element;
			gdouble** _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			gdouble _tmp14_;
			gdouble* _tmp15_;
			gdouble* _tmp16_;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp6_ = _element_it;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			if (!_tmp7_) {
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
				break;
#line 2285 "collection.c"
			}
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp8_ = _element_it;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp9_ = gee_iterator_get (_tmp8_);
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp10_ = (gdouble*) _tmp9_;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp11_ = *_tmp10_;
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp10_);
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			element = _tmp11_;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_ = array;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12__length1 = array_length1;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp13_ = index;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			index = _tmp13_ + 1;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp14_ = element;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp15_ = __double_dup0 (&_tmp14_);
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_g_free0 (_tmp12_[_tmp13_]);
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp12_[_tmp13_] = _tmp15_;
#line 274 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
			_tmp16_ = _tmp12_[_tmp13_];
#line 2317 "collection.c"
		}
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		_g_object_unref0 (_element_it);
#line 2321 "collection.c"
	}
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp17_ = array;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp17__length1 = array_length1;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (result_length1) {
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		*result_length1 = _tmp17__length1;
#line 2331 "collection.c"
	}
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp17_;
#line 276 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2337 "collection.c"
}


/**
 * Returns an immutable empty collection.
 *
 * @return an immutable empty collection
 */
GeeCollection* gee_collection_empty (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeCollection* result = NULL;
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeCollection* _tmp4_;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = gee_hash_set_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, NULL, NULL, NULL, NULL, NULL, NULL);
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = _tmp0_;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp2_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp1_);
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp3_ = _tmp2_;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp4_ = (GeeCollection*) _tmp3_;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_g_object_unref0 (_tmp1_);
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp4_;
#line 290 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2369 "collection.c"
}


gint gee_collection_get_size (GeeCollection* self) {
#line 31 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 31 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->get_size (self);
#line 2378 "collection.c"
}


gboolean gee_collection_get_is_empty (GeeCollection* self) {
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->get_is_empty (self);
#line 2387 "collection.c"
}


static gboolean gee_collection_real_get_is_empty (GeeCollection* base) {
	gboolean result;
	GeeCollection* self;
	gint _tmp0_;
	gint _tmp1_;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	self = base;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp0_ = gee_collection_get_size (self);
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	_tmp1_ = _tmp0_;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	result = _tmp1_ == 0;
#line 36 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return result;
#line 2406 "collection.c"
}


gboolean gee_collection_get_read_only (GeeCollection* self) {
#line 42 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 42 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->get_read_only (self);
#line 2415 "collection.c"
}


GeeCollection* gee_collection_get_read_only_view (GeeCollection* self) {
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 282 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	return GEE_COLLECTION_GET_INTERFACE (self)->get_read_only_view (self);
#line 2424 "collection.c"
}


static void gee_collection_base_init (GeeCollectionIface * iface) {
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	static gboolean initialized = FALSE;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
	if (!initialized) {
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		initialized = TRUE;
#line 2435 "collection.c"
		/**
		 * The number of items in this collection.
		 */
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		g_object_interface_install_property (iface, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2441 "collection.c"
		/**
		 * Specifies whether this collection can change - i.e. wheather {@link add},
		 * {@link remove} etc. are legal operations.
		 */
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2448 "collection.c"
		/**
		 * The read-only view of this collection.
		 */
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->add_all = gee_collection_real_add_all;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->contains_all = gee_collection_real_contains_all;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->remove_all = gee_collection_real_remove_all;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->retain_all = gee_collection_real_retain_all;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->to_array = gee_collection_real_to_array;
#line 27 "/home/mpiechotka/Projects/contributions/libgee/gee/collection.vala"
		iface->get_is_empty = gee_collection_real_get_is_empty;
#line 2466 "collection.c"
	}
}


/**
 * A generic collection of objects.
 */
GType gee_collection_get_type (void) {
	static volatile gsize gee_collection_type_id__volatile = 0;
	if (g_once_init_enter (&gee_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeCollectionIface), (GBaseInitFunc) gee_collection_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_collection_type_id;
		gee_collection_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeCollection", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_collection_type_id, GEE_TYPE_ITERABLE);
		g_once_init_leave (&gee_collection_type_id__volatile, gee_collection_type_id);
	}
	return gee_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



