/* role-details.c generated by valac 0.13.4, the Vala compiler
 * generated from role-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>


#define FOLKS_TYPE_ROLE (folks_role_get_type ())
#define FOLKS_ROLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE, FolksRole))
#define FOLKS_ROLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ROLE, FolksRoleClass))
#define FOLKS_IS_ROLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE))
#define FOLKS_IS_ROLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ROLE))
#define FOLKS_ROLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ROLE, FolksRoleClass))

typedef struct _FolksRole FolksRole;
typedef struct _FolksRoleClass FolksRoleClass;
typedef struct _FolksRolePrivate FolksRolePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;
typedef struct _FolksAbstractFieldDetailsPrivate FolksAbstractFieldDetailsPrivate;

#define FOLKS_TYPE_ROLE_FIELD_DETAILS (folks_role_field_details_get_type ())
#define FOLKS_ROLE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetails))
#define FOLKS_ROLE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetailsClass))
#define FOLKS_IS_ROLE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE_FIELD_DETAILS))
#define FOLKS_IS_ROLE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ROLE_FIELD_DETAILS))
#define FOLKS_ROLE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ROLE_FIELD_DETAILS, FolksRoleFieldDetailsClass))

typedef struct _FolksRoleFieldDetails FolksRoleFieldDetails;
typedef struct _FolksRoleFieldDetailsClass FolksRoleFieldDetailsClass;
typedef struct _FolksRoleFieldDetailsPrivate FolksRoleFieldDetailsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_TYPE_ROLE_DETAILS (folks_role_details_get_type ())
#define FOLKS_ROLE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetails))
#define FOLKS_IS_ROLE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ROLE_DETAILS))
#define FOLKS_ROLE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ROLE_DETAILS, FolksRoleDetailsIface))

typedef struct _FolksRoleDetails FolksRoleDetails;
typedef struct _FolksRoleDetailsIface FolksRoleDetailsIface;
typedef struct _FolksRoleDetailsChangeRolesData FolksRoleDetailsChangeRolesData;

struct _FolksRole {
	GObject parent_instance;
	FolksRolePrivate * priv;
};

struct _FolksRoleClass {
	GObjectClass parent_class;
};

struct _FolksRolePrivate {
	gchar* _organisation_name;
	gchar* _title;
	gchar* _role;
	gchar* _uid;
};

struct _FolksAbstractFieldDetails {
	GObject parent_instance;
	FolksAbstractFieldDetailsPrivate * priv;
};

struct _FolksAbstractFieldDetailsClass {
	GObjectClass parent_class;
	gboolean (*equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	guint (*hash) (FolksAbstractFieldDetails* self);
	gconstpointer (*get_value) (FolksAbstractFieldDetails* self);
	void (*set_value) (FolksAbstractFieldDetails* self, gconstpointer value);
	GeeMultiMap* (*get_parameters) (FolksAbstractFieldDetails* self);
	void (*set_parameters) (FolksAbstractFieldDetails* self, GeeMultiMap* value);
};

struct _FolksRoleFieldDetails {
	FolksAbstractFieldDetails parent_instance;
	FolksRoleFieldDetailsPrivate * priv;
};

struct _FolksRoleFieldDetailsClass {
	FolksAbstractFieldDetailsClass parent_class;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksRoleDetailsIface {
	GTypeInterface parent_iface;
	void (*change_roles) (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_roles_finish) (FolksRoleDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_roles) (FolksRoleDetails* self);
	void (*set_roles) (FolksRoleDetails* self, GeeSet* value);
};

struct _FolksRoleDetailsChangeRolesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksRoleDetails* self;
	GeeSet* roles;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};


static gpointer folks_role_parent_class = NULL;
static gpointer folks_role_field_details_parent_class = NULL;

GType folks_role_get_type (void) G_GNUC_CONST;
#define FOLKS_ROLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_ROLE, FolksRolePrivate))
enum  {
	FOLKS_ROLE_DUMMY_PROPERTY,
	FOLKS_ROLE_ORGANISATION_NAME,
	FOLKS_ROLE_TITLE,
	FOLKS_ROLE_ROLE,
	FOLKS_ROLE_UID
};
FolksRole* folks_role_new (const gchar* title, const gchar* organisation_name, const gchar* uid);
FolksRole* folks_role_construct (GType object_type, const gchar* title, const gchar* organisation_name, const gchar* uid);
gboolean folks_role_equal (FolksRole* a, FolksRole* b);
const gchar* folks_role_get_title (FolksRole* self);
const gchar* folks_role_get_role (FolksRole* self);
const gchar* folks_role_get_organisation_name (FolksRole* self);
guint folks_role_hash (FolksRole* r);
gchar* folks_role_to_string (FolksRole* self);
void folks_role_set_organisation_name (FolksRole* self, const gchar* value);
void folks_role_set_title (FolksRole* self, const gchar* value);
void folks_role_set_role (FolksRole* self, const gchar* value);
const gchar* folks_role_get_uid (FolksRole* self);
void folks_role_set_uid (FolksRole* self, const gchar* value);
static void folks_role_finalize (GObject* obj);
static void _vala_folks_role_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_role_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_role_field_details_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_ROLE_FIELD_DETAILS_DUMMY_PROPERTY
};
FolksRoleFieldDetails* folks_role_field_details_new (FolksRole* value, GeeMultiMap* parameters);
FolksRoleFieldDetails* folks_role_field_details_construct (GType object_type, FolksRole* value, GeeMultiMap* parameters);
FolksAbstractFieldDetails* folks_abstract_field_details_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func);
void folks_abstract_field_details_set_value (FolksAbstractFieldDetails* self, gconstpointer value);
void folks_abstract_field_details_set_parameters (FolksAbstractFieldDetails* self, GeeMultiMap* value);
static gboolean folks_role_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
static guint folks_role_field_details_real_hash (FolksAbstractFieldDetails* base);
GQuark folks_property_error_quark (void);
GType folks_role_details_get_type (void) G_GNUC_CONST;
static void folks_role_details_real_change_roles_data_free (gpointer _data);
static void folks_role_details_real_change_roles (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_role_details_change_roles (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_role_details_change_roles_finish (FolksRoleDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_role_details_real_change_roles_co (FolksRoleDetailsChangeRolesData* _data_);
GeeSet* folks_role_details_get_roles (FolksRoleDetails* self);
void folks_role_details_set_roles (FolksRoleDetails* self, GeeSet* value);


/**
   * Default constructor.
   *
   * @param title title of the position
   * @param organisation_name organisation where the role is hold
   * @param uid a Unique ID associated to this Role
   * @return a new Role
   *
   * @since 0.4.0
   */
FolksRole* folks_role_construct (GType object_type, const gchar* title, const gchar* organisation_name, const gchar* uid) {
	FolksRole * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	_tmp0_ = title;
	if (_tmp0_ == NULL) {
		title = "";
	}
	_tmp1_ = organisation_name;
	if (_tmp1_ == NULL) {
		organisation_name = "";
	}
	_tmp2_ = uid;
	if (_tmp2_ == NULL) {
		uid = "";
	}
	_tmp3_ = uid;
	_tmp4_ = title;
	_tmp5_ = organisation_name;
	self = (FolksRole*) g_object_new (object_type, "uid", _tmp3_, "title", _tmp4_, "organisation-name", _tmp5_, NULL);
	return self;
}


FolksRole* folks_role_new (const gchar* title, const gchar* organisation_name, const gchar* uid) {
	return folks_role_construct (FOLKS_TYPE_ROLE, title, organisation_name, uid);
}


/**
   * Compare if two roles are equal. Roles are equal if their titles and
   * organisation names are equal.
   *
   * @param a a role to compare
   * @param b another role to compare
   * @return `true` if the roles are equal, `false` otherwise
   */
gboolean folks_role_equal (FolksRole* a, FolksRole* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	FolksRole* _tmp2_;
	const gchar* _tmp3_;
	FolksRole* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp10_;
	gboolean _tmp15_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp2_ = a;
	_tmp3_ = _tmp2_->priv->_title;
	_tmp4_ = b;
	_tmp5_ = _tmp4_->priv->_title;
	if (g_strcmp0 (_tmp3_, _tmp5_) == 0) {
		FolksRole* _tmp6_;
		const gchar* _tmp7_;
		FolksRole* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = a;
		_tmp7_ = _tmp6_->priv->_role;
		_tmp8_ = b;
		_tmp9_ = _tmp8_->priv->_role;
		_tmp1_ = g_strcmp0 (_tmp7_, _tmp9_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		FolksRole* _tmp11_;
		const gchar* _tmp12_;
		FolksRole* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = a;
		_tmp12_ = _tmp11_->priv->_organisation_name;
		_tmp13_ = b;
		_tmp14_ = _tmp13_->priv->_organisation_name;
		_tmp0_ = g_strcmp0 (_tmp12_, _tmp14_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp15_ = _tmp0_;
	result = _tmp15_;
	return result;
}


/**
   * Hash function for the class. Suitable for use as a hash table key.
   *
   * @param r a role to hash
   * @return hash value for the role instance
   */
guint folks_role_hash (FolksRole* r) {
	guint result = 0U;
	FolksRole* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_ = 0U;
	FolksRole* _tmp3_;
	const gchar* _tmp4_;
	guint _tmp5_ = 0U;
	FolksRole* _tmp6_;
	const gchar* _tmp7_;
	guint _tmp8_ = 0U;
	g_return_val_if_fail (r != NULL, 0U);
	_tmp0_ = r;
	_tmp1_ = _tmp0_->priv->_organisation_name;
	_tmp2_ = g_str_hash (_tmp1_);
	_tmp3_ = r;
	_tmp4_ = _tmp3_->priv->_title;
	_tmp5_ = g_str_hash (_tmp4_);
	_tmp6_ = r;
	_tmp7_ = _tmp6_->priv->_role;
	_tmp8_ = g_str_hash (_tmp7_);
	result = (_tmp2_ ^ _tmp5_) ^ _tmp8_;
	return result;
}


/**
   * Formatted version of this role.
   *
   * @since 0.4.0
   */
gchar* folks_role_to_string (FolksRole* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* str;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _ ("Title: %s, Organisation: %s, Role: %s");
	_tmp1_ = g_strdup (_tmp0_);
	str = _tmp1_;
	_tmp2_ = self->priv->_title;
	_tmp3_ = self->priv->_organisation_name;
	_tmp4_ = self->priv->_role;
	_tmp5_ = g_strdup_printf (str, _tmp2_, _tmp3_, _tmp4_);
	result = _tmp5_;
	_g_free0 (str);
	return result;
}


const gchar* folks_role_get_organisation_name (FolksRole* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_organisation_name;
	result = _tmp0_;
	return result;
}


void folks_role_set_organisation_name (FolksRole* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_organisation_name);
	self->priv->_organisation_name = _tmp1_;
	g_object_notify ((GObject *) self, "organisation-name");
}


const gchar* folks_role_get_title (FolksRole* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


void folks_role_set_title (FolksRole* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_title);
	self->priv->_title = _tmp1_;
	g_object_notify ((GObject *) self, "title");
}


const gchar* folks_role_get_role (FolksRole* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_role;
	result = _tmp0_;
	return result;
}


void folks_role_set_role (FolksRole* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_role);
	self->priv->_role = _tmp1_;
	g_object_notify ((GObject *) self, "role");
}


const gchar* folks_role_get_uid (FolksRole* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uid;
	result = _tmp0_;
	return result;
}


void folks_role_set_uid (FolksRole* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uid);
	self->priv->_uid = _tmp1_;
	g_object_notify ((GObject *) self, "uid");
}


static void folks_role_class_init (FolksRoleClass * klass) {
	folks_role_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksRolePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_role_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_role_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_role_finalize;
	/**
	   * The name of the organisation in which the role is held.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_ORGANISATION_NAME, g_param_spec_string ("organisation-name", "organisation-name", "organisation-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The title of the position held.
	   *
	   * For example: “Director, Ministry of Silly Walks”
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_TITLE, g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The role of the position.
	   *
	   * For example: “Programmer”
	   *
	   * @since 0.6.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_ROLE, g_param_spec_string ("role", "role", "role", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The UID that distinguishes this role.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_ROLE_UID, g_param_spec_string ("uid", "uid", "uid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_role_instance_init (FolksRole * self) {
	self->priv = FOLKS_ROLE_GET_PRIVATE (self);
}


static void folks_role_finalize (GObject* obj) {
	FolksRole * self;
	self = FOLKS_ROLE (obj);
	_g_free0 (self->priv->_organisation_name);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_role);
	_g_free0 (self->priv->_uid);
	G_OBJECT_CLASS (folks_role_parent_class)->finalize (obj);
}


/**
 * This interface represents the role a {@link Persona} and {@link Individual}
 * have in a given Organisation.
 *
 * @since 0.4.0
 */
GType folks_role_get_type (void) {
	static volatile gsize folks_role_type_id__volatile = 0;
	if (g_once_init_enter (&folks_role_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksRoleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_role_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksRole), 0, (GInstanceInitFunc) folks_role_instance_init, NULL };
		GType folks_role_type_id;
		folks_role_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksRole", &g_define_type_info, 0);
		g_once_init_leave (&folks_role_type_id__volatile, folks_role_type_id);
	}
	return folks_role_type_id__volatile;
}


static void _vala_folks_role_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksRole * self;
	self = FOLKS_ROLE (object);
	switch (property_id) {
		case FOLKS_ROLE_ORGANISATION_NAME:
		g_value_set_string (value, folks_role_get_organisation_name (self));
		break;
		case FOLKS_ROLE_TITLE:
		g_value_set_string (value, folks_role_get_title (self));
		break;
		case FOLKS_ROLE_ROLE:
		g_value_set_string (value, folks_role_get_role (self));
		break;
		case FOLKS_ROLE_UID:
		g_value_set_string (value, folks_role_get_uid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_role_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksRole * self;
	self = FOLKS_ROLE (object);
	switch (property_id) {
		case FOLKS_ROLE_ORGANISATION_NAME:
		folks_role_set_organisation_name (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_TITLE:
		folks_role_set_title (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_ROLE:
		folks_role_set_role (self, g_value_get_string (value));
		break;
		case FOLKS_ROLE_UID:
		folks_role_set_uid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


/**
   * Create a new RoleFieldDetails.
   *
   * @param value the {@link Role} of the field
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A `null` value is equivalent to an
   * empty map of parameters.
   *
   * @return a new RoleFieldDetails
   *
   * @since 0.6.0
   */
FolksRoleFieldDetails* folks_role_field_details_construct (GType object_type, FolksRole* value, GeeMultiMap* parameters) {
	FolksRoleFieldDetails * self = NULL;
	FolksRole* _tmp0_;
	GeeMultiMap* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	self = (FolksRoleFieldDetails*) folks_abstract_field_details_construct (object_type, FOLKS_TYPE_ROLE, (GBoxedCopyFunc) g_object_ref, g_object_unref);
	_tmp0_ = value;
	folks_abstract_field_details_set_value ((FolksAbstractFieldDetails*) self, _tmp0_);
	_tmp1_ = parameters;
	if (_tmp1_ != NULL) {
		GeeMultiMap* _tmp2_;
		_tmp2_ = parameters;
		folks_abstract_field_details_set_parameters ((FolksAbstractFieldDetails*) self, _tmp2_);
	}
	return self;
}


FolksRoleFieldDetails* folks_role_field_details_new (FolksRole* value, GeeMultiMap* parameters) {
	return folks_role_field_details_construct (FOLKS_TYPE_ROLE_FIELD_DETAILS, value, parameters);
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0 
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean folks_role_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that) {
	FolksRoleFieldDetails * self;
	gboolean result = FALSE;
	FolksAbstractFieldDetails* _tmp0_;
	FolksRoleFieldDetails* _tmp1_;
	FolksRoleFieldDetails* that_fd;
	FolksRoleFieldDetails* _tmp2_;
	gconstpointer _tmp3_;
	FolksRole* _tmp4_;
	FolksRoleFieldDetails* _tmp5_;
	gconstpointer _tmp6_;
	FolksRole* _tmp7_;
	gboolean _tmp8_ = FALSE;
	self = (FolksRoleFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	_tmp1_ = _g_object_ref0 (FOLKS_IS_ROLE_FIELD_DETAILS (_tmp0_) ? ((FolksRoleFieldDetails*) _tmp0_) : NULL);
	that_fd = _tmp1_;
	_tmp2_ = that_fd;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (that_fd);
		return result;
	}
	_tmp3_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = that_fd;
	_tmp6_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = folks_role_equal ((FolksRole*) _tmp4_, (FolksRole*) _tmp7_);
	result = _tmp8_;
	_g_object_unref0 (that_fd);
	return result;
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint folks_role_field_details_real_hash (FolksAbstractFieldDetails* base) {
	FolksRoleFieldDetails * self;
	guint result = 0U;
	GHashFunc _tmp0_;
	gconstpointer _tmp1_;
	FolksRole* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_;
	self = (FolksRoleFieldDetails*) base;
	_tmp0_ = g_str_hash;
	_tmp1_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_role_to_string ((FolksRole*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp0_ (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	return result;
}


static void folks_role_field_details_class_init (FolksRoleFieldDetailsClass * klass) {
	folks_role_field_details_parent_class = g_type_class_peek_parent (klass);
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->equal = folks_role_field_details_real_equal;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->hash = folks_role_field_details_real_hash;
}


static void folks_role_field_details_instance_init (FolksRoleFieldDetails * self) {
}


/**
 * Object representing details of a contact in an organisation which can have
 * some parameters associated with it.
 *
 * See {@link Folks.AbstractFieldDetails}.
 *
 * @since 0.6.0
 */
GType folks_role_field_details_get_type (void) {
	static volatile gsize folks_role_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_role_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksRoleFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_role_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksRoleFieldDetails), 0, (GInstanceInitFunc) folks_role_field_details_instance_init, NULL };
		GType folks_role_field_details_type_id;
		folks_role_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksRoleFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_role_field_details_type_id__volatile, folks_role_field_details_type_id);
	}
	return folks_role_field_details_type_id__volatile;
}


static void folks_role_details_real_change_roles_data_free (gpointer _data) {
	FolksRoleDetailsChangeRolesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->roles);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksRoleDetailsChangeRolesData, _data_);
}


static void folks_role_details_real_change_roles (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksRoleDetailsChangeRolesData* _data_;
	FolksRoleDetails* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	_data_ = g_slice_new0 (FolksRoleDetailsChangeRolesData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_role_details_real_change_roles);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_role_details_real_change_roles_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = roles;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->roles = _tmp2_;
	folks_role_details_real_change_roles_co (_data_);
}


static void folks_role_details_real_change_roles_finish (FolksRoleDetails* self, GAsyncResult* _res_, GError** error) {
	FolksRoleDetailsChangeRolesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's roles.
   *
   * It's preferred to call this rather than setting {@link RoleDetails.roles}
   * directly, as this method gives error notification and will only return once
   * the roles have been written to the relevant backing store (or the
   * operation's failed).
   *
   * @param roles the set of roles
   * @throws PropertyError if setting the roles failed
   * @since 0.6.2
   */
static gboolean folks_role_details_real_change_roles_co (FolksRoleDetailsChangeRolesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Roles are not writeable on this contact.");
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_role_details_change_roles (FolksRoleDetails* self, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->change_roles (self, roles, _callback_, _user_data_);
}


void folks_role_details_change_roles_finish (FolksRoleDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->change_roles_finish (self, _res_, error);
}


GeeSet* folks_role_details_get_roles (FolksRoleDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->get_roles (self);
}


void folks_role_details_set_roles (FolksRoleDetails* self, GeeSet* value) {
	g_return_if_fail (self != NULL);
	FOLKS_ROLE_DETAILS_GET_INTERFACE (self)->set_roles (self, value);
}


static void folks_role_details_base_init (FolksRoleDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The roles of the contact.
		   *
		   * @since 0.6.0
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("roles", "roles", "roles", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_roles = folks_role_details_real_change_roles;
		iface->change_roles_finish = folks_role_details_real_change_roles_finish;
	}
}


/**
 * This interfaces represents the list of roles a {@link Persona} and
 * {@link Individual} might have.
 *
 * @since 0.4.0
 */
GType folks_role_details_get_type (void) {
	static volatile gsize folks_role_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_role_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksRoleDetailsIface), (GBaseInitFunc) folks_role_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_role_details_type_id;
		folks_role_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksRoleDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_role_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_role_details_type_id__volatile, folks_role_details_type_id);
	}
	return folks_role_details_type_id__volatile;
}



