/* baobab-treemap.c generated by valac 0.21.2.6-90bab, the Vala compiler
 * generated from baobab-treemap.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2008  Igalia
 * Copyright (C) 2013  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors of the original code:
 *   Fabio Marzocca  <thesaltydog@gmail.com>
 *   Paolo Borelli <pborelli@katamail.com>
 *   Miguel Gomez <magomez@igalia.com>
 *   Eduardo Lima Mitev <elima@igalia.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <pango/pango.h>


#define BAOBAB_TYPE_CHART_ITEM (baobab_chart_item_get_type ())
#define BAOBAB_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItem))
#define BAOBAB_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))
#define BAOBAB_IS_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_IS_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_CHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))

typedef struct _BaobabChartItem BaobabChartItem;
typedef struct _BaobabChartItemClass BaobabChartItemClass;
typedef struct _BaobabChartItemPrivate BaobabChartItemPrivate;

#define BAOBAB_TYPE_TREEMAP_ITEM (baobab_treemap_item_get_type ())
#define BAOBAB_TREEMAP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_TREEMAP_ITEM, BaobabTreemapItem))
#define BAOBAB_TREEMAP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_TREEMAP_ITEM, BaobabTreemapItemClass))
#define BAOBAB_IS_TREEMAP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_TREEMAP_ITEM))
#define BAOBAB_IS_TREEMAP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_TREEMAP_ITEM))
#define BAOBAB_TREEMAP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_TREEMAP_ITEM, BaobabTreemapItemClass))

typedef struct _BaobabTreemapItem BaobabTreemapItem;
typedef struct _BaobabTreemapItemClass BaobabTreemapItemClass;
typedef struct _BaobabTreemapItemPrivate BaobabTreemapItemPrivate;

#define BAOBAB_TYPE_CHART (baobab_chart_get_type ())
#define BAOBAB_CHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART, BaobabChart))
#define BAOBAB_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART, BaobabChartClass))
#define BAOBAB_IS_CHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART))
#define BAOBAB_IS_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART))
#define BAOBAB_CHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART, BaobabChartClass))

typedef struct _BaobabChart BaobabChart;
typedef struct _BaobabChartClass BaobabChartClass;
typedef struct _BaobabChartPrivate BaobabChartPrivate;

#define BAOBAB_TYPE_TREEMAP (baobab_treemap_get_type ())
#define BAOBAB_TREEMAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_TREEMAP, BaobabTreemap))
#define BAOBAB_TREEMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_TREEMAP, BaobabTreemapClass))
#define BAOBAB_IS_TREEMAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_TREEMAP))
#define BAOBAB_IS_TREEMAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_TREEMAP))
#define BAOBAB_TREEMAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_TREEMAP, BaobabTreemapClass))

typedef struct _BaobabTreemap BaobabTreemap;
typedef struct _BaobabTreemapClass BaobabTreemapClass;
typedef struct _BaobabTreemapPrivate BaobabTreemapPrivate;
#define _baobab_chart_item_unref0(var) ((var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BaobabChartItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BaobabChartItemPrivate * priv;
	gchar* name;
	gchar* size;
	guint depth;
	gdouble rel_start;
	gdouble rel_size;
	GtkTreeIter iter;
	gboolean visible;
	gboolean has_any_child;
	gboolean has_visible_children;
	GdkRectangle rect;
	GList* parent;
};

struct _BaobabChartItemClass {
	GTypeClass parent_class;
	void (*finalize) (BaobabChartItem *self);
};

struct _BaobabTreemapItem {
	BaobabChartItem parent_instance;
	BaobabTreemapItemPrivate * priv;
	cairo_rectangle_t cr_rect;
};

struct _BaobabTreemapItemClass {
	BaobabChartItemClass parent_class;
};

struct _BaobabChart {
	GtkWidget parent_instance;
	BaobabChartPrivate * priv;
};

struct _BaobabChartClass {
	GtkWidgetClass parent_class;
	void (*post_draw) (BaobabChart* self, cairo_t* cr);
	void (*draw_item) (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
	void (*calculate_item_geometry) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*is_point_over_item) (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
	void (*get_item_rectangle) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*can_zoom_in) (BaobabChart* self);
	gboolean (*can_zoom_out) (BaobabChart* self);
	BaobabChartItem* (*create_new_chartitem) (BaobabChart* self);
	void (*item_activated) (BaobabChart* self, GtkTreeIter* iter);
};

struct _BaobabTreemap {
	BaobabChart parent_instance;
	BaobabTreemapPrivate * priv;
};

struct _BaobabTreemapClass {
	BaobabChartClass parent_class;
};

struct _BaobabTreemapPrivate {
	guint max_visible_depth;
	gboolean more_visible_children;
};


static gpointer baobab_treemap_item_parent_class = NULL;
static gpointer baobab_treemap_parent_class = NULL;

gpointer baobab_chart_item_ref (gpointer instance);
void baobab_chart_item_unref (gpointer instance);
GParamSpec* baobab_param_spec_chart_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_chart_item (GValue* value, gpointer v_object);
void baobab_value_take_chart_item (GValue* value, gpointer v_object);
gpointer baobab_value_get_chart_item (const GValue* value);
GType baobab_chart_item_get_type (void) G_GNUC_CONST;
GType baobab_treemap_item_get_type (void) G_GNUC_CONST;
enum  {
	BAOBAB_TREEMAP_ITEM_DUMMY_PROPERTY
};
BaobabTreemapItem* baobab_treemap_item_new (void);
BaobabTreemapItem* baobab_treemap_item_construct (GType object_type);
BaobabChartItem* baobab_chart_item_construct (GType object_type);
static void baobab_treemap_item_finalize (BaobabChartItem* obj);
GType baobab_chart_get_type (void) G_GNUC_CONST;
GType baobab_treemap_get_type (void) G_GNUC_CONST;
#define BAOBAB_TREEMAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_TREEMAP, BaobabTreemapPrivate))
enum  {
	BAOBAB_TREEMAP_DUMMY_PROPERTY
};
#define BAOBAB_TREEMAP_ITEM_BORDER_WIDTH 1
#define BAOBAB_TREEMAP_ITEM_PADDING 6
#define BAOBAB_TREEMAP_ITEM_TEXT_PADDING 3
#define BAOBAB_TREEMAP_ITEM_MIN_WIDTH 3
#define BAOBAB_TREEMAP_ITEM_MIN_HEIGHT 3
static BaobabChartItem* baobab_treemap_real_create_new_chartitem (BaobabChart* base);
static void baobab_treemap_draw_rectangle (BaobabTreemap* self, cairo_t* cr, gdouble x, gdouble y, gdouble width, gdouble height, GdkRGBA* fill_color, const gchar* text, gboolean show_text);
static void baobab_treemap_real_draw_item (BaobabChart* base, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
void baobab_chart_get_item_color (BaobabChart* self, gdouble rel_position, guint depth, gboolean highlighted, GdkRGBA* result);
static void baobab_treemap_real_calculate_item_geometry (BaobabChart* base, BaobabChartItem* item);
void baobab_chart_get_item_rectangle (BaobabChart* self, BaobabChartItem* item);
guint baobab_chart_get_max_depth (BaobabChart* self);
static void baobab_treemap_real_get_item_rectangle (BaobabChart* base, BaobabChartItem* item);
static gboolean baobab_treemap_real_is_point_over_item (BaobabChart* base, BaobabChartItem* item, gdouble x, gdouble y);
static gboolean baobab_treemap_real_can_zoom_out (BaobabChart* base);
static gboolean baobab_treemap_real_can_zoom_in (BaobabChart* base);
BaobabTreemap* baobab_treemap_new (void);
BaobabTreemap* baobab_treemap_construct (GType object_type);
BaobabChart* baobab_chart_construct (GType object_type);
static void baobab_treemap_finalize (GObject* obj);


BaobabTreemapItem* baobab_treemap_item_construct (GType object_type) {
	BaobabTreemapItem* self = NULL;
	self = (BaobabTreemapItem*) baobab_chart_item_construct (object_type);
	return self;
}


BaobabTreemapItem* baobab_treemap_item_new (void) {
	return baobab_treemap_item_construct (BAOBAB_TYPE_TREEMAP_ITEM);
}


static void baobab_treemap_item_class_init (BaobabTreemapItemClass * klass) {
	baobab_treemap_item_parent_class = g_type_class_peek_parent (klass);
	BAOBAB_CHART_ITEM_CLASS (klass)->finalize = baobab_treemap_item_finalize;
}


static void baobab_treemap_item_instance_init (BaobabTreemapItem * self) {
}


static void baobab_treemap_item_finalize (BaobabChartItem* obj) {
	BaobabTreemapItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_TREEMAP_ITEM, BaobabTreemapItem);
	BAOBAB_CHART_ITEM_CLASS (baobab_treemap_item_parent_class)->finalize (obj);
}


GType baobab_treemap_item_get_type (void) {
	static volatile gsize baobab_treemap_item_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_treemap_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabTreemapItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_treemap_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabTreemapItem), 0, (GInstanceInitFunc) baobab_treemap_item_instance_init, NULL };
		GType baobab_treemap_item_type_id;
		baobab_treemap_item_type_id = g_type_register_static (BAOBAB_TYPE_CHART_ITEM, "BaobabTreemapItem", &g_define_type_info, 0);
		g_once_init_leave (&baobab_treemap_item_type_id__volatile, baobab_treemap_item_type_id);
	}
	return baobab_treemap_item_type_id__volatile;
}


static BaobabChartItem* baobab_treemap_real_create_new_chartitem (BaobabChart* base) {
	BaobabTreemap * self;
	BaobabChartItem* result = NULL;
	BaobabTreemapItem* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	self = (BaobabTreemap*) base;
	_tmp0_ = baobab_treemap_item_new ();
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_CHART_ITEM) ? ((BaobabChartItem*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_baobab_chart_item_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_treemap_draw_rectangle (BaobabTreemap* self, cairo_t* cr, gdouble x, gdouble y, gdouble width, gdouble height, GdkRGBA* fill_color, const gchar* text, gboolean show_text) {
	guint border = 0U;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	cairo_t* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	guint _tmp6_ = 0U;
	gdouble _tmp7_ = 0.0;
	guint _tmp8_ = 0U;
	gdouble _tmp9_ = 0.0;
	guint _tmp10_ = 0U;
	gdouble _tmp11_ = 0.0;
	guint _tmp12_ = 0U;
	cairo_t* _tmp13_ = NULL;
	GdkRGBA _tmp14_ = {0};
	cairo_t* _tmp15_ = NULL;
	GdkRGBA border_color = {0};
	GtkStyleContext* _tmp16_ = NULL;
	GdkRGBA _tmp17_ = {0};
	cairo_t* _tmp18_ = NULL;
	GdkRGBA _tmp19_ = {0};
	cairo_t* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (fill_color != NULL);
	g_return_if_fail (text != NULL);
	border = (guint) BAOBAB_TREEMAP_ITEM_BORDER_WIDTH;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	_tmp2_ = cr;
	_tmp3_ = border;
	cairo_set_line_width (_tmp2_, (gdouble) _tmp3_);
	_tmp4_ = cr;
	_tmp5_ = x;
	_tmp6_ = border;
	_tmp7_ = y;
	_tmp8_ = border;
	_tmp9_ = width;
	_tmp10_ = border;
	_tmp11_ = height;
	_tmp12_ = border;
	cairo_rectangle (_tmp4_, _tmp5_ + _tmp6_, _tmp7_ + _tmp8_, _tmp9_ - (_tmp10_ * 2), _tmp11_ - (_tmp12_ * 2));
	_tmp13_ = cr;
	_tmp14_ = *fill_color;
	gdk_cairo_set_source_rgba (_tmp13_, &_tmp14_);
	_tmp15_ = cr;
	cairo_fill_preserve (_tmp15_);
	_tmp16_ = context;
	gtk_style_context_get_border_color (_tmp16_, GTK_STATE_FLAG_NORMAL, &_tmp17_);
	border_color = _tmp17_;
	_tmp18_ = cr;
	_tmp19_ = border_color;
	gdk_cairo_set_source_rgba (_tmp18_, &_tmp19_);
	_tmp20_ = cr;
	cairo_stroke (_tmp20_);
	_tmp21_ = show_text;
	if (_tmp21_) {
		PangoLayout* layout = NULL;
		PangoLayout* _tmp22_ = NULL;
		gchar* markup = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		PangoLayout* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		PangoRectangle rect = {0};
		PangoLayout* _tmp27_ = NULL;
		PangoRectangle _tmp28_ = {0};
		gboolean _tmp29_ = FALSE;
		PangoRectangle _tmp30_ = {0};
		gint _tmp31_ = 0;
		gdouble _tmp32_ = 0.0;
		gboolean _tmp36_ = FALSE;
		_tmp22_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
		layout = _tmp22_;
		_tmp23_ = text;
		_tmp24_ = g_markup_escape_text (_tmp23_, (gssize) (-1));
		markup = _tmp24_;
		_tmp25_ = layout;
		_tmp26_ = markup;
		pango_layout_set_markup (_tmp25_, _tmp26_, -1);
		_tmp27_ = layout;
		pango_layout_get_pixel_extents (_tmp27_, NULL, &_tmp28_);
		rect = _tmp28_;
		_tmp30_ = rect;
		_tmp31_ = _tmp30_.width;
		_tmp32_ = width;
		if (((gdouble) (_tmp31_ + (BAOBAB_TREEMAP_ITEM_TEXT_PADDING * 2))) <= _tmp32_) {
			PangoRectangle _tmp33_ = {0};
			gint _tmp34_ = 0;
			gdouble _tmp35_ = 0.0;
			_tmp33_ = rect;
			_tmp34_ = _tmp33_.height;
			_tmp35_ = height;
			_tmp29_ = ((gdouble) (_tmp34_ + (BAOBAB_TREEMAP_ITEM_TEXT_PADDING * 2))) <= _tmp35_;
		} else {
			_tmp29_ = FALSE;
		}
		_tmp36_ = _tmp29_;
		if (_tmp36_) {
			GtkStyleContext* _tmp37_ = NULL;
			cairo_t* _tmp38_ = NULL;
			gdouble _tmp39_ = 0.0;
			gdouble _tmp40_ = 0.0;
			PangoRectangle _tmp41_ = {0};
			gint _tmp42_ = 0;
			gdouble _tmp43_ = 0.0;
			gdouble _tmp44_ = 0.0;
			PangoRectangle _tmp45_ = {0};
			gint _tmp46_ = 0;
			PangoLayout* _tmp47_ = NULL;
			_tmp37_ = context;
			_tmp38_ = cr;
			_tmp39_ = x;
			_tmp40_ = width;
			_tmp41_ = rect;
			_tmp42_ = _tmp41_.width;
			_tmp43_ = y;
			_tmp44_ = height;
			_tmp45_ = rect;
			_tmp46_ = _tmp45_.height;
			_tmp47_ = layout;
			gtk_render_layout (_tmp37_, _tmp38_, (_tmp39_ + (_tmp40_ / 2)) - (_tmp42_ / 2), (_tmp43_ + (_tmp44_ / 2)) - (_tmp46_ / 2), _tmp47_);
		}
		_g_free0 (markup);
		_g_object_unref0 (layout);
	}
	_g_object_unref0 (context);
}


static void baobab_treemap_real_draw_item (BaobabChart* base, cairo_t* cr, BaobabChartItem* item, gboolean highlighted) {
	BaobabTreemap * self;
	cairo_rectangle_t rect = {0};
	GdkRGBA fill_color = {0};
	GtkAllocation allocation = {0};
	gdouble width = 0.0;
	gdouble height = 0.0;
	BaobabChartItem* _tmp0_ = NULL;
	cairo_rectangle_t _tmp1_ = {0};
	GtkAllocation _tmp2_ = {0};
	BaobabChartItem* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	cairo_t* _tmp29_ = NULL;
	cairo_rectangle_t _tmp30_ = {0};
	gdouble _tmp31_ = 0.0;
	cairo_rectangle_t _tmp32_ = {0};
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	GdkRGBA _tmp36_ = {0};
	BaobabChartItem* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	BaobabChartItem* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	self = (BaobabTreemap*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (item != NULL);
	memset (&fill_color, 0, sizeof (GdkRGBA));
	width = (gdouble) 0;
	height = (gdouble) 0;
	_tmp0_ = item;
	_tmp1_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_TREEMAP_ITEM) ? ((BaobabTreemapItem*) _tmp0_) : NULL)->cr_rect;
	rect = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = item;
	_tmp4_ = _tmp3_->depth;
	if ((_tmp4_ % 2) != ((guint) 0)) {
		cairo_rectangle_t _tmp5_ = {0};
		gdouble _tmp6_ = 0.0;
		GtkAllocation _tmp7_ = {0};
		gint _tmp8_ = 0;
		BaobabChartItem* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		GdkRGBA _tmp12_ = {0};
		cairo_rectangle_t _tmp13_ = {0};
		gdouble _tmp14_ = 0.0;
		cairo_rectangle_t _tmp15_ = {0};
		gdouble _tmp16_ = 0.0;
		_tmp5_ = rect;
		_tmp6_ = _tmp5_.x;
		_tmp7_ = allocation;
		_tmp8_ = _tmp7_.width;
		_tmp9_ = item;
		_tmp10_ = _tmp9_->depth;
		_tmp11_ = highlighted;
		baobab_chart_get_item_color ((BaobabChart*) self, (_tmp6_ / _tmp8_) * 200, _tmp10_, _tmp11_, &_tmp12_);
		fill_color = _tmp12_;
		_tmp13_ = rect;
		_tmp14_ = _tmp13_.width;
		width = _tmp14_ - BAOBAB_TREEMAP_ITEM_PADDING;
		_tmp15_ = rect;
		_tmp16_ = _tmp15_.height;
		height = _tmp16_;
	} else {
		cairo_rectangle_t _tmp17_ = {0};
		gdouble _tmp18_ = 0.0;
		GtkAllocation _tmp19_ = {0};
		gint _tmp20_ = 0;
		BaobabChartItem* _tmp21_ = NULL;
		guint _tmp22_ = 0U;
		gboolean _tmp23_ = FALSE;
		GdkRGBA _tmp24_ = {0};
		cairo_rectangle_t _tmp25_ = {0};
		gdouble _tmp26_ = 0.0;
		cairo_rectangle_t _tmp27_ = {0};
		gdouble _tmp28_ = 0.0;
		_tmp17_ = rect;
		_tmp18_ = _tmp17_.y;
		_tmp19_ = allocation;
		_tmp20_ = _tmp19_.height;
		_tmp21_ = item;
		_tmp22_ = _tmp21_->depth;
		_tmp23_ = highlighted;
		baobab_chart_get_item_color ((BaobabChart*) self, (_tmp18_ / _tmp20_) * 200, _tmp22_, _tmp23_, &_tmp24_);
		fill_color = _tmp24_;
		_tmp25_ = rect;
		_tmp26_ = _tmp25_.width;
		width = _tmp26_;
		_tmp27_ = rect;
		_tmp28_ = _tmp27_.height;
		height = _tmp28_ - BAOBAB_TREEMAP_ITEM_PADDING;
	}
	_tmp29_ = cr;
	_tmp30_ = rect;
	_tmp31_ = _tmp30_.x;
	_tmp32_ = rect;
	_tmp33_ = _tmp32_.y;
	_tmp34_ = width;
	_tmp35_ = height;
	_tmp36_ = fill_color;
	_tmp37_ = item;
	_tmp38_ = _tmp37_->name;
	_tmp39_ = item;
	_tmp40_ = _tmp39_->has_visible_children;
	baobab_treemap_draw_rectangle (self, _tmp29_, _tmp31_, _tmp33_, _tmp34_, _tmp35_, &_tmp36_, _tmp38_, !_tmp40_);
}


static gpointer _baobab_chart_item_ref0 (gpointer self) {
	return self ? baobab_chart_item_ref (self) : NULL;
}


static void baobab_treemap_real_calculate_item_geometry (BaobabChart* base, BaobabChartItem* item) {
	BaobabTreemap * self;
	BaobabTreemapItem* treemapitem = NULL;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabTreemapItem* _tmp1_ = NULL;
	cairo_rectangle_t p_area = {0};
	BaobabChartItem* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	BaobabChartItem* _tmp4_ = NULL;
	BaobabChartItem* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	BaobabChartItem* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	gboolean _tmp55_ = FALSE;
	BaobabTreemapItem* _tmp56_ = NULL;
	cairo_rectangle_t _tmp57_ = {0};
	gdouble _tmp58_ = 0.0;
	gboolean _tmp62_ = FALSE;
	BaobabTreemapItem* _tmp63_ = NULL;
	BaobabTreemapItem* _tmp64_ = NULL;
	cairo_rectangle_t _tmp65_ = {0};
	gdouble _tmp66_ = 0.0;
	gdouble _tmp67_ = 0.0;
	BaobabTreemapItem* _tmp68_ = NULL;
	BaobabTreemapItem* _tmp69_ = NULL;
	cairo_rectangle_t _tmp70_ = {0};
	gdouble _tmp71_ = 0.0;
	gdouble _tmp72_ = 0.0;
	BaobabTreemapItem* _tmp73_ = NULL;
	BaobabTreemapItem* _tmp74_ = NULL;
	cairo_rectangle_t _tmp75_ = {0};
	gdouble _tmp76_ = 0.0;
	gdouble _tmp77_ = 0.0;
	BaobabTreemapItem* _tmp78_ = NULL;
	BaobabTreemapItem* _tmp79_ = NULL;
	cairo_rectangle_t _tmp80_ = {0};
	gdouble _tmp81_ = 0.0;
	gdouble _tmp82_ = 0.0;
	BaobabChartItem* _tmp83_ = NULL;
	BaobabChartItem* _tmp84_ = NULL;
	GList* _tmp85_ = NULL;
	BaobabChartItem* _tmp89_ = NULL;
	BaobabChartItem* _tmp90_ = NULL;
	guint _tmp91_ = 0U;
	guint _tmp92_ = 0U;
	guint _tmp93_ = 0U;
	self = (BaobabTreemap*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_TREEMAP_ITEM) ? ((BaobabTreemapItem*) _tmp0_) : NULL);
	treemapitem = _tmp1_;
	memset (&p_area, 0, sizeof (cairo_rectangle_t));
	_tmp2_ = item;
	_tmp3_ = _tmp2_->depth;
	if (_tmp3_ == ((guint) 0)) {
		self->priv->max_visible_depth = (guint) 0;
		self->priv->more_visible_children = FALSE;
	}
	_tmp4_ = item;
	_tmp4_->visible = FALSE;
	_tmp5_ = item;
	_tmp6_ = _tmp5_->parent;
	if (_tmp6_ == NULL) {
		GtkAllocation allocation = {0};
		GtkAllocation _tmp7_ = {0};
		GtkAllocation _tmp8_ = {0};
		gint _tmp9_ = 0;
		GtkAllocation _tmp10_ = {0};
		gint _tmp11_ = 0;
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp7_);
		allocation = _tmp7_;
		p_area.x = (gdouble) ((-BAOBAB_TREEMAP_ITEM_PADDING) / 2);
		p_area.y = (gdouble) ((-BAOBAB_TREEMAP_ITEM_PADDING) / 2);
		_tmp8_ = allocation;
		_tmp9_ = _tmp8_.width;
		p_area.width = (gdouble) (_tmp9_ + (BAOBAB_TREEMAP_ITEM_PADDING * 2));
		_tmp10_ = allocation;
		_tmp11_ = _tmp10_.height;
		p_area.height = (gdouble) (_tmp11_ + (BAOBAB_TREEMAP_ITEM_PADDING * 2));
	} else {
		BaobabChartItem* _tmp12_ = NULL;
		GList* _tmp13_ = NULL;
		gconstpointer _tmp14_ = NULL;
		BaobabChartItem* _tmp15_ = NULL;
		cairo_rectangle_t _tmp16_ = {0};
		_tmp12_ = item;
		_tmp13_ = _tmp12_->parent;
		_tmp14_ = _tmp13_->data;
		_tmp15_ = (BaobabChartItem*) _tmp14_;
		_tmp16_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, BAOBAB_TYPE_TREEMAP_ITEM) ? ((BaobabTreemapItem*) _tmp15_) : NULL)->cr_rect;
		p_area = _tmp16_;
	}
	_tmp17_ = item;
	_tmp18_ = _tmp17_->depth;
	if ((_tmp18_ % 2) != ((guint) 0)) {
		gdouble width = 0.0;
		cairo_rectangle_t _tmp19_ = {0};
		gdouble _tmp20_ = 0.0;
		BaobabTreemapItem* _tmp21_ = NULL;
		cairo_rectangle_t _tmp22_ = {0};
		gdouble _tmp23_ = 0.0;
		BaobabChartItem* _tmp24_ = NULL;
		gdouble _tmp25_ = 0.0;
		gdouble _tmp26_ = 0.0;
		BaobabTreemapItem* _tmp27_ = NULL;
		cairo_rectangle_t _tmp28_ = {0};
		gdouble _tmp29_ = 0.0;
		BaobabTreemapItem* _tmp30_ = NULL;
		gdouble _tmp31_ = 0.0;
		BaobabChartItem* _tmp32_ = NULL;
		gdouble _tmp33_ = 0.0;
		BaobabTreemapItem* _tmp34_ = NULL;
		cairo_rectangle_t _tmp35_ = {0};
		gdouble _tmp36_ = 0.0;
		_tmp19_ = p_area;
		_tmp20_ = _tmp19_.width;
		width = _tmp20_ - BAOBAB_TREEMAP_ITEM_PADDING;
		_tmp21_ = treemapitem;
		_tmp22_ = p_area;
		_tmp23_ = _tmp22_.x;
		_tmp24_ = item;
		_tmp25_ = _tmp24_->rel_start;
		_tmp26_ = width;
		_tmp21_->cr_rect.x = (_tmp23_ + ((_tmp25_ * _tmp26_) / 100)) + BAOBAB_TREEMAP_ITEM_PADDING;
		_tmp27_ = treemapitem;
		_tmp28_ = p_area;
		_tmp29_ = _tmp28_.y;
		_tmp27_->cr_rect.y = _tmp29_ + BAOBAB_TREEMAP_ITEM_PADDING;
		_tmp30_ = treemapitem;
		_tmp31_ = width;
		_tmp32_ = item;
		_tmp33_ = _tmp32_->rel_size;
		_tmp30_->cr_rect.width = (_tmp31_ * _tmp33_) / 100;
		_tmp34_ = treemapitem;
		_tmp35_ = p_area;
		_tmp36_ = _tmp35_.height;
		_tmp34_->cr_rect.height = _tmp36_ - (BAOBAB_TREEMAP_ITEM_PADDING * 3);
	} else {
		gdouble height = 0.0;
		cairo_rectangle_t _tmp37_ = {0};
		gdouble _tmp38_ = 0.0;
		BaobabTreemapItem* _tmp39_ = NULL;
		cairo_rectangle_t _tmp40_ = {0};
		gdouble _tmp41_ = 0.0;
		BaobabTreemapItem* _tmp42_ = NULL;
		cairo_rectangle_t _tmp43_ = {0};
		gdouble _tmp44_ = 0.0;
		BaobabChartItem* _tmp45_ = NULL;
		gdouble _tmp46_ = 0.0;
		gdouble _tmp47_ = 0.0;
		BaobabTreemapItem* _tmp48_ = NULL;
		cairo_rectangle_t _tmp49_ = {0};
		gdouble _tmp50_ = 0.0;
		BaobabTreemapItem* _tmp51_ = NULL;
		gdouble _tmp52_ = 0.0;
		BaobabChartItem* _tmp53_ = NULL;
		gdouble _tmp54_ = 0.0;
		_tmp37_ = p_area;
		_tmp38_ = _tmp37_.height;
		height = _tmp38_ - BAOBAB_TREEMAP_ITEM_PADDING;
		_tmp39_ = treemapitem;
		_tmp40_ = p_area;
		_tmp41_ = _tmp40_.x;
		_tmp39_->cr_rect.x = _tmp41_ + BAOBAB_TREEMAP_ITEM_PADDING;
		_tmp42_ = treemapitem;
		_tmp43_ = p_area;
		_tmp44_ = _tmp43_.y;
		_tmp45_ = item;
		_tmp46_ = _tmp45_->rel_start;
		_tmp47_ = height;
		_tmp42_->cr_rect.y = (_tmp44_ + ((_tmp46_ * _tmp47_) / 100)) + BAOBAB_TREEMAP_ITEM_PADDING;
		_tmp48_ = treemapitem;
		_tmp49_ = p_area;
		_tmp50_ = _tmp49_.width;
		_tmp48_->cr_rect.width = _tmp50_ - (BAOBAB_TREEMAP_ITEM_PADDING * 3);
		_tmp51_ = treemapitem;
		_tmp52_ = height;
		_tmp53_ = item;
		_tmp54_ = _tmp53_->rel_size;
		_tmp51_->cr_rect.height = (_tmp52_ * _tmp54_) / 100;
	}
	_tmp56_ = treemapitem;
	_tmp57_ = _tmp56_->cr_rect;
	_tmp58_ = _tmp57_.width;
	if ((_tmp58_ - BAOBAB_TREEMAP_ITEM_PADDING) < ((gdouble) BAOBAB_TREEMAP_ITEM_MIN_WIDTH)) {
		_tmp55_ = TRUE;
	} else {
		BaobabTreemapItem* _tmp59_ = NULL;
		cairo_rectangle_t _tmp60_ = {0};
		gdouble _tmp61_ = 0.0;
		_tmp59_ = treemapitem;
		_tmp60_ = _tmp59_->cr_rect;
		_tmp61_ = _tmp60_.height;
		_tmp55_ = (_tmp61_ - BAOBAB_TREEMAP_ITEM_PADDING) < ((gdouble) BAOBAB_TREEMAP_ITEM_MIN_HEIGHT);
	}
	_tmp62_ = _tmp55_;
	if (_tmp62_) {
		_baobab_chart_item_unref0 (treemapitem);
		return;
	}
	_tmp63_ = treemapitem;
	_tmp64_ = treemapitem;
	_tmp65_ = _tmp64_->cr_rect;
	_tmp66_ = _tmp65_.x;
	_tmp67_ = floor (_tmp66_);
	_tmp63_->cr_rect.x = _tmp67_ + 0.5;
	_tmp68_ = treemapitem;
	_tmp69_ = treemapitem;
	_tmp70_ = _tmp69_->cr_rect;
	_tmp71_ = _tmp70_.y;
	_tmp72_ = floor (_tmp71_);
	_tmp68_->cr_rect.y = _tmp72_ + 0.5;
	_tmp73_ = treemapitem;
	_tmp74_ = treemapitem;
	_tmp75_ = _tmp74_->cr_rect;
	_tmp76_ = _tmp75_.width;
	_tmp77_ = floor (_tmp76_);
	_tmp73_->cr_rect.width = _tmp77_;
	_tmp78_ = treemapitem;
	_tmp79_ = treemapitem;
	_tmp80_ = _tmp79_->cr_rect;
	_tmp81_ = _tmp80_.height;
	_tmp82_ = floor (_tmp81_);
	_tmp78_->cr_rect.height = _tmp82_;
	_tmp83_ = item;
	_tmp83_->visible = TRUE;
	_tmp84_ = item;
	_tmp85_ = _tmp84_->parent;
	if (_tmp85_ != NULL) {
		BaobabChartItem* _tmp86_ = NULL;
		GList* _tmp87_ = NULL;
		gconstpointer _tmp88_ = NULL;
		_tmp86_ = item;
		_tmp87_ = _tmp86_->parent;
		_tmp88_ = _tmp87_->data;
		((BaobabChartItem*) _tmp88_)->has_visible_children = TRUE;
	}
	_tmp89_ = item;
	baobab_chart_get_item_rectangle ((BaobabChart*) self, _tmp89_);
	_tmp90_ = item;
	_tmp91_ = _tmp90_->depth;
	_tmp92_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp93_ = _tmp92_;
	if (_tmp91_ == (_tmp93_ + 1)) {
		self->priv->more_visible_children = TRUE;
	} else {
		guint _tmp94_ = 0U;
		BaobabChartItem* _tmp95_ = NULL;
		guint _tmp96_ = 0U;
		guint _tmp97_ = 0U;
		_tmp94_ = self->priv->max_visible_depth;
		_tmp95_ = item;
		_tmp96_ = _tmp95_->depth;
		_tmp97_ = MAX (_tmp94_, _tmp96_);
		self->priv->max_visible_depth = _tmp97_;
	}
	_baobab_chart_item_unref0 (treemapitem);
}


static void baobab_treemap_real_get_item_rectangle (BaobabChart* base, BaobabChartItem* item) {
	BaobabTreemap * self;
	cairo_rectangle_t crect = {0};
	BaobabChartItem* _tmp0_ = NULL;
	cairo_rectangle_t _tmp1_ = {0};
	BaobabChartItem* _tmp2_ = NULL;
	cairo_rectangle_t _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	BaobabChartItem* _tmp5_ = NULL;
	cairo_rectangle_t _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	BaobabChartItem* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	self = (BaobabTreemap*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_TREEMAP_ITEM) ? ((BaobabTreemapItem*) _tmp0_) : NULL)->cr_rect;
	crect = _tmp1_;
	_tmp2_ = item;
	_tmp3_ = crect;
	_tmp4_ = _tmp3_.x;
	_tmp2_->rect.x = (gint) _tmp4_;
	_tmp5_ = item;
	_tmp6_ = crect;
	_tmp7_ = _tmp6_.y;
	_tmp5_->rect.y = (gint) _tmp7_;
	_tmp8_ = item;
	_tmp9_ = _tmp8_->depth;
	if ((_tmp9_ % 2) != ((guint) 0)) {
		BaobabChartItem* _tmp10_ = NULL;
		cairo_rectangle_t _tmp11_ = {0};
		gdouble _tmp12_ = 0.0;
		BaobabChartItem* _tmp13_ = NULL;
		cairo_rectangle_t _tmp14_ = {0};
		gdouble _tmp15_ = 0.0;
		_tmp10_ = item;
		_tmp11_ = crect;
		_tmp12_ = _tmp11_.width;
		_tmp10_->rect.width = ((gint) _tmp12_) - BAOBAB_TREEMAP_ITEM_PADDING;
		_tmp13_ = item;
		_tmp14_ = crect;
		_tmp15_ = _tmp14_.height;
		_tmp13_->rect.height = (gint) _tmp15_;
	} else {
		BaobabChartItem* _tmp16_ = NULL;
		cairo_rectangle_t _tmp17_ = {0};
		gdouble _tmp18_ = 0.0;
		BaobabChartItem* _tmp19_ = NULL;
		cairo_rectangle_t _tmp20_ = {0};
		gdouble _tmp21_ = 0.0;
		_tmp16_ = item;
		_tmp17_ = crect;
		_tmp18_ = _tmp17_.width;
		_tmp16_->rect.width = (gint) _tmp18_;
		_tmp19_ = item;
		_tmp20_ = crect;
		_tmp21_ = _tmp20_.height;
		_tmp19_->rect.height = ((gint) _tmp21_) - BAOBAB_TREEMAP_ITEM_PADDING;
	}
}


static gboolean baobab_treemap_real_is_point_over_item (BaobabChart* base, BaobabChartItem* item, gdouble x, gdouble y) {
	BaobabTreemap * self;
	gboolean result = FALSE;
	GdkRectangle rect = {0};
	BaobabChartItem* _tmp0_ = NULL;
	GdkRectangle _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gdouble _tmp5_ = 0.0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp23_ = FALSE;
	self = (BaobabTreemap*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = item;
	_tmp1_ = _tmp0_->rect;
	rect = _tmp1_;
	_tmp5_ = x;
	_tmp6_ = rect;
	_tmp7_ = _tmp6_.x;
	if (_tmp5_ >= ((gdouble) _tmp7_)) {
		gdouble _tmp8_ = 0.0;
		GdkRectangle _tmp9_ = {0};
		gint _tmp10_ = 0;
		GdkRectangle _tmp11_ = {0};
		gint _tmp12_ = 0;
		_tmp8_ = x;
		_tmp9_ = rect;
		_tmp10_ = _tmp9_.x;
		_tmp11_ = rect;
		_tmp12_ = _tmp11_.width;
		_tmp4_ = _tmp8_ <= ((gdouble) (_tmp10_ + _tmp12_));
	} else {
		_tmp4_ = FALSE;
	}
	_tmp13_ = _tmp4_;
	if (_tmp13_) {
		gdouble _tmp14_ = 0.0;
		GdkRectangle _tmp15_ = {0};
		gint _tmp16_ = 0;
		_tmp14_ = y;
		_tmp15_ = rect;
		_tmp16_ = _tmp15_.y;
		_tmp3_ = _tmp14_ >= ((gdouble) _tmp16_);
	} else {
		_tmp3_ = FALSE;
	}
	_tmp17_ = _tmp3_;
	if (_tmp17_) {
		gdouble _tmp18_ = 0.0;
		GdkRectangle _tmp19_ = {0};
		gint _tmp20_ = 0;
		GdkRectangle _tmp21_ = {0};
		gint _tmp22_ = 0;
		_tmp18_ = y;
		_tmp19_ = rect;
		_tmp20_ = _tmp19_.y;
		_tmp21_ = rect;
		_tmp22_ = _tmp21_.height;
		_tmp2_ = _tmp18_ <= ((gdouble) (_tmp20_ + _tmp22_));
	} else {
		_tmp2_ = FALSE;
	}
	_tmp23_ = _tmp2_;
	result = _tmp23_;
	return result;
}


static gboolean baobab_treemap_real_can_zoom_out (BaobabChart* base) {
	BaobabTreemap * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (BaobabTreemap*) base;
	_tmp0_ = self->priv->more_visible_children;
	result = _tmp0_;
	return result;
}


static gboolean baobab_treemap_real_can_zoom_in (BaobabChart* base) {
	BaobabTreemap * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	self = (BaobabTreemap*) base;
	_tmp0_ = self->priv->max_visible_depth;
	result = _tmp0_ > ((guint) 1);
	return result;
}


BaobabTreemap* baobab_treemap_construct (GType object_type) {
	BaobabTreemap * self = NULL;
	self = (BaobabTreemap*) baobab_chart_construct (object_type);
	return self;
}


BaobabTreemap* baobab_treemap_new (void) {
	return baobab_treemap_construct (BAOBAB_TYPE_TREEMAP);
}


static void baobab_treemap_class_init (BaobabTreemapClass * klass) {
	baobab_treemap_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabTreemapPrivate));
	BAOBAB_CHART_CLASS (klass)->create_new_chartitem = baobab_treemap_real_create_new_chartitem;
	BAOBAB_CHART_CLASS (klass)->draw_item = baobab_treemap_real_draw_item;
	BAOBAB_CHART_CLASS (klass)->calculate_item_geometry = baobab_treemap_real_calculate_item_geometry;
	BAOBAB_CHART_CLASS (klass)->get_item_rectangle = baobab_treemap_real_get_item_rectangle;
	BAOBAB_CHART_CLASS (klass)->is_point_over_item = baobab_treemap_real_is_point_over_item;
	BAOBAB_CHART_CLASS (klass)->can_zoom_out = baobab_treemap_real_can_zoom_out;
	BAOBAB_CHART_CLASS (klass)->can_zoom_in = baobab_treemap_real_can_zoom_in;
	G_OBJECT_CLASS (klass)->finalize = baobab_treemap_finalize;
}


static void baobab_treemap_instance_init (BaobabTreemap * self) {
	self->priv = BAOBAB_TREEMAP_GET_PRIVATE (self);
}


static void baobab_treemap_finalize (GObject* obj) {
	BaobabTreemap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_TREEMAP, BaobabTreemap);
	G_OBJECT_CLASS (baobab_treemap_parent_class)->finalize (obj);
}


GType baobab_treemap_get_type (void) {
	static volatile gsize baobab_treemap_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_treemap_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabTreemapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_treemap_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabTreemap), 0, (GInstanceInitFunc) baobab_treemap_instance_init, NULL };
		GType baobab_treemap_type_id;
		baobab_treemap_type_id = g_type_register_static (BAOBAB_TYPE_CHART, "BaobabTreemap", &g_define_type_info, 0);
		g_once_init_leave (&baobab_treemap_type_id__volatile, baobab_treemap_type_id);
	}
	return baobab_treemap_type_id__volatile;
}



