#ifndef GTK_CLIENT_PROTOCOL_H
#define GTK_CLIENT_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

struct wl_client;
struct wl_resource;

struct gtk_shell;
struct gtk_surface;

extern const struct wl_interface gtk_shell_interface;
extern const struct wl_interface gtk_surface_interface;

#ifndef GTK_SHELL_CAPABILITY_ENUM
#define GTK_SHELL_CAPABILITY_ENUM
enum gtk_shell_capability {
	GTK_SHELL_CAPABILITY_GLOBAL_APP_MENU = 1,
	GTK_SHELL_CAPABILITY_GLOBAL_MENU_BAR = 2,
	GTK_SHELL_CAPABILITY_DESKTOP_ICONS = 3,
};
#endif /* GTK_SHELL_CAPABILITY_ENUM */

struct gtk_shell_listener {
	/**
	 * capabilities - (none)
	 * @capabilities: (none)
	 */
	void (*capabilities)(void *data,
			     struct gtk_shell *gtk_shell,
			     uint32_t capabilities);
};

static inline int
gtk_shell_add_listener(struct gtk_shell *gtk_shell,
		       const struct gtk_shell_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) gtk_shell,
				     (void (**)(void)) listener, data);
}

#define GTK_SHELL_GET_GTK_SURFACE	0

static inline void
gtk_shell_set_user_data(struct gtk_shell *gtk_shell, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gtk_shell, user_data);
}

static inline void *
gtk_shell_get_user_data(struct gtk_shell *gtk_shell)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gtk_shell);
}

static inline void
gtk_shell_destroy(struct gtk_shell *gtk_shell)
{
	wl_proxy_destroy((struct wl_proxy *) gtk_shell);
}

static inline struct gtk_surface *
gtk_shell_get_gtk_surface(struct gtk_shell *gtk_shell, struct wl_surface *surface)
{
	struct wl_proxy *gtk_surface;

	gtk_surface = wl_proxy_create((struct wl_proxy *) gtk_shell,
			     &gtk_surface_interface);
	if (!gtk_surface)
		return NULL;

	wl_proxy_marshal((struct wl_proxy *) gtk_shell,
			 GTK_SHELL_GET_GTK_SURFACE, gtk_surface, surface);

	return (struct gtk_surface *) gtk_surface;
}

#define GTK_SURFACE_SET_DBUS_PROPERTIES	0

static inline void
gtk_surface_set_user_data(struct gtk_surface *gtk_surface, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) gtk_surface, user_data);
}

static inline void *
gtk_surface_get_user_data(struct gtk_surface *gtk_surface)
{
	return wl_proxy_get_user_data((struct wl_proxy *) gtk_surface);
}

static inline void
gtk_surface_destroy(struct gtk_surface *gtk_surface)
{
	wl_proxy_destroy((struct wl_proxy *) gtk_surface);
}

static inline void
gtk_surface_set_dbus_properties(struct gtk_surface *gtk_surface, const char *application_id, const char *app_menu_path, const char *menubar_path, const char *window_object_path, const char *application_object_path, const char *unique_bus_name)
{
	wl_proxy_marshal((struct wl_proxy *) gtk_surface,
			 GTK_SURFACE_SET_DBUS_PROPERTIES, application_id, app_menu_path, menubar_path, window_object_path, application_object_path, unique_bus_name);
}

#ifdef  __cplusplus
}
#endif

#endif
