/* tracker-view.c generated by valac 0.22.0, the Vala compiler
 * generated from tracker-view.vala, do not modify */

/**/
/* Copyright 2010, Martyn Russell <martyn@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TRACKER_TYPE_VIEW (tracker_view_get_type ())
#define TRACKER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_VIEW, TrackerView))
#define TRACKER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_VIEW, TrackerViewClass))
#define TRACKER_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_VIEW))
#define TRACKER_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_VIEW))
#define TRACKER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_VIEW, TrackerViewClass))

typedef struct _TrackerView TrackerView;
typedef struct _TrackerViewClass TrackerViewClass;
typedef struct _TrackerViewPrivate TrackerViewPrivate;

#define TRACKER_VIEW_TYPE_DISPLAY (tracker_view_display_get_type ())

#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
typedef struct _Block5Data Block5Data;

#define TYPE_TRACKER_TAGS_VIEW (tracker_tags_view_get_type ())
#define TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsView))
#define TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))
#define IS_TRACKER_TAGS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_TAGS_VIEW))
#define IS_TRACKER_TAGS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_TAGS_VIEW))
#define TRACKER_TAGS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_TAGS_VIEW, TrackerTagsViewClass))

typedef struct _TrackerTagsView TrackerTagsView;
typedef struct _TrackerTagsViewClass TrackerTagsViewClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _TrackerView {
	GtkScrolledWindow parent_instance;
	TrackerViewPrivate * priv;
};

struct _TrackerViewClass {
	GtkScrolledWindowClass parent_class;
};

typedef enum  {
	TRACKER_VIEW_DISPLAY_NO_RESULTS,
	TRACKER_VIEW_DISPLAY_CATEGORIES,
	TRACKER_VIEW_DISPLAY_FILE_LIST,
	TRACKER_VIEW_DISPLAY_FILE_ICONS
} TrackerViewDisplay;

struct _TrackerViewPrivate {
	TrackerViewDisplay _display;
	TrackerResultStore* _store;
	GtkWidget* view;
	GtkMenu* context_menu;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

struct _Block5Data {
	int _ref_count_;
	TrackerView * self;
	GtkDialog* dialog;
};


static gpointer tracker_view_parent_class = NULL;

GType tracker_view_get_type (void) G_GNUC_CONST;
GType tracker_view_display_get_type (void) G_GNUC_CONST;
GType tracker_result_store_get_type (void) G_GNUC_CONST;
#define TRACKER_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_VIEW, TrackerViewPrivate))
enum  {
	TRACKER_VIEW_DUMMY_PROPERTY,
	TRACKER_VIEW_DISPLAY,
	TRACKER_VIEW_STORE
};
static void tracker_view_store_row_changed (TrackerView* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static gboolean tracker_view_row_selection_func (TrackerView* self, GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_selected);
static void tracker_view_real_unmap (GtkWidget* base);
TrackerResultStore* tracker_view_get_store (TrackerView* self);
void tracker_result_store_cancel_search (TrackerResultStore* self);
TrackerView* tracker_view_new (TrackerViewDisplay* _display, TrackerResultStore* store);
TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, TrackerResultStore* store);
static void tracker_view_set_display (TrackerView* self, TrackerViewDisplay value);
static void _tracker_view_store_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
TrackerViewDisplay tracker_view_get_display (TrackerView* self);
static void tracker_view_setup_model (TrackerView* self);
static void tracker_view_setup_menus (TrackerView* self);
static void tracker_view_background_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_background_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void tracker_view_text_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_text_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void tracker_view_file_date_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_file_date_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void tracker_view_file_size_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_file_size_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static gboolean _tracker_view_row_selection_func_gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self);
static void tracker_view_category_detail_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void _tracker_view_category_detail_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
GType tracker_query_type_get_type (void) G_GNUC_CONST;
gchar* tracker_time_format_from_iso8601 (const gchar* s);
gchar* tracker_time_format_from_seconds (const gchar* seconds_str);
static gboolean tracker_view_view_button_press_event (TrackerView* self, GtkWidget* widget, GdkEventButton* event);
static gboolean _tracker_view_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void tracker_view_context_menu_directory_clicked (TrackerView* self);
static void _tracker_view_context_menu_directory_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void tracker_view_context_menu_tags_clicked (TrackerView* self);
static void _tracker_view_context_menu_tags_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static GtkTreePath* tracker_view_get_selected_path (TrackerView* self);
static GtkTreeModel* tracker_view_get_model (TrackerView* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void tracker_model_launch_selected_parent_dir (GtkTreeModel* model, GtkTreePath* path, gint col);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda5_ (Block5Data* _data5_);
static void ___lambda5__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
TrackerTagsView* tracker_tags_view_new (GList* _files);
TrackerTagsView* tracker_tags_view_construct (GType object_type, GList* _files);
GType tracker_tags_view_get_type (void) G_GNUC_CONST;
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void tracker_view_set_store (TrackerView* self, TrackerResultStore* value);
static void tracker_view_finalize (GObject* obj);
static void _vala_tracker_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType tracker_view_display_get_type (void) {
	static volatile gsize tracker_view_display_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_view_display_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_VIEW_DISPLAY_NO_RESULTS, "TRACKER_VIEW_DISPLAY_NO_RESULTS", "no-results"}, {TRACKER_VIEW_DISPLAY_CATEGORIES, "TRACKER_VIEW_DISPLAY_CATEGORIES", "categories"}, {TRACKER_VIEW_DISPLAY_FILE_LIST, "TRACKER_VIEW_DISPLAY_FILE_LIST", "file-list"}, {TRACKER_VIEW_DISPLAY_FILE_ICONS, "TRACKER_VIEW_DISPLAY_FILE_ICONS", "file-icons"}, {0, NULL, NULL}};
		GType tracker_view_display_type_id;
		tracker_view_display_type_id = g_enum_register_static ("TrackerViewDisplay", values);
		g_once_init_leave (&tracker_view_display_type_id__volatile, tracker_view_display_type_id);
	}
	return tracker_view_display_type_id__volatile;
}


static void tracker_view_store_row_changed (TrackerView* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	gint n_children = 0;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = *iter;
	_tmp2_ = gtk_tree_model_iter_n_children (_tmp0_, &_tmp1_);
	n_children = _tmp2_;
	_tmp3_ = n_children;
	if (_tmp3_ > 0) {
		GtkWidget* _tmp4_ = NULL;
		GtkTreePath* _tmp5_ = NULL;
		_tmp4_ = self->priv->view;
		_tmp5_ = path;
		gtk_tree_view_expand_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GTK_TYPE_TREE_VIEW, GtkTreeView), _tmp5_, FALSE);
	}
}


static gboolean tracker_view_row_selection_func (TrackerView* self, GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_selected) {
	gboolean result = FALSE;
	GtkTreePath* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (selection != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = gtk_tree_path_get_depth (_tmp0_);
	if (_tmp1_ == 1) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void tracker_view_real_unmap (GtkWidget* base) {
	TrackerView * self;
	TrackerResultStore* _tmp0_ = NULL;
	TrackerResultStore* _tmp1_ = NULL;
	self = (TrackerView*) base;
	_tmp0_ = tracker_view_get_store (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		TrackerResultStore* _tmp2_ = NULL;
		TrackerResultStore* _tmp3_ = NULL;
		_tmp2_ = tracker_view_get_store (self);
		_tmp3_ = _tmp2_;
		tracker_result_store_cancel_search (_tmp3_);
	}
	GTK_WIDGET_CLASS (tracker_view_parent_class)->unmap ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_SCROLLED_WINDOW, GtkScrolledWindow));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _tracker_view_store_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	tracker_view_store_row_changed (self, _sender, path, iter);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


TrackerView* tracker_view_construct (GType object_type, TrackerViewDisplay* _display, TrackerResultStore* store) {
	TrackerView * self = NULL;
	TrackerViewDisplay* _tmp0_ = NULL;
	TrackerResultStore* _tmp1_ = NULL;
	TrackerViewDisplay _tmp6_ = 0;
	TrackerViewDisplay _tmp29_ = 0;
	self = (TrackerView*) g_object_new (object_type, NULL);
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp0_ = _display;
	tracker_view_set_display (self, *_tmp0_);
	_tmp1_ = store;
	if (_tmp1_ != NULL) {
		TrackerResultStore* _tmp2_ = NULL;
		TrackerResultStore* _tmp3_ = NULL;
		TrackerResultStore* _tmp4_ = NULL;
		TrackerResultStore* _tmp5_ = NULL;
		_tmp2_ = store;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp3_;
		_tmp4_ = store;
		g_signal_connect_object ((GtkTreeModel*) _tmp4_, "row-changed", (GCallback) _tracker_view_store_row_changed_gtk_tree_model_row_changed, self, 0);
		_tmp5_ = store;
		g_debug ("tracker-view.vala:101: using store:%p", _tmp5_);
	}
	_tmp6_ = self->priv->_display;
	switch (_tmp6_) {
		case TRACKER_VIEW_DISPLAY_NO_RESULTS:
		{
			GtkLabel* l = NULL;
			GtkLabel* _tmp7_ = NULL;
			GtkLabel* _tmp8_ = NULL;
			gchar* results = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* help_views = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* help_search = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* markup = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			GtkLabel* _tmp22_ = NULL;
			GtkLabel* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			GtkLabel* _tmp25_ = NULL;
			GtkWidget* _tmp26_ = NULL;
			_tmp7_ = (GtkLabel*) gtk_label_new ("");
			g_object_ref_sink (_tmp7_);
			_g_object_unref0 (l);
			l = _tmp7_;
			_tmp8_ = l;
			gtk_label_set_justify (_tmp8_, GTK_JUSTIFY_CENTER);
			_tmp9_ = _ ("No Search Results");
			_tmp10_ = g_strdup (_tmp9_);
			results = _tmp10_;
			_tmp11_ = _ ("Select the view on the toolbar for the content you want, e.g. everythi" \
"ng, files or just images");
			_tmp12_ = g_strdup (_tmp11_);
			help_views = _tmp12_;
			_tmp13_ = _ ("Start to search using the entry box above");
			_tmp14_ = g_strdup (_tmp13_);
			help_search = _tmp14_;
			_tmp15_ = results;
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = help_views;
			_tmp18_ = string_to_string (_tmp17_);
			_tmp19_ = help_search;
			_tmp20_ = string_to_string (_tmp19_);
			_tmp21_ = g_strconcat ("<big>", _tmp16_, "</big>\n\n", _tmp18_, "\n\n", _tmp20_, NULL);
			markup = _tmp21_;
			_tmp22_ = l;
			gtk_label_set_use_markup (_tmp22_, TRUE);
			_tmp23_ = l;
			_tmp24_ = markup;
			gtk_label_set_markup (_tmp23_, _tmp24_);
			_tmp25_ = l;
			_tmp26_ = _g_object_ref0 ((GtkWidget*) _tmp25_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = _tmp26_;
			_g_free0 (markup);
			_g_free0 (help_search);
			_g_free0 (help_views);
			_g_free0 (results);
			_g_object_unref0 (l);
			break;
		}
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			GtkTreeView* _tmp27_ = NULL;
			_tmp27_ = (GtkTreeView*) gtk_tree_view_new ();
			g_object_ref_sink (_tmp27_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = (GtkWidget*) _tmp27_;
			break;
		}
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			GtkIconView* _tmp28_ = NULL;
			_tmp28_ = (GtkIconView*) gtk_icon_view_new ();
			g_object_ref_sink (_tmp28_);
			_g_object_unref0 (self->priv->view);
			self->priv->view = (GtkWidget*) _tmp28_;
			break;
		}
		default:
		break;
	}
	_tmp29_ = self->priv->_display;
	if (_tmp29_ == TRACKER_VIEW_DISPLAY_NO_RESULTS) {
		GtkWidget* _tmp30_ = NULL;
		_tmp30_ = self->priv->view;
		gtk_scrolled_window_add_with_viewport ((GtkScrolledWindow*) self, _tmp30_);
	} else {
		GtkWidget* _tmp31_ = NULL;
		_tmp31_ = self->priv->view;
		gtk_container_add ((GtkContainer*) self, _tmp31_);
		tracker_view_setup_model (self);
		tracker_view_setup_menus (self);
	}
	GTK_WIDGET_CLASS (tracker_view_parent_class)->show_all ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_SCROLLED_WINDOW, GtkScrolledWindow));
	return self;
}


TrackerView* tracker_view_new (TrackerViewDisplay* _display, TrackerResultStore* store) {
	return tracker_view_construct (TRACKER_TYPE_VIEW, _display, store);
}


static void _tracker_view_background_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_background_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void _tracker_view_text_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_text_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void _tracker_view_file_date_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_file_date_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void _tracker_view_file_size_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_file_size_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static gboolean _tracker_view_row_selection_func_gtk_tree_selection_func (GtkTreeSelection* selection, GtkTreeModel* model, GtkTreePath* path, gboolean path_currently_selected, gpointer self) {
	gboolean result;
	result = tracker_view_row_selection_func (self, selection, model, path, path_currently_selected);
	return result;
}


static void _tracker_view_category_detail_renderer_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	tracker_view_category_detail_renderer_func (self, cell_layout, cell, tree_model, iter);
}


static void tracker_view_setup_model (TrackerView* self) {
	TrackerViewDisplay _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	switch (_tmp0_) {
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			{
				GtkIconView* iv = NULL;
				GtkWidget* _tmp1_ = NULL;
				GtkIconView* _tmp2_ = NULL;
				GtkIconView* _tmp3_ = NULL;
				TrackerResultStore* _tmp4_ = NULL;
				TrackerResultStore* _tmp5_ = NULL;
				GtkIconView* _tmp6_ = NULL;
				GtkIconView* _tmp7_ = NULL;
				GtkIconView* _tmp8_ = NULL;
				GtkIconView* _tmp9_ = NULL;
				GtkIconView* _tmp10_ = NULL;
				GtkIconView* _tmp11_ = NULL;
				GtkIconView* _tmp12_ = NULL;
				GtkIconView* _tmp13_ = NULL;
				_tmp1_ = self->priv->view;
				_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_ICON_VIEW, GtkIconView));
				iv = _tmp2_;
				_tmp3_ = iv;
				_tmp4_ = tracker_view_get_store (self);
				_tmp5_ = _tmp4_;
				gtk_icon_view_set_model (_tmp3_, (GtkTreeModel*) _tmp5_);
				_tmp6_ = iv;
				gtk_icon_view_set_item_width (_tmp6_, 128);
				_tmp7_ = iv;
				gtk_icon_view_set_item_padding (_tmp7_, 1);
				_tmp8_ = iv;
				gtk_icon_view_set_row_spacing (_tmp8_, 2);
				_tmp9_ = iv;
				gtk_icon_view_set_column_spacing (_tmp9_, 2);
				_tmp10_ = iv;
				gtk_icon_view_set_selection_mode (_tmp10_, GTK_SELECTION_SINGLE);
				_tmp11_ = iv;
				gtk_icon_view_set_pixbuf_column (_tmp11_, 6);
				_tmp12_ = iv;
				gtk_icon_view_set_text_column (_tmp12_, -1);
				_tmp13_ = iv;
				gtk_icon_view_set_tooltip_column (_tmp13_, 5);
				_g_object_unref0 (iv);
				break;
			}
		}
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			{
				GtkTreeViewColumn* col = NULL;
				GtkTreeView* tv = NULL;
				GtkWidget* _tmp14_ = NULL;
				GtkTreeView* _tmp15_ = NULL;
				GtkTreeView* _tmp16_ = NULL;
				TrackerResultStore* _tmp17_ = NULL;
				TrackerResultStore* _tmp18_ = NULL;
				GtkTreeView* _tmp19_ = NULL;
				GtkTreeView* _tmp20_ = NULL;
				GtkTreeView* _tmp21_ = NULL;
				GtkTreeView* _tmp22_ = NULL;
				GtkCellRendererPixbuf* renderer1 = NULL;
				GtkCellRendererPixbuf* _tmp23_ = NULL;
				GtkCellRendererText* renderer2 = NULL;
				GtkCellRendererText* _tmp24_ = NULL;
				GtkTreeViewColumn* _tmp25_ = NULL;
				GtkTreeViewColumn* _tmp26_ = NULL;
				GtkTreeViewColumn* _tmp27_ = NULL;
				GtkCellRendererPixbuf* _tmp28_ = NULL;
				GtkTreeViewColumn* _tmp29_ = NULL;
				GtkCellRendererPixbuf* _tmp30_ = NULL;
				GtkCellRendererPixbuf* _tmp31_ = NULL;
				GtkCellRendererPixbuf* _tmp32_ = NULL;
				GtkTreeViewColumn* _tmp33_ = NULL;
				GtkCellRendererText* _tmp34_ = NULL;
				GtkCellRendererText* _tmp35_ = NULL;
				GtkCellRendererText* _tmp36_ = NULL;
				GtkTreeViewColumn* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				GtkTreeViewColumn* _tmp39_ = NULL;
				GtkTreeViewColumn* _tmp40_ = NULL;
				GtkTreeViewColumn* _tmp41_ = NULL;
				GtkCellRendererPixbuf* _tmp42_ = NULL;
				GtkTreeViewColumn* _tmp43_ = NULL;
				GtkCellRendererText* _tmp44_ = NULL;
				GtkTreeView* _tmp45_ = NULL;
				GtkTreeViewColumn* _tmp46_ = NULL;
				GtkCellRendererText* renderer3 = NULL;
				GtkCellRendererText* _tmp47_ = NULL;
				GtkCellRendererText* _tmp48_ = NULL;
				GtkTreeViewColumn* _tmp49_ = NULL;
				GtkTreeViewColumn* _tmp50_ = NULL;
				GtkTreeViewColumn* _tmp51_ = NULL;
				GtkCellRendererText* _tmp52_ = NULL;
				GtkTreeViewColumn* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				GtkTreeViewColumn* _tmp55_ = NULL;
				GtkCellRendererText* _tmp56_ = NULL;
				GtkTreeView* _tmp57_ = NULL;
				GtkTreeViewColumn* _tmp58_ = NULL;
				GtkCellRendererText* renderer4 = NULL;
				GtkCellRendererText* _tmp59_ = NULL;
				GtkCellRendererText* _tmp60_ = NULL;
				GtkTreeViewColumn* _tmp61_ = NULL;
				GtkTreeViewColumn* _tmp62_ = NULL;
				GtkTreeViewColumn* _tmp63_ = NULL;
				GtkCellRendererText* _tmp64_ = NULL;
				GtkTreeViewColumn* _tmp65_ = NULL;
				const gchar* _tmp66_ = NULL;
				GtkTreeViewColumn* _tmp67_ = NULL;
				GtkCellRendererText* _tmp68_ = NULL;
				GtkTreeView* _tmp69_ = NULL;
				GtkTreeViewColumn* _tmp70_ = NULL;
				_tmp14_ = self->priv->view;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GTK_TYPE_TREE_VIEW, GtkTreeView));
				tv = _tmp15_;
				_tmp16_ = tv;
				_tmp17_ = tracker_view_get_store (self);
				_tmp18_ = _tmp17_;
				gtk_tree_view_set_model (_tmp16_, (GtkTreeModel*) _tmp18_);
				_tmp19_ = tv;
				gtk_tree_view_set_tooltip_column (_tmp19_, 6);
				_tmp20_ = tv;
				gtk_tree_view_set_rules_hint (_tmp20_, FALSE);
				_tmp21_ = tv;
				gtk_tree_view_set_grid_lines (_tmp21_, GTK_TREE_VIEW_GRID_LINES_VERTICAL);
				_tmp22_ = tv;
				gtk_tree_view_set_headers_visible (_tmp22_, TRUE);
				_tmp23_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
				g_object_ref_sink (_tmp23_);
				renderer1 = _tmp23_;
				_tmp24_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				g_object_ref_sink (_tmp24_);
				renderer2 = _tmp24_;
				_tmp25_ = gtk_tree_view_column_new ();
				g_object_ref_sink (_tmp25_);
				_g_object_unref0 (col);
				col = _tmp25_;
				_tmp26_ = col;
				gtk_tree_view_column_set_sizing (_tmp26_, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
				_tmp27_ = col;
				_tmp28_ = renderer1;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, FALSE);
				_tmp29_ = col;
				_tmp30_ = renderer1;
				gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp29_, (GtkCellRenderer*) _tmp30_, "pixbuf", 7);
				_tmp31_ = renderer1;
				g_object_set ((GtkCellRenderer*) _tmp31_, "xpad", (guint) 5, NULL);
				_tmp32_ = renderer1;
				g_object_set ((GtkCellRenderer*) _tmp32_, "ypad", (guint) 5, NULL);
				_tmp33_ = col;
				_tmp34_ = renderer2;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp33_, (GtkCellRenderer*) _tmp34_, TRUE);
				_tmp35_ = renderer2;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp35_, 2);
				_tmp36_ = renderer2;
				g_object_set (_tmp36_, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
				_tmp37_ = col;
				_tmp38_ = _ ("File");
				gtk_tree_view_column_set_title (_tmp37_, _tmp38_);
				_tmp39_ = col;
				gtk_tree_view_column_set_resizable (_tmp39_, TRUE);
				_tmp40_ = col;
				gtk_tree_view_column_set_expand (_tmp40_, TRUE);
				_tmp41_ = col;
				_tmp42_ = renderer1;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp41_, (GtkCellRenderer*) _tmp42_, _tracker_view_background_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp43_ = col;
				_tmp44_ = renderer2;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp43_, (GtkCellRenderer*) _tmp44_, _tracker_view_text_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp45_ = tv;
				_tmp46_ = col;
				gtk_tree_view_append_column (_tmp45_, _tmp46_);
				_tmp47_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				g_object_ref_sink (_tmp47_);
				renderer3 = _tmp47_;
				_tmp48_ = renderer3;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp48_, 2);
				_tmp49_ = gtk_tree_view_column_new ();
				g_object_ref_sink (_tmp49_);
				_g_object_unref0 (col);
				col = _tmp49_;
				_tmp50_ = col;
				gtk_tree_view_column_set_sizing (_tmp50_, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
				_tmp51_ = col;
				_tmp52_ = renderer3;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp51_, (GtkCellRenderer*) _tmp52_, TRUE);
				_tmp53_ = col;
				_tmp54_ = _ ("Last Changed");
				gtk_tree_view_column_set_title (_tmp53_, _tmp54_);
				_tmp55_ = col;
				_tmp56_ = renderer3;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp55_, (GtkCellRenderer*) _tmp56_, _tracker_view_file_date_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp57_ = tv;
				_tmp58_ = col;
				gtk_tree_view_append_column (_tmp57_, _tmp58_);
				_tmp59_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				g_object_ref_sink (_tmp59_);
				renderer4 = _tmp59_;
				_tmp60_ = renderer4;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp60_, 2);
				_tmp61_ = gtk_tree_view_column_new ();
				g_object_ref_sink (_tmp61_);
				_g_object_unref0 (col);
				col = _tmp61_;
				_tmp62_ = col;
				gtk_tree_view_column_set_sizing (_tmp62_, GTK_TREE_VIEW_COLUMN_AUTOSIZE);
				_tmp63_ = col;
				_tmp64_ = renderer4;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp63_, (GtkCellRenderer*) _tmp64_, TRUE);
				_tmp65_ = col;
				_tmp66_ = _ ("Size");
				gtk_tree_view_column_set_title (_tmp65_, _tmp66_);
				_tmp67_ = col;
				_tmp68_ = renderer4;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp67_, (GtkCellRenderer*) _tmp68_, _tracker_view_file_size_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp69_ = tv;
				_tmp70_ = col;
				gtk_tree_view_append_column (_tmp69_, _tmp70_);
				_g_object_unref0 (renderer4);
				_g_object_unref0 (renderer3);
				_g_object_unref0 (renderer2);
				_g_object_unref0 (renderer1);
				_g_object_unref0 (tv);
				_g_object_unref0 (col);
				break;
			}
		}
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		{
			{
				GtkTreeViewColumn* col = NULL;
				GtkTreeView* tv = NULL;
				GtkWidget* _tmp71_ = NULL;
				GtkTreeView* _tmp72_ = NULL;
				GtkTreeSelection* selection = NULL;
				GtkTreeView* _tmp73_ = NULL;
				TrackerResultStore* _tmp74_ = NULL;
				TrackerResultStore* _tmp75_ = NULL;
				GtkTreeView* _tmp76_ = NULL;
				GtkTreeView* _tmp77_ = NULL;
				GtkTreeView* _tmp78_ = NULL;
				GtkTreeView* _tmp79_ = NULL;
				GtkTreeView* _tmp80_ = NULL;
				GtkTreeView* _tmp81_ = NULL;
				GtkTreeSelection* _tmp82_ = NULL;
				GtkTreeSelection* _tmp83_ = NULL;
				GtkTreeSelection* _tmp84_ = NULL;
				GtkTreeViewColumn* _tmp85_ = NULL;
				GtkTreeViewColumn* _tmp86_ = NULL;
				GtkTreeViewColumn* _tmp87_ = NULL;
				GtkCellRendererPixbuf* renderer1 = NULL;
				GtkCellRendererPixbuf* _tmp88_ = NULL;
				GtkTreeViewColumn* _tmp89_ = NULL;
				GtkCellRendererPixbuf* _tmp90_ = NULL;
				GtkTreeViewColumn* _tmp91_ = NULL;
				GtkCellRendererPixbuf* _tmp92_ = NULL;
				GtkTreeViewColumn* _tmp93_ = NULL;
				GtkCellRendererPixbuf* _tmp94_ = NULL;
				GtkCellRendererPixbuf* _tmp95_ = NULL;
				GtkCellRendererPixbuf* _tmp96_ = NULL;
				GtkCellRendererText* renderer2 = NULL;
				GtkCellRendererText* _tmp97_ = NULL;
				GtkTreeViewColumn* _tmp98_ = NULL;
				GtkCellRendererText* _tmp99_ = NULL;
				GtkTreeViewColumn* _tmp100_ = NULL;
				GtkCellRendererText* _tmp101_ = NULL;
				GtkCellRendererText* _tmp102_ = NULL;
				GtkCellRendererText* _tmp103_ = NULL;
				GtkTreeView* _tmp104_ = NULL;
				GtkTreeViewColumn* _tmp105_ = NULL;
				GtkCellRendererText* renderer4 = NULL;
				GtkCellRendererText* _tmp106_ = NULL;
				GtkCellRendererText* _tmp107_ = NULL;
				GtkCellRendererText* _tmp108_ = NULL;
				GtkCellRendererText* _tmp109_ = NULL;
				GtkTreeViewColumn* _tmp110_ = NULL;
				GtkTreeViewColumn* _tmp111_ = NULL;
				GtkTreeViewColumn* _tmp112_ = NULL;
				GtkTreeViewColumn* _tmp113_ = NULL;
				GtkCellRendererText* _tmp114_ = NULL;
				GtkTreeViewColumn* _tmp115_ = NULL;
				GtkCellRendererText* _tmp116_ = NULL;
				GtkTreeView* _tmp117_ = NULL;
				GtkTreeViewColumn* _tmp118_ = NULL;
				_tmp71_ = self->priv->view;
				_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GTK_TYPE_TREE_VIEW, GtkTreeView));
				tv = _tmp72_;
				_tmp73_ = tv;
				_tmp74_ = tracker_view_get_store (self);
				_tmp75_ = _tmp74_;
				gtk_tree_view_set_model (_tmp73_, (GtkTreeModel*) _tmp75_);
				_tmp76_ = tv;
				gtk_tree_view_set_tooltip_column (_tmp76_, 5);
				_tmp77_ = tv;
				gtk_tree_view_set_rules_hint (_tmp77_, FALSE);
				_tmp78_ = tv;
				gtk_tree_view_set_grid_lines (_tmp78_, GTK_TREE_VIEW_GRID_LINES_NONE);
				_tmp79_ = tv;
				gtk_tree_view_set_headers_visible (_tmp79_, FALSE);
				_tmp80_ = tv;
				gtk_tree_view_set_show_expanders (_tmp80_, FALSE);
				_tmp81_ = tv;
				_tmp82_ = gtk_tree_view_get_selection (_tmp81_);
				_tmp83_ = _g_object_ref0 (_tmp82_);
				_g_object_unref0 (selection);
				selection = _tmp83_;
				_tmp84_ = selection;
				gtk_tree_selection_set_select_function (_tmp84_, _tracker_view_row_selection_func_gtk_tree_selection_func, g_object_ref (self), g_object_unref);
				_tmp85_ = gtk_tree_view_column_new ();
				g_object_ref_sink (_tmp85_);
				_g_object_unref0 (col);
				col = _tmp85_;
				_tmp86_ = col;
				gtk_tree_view_column_set_sizing (_tmp86_, GTK_TREE_VIEW_COLUMN_FIXED);
				_tmp87_ = col;
				gtk_tree_view_column_set_expand (_tmp87_, TRUE);
				_tmp88_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
				g_object_ref_sink (_tmp88_);
				renderer1 = _tmp88_;
				_tmp89_ = col;
				_tmp90_ = renderer1;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp89_, (GtkCellRenderer*) _tmp90_, FALSE);
				_tmp91_ = col;
				_tmp92_ = renderer1;
				gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp91_, (GtkCellRenderer*) _tmp92_, "pixbuf", 6);
				_tmp93_ = col;
				_tmp94_ = renderer1;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp93_, (GtkCellRenderer*) _tmp94_, _tracker_view_background_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp95_ = renderer1;
				g_object_set ((GtkCellRenderer*) _tmp95_, "xpad", (guint) 5, NULL);
				_tmp96_ = renderer1;
				g_object_set ((GtkCellRenderer*) _tmp96_, "ypad", (guint) 5, NULL);
				_tmp97_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				g_object_ref_sink (_tmp97_);
				renderer2 = _tmp97_;
				_tmp98_ = col;
				_tmp99_ = renderer2;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp98_, (GtkCellRenderer*) _tmp99_, TRUE);
				_tmp100_ = col;
				_tmp101_ = renderer2;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp100_, (GtkCellRenderer*) _tmp101_, _tracker_view_text_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp102_ = renderer2;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp102_, 2);
				_tmp103_ = renderer2;
				g_object_set (_tmp103_, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
				_tmp104_ = tv;
				_tmp105_ = col;
				gtk_tree_view_append_column (_tmp104_, _tmp105_);
				_tmp106_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
				g_object_ref_sink (_tmp106_);
				renderer4 = _tmp106_;
				_tmp107_ = renderer4;
				gtk_cell_renderer_text_set_fixed_height_from_font (_tmp107_, 2);
				_tmp108_ = renderer4;
				g_object_set (_tmp108_, "alignment", PANGO_ALIGN_RIGHT, NULL);
				_tmp109_ = renderer4;
				g_object_set ((GtkCellRenderer*) _tmp109_, "xalign", (gfloat) 1, NULL);
				_tmp110_ = gtk_tree_view_column_new ();
				g_object_ref_sink (_tmp110_);
				_g_object_unref0 (col);
				col = _tmp110_;
				_tmp111_ = col;
				gtk_tree_view_column_set_min_width (_tmp111_, 80);
				_tmp112_ = col;
				gtk_tree_view_column_set_sizing (_tmp112_, GTK_TREE_VIEW_COLUMN_FIXED);
				_tmp113_ = col;
				_tmp114_ = renderer4;
				gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp113_, (GtkCellRenderer*) _tmp114_, TRUE);
				_tmp115_ = col;
				_tmp116_ = renderer4;
				gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp115_, (GtkCellRenderer*) _tmp116_, _tracker_view_category_detail_renderer_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
				_tmp117_ = tv;
				_tmp118_ = col;
				gtk_tree_view_append_column (_tmp117_, _tmp118_);
				_g_object_unref0 (renderer4);
				_g_object_unref0 (renderer2);
				_g_object_unref0 (renderer1);
				_g_object_unref0 (selection);
				_g_object_unref0 (tv);
				_g_object_unref0 (col);
				break;
			}
		}
		default:
		break;
	}
}


static void tracker_view_background_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	GdkColor color = {0};
	GtkStyle* style = NULL;
	GtkTreePath* path = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkStyle* _tmp1_ = NULL;
	GtkStyle* _tmp2_ = NULL;
	GtkStyle* _tmp3_ = NULL;
	GdkColor* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GdkColor _tmp5_ = {0};
	gint sum_normal = 0;
	GdkColor _tmp6_ = {0};
	guint16 _tmp7_ = 0U;
	GdkColor _tmp8_ = {0};
	guint16 _tmp9_ = 0U;
	GdkColor _tmp10_ = {0};
	guint16 _tmp11_ = 0U;
	GtkStyle* _tmp12_ = NULL;
	GdkColor* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	GdkColor _tmp14_ = {0};
	gint sum_selected = 0;
	GdkColor _tmp15_ = {0};
	guint16 _tmp16_ = 0U;
	GdkColor _tmp17_ = {0};
	guint16 _tmp18_ = 0U;
	GdkColor _tmp19_ = {0};
	guint16 _tmp20_ = 0U;
	GtkStyle* _tmp21_ = NULL;
	GdkColor* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	GdkColor _tmp23_ = {0};
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GtkTreeModel* _tmp56_ = NULL;
	GtkTreeIter _tmp57_ = {0};
	GtkTreePath* _tmp58_ = NULL;
	GtkTreePath* _tmp59_ = NULL;
	gint _tmp60_ = 0;
	gint* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = gtk_widget_get_style (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (style);
	style = _tmp2_;
	_tmp3_ = style;
	_tmp4_ = _tmp3_->base;
	_tmp4__length1 = -1;
	_tmp5_ = _tmp4_[GTK_STATE_SELECTED];
	color = _tmp5_;
	_tmp6_ = color;
	_tmp7_ = _tmp6_.red;
	_tmp8_ = color;
	_tmp9_ = _tmp8_.green;
	_tmp10_ = color;
	_tmp11_ = _tmp10_.blue;
	sum_normal = (gint) ((_tmp7_ + _tmp9_) + _tmp11_);
	_tmp12_ = style;
	_tmp13_ = _tmp12_->base;
	_tmp13__length1 = -1;
	_tmp14_ = _tmp13_[GTK_STATE_NORMAL];
	color = _tmp14_;
	_tmp15_ = color;
	_tmp16_ = _tmp15_.red;
	_tmp17_ = color;
	_tmp18_ = _tmp17_.green;
	_tmp19_ = color;
	_tmp20_ = _tmp19_.blue;
	sum_selected = (gint) ((_tmp16_ + _tmp18_) + _tmp20_);
	_tmp21_ = style;
	_tmp22_ = _tmp21_->text_aa;
	_tmp22__length1 = -1;
	_tmp23_ = _tmp22_[GTK_STATE_INSENSITIVE];
	color = _tmp23_;
	_tmp24_ = sum_normal;
	_tmp25_ = sum_selected;
	if (_tmp24_ < _tmp25_) {
		GdkColor _tmp26_ = {0};
		guint16 _tmp27_ = 0U;
		GtkStyle* _tmp28_ = NULL;
		GdkColor _tmp29_ = {0};
		guint16 _tmp30_ = 0U;
		GdkColor _tmp31_ = {0};
		guint16 _tmp32_ = 0U;
		GtkStyle* _tmp33_ = NULL;
		GdkColor _tmp34_ = {0};
		guint16 _tmp35_ = 0U;
		GdkColor _tmp36_ = {0};
		guint16 _tmp37_ = 0U;
		GtkStyle* _tmp38_ = NULL;
		GdkColor _tmp39_ = {0};
		guint16 _tmp40_ = 0U;
		_tmp26_ = color;
		_tmp27_ = _tmp26_.red;
		_tmp28_ = style;
		_tmp29_ = _tmp28_->white;
		_tmp30_ = _tmp29_.red;
		color.red = (guint16) ((_tmp27_ + _tmp30_) / 2);
		_tmp31_ = color;
		_tmp32_ = _tmp31_.green;
		_tmp33_ = style;
		_tmp34_ = _tmp33_->white;
		_tmp35_ = _tmp34_.green;
		color.green = (guint16) ((_tmp32_ + _tmp35_) / 2);
		_tmp36_ = color;
		_tmp37_ = _tmp36_.blue;
		_tmp38_ = style;
		_tmp39_ = _tmp38_->white;
		_tmp40_ = _tmp39_.blue;
		color.blue = (guint16) ((_tmp37_ + _tmp40_) / 2);
	} else {
		GdkColor _tmp41_ = {0};
		guint16 _tmp42_ = 0U;
		GtkStyle* _tmp43_ = NULL;
		GdkColor _tmp44_ = {0};
		guint16 _tmp45_ = 0U;
		GdkColor _tmp46_ = {0};
		guint16 _tmp47_ = 0U;
		GtkStyle* _tmp48_ = NULL;
		GdkColor _tmp49_ = {0};
		guint16 _tmp50_ = 0U;
		GdkColor _tmp51_ = {0};
		guint16 _tmp52_ = 0U;
		GtkStyle* _tmp53_ = NULL;
		GdkColor _tmp54_ = {0};
		guint16 _tmp55_ = 0U;
		_tmp41_ = color;
		_tmp42_ = _tmp41_.red;
		_tmp43_ = style;
		_tmp44_ = _tmp43_->black;
		_tmp45_ = _tmp44_.red;
		color.red = (guint16) ((_tmp42_ + _tmp45_) / 2);
		_tmp46_ = color;
		_tmp47_ = _tmp46_.green;
		_tmp48_ = style;
		_tmp49_ = _tmp48_->black;
		_tmp50_ = _tmp49_.green;
		color.green = (guint16) ((_tmp47_ + _tmp50_) / 2);
		_tmp51_ = color;
		_tmp52_ = _tmp51_.blue;
		_tmp53_ = style;
		_tmp54_ = _tmp53_->black;
		_tmp55_ = _tmp54_.blue;
		color.blue = (guint16) ((_tmp52_ + _tmp55_) / 2);
	}
	_tmp56_ = tree_model;
	_tmp57_ = *iter;
	_tmp58_ = gtk_tree_model_get_path (_tmp56_, &_tmp57_);
	_gtk_tree_path_free0 (path);
	path = _tmp58_;
	_tmp59_ = path;
	_tmp61_ = gtk_tree_path_get_indices_with_depth (_tmp59_, &_tmp60_);
	_tmp62_ = _tmp61_[0];
	if ((_tmp62_ % 2) != 0) {
		GtkCellRenderer* _tmp63_ = NULL;
		GdkColor _tmp64_ = {0};
		_tmp63_ = cell;
		_tmp64_ = color;
		g_object_set ((GObject*) _tmp63_, "cell-background-gdk", &_tmp64_, NULL);
	} else {
		GtkCellRenderer* _tmp65_ = NULL;
		_tmp65_ = cell;
		g_object_set ((GObject*) _tmp65_, "cell-background-gdk", NULL, NULL);
	}
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (style);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally31;
	__catch31_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void tracker_view_text_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	gchar* text = NULL;
	gchar* subtext = NULL;
	gchar* markup = NULL;
	gint n_children = 0;
	GtkCellLayout* _tmp0_ = NULL;
	GtkCellRenderer* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkCellRenderer* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	markup = NULL;
	_tmp0_ = cell_layout;
	_tmp1_ = cell;
	_tmp2_ = tree_model;
	_tmp3_ = *iter;
	tracker_view_background_renderer_func (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = tree_model;
	_tmp5_ = *iter;
	_tmp6_ = gtk_tree_model_iter_n_children (_tmp4_, &_tmp5_);
	n_children = _tmp6_;
	_tmp7_ = n_children;
	if (_tmp7_ > 0) {
		TrackerQueryType type = 0;
		gchar* cat = NULL;
		GtkTreeModel* _tmp8_ = NULL;
		GtkTreeIter _tmp9_ = {0};
		TrackerQueryType _tmp10_ = 0;
		const gchar* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		cat = NULL;
		_tmp8_ = tree_model;
		_tmp9_ = *iter;
		gtk_tree_model_get (_tmp8_, &_tmp9_, 7, &type, -1, -1);
		_tmp10_ = type;
		switch (_tmp10_) {
			case TRACKER_QUERY_TYPE_APPLICATIONS:
			{
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				_tmp11_ = _ ("Applications");
				_tmp12_ = g_strdup (_tmp11_);
				_g_free0 (cat);
				cat = _tmp12_;
				break;
			}
			case TRACKER_QUERY_TYPE_MUSIC:
			{
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				_tmp13_ = _ ("Music");
				_tmp14_ = g_strdup (_tmp13_);
				_g_free0 (cat);
				cat = _tmp14_;
				break;
			}
			case TRACKER_QUERY_TYPE_IMAGES:
			{
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				_tmp15_ = _ ("Images");
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (cat);
				cat = _tmp16_;
				break;
			}
			case TRACKER_QUERY_TYPE_VIDEOS:
			{
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				_tmp17_ = _ ("Videos");
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (cat);
				cat = _tmp18_;
				break;
			}
			case TRACKER_QUERY_TYPE_DOCUMENTS:
			{
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				_tmp19_ = _ ("Documents");
				_tmp20_ = g_strdup (_tmp19_);
				_g_free0 (cat);
				cat = _tmp20_;
				break;
			}
			case TRACKER_QUERY_TYPE_MAIL:
			{
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				_tmp21_ = _ ("Mail");
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (cat);
				cat = _tmp22_;
				break;
			}
			case TRACKER_QUERY_TYPE_FOLDERS:
			{
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_ = NULL;
				_tmp23_ = _ ("Folders");
				_tmp24_ = g_strdup (_tmp23_);
				_g_free0 (cat);
				cat = _tmp24_;
				break;
			}
			case TRACKER_QUERY_TYPE_BOOKMARKS:
			{
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				_tmp25_ = _ ("Bookmarks");
				_tmp26_ = g_strdup (_tmp25_);
				_g_free0 (cat);
				cat = _tmp26_;
				break;
			}
			default:
			break;
		}
		_tmp27_ = cat;
		_tmp28_ = n_children;
		_tmp29_ = _ ("Items");
		_tmp30_ = g_strdup_printf ("<b><big>%s</big></b> <small>(%d %s)</small>", _tmp27_, _tmp28_, _tmp29_);
		_g_free0 (markup);
		markup = _tmp30_;
		_g_free0 (cat);
	} else {
		GtkTreeModel* _tmp31_ = NULL;
		GtkTreeIter _tmp32_ = {0};
		const gchar* _tmp33_ = NULL;
		_tmp31_ = tree_model;
		_tmp32_ = *iter;
		gtk_tree_model_get (_tmp31_, &_tmp32_, 2, &text, 3, &subtext, -1, -1);
		_tmp33_ = text;
		if (_tmp33_ != NULL) {
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			_tmp34_ = text;
			_tmp35_ = g_markup_escape_text (_tmp34_, (gssize) (-1));
			_g_free0 (markup);
			markup = _tmp35_;
			_tmp36_ = subtext;
			if (_tmp36_ != NULL) {
				const gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				_tmp37_ = subtext;
				_tmp38_ = string_replace (_tmp37_, "\n", " ");
				_g_free0 (subtext);
				subtext = _tmp38_;
				_tmp39_ = markup;
				_tmp40_ = subtext;
				_tmp41_ = g_markup_escape_text (_tmp40_, (gssize) (-1));
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("\n<small><span color='grey'>%s</span></small>", _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = g_strconcat (_tmp39_, _tmp44_, NULL);
				_g_free0 (markup);
				markup = _tmp45_;
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
			}
		} else {
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
			_tmp46_ = _ ("Loading…");
			_tmp47_ = g_strdup_printf ("<span color='grey'>%s</span>\n", _tmp46_);
			_g_free0 (markup);
			markup = _tmp47_;
		}
	}
	_tmp48_ = cell;
	_tmp49_ = markup;
	g_object_set ((GObject*) _tmp48_, "markup", _tmp49_, NULL);
	_g_free0 (markup);
	_g_free0 (subtext);
	_g_free0 (text);
}


static void tracker_view_file_size_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	gchar* size = NULL;
	GtkCellLayout* _tmp0_ = NULL;
	GtkCellRenderer* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	const gchar* _tmp6_ = NULL;
	GtkCellRenderer* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = cell_layout;
	_tmp1_ = cell;
	_tmp2_ = tree_model;
	_tmp3_ = *iter;
	tracker_view_background_renderer_func (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = tree_model;
	_tmp5_ = *iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 4, &size, -1, -1);
	_tmp6_ = size;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		_tmp7_ = size;
		_tmp8_ = atoi (_tmp7_);
		_tmp9_ = g_format_size_for_display ((gint64) _tmp8_);
		_g_free0 (size);
		size = _tmp9_;
	}
	_tmp10_ = cell;
	_tmp11_ = size;
	g_object_set ((GObject*) _tmp10_, "text", _tmp11_, NULL);
	_g_free0 (size);
}


static void tracker_view_file_date_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	gchar* date = NULL;
	GtkCellLayout* _tmp0_ = NULL;
	GtkCellRenderer* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	const gchar* _tmp6_ = NULL;
	GtkCellRenderer* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = cell_layout;
	_tmp1_ = cell;
	_tmp2_ = tree_model;
	_tmp3_ = *iter;
	tracker_view_background_renderer_func (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = tree_model;
	_tmp5_ = *iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 5, &date, -1, -1);
	_tmp6_ = date;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp7_ = date;
		_tmp8_ = tracker_time_format_from_iso8601 (_tmp7_);
		_g_free0 (date);
		date = _tmp8_;
	}
	_tmp9_ = cell;
	_tmp10_ = date;
	g_object_set ((GObject*) _tmp9_, "text", _tmp10_, NULL);
	_g_free0 (date);
}


static void tracker_view_category_detail_renderer_func (TrackerView* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	TrackerQueryType category = 0;
	gchar* markup = NULL;
	gchar* detail = NULL;
	GtkCellLayout* _tmp0_ = NULL;
	GtkCellRenderer* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	const gchar* _tmp6_ = NULL;
	TrackerQueryType _tmp8_ = 0;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GtkCellRenderer* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	markup = NULL;
	_tmp0_ = cell_layout;
	_tmp1_ = cell;
	_tmp2_ = tree_model;
	_tmp3_ = *iter;
	tracker_view_background_renderer_func (self, _tmp0_, _tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = tree_model;
	_tmp5_ = *iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 4, &detail, 7, &category, -1, -1);
	_tmp6_ = detail;
	if (_tmp6_ == NULL) {
		GtkCellRenderer* _tmp7_ = NULL;
		_tmp7_ = cell;
		g_object_set ((GObject*) _tmp7_, "markup", NULL, NULL);
		_g_free0 (detail);
		_g_free0 (markup);
		return;
	}
	_tmp8_ = category;
	switch (_tmp8_) {
		case TRACKER_QUERY_TYPE_FOLDERS:
		case TRACKER_QUERY_TYPE_MAIL:
		case TRACKER_QUERY_TYPE_BOOKMARKS:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp9_ = detail;
			_tmp10_ = tracker_time_format_from_iso8601 (_tmp9_);
			_g_free0 (detail);
			detail = _tmp10_;
			break;
		}
		case TRACKER_QUERY_TYPE_MUSIC:
		case TRACKER_QUERY_TYPE_VIDEOS:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			_tmp11_ = detail;
			_tmp12_ = tracker_time_format_from_seconds (_tmp11_);
			_g_free0 (detail);
			detail = _tmp12_;
			break;
		}
		case TRACKER_QUERY_TYPE_DOCUMENTS:
		{
			const gchar* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gchar* _tmp18_ = NULL;
			_tmp13_ = detail;
			_tmp14_ = atoi (_tmp13_);
			_tmp15_ = ngettext ("%d Page", "%d Pages", (gulong) _tmp14_);
			_tmp16_ = detail;
			_tmp17_ = atoi (_tmp16_);
			_tmp18_ = g_strdup_printf (_tmp15_, _tmp17_);
			_g_free0 (detail);
			detail = _tmp18_;
			break;
		}
		case TRACKER_QUERY_TYPE_IMAGES:
		{
			const gchar* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gchar* _tmp21_ = NULL;
			_tmp19_ = detail;
			_tmp20_ = atoi (_tmp19_);
			_tmp21_ = g_format_size_for_display ((gint64) _tmp20_);
			_g_free0 (detail);
			detail = _tmp21_;
			break;
		}
		default:
		break;
	}
	_tmp22_ = detail;
	_tmp23_ = g_markup_escape_text (_tmp22_, (gssize) (-1));
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf ("<span color='grey'><small>%s</small></span>", _tmp24_);
	_g_free0 (markup);
	markup = _tmp25_;
	_g_free0 (_tmp24_);
	_tmp26_ = cell;
	_tmp27_ = markup;
	g_object_set ((GObject*) _tmp26_, "markup", _tmp27_, NULL);
	_g_free0 (detail);
	_g_free0 (markup);
}


static gboolean _tracker_view_view_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = tracker_view_view_button_press_event (self, _sender, event);
	return result;
}


static void _tracker_view_context_menu_directory_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	tracker_view_context_menu_directory_clicked (self);
}


static void _tracker_view_context_menu_tags_clicked_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	tracker_view_context_menu_tags_clicked (self);
}


static void tracker_view_setup_menus (TrackerView* self) {
	GtkWidget* _tmp0_ = NULL;
	GtkMenu* _tmp1_ = NULL;
	GtkMenuItem* item = NULL;
	const gchar* _tmp2_ = NULL;
	GtkMenuItem* _tmp3_ = NULL;
	GtkMenuItem* _tmp4_ = NULL;
	GtkMenu* _tmp5_ = NULL;
	GtkMenuItem* _tmp6_ = NULL;
	GtkSeparatorMenuItem* separator = NULL;
	GtkSeparatorMenuItem* _tmp7_ = NULL;
	GtkMenu* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkMenuItem* _tmp10_ = NULL;
	GtkMenuItem* _tmp11_ = NULL;
	GtkMenu* _tmp12_ = NULL;
	GtkMenuItem* _tmp13_ = NULL;
	GtkMenu* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view;
	g_signal_connect_object (_tmp0_, "button-press-event", (GCallback) _tracker_view_view_button_press_event_gtk_widget_button_press_event, self, 0);
	_tmp1_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->context_menu);
	self->priv->context_menu = _tmp1_;
	_tmp2_ = _ ("_Show Parent Directory");
	_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp2_);
	g_object_ref_sink (_tmp3_);
	item = _tmp3_;
	_tmp4_ = item;
	g_signal_connect_object (_tmp4_, "activate", (GCallback) _tracker_view_context_menu_directory_clicked_gtk_menu_item_activate, self, 0);
	_tmp5_ = self->priv->context_menu;
	_tmp6_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp7_);
	separator = _tmp7_;
	_tmp8_ = self->priv->context_menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, (GtkWidget*) ((GtkMenuItem*) separator));
	_tmp9_ = _ ("_Tags…");
	_tmp10_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (item);
	item = _tmp10_;
	_tmp11_ = item;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) _tracker_view_context_menu_tags_clicked_gtk_menu_item_activate, self, 0);
	_tmp12_ = self->priv->context_menu;
	_tmp13_ = item;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->context_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp14_);
	_g_object_unref0 (separator);
	_g_object_unref0 (item);
}


static gboolean tracker_view_view_button_press_event (TrackerView* self, GtkWidget* widget, GdkEventButton* event) {
	gboolean result = FALSE;
	GdkEventButton _tmp0_ = {0};
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.button;
	if (_tmp1_ == ((guint) 3)) {
		GtkTreePath* _tmp2_ = NULL;
		GtkTreePath* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = tracker_view_get_selected_path (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_ != NULL;
		_gtk_tree_path_free0 (_tmp3_);
		if (_tmp4_) {
			GtkMenu* _tmp5_ = NULL;
			GdkEventButton _tmp6_ = {0};
			guint _tmp7_ = 0U;
			GdkEventButton _tmp8_ = {0};
			guint32 _tmp9_ = 0U;
			_tmp5_ = self->priv->context_menu;
			_tmp6_ = *event;
			_tmp7_ = _tmp6_.button;
			_tmp8_ = *event;
			_tmp9_ = _tmp8_.time;
			gtk_menu_popup (_tmp5_, NULL, NULL, NULL, NULL, _tmp7_, _tmp9_);
		}
	}
	result = FALSE;
	return result;
}


static GtkTreeModel* tracker_view_get_model (TrackerView* self) {
	GtkTreeModel* result = NULL;
	TrackerViewDisplay _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	switch (_tmp0_) {
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			GtkTreeView* v = NULL;
			GtkWidget* _tmp1_ = NULL;
			GtkTreeView* _tmp2_ = NULL;
			GtkTreeView* _tmp3_ = NULL;
			GtkTreeModel* _tmp4_ = NULL;
			GtkTreeModel* _tmp5_ = NULL;
			_tmp1_ = self->priv->view;
			_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_TREE_VIEW, GtkTreeView));
			v = _tmp2_;
			_tmp3_ = v;
			_tmp4_ = gtk_tree_view_get_model (_tmp3_);
			_tmp5_ = _g_object_ref0 (_tmp4_);
			result = _tmp5_;
			_g_object_unref0 (v);
			return result;
		}
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			GtkIconView* v = NULL;
			GtkWidget* _tmp6_ = NULL;
			GtkIconView* _tmp7_ = NULL;
			GtkIconView* _tmp8_ = NULL;
			GtkTreeModel* _tmp9_ = NULL;
			GtkTreeModel* _tmp10_ = NULL;
			_tmp6_ = self->priv->view;
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_ICON_VIEW, GtkIconView));
			v = _tmp7_;
			_tmp8_ = v;
			_tmp9_ = gtk_icon_view_get_model (_tmp8_);
			_tmp10_ = _g_object_ref0 (_tmp9_);
			result = _tmp10_;
			_g_object_unref0 (v);
			return result;
		}
		default:
		{
			break;
		}
	}
	result = NULL;
	return result;
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static GtkTreePath* tracker_view_get_selected_path (TrackerView* self) {
	GtkTreePath* result = NULL;
	TrackerViewDisplay _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	switch (_tmp0_) {
		case TRACKER_VIEW_DISPLAY_CATEGORIES:
		case TRACKER_VIEW_DISPLAY_FILE_LIST:
		{
			GtkTreeView* v = NULL;
			GtkWidget* _tmp1_ = NULL;
			GtkTreeView* _tmp2_ = NULL;
			GtkTreeSelection* s = NULL;
			GtkTreeView* _tmp3_ = NULL;
			GtkTreeSelection* _tmp4_ = NULL;
			GtkTreeSelection* _tmp5_ = NULL;
			GList* selected = NULL;
			GtkTreeSelection* _tmp6_ = NULL;
			GList* _tmp7_ = NULL;
			GList* _tmp8_ = NULL;
			gconstpointer _tmp9_ = NULL;
			GtkTreePath* _tmp10_ = NULL;
			_tmp1_ = self->priv->view;
			_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_TREE_VIEW, GtkTreeView));
			v = _tmp2_;
			_tmp3_ = v;
			_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
			_tmp5_ = _g_object_ref0 (_tmp4_);
			s = _tmp5_;
			_tmp6_ = s;
			_tmp7_ = gtk_tree_selection_get_selected_rows (_tmp6_, NULL);
			selected = _tmp7_;
			_tmp8_ = selected;
			_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
			_tmp10_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp9_);
			result = _tmp10_;
			__g_list_free__gtk_tree_path_free0_0 (selected);
			_g_object_unref0 (s);
			_g_object_unref0 (v);
			return result;
		}
		case TRACKER_VIEW_DISPLAY_FILE_ICONS:
		{
			GtkIconView* v = NULL;
			GtkWidget* _tmp11_ = NULL;
			GtkIconView* _tmp12_ = NULL;
			GList* selected = NULL;
			GtkIconView* _tmp13_ = NULL;
			GList* _tmp14_ = NULL;
			GList* _tmp15_ = NULL;
			gconstpointer _tmp16_ = NULL;
			GtkTreePath* _tmp17_ = NULL;
			_tmp11_ = self->priv->view;
			_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GTK_TYPE_ICON_VIEW, GtkIconView));
			v = _tmp12_;
			_tmp13_ = v;
			_tmp14_ = gtk_icon_view_get_selected_items (_tmp13_);
			selected = _tmp14_;
			_tmp15_ = selected;
			_tmp16_ = g_list_nth_data (_tmp15_, (guint) 0);
			_tmp17_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp16_);
			result = _tmp17_;
			__g_list_free__gtk_tree_path_free0_0 (selected);
			_g_object_unref0 (v);
			return result;
		}
		default:
		{
			break;
		}
	}
	result = NULL;
	return result;
}


static void tracker_view_context_menu_directory_clicked (TrackerView* self) {
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_view_get_model (self);
	model = _tmp0_;
	_tmp1_ = tracker_view_get_selected_path (self);
	path = _tmp1_;
	tracker_model_launch_selected_parent_dir (model, path, 1);
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (model);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		TrackerView * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda5_ (Block5Data* _data5_) {
	TrackerView * self;
	GtkDialog* _tmp0_ = NULL;
	self = _data5_->self;
	_tmp0_ = _data5_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void ___lambda5__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda5_ (self);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void tracker_view_context_menu_tags_clicked (TrackerView* self) {
	Block5Data* _data5_;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	const gchar* uri = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GtkDialog* _tmp14_ = NULL;
	GList* files = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GtkVBox* vbox = NULL;
	GList* _tmp17_ = NULL;
	TrackerTagsView* _tmp18_ = NULL;
	GtkBox* content = NULL;
	GtkDialog* _tmp19_ = NULL;
	GtkBox* _tmp20_ = NULL;
	GtkBox* _tmp21_ = NULL;
	GtkBox* _tmp22_ = NULL;
	GtkVBox* _tmp23_ = NULL;
	GtkBox* _tmp24_ = NULL;
	GtkDialog* _tmp25_ = NULL;
	GtkDialog* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = tracker_view_get_model (self);
	model = _tmp0_;
	_tmp1_ = tracker_view_get_selected_path (self);
	path = _tmp1_;
	_tmp2_ = model;
	_tmp3_ = path;
	gtk_tree_model_get_iter (_tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	_tmp5_ = model;
	_tmp6_ = iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &uri, -1);
	_tmp7_ = uri;
	if (_tmp7_ == NULL) {
		_gtk_tree_path_free0 (path);
		_g_object_unref0 (model);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp8_ = uri;
	g_debug ("tracker-view.vala:536: Showing tags dialog for uri:'%s'", _tmp8_);
	_tmp9_ = _ ("Tags");
	_tmp10_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp11_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GTK_TYPE_WINDOW, GtkWindow), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL, NULL);
	g_object_ref_sink (_tmp11_);
	_data5_->dialog = _tmp11_;
	_tmp12_ = _data5_->dialog;
	gtk_window_set_default_size ((GtkWindow*) _tmp12_, 400, 300);
	_tmp13_ = _data5_->dialog;
	gtk_container_set_border_width ((GtkContainer*) _tmp13_, (guint) 12);
	_tmp14_ = _data5_->dialog;
	g_signal_connect_data (_tmp14_, "response", (GCallback) ___lambda5__gtk_dialog_response, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	files = NULL;
	_tmp15_ = uri;
	_tmp16_ = g_strdup (_tmp15_);
	files = g_list_prepend (files, _tmp16_);
	_tmp17_ = files;
	files = NULL;
	_tmp18_ = tracker_tags_view_new (_tmp17_);
	g_object_ref_sink (_tmp18_);
	vbox = (GtkVBox*) _tmp18_;
	_tmp19_ = _data5_->dialog;
	_tmp20_ = (GtkBox*) gtk_dialog_get_content_area (_tmp19_);
	_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, GTK_TYPE_BOX) ? ((GtkBox*) _tmp20_) : NULL);
	content = _tmp21_;
	_tmp22_ = content;
	_tmp23_ = vbox;
	gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, TRUE, TRUE, (guint) 6);
	_tmp24_ = content;
	gtk_box_set_spacing (_tmp24_, 10);
	_tmp25_ = _data5_->dialog;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_WIDGET, GtkWidget));
	_tmp26_ = _data5_->dialog;
	gtk_dialog_run (_tmp26_);
	_g_object_unref0 (content);
	_g_object_unref0 (vbox);
	__g_list_free__g_free0_0 (files);
	_gtk_tree_path_free0 (path);
	_g_object_unref0 (model);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


TrackerViewDisplay tracker_view_get_display (TrackerView* self) {
	TrackerViewDisplay result;
	TrackerViewDisplay _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}


static void tracker_view_set_display (TrackerView* self, TrackerViewDisplay value) {
	TrackerViewDisplay _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_display = _tmp0_;
	g_object_notify ((GObject *) self, "display");
}


TrackerResultStore* tracker_view_get_store (TrackerView* self) {
	TrackerResultStore* result;
	TrackerResultStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}


void tracker_view_set_store (TrackerView* self, TrackerResultStore* value) {
	TrackerResultStore* _tmp0_ = NULL;
	TrackerResultStore* _tmp3_ = NULL;
	TrackerResultStore* _tmp4_ = NULL;
	TrackerResultStore* _tmp5_ = NULL;
	TrackerViewDisplay _tmp8_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	if (_tmp0_ != NULL) {
		TrackerResultStore* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		_tmp1_ = self->priv->_store;
		g_signal_parse_name ("row-changed", GTK_TYPE_TREE_MODEL, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkTreeModel*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _tracker_view_store_row_changed_gtk_tree_model_row_changed, self);
	}
	_tmp3_ = value;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp4_;
	_tmp5_ = self->priv->_store;
	if (_tmp5_ != NULL) {
		TrackerResultStore* _tmp6_ = NULL;
		TrackerResultStore* _tmp7_ = NULL;
		_tmp6_ = self->priv->_store;
		g_debug ("tracker-view.vala:48: using store:%p", _tmp6_);
		_tmp7_ = self->priv->_store;
		g_signal_connect_object ((GtkTreeModel*) _tmp7_, "row-changed", (GCallback) _tracker_view_store_row_changed_gtk_tree_model_row_changed, self, 0);
	}
	_tmp8_ = self->priv->_display;
	if (_tmp8_ != TRACKER_VIEW_DISPLAY_FILE_ICONS) {
		GtkWidget* _tmp9_ = NULL;
		TrackerResultStore* _tmp10_ = NULL;
		_tmp9_ = self->priv->view;
		_tmp10_ = self->priv->_store;
		gtk_tree_view_set_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_TREE_VIEW, GtkTreeView), (GtkTreeModel*) _tmp10_);
	} else {
		GtkWidget* _tmp11_ = NULL;
		TrackerResultStore* _tmp12_ = NULL;
		_tmp11_ = self->priv->view;
		_tmp12_ = self->priv->_store;
		gtk_icon_view_set_model (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GTK_TYPE_ICON_VIEW, GtkIconView), (GtkTreeModel*) _tmp12_);
	}
	g_object_notify ((GObject *) self, "store");
}


static void tracker_view_class_init (TrackerViewClass * klass) {
	tracker_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerViewPrivate));
	GTK_WIDGET_CLASS (klass)->unmap = tracker_view_real_unmap;
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_VIEW_DISPLAY, g_param_spec_enum ("display", "display", "display", TRACKER_VIEW_TYPE_DISPLAY, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_VIEW_STORE, g_param_spec_object ("store", "store", "store", TRACKER_TYPE_RESULT_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void tracker_view_instance_init (TrackerView * self) {
	self->priv = TRACKER_VIEW_GET_PRIVATE (self);
	self->priv->view = NULL;
}


static void tracker_view_finalize (GObject* obj) {
	TrackerView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_VIEW, TrackerView);
	_g_object_unref0 (self->priv->_store);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->context_menu);
	G_OBJECT_CLASS (tracker_view_parent_class)->finalize (obj);
}


GType tracker_view_get_type (void) {
	static volatile gsize tracker_view_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerView), 0, (GInstanceInitFunc) tracker_view_instance_init, NULL };
		GType tracker_view_type_id;
		tracker_view_type_id = g_type_register_static (GTK_TYPE_SCROLLED_WINDOW, "TrackerView", &g_define_type_info, 0);
		g_once_init_leave (&tracker_view_type_id__volatile, tracker_view_type_id);
	}
	return tracker_view_type_id__volatile;
}


static void _vala_tracker_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_VIEW, TrackerView);
	switch (property_id) {
		case TRACKER_VIEW_DISPLAY:
		g_value_set_enum (value, tracker_view_get_display (self));
		break;
		case TRACKER_VIEW_STORE:
		g_value_set_object (value, tracker_view_get_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_VIEW, TrackerView);
	switch (property_id) {
		case TRACKER_VIEW_DISPLAY:
		tracker_view_set_display (self, g_value_get_enum (value));
		break;
		case TRACKER_VIEW_STORE:
		tracker_view_set_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



