/* tracker-result-store.c generated by valac 0.22.0, the Vala compiler
 * generated from tracker-result-store.vala, do not modify */

/**/
/* Copyright 2010, Carlos Garnacho <carlos@lanedo.com>*/
/**/
/* This program is free software; you can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License*/
/* as published by the Free Software Foundation; either version 2*/
/* of the License, or (at your option) any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, write to the Free Software*/
/* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA*/
/* 02110-1301, USA.*/
/**/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <stdarg.h>
#include <gobject/gvaluecollector.h>


#define TRACKER_TYPE_RESULT_STORE (tracker_result_store_get_type ())
#define TRACKER_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStore))
#define TRACKER_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))
#define TRACKER_IS_RESULT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_IS_RESULT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESULT_STORE))
#define TRACKER_RESULT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESULT_STORE, TrackerResultStoreClass))

typedef struct _TrackerResultStore TrackerResultStore;
typedef struct _TrackerResultStoreClass TrackerResultStoreClass;
typedef struct _TrackerResultStorePrivate TrackerResultStorePrivate;

#define TRACKER_RESULT_STORE_TYPE_QUERY_DATA (tracker_result_store_query_data_get_type ())

#define TRACKER_QUERY_TYPE_TYPE (tracker_query_type_get_type ())

#define TRACKER_QUERY_TYPE_MATCH (tracker_query_match_get_type ())
typedef struct _TrackerResultStoreQueryData TrackerResultStoreQueryData;

#define TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE (tracker_result_store_category_node_get_type ())
#define TRACKER_RESULT_STORE_CATEGORY_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode))
#define TRACKER_RESULT_STORE_CATEGORY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNodeClass))
#define TRACKER_RESULT_STORE_IS_CATEGORY_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE))
#define TRACKER_RESULT_STORE_IS_CATEGORY_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE))
#define TRACKER_RESULT_STORE_CATEGORY_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNodeClass))

typedef struct _TrackerResultStoreCategoryNode TrackerResultStoreCategoryNode;
typedef struct _TrackerResultStoreCategoryNodeClass TrackerResultStoreCategoryNodeClass;

#define TRACKER_RESULT_STORE_TYPE_OPERATION (tracker_result_store_operation_get_type ())
#define TRACKER_RESULT_STORE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperation))
#define TRACKER_RESULT_STORE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperationClass))
#define TRACKER_RESULT_STORE_IS_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION))
#define TRACKER_RESULT_STORE_IS_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_RESULT_STORE_TYPE_OPERATION))
#define TRACKER_RESULT_STORE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperationClass))

typedef struct _TrackerResultStoreOperation TrackerResultStoreOperation;
typedef struct _TrackerResultStoreOperationClass TrackerResultStoreOperationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerResultStoreOperationPrivate TrackerResultStoreOperationPrivate;

#define TRACKER_TYPE_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_QUERY, TrackerQueryClass))
#define TRACKER_IS_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_QUERY))
#define TRACKER_IS_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
#define _tracker_query_unref0(var) ((var == NULL) ? NULL : (var = (tracker_query_unref (var), NULL)))
typedef struct _TrackerResultStoreCategoryNodePrivate TrackerResultStoreCategoryNodePrivate;

#define TRACKER_RESULT_STORE_TYPE_RESULT_NODE (tracker_result_store_result_node_get_type ())
typedef struct _TrackerResultStoreResultNode TrackerResultStoreResultNode;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _TrackerResultStoreLoadOperationData TrackerResultStoreLoadOperationData;
#define _tracker_result_store_category_node_unref0(var) ((var == NULL) ? NULL : (var = (tracker_result_store_category_node_unref (var), NULL)))
typedef struct _TrackerResultStoreLoadCategoryData TrackerResultStoreLoadCategoryData;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _TrackerResultStoreFetchThumbnailData TrackerResultStoreFetchThumbnailData;
typedef struct _TrackerResultStoreParamSpecCategoryNode TrackerResultStoreParamSpecCategoryNode;

struct _TrackerResultStore {
	GObject parent_instance;
	TrackerResultStorePrivate * priv;
};

struct _TrackerResultStoreClass {
	GObjectClass parent_class;
};

typedef enum  {
	TRACKER_QUERY_TYPE_ALL,
	TRACKER_QUERY_TYPE_CONTACTS,
	TRACKER_QUERY_TYPE_APPLICATIONS,
	TRACKER_QUERY_TYPE_MUSIC,
	TRACKER_QUERY_TYPE_IMAGES,
	TRACKER_QUERY_TYPE_VIDEOS,
	TRACKER_QUERY_TYPE_DOCUMENTS,
	TRACKER_QUERY_TYPE_MAIL,
	TRACKER_QUERY_TYPE_CALENDAR,
	TRACKER_QUERY_TYPE_FOLDERS,
	TRACKER_QUERY_TYPE_BOOKMARKS
} TrackerQueryType;

typedef enum  {
	TRACKER_QUERY_MATCH_NONE,
	TRACKER_QUERY_MATCH_FTS,
	TRACKER_QUERY_MATCH_FTS_INDIRECT,
	TRACKER_QUERY_MATCH_TITLES,
	TRACKER_QUERY_MATCH_TITLES_INDIRECT,
	TRACKER_QUERY_MATCH_TAGS_ONLY,
	TRACKER_QUERY_MATCH_TAGS_ONLY_INDIRECT
} TrackerQueryMatch;

struct _TrackerResultStoreQueryData {
	TrackerQueryType type;
	TrackerQueryMatch match;
	gchar** args;
	gint args_length1;
	gint _args_size_;
};

struct _TrackerResultStorePrivate {
	GCancellable* cancellable;
	TrackerResultStoreQueryData* queries;
	gint queries_length1;
	gint _queries_size_;
	GPtrArray* categories;
	GPtrArray* running_operations;
	GPtrArray* delayed_operations;
	gint n_extra_columns;
	gint n_columns;
	gint timestamp;
	gint _icon_size;
	guint _limit;
	gchar* _search_term;
	GPtrArray* _search_tags;
	gboolean _active;
};

struct _TrackerResultStoreOperation {
	GObject parent_instance;
	TrackerResultStoreOperationPrivate * priv;
	TrackerResultStoreCategoryNode* node;
	gint offset;
};

struct _TrackerResultStoreOperationClass {
	GObjectClass parent_class;
};

struct _TrackerResultStoreResultNode {
	gchar** values;
	gint values_length1;
	gint _values_size_;
	GdkPixbuf* pixbuf;
};

struct _TrackerResultStoreCategoryNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerResultStoreCategoryNodePrivate * priv;
	TrackerQueryType type;
	TrackerResultStoreQueryData* query;
	TrackerResultStoreResultNode* results;
	gint results_length1;
	gint _results_size_;
	GdkPixbuf* pixbuf;
	gint count;
};

struct _TrackerResultStoreCategoryNodeClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerResultStoreCategoryNode *self);
};

struct _TrackerResultStoreLoadOperationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	TrackerResultStoreOperation* op;
	GCancellable* cancellable;
	TrackerQuery* query;
	TrackerSparqlCursor* cursor;
	gint i;
	GCancellable* _tmp0_;
	TrackerQuery* _tmp1_;
	TrackerQuery* _tmp2_;
	const gchar* _tmp3_;
	TrackerQuery* _tmp4_;
	GPtrArray* _tmp5_;
	TrackerQuery* _tmp6_;
	guint _tmp7_;
	TrackerQuery* _tmp8_;
	TrackerResultStoreOperation* _tmp9_;
	gint _tmp10_;
	TrackerSparqlCursor* _tmp11_;
	TrackerQuery* _tmp12_;
	TrackerResultStoreOperation* _tmp13_;
	TrackerResultStoreCategoryNode* _tmp14_;
	TrackerResultStoreQueryData* _tmp15_;
	TrackerQueryType _tmp16_;
	TrackerResultStoreOperation* _tmp17_;
	TrackerResultStoreCategoryNode* _tmp18_;
	TrackerResultStoreQueryData* _tmp19_;
	TrackerQueryMatch _tmp20_;
	TrackerResultStoreOperation* _tmp21_;
	TrackerResultStoreCategoryNode* _tmp22_;
	TrackerResultStoreQueryData* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	GCancellable* _tmp25_;
	TrackerSparqlCursor* _tmp26_;
	GCancellable* _tmp27_;
	TrackerSparqlCursor* _tmp28_;
	TrackerResultStoreOperation* _tmp29_;
	gint _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	TrackerResultStoreOperation* _tmp35_;
	gint _tmp36_;
	TrackerResultStoreResultNode* _result_;
	GtkTreeIter iter;
	GtkTreePath* path;
	gboolean b;
	gint j;
	gboolean _tmp37_;
	TrackerSparqlCursor* _tmp38_;
	GCancellable* _tmp39_;
	gboolean _tmp40_;
	GError* ge;
	GCancellable* _tmp41_;
	gboolean _tmp42_;
	GError* _tmp43_;
	const gchar* _tmp44_;
	gboolean _tmp45_;
	TrackerResultStoreOperation* _tmp46_;
	TrackerResultStoreCategoryNode* _tmp47_;
	TrackerResultStoreResultNode* _tmp48_;
	gint _tmp48__length1;
	gint _tmp49_;
	gboolean _tmp50_;
	gboolean _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	gchar* s;
	TrackerSparqlCursor* _tmp57_;
	gint _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	TrackerResultStoreResultNode* _tmp62_;
	gchar** _tmp63_;
	gint _tmp63__length1;
	gint _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	TrackerResultStoreResultNode* _tmp68_;
	gchar** _tmp69_;
	gint _tmp69__length1;
	gint _tmp70_;
	gchar* _tmp71_;
	TrackerResultStoreResultNode* _tmp72_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	gint _tmp74_;
	TrackerSparqlCursor* _tmp75_;
	gint _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	gint _tmp80_;
	TrackerResultStoreOperation* _tmp81_;
	TrackerResultStoreCategoryNode* _tmp82_;
	TrackerResultStoreResultNode* _tmp83_;
	gint _tmp84_;
	void* _tmp85_;
	GtkTreeIter _tmp86_;
	GtkTreePath* _tmp87_;
	GtkTreePath* _tmp88_;
	GtkTreeIter _tmp89_;
	GPtrArray* _tmp90_;
	TrackerResultStoreOperation* _tmp91_;
	GError* ie;
	GCancellable* _tmp92_;
	gboolean _tmp93_;
	GError* _tmp94_;
	const gchar* _tmp95_;
	GPtrArray* _tmp96_;
	gint _tmp97_;
	gint _tmp98_;
	TrackerResultStoreOperation* next_to_start;
	GPtrArray* _tmp99_;
	GPtrArray* _tmp100_;
	gint _tmp101_;
	gint _tmp102_;
	gconstpointer _tmp103_;
	TrackerResultStoreOperation* _tmp104_;
	GPtrArray* _tmp105_;
	TrackerResultStoreOperation* _tmp106_;
	GPtrArray* _tmp107_;
	TrackerResultStoreOperation* _tmp108_;
	TrackerResultStoreOperation* _tmp109_;
	TrackerResultStoreOperation* _tmp110_;
	GCancellable* _tmp111_;
	GPtrArray* _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	GError * _inner_error_;
};

struct _TrackerResultStoreLoadCategoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	TrackerResultStoreQueryData* query_data;
	GCancellable* cancellable;
	guint count;
	GCancellable* _tmp0_;
	TrackerQuery* query;
	TrackerQuery* _tmp1_;
	TrackerQuery* _tmp2_;
	const gchar* _tmp3_;
	TrackerQuery* _tmp4_;
	GPtrArray* _tmp5_;
	guint _tmp6_;
	TrackerQuery* _tmp7_;
	TrackerResultStoreQueryData* _tmp8_;
	TrackerQueryType _tmp9_;
	TrackerResultStoreQueryData* _tmp10_;
	TrackerQueryMatch _tmp11_;
	GCancellable* _tmp12_;
	guint _tmp13_;
	GCancellable* _tmp14_;
	GError* ie;
	GCancellable* _tmp15_;
	gboolean _tmp16_;
	GError* _tmp17_;
	const gchar* _tmp18_;
	guint _tmp19_;
	TrackerResultStoreCategoryNode* cat;
	TrackerResultStoreResultNode* res;
	gint i;
	guint _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GtkTreeIter iter;
	GtkTreePath* path;
	TrackerResultStoreCategoryNode* _tmp23_;
	TrackerResultStoreCategoryNode* _tmp24_;
	TrackerResultStoreQueryData* _tmp25_;
	TrackerQueryType _tmp26_;
	TrackerResultStoreCategoryNode* _tmp27_;
	TrackerResultStoreQueryData* _tmp28_;
	TrackerResultStoreCategoryNode* _tmp29_;
	guint _tmp30_;
	gint _tmp31_;
	GPtrArray* _tmp32_;
	TrackerResultStoreCategoryNode* _tmp33_;
	TrackerResultStoreCategoryNode* _tmp34_;
	gint _tmp35_;
	TrackerResultStoreCategoryNode* _tmp36_;
	TrackerResultStoreQueryData* _tmp37_;
	gint _tmp37__length1;
	GtkTreeIter _tmp38_;
	GtkTreePath* _tmp39_;
	GtkTreePath* _tmp40_;
	GtkTreeIter _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	guint _tmp46_;
	TrackerResultStoreCategoryNode* _tmp47_;
	TrackerResultStoreResultNode* _tmp48_;
	gint _tmp48__length1;
	gint _tmp49_;
	TrackerResultStoreResultNode* _tmp50_;
	gint _tmp51_;
	gchar** _tmp52_;
	TrackerResultStoreResultNode* _tmp53_;
	gint _tmp54_;
	void* _tmp55_;
	GtkTreeIter _tmp56_;
	GtkTreePath* _tmp57_;
	TrackerResultStoreCategoryNode* _tmp58_;
	gint _tmp59_;
	GtkTreePath* _tmp60_;
	GtkTreeIter _tmp61_;
	TrackerResultStoreQueryData* _tmp62_;
	gint _tmp62__length1;
	GtkTreeIter _tmp63_;
	GtkTreePath* _tmp64_;
	GtkTreePath* _tmp65_;
	GtkTreeIter _tmp66_;
	GPtrArray* _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	GError * _inner_error_;
};

struct _TrackerResultStoreFetchThumbnailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResultStore* self;
	GtkTreeIter iter;
	GFile* file;
	GFileInfo* info;
	TrackerResultStoreResultNode* _result_;
	gchar* thumb_path;
	GdkPixbuf* pixbuf;
	GtkTreeIter _tmp0_;
	void* _tmp1_;
	TrackerResultStoreResultNode* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFileInfo* _tmp6_;
	GFile* _tmp7_;
	GCancellable* _tmp8_;
	GFileInfo* _tmp9_;
	GError* ie;
	GCancellable* _tmp10_;
	gboolean _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GFileInfo* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	GdkPixbuf* _tmp18_;
	const gchar* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	GdkPixbuf* _tmp22_;
	GIcon* icon;
	GtkIconInfo* icon_info;
	GFileInfo* _tmp23_;
	GObject* _tmp24_;
	GIcon* _tmp25_;
	GIcon* _tmp26_;
	GtkIconTheme* theme;
	GdkScreen* _tmp27_;
	GtkIconTheme* _tmp28_;
	GtkIconTheme* _tmp29_;
	GtkIconTheme* _tmp30_;
	GIcon* _tmp31_;
	gint _tmp32_;
	GtkIconInfo* _tmp33_;
	GtkIconInfo* _tmp34_;
	GdkPixbuf* _tmp35_;
	GtkIconInfo* _tmp36_;
	GdkPixbuf* _tmp37_;
	GError* e;
	GError* _tmp38_;
	const gchar* _tmp39_;
	GdkPixbuf* _tmp40_;
	GtkTreePath* path;
	TrackerResultStoreResultNode* _tmp41_;
	GdkPixbuf* _tmp42_;
	GdkPixbuf* _tmp43_;
	GtkTreeIter _tmp44_;
	GtkTreePath* _tmp45_;
	GtkTreePath* _tmp46_;
	GtkTreeIter _tmp47_;
	GError * _inner_error_;
};

struct _TrackerResultStoreParamSpecCategoryNode {
	GParamSpec parent_instance;
};


static gpointer tracker_result_store_parent_class = NULL;
static gpointer tracker_result_store_category_node_parent_class = NULL;
static gpointer tracker_result_store_operation_parent_class = NULL;
static GtkTreeModelIface* tracker_result_store_gtk_tree_model_parent_iface = NULL;

GType tracker_result_store_get_type (void) G_GNUC_CONST;
static GType tracker_result_store_query_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType tracker_query_type_get_type (void) G_GNUC_CONST;
GType tracker_query_match_get_type (void) G_GNUC_CONST;
static TrackerResultStoreQueryData* tracker_result_store_query_data_dup (const TrackerResultStoreQueryData* self);
static void tracker_result_store_query_data_free (TrackerResultStoreQueryData* self);
static void tracker_result_store_query_data_copy (const TrackerResultStoreQueryData* self, TrackerResultStoreQueryData* dest);
static void tracker_result_store_query_data_destroy (TrackerResultStoreQueryData* self);
static gpointer tracker_result_store_category_node_ref (gpointer instance);
static void tracker_result_store_category_node_unref (gpointer instance);
static GParamSpec* tracker_result_store_param_spec_category_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_result_store_value_set_category_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_result_store_value_take_category_node (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_result_store_value_get_category_node (const GValue* value) G_GNUC_UNUSED;
static GType tracker_result_store_category_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType tracker_result_store_operation_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_RESULT_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_RESULT_STORE, TrackerResultStorePrivate))
enum  {
	TRACKER_RESULT_STORE_DUMMY_PROPERTY,
	TRACKER_RESULT_STORE_ICON_SIZE,
	TRACKER_RESULT_STORE_LIMIT,
	TRACKER_RESULT_STORE_SEARCH_TERM,
	TRACKER_RESULT_STORE_SEARCH_TAGS,
	TRACKER_RESULT_STORE_ACTIVE
};
static void _vala_TrackerResultStoreQueryData_array_free (TrackerResultStoreQueryData* array, gint array_length);
static TrackerResultStoreOperation* tracker_result_store_find_operation (TrackerResultStore* self, GPtrArray* array, TrackerResultStoreCategoryNode* node, gint offset);
static void tracker_result_store_load_operation_data_free (gpointer _data);
static void tracker_result_store_load_operation (TrackerResultStore* self, TrackerResultStoreOperation* op, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_load_operation_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_load_operation_co (TrackerResultStoreLoadOperationData* _data_);
gpointer tracker_query_ref (gpointer instance);
void tracker_query_unref (gpointer instance);
GParamSpec* tracker_param_spec_query (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void tracker_value_set_query (GValue* value, gpointer v_object);
void tracker_value_take_query (GValue* value, gpointer v_object);
gpointer tracker_value_get_query (const GValue* value);
GType tracker_query_get_type (void) G_GNUC_CONST;
TrackerQuery* tracker_query_new (void);
TrackerQuery* tracker_query_construct (GType object_type);
void tracker_query_set_criteria (TrackerQuery* self, const gchar* value);
GPtrArray* tracker_result_store_get_search_tags (TrackerResultStore* self);
void tracker_query_set_tags (TrackerQuery* self, GPtrArray* value);
guint tracker_result_store_get_limit (TrackerResultStore* self);
void tracker_query_set_limit (TrackerQuery* self, guint value);
void tracker_query_set_offset (TrackerQuery* self, guint value);
void tracker_query_perform_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, gchar** args, int args_length1, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
TrackerSparqlCursor* tracker_query_perform_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static GType tracker_result_store_result_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static TrackerResultStoreResultNode* tracker_result_store_result_node_dup (const TrackerResultStoreResultNode* self);
static void tracker_result_store_result_node_free (TrackerResultStoreResultNode* self);
static void tracker_result_store_result_node_copy (const TrackerResultStoreResultNode* self, TrackerResultStoreResultNode* dest);
static void tracker_result_store_result_node_destroy (TrackerResultStoreResultNode* self);
static void tracker_result_store_load_operation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_result_store_set_active (TrackerResultStore* self, gboolean value);
static void tracker_result_store_add_operation (TrackerResultStore* self, TrackerResultStoreCategoryNode* cat, gint offset);
static TrackerResultStoreOperation* tracker_result_store_operation_new (void);
static TrackerResultStoreOperation* tracker_result_store_operation_construct (GType object_type);
static void tracker_result_store_load_category_data_free (gpointer _data);
static void tracker_result_store_load_category (TrackerResultStore* self, TrackerResultStoreQueryData* query_data, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_load_category_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_load_category_co (TrackerResultStoreLoadCategoryData* _data_);
void tracker_query_get_count_async (TrackerQuery* self, TrackerQueryType query_type, TrackerQueryMatch match_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint tracker_query_get_count_finish (TrackerQuery* self, GAsyncResult* _res_, GError** error);
static void tracker_result_store_load_category_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static TrackerResultStoreCategoryNode* tracker_result_store_category_node_new (void);
static TrackerResultStoreCategoryNode* tracker_result_store_category_node_construct (GType object_type);
static void tracker_result_store_clear_results (TrackerResultStore* self);
static gint tracker_result_store_find_nth_category_index (TrackerResultStore* self, TrackerResultStoreCategoryNode* node, gint n);
static gint tracker_result_store_filled_categories_count (TrackerResultStore* self);
static GType tracker_result_store_real_get_column_type (GtkTreeModel* base, gint index_);
static GtkTreeModelFlags tracker_result_store_real_get_flags (GtkTreeModel* base);
static gboolean tracker_result_store_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static gint tracker_result_store_real_get_n_columns (GtkTreeModel* base);
static GtkTreePath* tracker_result_store_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_fetch_thumbnail_data_free (gpointer _data);
static void tracker_result_store_fetch_thumbnail (TrackerResultStore* self, GtkTreeIter* iter, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void tracker_result_store_fetch_thumbnail_finish (TrackerResultStore* self, GAsyncResult* _res_);
static gboolean tracker_result_store_fetch_thumbnail_co (TrackerResultStoreFetchThumbnailData* _data_);
static void tracker_result_store_fetch_thumbnail_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint tracker_result_store_get_icon_size (TrackerResultStore* self);
static void tracker_result_store_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
GdkPixbuf* tracker_pixbuf_new_from_name (GtkIconTheme* theme, const gchar* name, gint size);
static gboolean tracker_result_store_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean tracker_result_store_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint tracker_result_store_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean tracker_result_store_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean tracker_result_store_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean tracker_result_store_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void tracker_result_store_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void tracker_result_store_theme_changed (TrackerResultStore* self, GtkIconTheme* theme);
TrackerResultStore* tracker_result_store_new (gint _n_columns);
TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns);
static void _tracker_result_store_category_node_unref0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value);
static void _tracker_result_store_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender, gpointer self);
void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup2 (gchar** self, int length);
static void _vala_array_add3 (TrackerResultStoreQueryData** array, int* length, int* size, const TrackerResultStoreQueryData* value);
gboolean tracker_result_store_has_results (TrackerResultStore* self);
void tracker_result_store_cancel_search (TrackerResultStore* self);
void tracker_result_store_set_limit (TrackerResultStore* self, guint value);
const gchar* tracker_result_store_get_search_term (TrackerResultStore* self);
void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value);
void tracker_result_store_set_search_tags (TrackerResultStore* self, GPtrArray* value);
gboolean tracker_result_store_get_active (TrackerResultStore* self);
enum  {
	TRACKER_RESULT_STORE_CATEGORY_NODE_DUMMY_PROPERTY
};
static void _vala_TrackerResultStoreResultNode_array_free (TrackerResultStoreResultNode* array, gint array_length);
static void tracker_result_store_category_node_finalize (TrackerResultStoreCategoryNode* obj);
enum  {
	TRACKER_RESULT_STORE_OPERATION_DUMMY_PROPERTY
};
static void tracker_result_store_operation_finalize (GObject* obj);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static void tracker_result_store_finalize (GObject* obj);
static void _vala_tracker_result_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tracker_result_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_TrackerResultStoreQueryData_array_free (TrackerResultStoreQueryData* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			tracker_result_store_query_data_destroy (&array[i]);
		}
	}
	g_free (array);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static TrackerResultStoreOperation* tracker_result_store_find_operation (TrackerResultStore* self, GPtrArray* array, TrackerResultStoreCategoryNode* node, gint offset) {
	TrackerResultStoreOperation* result = NULL;
	TrackerResultStoreOperation* op = NULL;
	gint i = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (array != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp3_ = 0;
			GPtrArray* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			GPtrArray* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gconstpointer _tmp9_ = NULL;
			TrackerResultStoreOperation* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			TrackerResultStoreOperation* _tmp12_ = NULL;
			TrackerResultStoreCategoryNode* _tmp13_ = NULL;
			TrackerResultStoreCategoryNode* _tmp14_ = NULL;
			gboolean _tmp18_ = FALSE;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_ = 0;
				_tmp2_ = i;
				i = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = i;
			_tmp4_ = array;
			_tmp5_ = g_ptr_array_get_length (_tmp4_);
			_tmp6_ = _tmp5_;
			if (!(_tmp3_ < _tmp6_)) {
				break;
			}
			_tmp7_ = array;
			_tmp8_ = i;
			_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
			_tmp10_ = _g_object_ref0 ((TrackerResultStoreOperation*) _tmp9_);
			_g_object_unref0 (op);
			op = _tmp10_;
			_tmp12_ = op;
			_tmp13_ = _tmp12_->node;
			_tmp14_ = node;
			if (_tmp13_ == _tmp14_) {
				TrackerResultStoreOperation* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				_tmp15_ = op;
				_tmp16_ = _tmp15_->offset;
				_tmp17_ = offset;
				_tmp11_ = _tmp16_ == _tmp17_;
			} else {
				_tmp11_ = FALSE;
			}
			_tmp18_ = _tmp11_;
			if (_tmp18_) {
				result = op;
				return result;
			}
		}
	}
	result = NULL;
	_g_object_unref0 (op);
	return result;
}


static void tracker_result_store_load_operation_data_free (gpointer _data) {
	TrackerResultStoreLoadOperationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->op);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerResultStoreLoadOperationData, _data_);
}


static void tracker_result_store_load_operation (TrackerResultStore* self, TrackerResultStoreOperation* op, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreLoadOperationData* _data_;
	TrackerResultStore* _tmp0_ = NULL;
	TrackerResultStoreOperation* _tmp1_ = NULL;
	TrackerResultStoreOperation* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (TrackerResultStoreLoadOperationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_load_operation);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_load_operation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = op;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->op);
	_data_->op = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	tracker_result_store_load_operation_co (_data_);
}


static void tracker_result_store_load_operation_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreLoadOperationData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_result_store_load_operation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreLoadOperationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_result_store_load_operation_co (_data_);
}


static gboolean tracker_result_store_load_operation_co (TrackerResultStoreLoadOperationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->cursor = NULL;
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->cancellable;
		g_cancellable_set_error_if_cancelled (_data_->_tmp0_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			_g_object_unref0 (_data_->cursor);
			_tracker_query_unref0 (_data_->query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = tracker_query_new ();
		_tracker_query_unref0 (_data_->query);
		_data_->query = _data_->_tmp1_;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->query;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->_search_term;
		tracker_query_set_criteria (_data_->_tmp2_, _data_->_tmp3_);
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->query;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->_search_tags;
		tracker_query_set_tags (_data_->_tmp4_, _data_->_tmp5_);
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->query;
		_data_->_tmp7_ = 0U;
		_data_->_tmp7_ = _data_->self->priv->_limit;
		tracker_query_set_limit (_data_->_tmp6_, _data_->_tmp7_);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->query;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->op;
		_data_->_tmp10_ = 0;
		_data_->_tmp10_ = _data_->_tmp9_->offset;
		tracker_query_set_offset (_data_->_tmp8_, (guint) _data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->query;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->op;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp13_->node;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_tmp14_->query;
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = (*_data_->_tmp15_).type;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->op;
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = _data_->_tmp17_->node;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_tmp18_->query;
		_data_->_tmp20_ = 0;
		_data_->_tmp20_ = (*_data_->_tmp19_).match;
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->op;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_tmp21_->node;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_tmp22_->query;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24__length1 = 0;
		_data_->_tmp24_ = (*_data_->_tmp23_).args;
		_data_->_tmp24__length1 = (*_data_->_tmp23_).args_length1;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->cancellable;
		_data_->_state_ = 1;
		tracker_query_perform_async (_data_->_tmp12_, _data_->_tmp16_, _data_->_tmp20_, _data_->_tmp24_, _data_->_tmp24__length1, _data_->_tmp25_, tracker_result_store_load_operation_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = tracker_query_perform_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp11_ = _data_->_tmp26_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			_g_object_unref0 (_data_->cursor);
			_tracker_query_unref0 (_data_->query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_object_unref0 (_data_->cursor);
		_data_->cursor = _data_->_tmp11_;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->cancellable;
		g_cancellable_set_error_if_cancelled (_data_->_tmp27_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			_g_object_unref0 (_data_->cursor);
			_tracker_query_unref0 (_data_->query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->cursor;
		if (_data_->_tmp28_ != NULL) {
			{
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = _data_->op;
				_data_->_tmp30_ = 0;
				_data_->_tmp30_ = _data_->_tmp29_->offset;
				_data_->i = _data_->_tmp30_;
				_data_->_tmp31_ = TRUE;
				while (TRUE) {
					_data_->_tmp32_ = FALSE;
					_data_->_tmp32_ = _data_->_tmp31_;
					if (!_data_->_tmp32_) {
						_data_->_tmp33_ = 0;
						_data_->_tmp33_ = _data_->i;
						_data_->i = _data_->_tmp33_ + 1;
					}
					_data_->_tmp31_ = FALSE;
					_data_->_tmp34_ = 0;
					_data_->_tmp34_ = _data_->i;
					_data_->_tmp35_ = NULL;
					_data_->_tmp35_ = _data_->op;
					_data_->_tmp36_ = 0;
					_data_->_tmp36_ = _data_->_tmp35_->offset;
					if (!(_data_->_tmp34_ < (_data_->_tmp36_ + 100))) {
						break;
					}
					_data_->b = FALSE;
					{
						_data_->_tmp38_ = NULL;
						_data_->_tmp38_ = _data_->cursor;
						_data_->_tmp39_ = NULL;
						_data_->_tmp39_ = _data_->cancellable;
						_data_->_state_ = 2;
						tracker_sparql_cursor_next_async (_data_->_tmp38_, _data_->_tmp39_, tracker_result_store_load_operation_ready, _data_);
						return FALSE;
						_state_2:
						_data_->_tmp40_ = FALSE;
						_data_->_tmp40_ = tracker_sparql_cursor_next_finish (_data_->_tmp38_, _data_->_res_, &_data_->_inner_error_);
						_data_->_tmp37_ = _data_->_tmp40_;
						if (_data_->_inner_error_ != NULL) {
							goto __catch7_g_error;
						}
						_data_->b = _data_->_tmp37_;
					}
					goto __finally7;
					__catch7_g_error:
					{
						_data_->ge = _data_->_inner_error_;
						_data_->_inner_error_ = NULL;
						_data_->_tmp41_ = NULL;
						_data_->_tmp41_ = _data_->cancellable;
						_data_->_tmp42_ = FALSE;
						_data_->_tmp42_ = g_cancellable_is_cancelled (_data_->_tmp41_);
						if (!_data_->_tmp42_) {
							_data_->_tmp43_ = NULL;
							_data_->_tmp43_ = _data_->ge;
							_data_->_tmp44_ = NULL;
							_data_->_tmp44_ = _data_->_tmp43_->message;
							g_warning ("tracker-result-store.vala:117: Could not fetch row: %s\n", _data_->_tmp44_);
						}
						_g_error_free0 (_data_->ge);
					}
					__finally7:
					if (_data_->_inner_error_ != NULL) {
						_gtk_tree_path_free0 (_data_->path);
						if (_data_->_inner_error_->domain == G_IO_ERROR) {
							goto __catch6_g_io_error;
						}
						_gtk_tree_path_free0 (_data_->path);
						_g_object_unref0 (_data_->cursor);
						_tracker_query_unref0 (_data_->query);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						return FALSE;
					}
					_data_->_tmp45_ = FALSE;
					_data_->_tmp45_ = _data_->b;
					if (!_data_->_tmp45_) {
						_gtk_tree_path_free0 (_data_->path);
						break;
					}
					_data_->_tmp46_ = NULL;
					_data_->_tmp46_ = _data_->op;
					_data_->_tmp47_ = NULL;
					_data_->_tmp47_ = _data_->_tmp46_->node;
					_data_->_tmp48_ = NULL;
					_data_->_tmp48__length1 = 0;
					_data_->_tmp48_ = _data_->_tmp47_->results;
					_data_->_tmp48__length1 = _data_->_tmp47_->results_length1;
					_data_->_tmp49_ = 0;
					_data_->_tmp49_ = _data_->i;
					_data_->_result_ = &_data_->_tmp48_[_data_->_tmp49_];
					{
						_data_->j = 0;
						_data_->_tmp50_ = TRUE;
						while (TRUE) {
							_data_->_tmp51_ = FALSE;
							_data_->_tmp51_ = _data_->_tmp50_;
							if (!_data_->_tmp51_) {
								_data_->_tmp52_ = 0;
								_data_->_tmp52_ = _data_->j;
								_data_->j = _data_->_tmp52_ + 1;
							}
							_data_->_tmp50_ = FALSE;
							_data_->_tmp53_ = 0;
							_data_->_tmp53_ = _data_->j;
							_data_->_tmp54_ = 0;
							_data_->_tmp54_ = _data_->self->priv->n_columns;
							if (!(_data_->_tmp53_ < _data_->_tmp54_)) {
								break;
							}
							_data_->_tmp55_ = 0;
							_data_->_tmp55_ = _data_->j;
							_data_->_tmp56_ = 0;
							_data_->_tmp56_ = _data_->self->priv->n_columns;
							if (_data_->_tmp55_ == (_data_->_tmp56_ - 1)) {
								_data_->_tmp57_ = NULL;
								_data_->_tmp57_ = _data_->cursor;
								_data_->_tmp58_ = 0;
								_data_->_tmp58_ = _data_->j;
								_data_->_tmp59_ = NULL;
								_data_->_tmp59_ = tracker_sparql_cursor_get_string (_data_->_tmp57_, _data_->_tmp58_, NULL);
								_data_->_tmp60_ = NULL;
								_data_->_tmp60_ = g_strdup (_data_->_tmp59_);
								_data_->s = _data_->_tmp60_;
								_data_->_tmp61_ = NULL;
								_data_->_tmp61_ = _data_->s;
								if (_data_->_tmp61_ != NULL) {
									_data_->_tmp62_ = NULL;
									_data_->_tmp62_ = _data_->_result_;
									_data_->_tmp63_ = NULL;
									_data_->_tmp63__length1 = 0;
									_data_->_tmp63_ = (*_data_->_tmp62_).values;
									_data_->_tmp63__length1 = (*_data_->_tmp62_).values_length1;
									_data_->_tmp64_ = 0;
									_data_->_tmp64_ = _data_->j;
									_data_->_tmp65_ = NULL;
									_data_->_tmp65_ = _data_->s;
									_data_->_tmp66_ = NULL;
									_data_->_tmp66_ = g_markup_escape_text (_data_->_tmp65_, (gssize) (-1));
									_g_free0 (_data_->_tmp63_[_data_->_tmp64_]);
									_data_->_tmp63_[_data_->_tmp64_] = _data_->_tmp66_;
									_data_->_tmp67_ = NULL;
									_data_->_tmp67_ = _data_->_tmp63_[_data_->_tmp64_];
								} else {
									_data_->_tmp68_ = NULL;
									_data_->_tmp68_ = _data_->_result_;
									_data_->_tmp69_ = NULL;
									_data_->_tmp69__length1 = 0;
									_data_->_tmp69_ = (*_data_->_tmp68_).values;
									_data_->_tmp69__length1 = (*_data_->_tmp68_).values_length1;
									_data_->_tmp70_ = 0;
									_data_->_tmp70_ = _data_->j;
									_g_free0 (_data_->_tmp69_[_data_->_tmp70_]);
									_data_->_tmp69_[_data_->_tmp70_] = NULL;
									_data_->_tmp71_ = NULL;
									_data_->_tmp71_ = _data_->_tmp69_[_data_->_tmp70_];
								}
								_g_free0 (_data_->s);
							} else {
								_data_->_tmp72_ = NULL;
								_data_->_tmp72_ = _data_->_result_;
								_data_->_tmp73_ = NULL;
								_data_->_tmp73__length1 = 0;
								_data_->_tmp73_ = (*_data_->_tmp72_).values;
								_data_->_tmp73__length1 = (*_data_->_tmp72_).values_length1;
								_data_->_tmp74_ = 0;
								_data_->_tmp74_ = _data_->j;
								_data_->_tmp75_ = NULL;
								_data_->_tmp75_ = _data_->cursor;
								_data_->_tmp76_ = 0;
								_data_->_tmp76_ = _data_->j;
								_data_->_tmp77_ = NULL;
								_data_->_tmp77_ = tracker_sparql_cursor_get_string (_data_->_tmp75_, _data_->_tmp76_, NULL);
								_data_->_tmp78_ = NULL;
								_data_->_tmp78_ = g_strdup (_data_->_tmp77_);
								_g_free0 (_data_->_tmp73_[_data_->_tmp74_]);
								_data_->_tmp73_[_data_->_tmp74_] = _data_->_tmp78_;
								_data_->_tmp79_ = NULL;
								_data_->_tmp79_ = _data_->_tmp73_[_data_->_tmp74_];
							}
						}
					}
					memset (&_data_->iter, 0, sizeof (GtkTreeIter));
					_data_->_tmp80_ = 0;
					_data_->_tmp80_ = _data_->self->priv->timestamp;
					_data_->iter.stamp = _data_->_tmp80_;
					_data_->_tmp81_ = NULL;
					_data_->_tmp81_ = _data_->op;
					_data_->_tmp82_ = NULL;
					_data_->_tmp82_ = _data_->_tmp81_->node;
					_data_->iter.user_data = _data_->_tmp82_;
					_data_->_tmp83_ = NULL;
					_data_->_tmp83_ = _data_->_result_;
					_data_->iter.user_data2 = _data_->_tmp83_;
					_data_->_tmp84_ = 0;
					_data_->_tmp84_ = _data_->i;
					_data_->_tmp85_ = NULL;
					_data_->_tmp85_ = GINT_TO_POINTER (_data_->_tmp84_);
					_data_->iter.user_data3 = _data_->_tmp85_;
					memset (&_data_->_tmp86_, 0, sizeof (GtkTreeIter));
					_data_->_tmp86_ = _data_->iter;
					_data_->_tmp87_ = NULL;
					_data_->_tmp87_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp86_);
					_gtk_tree_path_free0 (_data_->path);
					_data_->path = _data_->_tmp87_;
					_data_->_tmp88_ = NULL;
					_data_->_tmp88_ = _data_->path;
					memset (&_data_->_tmp89_, 0, sizeof (GtkTreeIter));
					_data_->_tmp89_ = _data_->iter;
					gtk_tree_model_row_changed ((GtkTreeModel*) _data_->self, _data_->_tmp88_, &_data_->_tmp89_);
					_gtk_tree_path_free0 (_data_->path);
				}
			}
		}
		_data_->_tmp90_ = NULL;
		_data_->_tmp90_ = _data_->self->priv->running_operations;
		_data_->_tmp91_ = NULL;
		_data_->_tmp91_ = _data_->op;
		g_ptr_array_remove (_data_->_tmp90_, _data_->_tmp91_);
	}
	goto __finally6;
	__catch6_g_io_error:
	{
		_data_->ie = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp92_ = NULL;
		_data_->_tmp92_ = _data_->cancellable;
		_data_->_tmp93_ = FALSE;
		_data_->_tmp93_ = g_cancellable_is_cancelled (_data_->_tmp92_);
		if (!_data_->_tmp93_) {
			_data_->_tmp94_ = NULL;
			_data_->_tmp94_ = _data_->ie;
			_data_->_tmp95_ = NULL;
			_data_->_tmp95_ = _data_->_tmp94_->message;
			g_warning ("tracker-result-store.vala:156: Could not load items: %s\n", _data_->_tmp95_);
		}
		_g_error_free0 (_data_->ie);
		_g_object_unref0 (_data_->cursor);
		_tracker_query_unref0 (_data_->query);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally6:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->cursor);
		_tracker_query_unref0 (_data_->query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp96_ = NULL;
	_data_->_tmp96_ = _data_->self->priv->delayed_operations;
	_data_->_tmp97_ = 0;
	_data_->_tmp97_ = g_ptr_array_get_length (_data_->_tmp96_);
	_data_->_tmp98_ = 0;
	_data_->_tmp98_ = _data_->_tmp97_;
	if (_data_->_tmp98_ > 0) {
		_data_->_tmp99_ = NULL;
		_data_->_tmp99_ = _data_->self->priv->delayed_operations;
		_data_->_tmp100_ = NULL;
		_data_->_tmp100_ = _data_->self->priv->delayed_operations;
		_data_->_tmp101_ = 0;
		_data_->_tmp101_ = g_ptr_array_get_length (_data_->_tmp100_);
		_data_->_tmp102_ = 0;
		_data_->_tmp102_ = _data_->_tmp101_;
		_data_->_tmp103_ = NULL;
		_data_->_tmp103_ = g_ptr_array_index (_data_->_tmp99_, (guint) (_data_->_tmp102_ - 1));
		_data_->_tmp104_ = NULL;
		_data_->_tmp104_ = _g_object_ref0 ((TrackerResultStoreOperation*) _data_->_tmp103_);
		_g_object_unref0 (_data_->next_to_start);
		_data_->next_to_start = _data_->_tmp104_;
		_data_->_tmp105_ = NULL;
		_data_->_tmp105_ = _data_->self->priv->delayed_operations;
		_data_->_tmp106_ = NULL;
		_data_->_tmp106_ = _data_->next_to_start;
		g_ptr_array_remove (_data_->_tmp105_, _data_->_tmp106_);
		_data_->_tmp107_ = NULL;
		_data_->_tmp107_ = _data_->self->priv->running_operations;
		_data_->_tmp108_ = NULL;
		_data_->_tmp108_ = _data_->next_to_start;
		_data_->_tmp109_ = NULL;
		_data_->_tmp109_ = _g_object_ref0 (_data_->_tmp108_);
		g_ptr_array_add (_data_->_tmp107_, _data_->_tmp109_);
		_data_->_tmp110_ = NULL;
		_data_->_tmp110_ = _data_->next_to_start;
		_data_->_tmp111_ = NULL;
		_data_->_tmp111_ = _data_->cancellable;
		tracker_result_store_load_operation (_data_->self, _data_->_tmp110_, _data_->_tmp111_, NULL, NULL);
		_g_object_unref0 (_data_->next_to_start);
	} else {
		_data_->_tmp112_ = NULL;
		_data_->_tmp112_ = _data_->self->priv->running_operations;
		_data_->_tmp113_ = 0;
		_data_->_tmp113_ = g_ptr_array_get_length (_data_->_tmp112_);
		_data_->_tmp114_ = 0;
		_data_->_tmp114_ = _data_->_tmp113_;
		if (_data_->_tmp114_ == 0) {
			tracker_result_store_set_active (_data_->self, FALSE);
		}
	}
	_g_object_unref0 (_data_->cursor);
	_tracker_query_unref0 (_data_->query);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _tracker_result_store_category_node_ref0 (gpointer self) {
	return self ? tracker_result_store_category_node_ref (self) : NULL;
}


static void tracker_result_store_add_operation (TrackerResultStore* self, TrackerResultStoreCategoryNode* cat, gint offset) {
	TrackerResultStoreOperation* op = NULL;
	TrackerResultStoreOperation* _tmp0_ = NULL;
	TrackerResultStoreOperation* old = NULL;
	TrackerResultStoreOperation* _tmp1_ = NULL;
	TrackerResultStoreCategoryNode* _tmp2_ = NULL;
	TrackerResultStoreCategoryNode* _tmp3_ = NULL;
	TrackerResultStoreOperation* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GPtrArray* _tmp6_ = NULL;
	TrackerResultStoreCategoryNode* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	TrackerResultStoreOperation* _tmp9_ = NULL;
	TrackerResultStoreOperation* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GPtrArray* _tmp12_ = NULL;
	TrackerResultStoreCategoryNode* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	TrackerResultStoreOperation* _tmp15_ = NULL;
	TrackerResultStoreOperation* _tmp16_ = NULL;
	GPtrArray* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cat != NULL);
	_tmp0_ = tracker_result_store_operation_new ();
	op = _tmp0_;
	_tmp1_ = op;
	_tmp2_ = cat;
	_tmp3_ = _tracker_result_store_category_node_ref0 (_tmp2_);
	_tracker_result_store_category_node_unref0 (_tmp1_->node);
	_tmp1_->node = _tmp3_;
	_tmp4_ = op;
	_tmp5_ = offset;
	_tmp4_->offset = _tmp5_;
	_tmp6_ = self->priv->running_operations;
	_tmp7_ = cat;
	_tmp8_ = offset;
	_tmp9_ = tracker_result_store_find_operation (self, _tmp6_, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	_g_object_unref0 (_tmp10_);
	if (_tmp11_) {
		_g_object_unref0 (old);
		_g_object_unref0 (op);
		return;
	}
	_tmp12_ = self->priv->delayed_operations;
	_tmp13_ = cat;
	_tmp14_ = offset;
	_tmp15_ = tracker_result_store_find_operation (self, _tmp12_, _tmp13_, _tmp14_);
	_g_object_unref0 (old);
	old = _tmp15_;
	_tmp16_ = old;
	if (_tmp16_ != NULL) {
		GPtrArray* _tmp17_ = NULL;
		TrackerResultStoreOperation* _tmp18_ = NULL;
		_tmp17_ = self->priv->delayed_operations;
		_tmp18_ = old;
		g_ptr_array_remove (_tmp17_, _tmp18_);
	}
	tracker_result_store_set_active (self, TRUE);
	_tmp19_ = self->priv->running_operations;
	_tmp20_ = g_ptr_array_get_length (_tmp19_);
	_tmp21_ = _tmp20_;
	if (_tmp21_ < 2) {
		GPtrArray* _tmp22_ = NULL;
		TrackerResultStoreOperation* _tmp23_ = NULL;
		TrackerResultStoreOperation* _tmp24_ = NULL;
		TrackerResultStoreOperation* _tmp25_ = NULL;
		GCancellable* _tmp26_ = NULL;
		_tmp22_ = self->priv->running_operations;
		_tmp23_ = op;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		g_ptr_array_add (_tmp22_, _tmp24_);
		_tmp25_ = op;
		_tmp26_ = self->priv->cancellable;
		tracker_result_store_load_operation (self, _tmp25_, _tmp26_, NULL, NULL);
	} else {
		GPtrArray* _tmp27_ = NULL;
		TrackerResultStoreOperation* _tmp28_ = NULL;
		TrackerResultStoreOperation* _tmp29_ = NULL;
		_tmp27_ = self->priv->delayed_operations;
		_tmp28_ = op;
		_tmp29_ = _g_object_ref0 (_tmp28_);
		g_ptr_array_add (_tmp27_, _tmp29_);
	}
	_g_object_unref0 (old);
	_g_object_unref0 (op);
}


static void tracker_result_store_load_category_data_free (gpointer _data) {
	TrackerResultStoreLoadCategoryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerResultStoreLoadCategoryData, _data_);
}


static void tracker_result_store_load_category (TrackerResultStore* self, TrackerResultStoreQueryData* query_data, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreLoadCategoryData* _data_;
	TrackerResultStore* _tmp0_ = NULL;
	TrackerResultStoreQueryData* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	_data_ = g_slice_new0 (TrackerResultStoreLoadCategoryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_load_category);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_load_category_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = query_data;
	_data_->query_data = _tmp1_;
	_tmp2_ = cancellable;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	tracker_result_store_load_category_co (_data_);
}


static void tracker_result_store_load_category_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreLoadCategoryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_result_store_load_category_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreLoadCategoryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_result_store_load_category_co (_data_);
}


static gboolean tracker_result_store_load_category_co (TrackerResultStoreLoadCategoryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->count = (guint) 0;
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->cancellable;
		g_cancellable_set_error_if_cancelled (_data_->_tmp0_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch8_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = tracker_query_new ();
		_data_->query = _data_->_tmp1_;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->query;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->_search_term;
		tracker_query_set_criteria (_data_->_tmp2_, _data_->_tmp3_);
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->query;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->_search_tags;
		tracker_query_set_tags (_data_->_tmp4_, _data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->query;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->query_data;
		_data_->_tmp9_ = 0;
		_data_->_tmp9_ = (*_data_->_tmp8_).type;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->query_data;
		_data_->_tmp11_ = 0;
		_data_->_tmp11_ = (*_data_->_tmp10_).match;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->cancellable;
		_data_->_state_ = 1;
		tracker_query_get_count_async (_data_->_tmp7_, _data_->_tmp9_, _data_->_tmp11_, _data_->_tmp12_, tracker_result_store_load_category_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp13_ = 0U;
		_data_->_tmp13_ = tracker_query_get_count_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp6_ = _data_->_tmp13_;
		if (_data_->_inner_error_ != NULL) {
			_tracker_query_unref0 (_data_->query);
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch8_g_io_error;
			}
			_tracker_query_unref0 (_data_->query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->count = _data_->_tmp6_;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->cancellable;
		g_cancellable_set_error_if_cancelled (_data_->_tmp14_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			_tracker_query_unref0 (_data_->query);
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch8_g_io_error;
			}
			_tracker_query_unref0 (_data_->query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_tracker_query_unref0 (_data_->query);
	}
	goto __finally8;
	__catch8_g_io_error:
	{
		_data_->ie = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->cancellable;
		_data_->_tmp16_ = FALSE;
		_data_->_tmp16_ = g_cancellable_is_cancelled (_data_->_tmp15_);
		if (!_data_->_tmp16_) {
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->ie;
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp17_->message;
			g_warning ("tracker-result-store.vala:226: Could not get count: %s\n", _data_->_tmp18_);
		}
		_g_error_free0 (_data_->ie);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally8:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp19_ = 0U;
	_data_->_tmp19_ = _data_->count;
	if (_data_->_tmp19_ != ((guint) 0)) {
		_data_->_tmp20_ = 0U;
		_data_->_tmp20_ = _data_->count;
		_data_->_tmp21_ = 0U;
		_data_->_tmp21_ = _data_->self->priv->_limit;
		if (_data_->_tmp20_ > _data_->_tmp21_) {
			g_signal_emit_by_name (_data_->self, "result-overflow");
			_data_->_tmp22_ = 0U;
			_data_->_tmp22_ = _data_->self->priv->_limit;
			_data_->count = _data_->_tmp22_;
		}
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = tracker_result_store_category_node_new ();
		_tracker_result_store_category_node_unref0 (_data_->cat);
		_data_->cat = _data_->_tmp23_;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->cat;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->query_data;
		_data_->_tmp26_ = 0;
		_data_->_tmp26_ = (*_data_->_tmp25_).type;
		_data_->_tmp24_->type = _data_->_tmp26_;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->cat;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->query_data;
		_data_->_tmp27_->query = _data_->_tmp28_;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->cat;
		_data_->_tmp30_ = 0U;
		_data_->_tmp30_ = _data_->count;
		_data_->_tmp31_ = 0;
		_data_->_tmp31_ = (gint) _data_->_tmp30_;
		_data_->_tmp29_->results = g_renew (TrackerResultStoreResultNode, _data_->_tmp29_->results, (gint) _data_->_tmp30_);
		(_data_->_tmp31_ > _data_->_tmp29_->results_length1) ? memset (_data_->_tmp29_->results + _data_->_tmp29_->results_length1, 0, sizeof (TrackerResultStoreResultNode) * (_data_->_tmp31_ - _data_->_tmp29_->results_length1)) : NULL;
		_data_->_tmp29_->results_length1 = _data_->_tmp31_;
		_data_->_tmp29_->_results_size_ = _data_->_tmp31_;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->self->priv->categories;
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->cat;
		_data_->_tmp34_ = NULL;
		_data_->_tmp34_ = _tracker_result_store_category_node_ref0 (_data_->_tmp33_);
		g_ptr_array_add (_data_->_tmp32_, _data_->_tmp34_);
		memset (&_data_->iter, 0, sizeof (GtkTreeIter));
		_data_->_tmp35_ = 0;
		_data_->_tmp35_ = _data_->self->priv->timestamp;
		_data_->iter.stamp = _data_->_tmp35_;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->cat;
		_data_->iter.user_data = _data_->_tmp36_;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37__length1 = 0;
		_data_->_tmp37_ = _data_->self->priv->queries;
		_data_->_tmp37__length1 = _data_->self->priv->queries_length1;
		if (_data_->_tmp37__length1 > 1) {
			memset (&_data_->_tmp38_, 0, sizeof (GtkTreeIter));
			_data_->_tmp38_ = _data_->iter;
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp38_);
			_gtk_tree_path_free0 (_data_->path);
			_data_->path = _data_->_tmp39_;
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = _data_->path;
			memset (&_data_->_tmp41_, 0, sizeof (GtkTreeIter));
			_data_->_tmp41_ = _data_->iter;
			gtk_tree_model_row_inserted ((GtkTreeModel*) _data_->self, _data_->_tmp40_, &_data_->_tmp41_);
		}
		{
			_data_->i = 0;
			_data_->_tmp42_ = TRUE;
			while (TRUE) {
				_data_->_tmp43_ = FALSE;
				_data_->_tmp43_ = _data_->_tmp42_;
				if (!_data_->_tmp43_) {
					_data_->_tmp44_ = 0;
					_data_->_tmp44_ = _data_->i;
					_data_->i = _data_->_tmp44_ + 1;
				}
				_data_->_tmp42_ = FALSE;
				_data_->_tmp45_ = 0;
				_data_->_tmp45_ = _data_->i;
				_data_->_tmp46_ = 0U;
				_data_->_tmp46_ = _data_->count;
				if (!(((guint) _data_->_tmp45_) < _data_->_tmp46_)) {
					break;
				}
				_data_->_tmp47_ = NULL;
				_data_->_tmp47_ = _data_->cat;
				_data_->_tmp48_ = NULL;
				_data_->_tmp48__length1 = 0;
				_data_->_tmp48_ = _data_->_tmp47_->results;
				_data_->_tmp48__length1 = _data_->_tmp47_->results_length1;
				_data_->_tmp49_ = 0;
				_data_->_tmp49_ = _data_->i;
				_data_->res = &_data_->_tmp48_[_data_->_tmp49_];
				_data_->_tmp50_ = NULL;
				_data_->_tmp50_ = _data_->res;
				_data_->_tmp51_ = 0;
				_data_->_tmp51_ = _data_->self->priv->n_columns;
				_data_->_tmp52_ = NULL;
				_data_->_tmp52_ = g_new0 (gchar*, _data_->_tmp51_ + 1);
				(*_data_->_tmp50_).values = (_vala_array_free ((*_data_->_tmp50_).values, (*_data_->_tmp50_).values_length1, (GDestroyNotify) g_free), NULL);
				(*_data_->_tmp50_).values = _data_->_tmp52_;
				(*_data_->_tmp50_).values_length1 = _data_->_tmp51_;
				(*_data_->_tmp50_)._values_size_ = (*_data_->_tmp50_).values_length1;
				_data_->_tmp53_ = NULL;
				_data_->_tmp53_ = _data_->res;
				_data_->iter.user_data2 = _data_->_tmp53_;
				_data_->_tmp54_ = 0;
				_data_->_tmp54_ = _data_->i;
				_data_->_tmp55_ = NULL;
				_data_->_tmp55_ = GINT_TO_POINTER (_data_->_tmp54_);
				_data_->iter.user_data3 = _data_->_tmp55_;
				memset (&_data_->_tmp56_, 0, sizeof (GtkTreeIter));
				_data_->_tmp56_ = _data_->iter;
				_data_->_tmp57_ = NULL;
				_data_->_tmp57_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp56_);
				_gtk_tree_path_free0 (_data_->path);
				_data_->path = _data_->_tmp57_;
				_data_->_tmp58_ = NULL;
				_data_->_tmp58_ = _data_->cat;
				_data_->_tmp59_ = 0;
				_data_->_tmp59_ = _data_->_tmp58_->count;
				_data_->_tmp58_->count = _data_->_tmp59_ + 1;
				_data_->_tmp60_ = NULL;
				_data_->_tmp60_ = _data_->path;
				memset (&_data_->_tmp61_, 0, sizeof (GtkTreeIter));
				_data_->_tmp61_ = _data_->iter;
				gtk_tree_model_row_inserted ((GtkTreeModel*) _data_->self, _data_->_tmp60_, &_data_->_tmp61_);
			}
		}
		_data_->_tmp62_ = NULL;
		_data_->_tmp62__length1 = 0;
		_data_->_tmp62_ = _data_->self->priv->queries;
		_data_->_tmp62__length1 = _data_->self->priv->queries_length1;
		if (_data_->_tmp62__length1 > 1) {
			_data_->iter.user_data2 = NULL;
			_data_->iter.user_data3 = NULL;
			memset (&_data_->_tmp63_, 0, sizeof (GtkTreeIter));
			_data_->_tmp63_ = _data_->iter;
			_data_->_tmp64_ = NULL;
			_data_->_tmp64_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp63_);
			_gtk_tree_path_free0 (_data_->path);
			_data_->path = _data_->_tmp64_;
			_data_->_tmp65_ = NULL;
			_data_->_tmp65_ = _data_->path;
			memset (&_data_->_tmp66_, 0, sizeof (GtkTreeIter));
			_data_->_tmp66_ = _data_->iter;
			gtk_tree_model_row_changed ((GtkTreeModel*) _data_->self, _data_->_tmp65_, &_data_->_tmp66_);
		}
		_gtk_tree_path_free0 (_data_->path);
		_tracker_result_store_category_node_unref0 (_data_->cat);
	}
	_data_->_tmp67_ = NULL;
	_data_->_tmp67_ = _data_->self->priv->running_operations;
	_data_->_tmp68_ = 0;
	_data_->_tmp68_ = g_ptr_array_get_length (_data_->_tmp67_);
	_data_->_tmp69_ = 0;
	_data_->_tmp69_ = _data_->_tmp68_;
	if (_data_->_tmp69_ == 0) {
		tracker_result_store_set_active (_data_->self, FALSE);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tracker_result_store_clear_results (TrackerResultStore* self) {
	gint j = 0;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GPtrArray* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		TrackerResultStoreCategoryNode* cat = NULL;
		GPtrArray* _tmp3_ = NULL;
		gconstpointer _tmp4_ = NULL;
		TrackerResultStoreCategoryNode* _tmp5_ = NULL;
		GtkTreeIter iter = {0};
		GtkTreePath* path = NULL;
		TrackerResultStoreCategoryNode* _tmp6_ = NULL;
		TrackerResultStoreResultNode* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp8_ = 0;
		TrackerResultStoreCategoryNode* _tmp9_ = NULL;
		TrackerResultStoreQueryData* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		GPtrArray* _tmp30_ = NULL;
		TrackerResultStoreCategoryNode* _tmp31_ = NULL;
		_tmp0_ = self->priv->categories;
		_tmp1_ = g_ptr_array_get_length (_tmp0_);
		_tmp2_ = _tmp1_;
		if (!(_tmp2_ > 0)) {
			break;
		}
		_tmp3_ = self->priv->categories;
		_tmp4_ = g_ptr_array_index (_tmp3_, (guint) 0);
		_tmp5_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp4_);
		cat = _tmp5_;
		_tmp6_ = cat;
		_tmp7_ = _tmp6_->results;
		_tmp7__length1 = _tmp6_->results_length1;
		if (_tmp7__length1 == 0) {
			_gtk_tree_path_free0 (path);
			_tracker_result_store_category_node_unref0 (cat);
			continue;
		}
		memset (&iter, 0, sizeof (GtkTreeIter));
		_tmp8_ = self->priv->timestamp;
		iter.stamp = _tmp8_;
		_tmp9_ = cat;
		iter.user_data = _tmp9_;
		{
			TrackerResultStoreCategoryNode* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gboolean _tmp12_ = FALSE;
			_tmp10_ = cat;
			_tmp11_ = _tmp10_->count;
			j = _tmp11_ - 1;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_ = FALSE;
				gint _tmp15_ = 0;
				TrackerResultStoreCategoryNode* _tmp16_ = NULL;
				TrackerResultStoreResultNode* _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				void* _tmp20_ = NULL;
				GtkTreeIter _tmp21_ = {0};
				GtkTreePath* _tmp22_ = NULL;
				GtkTreePath* _tmp23_ = NULL;
				TrackerResultStoreCategoryNode* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					gint _tmp14_ = 0;
					_tmp14_ = j;
					j = _tmp14_ - 1;
				}
				_tmp12_ = FALSE;
				_tmp15_ = j;
				if (!(_tmp15_ >= 0)) {
					break;
				}
				_tmp16_ = cat;
				_tmp17_ = _tmp16_->results;
				_tmp17__length1 = _tmp16_->results_length1;
				_tmp18_ = j;
				iter.user_data2 = &_tmp17_[_tmp18_];
				_tmp19_ = j;
				_tmp20_ = GINT_TO_POINTER (_tmp19_);
				iter.user_data3 = _tmp20_;
				_tmp21_ = iter;
				_tmp22_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp21_);
				_gtk_tree_path_free0 (path);
				path = _tmp22_;
				_tmp23_ = path;
				gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp23_);
				_tmp24_ = cat;
				_tmp25_ = _tmp24_->count;
				_tmp24_->count = _tmp25_ - 1;
			}
		}
		_tmp26_ = self->priv->queries;
		_tmp26__length1 = self->priv->queries_length1;
		if (_tmp26__length1 > 1) {
			GtkTreeIter _tmp27_ = {0};
			GtkTreePath* _tmp28_ = NULL;
			GtkTreePath* _tmp29_ = NULL;
			iter.user_data2 = NULL;
			iter.user_data3 = NULL;
			_tmp27_ = iter;
			_tmp28_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp27_);
			_gtk_tree_path_free0 (path);
			path = _tmp28_;
			_tmp29_ = path;
			gtk_tree_model_row_deleted ((GtkTreeModel*) self, _tmp29_);
		}
		_tmp30_ = self->priv->categories;
		_tmp31_ = cat;
		g_ptr_array_remove (_tmp30_, _tmp31_);
		_gtk_tree_path_free0 (path);
		_tracker_result_store_category_node_unref0 (cat);
	}
}


static gint tracker_result_store_find_nth_category_index (TrackerResultStore* self, TrackerResultStoreCategoryNode* node, gint n) {
	gint result = 0;
	gint i = 0;
	TrackerResultStoreCategoryNode* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = node;
	if (_tmp0_ == NULL) {
		gint _tmp1_ = 0;
		_tmp1_ = n;
		result = _tmp1_;
		return result;
	}
	{
		gboolean _tmp2_ = FALSE;
		i = 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp3_ = FALSE;
			gint _tmp5_ = 0;
			GPtrArray* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			TrackerResultStoreCategoryNode* cat = NULL;
			GPtrArray* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gconstpointer _tmp11_ = NULL;
			TrackerResultStoreCategoryNode* _tmp12_ = NULL;
			TrackerResultStoreCategoryNode* _tmp13_ = NULL;
			TrackerResultStoreCategoryNode* _tmp14_ = NULL;
			_tmp3_ = _tmp2_;
			if (!_tmp3_) {
				gint _tmp4_ = 0;
				_tmp4_ = i;
				i = _tmp4_ + 1;
			}
			_tmp2_ = FALSE;
			_tmp5_ = i;
			_tmp6_ = self->priv->categories;
			_tmp7_ = g_ptr_array_get_length (_tmp6_);
			_tmp8_ = _tmp7_;
			if (!(_tmp5_ < _tmp8_)) {
				break;
			}
			_tmp9_ = self->priv->categories;
			_tmp10_ = i;
			_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
			_tmp12_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp11_);
			_tracker_result_store_category_node_unref0 (cat);
			cat = _tmp12_;
			_tmp13_ = cat;
			_tmp14_ = node;
			if (_tmp13_ == _tmp14_) {
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				_tmp15_ = i;
				_tmp16_ = n;
				result = _tmp15_ + _tmp16_;
				_tracker_result_store_category_node_unref0 (cat);
				return result;
			}
			_tracker_result_store_category_node_unref0 (cat);
		}
	}
	result = -1;
	return result;
}


static gint tracker_result_store_filled_categories_count (TrackerResultStore* self) {
	gint result = 0;
	gint i = 0;
	gint n = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp3_ = 0;
			GPtrArray* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			TrackerResultStoreCategoryNode* cat = NULL;
			GPtrArray* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gconstpointer _tmp9_ = NULL;
			TrackerResultStoreCategoryNode* _tmp10_ = NULL;
			TrackerResultStoreCategoryNode* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				gint _tmp2_ = 0;
				_tmp2_ = i;
				i = _tmp2_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = i;
			_tmp4_ = self->priv->categories;
			_tmp5_ = g_ptr_array_get_length (_tmp4_);
			_tmp6_ = _tmp5_;
			if (!(_tmp3_ < _tmp6_)) {
				break;
			}
			_tmp7_ = self->priv->categories;
			_tmp8_ = i;
			_tmp9_ = g_ptr_array_index (_tmp7_, (guint) _tmp8_);
			_tmp10_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp9_);
			_tracker_result_store_category_node_unref0 (cat);
			cat = _tmp10_;
			_tmp11_ = cat;
			_tmp12_ = _tmp11_->count;
			if (_tmp12_ > 0) {
				gint _tmp13_ = 0;
				_tmp13_ = n;
				n = _tmp13_ + 1;
			}
			_tracker_result_store_category_node_unref0 (cat);
		}
	}
	result = n;
	return result;
}


static GType tracker_result_store_real_get_column_type (GtkTreeModel* base, gint index_) {
	TrackerResultStore * self;
	GType result = 0UL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = (TrackerResultStore*) base;
	_tmp0_ = index_;
	_tmp1_ = self->priv->n_columns;
	if (_tmp0_ == _tmp1_) {
		result = GDK_TYPE_PIXBUF;
		return result;
	} else {
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp2_ = index_;
		_tmp3_ = self->priv->n_columns;
		if (_tmp2_ == (_tmp3_ + 1)) {
			result = TRACKER_QUERY_TYPE_TYPE;
			return result;
		} else {
			result = G_TYPE_STRING;
			return result;
		}
	}
}


static GtkTreeModelFlags tracker_result_store_real_get_flags (GtkTreeModel* base) {
	TrackerResultStore * self;
	GtkTreeModelFlags result = 0;
	GtkTreeModelFlags flags = 0;
	TrackerResultStoreQueryData* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (TrackerResultStore*) base;
	flags = GTK_TREE_MODEL_ITERS_PERSIST;
	_tmp0_ = self->priv->queries;
	_tmp0__length1 = self->priv->queries_length1;
	if (_tmp0__length1 == 1) {
		GtkTreeModelFlags _tmp1_ = 0;
		_tmp1_ = flags;
		flags = _tmp1_ | GTK_TREE_MODEL_LIST_ONLY;
	}
	result = flags;
	return result;
}


static gboolean tracker_result_store_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	TrackerResultStore * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gint* indices = NULL;
	GtkTreePath* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint indices_length1 = 0;
	gint _indices_size_ = 0;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i = 0;
	TrackerResultStoreQueryData* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp23_ = 0;
	TrackerResultStoreCategoryNode* _tmp24_ = NULL;
	GtkTreePath* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	self = (TrackerResultStore*) base;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp2_ = gtk_tree_path_get_indices_with_depth (_tmp0_, &_tmp1_);
	indices = _tmp2_;
	indices_length1 = _tmp1_;
	_indices_size_ = indices_length1;
	i = 0;
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp3_ = self->priv->queries;
	_tmp3__length1 = self->priv->queries_length1;
	if (_tmp3__length1 > 1) {
		gint* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GPtrArray* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GPtrArray* _tmp10_ = NULL;
		gint* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gconstpointer _tmp14_ = NULL;
		TrackerResultStoreCategoryNode* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp4_ = indices;
		_tmp4__length1 = indices_length1;
		_tmp5_ = i;
		_tmp6_ = _tmp4_[_tmp5_];
		_tmp7_ = self->priv->categories;
		_tmp8_ = g_ptr_array_get_length (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp6_ >= _tmp9_) {
			_vala_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		}
		_tmp10_ = self->priv->categories;
		_tmp11_ = indices;
		_tmp11__length1 = indices_length1;
		_tmp12_ = i;
		_tmp13_ = _tmp11_[_tmp12_];
		_tmp14_ = g_ptr_array_index (_tmp10_, (guint) _tmp13_);
		_tmp15_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp14_);
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp15_;
		_tmp16_ = i;
		i = _tmp16_ + 1;
	} else {
		GPtrArray* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		GPtrArray* _tmp20_ = NULL;
		gconstpointer _tmp21_ = NULL;
		TrackerResultStoreCategoryNode* _tmp22_ = NULL;
		_tmp17_ = self->priv->categories;
		_tmp18_ = g_ptr_array_get_length (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ == 0) {
			_vala_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		}
		_tmp20_ = self->priv->categories;
		_tmp21_ = g_ptr_array_index (_tmp20_, (guint) 0);
		_tmp22_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp21_);
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp22_;
	}
	_tmp23_ = self->priv->timestamp;
	_vala_iter.stamp = _tmp23_;
	_tmp24_ = cat;
	_vala_iter.user_data = _tmp24_;
	_tmp25_ = path;
	_tmp26_ = gtk_tree_path_get_depth (_tmp25_);
	_tmp27_ = i;
	if (_tmp26_ == (_tmp27_ + 1)) {
		gint* _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		TrackerResultStoreCategoryNode* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		TrackerResultStoreCategoryNode* _tmp33_ = NULL;
		TrackerResultStoreResultNode* _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		gint* _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		gint* _tmp38_ = NULL;
		gint _tmp38__length1 = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		void* _tmp41_ = NULL;
		_tmp28_ = indices;
		_tmp28__length1 = indices_length1;
		_tmp29_ = i;
		_tmp30_ = _tmp28_[_tmp29_];
		_tmp31_ = cat;
		_tmp32_ = _tmp31_->count;
		if (_tmp30_ >= _tmp32_) {
			_vala_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		}
		_tmp33_ = cat;
		_tmp34_ = _tmp33_->results;
		_tmp34__length1 = _tmp33_->results_length1;
		_tmp35_ = indices;
		_tmp35__length1 = indices_length1;
		_tmp36_ = i;
		_tmp37_ = _tmp35_[_tmp36_];
		_vala_iter.user_data2 = &_tmp34_[_tmp37_];
		_tmp38_ = indices;
		_tmp38__length1 = indices_length1;
		_tmp39_ = i;
		_tmp40_ = _tmp38_[_tmp39_];
		_tmp41_ = GINT_TO_POINTER (_tmp40_);
		_vala_iter.user_data3 = _tmp41_;
	}
	result = TRUE;
	_tracker_result_store_category_node_unref0 (cat);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static gint tracker_result_store_real_get_n_columns (GtkTreeModel* base) {
	TrackerResultStore * self;
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	self = (TrackerResultStore*) base;
	_tmp0_ = self->priv->n_columns;
	_tmp1_ = self->priv->n_extra_columns;
	result = _tmp0_ + _tmp1_;
	return result;
}


static GtkTreePath* tracker_result_store_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	GtkTreePath* result = NULL;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_ = NULL;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i = 0;
	TrackerResultStoreQueryData* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GtkTreeIter _tmp18_ = {0};
	void* _tmp19_ = NULL;
	self = (TrackerResultStore*) base;
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_tree_path_new ();
	path = _tmp0_;
	_tmp1_ = self->priv->queries;
	_tmp1__length1 = self->priv->queries_length1;
	if (_tmp1__length1 > 1) {
		{
			gboolean _tmp2_ = FALSE;
			i = 0;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GPtrArray* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gconstpointer _tmp11_ = NULL;
				TrackerResultStoreCategoryNode* _tmp12_ = NULL;
				TrackerResultStoreCategoryNode* _tmp13_ = NULL;
				GtkTreeIter _tmp14_ = {0};
				void* _tmp15_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->priv->categories;
				_tmp7_ = g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = self->priv->categories;
				_tmp10_ = i;
				_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
				_tmp12_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp11_);
				_tracker_result_store_category_node_unref0 (cat);
				cat = _tmp12_;
				_tmp13_ = cat;
				_tmp14_ = *iter;
				_tmp15_ = _tmp14_.user_data;
				if (_tmp13_ == _tmp15_) {
					GtkTreePath* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					_tmp16_ = path;
					_tmp17_ = i;
					gtk_tree_path_append_index (_tmp16_, _tmp17_);
					break;
				}
			}
		}
	}
	_tmp18_ = *iter;
	_tmp19_ = _tmp18_.user_data2;
	if (_tmp19_ != NULL) {
		GtkTreePath* _tmp20_ = NULL;
		GtkTreeIter _tmp21_ = {0};
		void* _tmp22_ = NULL;
		_tmp20_ = path;
		_tmp21_ = *iter;
		_tmp22_ = _tmp21_.user_data3;
		gtk_tree_path_append_index (_tmp20_, (gint) ((glong) _tmp22_));
	}
	result = path;
	_tracker_result_store_category_node_unref0 (cat);
	return result;
}


static void tracker_result_store_fetch_thumbnail_data_free (gpointer _data) {
	TrackerResultStoreFetchThumbnailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TrackerResultStoreFetchThumbnailData, _data_);
}


static void tracker_result_store_fetch_thumbnail (TrackerResultStore* self, GtkTreeIter* iter, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResultStoreFetchThumbnailData* _data_;
	TrackerResultStore* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	_data_ = g_slice_new0 (TrackerResultStoreFetchThumbnailData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_result_store_fetch_thumbnail);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_result_store_fetch_thumbnail_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *iter;
	_data_->iter = _tmp1_;
	tracker_result_store_fetch_thumbnail_co (_data_);
}


static void tracker_result_store_fetch_thumbnail_finish (TrackerResultStore* self, GAsyncResult* _res_) {
	TrackerResultStoreFetchThumbnailData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void tracker_result_store_fetch_thumbnail_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResultStoreFetchThumbnailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_result_store_fetch_thumbnail_co (_data_);
}


static gboolean tracker_result_store_fetch_thumbnail_co (TrackerResultStoreFetchThumbnailData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->pixbuf = NULL;
	memset (&_data_->_tmp0_, 0, sizeof (GtkTreeIter));
	_data_->_tmp0_ = _data_->iter;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_.user_data2;
	_data_->_result_ = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_result_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3__length1 = 0;
	_data_->_tmp3_ = (*_data_->_tmp2_).values;
	_data_->_tmp3__length1 = (*_data_->_tmp2_).values_length1;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->_tmp3_[1];
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = g_file_new_for_uri (_data_->_tmp4_);
	_g_object_unref0 (_data_->file);
	_data_->file = _data_->_tmp5_;
	{
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->file;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp7_, "thumbnail::path,standard::icon", G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp8_, tracker_result_store_fetch_thumbnail_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_file_query_info_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp6_ = _data_->_tmp9_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch9_g_error;
		}
		_g_object_unref0 (_data_->info);
		_data_->info = _data_->_tmp6_;
	}
	goto __finally9;
	__catch9_g_error:
	{
		_data_->ie = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->self->priv->cancellable;
		_data_->_tmp11_ = FALSE;
		_data_->_tmp11_ = g_cancellable_is_cancelled (_data_->_tmp10_);
		if (!_data_->_tmp11_) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->ie;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			g_warning ("tracker-result-store.vala:505: Could not get thumbnail: %s", _data_->_tmp13_);
		}
		_g_error_free0 (_data_->ie);
		_g_object_unref0 (_data_->pixbuf);
		_g_free0 (_data_->thumb_path);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->file);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally9:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->pixbuf);
		_g_free0 (_data_->thumb_path);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->info;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = g_file_info_get_attribute_byte_string (_data_->_tmp14_, "thumbnail::path");
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_strdup (_data_->_tmp15_);
	_g_free0 (_data_->thumb_path);
	_data_->thumb_path = _data_->_tmp16_;
	{
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->thumb_path;
		if (_data_->_tmp17_ != NULL) {
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->thumb_path;
			_data_->_tmp20_ = 0;
			_data_->_tmp20_ = _data_->self->priv->_icon_size;
			_data_->_tmp21_ = 0;
			_data_->_tmp21_ = _data_->self->priv->_icon_size;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = gdk_pixbuf_new_from_file_at_size (_data_->_tmp19_, _data_->_tmp20_, _data_->_tmp21_, &_data_->_inner_error_);
			_data_->_tmp18_ = _data_->_tmp22_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			_g_object_unref0 (_data_->pixbuf);
			_data_->pixbuf = _data_->_tmp18_;
		} else {
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->info;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = g_file_info_get_attribute_object (_data_->_tmp23_, "standard::icon");
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, G_TYPE_ICON, GIcon));
			_g_object_unref0 (_data_->icon);
			_data_->icon = _data_->_tmp25_;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->icon;
			if (_data_->_tmp26_ == NULL) {
				_gtk_icon_info_free0 (_data_->icon_info);
				_g_object_unref0 (_data_->icon);
				_g_object_unref0 (_data_->pixbuf);
				_g_free0 (_data_->thumb_path);
				_g_object_unref0 (_data_->info);
				_g_object_unref0 (_data_->file);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = gdk_screen_get_default ();
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = gtk_icon_theme_get_for_screen (_data_->_tmp27_);
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _g_object_ref0 (_data_->_tmp28_);
			_data_->theme = _data_->_tmp29_;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->theme;
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = _data_->icon;
			_data_->_tmp32_ = 0;
			_data_->_tmp32_ = _data_->self->priv->_icon_size;
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = gtk_icon_theme_lookup_by_gicon (_data_->_tmp30_, _data_->_tmp31_, _data_->_tmp32_, 0);
			_gtk_icon_info_free0 (_data_->icon_info);
			_data_->icon_info = _data_->_tmp33_;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = _data_->icon_info;
			if (_data_->_tmp34_ == NULL) {
				_g_object_unref0 (_data_->theme);
				_gtk_icon_info_free0 (_data_->icon_info);
				_g_object_unref0 (_data_->icon);
				_g_object_unref0 (_data_->pixbuf);
				_g_free0 (_data_->thumb_path);
				_g_object_unref0 (_data_->info);
				_g_object_unref0 (_data_->file);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = _data_->icon_info;
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = gtk_icon_info_load_icon (_data_->_tmp36_, &_data_->_inner_error_);
			_data_->_tmp35_ = _data_->_tmp37_;
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->theme);
				_gtk_icon_info_free0 (_data_->icon_info);
				_g_object_unref0 (_data_->icon);
				goto __catch10_g_error;
			}
			_g_object_unref0 (_data_->pixbuf);
			_data_->pixbuf = _data_->_tmp35_;
			_g_object_unref0 (_data_->theme);
			_gtk_icon_info_free0 (_data_->icon_info);
			_g_object_unref0 (_data_->icon);
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->e;
		_data_->_tmp39_ = NULL;
		_data_->_tmp39_ = _data_->_tmp38_->message;
		g_warning ("tracker-result-store.vala:535: Could not get icon pixbuf: %s\n", _data_->_tmp39_);
		_g_error_free0 (_data_->e);
	}
	__finally10:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->pixbuf);
		_g_free0 (_data_->thumb_path);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp40_ = NULL;
	_data_->_tmp40_ = _data_->pixbuf;
	if (_data_->_tmp40_ != NULL) {
		_data_->_tmp41_ = NULL;
		_data_->_tmp41_ = _data_->_result_;
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = _data_->pixbuf;
		_data_->_tmp43_ = NULL;
		_data_->_tmp43_ = _g_object_ref0 (_data_->_tmp42_);
		_g_object_unref0 ((*_data_->_tmp41_).pixbuf);
		(*_data_->_tmp41_).pixbuf = _data_->_tmp43_;
		memset (&_data_->_tmp44_, 0, sizeof (GtkTreeIter));
		_data_->_tmp44_ = _data_->iter;
		_data_->_tmp45_ = NULL;
		_data_->_tmp45_ = gtk_tree_model_get_path ((GtkTreeModel*) _data_->self, &_data_->_tmp44_);
		_gtk_tree_path_free0 (_data_->path);
		_data_->path = _data_->_tmp45_;
		_data_->_tmp46_ = NULL;
		_data_->_tmp46_ = _data_->path;
		memset (&_data_->_tmp47_, 0, sizeof (GtkTreeIter));
		_data_->_tmp47_ = _data_->iter;
		gtk_tree_model_row_changed ((GtkTreeModel*) _data_->self, _data_->_tmp46_, &_data_->_tmp47_);
		_gtk_tree_path_free0 (_data_->path);
	}
	_g_object_unref0 (_data_->pixbuf);
	_g_free0 (_data_->thumb_path);
	_g_object_unref0 (_data_->info);
	_g_object_unref0 (_data_->file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tracker_result_store_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	TrackerResultStore * self;
	GValue _vala_value = {0};
	TrackerResultStoreCategoryNode* cat = NULL;
	gint _tmp0_ = 0;
	GType _tmp1_ = 0UL;
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkTreeIter _tmp7_ = {0};
	void* _tmp8_ = NULL;
	TrackerResultStoreCategoryNode* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkTreeIter _tmp14_ = {0};
	void* _tmp15_ = NULL;
	self = (TrackerResultStore*) base;
	g_return_if_fail (iter != NULL);
	_tmp0_ = column;
	_tmp1_ = gtk_tree_model_get_column_type ((GtkTreeModel*) self, _tmp0_);
	g_value_init (&_tmp2_, _tmp1_);
	G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
	_vala_value = _tmp2_;
	_tmp3_ = _vala_value;
	_tmp4_ = column;
	_tmp5_ = self->priv->n_columns;
	_tmp6_ = self->priv->n_extra_columns;
	if (_tmp4_ >= (_tmp5_ + _tmp6_)) {
		_tracker_result_store_category_node_unref0 (cat);
		if (value) {
			*value = _vala_value;
		} else {
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
		}
		return;
	}
	_tmp7_ = *iter;
	_tmp8_ = _tmp7_.user_data;
	_tmp9_ = _tracker_result_store_category_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode));
	_tracker_result_store_category_node_unref0 (cat);
	cat = _tmp9_;
	_tmp10_ = column;
	_tmp11_ = self->priv->n_columns;
	if (_tmp10_ == (_tmp11_ + 1)) {
		TrackerResultStoreCategoryNode* _tmp12_ = NULL;
		TrackerQueryType _tmp13_ = 0;
		_tmp12_ = cat;
		_tmp13_ = _tmp12_->type;
		g_value_set_enum (&_vala_value, (gint) _tmp13_);
		_tracker_result_store_category_node_unref0 (cat);
		if (value) {
			*value = _vala_value;
		} else {
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
		}
		return;
	}
	_tmp14_ = *iter;
	_tmp15_ = _tmp14_.user_data2;
	if (_tmp15_ == NULL) {
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp16_ = column;
		_tmp17_ = self->priv->n_columns;
		if (_tmp16_ == _tmp17_) {
			GdkPixbuf* pixbuf = NULL;
			TrackerResultStoreCategoryNode* _tmp18_ = NULL;
			GdkPixbuf* _tmp19_ = NULL;
			GdkPixbuf* _tmp20_ = NULL;
			GdkPixbuf* _tmp21_ = NULL;
			GdkPixbuf* _tmp52_ = NULL;
			_tmp18_ = cat;
			_tmp19_ = _tmp18_->pixbuf;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp20_;
			_tmp21_ = pixbuf;
			if (_tmp21_ == NULL) {
				GtkIconTheme* theme = NULL;
				GdkScreen* _tmp22_ = NULL;
				GtkIconTheme* _tmp23_ = NULL;
				GtkIconTheme* _tmp24_ = NULL;
				gint size = 0;
				gint _tmp25_ = 0;
				TrackerResultStoreCategoryNode* _tmp26_ = NULL;
				TrackerQueryType _tmp27_ = 0;
				_tmp22_ = gdk_screen_get_default ();
				_tmp23_ = gtk_icon_theme_get_for_screen (_tmp22_);
				_tmp24_ = _g_object_ref0 (_tmp23_);
				theme = _tmp24_;
				_tmp25_ = self->priv->_icon_size;
				size = _tmp25_;
				_tmp26_ = cat;
				_tmp27_ = _tmp26_->type;
				switch (_tmp27_) {
					case TRACKER_QUERY_TYPE_APPLICATIONS:
					{
						GtkIconTheme* _tmp28_ = NULL;
						gint _tmp29_ = 0;
						GdkPixbuf* _tmp30_ = NULL;
						_tmp28_ = theme;
						_tmp29_ = size;
						_tmp30_ = tracker_pixbuf_new_from_name (_tmp28_, "package-x-generic", _tmp29_);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp30_;
						break;
					}
					case TRACKER_QUERY_TYPE_MUSIC:
					{
						GtkIconTheme* _tmp31_ = NULL;
						gint _tmp32_ = 0;
						GdkPixbuf* _tmp33_ = NULL;
						_tmp31_ = theme;
						_tmp32_ = size;
						_tmp33_ = tracker_pixbuf_new_from_name (_tmp31_, "audio-x-generic", _tmp32_);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp33_;
						break;
					}
					case TRACKER_QUERY_TYPE_IMAGES:
					{
						GtkIconTheme* _tmp34_ = NULL;
						gint _tmp35_ = 0;
						GdkPixbuf* _tmp36_ = NULL;
						_tmp34_ = theme;
						_tmp35_ = size;
						_tmp36_ = tracker_pixbuf_new_from_name (_tmp34_, "image-x-generic", _tmp35_);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp36_;
						break;
					}
					case TRACKER_QUERY_TYPE_VIDEOS:
					{
						GtkIconTheme* _tmp37_ = NULL;
						gint _tmp38_ = 0;
						GdkPixbuf* _tmp39_ = NULL;
						_tmp37_ = theme;
						_tmp38_ = size;
						_tmp39_ = tracker_pixbuf_new_from_name (_tmp37_, "video-x-generic", _tmp38_);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp39_;
						break;
					}
					case TRACKER_QUERY_TYPE_DOCUMENTS:
					{
						GtkIconTheme* _tmp40_ = NULL;
						gint _tmp41_ = 0;
						GdkPixbuf* _tmp42_ = NULL;
						_tmp40_ = theme;
						_tmp41_ = size;
						_tmp42_ = tracker_pixbuf_new_from_name (_tmp40_, "x-office-presentation", _tmp41_);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp42_;
						break;
					}
					case TRACKER_QUERY_TYPE_MAIL:
					{
						GtkIconTheme* _tmp43_ = NULL;
						gint _tmp44_ = 0;
						GdkPixbuf* _tmp45_ = NULL;
						_tmp43_ = theme;
						_tmp44_ = size;
						_tmp45_ = tracker_pixbuf_new_from_name (_tmp43_, "emblem-mail", _tmp44_);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp45_;
						break;
					}
					case TRACKER_QUERY_TYPE_FOLDERS:
					{
						GtkIconTheme* _tmp46_ = NULL;
						gint _tmp47_ = 0;
						GdkPixbuf* _tmp48_ = NULL;
						_tmp46_ = theme;
						_tmp47_ = size;
						_tmp48_ = tracker_pixbuf_new_from_name (_tmp46_, "folder", _tmp47_);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp48_;
						break;
					}
					case TRACKER_QUERY_TYPE_BOOKMARKS:
					{
						GtkIconTheme* _tmp49_ = NULL;
						gint _tmp50_ = 0;
						GdkPixbuf* _tmp51_ = NULL;
						_tmp49_ = theme;
						_tmp50_ = size;
						_tmp51_ = tracker_pixbuf_new_from_name (_tmp49_, "web-browser", _tmp50_);
						_g_object_unref0 (pixbuf);
						pixbuf = _tmp51_;
						break;
					}
					default:
					break;
				}
				_g_object_unref0 (theme);
			}
			_tmp52_ = pixbuf;
			g_value_set_object (&_vala_value, (GObject*) _tmp52_);
			_g_object_unref0 (pixbuf);
		}
	} else {
		TrackerResultStoreResultNode* _result_ = NULL;
		gint n_node = 0;
		GtkTreeIter _tmp53_ = {0};
		void* _tmp54_ = NULL;
		GtkTreeIter _tmp55_ = {0};
		void* _tmp56_ = NULL;
		TrackerResultStoreResultNode* _tmp57_ = NULL;
		gchar** _tmp58_ = NULL;
		gint _tmp58__length1 = 0;
		const gchar* _tmp59_ = NULL;
		_tmp53_ = *iter;
		_tmp54_ = _tmp53_.user_data2;
		_result_ = _tmp54_;
		_tmp55_ = *iter;
		_tmp56_ = _tmp55_.user_data3;
		n_node = (gint) ((glong) _tmp56_);
		_tmp57_ = _result_;
		_tmp58_ = (*_tmp57_).values;
		_tmp58__length1 = (*_tmp57_).values_length1;
		_tmp59_ = _tmp58_[0];
		if (_tmp59_ != NULL) {
			gint _tmp60_ = 0;
			gint _tmp61_ = 0;
			_tmp60_ = column;
			_tmp61_ = self->priv->n_columns;
			if (_tmp60_ == _tmp61_) {
				TrackerResultStoreResultNode* _tmp62_ = NULL;
				GdkPixbuf* _tmp63_ = NULL;
				_tmp62_ = _result_;
				_tmp63_ = (*_tmp62_).pixbuf;
				if (_tmp63_ != NULL) {
					TrackerResultStoreResultNode* _tmp64_ = NULL;
					GdkPixbuf* _tmp65_ = NULL;
					_tmp64_ = _result_;
					_tmp65_ = (*_tmp64_).pixbuf;
					g_value_set_object (&_vala_value, (GObject*) _tmp65_);
				} else {
					TrackerResultStoreQueryData* _tmp66_ = NULL;
					gint _tmp66__length1 = 0;
					_tmp66_ = self->priv->queries;
					_tmp66__length1 = self->priv->queries_length1;
					if (_tmp66__length1 == 1) {
						GtkTreeIter _tmp67_ = {0};
						_tmp67_ = *iter;
						tracker_result_store_fetch_thumbnail (self, &_tmp67_, NULL, NULL);
					}
				}
			} else {
				TrackerResultStoreResultNode* _tmp68_ = NULL;
				gchar** _tmp69_ = NULL;
				gint _tmp69__length1 = 0;
				gint _tmp70_ = 0;
				const gchar* _tmp71_ = NULL;
				_tmp68_ = _result_;
				_tmp69_ = (*_tmp68_).values;
				_tmp69__length1 = (*_tmp68_).values_length1;
				_tmp70_ = column;
				_tmp71_ = _tmp69_[_tmp70_];
				g_value_set_string (&_vala_value, _tmp71_);
			}
		} else {
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			TrackerResultStoreCategoryNode* _tmp74_ = NULL;
			gint _tmp75_ = 0;
			_tmp72_ = n_node;
			n_node = _tmp72_ / 100;
			_tmp73_ = n_node;
			n_node = _tmp73_ * 100;
			_tmp74_ = cat;
			_tmp75_ = n_node;
			tracker_result_store_add_operation (self, _tmp74_, _tmp75_);
		}
	}
	_tracker_result_store_category_node_unref0 (cat);
	if (value) {
		*value = _vala_value;
	} else {
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
	}
}


static gboolean tracker_result_store_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	TrackerResultStore * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	GtkTreeIter* _tmp18_ = NULL;
	void* _tmp19_ = NULL;
	GtkTreeIter* _tmp20_ = NULL;
	void* _tmp21_ = NULL;
	TrackerResultStoreCategoryNode* _tmp22_ = NULL;
	TrackerResultStoreCategoryNode* _tmp23_ = NULL;
	TrackerResultStoreResultNode* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	gint _tmp25_ = 0;
	TrackerResultStoreCategoryNode* _tmp26_ = NULL;
	TrackerResultStoreCategoryNode* _tmp27_ = NULL;
	TrackerResultStoreResultNode* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	void* _tmp29_ = NULL;
	self = (TrackerResultStore*) base;
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = parent;
	if (_tmp0_ == NULL) {
		GPtrArray* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		TrackerResultStoreQueryData* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp1_ = self->priv->categories;
		_tmp2_ = g_ptr_array_get_length (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ == 0) {
			_vala_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		}
		_tmp4_ = self->priv->queries;
		_tmp4__length1 = self->priv->queries_length1;
		if (_tmp4__length1 > 1) {
			gint i = 0;
			gint _tmp5_ = 0;
			GPtrArray* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gconstpointer _tmp8_ = NULL;
			TrackerResultStoreCategoryNode* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			TrackerResultStoreCategoryNode* _tmp11_ = NULL;
			_tmp5_ = tracker_result_store_find_nth_category_index (self, NULL, 0);
			i = _tmp5_;
			_tmp6_ = self->priv->categories;
			_tmp7_ = i;
			_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
			_tmp9_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp8_);
			_tracker_result_store_category_node_unref0 (cat);
			cat = _tmp9_;
			_tmp10_ = self->priv->timestamp;
			_vala_iter.stamp = _tmp10_;
			_tmp11_ = cat;
			_vala_iter.user_data = _tmp11_;
			result = TRUE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		} else {
			gint _tmp12_ = 0;
			GPtrArray* _tmp13_ = NULL;
			gconstpointer _tmp14_ = NULL;
			TrackerResultStoreCategoryNode* _tmp15_ = NULL;
			TrackerResultStoreResultNode* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			void* _tmp17_ = NULL;
			_tmp12_ = self->priv->timestamp;
			_vala_iter.stamp = _tmp12_;
			_tmp13_ = self->priv->categories;
			_tmp14_ = g_ptr_array_index (_tmp13_, (guint) 0);
			_vala_iter.user_data = (TrackerResultStoreCategoryNode*) _tmp14_;
			_tmp15_ = cat;
			_tmp16_ = _tmp15_->results;
			_tmp16__length1 = _tmp15_->results_length1;
			_vala_iter.user_data2 = &_tmp16_[0];
			_tmp17_ = GINT_TO_POINTER (0);
			_vala_iter.user_data3 = _tmp17_;
			result = TRUE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		}
	}
	_tmp18_ = parent;
	_tmp19_ = (*_tmp18_).user_data2;
	if (_tmp19_ != NULL) {
		_vala_iter.stamp = 0;
		result = FALSE;
		_tracker_result_store_category_node_unref0 (cat);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp20_ = parent;
	_tmp21_ = (*_tmp20_).user_data;
	_tmp22_ = _tracker_result_store_category_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode));
	_tracker_result_store_category_node_unref0 (cat);
	cat = _tmp22_;
	_tmp23_ = cat;
	_tmp24_ = _tmp23_->results;
	_tmp24__length1 = _tmp23_->results_length1;
	if (_tmp24__length1 <= 0) {
		_vala_iter.stamp = 0;
		result = FALSE;
		_tracker_result_store_category_node_unref0 (cat);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp25_ = self->priv->timestamp;
	_vala_iter.stamp = _tmp25_;
	_tmp26_ = cat;
	_vala_iter.user_data = _tmp26_;
	_tmp27_ = cat;
	_tmp28_ = _tmp27_->results;
	_tmp28__length1 = _tmp27_->results_length1;
	_vala_iter.user_data2 = &_tmp28_[0];
	_tmp29_ = GINT_TO_POINTER (0);
	_vala_iter.user_data3 = _tmp29_;
	result = TRUE;
	_tracker_result_store_category_node_unref0 (cat);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static gboolean tracker_result_store_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gboolean result = FALSE;
	GtkTreeIter _tmp0_ = {0};
	void* _tmp1_ = NULL;
	self = (TrackerResultStore*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = _tmp0_.user_data2;
	if (_tmp1_ == NULL) {
		TrackerResultStoreCategoryNode* cat = NULL;
		GtkTreeIter _tmp2_ = {0};
		void* _tmp3_ = NULL;
		TrackerResultStoreCategoryNode* _tmp4_ = NULL;
		TrackerResultStoreCategoryNode* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp2_ = *iter;
		_tmp3_ = _tmp2_.user_data;
		_tmp4_ = _tracker_result_store_category_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode));
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp4_;
		_tmp5_ = cat;
		_tmp6_ = _tmp5_->count;
		result = _tmp6_ > 0;
		_tracker_result_store_category_node_unref0 (cat);
		return result;
	}
	result = FALSE;
	return result;
}


static gint tracker_result_store_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gint result = 0;
	GtkTreeIter* _tmp0_ = NULL;
	GtkTreeIter* _tmp11_ = NULL;
	void* _tmp12_ = NULL;
	TrackerResultStoreCategoryNode* cat = NULL;
	GtkTreeIter* _tmp13_ = NULL;
	void* _tmp14_ = NULL;
	TrackerResultStoreCategoryNode* _tmp15_ = NULL;
	TrackerResultStoreCategoryNode* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	self = (TrackerResultStore*) base;
	_tmp0_ = iter;
	if (_tmp0_ == NULL) {
		TrackerResultStoreQueryData* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp1_ = self->priv->queries;
		_tmp1__length1 = self->priv->queries_length1;
		if (_tmp1__length1 > 1) {
			GPtrArray* _tmp2_ = NULL;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			_tmp2_ = self->priv->categories;
			_tmp3_ = g_ptr_array_get_length (_tmp2_);
			_tmp4_ = _tmp3_;
			result = _tmp4_ - 1;
			return result;
		} else {
			GPtrArray* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			_tmp5_ = self->priv->categories;
			_tmp6_ = g_ptr_array_get_length (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ > 0) {
				GPtrArray* _tmp8_ = NULL;
				gconstpointer _tmp9_ = NULL;
				gint _tmp10_ = 0;
				_tmp8_ = self->priv->categories;
				_tmp9_ = g_ptr_array_index (_tmp8_, (guint) 0);
				_tmp10_ = ((TrackerResultStoreCategoryNode*) _tmp9_)->count;
				result = _tmp10_;
				return result;
			} else {
				result = -1;
				return result;
			}
		}
	}
	_tmp11_ = iter;
	_tmp12_ = (*_tmp11_).user_data2;
	if (_tmp12_ != NULL) {
		result = -1;
		return result;
	}
	_tmp13_ = iter;
	_tmp14_ = (*_tmp13_).user_data;
	_tmp15_ = _tracker_result_store_category_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode));
	cat = _tmp15_;
	_tmp16_ = cat;
	_tmp17_ = _tmp16_->count;
	result = _tmp17_;
	_tracker_result_store_category_node_unref0 (cat);
	return result;
}


static gboolean tracker_result_store_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	gint i = 0;
	GtkTreeIter _tmp0_ = {0};
	void* _tmp1_ = NULL;
	TrackerResultStoreCategoryNode* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	void* _tmp4_ = NULL;
	self = (TrackerResultStore*) base;
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	_tmp1_ = _tmp0_.user_data;
	_tmp2_ = _tracker_result_store_category_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode));
	_tracker_result_store_category_node_unref0 (cat);
	cat = _tmp2_;
	_tmp3_ = *iter;
	_tmp4_ = _tmp3_.user_data2;
	if (_tmp4_ == NULL) {
		TrackerResultStoreCategoryNode* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
		gint _tmp8_ = 0;
		gboolean _tmp13_ = FALSE;
		gint _tmp14_ = 0;
		GPtrArray* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gconstpointer _tmp17_ = NULL;
		_tmp5_ = cat;
		_tmp6_ = tracker_result_store_find_nth_category_index (self, _tmp5_, 1);
		i = _tmp6_;
		_tmp8_ = i;
		if (_tmp8_ < 0) {
			_tmp7_ = TRUE;
		} else {
			gint _tmp9_ = 0;
			GPtrArray* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp9_ = i;
			_tmp10_ = self->priv->categories;
			_tmp11_ = g_ptr_array_get_length (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = _tmp9_ >= _tmp12_;
		}
		_tmp13_ = _tmp7_;
		if (_tmp13_) {
			(*iter).stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			return result;
		}
		_tmp14_ = self->priv->timestamp;
		(*iter).stamp = _tmp14_;
		_tmp15_ = self->priv->categories;
		_tmp16_ = i;
		_tmp17_ = g_ptr_array_index (_tmp15_, (guint) _tmp16_);
		(*iter).user_data = (TrackerResultStoreCategoryNode*) _tmp17_;
		result = TRUE;
		_tracker_result_store_category_node_unref0 (cat);
		return result;
	} else {
		GtkTreeIter _tmp18_ = {0};
		void* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		TrackerResultStoreCategoryNode* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		TrackerResultStoreCategoryNode* _tmp24_ = NULL;
		TrackerResultStoreResultNode* _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		void* _tmp28_ = NULL;
		_tmp18_ = *iter;
		_tmp19_ = _tmp18_.user_data3;
		i = (gint) ((glong) _tmp19_);
		_tmp20_ = i;
		i = _tmp20_ + 1;
		_tmp21_ = i;
		_tmp22_ = cat;
		_tmp23_ = _tmp22_->count;
		if (_tmp21_ >= _tmp23_) {
			(*iter).stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			return result;
		}
		_tmp24_ = cat;
		_tmp25_ = _tmp24_->results;
		_tmp25__length1 = _tmp24_->results_length1;
		_tmp26_ = i;
		(*iter).user_data2 = &_tmp25_[_tmp26_];
		_tmp27_ = i;
		_tmp28_ = GINT_TO_POINTER (_tmp27_);
		(*iter).user_data3 = _tmp28_;
		result = TRUE;
		_tracker_result_store_category_node_unref0 (cat);
		return result;
	}
	_tracker_result_store_category_node_unref0 (cat);
}


static gboolean tracker_result_store_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	TrackerResultStore * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	TrackerResultStoreCategoryNode* cat = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	self = (TrackerResultStore*) base;
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = parent;
	if (_tmp0_ != NULL) {
		GtkTreeIter* _tmp1_ = NULL;
		void* _tmp2_ = NULL;
		TrackerResultStoreCategoryNode* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		TrackerResultStoreCategoryNode* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		TrackerResultStoreCategoryNode* _tmp8_ = NULL;
		TrackerResultStoreCategoryNode* _tmp9_ = NULL;
		TrackerResultStoreResultNode* _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		void* _tmp13_ = NULL;
		_tmp1_ = parent;
		_tmp2_ = (*_tmp1_).user_data;
		_tmp3_ = _tracker_result_store_category_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode));
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp3_;
		_tmp4_ = n;
		_tmp5_ = cat;
		_tmp6_ = _tmp5_->count;
		if (_tmp4_ >= _tmp6_) {
			_vala_iter.stamp = 0;
			result = FALSE;
			_tracker_result_store_category_node_unref0 (cat);
			if (iter) {
				*iter = _vala_iter;
			}
			return result;
		}
		_tmp7_ = self->priv->timestamp;
		_vala_iter.stamp = _tmp7_;
		_tmp8_ = cat;
		_vala_iter.user_data = _tmp8_;
		_tmp9_ = cat;
		_tmp10_ = _tmp9_->results;
		_tmp10__length1 = _tmp9_->results_length1;
		_tmp11_ = n;
		_vala_iter.user_data2 = &_tmp10_[_tmp11_];
		_tmp12_ = n;
		_tmp13_ = GINT_TO_POINTER (_tmp12_);
		_vala_iter.user_data3 = _tmp13_;
		result = TRUE;
		_tracker_result_store_category_node_unref0 (cat);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	} else {
		gint index = 0;
		TrackerResultStoreQueryData* _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		GPtrArray* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gconstpointer _tmp26_ = NULL;
		TrackerResultStoreCategoryNode* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		TrackerResultStoreCategoryNode* _tmp29_ = NULL;
		TrackerResultStoreQueryData* _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		_tmp14_ = self->priv->queries;
		_tmp14__length1 = self->priv->queries_length1;
		if (_tmp14__length1 > 1) {
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gboolean _tmp17_ = FALSE;
			gint _tmp18_ = 0;
			gboolean _tmp23_ = FALSE;
			_tmp15_ = n;
			_tmp16_ = tracker_result_store_find_nth_category_index (self, NULL, _tmp15_);
			index = _tmp16_;
			_tmp18_ = index;
			if (_tmp18_ < 0) {
				_tmp17_ = TRUE;
			} else {
				gint _tmp19_ = 0;
				GPtrArray* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				_tmp19_ = index;
				_tmp20_ = self->priv->categories;
				_tmp21_ = g_ptr_array_get_length (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp17_ = _tmp19_ >= _tmp22_;
			}
			_tmp23_ = _tmp17_;
			if (_tmp23_) {
				_vala_iter.stamp = 0;
				result = FALSE;
				_tracker_result_store_category_node_unref0 (cat);
				if (iter) {
					*iter = _vala_iter;
				}
				return result;
			}
		} else {
			index = 0;
		}
		_tmp24_ = self->priv->categories;
		_tmp25_ = index;
		_tmp26_ = g_ptr_array_index (_tmp24_, (guint) _tmp25_);
		_tmp27_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp26_);
		_tracker_result_store_category_node_unref0 (cat);
		cat = _tmp27_;
		_tmp28_ = self->priv->timestamp;
		_vala_iter.stamp = _tmp28_;
		_tmp29_ = cat;
		_vala_iter.user_data = _tmp29_;
		_tmp30_ = self->priv->queries;
		_tmp30__length1 = self->priv->queries_length1;
		if (_tmp30__length1 > 1) {
			TrackerResultStoreCategoryNode* _tmp31_ = NULL;
			TrackerResultStoreResultNode* _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			void* _tmp33_ = NULL;
			_tmp31_ = cat;
			_tmp32_ = _tmp31_->results;
			_tmp32__length1 = _tmp31_->results_length1;
			_vala_iter.user_data2 = &_tmp32_[0];
			_tmp33_ = GINT_TO_POINTER (0);
			_vala_iter.user_data3 = _tmp33_;
		}
		result = TRUE;
		_tracker_result_store_category_node_unref0 (cat);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tracker_result_store_category_node_unref0 (cat);
	if (iter) {
		*iter = _vala_iter;
	}
}


static gboolean tracker_result_store_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	TrackerResultStore * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerResultStoreQueryData* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp4_ = FALSE;
	self = (TrackerResultStore*) base;
	g_return_val_if_fail (child != NULL, FALSE);
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
	_tmp1_ = self->priv->queries;
	_tmp1__length1 = self->priv->queries_length1;
	if (_tmp1__length1 > 1) {
		GtkTreeIter _tmp2_ = {0};
		void* _tmp3_ = NULL;
		_tmp2_ = *child;
		_tmp3_ = _tmp2_.user_data2;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gint _tmp5_ = 0;
		GtkTreeIter _tmp6_ = {0};
		void* _tmp7_ = NULL;
		_tmp5_ = self->priv->timestamp;
		_vala_iter.stamp = _tmp5_;
		_tmp6_ = *child;
		_tmp7_ = _tmp6_.user_data;
		_vala_iter.user_data = _tmp7_;
		_vala_iter.user_data2 = NULL;
		_vala_iter.user_data3 = NULL;
		result = TRUE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_vala_iter.stamp = 0;
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


static void tracker_result_store_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	self = (TrackerResultStore*) base;
	g_return_if_fail (iter != NULL);
}


static void tracker_result_store_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	TrackerResultStore * self;
	self = (TrackerResultStore*) base;
	g_return_if_fail (iter != NULL);
}


static void tracker_result_store_theme_changed (TrackerResultStore* self, GtkIconTheme* theme) {
	GtkTreeIter iter = {0};
	gint i = 0;
	gint j = 0;
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme != NULL);
	memset (&iter, 0, sizeof (GtkTreeIter));
	_tmp0_ = self->priv->timestamp;
	iter.stamp = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		i = 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp4_ = 0;
			GPtrArray* _tmp5_ = NULL;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			TrackerResultStoreCategoryNode* cat = NULL;
			GPtrArray* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gconstpointer _tmp10_ = NULL;
			TrackerResultStoreCategoryNode* _tmp11_ = NULL;
			TrackerResultStoreCategoryNode* _tmp12_ = NULL;
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				gint _tmp3_ = 0;
				_tmp3_ = i;
				i = _tmp3_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp4_ = i;
			_tmp5_ = self->priv->categories;
			_tmp6_ = g_ptr_array_get_length (_tmp5_);
			_tmp7_ = _tmp6_;
			if (!(_tmp4_ < _tmp7_)) {
				break;
			}
			_tmp8_ = self->priv->categories;
			_tmp9_ = i;
			_tmp10_ = g_ptr_array_index (_tmp8_, (guint) _tmp9_);
			_tmp11_ = _tracker_result_store_category_node_ref0 ((TrackerResultStoreCategoryNode*) _tmp10_);
			cat = _tmp11_;
			_tmp12_ = cat;
			iter.user_data = _tmp12_;
			{
				TrackerResultStoreCategoryNode* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
				_tmp13_ = cat;
				_tmp14_ = _tmp13_->count;
				j = _tmp14_ - 1;
				_tmp15_ = TRUE;
				while (TRUE) {
					gboolean _tmp16_ = FALSE;
					gint _tmp18_ = 0;
					TrackerResultStoreResultNode _result_ = {0};
					TrackerResultStoreCategoryNode* _tmp19_ = NULL;
					TrackerResultStoreResultNode* _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					TrackerResultStoreResultNode _tmp22_ = {0};
					TrackerResultStoreResultNode _tmp23_ = {0};
					TrackerResultStoreCategoryNode* _tmp24_ = NULL;
					TrackerResultStoreResultNode* _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					void* _tmp28_ = NULL;
					TrackerResultStoreResultNode _tmp29_ = {0};
					GdkPixbuf* _tmp30_ = NULL;
					_tmp16_ = _tmp15_;
					if (!_tmp16_) {
						gint _tmp17_ = 0;
						_tmp17_ = j;
						j = _tmp17_ - 1;
					}
					_tmp15_ = FALSE;
					_tmp18_ = j;
					if (!(_tmp18_ >= 0)) {
						break;
					}
					_tmp19_ = cat;
					_tmp20_ = _tmp19_->results;
					_tmp20__length1 = _tmp19_->results_length1;
					_tmp21_ = j;
					_tmp22_ = _tmp20_[_tmp21_];
					tracker_result_store_result_node_copy (&_tmp22_, &_tmp23_);
					_result_ = _tmp23_;
					_tmp24_ = cat;
					_tmp25_ = _tmp24_->results;
					_tmp25__length1 = _tmp24_->results_length1;
					_tmp26_ = j;
					iter.user_data2 = &_tmp25_[_tmp26_];
					_tmp27_ = j;
					_tmp28_ = GINT_TO_POINTER (_tmp27_);
					iter.user_data3 = _tmp28_;
					_tmp29_ = _result_;
					_tmp30_ = _tmp29_.pixbuf;
					if (_tmp30_ != NULL) {
						GtkTreeIter _tmp31_ = {0};
						_tmp31_ = iter;
						tracker_result_store_fetch_thumbnail (self, &_tmp31_, NULL, NULL);
					}
					tracker_result_store_result_node_destroy (&_result_);
				}
			}
			_tracker_result_store_category_node_unref0 (cat);
		}
	}
}


static void _tracker_result_store_category_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (tracker_result_store_category_node_unref (var), NULL));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _tracker_result_store_theme_changed_gtk_icon_theme_changed (GtkIconTheme* _sender, gpointer self) {
	tracker_result_store_theme_changed (self, _sender);
}


TrackerResultStore* tracker_result_store_construct (GType object_type, gint _n_columns) {
	TrackerResultStore * self = NULL;
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkIconTheme* theme = NULL;
	GdkScreen* _tmp4_ = NULL;
	GtkIconTheme* _tmp5_ = NULL;
	GtkIconTheme* _tmp6_ = NULL;
	self = (TrackerResultStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_ptr_array_new_with_free_func (_tracker_result_store_category_node_unref0_);
	_g_ptr_array_unref0 (self->priv->categories);
	self->priv->categories = _tmp0_;
	_tmp1_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->running_operations);
	self->priv->running_operations = _tmp1_;
	_tmp2_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->delayed_operations);
	self->priv->delayed_operations = _tmp2_;
	_tmp3_ = _n_columns;
	self->priv->n_columns = _tmp3_;
	self->priv->timestamp = 1;
	tracker_result_store_set_icon_size (self, 24);
	_tmp4_ = gdk_screen_get_default ();
	_tmp5_ = gtk_icon_theme_get_for_screen (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	theme = _tmp6_;
	g_signal_connect_object (theme, "changed", (GCallback) _tracker_result_store_theme_changed_gtk_icon_theme_changed, self, 0);
	_g_object_unref0 (theme);
	return self;
}


TrackerResultStore* tracker_result_store_new (gint _n_columns) {
	return tracker_result_store_construct (TRACKER_TYPE_RESULT_STORE, _n_columns);
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add3 (TrackerResultStoreQueryData** array, int* length, int* size, const TrackerResultStoreQueryData* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TrackerResultStoreQueryData, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


void tracker_result_store_add_query (TrackerResultStore* self, TrackerQueryType type, TrackerQueryMatch match, ...) {
	va_list l = {0};
	gchar* str = NULL;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	TrackerResultStoreQueryData query_data = {0};
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp10_ = 0;
	TrackerQueryType _tmp11_ = 0;
	TrackerQueryMatch _tmp12_ = 0;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	TrackerResultStoreQueryData* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	TrackerResultStoreQueryData _tmp16_ = {0};
	TrackerResultStoreQueryData _tmp17_ = {0};
	g_return_if_fail (self != NULL);
	va_start (l, match);
	str = NULL;
	args = NULL;
	args_length1 = 0;
	_args_size_ = args_length1;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_tmp1_ = _tmp0_;
			if (!_tmp1_) {
				const gchar* _tmp2_ = NULL;
				_tmp2_ = str;
				if (!(_tmp2_ != NULL)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp3_ = va_arg (l, gchar*);
			_tmp4_ = g_strdup (_tmp3_);
			_g_free0 (str);
			str = _tmp4_;
			_tmp5_ = str;
			if (_tmp5_ != NULL) {
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				_tmp6_ = args;
				_tmp6__length1 = args_length1;
				_tmp7_ = str;
				_tmp8_ = g_strdup (_tmp7_);
				_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp8_);
			}
		}
	}
	_tmp9_ = args;
	_tmp9__length1 = args_length1;
	_tmp10_ = self->priv->n_columns;
	if (_tmp9__length1 != _tmp10_) {
		g_warning ("tracker-result-store.vala:866: Arguments and number of columns doesn't" \
" match");
		tracker_result_store_query_data_destroy (&query_data);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (str);
		va_end (l);
		return;
	}
	tracker_result_store_query_data_destroy (&query_data);
	memset (&query_data, 0, sizeof (TrackerResultStoreQueryData));
	_tmp11_ = type;
	query_data.type = _tmp11_;
	_tmp12_ = match;
	query_data.match = _tmp12_;
	_tmp13_ = args;
	_tmp13__length1 = args_length1;
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup2 (_tmp13_, _tmp13__length1) : ((gpointer) _tmp13_);
	_tmp14__length1 = _tmp13__length1;
	query_data.args = (_vala_array_free (query_data.args, query_data.args_length1, (GDestroyNotify) g_free), NULL);
	query_data.args = _tmp14_;
	query_data.args_length1 = _tmp14__length1;
	query_data._args_size_ = query_data.args_length1;
	_tmp15_ = self->priv->queries;
	_tmp15__length1 = self->priv->queries_length1;
	_tmp16_ = query_data;
	tracker_result_store_query_data_copy (&_tmp16_, &_tmp17_);
	_vala_array_add3 (&self->priv->queries, &self->priv->queries_length1, &self->priv->_queries_size_, &_tmp17_);
	tracker_result_store_query_data_destroy (&query_data);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (str);
	va_end (l);
}


gboolean tracker_result_store_has_results (TrackerResultStore* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tracker_result_store_filled_categories_count (self);
	result = _tmp0_ > 0;
	return result;
}


void tracker_result_store_cancel_search (TrackerResultStore* self) {
	GCancellable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_ = NULL;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
		_g_object_unref0 (self->priv->cancellable);
		self->priv->cancellable = NULL;
	}
	tracker_result_store_clear_results (self);
}


gint tracker_result_store_get_icon_size (TrackerResultStore* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_icon_size;
	result = _tmp0_;
	return result;
}


void tracker_result_store_set_icon_size (TrackerResultStore* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_icon_size = _tmp0_;
	g_object_notify ((GObject *) self, "icon-size");
}


guint tracker_result_store_get_limit (TrackerResultStore* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_limit;
	result = _tmp0_;
	return result;
}


void tracker_result_store_set_limit (TrackerResultStore* self, guint value) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_limit = _tmp0_;
	g_object_notify ((GObject *) self, "limit");
}


const gchar* tracker_result_store_get_search_term (TrackerResultStore* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_term;
	result = _tmp0_;
	return result;
}


void tracker_result_store_set_search_term (TrackerResultStore* self, const gchar* value) {
	gint i = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GCancellable* _tmp2_ = NULL;
	GPtrArray* _tmp3_ = NULL;
	GPtrArray* _tmp4_ = NULL;
	GPtrArray* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	tracker_result_store_cancel_search (self);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_search_term);
	self->priv->_search_term = _tmp1_;
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	tracker_result_store_set_active (self, TRUE);
	_tmp3_ = g_ptr_array_new_with_free_func (_tracker_result_store_category_node_unref0_);
	_g_ptr_array_unref0 (self->priv->categories);
	self->priv->categories = _tmp3_;
	_tmp4_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->running_operations);
	self->priv->running_operations = _tmp4_;
	_tmp5_ = g_ptr_array_new_with_free_func (_g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->delayed_operations);
	self->priv->delayed_operations = _tmp5_;
	_tmp6_ = self->priv->timestamp;
	self->priv->timestamp = _tmp6_ + 1;
	{
		gboolean _tmp7_ = FALSE;
		i = 0;
		_tmp7_ = TRUE;
		while (TRUE) {
			gboolean _tmp8_ = FALSE;
			gint _tmp10_ = 0;
			TrackerResultStoreQueryData* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			TrackerResultStoreQueryData* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp13_ = 0;
			GCancellable* _tmp14_ = NULL;
			_tmp8_ = _tmp7_;
			if (!_tmp8_) {
				gint _tmp9_ = 0;
				_tmp9_ = i;
				i = _tmp9_ + 1;
			}
			_tmp7_ = FALSE;
			_tmp10_ = i;
			_tmp11_ = self->priv->queries;
			_tmp11__length1 = self->priv->queries_length1;
			if (!(_tmp10_ < _tmp11__length1)) {
				break;
			}
			_tmp12_ = self->priv->queries;
			_tmp12__length1 = self->priv->queries_length1;
			_tmp13_ = i;
			_tmp14_ = self->priv->cancellable;
			tracker_result_store_load_category (self, &_tmp12_[_tmp13_], _tmp14_, NULL, NULL);
		}
	}
	g_object_notify ((GObject *) self, "search-term");
}


GPtrArray* tracker_result_store_get_search_tags (TrackerResultStore* self) {
	GPtrArray* result;
	GPtrArray* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_tags;
	result = _tmp0_;
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


void tracker_result_store_set_search_tags (TrackerResultStore* self, GPtrArray* value) {
	GPtrArray* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
	_g_ptr_array_unref0 (self->priv->_search_tags);
	self->priv->_search_tags = _tmp1_;
	g_object_notify ((GObject *) self, "search-tags");
}


gboolean tracker_result_store_get_active (TrackerResultStore* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_active;
	result = _tmp0_;
	return result;
}


static void tracker_result_store_set_active (TrackerResultStore* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_active = _tmp0_;
	g_object_notify ((GObject *) self, "active");
}


static void _vala_TrackerResultStoreResultNode_array_free (TrackerResultStoreResultNode* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			tracker_result_store_result_node_destroy (&array[i]);
		}
	}
	g_free (array);
}


static TrackerResultStoreCategoryNode* tracker_result_store_category_node_construct (GType object_type) {
	TrackerResultStoreCategoryNode* self = NULL;
	self = (TrackerResultStoreCategoryNode*) g_type_create_instance (object_type);
	return self;
}


static TrackerResultStoreCategoryNode* tracker_result_store_category_node_new (void) {
	return tracker_result_store_category_node_construct (TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE);
}


static void tracker_result_store_value_category_node_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void tracker_result_store_value_category_node_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tracker_result_store_category_node_unref (value->data[0].v_pointer);
	}
}


static void tracker_result_store_value_category_node_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tracker_result_store_category_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer tracker_result_store_value_category_node_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* tracker_result_store_value_category_node_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TrackerResultStoreCategoryNode* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tracker_result_store_category_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* tracker_result_store_value_category_node_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerResultStoreCategoryNode** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tracker_result_store_category_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* tracker_result_store_param_spec_category_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerResultStoreParamSpecCategoryNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer tracker_result_store_value_get_category_node (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE), NULL);
	return value->data[0].v_pointer;
}


static void tracker_result_store_value_set_category_node (GValue* value, gpointer v_object) {
	TrackerResultStoreCategoryNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tracker_result_store_category_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_result_store_category_node_unref (old);
	}
}


static void tracker_result_store_value_take_category_node (GValue* value, gpointer v_object) {
	TrackerResultStoreCategoryNode* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tracker_result_store_category_node_unref (old);
	}
}


static void tracker_result_store_category_node_class_init (TrackerResultStoreCategoryNodeClass * klass) {
	tracker_result_store_category_node_parent_class = g_type_class_peek_parent (klass);
	TRACKER_RESULT_STORE_CATEGORY_NODE_CLASS (klass)->finalize = tracker_result_store_category_node_finalize;
}


static void tracker_result_store_category_node_instance_init (TrackerResultStoreCategoryNode * self) {
	self->ref_count = 1;
}


static void tracker_result_store_category_node_finalize (TrackerResultStoreCategoryNode* obj) {
	TrackerResultStoreCategoryNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_RESULT_STORE_TYPE_CATEGORY_NODE, TrackerResultStoreCategoryNode);
	self->results = (_vala_TrackerResultStoreResultNode_array_free (self->results, self->results_length1), NULL);
	_g_object_unref0 (self->pixbuf);
}


static GType tracker_result_store_category_node_get_type (void) {
	static volatile gsize tracker_result_store_category_node_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_category_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_result_store_value_category_node_init, tracker_result_store_value_category_node_free_value, tracker_result_store_value_category_node_copy_value, tracker_result_store_value_category_node_peek_pointer, "p", tracker_result_store_value_category_node_collect_value, "p", tracker_result_store_value_category_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreCategoryNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_category_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStoreCategoryNode), 0, (GInstanceInitFunc) tracker_result_store_category_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_result_store_category_node_type_id;
		tracker_result_store_category_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerResultStoreCategoryNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_result_store_category_node_type_id__volatile, tracker_result_store_category_node_type_id);
	}
	return tracker_result_store_category_node_type_id__volatile;
}


static gpointer tracker_result_store_category_node_ref (gpointer instance) {
	TrackerResultStoreCategoryNode* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void tracker_result_store_category_node_unref (gpointer instance) {
	TrackerResultStoreCategoryNode* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRACKER_RESULT_STORE_CATEGORY_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static TrackerResultStoreOperation* tracker_result_store_operation_construct (GType object_type) {
	TrackerResultStoreOperation * self = NULL;
	self = (TrackerResultStoreOperation*) g_object_new (object_type, NULL);
	return self;
}


static TrackerResultStoreOperation* tracker_result_store_operation_new (void) {
	return tracker_result_store_operation_construct (TRACKER_RESULT_STORE_TYPE_OPERATION);
}


static void tracker_result_store_operation_class_init (TrackerResultStoreOperationClass * klass) {
	tracker_result_store_operation_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tracker_result_store_operation_finalize;
}


static void tracker_result_store_operation_instance_init (TrackerResultStoreOperation * self) {
}


static void tracker_result_store_operation_finalize (GObject* obj) {
	TrackerResultStoreOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_RESULT_STORE_TYPE_OPERATION, TrackerResultStoreOperation);
	_tracker_result_store_category_node_unref0 (self->node);
	G_OBJECT_CLASS (tracker_result_store_operation_parent_class)->finalize (obj);
}


static GType tracker_result_store_operation_get_type (void) {
	static volatile gsize tracker_result_store_operation_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStoreOperation), 0, (GInstanceInitFunc) tracker_result_store_operation_instance_init, NULL };
		GType tracker_result_store_operation_type_id;
		tracker_result_store_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResultStoreOperation", &g_define_type_info, 0);
		g_once_init_leave (&tracker_result_store_operation_type_id__volatile, tracker_result_store_operation_type_id);
	}
	return tracker_result_store_operation_type_id__volatile;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void tracker_result_store_result_node_copy (const TrackerResultStoreResultNode* self, TrackerResultStoreResultNode* dest) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	_tmp0_ = (*self).values;
	_tmp0__length1 = (*self).values_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	(*dest).values = (_vala_array_free ((*dest).values, (*dest).values_length1, (GDestroyNotify) g_free), NULL);
	(*dest).values = _tmp1_;
	(*dest).values_length1 = _tmp1__length1;
	(*dest)._values_size_ = (*dest).values_length1;
	_tmp2_ = (*self).pixbuf;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).pixbuf);
	(*dest).pixbuf = _tmp3_;
}


static void tracker_result_store_result_node_destroy (TrackerResultStoreResultNode* self) {
	(*self).values = (_vala_array_free ((*self).values, (*self).values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 ((*self).pixbuf);
}


static TrackerResultStoreResultNode* tracker_result_store_result_node_dup (const TrackerResultStoreResultNode* self) {
	TrackerResultStoreResultNode* dup;
	dup = g_new0 (TrackerResultStoreResultNode, 1);
	tracker_result_store_result_node_copy (self, dup);
	return dup;
}


static void tracker_result_store_result_node_free (TrackerResultStoreResultNode* self) {
	tracker_result_store_result_node_destroy (self);
	g_free (self);
}


static GType tracker_result_store_result_node_get_type (void) {
	static volatile gsize tracker_result_store_result_node_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_result_node_type_id__volatile)) {
		GType tracker_result_store_result_node_type_id;
		tracker_result_store_result_node_type_id = g_boxed_type_register_static ("TrackerResultStoreResultNode", (GBoxedCopyFunc) tracker_result_store_result_node_dup, (GBoxedFreeFunc) tracker_result_store_result_node_free);
		g_once_init_leave (&tracker_result_store_result_node_type_id__volatile, tracker_result_store_result_node_type_id);
	}
	return tracker_result_store_result_node_type_id__volatile;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void tracker_result_store_query_data_copy (const TrackerResultStoreQueryData* self, TrackerResultStoreQueryData* dest) {
	TrackerQueryType _tmp0_ = 0;
	TrackerQueryMatch _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = (*self).type;
	(*dest).type = _tmp0_;
	_tmp1_ = (*self).match;
	(*dest).match = _tmp1_;
	_tmp2_ = (*self).args;
	_tmp2__length1 = (*self).args_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup4 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	(*dest).args = (_vala_array_free ((*dest).args, (*dest).args_length1, (GDestroyNotify) g_free), NULL);
	(*dest).args = _tmp3_;
	(*dest).args_length1 = _tmp3__length1;
	(*dest)._args_size_ = (*dest).args_length1;
}


static void tracker_result_store_query_data_destroy (TrackerResultStoreQueryData* self) {
	(*self).args = (_vala_array_free ((*self).args, (*self).args_length1, (GDestroyNotify) g_free), NULL);
}


static TrackerResultStoreQueryData* tracker_result_store_query_data_dup (const TrackerResultStoreQueryData* self) {
	TrackerResultStoreQueryData* dup;
	dup = g_new0 (TrackerResultStoreQueryData, 1);
	tracker_result_store_query_data_copy (self, dup);
	return dup;
}


static void tracker_result_store_query_data_free (TrackerResultStoreQueryData* self) {
	tracker_result_store_query_data_destroy (self);
	g_free (self);
}


static GType tracker_result_store_query_data_get_type (void) {
	static volatile gsize tracker_result_store_query_data_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_query_data_type_id__volatile)) {
		GType tracker_result_store_query_data_type_id;
		tracker_result_store_query_data_type_id = g_boxed_type_register_static ("TrackerResultStoreQueryData", (GBoxedCopyFunc) tracker_result_store_query_data_dup, (GBoxedFreeFunc) tracker_result_store_query_data_free);
		g_once_init_leave (&tracker_result_store_query_data_type_id__volatile, tracker_result_store_query_data_type_id);
	}
	return tracker_result_store_query_data_type_id__volatile;
}


static void tracker_result_store_class_init (TrackerResultStoreClass * klass) {
	tracker_result_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerResultStorePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tracker_result_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tracker_result_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = tracker_result_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_ICON_SIZE, g_param_spec_int ("icon-size", "icon-size", "icon-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_LIMIT, g_param_spec_uint ("limit", "limit", "limit", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_SEARCH_TERM, g_param_spec_string ("search-term", "search-term", "search-term", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_SEARCH_TAGS, g_param_spec_boxed ("search-tags", "search-tags", "search-tags", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_RESULT_STORE_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("result_overflow", TRACKER_TYPE_RESULT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void tracker_result_store_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
	tracker_result_store_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_column_type = (GType (*)(GtkTreeModel*, gint)) tracker_result_store_real_get_column_type;
	iface->get_flags = (GtkTreeModelFlags (*)(GtkTreeModel*)) tracker_result_store_real_get_flags;
	iface->get_iter = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) tracker_result_store_real_get_iter;
	iface->get_n_columns = (gint (*)(GtkTreeModel*)) tracker_result_store_real_get_n_columns;
	iface->get_path = (GtkTreePath* (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_get_path;
	iface->get_value = (void (*)(GtkTreeModel*, GtkTreeIter*, gint, GValue*)) tracker_result_store_real_get_value;
	iface->iter_children = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) tracker_result_store_real_iter_children;
	iface->iter_has_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_iter_has_child;
	iface->iter_n_children = (gint (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_iter_n_children;
	iface->iter_next = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_iter_next;
	iface->iter_nth_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) tracker_result_store_real_iter_nth_child;
	iface->iter_parent = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) tracker_result_store_real_iter_parent;
	iface->ref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_ref_node;
	iface->unref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) tracker_result_store_real_unref_node;
}


static void tracker_result_store_instance_init (TrackerResultStore * self) {
	self->priv = TRACKER_RESULT_STORE_GET_PRIVATE (self);
	self->priv->n_extra_columns = 2;
}


static void tracker_result_store_finalize (GObject* obj) {
	TrackerResultStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_RESULT_STORE, TrackerResultStore);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->queries = (_vala_TrackerResultStoreQueryData_array_free (self->priv->queries, self->priv->queries_length1), NULL);
	_g_ptr_array_unref0 (self->priv->categories);
	_g_ptr_array_unref0 (self->priv->running_operations);
	_g_ptr_array_unref0 (self->priv->delayed_operations);
	_g_free0 (self->priv->_search_term);
	_g_ptr_array_unref0 (self->priv->_search_tags);
	G_OBJECT_CLASS (tracker_result_store_parent_class)->finalize (obj);
}


GType tracker_result_store_get_type (void) {
	static volatile gsize tracker_result_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_result_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResultStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_result_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResultStore), 0, (GInstanceInitFunc) tracker_result_store_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) tracker_result_store_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tracker_result_store_type_id;
		tracker_result_store_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResultStore", &g_define_type_info, 0);
		g_type_add_interface_static (tracker_result_store_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&tracker_result_store_type_id__volatile, tracker_result_store_type_id);
	}
	return tracker_result_store_type_id__volatile;
}


static void _vala_tracker_result_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerResultStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_RESULT_STORE, TrackerResultStore);
	switch (property_id) {
		case TRACKER_RESULT_STORE_ICON_SIZE:
		g_value_set_int (value, tracker_result_store_get_icon_size (self));
		break;
		case TRACKER_RESULT_STORE_LIMIT:
		g_value_set_uint (value, tracker_result_store_get_limit (self));
		break;
		case TRACKER_RESULT_STORE_SEARCH_TERM:
		g_value_set_string (value, tracker_result_store_get_search_term (self));
		break;
		case TRACKER_RESULT_STORE_SEARCH_TAGS:
		g_value_set_boxed (value, tracker_result_store_get_search_tags (self));
		break;
		case TRACKER_RESULT_STORE_ACTIVE:
		g_value_set_boolean (value, tracker_result_store_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tracker_result_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerResultStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TRACKER_TYPE_RESULT_STORE, TrackerResultStore);
	switch (property_id) {
		case TRACKER_RESULT_STORE_ICON_SIZE:
		tracker_result_store_set_icon_size (self, g_value_get_int (value));
		break;
		case TRACKER_RESULT_STORE_LIMIT:
		tracker_result_store_set_limit (self, g_value_get_uint (value));
		break;
		case TRACKER_RESULT_STORE_SEARCH_TERM:
		tracker_result_store_set_search_term (self, g_value_get_string (value));
		break;
		case TRACKER_RESULT_STORE_SEARCH_TAGS:
		tracker_result_store_set_search_tags (self, g_value_get_boxed (value));
		break;
		case TRACKER_RESULT_STORE_ACTIVE:
		tracker_result_store_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



