/* tracker-direct.c generated by valac 0.20.1, the Vala compiler
 * generated from tracker-direct.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-db-manager.h"
#include "libtracker-data/tracker-data-manager.h"
#include <gio/gio.h>
#include "libtracker-common/tracker-locale.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-sparql-query.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-common/tracker-date-time.h"


#define TRACKER_DIRECT_TYPE_CONNECTION (tracker_direct_connection_get_type ())
#define TRACKER_DIRECT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnection))
#define TRACKER_DIRECT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionClass))
#define TRACKER_DIRECT_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_DIRECT_TYPE_CONNECTION))
#define TRACKER_DIRECT_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_DIRECT_TYPE_CONNECTION))
#define TRACKER_DIRECT_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionClass))

typedef struct _TrackerDirectConnection TrackerDirectConnection;
typedef struct _TrackerDirectConnectionClass TrackerDirectConnectionClass;
typedef struct _TrackerDirectConnectionPrivate TrackerDirectConnectionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
typedef struct _TrackerDirectConnectionQueryAsyncData TrackerDirectConnectionQueryAsyncData;

struct _TrackerDirectConnection {
	TrackerSparqlConnection parent_instance;
	TrackerDirectConnectionPrivate * priv;
};

struct _TrackerDirectConnectionClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerDirectConnectionPrivate {
	gboolean initialized;
};

struct _Block1Data {
	int _ref_count_;
	TrackerDirectConnection * self;
	gchar* sparql;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	TrackerSparqlCursor* _result_;
	GMainContext* context;
};

struct _TrackerDirectConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerDirectConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_;
	Block2Data* _data2_;
	GMainContext* _tmp3_;
	GMainContext* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	TrackerSparqlCursor* _tmp14_;
	TrackerSparqlCursor* _tmp15_;
	const gchar* _tmp16_;
	GCancellable* _tmp17_;
	TrackerSparqlCursor* _tmp18_;
	TrackerSparqlCursor* _tmp19_;
	GError * _inner_error_;
};


static gpointer tracker_direct_connection_parent_class = NULL;
static gint tracker_direct_connection_use_count;
static gint tracker_direct_connection_use_count = 0;

GType tracker_direct_connection_get_type (void) G_GNUC_CONST;
#define TRACKER_DIRECT_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionPrivate))
enum  {
	TRACKER_DIRECT_CONNECTION_DUMMY_PROPERTY
};
TrackerDirectConnection* tracker_direct_connection_new (GError** error);
TrackerDirectConnection* tracker_direct_connection_construct (GType object_type, GError** error);
static TrackerSparqlCursor* tracker_direct_connection_query_unlocked (TrackerDirectConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error);
static TrackerSparqlCursor* tracker_direct_connection_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_direct_connection_real_query_async_data_free (gpointer _data);
static void tracker_direct_connection_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_direct_connection_real_query_async_co (TrackerDirectConnectionQueryAsyncData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean ___lambda2_ (Block2Data* _data2_, GIOSchedulerJob* job);
static gboolean __lambda3_ (Block2Data* _data2_);
static gboolean ___lambda3__gsource_func (gpointer self);
static gboolean ____lambda2__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self);
static void tracker_direct_connection_finalize (GObject* obj);


TrackerDirectConnection* tracker_direct_connection_construct (GType object_type, GError** error) {
	TrackerDirectConnection * self = NULL;
	GError * _inner_error_ = NULL;
#line 24 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) tracker_sparql_connection_construct (object_type);
#line 25 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_db_manager_lock ();
#line 157 "tracker-direct.c"
	{
		gint _tmp0_;
		gint _tmp9_;
#line 28 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = tracker_direct_connection_use_count;
#line 28 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_tmp0_ == 0) {
#line 165 "tracker-direct.c"
			gboolean _tmp1_ = FALSE;
			guint select_cache_size;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* env_cache_size;
			const gchar* _tmp5_;
			guint _tmp8_;
#line 31 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			tracker_locale_init ();
#line 32 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp1_ = tracker_db_manager_locale_changed ();
#line 32 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_tmp1_) {
#line 179 "tracker-direct.c"
				GError* _tmp2_;
#line 33 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_tmp2_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, "Locale mismatch, cannot use direct connection");
#line 33 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_inner_error_ = _tmp2_;
#line 185 "tracker-direct.c"
				goto __catch1_g_error;
			}
#line 36 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			select_cache_size = (guint) 100;
#line 37 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp3_ = g_getenv ("TRACKER_SPARQL_CACHE_SIZE");
#line 37 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp4_ = g_strdup (_tmp3_);
#line 37 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			env_cache_size = _tmp4_;
#line 39 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp5_ = env_cache_size;
#line 39 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_tmp5_ != NULL) {
#line 200 "tracker-direct.c"
				const gchar* _tmp6_;
				gint _tmp7_ = 0;
#line 40 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_tmp6_ = env_cache_size;
#line 40 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_tmp7_ = atoi (_tmp6_);
#line 40 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				select_cache_size = (guint) _tmp7_;
#line 209 "tracker-direct.c"
			}
#line 43 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp8_ = select_cache_size;
#line 43 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			tracker_data_manager_init (TRACKER_DB_MANAGER_READONLY, NULL, NULL, FALSE, FALSE, _tmp8_, (guint) 0, NULL, NULL, NULL, &_inner_error_);
#line 43 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_ != NULL) {
#line 43 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_g_free0 (env_cache_size);
#line 219 "tracker-direct.c"
				goto __catch1_g_error;
			}
#line 28 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_free0 (env_cache_size);
#line 224 "tracker-direct.c"
		}
#line 46 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = tracker_direct_connection_use_count;
#line 46 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_direct_connection_use_count = _tmp9_ + 1;
#line 47 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		self->priv->initialized = TRUE;
#line 232 "tracker-direct.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		GError* _tmp12_;
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 49 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp10_ = e;
#line 49 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp11_ = _tmp10_->message;
#line 49 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp12_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp11_);
#line 49 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp12_;
#line 49 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 255 "tracker-direct.c"
		goto __finally1;
	}
	__finally1:
	{
#line 51 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_db_manager_unlock ();
#line 262 "tracker-direct.c"
	}
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_inner_error_ != NULL) {
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_propagate_error (error, _inner_error_);
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_object_unref0 (self);
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 274 "tracker-direct.c"
		} else {
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_inner_error_);
#line 27 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 282 "tracker-direct.c"
		}
	}
#line 24 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return self;
#line 287 "tracker-direct.c"
}


TrackerDirectConnection* tracker_direct_connection_new (GError** error) {
#line 24 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return tracker_direct_connection_construct (TRACKER_DIRECT_TYPE_CONNECTION, error);
#line 294 "tracker-direct.c"
}


static TrackerSparqlCursor* tracker_direct_connection_query_unlocked (TrackerDirectConnection* self, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_ = NULL;
#line 75 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 305 "tracker-direct.c"
	{
		const gchar* _tmp0_;
		TrackerSparqlQuery* _tmp1_;
		TrackerSparqlQuery* query_object;
		TrackerSparqlQuery* _tmp2_;
		TrackerDBCursor* _tmp3_ = NULL;
		TrackerDBCursor* cursor;
		TrackerDBCursor* _tmp4_;
#line 77 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = sparql;
#line 77 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = tracker_sparql_query_new (_tmp0_);
#line 77 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		query_object = _tmp1_;
#line 78 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = query_object;
#line 78 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = tracker_sparql_query_execute_cursor (_tmp2_, TRUE, &_inner_error_);
#line 78 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		cursor = _tmp3_;
#line 78 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_inner_error_ != NULL) {
#line 78 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_object_unref0 (query_object);
#line 78 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 332 "tracker-direct.c"
				goto __catch2_tracker_db_interface_error;
			}
#line 78 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 337 "tracker-direct.c"
				goto __catch2_tracker_date_error;
			}
			goto __finally2;
		}
#line 79 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = cursor;
#line 79 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_sparql_cursor_set_connection ((TrackerSparqlCursor*) _tmp4_, (TrackerSparqlConnection*) self);
#line 80 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		result = (TrackerSparqlCursor*) cursor;
#line 80 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (query_object);
#line 80 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return result;
#line 352 "tracker-direct.c"
	}
	goto __finally2;
	__catch2_tracker_db_interface_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 82 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = e;
#line 82 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = _tmp5_->message;
#line 82 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp6_);
#line 82 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp7_;
#line 82 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 375 "tracker-direct.c"
		goto __finally2;
	}
	goto __finally2;
	__catch2_tracker_date_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 84 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = e;
#line 84 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = _tmp8_->message;
#line 84 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp10_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp9_);
#line 84 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp10_;
#line 84 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 399 "tracker-direct.c"
		goto __finally2;
	}
	__finally2:
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 409 "tracker-direct.c"
	} else {
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 76 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 417 "tracker-direct.c"
	}
}


static TrackerSparqlCursor* tracker_direct_connection_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerDirectConnection * self;
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_ = NULL;
#line 88 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 88 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 89 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_db_manager_lock ();
#line 432 "tracker-direct.c"
	{
		const gchar* _tmp0_;
		GCancellable* _tmp1_;
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlCursor* _tmp3_;
#line 91 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = sparql;
#line 91 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = cancellable;
#line 91 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = tracker_direct_connection_query_unlocked (self, _tmp0_, _tmp1_, &_inner_error_);
#line 91 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = _tmp2_;
#line 91 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_inner_error_ != NULL) {
#line 448 "tracker-direct.c"
			goto __finally3;
		}
#line 91 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		result = _tmp3_;
#line 453 "tracker-direct.c"
		{
#line 93 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			tracker_db_manager_unlock ();
#line 457 "tracker-direct.c"
		}
#line 91 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return result;
#line 461 "tracker-direct.c"
	}
	__finally3:
	{
#line 93 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_db_manager_unlock ();
#line 467 "tracker-direct.c"
	}
#line 90 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 90 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 90 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 475 "tracker-direct.c"
	} else {
#line 90 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 90 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 90 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 483 "tracker-direct.c"
	}
}


static void tracker_direct_connection_real_query_async_data_free (gpointer _data) {
	TrackerDirectConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->result);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_slice_free (TrackerDirectConnectionQueryAsyncData, _data_);
#line 497 "tracker-direct.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return self ? g_object_ref (self) : NULL;
#line 504 "tracker-direct.c"
}


static void tracker_direct_connection_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerDirectConnection * self;
	TrackerDirectConnectionQueryAsyncData* _data_;
	TrackerDirectConnection* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_slice_new0 (TrackerDirectConnectionQueryAsyncData);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_direct_connection_real_query_async);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_direct_connection_real_query_async_data_free);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self = _tmp0_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = sparql;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->sparql);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->sparql = _tmp2_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = cancellable;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->cancellable = _tmp4_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_query_async_co (_data_);
#line 546 "tracker-direct.c"
}


static TrackerSparqlCursor* tracker_direct_connection_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerDirectConnectionQueryAsyncData* _data_;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 557 "tracker-direct.c"
	}
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	result = _data_->result;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->result = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 567 "tracker-direct.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return _data1_;
#line 576 "tracker-direct.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 585 "tracker-direct.c"
		TrackerDirectConnection * self;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		self = _data1_->self;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_free0 (_data1_->sparql);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data1_->cancellable);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (self);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_slice_free (Block1Data, _data1_);
#line 597 "tracker-direct.c"
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return _data2_;
#line 607 "tracker-direct.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 616 "tracker-direct.c"
		TrackerDirectConnection * self;
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		self = _data2_->_data1_->self;
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_main_context_unref0 (_data2_->context);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data2_->_result_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->io_error);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		block1_data_unref (_data2_->_data1_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->_data1_ = NULL;
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_slice_free (Block2Data, _data2_);
#line 636 "tracker-direct.c"
	}
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 104 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 644 "tracker-direct.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 110 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return self ? g_error_copy (self) : NULL;
#line 651 "tracker-direct.c"
}


static gboolean __lambda3_ (Block2Data* _data2_) {
	Block1Data* _data1_;
	TrackerDirectConnection * self;
	gboolean result = FALSE;
#line 118 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data1_ = _data2_->_data1_;
#line 118 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	self = _data1_->self;
#line 119 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_query_async_co (_data1_->_async_data_);
#line 120 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	result = FALSE;
#line 120 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 669 "tracker-direct.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 118 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 678 "tracker-direct.c"
}


static gboolean ___lambda2_ (Block2Data* _data2_, GIOSchedulerJob* job) {
	Block1Data* _data1_;
	TrackerDirectConnection * self;
	gboolean result = FALSE;
	GSource* _tmp10_;
	GSource* source;
	GMainContext* _tmp11_;
	GError * _inner_error_ = NULL;
#line 106 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data1_ = _data2_->_data1_;
#line 106 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	self = _data1_->self;
#line 106 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (job != NULL, FALSE);
#line 696 "tracker-direct.c"
	{
		const gchar* _tmp0_;
		GCancellable* _tmp1_;
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlCursor* _tmp3_;
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = _data1_->sparql;
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = _data1_->cancellable;
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = tracker_sparql_connection_query ((TrackerSparqlConnection*) self, _tmp0_, _tmp1_, &_inner_error_);
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = _tmp2_;
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_inner_error_ != NULL) {
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 714 "tracker-direct.c"
				goto __catch4_g_io_error;
			}
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 719 "tracker-direct.c"
				goto __catch4_tracker_sparql_error;
			}
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 724 "tracker-direct.c"
				goto __catch4_g_dbus_error;
			}
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_inner_error_);
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			return FALSE;
#line 733 "tracker-direct.c"
		}
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data2_->_result_);
#line 108 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->_result_ = _tmp3_;
#line 739 "tracker-direct.c"
	}
	goto __finally4;
	__catch4_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp4_;
		GError* _tmp5_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		e_io = _inner_error_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 110 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = e_io;
#line 110 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = _g_error_copy0 (_tmp4_);
#line 110 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->io_error);
#line 110 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->io_error = _tmp5_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_io);
#line 761 "tracker-direct.c"
	}
	goto __finally4;
	__catch4_tracker_sparql_error:
	{
		GError* e_spql = NULL;
		GError* _tmp6_;
		GError* _tmp7_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		e_spql = _inner_error_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 112 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = e_spql;
#line 112 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = _g_error_copy0 (_tmp6_);
#line 112 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 112 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->sparql_error = _tmp7_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_spql);
#line 783 "tracker-direct.c"
	}
	goto __finally4;
	__catch4_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp8_;
		GError* _tmp9_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		e_dbus = _inner_error_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 114 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = e_dbus;
#line 114 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = _g_error_copy0 (_tmp8_);
#line 114 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 114 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->dbus_error = _tmp9_;
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_dbus);
#line 805 "tracker-direct.c"
	}
	__finally4:
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_inner_error_ != NULL) {
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 107 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return FALSE;
#line 816 "tracker-direct.c"
	}
#line 117 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp10_ = g_idle_source_new ();
#line 117 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	source = _tmp10_;
#line 118 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_source_set_callback (source, ___lambda3__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 122 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp11_ = _data2_->context;
#line 122 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_source_attach (source, _tmp11_);
#line 124 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	result = FALSE;
#line 124 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_source_unref0 (source);
#line 124 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 834 "tracker-direct.c"
}


static gboolean ____lambda2__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self) {
	gboolean result;
	result = ___lambda2_ (self, job);
#line 106 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 843 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_query_async_co (TrackerDirectConnectionQueryAsyncData* _data_) {
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	switch (_data_->_state_) {
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		case 0:
#line 852 "tracker-direct.c"
		goto _state_0;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		case 1:
#line 856 "tracker-direct.c"
		goto _state_1;
		default:
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_assert_not_reached ();
#line 861 "tracker-direct.c"
	}
	_state_0:
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_ = g_slice_new0 (Block1Data);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->_ref_count_ = 1;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->self = g_object_ref (_data_->self);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->_data1_->sparql);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->sparql = _data_->_tmp0_;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->_data1_->cancellable);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->cancellable = _data_->_tmp1_;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_->_async_data_ = _data_;
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp2_ = FALSE;
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp2_ = tracker_db_manager_trylock ();
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (!_data_->_tmp2_) {
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_ = g_slice_new0 (Block2Data);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_->_ref_count_ = 1;
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_->_data1_ = block1_data_ref (_data_->_data1_);
#line 100 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_->sparql_error = NULL;
#line 101 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_->io_error = NULL;
#line 102 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_->dbus_error = NULL;
#line 103 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_->_result_ = NULL;
#line 104 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp3_ = NULL;
#line 104 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp3_ = g_main_context_get_thread_default ();
#line 104 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp4_ = _g_main_context_ref0 (_data_->_tmp3_);
#line 104 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_->context = _data_->_tmp4_;
#line 106 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_io_scheduler_push_job (____lambda2__gio_scheduler_job_func, block2_data_ref (_data_->_data2_), block2_data_unref, G_PRIORITY_DEFAULT, NULL);
#line 126 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_state_ = 1;
#line 126 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return FALSE;
#line 918 "tracker-direct.c"
		_state_1:
		;
#line 128 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp5_ = _data_->_data2_->sparql_error;
#line 128 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_data_->_tmp5_ != NULL) {
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp6_ = _data_->_data2_->sparql_error;
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp7_ = _g_error_copy0 (_data_->_tmp6_);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_inner_error_ = _data_->_tmp7_;
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				g_error_free (_data_->_inner_error_);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				block2_data_unref (_data_->_data2_);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_data2_ = NULL;
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				block1_data_unref (_data_->_data1_);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_data1_ = NULL;
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				if (_data_->_state_ == 0) {
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 949 "tracker-direct.c"
				} else {
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					g_simple_async_result_complete (_data_->_async_result);
#line 953 "tracker-direct.c"
				}
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				g_object_unref (_data_->_async_result);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				return FALSE;
#line 959 "tracker-direct.c"
			} else {
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				block2_data_unref (_data_->_data2_);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_data2_ = NULL;
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				block1_data_unref (_data_->_data1_);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_data1_ = NULL;
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				g_clear_error (&_data_->_inner_error_);
#line 129 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				return FALSE;
#line 975 "tracker-direct.c"
			}
		} else {
#line 130 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp8_ = _data_->_data2_->io_error;
#line 130 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_data_->_tmp8_ != NULL) {
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp9_ = _data_->_data2_->io_error;
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp10_ = _g_error_copy0 (_data_->_tmp9_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_inner_error_ = _data_->_tmp10_;
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					g_error_free (_data_->_inner_error_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					block2_data_unref (_data_->_data2_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data2_ = NULL;
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					block1_data_unref (_data_->_data1_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data1_ = NULL;
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					if (_data_->_state_ == 0) {
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1006 "tracker-direct.c"
					} else {
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1010 "tracker-direct.c"
					}
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					g_object_unref (_data_->_async_result);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 1016 "tracker-direct.c"
				} else {
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					block2_data_unref (_data_->_data2_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data2_ = NULL;
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					block1_data_unref (_data_->_data1_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data1_ = NULL;
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					g_clear_error (&_data_->_inner_error_);
#line 131 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 1032 "tracker-direct.c"
				}
			} else {
#line 132 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp11_ = _data_->_data2_->dbus_error;
#line 132 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
				if (_data_->_tmp11_ != NULL) {
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp12_ = _data_->_data2_->dbus_error;
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp13_ = _g_error_copy0 (_data_->_tmp12_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_inner_error_ = _data_->_tmp13_;
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_error_free (_data_->_inner_error_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						block2_data_unref (_data_->_data2_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						_data_->_data2_ = NULL;
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						block1_data_unref (_data_->_data1_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						_data_->_data1_ = NULL;
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						if (_data_->_state_ == 0) {
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
							g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1063 "tracker-direct.c"
						} else {
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
							g_simple_async_result_complete (_data_->_async_result);
#line 1067 "tracker-direct.c"
						}
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_object_unref (_data_->_async_result);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						return FALSE;
#line 1073 "tracker-direct.c"
					} else {
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						block2_data_unref (_data_->_data2_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						_data_->_data2_ = NULL;
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						block1_data_unref (_data_->_data1_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						_data_->_data1_ = NULL;
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_clear_error (&_data_->_inner_error_);
#line 133 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						return FALSE;
#line 1089 "tracker-direct.c"
					}
				} else {
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp14_ = _data_->_data2_->_result_;
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->result = _data_->_tmp15_;
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					block2_data_unref (_data_->_data2_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data2_ = NULL;
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					block1_data_unref (_data_->_data1_);
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data1_ = NULL;
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					if (_data_->_state_ == 0) {
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1110 "tracker-direct.c"
					} else {
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1114 "tracker-direct.c"
					}
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					g_object_unref (_data_->_async_result);
#line 135 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 1120 "tracker-direct.c"
				}
			}
		}
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		block2_data_unref (_data_->_data2_);
#line 98 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data2_ = NULL;
#line 1128 "tracker-direct.c"
	}
	{
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp16_ = _data_->_data1_->sparql;
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp17_ = _data_->_data1_->cancellable;
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp18_ = NULL;
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp18_ = tracker_direct_connection_query_unlocked (_data_->self, _data_->_tmp16_, _data_->_tmp17_, &_data_->_inner_error_);
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp19_ = _data_->_tmp18_;
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1143 "tracker-direct.c"
			goto __finally5;
		}
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->result = _data_->_tmp19_;
#line 1148 "tracker-direct.c"
		{
#line 141 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			tracker_db_manager_unlock ();
#line 1152 "tracker-direct.c"
		}
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		block1_data_unref (_data_->_data1_);
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data1_ = NULL;
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_data_->_state_ == 0) {
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1162 "tracker-direct.c"
		} else {
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1166 "tracker-direct.c"
		}
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_object_unref (_data_->_async_result);
#line 139 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return FALSE;
#line 1172 "tracker-direct.c"
	}
	__finally5:
	{
#line 141 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_db_manager_unlock ();
#line 1178 "tracker-direct.c"
	}
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_error_free (_data_->_inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		block1_data_unref (_data_->_data1_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data1_ = NULL;
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_data_->_state_ == 0) {
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1194 "tracker-direct.c"
		} else {
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1198 "tracker-direct.c"
		}
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_object_unref (_data_->_async_result);
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return FALSE;
#line 1204 "tracker-direct.c"
	} else {
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		block1_data_unref (_data_->_data1_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_data1_ = NULL;
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_data_->_inner_error_);
#line 138 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		return FALSE;
#line 1216 "tracker-direct.c"
	}
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	block1_data_unref (_data_->_data1_);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data1_ = NULL;
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_state_ == 0) {
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1226 "tracker-direct.c"
	} else {
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1230 "tracker-direct.c"
	}
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_object_unref (_data_->_async_result);
#line 97 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 1236 "tracker-direct.c"
}


static void tracker_direct_connection_class_init (TrackerDirectConnectionClass * klass) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	g_type_class_add_private (klass, sizeof (TrackerDirectConnectionPrivate));
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query = tracker_direct_connection_real_query;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_async = tracker_direct_connection_real_query_async;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	TRACKER_SPARQL_CONNECTION_CLASS (klass)->query_finish = tracker_direct_connection_real_query_finish;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_direct_connection_finalize;
#line 1253 "tracker-direct.c"
}


static void tracker_direct_connection_instance_init (TrackerDirectConnection * self) {
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	self->priv = TRACKER_DIRECT_CONNECTION_GET_PRIVATE (self);
#line 1260 "tracker-direct.c"
}


static void tracker_direct_connection_finalize (GObject* obj) {
	TrackerDirectConnection * self;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnection);
#line 56 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = self->priv->initialized;
#line 56 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (!_tmp0_) {
#line 1274 "tracker-direct.c"
		goto _return;
	}
#line 62 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_db_manager_lock ();
#line 1279 "tracker-direct.c"
	{
		gint _tmp1_;
		gint _tmp2_;
#line 65 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = tracker_direct_connection_use_count;
#line 65 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_direct_connection_use_count = _tmp1_ - 1;
#line 67 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = tracker_direct_connection_use_count;
#line 67 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_tmp2_ == 0) {
#line 68 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
			tracker_data_manager_shutdown ();
#line 1293 "tracker-direct.c"
		}
	}
	__finally0:
	{
#line 71 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_db_manager_unlock ();
#line 1300 "tracker-direct.c"
	}
#line 64 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_inner_error_ != NULL) {
#line 64 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 1308 "tracker-direct.c"
	}
	_return:
#line 20 "/home/martyn/Source/tracker/src/libtracker-direct/tracker-direct.vala"
	G_OBJECT_CLASS (tracker_direct_connection_parent_class)->finalize (obj);
#line 1313 "tracker-direct.c"
}


GType tracker_direct_connection_get_type (void) {
	static volatile gsize tracker_direct_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDirectConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_direct_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDirectConnection), 0, (GInstanceInitFunc) tracker_direct_connection_instance_init, NULL };
		GType tracker_direct_connection_type_id;
		tracker_direct_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerDirectConnection", &g_define_type_info, 0);
		g_once_init_leave (&tracker_direct_connection_type_id__volatile, tracker_direct_connection_type_id);
	}
	return tracker_direct_connection_type_id__volatile;
}



