/*
 * Copyright (C) 2002,2003 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <glib.h>

#include "terminal-debug.h"

TerminalDebugFlags _terminal_debug_flags;

void
_terminal_debug_init(void)
{
#ifdef GNOME_ENABLE_DEBUG
  const GDebugKey keys[] = {
    { "accels",        TERMINAL_DEBUG_ACCELS        },
    { "encodings",     TERMINAL_DEBUG_ENCODINGS     },
    { "server",        TERMINAL_DEBUG_SERVER        },
    { "geometry",      TERMINAL_DEBUG_GEOMETRY      },
    { "mdi",           TERMINAL_DEBUG_MDI           },
    { "processes",     TERMINAL_DEBUG_PROCESSES     },
    { "profile",       TERMINAL_DEBUG_PROFILE       },
    { "settings-list", TERMINAL_DEBUG_SETTINGS_LIST },
    { "appmenu",       TERMINAL_DEBUG_APPMENU       },
    { "search",        TERMINAL_DEBUG_SEARCH        },
  };

  _terminal_debug_flags = g_parse_debug_string (g_getenv ("GNOME_TERMINAL_DEBUG"),
                                                keys, G_N_ELEMENTS (keys));
#endif /* GNOME_ENABLE_DEBUG */
}

