/* bluez-persona-store.c generated by valac 0.24.0, the Vala compiler
 * generated from bluez-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *          Arun Raghavan <arun.raghavan@collabora.co.uk>
 *          Jeremy Whiting <jeremy.whiting@collabora.com>
 *          Simon McVittie <simon.mcvittie@collabora.co.uk>
 *          Gustavo Padovan <gustavo.padovan@collabora.co.uk>
 *          Matthieu Bouron <matthieu.bouron@collabora.com>
 *          Philip Withnall <philip.withnall@collabora.co.uk>
 *
 * Based on kf-persona-store.vala by:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libebook-contacts/libebook-contacts.h>
#include <glib/gi18n-lib.h>
#include <folks-internal.h>
#include <math.h>
#include <float.h>


#define FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE (folks_backends_blue_z_persona_store_get_type ())
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStoreClass))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStoreClass))

typedef struct _FolksBackendsBlueZPersonaStore FolksBackendsBlueZPersonaStore;
typedef struct _FolksBackendsBlueZPersonaStoreClass FolksBackendsBlueZPersonaStoreClass;
typedef struct _FolksBackendsBlueZPersonaStorePrivate FolksBackendsBlueZPersonaStorePrivate;

#define FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA (folks_backends_blue_z_persona_get_type ())
#define FOLKS_BACKENDS_BLUE_Z_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersona))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersonaClass))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA))
#define FOLKS_BACKENDS_BLUE_Z_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, FolksBackendsBlueZPersonaClass))

typedef struct _FolksBackendsBlueZPersona FolksBackendsBlueZPersona;
typedef struct _FolksBackendsBlueZPersonaClass FolksBackendsBlueZPersonaClass;

#define ORG_BLUEZ_OBEX_TYPE_CLIENT (org_bluez_obex_client_get_type ())
#define ORG_BLUEZ_OBEX_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_OBEX_TYPE_CLIENT, orgbluezobexClient))
#define ORG_BLUEZ_OBEX_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_OBEX_TYPE_CLIENT))
#define ORG_BLUEZ_OBEX_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_OBEX_TYPE_CLIENT, orgbluezobexClientIface))

typedef struct _orgbluezobexClient orgbluezobexClient;
typedef struct _orgbluezobexClientIface orgbluezobexClientIface;

#define ORG_BLUEZ_OBEX_TYPE_CLIENT_PROXY (org_bluez_obex_client_proxy_get_type ())

#define ORG_BLUEZ_TYPE_DEVICE (org_bluez_device_get_type ())
#define ORG_BLUEZ_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_TYPE_DEVICE, orgbluezDevice))
#define ORG_BLUEZ_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_TYPE_DEVICE))
#define ORG_BLUEZ_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_TYPE_DEVICE, orgbluezDeviceIface))

typedef struct _orgbluezDevice orgbluezDevice;
typedef struct _orgbluezDeviceIface orgbluezDeviceIface;

#define ORG_BLUEZ_TYPE_DEVICE_PROXY (org_bluez_device_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_EVCardAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_EVCardAttribute_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData;
typedef struct _FolksBackendsBlueZPersonaStoreSetConnectionStateData FolksBackendsBlueZPersonaStoreSetConnectionStateData;

#define ORG_BLUEZ_OBEX_TYPE_PHONEBOOK_ACCESS (org_bluez_obex_phonebook_access_get_type ())
#define ORG_BLUEZ_OBEX_PHONEBOOK_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_OBEX_TYPE_PHONEBOOK_ACCESS, orgbluezobexPhonebookAccess))
#define ORG_BLUEZ_OBEX_IS_PHONEBOOK_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_OBEX_TYPE_PHONEBOOK_ACCESS))
#define ORG_BLUEZ_OBEX_PHONEBOOK_ACCESS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_OBEX_TYPE_PHONEBOOK_ACCESS, orgbluezobexPhonebookAccessIface))

typedef struct _orgbluezobexPhonebookAccess orgbluezobexPhonebookAccess;
typedef struct _orgbluezobexPhonebookAccessIface orgbluezobexPhonebookAccessIface;

#define ORG_BLUEZ_OBEX_TYPE_PHONEBOOK_ACCESS_PROXY (org_bluez_obex_phonebook_access_proxy_get_type ())

#define ORG_BLUEZ_OBEX_PHONEBOOK_ACCESS_TYPE_PHONEBOOK_ENTRY (org_bluez_obex_phonebook_access_phonebook_entry_get_type ())
typedef struct _orgbluezobexPhonebookAccessPhonebookEntry orgbluezobexPhonebookAccessPhonebookEntry;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksBackendsBlueZPersonaStoreNewObexSessionData FolksBackendsBlueZPersonaStoreNewObexSessionData;
typedef struct _FolksBackendsBlueZPersonaStoreRemoveObexSessionData FolksBackendsBlueZPersonaStoreRemoveObexSessionData;
typedef struct _Block2Data Block2Data;

#define ORG_BLUEZ_OBEX_TYPE_TRANSFER (org_bluez_obex_transfer_get_type ())
#define ORG_BLUEZ_OBEX_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_OBEX_TYPE_TRANSFER, orgbluezobexTransfer))
#define ORG_BLUEZ_OBEX_IS_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_OBEX_TYPE_TRANSFER))
#define ORG_BLUEZ_OBEX_TRANSFER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_OBEX_TYPE_TRANSFER, orgbluezobexTransferIface))

typedef struct _orgbluezobexTransfer orgbluezobexTransfer;
typedef struct _orgbluezobexTransferIface orgbluezobexTransferIface;

#define ORG_BLUEZ_OBEX_TYPE_TRANSFER_PROXY (org_bluez_obex_transfer_proxy_get_type ())
typedef struct _Block3Data Block3Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _FolksBackendsBlueZPersonaStorePerformObexTransferData FolksBackendsBlueZPersonaStorePerformObexTransferData;
typedef struct _FolksBackendsBlueZPersonaStoreUpdateContactsData FolksBackendsBlueZPersonaStoreUpdateContactsData;
typedef struct _Block5Data Block5Data;
typedef struct _FolksBackendsBlueZPersonaStorePrepareData FolksBackendsBlueZPersonaStorePrepareData;
typedef struct _FolksBackendsBlueZPersonaStoreRemovePersonaData FolksBackendsBlueZPersonaStoreRemovePersonaData;
typedef struct _FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData;

struct _FolksBackendsBlueZPersonaStore {
	FolksPersonaStore parent_instance;
	FolksBackendsBlueZPersonaStorePrivate * priv;
};

struct _FolksBackendsBlueZPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _orgbluezobexClientIface {
	GTypeInterface parent_iface;
	void (*create_session) (orgbluezobexClient* self, const gchar* address, GHashTable* args, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*create_session_finish) (orgbluezobexClient* self, GAsyncResult* _res_, GError** error);
	void (*remove_session) (orgbluezobexClient* self, const char* session, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_session_finish) (orgbluezobexClient* self, GAsyncResult* _res_, GError** error);
};

typedef enum  {
	ORG_BLUEZ_ERROR_NOT_READY,
	ORG_BLUEZ_ERROR_FAILED,
	ORG_BLUEZ_ERROR_IN_PROGRESS,
	ORG_BLUEZ_ERROR_ALREADY_CONNECTED,
	ORG_BLUEZ_ERROR_NOT_CONNECTED,
	ORG_BLUEZ_ERROR_DOES_NOT_EXIST,
	ORG_BLUEZ_ERROR_CONNECT_FAILED,
	ORG_BLUEZ_ERROR_NOT_SUPPORTED,
	ORG_BLUEZ_ERROR_INVALID_ARGUMENTS,
	ORG_BLUEZ_ERROR_AUTHENTICATION_CANCELED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_FAILED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_REJECTED,
	ORG_BLUEZ_ERROR_AUTHENTICATION_TIMEOUT,
	ORG_BLUEZ_ERROR_CONNECTION_ATTEMPT_FAILED
} orgbluezError;
#define ORG_BLUEZ_ERROR org_bluez_error_quark ()
struct _orgbluezDeviceIface {
	GTypeInterface parent_iface;
	void (*connect) (orgbluezDevice* self, GError** error);
	void (*disconnect) (orgbluezDevice* self, GError** error);
	void (*disconnect_profile) (orgbluezDevice* self, const gchar* uuid, GError** error);
	void (*pair) (orgbluezDevice* self, GError** error);
	void (*cancel_pairing) (orgbluezDevice* self, GError** error);
	gchar* (*get_address) (orgbluezDevice* self);
	gchar* (*get_name) (orgbluezDevice* self);
	gchar* (*get_icon) (orgbluezDevice* self);
	guint32 (*get_bluetooth_class) (orgbluezDevice* self);
	guint16 (*get_appearance) (orgbluezDevice* self);
	gchar** (*get_uuids) (orgbluezDevice* self, int* result_length1);
	gboolean (*get_paired) (orgbluezDevice* self);
	gboolean (*get_connected) (orgbluezDevice* self);
	gboolean (*get_trusted) (orgbluezDevice* self);
	void (*set_trusted) (orgbluezDevice* self, gboolean value);
	gboolean (*get_blocked) (orgbluezDevice* self);
	void (*set_blocked) (orgbluezDevice* self, gboolean value);
	gchar* (*get_alias) (orgbluezDevice* self);
	void (*set_alias) (orgbluezDevice* self, const gchar* value);
	char* (*get_adapter) (orgbluezDevice* self);
	gboolean (*get_legacy_pairing) (orgbluezDevice* self);
	gchar* (*get_mod_alias) (orgbluezDevice* self);
	gint16 (*get_rssi) (orgbluezDevice* self);
};

struct _FolksBackendsBlueZPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	orgbluezobexClient* _obex_client;
	gchar* _object_path;
	orgbluezDevice* _device;
	gchar* _display_name;
	GCancellable* _update_contacts_cancellable;
	guint _update_contacts_id;
	gboolean _photos_up_to_date;
	guint _update_contacts_n;
	guint _update_contacts_failures;
};

struct _FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	GFile* file;
	GeeHashSet* added_personas;
	GeeHashSet* _tmp0_;
	GeeHashSet* removed_personas;
	GeeHashSet* _tmp1_;
	gboolean photos_up_to_date;
	gboolean _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeHashSet* _tmp6_;
	GeeHashMap* _tmp7_;
	GeeCollection* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	GFileInputStream* _tmp11_;
	GFile* _tmp12_;
	GFileInputStream* _tmp13_;
	GDataInputStream* dis;
	GDataInputStream* _tmp14_;
	guint i;
	gchar* line;
	GString* vcard;
	GString* _tmp15_;
	GString* vcard_without_photo;
	GString* _tmp16_;
	gchar* _tmp17_;
	GDataInputStream* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_;
	GString* _tmp23_;
	gssize _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	GString* _tmp30_;
	gboolean _tmp31_;
	const gchar* _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	gboolean _tmp35_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	GString* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_;
	EVCard* card;
	GString* _tmp43_;
	const gchar* _tmp44_;
	EVCard* _tmp45_;
	gboolean is_user;
	guint _tmp46_;
	gboolean iid_is_checksum;
	gchar* iid;
	EVCardAttribute* attribute;
	EVCard* _tmp47_;
	EVCardAttribute* _tmp48_;
	EVCardAttribute* _tmp49_;
	EVCardAttribute* _tmp50_;
	EVCardAttribute* _tmp51_;
	GString* _tmp52_;
	GString* _tmp53_;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	GString* _tmp56_;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	FolksBackendsBlueZPersona* persona;
	GeeHashMap* _tmp59_;
	const gchar* _tmp60_;
	gpointer _tmp61_;
	FolksBackendsBlueZPersona* _tmp62_;
	GString* _tmp63_;
	const gchar* _tmp64_;
	EVCard* _tmp65_;
	gboolean _tmp66_;
	const gchar* _tmp67_;
	FolksBackendsBlueZPersona* _tmp68_;
	gboolean _tmp69_;
	gboolean _tmp70_;
	GString* _tmp71_;
	gssize _tmp72_;
	GString* _tmp73_;
	gssize _tmp74_;
	FolksBackendsBlueZPersona* _tmp75_;
	EVCard* _tmp76_;
	gboolean _tmp77_;
	GeeHashSet* _tmp78_;
	FolksBackendsBlueZPersona* _tmp79_;
	gboolean _tmp80_;
	GeeHashSet* _tmp81_;
	FolksBackendsBlueZPersona* _tmp82_;
	guint _tmp83_;
	GString* _tmp84_;
	GString* _tmp85_;
	GError* e1;
	const gchar* _tmp86_;
	GError* _tmp87_;
	const gchar* _tmp88_;
	GError* _tmp89_;
	GeeHashSet* _tmp90_;
	gint _tmp91_;
	gint _tmp92_;
	GeeHashSet* _tmp93_;
	gint _tmp94_;
	gint _tmp95_;
	GeeIterator* _p_it;
	GeeHashSet* _tmp96_;
	GeeIterator* _tmp97_;
	GeeIterator* _tmp98_;
	gboolean _tmp99_;
	FolksBackendsBlueZPersona* p;
	GeeIterator* _tmp100_;
	gpointer _tmp101_;
	GeeHashMap* _tmp102_;
	FolksBackendsBlueZPersona* _tmp103_;
	const gchar* _tmp104_;
	const gchar* _tmp105_;
	FolksBackendsBlueZPersona* _tmp106_;
	GeeIterator* _vala1__p_it;
	GeeHashSet* _tmp107_;
	GeeIterator* _tmp108_;
	GeeIterator* _tmp109_;
	gboolean _tmp110_;
	FolksBackendsBlueZPersona* _vala1_p;
	GeeIterator* _tmp111_;
	gpointer _tmp112_;
	GeeHashMap* _tmp113_;
	FolksBackendsBlueZPersona* _tmp114_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	gboolean _tmp117_;
	gboolean _tmp118_;
	GeeHashSet* _tmp119_;
	gboolean _tmp120_;
	gboolean _tmp121_;
	GeeHashSet* _tmp122_;
	gboolean _tmp123_;
	gboolean _tmp124_;
	GeeHashSet* _tmp125_;
	GeeHashSet* _tmp126_;
	GError * _inner_error_;
};

struct _FolksBackendsBlueZPersonaStoreSetConnectionStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	gboolean connected;
	gboolean _tmp0_;
	orgbluezDevice* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	orgbluezDevice* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	orgbluezDevice* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	orgbluezDevice* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError * _inner_error_;
};

struct _orgbluezobexPhonebookAccessPhonebookEntry {
	gchar* vcard;
	gchar* name;
};

struct _orgbluezobexPhonebookAccessIface {
	GTypeInterface parent_iface;
	void (*select) (orgbluezobexPhonebookAccess* self, const gchar* location, const gchar* phonebook, GError** error);
	orgbluezobexPhonebookAccessPhonebookEntry* (*list) (orgbluezobexPhonebookAccess* self, GHashTable* filters, int* result_length1, GError** error);
	gchar** (*list_filter_fields) (orgbluezobexPhonebookAccess* self, int* result_length1, GError** error);
	void (*pull_all) (orgbluezobexPhonebookAccess* self, const gchar* target, GHashTable* filters, gchar** path, GHashTable** props, GError** error);
};

struct _FolksBackendsBlueZPersonaStoreNewObexSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	orgbluezobexPhonebookAccess* obex_pbap;
	char* result;
	GHashTable* args;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gchar* _tmp2_;
	GVariant* _tmp3_;
	char* session_path;
	orgbluezobexClient* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GHashTable* _tmp7_;
	char* _tmp8_;
	const char* _tmp9_;
	orgbluezobexPhonebookAccess* _tmp10_;
	const char* _tmp11_;
	orgbluezobexPhonebookAccess* _tmp12_;
	orgbluezobexPhonebookAccess* _tmp13_;
	orgbluezobexPhonebookAccess* _tmp14_;
	GError * _inner_error_;
};

struct _FolksBackendsBlueZPersonaStoreRemoveObexSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	char* session_path;
	orgbluezobexClient* _tmp0_;
	const char* _tmp1_;
	GError* ie;
	gboolean _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	gboolean _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const char* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* de;
	const char* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	FolksBackendsBlueZPersonaStore* self;
	gpointer _async_data_;
};

struct _orgbluezobexTransferIface {
	GTypeInterface parent_iface;
	void (*cancel) (orgbluezobexTransfer* self, GError** error);
	gchar* (*get_status) (orgbluezobexTransfer* self);
	char* (*get_session) (orgbluezobexTransfer* self);
	gchar* (*get_name) (orgbluezobexTransfer* self);
	gchar* (*get_transfer_type) (orgbluezobexTransfer* self);
	gint64 (*get_time) (orgbluezobexTransfer* self);
	guint64 (*get_size) (orgbluezobexTransfer* self);
	guint64 (*get_transferred) (orgbluezobexTransfer* self);
	gchar* (*get_filename) (orgbluezobexTransfer* self);
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gboolean has_yielded;
	gchar* transfer_status;
};

struct _Block4Data {
	int _ref_count_;
	Block2Data * _data2_;
	GFile* file;
};

struct _FolksBackendsBlueZPersonaStorePerformObexTransferData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	gchar* path;
	GCancellable* cancellable;
	Block2Data* _data2_;
	orgbluezobexTransfer* transfer;
	Block3Data* _data3_;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	orgbluezobexTransfer* _tmp2_;
	const gchar* _tmp3_;
	orgbluezobexTransfer* _tmp4_;
	orgbluezobexTransfer* _tmp5_;
	GDBusProxy* transfer_proxy;
	orgbluezobexTransfer* _tmp6_;
	GDBusProxy* _tmp7_;
	gulong signal_id;
	gulong cancellable_id;
	orgbluezobexTransfer* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GCancellable* _tmp11_;
	GCancellable* _tmp12_;
	gulong _tmp13_;
	GDBusProxy* _tmp14_;
	gulong _tmp15_;
	const gchar* _tmp16_;
	GDBusProxy* _tmp17_;
	gulong _tmp18_;
	gulong _tmp19_;
	GCancellable* _tmp20_;
	gulong _tmp21_;
	const gchar* _tmp22_;
	gchar* filename;
	orgbluezobexTransfer* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	orgbluezobexTransfer* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	GError* _tmp33_;
	GError* _tmp34_;
	GFile* file;
	const gchar* _tmp35_;
	GFile* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GFile* _tmp41_;
	const gchar* _tmp42_;
	GCancellable* _tmp43_;
	GCancellable* _tmp44_;
	const gchar* _tmp45_;
	orgbluezobexTransfer* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	GError* _tmp51_;
	GError* _tmp52_;
	gboolean _tmp53_;
	orgbluezobexTransfer* _tmp54_;
	orgbluezobexTransfer* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	Block4Data* _data4_;
	orgbluezobexTransfer* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GFile* _tmp63_;
	GFile* _tmp64_;
	GFile* _tmp65_;
	GError * _inner_error_;
};

struct _FolksBackendsBlueZPersonaStoreUpdateContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	gboolean download_photos;
	char* session_path;
	orgbluezobexPhonebookAccess* obex_pbap;
	gboolean success;
	GCancellable* _tmp0_;
	const char* _tmp1_;
	const char* _tmp2_;
	gboolean _tmp3_;
	guint _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean new_download_photos;
	gboolean _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* path;
	GHashTable* props;
	GCancellable* _tmp13_;
	char* _tmp14_;
	orgbluezobexPhonebookAccess* _tmp15_;
	char* _tmp16_;
	char* _tmp17_;
	GError* e1;
	gboolean _tmp18_;
	GError* _tmp19_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_;
	const gchar* _tmp23_;
	orgbluezDevice* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GError* _tmp28_;
	GError* _tmp29_;
	const gchar* _tmp30_;
	orgbluezDevice* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GError* _tmp35_;
	const gchar* _tmp36_;
	GError* _tmp37_;
	GError* _tmp38_;
	const char* _tmp39_;
	const char* _tmp40_;
	gboolean _tmp41_;
	guint _tmp42_;
	gboolean _vala1__tmp5_;
	gboolean _tmp43_;
	gboolean _tmp44_;
	gboolean _vala1_new_download_photos;
	gboolean _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	orgbluezobexPhonebookAccess* _tmp48_;
	GHashTable* phonebook_filter;
	GHashTable* _tmp49_;
	GHashTable* _tmp50_;
	gchar* _tmp51_;
	GVariant* _tmp52_;
	gboolean _tmp53_;
	GHashTable* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar** _tmp64_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	GVariant* _tmp66_;
	GHashTable* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar** _tmp76_;
	gchar** _tmp77_;
	gint _tmp77__length1;
	GVariant* _tmp78_;
	orgbluezobexPhonebookAccess* _tmp79_;
	GHashTable* _tmp80_;
	gchar* _tmp81_;
	GHashTable* _tmp82_;
	GError* e2;
	const gchar* _tmp83_;
	orgbluezDevice* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	GError* _tmp88_;
	const gchar* _tmp89_;
	GError* _tmp90_;
	GError* _tmp91_;
	const char* _tmp92_;
	const char* _tmp93_;
	gboolean _tmp94_;
	guint _tmp95_;
	gboolean _vala2__tmp5_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	gboolean _vala2_new_download_photos;
	gboolean _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	const gchar* _tmp101_;
	GCancellable* _tmp102_;
	GError* e3;
	GError* _tmp103_;
	GError* _tmp104_;
	GError* _tmp105_;
	const gchar* _tmp106_;
	const gchar* _tmp107_;
	GError* _tmp108_;
	const gchar* _tmp109_;
	GError* _tmp110_;
	const char* _tmp111_;
	const char* _tmp112_;
	gboolean _tmp113_;
	guint _tmp114_;
	gboolean _vala3__tmp5_;
	gboolean _tmp115_;
	gboolean _tmp116_;
	gboolean _vala3_new_download_photos;
	gboolean _tmp117_;
	const gchar* _tmp118_;
	const gchar* _tmp119_;
	GError* e4;
	GError* _tmp120_;
	GError* _tmp121_;
	GError* e5;
	GError* _tmp122_;
	GError* _tmp123_;
	const char* _tmp124_;
	const char* _tmp125_;
	gboolean _tmp126_;
	guint _tmp127_;
	gboolean _vala4__tmp5_;
	gboolean _tmp128_;
	gboolean _tmp129_;
	gboolean _vala4_new_download_photos;
	gboolean _tmp130_;
	const gchar* _tmp131_;
	const gchar* _tmp132_;
	GError * _inner_error_;
};

struct _Block5Data {
	int _ref_count_;
	FolksBackendsBlueZPersonaStore* self;
	gboolean download_photos;
};

struct _FolksBackendsBlueZPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GError* e1;
	const gchar* _tmp5_;
	orgbluezDevice* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError * _inner_error_;
};

struct _FolksBackendsBlueZPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsBlueZPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	GError * _inner_error_;
};


static gpointer folks_backends_blue_z_persona_store_parent_class = NULL;
static gchar** folks_backends_blue_z_persona_store__always_writeable_properties;
static gint folks_backends_blue_z_persona_store__always_writeable_properties_length1;
static gchar** folks_backends_blue_z_persona_store__always_writeable_properties = NULL;
static gint folks_backends_blue_z_persona_store__always_writeable_properties_length1 = 0;
static gint _folks_backends_blue_z_persona_store__always_writeable_properties_size_ = 0;

GType folks_backends_blue_z_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backends_blue_z_persona_get_type (void) G_GNUC_CONST;
GType org_bluez_obex_client_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_obex_client_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_bluez_obex_client_get_type (void) G_GNUC_CONST;
GType org_bluez_device_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_device_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GQuark org_bluez_error_quark (void);
GType org_bluez_device_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStorePrivate))
enum  {
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_TYPE_ID,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ADD_PERSONAS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_GROUP_PERSONAS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_PREPARED,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_QUIESCENT,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_PERSONAS,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME,
	FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH
};
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_MIN ((guint) 4)
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_BASE ((guint) 2)
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_MAX ((guint) (5 * 60))
#define FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__MAX_CONSECUTIVE_FAILURES ((guint) 3)
FolksBackendsBlueZPersonaStore* folks_backends_blue_z_persona_store_new (orgbluezDevice* device, const gchar* object_path, orgbluezobexClient* obex_client);
FolksBackendsBlueZPersonaStore* folks_backends_blue_z_persona_store_construct (GType object_type, orgbluezDevice* device, const gchar* object_path, orgbluezobexClient* obex_client);
gchar* org_bluez_device_get_address (orgbluezDevice* self);
gchar* org_bluez_device_get_alias (orgbluezDevice* self);
void folks_backends_blue_z_persona_store_set_is_trusted (FolksBackendsBlueZPersonaStore* self, gboolean trusted);
gboolean org_bluez_device_get_trusted (orgbluezDevice* self);
static void _folks_backends_blue_z_persona_store_update_contacts_from_file_data_free (gpointer _data);
static void _folks_backends_blue_z_persona_store_update_contacts_from_file (FolksBackendsBlueZPersonaStore* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_update_contacts_from_file_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _folks_backends_blue_z_persona_store_update_contacts_from_file_co (FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_);
static void _folks_backends_blue_z_persona_store_update_contacts_from_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self);
FolksBackendsBlueZPersona* folks_backends_blue_z_persona_new (const gchar* vcard, EVCard* card, FolksPersonaStore* store, gboolean is_user, const gchar* iid);
FolksBackendsBlueZPersona* folks_backends_blue_z_persona_construct (GType object_type, const gchar* vcard, EVCard* card, FolksPersonaStore* store, gboolean is_user, const gchar* iid);
gboolean folks_backends_blue_z_persona_update_from_vcard (FolksBackendsBlueZPersona* self, EVCard* card);
static void _vala_EVCardAttribute_free (EVCardAttribute* self);
void folks_backends_blue_z_persona_store_set_alias (FolksBackendsBlueZPersonaStore* self, const gchar* alias);
static void folks_backends_blue_z_persona_store_set_connection_state_data_free (gpointer _data);
void folks_backends_blue_z_persona_store_set_connection_state (FolksBackendsBlueZPersonaStore* self, gboolean connected, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backends_blue_z_persona_store_set_connection_state_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean folks_backends_blue_z_persona_store_set_connection_state_co (FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_);
static void _folks_backends_blue_z_persona_store_update_contacts (FolksBackendsBlueZPersonaStore* self, gboolean download_photos, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_update_contacts_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_backends_blue_z_persona_store_set_connection_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void folks_backends_blue_z_persona_store_cancel_updates (FolksBackendsBlueZPersonaStore* self);
static void _folks_backends_blue_z_persona_store_new_obex_session_data_free (gpointer _data);
GType org_bluez_obex_phonebook_access_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_obex_phonebook_access_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_bluez_obex_phonebook_access_phonebook_entry_get_type (void) G_GNUC_CONST;
orgbluezobexPhonebookAccessPhonebookEntry* org_bluez_obex_phonebook_access_phonebook_entry_dup (const orgbluezobexPhonebookAccessPhonebookEntry* self);
void org_bluez_obex_phonebook_access_phonebook_entry_free (orgbluezobexPhonebookAccessPhonebookEntry* self);
void org_bluez_obex_phonebook_access_phonebook_entry_copy (const orgbluezobexPhonebookAccessPhonebookEntry* self, orgbluezobexPhonebookAccessPhonebookEntry* dest);
void org_bluez_obex_phonebook_access_phonebook_entry_destroy (orgbluezobexPhonebookAccessPhonebookEntry* self);
GType org_bluez_obex_phonebook_access_get_type (void) G_GNUC_CONST;
static void _folks_backends_blue_z_persona_store_new_obex_session (FolksBackendsBlueZPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static char* _folks_backends_blue_z_persona_store_new_obex_session_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, orgbluezobexPhonebookAccess** obex_pbap, GError** error);
static gboolean _folks_backends_blue_z_persona_store_new_obex_session_co (FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (const gchar* value);
void org_bluez_obex_client_create_session (orgbluezobexClient* self, const gchar* address, GHashTable* args, GAsyncReadyCallback _callback_, gpointer _user_data_);
char* org_bluez_obex_client_create_session_finish (orgbluezobexClient* self, GAsyncResult* _res_, GError** error);
static void _folks_backends_blue_z_persona_store_new_obex_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_remove_obex_session_data_free (gpointer _data);
static void _folks_backends_blue_z_persona_store_remove_obex_session (FolksBackendsBlueZPersonaStore* self, const char* session_path, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_remove_obex_session_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_);
static gboolean _folks_backends_blue_z_persona_store_remove_obex_session_co (FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_);
void org_bluez_obex_client_remove_session (orgbluezobexClient* self, const char* session, GAsyncReadyCallback _callback_, gpointer _user_data_);
void org_bluez_obex_client_remove_session_finish (orgbluezobexClient* self, GAsyncResult* _res_, GError** error);
static void _folks_backends_blue_z_persona_store_remove_obex_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_perform_obex_transfer_data_free (gpointer _data);
static void _folks_backends_blue_z_persona_store_perform_obex_transfer (FolksBackendsBlueZPersonaStore* self, const gchar* path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _folks_backends_blue_z_persona_store_perform_obex_transfer_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _folks_backends_blue_z_persona_store_perform_obex_transfer_co (FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
GType org_bluez_obex_transfer_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_obex_transfer_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_bluez_obex_transfer_get_type (void) G_GNUC_CONST;
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _folks_backends_blue_z_persona_store_perform_obex_transfer_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gchar* org_bluez_obex_transfer_get_status (orgbluezobexTransfer* self);
static void ____lambda3_ (Block3Data* _data3_);
static void _____lambda3__gfunc (gconstpointer data, gpointer self);
static void ___lambda4_ (Block3Data* _data3_, GVariant* changed, gchar** invalidated, int invalidated_length1);
static void ____lambda4__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
gchar* org_bluez_obex_transfer_get_filename (orgbluezobexTransfer* self);
gchar* org_bluez_obex_transfer_get_name (orgbluezobexTransfer* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ____lambda5_ (Block4Data* _data4_, GObject* o, GAsyncResult* r);
static void _____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _folks_backends_blue_z_persona_store_update_contacts_data_free (gpointer _data);
static gboolean _folks_backends_blue_z_persona_store_update_contacts_co (FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_);
static void _folks_backends_blue_z_persona_store_schedule_update_contacts (FolksBackendsBlueZPersonaStore* self, gboolean download_photos);
static void _folks_backends_blue_z_persona_store_update_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void org_bluez_obex_phonebook_access_select (orgbluezobexPhonebookAccess* self, const gchar* location, const gchar* phonebook, GError** error);
static GVariant* _variant_new2 (const gchar* value);
void org_bluez_obex_phonebook_access_pull_all (orgbluezobexPhonebookAccess* self, const gchar* target, GHashTable* filters, gchar** path, GHashTable** props, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block5Data* _data5_);
static void __lambda7_ (FolksBackendsBlueZPersonaStore* self, GObject* o, GAsyncResult* r);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean ___lambda6__gsource_func (gpointer self);
static void folks_backends_blue_z_persona_store_real_prepare_data_free (gpointer _data);
static void folks_backends_blue_z_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_blue_z_persona_store_real_prepare_co (FolksBackendsBlueZPersonaStorePrepareData* _data_);
static void folks_backends_blue_z_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backends_blue_z_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_backends_blue_z_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_blue_z_persona_store_real_remove_persona_co (FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_);
static void folks_backends_blue_z_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_backends_blue_z_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_blue_z_persona_store_real_add_persona_from_details_co (FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_);
const gchar* folks_backends_blue_z_persona_store_get_display_name (FolksBackendsBlueZPersonaStore* self);
static void folks_backends_blue_z_persona_store_set_display_name (FolksBackendsBlueZPersonaStore* self, const gchar* value);
const gchar* folks_backends_blue_z_persona_store_get_object_path (FolksBackendsBlueZPersonaStore* self);
static void folks_backends_blue_z_persona_store_set_object_path (FolksBackendsBlueZPersonaStore* self, const gchar* value);
static GObject * folks_backends_blue_z_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_blue_z_persona_store_finalize (GObject* obj);
static void _vala_folks_backends_blue_z_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backends_blue_z_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to expose the {@link Persona}s provided by the
   * device with the given Bluetooth address.
   *
   * @param device the D-Bus object for the Bluetooth device.
   * @param object_path the D-Bus path of the object for the Bluetooth device
   * @param obex_client the D-Bus obex client object.
   *
   * @since 0.9.6
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksBackendsBlueZPersonaStore* folks_backends_blue_z_persona_store_construct (GType object_type, orgbluezDevice* device, const gchar* object_path, orgbluezobexClient* obex_client) {
	FolksBackendsBlueZPersonaStore * self = NULL;
	orgbluezDevice* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	orgbluezDevice* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	orgbluezDevice* _tmp9_ = NULL;
	orgbluezDevice* _tmp10_ = NULL;
	orgbluezobexClient* _tmp11_ = NULL;
	orgbluezobexClient* _tmp12_ = NULL;
	orgbluezDevice* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (obex_client != NULL, NULL);
	_tmp0_ = device;
	_tmp1_ = org_bluez_device_get_address (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = object_path;
	_tmp5_ = device;
	_tmp6_ = org_bluez_device_get_alias (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	self = (FolksBackendsBlueZPersonaStore*) g_object_new (object_type, "id", _tmp3_, "object-path", _tmp4_, "display-name", _tmp8_, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp3_);
	_tmp9_ = device;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->priv->_device);
	self->priv->_device = _tmp10_;
	_tmp11_ = obex_client;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->_obex_client);
	self->priv->_obex_client = _tmp12_;
	_tmp13_ = self->priv->_device;
	_tmp14_ = org_bluez_device_get_trusted (_tmp13_);
	_tmp15_ = _tmp14_;
	folks_backends_blue_z_persona_store_set_is_trusted (self, _tmp15_);
	return self;
}


FolksBackendsBlueZPersonaStore* folks_backends_blue_z_persona_store_new (orgbluezDevice* device, const gchar* object_path, orgbluezobexClient* obex_client) {
	return folks_backends_blue_z_persona_store_construct (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, device, object_path, obex_client);
}


static void _folks_backends_blue_z_persona_store_update_contacts_from_file_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData, _data_);
}


static void _folks_backends_blue_z_persona_store_update_contacts_from_file (FolksBackendsBlueZPersonaStore* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backends_blue_z_persona_store_update_contacts_from_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_update_contacts_from_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_folks_backends_blue_z_persona_store_update_contacts_from_file_co (_data_);
}


static void _folks_backends_blue_z_persona_store_update_contacts_from_file_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Load contacts from a file and update the persona store.
   *
   * Load contacts from a file identified by its {@link File} and update
   * the persona store accordingly. Contacts are stored in the file as a
   * sequence of vCards, separated by blank lines.
   *
   * If a contact already exists in the store, its properties will be updated
   * from the vCard; otherwise it will be added as a new contact to the store.
   * Contacts which are in the store and not in the vCard will be removed from
   * the store.
   *
   * If this throws an error, it guarantees to leave the store’s internal state
   * unchanged, but may change the state of {@link Persona}s in the store.
   *
   * @param file the file where the contacts are stored
   * @throws IOError if there was an error communicating with D-Bus
   * @throws Error if the given file couldn’t be read
   *
   * @since 0.9.6
   */
static void _folks_backends_blue_z_persona_store_update_contacts_from_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_update_contacts_from_file_co (_data_);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static EVCardAttribute* _vala_EVCardAttribute_copy (EVCardAttribute* self) {
	return g_boxed_copy (e_vcard_attribute_get_type (), self);
}


static gpointer __vala_EVCardAttribute_copy0 (gpointer self) {
	return self ? _vala_EVCardAttribute_copy (self) : NULL;
}


static void _vala_EVCardAttribute_free (EVCardAttribute* self) {
	g_boxed_free (e_vcard_attribute_get_type (), self);
}


static gboolean _folks_backends_blue_z_persona_store_update_contacts_from_file_co (FolksBackendsBlueZPersonaStoreUpdateContactsFromFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = gee_hash_set_new (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->added_personas = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = gee_hash_set_new (FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->removed_personas = _data_->_tmp1_;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = _data_->self->priv->_photos_up_to_date;
	_data_->photos_up_to_date = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->file;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_get_path (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	g_debug ("bluez-persona-store.vala:279: Parsing contacts from file ‘%s’.", _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->removed_personas;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->self->priv->_personas;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_collection_add_all ((GeeCollection*) _data_->_tmp6_, _data_->_tmp10_);
	_g_object_unref0 (_data_->_tmp10_);
	{
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->file;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_file_read (_data_->_tmp12_, NULL, &_data_->_inner_error_);
		_data_->_tmp11_ = _data_->_tmp13_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp11_);
		_data_->dis = _data_->_tmp14_;
		_data_->i = (guint) 0;
		_data_->line = NULL;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = g_string_new ("");
		_data_->vcard = _data_->_tmp15_;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = g_string_new ("");
		_data_->vcard_without_photo = _data_->_tmp16_;
		while (TRUE) {
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->dis;
			_data_->_state_ = 1;
			g_data_input_stream_read_line_async (_data_->_tmp18_, G_PRIORITY_DEFAULT, NULL, _folks_backends_blue_z_persona_store_update_contacts_from_file_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = g_data_input_stream_read_line_finish (_data_->_tmp18_, _data_->_res_, NULL, &_data_->_inner_error_);
			_data_->_tmp17_ = _data_->_tmp19_;
			if (_data_->_inner_error_ != NULL) {
				_g_string_free0 (_data_->vcard_without_photo);
				_g_string_free0 (_data_->vcard);
				_g_free0 (_data_->line);
				_g_object_unref0 (_data_->dis);
				_g_object_unref0 (_data_->_tmp11_);
				goto __catch5_g_error;
			}
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp17_;
			_data_->_tmp17_ = NULL;
			_g_free0 (_data_->line);
			_data_->line = _data_->_tmp20_;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->line;
			if (!(_data_->_tmp21_ != NULL)) {
				_g_free0 (_data_->_tmp17_);
				break;
			}
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->vcard;
			_data_->_tmp24_ = 0L;
			_data_->_tmp24_ = _data_->_tmp23_->len;
			if (_data_->_tmp24_ == ((gssize) 0)) {
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = _data_->line;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = string_strip (_data_->_tmp25_);
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->_tmp26_;
				_data_->_tmp22_ = g_strcmp0 (_data_->_tmp27_, "") == 0;
				_g_free0 (_data_->_tmp27_);
			} else {
				_data_->_tmp22_ = FALSE;
			}
			if (_data_->_tmp22_) {
				_g_free0 (_data_->_tmp17_);
				continue;
			}
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->vcard;
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->line;
			g_string_append (_data_->_tmp28_, _data_->_tmp29_);
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->vcard;
			g_string_append_c (_data_->_tmp30_, '\n');
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = _data_->line;
			_data_->_tmp33_ = FALSE;
			_data_->_tmp33_ = g_str_has_prefix (_data_->_tmp32_, "PHOTO:");
			if (!_data_->_tmp33_) {
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->line;
				_data_->_tmp35_ = FALSE;
				_data_->_tmp35_ = g_str_has_prefix (_data_->_tmp34_, "PHOTO;");
				_data_->_tmp31_ = !_data_->_tmp35_;
			} else {
				_data_->_tmp31_ = FALSE;
			}
			if (_data_->_tmp31_) {
				_data_->_tmp36_ = NULL;
				_data_->_tmp36_ = _data_->vcard_without_photo;
				_data_->_tmp37_ = NULL;
				_data_->_tmp37_ = _data_->line;
				g_string_append (_data_->_tmp36_, _data_->_tmp37_);
				_data_->_tmp38_ = NULL;
				_data_->_tmp38_ = _data_->vcard_without_photo;
				g_string_append_c (_data_->_tmp38_, '\n');
			}
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = _data_->line;
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = string_strip (_data_->_tmp39_);
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = _data_->_tmp40_;
			_data_->_tmp42_ = FALSE;
			_data_->_tmp42_ = g_strcmp0 (_data_->_tmp41_, "END:VCARD") == 0;
			_g_free0 (_data_->_tmp41_);
			if (_data_->_tmp42_) {
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = _data_->vcard;
				_data_->_tmp44_ = NULL;
				_data_->_tmp44_ = _data_->_tmp43_->str;
				_data_->_tmp45_ = NULL;
				_data_->_tmp45_ = e_vcard_new_from_string (_data_->_tmp44_);
				_data_->card = _data_->_tmp45_;
				_data_->_tmp46_ = 0U;
				_data_->_tmp46_ = _data_->i;
				_data_->is_user = _data_->_tmp46_ == ((guint) 0);
				_data_->iid_is_checksum = FALSE;
				_data_->_tmp47_ = NULL;
				_data_->_tmp47_ = _data_->card;
				_data_->_tmp48_ = NULL;
				_data_->_tmp48_ = e_vcard_get_attribute (_data_->_tmp47_, "UID");
				_data_->_tmp49_ = NULL;
				_data_->_tmp49_ = __vala_EVCardAttribute_copy0 (_data_->_tmp48_);
				_data_->attribute = _data_->_tmp49_;
				_data_->_tmp50_ = NULL;
				_data_->_tmp50_ = _data_->attribute;
				if (_data_->_tmp50_ != NULL) {
					_data_->_tmp51_ = NULL;
					_data_->_tmp51_ = _data_->attribute;
					_data_->_tmp52_ = NULL;
					_data_->_tmp52_ = e_vcard_attribute_get_value_decoded (_data_->_tmp51_);
					_data_->_tmp53_ = NULL;
					_data_->_tmp53_ = _data_->_tmp52_;
					_data_->_tmp54_ = NULL;
					_data_->_tmp54_ = _data_->_tmp53_->str;
					_data_->_tmp55_ = NULL;
					_data_->_tmp55_ = g_strdup (_data_->_tmp54_);
					_g_free0 (_data_->iid);
					_data_->iid = _data_->_tmp55_;
					_g_string_free0 (_data_->_tmp53_);
				} else {
					_data_->_tmp56_ = NULL;
					_data_->_tmp56_ = _data_->vcard_without_photo;
					_data_->_tmp57_ = NULL;
					_data_->_tmp57_ = _data_->_tmp56_->str;
					_data_->_tmp58_ = NULL;
					_data_->_tmp58_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _data_->_tmp57_, (gsize) (-1));
					_g_free0 (_data_->iid);
					_data_->iid = _data_->_tmp58_;
					_data_->iid_is_checksum = TRUE;
				}
				_data_->_tmp59_ = NULL;
				_data_->_tmp59_ = _data_->self->priv->_personas;
				_data_->_tmp60_ = NULL;
				_data_->_tmp60_ = _data_->iid;
				_data_->_tmp61_ = NULL;
				_data_->_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp59_, _data_->_tmp60_);
				_data_->persona = (FolksBackendsBlueZPersona*) _data_->_tmp61_;
				_data_->_tmp62_ = NULL;
				_data_->_tmp62_ = _data_->persona;
				if (_data_->_tmp62_ == NULL) {
					_data_->_tmp63_ = NULL;
					_data_->_tmp63_ = _data_->vcard;
					_data_->_tmp64_ = NULL;
					_data_->_tmp64_ = _data_->_tmp63_->str;
					_data_->_tmp65_ = NULL;
					_data_->_tmp65_ = _data_->card;
					_data_->_tmp66_ = FALSE;
					_data_->_tmp66_ = _data_->is_user;
					_data_->_tmp67_ = NULL;
					_data_->_tmp67_ = _data_->iid;
					_data_->_tmp68_ = NULL;
					_data_->_tmp68_ = folks_backends_blue_z_persona_new (_data_->_tmp64_, _data_->_tmp65_, (FolksPersonaStore*) _data_->self, _data_->_tmp66_, _data_->_tmp67_);
					_g_object_unref0 (_data_->persona);
					_data_->persona = _data_->_tmp68_;
					_data_->photos_up_to_date = FALSE;
				} else {
					_data_->_tmp70_ = FALSE;
					_data_->_tmp70_ = _data_->iid_is_checksum;
					if (_data_->_tmp70_ == FALSE) {
						_data_->_tmp69_ = TRUE;
					} else {
						_data_->_tmp71_ = NULL;
						_data_->_tmp71_ = _data_->vcard_without_photo;
						_data_->_tmp72_ = 0L;
						_data_->_tmp72_ = _data_->_tmp71_->len;
						_data_->_tmp73_ = NULL;
						_data_->_tmp73_ = _data_->vcard;
						_data_->_tmp74_ = 0L;
						_data_->_tmp74_ = _data_->_tmp73_->len;
						_data_->_tmp69_ = _data_->_tmp72_ != _data_->_tmp74_;
					}
					if (_data_->_tmp69_) {
						_data_->_tmp75_ = NULL;
						_data_->_tmp75_ = _data_->persona;
						_data_->_tmp76_ = NULL;
						_data_->_tmp76_ = _data_->card;
						_data_->_tmp77_ = FALSE;
						_data_->_tmp77_ = folks_backends_blue_z_persona_update_from_vcard (_data_->_tmp75_, _data_->_tmp76_);
						if (_data_->_tmp77_ == TRUE) {
							_data_->photos_up_to_date = FALSE;
						}
					}
				}
				_data_->_tmp78_ = NULL;
				_data_->_tmp78_ = _data_->removed_personas;
				_data_->_tmp79_ = NULL;
				_data_->_tmp79_ = _data_->persona;
				_data_->_tmp80_ = FALSE;
				_data_->_tmp80_ = gee_abstract_collection_remove ((GeeAbstractCollection*) _data_->_tmp78_, _data_->_tmp79_);
				if (_data_->_tmp80_ == FALSE) {
					_data_->_tmp81_ = NULL;
					_data_->_tmp81_ = _data_->added_personas;
					_data_->_tmp82_ = NULL;
					_data_->_tmp82_ = _data_->persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp81_, _data_->_tmp82_);
				}
				_data_->_tmp83_ = 0U;
				_data_->_tmp83_ = _data_->i;
				_data_->i = _data_->_tmp83_ + 1;
				_data_->_tmp84_ = NULL;
				_data_->_tmp84_ = _data_->vcard;
				g_string_erase (_data_->_tmp84_, (gssize) 0, (gssize) (-1));
				_data_->_tmp85_ = NULL;
				_data_->_tmp85_ = _data_->vcard_without_photo;
				g_string_erase (_data_->_tmp85_, (gssize) 0, (gssize) (-1));
				_g_object_unref0 (_data_->persona);
				__vala_EVCardAttribute_free0 (_data_->attribute);
				_g_free0 (_data_->iid);
				_g_object_unref0 (_data_->card);
			}
			_g_free0 (_data_->_tmp17_);
		}
		_g_string_free0 (_data_->vcard_without_photo);
		_g_string_free0 (_data_->vcard);
		_g_free0 (_data_->line);
		_g_object_unref0 (_data_->dis);
		_g_object_unref0 (_data_->_tmp11_);
	}
	goto __finally5;
	__catch5_g_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp86_ = NULL;
		_data_->_tmp86_ = _ ("Error reading the transferred address book file: %s");
		_data_->_tmp87_ = NULL;
		_data_->_tmp87_ = _data_->e1;
		_data_->_tmp88_ = NULL;
		_data_->_tmp88_ = _data_->_tmp87_->message;
		_data_->_tmp89_ = NULL;
		_data_->_tmp89_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, _data_->_tmp86_, _data_->_tmp88_);
		_data_->_inner_error_ = _data_->_tmp89_;
		_g_error_free0 (_data_->e1);
		goto __finally5;
	}
	__finally5:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == G_IO_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->removed_personas);
			_g_object_unref0 (_data_->added_personas);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->removed_personas);
			_g_object_unref0 (_data_->added_personas);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp90_ = NULL;
	_data_->_tmp90_ = _data_->added_personas;
	_data_->_tmp91_ = 0;
	_data_->_tmp91_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp90_);
	_data_->_tmp92_ = 0;
	_data_->_tmp92_ = _data_->_tmp91_;
	_data_->_tmp93_ = NULL;
	_data_->_tmp93_ = _data_->removed_personas;
	_data_->_tmp94_ = 0;
	_data_->_tmp94_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp93_);
	_data_->_tmp95_ = 0;
	_data_->_tmp95_ = _data_->_tmp94_;
	g_debug ("Finished parsing personas; now updating store state with %u " "added personas and %u removed personas.", _data_->_tmp92_, _data_->_tmp95_);
	{
		_data_->_tmp96_ = NULL;
		_data_->_tmp96_ = _data_->added_personas;
		_data_->_tmp97_ = NULL;
		_data_->_tmp97_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp96_);
		_data_->_p_it = _data_->_tmp97_;
		while (TRUE) {
			_data_->_tmp98_ = NULL;
			_data_->_tmp98_ = _data_->_p_it;
			_data_->_tmp99_ = FALSE;
			_data_->_tmp99_ = gee_iterator_next (_data_->_tmp98_);
			if (!_data_->_tmp99_) {
				break;
			}
			_data_->_tmp100_ = NULL;
			_data_->_tmp100_ = _data_->_p_it;
			_data_->_tmp101_ = NULL;
			_data_->_tmp101_ = gee_iterator_get (_data_->_tmp100_);
			_data_->p = (FolksBackendsBlueZPersona*) _data_->_tmp101_;
			_data_->_tmp102_ = NULL;
			_data_->_tmp102_ = _data_->self->priv->_personas;
			_data_->_tmp103_ = NULL;
			_data_->_tmp103_ = _data_->p;
			_data_->_tmp104_ = NULL;
			_data_->_tmp104_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp103_);
			_data_->_tmp105_ = NULL;
			_data_->_tmp105_ = _data_->_tmp104_;
			_data_->_tmp106_ = NULL;
			_data_->_tmp106_ = _data_->p;
			gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp102_, _data_->_tmp105_, _data_->_tmp106_);
			_g_object_unref0 (_data_->p);
		}
		_g_object_unref0 (_data_->_p_it);
	}
	{
		_data_->_tmp107_ = NULL;
		_data_->_tmp107_ = _data_->removed_personas;
		_data_->_tmp108_ = NULL;
		_data_->_tmp108_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp107_);
		_data_->_vala1__p_it = _data_->_tmp108_;
		while (TRUE) {
			_data_->_tmp109_ = NULL;
			_data_->_tmp109_ = _data_->_vala1__p_it;
			_data_->_tmp110_ = FALSE;
			_data_->_tmp110_ = gee_iterator_next (_data_->_tmp109_);
			if (!_data_->_tmp110_) {
				break;
			}
			_data_->_tmp111_ = NULL;
			_data_->_tmp111_ = _data_->_vala1__p_it;
			_data_->_tmp112_ = NULL;
			_data_->_tmp112_ = gee_iterator_get (_data_->_tmp111_);
			_data_->_vala1_p = (FolksBackendsBlueZPersona*) _data_->_tmp112_;
			_data_->_tmp113_ = NULL;
			_data_->_tmp113_ = _data_->self->priv->_personas;
			_data_->_tmp114_ = NULL;
			_data_->_tmp114_ = _data_->_vala1_p;
			_data_->_tmp115_ = NULL;
			_data_->_tmp115_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp114_);
			_data_->_tmp116_ = NULL;
			_data_->_tmp116_ = _data_->_tmp115_;
			gee_abstract_map_unset ((GeeAbstractMap*) _data_->_tmp113_, _data_->_tmp116_, NULL);
			_g_object_unref0 (_data_->_vala1_p);
		}
		_g_object_unref0 (_data_->_vala1__p_it);
	}
	_data_->_tmp117_ = FALSE;
	_data_->_tmp117_ = _data_->photos_up_to_date;
	_data_->self->priv->_photos_up_to_date = _data_->_tmp117_;
	_data_->_tmp119_ = NULL;
	_data_->_tmp119_ = _data_->added_personas;
	_data_->_tmp120_ = FALSE;
	_data_->_tmp120_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp119_);
	_data_->_tmp121_ = FALSE;
	_data_->_tmp121_ = _data_->_tmp120_;
	if (_data_->_tmp121_ == FALSE) {
		_data_->_tmp118_ = TRUE;
	} else {
		_data_->_tmp122_ = NULL;
		_data_->_tmp122_ = _data_->removed_personas;
		_data_->_tmp123_ = FALSE;
		_data_->_tmp123_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp122_);
		_data_->_tmp124_ = FALSE;
		_data_->_tmp124_ = _data_->_tmp123_;
		_data_->_tmp118_ = _data_->_tmp124_ == FALSE;
	}
	if (_data_->_tmp118_) {
		_data_->_tmp125_ = NULL;
		_data_->_tmp125_ = _data_->added_personas;
		_data_->_tmp126_ = NULL;
		_data_->_tmp126_ = _data_->removed_personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp125_, (GeeSet*) _data_->_tmp126_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (_data_->removed_personas);
	_g_object_unref0 (_data_->added_personas);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Set the persona store's alias.
   *
   * This will be called in response to a property change sent to the Backend.
   *
   * @param alias the device’s new alias
   *
   * @since 0.9.6
   */
void folks_backends_blue_z_persona_store_set_alias (FolksBackendsBlueZPersonaStore* self, const gchar* alias) {
	const gchar* _tmp0_ = NULL;
	orgbluezDevice* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alias != NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = self->priv->_device;
	_tmp2_ = org_bluez_device_get_address (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = alias;
	g_debug ("bluez-persona-store.vala:420: Device ‘%s’ (%s) changed alias to ‘%s’.", _tmp0_, _tmp4_, _tmp5_);
	_g_free0 (_tmp4_);
	_tmp6_ = alias;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp7_;
	g_object_notify ((GObject*) self, "display-name");
}


/**
   * Set the persona store's trust level.
   *
   * This will be called in response to a property change sent to the Backend.
   *
   * Default to partial trust. BlueZ persona UIDs are built from a SHA1
   * of the contact’s vCard, which we believe can’t be maliciously edited
   * to corrupt linking.
   *
   * The trust for each device is manually set by the user in the BlueZ
   * interface on the computer.
   *
   * @param trusted ``true`` if the user trusts the device, ``false`` otherwise
   *
   * @since 0.9.6
   */
void folks_backends_blue_z_persona_store_set_is_trusted (FolksBackendsBlueZPersonaStore* self, gboolean trusted) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	orgbluezDevice* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	orgbluezDevice* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	FolksPersonaStoreTrust _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = trusted;
	if (_tmp1_) {
		_tmp0_ = "trusted";
	} else {
		_tmp0_ = "untrusted";
	}
	_tmp2_ = self->priv->_device;
	_tmp3_ = org_bluez_device_get_alias (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_device;
	_tmp7_ = org_bluez_device_get_address (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	g_debug ("bluez-persona-store.vala:445: Device ‘%s’ (%s) marked as %s.", _tmp5_, _tmp9_, _tmp0_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	_tmp11_ = trusted;
	if (_tmp11_) {
		_tmp10_ = FOLKS_PERSONA_STORE_TRUST_FULL;
	} else {
		_tmp10_ = FOLKS_PERSONA_STORE_TRUST_PARTIAL;
	}
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, _tmp10_);
}


static void folks_backends_blue_z_persona_store_set_connection_state_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreSetConnectionStateData, _data_);
}


void folks_backends_blue_z_persona_store_set_connection_state (FolksBackendsBlueZPersonaStore* self, gboolean connected, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreSetConnectionStateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_blue_z_persona_store_set_connection_state);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_blue_z_persona_store_set_connection_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = connected;
	_data_->connected = _tmp1_;
	folks_backends_blue_z_persona_store_set_connection_state_co (_data_);
}


void folks_backends_blue_z_persona_store_set_connection_state_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Set the persona store's connection state.
   *
   * This will be called in response to a property change sent to the Backend.
   *
   * If this throws an error, it guarantees to leave the store’s internal state
   * unchanged.
   *
   * @param connected ``true`` if the device is now connected, ``false``
   * otherwise
   *
   * @throws IOError if the operation was cancelled
   * (see {@link _update_contacts})
   * @throws PersonaStoreError if the contacts couldn’t be updated
   * (see {@link _update_contacts})
   *
   * @since 0.9.6
   */
static void folks_backends_blue_z_persona_store_set_connection_state_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_blue_z_persona_store_set_connection_state_co (_data_);
}


static gboolean folks_backends_blue_z_persona_store_set_connection_state_co (FolksBackendsBlueZPersonaStoreSetConnectionStateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->connected;
	if (_data_->_tmp0_ == TRUE) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->_device;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = org_bluez_device_get_alias (_data_->_tmp1_);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->_device;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = org_bluez_device_get_address (_data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp7_;
		g_debug ("bluez-persona-store.vala:475: Device ‘%s’ (%s) is connected.", _data_->_tmp4_, _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
		_g_free0 (_data_->_tmp4_);
		_data_->_state_ = 1;
		_folks_backends_blue_z_persona_store_update_contacts (_data_->self, FALSE, folks_backends_blue_z_persona_store_set_connection_state_ready, _data_);
		return FALSE;
		_state_1:
		_folks_backends_blue_z_persona_store_update_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR)) {
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	} else {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->self->priv->_device;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = org_bluez_device_get_alias (_data_->_tmp9_);
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->self->priv->_device;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = org_bluez_device_get_address (_data_->_tmp13_);
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_tmp15_;
		g_debug ("bluez-persona-store.vala:482: Device ‘%s’ (%s) is disconnected.", _data_->_tmp12_, _data_->_tmp16_);
		_g_free0 (_data_->_tmp16_);
		_g_free0 (_data_->_tmp12_);
		folks_backends_blue_z_persona_store_cancel_updates (_data_->self);
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_persona_store_new_obex_session_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreNewObexSessionData, _data_);
}


static void _folks_backends_blue_z_persona_store_new_obex_session (FolksBackendsBlueZPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreNewObexSessionData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backends_blue_z_persona_store_new_obex_session);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_new_obex_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_folks_backends_blue_z_persona_store_new_obex_session_co (_data_);
}


static char* _folks_backends_blue_z_persona_store_new_obex_session_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, orgbluezobexPhonebookAccess** obex_pbap, GError** error) {
	char* result;
	FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (obex_pbap) {
		*obex_pbap = _data_->obex_pbap;
	} else {
		_g_object_unref0 (_data_->obex_pbap);
	}
	_data_->obex_pbap = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Create a new obex session for this Persona store.
   *
   * Create a new obex session for this Persona store if no previous session
   * already exists.
   *
   * @param obex_pbap return location for an OBEX PBAP proxy object
   * @returns the path of the OBEX session D-Bus object
   * @throws IOError if it can't connect to D-Bus
   * @throws DBusError if it can't create a new OBEX session
   *
   * @since 0.9.6
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GVariant* _variant_new1 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void _folks_backends_blue_z_persona_store_new_obex_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_new_obex_session_co (_data_);
}


static gboolean _folks_backends_blue_z_persona_store_new_obex_session_co (FolksBackendsBlueZPersonaStoreNewObexSessionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_debug ("bluez-persona-store.vala:507: Creating a new OBEX session.");
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	_data_->args = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->args;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_strdup ("Target");
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _variant_new1 ("PBAP");
	g_hash_table_insert (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->_obex_client;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->args;
	_data_->_state_ = 1;
	org_bluez_obex_client_create_session (_data_->_tmp4_, _data_->_tmp6_, _data_->_tmp7_, _folks_backends_blue_z_persona_store_new_obex_session_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = org_bluez_obex_client_create_session_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
	_data_->session_path = _data_->_tmp8_;
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == G_DBUS_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_hash_table_unref0 (_data_->args);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_hash_table_unref0 (_data_->args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->session_path;
	g_debug ("bluez-persona-store.vala:514:     Got OBEX session path: %s", (const gchar*) _data_->_tmp9_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->session_path;
	_data_->_state_ = 2;
	g_async_initable_new_async (ORG_BLUEZ_OBEX_TYPE_PHONEBOOK_ACCESS_PROXY, 0, NULL, _folks_backends_blue_z_persona_store_new_obex_session_ready, _data_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _data_->_tmp11_, "g-interface-name", "org.bluez.obex.PhonebookAccess1", NULL);
	return FALSE;
	_state_2:
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp10_ = (orgbluezobexPhonebookAccess*) _data_->_tmp12_;
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == G_DBUS_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->session_path);
			_g_hash_table_unref0 (_data_->args);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->session_path);
			_g_hash_table_unref0 (_data_->args);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp10_;
	_data_->_tmp10_ = NULL;
	_g_object_unref0 (_data_->obex_pbap);
	_data_->obex_pbap = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->obex_pbap;
	g_debug ("bluez-persona-store.vala:519:     Got OBEX PBAP proxy: %p", _data_->_tmp14_);
	_data_->result = _data_->session_path;
	_g_object_unref0 (_data_->_tmp10_);
	_g_hash_table_unref0 (_data_->args);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->_tmp10_);
	_g_free0 (_data_->session_path);
	_g_hash_table_unref0 (_data_->args);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_persona_store_remove_obex_session_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->session_path);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreRemoveObexSessionData, _data_);
}


static void _folks_backends_blue_z_persona_store_remove_obex_session (FolksBackendsBlueZPersonaStore* self, const char* session_path, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreRemoveObexSessionData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backends_blue_z_persona_store_remove_obex_session);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_remove_obex_session_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = session_path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->session_path);
	_data_->session_path = _tmp2_;
	_folks_backends_blue_z_persona_store_remove_obex_session_co (_data_);
}


static void _folks_backends_blue_z_persona_store_remove_obex_session_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_) {
	FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove the specified OBEX session from this persona store.
   *
   * Remove the specified OBEX session for this persona store and discard its
   * transfer.
   *
   * @param session_path the path of the OBEX session D-Bus object to remove
   *
   * @since 0.9.6
   */
static void _folks_backends_blue_z_persona_store_remove_obex_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_remove_obex_session_co (_data_);
}


static gboolean _folks_backends_blue_z_persona_store_remove_obex_session_co (FolksBackendsBlueZPersonaStoreRemoveObexSessionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->self->priv->_obex_client;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->session_path;
		_data_->_state_ = 1;
		org_bluez_obex_client_remove_session (_data_->_tmp0_, _data_->_tmp1_, _folks_backends_blue_z_persona_store_remove_obex_session_ready, _data_);
		return FALSE;
		_state_1:
		org_bluez_obex_client_remove_session_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch6_g_io_error;
			}
			if (_data_->_inner_error_->domain == G_DBUS_ERROR) {
				goto __catch6_g_dbus_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	goto __finally6;
	__catch6_g_io_error:
	{
		_data_->ie = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->ie;
		if (g_error_matches (_data_->_tmp3_, G_IO_ERROR, G_IO_ERROR_CLOSED)) {
			_data_->_tmp2_ = TRUE;
		} else {
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = _data_->ie;
			_data_->_tmp2_ = g_error_matches (_data_->_tmp4_, G_IO_ERROR, G_IO_ERROR_CANCELLED);
		}
		if (_data_->_tmp2_) {
			_g_error_free0 (_data_->ie);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->ie;
		if (g_error_matches (_data_->_tmp6_, G_IO_ERROR, G_IO_ERROR_DBUS_ERROR)) {
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->ie;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			_data_->_tmp9_ = FALSE;
			_data_->_tmp9_ = g_str_has_prefix (_data_->_tmp8_, "GDBus.Error:org.freedesktop.DBus." "Python.dbus.exceptions.DBusException: " "('org.freedesktop.DBus.Mock.NameError'");
			_data_->_tmp5_ = _data_->_tmp9_;
		} else {
			_data_->_tmp5_ = FALSE;
		}
		if (_data_->_tmp5_) {
			_g_error_free0 (_data_->ie);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->session_path;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->ie;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_warning ("bluez-persona-store.vala:555: Couldn’t remove OBEX session ‘%s’: %s", (const gchar*) _data_->_tmp10_, _data_->_tmp12_);
		_g_error_free0 (_data_->ie);
	}
	goto __finally6;
	__catch6_g_dbus_error:
	{
		_data_->de = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->session_path;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->de;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_tmp14_->message;
		g_warning ("bluez-persona-store.vala:560: Couldn’t remove OBEX session ‘%s’: %s", (const gchar*) _data_->_tmp13_, _data_->_tmp15_);
		_g_error_free0 (_data_->de);
	}
	__finally6:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_persona_store_perform_obex_transfer_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStorePerformObexTransferData, _data_);
}


static void _folks_backends_blue_z_persona_store_perform_obex_transfer (FolksBackendsBlueZPersonaStore* self, const gchar* path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStorePerformObexTransferData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backends_blue_z_persona_store_perform_obex_transfer);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_perform_obex_transfer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->path);
	_data_->path = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	_folks_backends_blue_z_persona_store_perform_obex_transfer_co (_data_);
}


static void _folks_backends_blue_z_persona_store_perform_obex_transfer_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Watch an OBEX transfer identified by its D-Bus path.
   *
   * This only returns once the transfer is complete (or has failed) and the
   * transfer object has been destroyed.
   *
   * If this throws an error, it guarantees to leave the store’s internal state
   * unchanged.
   *
   * @param path the D-Bus transfer object path to watch.
   * @param cancellable an optional {@link Cancellable} object to cancel the
   * transfer
   *
   * @throws IOError if the operation was cancelled, or if another failure
   * occurred (unavoidable; valac generates invalid C if we try to handle
   * IOError internally here)
   * @throws PersonaStoreError if the transfer failed
   *
   * @since 0.9.6
   */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		FolksBackendsBlueZPersonaStore* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FolksBackendsBlueZPersonaStore* self;
		self = _data3_->_data2_->self;
		_g_free0 (_data3_->transfer_status);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static void _folks_backends_blue_z_persona_store_perform_obex_transfer_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_perform_obex_transfer_co (_data_);
}


static void ____lambda3_ (Block3Data* _data3_) {
	Block2Data* _data2_;
	FolksBackendsBlueZPersonaStore* self;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = g_strdup ("error");
	_g_free0 (_data3_->transfer_status);
	_data3_->transfer_status = _tmp0_;
	_tmp1_ = _data3_->has_yielded;
	if (_tmp1_ == TRUE) {
		_folks_backends_blue_z_persona_store_perform_obex_transfer_co (_data2_->_async_data_);
	}
}


static void _____lambda3__gfunc (gconstpointer data, gpointer self) {
	____lambda3_ (self);
}


static void ___lambda4_ (Block3Data* _data3_, GVariant* changed, gchar** invalidated, int invalidated_length1) {
	Block2Data* _data2_;
	FolksBackendsBlueZPersonaStore* self;
	GVariant* property = NULL;
	GVariant* _tmp0_ = NULL;
	const GVariantType* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	gchar* status = NULL;
	GVariant* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	g_return_if_fail (changed != NULL);
	_tmp0_ = changed;
	_tmp1_ = G_VARIANT_TYPE_STRING;
	_tmp2_ = g_variant_lookup_value (_tmp0_, "Status", _tmp1_);
	property = _tmp2_;
	_tmp3_ = property;
	if (_tmp3_ == NULL) {
		_g_variant_unref0 (property);
		return;
	}
	_tmp4_ = property;
	_tmp5_ = g_variant_get_string (_tmp4_, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	status = _tmp6_;
	_tmp7_ = status;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_data3_->transfer_status);
	_data3_->transfer_status = _tmp8_;
	_tmp10_ = status;
	if (g_strcmp0 (_tmp10_, "complete") == 0) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_ = NULL;
		_tmp11_ = status;
		_tmp9_ = g_strcmp0 (_tmp11_, "error") == 0;
	}
	if (_tmp9_) {
		gboolean _tmp12_ = FALSE;
		_tmp12_ = _data3_->has_yielded;
		if (_tmp12_ == TRUE) {
			_folks_backends_blue_z_persona_store_perform_obex_transfer_co (_data2_->_async_data_);
		}
	} else {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_ = NULL;
		_tmp14_ = status;
		if (g_strcmp0 (_tmp14_, "queued") == 0) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = status;
			_tmp13_ = g_strcmp0 (_tmp15_, "active") == 0;
		}
		if (_tmp13_) {
		} else {
			const gchar* _tmp16_ = NULL;
			_tmp16_ = status;
			g_warning ("bluez-persona-store.vala:647: Unknown OBEX transfer status ‘%s’.", _tmp16_);
		}
	}
	_g_free0 (status);
	_g_variant_unref0 (property);
}


static void ____lambda4__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	___lambda4_ (self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		FolksBackendsBlueZPersonaStore* self;
		self = _data4_->_data2_->self;
		_g_object_unref0 (_data4_->file);
		block2_data_unref (_data4_->_data2_);
		_data4_->_data2_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}


static void ____lambda5_ (Block4Data* _data4_, GObject* o, GAsyncResult* r) {
	Block2Data* _data2_;
	FolksBackendsBlueZPersonaStore* self;
	GError * _inner_error_ = NULL;
	_data2_ = _data4_->_data2_;
	self = _data2_->self;
	g_return_if_fail (r != NULL);
	{
		GFile* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data4_->file;
		_tmp1_ = r;
		g_file_delete_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e1 = NULL;
		e1 = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e1);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _____lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda5_ (self, source_object, res);
	block4_data_unref (self);
}


static gboolean _folks_backends_blue_z_persona_store_perform_obex_transfer_co (FolksBackendsBlueZPersonaStorePerformObexTransferData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data2_ = g_slice_new0 (Block2Data);
	_data_->_data2_->_ref_count_ = 1;
	_data_->_data2_->self = g_object_ref (_data_->self);
	_data_->_data2_->_async_data_ = _data_;
	_data_->transfer = NULL;
	{
		_data_->_data3_ = g_slice_new0 (Block3Data);
		_data_->_data3_->_ref_count_ = 1;
		_data_->_data3_->_data2_ = block2_data_ref (_data_->_data2_);
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->cancellable;
		if (_data_->_tmp0_ != NULL) {
			_data_->_tmp1_ = NULL;
			_data_->_tmp1_ = _data_->cancellable;
			g_cancellable_set_error_if_cancelled (_data_->_tmp1_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				block3_data_unref (_data_->_data3_);
				_data_->_data3_ = NULL;
				goto __finally7;
			}
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->path;
		_data_->_state_ = 1;
		g_async_initable_new_async (ORG_BLUEZ_OBEX_TYPE_TRANSFER_PROXY, 0, NULL, _folks_backends_blue_z_persona_store_perform_obex_transfer_ready, _data_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _data_->_tmp3_, "g-interface-name", "org.bluez.obex.Transfer1", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp2_ = (orgbluezobexTransfer*) _data_->_tmp4_;
		if (_data_->_inner_error_ != NULL) {
			block3_data_unref (_data_->_data3_);
			_data_->_data3_ = NULL;
			goto __finally7;
		}
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp2_;
		_data_->_tmp2_ = NULL;
		_g_object_unref0 (_data_->transfer);
		_data_->transfer = _data_->_tmp5_;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->transfer;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, G_TYPE_DBUS_PROXY, GDBusProxy));
		_data_->transfer_proxy = _data_->_tmp7_;
		_data_->_data3_->has_yielded = FALSE;
		_data_->_data3_->transfer_status = NULL;
		_data_->cancellable_id = (gulong) 0;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->transfer;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = org_bluez_obex_transfer_get_status (_data_->_tmp8_);
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_;
		_g_free0 (_data_->_data3_->transfer_status);
		_data_->_data3_->transfer_status = _data_->_tmp10_;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->cancellable;
		if (_data_->_tmp11_ != NULL) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _data_->cancellable;
			_data_->_tmp13_ = 0UL;
			_data_->_tmp13_ = g_cancellable_connect (_data_->_tmp12_, (GCallback) _____lambda3__gfunc, block3_data_ref (_data_->_data3_), block3_data_unref);
			_data_->cancellable_id = _data_->_tmp13_;
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->transfer_proxy;
		_data_->_tmp15_ = 0UL;
		_data_->_tmp15_ = g_signal_connect_data (_data_->_tmp14_, "g-properties-changed", (GCallback) ____lambda4__g_dbus_proxy_g_properties_changed, block3_data_ref (_data_->_data3_), (GClosureNotify) block3_data_unref, 0);
		_data_->signal_id = _data_->_tmp15_;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_data3_->transfer_status;
		if (_data_->_tmp16_ == NULL) {
			_data_->_data3_->has_yielded = TRUE;
			_data_->_state_ = 2;
			return FALSE;
			_state_2:
			;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = _data_->transfer_proxy;
		_data_->_tmp18_ = 0UL;
		_data_->_tmp18_ = _data_->signal_id;
		g_signal_handler_disconnect ((GObject*) _data_->_tmp17_, _data_->_tmp18_);
		_data_->_tmp19_ = 0UL;
		_data_->_tmp19_ = _data_->cancellable_id;
		if (_data_->_tmp19_ != ((gulong) 0)) {
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->cancellable;
			_data_->_tmp21_ = 0UL;
			_data_->_tmp21_ = _data_->cancellable_id;
			g_cancellable_disconnect (_data_->_tmp20_, _data_->_tmp21_);
		}
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->_data3_->transfer_status;
		if (g_strcmp0 (_data_->_tmp22_, "complete") == 0) {
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->transfer;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = org_bluez_obex_transfer_get_filename (_data_->_tmp23_);
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->filename = _data_->_tmp25_;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->filename;
			if (_data_->_tmp26_ == NULL) {
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _ ("Error during transfer of the address book ‘%s’ from " "Bluetooth device ‘%s’.");
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = _data_->transfer;
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = org_bluez_obex_transfer_get_name (_data_->_tmp28_);
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = _data_->_tmp29_;
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _data_->_tmp30_;
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->self->priv->_display_name;
				_data_->_tmp33_ = NULL;
				_data_->_tmp33_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp27_, _data_->_tmp31_, _data_->_tmp32_);
				_data_->_tmp34_ = NULL;
				_data_->_tmp34_ = _data_->_tmp33_;
				_g_free0 (_data_->_tmp31_);
				_data_->_inner_error_ = _data_->_tmp34_;
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->transfer_proxy);
				_g_object_unref0 (_data_->_tmp2_);
				block3_data_unref (_data_->_data3_);
				_data_->_data3_ = NULL;
				goto __finally7;
			}
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = _data_->filename;
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = g_file_new_for_path ((const gchar*) _data_->_tmp35_);
			_data_->file = _data_->_tmp36_;
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = _data_->self->priv->_display_name;
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
			_data_->_tmp39_ = NULL;
			_data_->_tmp39_ = _data_->_tmp38_;
			_data_->_tmp40_ = NULL;
			_data_->_tmp40_ = _data_->filename;
			g_debug ("bluez-persona-store.vala:683: vCard’s filename for device ‘%s’ (%s): %" \
"s", _data_->_tmp37_, _data_->_tmp39_, (const gchar*) _data_->_tmp40_);
			_data_->_tmp41_ = NULL;
			_data_->_tmp41_ = _data_->file;
			_data_->_state_ = 3;
			_folks_backends_blue_z_persona_store_update_contacts_from_file (_data_->self, _data_->_tmp41_, _folks_backends_blue_z_persona_store_perform_obex_transfer_ready, _data_);
			return FALSE;
			_state_3:
			_folks_backends_blue_z_persona_store_update_contacts_from_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->transfer_proxy);
				_g_object_unref0 (_data_->_tmp2_);
				block3_data_unref (_data_->_data3_);
				_data_->_data3_ = NULL;
				goto __finally7;
			}
			_g_object_unref0 (_data_->file);
			_g_free0 (_data_->filename);
		} else {
			_data_->_tmp42_ = NULL;
			_data_->_tmp42_ = _data_->_data3_->transfer_status;
			if (g_strcmp0 (_data_->_tmp42_, "error") == 0) {
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = _data_->cancellable;
				if (_data_->_tmp43_ != NULL) {
					_data_->_tmp44_ = NULL;
					_data_->_tmp44_ = _data_->cancellable;
					g_cancellable_set_error_if_cancelled (_data_->_tmp44_, &_data_->_inner_error_);
					if (_data_->_inner_error_ != NULL) {
						_g_object_unref0 (_data_->transfer_proxy);
						_g_object_unref0 (_data_->_tmp2_);
						block3_data_unref (_data_->_data3_);
						_data_->_data3_ = NULL;
						goto __finally7;
					}
				}
				_data_->_tmp45_ = NULL;
				_data_->_tmp45_ = _ ("Error during transfer of the address book ‘%s’ from Bluetooth device ‘" \
"%s’.");
				_data_->_tmp46_ = NULL;
				_data_->_tmp46_ = _data_->transfer;
				_data_->_tmp47_ = NULL;
				_data_->_tmp47_ = org_bluez_obex_transfer_get_name (_data_->_tmp46_);
				_data_->_tmp48_ = NULL;
				_data_->_tmp48_ = _data_->_tmp47_;
				_data_->_tmp49_ = NULL;
				_data_->_tmp49_ = _data_->_tmp48_;
				_data_->_tmp50_ = NULL;
				_data_->_tmp50_ = _data_->self->priv->_display_name;
				_data_->_tmp51_ = NULL;
				_data_->_tmp51_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp45_, _data_->_tmp49_, _data_->_tmp50_);
				_data_->_tmp52_ = NULL;
				_data_->_tmp52_ = _data_->_tmp51_;
				_g_free0 (_data_->_tmp49_);
				_data_->_inner_error_ = _data_->_tmp52_;
				_g_object_unref0 (_data_->transfer_proxy);
				_g_object_unref0 (_data_->_tmp2_);
				block3_data_unref (_data_->_data3_);
				_data_->_data3_ = NULL;
				goto __finally7;
			} else {
				g_assert_not_reached ();
			}
		}
		_g_object_unref0 (_data_->transfer_proxy);
		_g_object_unref0 (_data_->_tmp2_);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
	}
	__finally7:
	{
		_data_->_tmp54_ = NULL;
		_data_->_tmp54_ = _data_->transfer;
		if (_data_->_tmp54_ != NULL) {
			_data_->_tmp55_ = NULL;
			_data_->_tmp55_ = _data_->transfer;
			_data_->_tmp56_ = NULL;
			_data_->_tmp56_ = org_bluez_obex_transfer_get_filename (_data_->_tmp55_);
			_data_->_tmp57_ = NULL;
			_data_->_tmp57_ = _data_->_tmp56_;
			_data_->_tmp58_ = NULL;
			_data_->_tmp58_ = _data_->_tmp57_;
			_data_->_tmp53_ = _data_->_tmp58_ != NULL;
			_g_free0 (_data_->_tmp58_);
		} else {
			_data_->_tmp53_ = FALSE;
		}
		if (_data_->_tmp53_) {
			_data_->_data4_ = g_slice_new0 (Block4Data);
			_data_->_data4_->_ref_count_ = 1;
			_data_->_data4_->_data2_ = block2_data_ref (_data_->_data2_);
			_data_->_tmp59_ = NULL;
			_data_->_tmp59_ = _data_->transfer;
			_data_->_tmp60_ = NULL;
			_data_->_tmp60_ = org_bluez_obex_transfer_get_filename (_data_->_tmp59_);
			_data_->_tmp61_ = NULL;
			_data_->_tmp61_ = _data_->_tmp60_;
			_data_->_tmp62_ = NULL;
			_data_->_tmp62_ = _data_->_tmp61_;
			_data_->_tmp63_ = NULL;
			_data_->_tmp63_ = g_file_new_for_path (_data_->_tmp62_);
			_data_->_tmp64_ = NULL;
			_data_->_tmp64_ = _data_->_tmp63_;
			_g_free0 (_data_->_tmp62_);
			_data_->_data4_->file = _data_->_tmp64_;
			_data_->_tmp65_ = NULL;
			_data_->_tmp65_ = _data_->_data4_->file;
			g_file_delete_async (_data_->_tmp65_, G_PRIORITY_DEFAULT, NULL, _____lambda5__gasync_ready_callback, block4_data_ref (_data_->_data4_));
			block4_data_unref (_data_->_data4_);
			_data_->_data4_ = NULL;
		}
	}
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->transfer);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->transfer);
			block2_data_unref (_data_->_data2_);
			_data_->_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->transfer);
	block2_data_unref (_data_->_data2_);
	_data_->_data2_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _folks_backends_blue_z_persona_store_update_contacts_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreUpdateContactsData, _data_);
}


static void _folks_backends_blue_z_persona_store_update_contacts (FolksBackendsBlueZPersonaStore* self, gboolean download_photos, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreUpdateContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _folks_backends_blue_z_persona_store_update_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _folks_backends_blue_z_persona_store_update_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = download_photos;
	_data_->download_photos = _tmp1_;
	_folks_backends_blue_z_persona_store_update_contacts_co (_data_);
}


static void _folks_backends_blue_z_persona_store_update_contacts_finish (FolksBackendsBlueZPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Update contacts from this persona store.
   *
   * Update contacts from this persona store by initiating a new OBEX
   * transfer, unless one is already in progress. If a transfer is already in
   * progress, leave it running and return immediately.
   *
   * If this throws an error, it guarantees to leave the store’s internal state
   * unchanged, apart from scheduling a new update operation to happen in the
   * future. This will always happen, regardless of success or failure.
   *
   * @param download_photos whether to download photos
   * @throws IOError if the operation was cancelled
   * @throws PersonaStoreError if the contacts couldn’t be downloaded from the
   * device
   *
   * @since 0.9.6
   */
static void _folks_backends_blue_z_persona_store_update_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_folks_backends_blue_z_persona_store_update_contacts_co (_data_);
}


static GVariant* _variant_new2 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gboolean _folks_backends_blue_z_persona_store_update_contacts_co (FolksBackendsBlueZPersonaStoreUpdateContactsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->session_path = NULL;
	_data_->obex_pbap = NULL;
	_data_->success = TRUE;
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->self->priv->_update_contacts_cancellable;
		if (_data_->_tmp0_ != NULL) {
			g_debug ("bluez-persona-store.vala:763: Not updating contacts due to ongoing upd" \
"ate operation.");
			{
				_data_->_tmp1_ = NULL;
				_data_->_tmp1_ = _data_->session_path;
				if (_data_->_tmp1_ != NULL) {
					_data_->_tmp2_ = NULL;
					_data_->_tmp2_ = _data_->session_path;
					_folks_backends_blue_z_persona_store_remove_obex_session (_data_->self, _data_->_tmp2_, NULL, NULL);
				}
				_g_object_unref0 (_data_->obex_pbap);
				_data_->obex_pbap = NULL;
				_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
				_data_->self->priv->_update_contacts_cancellable = NULL;
				_data_->_tmp3_ = FALSE;
				_data_->_tmp3_ = _data_->success;
				if (_data_->_tmp3_ == TRUE) {
					_data_->self->priv->_update_contacts_failures = (guint) 0;
				} else {
					_data_->_tmp4_ = 0U;
					_data_->_tmp4_ = _data_->self->priv->_update_contacts_failures;
					_data_->self->priv->_update_contacts_failures = _data_->_tmp4_ + 1;
				}
				_data_->_tmp6_ = FALSE;
				_data_->_tmp6_ = _data_->success;
				if (_data_->_tmp6_ == TRUE) {
					_data_->_tmp7_ = FALSE;
					_data_->_tmp7_ = _data_->self->priv->_photos_up_to_date;
					_data_->_tmp5_ = _data_->_tmp7_ == FALSE;
				} else {
					_data_->_tmp5_ = FALSE;
				}
				_data_->new_download_photos = _data_->_tmp5_;
				_data_->_tmp8_ = FALSE;
				_data_->_tmp8_ = _data_->new_download_photos;
				_folks_backends_blue_z_persona_store_schedule_update_contacts (_data_->self, _data_->_tmp8_);
				_data_->_tmp9_ = NULL;
				_data_->_tmp9_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->_tmp9_;
				folks_internal_profiling_end ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp10_, NULL);
			}
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		folks_internal_profiling_start ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp12_, NULL);
		g_debug ("bluez-persona-store.vala:770: Updating contacts.");
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = g_cancellable_new ();
		_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
		_data_->self->priv->_update_contacts_cancellable = _data_->_tmp13_;
		{
			_data_->_tmp15_ = NULL;
			_data_->_state_ = 1;
			_folks_backends_blue_z_persona_store_new_obex_session (_data_->self, _folks_backends_blue_z_persona_store_update_contacts_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _folks_backends_blue_z_persona_store_new_obex_session_finish (_data_->self, _data_->_res_, &_data_->_tmp15_, &_data_->_inner_error_);
			_g_object_unref0 (_data_->obex_pbap);
			_data_->obex_pbap = _data_->_tmp15_;
			_data_->_tmp14_ = _data_->_tmp16_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->_tmp14_;
			_data_->_tmp14_ = NULL;
			_g_free0 (_data_->session_path);
			_data_->session_path = _data_->_tmp17_;
			_g_free0 (_data_->_tmp14_);
		}
		goto __finally10;
		__catch10_g_error:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->e1;
			if (g_error_matches (_data_->_tmp19_, G_IO_ERROR, G_IO_ERROR_DBUS_ERROR)) {
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = _data_->e1;
				_data_->_tmp21_ = NULL;
				_data_->_tmp21_ = _data_->_tmp20_->message;
				_data_->_tmp22_ = FALSE;
				_data_->_tmp22_ = g_str_has_suffix (_data_->_tmp21_, "OBEX Connect failed with 0x43");
				_data_->_tmp18_ = _data_->_tmp22_;
			} else {
				_data_->_tmp18_ = FALSE;
			}
			if (_data_->_tmp18_) {
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = _ ("Permission to access the address book on Bluetooth device ‘%s’ was den" \
"ied by the user.");
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _data_->self->priv->_device;
				_data_->_tmp25_ = NULL;
				_data_->_tmp25_ = org_bluez_device_get_alias (_data_->_tmp24_);
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->_tmp25_;
				_data_->_tmp27_ = NULL;
				_data_->_tmp27_ = _data_->_tmp26_;
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED, _data_->_tmp23_, _data_->_tmp27_);
				_data_->_tmp29_ = NULL;
				_data_->_tmp29_ = _data_->_tmp28_;
				_g_free0 (_data_->_tmp27_);
				_data_->_inner_error_ = _data_->_tmp29_;
				_g_error_free0 (_data_->e1);
				goto __finally10;
			}
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _ ("An OBEX address book transfer from device ‘%s’ could not be started: %" \
"s");
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = _data_->self->priv->_device;
			_data_->_tmp32_ = NULL;
			_data_->_tmp32_ = org_bluez_device_get_alias (_data_->_tmp31_);
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = _data_->_tmp32_;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = _data_->_tmp33_;
			_data_->_tmp35_ = NULL;
			_data_->_tmp35_ = _data_->e1;
			_data_->_tmp36_ = NULL;
			_data_->_tmp36_ = _data_->_tmp35_->message;
			_data_->_tmp37_ = NULL;
			_data_->_tmp37_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp30_, _data_->_tmp34_, _data_->_tmp36_);
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = _data_->_tmp37_;
			_g_free0 (_data_->_tmp34_);
			_data_->_inner_error_ = _data_->_tmp38_;
			_g_error_free0 (_data_->e1);
			goto __finally10;
		}
		__finally10:
		if (_data_->_inner_error_ != NULL) {
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch9_g_io_error;
			}
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch9_folks_persona_store_error;
			}
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			{
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = _data_->session_path;
				if (_data_->_tmp39_ != NULL) {
					_data_->_tmp40_ = NULL;
					_data_->_tmp40_ = _data_->session_path;
					_folks_backends_blue_z_persona_store_remove_obex_session (_data_->self, _data_->_tmp40_, NULL, NULL);
				}
				_g_object_unref0 (_data_->obex_pbap);
				_data_->obex_pbap = NULL;
				_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
				_data_->self->priv->_update_contacts_cancellable = NULL;
				_data_->_tmp41_ = FALSE;
				_data_->_tmp41_ = _data_->success;
				if (_data_->_tmp41_ == TRUE) {
					_data_->self->priv->_update_contacts_failures = (guint) 0;
				} else {
					_data_->_tmp42_ = 0U;
					_data_->_tmp42_ = _data_->self->priv->_update_contacts_failures;
					_data_->self->priv->_update_contacts_failures = _data_->_tmp42_ + 1;
				}
				_data_->_tmp43_ = FALSE;
				_data_->_tmp43_ = _data_->success;
				if (_data_->_tmp43_ == TRUE) {
					_data_->_tmp44_ = FALSE;
					_data_->_tmp44_ = _data_->self->priv->_photos_up_to_date;
					_data_->_vala1__tmp5_ = _data_->_tmp44_ == FALSE;
				} else {
					_data_->_vala1__tmp5_ = FALSE;
				}
				_data_->_vala1_new_download_photos = _data_->_vala1__tmp5_;
				_data_->_tmp45_ = FALSE;
				_data_->_tmp45_ = _data_->_vala1_new_download_photos;
				_folks_backends_blue_z_persona_store_schedule_update_contacts (_data_->self, _data_->_tmp45_);
				_data_->_tmp46_ = NULL;
				_data_->_tmp46_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
				_data_->_tmp47_ = NULL;
				_data_->_tmp47_ = _data_->_tmp46_;
				folks_internal_profiling_end ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp47_, NULL);
			}
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		{
			_data_->_tmp48_ = NULL;
			_data_->_tmp48_ = _data_->obex_pbap;
			org_bluez_obex_phonebook_access_select (_data_->_tmp48_, "int", "PB", &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
			_data_->_tmp49_ = NULL;
			_data_->_tmp49_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
			_data_->phonebook_filter = _data_->_tmp49_;
			_data_->_tmp50_ = NULL;
			_data_->_tmp50_ = _data_->phonebook_filter;
			_data_->_tmp51_ = NULL;
			_data_->_tmp51_ = g_strdup ("Format");
			_data_->_tmp52_ = NULL;
			_data_->_tmp52_ = _variant_new2 ("Vcard30");
			g_hash_table_insert (_data_->_tmp50_, _data_->_tmp51_, _data_->_tmp52_);
			_data_->_tmp53_ = FALSE;
			_data_->_tmp53_ = _data_->download_photos;
			if (_data_->_tmp53_ == TRUE) {
				_data_->_tmp54_ = NULL;
				_data_->_tmp54_ = _data_->phonebook_filter;
				_data_->_tmp55_ = NULL;
				_data_->_tmp55_ = g_strdup ("Fields");
				_data_->_tmp56_ = NULL;
				_data_->_tmp56_ = g_strdup ("UID");
				_data_->_tmp57_ = NULL;
				_data_->_tmp57_ = g_strdup ("N");
				_data_->_tmp58_ = NULL;
				_data_->_tmp58_ = g_strdup ("FN");
				_data_->_tmp59_ = NULL;
				_data_->_tmp59_ = g_strdup ("NICKNAME");
				_data_->_tmp60_ = NULL;
				_data_->_tmp60_ = g_strdup ("TEL");
				_data_->_tmp61_ = NULL;
				_data_->_tmp61_ = g_strdup ("URL");
				_data_->_tmp62_ = NULL;
				_data_->_tmp62_ = g_strdup ("EMAIL");
				_data_->_tmp63_ = NULL;
				_data_->_tmp63_ = g_strdup ("PHOTO");
				_data_->_tmp64_ = NULL;
				_data_->_tmp64_ = g_new0 (gchar*, 8 + 1);
				_data_->_tmp64_[0] = _data_->_tmp56_;
				_data_->_tmp64_[1] = _data_->_tmp57_;
				_data_->_tmp64_[2] = _data_->_tmp58_;
				_data_->_tmp64_[3] = _data_->_tmp59_;
				_data_->_tmp64_[4] = _data_->_tmp60_;
				_data_->_tmp64_[5] = _data_->_tmp61_;
				_data_->_tmp64_[6] = _data_->_tmp62_;
				_data_->_tmp64_[7] = _data_->_tmp63_;
				_data_->_tmp65_ = NULL;
				_data_->_tmp65__length1 = 0;
				_data_->_tmp65_ = _data_->_tmp64_;
				_data_->_tmp65__length1 = 8;
				_data_->_tmp66_ = NULL;
				_data_->_tmp66_ = g_variant_new_strv (_data_->_tmp65_, 8);
				g_variant_ref_sink (_data_->_tmp66_);
				g_hash_table_insert (_data_->_tmp54_, _data_->_tmp55_, _data_->_tmp66_);
				_data_->_tmp65_ = (_vala_array_free (_data_->_tmp65_, _data_->_tmp65__length1, (GDestroyNotify) g_free), NULL);
			} else {
				_data_->_tmp67_ = NULL;
				_data_->_tmp67_ = _data_->phonebook_filter;
				_data_->_tmp68_ = NULL;
				_data_->_tmp68_ = g_strdup ("Fields");
				_data_->_tmp69_ = NULL;
				_data_->_tmp69_ = g_strdup ("UID");
				_data_->_tmp70_ = NULL;
				_data_->_tmp70_ = g_strdup ("N");
				_data_->_tmp71_ = NULL;
				_data_->_tmp71_ = g_strdup ("FN");
				_data_->_tmp72_ = NULL;
				_data_->_tmp72_ = g_strdup ("NICKNAME");
				_data_->_tmp73_ = NULL;
				_data_->_tmp73_ = g_strdup ("TEL");
				_data_->_tmp74_ = NULL;
				_data_->_tmp74_ = g_strdup ("URL");
				_data_->_tmp75_ = NULL;
				_data_->_tmp75_ = g_strdup ("EMAIL");
				_data_->_tmp76_ = NULL;
				_data_->_tmp76_ = g_new0 (gchar*, 7 + 1);
				_data_->_tmp76_[0] = _data_->_tmp69_;
				_data_->_tmp76_[1] = _data_->_tmp70_;
				_data_->_tmp76_[2] = _data_->_tmp71_;
				_data_->_tmp76_[3] = _data_->_tmp72_;
				_data_->_tmp76_[4] = _data_->_tmp73_;
				_data_->_tmp76_[5] = _data_->_tmp74_;
				_data_->_tmp76_[6] = _data_->_tmp75_;
				_data_->_tmp77_ = NULL;
				_data_->_tmp77__length1 = 0;
				_data_->_tmp77_ = _data_->_tmp76_;
				_data_->_tmp77__length1 = 7;
				_data_->_tmp78_ = NULL;
				_data_->_tmp78_ = g_variant_new_strv (_data_->_tmp77_, 7);
				g_variant_ref_sink (_data_->_tmp78_);
				g_hash_table_insert (_data_->_tmp67_, _data_->_tmp68_, _data_->_tmp78_);
				_data_->_tmp77_ = (_vala_array_free (_data_->_tmp77_, _data_->_tmp77__length1, (GDestroyNotify) g_free), NULL);
			}
			_data_->_tmp79_ = NULL;
			_data_->_tmp79_ = _data_->obex_pbap;
			_data_->_tmp80_ = NULL;
			_data_->_tmp80_ = _data_->phonebook_filter;
			_data_->_tmp81_ = NULL;
			_data_->_tmp82_ = NULL;
			org_bluez_obex_phonebook_access_pull_all (_data_->_tmp79_, "", _data_->_tmp80_, &_data_->_tmp81_, &_data_->_tmp82_, &_data_->_inner_error_);
			_g_free0 (_data_->path);
			_data_->path = _data_->_tmp81_;
			_g_hash_table_unref0 (_data_->props);
			_data_->props = _data_->_tmp82_;
			if (_data_->_inner_error_ != NULL) {
				_g_hash_table_unref0 (_data_->phonebook_filter);
				goto __catch11_g_error;
			}
			_g_hash_table_unref0 (_data_->phonebook_filter);
		}
		goto __finally11;
		__catch11_g_error:
		{
			_data_->e2 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp83_ = NULL;
			_data_->_tmp83_ = _ ("The OBEX address book transfer from device ‘%s’ failed: %s");
			_data_->_tmp84_ = NULL;
			_data_->_tmp84_ = _data_->self->priv->_device;
			_data_->_tmp85_ = NULL;
			_data_->_tmp85_ = org_bluez_device_get_alias (_data_->_tmp84_);
			_data_->_tmp86_ = NULL;
			_data_->_tmp86_ = _data_->_tmp85_;
			_data_->_tmp87_ = NULL;
			_data_->_tmp87_ = _data_->_tmp86_;
			_data_->_tmp88_ = NULL;
			_data_->_tmp88_ = _data_->e2;
			_data_->_tmp89_ = NULL;
			_data_->_tmp89_ = _data_->_tmp88_->message;
			_data_->_tmp90_ = NULL;
			_data_->_tmp90_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp83_, _data_->_tmp87_, _data_->_tmp89_);
			_data_->_tmp91_ = NULL;
			_data_->_tmp91_ = _data_->_tmp90_;
			_g_free0 (_data_->_tmp87_);
			_data_->_inner_error_ = _data_->_tmp91_;
			_g_error_free0 (_data_->e2);
			goto __finally11;
		}
		__finally11:
		if (_data_->_inner_error_ != NULL) {
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch9_g_io_error;
			}
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch9_folks_persona_store_error;
			}
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			{
				_data_->_tmp92_ = NULL;
				_data_->_tmp92_ = _data_->session_path;
				if (_data_->_tmp92_ != NULL) {
					_data_->_tmp93_ = NULL;
					_data_->_tmp93_ = _data_->session_path;
					_folks_backends_blue_z_persona_store_remove_obex_session (_data_->self, _data_->_tmp93_, NULL, NULL);
				}
				_g_object_unref0 (_data_->obex_pbap);
				_data_->obex_pbap = NULL;
				_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
				_data_->self->priv->_update_contacts_cancellable = NULL;
				_data_->_tmp94_ = FALSE;
				_data_->_tmp94_ = _data_->success;
				if (_data_->_tmp94_ == TRUE) {
					_data_->self->priv->_update_contacts_failures = (guint) 0;
				} else {
					_data_->_tmp95_ = 0U;
					_data_->_tmp95_ = _data_->self->priv->_update_contacts_failures;
					_data_->self->priv->_update_contacts_failures = _data_->_tmp95_ + 1;
				}
				_data_->_tmp96_ = FALSE;
				_data_->_tmp96_ = _data_->success;
				if (_data_->_tmp96_ == TRUE) {
					_data_->_tmp97_ = FALSE;
					_data_->_tmp97_ = _data_->self->priv->_photos_up_to_date;
					_data_->_vala2__tmp5_ = _data_->_tmp97_ == FALSE;
				} else {
					_data_->_vala2__tmp5_ = FALSE;
				}
				_data_->_vala2_new_download_photos = _data_->_vala2__tmp5_;
				_data_->_tmp98_ = FALSE;
				_data_->_tmp98_ = _data_->_vala2_new_download_photos;
				_folks_backends_blue_z_persona_store_schedule_update_contacts (_data_->self, _data_->_tmp98_);
				_data_->_tmp99_ = NULL;
				_data_->_tmp99_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
				_data_->_tmp100_ = NULL;
				_data_->_tmp100_ = _data_->_tmp99_;
				folks_internal_profiling_end ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp100_, NULL);
			}
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		{
			_data_->_tmp101_ = NULL;
			_data_->_tmp101_ = _data_->path;
			_data_->_tmp102_ = NULL;
			_data_->_tmp102_ = _data_->self->priv->_update_contacts_cancellable;
			_data_->_state_ = 2;
			_folks_backends_blue_z_persona_store_perform_obex_transfer (_data_->self, _data_->_tmp101_, _data_->_tmp102_, _folks_backends_blue_z_persona_store_update_contacts_ready, _data_);
			return FALSE;
			_state_2:
			_folks_backends_blue_z_persona_store_perform_obex_transfer_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == G_IO_ERROR) {
					goto __catch12_g_io_error;
				}
				goto __finally12;
			}
		}
		goto __finally12;
		__catch12_g_io_error:
		{
			_data_->e3 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp103_ = NULL;
			_data_->_tmp103_ = _data_->e3;
			if (g_error_matches (_data_->_tmp103_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
				_data_->_tmp104_ = NULL;
				_data_->_tmp104_ = _data_->e3;
				_data_->_tmp105_ = NULL;
				_data_->_tmp105_ = _g_error_copy0 (_data_->_tmp104_);
				_data_->_inner_error_ = _data_->_tmp105_;
				_g_error_free0 (_data_->e3);
				goto __finally12;
			}
			_data_->_tmp106_ = NULL;
			_data_->_tmp106_ = _ ("Error during transfer of the address book from Bluetooth device ‘%s’: " \
"%s");
			_data_->_tmp107_ = NULL;
			_data_->_tmp107_ = _data_->self->priv->_display_name;
			_data_->_tmp108_ = NULL;
			_data_->_tmp108_ = _data_->e3;
			_data_->_tmp109_ = NULL;
			_data_->_tmp109_ = _data_->_tmp108_->message;
			_data_->_tmp110_ = NULL;
			_data_->_tmp110_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp106_, _data_->_tmp107_, _data_->_tmp109_);
			_data_->_inner_error_ = _data_->_tmp110_;
			_g_error_free0 (_data_->e3);
			goto __finally12;
		}
		__finally12:
		if (_data_->_inner_error_ != NULL) {
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			if (_data_->_inner_error_->domain == G_IO_ERROR) {
				goto __catch9_g_io_error;
			}
			if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
				goto __catch9_folks_persona_store_error;
			}
			_g_hash_table_unref0 (_data_->props);
			_g_free0 (_data_->path);
			{
				_data_->_tmp111_ = NULL;
				_data_->_tmp111_ = _data_->session_path;
				if (_data_->_tmp111_ != NULL) {
					_data_->_tmp112_ = NULL;
					_data_->_tmp112_ = _data_->session_path;
					_folks_backends_blue_z_persona_store_remove_obex_session (_data_->self, _data_->_tmp112_, NULL, NULL);
				}
				_g_object_unref0 (_data_->obex_pbap);
				_data_->obex_pbap = NULL;
				_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
				_data_->self->priv->_update_contacts_cancellable = NULL;
				_data_->_tmp113_ = FALSE;
				_data_->_tmp113_ = _data_->success;
				if (_data_->_tmp113_ == TRUE) {
					_data_->self->priv->_update_contacts_failures = (guint) 0;
				} else {
					_data_->_tmp114_ = 0U;
					_data_->_tmp114_ = _data_->self->priv->_update_contacts_failures;
					_data_->self->priv->_update_contacts_failures = _data_->_tmp114_ + 1;
				}
				_data_->_tmp115_ = FALSE;
				_data_->_tmp115_ = _data_->success;
				if (_data_->_tmp115_ == TRUE) {
					_data_->_tmp116_ = FALSE;
					_data_->_tmp116_ = _data_->self->priv->_photos_up_to_date;
					_data_->_vala3__tmp5_ = _data_->_tmp116_ == FALSE;
				} else {
					_data_->_vala3__tmp5_ = FALSE;
				}
				_data_->_vala3_new_download_photos = _data_->_vala3__tmp5_;
				_data_->_tmp117_ = FALSE;
				_data_->_tmp117_ = _data_->_vala3_new_download_photos;
				_folks_backends_blue_z_persona_store_schedule_update_contacts (_data_->self, _data_->_tmp117_);
				_data_->_tmp118_ = NULL;
				_data_->_tmp118_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
				_data_->_tmp119_ = NULL;
				_data_->_tmp119_ = _data_->_tmp118_;
				folks_internal_profiling_end ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp119_, NULL);
			}
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_hash_table_unref0 (_data_->props);
		_g_free0 (_data_->path);
	}
	goto __finally9;
	__catch9_g_io_error:
	{
		_data_->e4 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->success = FALSE;
		_data_->_tmp120_ = NULL;
		_data_->_tmp120_ = _data_->e4;
		_data_->_tmp121_ = NULL;
		_data_->_tmp121_ = _g_error_copy0 (_data_->_tmp120_);
		_data_->_inner_error_ = _data_->_tmp121_;
		_g_error_free0 (_data_->e4);
		goto __finally9;
	}
	goto __finally9;
	__catch9_folks_persona_store_error:
	{
		_data_->e5 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->success = FALSE;
		_data_->_tmp122_ = NULL;
		_data_->_tmp122_ = _data_->e5;
		_data_->_tmp123_ = NULL;
		_data_->_tmp123_ = _g_error_copy0 (_data_->_tmp122_);
		_data_->_inner_error_ = _data_->_tmp123_;
		_g_error_free0 (_data_->e5);
		goto __finally9;
	}
	__finally9:
	{
		_data_->_tmp124_ = NULL;
		_data_->_tmp124_ = _data_->session_path;
		if (_data_->_tmp124_ != NULL) {
			_data_->_tmp125_ = NULL;
			_data_->_tmp125_ = _data_->session_path;
			_folks_backends_blue_z_persona_store_remove_obex_session (_data_->self, _data_->_tmp125_, NULL, NULL);
		}
		_g_object_unref0 (_data_->obex_pbap);
		_data_->obex_pbap = NULL;
		_g_object_unref0 (_data_->self->priv->_update_contacts_cancellable);
		_data_->self->priv->_update_contacts_cancellable = NULL;
		_data_->_tmp126_ = FALSE;
		_data_->_tmp126_ = _data_->success;
		if (_data_->_tmp126_ == TRUE) {
			_data_->self->priv->_update_contacts_failures = (guint) 0;
		} else {
			_data_->_tmp127_ = 0U;
			_data_->_tmp127_ = _data_->self->priv->_update_contacts_failures;
			_data_->self->priv->_update_contacts_failures = _data_->_tmp127_ + 1;
		}
		_data_->_tmp128_ = FALSE;
		_data_->_tmp128_ = _data_->success;
		if (_data_->_tmp128_ == TRUE) {
			_data_->_tmp129_ = FALSE;
			_data_->_tmp129_ = _data_->self->priv->_photos_up_to_date;
			_data_->_vala4__tmp5_ = _data_->_tmp129_ == FALSE;
		} else {
			_data_->_vala4__tmp5_ = FALSE;
		}
		_data_->_vala4_new_download_photos = _data_->_vala4__tmp5_;
		_data_->_tmp130_ = FALSE;
		_data_->_tmp130_ = _data_->_vala4_new_download_photos;
		_folks_backends_blue_z_persona_store_schedule_update_contacts (_data_->self, _data_->_tmp130_);
		_data_->_tmp131_ = NULL;
		_data_->_tmp131_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp132_ = NULL;
		_data_->_tmp132_ = _data_->_tmp131_;
		folks_internal_profiling_end ("updating BlueZ.PersonaStore (ID: %s) " "contacts", _data_->_tmp132_, NULL);
	}
	if (_data_->_inner_error_ != NULL) {
		if ((_data_->_inner_error_->domain == G_IO_ERROR) || (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->obex_pbap);
			_g_free0 (_data_->session_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->obex_pbap);
	_g_free0 (_data_->session_path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Schedule the next call to {@link _update_contacts}.
   *
   * This calculates a suitable timeout value and schedules the next timeout
   * for updating the contacts.
   *
   * The update scheme is as follows:
   *  1. Download the contacts (without photos) as soon as connected to the
   *     phone.
   *  2. Schedule a second download attempt for a few seconds after the first
   *     one completes. If the first one completes successfully, this second
   *     download will include photos; otherwise, it won’t.
   *  3. Schedule subsequent download attempts for exponentially increasing
   *     timeouts, up to a maximum timeout (at which point the timeouts enter a
   *     linear region and repeat indefinitely). Subsequent download attempts
   *     will include photos only if they have not been successfully downloaded
   *     already, or if the previous download attempt caused other property
   *     changes in a persona (indicating that the address book has been edited
   *     on the phone).
   *  4. If updates fail a certain number of consecutive times, give up
   *     completely and leave the persona store in a prepared but empty
   *     quiescent state. Update attempts will only restart if the phone is then
   *     disconnected and reconnected.
   *
   * The rationale for this design is to:
   *  A. Allow for the user accidentally denying the first connection request on
   *     the phone, or not noticing it and it timing out. Attempting a second
   *     download after a timeout gives them an opportunity to fix the problem.
   *  B. If the user explicitly denies the connection request on the phone, the
   *     phone should remember this and automatically deny all future connection
   *     attempts until the consecutive failure limit is reached. The user
   *     shouldn’t be pestered to accept again.
   *  C. Watch for changes in the user’s address book and update the persona
   *     store accordingly. Unfortunately this has to be done by polling, since
   *     neither PBAP not OBEX itself support push notifications.
   *
   * @param download_photos whether to download photos
   *
   * @since 0.9.7
   */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		FolksBackendsBlueZPersonaStore* self;
		self = _data5_->self;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean uint64_try_parse (const gchar* str, guint64* _result_) {
	guint64 _vala_result = 0ULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	guint64 _tmp2_ = 0ULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoull (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static void __lambda7_ (FolksBackendsBlueZPersonaStore* self, GObject* o, GAsyncResult* r) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (r != NULL);
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = r;
		_folks_backends_blue_z_persona_store_update_contacts_finish (self, _tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e4 = NULL;
		GError* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		e4 = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e4;
		if (g_error_matches (_tmp1_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_g_error_free0 (e4);
			return;
		}
		_tmp2_ = e4;
		if (g_error_matches (_tmp2_, FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE)) {
			GError* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			_tmp3_ = e4;
			_tmp4_ = _tmp3_->message;
			g_debug ("Not updating persona store from BlueZ due to " "store being offline: %s", _tmp4_);
		} else {
			GError* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			_tmp5_ = e4;
			_tmp6_ = _tmp5_->message;
			g_warning ("bluez-persona-store.vala:998: Error updating persona store from BlueZ:" \
" %s", _tmp6_);
		}
		_g_error_free0 (e4);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda7_ ((FolksBackendsBlueZPersonaStore*) self, source_object, res);
	g_object_unref (self);
}


static gboolean __lambda6_ (Block5Data* _data5_) {
	FolksBackendsBlueZPersonaStore* self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = _data5_->self;
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	g_debug ("bluez-persona-store.vala:973: Scheduled update firing for BlueZ store " \
"‘%s’.", _tmp1_);
	self->priv->_update_contacts_id = (guint) 0;
	_tmp2_ = _data5_->download_photos;
	_folks_backends_blue_z_persona_store_update_contacts (self, _tmp2_, ___lambda7__gasync_ready_callback, g_object_ref (self));
	result = FALSE;
	return result;
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
	return result;
}


static void _folks_backends_blue_z_persona_store_schedule_update_contacts (FolksBackendsBlueZPersonaStore* self, gboolean download_photos) {
	Block5Data* _data5_;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint timeout = 0U;
	guint _tmp3_ = 0U;
	gdouble _tmp4_ = 0.0;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	gchar* divisor_str = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GSourceFunc fn = NULL;
	void* fn_target = NULL;
	GDestroyNotify fn_target_destroy_notify = NULL;
	guint _tmp16_ = 0U;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = download_photos;
	_data5_->download_photos = _tmp0_;
	_tmp1_ = self->priv->_update_contacts_id;
	if (_tmp1_ != ((guint) 0)) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp2_ = self->priv->_update_contacts_failures;
	if (_tmp2_ >= FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__MAX_CONSECUTIVE_FAILURES) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp3_ = self->priv->_update_contacts_n;
	_tmp4_ = pow ((gdouble) FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_BASE, (gdouble) _tmp3_);
	_tmp5_ = MIN (FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_MIN + ((guint) _tmp4_), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE__TIMEOUT_MAX);
	timeout = _tmp5_;
	_tmp6_ = self->priv->_update_contacts_n;
	self->priv->_update_contacts_n = _tmp6_ + 1;
	_tmp7_ = timeout;
	timeout = _tmp7_ * 1000;
	_tmp8_ = g_getenv ("FOLKS_BLUEZ_TIMEOUT_DIVISOR");
	_tmp9_ = g_strdup (_tmp8_);
	divisor_str = _tmp9_;
	_tmp10_ = divisor_str;
	if (_tmp10_ != NULL) {
		guint64 divisor = 0ULL;
		const gchar* _tmp11_ = NULL;
		guint64 _tmp12_ = 0ULL;
		gboolean _tmp13_ = FALSE;
		_tmp11_ = divisor_str;
		_tmp13_ = uint64_try_parse (_tmp11_, &_tmp12_);
		divisor = _tmp12_;
		if (_tmp13_ == TRUE) {
			guint _tmp14_ = 0U;
			guint64 _tmp15_ = 0ULL;
			_tmp14_ = timeout;
			_tmp15_ = divisor;
			timeout = _tmp14_ / ((guint) _tmp15_);
		}
	}
	fn = ___lambda6__gsource_func;
	fn_target = block5_data_ref (_data5_);
	fn_target_destroy_notify = block5_data_unref;
	_tmp16_ = timeout;
	if ((_tmp16_ % 1000) == ((guint) 0)) {
		guint _tmp17_ = 0U;
		GSourceFunc _tmp18_ = NULL;
		void* _tmp18__target = NULL;
		GDestroyNotify _tmp18__target_destroy_notify = NULL;
		guint _tmp19_ = 0U;
		_tmp17_ = timeout;
		_tmp18_ = fn;
		_tmp18__target = fn_target;
		_tmp18__target_destroy_notify = fn_target_destroy_notify;
		fn_target_destroy_notify = NULL;
		_tmp19_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _tmp17_ / 1000, _tmp18_, _tmp18__target, _tmp18__target_destroy_notify);
		self->priv->_update_contacts_id = _tmp19_;
	} else {
		guint _tmp20_ = 0U;
		GSourceFunc _tmp21_ = NULL;
		void* _tmp21__target = NULL;
		GDestroyNotify _tmp21__target_destroy_notify = NULL;
		guint _tmp22_ = 0U;
		_tmp20_ = timeout;
		_tmp21_ = fn;
		_tmp21__target = fn_target;
		_tmp21__target_destroy_notify = fn_target_destroy_notify;
		fn_target_destroy_notify = NULL;
		_tmp22_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp20_, _tmp21_, _tmp21__target, _tmp21__target_destroy_notify);
		self->priv->_update_contacts_id = _tmp22_;
	}
	(fn_target_destroy_notify == NULL) ? NULL : (fn_target_destroy_notify (fn_target), NULL);
	fn = NULL;
	fn_target = NULL;
	fn_target_destroy_notify = NULL;
	_g_free0 (divisor_str);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


/**
   * Cancel ongoing and scheduled updates from the device.
   *
   * This doesn't remove the store, but does cancel all ongoing updates and
   * future scheduled updates, in preparation for removing the store. This is
   * necessary to avoid the store maintaining a reference to itself (through the
   * closure for the next scheduled update) and thus never being finalised.
   *
   * @since 0.9.7
   */
void folks_backends_blue_z_persona_store_cancel_updates (FolksBackendsBlueZPersonaStore* self) {
	GCancellable* _tmp0_ = NULL;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_update_contacts_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_ = NULL;
		_tmp1_ = self->priv->_update_contacts_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = self->priv->_update_contacts_id;
	if (_tmp2_ != ((guint) 0)) {
		guint _tmp3_ = 0U;
		_tmp3_ = self->priv->_update_contacts_id;
		g_source_remove (_tmp3_);
		self->priv->_update_contacts_id = (guint) 0;
	}
}


static void folks_backends_blue_z_persona_store_real_prepare_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStorePrepareData, _data_);
}


static void folks_backends_blue_z_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStore * self;
	FolksBackendsBlueZPersonaStorePrepareData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_blue_z_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_blue_z_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_blue_z_persona_store_real_prepare_co (_data_);
}


static void folks_backends_blue_z_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsBlueZPersonaStorePrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   *
   * @since 0.9.6
   */
static void folks_backends_blue_z_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_blue_z_persona_store_real_prepare_co (_data_);
}


static gboolean folks_backends_blue_z_persona_store_real_prepare_co (FolksBackendsBlueZPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing BlueZ.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = FALSE;
		_data_->_tmp4_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	if (_data_->_tmp2_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		{
			_data_->_state_ = 1;
			_folks_backends_blue_z_persona_store_update_contacts (_data_->self, FALSE, folks_backends_blue_z_persona_store_prepare_ready, _data_);
			return FALSE;
			_state_1:
			_folks_backends_blue_z_persona_store_update_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == G_IO_ERROR) {
					goto __catch15_g_io_error;
				}
				goto __finally15;
			}
		}
		goto __finally15;
		__catch15_g_io_error:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _ ("Bluetooth device ‘%s’ disappeared during address book transfer.");
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->self->priv->_device;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = org_bluez_device_get_alias (_data_->_tmp6_);
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp5_, _data_->_tmp9_);
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _data_->_tmp10_;
			_g_free0 (_data_->_tmp9_);
			_data_->_inner_error_ = _data_->_tmp11_;
			_g_error_free0 (_data_->e1);
			goto __finally15;
		}
		__finally15:
		{
			_data_->self->priv->_is_prepared = TRUE;
			g_object_notify ((GObject*) _data_->self, "is-prepared");
			_data_->self->priv->_is_quiescent = TRUE;
			g_object_notify ((GObject*) _data_->self, "is-quiescent");
		}
		if (_data_->_inner_error_ != NULL) {
			goto __finally14;
		}
	}
	__finally14:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	folks_internal_profiling_end ("preparing BlueZ.PersonaStore (ID: %s)", _data_->_tmp13_, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_blue_z_persona_store_real_remove_persona_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreRemovePersonaData, _data_);
}


static void folks_backends_blue_z_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStore * self;
	FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	FolksPersona* _tmp1_ = NULL;
	FolksPersona* _tmp2_ = NULL;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_blue_z_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_blue_z_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	folks_backends_blue_z_persona_store_real_remove_persona_co (_data_);
}


static void folks_backends_blue_z_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   *
   * @param persona the {@link Persona} to remove
   * @throws Folks.PersonaStoreError.READ_ONLY every time since the
   * BlueZ backend is read-only.
   *
   * @since 0.9.6
   */
static gboolean folks_backends_blue_z_persona_store_real_remove_persona_co (FolksBackendsBlueZPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be removed from this store.");
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_blue_z_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void folks_backends_blue_z_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsBlueZPersonaStore * self;
	FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_;
	FolksBackendsBlueZPersonaStore* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_blue_z_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_blue_z_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp2_;
	folks_backends_blue_z_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* folks_backends_blue_z_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @param details a map of keys to values giving the persona’s initial details
   * @throws Folks.PersonaStoreError.READ_ONLY every time since the
   * BlueZ backend is read-only.
   *
   * @since 0.9.6
   */
static gboolean folks_backends_blue_z_persona_store_real_add_persona_from_details_co (FolksBackendsBlueZPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be added to this store.");
	_data_->_inner_error_ = _data_->_tmp0_;
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* folks_backends_blue_z_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool folks_backends_blue_z_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool folks_backends_blue_z_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool folks_backends_blue_z_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool folks_backends_blue_z_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsBlueZPersonaStore* self;
	self = (FolksBackendsBlueZPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static gboolean folks_backends_blue_z_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	FolksBackendsBlueZPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_blue_z_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	FolksBackendsBlueZPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static gchar** folks_backends_blue_z_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	FolksBackendsBlueZPersonaStore* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_tmp0_ = folks_backends_blue_z_persona_store__always_writeable_properties;
	_tmp0__length1 = folks_backends_blue_z_persona_store__always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GeeMap* folks_backends_blue_z_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	FolksBackendsBlueZPersonaStore* self;
	GeeMap* _tmp0_ = NULL;
	self = (FolksBackendsBlueZPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


const gchar* folks_backends_blue_z_persona_store_get_display_name (FolksBackendsBlueZPersonaStore* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_store_set_display_name (FolksBackendsBlueZPersonaStore* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	g_object_notify ((GObject *) self, "display-name");
}


const gchar* folks_backends_blue_z_persona_store_get_object_path (FolksBackendsBlueZPersonaStore* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_object_path;
	result = _tmp0_;
	return result;
}


static void folks_backends_blue_z_persona_store_set_object_path (FolksBackendsBlueZPersonaStore* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_object_path);
	self->priv->_object_path = _tmp1_;
	g_object_notify ((GObject *) self, "object-path");
}


static GObject * folks_backends_blue_z_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsBlueZPersonaStore * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_backends_blue_z_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	return obj;
}


static void folks_backends_blue_z_persona_store_class_init (FolksBackendsBlueZPersonaStoreClass * klass) {
	gchar** _tmp0_ = NULL;
	folks_backends_blue_z_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsBlueZPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = folks_backends_blue_z_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = folks_backends_blue_z_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = folks_backends_blue_z_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = folks_backends_blue_z_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = folks_backends_blue_z_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = folks_backends_blue_z_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_backends_blue_z_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = folks_backends_blue_z_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = folks_backends_blue_z_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = folks_backends_blue_z_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = folks_backends_blue_z_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = folks_backends_blue_z_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = folks_backends_blue_z_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = folks_backends_blue_z_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_backends_blue_z_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_blue_z_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_blue_z_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_blue_z_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_blue_z_persona_store_finalize;
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has reached a quiescent state.
	   *
	   * See {@link Folks.PersonaStore.is_quiescent}.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * Path of the D-Bus object backing this {@link PersonaStore}.
	   *
	   * This is the path of the BlueZ device object on D-Bus which provides the
	   * contacts in this store.
	   *
	   * @since 0.9.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH, g_param_spec_string ("object-path", "object-path", "object-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	folks_backends_blue_z_persona_store__always_writeable_properties = _tmp0_;
	folks_backends_blue_z_persona_store__always_writeable_properties_length1 = 0;
}


static void folks_backends_blue_z_persona_store_instance_init (FolksBackendsBlueZPersonaStore * self) {
	self->priv = FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
	self->priv->_update_contacts_cancellable = NULL;
	self->priv->_update_contacts_id = (guint) 0;
	self->priv->_photos_up_to_date = FALSE;
	self->priv->_update_contacts_n = (guint) 0;
	self->priv->_update_contacts_failures = (guint) 0;
}


static void folks_backends_blue_z_persona_store_finalize (GObject* obj) {
	FolksBackendsBlueZPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_obex_client);
	_g_free0 (self->priv->_object_path);
	_g_object_unref0 (self->priv->_device);
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_update_contacts_cancellable);
	G_OBJECT_CLASS (folks_backends_blue_z_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single BlueZ PBAP server (i.e.
 * one {@link PersonaStore} per device). It will create a {@link Persona} for
 * each contact on the device.
 *
 * Since large contact lists can take a long time to download in full (on the
 * order of 1s per 10 contacts), contacts are downloaded in two phases:
 * # Phase 1 downloads all non-PHOTO data. This is very fast (on the order of
 * 1s per 400 contacts)
 * # Phase 2 downloads all PHOTO data for those contacts. This is slow, but
 * happens later, in the background.
 *
 * Subsequent download attempts happen on an exponentially increasing interval,
 * up to a limit (once this limit is reached, updates occur on a regular
 * interval; the linear region). Download attempts repeat indefinitely unless a
 * certain number of consecutive attempts end in failure. See the documentation
 * for {@link _schedule_update_contacts} for details.
 *
 * @since 0.9.6
 */
GType folks_backends_blue_z_persona_store_get_type (void) {
	static volatile gsize folks_backends_blue_z_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_blue_z_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsBlueZPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_blue_z_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsBlueZPersonaStore), 0, (GInstanceInitFunc) folks_backends_blue_z_persona_store_instance_init, NULL };
		GType folks_backends_blue_z_persona_store_type_id;
		folks_backends_blue_z_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksBackendsBlueZPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_blue_z_persona_store_type_id__volatile, folks_backends_blue_z_persona_store_type_id);
	}
	return folks_backends_blue_z_persona_store_type_id__volatile;
}


static void _vala_folks_backends_blue_z_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsBlueZPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME:
		g_value_set_string (value, folks_backends_blue_z_persona_store_get_display_name (self));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH:
		g_value_set_string (value, folks_backends_blue_z_persona_store_get_object_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backends_blue_z_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsBlueZPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_BLUE_Z_TYPE_PERSONA_STORE, FolksBackendsBlueZPersonaStore);
	switch (property_id) {
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_DISPLAY_NAME:
		folks_backends_blue_z_persona_store_set_display_name (self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_BLUE_Z_PERSONA_STORE_OBJECT_PATH:
		folks_backends_blue_z_persona_store_set_object_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



