/* timsort.c generated by valac 0.24.0.111-cb21a, the Vala compiler
 * generated from timsort.vala, do not modify */

/* timsort.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_TIM_SORT (gee_tim_sort_get_type ())
#define GEE_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TIM_SORT, GeeTimSort))
#define GEE_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TIM_SORT, GeeTimSortClass))
#define GEE_IS_TIM_SORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TIM_SORT))
#define GEE_IS_TIM_SORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TIM_SORT))
#define GEE_TIM_SORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TIM_SORT, GeeTimSortClass))

typedef struct _GeeTimSort GeeTimSort;
typedef struct _GeeTimSortClass GeeTimSortClass;
typedef struct _GeeTimSortPrivate GeeTimSortPrivate;

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;
typedef struct _GeeTimSortSlice GeeTimSortSlice;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;

#define GEE_TYPE_ABSTRACT_BIDIR_LIST (gee_abstract_bidir_list_get_type ())
#define GEE_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList))
#define GEE_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))
#define GEE_IS_ABSTRACT_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_IS_ABSTRACT_BIDIR_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_BIDIR_LIST))
#define GEE_ABSTRACT_BIDIR_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirListClass))

typedef struct _GeeAbstractBidirList GeeAbstractBidirList;
typedef struct _GeeAbstractBidirListClass GeeAbstractBidirListClass;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
#define _g_destroy_func0(var) (((var == NULL) || (g_destroy_func == NULL)) ? NULL : (var = (g_destroy_func (var), NULL)))
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_BIDIR_LIST (gee_bidir_list_get_type ())
#define GEE_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_LIST, GeeBidirList))
#define GEE_IS_BIDIR_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_LIST))
#define GEE_BIDIR_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_LIST, GeeBidirListIface))

typedef struct _GeeBidirList GeeBidirList;
typedef struct _GeeBidirListIface GeeBidirListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_BIDIR_LIST_ITERATOR (gee_bidir_list_iterator_get_type ())
#define GEE_BIDIR_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR, GeeBidirListIterator))
#define GEE_IS_BIDIR_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR))
#define GEE_BIDIR_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_LIST_ITERATOR, GeeBidirListIteratorIface))

typedef struct _GeeBidirListIterator GeeBidirListIterator;
typedef struct _GeeBidirListIteratorIface GeeBidirListIteratorIface;
typedef struct _GeeAbstractBidirListPrivate GeeAbstractBidirListPrivate;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;
#define _gee_tim_sort_slice_free0(var) ((var == NULL) ? NULL : (var = (gee_tim_sort_slice_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GeeTimSort {
	GObject parent_instance;
	GeeTimSortPrivate * priv;
};

struct _GeeTimSortClass {
	GObjectClass parent_class;
};

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END,
	GEE_TRAVERSABLE_STREAM_WAIT
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
typedef GeeIterator* (*GeeFlatMapFunc) (gpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
	GeeIterator* (*flat_map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFlatMapFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator** (*tee) (GeeTraversable* self, guint forks, int* result_length1);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
	gboolean (*add_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*contains_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*remove_all_array) (GeeCollection* self, gpointer* array, int array_length1);
	gboolean (*add_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*contains_all_iterator) (GeeCollection* self, GeeIterator* iter);
	gboolean (*remove_all_iterator) (GeeCollection* self, GeeIterator* iter);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeList* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeList* self);
	GDestroyNotify (*get_g_destroy_func) (GeeList* self);
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareDataFunc compare_func, void* compare_func_target, GDestroyNotify compare_func_target_destroy_notify);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeTimSortPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeList* list_collection;
	gpointer* array;
	gint array_length1;
	gint _array_size_;
	void** list;
	gint index;
	gint size;
	GeeTimSortSlice** pending;
	gint pending_length1;
	gint _pending_size_;
	gint minimum_gallop;
	GCompareDataFunc compare;
	gpointer compare_target;
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gboolean (*foreach) (GeeAbstractCollection* self, GeeForallFunc f, void* f_target);
	void (*reserved0) (GeeAbstractCollection* self);
	void (*reserved1) (GeeAbstractCollection* self);
	void (*reserved2) (GeeAbstractCollection* self);
	void (*reserved3) (GeeAbstractCollection* self);
	void (*reserved4) (GeeAbstractCollection* self);
	void (*reserved5) (GeeAbstractCollection* self);
	void (*reserved6) (GeeAbstractCollection* self);
	void (*reserved7) (GeeAbstractCollection* self);
	void (*reserved8) (GeeAbstractCollection* self);
	void (*reserved9) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_read_only) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	void (*reserved0) (GeeAbstractList* self);
	void (*reserved1) (GeeAbstractList* self);
	void (*reserved2) (GeeAbstractList* self);
	void (*reserved3) (GeeAbstractList* self);
	void (*reserved4) (GeeAbstractList* self);
	void (*reserved5) (GeeAbstractList* self);
	void (*reserved6) (GeeAbstractList* self);
	void (*reserved7) (GeeAbstractList* self);
	void (*reserved8) (GeeAbstractList* self);
	void (*reserved9) (GeeAbstractList* self);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirIterator* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirIterator* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirIterator* self);
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*first) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeBidirListIteratorIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirListIterator* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirListIterator* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirListIterator* self);
	void (*insert) (GeeBidirListIterator* self, gconstpointer item);
};

struct _GeeBidirListIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeBidirList* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeBidirList* self);
	GDestroyNotify (*get_g_destroy_func) (GeeBidirList* self);
	GeeBidirListIterator* (*bidir_list_iterator) (GeeBidirList* self);
	GeeBidirList* (*get_read_only_view) (GeeBidirList* self);
};

struct _GeeAbstractBidirList {
	GeeAbstractList parent_instance;
	GeeAbstractBidirListPrivate * priv;
};

struct _GeeAbstractBidirListClass {
	GeeAbstractListClass parent_class;
	GeeBidirListIterator* (*bidir_list_iterator) (GeeAbstractBidirList* self);
	void (*reserved0) (GeeAbstractBidirList* self);
	void (*reserved1) (GeeAbstractBidirList* self);
	void (*reserved2) (GeeAbstractBidirList* self);
	void (*reserved3) (GeeAbstractBidirList* self);
	void (*reserved4) (GeeAbstractBidirList* self);
	void (*reserved5) (GeeAbstractBidirList* self);
	void (*reserved6) (GeeAbstractBidirList* self);
	void (*reserved7) (GeeAbstractBidirList* self);
	void (*reserved8) (GeeAbstractBidirList* self);
	void (*reserved9) (GeeAbstractBidirList* self);
	GeeBidirList* (*get_read_only_view) (GeeAbstractBidirList* self);
};

struct _GeeArrayList {
	GeeAbstractBidirList parent_instance;
	GeeArrayListPrivate * priv;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _size;
};

struct _GeeArrayListClass {
	GeeAbstractBidirListClass parent_class;
};

struct _GeeTimSortSlice {
	void** list;
	void** new_list;
	gint index;
	gint length;
};

typedef gboolean (*GeeTimSortLowerFunc) (gconstpointer left, gconstpointer right, void* user_data);

static gpointer gee_tim_sort_parent_class = NULL;

G_GNUC_INTERNAL GType gee_tim_sort_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
static void gee_tim_sort_slice_free (GeeTimSortSlice* self);
#define GEE_TIM_SORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TIM_SORT, GeeTimSortPrivate))
enum  {
	GEE_TIM_SORT_DUMMY_PROPERTY,
	GEE_TIM_SORT_G_TYPE,
	GEE_TIM_SORT_G_DUP_FUNC,
	GEE_TIM_SORT_G_DESTROY_FUNC
};
#define GEE_TIM_SORT_MINIMUM_GALLOP 7
G_GNUC_INTERNAL void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare, void* compare_target);
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_bidir_list_get_type (void) G_GNUC_CONST;
GType gee_array_list_get_type (void) G_GNUC_CONST;
static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareDataFunc compare, void* compare_target);
static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare, void* compare_target);
G_GNUC_INTERNAL GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
G_GNUC_INTERNAL GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
gpointer* gee_collection_to_array (GeeCollection* self, int* result_length1);
gint gee_collection_get_size (GeeCollection* self);
static void gee_tim_sort_do_sort (GeeTimSort* self);
void gee_collection_clear (GeeCollection* self);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_bidir_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_bidir_list_get_type (void) G_GNUC_CONST;
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length);
static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length);
static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length);
static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending);
static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self);
static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset);
static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n);
static void _vala_array_add3 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value);
static void gee_tim_sort_merge_collapse (GeeTimSort* self);
static void gee_tim_sort_merge_force_collapse (GeeTimSort* self);
static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right);
static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right);
static void gee_tim_sort_merge_at (GeeTimSort* self, gint index);
static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self);
static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint);
static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self);
static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b);
static void gee_tim_sort_slice_copy (GeeTimSortSlice* self);
static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self);
static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count);
static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n);
static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self);
static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j);
static void gee_tim_sort_finalize (GObject* obj);
static void _vala_gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);


G_GNUC_INTERNAL void gee_tim_sort_sort (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare, void* compare_target) {
	GeeList* _tmp0_ = NULL;
	g_return_if_fail (list != NULL);
	_tmp0_ = list;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GEE_TYPE_ARRAY_LIST)) {
		GeeList* _tmp1_ = NULL;
		GCompareDataFunc _tmp2_ = NULL;
		void* _tmp2__target = NULL;
		_tmp1_ = list;
		_tmp2_ = compare;
		_tmp2__target = compare_target;
		gee_tim_sort_sort_arraylist (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ARRAY_LIST, GeeArrayList), _tmp2_, _tmp2__target);
	} else {
		GeeList* _tmp3_ = NULL;
		GCompareDataFunc _tmp4_ = NULL;
		void* _tmp4__target = NULL;
		_tmp3_ = list;
		_tmp4_ = compare;
		_tmp4__target = compare_target;
		gee_tim_sort_sort_list (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, _tmp3_, _tmp4_, _tmp4__target);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gee_tim_sort_sort_list (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare, void* compare_target) {
	GeeTimSort* helper = NULL;
	GeeTimSort* _tmp0_ = NULL;
	GeeTimSort* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	GeeTimSort* _tmp4_ = NULL;
	GeeList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gpointer* _tmp7_ = NULL;
	GeeTimSort* _tmp8_ = NULL;
	GeeTimSort* _tmp9_ = NULL;
	gpointer* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GeeTimSort* _tmp11_ = NULL;
	GeeTimSort* _tmp12_ = NULL;
	GeeList* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GeeTimSort* _tmp16_ = NULL;
	GCompareDataFunc _tmp17_ = NULL;
	void* _tmp17__target = NULL;
	GeeTimSort* _tmp18_ = NULL;
	GeeList* _tmp19_ = NULL;
	GeeTimSort* _tmp20_ = NULL;
	gpointer* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	g_return_if_fail (list != NULL);
	_tmp0_ = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = helper;
	_tmp2_ = list;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_tmp1_->priv->list_collection);
	_tmp1_->priv->list_collection = _tmp3_;
	_tmp4_ = helper;
	_tmp5_ = list;
	_tmp7_ = gee_collection_to_array ((GeeCollection*) _tmp5_, &_tmp6_);
	_tmp4_->priv->array = (_vala_array_free (_tmp4_->priv->array, _tmp4_->priv->array_length1, (GDestroyNotify) g_destroy_func), NULL);
	_tmp4_->priv->array = _tmp7_;
	_tmp4_->priv->array_length1 = _tmp6_;
	_tmp4_->priv->_array_size_ = _tmp4_->priv->array_length1;
	_tmp8_ = helper;
	_tmp9_ = helper;
	_tmp10_ = _tmp9_->priv->array;
	_tmp10__length1 = _tmp9_->priv->array_length1;
	_tmp8_->priv->list = _tmp10_;
	_tmp11_ = helper;
	_tmp11_->priv->index = 0;
	_tmp12_ = helper;
	_tmp13_ = list;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp12_->priv->size = _tmp15_;
	_tmp16_ = helper;
	_tmp17_ = compare;
	_tmp17__target = compare_target;
	_tmp16_->priv->compare = _tmp17_;
	_tmp16_->priv->compare_target = _tmp17__target;
	_tmp18_ = helper;
	gee_tim_sort_do_sort (_tmp18_);
	_tmp19_ = list;
	gee_collection_clear ((GeeCollection*) _tmp19_);
	_tmp20_ = helper;
	_tmp21_ = _tmp20_->priv->array;
	_tmp21__length1 = _tmp20_->priv->array_length1;
	{
		gpointer* item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp21_;
		item_collection_length1 = _tmp21__length1;
		for (item_it = 0; item_it < _tmp21__length1; item_it = item_it + 1) {
			gpointer _tmp22_ = NULL;
			gpointer item = NULL;
			_tmp22_ = ((item_collection[item_it] != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) item_collection[item_it]) : ((gpointer) item_collection[item_it]);
			item = _tmp22_;
			{
				GeeList* _tmp23_ = NULL;
				gconstpointer _tmp24_ = NULL;
				_tmp23_ = list;
				_tmp24_ = item;
				gee_collection_add ((GeeCollection*) _tmp23_, _tmp24_);
				_g_destroy_func0 (item);
			}
		}
	}
	_g_object_unref0 (helper);
}


static void gee_tim_sort_sort_arraylist (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list, GCompareDataFunc compare, void* compare_target) {
	GeeTimSort* helper = NULL;
	GeeTimSort* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeList* _tmp2_ = NULL;
	GeeArrayList* _tmp3_ = NULL;
	gpointer* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GeeArrayList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GCompareDataFunc _tmp7_ = NULL;
	void* _tmp7__target = NULL;
	g_return_if_fail (list != NULL);
	_tmp0_ = gee_tim_sort_new (g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	helper = _tmp0_;
	_tmp1_ = list;
	_tmp2_ = _g_object_ref0 ((GeeList*) _tmp1_);
	_g_object_unref0 (helper->priv->list_collection);
	helper->priv->list_collection = _tmp2_;
	_tmp3_ = list;
	_tmp4_ = _tmp3_->_items;
	_tmp4__length1 = _tmp3_->_items_length1;
	helper->priv->list = _tmp4_;
	helper->priv->index = 0;
	_tmp5_ = list;
	_tmp6_ = _tmp5_->_size;
	helper->priv->size = _tmp6_;
	_tmp7_ = compare;
	_tmp7__target = compare_target;
	helper->priv->compare = _tmp7_;
	helper->priv->compare_target = _tmp7__target;
	gee_tim_sort_do_sort (helper);
	_g_object_unref0 (helper);
}


static void _vala_array_add3 (GeeTimSortSlice*** array, int* length, int* size, GeeTimSortSlice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GeeTimSortSlice*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void gee_tim_sort_do_sort (GeeTimSort* self) {
	gint _tmp0_ = 0;
	GeeTimSortSlice** _tmp1_ = NULL;
	GeeTimSortSlice* remaining = NULL;
	void** _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GeeTimSortSlice* _tmp5_ = NULL;
	gint minimum_length = 0;
	GeeTimSortSlice* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GeeTimSortSlice* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	GeeTimSortSlice** _tmp36_ = NULL;
	gint _tmp36__length1 = 0;
	GeeTimSortSlice** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	GeeTimSortSlice* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	GeeTimSortSlice** _tmp40_ = NULL;
	gint _tmp40__length1 = 0;
	GeeTimSortSlice* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->size;
	if (_tmp0_ < 2) {
		return;
	}
	_tmp1_ = g_new0 (GeeTimSortSlice*, 0 + 1);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) gee_tim_sort_slice_free), NULL);
	self->priv->pending = _tmp1_;
	self->priv->pending_length1 = 0;
	self->priv->_pending_size_ = self->priv->pending_length1;
	self->priv->minimum_gallop = GEE_TIM_SORT_MINIMUM_GALLOP;
	_tmp2_ = self->priv->list;
	_tmp3_ = self->priv->index;
	_tmp4_ = self->priv->size;
	_tmp5_ = gee_tim_sort_slice_new (_tmp2_, _tmp3_, _tmp4_);
	remaining = _tmp5_;
	_tmp6_ = remaining;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = gee_tim_sort_compute_minimum_run_length (self, _tmp7_);
	minimum_length = _tmp8_;
	while (TRUE) {
		GeeTimSortSlice* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gboolean descending = FALSE;
		GeeTimSortSlice* run = NULL;
		GeeTimSortSlice* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		GeeTimSortSlice* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		GeeTimSortSlice* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		GeeTimSortSlice* _tmp28_ = NULL;
		GeeTimSortSlice* _tmp29_ = NULL;
		gint _tmp30_ = 0;
		GeeTimSortSlice** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		GeeTimSortSlice* _tmp32_ = NULL;
		_tmp9_ = remaining;
		_tmp10_ = _tmp9_->length;
		if (!(_tmp10_ > 0)) {
			break;
		}
		_tmp11_ = remaining;
		_tmp13_ = gee_tim_sort_compute_longest_run (self, _tmp11_, &_tmp12_);
		descending = _tmp12_;
		run = _tmp13_;
		_tmp14_ = descending;
		if (_tmp14_) {
			GeeTimSortSlice* _tmp15_ = NULL;
			_tmp15_ = run;
			gee_tim_sort_slice_reverse (_tmp15_);
		}
		_tmp16_ = run;
		_tmp17_ = _tmp16_->length;
		_tmp18_ = minimum_length;
		if (_tmp17_ < _tmp18_) {
			gint sorted_count = 0;
			GeeTimSortSlice* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			GeeTimSortSlice* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			GeeTimSortSlice* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			GeeTimSortSlice* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			_tmp19_ = run;
			_tmp20_ = _tmp19_->length;
			sorted_count = _tmp20_;
			_tmp21_ = run;
			_tmp22_ = minimum_length;
			_tmp23_ = remaining;
			_tmp24_ = _tmp23_->length;
			_tmp25_ = MIN (_tmp22_, _tmp24_);
			_tmp21_->length = _tmp25_;
			_tmp26_ = run;
			_tmp27_ = sorted_count;
			gee_tim_sort_insertion_sort (self, _tmp26_, _tmp27_);
		}
		_tmp28_ = remaining;
		_tmp29_ = run;
		_tmp30_ = _tmp29_->length;
		gee_tim_sort_slice_shorten_start (_tmp28_, _tmp30_);
		_tmp31_ = self->priv->pending;
		_tmp31__length1 = self->priv->pending_length1;
		_tmp32_ = run;
		run = NULL;
		_vala_array_add3 (&self->priv->pending, &self->priv->pending_length1, &self->priv->_pending_size_, _tmp32_);
		gee_tim_sort_merge_collapse (self);
		_gee_tim_sort_slice_free0 (run);
	}
	_tmp33_ = remaining;
	_tmp34_ = _tmp33_->index;
	_tmp35_ = self->priv->size;
	_vala_assert (_tmp34_ == _tmp35_, "remaining.index == size");
	gee_tim_sort_merge_force_collapse (self);
	_tmp36_ = self->priv->pending;
	_tmp36__length1 = self->priv->pending_length1;
	_vala_assert (_tmp36__length1 == 1, "pending.length == 1");
	_tmp37_ = self->priv->pending;
	_tmp37__length1 = self->priv->pending_length1;
	_tmp38_ = _tmp37_[0];
	_tmp39_ = _tmp38_->index;
	_vala_assert (_tmp39_ == 0, "pending[0].index == 0");
	_tmp40_ = self->priv->pending;
	_tmp40__length1 = self->priv->pending_length1;
	_tmp41_ = _tmp40_[0];
	_tmp42_ = _tmp41_->length;
	_tmp43_ = self->priv->size;
	_vala_assert (_tmp42_ == _tmp43_, "pending[0].length == size");
	_gee_tim_sort_slice_free0 (remaining);
}


static inline gboolean gee_tim_sort_lower_than (GeeTimSort* self, gconstpointer left, gconstpointer right) {
	gboolean result = FALSE;
	GCompareDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	_tmp1_ = left;
	_tmp2_ = right;
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
	result = _tmp3_ < 0;
	return result;
}


static inline gboolean gee_tim_sort_lower_than_or_equal_to (GeeTimSort* self, gconstpointer left, gconstpointer right) {
	gboolean result = FALSE;
	GCompareDataFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gconstpointer _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->compare;
	_tmp0__target = self->priv->compare_target;
	_tmp1_ = left;
	_tmp2_ = right;
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
	result = _tmp3_ <= 0;
	return result;
}


static gint gee_tim_sort_compute_minimum_run_length (GeeTimSort* self, gint length) {
	gint result = 0;
	gint run_length = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	run_length = 0;
	while (TRUE) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		_tmp0_ = length;
		if (!(_tmp0_ >= 64)) {
			break;
		}
		_tmp1_ = run_length;
		_tmp2_ = length;
		run_length = _tmp1_ | (_tmp2_ & 1);
		_tmp3_ = length;
		length = _tmp3_ >> 1;
	}
	_tmp4_ = length;
	_tmp5_ = run_length;
	result = _tmp4_ + _tmp5_;
	return result;
}


static GeeTimSortSlice* gee_tim_sort_compute_longest_run (GeeTimSort* self, GeeTimSortSlice* a, gboolean* descending) {
	gboolean _vala_descending = FALSE;
	GeeTimSortSlice* result = NULL;
	gint run_length = 0;
	GeeTimSortSlice* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeTimSortSlice* _tmp53_ = NULL;
	void** _tmp54_ = NULL;
	GeeTimSortSlice* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	GeeTimSortSlice* _tmp58_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (a != NULL, NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	if (_tmp1_ <= 1) {
		GeeTimSortSlice* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp2_ = a;
		_tmp3_ = _tmp2_->length;
		run_length = _tmp3_;
		_vala_descending = FALSE;
	} else {
		GeeTimSortSlice* _tmp4_ = NULL;
		void** _tmp5_ = NULL;
		GeeTimSortSlice* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		void* _tmp8_ = NULL;
		GeeTimSortSlice* _tmp9_ = NULL;
		void** _tmp10_ = NULL;
		GeeTimSortSlice* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		void* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		run_length = 2;
		_tmp4_ = a;
		_tmp5_ = _tmp4_->list;
		_tmp6_ = a;
		_tmp7_ = _tmp6_->index;
		_tmp8_ = _tmp5_[_tmp7_ + 1];
		_tmp9_ = a;
		_tmp10_ = _tmp9_->list;
		_tmp11_ = a;
		_tmp12_ = _tmp11_->index;
		_tmp13_ = _tmp10_[_tmp12_];
		_tmp14_ = gee_tim_sort_lower_than (self, _tmp8_, _tmp13_);
		if (_tmp14_) {
			_vala_descending = TRUE;
			{
				gint i = 0;
				GeeTimSortSlice* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				_tmp15_ = a;
				_tmp16_ = _tmp15_->index;
				i = _tmp16_ + 2;
				{
					gboolean _tmp17_ = FALSE;
					_tmp17_ = TRUE;
					while (TRUE) {
						gint _tmp19_ = 0;
						GeeTimSortSlice* _tmp20_ = NULL;
						gint _tmp21_ = 0;
						GeeTimSortSlice* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						GeeTimSortSlice* _tmp24_ = NULL;
						void** _tmp25_ = NULL;
						gint _tmp26_ = 0;
						void* _tmp27_ = NULL;
						GeeTimSortSlice* _tmp28_ = NULL;
						void** _tmp29_ = NULL;
						gint _tmp30_ = 0;
						void* _tmp31_ = NULL;
						gboolean _tmp32_ = FALSE;
						if (!_tmp17_) {
							gint _tmp18_ = 0;
							_tmp18_ = i;
							i = _tmp18_ + 1;
						}
						_tmp17_ = FALSE;
						_tmp19_ = i;
						_tmp20_ = a;
						_tmp21_ = _tmp20_->index;
						_tmp22_ = a;
						_tmp23_ = _tmp22_->length;
						if (!(_tmp19_ < (_tmp21_ + _tmp23_))) {
							break;
						}
						_tmp24_ = a;
						_tmp25_ = _tmp24_->list;
						_tmp26_ = i;
						_tmp27_ = _tmp25_[_tmp26_];
						_tmp28_ = a;
						_tmp29_ = _tmp28_->list;
						_tmp30_ = i;
						_tmp31_ = _tmp29_[_tmp30_ - 1];
						_tmp32_ = gee_tim_sort_lower_than (self, _tmp27_, _tmp31_);
						if (_tmp32_) {
							gint _tmp33_ = 0;
							_tmp33_ = run_length;
							run_length = _tmp33_ + 1;
						} else {
							break;
						}
					}
				}
			}
		} else {
			_vala_descending = FALSE;
			{
				gint i = 0;
				GeeTimSortSlice* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				_tmp34_ = a;
				_tmp35_ = _tmp34_->index;
				i = _tmp35_ + 2;
				{
					gboolean _tmp36_ = FALSE;
					_tmp36_ = TRUE;
					while (TRUE) {
						gint _tmp38_ = 0;
						GeeTimSortSlice* _tmp39_ = NULL;
						gint _tmp40_ = 0;
						GeeTimSortSlice* _tmp41_ = NULL;
						gint _tmp42_ = 0;
						GeeTimSortSlice* _tmp43_ = NULL;
						void** _tmp44_ = NULL;
						gint _tmp45_ = 0;
						void* _tmp46_ = NULL;
						GeeTimSortSlice* _tmp47_ = NULL;
						void** _tmp48_ = NULL;
						gint _tmp49_ = 0;
						void* _tmp50_ = NULL;
						gboolean _tmp51_ = FALSE;
						if (!_tmp36_) {
							gint _tmp37_ = 0;
							_tmp37_ = i;
							i = _tmp37_ + 1;
						}
						_tmp36_ = FALSE;
						_tmp38_ = i;
						_tmp39_ = a;
						_tmp40_ = _tmp39_->index;
						_tmp41_ = a;
						_tmp42_ = _tmp41_->length;
						if (!(_tmp38_ < (_tmp40_ + _tmp42_))) {
							break;
						}
						_tmp43_ = a;
						_tmp44_ = _tmp43_->list;
						_tmp45_ = i;
						_tmp46_ = _tmp44_[_tmp45_];
						_tmp47_ = a;
						_tmp48_ = _tmp47_->list;
						_tmp49_ = i;
						_tmp50_ = _tmp48_[_tmp49_ - 1];
						_tmp51_ = gee_tim_sort_lower_than (self, _tmp46_, _tmp50_);
						if (_tmp51_) {
							break;
						} else {
							gint _tmp52_ = 0;
							_tmp52_ = run_length;
							run_length = _tmp52_ + 1;
						}
					}
				}
			}
		}
	}
	_tmp53_ = a;
	_tmp54_ = _tmp53_->list;
	_tmp55_ = a;
	_tmp56_ = _tmp55_->index;
	_tmp57_ = run_length;
	_tmp58_ = gee_tim_sort_slice_new (_tmp54_, _tmp56_, _tmp57_);
	result = _tmp58_;
	if (descending) {
		*descending = _vala_descending;
	}
	return result;
}


static void gee_tim_sort_insertion_sort (GeeTimSort* self, GeeTimSortSlice* a, gint offset) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	{
		gint start = 0;
		GeeTimSortSlice* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp0_ = a;
		_tmp1_ = _tmp0_->index;
		_tmp2_ = offset;
		start = _tmp1_ + _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				GeeTimSortSlice* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				GeeTimSortSlice* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint left = 0;
				GeeTimSortSlice* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint right = 0;
				gint _tmp12_ = 0;
				void* pivot = NULL;
				GeeTimSortSlice* _tmp13_ = NULL;
				void** _tmp14_ = NULL;
				gint _tmp15_ = 0;
				void* _tmp16_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				GeeTimSortSlice* _tmp32_ = NULL;
				void** _tmp33_ = NULL;
				gint _tmp34_ = 0;
				GeeTimSortSlice* _tmp35_ = NULL;
				void** _tmp36_ = NULL;
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				GeeTimSortSlice* _tmp40_ = NULL;
				void** _tmp41_ = NULL;
				gint _tmp42_ = 0;
				void* _tmp43_ = NULL;
				void* _tmp44_ = NULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = start;
					start = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = start;
				_tmp6_ = a;
				_tmp7_ = _tmp6_->index;
				_tmp8_ = a;
				_tmp9_ = _tmp8_->length;
				if (!(_tmp5_ < (_tmp7_ + _tmp9_))) {
					break;
				}
				_tmp10_ = a;
				_tmp11_ = _tmp10_->index;
				left = _tmp11_;
				_tmp12_ = start;
				right = _tmp12_;
				_tmp13_ = a;
				_tmp14_ = _tmp13_->list;
				_tmp15_ = right;
				_tmp16_ = _tmp14_[_tmp15_];
				pivot = _tmp16_;
				while (TRUE) {
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint p = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
					void* _tmp22_ = NULL;
					GeeTimSortSlice* _tmp23_ = NULL;
					void** _tmp24_ = NULL;
					gint _tmp25_ = 0;
					void* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
					_tmp17_ = left;
					_tmp18_ = right;
					if (!(_tmp17_ < _tmp18_)) {
						break;
					}
					_tmp19_ = left;
					_tmp20_ = right;
					_tmp21_ = left;
					p = _tmp19_ + ((_tmp20_ - _tmp21_) >> 1);
					_tmp22_ = pivot;
					_tmp23_ = a;
					_tmp24_ = _tmp23_->list;
					_tmp25_ = p;
					_tmp26_ = _tmp24_[_tmp25_];
					_tmp27_ = gee_tim_sort_lower_than (self, _tmp22_, _tmp26_);
					if (_tmp27_) {
						gint _tmp28_ = 0;
						_tmp28_ = p;
						right = _tmp28_;
					} else {
						gint _tmp29_ = 0;
						_tmp29_ = p;
						left = _tmp29_ + 1;
					}
				}
				_tmp30_ = left;
				_tmp31_ = right;
				_vala_assert (_tmp30_ == _tmp31_, "left == right");
				_tmp32_ = a;
				_tmp33_ = _tmp32_->list;
				_tmp34_ = left;
				_tmp35_ = a;
				_tmp36_ = _tmp35_->list;
				_tmp37_ = left;
				_tmp38_ = start;
				_tmp39_ = left;
				g_memmove (&_tmp33_[_tmp34_ + 1], &_tmp36_[_tmp37_], (gsize) (sizeof (gpointer) * (_tmp38_ - _tmp39_)));
				_tmp40_ = a;
				_tmp41_ = _tmp40_->list;
				_tmp42_ = left;
				_tmp43_ = pivot;
				_tmp41_[_tmp42_] = _tmp43_;
				_tmp44_ = _tmp41_[_tmp42_];
			}
		}
	}
}


static void gee_tim_sort_merge_collapse (GeeTimSort* self) {
	gint count = 0;
	GeeTimSortSlice** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_ = 0;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_ = 0;
		GeeTimSortSlice** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		_tmp1_ = count;
		if (!(_tmp1_ > 1)) {
			break;
		}
		_tmp3_ = count;
		if (_tmp3_ >= 3) {
			GeeTimSortSlice** _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			gint _tmp5_ = 0;
			GeeTimSortSlice* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			GeeTimSortSlice** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gint _tmp9_ = 0;
			GeeTimSortSlice* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			GeeTimSortSlice** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp13_ = 0;
			GeeTimSortSlice* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = count;
			_tmp6_ = _tmp4_[_tmp5_ - 3];
			_tmp7_ = _tmp6_->length;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = count;
			_tmp10_ = _tmp8_[_tmp9_ - 2];
			_tmp11_ = _tmp10_->length;
			_tmp12_ = self->priv->pending;
			_tmp12__length1 = self->priv->pending_length1;
			_tmp13_ = count;
			_tmp14_ = _tmp12_[_tmp13_ - 1];
			_tmp15_ = _tmp14_->length;
			_tmp2_ = _tmp7_ <= (_tmp11_ + _tmp15_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			GeeTimSortSlice** _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			gint _tmp17_ = 0;
			GeeTimSortSlice* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			GeeTimSortSlice** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			gint _tmp21_ = 0;
			GeeTimSortSlice* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			_tmp16_ = self->priv->pending;
			_tmp16__length1 = self->priv->pending_length1;
			_tmp17_ = count;
			_tmp18_ = _tmp16_[_tmp17_ - 3];
			_tmp19_ = _tmp18_->length;
			_tmp20_ = self->priv->pending;
			_tmp20__length1 = self->priv->pending_length1;
			_tmp21_ = count;
			_tmp22_ = _tmp20_[_tmp21_ - 1];
			_tmp23_ = _tmp22_->length;
			if (_tmp19_ < _tmp23_) {
				gint _tmp24_ = 0;
				_tmp24_ = count;
				gee_tim_sort_merge_at (self, _tmp24_ - 3);
			} else {
				gint _tmp25_ = 0;
				_tmp25_ = count;
				gee_tim_sort_merge_at (self, _tmp25_ - 2);
			}
		} else {
			GeeTimSortSlice** _tmp26_ = NULL;
			gint _tmp26__length1 = 0;
			gint _tmp27_ = 0;
			GeeTimSortSlice* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			GeeTimSortSlice** _tmp30_ = NULL;
			gint _tmp30__length1 = 0;
			gint _tmp31_ = 0;
			GeeTimSortSlice* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			_tmp26_ = self->priv->pending;
			_tmp26__length1 = self->priv->pending_length1;
			_tmp27_ = count;
			_tmp28_ = _tmp26_[_tmp27_ - 2];
			_tmp29_ = _tmp28_->length;
			_tmp30_ = self->priv->pending;
			_tmp30__length1 = self->priv->pending_length1;
			_tmp31_ = count;
			_tmp32_ = _tmp30_[_tmp31_ - 1];
			_tmp33_ = _tmp32_->length;
			if (_tmp29_ <= _tmp33_) {
				gint _tmp34_ = 0;
				_tmp34_ = count;
				gee_tim_sort_merge_at (self, _tmp34_ - 2);
			} else {
				break;
			}
		}
		_tmp35_ = self->priv->pending;
		_tmp35__length1 = self->priv->pending_length1;
		count = _tmp35__length1;
	}
}


static void gee_tim_sort_merge_force_collapse (GeeTimSort* self) {
	gint count = 0;
	GeeTimSortSlice** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	count = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_ = 0;
		gboolean _tmp2_ = FALSE;
		gint _tmp3_ = 0;
		GeeTimSortSlice** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		_tmp1_ = count;
		if (!(_tmp1_ > 1)) {
			break;
		}
		_tmp3_ = count;
		if (_tmp3_ >= 3) {
			GeeTimSortSlice** _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			gint _tmp5_ = 0;
			GeeTimSortSlice* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			GeeTimSortSlice** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gint _tmp9_ = 0;
			GeeTimSortSlice* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			_tmp4_ = self->priv->pending;
			_tmp4__length1 = self->priv->pending_length1;
			_tmp5_ = count;
			_tmp6_ = _tmp4_[_tmp5_ - 3];
			_tmp7_ = _tmp6_->length;
			_tmp8_ = self->priv->pending;
			_tmp8__length1 = self->priv->pending_length1;
			_tmp9_ = count;
			_tmp10_ = _tmp8_[_tmp9_ - 1];
			_tmp11_ = _tmp10_->length;
			_tmp2_ = _tmp7_ < _tmp11_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gint _tmp12_ = 0;
			_tmp12_ = count;
			gee_tim_sort_merge_at (self, _tmp12_ - 3);
		} else {
			gint _tmp13_ = 0;
			_tmp13_ = count;
			gee_tim_sort_merge_at (self, _tmp13_ - 2);
		}
		_tmp14_ = self->priv->pending;
		_tmp14__length1 = self->priv->pending_length1;
		count = _tmp14__length1;
	}
}


static void gee_tim_sort_merge_at (GeeTimSort* self, gint index) {
	GeeTimSortSlice* a = NULL;
	GeeTimSortSlice** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp1_ = 0;
	GeeTimSortSlice* _tmp2_ = NULL;
	GeeTimSortSlice* b = NULL;
	GeeTimSortSlice** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	GeeTimSortSlice* _tmp5_ = NULL;
	GeeTimSortSlice* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GeeTimSortSlice* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GeeTimSortSlice* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GeeTimSortSlice* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GeeTimSortSlice* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GeeTimSortSlice** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp17_ = 0;
	void** _tmp18_ = NULL;
	GeeTimSortSlice* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GeeTimSortSlice* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GeeTimSortSlice* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GeeTimSortSlice* _tmp25_ = NULL;
	GeeTimSortSlice* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GeeTimSortSlice** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint sorted_count = 0;
	GeeTimSortSlice* _tmp32_ = NULL;
	void* _tmp33_ = NULL;
	GeeTimSortSlice* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	GeeTimSortSlice* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	GeeTimSortSlice* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	GeeTimSortSlice* _tmp40_ = NULL;
	GeeTimSortSlice* _tmp41_ = NULL;
	void* _tmp42_ = NULL;
	GeeTimSortSlice* _tmp43_ = NULL;
	GeeTimSortSlice* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	GeeTimSortSlice* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	GeeTimSortSlice* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	GeeTimSortSlice* _tmp51_ = NULL;
	gint _tmp52_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pending;
	_tmp0__length1 = self->priv->pending_length1;
	_tmp1_ = index;
	_tmp2_ = _tmp0_[_tmp1_];
	_tmp0_[_tmp1_] = NULL;
	a = _tmp2_;
	_tmp3_ = self->priv->pending;
	_tmp3__length1 = self->priv->pending_length1;
	_tmp4_ = index;
	_tmp5_ = _tmp3_[_tmp4_ + 1];
	_tmp3_[_tmp4_ + 1] = NULL;
	b = _tmp5_;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_vala_assert (_tmp7_ > 0, "a.length > 0");
	_tmp8_ = b;
	_tmp9_ = _tmp8_->length;
	_vala_assert (_tmp9_ > 0, "b.length > 0");
	_tmp10_ = a;
	_tmp11_ = _tmp10_->index;
	_tmp12_ = a;
	_tmp13_ = _tmp12_->length;
	_tmp14_ = b;
	_tmp15_ = _tmp14_->index;
	_vala_assert ((_tmp11_ + _tmp13_) == _tmp15_, "a.index + a.length == b.index");
	_tmp16_ = self->priv->pending;
	_tmp16__length1 = self->priv->pending_length1;
	_tmp17_ = index;
	_tmp18_ = self->priv->list;
	_tmp19_ = a;
	_tmp20_ = _tmp19_->index;
	_tmp21_ = a;
	_tmp22_ = _tmp21_->length;
	_tmp23_ = b;
	_tmp24_ = _tmp23_->length;
	_tmp25_ = gee_tim_sort_slice_new (_tmp18_, _tmp20_, _tmp22_ + _tmp24_);
	_gee_tim_sort_slice_free0 (_tmp16_[_tmp17_]);
	_tmp16_[_tmp17_] = _tmp25_;
	_tmp26_ = _tmp16_[_tmp17_];
	_tmp27_ = index;
	_tmp28_ = index;
	_tmp29_ = self->priv->pending;
	_tmp29__length1 = self->priv->pending_length1;
	_tmp30_ = index;
	_vala_array_move (self->priv->pending, sizeof (GeeTimSortSlice*), _tmp27_ + 2, _tmp28_ + 1, (_tmp29__length1 - _tmp30_) - 2);
	self->priv->pending_length1 = self->priv->pending_length1 - 1;
	_tmp31_ = self->priv->pending_length1;
	_tmp32_ = b;
	_tmp33_ = gee_tim_sort_slice_peek_first (_tmp32_);
	_tmp34_ = a;
	_tmp35_ = gee_tim_sort_gallop_rightmost (self, _tmp33_, _tmp34_, 0);
	sorted_count = _tmp35_;
	_tmp36_ = a;
	_tmp37_ = sorted_count;
	gee_tim_sort_slice_shorten_start (_tmp36_, _tmp37_);
	_tmp38_ = a;
	_tmp39_ = _tmp38_->length;
	if (_tmp39_ == 0) {
		_gee_tim_sort_slice_free0 (b);
		_gee_tim_sort_slice_free0 (a);
		return;
	}
	_tmp40_ = b;
	_tmp41_ = a;
	_tmp42_ = gee_tim_sort_slice_peek_last (_tmp41_);
	_tmp43_ = b;
	_tmp44_ = b;
	_tmp45_ = _tmp44_->length;
	_tmp46_ = gee_tim_sort_gallop_leftmost (self, _tmp42_, _tmp43_, _tmp45_ - 1);
	_tmp40_->length = _tmp46_;
	_tmp47_ = b;
	_tmp48_ = _tmp47_->length;
	if (_tmp48_ == 0) {
		_gee_tim_sort_slice_free0 (b);
		_gee_tim_sort_slice_free0 (a);
		return;
	}
	_tmp49_ = a;
	_tmp50_ = _tmp49_->length;
	_tmp51_ = b;
	_tmp52_ = _tmp51_->length;
	if (_tmp50_ <= _tmp52_) {
		GeeTimSortSlice* _tmp53_ = NULL;
		GeeTimSortSlice* _tmp54_ = NULL;
		_tmp53_ = a;
		a = NULL;
		_tmp54_ = b;
		b = NULL;
		gee_tim_sort_merge_low (self, _tmp53_, _tmp54_);
	} else {
		GeeTimSortSlice* _tmp55_ = NULL;
		GeeTimSortSlice* _tmp56_ = NULL;
		_tmp55_ = a;
		a = NULL;
		_tmp56_ = b;
		b = NULL;
		gee_tim_sort_merge_high (self, _tmp55_, _tmp56_);
	}
	_gee_tim_sort_slice_free0 (b);
	_gee_tim_sort_slice_free0 (a);
}


static gint gee_tim_sort_gallop_leftmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GeeTimSortSlice* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint p = 0;
	GeeTimSortSlice* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint last_offset = 0;
	gint offset = 0;
	GeeTimSortSlice* _tmp7_ = NULL;
	void** _tmp8_ = NULL;
	gint _tmp9_ = 0;
	void* _tmp10_ = NULL;
	gconstpointer _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	GeeTimSortSlice* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_tmp0_ = hint;
	_vala_assert (0 <= _tmp0_, "0 <= hint");
	_tmp1_ = hint;
	_tmp2_ = a;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp1_ < _tmp3_, "hint < a.length");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = hint;
	p = _tmp5_ + _tmp6_;
	last_offset = 0;
	offset = 1;
	_tmp7_ = a;
	_tmp8_ = _tmp7_->list;
	_tmp9_ = p;
	_tmp10_ = _tmp8_[_tmp9_];
	_tmp11_ = key;
	_tmp12_ = gee_tim_sort_lower_than (self, _tmp10_, _tmp11_);
	if (_tmp12_) {
		gint max_offset = 0;
		GeeTimSortSlice* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		_tmp13_ = a;
		_tmp14_ = _tmp13_->length;
		_tmp15_ = hint;
		max_offset = _tmp14_ - _tmp15_;
		while (TRUE) {
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			GeeTimSortSlice* _tmp18_ = NULL;
			void** _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			void* _tmp22_ = NULL;
			gconstpointer _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp16_ = offset;
			_tmp17_ = max_offset;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = a;
			_tmp19_ = _tmp18_->list;
			_tmp20_ = p;
			_tmp21_ = offset;
			_tmp22_ = _tmp19_[_tmp20_ + _tmp21_];
			_tmp23_ = key;
			_tmp24_ = gee_tim_sort_lower_than (self, _tmp22_, _tmp23_);
			if (_tmp24_) {
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				_tmp25_ = offset;
				last_offset = _tmp25_;
				_tmp26_ = offset;
				offset = _tmp26_ << 1;
				_tmp27_ = offset;
				offset = _tmp27_ + 1;
			} else {
				break;
			}
		}
		_tmp28_ = offset;
		_tmp29_ = max_offset;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_ = 0;
			_tmp30_ = max_offset;
			offset = _tmp30_;
		}
		_tmp31_ = hint;
		_tmp32_ = last_offset;
		last_offset = _tmp31_ + _tmp32_;
		_tmp33_ = hint;
		_tmp34_ = offset;
		offset = _tmp33_ + _tmp34_;
	} else {
		gint max_offset = 0;
		gint _tmp35_ = 0;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gint temp_last_offset = 0;
		gint _tmp51_ = 0;
		gint temp_offset = 0;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		_tmp35_ = hint;
		max_offset = _tmp35_ + 1;
		while (TRUE) {
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			GeeTimSortSlice* _tmp38_ = NULL;
			void** _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			void* _tmp42_ = NULL;
			gconstpointer _tmp43_ = NULL;
			gboolean _tmp44_ = FALSE;
			_tmp36_ = offset;
			_tmp37_ = max_offset;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = a;
			_tmp39_ = _tmp38_->list;
			_tmp40_ = p;
			_tmp41_ = offset;
			_tmp42_ = _tmp39_[_tmp40_ - _tmp41_];
			_tmp43_ = key;
			_tmp44_ = gee_tim_sort_lower_than (self, _tmp42_, _tmp43_);
			if (_tmp44_) {
				break;
			} else {
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
				_tmp45_ = offset;
				last_offset = _tmp45_;
				_tmp46_ = offset;
				offset = _tmp46_ << 1;
				_tmp47_ = offset;
				offset = _tmp47_ + 1;
			}
		}
		_tmp48_ = offset;
		_tmp49_ = max_offset;
		if (_tmp48_ > _tmp49_) {
			gint _tmp50_ = 0;
			_tmp50_ = max_offset;
			offset = _tmp50_;
		}
		_tmp51_ = last_offset;
		temp_last_offset = _tmp51_;
		_tmp52_ = offset;
		temp_offset = _tmp52_;
		_tmp53_ = hint;
		_tmp54_ = temp_offset;
		last_offset = _tmp53_ - _tmp54_;
		_tmp55_ = hint;
		_tmp56_ = temp_last_offset;
		offset = _tmp55_ - _tmp56_;
	}
	_tmp57_ = last_offset;
	_vala_assert ((-1) <= _tmp57_, "-1 <= last_offset");
	_tmp58_ = last_offset;
	_tmp59_ = offset;
	_vala_assert (_tmp58_ < _tmp59_, "last_offset < offset");
	_tmp60_ = offset;
	_tmp61_ = a;
	_tmp62_ = _tmp61_->length;
	_vala_assert (_tmp60_ <= _tmp62_, "offset <= a.length");
	_tmp63_ = last_offset;
	last_offset = _tmp63_ + 1;
	while (TRUE) {
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint m = 0;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		GeeTimSortSlice* _tmp69_ = NULL;
		void** _tmp70_ = NULL;
		GeeTimSortSlice* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		gint _tmp73_ = 0;
		void* _tmp74_ = NULL;
		gconstpointer _tmp75_ = NULL;
		gboolean _tmp76_ = FALSE;
		_tmp64_ = last_offset;
		_tmp65_ = offset;
		if (!(_tmp64_ < _tmp65_)) {
			break;
		}
		_tmp66_ = last_offset;
		_tmp67_ = offset;
		_tmp68_ = last_offset;
		m = _tmp66_ + ((_tmp67_ - _tmp68_) >> 1);
		_tmp69_ = a;
		_tmp70_ = _tmp69_->list;
		_tmp71_ = a;
		_tmp72_ = _tmp71_->index;
		_tmp73_ = m;
		_tmp74_ = _tmp70_[_tmp72_ + _tmp73_];
		_tmp75_ = key;
		_tmp76_ = gee_tim_sort_lower_than (self, _tmp74_, _tmp75_);
		if (_tmp76_) {
			gint _tmp77_ = 0;
			_tmp77_ = m;
			last_offset = _tmp77_ + 1;
		} else {
			gint _tmp78_ = 0;
			_tmp78_ = m;
			offset = _tmp78_;
		}
	}
	_tmp79_ = last_offset;
	_tmp80_ = offset;
	_vala_assert (_tmp79_ == _tmp80_, "last_offset == offset");
	result = offset;
	return result;
}


static gint gee_tim_sort_gallop_rightmost (GeeTimSort* self, gconstpointer key, GeeTimSortSlice* a, gint hint) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GeeTimSortSlice* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint p = 0;
	GeeTimSortSlice* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint last_offset = 0;
	gint offset = 0;
	GeeTimSortSlice* _tmp7_ = NULL;
	void** _tmp8_ = NULL;
	gint _tmp9_ = 0;
	void* _tmp10_ = NULL;
	gconstpointer _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gint _tmp57_ = 0;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	gint _tmp60_ = 0;
	GeeTimSortSlice* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	_tmp0_ = hint;
	_vala_assert (0 <= _tmp0_, "0 <= hint");
	_tmp1_ = hint;
	_tmp2_ = a;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp1_ < _tmp3_, "hint < a.length");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = hint;
	p = _tmp5_ + _tmp6_;
	last_offset = 0;
	offset = 1;
	_tmp7_ = a;
	_tmp8_ = _tmp7_->list;
	_tmp9_ = p;
	_tmp10_ = _tmp8_[_tmp9_];
	_tmp11_ = key;
	_tmp12_ = gee_tim_sort_lower_than_or_equal_to (self, _tmp10_, _tmp11_);
	if (_tmp12_) {
		gint max_offset = 0;
		GeeTimSortSlice* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		_tmp13_ = a;
		_tmp14_ = _tmp13_->length;
		_tmp15_ = hint;
		max_offset = _tmp14_ - _tmp15_;
		while (TRUE) {
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			GeeTimSortSlice* _tmp18_ = NULL;
			void** _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			void* _tmp22_ = NULL;
			gconstpointer _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp16_ = offset;
			_tmp17_ = max_offset;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = a;
			_tmp19_ = _tmp18_->list;
			_tmp20_ = p;
			_tmp21_ = offset;
			_tmp22_ = _tmp19_[_tmp20_ + _tmp21_];
			_tmp23_ = key;
			_tmp24_ = gee_tim_sort_lower_than_or_equal_to (self, _tmp22_, _tmp23_);
			if (_tmp24_) {
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				_tmp25_ = offset;
				last_offset = _tmp25_;
				_tmp26_ = offset;
				offset = _tmp26_ << 1;
				_tmp27_ = offset;
				offset = _tmp27_ + 1;
			} else {
				break;
			}
		}
		_tmp28_ = offset;
		_tmp29_ = max_offset;
		if (_tmp28_ > _tmp29_) {
			gint _tmp30_ = 0;
			_tmp30_ = max_offset;
			offset = _tmp30_;
		}
		_tmp31_ = hint;
		_tmp32_ = last_offset;
		last_offset = _tmp31_ + _tmp32_;
		_tmp33_ = hint;
		_tmp34_ = offset;
		offset = _tmp33_ + _tmp34_;
	} else {
		gint max_offset = 0;
		gint _tmp35_ = 0;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gint temp_last_offset = 0;
		gint _tmp51_ = 0;
		gint temp_offset = 0;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		_tmp35_ = hint;
		max_offset = _tmp35_ + 1;
		while (TRUE) {
			gint _tmp36_ = 0;
			gint _tmp37_ = 0;
			GeeTimSortSlice* _tmp38_ = NULL;
			void** _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			void* _tmp42_ = NULL;
			gconstpointer _tmp43_ = NULL;
			gboolean _tmp44_ = FALSE;
			_tmp36_ = offset;
			_tmp37_ = max_offset;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = a;
			_tmp39_ = _tmp38_->list;
			_tmp40_ = p;
			_tmp41_ = offset;
			_tmp42_ = _tmp39_[_tmp40_ - _tmp41_];
			_tmp43_ = key;
			_tmp44_ = gee_tim_sort_lower_than_or_equal_to (self, _tmp42_, _tmp43_);
			if (_tmp44_) {
				break;
			} else {
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
				_tmp45_ = offset;
				last_offset = _tmp45_;
				_tmp46_ = offset;
				offset = _tmp46_ << 1;
				_tmp47_ = offset;
				offset = _tmp47_ + 1;
			}
		}
		_tmp48_ = offset;
		_tmp49_ = max_offset;
		if (_tmp48_ > _tmp49_) {
			gint _tmp50_ = 0;
			_tmp50_ = max_offset;
			offset = _tmp50_;
		}
		_tmp51_ = last_offset;
		temp_last_offset = _tmp51_;
		_tmp52_ = offset;
		temp_offset = _tmp52_;
		_tmp53_ = hint;
		_tmp54_ = temp_offset;
		last_offset = _tmp53_ - _tmp54_;
		_tmp55_ = hint;
		_tmp56_ = temp_last_offset;
		offset = _tmp55_ - _tmp56_;
	}
	_tmp57_ = last_offset;
	_vala_assert ((-1) <= _tmp57_, "-1 <= last_offset");
	_tmp58_ = last_offset;
	_tmp59_ = offset;
	_vala_assert (_tmp58_ < _tmp59_, "last_offset < offset");
	_tmp60_ = offset;
	_tmp61_ = a;
	_tmp62_ = _tmp61_->length;
	_vala_assert (_tmp60_ <= _tmp62_, "offset <= a.length");
	_tmp63_ = last_offset;
	last_offset = _tmp63_ + 1;
	while (TRUE) {
		gint _tmp64_ = 0;
		gint _tmp65_ = 0;
		gint m = 0;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		GeeTimSortSlice* _tmp69_ = NULL;
		void** _tmp70_ = NULL;
		GeeTimSortSlice* _tmp71_ = NULL;
		gint _tmp72_ = 0;
		gint _tmp73_ = 0;
		void* _tmp74_ = NULL;
		gconstpointer _tmp75_ = NULL;
		gboolean _tmp76_ = FALSE;
		_tmp64_ = last_offset;
		_tmp65_ = offset;
		if (!(_tmp64_ < _tmp65_)) {
			break;
		}
		_tmp66_ = last_offset;
		_tmp67_ = offset;
		_tmp68_ = last_offset;
		m = _tmp66_ + ((_tmp67_ - _tmp68_) >> 1);
		_tmp69_ = a;
		_tmp70_ = _tmp69_->list;
		_tmp71_ = a;
		_tmp72_ = _tmp71_->index;
		_tmp73_ = m;
		_tmp74_ = _tmp70_[_tmp72_ + _tmp73_];
		_tmp75_ = key;
		_tmp76_ = gee_tim_sort_lower_than_or_equal_to (self, _tmp74_, _tmp75_);
		if (_tmp76_) {
			gint _tmp77_ = 0;
			_tmp77_ = m;
			last_offset = _tmp77_ + 1;
		} else {
			gint _tmp78_ = 0;
			_tmp78_ = m;
			offset = _tmp78_;
		}
	}
	_tmp79_ = last_offset;
	_tmp80_ = offset;
	_vala_assert (_tmp79_ == _tmp80_, "last_offset == offset");
	result = offset;
	return result;
}


static void gee_tim_sort_merge_low (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
	GeeTimSortSlice* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeTimSortSlice* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GeeTimSortSlice* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GeeTimSortSlice* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GeeTimSortSlice* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint minimum_gallop = 0;
	gint _tmp10_ = 0;
	gint dest = 0;
	GeeTimSortSlice* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GeeTimSortSlice* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	_vala_assert (_tmp1_ > 0, "a.length > 0");
	_tmp2_ = b;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp3_ > 0, "b.length > 0");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->index;
	_vala_assert ((_tmp5_ + _tmp7_) == _tmp9_, "a.index + a.length == b.index");
	_tmp10_ = self->priv->minimum_gallop;
	minimum_gallop = _tmp10_;
	_tmp11_ = a;
	_tmp12_ = _tmp11_->index;
	dest = _tmp12_;
	_tmp13_ = a;
	gee_tim_sort_slice_copy (_tmp13_);
	{
		void** _tmp14_ = NULL;
		gint _tmp15_ = 0;
		GeeTimSortSlice* _tmp16_ = NULL;
		void* _tmp17_ = NULL;
		void* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		GeeTimSortSlice* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		_tmp14_ = self->priv->list;
		_tmp15_ = dest;
		dest = _tmp15_ + 1;
		_tmp16_ = b;
		_tmp17_ = gee_tim_sort_slice_pop_first (_tmp16_);
		_tmp14_[_tmp15_] = _tmp17_;
		_tmp18_ = _tmp14_[_tmp15_];
		_tmp20_ = a;
		_tmp21_ = _tmp20_->length;
		if (_tmp21_ == 1) {
			_tmp19_ = TRUE;
		} else {
			GeeTimSortSlice* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			_tmp22_ = b;
			_tmp23_ = _tmp22_->length;
			_tmp19_ = _tmp23_ == 0;
		}
		if (_tmp19_) {
			{
				GeeTimSortSlice* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				GeeTimSortSlice* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				GeeTimSortSlice* _tmp28_ = NULL;
				void** _tmp29_ = NULL;
				GeeTimSortSlice* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				GeeTimSortSlice* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				GeeTimSortSlice* _tmp35_ = NULL;
				void** _tmp36_ = NULL;
				GeeTimSortSlice* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				GeeTimSortSlice* _tmp40_ = NULL;
				gint _tmp41_ = 0;
				GeeTimSortSlice* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				_tmp24_ = a;
				_tmp25_ = _tmp24_->length;
				_vala_assert (_tmp25_ >= 0, "a.length >= 0");
				_tmp26_ = b;
				_tmp27_ = _tmp26_->length;
				_vala_assert (_tmp27_ >= 0, "b.length >= 0");
				_tmp28_ = b;
				_tmp29_ = self->priv->list;
				_tmp30_ = b;
				_tmp31_ = _tmp30_->index;
				_tmp32_ = dest;
				_tmp33_ = b;
				_tmp34_ = _tmp33_->length;
				gee_tim_sort_slice_merge_in (_tmp28_, _tmp29_, _tmp31_, _tmp32_, _tmp34_);
				_tmp35_ = a;
				_tmp36_ = self->priv->list;
				_tmp37_ = a;
				_tmp38_ = _tmp37_->index;
				_tmp39_ = dest;
				_tmp40_ = b;
				_tmp41_ = _tmp40_->length;
				_tmp42_ = a;
				_tmp43_ = _tmp42_->length;
				gee_tim_sort_slice_merge_in (_tmp35_, _tmp36_, _tmp38_, _tmp39_ + _tmp41_, _tmp43_);
			}
			_gee_tim_sort_slice_free0 (a);
			_gee_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count = 0;
			gint b_count = 0;
			gint _tmp109_ = 0;
			gint _tmp243_ = 0;
			gint _tmp244_ = 0;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				GeeTimSortSlice* _tmp44_ = NULL;
				void* _tmp45_ = NULL;
				GeeTimSortSlice* _tmp46_ = NULL;
				void* _tmp47_ = NULL;
				gboolean _tmp48_ = FALSE;
				_tmp44_ = b;
				_tmp45_ = gee_tim_sort_slice_peek_first (_tmp44_);
				_tmp46_ = a;
				_tmp47_ = gee_tim_sort_slice_peek_first (_tmp46_);
				_tmp48_ = gee_tim_sort_lower_than (self, _tmp45_, _tmp47_);
				if (_tmp48_) {
					void** _tmp49_ = NULL;
					gint _tmp50_ = 0;
					GeeTimSortSlice* _tmp51_ = NULL;
					void* _tmp52_ = NULL;
					void* _tmp53_ = NULL;
					GeeTimSortSlice* _tmp54_ = NULL;
					gint _tmp55_ = 0;
					gint _tmp76_ = 0;
					gint _tmp77_ = 0;
					gint _tmp78_ = 0;
					_tmp49_ = self->priv->list;
					_tmp50_ = dest;
					dest = _tmp50_ + 1;
					_tmp51_ = b;
					_tmp52_ = gee_tim_sort_slice_pop_first (_tmp51_);
					_tmp49_[_tmp50_] = _tmp52_;
					_tmp53_ = _tmp49_[_tmp50_];
					_tmp54_ = b;
					_tmp55_ = _tmp54_->length;
					if (_tmp55_ == 0) {
						{
							GeeTimSortSlice* _tmp56_ = NULL;
							gint _tmp57_ = 0;
							GeeTimSortSlice* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							GeeTimSortSlice* _tmp60_ = NULL;
							void** _tmp61_ = NULL;
							GeeTimSortSlice* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							gint _tmp64_ = 0;
							GeeTimSortSlice* _tmp65_ = NULL;
							gint _tmp66_ = 0;
							GeeTimSortSlice* _tmp67_ = NULL;
							void** _tmp68_ = NULL;
							GeeTimSortSlice* _tmp69_ = NULL;
							gint _tmp70_ = 0;
							gint _tmp71_ = 0;
							GeeTimSortSlice* _tmp72_ = NULL;
							gint _tmp73_ = 0;
							GeeTimSortSlice* _tmp74_ = NULL;
							gint _tmp75_ = 0;
							_tmp56_ = a;
							_tmp57_ = _tmp56_->length;
							_vala_assert (_tmp57_ >= 0, "a.length >= 0");
							_tmp58_ = b;
							_tmp59_ = _tmp58_->length;
							_vala_assert (_tmp59_ >= 0, "b.length >= 0");
							_tmp60_ = b;
							_tmp61_ = self->priv->list;
							_tmp62_ = b;
							_tmp63_ = _tmp62_->index;
							_tmp64_ = dest;
							_tmp65_ = b;
							_tmp66_ = _tmp65_->length;
							gee_tim_sort_slice_merge_in (_tmp60_, _tmp61_, _tmp63_, _tmp64_, _tmp66_);
							_tmp67_ = a;
							_tmp68_ = self->priv->list;
							_tmp69_ = a;
							_tmp70_ = _tmp69_->index;
							_tmp71_ = dest;
							_tmp72_ = b;
							_tmp73_ = _tmp72_->length;
							_tmp74_ = a;
							_tmp75_ = _tmp74_->length;
							gee_tim_sort_slice_merge_in (_tmp67_, _tmp68_, _tmp70_, _tmp71_ + _tmp73_, _tmp75_);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp76_ = b_count;
					b_count = _tmp76_ + 1;
					a_count = 0;
					_tmp77_ = b_count;
					_tmp78_ = minimum_gallop;
					if (_tmp77_ >= _tmp78_) {
						break;
					}
				} else {
					void** _tmp79_ = NULL;
					gint _tmp80_ = 0;
					GeeTimSortSlice* _tmp81_ = NULL;
					void* _tmp82_ = NULL;
					void* _tmp83_ = NULL;
					GeeTimSortSlice* _tmp84_ = NULL;
					gint _tmp85_ = 0;
					gint _tmp106_ = 0;
					gint _tmp107_ = 0;
					gint _tmp108_ = 0;
					_tmp79_ = self->priv->list;
					_tmp80_ = dest;
					dest = _tmp80_ + 1;
					_tmp81_ = a;
					_tmp82_ = gee_tim_sort_slice_pop_first (_tmp81_);
					_tmp79_[_tmp80_] = _tmp82_;
					_tmp83_ = _tmp79_[_tmp80_];
					_tmp84_ = a;
					_tmp85_ = _tmp84_->length;
					if (_tmp85_ == 1) {
						{
							GeeTimSortSlice* _tmp86_ = NULL;
							gint _tmp87_ = 0;
							GeeTimSortSlice* _tmp88_ = NULL;
							gint _tmp89_ = 0;
							GeeTimSortSlice* _tmp90_ = NULL;
							void** _tmp91_ = NULL;
							GeeTimSortSlice* _tmp92_ = NULL;
							gint _tmp93_ = 0;
							gint _tmp94_ = 0;
							GeeTimSortSlice* _tmp95_ = NULL;
							gint _tmp96_ = 0;
							GeeTimSortSlice* _tmp97_ = NULL;
							void** _tmp98_ = NULL;
							GeeTimSortSlice* _tmp99_ = NULL;
							gint _tmp100_ = 0;
							gint _tmp101_ = 0;
							GeeTimSortSlice* _tmp102_ = NULL;
							gint _tmp103_ = 0;
							GeeTimSortSlice* _tmp104_ = NULL;
							gint _tmp105_ = 0;
							_tmp86_ = a;
							_tmp87_ = _tmp86_->length;
							_vala_assert (_tmp87_ >= 0, "a.length >= 0");
							_tmp88_ = b;
							_tmp89_ = _tmp88_->length;
							_vala_assert (_tmp89_ >= 0, "b.length >= 0");
							_tmp90_ = b;
							_tmp91_ = self->priv->list;
							_tmp92_ = b;
							_tmp93_ = _tmp92_->index;
							_tmp94_ = dest;
							_tmp95_ = b;
							_tmp96_ = _tmp95_->length;
							gee_tim_sort_slice_merge_in (_tmp90_, _tmp91_, _tmp93_, _tmp94_, _tmp96_);
							_tmp97_ = a;
							_tmp98_ = self->priv->list;
							_tmp99_ = a;
							_tmp100_ = _tmp99_->index;
							_tmp101_ = dest;
							_tmp102_ = b;
							_tmp103_ = _tmp102_->length;
							_tmp104_ = a;
							_tmp105_ = _tmp104_->length;
							gee_tim_sort_slice_merge_in (_tmp97_, _tmp98_, _tmp100_, _tmp101_ + _tmp103_, _tmp105_);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp106_ = a_count;
					a_count = _tmp106_ + 1;
					b_count = 0;
					_tmp107_ = a_count;
					_tmp108_ = minimum_gallop;
					if (_tmp107_ >= _tmp108_) {
						break;
					}
				}
			}
			_tmp109_ = minimum_gallop;
			minimum_gallop = _tmp109_ + 1;
			while (TRUE) {
				gint _tmp110_ = 0;
				gint _tmp111_ = 0;
				gint _tmp112_ = 0;
				gint _tmp113_ = 0;
				GeeTimSortSlice* _tmp114_ = NULL;
				void* _tmp115_ = NULL;
				GeeTimSortSlice* _tmp116_ = NULL;
				gint _tmp117_ = 0;
				GeeTimSortSlice* _tmp118_ = NULL;
				void** _tmp119_ = NULL;
				GeeTimSortSlice* _tmp120_ = NULL;
				gint _tmp121_ = 0;
				gint _tmp122_ = 0;
				gint _tmp123_ = 0;
				gint _tmp124_ = 0;
				gint _tmp125_ = 0;
				GeeTimSortSlice* _tmp126_ = NULL;
				gint _tmp127_ = 0;
				GeeTimSortSlice* _tmp128_ = NULL;
				gint _tmp129_ = 0;
				void** _tmp150_ = NULL;
				gint _tmp151_ = 0;
				GeeTimSortSlice* _tmp152_ = NULL;
				void* _tmp153_ = NULL;
				void* _tmp154_ = NULL;
				GeeTimSortSlice* _tmp155_ = NULL;
				gint _tmp156_ = 0;
				GeeTimSortSlice* _tmp177_ = NULL;
				void* _tmp178_ = NULL;
				GeeTimSortSlice* _tmp179_ = NULL;
				gint _tmp180_ = 0;
				GeeTimSortSlice* _tmp181_ = NULL;
				void** _tmp182_ = NULL;
				GeeTimSortSlice* _tmp183_ = NULL;
				gint _tmp184_ = 0;
				gint _tmp185_ = 0;
				gint _tmp186_ = 0;
				gint _tmp187_ = 0;
				gint _tmp188_ = 0;
				GeeTimSortSlice* _tmp189_ = NULL;
				gint _tmp190_ = 0;
				GeeTimSortSlice* _tmp191_ = NULL;
				gint _tmp192_ = 0;
				void** _tmp213_ = NULL;
				gint _tmp214_ = 0;
				GeeTimSortSlice* _tmp215_ = NULL;
				void* _tmp216_ = NULL;
				void* _tmp217_ = NULL;
				GeeTimSortSlice* _tmp218_ = NULL;
				gint _tmp219_ = 0;
				gboolean _tmp240_ = FALSE;
				gint _tmp241_ = 0;
				_tmp111_ = minimum_gallop;
				if (_tmp111_ > 1) {
					_tmp110_ = 1;
				} else {
					_tmp110_ = 0;
				}
				_tmp112_ = minimum_gallop;
				minimum_gallop = _tmp112_ - _tmp110_;
				_tmp113_ = minimum_gallop;
				self->priv->minimum_gallop = _tmp113_;
				_tmp114_ = b;
				_tmp115_ = gee_tim_sort_slice_peek_first (_tmp114_);
				_tmp116_ = a;
				_tmp117_ = gee_tim_sort_gallop_rightmost (self, _tmp115_, _tmp116_, 0);
				a_count = _tmp117_;
				_tmp118_ = a;
				_tmp119_ = self->priv->list;
				_tmp120_ = a;
				_tmp121_ = _tmp120_->index;
				_tmp122_ = dest;
				_tmp123_ = a_count;
				gee_tim_sort_slice_merge_in (_tmp118_, _tmp119_, _tmp121_, _tmp122_, _tmp123_);
				_tmp124_ = dest;
				_tmp125_ = a_count;
				dest = _tmp124_ + _tmp125_;
				_tmp126_ = a;
				_tmp127_ = a_count;
				gee_tim_sort_slice_shorten_start (_tmp126_, _tmp127_);
				_tmp128_ = a;
				_tmp129_ = _tmp128_->length;
				if (_tmp129_ <= 1) {
					{
						GeeTimSortSlice* _tmp130_ = NULL;
						gint _tmp131_ = 0;
						GeeTimSortSlice* _tmp132_ = NULL;
						gint _tmp133_ = 0;
						GeeTimSortSlice* _tmp134_ = NULL;
						void** _tmp135_ = NULL;
						GeeTimSortSlice* _tmp136_ = NULL;
						gint _tmp137_ = 0;
						gint _tmp138_ = 0;
						GeeTimSortSlice* _tmp139_ = NULL;
						gint _tmp140_ = 0;
						GeeTimSortSlice* _tmp141_ = NULL;
						void** _tmp142_ = NULL;
						GeeTimSortSlice* _tmp143_ = NULL;
						gint _tmp144_ = 0;
						gint _tmp145_ = 0;
						GeeTimSortSlice* _tmp146_ = NULL;
						gint _tmp147_ = 0;
						GeeTimSortSlice* _tmp148_ = NULL;
						gint _tmp149_ = 0;
						_tmp130_ = a;
						_tmp131_ = _tmp130_->length;
						_vala_assert (_tmp131_ >= 0, "a.length >= 0");
						_tmp132_ = b;
						_tmp133_ = _tmp132_->length;
						_vala_assert (_tmp133_ >= 0, "b.length >= 0");
						_tmp134_ = b;
						_tmp135_ = self->priv->list;
						_tmp136_ = b;
						_tmp137_ = _tmp136_->index;
						_tmp138_ = dest;
						_tmp139_ = b;
						_tmp140_ = _tmp139_->length;
						gee_tim_sort_slice_merge_in (_tmp134_, _tmp135_, _tmp137_, _tmp138_, _tmp140_);
						_tmp141_ = a;
						_tmp142_ = self->priv->list;
						_tmp143_ = a;
						_tmp144_ = _tmp143_->index;
						_tmp145_ = dest;
						_tmp146_ = b;
						_tmp147_ = _tmp146_->length;
						_tmp148_ = a;
						_tmp149_ = _tmp148_->length;
						gee_tim_sort_slice_merge_in (_tmp141_, _tmp142_, _tmp144_, _tmp145_ + _tmp147_, _tmp149_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp150_ = self->priv->list;
				_tmp151_ = dest;
				dest = _tmp151_ + 1;
				_tmp152_ = b;
				_tmp153_ = gee_tim_sort_slice_pop_first (_tmp152_);
				_tmp150_[_tmp151_] = _tmp153_;
				_tmp154_ = _tmp150_[_tmp151_];
				_tmp155_ = b;
				_tmp156_ = _tmp155_->length;
				if (_tmp156_ == 0) {
					{
						GeeTimSortSlice* _tmp157_ = NULL;
						gint _tmp158_ = 0;
						GeeTimSortSlice* _tmp159_ = NULL;
						gint _tmp160_ = 0;
						GeeTimSortSlice* _tmp161_ = NULL;
						void** _tmp162_ = NULL;
						GeeTimSortSlice* _tmp163_ = NULL;
						gint _tmp164_ = 0;
						gint _tmp165_ = 0;
						GeeTimSortSlice* _tmp166_ = NULL;
						gint _tmp167_ = 0;
						GeeTimSortSlice* _tmp168_ = NULL;
						void** _tmp169_ = NULL;
						GeeTimSortSlice* _tmp170_ = NULL;
						gint _tmp171_ = 0;
						gint _tmp172_ = 0;
						GeeTimSortSlice* _tmp173_ = NULL;
						gint _tmp174_ = 0;
						GeeTimSortSlice* _tmp175_ = NULL;
						gint _tmp176_ = 0;
						_tmp157_ = a;
						_tmp158_ = _tmp157_->length;
						_vala_assert (_tmp158_ >= 0, "a.length >= 0");
						_tmp159_ = b;
						_tmp160_ = _tmp159_->length;
						_vala_assert (_tmp160_ >= 0, "b.length >= 0");
						_tmp161_ = b;
						_tmp162_ = self->priv->list;
						_tmp163_ = b;
						_tmp164_ = _tmp163_->index;
						_tmp165_ = dest;
						_tmp166_ = b;
						_tmp167_ = _tmp166_->length;
						gee_tim_sort_slice_merge_in (_tmp161_, _tmp162_, _tmp164_, _tmp165_, _tmp167_);
						_tmp168_ = a;
						_tmp169_ = self->priv->list;
						_tmp170_ = a;
						_tmp171_ = _tmp170_->index;
						_tmp172_ = dest;
						_tmp173_ = b;
						_tmp174_ = _tmp173_->length;
						_tmp175_ = a;
						_tmp176_ = _tmp175_->length;
						gee_tim_sort_slice_merge_in (_tmp168_, _tmp169_, _tmp171_, _tmp172_ + _tmp174_, _tmp176_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp177_ = a;
				_tmp178_ = gee_tim_sort_slice_peek_first (_tmp177_);
				_tmp179_ = b;
				_tmp180_ = gee_tim_sort_gallop_leftmost (self, _tmp178_, _tmp179_, 0);
				b_count = _tmp180_;
				_tmp181_ = b;
				_tmp182_ = self->priv->list;
				_tmp183_ = b;
				_tmp184_ = _tmp183_->index;
				_tmp185_ = dest;
				_tmp186_ = b_count;
				gee_tim_sort_slice_merge_in (_tmp181_, _tmp182_, _tmp184_, _tmp185_, _tmp186_);
				_tmp187_ = dest;
				_tmp188_ = b_count;
				dest = _tmp187_ + _tmp188_;
				_tmp189_ = b;
				_tmp190_ = b_count;
				gee_tim_sort_slice_shorten_start (_tmp189_, _tmp190_);
				_tmp191_ = b;
				_tmp192_ = _tmp191_->length;
				if (_tmp192_ == 0) {
					{
						GeeTimSortSlice* _tmp193_ = NULL;
						gint _tmp194_ = 0;
						GeeTimSortSlice* _tmp195_ = NULL;
						gint _tmp196_ = 0;
						GeeTimSortSlice* _tmp197_ = NULL;
						void** _tmp198_ = NULL;
						GeeTimSortSlice* _tmp199_ = NULL;
						gint _tmp200_ = 0;
						gint _tmp201_ = 0;
						GeeTimSortSlice* _tmp202_ = NULL;
						gint _tmp203_ = 0;
						GeeTimSortSlice* _tmp204_ = NULL;
						void** _tmp205_ = NULL;
						GeeTimSortSlice* _tmp206_ = NULL;
						gint _tmp207_ = 0;
						gint _tmp208_ = 0;
						GeeTimSortSlice* _tmp209_ = NULL;
						gint _tmp210_ = 0;
						GeeTimSortSlice* _tmp211_ = NULL;
						gint _tmp212_ = 0;
						_tmp193_ = a;
						_tmp194_ = _tmp193_->length;
						_vala_assert (_tmp194_ >= 0, "a.length >= 0");
						_tmp195_ = b;
						_tmp196_ = _tmp195_->length;
						_vala_assert (_tmp196_ >= 0, "b.length >= 0");
						_tmp197_ = b;
						_tmp198_ = self->priv->list;
						_tmp199_ = b;
						_tmp200_ = _tmp199_->index;
						_tmp201_ = dest;
						_tmp202_ = b;
						_tmp203_ = _tmp202_->length;
						gee_tim_sort_slice_merge_in (_tmp197_, _tmp198_, _tmp200_, _tmp201_, _tmp203_);
						_tmp204_ = a;
						_tmp205_ = self->priv->list;
						_tmp206_ = a;
						_tmp207_ = _tmp206_->index;
						_tmp208_ = dest;
						_tmp209_ = b;
						_tmp210_ = _tmp209_->length;
						_tmp211_ = a;
						_tmp212_ = _tmp211_->length;
						gee_tim_sort_slice_merge_in (_tmp204_, _tmp205_, _tmp207_, _tmp208_ + _tmp210_, _tmp212_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp213_ = self->priv->list;
				_tmp214_ = dest;
				dest = _tmp214_ + 1;
				_tmp215_ = a;
				_tmp216_ = gee_tim_sort_slice_pop_first (_tmp215_);
				_tmp213_[_tmp214_] = _tmp216_;
				_tmp217_ = _tmp213_[_tmp214_];
				_tmp218_ = a;
				_tmp219_ = _tmp218_->length;
				if (_tmp219_ == 1) {
					{
						GeeTimSortSlice* _tmp220_ = NULL;
						gint _tmp221_ = 0;
						GeeTimSortSlice* _tmp222_ = NULL;
						gint _tmp223_ = 0;
						GeeTimSortSlice* _tmp224_ = NULL;
						void** _tmp225_ = NULL;
						GeeTimSortSlice* _tmp226_ = NULL;
						gint _tmp227_ = 0;
						gint _tmp228_ = 0;
						GeeTimSortSlice* _tmp229_ = NULL;
						gint _tmp230_ = 0;
						GeeTimSortSlice* _tmp231_ = NULL;
						void** _tmp232_ = NULL;
						GeeTimSortSlice* _tmp233_ = NULL;
						gint _tmp234_ = 0;
						gint _tmp235_ = 0;
						GeeTimSortSlice* _tmp236_ = NULL;
						gint _tmp237_ = 0;
						GeeTimSortSlice* _tmp238_ = NULL;
						gint _tmp239_ = 0;
						_tmp220_ = a;
						_tmp221_ = _tmp220_->length;
						_vala_assert (_tmp221_ >= 0, "a.length >= 0");
						_tmp222_ = b;
						_tmp223_ = _tmp222_->length;
						_vala_assert (_tmp223_ >= 0, "b.length >= 0");
						_tmp224_ = b;
						_tmp225_ = self->priv->list;
						_tmp226_ = b;
						_tmp227_ = _tmp226_->index;
						_tmp228_ = dest;
						_tmp229_ = b;
						_tmp230_ = _tmp229_->length;
						gee_tim_sort_slice_merge_in (_tmp224_, _tmp225_, _tmp227_, _tmp228_, _tmp230_);
						_tmp231_ = a;
						_tmp232_ = self->priv->list;
						_tmp233_ = a;
						_tmp234_ = _tmp233_->index;
						_tmp235_ = dest;
						_tmp236_ = b;
						_tmp237_ = _tmp236_->length;
						_tmp238_ = a;
						_tmp239_ = _tmp238_->length;
						gee_tim_sort_slice_merge_in (_tmp231_, _tmp232_, _tmp234_, _tmp235_ + _tmp237_, _tmp239_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp241_ = a_count;
				if (_tmp241_ < GEE_TIM_SORT_MINIMUM_GALLOP) {
					gint _tmp242_ = 0;
					_tmp242_ = b_count;
					_tmp240_ = _tmp242_ < GEE_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp240_ = FALSE;
				}
				if (_tmp240_) {
					break;
				}
			}
			_tmp243_ = minimum_gallop;
			minimum_gallop = _tmp243_ + 1;
			_tmp244_ = minimum_gallop;
			self->priv->minimum_gallop = _tmp244_;
		}
	}
	__finally5:
	{
		GeeTimSortSlice* _tmp245_ = NULL;
		gint _tmp246_ = 0;
		GeeTimSortSlice* _tmp247_ = NULL;
		gint _tmp248_ = 0;
		GeeTimSortSlice* _tmp249_ = NULL;
		void** _tmp250_ = NULL;
		GeeTimSortSlice* _tmp251_ = NULL;
		gint _tmp252_ = 0;
		gint _tmp253_ = 0;
		GeeTimSortSlice* _tmp254_ = NULL;
		gint _tmp255_ = 0;
		GeeTimSortSlice* _tmp256_ = NULL;
		void** _tmp257_ = NULL;
		GeeTimSortSlice* _tmp258_ = NULL;
		gint _tmp259_ = 0;
		gint _tmp260_ = 0;
		GeeTimSortSlice* _tmp261_ = NULL;
		gint _tmp262_ = 0;
		GeeTimSortSlice* _tmp263_ = NULL;
		gint _tmp264_ = 0;
		_tmp245_ = a;
		_tmp246_ = _tmp245_->length;
		_vala_assert (_tmp246_ >= 0, "a.length >= 0");
		_tmp247_ = b;
		_tmp248_ = _tmp247_->length;
		_vala_assert (_tmp248_ >= 0, "b.length >= 0");
		_tmp249_ = b;
		_tmp250_ = self->priv->list;
		_tmp251_ = b;
		_tmp252_ = _tmp251_->index;
		_tmp253_ = dest;
		_tmp254_ = b;
		_tmp255_ = _tmp254_->length;
		gee_tim_sort_slice_merge_in (_tmp249_, _tmp250_, _tmp252_, _tmp253_, _tmp255_);
		_tmp256_ = a;
		_tmp257_ = self->priv->list;
		_tmp258_ = a;
		_tmp259_ = _tmp258_->index;
		_tmp260_ = dest;
		_tmp261_ = b;
		_tmp262_ = _tmp261_->length;
		_tmp263_ = a;
		_tmp264_ = _tmp263_->length;
		gee_tim_sort_slice_merge_in (_tmp256_, _tmp257_, _tmp259_, _tmp260_ + _tmp262_, _tmp264_);
	}
	_gee_tim_sort_slice_free0 (a);
	_gee_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


static void gee_tim_sort_merge_high (GeeTimSort* self, GeeTimSortSlice* a, GeeTimSortSlice* b) {
	GeeTimSortSlice* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeTimSortSlice* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GeeTimSortSlice* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GeeTimSortSlice* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GeeTimSortSlice* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint minimum_gallop = 0;
	gint _tmp10_ = 0;
	gint dest = 0;
	GeeTimSortSlice* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GeeTimSortSlice* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GeeTimSortSlice* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->length;
	_vala_assert (_tmp1_ > 0, "a.length > 0");
	_tmp2_ = b;
	_tmp3_ = _tmp2_->length;
	_vala_assert (_tmp3_ > 0, "b.length > 0");
	_tmp4_ = a;
	_tmp5_ = _tmp4_->index;
	_tmp6_ = a;
	_tmp7_ = _tmp6_->length;
	_tmp8_ = b;
	_tmp9_ = _tmp8_->index;
	_vala_assert ((_tmp5_ + _tmp7_) == _tmp9_, "a.index + a.length == b.index");
	_tmp10_ = self->priv->minimum_gallop;
	minimum_gallop = _tmp10_;
	_tmp11_ = b;
	_tmp12_ = _tmp11_->index;
	_tmp13_ = b;
	_tmp14_ = _tmp13_->length;
	dest = _tmp12_ + _tmp14_;
	_tmp15_ = b;
	gee_tim_sort_slice_copy (_tmp15_);
	{
		void** _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		GeeTimSortSlice* _tmp19_ = NULL;
		void* _tmp20_ = NULL;
		void* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		GeeTimSortSlice* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		_tmp16_ = self->priv->list;
		_tmp17_ = dest;
		dest = _tmp17_ - 1;
		_tmp18_ = dest;
		_tmp19_ = a;
		_tmp20_ = gee_tim_sort_slice_pop_last (_tmp19_);
		_tmp16_[_tmp18_] = _tmp20_;
		_tmp21_ = _tmp16_[_tmp18_];
		_tmp23_ = a;
		_tmp24_ = _tmp23_->length;
		if (_tmp24_ == 0) {
			_tmp22_ = TRUE;
		} else {
			GeeTimSortSlice* _tmp25_ = NULL;
			gint _tmp26_ = 0;
			_tmp25_ = b;
			_tmp26_ = _tmp25_->length;
			_tmp22_ = _tmp26_ == 1;
		}
		if (_tmp22_) {
			{
				GeeTimSortSlice* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				GeeTimSortSlice* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				GeeTimSortSlice* _tmp31_ = NULL;
				void** _tmp32_ = NULL;
				GeeTimSortSlice* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				GeeTimSortSlice* _tmp36_ = NULL;
				gint _tmp37_ = 0;
				GeeTimSortSlice* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				GeeTimSortSlice* _tmp40_ = NULL;
				void** _tmp41_ = NULL;
				GeeTimSortSlice* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				GeeTimSortSlice* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				GeeTimSortSlice* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				GeeTimSortSlice* _tmp49_ = NULL;
				gint _tmp50_ = 0;
				_tmp27_ = a;
				_tmp28_ = _tmp27_->length;
				_vala_assert (_tmp28_ >= 0, "a.length >= 0");
				_tmp29_ = b;
				_tmp30_ = _tmp29_->length;
				_vala_assert (_tmp30_ >= 0, "b.length >= 0");
				_tmp31_ = a;
				_tmp32_ = self->priv->list;
				_tmp33_ = a;
				_tmp34_ = _tmp33_->index;
				_tmp35_ = dest;
				_tmp36_ = a;
				_tmp37_ = _tmp36_->length;
				_tmp38_ = a;
				_tmp39_ = _tmp38_->length;
				gee_tim_sort_slice_merge_in_reversed (_tmp31_, _tmp32_, _tmp34_, _tmp35_ - _tmp37_, _tmp39_);
				_tmp40_ = b;
				_tmp41_ = self->priv->list;
				_tmp42_ = b;
				_tmp43_ = _tmp42_->index;
				_tmp44_ = dest;
				_tmp45_ = a;
				_tmp46_ = _tmp45_->length;
				_tmp47_ = b;
				_tmp48_ = _tmp47_->length;
				_tmp49_ = b;
				_tmp50_ = _tmp49_->length;
				gee_tim_sort_slice_merge_in_reversed (_tmp40_, _tmp41_, _tmp43_, (_tmp44_ - _tmp46_) - _tmp48_, _tmp50_);
			}
			_gee_tim_sort_slice_free0 (a);
			_gee_tim_sort_slice_free0 (b);
			return;
		}
		while (TRUE) {
			gint a_count = 0;
			gint b_count = 0;
			gint _tmp126_ = 0;
			gint _tmp292_ = 0;
			gint _tmp293_ = 0;
			a_count = 0;
			b_count = 0;
			while (TRUE) {
				GeeTimSortSlice* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				GeeTimSortSlice* _tmp53_ = NULL;
				void* _tmp54_ = NULL;
				gboolean _tmp55_ = FALSE;
				_tmp51_ = b;
				_tmp52_ = gee_tim_sort_slice_peek_last (_tmp51_);
				_tmp53_ = a;
				_tmp54_ = gee_tim_sort_slice_peek_last (_tmp53_);
				_tmp55_ = gee_tim_sort_lower_than (self, _tmp52_, _tmp54_);
				if (_tmp55_) {
					void** _tmp56_ = NULL;
					gint _tmp57_ = 0;
					gint _tmp58_ = 0;
					GeeTimSortSlice* _tmp59_ = NULL;
					void* _tmp60_ = NULL;
					void* _tmp61_ = NULL;
					GeeTimSortSlice* _tmp62_ = NULL;
					gint _tmp63_ = 0;
					gint _tmp88_ = 0;
					gint _tmp89_ = 0;
					gint _tmp90_ = 0;
					_tmp56_ = self->priv->list;
					_tmp57_ = dest;
					dest = _tmp57_ - 1;
					_tmp58_ = dest;
					_tmp59_ = a;
					_tmp60_ = gee_tim_sort_slice_pop_last (_tmp59_);
					_tmp56_[_tmp58_] = _tmp60_;
					_tmp61_ = _tmp56_[_tmp58_];
					_tmp62_ = a;
					_tmp63_ = _tmp62_->length;
					if (_tmp63_ == 0) {
						{
							GeeTimSortSlice* _tmp64_ = NULL;
							gint _tmp65_ = 0;
							GeeTimSortSlice* _tmp66_ = NULL;
							gint _tmp67_ = 0;
							GeeTimSortSlice* _tmp68_ = NULL;
							void** _tmp69_ = NULL;
							GeeTimSortSlice* _tmp70_ = NULL;
							gint _tmp71_ = 0;
							gint _tmp72_ = 0;
							GeeTimSortSlice* _tmp73_ = NULL;
							gint _tmp74_ = 0;
							GeeTimSortSlice* _tmp75_ = NULL;
							gint _tmp76_ = 0;
							GeeTimSortSlice* _tmp77_ = NULL;
							void** _tmp78_ = NULL;
							GeeTimSortSlice* _tmp79_ = NULL;
							gint _tmp80_ = 0;
							gint _tmp81_ = 0;
							GeeTimSortSlice* _tmp82_ = NULL;
							gint _tmp83_ = 0;
							GeeTimSortSlice* _tmp84_ = NULL;
							gint _tmp85_ = 0;
							GeeTimSortSlice* _tmp86_ = NULL;
							gint _tmp87_ = 0;
							_tmp64_ = a;
							_tmp65_ = _tmp64_->length;
							_vala_assert (_tmp65_ >= 0, "a.length >= 0");
							_tmp66_ = b;
							_tmp67_ = _tmp66_->length;
							_vala_assert (_tmp67_ >= 0, "b.length >= 0");
							_tmp68_ = a;
							_tmp69_ = self->priv->list;
							_tmp70_ = a;
							_tmp71_ = _tmp70_->index;
							_tmp72_ = dest;
							_tmp73_ = a;
							_tmp74_ = _tmp73_->length;
							_tmp75_ = a;
							_tmp76_ = _tmp75_->length;
							gee_tim_sort_slice_merge_in_reversed (_tmp68_, _tmp69_, _tmp71_, _tmp72_ - _tmp74_, _tmp76_);
							_tmp77_ = b;
							_tmp78_ = self->priv->list;
							_tmp79_ = b;
							_tmp80_ = _tmp79_->index;
							_tmp81_ = dest;
							_tmp82_ = a;
							_tmp83_ = _tmp82_->length;
							_tmp84_ = b;
							_tmp85_ = _tmp84_->length;
							_tmp86_ = b;
							_tmp87_ = _tmp86_->length;
							gee_tim_sort_slice_merge_in_reversed (_tmp77_, _tmp78_, _tmp80_, (_tmp81_ - _tmp83_) - _tmp85_, _tmp87_);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp88_ = a_count;
					a_count = _tmp88_ + 1;
					b_count = 0;
					_tmp89_ = a_count;
					_tmp90_ = minimum_gallop;
					if (_tmp89_ >= _tmp90_) {
						break;
					}
				} else {
					void** _tmp91_ = NULL;
					gint _tmp92_ = 0;
					gint _tmp93_ = 0;
					GeeTimSortSlice* _tmp94_ = NULL;
					void* _tmp95_ = NULL;
					void* _tmp96_ = NULL;
					GeeTimSortSlice* _tmp97_ = NULL;
					gint _tmp98_ = 0;
					gint _tmp123_ = 0;
					gint _tmp124_ = 0;
					gint _tmp125_ = 0;
					_tmp91_ = self->priv->list;
					_tmp92_ = dest;
					dest = _tmp92_ - 1;
					_tmp93_ = dest;
					_tmp94_ = b;
					_tmp95_ = gee_tim_sort_slice_pop_last (_tmp94_);
					_tmp91_[_tmp93_] = _tmp95_;
					_tmp96_ = _tmp91_[_tmp93_];
					_tmp97_ = b;
					_tmp98_ = _tmp97_->length;
					if (_tmp98_ == 1) {
						{
							GeeTimSortSlice* _tmp99_ = NULL;
							gint _tmp100_ = 0;
							GeeTimSortSlice* _tmp101_ = NULL;
							gint _tmp102_ = 0;
							GeeTimSortSlice* _tmp103_ = NULL;
							void** _tmp104_ = NULL;
							GeeTimSortSlice* _tmp105_ = NULL;
							gint _tmp106_ = 0;
							gint _tmp107_ = 0;
							GeeTimSortSlice* _tmp108_ = NULL;
							gint _tmp109_ = 0;
							GeeTimSortSlice* _tmp110_ = NULL;
							gint _tmp111_ = 0;
							GeeTimSortSlice* _tmp112_ = NULL;
							void** _tmp113_ = NULL;
							GeeTimSortSlice* _tmp114_ = NULL;
							gint _tmp115_ = 0;
							gint _tmp116_ = 0;
							GeeTimSortSlice* _tmp117_ = NULL;
							gint _tmp118_ = 0;
							GeeTimSortSlice* _tmp119_ = NULL;
							gint _tmp120_ = 0;
							GeeTimSortSlice* _tmp121_ = NULL;
							gint _tmp122_ = 0;
							_tmp99_ = a;
							_tmp100_ = _tmp99_->length;
							_vala_assert (_tmp100_ >= 0, "a.length >= 0");
							_tmp101_ = b;
							_tmp102_ = _tmp101_->length;
							_vala_assert (_tmp102_ >= 0, "b.length >= 0");
							_tmp103_ = a;
							_tmp104_ = self->priv->list;
							_tmp105_ = a;
							_tmp106_ = _tmp105_->index;
							_tmp107_ = dest;
							_tmp108_ = a;
							_tmp109_ = _tmp108_->length;
							_tmp110_ = a;
							_tmp111_ = _tmp110_->length;
							gee_tim_sort_slice_merge_in_reversed (_tmp103_, _tmp104_, _tmp106_, _tmp107_ - _tmp109_, _tmp111_);
							_tmp112_ = b;
							_tmp113_ = self->priv->list;
							_tmp114_ = b;
							_tmp115_ = _tmp114_->index;
							_tmp116_ = dest;
							_tmp117_ = a;
							_tmp118_ = _tmp117_->length;
							_tmp119_ = b;
							_tmp120_ = _tmp119_->length;
							_tmp121_ = b;
							_tmp122_ = _tmp121_->length;
							gee_tim_sort_slice_merge_in_reversed (_tmp112_, _tmp113_, _tmp115_, (_tmp116_ - _tmp118_) - _tmp120_, _tmp122_);
						}
						_gee_tim_sort_slice_free0 (a);
						_gee_tim_sort_slice_free0 (b);
						return;
					}
					_tmp123_ = b_count;
					b_count = _tmp123_ + 1;
					a_count = 0;
					_tmp124_ = b_count;
					_tmp125_ = minimum_gallop;
					if (_tmp124_ >= _tmp125_) {
						break;
					}
				}
			}
			_tmp126_ = minimum_gallop;
			minimum_gallop = _tmp126_ + 1;
			while (TRUE) {
				gint _tmp127_ = 0;
				gint _tmp128_ = 0;
				gint _tmp129_ = 0;
				gint _tmp130_ = 0;
				gint k = 0;
				GeeTimSortSlice* _tmp131_ = NULL;
				void* _tmp132_ = NULL;
				GeeTimSortSlice* _tmp133_ = NULL;
				GeeTimSortSlice* _tmp134_ = NULL;
				gint _tmp135_ = 0;
				gint _tmp136_ = 0;
				GeeTimSortSlice* _tmp137_ = NULL;
				gint _tmp138_ = 0;
				gint _tmp139_ = 0;
				GeeTimSortSlice* _tmp140_ = NULL;
				void** _tmp141_ = NULL;
				GeeTimSortSlice* _tmp142_ = NULL;
				gint _tmp143_ = 0;
				gint _tmp144_ = 0;
				gint _tmp145_ = 0;
				gint _tmp146_ = 0;
				gint _tmp147_ = 0;
				gint _tmp148_ = 0;
				gint _tmp149_ = 0;
				GeeTimSortSlice* _tmp150_ = NULL;
				gint _tmp151_ = 0;
				GeeTimSortSlice* _tmp152_ = NULL;
				gint _tmp153_ = 0;
				void** _tmp178_ = NULL;
				gint _tmp179_ = 0;
				gint _tmp180_ = 0;
				GeeTimSortSlice* _tmp181_ = NULL;
				void* _tmp182_ = NULL;
				void* _tmp183_ = NULL;
				GeeTimSortSlice* _tmp184_ = NULL;
				gint _tmp185_ = 0;
				GeeTimSortSlice* _tmp210_ = NULL;
				void* _tmp211_ = NULL;
				GeeTimSortSlice* _tmp212_ = NULL;
				GeeTimSortSlice* _tmp213_ = NULL;
				gint _tmp214_ = 0;
				gint _tmp215_ = 0;
				GeeTimSortSlice* _tmp216_ = NULL;
				gint _tmp217_ = 0;
				gint _tmp218_ = 0;
				GeeTimSortSlice* _tmp219_ = NULL;
				void** _tmp220_ = NULL;
				GeeTimSortSlice* _tmp221_ = NULL;
				gint _tmp222_ = 0;
				gint _tmp223_ = 0;
				gint _tmp224_ = 0;
				gint _tmp225_ = 0;
				gint _tmp226_ = 0;
				gint _tmp227_ = 0;
				gint _tmp228_ = 0;
				GeeTimSortSlice* _tmp229_ = NULL;
				gint _tmp230_ = 0;
				GeeTimSortSlice* _tmp231_ = NULL;
				gint _tmp232_ = 0;
				void** _tmp257_ = NULL;
				gint _tmp258_ = 0;
				gint _tmp259_ = 0;
				GeeTimSortSlice* _tmp260_ = NULL;
				void* _tmp261_ = NULL;
				void* _tmp262_ = NULL;
				GeeTimSortSlice* _tmp263_ = NULL;
				gint _tmp264_ = 0;
				gboolean _tmp289_ = FALSE;
				gint _tmp290_ = 0;
				_tmp128_ = minimum_gallop;
				if (_tmp128_ > 1) {
					_tmp127_ = 1;
				} else {
					_tmp127_ = 0;
				}
				_tmp129_ = minimum_gallop;
				minimum_gallop = _tmp129_ - _tmp127_;
				_tmp130_ = minimum_gallop;
				self->priv->minimum_gallop = _tmp130_;
				_tmp131_ = b;
				_tmp132_ = gee_tim_sort_slice_peek_last (_tmp131_);
				_tmp133_ = a;
				_tmp134_ = a;
				_tmp135_ = _tmp134_->length;
				_tmp136_ = gee_tim_sort_gallop_rightmost (self, _tmp132_, _tmp133_, _tmp135_ - 1);
				k = _tmp136_;
				_tmp137_ = a;
				_tmp138_ = _tmp137_->length;
				_tmp139_ = k;
				a_count = _tmp138_ - _tmp139_;
				_tmp140_ = a;
				_tmp141_ = self->priv->list;
				_tmp142_ = a;
				_tmp143_ = _tmp142_->index;
				_tmp144_ = k;
				_tmp145_ = dest;
				_tmp146_ = a_count;
				_tmp147_ = a_count;
				gee_tim_sort_slice_merge_in_reversed (_tmp140_, _tmp141_, _tmp143_ + _tmp144_, _tmp145_ - _tmp146_, _tmp147_);
				_tmp148_ = dest;
				_tmp149_ = a_count;
				dest = _tmp148_ - _tmp149_;
				_tmp150_ = a;
				_tmp151_ = a_count;
				gee_tim_sort_slice_shorten_end (_tmp150_, _tmp151_);
				_tmp152_ = a;
				_tmp153_ = _tmp152_->length;
				if (_tmp153_ == 0) {
					{
						GeeTimSortSlice* _tmp154_ = NULL;
						gint _tmp155_ = 0;
						GeeTimSortSlice* _tmp156_ = NULL;
						gint _tmp157_ = 0;
						GeeTimSortSlice* _tmp158_ = NULL;
						void** _tmp159_ = NULL;
						GeeTimSortSlice* _tmp160_ = NULL;
						gint _tmp161_ = 0;
						gint _tmp162_ = 0;
						GeeTimSortSlice* _tmp163_ = NULL;
						gint _tmp164_ = 0;
						GeeTimSortSlice* _tmp165_ = NULL;
						gint _tmp166_ = 0;
						GeeTimSortSlice* _tmp167_ = NULL;
						void** _tmp168_ = NULL;
						GeeTimSortSlice* _tmp169_ = NULL;
						gint _tmp170_ = 0;
						gint _tmp171_ = 0;
						GeeTimSortSlice* _tmp172_ = NULL;
						gint _tmp173_ = 0;
						GeeTimSortSlice* _tmp174_ = NULL;
						gint _tmp175_ = 0;
						GeeTimSortSlice* _tmp176_ = NULL;
						gint _tmp177_ = 0;
						_tmp154_ = a;
						_tmp155_ = _tmp154_->length;
						_vala_assert (_tmp155_ >= 0, "a.length >= 0");
						_tmp156_ = b;
						_tmp157_ = _tmp156_->length;
						_vala_assert (_tmp157_ >= 0, "b.length >= 0");
						_tmp158_ = a;
						_tmp159_ = self->priv->list;
						_tmp160_ = a;
						_tmp161_ = _tmp160_->index;
						_tmp162_ = dest;
						_tmp163_ = a;
						_tmp164_ = _tmp163_->length;
						_tmp165_ = a;
						_tmp166_ = _tmp165_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp158_, _tmp159_, _tmp161_, _tmp162_ - _tmp164_, _tmp166_);
						_tmp167_ = b;
						_tmp168_ = self->priv->list;
						_tmp169_ = b;
						_tmp170_ = _tmp169_->index;
						_tmp171_ = dest;
						_tmp172_ = a;
						_tmp173_ = _tmp172_->length;
						_tmp174_ = b;
						_tmp175_ = _tmp174_->length;
						_tmp176_ = b;
						_tmp177_ = _tmp176_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp167_, _tmp168_, _tmp170_, (_tmp171_ - _tmp173_) - _tmp175_, _tmp177_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp178_ = self->priv->list;
				_tmp179_ = dest;
				dest = _tmp179_ - 1;
				_tmp180_ = dest;
				_tmp181_ = b;
				_tmp182_ = gee_tim_sort_slice_pop_last (_tmp181_);
				_tmp178_[_tmp180_] = _tmp182_;
				_tmp183_ = _tmp178_[_tmp180_];
				_tmp184_ = b;
				_tmp185_ = _tmp184_->length;
				if (_tmp185_ == 1) {
					{
						GeeTimSortSlice* _tmp186_ = NULL;
						gint _tmp187_ = 0;
						GeeTimSortSlice* _tmp188_ = NULL;
						gint _tmp189_ = 0;
						GeeTimSortSlice* _tmp190_ = NULL;
						void** _tmp191_ = NULL;
						GeeTimSortSlice* _tmp192_ = NULL;
						gint _tmp193_ = 0;
						gint _tmp194_ = 0;
						GeeTimSortSlice* _tmp195_ = NULL;
						gint _tmp196_ = 0;
						GeeTimSortSlice* _tmp197_ = NULL;
						gint _tmp198_ = 0;
						GeeTimSortSlice* _tmp199_ = NULL;
						void** _tmp200_ = NULL;
						GeeTimSortSlice* _tmp201_ = NULL;
						gint _tmp202_ = 0;
						gint _tmp203_ = 0;
						GeeTimSortSlice* _tmp204_ = NULL;
						gint _tmp205_ = 0;
						GeeTimSortSlice* _tmp206_ = NULL;
						gint _tmp207_ = 0;
						GeeTimSortSlice* _tmp208_ = NULL;
						gint _tmp209_ = 0;
						_tmp186_ = a;
						_tmp187_ = _tmp186_->length;
						_vala_assert (_tmp187_ >= 0, "a.length >= 0");
						_tmp188_ = b;
						_tmp189_ = _tmp188_->length;
						_vala_assert (_tmp189_ >= 0, "b.length >= 0");
						_tmp190_ = a;
						_tmp191_ = self->priv->list;
						_tmp192_ = a;
						_tmp193_ = _tmp192_->index;
						_tmp194_ = dest;
						_tmp195_ = a;
						_tmp196_ = _tmp195_->length;
						_tmp197_ = a;
						_tmp198_ = _tmp197_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp190_, _tmp191_, _tmp193_, _tmp194_ - _tmp196_, _tmp198_);
						_tmp199_ = b;
						_tmp200_ = self->priv->list;
						_tmp201_ = b;
						_tmp202_ = _tmp201_->index;
						_tmp203_ = dest;
						_tmp204_ = a;
						_tmp205_ = _tmp204_->length;
						_tmp206_ = b;
						_tmp207_ = _tmp206_->length;
						_tmp208_ = b;
						_tmp209_ = _tmp208_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp199_, _tmp200_, _tmp202_, (_tmp203_ - _tmp205_) - _tmp207_, _tmp209_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp210_ = a;
				_tmp211_ = gee_tim_sort_slice_peek_last (_tmp210_);
				_tmp212_ = b;
				_tmp213_ = b;
				_tmp214_ = _tmp213_->length;
				_tmp215_ = gee_tim_sort_gallop_leftmost (self, _tmp211_, _tmp212_, _tmp214_ - 1);
				k = _tmp215_;
				_tmp216_ = b;
				_tmp217_ = _tmp216_->length;
				_tmp218_ = k;
				b_count = _tmp217_ - _tmp218_;
				_tmp219_ = b;
				_tmp220_ = self->priv->list;
				_tmp221_ = b;
				_tmp222_ = _tmp221_->index;
				_tmp223_ = k;
				_tmp224_ = dest;
				_tmp225_ = b_count;
				_tmp226_ = b_count;
				gee_tim_sort_slice_merge_in_reversed (_tmp219_, _tmp220_, _tmp222_ + _tmp223_, _tmp224_ - _tmp225_, _tmp226_);
				_tmp227_ = dest;
				_tmp228_ = b_count;
				dest = _tmp227_ - _tmp228_;
				_tmp229_ = b;
				_tmp230_ = b_count;
				gee_tim_sort_slice_shorten_end (_tmp229_, _tmp230_);
				_tmp231_ = b;
				_tmp232_ = _tmp231_->length;
				if (_tmp232_ <= 1) {
					{
						GeeTimSortSlice* _tmp233_ = NULL;
						gint _tmp234_ = 0;
						GeeTimSortSlice* _tmp235_ = NULL;
						gint _tmp236_ = 0;
						GeeTimSortSlice* _tmp237_ = NULL;
						void** _tmp238_ = NULL;
						GeeTimSortSlice* _tmp239_ = NULL;
						gint _tmp240_ = 0;
						gint _tmp241_ = 0;
						GeeTimSortSlice* _tmp242_ = NULL;
						gint _tmp243_ = 0;
						GeeTimSortSlice* _tmp244_ = NULL;
						gint _tmp245_ = 0;
						GeeTimSortSlice* _tmp246_ = NULL;
						void** _tmp247_ = NULL;
						GeeTimSortSlice* _tmp248_ = NULL;
						gint _tmp249_ = 0;
						gint _tmp250_ = 0;
						GeeTimSortSlice* _tmp251_ = NULL;
						gint _tmp252_ = 0;
						GeeTimSortSlice* _tmp253_ = NULL;
						gint _tmp254_ = 0;
						GeeTimSortSlice* _tmp255_ = NULL;
						gint _tmp256_ = 0;
						_tmp233_ = a;
						_tmp234_ = _tmp233_->length;
						_vala_assert (_tmp234_ >= 0, "a.length >= 0");
						_tmp235_ = b;
						_tmp236_ = _tmp235_->length;
						_vala_assert (_tmp236_ >= 0, "b.length >= 0");
						_tmp237_ = a;
						_tmp238_ = self->priv->list;
						_tmp239_ = a;
						_tmp240_ = _tmp239_->index;
						_tmp241_ = dest;
						_tmp242_ = a;
						_tmp243_ = _tmp242_->length;
						_tmp244_ = a;
						_tmp245_ = _tmp244_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp237_, _tmp238_, _tmp240_, _tmp241_ - _tmp243_, _tmp245_);
						_tmp246_ = b;
						_tmp247_ = self->priv->list;
						_tmp248_ = b;
						_tmp249_ = _tmp248_->index;
						_tmp250_ = dest;
						_tmp251_ = a;
						_tmp252_ = _tmp251_->length;
						_tmp253_ = b;
						_tmp254_ = _tmp253_->length;
						_tmp255_ = b;
						_tmp256_ = _tmp255_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp246_, _tmp247_, _tmp249_, (_tmp250_ - _tmp252_) - _tmp254_, _tmp256_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp257_ = self->priv->list;
				_tmp258_ = dest;
				dest = _tmp258_ - 1;
				_tmp259_ = dest;
				_tmp260_ = a;
				_tmp261_ = gee_tim_sort_slice_pop_last (_tmp260_);
				_tmp257_[_tmp259_] = _tmp261_;
				_tmp262_ = _tmp257_[_tmp259_];
				_tmp263_ = a;
				_tmp264_ = _tmp263_->length;
				if (_tmp264_ == 0) {
					{
						GeeTimSortSlice* _tmp265_ = NULL;
						gint _tmp266_ = 0;
						GeeTimSortSlice* _tmp267_ = NULL;
						gint _tmp268_ = 0;
						GeeTimSortSlice* _tmp269_ = NULL;
						void** _tmp270_ = NULL;
						GeeTimSortSlice* _tmp271_ = NULL;
						gint _tmp272_ = 0;
						gint _tmp273_ = 0;
						GeeTimSortSlice* _tmp274_ = NULL;
						gint _tmp275_ = 0;
						GeeTimSortSlice* _tmp276_ = NULL;
						gint _tmp277_ = 0;
						GeeTimSortSlice* _tmp278_ = NULL;
						void** _tmp279_ = NULL;
						GeeTimSortSlice* _tmp280_ = NULL;
						gint _tmp281_ = 0;
						gint _tmp282_ = 0;
						GeeTimSortSlice* _tmp283_ = NULL;
						gint _tmp284_ = 0;
						GeeTimSortSlice* _tmp285_ = NULL;
						gint _tmp286_ = 0;
						GeeTimSortSlice* _tmp287_ = NULL;
						gint _tmp288_ = 0;
						_tmp265_ = a;
						_tmp266_ = _tmp265_->length;
						_vala_assert (_tmp266_ >= 0, "a.length >= 0");
						_tmp267_ = b;
						_tmp268_ = _tmp267_->length;
						_vala_assert (_tmp268_ >= 0, "b.length >= 0");
						_tmp269_ = a;
						_tmp270_ = self->priv->list;
						_tmp271_ = a;
						_tmp272_ = _tmp271_->index;
						_tmp273_ = dest;
						_tmp274_ = a;
						_tmp275_ = _tmp274_->length;
						_tmp276_ = a;
						_tmp277_ = _tmp276_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp269_, _tmp270_, _tmp272_, _tmp273_ - _tmp275_, _tmp277_);
						_tmp278_ = b;
						_tmp279_ = self->priv->list;
						_tmp280_ = b;
						_tmp281_ = _tmp280_->index;
						_tmp282_ = dest;
						_tmp283_ = a;
						_tmp284_ = _tmp283_->length;
						_tmp285_ = b;
						_tmp286_ = _tmp285_->length;
						_tmp287_ = b;
						_tmp288_ = _tmp287_->length;
						gee_tim_sort_slice_merge_in_reversed (_tmp278_, _tmp279_, _tmp281_, (_tmp282_ - _tmp284_) - _tmp286_, _tmp288_);
					}
					_gee_tim_sort_slice_free0 (a);
					_gee_tim_sort_slice_free0 (b);
					return;
				}
				_tmp290_ = a_count;
				if (_tmp290_ < GEE_TIM_SORT_MINIMUM_GALLOP) {
					gint _tmp291_ = 0;
					_tmp291_ = b_count;
					_tmp289_ = _tmp291_ < GEE_TIM_SORT_MINIMUM_GALLOP;
				} else {
					_tmp289_ = FALSE;
				}
				if (_tmp289_) {
					break;
				}
			}
			_tmp292_ = minimum_gallop;
			minimum_gallop = _tmp292_ + 1;
			_tmp293_ = minimum_gallop;
			self->priv->minimum_gallop = _tmp293_;
		}
	}
	__finally6:
	{
		GeeTimSortSlice* _tmp294_ = NULL;
		gint _tmp295_ = 0;
		GeeTimSortSlice* _tmp296_ = NULL;
		gint _tmp297_ = 0;
		GeeTimSortSlice* _tmp298_ = NULL;
		void** _tmp299_ = NULL;
		GeeTimSortSlice* _tmp300_ = NULL;
		gint _tmp301_ = 0;
		gint _tmp302_ = 0;
		GeeTimSortSlice* _tmp303_ = NULL;
		gint _tmp304_ = 0;
		GeeTimSortSlice* _tmp305_ = NULL;
		gint _tmp306_ = 0;
		GeeTimSortSlice* _tmp307_ = NULL;
		void** _tmp308_ = NULL;
		GeeTimSortSlice* _tmp309_ = NULL;
		gint _tmp310_ = 0;
		gint _tmp311_ = 0;
		GeeTimSortSlice* _tmp312_ = NULL;
		gint _tmp313_ = 0;
		GeeTimSortSlice* _tmp314_ = NULL;
		gint _tmp315_ = 0;
		GeeTimSortSlice* _tmp316_ = NULL;
		gint _tmp317_ = 0;
		_tmp294_ = a;
		_tmp295_ = _tmp294_->length;
		_vala_assert (_tmp295_ >= 0, "a.length >= 0");
		_tmp296_ = b;
		_tmp297_ = _tmp296_->length;
		_vala_assert (_tmp297_ >= 0, "b.length >= 0");
		_tmp298_ = a;
		_tmp299_ = self->priv->list;
		_tmp300_ = a;
		_tmp301_ = _tmp300_->index;
		_tmp302_ = dest;
		_tmp303_ = a;
		_tmp304_ = _tmp303_->length;
		_tmp305_ = a;
		_tmp306_ = _tmp305_->length;
		gee_tim_sort_slice_merge_in_reversed (_tmp298_, _tmp299_, _tmp301_, _tmp302_ - _tmp304_, _tmp306_);
		_tmp307_ = b;
		_tmp308_ = self->priv->list;
		_tmp309_ = b;
		_tmp310_ = _tmp309_->index;
		_tmp311_ = dest;
		_tmp312_ = a;
		_tmp313_ = _tmp312_->length;
		_tmp314_ = b;
		_tmp315_ = _tmp314_->length;
		_tmp316_ = b;
		_tmp317_ = _tmp316_->length;
		gee_tim_sort_slice_merge_in_reversed (_tmp307_, _tmp308_, _tmp310_, (_tmp311_ - _tmp313_) - _tmp315_, _tmp317_);
	}
	_gee_tim_sort_slice_free0 (a);
	_gee_tim_sort_slice_free0 (b);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return;
}


G_GNUC_INTERNAL GeeTimSort* gee_tim_sort_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeTimSort * self = NULL;
	self = (GeeTimSort*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


G_GNUC_INTERNAL GeeTimSort* gee_tim_sort_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_tim_sort_construct (GEE_TYPE_TIM_SORT, g_type, g_dup_func, g_destroy_func);
}


static GeeTimSortSlice* gee_tim_sort_slice_new (void** list, gint index, gint length) {
	GeeTimSortSlice* self;
	void** _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = g_slice_new0 (GeeTimSortSlice);
	gee_tim_sort_slice_instance_init (self);
	_tmp0_ = list;
	self->list = _tmp0_;
	_tmp1_ = index;
	self->index = _tmp1_;
	_tmp2_ = length;
	self->length = _tmp2_;
	return self;
}


static void gee_tim_sort_slice_copy (GeeTimSortSlice* self) {
	void** _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	void* _tmp3_ = NULL;
	void** _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	_tmp3_ = g_memdup (&_tmp0_[_tmp1_], ((guint) sizeof (gpointer)) * _tmp2_);
	self->new_list = _tmp3_;
	_tmp4_ = self->new_list;
	self->list = _tmp4_;
	self->index = 0;
}


static inline void gee_tim_sort_slice_merge_in (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
	void** _tmp0_ = NULL;
	gint _tmp1_ = 0;
	void** _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = dest_array;
	_tmp1_ = dest_index;
	_tmp2_ = self->list;
	_tmp3_ = index;
	_tmp4_ = count;
	g_memmove (&_tmp0_[_tmp1_], &_tmp2_[_tmp3_], (gsize) (sizeof (gpointer) * _tmp4_));
}


static inline void gee_tim_sort_slice_merge_in_reversed (GeeTimSortSlice* self, void** dest_array, gint index, gint dest_index, gint count) {
	void** _tmp0_ = NULL;
	gint _tmp1_ = 0;
	void** _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = dest_array;
	_tmp1_ = dest_index;
	_tmp2_ = self->list;
	_tmp3_ = index;
	_tmp4_ = count;
	g_memmove (&_tmp0_[_tmp1_], &_tmp2_[_tmp3_], (gsize) (sizeof (gpointer) * _tmp4_));
}


static inline void gee_tim_sort_slice_shorten_start (GeeTimSortSlice* self, gint n) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	_tmp1_ = n;
	self->index = _tmp0_ + _tmp1_;
	_tmp2_ = self->length;
	_tmp3_ = n;
	self->length = _tmp2_ - _tmp3_;
}


static inline void gee_tim_sort_slice_shorten_end (GeeTimSortSlice* self, gint n) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->length;
	_tmp1_ = n;
	self->length = _tmp0_ - _tmp1_;
}


static inline void* gee_tim_sort_slice_pop_first (GeeTimSortSlice* self) {
	void* result = NULL;
	gint _tmp0_ = 0;
	void** _tmp1_ = NULL;
	gint _tmp2_ = 0;
	void* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	self->index = _tmp2_ + 1;
	_tmp3_ = _tmp1_[_tmp2_];
	result = _tmp3_;
	return result;
}


static inline void* gee_tim_sort_slice_pop_last (GeeTimSortSlice* self) {
	void* result = NULL;
	gint _tmp0_ = 0;
	void** _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	void* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->length;
	self->length = _tmp0_ - 1;
	_tmp1_ = self->list;
	_tmp2_ = self->index;
	_tmp3_ = self->length;
	_tmp4_ = _tmp1_[_tmp2_ + _tmp3_];
	result = _tmp4_;
	return result;
}


static inline void* gee_tim_sort_slice_peek_first (GeeTimSortSlice* self) {
	void* result = NULL;
	void** _tmp0_ = NULL;
	gint _tmp1_ = 0;
	void* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = _tmp0_[_tmp1_];
	result = _tmp2_;
	return result;
}


static inline void* gee_tim_sort_slice_peek_last (GeeTimSortSlice* self) {
	void* result = NULL;
	void** _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	void* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->list;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	_tmp3_ = _tmp0_[(_tmp1_ + _tmp2_) - 1];
	result = _tmp3_;
	return result;
}


static void gee_tim_sort_slice_reverse (GeeTimSortSlice* self) {
	gint low = 0;
	gint _tmp0_ = 0;
	gint high = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->index;
	low = _tmp0_;
	_tmp1_ = self->index;
	_tmp2_ = self->length;
	high = (_tmp1_ + _tmp2_) - 1;
	while (TRUE) {
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp3_ = low;
		_tmp4_ = high;
		if (!(_tmp3_ < _tmp4_)) {
			break;
		}
		_tmp5_ = low;
		low = _tmp5_ + 1;
		_tmp6_ = high;
		high = _tmp6_ - 1;
		gee_tim_sort_slice_swap (self, _tmp5_, _tmp6_);
	}
}


static inline void gee_tim_sort_slice_swap (GeeTimSortSlice* self, gint i, gint j) {
	void* temp = NULL;
	void** _tmp0_ = NULL;
	gint _tmp1_ = 0;
	void* _tmp2_ = NULL;
	void** _tmp3_ = NULL;
	gint _tmp4_ = 0;
	void** _tmp5_ = NULL;
	gint _tmp6_ = 0;
	void* _tmp7_ = NULL;
	void* _tmp8_ = NULL;
	void** _tmp9_ = NULL;
	gint _tmp10_ = 0;
	void* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->list;
	_tmp1_ = i;
	_tmp2_ = _tmp0_[_tmp1_];
	temp = _tmp2_;
	_tmp3_ = self->list;
	_tmp4_ = i;
	_tmp5_ = self->list;
	_tmp6_ = j;
	_tmp7_ = _tmp5_[_tmp6_];
	_tmp3_[_tmp4_] = _tmp7_;
	_tmp8_ = _tmp3_[_tmp4_];
	_tmp9_ = self->list;
	_tmp10_ = j;
	_tmp9_[_tmp10_] = temp;
	_tmp11_ = _tmp9_[_tmp10_];
}


static void gee_tim_sort_slice_instance_init (GeeTimSortSlice * self) {
}


static void gee_tim_sort_slice_free (GeeTimSortSlice* self) {
	void** _tmp0_ = NULL;
	_tmp0_ = self->new_list;
	if (_tmp0_ != NULL) {
		void** _tmp1_ = NULL;
		_tmp1_ = self->new_list;
		g_free (_tmp1_);
	}
	g_slice_free (GeeTimSortSlice, self);
}


static void gee_tim_sort_class_init (GeeTimSortClass * klass) {
	gee_tim_sort_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTimSortPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_tim_sort_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_tim_sort_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tim_sort_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TIM_SORT_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tim_sort_instance_init (GeeTimSort * self) {
	self->priv = GEE_TIM_SORT_GET_PRIVATE (self);
}


static void gee_tim_sort_finalize (GObject* obj) {
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_TYPE_TIM_SORT, GeeTimSort);
	_g_object_unref0 (self->priv->list_collection);
	self->priv->array = (_vala_array_free (self->priv->array, self->priv->array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	self->priv->pending = (_vala_array_free (self->priv->pending, self->priv->pending_length1, (GDestroyNotify) gee_tim_sort_slice_free), NULL);
	G_OBJECT_CLASS (gee_tim_sort_parent_class)->finalize (obj);
}


/**
 * A stable, adaptive, iterative mergesort that requires far fewer than n*lg(n)
 * comparisons when running on partially sorted arrays, while offering
 * performance comparable to a traditional mergesort when run on random arrays.
 * Like all proper mergesorts, this sort is stable and runs O(n*log(n)) time
 * (worst case). In the worst case, this sort requires temporary storage space
 * for n/2 object references; in the best case, it requires only a small
 * constant amount of space.
 *
 * This implementation was adapted from Tim Peters's list sort for Python,
 * which is described in detail here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listsort.txt]]
 *
 * Tim's C code may be found here:
 *   [[http://svn.python.org/projects/python/trunk/Objects/listobject.c]]
 *
 * The underlying techniques are described in this paper (and may have even
 * earlier origins):
 *
 *   "Optimistic Sorting and Information Theoretic Complexity"
 *   Peter McIlroy
 *   SODA (Fourth Annual ACM-SIAM Symposium on Discrete Algorithms), pp
 *   467-474, Austin, Texas, 25-27 January 1993.
 */
G_GNUC_INTERNAL GType gee_tim_sort_get_type (void) {
	static volatile gsize gee_tim_sort_type_id__volatile = 0;
	if (g_once_init_enter (&gee_tim_sort_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTimSortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tim_sort_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTimSort), 0, (GInstanceInitFunc) gee_tim_sort_instance_init, NULL };
		GType gee_tim_sort_type_id;
		gee_tim_sort_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTimSort", &g_define_type_info, 0);
		g_once_init_leave (&gee_tim_sort_type_id__volatile, gee_tim_sort_type_id);
	}
	return gee_tim_sort_type_id__volatile;
}


static void _vala_gee_tim_sort_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_TIM_SORT, GeeTimSort);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_tim_sort_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTimSort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEE_TYPE_TIM_SORT, GeeTimSort);
	switch (property_id) {
		case GEE_TIM_SORT_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TIM_SORT_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TIM_SORT_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if ((src < dest) && ((src + length) > dest)) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else if ((src > dest) && (src < (dest + length))) {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	} else if (src != dest) {
		memset (((char*) array) + (src * element_size), 0, length * element_size);
	}
}



