/* tracker-resources.c generated by valac 0.25.1, the Vala compiler
 * generated from tracker-resources.vala, do not modify */

/*
 * Copyright (C) 2006, Jamie McCracken <jamiemcc@gnome.org>
 * Copyright (C) 2008-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "tracker-store/tracker-config.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-common/tracker-common.h"
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include "libtracker-data/tracker-data-backup.h"
#include "libtracker-data/tracker-class.h"
#include "tracker-store/tracker-events.h"
#include "tracker-store/tracker-writeback.h"


#define TRACKER_TYPE_RESOURCES (tracker_resources_get_type ())
#define TRACKER_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_RESOURCES, TrackerResources))
#define TRACKER_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))
#define TRACKER_IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_RESOURCES))
#define TRACKER_IS_RESOURCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_RESOURCES))
#define TRACKER_RESOURCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_RESOURCES, TrackerResourcesClass))

typedef struct _TrackerResources TrackerResources;
typedef struct _TrackerResourcesClass TrackerResourcesClass;
typedef struct _TrackerResourcesPrivate TrackerResourcesPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TrackerResourcesLoadData TrackerResourcesLoadData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TRACKER_STORE_TYPE_PRIORITY (tracker_store_priority_get_type ())
typedef struct _TrackerResourcesSparqlQueryData TrackerResourcesSparqlQueryData;
typedef struct _TrackerResourcesSparqlUpdateData TrackerResourcesSparqlUpdateData;
typedef struct _TrackerResourcesSparqlUpdateBlankData TrackerResourcesSparqlUpdateBlankData;
typedef struct _TrackerResourcesBatchSparqlUpdateData TrackerResourcesBatchSparqlUpdateData;
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _TrackerResources {
	GObject parent_instance;
	TrackerResourcesPrivate * priv;
};

struct _TrackerResourcesClass {
	GObjectClass parent_class;
};

struct _TrackerResourcesPrivate {
	GDBusConnection* connection;
	guint signal_timeout;
	gboolean regular_commit_pending;
	TrackerConfig* config;
};

struct _TrackerResourcesLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* uri;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	const gchar* _tmp1_;
	TrackerDBusRequest* _tmp2_;
	GFile* file;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	const char* _tmp5_;
	GError* ie;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	GError* e;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _tmp15_;
	GError * _inner_error_;
};

struct _Block3Data {
	int _ref_count_;
	TrackerResources* self;
	GVariantBuilder* builder;
};

typedef enum  {
	TRACKER_STORE_PRIORITY_HIGH,
	TRACKER_STORE_PRIORITY_LOW,
	TRACKER_STORE_PRIORITY_TURTLE,
	TRACKER_STORE_PRIORITY_N_PRIORITIES
} TrackerStorePriority;

typedef void (*TrackerStoreSparqlQueryInThread) (TrackerDBCursor* cursor, void* user_data, GError** error);
struct _TrackerResourcesSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* query;
	GVariant* result;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	TrackerDBusRequest* _tmp2_;
	const gchar* _tmp3_;
	Block3Data* _data3_;
	GVariantBuilder* _tmp4_;
	const gchar* _tmp5_;
	const char* _tmp6_;
	GVariant* _result_;
	GVariantBuilder* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	gsize _tmp10_;
	GError* _tmp11_;
	TrackerDBusRequest* _tmp12_;
	GError* e;
	TrackerDBusRequest* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError* _tmp20_;
	GError * _inner_error_;
};

struct _TrackerResourcesSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const char* _tmp4_;
	GError* ie;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	GError* e;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError * _inner_error_;
};

struct _TrackerResourcesSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	GVariant* result;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	TrackerDBusRequest* _tmp2_;
	const gchar* _tmp3_;
	GVariant* variant;
	const gchar* _tmp4_;
	const char* _tmp5_;
	GVariant* _tmp6_;
	TrackerDBusRequest* _tmp7_;
	GError* ie;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GError* e;
	TrackerDBusRequest* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	GError * _inner_error_;
};

struct _TrackerResourcesBatchSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TrackerResources* self;
	char* sender;
	gchar* update;
	TrackerDBusRequest* request;
	const char* _tmp0_;
	TrackerDBusRequest* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const char* _tmp4_;
	GError* ie;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	GError* e;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	TrackerResources* self;
	GVariantBuilder* builder;
};


static gpointer tracker_resources_parent_class = NULL;

GType tracker_resources_get_type (void) G_GNUC_CONST;
guint tracker_resources_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define TRACKER_RESOURCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_RESOURCES, TrackerResourcesPrivate))
enum  {
	TRACKER_RESOURCES_DUMMY_PROPERTY
};
void tracker_resources_disable_signals (TrackerResources* self);
#define TRACKER_RESOURCES_PATH "/org/freedesktop/Tracker1/Resources"
#define TRACKER_RESOURCES_GRAPH_UPDATED_IMMEDIATE_EMIT_AT 50000
#define TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE 10000000
TrackerResources* tracker_resources_new (GDBusConnection* connection, TrackerConfig* config_p);
TrackerResources* tracker_resources_construct (GType object_type, GDBusConnection* connection, TrackerConfig* config_p);
static void tracker_resources_load_data_free (gpointer _data);
void tracker_resources_load (TrackerResources* self, const char* sender, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_load_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_load_co (TrackerResourcesLoadData* _data_);
void tracker_store_queue_turtle_import (GFile* file, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_query_data_free (gpointer _data);
void tracker_resources_sparql_query (TrackerResources* self, const char* sender, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_resources_sparql_query_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
GType tracker_store_priority_get_type (void) G_GNUC_CONST;
void tracker_store_sparql_query (const gchar* sparql, TrackerStorePriority priority, TrackerStoreSparqlQueryInThread in_thread, void* in_thread_target, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_, GError** error);
static void ___lambda6_ (Block3Data* _data3_, TrackerDBCursor* cursor, GError** error);
static void ____lambda6__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor, gpointer self, GError** error);
static void tracker_resources_sparql_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_update_data_free (gpointer _data);
void tracker_resources_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* _data_);
void tracker_store_sparql_update (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tracker_resources_sparql_update_blank_data_free (gpointer _data);
void tracker_resources_sparql_update_blank (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_resources_sparql_update_blank_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* _data_);
void tracker_store_sparql_update_blank (const gchar* sparql, TrackerStorePriority priority, const gchar* client_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_, GError** error);
static void tracker_resources_sparql_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_resources_sync (TrackerResources* self, const char* sender);
void tracker_store_wal_checkpoint (void);
static void tracker_resources_batch_sparql_update_data_free (gpointer _data);
void tracker_resources_batch_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tracker_resources_batch_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error);
static gboolean tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* _data_);
static void tracker_resources_batch_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void tracker_resources_batch_commit (TrackerResources* self);
static gboolean tracker_resources_emit_graph_updated (TrackerResources* self, TrackerClass* cl);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda7_ (Block4Data* _data4_, gint graph_id, gint subject_id, gint pred_id, gint object_id);
static void ____lambda7__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self);
static void ___lambda8_ (Block4Data* _data4_, gint graph_id, gint subject_id, gint pred_id, gint object_id);
static void ____lambda8__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self);
static gboolean tracker_resources_on_emit_signals (TrackerResources* self);
static void tracker_resources_on_statements_committed (TrackerResources* self, TrackerDataCommitType commit_type);
static gboolean _tracker_resources_on_emit_signals_gsource_func (gpointer self);
static void tracker_resources_on_statements_rolled_back (TrackerResources* self, TrackerDataCommitType commit_type);
static void tracker_resources_check_graph_updated_signal (TrackerResources* self);
static void tracker_resources_on_statement_inserted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types);
static void tracker_resources_on_statement_deleted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types);
void tracker_resources_enable_signals (TrackerResources* self);
static void _tracker_resources_on_statement_inserted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self);
static void _tracker_resources_on_statement_deleted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self);
static void _tracker_resources_on_statements_committed_tracker_commit_callback (TrackerDataCommitType commit_type, gpointer self);
static void _tracker_resources_on_statements_rolled_back_tracker_commit_callback (TrackerDataCommitType commit_type, gpointer self);
void tracker_resources_unreg_batches (TrackerResources* self, const gchar* old_owner);
void tracker_store_unreg_batches (const gchar* client_id);
static void g_cclosure_user_marshal_VOID__VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void tracker_resources_finalize (GObject* obj);
static void _dbus_tracker_resources_load (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_load_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_query (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sparql_update_blank (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_sync (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_tracker_resources_batch_commit (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void tracker_resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* tracker_resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean tracker_resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_tracker_resources_writeback (GObject* _sender, GVariant* subjects, gpointer* _data);
static void _dbus_tracker_resources_graph_updated (GObject* _sender, const gchar* classname, GVariant* deletes, GVariant* inserts, gpointer* _data);
static void _tracker_resources_unregister_object (gpointer user_data);

static const GDBusArgInfo _tracker_resources_dbus_arg_info_load_uri = {-1, "uri", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_in[] = {&_tracker_resources_dbus_arg_info_load_uri, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_load_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_load = {-1, "Load", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_load_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_query = {-1, "query", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_query_result = {-1, "result", "aas"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_in[] = {&_tracker_resources_dbus_arg_info_sparql_query_query, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_query_out[] = {&_tracker_resources_dbus_arg_info_sparql_query_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_query = {-1, "SparqlQuery", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_query_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_update = {-1, "update", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update = {-1, "SparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_update = {-1, "update", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_sparql_update_blank_result = {-1, "result", "aaa{ss}"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_in[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sparql_update_blank_out[] = {&_tracker_resources_dbus_arg_info_sparql_update_blank_result, NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sparql_update_blank = {-1, "SparqlUpdateBlank", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sparql_update_blank_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_sync_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_sync = {-1, "Sync", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_sync_out)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_batch_sparql_update_update = {-1, "update", "s"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_in[] = {&_tracker_resources_dbus_arg_info_batch_sparql_update_update, NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_sparql_update_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_sparql_update = {-1, "BatchSparqlUpdate", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_sparql_update_out)};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_in[] = {NULL};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_batch_commit_out[] = {NULL};
static const GDBusMethodInfo _tracker_resources_dbus_method_info_batch_commit = {-1, "BatchCommit", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_in), (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_batch_commit_out)};
static const GDBusMethodInfo * const _tracker_resources_dbus_method_info[] = {&_tracker_resources_dbus_method_info_load, &_tracker_resources_dbus_method_info_sparql_query, &_tracker_resources_dbus_method_info_sparql_update, &_tracker_resources_dbus_method_info_sparql_update_blank, &_tracker_resources_dbus_method_info_sync, &_tracker_resources_dbus_method_info_batch_sparql_update, &_tracker_resources_dbus_method_info_batch_commit, NULL};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_writeback_subjects = {-1, "subjects", "a{iai}"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_writeback[] = {&_tracker_resources_dbus_arg_info_writeback_subjects, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_writeback = {-1, "Writeback", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_writeback)};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_classname = {-1, "classname", "s"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_deletes = {-1, "deletes", "a(iiii)"};
static const GDBusArgInfo _tracker_resources_dbus_arg_info_graph_updated_inserts = {-1, "inserts", "a(iiii)"};
static const GDBusArgInfo * const _tracker_resources_dbus_arg_info_graph_updated[] = {&_tracker_resources_dbus_arg_info_graph_updated_classname, &_tracker_resources_dbus_arg_info_graph_updated_deletes, &_tracker_resources_dbus_arg_info_graph_updated_inserts, NULL};
static const GDBusSignalInfo _tracker_resources_dbus_signal_info_graph_updated = {-1, "GraphUpdated", (GDBusArgInfo **) (&_tracker_resources_dbus_arg_info_graph_updated)};
static const GDBusSignalInfo * const _tracker_resources_dbus_signal_info[] = {&_tracker_resources_dbus_signal_info_writeback, &_tracker_resources_dbus_signal_info_graph_updated, NULL};
static const GDBusPropertyInfo * const _tracker_resources_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _tracker_resources_dbus_interface_info = {-1, "org.freedesktop.Tracker1.Resources", (GDBusMethodInfo **) (&_tracker_resources_dbus_method_info), (GDBusSignalInfo **) (&_tracker_resources_dbus_signal_info), (GDBusPropertyInfo **) (&_tracker_resources_dbus_property_info)};
static const GDBusInterfaceVTable _tracker_resources_dbus_interface_vtable = {tracker_resources_dbus_interface_method_call, tracker_resources_dbus_interface_get_property, tracker_resources_dbus_interface_set_property};

static gpointer _g_object_ref0 (gpointer self) {
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return self ? g_object_ref (self) : NULL;
#line 409 "tracker-resources.c"
}


TrackerResources* tracker_resources_construct (GType object_type, GDBusConnection* connection, TrackerConfig* config_p) {
	TrackerResources * self = NULL;
	GDBusConnection* _tmp0_ = NULL;
	GDBusConnection* _tmp1_ = NULL;
	TrackerConfig* _tmp2_ = NULL;
	TrackerConfig* _tmp3_ = NULL;
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (connection != NULL, NULL);
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (config_p != NULL, NULL);
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = (TrackerResources*) g_object_new (object_type, NULL);
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = connection;
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->connection);
#line 61 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv->connection = _tmp1_;
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = config_p;
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->config);
#line 62 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv->config = _tmp3_;
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return self;
#line 443 "tracker-resources.c"
}


TrackerResources* tracker_resources_new (GDBusConnection* connection, TrackerConfig* config_p) {
#line 60 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return tracker_resources_construct (TRACKER_TYPE_RESOURCES, connection, config_p);
#line 450 "tracker-resources.c"
}


static void tracker_resources_load_data_free (gpointer _data) {
	TrackerResourcesLoadData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->uri);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesLoadData, _data_);
#line 465 "tracker-resources.c"
}


void tracker_resources_load (TrackerResources* self, const char* sender, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesLoadData* _data_;
	TrackerResources* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesLoadData);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_load);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_load_data_free);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = uri;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->uri);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->uri = _tmp4_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_load_co (_data_);
#line 504 "tracker-resources.c"
}


void tracker_resources_load_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesLoadData* _data_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return;
#line 514 "tracker-resources.c"
	}
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 518 "tracker-resources.c"
}


static void tracker_resources_load_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesLoadData* _data_;
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_load_co (_data_);
#line 532 "tracker-resources.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return self ? g_error_copy (self) : NULL;
#line 539 "tracker-resources.c"
}


static gboolean tracker_resources_load_co (TrackerResourcesLoadData* _data_) {
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 548 "tracker-resources.c"
		goto _state_0;
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 552 "tracker-resources.c"
		goto _state_1;
		default:
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 557 "tracker-resources.c"
	}
	_state_0:
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = NULL;
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = NULL;
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = _data_->uri;
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = NULL;
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.Load (uri: '%s')", _data_->_tmp1_, NULL);
#line 66 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp2_;
#line 574 "tracker-resources.c"
	{
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = NULL;
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _data_->uri;
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = NULL;
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = g_file_new_for_uri (_data_->_tmp3_);
#line 68 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->file = _data_->_tmp4_;
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = NULL;
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->sender;
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_queue_turtle_import (_data_->file, (const gchar*) _data_->_tmp5_, tracker_resources_load_ready, _data_);
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 596 "tracker-resources.c"
		_state_1:
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_queue_turtle_import_finish (_data_->_res_, &_data_->_inner_error_);
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_object_unref0 (_data_->file);
#line 70 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 606 "tracker-resources.c"
				goto __catch8_tracker_db_no_space;
			}
			goto __catch8_g_error;
		}
#line 72 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (_data_->file);
#line 615 "tracker-resources.c"
	}
	goto __finally8;
	__catch8_tracker_db_no_space:
	{
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = NULL;
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->ie;
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = NULL;
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->_tmp6_->message;
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = NULL;
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp7_);
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 74 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 640 "tracker-resources.c"
		goto __finally8;
	}
	goto __finally8;
	__catch8_g_error:
	{
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = NULL;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->e;
#line 76 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp9_);
#line 77 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = NULL;
#line 77 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = _data_->e;
#line 77 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp10_->domain == TRACKER_SPARQL_ERROR) {
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = NULL;
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _data_->e;
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = NULL;
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp12_;
#line 78 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 674 "tracker-resources.c"
			goto __finally8;
		} else {
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = NULL;
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = _data_->e;
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = NULL;
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = _data_->_tmp13_->message;
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp15_ = NULL;
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp15_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp14_);
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp15_;
#line 80 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 693 "tracker-resources.c"
			goto __finally8;
		}
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 698 "tracker-resources.c"
	}
	__finally8:
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_error_free (_data_->_inner_error_);
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ == 0) {
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 711 "tracker-resources.c"
		} else {
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 715 "tracker-resources.c"
		}
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 67 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 721 "tracker-resources.c"
	}
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ == 0) {
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 727 "tracker-resources.c"
	} else {
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 731 "tracker-resources.c"
	}
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 65 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 737 "tracker-resources.c"
}


static void tracker_resources_sparql_query_data_free (gpointer _data) {
	TrackerResourcesSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->query);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlQueryData, _data_);
#line 754 "tracker-resources.c"
}


void tracker_resources_sparql_query (TrackerResources* self, const char* sender, const gchar* query, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlQueryData* _data_;
	TrackerResources* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlQueryData);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_sparql_query);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_sparql_query_data_free);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = query;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->query);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->query = _tmp4_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_query_co (_data_);
#line 793 "tracker-resources.c"
}


GVariant* tracker_resources_sparql_query_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerResourcesSparqlQueryData* _data_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return NULL;
#line 804 "tracker-resources.c"
	}
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	result = _data_->result;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->result = NULL;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 814 "tracker-resources.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return _data3_;
#line 823 "tracker-resources.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 832 "tracker-resources.c"
		TrackerResources* self;
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		self = _data3_->self;
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data3_->builder);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (self);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_slice_free (Block3Data, _data3_);
#line 842 "tracker-resources.c"
	}
}


static void ___lambda6_ (Block3Data* _data3_, TrackerDBCursor* cursor, GError** error) {
	TrackerResources* self;
	GError * _inner_error_ = NULL;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = _data3_->self;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (cursor != NULL);
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	while (TRUE) {
#line 856 "tracker-resources.c"
		gboolean _tmp0_ = FALSE;
		TrackerDBCursor* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		GVariantBuilder* _tmp3_ = NULL;
		GVariantBuilder* _tmp16_ = NULL;
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp1_ = cursor;
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp2_ = tracker_sparql_cursor_next ((TrackerSparqlCursor*) _tmp1_, NULL, &_inner_error_);
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp0_ = _tmp2_;
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_propagate_error (error, _inner_error_);
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			return;
#line 874 "tracker-resources.c"
		}
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (!_tmp0_) {
#line 93 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			break;
#line 880 "tracker-resources.c"
		}
#line 94 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp3_ = _data3_->builder;
#line 94 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_builder_open (_tmp3_, (const GVariantType*) "as");
#line 886 "tracker-resources.c"
		{
			gint i = 0;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			i = 0;
#line 891 "tracker-resources.c"
			{
				gboolean _tmp4_ = FALSE;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_tmp4_ = TRUE;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				while (TRUE) {
#line 898 "tracker-resources.c"
					gint _tmp6_ = 0;
					TrackerDBCursor* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					const gchar* str = NULL;
					TrackerDBCursor* _tmp10_ = NULL;
					gint _tmp11_ = 0;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					GVariantBuilder* _tmp14_ = NULL;
					const gchar* _tmp15_ = NULL;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					if (!_tmp4_) {
#line 912 "tracker-resources.c"
						gint _tmp5_ = 0;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp5_ = i;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						i = _tmp5_ + 1;
#line 918 "tracker-resources.c"
					}
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp4_ = FALSE;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp6_ = i;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp7_ = cursor;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp8_ = tracker_sparql_cursor_get_n_columns ((TrackerSparqlCursor*) _tmp7_);
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp9_ = _tmp8_;
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					if (!(_tmp6_ < _tmp9_)) {
#line 96 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						break;
#line 934 "tracker-resources.c"
					}
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp10_ = cursor;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp11_ = i;
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp12_ = tracker_sparql_cursor_get_string ((TrackerSparqlCursor*) _tmp10_, _tmp11_, NULL);
#line 97 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					str = _tmp12_;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp13_ = str;
#line 99 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					if (_tmp13_ == NULL) {
#line 100 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						str = "";
#line 950 "tracker-resources.c"
					}
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp14_ = _data3_->builder;
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp15_ = str;
#line 103 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					g_variant_builder_add (_tmp14_, "s", _tmp15_, NULL);
#line 958 "tracker-resources.c"
				}
			}
		}
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp16_ = _data3_->builder;
#line 106 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_builder_close (_tmp16_);
#line 966 "tracker-resources.c"
	}
}


static void ____lambda6__tracker_store_sparql_query_in_thread (TrackerDBCursor* cursor, gpointer self, GError** error) {
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	___lambda6_ (self, cursor, error);
#line 974 "tracker-resources.c"
}


static void tracker_resources_sparql_query_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlQueryData* _data_;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_query_co (_data_);
#line 988 "tracker-resources.c"
}


static gboolean tracker_resources_sparql_query_co (TrackerResourcesSparqlQueryData* _data_) {
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 997 "tracker-resources.c"
		goto _state_0;
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1001 "tracker-resources.c"
		goto _state_1;
		default:
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1006 "tracker-resources.c"
	}
	_state_0:
#line 87 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = NULL;
#line 87 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 87 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = NULL;
#line 87 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.SparqlQuery", NULL);
#line 87 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp1_;
#line 88 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = NULL;
#line 88 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = _data_->request;
#line 88 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp3_ = NULL;
#line 88 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp3_ = _data_->query;
#line 88 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->_tmp2_, "query: %s", _data_->_tmp3_, NULL);
#line 1029 "tracker-resources.c"
	{
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_ = g_slice_new0 (Block3Data);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->_ref_count_ = 1;
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->self = g_object_ref (_data_->self);
#line 90 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = NULL;
#line 90 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = g_variant_builder_new ((const GVariantType*) "aas");
#line 90 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_->builder = _data_->_tmp4_;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = NULL;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->query;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = NULL;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->sender;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_query (_data_->_tmp5_, TRACKER_STORE_PRIORITY_HIGH, ____lambda6__tracker_store_sparql_query_in_thread, _data_->_data3_, (const gchar*) _data_->_tmp6_, tracker_resources_sparql_query_ready, _data_);
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1057 "tracker-resources.c"
		_state_1:
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_query_finish (_data_->_res_, &_data_->_inner_error_);
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			block3_data_unref (_data_->_data3_);
#line 92 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_data3_ = NULL;
#line 1067 "tracker-resources.c"
			goto __catch9_g_error;
		}
#line 110 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = NULL;
#line 110 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->_data3_->builder;
#line 110 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = NULL;
#line 110 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = g_variant_builder_end (_data_->_tmp7_);
#line 110 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_data_->_tmp8_);
#line 110 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_result_ = _data_->_tmp8_;
#line 111 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = NULL;
#line 111 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->_result_;
#line 111 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = 0UL;
#line 111 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = g_variant_get_size (_data_->_tmp9_);
#line 111 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp10_ > ((gsize) TRACKER_RESOURCES_DBUS_ARBITRARY_MAX_MSG_SIZE)) {
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = NULL;
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "result set of the query is too large");
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp11_;
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_variant_unref0 (_data_->_result_);
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			block3_data_unref (_data_->_data3_);
#line 112 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_data3_ = NULL;
#line 1104 "tracker-resources.c"
			goto __catch9_g_error;
		}
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp12_ = NULL;
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp12_ = _data_->request;
#line 115 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp12_, NULL);
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->result = _data_->_result_;
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		block3_data_unref (_data_->_data3_);
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_data3_ = NULL;
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ == 0) {
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1123 "tracker-resources.c"
		} else {
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1127 "tracker-resources.c"
		}
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 117 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1133 "tracker-resources.c"
	}
	goto __finally9;
	__catch9_g_error:
	{
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp13_ = NULL;
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp13_ = _data_->request;
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp14_ = NULL;
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp14_ = _data_->e;
#line 119 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp13_, _data_->_tmp14_);
#line 120 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp15_ = NULL;
#line 120 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp15_ = _data_->e;
#line 120 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp15_->domain == TRACKER_SPARQL_ERROR) {
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp16_ = NULL;
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp16_ = _data_->e;
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp17_ = NULL;
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp17_;
#line 121 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1170 "tracker-resources.c"
			goto __finally9;
		} else {
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp18_ = NULL;
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp18_ = _data_->e;
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp19_ = NULL;
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp19_ = _data_->_tmp18_->message;
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp20_ = NULL;
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp20_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp19_);
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp20_;
#line 123 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1189 "tracker-resources.c"
			goto __finally9;
		}
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1194 "tracker-resources.c"
	}
	__finally9:
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_error_free (_data_->_inner_error_);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ == 0) {
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1205 "tracker-resources.c"
	} else {
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1209 "tracker-resources.c"
	}
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 89 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ == 0) {
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1219 "tracker-resources.c"
	} else {
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1223 "tracker-resources.c"
	}
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 86 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1229 "tracker-resources.c"
}


static void tracker_resources_sparql_update_data_free (gpointer _data) {
	TrackerResourcesSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlUpdateData, _data_);
#line 1244 "tracker-resources.c"
}


void tracker_resources_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateData* _data_;
	TrackerResources* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateData);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_sparql_update);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_sparql_update_data_free);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = update;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp4_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_co (_data_);
#line 1283 "tracker-resources.c"
}


void tracker_resources_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesSparqlUpdateData* _data_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return;
#line 1293 "tracker-resources.c"
	}
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1297 "tracker-resources.c"
}


static void tracker_resources_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateData* _data_;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_co (_data_);
#line 1311 "tracker-resources.c"
}


static gboolean tracker_resources_sparql_update_co (TrackerResourcesSparqlUpdateData* _data_) {
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1320 "tracker-resources.c"
		goto _state_0;
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1324 "tracker-resources.c"
		goto _state_1;
		default:
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1329 "tracker-resources.c"
	}
	_state_0:
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = NULL;
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = NULL;
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.SparqlUpdate", NULL);
#line 129 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp1_;
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = NULL;
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = _data_->update;
#line 130 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->_tmp2_, NULL);
#line 1348 "tracker-resources.c"
	{
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = NULL;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _data_->update;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = NULL;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->sender;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update (_data_->_tmp3_, TRACKER_STORE_PRIORITY_HIGH, (const gchar*) _data_->_tmp4_, tracker_resources_sparql_update_ready, _data_);
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1364 "tracker-resources.c"
		_state_1:
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error_);
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 132 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 1372 "tracker-resources.c"
				goto __catch10_tracker_db_no_space;
			}
			goto __catch10_g_error;
		}
#line 134 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 1379 "tracker-resources.c"
	}
	goto __finally10;
	__catch10_tracker_db_no_space:
	{
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = NULL;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->ie;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = NULL;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->_tmp5_->message;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = NULL;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp6_);
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp7_;
#line 136 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 1404 "tracker-resources.c"
		goto __finally10;
	}
	goto __finally10;
	__catch10_g_error:
	{
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = NULL;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->e;
#line 138 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp8_);
#line 139 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = NULL;
#line 139 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->e;
#line 139 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp9_->domain == TRACKER_SPARQL_ERROR) {
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = NULL;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = _data_->e;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = NULL;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp11_;
#line 140 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1438 "tracker-resources.c"
			goto __finally10;
		} else {
#line 142 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = NULL;
#line 142 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = _data_->e;
#line 142 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = NULL;
#line 142 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = _data_->_tmp12_->message;
#line 142 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = NULL;
#line 142 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp13_);
#line 142 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp14_;
#line 142 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1457 "tracker-resources.c"
			goto __finally10;
		}
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1462 "tracker-resources.c"
	}
	__finally10:
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_error_free (_data_->_inner_error_);
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ == 0) {
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1475 "tracker-resources.c"
		} else {
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1479 "tracker-resources.c"
		}
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 131 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1485 "tracker-resources.c"
	}
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ == 0) {
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1491 "tracker-resources.c"
	} else {
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1495 "tracker-resources.c"
	}
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 128 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1501 "tracker-resources.c"
}


static void tracker_resources_sparql_update_blank_data_free (gpointer _data) {
	TrackerResourcesSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesSparqlUpdateBlankData, _data_);
#line 1518 "tracker-resources.c"
}


void tracker_resources_sparql_update_blank (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateBlankData* _data_;
	TrackerResources* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesSparqlUpdateBlankData);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_sparql_update_blank);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_sparql_update_blank_data_free);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = update;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp4_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_blank_co (_data_);
#line 1557 "tracker-resources.c"
}


GVariant* tracker_resources_sparql_update_blank_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerResourcesSparqlUpdateBlankData* _data_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return NULL;
#line 1568 "tracker-resources.c"
	}
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	result = _data_->result;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->result = NULL;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 1578 "tracker-resources.c"
}


static void tracker_resources_sparql_update_blank_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesSparqlUpdateBlankData* _data_;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_sparql_update_blank_co (_data_);
#line 1592 "tracker-resources.c"
}


static gboolean tracker_resources_sparql_update_blank_co (TrackerResourcesSparqlUpdateBlankData* _data_) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1601 "tracker-resources.c"
		goto _state_0;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1605 "tracker-resources.c"
		goto _state_1;
		default:
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1610 "tracker-resources.c"
	}
	_state_0:
#line 149 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = NULL;
#line 149 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 149 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = NULL;
#line 149 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.SparqlUpdateBlank", NULL);
#line 149 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp1_;
#line 150 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = NULL;
#line 150 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = _data_->request;
#line 150 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp3_ = NULL;
#line 150 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp3_ = _data_->update;
#line 150 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->_tmp2_, "query: %s", _data_->_tmp3_, NULL);
#line 1633 "tracker-resources.c"
	{
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = NULL;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->update;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = NULL;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->sender;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_blank (_data_->_tmp4_, TRACKER_STORE_PRIORITY_HIGH, (const gchar*) _data_->_tmp5_, tracker_resources_sparql_update_blank_ready, _data_);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1649 "tracker-resources.c"
		_state_1:
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = NULL;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = tracker_store_sparql_update_blank_finish (_data_->_res_, &_data_->_inner_error_);
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->variant = _data_->_tmp6_;
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 152 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 1661 "tracker-resources.c"
				goto __catch11_tracker_db_no_space;
			}
			goto __catch11_g_error;
		}
#line 154 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = NULL;
#line 154 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = _data_->request;
#line 154 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp7_, NULL);
#line 156 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->result = _data_->variant;
#line 156 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ == 0) {
#line 156 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1678 "tracker-resources.c"
		} else {
#line 156 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1682 "tracker-resources.c"
		}
#line 156 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 156 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1688 "tracker-resources.c"
	}
	goto __finally11;
	__catch11_tracker_db_no_space:
	{
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = NULL;
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->ie;
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = NULL;
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->_tmp8_->message;
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = NULL;
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp10_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp9_);
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp10_;
#line 158 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 1713 "tracker-resources.c"
		goto __finally11;
	}
	goto __finally11;
	__catch11_g_error:
	{
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp11_ = NULL;
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp11_ = _data_->request;
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp12_ = NULL;
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp12_ = _data_->e;
#line 160 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->_tmp11_, _data_->_tmp12_);
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp13_ = NULL;
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp13_ = _data_->e;
#line 161 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp13_->domain == TRACKER_SPARQL_ERROR) {
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = NULL;
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = _data_->e;
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp15_ = NULL;
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp15_ = _g_error_copy0 (_data_->_tmp14_);
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp15_;
#line 162 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1751 "tracker-resources.c"
			goto __finally11;
		} else {
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp16_ = NULL;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp16_ = _data_->e;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp17_ = NULL;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp17_ = _data_->_tmp16_->message;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp18_ = NULL;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp18_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp17_);
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp18_;
#line 164 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 1770 "tracker-resources.c"
			goto __finally11;
		}
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 1775 "tracker-resources.c"
	}
	__finally11:
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_error_free (_data_->_inner_error_);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ == 0) {
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1786 "tracker-resources.c"
	} else {
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1790 "tracker-resources.c"
	}
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 151 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ == 0) {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1800 "tracker-resources.c"
	} else {
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1804 "tracker-resources.c"
	}
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 148 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 1810 "tracker-resources.c"
}


void tracker_resources_sync (TrackerResources* self, const char* sender) {
	TrackerDBusRequest* request = NULL;
	const char* _tmp0_ = NULL;
	TrackerDBusRequest* _tmp1_ = NULL;
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 169 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (sender != NULL);
#line 170 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = sender;
#line 170 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_dbus_request_begin ((const gchar*) _tmp0_, "Resources.Sync", NULL);
#line 170 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	request = _tmp1_;
#line 173 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_store_wal_checkpoint ();
#line 175 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_sync ();
#line 177 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_end (request, NULL);
#line 1834 "tracker-resources.c"
}


static void tracker_resources_batch_sparql_update_data_free (gpointer _data) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (_data_->self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_slice_free (TrackerResourcesBatchSparqlUpdateData, _data_);
#line 1849 "tracker-resources.c"
}


void tracker_resources_batch_sparql_update (TrackerResources* self, const char* sender, const gchar* update, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
	TrackerResources* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	char* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_slice_new0 (TrackerResourcesBatchSparqlUpdateData);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tracker_resources_batch_sparql_update);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tracker_resources_batch_sparql_update_data_free);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->self = _tmp0_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = sender;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->sender);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->sender = _tmp2_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = update;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_free0 (_data_->update);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->update = _tmp4_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_batch_sparql_update_co (_data_);
#line 1888 "tracker-resources.c"
}


void tracker_resources_batch_sparql_update_finish (TrackerResources* self, GAsyncResult* _res_, GError** error) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return;
#line 1898 "tracker-resources.c"
	}
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1902 "tracker-resources.c"
}


static void tracker_resources_batch_sparql_update_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TrackerResourcesBatchSparqlUpdateData* _data_;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_ = _user_data_;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_source_object_ = source_object;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_res_ = _res_;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_batch_sparql_update_co (_data_);
#line 1916 "tracker-resources.c"
}


static gboolean tracker_resources_batch_sparql_update_co (TrackerResourcesBatchSparqlUpdateData* _data_) {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	switch (_data_->_state_) {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 0:
#line 1925 "tracker-resources.c"
		goto _state_0;
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		case 1:
#line 1929 "tracker-resources.c"
		goto _state_1;
		default:
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_assert_not_reached ();
#line 1934 "tracker-resources.c"
	}
	_state_0:
#line 181 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = NULL;
#line 181 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp0_ = _data_->sender;
#line 181 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = NULL;
#line 181 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp1_ = tracker_dbus_request_begin ((const gchar*) _data_->_tmp0_, "Resources.BatchSparqlUpdate", NULL);
#line 181 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->request = _data_->_tmp1_;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = NULL;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_data_->_tmp2_ = _data_->update;
#line 182 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_dbus_request_debug (_data_->request, "query: %s", _data_->_tmp2_, NULL);
#line 1953 "tracker-resources.c"
	{
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = NULL;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp3_ = _data_->update;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = NULL;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp4_ = _data_->sender;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_state_ = 1;
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update (_data_->_tmp3_, TRACKER_STORE_PRIORITY_LOW, (const gchar*) _data_->_tmp4_, tracker_resources_batch_sparql_update_ready, _data_);
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 1969 "tracker-resources.c"
		_state_1:
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_store_sparql_update_finish (_data_->_res_, &_data_->_inner_error_);
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 184 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (g_error_matches (_data_->_inner_error_, TRACKER_DB_INTERFACE_ERROR, TRACKER_DB_NO_SPACE)) {
#line 1977 "tracker-resources.c"
				goto __catch12_tracker_db_no_space;
			}
			goto __catch12_g_error;
		}
#line 186 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, NULL);
#line 1984 "tracker-resources.c"
	}
	goto __finally12;
	__catch12_tracker_db_no_space:
	{
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->ie = _data_->_inner_error_;
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = NULL;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp5_ = _data_->ie;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = NULL;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp6_ = _data_->_tmp5_->message;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = NULL;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp7_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_NO_SPACE, _data_->_tmp6_);
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = _data_->_tmp7_;
#line 188 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->ie);
#line 2009 "tracker-resources.c"
		goto __finally12;
	}
	goto __finally12;
	__catch12_g_error:
	{
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->e = _data_->_inner_error_;
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_inner_error_ = NULL;
#line 190 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = NULL;
#line 190 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp8_ = _data_->e;
#line 190 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_dbus_request_end (_data_->request, _data_->_tmp8_);
#line 191 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = NULL;
#line 191 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data_->_tmp9_ = _data_->e;
#line 191 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_tmp9_->domain == TRACKER_SPARQL_ERROR) {
#line 192 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = NULL;
#line 192 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp10_ = _data_->e;
#line 192 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = NULL;
#line 192 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
#line 192 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp11_;
#line 192 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 2043 "tracker-resources.c"
			goto __finally12;
		} else {
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = NULL;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp12_ = _data_->e;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = NULL;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp13_ = _data_->_tmp12_->message;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = NULL;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_tmp14_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp13_);
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_data_->_inner_error_ = _data_->_tmp14_;
#line 194 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_g_error_free0 (_data_->e);
#line 2062 "tracker-resources.c"
			goto __finally12;
		}
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_error_free0 (_data_->e);
#line 2067 "tracker-resources.c"
	}
	__finally12:
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_error_free (_data_->_inner_error_);
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_data_->_state_ == 0) {
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2080 "tracker-resources.c"
		} else {
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 2084 "tracker-resources.c"
		}
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_object_unref (_data_->_async_result);
#line 183 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return FALSE;
#line 2090 "tracker-resources.c"
	}
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_data_->_state_ == 0) {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 2096 "tracker-resources.c"
	} else {
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 2100 "tracker-resources.c"
	}
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_object_unref (_data_->_async_result);
#line 180 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return FALSE;
#line 2106 "tracker-resources.c"
}


void tracker_resources_batch_commit (TrackerResources* self) {
#line 199 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 2113 "tracker-resources.c"
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return _data4_;
#line 2122 "tracker-resources.c"
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 2131 "tracker-resources.c"
		TrackerResources* self;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		self = _data4_->self;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data4_->builder);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_object_unref0 (self);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_slice_free (Block4Data, _data4_);
#line 2141 "tracker-resources.c"
	}
}


static void ___lambda7_ (Block4Data* _data4_, gint graph_id, gint subject_id, gint pred_id, gint object_id) {
	TrackerResources* self;
	GVariantBuilder* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = _data4_->self;
#line 207 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _data4_->builder;
#line 207 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = graph_id;
#line 207 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = subject_id;
#line 207 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = pred_id;
#line 207 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = object_id;
#line 207 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_variant_builder_add (_tmp0_, "(iiii)", _tmp1_, _tmp2_, _tmp3_, _tmp4_, NULL);
#line 2167 "tracker-resources.c"
}


static void ____lambda7__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self) {
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	___lambda7_ (self, graph_id, subject_id, pred_id, object_id);
#line 2174 "tracker-resources.c"
}


static void ___lambda8_ (Block4Data* _data4_, gint graph_id, gint subject_id, gint pred_id, gint object_id) {
	TrackerResources* self;
	GVariantBuilder* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 212 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = _data4_->self;
#line 213 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = _data4_->builder;
#line 213 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = graph_id;
#line 213 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = subject_id;
#line 213 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = pred_id;
#line 213 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = object_id;
#line 213 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_variant_builder_add (_tmp0_, "(iiii)", _tmp1_, _tmp2_, _tmp3_, _tmp4_, NULL);
#line 2199 "tracker-resources.c"
}


static void ____lambda8__tracker_events_foreach (gint graph_id, gint subject_id, gint pred_id, gint object_id, gpointer self) {
#line 212 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	___lambda8_ (self, graph_id, subject_id, pred_id, object_id);
#line 2206 "tracker-resources.c"
}


static gboolean tracker_resources_emit_graph_updated (TrackerResources* self, TrackerClass* cl) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TrackerClass* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 203 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 203 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (cl != NULL, FALSE);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = cl;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = tracker_class_has_insert_events (_tmp1_);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp2_) {
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp0_ = TRUE;
#line 2227 "tracker-resources.c"
	} else {
		TrackerClass* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp3_ = cl;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp4_ = tracker_class_has_delete_events (_tmp3_);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp0_ = _tmp4_;
#line 2237 "tracker-resources.c"
	}
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp0_) {
#line 2241 "tracker-resources.c"
		Block4Data* _data4_;
		GVariantBuilder* _tmp5_ = NULL;
		TrackerClass* _tmp6_ = NULL;
		GVariant* deletes = NULL;
		GVariantBuilder* _tmp7_ = NULL;
		GVariant* _tmp8_ = NULL;
		GVariantBuilder* _tmp9_ = NULL;
		TrackerClass* _tmp10_ = NULL;
		GVariant* inserts = NULL;
		GVariantBuilder* _tmp11_ = NULL;
		GVariant* _tmp12_ = NULL;
		TrackerClass* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GVariant* _tmp16_ = NULL;
		GVariant* _tmp17_ = NULL;
		TrackerClass* _tmp18_ = NULL;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_ = g_slice_new0 (Block4Data);
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_->_ref_count_ = 1;
#line 204 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_->self = g_object_ref (self);
#line 205 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp5_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
#line 205 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_->builder = _tmp5_;
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp6_ = cl;
#line 206 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_class_foreach_delete_event (_tmp6_, ____lambda7__tracker_events_foreach, _data4_);
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp7_ = _data4_->builder;
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp8_ = g_variant_builder_end (_tmp7_);
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp8_);
#line 209 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		deletes = _tmp8_;
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp9_ = g_variant_builder_new ((const GVariantType*) "a(iiii)");
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (_data4_->builder);
#line 211 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_->builder = _tmp9_;
#line 212 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp10_ = cl;
#line 212 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_class_foreach_insert_event (_tmp10_, ____lambda8__tracker_events_foreach, _data4_);
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp11_ = _data4_->builder;
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp12_ = g_variant_builder_end (_tmp11_);
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp12_);
#line 215 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		inserts = _tmp12_;
#line 217 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp13_ = cl;
#line 217 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp14_ = tracker_class_get_uri (_tmp13_);
#line 217 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp15_ = _tmp14_;
#line 217 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp16_ = deletes;
#line 217 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp17_ = inserts;
#line 217 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_signal_emit_by_name (self, "graph-updated", _tmp15_, _tmp16_, _tmp17_);
#line 219 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp18_ = cl;
#line 219 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_class_reset_ready_events (_tmp18_);
#line 221 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		result = TRUE;
#line 221 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (inserts);
#line 221 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (deletes);
#line 221 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		block4_data_unref (_data4_);
#line 221 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_data4_ = NULL;
#line 221 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		return result;
#line 2327 "tracker-resources.c"
	}
#line 223 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	result = FALSE;
#line 223 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 2333 "tracker-resources.c"
}


static gpointer _g_hash_table_ref0 (gpointer self) {
#line 235 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return self ? g_hash_table_ref (self) : NULL;
#line 2340 "tracker-resources.c"
}


static gboolean tracker_resources_on_emit_signals (TrackerResources* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	TrackerClass** _tmp1_ = NULL;
	GHashTable* writebacks = NULL;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GHashTable* _tmp6_ = NULL;
#line 226 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_events_get_classes (&_tmp0_);
#line 2356 "tracker-resources.c"
	{
		TrackerClass** cl_collection = NULL;
		gint cl_collection_length1 = 0;
		gint _cl_collection_size_ = 0;
		gint cl_it = 0;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		cl_collection = _tmp1_;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		cl_collection_length1 = _tmp0_;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		for (cl_it = 0; cl_it < _tmp0_; cl_it = cl_it + 1) {
#line 2368 "tracker-resources.c"
			TrackerClass* _tmp2_ = NULL;
			TrackerClass* cl = NULL;
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp2_ = _g_object_ref0 (cl_collection[cl_it]);
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			cl = _tmp2_;
#line 2375 "tracker-resources.c"
			{
				TrackerClass* _tmp3_ = NULL;
#line 228 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_tmp3_ = cl;
#line 228 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				tracker_resources_emit_graph_updated (self, _tmp3_);
#line 227 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_g_object_unref0 (cl);
#line 2384 "tracker-resources.c"
			}
		}
	}
#line 232 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_events_get_total (TRUE);
#line 235 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = tracker_writeback_get_ready ();
#line 235 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
#line 235 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	writebacks = _tmp5_;
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp6_ = writebacks;
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp6_ != NULL) {
#line 2400 "tracker-resources.c"
		GVariantBuilder* builder = NULL;
		GVariantBuilder* _tmp7_ = NULL;
		GHashTableIter wb_iter = {0};
		GHashTable* _tmp8_ = NULL;
		gint subject_id = 0;
		GArray* types = NULL;
		GVariantBuilder* _tmp27_ = NULL;
		GVariant* _tmp28_ = NULL;
		GVariant* _tmp29_ = NULL;
#line 238 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp7_ = g_variant_builder_new ((const GVariantType*) "a{iai}");
#line 238 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		builder = _tmp7_;
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp8_ = writebacks;
#line 240 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_hash_table_iter_init (&wb_iter, _tmp8_);
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		while (TRUE) {
#line 2420 "tracker-resources.c"
			gconstpointer _tmp9_ = NULL;
			gconstpointer _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			GVariantBuilder* _tmp12_ = NULL;
			GVariantBuilder* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			GVariantBuilder* _tmp15_ = NULL;
			GVariantBuilder* _tmp25_ = NULL;
			GVariantBuilder* _tmp26_ = NULL;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp11_ = g_hash_table_iter_next (&wb_iter, (gpointer*) (&_tmp9_), (gpointer*) (&_tmp10_));
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			subject_id = _tmp9_;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			types = _tmp10_;
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			if (!_tmp11_) {
#line 244 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				break;
#line 2440 "tracker-resources.c"
			}
#line 245 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp12_ = builder;
#line 245 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_open (_tmp12_, (const GVariantType*) "{iai}");
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp13_ = builder;
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp14_ = subject_id;
#line 247 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_add (_tmp13_, "i", _tmp14_, NULL);
#line 249 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp15_ = builder;
#line 249 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_open (_tmp15_, (const GVariantType*) "ai");
#line 2456 "tracker-resources.c"
			{
				gint i = 0;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				i = 0;
#line 2461 "tracker-resources.c"
				{
					gboolean _tmp16_ = FALSE;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					_tmp16_ = TRUE;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
					while (TRUE) {
#line 2468 "tracker-resources.c"
						gint _tmp18_ = 0;
						GArray* _tmp19_ = NULL;
						guint _tmp20_ = 0U;
						GVariantBuilder* _tmp21_ = NULL;
						GArray* _tmp22_ = NULL;
						gint _tmp23_ = 0;
						gint _tmp24_ = 0;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						if (!_tmp16_) {
#line 2478 "tracker-resources.c"
							gint _tmp17_ = 0;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
							_tmp17_ = i;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
							i = _tmp17_ + 1;
#line 2484 "tracker-resources.c"
						}
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp16_ = FALSE;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp18_ = i;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp19_ = types;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp20_ = _tmp19_->len;
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						if (!(((guint) _tmp18_) < _tmp20_)) {
#line 250 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
							break;
#line 2498 "tracker-resources.c"
						}
#line 251 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp21_ = builder;
#line 251 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp22_ = types;
#line 251 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp23_ = i;
#line 251 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						_tmp24_ = g_array_index (_tmp22_, gint, (guint) _tmp23_);
#line 251 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
						g_variant_builder_add (_tmp21_, "i", _tmp24_, NULL);
#line 2510 "tracker-resources.c"
					}
				}
			}
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp25_ = builder;
#line 253 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_close (_tmp25_);
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp26_ = builder;
#line 255 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_variant_builder_close (_tmp26_);
#line 2522 "tracker-resources.c"
		}
#line 258 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp27_ = builder;
#line 258 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp28_ = g_variant_builder_end (_tmp27_);
#line 258 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_variant_ref_sink (_tmp28_);
#line 258 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp29_ = _tmp28_;
#line 258 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_signal_emit_by_name (self, "writeback", _tmp29_);
#line 258 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_unref0 (_tmp29_);
#line 237 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_g_variant_builder_unref0 (builder);
#line 2538 "tracker-resources.c"
	}
#line 261 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_reset_ready ();
#line 263 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv->regular_commit_pending = FALSE;
#line 264 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv->signal_timeout = (guint) 0;
#line 265 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	result = FALSE;
#line 265 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_hash_table_unref0 (writebacks);
#line 265 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 2552 "tracker-resources.c"
}


static gboolean _tracker_resources_on_emit_signals_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_resources_on_emit_signals ((TrackerResources*) self);
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	return result;
#line 2561 "tracker-resources.c"
}


static void tracker_resources_on_statements_committed (TrackerResources* self, TrackerDataCommitType commit_type) {
	gint _tmp0_ = 0;
	TrackerClass** _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	TrackerDataCommitType _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
#line 268 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = tracker_events_get_classes (&_tmp0_);
#line 2576 "tracker-resources.c"
	{
		TrackerClass** cl_collection = NULL;
		gint cl_collection_length1 = 0;
		gint _cl_collection_size_ = 0;
		gint cl_it = 0;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		cl_collection = _tmp1_;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		cl_collection_length1 = _tmp0_;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		for (cl_it = 0; cl_it < _tmp0_; cl_it = cl_it + 1) {
#line 2588 "tracker-resources.c"
			TrackerClass* _tmp2_ = NULL;
			TrackerClass* cl = NULL;
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp2_ = _g_object_ref0 (cl_collection[cl_it]);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			cl = _tmp2_;
#line 2595 "tracker-resources.c"
			{
				TrackerClass* _tmp3_ = NULL;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_tmp3_ = cl;
#line 272 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				tracker_class_transact_events (_tmp3_);
#line 271 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
				_g_object_unref0 (cl);
#line 2604 "tracker-resources.c"
			}
		}
	}
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = self->priv->regular_commit_pending;
#line 275 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (!_tmp4_) {
#line 2612 "tracker-resources.c"
		guint _tmp5_ = 0U;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp5_ = self->priv->signal_timeout;
#line 284 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_tmp5_ != ((guint) 0)) {
#line 2618 "tracker-resources.c"
			guint _tmp6_ = 0U;
#line 285 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp6_ = self->priv->signal_timeout;
#line 285 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_source_remove (_tmp6_);
#line 286 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = (guint) 0;
#line 2626 "tracker-resources.c"
		}
	}
#line 290 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp7_ = commit_type;
#line 290 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp7_ == TRACKER_DATA_COMMIT_REGULAR) {
#line 291 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		self->priv->regular_commit_pending = TRUE;
#line 2635 "tracker-resources.c"
	}
#line 294 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp9_ = self->priv->regular_commit_pending;
#line 294 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp9_) {
#line 294 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp8_ = TRUE;
#line 2643 "tracker-resources.c"
	} else {
		TrackerDataCommitType _tmp10_ = 0;
#line 294 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp10_ = commit_type;
#line 294 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp8_ = _tmp10_ == TRACKER_DATA_COMMIT_BATCH_LAST;
#line 2650 "tracker-resources.c"
	}
#line 294 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp8_) {
#line 2654 "tracker-resources.c"
		guint _tmp11_ = 0U;
#line 296 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp11_ = self->priv->signal_timeout;
#line 296 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_tmp11_ == ((guint) 0)) {
#line 2660 "tracker-resources.c"
			TrackerConfig* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			guint _tmp15_ = 0U;
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp12_ = self->priv->config;
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp13_ = tracker_config_get_graphupdated_delay (_tmp12_);
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp14_ = _tmp13_;
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp15_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp14_, _tracker_resources_on_emit_signals_gsource_func, g_object_ref (self), g_object_unref);
#line 297 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = _tmp15_;
#line 2675 "tracker-resources.c"
		}
	}
#line 302 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_transact ();
#line 2680 "tracker-resources.c"
}


static void tracker_resources_on_statements_rolled_back (TrackerResources* self, TrackerDataCommitType commit_type) {
#line 305 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 306 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_events_reset_pending ();
#line 307 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_reset_pending ();
#line 2691 "tracker-resources.c"
}


static void tracker_resources_check_graph_updated_signal (TrackerResources* self) {
	guint _tmp0_ = 0U;
#line 310 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 312 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = tracker_events_get_total (FALSE);
#line 312 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp0_ > ((guint) TRACKER_RESOURCES_GRAPH_UPDATED_IMMEDIATE_EMIT_AT)) {
#line 2703 "tracker-resources.c"
		guint _tmp1_ = 0U;
#line 316 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp1_ = self->priv->signal_timeout;
#line 316 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		if (_tmp1_ != ((guint) 0)) {
#line 2709 "tracker-resources.c"
			guint _tmp2_ = 0U;
#line 317 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			_tmp2_ = self->priv->signal_timeout;
#line 317 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			g_source_remove (_tmp2_);
#line 318 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
			self->priv->signal_timeout = (guint) 0;
#line 2717 "tracker-resources.c"
		}
#line 322 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		tracker_resources_on_emit_signals (self);
#line 2721 "tracker-resources.c"
	}
}


static void tracker_resources_on_statement_inserted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	GPtrArray* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	GPtrArray* _tmp14_ = NULL;
#line 326 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 326 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (subject != NULL);
#line 326 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (rdf_types != NULL);
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = graph_id;
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = subject_id;
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = subject;
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = pred_id;
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = object_id;
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp5_ = object;
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp6_ = rdf_types;
#line 327 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_events_add_insert (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp7_ = graph_id;
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp8_ = graph;
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp9_ = subject_id;
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp10_ = subject;
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp11_ = pred_id;
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp12_ = object_id;
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp13_ = object;
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp14_ = rdf_types;
#line 328 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_check (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
#line 329 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_check_graph_updated_signal (self);
#line 2784 "tracker-resources.c"
}


static void tracker_resources_on_statement_deleted (TrackerResources* self, gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint pred_id, gint object_id, const gchar* object, GPtrArray* rdf_types) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	GPtrArray* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	GPtrArray* _tmp14_ = NULL;
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (subject != NULL);
#line 332 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (rdf_types != NULL);
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = graph_id;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp1_ = subject_id;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp2_ = subject;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp3_ = pred_id;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp4_ = object_id;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp5_ = object;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp6_ = rdf_types;
#line 333 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_events_add_delete (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp7_ = graph_id;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp8_ = graph;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp9_ = subject_id;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp10_ = subject;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp11_ = pred_id;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp12_ = object_id;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp13_ = object;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp14_ = rdf_types;
#line 334 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_writeback_check (_tmp7_, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
#line 335 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_check_graph_updated_signal (self);
#line 2846 "tracker-resources.c"
}


static void _tracker_resources_on_statement_inserted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self) {
#line 340 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statement_inserted ((TrackerResources*) self, graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
#line 2853 "tracker-resources.c"
}


static void _tracker_resources_on_statement_deleted_tracker_statement_callback (gint graph_id, const gchar* graph, gint subject_id, const gchar* subject, gint predicate_id, gint object_id, const gchar* object, GPtrArray* rdf_types, gpointer self) {
#line 341 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statement_deleted ((TrackerResources*) self, graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
#line 2860 "tracker-resources.c"
}


static void _tracker_resources_on_statements_committed_tracker_commit_callback (TrackerDataCommitType commit_type, gpointer self) {
#line 342 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statements_committed ((TrackerResources*) self, commit_type);
#line 2867 "tracker-resources.c"
}


static void _tracker_resources_on_statements_rolled_back_tracker_commit_callback (TrackerDataCommitType commit_type, gpointer self) {
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_on_statements_rolled_back ((TrackerResources*) self, commit_type);
#line 2874 "tracker-resources.c"
}


void tracker_resources_enable_signals (TrackerResources* self) {
#line 339 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 340 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_add_insert_statement_callback (_tracker_resources_on_statement_inserted_tracker_statement_callback, self);
#line 341 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_add_delete_statement_callback (_tracker_resources_on_statement_deleted_tracker_statement_callback, self);
#line 342 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_add_commit_statement_callback (_tracker_resources_on_statements_committed_tracker_commit_callback, self);
#line 343 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_add_rollback_statement_callback (_tracker_resources_on_statements_rolled_back_tracker_commit_callback, self);
#line 2889 "tracker-resources.c"
}


void tracker_resources_disable_signals (TrackerResources* self) {
	guint _tmp0_ = 0U;
#line 347 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 348 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_insert_statement_callback (_tracker_resources_on_statement_inserted_tracker_statement_callback, self);
#line 349 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_delete_statement_callback (_tracker_resources_on_statement_deleted_tracker_statement_callback, self);
#line 350 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_commit_statement_callback (_tracker_resources_on_statements_committed_tracker_commit_callback, self);
#line 351 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_data_remove_rollback_statement_callback (_tracker_resources_on_statements_rolled_back_tracker_commit_callback, self);
#line 353 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = self->priv->signal_timeout;
#line 353 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 2909 "tracker-resources.c"
		guint _tmp1_ = 0U;
#line 354 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		_tmp1_ = self->priv->signal_timeout;
#line 354 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		g_source_remove (_tmp1_);
#line 2915 "tracker-resources.c"
	}
}


void tracker_resources_unreg_batches (TrackerResources* self, const gchar* old_owner) {
	const gchar* _tmp0_ = NULL;
#line 363 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (self != NULL);
#line 363 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (old_owner != NULL);
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_tmp0_ = old_owner;
#line 364 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_store_unreg_batches (_tmp0_);
#line 2930 "tracker-resources.c"
}


static void g_cclosure_user_marshal_VOID__VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__VARIANT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (n_param_values == 2);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data1 = closure->data;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data2 = param_values->data[0].v_pointer;
#line 2949 "tracker-resources.c"
	} else {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data1 = param_values->data[0].v_pointer;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data2 = closure->data;
#line 2955 "tracker-resources.c"
	}
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	callback = (GMarshalFunc_VOID__VARIANT) (marshal_data ? marshal_data : cc->callback);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	callback (data1, g_value_get_variant (param_values + 1), data2);
#line 2961 "tracker-resources.c"
}


static void g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_VARIANT_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_return_if_fail (n_param_values == 4);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data1 = closure->data;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data2 = param_values->data[0].v_pointer;
#line 2980 "tracker-resources.c"
	} else {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data1 = param_values->data[0].v_pointer;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
		data2 = closure->data;
#line 2986 "tracker-resources.c"
	}
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	callback = (GMarshalFunc_VOID__STRING_VARIANT_VARIANT) (marshal_data ? marshal_data : cc->callback);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_variant (param_values + 2), g_value_get_variant (param_values + 3), data2);
#line 2992 "tracker-resources.c"
}


static void tracker_resources_class_init (TrackerResourcesClass * klass) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_type_class_add_private (klass, sizeof (TrackerResourcesPrivate));
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_resources_finalize;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_signal_new ("writeback", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__VARIANT, G_TYPE_NONE, 1, G_TYPE_VARIANT);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	g_signal_new ("graph_updated", TRACKER_TYPE_RESOURCES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_VARIANT_VARIANT, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);
#line 3007 "tracker-resources.c"
}


static void tracker_resources_instance_init (TrackerResources * self) {
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self->priv = TRACKER_RESOURCES_GET_PRIVATE (self);
#line 3014 "tracker-resources.c"
}


static void tracker_resources_finalize (GObject* obj) {
	TrackerResources * self;
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_RESOURCES, TrackerResources);
#line 359 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	tracker_resources_disable_signals (self);
#line 52 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->connection);
#line 55 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	_g_object_unref0 (self->priv->config);
#line 22 "/home/martyn/Source/checkout/gnome/tracker/src/tracker-store/tracker-resources.vala"
	G_OBJECT_CLASS (tracker_resources_parent_class)->finalize (obj);
#line 3030 "tracker-resources.c"
}


GType tracker_resources_get_type (void) {
	static volatile gsize tracker_resources_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_resources_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerResourcesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_resources_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerResources), 0, (GInstanceInitFunc) tracker_resources_instance_init, NULL };
		GType tracker_resources_type_id;
		tracker_resources_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerResources", &g_define_type_info, 0);
		g_type_set_qdata (tracker_resources_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) tracker_resources_register_object);
		g_once_init_leave (&tracker_resources_type_id__volatile, tracker_resources_type_id);
	}
	return tracker_resources_type_id__volatile;
}


static void _dbus_tracker_resources_load (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	tracker_resources_load (self, g_dbus_method_invocation_get_sender (invocation), uri, (GAsyncReadyCallback) _dbus_tracker_resources_load_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_tracker_resources_load_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_load_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_query (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* query = NULL;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	query = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	tracker_resources_sparql_query (self, g_dbus_method_invocation_get_sender (invocation), query, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_query_ready, invocation);
	_g_free0 (query);
}


static void _dbus_tracker_resources_sparql_query_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_resources_sparql_query_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_update (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	tracker_resources_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sparql_update_blank (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp5_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	tracker_resources_sparql_update_blank (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_sparql_update_blank_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_sparql_update_blank_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* result;
	invocation = _user_data_;
	result = tracker_resources_sparql_update_blank_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, result);
	_g_variant_unref0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_sync (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_resources_sync (self, g_dbus_method_invocation_get_sender (invocation));
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_batch_sparql_update (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* update = NULL;
	GVariant* _tmp6_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	update = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	tracker_resources_batch_sparql_update (self, g_dbus_method_invocation_get_sender (invocation), update, (GAsyncReadyCallback) _dbus_tracker_resources_batch_sparql_update_ready, invocation);
	_g_free0 (update);
}


static void _dbus_tracker_resources_batch_sparql_update_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	tracker_resources_batch_sparql_update_finish ((TrackerResources*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_tracker_resources_batch_commit (TrackerResources* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	tracker_resources_batch_commit (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void tracker_resources_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Load") == 0) {
		_dbus_tracker_resources_load (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlQuery") == 0) {
		_dbus_tracker_resources_sparql_query (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdate") == 0) {
		_dbus_tracker_resources_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "SparqlUpdateBlank") == 0) {
		_dbus_tracker_resources_sparql_update_blank (object, parameters, invocation);
	} else if (strcmp (method_name, "Sync") == 0) {
		_dbus_tracker_resources_sync (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchSparqlUpdate") == 0) {
		_dbus_tracker_resources_batch_sparql_update (object, parameters, invocation);
	} else if (strcmp (method_name, "BatchCommit") == 0) {
		_dbus_tracker_resources_batch_commit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* tracker_resources_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean tracker_resources_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_tracker_resources_writeback (GObject* _sender, GVariant* subjects, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, subjects);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "Writeback", _arguments, NULL);
}


static void _dbus_tracker_resources_graph_updated (GObject* _sender, const gchar* classname, GVariant* deletes, GVariant* inserts, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (classname));
	g_variant_builder_add_value (&_arguments_builder, deletes);
	g_variant_builder_add_value (&_arguments_builder, inserts);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.Tracker1.Resources", "GraphUpdated", _arguments, NULL);
}


guint tracker_resources_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_tracker_resources_dbus_interface_info), &_tracker_resources_dbus_interface_vtable, data, _tracker_resources_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "writeback", (GCallback) _dbus_tracker_resources_writeback, data);
	g_signal_connect (object, "graph-updated", (GCallback) _dbus_tracker_resources_graph_updated, data);
	return result;
}


static void _tracker_resources_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_resources_writeback, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_tracker_resources_graph_updated, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}



