/* math-preferences.c generated by valac 0.24.0, the Vala compiler
 * generated from math-preferences.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MATH_PREFERENCES_DIALOG (math_preferences_dialog_get_type ())
#define MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog))
#define MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))
#define IS_MATH_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_PREFERENCES_DIALOG))
#define IS_MATH_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_PREFERENCES_DIALOG))
#define MATH_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogClass))

typedef struct _MathPreferencesDialog MathPreferencesDialog;
typedef struct _MathPreferencesDialogClass MathPreferencesDialogClass;
typedef struct _MathPreferencesDialogPrivate MathPreferencesDialogPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MathPreferencesDialog {
	GtkDialog parent_instance;
	MathPreferencesDialogPrivate * priv;
};

struct _MathPreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _MathPreferencesDialogPrivate {
	MathEquation* _equation;
	GtkComboBox* angle_unit_combo;
	GtkComboBox* number_format_combo;
	GtkComboBox* word_size_combo;
	GtkSpinButton* decimal_places_spin;
	GtkCheckButton* thousands_separator_check;
	GtkCheckButton* trailing_zeroes_check;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;


static gpointer math_preferences_dialog_parent_class = NULL;

GType math_preferences_dialog_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
#define MATH_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialogPrivate))
enum  {
	MATH_PREFERENCES_DIALOG_DUMMY_PROPERTY,
	MATH_PREFERENCES_DIALOG_EQUATION
};
MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq);
MathPreferencesDialog* math_preferences_dialog_construct (GType object_type, MathEquation* eq);
static void math_preferences_dialog_real_response (GtkDialog* base, gint id);
static gboolean math_preferences_dialog_real_delete_event (GtkWidget* base, GdkEventAny* event);
static void math_preferences_dialog_number_format_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo);
GType display_format_get_type (void) G_GNUC_CONST;
static MathEquation* math_preferences_dialog_get_equation (MathPreferencesDialog* self);
void math_equation_set_number_format (MathEquation* self, DisplayFormat value);
static void math_preferences_dialog_angle_unit_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo);
GType angle_unit_get_type (void) G_GNUC_CONST;
void math_equation_set_angle_units (MathEquation* self, AngleUnit value);
static void math_preferences_dialog_word_size_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo);
void math_equation_set_word_size (MathEquation* self, gint value);
static void math_preferences_dialog_set_combo_box_from_int (MathPreferencesDialog* self, GtkComboBox* combo, gint value);
static void math_preferences_dialog_set_equation (MathPreferencesDialog* self, MathEquation* value);
static GObject * math_preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _math_preferences_dialog_number_format_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _math_preferences_dialog___lambda33_ (MathPreferencesDialog* self);
void math_equation_set_accuracy (MathEquation* self, gint value);
static void __math_preferences_dialog___lambda33__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self);
static void _math_preferences_dialog___lambda34_ (MathPreferencesDialog* self);
void math_equation_set_show_trailing_zeroes (MathEquation* self, gboolean value);
static void __math_preferences_dialog___lambda34__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _math_preferences_dialog___lambda35_ (MathPreferencesDialog* self);
void math_equation_set_show_thousands_separators (MathEquation* self, gboolean value);
static void __math_preferences_dialog___lambda35__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _math_preferences_dialog_angle_unit_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _math_preferences_dialog_word_size_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
gint math_equation_get_accuracy (MathEquation* self);
static void _math_preferences_dialog___lambda36_ (MathPreferencesDialog* self, GParamSpec* pspec);
static void __math_preferences_dialog___lambda36__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean math_equation_get_show_thousands_separators (MathEquation* self);
static void _math_preferences_dialog___lambda37_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda37__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean math_equation_get_show_trailing_zeroes (MathEquation* self);
static void _math_preferences_dialog___lambda38_ (MathPreferencesDialog* self);
static void __math_preferences_dialog___lambda38__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
DisplayFormat math_equation_get_number_format (MathEquation* self);
static void _math_preferences_dialog___lambda39_ (MathPreferencesDialog* self, GParamSpec* pspec);
static void __math_preferences_dialog___lambda39__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gint math_equation_get_word_size (MathEquation* self);
static void _math_preferences_dialog___lambda40_ (MathPreferencesDialog* self, GParamSpec* pspec);
static void __math_preferences_dialog___lambda40__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
AngleUnit math_equation_get_angle_units (MathEquation* self);
static void _math_preferences_dialog___lambda41_ (MathPreferencesDialog* self, GParamSpec* pspec);
static void __math_preferences_dialog___lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_preferences_dialog_finalize (GObject* obj);
static void _vala_math_preferences_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_preferences_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


MathPreferencesDialog* math_preferences_dialog_construct (GType object_type, MathEquation* eq) {
	MathPreferencesDialog * self = NULL;
	MathEquation* _tmp0_ = NULL;
	g_return_val_if_fail (eq != NULL, NULL);
	_tmp0_ = eq;
	self = (MathPreferencesDialog*) g_object_new (object_type, "use-header-bar", 1, "equation", _tmp0_, NULL);
	return self;
}


MathPreferencesDialog* math_preferences_dialog_new (MathEquation* eq) {
	return math_preferences_dialog_construct (TYPE_MATH_PREFERENCES_DIALOG, eq);
}


static void math_preferences_dialog_real_response (GtkDialog* base, gint id) {
	MathPreferencesDialog * self;
	self = (MathPreferencesDialog*) base;
	gtk_widget_hide ((GtkWidget*) self);
}


static gboolean math_preferences_dialog_real_delete_event (GtkWidget* base, GdkEventAny* event) {
	MathPreferencesDialog * self;
	gboolean result = FALSE;
	self = (MathPreferencesDialog*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	gtk_widget_hide ((GtkWidget*) self);
	result = TRUE;
	return result;
}


static void math_preferences_dialog_number_format_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	DisplayFormat value = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	MathEquation* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &value, -1, -1);
	_tmp6_ = self->priv->_equation;
	math_equation_set_number_format (_tmp6_, value);
}


static void math_preferences_dialog_angle_unit_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	AngleUnit value = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	MathEquation* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &value, -1, -1);
	_tmp6_ = self->priv->_equation;
	math_equation_set_angle_units (_tmp6_, value);
}


static void math_preferences_dialog_word_size_combo_changed_cb (MathPreferencesDialog* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint value = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	MathEquation* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &value, -1, -1);
	_tmp6_ = self->priv->_equation;
	math_equation_set_word_size (_tmp6_, value);
}


static void math_preferences_dialog_set_combo_box_from_int (MathPreferencesDialog* self, GtkComboBox* combo, gint value) {
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GtkComboBox* _tmp22_ = NULL;
	GtkTreeIter _tmp23_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = gtk_tree_model_get_iter_first (_tmp2_, &_tmp3_);
	iter = _tmp3_;
	valid = _tmp4_;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		gint v = 0;
		GtkComboBox* _tmp6_ = NULL;
		GtkTreeModel* _tmp7_ = NULL;
		GtkTreeModel* _tmp8_ = NULL;
		GtkTreeIter _tmp9_ = {0};
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		GtkComboBox* _tmp12_ = NULL;
		GtkTreeModel* _tmp13_ = NULL;
		GtkTreeModel* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp5_ = valid;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = combo;
		_tmp7_ = gtk_combo_box_get_model (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = iter;
		gtk_tree_model_get (_tmp8_, &_tmp9_, 1, &v, -1, -1);
		_tmp10_ = v;
		_tmp11_ = value;
		if (_tmp10_ == _tmp11_) {
			break;
		}
		_tmp12_ = combo;
		_tmp13_ = gtk_combo_box_get_model (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gtk_tree_model_iter_next (_tmp14_, &iter);
		valid = _tmp15_;
	}
	_tmp16_ = valid;
	if (!_tmp16_) {
		GtkComboBox* _tmp17_ = NULL;
		GtkTreeModel* _tmp18_ = NULL;
		GtkTreeModel* _tmp19_ = NULL;
		GtkTreeIter _tmp20_ = {0};
		gboolean _tmp21_ = FALSE;
		_tmp17_ = combo;
		_tmp18_ = gtk_combo_box_get_model (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp21_ = gtk_tree_model_get_iter_first (_tmp19_, &_tmp20_);
		iter = _tmp20_;
		valid = _tmp21_;
	}
	_tmp22_ = combo;
	_tmp23_ = iter;
	gtk_combo_box_set_active_iter (_tmp22_, &_tmp23_);
}


static MathEquation* math_preferences_dialog_get_equation (MathPreferencesDialog* self) {
	MathEquation* result;
	MathEquation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void math_preferences_dialog_set_equation (MathPreferencesDialog* self, MathEquation* value) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_equation);
	self->priv->_equation = _tmp1_;
	g_object_notify ((GObject *) self, "equation");
}


static void _math_preferences_dialog_number_format_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_preferences_dialog_number_format_combo_changed_cb ((MathPreferencesDialog*) self, _sender);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void _math_preferences_dialog___lambda33_ (MathPreferencesDialog* self) {
	MathEquation* _tmp0_ = NULL;
	GtkSpinButton* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	_tmp0_ = self->priv->_equation;
	_tmp1_ = self->priv->decimal_places_spin;
	_tmp2_ = gtk_spin_button_get_value_as_int (_tmp1_);
	math_equation_set_accuracy (_tmp0_, _tmp2_);
}


static void __math_preferences_dialog___lambda33__gtk_spin_button_value_changed (GtkSpinButton* _sender, gpointer self) {
	_math_preferences_dialog___lambda33_ ((MathPreferencesDialog*) self);
}


static void _math_preferences_dialog___lambda34_ (MathPreferencesDialog* self) {
	MathEquation* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->_equation;
	_tmp1_ = self->priv->trailing_zeroes_check;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	math_equation_set_show_trailing_zeroes (_tmp0_, _tmp2_);
}


static void __math_preferences_dialog___lambda34__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_math_preferences_dialog___lambda34_ ((MathPreferencesDialog*) self);
}


static void _math_preferences_dialog___lambda35_ (MathPreferencesDialog* self) {
	MathEquation* _tmp0_ = NULL;
	GtkCheckButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->_equation;
	_tmp1_ = self->priv->thousands_separator_check;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	math_equation_set_show_thousands_separators (_tmp0_, _tmp2_);
}


static void __math_preferences_dialog___lambda35__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_math_preferences_dialog___lambda35_ ((MathPreferencesDialog*) self);
}


static void _math_preferences_dialog_angle_unit_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_preferences_dialog_angle_unit_combo_changed_cb ((MathPreferencesDialog*) self, _sender);
}


static void _math_preferences_dialog_word_size_combo_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_preferences_dialog_word_size_combo_changed_cb ((MathPreferencesDialog*) self, _sender);
}


static void _math_preferences_dialog___lambda36_ (MathPreferencesDialog* self, GParamSpec* pspec) {
	GtkSpinButton* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->decimal_places_spin;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_accuracy (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_spin_button_set_value (_tmp0_, (gdouble) _tmp3_);
}


static void __math_preferences_dialog___lambda36__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_math_preferences_dialog___lambda36_ ((MathPreferencesDialog*) self, pspec);
}


static void _math_preferences_dialog___lambda37_ (MathPreferencesDialog* self) {
	GtkCheckButton* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->thousands_separator_check;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_show_thousands_separators (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, _tmp3_);
}


static void __math_preferences_dialog___lambda37__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_math_preferences_dialog___lambda37_ ((MathPreferencesDialog*) self);
}


static void _math_preferences_dialog___lambda38_ (MathPreferencesDialog* self) {
	GtkCheckButton* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->trailing_zeroes_check;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_show_trailing_zeroes (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, _tmp3_);
}


static void __math_preferences_dialog___lambda38__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_math_preferences_dialog___lambda38_ ((MathPreferencesDialog*) self);
}


static void _math_preferences_dialog___lambda39_ (MathPreferencesDialog* self, GParamSpec* pspec) {
	GtkComboBox* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	DisplayFormat _tmp2_ = 0;
	DisplayFormat _tmp3_ = 0;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->number_format_combo;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_number_format (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp0_, (gint) _tmp3_);
}


static void __math_preferences_dialog___lambda39__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_math_preferences_dialog___lambda39_ ((MathPreferencesDialog*) self, pspec);
}


static void _math_preferences_dialog___lambda40_ (MathPreferencesDialog* self, GParamSpec* pspec) {
	GtkComboBox* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->word_size_combo;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_word_size (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp0_, _tmp3_);
}


static void __math_preferences_dialog___lambda40__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_math_preferences_dialog___lambda40_ ((MathPreferencesDialog*) self, pspec);
}


static void _math_preferences_dialog___lambda41_ (MathPreferencesDialog* self, GParamSpec* pspec) {
	GtkComboBox* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	AngleUnit _tmp2_ = 0;
	AngleUnit _tmp3_ = 0;
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->angle_unit_combo;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_angle_units (_tmp1_);
	_tmp3_ = _tmp2_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp0_, (gint) _tmp3_);
}


static void __math_preferences_dialog___lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_math_preferences_dialog___lambda41_ ((MathPreferencesDialog*) self, pspec);
}


static GObject * math_preferences_dialog_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MathPreferencesDialog * self;
	const gchar* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp2_ = NULL;
	GtkGrid* _tmp3_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	GtkGrid* _tmp5_ = NULL;
	GtkGrid* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkGrid* _tmp8_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkComboBox* _tmp15_ = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkComboBox* _tmp17_ = NULL;
	GtkComboBox* _tmp18_ = NULL;
	GtkComboBox* _tmp19_ = NULL;
	GtkGrid* _tmp20_ = NULL;
	GtkComboBox* _tmp21_ = NULL;
	GtkListStore* model = NULL;
	GtkListStore* _tmp22_ = NULL;
	GtkComboBox* _tmp23_ = NULL;
	GtkListStore* _tmp24_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp25_ = NULL;
	GtkTreeIter _tmp26_ = {0};
	GtkListStore* _tmp27_ = NULL;
	GtkTreeIter _tmp28_ = {0};
	const gchar* _tmp29_ = NULL;
	GtkListStore* _tmp30_ = NULL;
	GtkTreeIter _tmp31_ = {0};
	GtkListStore* _tmp32_ = NULL;
	GtkTreeIter _tmp33_ = {0};
	const gchar* _tmp34_ = NULL;
	GtkListStore* _tmp35_ = NULL;
	GtkTreeIter _tmp36_ = {0};
	GtkListStore* _tmp37_ = NULL;
	GtkTreeIter _tmp38_ = {0};
	const gchar* _tmp39_ = NULL;
	GtkListStore* _tmp40_ = NULL;
	GtkTreeIter _tmp41_ = {0};
	GtkListStore* _tmp42_ = NULL;
	GtkTreeIter _tmp43_ = {0};
	const gchar* _tmp44_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp45_ = NULL;
	GtkComboBox* _tmp46_ = NULL;
	GtkCellRendererText* _tmp47_ = NULL;
	GtkComboBox* _tmp48_ = NULL;
	GtkCellRendererText* _tmp49_ = NULL;
	GtkAlignment* alignment = NULL;
	GtkAlignment* _tmp50_ = NULL;
	GtkAlignment* _tmp51_ = NULL;
	GtkAlignment* _tmp52_ = NULL;
	GtkAlignment* _tmp53_ = NULL;
	GtkGrid* _tmp54_ = NULL;
	GtkAlignment* _tmp55_ = NULL;
	GtkBox* format_options_box = NULL;
	GtkBox* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkAlignment* _tmp58_ = NULL;
	GtkBox* _tmp59_ = NULL;
	GtkBox* places_box = NULL;
	GtkBox* _tmp60_ = NULL;
	GtkBox* _tmp61_ = NULL;
	GtkBox* _tmp62_ = NULL;
	GtkBox* _tmp63_ = NULL;
	gchar* string = NULL;
	const gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp66_ = NULL;
	gchar** _tmp67_ = NULL;
	gchar** _tmp68_ = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	GtkAdjustment* decimal_places_adjustment = NULL;
	GtkAdjustment* _tmp69_ = NULL;
	GtkAdjustment* _tmp70_ = NULL;
	GtkSpinButton* _tmp71_ = NULL;
	gchar** _tmp72_ = NULL;
	gint _tmp72__length1 = 0;
	GtkSpinButton* _tmp83_ = NULL;
	GtkSpinButton* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkSpinButton* _tmp86_ = NULL;
	gchar** _tmp87_ = NULL;
	gint _tmp87__length1 = 0;
	const gchar* _tmp98_ = NULL;
	GtkCheckButton* _tmp99_ = NULL;
	GtkCheckButton* _tmp100_ = NULL;
	GtkCheckButton* _tmp101_ = NULL;
	GtkBox* _tmp102_ = NULL;
	GtkCheckButton* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	GtkCheckButton* _tmp105_ = NULL;
	GtkCheckButton* _tmp106_ = NULL;
	GtkCheckButton* _tmp107_ = NULL;
	GtkBox* _tmp108_ = NULL;
	GtkCheckButton* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	GtkLabel* _tmp111_ = NULL;
	GtkLabel* _tmp112_ = NULL;
	GtkLabel* _tmp113_ = NULL;
	GtkGrid* _tmp114_ = NULL;
	GtkLabel* _tmp115_ = NULL;
	GtkComboBox* _tmp116_ = NULL;
	GtkLabel* _tmp117_ = NULL;
	GtkComboBox* _tmp118_ = NULL;
	GtkComboBox* _tmp119_ = NULL;
	GtkComboBox* _tmp120_ = NULL;
	GtkGrid* _tmp121_ = NULL;
	GtkComboBox* _tmp122_ = NULL;
	GtkListStore* _tmp123_ = NULL;
	GtkComboBox* _tmp124_ = NULL;
	GtkListStore* _tmp125_ = NULL;
	GtkListStore* _tmp126_ = NULL;
	GtkTreeIter _tmp127_ = {0};
	GtkListStore* _tmp128_ = NULL;
	GtkTreeIter _tmp129_ = {0};
	const gchar* _tmp130_ = NULL;
	GtkListStore* _tmp131_ = NULL;
	GtkTreeIter _tmp132_ = {0};
	GtkListStore* _tmp133_ = NULL;
	GtkTreeIter _tmp134_ = {0};
	const gchar* _tmp135_ = NULL;
	GtkListStore* _tmp136_ = NULL;
	GtkTreeIter _tmp137_ = {0};
	GtkListStore* _tmp138_ = NULL;
	GtkTreeIter _tmp139_ = {0};
	const gchar* _tmp140_ = NULL;
	GtkCellRendererText* _tmp141_ = NULL;
	GtkComboBox* _tmp142_ = NULL;
	GtkCellRendererText* _tmp143_ = NULL;
	GtkComboBox* _tmp144_ = NULL;
	GtkCellRendererText* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	GtkLabel* _tmp147_ = NULL;
	GtkLabel* _tmp148_ = NULL;
	GtkLabel* _tmp149_ = NULL;
	GtkGrid* _tmp150_ = NULL;
	GtkLabel* _tmp151_ = NULL;
	GtkComboBox* _tmp152_ = NULL;
	GtkLabel* _tmp153_ = NULL;
	GtkComboBox* _tmp154_ = NULL;
	GtkComboBox* _tmp155_ = NULL;
	GtkComboBox* _tmp156_ = NULL;
	GtkGrid* _tmp157_ = NULL;
	GtkComboBox* _tmp158_ = NULL;
	GtkListStore* _tmp159_ = NULL;
	GtkComboBox* _tmp160_ = NULL;
	GtkListStore* _tmp161_ = NULL;
	GtkListStore* _tmp162_ = NULL;
	GtkTreeIter _tmp163_ = {0};
	GtkListStore* _tmp164_ = NULL;
	GtkTreeIter _tmp165_ = {0};
	const gchar* _tmp166_ = NULL;
	GtkListStore* _tmp167_ = NULL;
	GtkTreeIter _tmp168_ = {0};
	GtkListStore* _tmp169_ = NULL;
	GtkTreeIter _tmp170_ = {0};
	const gchar* _tmp171_ = NULL;
	GtkListStore* _tmp172_ = NULL;
	GtkTreeIter _tmp173_ = {0};
	GtkListStore* _tmp174_ = NULL;
	GtkTreeIter _tmp175_ = {0};
	const gchar* _tmp176_ = NULL;
	GtkListStore* _tmp177_ = NULL;
	GtkTreeIter _tmp178_ = {0};
	GtkListStore* _tmp179_ = NULL;
	GtkTreeIter _tmp180_ = {0};
	const gchar* _tmp181_ = NULL;
	GtkCellRendererText* _tmp182_ = NULL;
	GtkComboBox* _tmp183_ = NULL;
	GtkCellRendererText* _tmp184_ = NULL;
	GtkComboBox* _tmp185_ = NULL;
	GtkCellRendererText* _tmp186_ = NULL;
	GtkSpinButton* _tmp187_ = NULL;
	MathEquation* _tmp188_ = NULL;
	gint _tmp189_ = 0;
	gint _tmp190_ = 0;
	MathEquation* _tmp191_ = NULL;
	GtkCheckButton* _tmp192_ = NULL;
	MathEquation* _tmp193_ = NULL;
	gboolean _tmp194_ = FALSE;
	gboolean _tmp195_ = FALSE;
	MathEquation* _tmp196_ = NULL;
	GtkCheckButton* _tmp197_ = NULL;
	MathEquation* _tmp198_ = NULL;
	gboolean _tmp199_ = FALSE;
	gboolean _tmp200_ = FALSE;
	MathEquation* _tmp201_ = NULL;
	GtkComboBox* _tmp202_ = NULL;
	MathEquation* _tmp203_ = NULL;
	DisplayFormat _tmp204_ = 0;
	DisplayFormat _tmp205_ = 0;
	MathEquation* _tmp206_ = NULL;
	GtkComboBox* _tmp207_ = NULL;
	MathEquation* _tmp208_ = NULL;
	gint _tmp209_ = 0;
	gint _tmp210_ = 0;
	MathEquation* _tmp211_ = NULL;
	GtkComboBox* _tmp212_ = NULL;
	MathEquation* _tmp213_ = NULL;
	AngleUnit _tmp214_ = 0;
	AngleUnit _tmp215_ = 0;
	MathEquation* _tmp216_ = NULL;
	parent_class = G_OBJECT_CLASS (math_preferences_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	_tmp0_ = _ ("Preferences");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 8);
	_tmp1_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
	gtk_header_bar_set_show_close_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_HEADER_BAR, GtkHeaderBar), TRUE);
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	grid = _tmp2_;
	_tmp3_ = grid;
	gtk_widget_show ((GtkWidget*) _tmp3_);
	_tmp4_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp4_, (guint) 5);
	_tmp5_ = grid;
	gtk_grid_set_column_spacing (_tmp5_, 6);
	_tmp6_ = grid;
	gtk_grid_set_row_spacing (_tmp6_, 12);
	_tmp7_ = (GtkBox*) gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp8_ = grid;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, TRUE, TRUE, (guint) 0);
	_tmp9_ = _ ("Number _Format:");
	_tmp10_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp9_);
	g_object_ref_sink (_tmp10_);
	label = _tmp10_;
	_tmp11_ = label;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	_tmp12_ = label;
	g_object_set ((GtkMisc*) _tmp12_, "xalign", (gfloat) 0, NULL);
	_tmp13_ = grid;
	_tmp14_ = label;
	gtk_grid_attach (_tmp13_, (GtkWidget*) _tmp14_, 0, 0, 1, 1);
	_tmp15_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->number_format_combo);
	self->priv->number_format_combo = _tmp15_;
	_tmp16_ = label;
	_tmp17_ = self->priv->number_format_combo;
	gtk_label_set_mnemonic_widget (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->number_format_combo;
	gtk_widget_show ((GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->number_format_combo;
	g_signal_connect_object (_tmp19_, "changed", (GCallback) _math_preferences_dialog_number_format_combo_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp20_ = grid;
	_tmp21_ = self->priv->number_format_combo;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 1, 0, 1, 1);
	_tmp22_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	model = _tmp22_;
	_tmp23_ = self->priv->number_format_combo;
	_tmp24_ = model;
	gtk_combo_box_set_model (_tmp23_, (GtkTreeModel*) _tmp24_);
	_tmp25_ = model;
	gtk_list_store_append (_tmp25_, &_tmp26_);
	iter = _tmp26_;
	_tmp27_ = model;
	_tmp28_ = iter;
	_tmp29_ = _ ("Automatic");
	gtk_list_store_set (_tmp27_, &_tmp28_, 0, _tmp29_, 1, DISPLAY_FORMAT_AUTOMATIC, -1, -1);
	_tmp30_ = model;
	gtk_list_store_append (_tmp30_, &_tmp31_);
	iter = _tmp31_;
	_tmp32_ = model;
	_tmp33_ = iter;
	_tmp34_ = _ ("Fixed");
	gtk_list_store_set (_tmp32_, &_tmp33_, 0, _tmp34_, 1, DISPLAY_FORMAT_FIXED, -1, -1);
	_tmp35_ = model;
	gtk_list_store_append (_tmp35_, &_tmp36_);
	iter = _tmp36_;
	_tmp37_ = model;
	_tmp38_ = iter;
	_tmp39_ = _ ("Scientific");
	gtk_list_store_set (_tmp37_, &_tmp38_, 0, _tmp39_, 1, DISPLAY_FORMAT_SCIENTIFIC, -1, -1);
	_tmp40_ = model;
	gtk_list_store_append (_tmp40_, &_tmp41_);
	iter = _tmp41_;
	_tmp42_ = model;
	_tmp43_ = iter;
	_tmp44_ = _ ("Engineering");
	gtk_list_store_set (_tmp42_, &_tmp43_, 0, _tmp44_, 1, DISPLAY_FORMAT_ENGINEERING, -1, -1);
	_tmp45_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp45_);
	renderer = _tmp45_;
	_tmp46_ = self->priv->number_format_combo;
	_tmp47_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp46_, (GtkCellRenderer*) _tmp47_, TRUE);
	_tmp48_ = self->priv->number_format_combo;
	_tmp49_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp48_, (GtkCellRenderer*) _tmp49_, "text", 0);
	_tmp50_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 1.0f, 1.0f);
	g_object_ref_sink (_tmp50_);
	alignment = _tmp50_;
	_tmp51_ = alignment;
	g_object_set (_tmp51_, "bottom-padding", (guint) 6, NULL);
	_tmp52_ = alignment;
	g_object_set (_tmp52_, "left-padding", (guint) 12, NULL);
	_tmp53_ = alignment;
	gtk_widget_show ((GtkWidget*) _tmp53_);
	_tmp54_ = grid;
	_tmp55_ = alignment;
	gtk_grid_attach (_tmp54_, (GtkWidget*) _tmp55_, 0, 1, 2, 1);
	_tmp56_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp56_);
	format_options_box = _tmp56_;
	_tmp57_ = format_options_box;
	gtk_widget_show ((GtkWidget*) _tmp57_);
	_tmp58_ = alignment;
	_tmp59_ = format_options_box;
	gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) _tmp59_);
	_tmp60_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp60_);
	places_box = _tmp60_;
	_tmp61_ = places_box;
	gtk_widget_show ((GtkWidget*) _tmp61_);
	_tmp62_ = format_options_box;
	_tmp63_ = places_box;
	gtk_box_pack_start (_tmp62_, (GtkWidget*) _tmp63_, FALSE, FALSE, (guint) 0);
	_tmp64_ = _ ("Show %d decimal _places");
	_tmp65_ = g_strdup (_tmp64_);
	string = _tmp65_;
	_tmp66_ = string;
	_tmp68_ = _tmp67_ = g_strsplit (_tmp66_, "%d", 2);
	tokens = _tmp68_;
	tokens_length1 = _vala_array_length (_tmp67_);
	_tokens_size_ = tokens_length1;
	_tmp69_ = gtk_adjustment_new (0.0, 0.0, 9.0, 1.0, 1.0, 0.0);
	g_object_ref_sink (_tmp69_);
	decimal_places_adjustment = _tmp69_;
	_tmp70_ = decimal_places_adjustment;
	_tmp71_ = (GtkSpinButton*) gtk_spin_button_new (_tmp70_, 0.0, (guint) 0);
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->decimal_places_spin);
	self->priv->decimal_places_spin = _tmp71_;
	_tmp72_ = tokens;
	_tmp72__length1 = tokens_length1;
	if (_tmp72__length1 > 0) {
		gchar** _tmp73_ = NULL;
		gint _tmp73__length1 = 0;
		const gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		GtkLabel* _tmp77_ = NULL;
		GtkLabel* _tmp78_ = NULL;
		GtkSpinButton* _tmp79_ = NULL;
		GtkLabel* _tmp80_ = NULL;
		GtkBox* _tmp81_ = NULL;
		GtkLabel* _tmp82_ = NULL;
		_tmp73_ = tokens;
		_tmp73__length1 = tokens_length1;
		_tmp74_ = _tmp73_[0];
		_tmp75_ = string_strip (_tmp74_);
		_tmp76_ = _tmp75_;
		_tmp77_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp76_);
		g_object_ref_sink (_tmp77_);
		_g_object_unref0 (label);
		label = _tmp77_;
		_g_free0 (_tmp76_);
		_tmp78_ = label;
		_tmp79_ = self->priv->decimal_places_spin;
		gtk_label_set_mnemonic_widget (_tmp78_, (GtkWidget*) _tmp79_);
		_tmp80_ = label;
		gtk_widget_show ((GtkWidget*) _tmp80_);
		_tmp81_ = places_box;
		_tmp82_ = label;
		gtk_box_pack_start (_tmp81_, (GtkWidget*) _tmp82_, FALSE, FALSE, (guint) 0);
	}
	_tmp83_ = self->priv->decimal_places_spin;
	gtk_widget_show ((GtkWidget*) _tmp83_);
	_tmp84_ = self->priv->decimal_places_spin;
	g_signal_connect_object (_tmp84_, "value-changed", (GCallback) __math_preferences_dialog___lambda33__gtk_spin_button_value_changed, self, 0);
	_tmp85_ = places_box;
	_tmp86_ = self->priv->decimal_places_spin;
	gtk_box_pack_start (_tmp85_, (GtkWidget*) _tmp86_, FALSE, FALSE, (guint) 0);
	_tmp87_ = tokens;
	_tmp87__length1 = tokens_length1;
	if (_tmp87__length1 == 2) {
		gchar** _tmp88_ = NULL;
		gint _tmp88__length1 = 0;
		const gchar* _tmp89_ = NULL;
		gchar* _tmp90_ = NULL;
		gchar* _tmp91_ = NULL;
		GtkLabel* _tmp92_ = NULL;
		GtkLabel* _tmp93_ = NULL;
		GtkSpinButton* _tmp94_ = NULL;
		GtkLabel* _tmp95_ = NULL;
		GtkBox* _tmp96_ = NULL;
		GtkLabel* _tmp97_ = NULL;
		_tmp88_ = tokens;
		_tmp88__length1 = tokens_length1;
		_tmp89_ = _tmp88_[1];
		_tmp90_ = string_strip (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp91_);
		g_object_ref_sink (_tmp92_);
		_g_object_unref0 (label);
		label = _tmp92_;
		_g_free0 (_tmp91_);
		_tmp93_ = label;
		_tmp94_ = self->priv->decimal_places_spin;
		gtk_label_set_mnemonic_widget (_tmp93_, (GtkWidget*) _tmp94_);
		_tmp95_ = label;
		gtk_widget_show ((GtkWidget*) _tmp95_);
		_tmp96_ = places_box;
		_tmp97_ = label;
		gtk_box_pack_start (_tmp96_, (GtkWidget*) _tmp97_, FALSE, FALSE, (guint) 0);
	}
	_tmp98_ = _ ("Show trailing _zeroes");
	_tmp99_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp98_);
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->trailing_zeroes_check);
	self->priv->trailing_zeroes_check = _tmp99_;
	_tmp100_ = self->priv->trailing_zeroes_check;
	gtk_widget_show ((GtkWidget*) _tmp100_);
	_tmp101_ = self->priv->trailing_zeroes_check;
	g_signal_connect_object ((GtkToggleButton*) _tmp101_, "toggled", (GCallback) __math_preferences_dialog___lambda34__gtk_toggle_button_toggled, self, 0);
	_tmp102_ = format_options_box;
	_tmp103_ = self->priv->trailing_zeroes_check;
	gtk_box_pack_start (_tmp102_, (GtkWidget*) _tmp103_, FALSE, FALSE, (guint) 0);
	_tmp104_ = _ ("Show _thousands separators");
	_tmp105_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp104_);
	g_object_ref_sink (_tmp105_);
	_g_object_unref0 (self->priv->thousands_separator_check);
	self->priv->thousands_separator_check = _tmp105_;
	_tmp106_ = self->priv->thousands_separator_check;
	gtk_widget_show ((GtkWidget*) _tmp106_);
	_tmp107_ = self->priv->thousands_separator_check;
	g_signal_connect_object ((GtkToggleButton*) _tmp107_, "toggled", (GCallback) __math_preferences_dialog___lambda35__gtk_toggle_button_toggled, self, 0);
	_tmp108_ = format_options_box;
	_tmp109_ = self->priv->thousands_separator_check;
	gtk_box_pack_start (_tmp108_, (GtkWidget*) _tmp109_, FALSE, FALSE, (guint) 0);
	_tmp110_ = _ ("_Angle units:");
	_tmp111_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp110_);
	g_object_ref_sink (_tmp111_);
	_g_object_unref0 (label);
	label = _tmp111_;
	_tmp112_ = label;
	gtk_widget_show ((GtkWidget*) _tmp112_);
	_tmp113_ = label;
	g_object_set ((GtkMisc*) _tmp113_, "xalign", (gfloat) 0, NULL);
	_tmp114_ = grid;
	_tmp115_ = label;
	gtk_grid_attach (_tmp114_, (GtkWidget*) _tmp115_, 0, 2, 1, 1);
	_tmp116_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp116_);
	_g_object_unref0 (self->priv->angle_unit_combo);
	self->priv->angle_unit_combo = _tmp116_;
	_tmp117_ = label;
	_tmp118_ = self->priv->angle_unit_combo;
	gtk_label_set_mnemonic_widget (_tmp117_, (GtkWidget*) _tmp118_);
	_tmp119_ = self->priv->angle_unit_combo;
	gtk_widget_show ((GtkWidget*) _tmp119_);
	_tmp120_ = self->priv->angle_unit_combo;
	g_signal_connect_object (_tmp120_, "changed", (GCallback) _math_preferences_dialog_angle_unit_combo_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp121_ = grid;
	_tmp122_ = self->priv->angle_unit_combo;
	gtk_grid_attach (_tmp121_, (GtkWidget*) _tmp122_, 1, 2, 1, 1);
	_tmp123_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (model);
	model = _tmp123_;
	_tmp124_ = self->priv->angle_unit_combo;
	_tmp125_ = model;
	gtk_combo_box_set_model (_tmp124_, (GtkTreeModel*) _tmp125_);
	_tmp126_ = model;
	gtk_list_store_append (_tmp126_, &_tmp127_);
	iter = _tmp127_;
	_tmp128_ = model;
	_tmp129_ = iter;
	_tmp130_ = _ ("Degrees");
	gtk_list_store_set (_tmp128_, &_tmp129_, 0, _tmp130_, 1, ANGLE_UNIT_DEGREES, -1, -1);
	_tmp131_ = model;
	gtk_list_store_append (_tmp131_, &_tmp132_);
	iter = _tmp132_;
	_tmp133_ = model;
	_tmp134_ = iter;
	_tmp135_ = _ ("Radians");
	gtk_list_store_set (_tmp133_, &_tmp134_, 0, _tmp135_, 1, ANGLE_UNIT_RADIANS, -1, -1);
	_tmp136_ = model;
	gtk_list_store_append (_tmp136_, &_tmp137_);
	iter = _tmp137_;
	_tmp138_ = model;
	_tmp139_ = iter;
	_tmp140_ = _ ("Gradians");
	gtk_list_store_set (_tmp138_, &_tmp139_, 0, _tmp140_, 1, ANGLE_UNIT_GRADIANS, -1, -1);
	_tmp141_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp141_);
	_g_object_unref0 (renderer);
	renderer = _tmp141_;
	_tmp142_ = self->priv->angle_unit_combo;
	_tmp143_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp142_, (GtkCellRenderer*) _tmp143_, TRUE);
	_tmp144_ = self->priv->angle_unit_combo;
	_tmp145_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp144_, (GtkCellRenderer*) _tmp145_, "text", 0);
	_tmp146_ = _ ("Word _size:");
	_tmp147_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp146_);
	g_object_ref_sink (_tmp147_);
	_g_object_unref0 (label);
	label = _tmp147_;
	_tmp148_ = label;
	gtk_widget_show ((GtkWidget*) _tmp148_);
	_tmp149_ = label;
	g_object_set ((GtkMisc*) _tmp149_, "xalign", (gfloat) 0, NULL);
	_tmp150_ = grid;
	_tmp151_ = label;
	gtk_grid_attach (_tmp150_, (GtkWidget*) _tmp151_, 0, 3, 1, 1);
	_tmp152_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp152_);
	_g_object_unref0 (self->priv->word_size_combo);
	self->priv->word_size_combo = _tmp152_;
	_tmp153_ = label;
	_tmp154_ = self->priv->word_size_combo;
	gtk_label_set_mnemonic_widget (_tmp153_, (GtkWidget*) _tmp154_);
	_tmp155_ = self->priv->word_size_combo;
	gtk_widget_show ((GtkWidget*) _tmp155_);
	_tmp156_ = self->priv->word_size_combo;
	g_signal_connect_object (_tmp156_, "changed", (GCallback) _math_preferences_dialog_word_size_combo_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp157_ = grid;
	_tmp158_ = self->priv->word_size_combo;
	gtk_grid_attach (_tmp157_, (GtkWidget*) _tmp158_, 1, 3, 1, 1);
	_tmp159_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (model);
	model = _tmp159_;
	_tmp160_ = self->priv->word_size_combo;
	_tmp161_ = model;
	gtk_combo_box_set_model (_tmp160_, (GtkTreeModel*) _tmp161_);
	_tmp162_ = model;
	gtk_list_store_append (_tmp162_, &_tmp163_);
	iter = _tmp163_;
	_tmp164_ = model;
	_tmp165_ = iter;
	_tmp166_ = _ ("8 bits");
	gtk_list_store_set (_tmp164_, &_tmp165_, 0, _tmp166_, 1, 8, -1);
	_tmp167_ = model;
	gtk_list_store_append (_tmp167_, &_tmp168_);
	iter = _tmp168_;
	_tmp169_ = model;
	_tmp170_ = iter;
	_tmp171_ = _ ("16 bits");
	gtk_list_store_set (_tmp169_, &_tmp170_, 0, _tmp171_, 1, 16, -1);
	_tmp172_ = model;
	gtk_list_store_append (_tmp172_, &_tmp173_);
	iter = _tmp173_;
	_tmp174_ = model;
	_tmp175_ = iter;
	_tmp176_ = _ ("32 bits");
	gtk_list_store_set (_tmp174_, &_tmp175_, 0, _tmp176_, 1, 32, -1);
	_tmp177_ = model;
	gtk_list_store_append (_tmp177_, &_tmp178_);
	iter = _tmp178_;
	_tmp179_ = model;
	_tmp180_ = iter;
	_tmp181_ = _ ("64 bits");
	gtk_list_store_set (_tmp179_, &_tmp180_, 0, _tmp181_, 1, 64, -1);
	_tmp182_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp182_);
	_g_object_unref0 (renderer);
	renderer = _tmp182_;
	_tmp183_ = self->priv->word_size_combo;
	_tmp184_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp183_, (GtkCellRenderer*) _tmp184_, TRUE);
	_tmp185_ = self->priv->word_size_combo;
	_tmp186_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp185_, (GtkCellRenderer*) _tmp186_, "text", 0);
	_tmp187_ = self->priv->decimal_places_spin;
	_tmp188_ = self->priv->_equation;
	_tmp189_ = math_equation_get_accuracy (_tmp188_);
	_tmp190_ = _tmp189_;
	gtk_spin_button_set_value (_tmp187_, (gdouble) _tmp190_);
	_tmp191_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp191_, "notify::accuracy", (GCallback) __math_preferences_dialog___lambda36__g_object_notify, self, 0);
	_tmp192_ = self->priv->thousands_separator_check;
	_tmp193_ = self->priv->_equation;
	_tmp194_ = math_equation_get_show_thousands_separators (_tmp193_);
	_tmp195_ = _tmp194_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp192_, _tmp195_);
	_tmp196_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp196_, "notify::show-thousands-separators", (GCallback) __math_preferences_dialog___lambda37__g_object_notify, self, 0);
	_tmp197_ = self->priv->trailing_zeroes_check;
	_tmp198_ = self->priv->_equation;
	_tmp199_ = math_equation_get_show_trailing_zeroes (_tmp198_);
	_tmp200_ = _tmp199_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp197_, _tmp200_);
	_tmp201_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp201_, "notify::show-trailing_zeroes", (GCallback) __math_preferences_dialog___lambda38__g_object_notify, self, 0);
	_tmp202_ = self->priv->number_format_combo;
	_tmp203_ = self->priv->_equation;
	_tmp204_ = math_equation_get_number_format (_tmp203_);
	_tmp205_ = _tmp204_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp202_, (gint) _tmp205_);
	_tmp206_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp206_, "notify::number-format", (GCallback) __math_preferences_dialog___lambda39__g_object_notify, self, 0);
	_tmp207_ = self->priv->word_size_combo;
	_tmp208_ = self->priv->_equation;
	_tmp209_ = math_equation_get_word_size (_tmp208_);
	_tmp210_ = _tmp209_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp207_, _tmp210_);
	_tmp211_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp211_, "notify::word-size", (GCallback) __math_preferences_dialog___lambda40__g_object_notify, self, 0);
	_tmp212_ = self->priv->angle_unit_combo;
	_tmp213_ = self->priv->_equation;
	_tmp214_ = math_equation_get_angle_units (_tmp213_);
	_tmp215_ = _tmp214_;
	math_preferences_dialog_set_combo_box_from_int (self, _tmp212_, (gint) _tmp215_);
	_tmp216_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp216_, "notify::angle-units", (GCallback) __math_preferences_dialog___lambda41__g_object_notify, self, 0);
	_g_object_unref0 (decimal_places_adjustment);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (string);
	_g_object_unref0 (places_box);
	_g_object_unref0 (format_options_box);
	_g_object_unref0 (alignment);
	_g_object_unref0 (renderer);
	_g_object_unref0 (model);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	return obj;
}


static void math_preferences_dialog_class_init (MathPreferencesDialogClass * klass) {
	math_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathPreferencesDialogPrivate));
	GTK_DIALOG_CLASS (klass)->response = math_preferences_dialog_real_response;
	GTK_WIDGET_CLASS (klass)->delete_event = math_preferences_dialog_real_delete_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_preferences_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_preferences_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = math_preferences_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_preferences_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_PREFERENCES_DIALOG_EQUATION, g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void math_preferences_dialog_instance_init (MathPreferencesDialog * self) {
	self->priv = MATH_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void math_preferences_dialog_finalize (GObject* obj) {
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	_g_object_unref0 (self->priv->_equation);
	_g_object_unref0 (self->priv->angle_unit_combo);
	_g_object_unref0 (self->priv->number_format_combo);
	_g_object_unref0 (self->priv->word_size_combo);
	_g_object_unref0 (self->priv->decimal_places_spin);
	_g_object_unref0 (self->priv->thousands_separator_check);
	_g_object_unref0 (self->priv->trailing_zeroes_check);
	G_OBJECT_CLASS (math_preferences_dialog_parent_class)->finalize (obj);
}


GType math_preferences_dialog_get_type (void) {
	static volatile gsize math_preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&math_preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathPreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathPreferencesDialog), 0, (GInstanceInitFunc) math_preferences_dialog_instance_init, NULL };
		GType math_preferences_dialog_type_id;
		math_preferences_dialog_type_id = g_type_register_static (GTK_TYPE_DIALOG, "MathPreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&math_preferences_dialog_type_id__volatile, math_preferences_dialog_type_id);
	}
	return math_preferences_dialog_type_id__volatile;
}


static void _vala_math_preferences_dialog_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	switch (property_id) {
		case MATH_PREFERENCES_DIALOG_EQUATION:
		g_value_set_object (value, math_preferences_dialog_get_equation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_math_preferences_dialog_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathPreferencesDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_PREFERENCES_DIALOG, MathPreferencesDialog);
	switch (property_id) {
		case MATH_PREFERENCES_DIALOG_EQUATION:
		math_preferences_dialog_set_equation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



