/* number.c generated by valac 0.24.0, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  PACKAGE, ACM TRANS. MATH. SOFTWARE 4 (MARCH 1978), 57-70.
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */
/* Size of the multiple precision values */

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _NumberPrivate NumberPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

typedef gint (*BitwiseFunc) (gint v1, gint v2, void* user_data);
typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Number {
	GObject parent_instance;
	NumberPrivate * priv;
	gint re_sign;
	gint im_sign;
	gint re_exponent;
	gint im_exponent;
	gint re_fraction[1000];
	gint im_fraction[1000];
};

struct _NumberClass {
	GObjectClass parent_class;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


static gpointer number_parent_class = NULL;
extern gchar* mp_error;
gchar* mp_error = NULL;

#define SIZE 1000
#define BASE 10000
#define T 100
GType angle_unit_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
enum  {
	NUMBER_DUMMY_PROPERTY
};
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_new_fraction (gint64 numerator, gint64 denominator);
Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator);
void mp_gcd (gint64* k, gint64* l);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_new_float (gfloat value);
Number* number_construct_float (GType object_type, gfloat value);
void mp_normalize (Number** x);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_new_double (gdouble value);
Number* number_construct_double (GType object_type, gdouble value);
Number* number_new_complex (Number* x, Number* y);
Number* number_construct_complex (GType object_type, Number* x, Number* y);
Number* number_new_polar (Number* r, Number* theta, AngleUnit unit);
Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_multiply (Number* self, Number* y);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
Number* number_epowy (Number* self);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
gint64 number_to_integer (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gfloat number_to_float (Number* self);
gboolean number_is_zero (Number* self);
gdouble number_to_double (Number* self);
gboolean number_is_negative (Number* self);
gboolean number_is_integer (Number* self);
gboolean number_is_complex (Number* self);
Number* number_divide (Number* self, Number* y);
Number* number_floor (Number* self);
gboolean number_equals (Number* self, Number* y);
gboolean number_is_positive_integer (Number* self);
gboolean number_is_natural (Number* self);
gint number_compare (Number* self, Number* y);
Number* number_sgn (Number* self);
Number* number_invert_sign (Number* self);
static Number* number_copy (Number* self);
Number* number_abs (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_add (Number* self, Number* y);
Number* number_root (Number* self, gint64 n);
Number* number_arg (Number* self, AngleUnit unit);
void mperr (const gchar* text);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_subtract (Number* self, Number* y);
static Number* number_from_radians (Number* self, AngleUnit unit);
Number* number_conjugate (Number* self);
Number* number_new (void);
Number* number_construct (GType object_type);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_fractional_part (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_reciprocal (Number* self);
static Number* number_reciprocal_real (Number* self);
static Number* number_epowy_real (Number* self);
Number* number_xpowy (Number* self, Number* y);
Number* number_xpowy_integer (Number* self, gint64 n);
static Number* number_pwr (Number* self, Number* y);
static Number* number_root_real (Number* self, gint64 n);
Number* number_sqrt (Number* self);
static Number* number_ext (Number* self, gint i, gint j);
Number* number_ln (Number* self);
static Number* number_ln_real (Number* self);
Number* number_logarithm (Number* self, gint64 n);
Number* number_factorial (Number* self);
static Number* number_add_with_sign (Number* self, gint y_sign, Number* y);
static Number* number_multiply_real (Number* self, Number* y);
static Number* number_multiply_integer_real (Number* self, gint64 y);
static Number* number_divide_integer_real (Number* self, gint64 y);
Number* number_modulus_divide (Number* self, Number* y);
Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod);
static Number* number_sin_real (Number* self, AngleUnit unit);
Number* number_cosh (Number* self);
static Number* number_cos_real (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_tan (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_and (Number* self, Number* y);
static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen);
static gint __lambda3_ (Number* self, gint v1, gint v2);
static gint ___lambda3__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_or (Number* self, Number* y);
static gint __lambda4_ (Number* self, gint v1, gint v2);
static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_xor (Number* self, Number* y);
static gint __lambda5_ (Number* self, gint v1, gint v2);
static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_not (Number* self, gint wordlen);
static gint __lambda6_ (Number* self, gint v1, gint v2);
static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_mask (Number* self, Number* x, gint wordlen);
static gchar* number_to_hex_string (Number* self);
Number* mp_set_from_string (const gchar* str, gint default_base);
Number* number_shift (Number* self, gint count);
Number* number_ones_complement (Number* self, gint wordlen);
static gint __lambda7_ (Number* self, gint v1, gint v2);
static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self);
Number* number_twos_complement (Number* self, gint wordlen);
GList* number_factorize (Number* self);
GList* number_factorize_uint64 (Number* self, guint64 n);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static Number* number_add_real (Number* self, gint y_sign, Number* y);
static Number* number_exp (Number* self);
static Number* number_lns (Number* self);
static gint* _vala_array_dup1 (gint* self, int length);
static gint* _vala_array_dup2 (gint* self, int length);
static gint* _vala_array_dup3 (gint* self, int length);
static gint* _vala_array_dup4 (gint* self, int length);
static Number* number_to_radians (Number* self, AngleUnit unit);
static Number* number_sin1 (Number* self, gboolean do_sin);
static gint number_hex_to_int (Number* self, gchar digit);
GType serializer_get_type (void) G_GNUC_CONST;
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
gchar* serializer_to_string (Serializer* self, Number* x);
static void number_finalize (GObject* obj);
gchar* mp_get_error (void);
void mp_clear_error (void);
Number* set_from_sexagesimal (const gchar* str);
gint char_val (gunichar c, gint number_base);
gboolean mp_is_overflow (Number* x, gint wordlen);


GType angle_unit_get_type (void) {
	static volatile gsize angle_unit_type_id__volatile = 0;
	if (g_once_init_enter (&angle_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
		GType angle_unit_type_id;
		angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
		g_once_init_leave (&angle_unit_type_id__volatile, angle_unit_type_id);
	}
	return angle_unit_type_id__volatile;
}


Number* number_construct_integer (GType object_type, gint64 value) {
	Number * self = NULL;
	gint64 _tmp0_ = 0LL;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = value;
	if (_tmp0_ < ((gint64) 0)) {
		gint64 _tmp1_ = 0LL;
		_tmp1_ = value;
		value = -_tmp1_;
		self->re_sign = -1;
	} else {
		gint64 _tmp2_ = 0LL;
		_tmp2_ = value;
		if (_tmp2_ > ((gint64) 0)) {
			self->re_sign = 1;
		} else {
			self->re_sign = 0;
		}
	}
	while (TRUE) {
		gint64 _tmp3_ = 0LL;
		gint _tmp4_ = 0;
		gint64 _tmp5_ = 0LL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint64 _tmp8_ = 0LL;
		_tmp3_ = value;
		if (!(_tmp3_ != ((gint64) 0))) {
			break;
		}
		_tmp4_ = self->re_exponent;
		_tmp5_ = value;
		self->re_fraction[_tmp4_] = (gint) (_tmp5_ % BASE);
		_tmp6_ = self->re_fraction[_tmp4_];
		_tmp7_ = self->re_exponent;
		self->re_exponent = _tmp7_ + 1;
		_tmp8_ = value;
		value = _tmp8_ / BASE;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint t = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = self->re_exponent;
				if (!(_tmp11_ < (_tmp12_ / 2))) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = self->re_fraction[_tmp13_];
				t = _tmp14_;
				_tmp15_ = i;
				_tmp16_ = self->re_exponent;
				_tmp17_ = i;
				_tmp18_ = self->re_fraction[(_tmp16_ - _tmp17_) - 1];
				self->re_fraction[_tmp15_] = _tmp18_;
				_tmp19_ = self->re_fraction[_tmp15_];
				_tmp20_ = self->re_exponent;
				_tmp21_ = i;
				_tmp22_ = t;
				self->re_fraction[(_tmp20_ - _tmp21_) - 1] = _tmp22_;
				_tmp23_ = self->re_fraction[(_tmp20_ - _tmp21_) - 1];
			}
		}
	}
	return self;
}


Number* number_new_integer (gint64 value) {
	return number_construct_integer (TYPE_NUMBER, value);
}


Number* number_construct_unsigned_integer (GType object_type, guint64 x) {
	Number * self = NULL;
	guint64 _tmp0_ = 0ULL;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = x;
	if (_tmp0_ == ((guint64) 0)) {
		self->re_sign = 0;
	} else {
		self->re_sign = 1;
	}
	while (TRUE) {
		guint64 _tmp1_ = 0ULL;
		gint _tmp2_ = 0;
		guint64 _tmp3_ = 0ULL;
		gint _tmp4_ = 0;
		guint64 _tmp5_ = 0ULL;
		gint _tmp6_ = 0;
		_tmp1_ = x;
		if (!(_tmp1_ != ((guint64) 0))) {
			break;
		}
		_tmp2_ = self->re_exponent;
		_tmp3_ = x;
		self->re_fraction[_tmp2_] = (gint) (_tmp3_ % BASE);
		_tmp4_ = self->re_fraction[_tmp2_];
		_tmp5_ = x;
		x = _tmp5_ / BASE;
		_tmp6_ = self->re_exponent;
		self->re_exponent = _tmp6_ + 1;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint t = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = self->re_exponent;
				if (!(_tmp9_ < (_tmp10_ / 2))) {
					break;
				}
				_tmp11_ = i;
				_tmp12_ = self->re_fraction[_tmp11_];
				t = _tmp12_;
				_tmp13_ = i;
				_tmp14_ = self->re_exponent;
				_tmp15_ = i;
				_tmp16_ = self->re_fraction[(_tmp14_ - _tmp15_) - 1];
				self->re_fraction[_tmp13_] = _tmp16_;
				_tmp17_ = self->re_fraction[_tmp13_];
				_tmp18_ = self->re_exponent;
				_tmp19_ = i;
				_tmp20_ = t;
				self->re_fraction[(_tmp18_ - _tmp19_) - 1] = _tmp20_;
				_tmp21_ = self->re_fraction[(_tmp18_ - _tmp19_) - 1];
			}
		}
	}
	return self;
}


Number* number_new_unsigned_integer (guint64 x) {
	return number_construct_unsigned_integer (TYPE_NUMBER, x);
}


Number* number_construct_fraction (GType object_type, gint64 numerator, gint64 denominator) {
	Number * self = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	mp_gcd (&numerator, &denominator);
	_tmp0_ = denominator;
	if (_tmp0_ < ((gint64) 0)) {
		gint64 _tmp1_ = 0LL;
		gint64 _tmp2_ = 0LL;
		_tmp1_ = numerator;
		numerator = -_tmp1_;
		_tmp2_ = denominator;
		denominator = -_tmp2_;
	}
	_tmp3_ = numerator;
	self = (Number*) number_construct_integer (object_type, _tmp3_);
	_tmp4_ = denominator;
	if (_tmp4_ != ((gint64) 1)) {
		Number* z = NULL;
		gint64 _tmp5_ = 0LL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		Number* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		Number* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		_tmp5_ = denominator;
		_tmp6_ = number_divide_integer (self, _tmp5_);
		z = _tmp6_;
		_tmp7_ = z;
		_tmp8_ = _tmp7_->re_sign;
		self->re_sign = _tmp8_;
		_tmp9_ = z;
		_tmp10_ = _tmp9_->im_sign;
		self->im_sign = _tmp10_;
		_tmp11_ = z;
		_tmp12_ = _tmp11_->re_exponent;
		self->re_exponent = _tmp12_;
		_tmp13_ = z;
		_tmp14_ = _tmp13_->im_exponent;
		self->im_exponent = _tmp14_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					gint _tmp17_ = 0;
					Number* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					Number* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					Number* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					if (!_tmp15_) {
						gint _tmp16_ = 0;
						_tmp16_ = i;
						i = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp17_ = i;
					_tmp18_ = z;
					if (!(_tmp17_ < 1000)) {
						break;
					}
					_tmp19_ = i;
					_tmp20_ = z;
					_tmp21_ = i;
					_tmp22_ = _tmp20_->re_fraction[_tmp21_];
					self->re_fraction[_tmp19_] = _tmp22_;
					_tmp23_ = self->re_fraction[_tmp19_];
					_tmp24_ = i;
					_tmp25_ = z;
					_tmp26_ = i;
					_tmp27_ = _tmp25_->im_fraction[_tmp26_];
					self->im_fraction[_tmp24_] = _tmp27_;
					_tmp28_ = self->im_fraction[_tmp24_];
				}
			}
		}
		_g_object_unref0 (z);
	}
	return self;
}


Number* number_new_fraction (gint64 numerator, gint64 denominator) {
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
}


Number* number_construct_float (GType object_type, gfloat value) {
	Number * self = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gfloat _tmp1_ = 0.0F;
	Number* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	Number* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	Number* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	Number* _tmp67_ = NULL;
	gint _tmp68_ = 0;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_new_integer ((gint64) 0);
	z = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ != ((gfloat) 0)) {
		gfloat rj = 0.0F;
		gfloat _tmp2_ = 0.0F;
		gint ie = 0;
		Number* _tmp14_ = NULL;
		gint ib = 0;
		gint _tmp27_ = 0;
		gint tp = 0;
		gint _tmp28_ = 0;
		rj = 0.f;
		_tmp2_ = value;
		if (_tmp2_ < 0.0f) {
			Number* _tmp3_ = NULL;
			gfloat _tmp4_ = 0.0F;
			_tmp3_ = z;
			_tmp3_->re_sign = -1;
			_tmp4_ = value;
			rj = -_tmp4_;
		} else {
			gfloat _tmp5_ = 0.0F;
			_tmp5_ = value;
			if (_tmp5_ > 0.0f) {
				Number* _tmp6_ = NULL;
				gfloat _tmp7_ = 0.0F;
				_tmp6_ = z;
				_tmp6_->re_sign = 1;
				_tmp7_ = value;
				rj = _tmp7_;
			}
		}
		ie = 0;
		while (TRUE) {
			gfloat _tmp8_ = 0.0F;
			gint _tmp9_ = 0;
			gfloat _tmp10_ = 0.0F;
			_tmp8_ = rj;
			if (!(_tmp8_ >= 1.0f)) {
				break;
			}
			_tmp9_ = ie;
			ie = _tmp9_ + 1;
			_tmp10_ = rj;
			rj = _tmp10_ * 0.0625f;
		}
		while (TRUE) {
			gfloat _tmp11_ = 0.0F;
			gint _tmp12_ = 0;
			gfloat _tmp13_ = 0.0F;
			_tmp11_ = rj;
			if (!(_tmp11_ < 0.0625f)) {
				break;
			}
			_tmp12_ = ie;
			ie = _tmp12_ - 1;
			_tmp13_ = rj;
			rj = _tmp13_ * 16.0f;
		}
		_tmp14_ = z;
		_tmp14_->re_exponent = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp15_ = FALSE;
				_tmp15_ = TRUE;
				while (TRUE) {
					gint _tmp17_ = 0;
					gfloat _tmp18_ = 0.0F;
					Number* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gfloat _tmp21_ = 0.0F;
					gint _tmp22_ = 0;
					gfloat _tmp23_ = 0.0F;
					Number* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					if (!_tmp15_) {
						gint _tmp16_ = 0;
						_tmp16_ = i;
						i = _tmp16_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp17_ = i;
					if (!(_tmp17_ < (T + 4))) {
						break;
					}
					_tmp18_ = rj;
					rj = _tmp18_ * BASE;
					_tmp19_ = z;
					_tmp20_ = i;
					_tmp21_ = rj;
					_tmp19_->re_fraction[_tmp20_] = (gint) _tmp21_;
					_tmp22_ = _tmp19_->re_fraction[_tmp20_];
					_tmp23_ = rj;
					_tmp24_ = z;
					_tmp25_ = i;
					_tmp26_ = _tmp24_->re_fraction[_tmp25_];
					rj = _tmp23_ - _tmp26_;
				}
			}
		}
		mp_normalize (&z);
		_tmp27_ = MAX ((BASE * 7) * BASE, 32767);
		ib = _tmp27_ / 16;
		tp = 1;
		_tmp28_ = ie;
		if (_tmp28_ < 0) {
			gint k = 0;
			gint _tmp29_ = 0;
			_tmp29_ = ie;
			k = -_tmp29_;
			{
				gint i = 0;
				i = 1;
				{
					gboolean _tmp30_ = FALSE;
					_tmp30_ = TRUE;
					while (TRUE) {
						gint _tmp32_ = 0;
						gint _tmp33_ = 0;
						gint _tmp34_ = 0;
						gboolean _tmp35_ = FALSE;
						gboolean _tmp36_ = FALSE;
						gint _tmp37_ = 0;
						gint _tmp38_ = 0;
						Number* _tmp42_ = NULL;
						gint _tmp43_ = 0;
						Number* _tmp44_ = NULL;
						if (!_tmp30_) {
							gint _tmp31_ = 0;
							_tmp31_ = i;
							i = _tmp31_ + 1;
						}
						_tmp30_ = FALSE;
						_tmp32_ = i;
						_tmp33_ = k;
						if (!(_tmp32_ <= _tmp33_)) {
							break;
						}
						_tmp34_ = tp;
						tp = _tmp34_ << 4;
						_tmp37_ = tp;
						_tmp38_ = ib;
						if (_tmp37_ <= _tmp38_) {
							gint _tmp39_ = 0;
							_tmp39_ = tp;
							_tmp36_ = _tmp39_ != BASE;
						} else {
							_tmp36_ = FALSE;
						}
						if (_tmp36_) {
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							_tmp40_ = i;
							_tmp41_ = k;
							_tmp35_ = _tmp40_ < _tmp41_;
						} else {
							_tmp35_ = FALSE;
						}
						if (_tmp35_) {
							continue;
						}
						_tmp42_ = z;
						_tmp43_ = tp;
						_tmp44_ = number_divide_integer (_tmp42_, (gint64) _tmp43_);
						_g_object_unref0 (z);
						z = _tmp44_;
						tp = 1;
					}
				}
			}
		} else {
			gint _tmp45_ = 0;
			_tmp45_ = ie;
			if (_tmp45_ > 0) {
				{
					gint i = 0;
					i = 1;
					{
						gboolean _tmp46_ = FALSE;
						_tmp46_ = TRUE;
						while (TRUE) {
							gint _tmp48_ = 0;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gboolean _tmp51_ = FALSE;
							gboolean _tmp52_ = FALSE;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							Number* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							Number* _tmp60_ = NULL;
							if (!_tmp46_) {
								gint _tmp47_ = 0;
								_tmp47_ = i;
								i = _tmp47_ + 1;
							}
							_tmp46_ = FALSE;
							_tmp48_ = i;
							_tmp49_ = ie;
							if (!(_tmp48_ <= _tmp49_)) {
								break;
							}
							_tmp50_ = tp;
							tp = _tmp50_ << 4;
							_tmp53_ = tp;
							_tmp54_ = ib;
							if (_tmp53_ <= _tmp54_) {
								gint _tmp55_ = 0;
								_tmp55_ = tp;
								_tmp52_ = _tmp55_ != BASE;
							} else {
								_tmp52_ = FALSE;
							}
							if (_tmp52_) {
								gint _tmp56_ = 0;
								gint _tmp57_ = 0;
								_tmp56_ = i;
								_tmp57_ = ie;
								_tmp51_ = _tmp56_ < _tmp57_;
							} else {
								_tmp51_ = FALSE;
							}
							if (_tmp51_) {
								continue;
							}
							_tmp58_ = z;
							_tmp59_ = tp;
							_tmp60_ = number_multiply_integer (_tmp58_, (gint64) _tmp59_);
							_g_object_unref0 (z);
							z = _tmp60_;
							tp = 1;
						}
					}
				}
			}
		}
	}
	_tmp61_ = z;
	_tmp62_ = _tmp61_->re_sign;
	self->re_sign = _tmp62_;
	_tmp63_ = z;
	_tmp64_ = _tmp63_->im_sign;
	self->im_sign = _tmp64_;
	_tmp65_ = z;
	_tmp66_ = _tmp65_->re_exponent;
	self->re_exponent = _tmp66_;
	_tmp67_ = z;
	_tmp68_ = _tmp67_->im_exponent;
	self->im_exponent = _tmp68_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp69_ = FALSE;
			_tmp69_ = TRUE;
			while (TRUE) {
				gint _tmp71_ = 0;
				Number* _tmp72_ = NULL;
				gint _tmp73_ = 0;
				Number* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				Number* _tmp79_ = NULL;
				gint _tmp80_ = 0;
				gint _tmp81_ = 0;
				gint _tmp82_ = 0;
				if (!_tmp69_) {
					gint _tmp70_ = 0;
					_tmp70_ = i;
					i = _tmp70_ + 1;
				}
				_tmp69_ = FALSE;
				_tmp71_ = i;
				_tmp72_ = z;
				if (!(_tmp71_ < 1000)) {
					break;
				}
				_tmp73_ = i;
				_tmp74_ = z;
				_tmp75_ = i;
				_tmp76_ = _tmp74_->re_fraction[_tmp75_];
				self->re_fraction[_tmp73_] = _tmp76_;
				_tmp77_ = self->re_fraction[_tmp73_];
				_tmp78_ = i;
				_tmp79_ = z;
				_tmp80_ = i;
				_tmp81_ = _tmp79_->im_fraction[_tmp80_];
				self->im_fraction[_tmp78_] = _tmp81_;
				_tmp82_ = self->im_fraction[_tmp78_];
			}
		}
	}
	_g_object_unref0 (z);
	return self;
}


Number* number_new_float (gfloat value) {
	return number_construct_float (TYPE_NUMBER, value);
}


Number* number_construct_double (GType object_type, gdouble value) {
	Number * self = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	Number* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	Number* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	Number* _tmp67_ = NULL;
	gint _tmp68_ = 0;
	Number* _tmp69_ = NULL;
	gint _tmp70_ = 0;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_new_integer ((gint64) 0);
	z = _tmp0_;
	_tmp1_ = value;
	if (_tmp1_ != ((gdouble) 0)) {
		gdouble dj = 0.0;
		gdouble _tmp2_ = 0.0;
		gint ie = 0;
		Number* _tmp16_ = NULL;
		gint ib = 0;
		gint _tmp29_ = 0;
		gint tp = 0;
		gint _tmp30_ = 0;
		dj = 0.0;
		_tmp2_ = value;
		if (_tmp2_ < 0.0) {
			Number* _tmp3_ = NULL;
			gdouble _tmp4_ = 0.0;
			_tmp3_ = z;
			_tmp3_->re_sign = -1;
			_tmp4_ = value;
			dj = -_tmp4_;
		} else {
			gdouble _tmp5_ = 0.0;
			_tmp5_ = value;
			if (_tmp5_ > 0.0) {
				Number* _tmp6_ = NULL;
				gdouble _tmp7_ = 0.0;
				_tmp6_ = z;
				_tmp6_->re_sign = 1;
				_tmp7_ = value;
				dj = _tmp7_;
			}
		}
		ie = 0;
		{
			gboolean _tmp8_ = FALSE;
			ie = 0;
			_tmp8_ = TRUE;
			while (TRUE) {
				gdouble _tmp10_ = 0.0;
				gdouble _tmp11_ = 0.0;
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = ie;
					ie = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = dj;
				if (!(_tmp10_ >= 1.0)) {
					break;
				}
				_tmp11_ = dj;
				dj = _tmp11_ * (1.0 / 16.0);
			}
		}
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gdouble _tmp14_ = 0.0;
				gdouble _tmp15_ = 0.0;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = ie;
					ie = _tmp13_ - 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = dj;
				if (!(_tmp14_ < (1.0 / 16.0))) {
					break;
				}
				_tmp15_ = dj;
				dj = _tmp15_ * 16.0;
			}
		}
		_tmp16_ = z;
		_tmp16_->re_exponent = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp17_ = FALSE;
				_tmp17_ = TRUE;
				while (TRUE) {
					gint _tmp19_ = 0;
					gdouble _tmp20_ = 0.0;
					Number* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					gdouble _tmp23_ = 0.0;
					gint _tmp24_ = 0;
					gdouble _tmp25_ = 0.0;
					Number* _tmp26_ = NULL;
					gint _tmp27_ = 0;
					gint _tmp28_ = 0;
					if (!_tmp17_) {
						gint _tmp18_ = 0;
						_tmp18_ = i;
						i = _tmp18_ + 1;
					}
					_tmp17_ = FALSE;
					_tmp19_ = i;
					if (!(_tmp19_ < (T + 4))) {
						break;
					}
					_tmp20_ = dj;
					dj = _tmp20_ * ((gdouble) BASE);
					_tmp21_ = z;
					_tmp22_ = i;
					_tmp23_ = dj;
					_tmp21_->re_fraction[_tmp22_] = (gint) _tmp23_;
					_tmp24_ = _tmp21_->re_fraction[_tmp22_];
					_tmp25_ = dj;
					_tmp26_ = z;
					_tmp27_ = i;
					_tmp28_ = _tmp26_->re_fraction[_tmp27_];
					dj = _tmp25_ - ((gdouble) _tmp28_);
				}
			}
		}
		mp_normalize (&z);
		_tmp29_ = MAX ((BASE * 7) * BASE, 32767);
		ib = _tmp29_ / 16;
		tp = 1;
		_tmp30_ = ie;
		if (_tmp30_ < 0) {
			gint k = 0;
			gint _tmp31_ = 0;
			_tmp31_ = ie;
			k = -_tmp31_;
			{
				gint i = 0;
				i = 1;
				{
					gboolean _tmp32_ = FALSE;
					_tmp32_ = TRUE;
					while (TRUE) {
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
						gint _tmp36_ = 0;
						gboolean _tmp37_ = FALSE;
						gboolean _tmp38_ = FALSE;
						gint _tmp39_ = 0;
						gint _tmp40_ = 0;
						Number* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						Number* _tmp46_ = NULL;
						if (!_tmp32_) {
							gint _tmp33_ = 0;
							_tmp33_ = i;
							i = _tmp33_ + 1;
						}
						_tmp32_ = FALSE;
						_tmp34_ = i;
						_tmp35_ = k;
						if (!(_tmp34_ <= _tmp35_)) {
							break;
						}
						_tmp36_ = tp;
						tp = _tmp36_ << 4;
						_tmp39_ = tp;
						_tmp40_ = ib;
						if (_tmp39_ <= _tmp40_) {
							gint _tmp41_ = 0;
							_tmp41_ = tp;
							_tmp38_ = _tmp41_ != BASE;
						} else {
							_tmp38_ = FALSE;
						}
						if (_tmp38_) {
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							_tmp42_ = i;
							_tmp43_ = k;
							_tmp37_ = _tmp42_ < _tmp43_;
						} else {
							_tmp37_ = FALSE;
						}
						if (_tmp37_) {
							continue;
						}
						_tmp44_ = z;
						_tmp45_ = tp;
						_tmp46_ = number_divide_integer (_tmp44_, (gint64) _tmp45_);
						_g_object_unref0 (z);
						z = _tmp46_;
						tp = 1;
					}
				}
			}
		} else {
			gint _tmp47_ = 0;
			_tmp47_ = ie;
			if (_tmp47_ > 0) {
				{
					gint i = 0;
					i = 1;
					{
						gboolean _tmp48_ = FALSE;
						_tmp48_ = TRUE;
						while (TRUE) {
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							gboolean _tmp53_ = FALSE;
							gboolean _tmp54_ = FALSE;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							Number* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							Number* _tmp62_ = NULL;
							if (!_tmp48_) {
								gint _tmp49_ = 0;
								_tmp49_ = i;
								i = _tmp49_ + 1;
							}
							_tmp48_ = FALSE;
							_tmp50_ = i;
							_tmp51_ = ie;
							if (!(_tmp50_ <= _tmp51_)) {
								break;
							}
							_tmp52_ = tp;
							tp = _tmp52_ << 4;
							_tmp55_ = tp;
							_tmp56_ = ib;
							if (_tmp55_ <= _tmp56_) {
								gint _tmp57_ = 0;
								_tmp57_ = tp;
								_tmp54_ = _tmp57_ != BASE;
							} else {
								_tmp54_ = FALSE;
							}
							if (_tmp54_) {
								gint _tmp58_ = 0;
								gint _tmp59_ = 0;
								_tmp58_ = i;
								_tmp59_ = ie;
								_tmp53_ = _tmp58_ < _tmp59_;
							} else {
								_tmp53_ = FALSE;
							}
							if (_tmp53_) {
								continue;
							}
							_tmp60_ = z;
							_tmp61_ = tp;
							_tmp62_ = number_multiply_integer (_tmp60_, (gint64) _tmp61_);
							_g_object_unref0 (z);
							z = _tmp62_;
							tp = 1;
						}
					}
				}
			}
		}
	}
	_tmp63_ = z;
	_tmp64_ = _tmp63_->re_sign;
	self->re_sign = _tmp64_;
	_tmp65_ = z;
	_tmp66_ = _tmp65_->im_sign;
	self->im_sign = _tmp66_;
	_tmp67_ = z;
	_tmp68_ = _tmp67_->re_exponent;
	self->re_exponent = _tmp68_;
	_tmp69_ = z;
	_tmp70_ = _tmp69_->im_exponent;
	self->im_exponent = _tmp70_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp71_ = FALSE;
			_tmp71_ = TRUE;
			while (TRUE) {
				gint _tmp73_ = 0;
				Number* _tmp74_ = NULL;
				gint _tmp75_ = 0;
				Number* _tmp76_ = NULL;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				Number* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				if (!_tmp71_) {
					gint _tmp72_ = 0;
					_tmp72_ = i;
					i = _tmp72_ + 1;
				}
				_tmp71_ = FALSE;
				_tmp73_ = i;
				_tmp74_ = z;
				if (!(_tmp73_ < 1000)) {
					break;
				}
				_tmp75_ = i;
				_tmp76_ = z;
				_tmp77_ = i;
				_tmp78_ = _tmp76_->re_fraction[_tmp77_];
				self->re_fraction[_tmp75_] = _tmp78_;
				_tmp79_ = self->re_fraction[_tmp75_];
				_tmp80_ = i;
				_tmp81_ = z;
				_tmp82_ = i;
				_tmp83_ = _tmp81_->im_fraction[_tmp82_];
				self->im_fraction[_tmp80_] = _tmp83_;
				_tmp84_ = self->im_fraction[_tmp80_];
			}
		}
	}
	_g_object_unref0 (z);
	return self;
}


Number* number_new_double (gdouble value) {
	return number_construct_double (TYPE_NUMBER, value);
}


Number* number_construct_complex (GType object_type, Number* x, Number* y) {
	Number * self = NULL;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Number* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Number* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = x;
	_tmp1_ = _tmp0_->re_sign;
	self->re_sign = _tmp1_;
	_tmp2_ = x;
	_tmp3_ = _tmp2_->re_exponent;
	self->re_exponent = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				Number* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < 1000)) {
					break;
				}
				_tmp7_ = i;
				_tmp8_ = x;
				_tmp9_ = i;
				_tmp10_ = _tmp8_->re_fraction[_tmp9_];
				self->re_fraction[_tmp7_] = _tmp10_;
				_tmp11_ = self->re_fraction[_tmp7_];
			}
		}
	}
	_tmp12_ = y;
	_tmp13_ = _tmp12_->re_sign;
	self->im_sign = _tmp13_;
	_tmp14_ = y;
	_tmp15_ = _tmp14_->re_exponent;
	self->im_exponent = _tmp15_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				if (!_tmp16_) {
					gint _tmp17_ = 0;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = i;
				if (!(_tmp18_ < 1000)) {
					break;
				}
				_tmp19_ = i;
				_tmp20_ = y;
				_tmp21_ = i;
				_tmp22_ = _tmp20_->re_fraction[_tmp21_];
				self->im_fraction[_tmp19_] = _tmp22_;
				_tmp23_ = self->im_fraction[_tmp19_];
			}
		}
	}
	return self;
}


Number* number_new_complex (Number* x, Number* y) {
	return number_construct_complex (TYPE_NUMBER, x, y);
}


Number* number_construct_polar (GType object_type, Number* r, Number* theta, AngleUnit unit) {
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_ = NULL;
	AngleUnit _tmp1_ = 0;
	Number* _tmp2_ = NULL;
	Number* y = NULL;
	Number* _tmp3_ = NULL;
	AngleUnit _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (theta != NULL, NULL);
	_tmp0_ = theta;
	_tmp1_ = unit;
	_tmp2_ = number_cos (_tmp0_, _tmp1_);
	x = _tmp2_;
	_tmp3_ = theta;
	_tmp4_ = unit;
	_tmp5_ = number_sin (_tmp3_, _tmp4_);
	y = _tmp5_;
	_tmp6_ = r;
	_tmp7_ = number_multiply (x, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = r;
	_tmp10_ = number_multiply (y, _tmp9_);
	_tmp11_ = _tmp10_;
	self = (Number*) number_construct_complex (object_type, _tmp8_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (y);
	_g_object_unref0 (x);
	return self;
}


Number* number_new_polar (Number* r, Number* theta, AngleUnit unit) {
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
}


Number* number_construct_eulers (GType object_type) {
	Number * self = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = number_new_integer ((gint64) 1);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_epowy (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	z = _tmp3_;
	_tmp4_ = z;
	_tmp5_ = _tmp4_->re_sign;
	self->re_sign = _tmp5_;
	_tmp6_ = z;
	_tmp7_ = _tmp6_->im_sign;
	self->im_sign = _tmp7_;
	_tmp8_ = z;
	_tmp9_ = _tmp8_->re_exponent;
	self->re_exponent = _tmp9_;
	_tmp10_ = z;
	_tmp11_ = _tmp10_->im_exponent;
	self->im_exponent = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				gint _tmp14_ = 0;
				Number* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				Number* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				Number* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				if (!_tmp12_) {
					gint _tmp13_ = 0;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = z;
				if (!(_tmp14_ < 1000)) {
					break;
				}
				_tmp16_ = i;
				_tmp17_ = z;
				_tmp18_ = i;
				_tmp19_ = _tmp17_->re_fraction[_tmp18_];
				self->re_fraction[_tmp16_] = _tmp19_;
				_tmp20_ = self->re_fraction[_tmp16_];
				_tmp21_ = i;
				_tmp22_ = z;
				_tmp23_ = i;
				_tmp24_ = _tmp22_->im_fraction[_tmp23_];
				self->im_fraction[_tmp21_] = _tmp24_;
				_tmp25_ = self->im_fraction[_tmp21_];
			}
		}
	}
	_g_object_unref0 (z);
	return self;
}


Number* number_new_eulers (void) {
	return number_construct_eulers (TYPE_NUMBER);
}


Number* number_construct_i (GType object_type) {
	Number * self = NULL;
	gint _tmp0_ = 0;
	self = (Number*) g_object_new (object_type, NULL);
	self->im_sign = 1;
	self->im_exponent = 1;
	self->im_fraction[0] = 1;
	_tmp0_ = self->im_fraction[0];
	return self;
}


Number* number_new_i (void) {
	return number_construct_i (TYPE_NUMBER);
}


Number* number_construct_pi (GType object_type) {
	Number * self = NULL;
	self = (Number*) number_construct_double (object_type, G_PI);
	return self;
}


Number* number_new_pi (void) {
	return number_construct_pi (TYPE_NUMBER);
}


Number* number_construct_random (GType object_type) {
	Number * self = NULL;
	gdouble _tmp0_ = 0.0;
	_tmp0_ = g_random_double ();
	self = (Number*) number_construct_double (object_type, _tmp0_);
	return self;
}


Number* number_new_random (void) {
	return number_construct_random (TYPE_NUMBER);
}


gint64 number_to_integer (Number* self) {
	gint64 result = 0LL;
	gint64 z = 0LL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint64 v = 0LL;
	gint64 _tmp13_ = 0LL;
	gint64 _tmp24_ = 0LL;
	gint _tmp25_ = 0;
	gint64 _tmp26_ = 0LL;
	g_return_val_if_fail (self != NULL, 0LL);
	z = (gint64) 0;
	_tmp1_ = self->re_sign;
	if (_tmp1_ == 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_ = 0;
		_tmp2_ = self->re_exponent;
		_tmp0_ = _tmp2_ <= 0;
	}
	if (_tmp0_) {
		result = (gint64) 0;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint64 t = 0LL;
				gint64 _tmp7_ = 0LL;
				gint64 _tmp8_ = 0LL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->re_exponent;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = z;
				t = _tmp7_;
				_tmp8_ = z;
				_tmp9_ = i;
				_tmp10_ = self->re_fraction[_tmp9_];
				z = (_tmp8_ * BASE) + _tmp10_;
				_tmp11_ = z;
				_tmp12_ = t;
				if (_tmp11_ <= _tmp12_) {
					result = (gint64) 0;
					return result;
				}
			}
		}
	}
	_tmp13_ = z;
	v = _tmp13_;
	{
		gint i = 0;
		gint _tmp14_ = 0;
		_tmp14_ = self->re_exponent;
		i = _tmp14_ - 1;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_ = 0;
				gint64 digit = 0LL;
				gint64 _tmp18_ = 0LL;
				gint64 _tmp19_ = 0LL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint64 _tmp22_ = 0LL;
				gint64 _tmp23_ = 0LL;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = i;
					i = _tmp16_ - 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				if (!(_tmp17_ >= 0)) {
					break;
				}
				_tmp18_ = v;
				_tmp19_ = v;
				digit = _tmp18_ - ((_tmp19_ / BASE) * BASE);
				_tmp20_ = i;
				_tmp21_ = self->re_fraction[_tmp20_];
				_tmp22_ = digit;
				if (((gint64) _tmp21_) != _tmp22_) {
					result = (gint64) 0;
					return result;
				}
				_tmp23_ = v;
				v = _tmp23_ / BASE;
			}
		}
	}
	_tmp24_ = v;
	if (_tmp24_ != ((gint64) 0)) {
		result = (gint64) 0;
		return result;
	}
	_tmp25_ = self->re_sign;
	_tmp26_ = z;
	result = _tmp25_ * _tmp26_;
	return result;
}


guint64 number_to_unsigned_integer (Number* self) {
	guint64 result = 0ULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	guint64 z = 0ULL;
	guint64 v = 0ULL;
	guint64 _tmp13_ = 0ULL;
	guint64 _tmp24_ = 0ULL;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp1_ = self->re_sign;
	if (_tmp1_ <= 0) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp2_ = 0;
		_tmp2_ = self->re_exponent;
		_tmp0_ = _tmp2_ <= 0;
	}
	if (_tmp0_) {
		result = (guint64) 0;
		return result;
	}
	z = (guint64) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				guint64 t = 0ULL;
				guint64 _tmp7_ = 0ULL;
				guint64 _tmp8_ = 0ULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				guint64 _tmp11_ = 0ULL;
				guint64 _tmp12_ = 0ULL;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = self->re_exponent;
				if (!(_tmp5_ < _tmp6_)) {
					break;
				}
				_tmp7_ = z;
				t = _tmp7_;
				_tmp8_ = z;
				_tmp9_ = i;
				_tmp10_ = self->re_fraction[_tmp9_];
				z = (_tmp8_ * BASE) + _tmp10_;
				_tmp11_ = z;
				_tmp12_ = t;
				if (_tmp11_ <= _tmp12_) {
					result = (guint64) 0;
					return result;
				}
			}
		}
	}
	_tmp13_ = z;
	v = _tmp13_;
	{
		gint i = 0;
		gint _tmp14_ = 0;
		_tmp14_ = self->re_exponent;
		i = _tmp14_ - 1;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_ = 0;
				guint64 digit = 0ULL;
				guint64 _tmp18_ = 0ULL;
				guint64 _tmp19_ = 0ULL;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				guint64 _tmp22_ = 0ULL;
				guint64 _tmp23_ = 0ULL;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = i;
					i = _tmp16_ - 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				if (!(_tmp17_ >= 0)) {
					break;
				}
				_tmp18_ = v;
				_tmp19_ = v;
				digit = ((guint64) _tmp18_) - ((_tmp19_ / BASE) * BASE);
				_tmp20_ = i;
				_tmp21_ = self->re_fraction[_tmp20_];
				_tmp22_ = digit;
				if (((guint64) _tmp21_) != _tmp22_) {
					result = (guint64) 0;
					return result;
				}
				_tmp23_ = v;
				v = _tmp23_ / BASE;
			}
		}
	}
	_tmp24_ = v;
	if (_tmp24_ != ((guint64) 0)) {
		result = (guint64) 0;
		return result;
	}
	result = z;
	return result;
}


gfloat number_to_float (Number* self) {
	gfloat result = 0.0F;
	gboolean _tmp0_ = FALSE;
	gfloat z = 0.0F;
	gint _tmp12_ = 0;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		result = 0.f;
		return result;
	}
	z = 0.f;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < T)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = self->re_fraction[_tmp4_];
				if (_tmp5_ != 0) {
					gfloat _tmp6_ = 0.0F;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gfloat _tmp11_ = 0.0F;
					_tmp6_ = z;
					_tmp7_ = i;
					_tmp8_ = self->re_fraction[_tmp7_];
					_tmp9_ = self->re_exponent;
					_tmp10_ = i;
					_tmp11_ = powf ((gfloat) BASE, (gfloat) ((_tmp9_ - _tmp10_) - 1));
					z = _tmp6_ + (_tmp8_ * _tmp11_);
				}
			}
		}
	}
	_tmp12_ = self->re_sign;
	if (_tmp12_ < 0) {
		gfloat _tmp13_ = 0.0F;
		_tmp13_ = z;
		result = -_tmp13_;
		return result;
	} else {
		result = z;
		return result;
	}
}


gdouble number_to_double (Number* self) {
	gdouble result = 0.0;
	gboolean _tmp0_ = FALSE;
	gdouble z = 0.0;
	gint _tmp12_ = 0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		result = 0.;
		return result;
	}
	z = 0.;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < T)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = self->re_fraction[_tmp4_];
				if (_tmp5_ != 0) {
					gdouble _tmp6_ = 0.0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gdouble _tmp11_ = 0.0;
					_tmp6_ = z;
					_tmp7_ = i;
					_tmp8_ = self->re_fraction[_tmp7_];
					_tmp9_ = self->re_exponent;
					_tmp10_ = i;
					_tmp11_ = pow ((gdouble) BASE, (gdouble) ((_tmp9_ - _tmp10_) - 1));
					z = _tmp6_ + (_tmp8_ * _tmp11_);
				}
			}
		}
	}
	_tmp12_ = self->re_sign;
	if (_tmp12_ < 0) {
		gdouble _tmp13_ = 0.0;
		_tmp13_ = z;
		result = -_tmp13_;
		return result;
	} else {
		result = z;
		return result;
	}
}


gboolean number_is_zero (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->re_sign;
	if (_tmp1_ == 0) {
		gint _tmp2_ = 0;
		_tmp2_ = self->im_sign;
		_tmp0_ = _tmp2_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean number_is_negative (Number* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->re_sign;
	result = _tmp0_ < 0;
	return result;
}


gboolean number_is_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Number* t3 = NULL;
	Number* _tmp1_ = NULL;
	Number* t1 = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* t2 = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = number_new_integer ((gint64) 10000);
	t3 = _tmp1_;
	_tmp2_ = t3;
	_tmp3_ = number_multiply (self, _tmp2_);
	t1 = _tmp3_;
	_tmp4_ = t1;
	_tmp5_ = t3;
	_tmp6_ = number_divide (_tmp4_, _tmp5_);
	_g_object_unref0 (t1);
	t1 = _tmp6_;
	_tmp7_ = t1;
	_tmp8_ = number_floor (_tmp7_);
	t2 = _tmp8_;
	_tmp9_ = t1;
	_tmp10_ = t2;
	_tmp11_ = number_equals (_tmp9_, _tmp10_);
	result = _tmp11_;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	_g_object_unref0 (t3);
	return result;
}


gboolean number_is_positive_integer (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		gint _tmp2_ = 0;
		_tmp2_ = self->re_sign;
		if (_tmp2_ >= 0) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = number_is_integer (self);
			_tmp1_ = _tmp3_;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		return result;
	}
}


gboolean number_is_natural (Number* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		gint _tmp2_ = 0;
		_tmp2_ = self->re_sign;
		if (_tmp2_ > 0) {
			gboolean _tmp3_ = FALSE;
			_tmp3_ = number_is_integer (self);
			_tmp1_ = _tmp3_;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		return result;
	}
}


gboolean number_is_complex (Number* self) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->im_sign;
	result = _tmp0_ != 0;
	return result;
}


gboolean number_equals (Number* self, Number* y) {
	gboolean result = FALSE;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	_tmp0_ = y;
	_tmp1_ = number_compare (self, _tmp0_);
	result = _tmp1_ == 0;
	return result;
}


gint number_compare (Number* self, Number* y) {
	gint result = 0;
	gint _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (y != NULL, 0);
	_tmp0_ = self->re_sign;
	_tmp1_ = y;
	_tmp2_ = _tmp1_->re_sign;
	if (_tmp0_ != _tmp2_) {
		gint _tmp3_ = 0;
		Number* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp3_ = self->re_sign;
		_tmp4_ = y;
		_tmp5_ = _tmp4_->re_sign;
		if (_tmp3_ > _tmp5_) {
			result = 1;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
	_tmp6_ = number_is_zero (self);
	if (_tmp6_) {
		result = 0;
		return result;
	}
	_tmp7_ = self->re_exponent;
	_tmp8_ = y;
	_tmp9_ = _tmp8_->re_exponent;
	if (_tmp7_ != _tmp9_) {
		gint _tmp10_ = 0;
		Number* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp10_ = self->re_exponent;
		_tmp11_ = y;
		_tmp12_ = _tmp11_->re_exponent;
		if (_tmp10_ > _tmp12_) {
			gint _tmp13_ = 0;
			_tmp13_ = self->re_sign;
			result = _tmp13_;
			return result;
		} else {
			gint _tmp14_ = 0;
			_tmp14_ = self->re_sign;
			result = -_tmp14_;
			return result;
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				Number* _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				if (!(_tmp17_ < SIZE)) {
					break;
				}
				_tmp18_ = i;
				_tmp19_ = self->re_fraction[_tmp18_];
				_tmp20_ = y;
				_tmp21_ = i;
				_tmp22_ = _tmp20_->re_fraction[_tmp21_];
				if (_tmp19_ == _tmp22_) {
					continue;
				}
				_tmp23_ = i;
				_tmp24_ = self->re_fraction[_tmp23_];
				_tmp25_ = y;
				_tmp26_ = i;
				_tmp27_ = _tmp25_->re_fraction[_tmp26_];
				if (_tmp24_ > _tmp27_) {
					gint _tmp28_ = 0;
					_tmp28_ = self->re_sign;
					result = _tmp28_;
					return result;
				} else {
					gint _tmp29_ = 0;
					_tmp29_ = self->re_sign;
					result = -_tmp29_;
					return result;
				}
			}
		}
	}
	result = 0;
	return result;
}


Number* number_sgn (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 0);
		result = _tmp1_;
		return result;
	} else {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = number_is_negative (self);
		if (_tmp2_) {
			Number* _tmp3_ = NULL;
			_tmp3_ = number_new_integer ((gint64) (-1));
			result = _tmp3_;
			return result;
		} else {
			Number* _tmp4_ = NULL;
			_tmp4_ = number_new_integer ((gint64) 1);
			result = _tmp4_;
			return result;
		}
	}
}


Number* number_invert_sign (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_copy (self);
	z = _tmp0_;
	_tmp1_ = z->re_sign;
	z->re_sign = -_tmp1_;
	_tmp2_ = z->im_sign;
	z->im_sign = -_tmp2_;
	result = z;
	return result;
}


Number* number_abs (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* z = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		_tmp1_ = number_real_component (self);
		x_real = _tmp1_;
		_tmp2_ = number_imaginary_component (self);
		x_im = _tmp2_;
		_tmp3_ = x_real;
		_tmp4_ = x_real;
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
		_g_object_unref0 (x_real);
		x_real = _tmp5_;
		_tmp6_ = x_im;
		_tmp7_ = x_im;
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
		_g_object_unref0 (x_im);
		x_im = _tmp8_;
		_tmp9_ = x_real;
		_tmp10_ = x_im;
		_tmp11_ = number_add (_tmp9_, _tmp10_);
		z = _tmp11_;
		_tmp12_ = z;
		_tmp13_ = number_root (_tmp12_, (gint64) 2);
		result = _tmp13_;
		_g_object_unref0 (z);
		_g_object_unref0 (x_im);
		_g_object_unref0 (x_real);
		return result;
	} else {
		Number* z = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp14_ = number_copy (self);
		z = _tmp14_;
		_tmp15_ = z;
		_tmp16_ = _tmp15_->re_sign;
		if (_tmp16_ < 0) {
			Number* _tmp17_ = NULL;
			Number* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			_tmp17_ = z;
			_tmp18_ = z;
			_tmp19_ = _tmp18_->re_sign;
			_tmp17_->re_sign = -_tmp19_;
		}
		result = z;
		return result;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Number* number_arg (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* x_real = NULL;
	Number* _tmp3_ = NULL;
	Number* x_im = NULL;
	Number* _tmp4_ = NULL;
	Number* pi = NULL;
	Number* _tmp5_ = NULL;
	Number* z = NULL;
	Number* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	Number* _tmp41_ = NULL;
	AngleUnit _tmp42_ = 0;
	Number* _tmp43_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		_tmp1_ = _ ("Argument not defined for zero");
		mperr (_tmp1_);
		_tmp2_ = number_new_integer ((gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = number_real_component (self);
	x_real = _tmp3_;
	_tmp4_ = number_imaginary_component (self);
	x_im = _tmp4_;
	_tmp5_ = number_new_pi ();
	pi = _tmp5_;
	_tmp6_ = x_im;
	_tmp7_ = number_is_zero (_tmp6_);
	if (_tmp7_) {
		Number* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = x_real;
		_tmp9_ = number_is_negative (_tmp8_);
		if (_tmp9_) {
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			_tmp10_ = pi;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (z);
			z = _tmp11_;
		} else {
			Number* _tmp12_ = NULL;
			_tmp12_ = number_new_integer ((gint64) 0);
			result = _tmp12_;
			_g_object_unref0 (z);
			_g_object_unref0 (pi);
			_g_object_unref0 (x_im);
			_g_object_unref0 (x_real);
			return result;
		}
	} else {
		Number* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		_tmp13_ = x_real;
		_tmp14_ = number_is_zero (_tmp13_);
		if (_tmp14_) {
			Number* _tmp15_ = NULL;
			gboolean _tmp16_ = FALSE;
			_tmp15_ = x_im;
			_tmp16_ = number_is_negative (_tmp15_);
			if (_tmp16_) {
				Number* _tmp17_ = NULL;
				Number* _tmp18_ = NULL;
				_tmp17_ = pi;
				_tmp18_ = number_divide_integer (_tmp17_, (gint64) (-2));
				_g_object_unref0 (z);
				z = _tmp18_;
			} else {
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
				_tmp19_ = pi;
				_tmp20_ = number_divide_integer (_tmp19_, (gint64) 2);
				_g_object_unref0 (z);
				z = _tmp20_;
			}
		} else {
			Number* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp21_ = x_real;
			_tmp22_ = number_is_negative (_tmp21_);
			if (_tmp22_) {
				Number* _tmp23_ = NULL;
				Number* _tmp24_ = NULL;
				Number* _tmp25_ = NULL;
				Number* _tmp26_ = NULL;
				Number* _tmp27_ = NULL;
				Number* _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
				_tmp23_ = x_im;
				_tmp24_ = x_real;
				_tmp25_ = number_divide (_tmp23_, _tmp24_);
				_g_object_unref0 (z);
				z = _tmp25_;
				_tmp26_ = z;
				_tmp27_ = number_atan (_tmp26_, ANGLE_UNIT_RADIANS);
				_g_object_unref0 (z);
				z = _tmp27_;
				_tmp28_ = x_im;
				_tmp29_ = number_is_negative (_tmp28_);
				if (_tmp29_) {
					Number* _tmp30_ = NULL;
					Number* _tmp31_ = NULL;
					Number* _tmp32_ = NULL;
					_tmp30_ = z;
					_tmp31_ = pi;
					_tmp32_ = number_subtract (_tmp30_, _tmp31_);
					_g_object_unref0 (z);
					z = _tmp32_;
				} else {
					Number* _tmp33_ = NULL;
					Number* _tmp34_ = NULL;
					Number* _tmp35_ = NULL;
					_tmp33_ = z;
					_tmp34_ = pi;
					_tmp35_ = number_add (_tmp33_, _tmp34_);
					_g_object_unref0 (z);
					z = _tmp35_;
				}
			} else {
				Number* _tmp36_ = NULL;
				Number* _tmp37_ = NULL;
				Number* _tmp38_ = NULL;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				_tmp36_ = x_im;
				_tmp37_ = x_real;
				_tmp38_ = number_divide (_tmp36_, _tmp37_);
				_g_object_unref0 (z);
				z = _tmp38_;
				_tmp39_ = z;
				_tmp40_ = number_atan (_tmp39_, ANGLE_UNIT_RADIANS);
				_g_object_unref0 (z);
				z = _tmp40_;
			}
		}
	}
	_tmp41_ = z;
	_tmp42_ = unit;
	_tmp43_ = number_from_radians (_tmp41_, _tmp42_);
	result = _tmp43_;
	_g_object_unref0 (z);
	_g_object_unref0 (pi);
	_g_object_unref0 (x_im);
	_g_object_unref0 (x_real);
	return result;
}


Number* number_conjugate (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_copy (self);
	z = _tmp0_;
	_tmp1_ = z->im_sign;
	z->im_sign = -_tmp1_;
	result = z;
	return result;
}


Number* number_real_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_copy (self);
	z = _tmp0_;
	_tmp1_ = z;
	_tmp1_->im_sign = 0;
	_tmp2_ = z;
	_tmp2_->im_exponent = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				Number* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = z;
				if (!(_tmp5_ < 1000)) {
					break;
				}
				_tmp7_ = z;
				_tmp8_ = i;
				_tmp7_->im_fraction[_tmp8_] = 0;
				_tmp9_ = _tmp7_->im_fraction[_tmp8_];
			}
		}
	}
	result = z;
	return result;
}


Number* number_imaginary_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = z;
	_tmp2_ = self->im_sign;
	_tmp1_->re_sign = _tmp2_;
	_tmp3_ = z;
	_tmp4_ = self->im_exponent;
	_tmp3_->re_exponent = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				Number* _tmp8_ = NULL;
				Number* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = z;
				if (!(_tmp7_ < 1000)) {
					break;
				}
				_tmp9_ = z;
				_tmp10_ = i;
				_tmp11_ = i;
				_tmp12_ = self->im_fraction[_tmp11_];
				_tmp9_->re_fraction[_tmp10_] = _tmp12_;
				_tmp13_ = _tmp9_->re_fraction[_tmp10_];
			}
		}
	}
	_tmp14_ = z;
	_tmp14_->im_sign = 0;
	_tmp15_ = z;
	_tmp15_->im_exponent = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_ = 0;
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				if (!_tmp16_) {
					gint _tmp17_ = 0;
					_tmp17_ = i;
					i = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = i;
				_tmp19_ = z;
				if (!(_tmp18_ < 1000)) {
					break;
				}
				_tmp20_ = z;
				_tmp21_ = i;
				_tmp20_->im_fraction[_tmp21_] = 0;
				_tmp22_ = _tmp20_->im_fraction[_tmp21_];
			}
		}
	}
	result = z;
	return result;
}


Number* number_integer_component (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_copy (self);
	z = _tmp0_;
	{
		gint i = 0;
		Number* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		_tmp1_ = z;
		_tmp2_ = _tmp1_->re_exponent;
		i = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_ = 0;
				Number* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < SIZE)) {
					break;
				}
				_tmp6_ = z;
				_tmp7_ = i;
				_tmp6_->re_fraction[_tmp7_] = 0;
				_tmp8_ = _tmp6_->re_fraction[_tmp7_];
			}
		}
	}
	_tmp9_ = z;
	_tmp9_->im_sign = 0;
	_tmp10_ = z;
	_tmp10_->im_exponent = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gint _tmp13_ = 0;
				Number* _tmp14_ = NULL;
				Number* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = i;
					i = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = i;
				_tmp14_ = z;
				if (!(_tmp13_ < 1000)) {
					break;
				}
				_tmp15_ = z;
				_tmp16_ = i;
				_tmp15_->im_fraction[_tmp16_] = 0;
				_tmp17_ = _tmp15_->im_fraction[_tmp16_];
			}
		}
	}
	result = z;
	return result;
}


Number* number_fractional_component (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	gint shift = 0;
	gint _tmp4_ = 0;
	Number* z = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	Number* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	Number* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->re_exponent;
	if (_tmp2_ <= 0) {
		Number* _tmp3_ = NULL;
		_tmp3_ = _g_object_ref0 (self);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->re_exponent;
	shift = _tmp4_;
	{
		gint i = 0;
		gint _tmp5_ = 0;
		_tmp5_ = shift;
		i = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_ = FALSE;
				gint _tmp9_ = 0;
				gint _tmp12_ = 0;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp9_ = i;
				if (_tmp9_ < SIZE) {
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					_tmp10_ = i;
					_tmp11_ = self->re_fraction[_tmp10_];
					_tmp8_ = _tmp11_ == 0;
				} else {
					_tmp8_ = FALSE;
				}
				if (!_tmp8_) {
					break;
				}
				_tmp12_ = shift;
				shift = _tmp12_ + 1;
			}
		}
	}
	_tmp13_ = number_new_integer ((gint64) 0);
	z = _tmp13_;
	_tmp14_ = z;
	_tmp15_ = self->re_sign;
	_tmp14_->re_sign = _tmp15_;
	_tmp16_ = z;
	_tmp17_ = self->re_exponent;
	_tmp18_ = shift;
	_tmp16_->re_exponent = _tmp17_ - _tmp18_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				if (!_tmp19_) {
					gint _tmp20_ = 0;
					_tmp20_ = i;
					i = _tmp20_ + 1;
				}
				_tmp19_ = FALSE;
				_tmp21_ = i;
				if (!(_tmp21_ < SIZE)) {
					break;
				}
				_tmp22_ = i;
				_tmp23_ = shift;
				if ((_tmp22_ + _tmp23_) >= SIZE) {
					Number* _tmp24_ = NULL;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					_tmp24_ = z;
					_tmp25_ = i;
					_tmp24_->re_fraction[_tmp25_] = 0;
					_tmp26_ = _tmp24_->re_fraction[_tmp25_];
				} else {
					Number* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					_tmp27_ = z;
					_tmp28_ = i;
					_tmp29_ = i;
					_tmp30_ = shift;
					_tmp31_ = self->re_fraction[_tmp29_ + _tmp30_];
					_tmp27_->re_fraction[_tmp28_] = _tmp31_;
					_tmp32_ = _tmp27_->re_fraction[_tmp28_];
				}
			}
		}
	}
	_tmp33_ = z;
	_tmp34_ = _tmp33_->re_fraction[0];
	if (_tmp34_ == 0) {
		Number* _tmp35_ = NULL;
		_tmp35_ = z;
		_tmp35_->re_sign = 0;
	}
	result = z;
	return result;
}


Number* number_fractional_part (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_floor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_subtract (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


Number* number_floor (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	Number* z = NULL;
	Number* _tmp6_ = NULL;
	gboolean have_fraction = FALSE;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = _g_object_ref0 (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->re_exponent;
	if (_tmp2_ <= 0) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = number_is_negative (self);
		if (_tmp3_) {
			Number* _tmp4_ = NULL;
			_tmp4_ = number_new_integer ((gint64) (-1));
			result = _tmp4_;
			return result;
		} else {
			Number* _tmp5_ = NULL;
			_tmp5_ = number_new_integer ((gint64) 0);
			result = _tmp5_;
			return result;
		}
	}
	_tmp6_ = number_copy (self);
	z = _tmp6_;
	have_fraction = FALSE;
	{
		gint i = 0;
		Number* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp7_ = z;
		_tmp8_ = _tmp7_->re_exponent;
		i = _tmp8_;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				Number* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				Number* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = i;
				if (!(_tmp11_ < SIZE)) {
					break;
				}
				_tmp12_ = z;
				_tmp13_ = i;
				_tmp14_ = _tmp12_->re_fraction[_tmp13_];
				if (_tmp14_ != 0) {
					have_fraction = TRUE;
				}
				_tmp15_ = z;
				_tmp16_ = i;
				_tmp15_->re_fraction[_tmp16_] = 0;
				_tmp17_ = _tmp15_->re_fraction[_tmp16_];
			}
		}
	}
	_tmp18_ = z;
	_tmp18_->im_sign = 0;
	_tmp19_ = z;
	_tmp19_->im_exponent = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_ = 0;
				Number* _tmp23_ = NULL;
				Number* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				if (!_tmp20_) {
					gint _tmp21_ = 0;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = z;
				if (!(_tmp22_ < 1000)) {
					break;
				}
				_tmp24_ = z;
				_tmp25_ = i;
				_tmp24_->im_fraction[_tmp25_] = 0;
				_tmp26_ = _tmp24_->im_fraction[_tmp25_];
			}
		}
	}
	_tmp28_ = have_fraction;
	if (_tmp28_) {
		gboolean _tmp29_ = FALSE;
		_tmp29_ = number_is_negative (self);
		_tmp27_ = _tmp29_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		_tmp30_ = z;
		_tmp31_ = number_new_integer ((gint64) (-1));
		_tmp32_ = _tmp31_;
		_tmp33_ = number_add (_tmp30_, _tmp32_);
		_g_object_unref0 (z);
		z = _tmp33_;
		_g_object_unref0 (_tmp32_);
	}
	result = z;
	return result;
}


Number* number_ceiling (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* f = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_floor (self);
	z = _tmp0_;
	_tmp1_ = number_fractional_component (self);
	f = _tmp1_;
	_tmp2_ = f;
	_tmp3_ = number_is_zero (_tmp2_);
	if (_tmp3_) {
		result = z;
		_g_object_unref0 (f);
		return result;
	}
	_tmp4_ = z;
	_tmp5_ = number_new_integer ((gint64) 1);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_add (_tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	result = _tmp8_;
	_g_object_unref0 (f);
	_g_object_unref0 (z);
	return result;
}


Number* number_round (Number* self) {
	Number* result = NULL;
	gboolean do_floor = FALSE;
	gboolean _tmp0_ = FALSE;
	Number* f = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_negative (self);
	do_floor = !_tmp0_;
	_tmp1_ = number_fractional_component (self);
	f = _tmp1_;
	_tmp2_ = f;
	_tmp3_ = number_multiply_integer (_tmp2_, (gint64) 2);
	_g_object_unref0 (f);
	f = _tmp3_;
	_tmp4_ = f;
	_tmp5_ = number_abs (_tmp4_);
	_g_object_unref0 (f);
	f = _tmp5_;
	_tmp6_ = f;
	_tmp7_ = number_new_integer ((gint64) 1);
	_tmp8_ = _tmp7_;
	_tmp9_ = number_compare (_tmp6_, _tmp8_);
	_tmp10_ = _tmp9_ >= 0;
	_g_object_unref0 (_tmp8_);
	if (_tmp10_) {
		gboolean _tmp11_ = FALSE;
		_tmp11_ = do_floor;
		do_floor = !_tmp11_;
	}
	_tmp12_ = do_floor;
	if (_tmp12_) {
		Number* _tmp13_ = NULL;
		_tmp13_ = number_floor (self);
		result = _tmp13_;
		_g_object_unref0 (f);
		return result;
	} else {
		Number* _tmp14_ = NULL;
		_tmp14_ = number_ceiling (self);
		result = _tmp14_;
		_g_object_unref0 (f);
		return result;
	}
	_g_object_unref0 (f);
}


Number* number_reciprocal (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* real_x = NULL;
		Number* _tmp1_ = NULL;
		Number* im_x = NULL;
		Number* _tmp2_ = NULL;
		Number* t1 = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* t2 = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* z = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		_tmp1_ = number_real_component (self);
		real_x = _tmp1_;
		_tmp2_ = number_imaginary_component (self);
		im_x = _tmp2_;
		_tmp3_ = real_x;
		_tmp4_ = real_x;
		_tmp5_ = number_multiply (_tmp3_, _tmp4_);
		t1 = _tmp5_;
		_tmp6_ = im_x;
		_tmp7_ = im_x;
		_tmp8_ = number_multiply (_tmp6_, _tmp7_);
		t2 = _tmp8_;
		_tmp9_ = t1;
		_tmp10_ = t2;
		_tmp11_ = number_add (_tmp9_, _tmp10_);
		_g_object_unref0 (t1);
		t1 = _tmp11_;
		_tmp12_ = t1;
		_tmp13_ = number_reciprocal_real (_tmp12_);
		z = _tmp13_;
		_tmp14_ = number_conjugate (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = z;
		_tmp17_ = number_multiply (_tmp15_, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp15_);
		result = _tmp18_;
		_g_object_unref0 (z);
		_g_object_unref0 (t2);
		_g_object_unref0 (t1);
		_g_object_unref0 (im_x);
		_g_object_unref0 (real_x);
		return result;
	} else {
		Number* _tmp19_ = NULL;
		_tmp19_ = number_reciprocal_real (self);
		result = _tmp19_;
		return result;
	}
}


Number* number_epowy (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 1);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_is_complex (self);
	if (_tmp2_) {
		Number* x_real = NULL;
		Number* _tmp3_ = NULL;
		Number* theta = NULL;
		Number* _tmp4_ = NULL;
		Number* r = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		_tmp3_ = number_real_component (self);
		x_real = _tmp3_;
		_tmp4_ = number_imaginary_component (self);
		theta = _tmp4_;
		_tmp5_ = x_real;
		_tmp6_ = number_epowy_real (_tmp5_);
		r = _tmp6_;
		_tmp7_ = r;
		_tmp8_ = theta;
		_tmp9_ = number_new_polar (_tmp7_, _tmp8_, ANGLE_UNIT_RADIANS);
		result = _tmp9_;
		_g_object_unref0 (r);
		_g_object_unref0 (theta);
		_g_object_unref0 (x_real);
		return result;
	} else {
		Number* _tmp10_ = NULL;
		_tmp10_ = number_epowy_real (self);
		result = _tmp10_;
		return result;
	}
}


Number* number_xpowy (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_is_integer (_tmp0_);
	if (_tmp1_) {
		Number* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		Number* _tmp4_ = NULL;
		_tmp2_ = y;
		_tmp3_ = number_to_integer (_tmp2_);
		_tmp4_ = number_xpowy_integer (self, _tmp3_);
		result = _tmp4_;
		return result;
	} else {
		Number* reciprocal = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = y;
		_tmp6_ = number_reciprocal (_tmp5_);
		reciprocal = _tmp6_;
		_tmp7_ = reciprocal;
		_tmp8_ = number_is_integer (_tmp7_);
		if (_tmp8_) {
			Number* _tmp9_ = NULL;
			gint64 _tmp10_ = 0LL;
			Number* _tmp11_ = NULL;
			_tmp9_ = reciprocal;
			_tmp10_ = number_to_integer (_tmp9_);
			_tmp11_ = number_root (self, _tmp10_);
			result = _tmp11_;
			_g_object_unref0 (reciprocal);
			return result;
		} else {
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
			_tmp12_ = y;
			_tmp13_ = number_pwr (self, _tmp12_);
			result = _tmp13_;
			_g_object_unref0 (reciprocal);
			return result;
		}
		_g_object_unref0 (reciprocal);
	}
}


Number* number_xpowy_integer (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint64 _tmp10_ = 0LL;
	gboolean _tmp12_ = FALSE;
	gint64 _tmp14_ = 0LL;
	Number* t = NULL;
	gint64 _tmp16_ = 0LL;
	Number* z = NULL;
	Number* _tmp20_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_is_zero (self);
	if (_tmp1_) {
		gint64 _tmp2_ = 0LL;
		_tmp2_ = n;
		_tmp0_ = _tmp2_ < ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp3_ = _ ("The power of zero is undefined for a negative exponent");
		mperr (_tmp3_);
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp6_ = number_is_zero (self);
	if (_tmp6_) {
		gint64 _tmp7_ = 0LL;
		_tmp7_ = n;
		_tmp5_ = _tmp7_ == ((gint64) 0);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		_tmp8_ = _ ("Zero raised to zero is undefined");
		mperr (_tmp8_);
		_tmp9_ = number_new_integer ((gint64) 0);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = n;
	if (_tmp10_ == ((gint64) 0)) {
		Number* _tmp11_ = NULL;
		_tmp11_ = number_new_integer ((gint64) 1);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = number_is_zero (self);
	if (_tmp12_) {
		Number* _tmp13_ = NULL;
		_tmp13_ = number_new_integer ((gint64) 0);
		result = _tmp13_;
		return result;
	}
	_tmp14_ = n;
	if (_tmp14_ == ((gint64) 1)) {
		Number* _tmp15_ = NULL;
		_tmp15_ = _g_object_ref0 (self);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = n;
	if (_tmp16_ < ((gint64) 0)) {
		Number* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		_tmp17_ = number_reciprocal (self);
		_g_object_unref0 (t);
		t = _tmp17_;
		_tmp18_ = n;
		n = -_tmp18_;
	} else {
		Number* _tmp19_ = NULL;
		_tmp19_ = _g_object_ref0 (self);
		_g_object_unref0 (t);
		t = _tmp19_;
	}
	_tmp20_ = number_new_integer ((gint64) 1);
	z = _tmp20_;
	while (TRUE) {
		gint64 _tmp21_ = 0LL;
		gint64 _tmp22_ = 0LL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		gint64 _tmp29_ = 0LL;
		_tmp21_ = n;
		if (!(_tmp21_ != ((gint64) 0))) {
			break;
		}
		_tmp22_ = n;
		if ((_tmp22_ % 2) == ((gint64) 1)) {
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			Number* _tmp25_ = NULL;
			_tmp23_ = z;
			_tmp24_ = t;
			_tmp25_ = number_multiply (_tmp23_, _tmp24_);
			_g_object_unref0 (z);
			z = _tmp25_;
		}
		_tmp26_ = t;
		_tmp27_ = t;
		_tmp28_ = number_multiply (_tmp26_, _tmp27_);
		_g_object_unref0 (t);
		t = _tmp28_;
		_tmp29_ = n;
		n = _tmp29_ / 2;
	}
	result = z;
	_g_object_unref0 (t);
	return result;
}


Number* number_root (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = number_is_complex (self);
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = number_is_negative (self);
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint64 _tmp4_ = 0LL;
		_tmp4_ = n;
		_tmp0_ = (_tmp4_ % 2) == ((gint64) 1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Number* z = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		_tmp5_ = number_abs (self);
		z = _tmp5_;
		_tmp6_ = z;
		_tmp7_ = n;
		_tmp8_ = number_root_real (_tmp6_, _tmp7_);
		_g_object_unref0 (z);
		z = _tmp8_;
		_tmp9_ = z;
		_tmp10_ = number_invert_sign (_tmp9_);
		_g_object_unref0 (z);
		z = _tmp10_;
		result = z;
		return result;
	} else {
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp12_ = number_is_complex (self);
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			gboolean _tmp13_ = FALSE;
			_tmp13_ = number_is_negative (self);
			_tmp11_ = _tmp13_;
		}
		if (_tmp11_) {
			Number* r = NULL;
			Number* _tmp14_ = NULL;
			Number* theta = NULL;
			Number* _tmp15_ = NULL;
			Number* _tmp16_ = NULL;
			gint64 _tmp17_ = 0LL;
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			_tmp14_ = number_abs (self);
			r = _tmp14_;
			_tmp15_ = number_arg (self, ANGLE_UNIT_RADIANS);
			theta = _tmp15_;
			_tmp16_ = r;
			_tmp17_ = n;
			_tmp18_ = number_root_real (_tmp16_, _tmp17_);
			_g_object_unref0 (r);
			r = _tmp18_;
			_tmp19_ = theta;
			_tmp20_ = n;
			_tmp21_ = number_divide_integer (_tmp19_, _tmp20_);
			_g_object_unref0 (theta);
			theta = _tmp21_;
			_tmp22_ = r;
			_tmp23_ = theta;
			_tmp24_ = number_new_polar (_tmp22_, _tmp23_, ANGLE_UNIT_RADIANS);
			result = _tmp24_;
			_g_object_unref0 (theta);
			_g_object_unref0 (r);
			return result;
		} else {
			gint64 _tmp25_ = 0LL;
			Number* _tmp26_ = NULL;
			_tmp25_ = n;
			_tmp26_ = number_root_real (self, _tmp25_);
			result = _tmp26_;
			return result;
		}
	}
}


Number* number_sqrt (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = _g_object_ref0 (self);
		result = _tmp1_;
		return result;
	} else {
		Number* t = NULL;
		Number* _tmp2_ = NULL;
		Number* z = NULL;
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		Number* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		Number* _tmp10_ = NULL;
		_tmp2_ = number_root (self, (gint64) (-2));
		t = _tmp2_;
		_tmp3_ = t;
		_tmp4_ = number_multiply (self, _tmp3_);
		z = _tmp4_;
		_tmp5_ = z;
		_tmp6_ = t;
		_tmp7_ = _tmp6_->re_fraction[0];
		_tmp8_ = z;
		_tmp9_ = _tmp8_->re_fraction[0];
		_tmp10_ = number_ext (_tmp5_, _tmp7_, _tmp9_);
		result = _tmp10_;
		_g_object_unref0 (z);
		_g_object_unref0 (t);
		return result;
	}
}


Number* number_ln (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		_tmp1_ = _ ("Logarithm of zero is undefined");
		mperr (_tmp1_);
		_tmp2_ = number_new_integer ((gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp4_ = number_is_complex (self);
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = number_is_negative (self);
		_tmp3_ = _tmp5_;
	}
	if (_tmp3_) {
		Number* r = NULL;
		Number* _tmp6_ = NULL;
		Number* theta = NULL;
		Number* _tmp7_ = NULL;
		Number* z_real = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		_tmp6_ = number_abs (self);
		r = _tmp6_;
		_tmp7_ = number_arg (self, ANGLE_UNIT_RADIANS);
		theta = _tmp7_;
		_tmp8_ = r;
		_tmp9_ = number_ln_real (_tmp8_);
		z_real = _tmp9_;
		_tmp10_ = z_real;
		_tmp11_ = theta;
		_tmp12_ = number_new_complex (_tmp10_, _tmp11_);
		result = _tmp12_;
		_g_object_unref0 (z_real);
		_g_object_unref0 (theta);
		_g_object_unref0 (r);
		return result;
	} else {
		Number* _tmp13_ = NULL;
		_tmp13_ = number_ln_real (self);
		result = _tmp13_;
		return result;
	}
}


Number* number_logarithm (Number* self, gint64 n) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	gint64 _tmp3_ = 0LL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		_tmp1_ = _ ("Logarithm of zero is undefined");
		mperr (_tmp1_);
		_tmp2_ = number_new_integer ((gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = n;
	_tmp4_ = number_new_integer (_tmp3_);
	t1 = _tmp4_;
	_tmp5_ = number_ln (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = t1;
	_tmp8_ = number_ln (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = number_divide (_tmp6_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp6_);
	result = _tmp11_;
	_g_object_unref0 (t1);
	return result;
}


Number* number_factorial (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint64 value = 0LL;
	gint64 _tmp13_ = 0LL;
	Number* z = NULL;
	Number* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 1);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_is_natural (self);
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gdouble val = 0.0;
		gdouble _tmp8_ = 0.0;
		gdouble fact = 0.0;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		gdouble _tmp11_ = 0.0;
		Number* _tmp12_ = NULL;
		_tmp4_ = number_is_negative (self);
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = number_is_complex (self);
			_tmp3_ = _tmp5_;
		}
		if (_tmp3_) {
			const gchar* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
			_tmp6_ = _ ("Factorial is only defined for non-negative real numbers");
			mperr (_tmp6_);
			_tmp7_ = number_new_integer ((gint64) 0);
			result = _tmp7_;
			return result;
		}
		_tmp8_ = number_to_double (self);
		val = _tmp8_;
		_tmp9_ = val;
		_tmp10_ = tgamma (_tmp9_ + 1);
		fact = _tmp10_;
		_tmp11_ = fact;
		_tmp12_ = number_new_double (_tmp11_);
		result = _tmp12_;
		return result;
	}
	_tmp13_ = number_to_integer (self);
	value = _tmp13_;
	_tmp14_ = _g_object_ref0 (self);
	z = _tmp14_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_ = 0;
				gint64 _tmp18_ = 0LL;
				Number* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				Number* _tmp21_ = NULL;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = value;
				if (!(((gint64) _tmp17_) < _tmp18_)) {
					break;
				}
				_tmp19_ = z;
				_tmp20_ = i;
				_tmp21_ = number_multiply_integer (_tmp19_, (gint64) _tmp20_);
				_g_object_unref0 (z);
				z = _tmp21_;
			}
		}
	}
	result = z;
	return result;
}


Number* number_add (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_add_with_sign (self, 1, _tmp0_);
	result = _tmp1_;
	return result;
}


Number* number_subtract (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_add_with_sign (self, -1, _tmp0_);
	result = _tmp1_;
	return result;
}


Number* number_multiply (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_zero (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_zero (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		Number* _tmp4_ = NULL;
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp6_ = number_is_complex (self);
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		Number* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = y;
		_tmp8_ = number_is_complex (_tmp7_);
		_tmp5_ = _tmp8_;
	}
	if (_tmp5_) {
		Number* t1 = NULL;
		Number* t2 = NULL;
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp9_ = NULL;
		Number* im_x = NULL;
		Number* _tmp10_ = NULL;
		Number* real_y = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* im_y = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		_tmp9_ = number_real_component (self);
		real_x = _tmp9_;
		_tmp10_ = number_imaginary_component (self);
		im_x = _tmp10_;
		_tmp11_ = y;
		_tmp12_ = number_real_component (_tmp11_);
		real_y = _tmp12_;
		_tmp13_ = y;
		_tmp14_ = number_imaginary_component (_tmp13_);
		im_y = _tmp14_;
		_tmp15_ = real_x;
		_tmp16_ = real_y;
		_tmp17_ = number_multiply_real (_tmp15_, _tmp16_);
		_g_object_unref0 (t1);
		t1 = _tmp17_;
		_tmp18_ = im_x;
		_tmp19_ = im_y;
		_tmp20_ = number_multiply_real (_tmp18_, _tmp19_);
		_g_object_unref0 (t2);
		t2 = _tmp20_;
		_tmp21_ = t1;
		_tmp22_ = t2;
		_tmp23_ = number_subtract (_tmp21_, _tmp22_);
		_g_object_unref0 (real_z);
		real_z = _tmp23_;
		_tmp24_ = real_x;
		_tmp25_ = im_y;
		_tmp26_ = number_multiply_real (_tmp24_, _tmp25_);
		_g_object_unref0 (t1);
		t1 = _tmp26_;
		_tmp27_ = im_x;
		_tmp28_ = real_y;
		_tmp29_ = number_multiply_real (_tmp27_, _tmp28_);
		_g_object_unref0 (t2);
		t2 = _tmp29_;
		_tmp30_ = t1;
		_tmp31_ = t2;
		_tmp32_ = number_add (_tmp30_, _tmp31_);
		_g_object_unref0 (im_z);
		im_z = _tmp32_;
		_tmp33_ = real_z;
		_tmp34_ = im_z;
		_tmp35_ = number_new_complex (_tmp33_, _tmp34_);
		result = _tmp35_;
		_g_object_unref0 (im_y);
		_g_object_unref0 (real_y);
		_g_object_unref0 (im_x);
		_g_object_unref0 (real_x);
		_g_object_unref0 (im_z);
		_g_object_unref0 (real_z);
		_g_object_unref0 (t2);
		_g_object_unref0 (t1);
		return result;
	} else {
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		_tmp36_ = y;
		_tmp37_ = number_multiply_real (self, _tmp36_);
		result = _tmp37_;
		return result;
	}
}


Number* number_multiply_integer (Number* self, gint64 y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* re_z = NULL;
		Number* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* im_z = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		_tmp1_ = number_real_component (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = y;
		_tmp4_ = number_multiply_integer_real (_tmp2_, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp2_);
		re_z = _tmp5_;
		_tmp6_ = number_imaginary_component (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = y;
		_tmp9_ = number_multiply_integer_real (_tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp7_);
		im_z = _tmp10_;
		_tmp11_ = re_z;
		_tmp12_ = im_z;
		_tmp13_ = number_new_complex (_tmp11_, _tmp12_);
		result = _tmp13_;
		_g_object_unref0 (im_z);
		_g_object_unref0 (re_z);
		return result;
	} else {
		gint64 _tmp14_ = 0LL;
		Number* _tmp15_ = NULL;
		_tmp14_ = y;
		_tmp15_ = number_multiply_integer_real (self, _tmp14_);
		result = _tmp15_;
		return result;
	}
}


Number* number_divide (Number* self, Number* y) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Number* t = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gint ie = 0;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	gint i = 0;
	Number* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	Number* z = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	Number* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	Number* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = y;
	_tmp1_ = number_is_zero (_tmp0_);
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		_tmp2_ = _ ("Division by zero is undefined");
		mperr (_tmp2_);
		_tmp3_ = number_new_integer ((gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_is_zero (self);
	if (_tmp4_) {
		Number* _tmp5_ = NULL;
		_tmp5_ = _g_object_ref0 (self);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = y;
	_tmp7_ = number_reciprocal (_tmp6_);
	t = _tmp7_;
	_tmp8_ = t;
	_tmp9_ = _tmp8_->re_exponent;
	ie = _tmp9_;
	_tmp10_ = t;
	_tmp10_->re_exponent = 0;
	_tmp11_ = t;
	_tmp12_ = _tmp11_->re_fraction[0];
	i = _tmp12_;
	_tmp13_ = t;
	_tmp14_ = number_multiply (self, _tmp13_);
	z = _tmp14_;
	_tmp15_ = z;
	_tmp16_ = i;
	_tmp17_ = z;
	_tmp18_ = _tmp17_->re_fraction[0];
	_tmp19_ = number_ext (_tmp15_, _tmp16_, _tmp18_);
	_g_object_unref0 (z);
	z = _tmp19_;
	_tmp20_ = z;
	_tmp21_ = z;
	_tmp22_ = _tmp21_->re_exponent;
	_tmp23_ = ie;
	_tmp21_->re_exponent = _tmp22_ + _tmp23_;
	result = z;
	_g_object_unref0 (t);
	return result;
}


Number* number_divide_integer (Number* self, gint64 y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* re_z = NULL;
		Number* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* im_z = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		gint64 _tmp8_ = 0LL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		_tmp1_ = number_real_component (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = y;
		_tmp4_ = number_divide_integer_real (_tmp2_, _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp2_);
		re_z = _tmp5_;
		_tmp6_ = number_imaginary_component (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = y;
		_tmp9_ = number_divide_integer_real (_tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp7_);
		im_z = _tmp10_;
		_tmp11_ = re_z;
		_tmp12_ = im_z;
		_tmp13_ = number_new_complex (_tmp11_, _tmp12_);
		result = _tmp13_;
		_g_object_unref0 (im_z);
		_g_object_unref0 (re_z);
		return result;
	} else {
		gint64 _tmp14_ = 0LL;
		Number* _tmp15_ = NULL;
		_tmp14_ = y;
		_tmp15_ = number_divide_integer_real (self, _tmp14_);
		result = _tmp15_;
		return result;
	}
}


Number* number_modulus_divide (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* t2 = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* z = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		_tmp4_ = _ ("Modulus division is only defined for integers");
		mperr (_tmp4_);
		_tmp5_ = number_new_integer ((gint64) 0);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = y;
	_tmp7_ = number_divide (self, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = number_floor (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	t1 = _tmp10_;
	_tmp11_ = t1;
	_tmp12_ = y;
	_tmp13_ = number_multiply (_tmp11_, _tmp12_);
	t2 = _tmp13_;
	_tmp14_ = t2;
	_tmp15_ = number_subtract (self, _tmp14_);
	z = _tmp15_;
	_tmp16_ = number_new_integer ((gint64) 0);
	_g_object_unref0 (t1);
	t1 = _tmp16_;
	_tmp19_ = y;
	_tmp20_ = t1;
	_tmp21_ = number_compare (_tmp19_, _tmp20_);
	if (_tmp21_ < 0) {
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		_tmp22_ = z;
		_tmp23_ = t1;
		_tmp24_ = number_compare (_tmp22_, _tmp23_);
		_tmp18_ = _tmp24_ > 0;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		gboolean _tmp25_ = FALSE;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		_tmp26_ = y;
		_tmp27_ = t1;
		_tmp28_ = number_compare (_tmp26_, _tmp27_);
		if (_tmp28_ > 0) {
			Number* _tmp29_ = NULL;
			Number* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			_tmp29_ = z;
			_tmp30_ = t1;
			_tmp31_ = number_compare (_tmp29_, _tmp30_);
			_tmp25_ = _tmp31_ < 0;
		} else {
			_tmp25_ = FALSE;
		}
		_tmp17_ = _tmp25_;
	}
	if (_tmp17_) {
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
		_tmp32_ = z;
		_tmp33_ = y;
		_tmp34_ = number_add (_tmp32_, _tmp33_);
		_g_object_unref0 (z);
		z = _tmp34_;
	}
	result = z;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}


Number* number_modular_exponentiation (Number* self, Number* exp, Number* mod) {
	Number* result = NULL;
	Number* base_value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* exp_value = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* ans = NULL;
	Number* _tmp7_ = NULL;
	Number* two = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp34_ = NULL;
	Number* _tmp35_ = NULL;
	Number* _tmp36_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (mod != NULL, NULL);
	_tmp0_ = number_copy (self);
	base_value = _tmp0_;
	_tmp1_ = exp;
	_tmp2_ = number_is_negative (_tmp1_);
	if (_tmp2_) {
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp3_ = base_value;
		_tmp4_ = number_reciprocal (_tmp3_);
		_g_object_unref0 (base_value);
		base_value = _tmp4_;
	}
	_tmp5_ = exp;
	_tmp6_ = number_abs (_tmp5_);
	exp_value = _tmp6_;
	_tmp7_ = number_new_integer ((gint64) 1);
	ans = _tmp7_;
	_tmp8_ = number_new_integer ((gint64) 2);
	two = _tmp8_;
	while (TRUE) {
		Number* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean is_even = FALSE;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		_tmp9_ = exp_value;
		_tmp10_ = number_is_zero (_tmp9_);
		if (!(!_tmp10_)) {
			break;
		}
		_tmp11_ = exp_value;
		_tmp12_ = two;
		_tmp13_ = number_modulus_divide (_tmp11_, _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = number_is_zero (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		is_even = _tmp16_;
		_tmp17_ = is_even;
		if (!_tmp17_) {
			Number* _tmp18_ = NULL;
			Number* _tmp19_ = NULL;
			Number* _tmp20_ = NULL;
			Number* _tmp21_ = NULL;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			_tmp18_ = ans;
			_tmp19_ = base_value;
			_tmp20_ = number_multiply (_tmp18_, _tmp19_);
			_g_object_unref0 (ans);
			ans = _tmp20_;
			_tmp21_ = ans;
			_tmp22_ = mod;
			_tmp23_ = number_modulus_divide (_tmp21_, _tmp22_);
			_g_object_unref0 (ans);
			ans = _tmp23_;
		}
		_tmp24_ = base_value;
		_tmp25_ = base_value;
		_tmp26_ = number_multiply (_tmp24_, _tmp25_);
		_g_object_unref0 (base_value);
		base_value = _tmp26_;
		_tmp27_ = base_value;
		_tmp28_ = mod;
		_tmp29_ = number_modulus_divide (_tmp27_, _tmp28_);
		_g_object_unref0 (base_value);
		base_value = _tmp29_;
		_tmp30_ = exp_value;
		_tmp31_ = number_divide_integer (_tmp30_, (gint64) 2);
		_tmp32_ = _tmp31_;
		_tmp33_ = number_floor (_tmp32_);
		_g_object_unref0 (exp_value);
		exp_value = _tmp33_;
		_g_object_unref0 (_tmp32_);
	}
	_tmp34_ = ans;
	_tmp35_ = mod;
	_tmp36_ = number_modulus_divide (_tmp34_, _tmp35_);
	result = _tmp36_;
	_g_object_unref0 (two);
	_g_object_unref0 (ans);
	_g_object_unref0 (exp_value);
	_g_object_unref0 (base_value);
	return result;
}


Number* number_sin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		_tmp1_ = number_real_component (self);
		x_real = _tmp1_;
		_tmp2_ = number_imaginary_component (self);
		x_im = _tmp2_;
		_tmp3_ = x_real;
		_tmp4_ = unit;
		_tmp5_ = number_sin_real (_tmp3_, _tmp4_);
		z_real = _tmp5_;
		_tmp6_ = x_im;
		_tmp7_ = number_cosh (_tmp6_);
		t = _tmp7_;
		_tmp8_ = z_real;
		_tmp9_ = t;
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
		_g_object_unref0 (z_real);
		z_real = _tmp10_;
		_tmp11_ = x_real;
		_tmp12_ = unit;
		_tmp13_ = number_cos_real (_tmp11_, _tmp12_);
		z_im = _tmp13_;
		_tmp14_ = x_im;
		_tmp15_ = number_sinh (_tmp14_);
		_g_object_unref0 (t);
		t = _tmp15_;
		_tmp16_ = z_im;
		_tmp17_ = t;
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
		_g_object_unref0 (z_im);
		z_im = _tmp18_;
		_tmp19_ = z_real;
		_tmp20_ = z_im;
		_tmp21_ = number_new_complex (_tmp19_, _tmp20_);
		result = _tmp21_;
		_g_object_unref0 (z_im);
		_g_object_unref0 (t);
		_g_object_unref0 (z_real);
		_g_object_unref0 (x_im);
		_g_object_unref0 (x_real);
		return result;
	} else {
		AngleUnit _tmp22_ = 0;
		Number* _tmp23_ = NULL;
		_tmp22_ = unit;
		_tmp23_ = number_sin_real (self, _tmp22_);
		result = _tmp23_;
		return result;
	}
}


Number* number_cos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_complex (self);
	if (_tmp0_) {
		Number* x_real = NULL;
		Number* _tmp1_ = NULL;
		Number* x_im = NULL;
		Number* _tmp2_ = NULL;
		Number* z_real = NULL;
		Number* _tmp3_ = NULL;
		AngleUnit _tmp4_ = 0;
		Number* _tmp5_ = NULL;
		Number* t = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* z_im = NULL;
		Number* _tmp11_ = NULL;
		AngleUnit _tmp12_ = 0;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		_tmp1_ = number_real_component (self);
		x_real = _tmp1_;
		_tmp2_ = number_imaginary_component (self);
		x_im = _tmp2_;
		_tmp3_ = x_real;
		_tmp4_ = unit;
		_tmp5_ = number_cos_real (_tmp3_, _tmp4_);
		z_real = _tmp5_;
		_tmp6_ = x_im;
		_tmp7_ = number_cosh (_tmp6_);
		t = _tmp7_;
		_tmp8_ = z_real;
		_tmp9_ = t;
		_tmp10_ = number_multiply (_tmp8_, _tmp9_);
		_g_object_unref0 (z_real);
		z_real = _tmp10_;
		_tmp11_ = x_real;
		_tmp12_ = unit;
		_tmp13_ = number_sin_real (_tmp11_, _tmp12_);
		z_im = _tmp13_;
		_tmp14_ = x_im;
		_tmp15_ = number_sinh (_tmp14_);
		_g_object_unref0 (t);
		t = _tmp15_;
		_tmp16_ = z_im;
		_tmp17_ = t;
		_tmp18_ = number_multiply (_tmp16_, _tmp17_);
		_g_object_unref0 (z_im);
		z_im = _tmp18_;
		_tmp19_ = z_im;
		_tmp20_ = number_invert_sign (_tmp19_);
		_g_object_unref0 (z_im);
		z_im = _tmp20_;
		_tmp21_ = z_real;
		_tmp22_ = z_im;
		_tmp23_ = number_new_complex (_tmp21_, _tmp22_);
		result = _tmp23_;
		_g_object_unref0 (z_im);
		_g_object_unref0 (t);
		_g_object_unref0 (z_real);
		_g_object_unref0 (x_im);
		_g_object_unref0 (x_real);
		return result;
	} else {
		AngleUnit _tmp24_ = 0;
		Number* _tmp25_ = NULL;
		_tmp24_ = unit;
		_tmp25_ = number_cos_real (self, _tmp24_);
		result = _tmp25_;
		return result;
	}
}


Number* number_tan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* cos_x = NULL;
	AngleUnit _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	AngleUnit _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	_tmp1_ = number_cos (self, _tmp0_);
	cos_x = _tmp1_;
	_tmp2_ = cos_x;
	_tmp3_ = number_is_zero (_tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		_tmp4_ = _ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)");
		mperr (_tmp4_);
		_tmp5_ = number_new_integer ((gint64) 0);
		result = _tmp5_;
		_g_object_unref0 (cos_x);
		return result;
	}
	_tmp6_ = unit;
	_tmp7_ = number_sin (self, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = cos_x;
	_tmp10_ = number_divide (_tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp8_);
	result = _tmp11_;
	_g_object_unref0 (cos_x);
	return result;
}


Number* number_asin (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	Number* t2 = NULL;
	gint _tmp20_ = 0;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp33_ = NULL;
	Number* _tmp34_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->re_exponent;
	if (_tmp2_ <= 0) {
		Number* t1 = NULL;
		Number* _tmp3_ = NULL;
		Number* t2 = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* z = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		AngleUnit _tmp18_ = 0;
		Number* _tmp19_ = NULL;
		_tmp3_ = number_new_integer ((gint64) 1);
		t1 = _tmp3_;
		_tmp4_ = t1;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		t2 = _tmp5_;
		_tmp6_ = t1;
		_tmp7_ = number_subtract (_tmp6_, self);
		_g_object_unref0 (t1);
		t1 = _tmp7_;
		_tmp8_ = t2;
		_tmp9_ = number_add (_tmp8_, self);
		_g_object_unref0 (t2);
		t2 = _tmp9_;
		_tmp10_ = t1;
		_tmp11_ = t2;
		_tmp12_ = number_multiply (_tmp10_, _tmp11_);
		_g_object_unref0 (t2);
		t2 = _tmp12_;
		_tmp13_ = t2;
		_tmp14_ = number_root (_tmp13_, (gint64) (-2));
		_g_object_unref0 (t2);
		t2 = _tmp14_;
		_tmp15_ = t2;
		_tmp16_ = number_multiply (self, _tmp15_);
		z = _tmp16_;
		_tmp17_ = z;
		_tmp18_ = unit;
		_tmp19_ = number_atan (_tmp17_, _tmp18_);
		_g_object_unref0 (z);
		z = _tmp19_;
		result = z;
		_g_object_unref0 (t2);
		_g_object_unref0 (t1);
		return result;
	}
	_tmp20_ = self->re_sign;
	_tmp21_ = number_new_integer ((gint64) _tmp20_);
	t2 = _tmp21_;
	_tmp22_ = t2;
	_tmp23_ = number_equals (self, _tmp22_);
	if (_tmp23_) {
		Number* z = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		AngleUnit _tmp31_ = 0;
		Number* _tmp32_ = NULL;
		_tmp24_ = number_new_pi ();
		_tmp25_ = _tmp24_;
		_tmp26_ = t2;
		_tmp27_ = _tmp26_->re_sign;
		_tmp28_ = number_divide_integer (_tmp25_, (gint64) (2 * _tmp27_));
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp25_);
		z = _tmp29_;
		_tmp30_ = z;
		_tmp31_ = unit;
		_tmp32_ = number_from_radians (_tmp30_, _tmp31_);
		result = _tmp32_;
		_g_object_unref0 (z);
		_g_object_unref0 (t2);
		return result;
	}
	_tmp33_ = _ ("Inverse sine is undefined for values outside [-1, 1]");
	mperr (_tmp33_);
	_tmp34_ = number_new_integer ((gint64) 0);
	result = _tmp34_;
	_g_object_unref0 (t2);
	return result;
}


Number* number_acos (Number* self, AngleUnit unit) {
	Number* result = NULL;
	Number* pi = NULL;
	Number* _tmp0_ = NULL;
	Number* t1 = NULL;
	Number* _tmp1_ = NULL;
	Number* n1 = NULL;
	Number* _tmp2_ = NULL;
	Number* z = NULL;
	gboolean _tmp3_ = FALSE;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp36_ = NULL;
	AngleUnit _tmp37_ = 0;
	Number* _tmp38_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_pi ();
	pi = _tmp0_;
	_tmp1_ = number_new_integer ((gint64) 1);
	t1 = _tmp1_;
	_tmp2_ = number_new_integer ((gint64) (-1));
	n1 = _tmp2_;
	_tmp4_ = t1;
	_tmp5_ = number_compare (self, _tmp4_);
	if (_tmp5_ > 0) {
		_tmp3_ = TRUE;
	} else {
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp6_ = n1;
		_tmp7_ = number_compare (self, _tmp6_);
		_tmp3_ = _tmp7_ < 0;
	}
	if (_tmp3_) {
		const gchar* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		_tmp8_ = _ ("Inverse cosine is undefined for values outside [-1, 1]");
		mperr (_tmp8_);
		_tmp9_ = number_new_integer ((gint64) 0);
		_g_object_unref0 (z);
		z = _tmp9_;
	} else {
		gboolean _tmp10_ = FALSE;
		_tmp10_ = number_is_zero (self);
		if (_tmp10_) {
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			_tmp11_ = pi;
			_tmp12_ = number_divide_integer (_tmp11_, (gint64) 2);
			_g_object_unref0 (z);
			z = _tmp12_;
		} else {
			Number* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = t1;
			_tmp14_ = number_equals (self, _tmp13_);
			if (_tmp14_) {
				Number* _tmp15_ = NULL;
				_tmp15_ = number_new_integer ((gint64) 0);
				_g_object_unref0 (z);
				z = _tmp15_;
			} else {
				Number* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				_tmp16_ = n1;
				_tmp17_ = number_equals (self, _tmp16_);
				if (_tmp17_) {
					Number* _tmp18_ = NULL;
					Number* _tmp19_ = NULL;
					_tmp18_ = pi;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (z);
					z = _tmp19_;
				} else {
					Number* y = NULL;
					Number* t2 = NULL;
					Number* _tmp20_ = NULL;
					Number* _tmp21_ = NULL;
					Number* _tmp22_ = NULL;
					Number* _tmp23_ = NULL;
					Number* _tmp24_ = NULL;
					Number* _tmp25_ = NULL;
					Number* _tmp26_ = NULL;
					Number* _tmp27_ = NULL;
					Number* _tmp28_ = NULL;
					Number* _tmp29_ = NULL;
					gint _tmp30_ = 0;
					_tmp20_ = number_multiply (self, self);
					t2 = _tmp20_;
					_tmp21_ = t1;
					_tmp22_ = t2;
					_tmp23_ = number_subtract (_tmp21_, _tmp22_);
					_g_object_unref0 (t2);
					t2 = _tmp23_;
					_tmp24_ = t2;
					_tmp25_ = number_sqrt (_tmp24_);
					_g_object_unref0 (t2);
					t2 = _tmp25_;
					_tmp26_ = t2;
					_tmp27_ = number_divide (_tmp26_, self);
					_g_object_unref0 (t2);
					t2 = _tmp27_;
					_tmp28_ = t2;
					_tmp29_ = number_atan (_tmp28_, ANGLE_UNIT_RADIANS);
					_g_object_unref0 (y);
					y = _tmp29_;
					_tmp30_ = self->re_sign;
					if (_tmp30_ > 0) {
						Number* _tmp31_ = NULL;
						Number* _tmp32_ = NULL;
						_tmp31_ = y;
						_tmp32_ = _g_object_ref0 (_tmp31_);
						_g_object_unref0 (z);
						z = _tmp32_;
					} else {
						Number* _tmp33_ = NULL;
						Number* _tmp34_ = NULL;
						Number* _tmp35_ = NULL;
						_tmp33_ = y;
						_tmp34_ = pi;
						_tmp35_ = number_add (_tmp33_, _tmp34_);
						_g_object_unref0 (z);
						z = _tmp35_;
					}
					_g_object_unref0 (t2);
					_g_object_unref0 (y);
				}
			}
		}
	}
	_tmp36_ = z;
	_tmp37_ = unit;
	_tmp38_ = number_from_radians (_tmp36_, _tmp37_);
	result = _tmp38_;
	_g_object_unref0 (z);
	_g_object_unref0 (n1);
	_g_object_unref0 (t1);
	_g_object_unref0 (pi);
	return result;
}


Number* number_atan (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t2 = NULL;
	Number* _tmp2_ = NULL;
	gfloat rx = 0.0F;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint q = 0;
	Number* z = NULL;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* t1 = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp33_ = NULL;
	Number* _tmp34_ = NULL;
	Number* _tmp53_ = NULL;
	gint _tmp54_ = 0;
	Number* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	Number* _tmp66_ = NULL;
	AngleUnit _tmp67_ = 0;
	Number* _tmp68_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = _g_object_ref0 (self);
	t2 = _tmp2_;
	rx = 0.f;
	_tmp3_ = self->re_exponent;
	_tmp4_ = abs (_tmp3_);
	if (_tmp4_ <= 2) {
		gfloat _tmp5_ = 0.0F;
		_tmp5_ = number_to_float (self);
		rx = _tmp5_;
	}
	q = 1;
	while (TRUE) {
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
		Number* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp13_ = 0;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		_tmp6_ = t2;
		_tmp7_ = _tmp6_->re_exponent;
		if (!(_tmp7_ >= 0)) {
			break;
		}
		_tmp9_ = t2;
		_tmp10_ = _tmp9_->re_exponent;
		if (_tmp10_ == 0) {
			Number* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp11_ = t2;
			_tmp12_ = _tmp11_->re_fraction[0];
			_tmp8_ = (2 * (_tmp12_ + 1)) <= BASE;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			break;
		}
		_tmp13_ = q;
		q = _tmp13_ * 2;
		_tmp14_ = t2;
		_tmp15_ = t2;
		_tmp16_ = number_multiply (_tmp14_, _tmp15_);
		_g_object_unref0 (z);
		z = _tmp16_;
		_tmp17_ = z;
		_tmp18_ = number_new_integer ((gint64) 1);
		_tmp19_ = _tmp18_;
		_tmp20_ = number_add (_tmp17_, _tmp19_);
		_g_object_unref0 (z);
		z = _tmp20_;
		_g_object_unref0 (_tmp19_);
		_tmp21_ = z;
		_tmp22_ = number_sqrt (_tmp21_);
		_g_object_unref0 (z);
		z = _tmp22_;
		_tmp23_ = z;
		_tmp24_ = number_new_integer ((gint64) 1);
		_tmp25_ = _tmp24_;
		_tmp26_ = number_add (_tmp23_, _tmp25_);
		_g_object_unref0 (z);
		z = _tmp26_;
		_g_object_unref0 (_tmp25_);
		_tmp27_ = t2;
		_tmp28_ = z;
		_tmp29_ = number_divide (_tmp27_, _tmp28_);
		_g_object_unref0 (t2);
		t2 = _tmp29_;
	}
	_tmp30_ = t2;
	_tmp31_ = _g_object_ref0 (_tmp30_);
	_g_object_unref0 (z);
	z = _tmp31_;
	_tmp32_ = t2;
	_tmp33_ = t2;
	_tmp34_ = number_multiply (_tmp32_, _tmp33_);
	t1 = _tmp34_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp35_ = FALSE;
			_tmp35_ = TRUE;
			while (TRUE) {
				Number* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				Number* _tmp44_ = NULL;
				Number* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				Number* _tmp47_ = NULL;
				Number* _tmp48_ = NULL;
				Number* _tmp49_ = NULL;
				Number* _tmp50_ = NULL;
				Number* _tmp51_ = NULL;
				gboolean _tmp52_ = FALSE;
				if (!_tmp35_) {
					gint _tmp36_ = 0;
					_tmp36_ = i;
					i = _tmp36_ + 2;
				}
				_tmp35_ = FALSE;
				_tmp37_ = t2;
				_tmp38_ = _tmp37_->re_exponent;
				if (((T + 2) + _tmp38_) <= 1) {
					break;
				}
				_tmp39_ = t2;
				_tmp40_ = t1;
				_tmp41_ = number_multiply (_tmp39_, _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = i;
				_tmp44_ = number_multiply_integer (_tmp42_, (gint64) (-_tmp43_));
				_tmp45_ = _tmp44_;
				_tmp46_ = i;
				_tmp47_ = number_divide_integer (_tmp45_, (gint64) (_tmp46_ + 2));
				_g_object_unref0 (t2);
				t2 = _tmp47_;
				_g_object_unref0 (_tmp45_);
				_g_object_unref0 (_tmp42_);
				_tmp48_ = z;
				_tmp49_ = t2;
				_tmp50_ = number_add (_tmp48_, _tmp49_);
				_g_object_unref0 (z);
				z = _tmp50_;
				_tmp51_ = t2;
				_tmp52_ = number_is_zero (_tmp51_);
				if (_tmp52_) {
					break;
				}
			}
		}
	}
	_tmp53_ = z;
	_tmp54_ = q;
	_tmp55_ = number_multiply_integer (_tmp53_, (gint64) _tmp54_);
	_g_object_unref0 (z);
	z = _tmp55_;
	_tmp56_ = self->re_exponent;
	_tmp57_ = abs (_tmp56_);
	if (_tmp57_ <= 2) {
		gfloat ry = 0.0F;
		Number* _tmp58_ = NULL;
		gfloat _tmp59_ = 0.0F;
		gfloat _tmp60_ = 0.0F;
		gfloat _tmp61_ = 0.0F;
		gdouble _tmp62_ = 0.0;
		gdouble _tmp63_ = 0.0;
		gfloat _tmp64_ = 0.0F;
		gdouble _tmp65_ = 0.0;
		_tmp58_ = z;
		_tmp59_ = number_to_float (_tmp58_);
		ry = _tmp59_;
		_tmp60_ = ry;
		_tmp61_ = rx;
		_tmp62_ = atan ((gdouble) _tmp61_);
		_tmp63_ = fabs (_tmp60_ - _tmp62_);
		_tmp64_ = ry;
		_tmp65_ = fabs ((gdouble) _tmp64_);
		if (_tmp63_ >= (_tmp65_ * 0.01)) {
			mperr ("*** ERROR OCCURRED IN ATAN, RESULT INCORRECT ***");
		}
	}
	_tmp66_ = z;
	_tmp67_ = unit;
	_tmp68_ = number_from_radians (_tmp66_, _tmp67_);
	result = _tmp68_;
	_g_object_unref0 (t1);
	_g_object_unref0 (z);
	_g_object_unref0 (t2);
	return result;
}


Number* number_sinh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* abs_x = NULL;
	Number* _tmp2_ = NULL;
	Number* z = NULL;
	Number* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	Number* _tmp34_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_abs (self);
	abs_x = _tmp2_;
	_tmp3_ = abs_x;
	_tmp4_ = _tmp3_->re_exponent;
	if (_tmp4_ <= 0) {
		Number* exp_x = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		Number* a = NULL;
		Number* _tmp7_ = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		Number* _tmp11_ = NULL;
		Number* b = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		_tmp5_ = abs_x;
		_tmp6_ = number_epowy (_tmp5_);
		exp_x = _tmp6_;
		_tmp7_ = exp_x;
		_tmp8_ = number_new_integer ((gint64) 1);
		_tmp9_ = _tmp8_;
		_tmp10_ = number_add (_tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		a = _tmp11_;
		_tmp12_ = exp_x;
		_tmp13_ = number_new_integer ((gint64) (-1));
		_tmp14_ = _tmp13_;
		_tmp15_ = number_add (_tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		b = _tmp16_;
		_tmp17_ = a;
		_tmp18_ = b;
		_tmp19_ = number_multiply (_tmp17_, _tmp18_);
		_g_object_unref0 (z);
		z = _tmp19_;
		_tmp20_ = z;
		_tmp21_ = exp_x;
		_tmp22_ = number_divide (_tmp20_, _tmp21_);
		_g_object_unref0 (z);
		z = _tmp22_;
		_g_object_unref0 (b);
		_g_object_unref0 (a);
		_g_object_unref0 (exp_x);
	} else {
		Number* exp_x = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		_tmp23_ = abs_x;
		_tmp24_ = number_epowy (_tmp23_);
		exp_x = _tmp24_;
		_tmp25_ = exp_x;
		_tmp26_ = number_reciprocal (_tmp25_);
		_g_object_unref0 (z);
		z = _tmp26_;
		_tmp27_ = exp_x;
		_tmp28_ = z;
		_tmp29_ = number_subtract (_tmp27_, _tmp28_);
		_g_object_unref0 (z);
		z = _tmp29_;
		_g_object_unref0 (exp_x);
	}
	_tmp30_ = z;
	_tmp31_ = number_divide_integer (_tmp30_, (gint64) 2);
	_g_object_unref0 (z);
	z = _tmp31_;
	_tmp32_ = z;
	_tmp33_ = self->re_sign;
	_tmp34_ = number_multiply_integer (_tmp32_, (gint64) _tmp33_);
	result = _tmp34_;
	_g_object_unref0 (z);
	_g_object_unref0 (abs_x);
	return result;
}


Number* number_cosh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* z = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 1);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_abs (self);
	t = _tmp2_;
	_tmp3_ = t;
	_tmp4_ = number_epowy (_tmp3_);
	_g_object_unref0 (t);
	t = _tmp4_;
	_tmp5_ = t;
	_tmp6_ = number_reciprocal (_tmp5_);
	z = _tmp6_;
	_tmp7_ = t;
	_tmp8_ = z;
	_tmp9_ = number_add (_tmp7_, _tmp8_);
	_g_object_unref0 (z);
	z = _tmp9_;
	_tmp10_ = z;
	_tmp11_ = number_divide_integer (_tmp10_, (gint64) 2);
	result = _tmp11_;
	_g_object_unref0 (z);
	_g_object_unref0 (t);
	return result;
}


Number* number_tanh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t = NULL;
	Number* _tmp2_ = NULL;
	gdouble r__1 = 0.0;
	gdouble _tmp3_ = 0.0;
	Number* z = NULL;
	gdouble _tmp4_ = 0.0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	Number* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	Number* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_abs (self);
	t = _tmp2_;
	_tmp3_ = log ((gdouble) ((gfloat) BASE));
	r__1 = (((gfloat) T) * 0.5) * _tmp3_;
	_tmp4_ = r__1;
	_tmp5_ = number_new_double (_tmp4_);
	z = _tmp5_;
	_tmp6_ = t;
	_tmp7_ = z;
	_tmp8_ = number_compare (_tmp6_, _tmp7_);
	if (_tmp8_ > 0) {
		gint _tmp9_ = 0;
		Number* _tmp10_ = NULL;
		_tmp9_ = self->re_sign;
		_tmp10_ = number_new_integer ((gint64) _tmp9_);
		result = _tmp10_;
		_g_object_unref0 (z);
		_g_object_unref0 (t);
		return result;
	}
	_tmp11_ = t;
	_tmp12_ = number_multiply_integer (_tmp11_, (gint64) 2);
	_g_object_unref0 (t);
	t = _tmp12_;
	_tmp13_ = t;
	_tmp14_ = _tmp13_->re_exponent;
	if (_tmp14_ > 0) {
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		_tmp15_ = t;
		_tmp16_ = number_epowy (_tmp15_);
		_g_object_unref0 (t);
		t = _tmp16_;
		_tmp17_ = t;
		_tmp18_ = number_new_integer ((gint64) (-1));
		_tmp19_ = _tmp18_;
		_tmp20_ = number_add (_tmp17_, _tmp19_);
		_g_object_unref0 (z);
		z = _tmp20_;
		_g_object_unref0 (_tmp19_);
		_tmp21_ = t;
		_tmp22_ = number_new_integer ((gint64) 1);
		_tmp23_ = _tmp22_;
		_tmp24_ = number_add (_tmp21_, _tmp23_);
		_g_object_unref0 (t);
		t = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_tmp25_ = z;
		_tmp26_ = t;
		_tmp27_ = number_divide (_tmp25_, _tmp26_);
		_g_object_unref0 (z);
		z = _tmp27_;
	} else {
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		_tmp28_ = t;
		_tmp29_ = number_epowy (_tmp28_);
		_g_object_unref0 (t);
		t = _tmp29_;
		_tmp30_ = t;
		_tmp31_ = number_new_integer ((gint64) 1);
		_tmp32_ = _tmp31_;
		_tmp33_ = number_add (_tmp30_, _tmp32_);
		_g_object_unref0 (z);
		z = _tmp33_;
		_g_object_unref0 (_tmp32_);
		_tmp34_ = t;
		_tmp35_ = number_new_integer ((gint64) (-1));
		_tmp36_ = _tmp35_;
		_tmp37_ = number_add (_tmp34_, _tmp36_);
		_g_object_unref0 (t);
		t = _tmp37_;
		_g_object_unref0 (_tmp36_);
		_tmp38_ = t;
		_tmp39_ = z;
		_tmp40_ = number_divide (_tmp38_, _tmp39_);
		_g_object_unref0 (z);
		z = _tmp40_;
	}
	_tmp41_ = z;
	_tmp42_ = self->re_sign;
	_tmp43_ = z;
	_tmp44_ = _tmp43_->re_sign;
	_tmp41_->re_sign = _tmp42_ * _tmp44_;
	result = z;
	_g_object_unref0 (t);
	return result;
}


Number* number_asinh (Number* self) {
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_multiply (self, self);
	t = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = number_new_integer ((gint64) 1);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_add (_tmp1_, _tmp3_);
	_g_object_unref0 (t);
	t = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp5_ = t;
	_tmp6_ = number_sqrt (_tmp5_);
	_g_object_unref0 (t);
	t = _tmp6_;
	_tmp7_ = t;
	_tmp8_ = number_add (self, _tmp7_);
	_g_object_unref0 (t);
	t = _tmp8_;
	_tmp9_ = t;
	_tmp10_ = number_ln (_tmp9_);
	result = _tmp10_;
	_g_object_unref0 (t);
	return result;
}


Number* number_acosh (Number* self) {
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1);
	t = _tmp0_;
	_tmp1_ = t;
	_tmp2_ = number_compare (self, _tmp1_);
	if (_tmp2_ < 0) {
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp3_ = _ ("Inverse hyperbolic cosine is undefined for values less than one");
		mperr (_tmp3_);
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		_g_object_unref0 (t);
		return result;
	}
	_tmp5_ = number_multiply (self, self);
	_g_object_unref0 (t);
	t = _tmp5_;
	_tmp6_ = t;
	_tmp7_ = number_new_integer ((gint64) (-1));
	_tmp8_ = _tmp7_;
	_tmp9_ = number_add (_tmp6_, _tmp8_);
	_g_object_unref0 (t);
	t = _tmp9_;
	_g_object_unref0 (_tmp8_);
	_tmp10_ = t;
	_tmp11_ = number_sqrt (_tmp10_);
	_g_object_unref0 (t);
	t = _tmp11_;
	_tmp12_ = t;
	_tmp13_ = number_add (self, _tmp12_);
	_g_object_unref0 (t);
	t = _tmp13_;
	_tmp14_ = t;
	_tmp15_ = number_ln (_tmp14_);
	result = _tmp15_;
	_g_object_unref0 (t);
	return result;
}


Number* number_atanh (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	Number* n = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* d = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* z = NULL;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	Number* _tmp23_ = NULL;
	Number* _tmp24_ = NULL;
	Number* _tmp25_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_);
	_tmp4_ = _tmp3_ >= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		_tmp5_ = number_new_integer ((gint64) (-1));
		_tmp6_ = _tmp5_;
		_tmp7_ = number_compare (self, _tmp6_);
		_tmp0_ = _tmp7_ <= 0;
		_g_object_unref0 (_tmp6_);
	}
	if (_tmp0_) {
		const gchar* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		_tmp8_ = _ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]");
		mperr (_tmp8_);
		_tmp9_ = number_new_integer ((gint64) 0);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = number_new_integer ((gint64) 1);
	_tmp11_ = _tmp10_;
	_tmp12_ = number_add (self, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	n = _tmp13_;
	_tmp14_ = number_invert_sign (self);
	d = _tmp14_;
	_tmp15_ = d;
	_tmp16_ = number_new_integer ((gint64) 1);
	_tmp17_ = _tmp16_;
	_tmp18_ = number_add (_tmp15_, _tmp17_);
	_g_object_unref0 (d);
	d = _tmp18_;
	_g_object_unref0 (_tmp17_);
	_tmp19_ = n;
	_tmp20_ = d;
	_tmp21_ = number_divide (_tmp19_, _tmp20_);
	z = _tmp21_;
	_tmp22_ = z;
	_tmp23_ = number_ln (_tmp22_);
	_g_object_unref0 (z);
	z = _tmp23_;
	_tmp24_ = z;
	_tmp25_ = number_divide_integer (_tmp24_, (gint64) 2);
	result = _tmp25_;
	_g_object_unref0 (z);
	_g_object_unref0 (d);
	_g_object_unref0 (n);
	return result;
}


static gint __lambda3_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ & _tmp1_;
	return result;
}


static gint ___lambda3__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda3_ ((Number*) self, v1, v2);
	return result;
}


Number* number_and (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = _ ("Boolean AND is only defined for positive integers");
		mperr (_tmp4_);
	}
	_tmp5_ = y;
	_tmp6_ = number_bitwise (self, _tmp5_, ___lambda3__bitwise_func, self, 0);
	result = _tmp6_;
	return result;
}


static gint __lambda4_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ | _tmp1_;
	return result;
}


static gint ___lambda4__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
	return result;
}


Number* number_or (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = _ ("Boolean OR is only defined for positive integers");
		mperr (_tmp4_);
	}
	_tmp5_ = y;
	_tmp6_ = number_bitwise (self, _tmp5_, ___lambda4__bitwise_func, self, 0);
	result = _tmp6_;
	return result;
}


static gint __lambda5_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ ^ _tmp1_;
	return result;
}


static gint ___lambda5__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
	return result;
}


Number* number_xor (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_positive_integer (self);
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_positive_integer (_tmp2_);
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = _ ("Boolean XOR is only defined for positive integers");
		mperr (_tmp4_);
	}
	_tmp5_ = y;
	_tmp6_ = number_bitwise (self, _tmp5_, ___lambda5__bitwise_func, self, 0);
	result = _tmp6_;
	return result;
}


static gint __lambda6_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = v1;
	result = _tmp0_ ^ 0xF;
	return result;
}


static gint ___lambda6__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
	return result;
}


Number* number_not (Number* self, gint wordlen) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_positive_integer (self);
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Boolean NOT is only defined for positive integers");
		mperr (_tmp1_);
	}
	_tmp2_ = number_new_integer ((gint64) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = wordlen;
	_tmp5_ = number_bitwise (self, _tmp3_, ___lambda6__bitwise_func, self, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


Number* number_mask (Number* self, Number* x, gint wordlen) {
	Number* result = NULL;
	gchar* text = NULL;
	Number* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint len = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint offset = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = x;
	_tmp1_ = number_to_hex_string (_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	len = _tmp4_;
	_tmp5_ = wordlen;
	offset = _tmp5_ / 4;
	_tmp7_ = len;
	_tmp8_ = offset;
	if (_tmp7_ > _tmp8_) {
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp9_ = len;
		_tmp10_ = offset;
		_tmp6_ = ((gint) _tmp9_) - _tmp10_;
	} else {
		_tmp6_ = 0;
	}
	offset = _tmp6_;
	_tmp11_ = text;
	_tmp12_ = offset;
	_tmp13_ = string_substring (_tmp11_, (glong) _tmp12_, (glong) (-1));
	_tmp14_ = _tmp13_;
	_tmp15_ = mp_set_from_string (_tmp14_, 16);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	result = _tmp16_;
	_g_free0 (text);
	return result;
}


Number* number_shift (Number* self, gint count) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_integer (self);
	if (!_tmp0_) {
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		_tmp1_ = _ ("Shift is only possible on integer values");
		mperr (_tmp1_);
		_tmp2_ = number_new_integer ((gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = count;
	if (_tmp3_ >= 0) {
		gint multiplier = 0;
		gint _tmp9_ = 0;
		Number* _tmp10_ = NULL;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					if (!_tmp4_) {
						gint _tmp5_ = 0;
						_tmp5_ = i;
						i = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = i;
					_tmp7_ = count;
					if (!(_tmp6_ < _tmp7_)) {
						break;
					}
					_tmp8_ = multiplier;
					multiplier = _tmp8_ * 2;
				}
			}
		}
		_tmp9_ = multiplier;
		_tmp10_ = number_multiply_integer (self, (gint64) _tmp9_);
		result = _tmp10_;
		return result;
	} else {
		gint multiplier = 0;
		gint _tmp16_ = 0;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					if (!_tmp11_) {
						gint _tmp12_ = 0;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = i;
					_tmp14_ = count;
					if (!(_tmp13_ < (-_tmp14_))) {
						break;
					}
					_tmp15_ = multiplier;
					multiplier = _tmp15_ * 2;
				}
			}
		}
		_tmp16_ = multiplier;
		_tmp17_ = number_divide_integer (self, (gint64) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = number_floor (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		result = _tmp20_;
		return result;
	}
}


static gint __lambda7_ (Number* self, gint v1, gint v2) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	_tmp0_ = v1;
	_tmp1_ = v2;
	result = _tmp0_ ^ _tmp1_;
	return result;
}


static gint ___lambda7__bitwise_func (gint v1, gint v2, gpointer self) {
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
	return result;
}


Number* number_ones_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = wordlen;
	_tmp3_ = number_bitwise (self, _tmp1_, ___lambda7__bitwise_func, self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = wordlen;
	_tmp6_ = number_not (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


Number* number_twos_complement (Number* self, gint wordlen) {
	Number* result = NULL;
	gint _tmp0_ = 0;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = wordlen;
	_tmp1_ = number_ones_complement (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_new_integer ((gint64) 1);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_add (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* number_factorize (Number* self) {
	GList* result = NULL;
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	guint64 num = 0ULL;
	guint64 _tmp11_ = 0ULL;
	guint64 _tmp12_ = 0ULL;
	guint64 _tmp13_ = 0ULL;
	Number* int_max = NULL;
	guint64 _tmp14_ = 0ULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	Number* divisor = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp37_ = NULL;
	Number* root = NULL;
	Number* _tmp38_ = NULL;
	Number* _tmp39_ = NULL;
	Number* _tmp60_ = NULL;
	Number* _tmp61_ = NULL;
	Number* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp67_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	_tmp0_ = number_abs (self);
	value = _tmp0_;
	_tmp1_ = value;
	_tmp2_ = number_is_zero (_tmp1_);
	if (_tmp2_) {
		Number* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp3_ = value;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		factors = g_list_append (factors, _tmp4_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	_tmp5_ = value;
	_tmp6_ = number_new_integer ((gint64) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_equals (_tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	if (_tmp9_) {
		Number* _tmp10_ = NULL;
		_tmp10_ = _g_object_ref0 (self);
		factors = g_list_append (factors, _tmp10_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	num = (guint64) 1;
	_tmp11_ = num;
	num = _tmp11_ << 63;
	_tmp12_ = num;
	_tmp13_ = num;
	num = _tmp12_ + (_tmp13_ - 1);
	_tmp14_ = num;
	_tmp15_ = number_new_unsigned_integer (_tmp14_);
	int_max = _tmp15_;
	_tmp16_ = value;
	_tmp17_ = int_max;
	_tmp18_ = number_compare (_tmp16_, _tmp17_);
	if (_tmp18_ <= 0) {
		GList* factors_int64 = NULL;
		Number* _tmp19_ = NULL;
		guint64 _tmp20_ = 0ULL;
		GList* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp19_ = value;
		_tmp20_ = number_to_unsigned_integer (_tmp19_);
		_tmp21_ = number_factorize_uint64 (self, _tmp20_);
		factors_int64 = _tmp21_;
		_tmp22_ = number_is_negative (self);
		if (_tmp22_) {
			GList* _tmp23_ = NULL;
			GList* _tmp24_ = NULL;
			gconstpointer _tmp25_ = NULL;
			Number* _tmp26_ = NULL;
			_tmp23_ = factors_int64;
			_tmp24_ = factors_int64;
			_tmp25_ = _tmp24_->data;
			_tmp26_ = number_invert_sign ((Number*) _tmp25_);
			_g_object_unref0 (_tmp23_->data);
			_tmp23_->data = _tmp26_;
		}
		result = factors_int64;
		_g_object_unref0 (int_max);
		_g_object_unref0 (value);
		__g_list_free__g_object_unref0_0 (factors);
		return result;
	}
	_tmp27_ = number_new_integer ((gint64) 2);
	divisor = _tmp27_;
	while (TRUE) {
		Number* tmp = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		gboolean _tmp32_ = FALSE;
		_tmp28_ = value;
		_tmp29_ = divisor;
		_tmp30_ = number_divide (_tmp28_, _tmp29_);
		tmp = _tmp30_;
		_tmp31_ = tmp;
		_tmp32_ = number_is_integer (_tmp31_);
		if (_tmp32_) {
			Number* _tmp33_ = NULL;
			Number* _tmp34_ = NULL;
			Number* _tmp35_ = NULL;
			Number* _tmp36_ = NULL;
			_tmp33_ = tmp;
			_tmp34_ = _g_object_ref0 (_tmp33_);
			_g_object_unref0 (value);
			value = _tmp34_;
			_tmp35_ = divisor;
			_tmp36_ = _g_object_ref0 (_tmp35_);
			factors = g_list_append (factors, _tmp36_);
		} else {
			_g_object_unref0 (tmp);
			break;
		}
		_g_object_unref0 (tmp);
	}
	_tmp37_ = number_new_integer ((gint64) 3);
	_g_object_unref0 (divisor);
	divisor = _tmp37_;
	_tmp38_ = value;
	_tmp39_ = number_sqrt (_tmp38_);
	root = _tmp39_;
	while (TRUE) {
		Number* _tmp40_ = NULL;
		Number* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		Number* tmp = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		gboolean _tmp47_ = FALSE;
		_tmp40_ = divisor;
		_tmp41_ = root;
		_tmp42_ = number_compare (_tmp40_, _tmp41_);
		if (!(_tmp42_ <= 0)) {
			break;
		}
		_tmp43_ = value;
		_tmp44_ = divisor;
		_tmp45_ = number_divide (_tmp43_, _tmp44_);
		tmp = _tmp45_;
		_tmp46_ = tmp;
		_tmp47_ = number_is_integer (_tmp46_);
		if (_tmp47_) {
			Number* _tmp48_ = NULL;
			Number* _tmp49_ = NULL;
			Number* _tmp50_ = NULL;
			Number* _tmp51_ = NULL;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
			_tmp48_ = tmp;
			_tmp49_ = _g_object_ref0 (_tmp48_);
			_g_object_unref0 (value);
			value = _tmp49_;
			_tmp50_ = value;
			_tmp51_ = number_sqrt (_tmp50_);
			_g_object_unref0 (root);
			root = _tmp51_;
			_tmp52_ = divisor;
			_tmp53_ = _g_object_ref0 (_tmp52_);
			factors = g_list_append (factors, _tmp53_);
		} else {
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			Number* _tmp56_ = NULL;
			Number* _tmp57_ = NULL;
			Number* _tmp58_ = NULL;
			Number* _tmp59_ = NULL;
			_tmp54_ = divisor;
			_tmp55_ = number_new_integer ((gint64) 2);
			_tmp56_ = _tmp55_;
			_tmp57_ = number_add (_tmp54_, _tmp56_);
			_g_object_unref0 (tmp);
			tmp = _tmp57_;
			_g_object_unref0 (_tmp56_);
			_tmp58_ = tmp;
			_tmp59_ = _g_object_ref0 (_tmp58_);
			_g_object_unref0 (divisor);
			divisor = _tmp59_;
		}
		_g_object_unref0 (tmp);
	}
	_tmp60_ = value;
	_tmp61_ = number_new_integer ((gint64) 1);
	_tmp62_ = _tmp61_;
	_tmp63_ = number_compare (_tmp60_, _tmp62_);
	_tmp64_ = _tmp63_ > 0;
	_g_object_unref0 (_tmp62_);
	if (_tmp64_) {
		Number* _tmp65_ = NULL;
		Number* _tmp66_ = NULL;
		_tmp65_ = value;
		_tmp66_ = _g_object_ref0 (_tmp65_);
		factors = g_list_append (factors, _tmp66_);
	}
	_tmp67_ = number_is_negative (self);
	if (_tmp67_) {
		GList* _tmp68_ = NULL;
		GList* _tmp69_ = NULL;
		gconstpointer _tmp70_ = NULL;
		Number* _tmp71_ = NULL;
		_tmp68_ = factors;
		_tmp69_ = factors;
		_tmp70_ = _tmp69_->data;
		_tmp71_ = number_invert_sign ((Number*) _tmp70_);
		_g_object_unref0 (_tmp68_->data);
		_tmp68_->data = _tmp71_;
	}
	result = factors;
	_g_object_unref0 (root);
	_g_object_unref0 (divisor);
	_g_object_unref0 (int_max);
	_g_object_unref0 (value);
	return result;
}


GList* number_factorize_uint64 (Number* self, guint64 n) {
	GList* result = NULL;
	GList* factors = NULL;
	guint64 _tmp14_ = 0ULL;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	while (TRUE) {
		guint64 _tmp0_ = 0ULL;
		guint64 _tmp1_ = 0ULL;
		Number* _tmp2_ = NULL;
		_tmp0_ = n;
		if (!((_tmp0_ % 2) == ((guint64) 0))) {
			break;
		}
		_tmp1_ = n;
		n = _tmp1_ / 2;
		_tmp2_ = number_new_unsigned_integer ((guint64) 2);
		factors = g_list_append (factors, _tmp2_);
	}
	{
		guint64 divisor = 0ULL;
		divisor = (guint64) 3;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				guint64 _tmp5_ = 0ULL;
				guint64 _tmp6_ = 0ULL;
				guint64 _tmp7_ = 0ULL;
				if (!_tmp3_) {
					guint64 _tmp4_ = 0ULL;
					_tmp4_ = divisor;
					divisor = _tmp4_ + 2;
				}
				_tmp3_ = FALSE;
				_tmp5_ = divisor;
				_tmp6_ = n;
				_tmp7_ = divisor;
				if (!(_tmp5_ <= (_tmp6_ / _tmp7_))) {
					break;
				}
				while (TRUE) {
					guint64 _tmp8_ = 0ULL;
					guint64 _tmp9_ = 0ULL;
					guint64 _tmp10_ = 0ULL;
					guint64 _tmp11_ = 0ULL;
					guint64 _tmp12_ = 0ULL;
					Number* _tmp13_ = NULL;
					_tmp8_ = n;
					_tmp9_ = divisor;
					if (!((_tmp8_ % _tmp9_) == ((guint64) 0))) {
						break;
					}
					_tmp10_ = n;
					_tmp11_ = divisor;
					n = _tmp10_ / _tmp11_;
					_tmp12_ = divisor;
					_tmp13_ = number_new_unsigned_integer (_tmp12_);
					factors = g_list_append (factors, _tmp13_);
				}
			}
		}
	}
	_tmp14_ = n;
	if (_tmp14_ > ((guint64) 1)) {
		guint64 _tmp15_ = 0ULL;
		Number* _tmp16_ = NULL;
		_tmp15_ = n;
		_tmp16_ = number_new_unsigned_integer (_tmp15_);
		factors = g_list_append (factors, _tmp16_);
	}
	result = factors;
	return result;
}


static Number* number_copy (Number* self) {
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = z;
	_tmp2_ = self->re_sign;
	_tmp1_->re_sign = _tmp2_;
	_tmp3_ = z;
	_tmp4_ = self->im_sign;
	_tmp3_->im_sign = _tmp4_;
	_tmp5_ = z;
	_tmp6_ = self->re_exponent;
	_tmp5_->re_exponent = _tmp6_;
	_tmp7_ = z;
	_tmp8_ = self->im_exponent;
	_tmp7_->im_exponent = _tmp8_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				Number* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				Number* _tmp17_ = NULL;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = i;
				if (!(_tmp11_ < 1000)) {
					break;
				}
				_tmp12_ = z;
				_tmp13_ = i;
				_tmp14_ = i;
				_tmp15_ = self->re_fraction[_tmp14_];
				_tmp12_->re_fraction[_tmp13_] = _tmp15_;
				_tmp16_ = _tmp12_->re_fraction[_tmp13_];
				_tmp17_ = z;
				_tmp18_ = i;
				_tmp19_ = i;
				_tmp20_ = self->im_fraction[_tmp19_];
				_tmp17_->im_fraction[_tmp18_] = _tmp20_;
				_tmp21_ = _tmp17_->im_fraction[_tmp18_];
			}
		}
	}
	result = z;
	return result;
}


static Number* number_add_with_sign (Number* self, gint y_sign, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = number_is_complex (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = y;
		_tmp3_ = number_is_complex (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		Number* real_z = NULL;
		Number* im_z = NULL;
		Number* real_x = NULL;
		Number* _tmp4_ = NULL;
		Number* im_x = NULL;
		Number* _tmp5_ = NULL;
		Number* real_y = NULL;
		Number* _tmp6_ = NULL;
		Number* _tmp7_ = NULL;
		Number* im_y = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		Number* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		Number* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		Number* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		_tmp4_ = number_real_component (self);
		real_x = _tmp4_;
		_tmp5_ = number_imaginary_component (self);
		im_x = _tmp5_;
		_tmp6_ = y;
		_tmp7_ = number_real_component (_tmp6_);
		real_y = _tmp7_;
		_tmp8_ = y;
		_tmp9_ = number_imaginary_component (_tmp8_);
		im_y = _tmp9_;
		_tmp10_ = real_x;
		_tmp11_ = y_sign;
		_tmp12_ = y;
		_tmp13_ = _tmp12_->re_sign;
		_tmp14_ = real_y;
		_tmp15_ = number_add_real (_tmp10_, _tmp11_ * _tmp13_, _tmp14_);
		_g_object_unref0 (real_z);
		real_z = _tmp15_;
		_tmp16_ = im_x;
		_tmp17_ = y_sign;
		_tmp18_ = y;
		_tmp19_ = _tmp18_->im_sign;
		_tmp20_ = im_y;
		_tmp21_ = number_add_real (_tmp16_, _tmp17_ * _tmp19_, _tmp20_);
		_g_object_unref0 (im_z);
		im_z = _tmp21_;
		_tmp22_ = real_z;
		_tmp23_ = im_z;
		_tmp24_ = number_new_complex (_tmp22_, _tmp23_);
		result = _tmp24_;
		_g_object_unref0 (im_y);
		_g_object_unref0 (real_y);
		_g_object_unref0 (im_x);
		_g_object_unref0 (real_x);
		_g_object_unref0 (im_z);
		_g_object_unref0 (real_z);
		return result;
	} else {
		gint _tmp25_ = 0;
		Number* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		_tmp25_ = y_sign;
		_tmp26_ = y;
		_tmp27_ = _tmp26_->re_sign;
		_tmp28_ = y;
		_tmp29_ = number_add_real (self, _tmp25_ * _tmp27_, _tmp28_);
		result = _tmp29_;
		return result;
	}
}


static Number* number_epowy_real (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	gdouble rx = 0.0;
	gdouble _tmp4_ = 0.0;
	gint xs = 0;
	gint _tmp5_ = 0;
	Number* t2 = NULL;
	Number* _tmp6_ = NULL;
	gint64 ix = 0LL;
	Number* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	Number* z = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	gint tss = 0;
	Number* t1 = NULL;
	gint _tmp17_ = 0;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	gint _tmp36_ = 0;
	Number* _tmp41_ = NULL;
	gint64 _tmp42_ = 0LL;
	Number* _tmp43_ = NULL;
	Number* _tmp44_ = NULL;
	Number* _tmp45_ = NULL;
	Number* _tmp46_ = NULL;
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	gdouble rz = 0.0;
	Number* _tmp49_ = NULL;
	gdouble _tmp50_ = 0.0;
	gdouble r__1 = 0.0;
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_ = 0.0;
	gdouble _tmp53_ = 0.0;
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 1);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->re_exponent;
	if (_tmp2_ <= 0) {
		Number* _tmp3_ = NULL;
		_tmp3_ = number_exp (self);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_to_double (self);
	rx = _tmp4_;
	_tmp5_ = self->re_sign;
	xs = _tmp5_;
	_tmp6_ = number_abs (self);
	t2 = _tmp6_;
	_tmp7_ = t2;
	_tmp8_ = number_to_integer (_tmp7_);
	ix = _tmp8_;
	_tmp9_ = t2;
	_tmp10_ = number_fractional_component (_tmp9_);
	_g_object_unref0 (t2);
	t2 = _tmp10_;
	_tmp11_ = t2;
	_tmp12_ = t2;
	_tmp13_ = _tmp12_->re_sign;
	_tmp14_ = xs;
	_tmp12_->re_sign = _tmp13_ * _tmp14_;
	_tmp15_ = t2;
	_tmp16_ = number_exp (_tmp15_);
	z = _tmp16_;
	tss = 0;
	if (T < 4) {
		tss = T + 1;
	} else {
		tss = T + 2;
	}
	_tmp17_ = xs;
	_tmp18_ = number_new_integer ((gint64) _tmp17_);
	t1 = _tmp18_;
	_tmp19_ = t2;
	_tmp19_->re_sign = 0;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				Number* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				Number* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				Number* _tmp30_ = NULL;
				Number* _tmp31_ = NULL;
				Number* _tmp32_ = NULL;
				Number* _tmp33_ = NULL;
				Number* _tmp34_ = NULL;
				gboolean _tmp35_ = FALSE;
				if (!_tmp20_) {
					gint _tmp21_ = 0;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = tss;
				_tmp23_ = tss;
				_tmp24_ = t1;
				_tmp25_ = _tmp24_->re_exponent;
				_tmp26_ = MIN (_tmp22_, (_tmp23_ + 2) + _tmp25_);
				if (_tmp26_ <= 2) {
					break;
				}
				_tmp27_ = t1;
				_tmp28_ = i;
				_tmp29_ = xs;
				_tmp30_ = number_divide_integer (_tmp27_, (gint64) (_tmp28_ * _tmp29_));
				_g_object_unref0 (t1);
				t1 = _tmp30_;
				_tmp31_ = t2;
				_tmp32_ = t1;
				_tmp33_ = number_add (_tmp31_, _tmp32_);
				_g_object_unref0 (t2);
				t2 = _tmp33_;
				_tmp34_ = t1;
				_tmp35_ = number_is_zero (_tmp34_);
				if (_tmp35_) {
					break;
				}
			}
		}
	}
	_tmp36_ = xs;
	if (_tmp36_ > 0) {
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		_tmp37_ = t2;
		_tmp38_ = number_new_integer ((gint64) 2);
		_tmp39_ = _tmp38_;
		_tmp40_ = number_add (_tmp37_, _tmp39_);
		_g_object_unref0 (t2);
		t2 = _tmp40_;
		_g_object_unref0 (_tmp39_);
	}
	_tmp41_ = t2;
	_tmp42_ = ix;
	_tmp43_ = number_xpowy_integer (_tmp41_, _tmp42_);
	_g_object_unref0 (t2);
	t2 = _tmp43_;
	_tmp44_ = z;
	_tmp45_ = t2;
	_tmp46_ = number_multiply (_tmp44_, _tmp45_);
	_g_object_unref0 (z);
	z = _tmp46_;
	_tmp47_ = rx;
	_tmp48_ = fabs (_tmp47_);
	if (_tmp48_ > ((gdouble) 10.0f)) {
		result = z;
		_g_object_unref0 (t1);
		_g_object_unref0 (t2);
		return result;
	}
	_tmp49_ = z;
	_tmp50_ = number_to_double (_tmp49_);
	rz = _tmp50_;
	_tmp51_ = rz;
	_tmp52_ = rx;
	_tmp53_ = exp (_tmp52_);
	r__1 = _tmp51_ - _tmp53_;
	_tmp54_ = r__1;
	_tmp55_ = fabs (_tmp54_);
	_tmp56_ = rz;
	if (_tmp55_ < (_tmp56_ * 0.01f)) {
		result = z;
		_g_object_unref0 (t1);
		_g_object_unref0 (t2);
		return result;
	}
	mperr ("*** ERROR OCCURRED IN EPOWY, RESULT INCORRECT ***");
	result = z;
	_g_object_unref0 (t1);
	_g_object_unref0 (t2);
	return result;
}


static Number* number_exp (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp2_ = 0;
	Number* t1 = NULL;
	Number* _tmp4_ = NULL;
	gdouble rlb = 0.0;
	gdouble _tmp5_ = 0.0;
	gint q = 0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
	gint _tmp10_ = 0;
	Number* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	Number* z = NULL;
	Number* _tmp29_ = NULL;
	Number* _tmp30_ = NULL;
	Number* t2 = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp61_ = NULL;
	Number* _tmp62_ = NULL;
	Number* _tmp63_ = NULL;
	Number* _tmp64_ = NULL;
	Number* _tmp65_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 1);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->re_exponent;
	if (_tmp2_ > 0) {
		Number* _tmp3_ = NULL;
		mperr ("*** ABS (X) NOT LESS THAN 1 IN CALL TO MP_EXP ***");
		_tmp3_ = number_new_integer ((gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = _g_object_ref0 (self);
	t1 = _tmp4_;
	_tmp5_ = log ((gdouble) BASE);
	rlb = _tmp5_;
	_tmp6_ = rlb;
	_tmp7_ = sqrt ((T * 0.48) * _tmp6_);
	_tmp8_ = self->re_exponent;
	_tmp9_ = rlb;
	q = (gint) (_tmp7_ + ((_tmp8_ * 1.44) * _tmp9_));
	_tmp10_ = q;
	if (_tmp10_ > 0) {
		gint ib = 0;
		gint ic = 0;
		ib = BASE << 2;
		ic = 1;
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					Number* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					Number* _tmp25_ = NULL;
					if (!_tmp11_) {
						gint _tmp12_ = 0;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = i;
					_tmp14_ = q;
					if (!(_tmp13_ <= _tmp14_)) {
						break;
					}
					_tmp15_ = ic;
					ic = _tmp15_ * 2;
					_tmp18_ = ic;
					_tmp19_ = ib;
					if (_tmp18_ < _tmp19_) {
						gint _tmp20_ = 0;
						_tmp20_ = ic;
						_tmp17_ = _tmp20_ != BASE;
					} else {
						_tmp17_ = FALSE;
					}
					if (_tmp17_) {
						gint _tmp21_ = 0;
						gint _tmp22_ = 0;
						_tmp21_ = i;
						_tmp22_ = q;
						_tmp16_ = _tmp21_ < _tmp22_;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						continue;
					}
					_tmp23_ = t1;
					_tmp24_ = ic;
					_tmp25_ = number_divide_integer (_tmp23_, (gint64) _tmp24_);
					_g_object_unref0 (t1);
					t1 = _tmp25_;
					ic = 1;
				}
			}
		}
	}
	_tmp26_ = t1;
	_tmp27_ = number_is_zero (_tmp26_);
	if (_tmp27_) {
		Number* _tmp28_ = NULL;
		_tmp28_ = number_new_integer ((gint64) 0);
		result = _tmp28_;
		_g_object_unref0 (t1);
		return result;
	}
	_tmp29_ = t1;
	_tmp30_ = number_copy (_tmp29_);
	z = _tmp30_;
	_tmp31_ = t1;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	t2 = _tmp32_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				Number* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				Number* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				Number* _tmp44_ = NULL;
				Number* _tmp45_ = NULL;
				Number* _tmp46_ = NULL;
				Number* _tmp47_ = NULL;
				Number* _tmp48_ = NULL;
				gboolean _tmp49_ = FALSE;
				if (!_tmp33_) {
					gint _tmp34_ = 0;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = t2;
				_tmp36_ = _tmp35_->re_exponent;
				_tmp37_ = z;
				_tmp38_ = _tmp37_->re_exponent;
				if (!(((T + _tmp36_) - _tmp38_) > 0)) {
					break;
				}
				_tmp39_ = t1;
				_tmp40_ = t2;
				_tmp41_ = number_multiply (_tmp39_, _tmp40_);
				_g_object_unref0 (t2);
				t2 = _tmp41_;
				_tmp42_ = t2;
				_tmp43_ = i;
				_tmp44_ = number_divide_integer (_tmp42_, (gint64) _tmp43_);
				_g_object_unref0 (t2);
				t2 = _tmp44_;
				_tmp45_ = t2;
				_tmp46_ = z;
				_tmp47_ = number_add (_tmp45_, _tmp46_);
				_g_object_unref0 (z);
				z = _tmp47_;
				_tmp48_ = t2;
				_tmp49_ = number_is_zero (_tmp48_);
				if (_tmp49_) {
					break;
				}
			}
		}
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
				Number* _tmp54_ = NULL;
				Number* _tmp55_ = NULL;
				Number* _tmp56_ = NULL;
				Number* _tmp57_ = NULL;
				Number* _tmp58_ = NULL;
				Number* _tmp59_ = NULL;
				Number* _tmp60_ = NULL;
				if (!_tmp50_) {
					gint _tmp51_ = 0;
					_tmp51_ = i;
					i = _tmp51_ + 1;
				}
				_tmp50_ = FALSE;
				_tmp52_ = i;
				_tmp53_ = q;
				if (!(_tmp52_ <= _tmp53_)) {
					break;
				}
				_tmp54_ = z;
				_tmp55_ = number_new_integer ((gint64) 2);
				_tmp56_ = _tmp55_;
				_tmp57_ = number_add (_tmp54_, _tmp56_);
				_g_object_unref0 (t1);
				t1 = _tmp57_;
				_g_object_unref0 (_tmp56_);
				_tmp58_ = t1;
				_tmp59_ = z;
				_tmp60_ = number_multiply (_tmp58_, _tmp59_);
				_g_object_unref0 (z);
				z = _tmp60_;
			}
		}
	}
	_tmp61_ = z;
	_tmp62_ = number_new_integer ((gint64) 1);
	_tmp63_ = _tmp62_;
	_tmp64_ = number_add (_tmp61_, _tmp63_);
	_tmp65_ = _tmp64_;
	_g_object_unref0 (_tmp63_);
	result = _tmp65_;
	_g_object_unref0 (t2);
	_g_object_unref0 (z);
	_g_object_unref0 (t1);
	return result;
}


static Number* number_pwr (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		Number* _tmp4_ = NULL;
		_tmp1_ = y;
		_tmp2_ = _tmp1_->re_sign;
		if (_tmp2_ < 0) {
			const gchar* _tmp3_ = NULL;
			_tmp3_ = _ ("The power of zero is undefined for a negative exponent");
			mperr (_tmp3_);
		}
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = y;
	_tmp6_ = number_is_zero (_tmp5_);
	if (_tmp6_) {
		Number* _tmp7_ = NULL;
		_tmp7_ = number_new_integer ((gint64) 1);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = y;
	_tmp9_ = number_ln (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = number_multiply (_tmp8_, _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = number_epowy (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp10_);
	result = _tmp14_;
	return result;
}


static Number* number_root_real (Number* self, gint64 n) {
	Number* result = NULL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 np = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gint _tmp8_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint64 ex = 0LL;
	gint _tmp19_ = 0;
	gint64 _tmp20_ = 0LL;
	Number* t1 = NULL;
	Number* _tmp21_ = NULL;
	Number* _tmp22_ = NULL;
	gdouble approximation = 0.0;
	gint64 _tmp23_ = 0LL;
	gint64 _tmp24_ = 0LL;
	gint _tmp25_ = 0;
	gdouble _tmp26_ = 0.0;
	Number* _tmp27_ = NULL;
	gfloat _tmp28_ = 0.0F;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	gint64 _tmp31_ = 0LL;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	Number* _tmp34_ = NULL;
	Number* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	Number* _tmp37_ = NULL;
	Number* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint64 _tmp40_ = 0LL;
	gint it0 = 0;
	gint t = 0;
	gint _tmp41_ = 0;
	Number* t2 = NULL;
	gboolean _tmp71_ = FALSE;
	Number* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	gint64 _tmp79_ = 0LL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = n;
	if (_tmp0_ == ((gint64) 1)) {
		Number* _tmp1_ = NULL;
		_tmp1_ = _g_object_ref0 (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = n;
	if (_tmp2_ == ((gint64) 0)) {
		const gchar* _tmp3_ = NULL;
		Number* _tmp4_ = NULL;
		_tmp3_ = _ ("Root must be non-zero");
		mperr (_tmp3_);
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = n;
	_tmp6_ = llabs (_tmp5_);
	np = _tmp6_;
	_tmp7_ = np;
	_tmp8_ = MAX (BASE, 64);
	if (_tmp7_ > ((gint64) _tmp8_)) {
		Number* _tmp9_ = NULL;
		mperr ("*** ABS (N) TOO LARGE IN CALL TO ROOT ***");
		_tmp9_ = number_new_integer ((gint64) 0);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = number_is_zero (self);
	if (_tmp10_) {
		gint64 _tmp11_ = 0LL;
		Number* _tmp13_ = NULL;
		_tmp11_ = n;
		if (_tmp11_ <= ((gint64) 0)) {
			const gchar* _tmp12_ = NULL;
			_tmp12_ = _ ("Negative root of zero is undefined");
			mperr (_tmp12_);
		}
		_tmp13_ = number_new_integer ((gint64) 0);
		result = _tmp13_;
		return result;
	}
	_tmp15_ = self->re_sign;
	if (_tmp15_ < 0) {
		gint64 _tmp16_ = 0LL;
		_tmp16_ = np;
		_tmp14_ = (_tmp16_ % 2) == ((gint64) 0);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		_tmp17_ = _ ("nth root of negative number is undefined for even n");
		mperr (_tmp17_);
		_tmp18_ = number_new_integer ((gint64) 0);
		result = _tmp18_;
		return result;
	}
	_tmp19_ = self->re_exponent;
	_tmp20_ = np;
	ex = _tmp19_ / _tmp20_;
	_tmp21_ = number_copy (self);
	t1 = _tmp21_;
	_tmp22_ = t1;
	_tmp22_->re_exponent = 0;
	_tmp23_ = np;
	_tmp24_ = ex;
	_tmp25_ = self->re_exponent;
	_tmp26_ = log ((gdouble) BASE);
	_tmp27_ = t1;
	_tmp28_ = number_to_float (_tmp27_);
	_tmp29_ = fabs ((gdouble) _tmp28_);
	_tmp30_ = log (_tmp29_);
	_tmp31_ = np;
	_tmp32_ = exp (((((_tmp23_ * _tmp24_) - _tmp25_) * _tmp26_) - _tmp30_) / _tmp31_);
	approximation = _tmp32_;
	_tmp33_ = approximation;
	_tmp34_ = number_new_double (_tmp33_);
	_g_object_unref0 (t1);
	t1 = _tmp34_;
	_tmp35_ = t1;
	_tmp36_ = self->re_sign;
	_tmp35_->re_sign = _tmp36_;
	_tmp37_ = t1;
	_tmp38_ = t1;
	_tmp39_ = _tmp38_->re_exponent;
	_tmp40_ = ex;
	_tmp38_->re_exponent = _tmp39_ - ((gint) _tmp40_);
	it0 = 3;
	_tmp41_ = it0;
	t = _tmp41_;
	while (TRUE) {
		Number* _tmp42_ = NULL;
		gint64 _tmp43_ = 0LL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		Number* _tmp47_ = NULL;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		Number* _tmp50_ = NULL;
		Number* _tmp51_ = NULL;
		Number* _tmp52_ = NULL;
		Number* _tmp53_ = NULL;
		Number* _tmp54_ = NULL;
		gint64 _tmp55_ = 0LL;
		Number* _tmp56_ = NULL;
		Number* _tmp57_ = NULL;
		Number* _tmp58_ = NULL;
		Number* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		gint ts3 = 0;
		gint _tmp61_ = 0;
		gint ts2 = 0;
		gint _tmp62_ = 0;
		gint _tmp69_ = 0;
		gint _tmp70_ = 0;
		_tmp42_ = t1;
		_tmp43_ = np;
		_tmp44_ = number_xpowy_integer (_tmp42_, _tmp43_);
		_g_object_unref0 (t2);
		t2 = _tmp44_;
		_tmp45_ = t2;
		_tmp46_ = number_multiply (self, _tmp45_);
		_g_object_unref0 (t2);
		t2 = _tmp46_;
		_tmp47_ = t2;
		_tmp48_ = number_new_integer ((gint64) (-1));
		_tmp49_ = _tmp48_;
		_tmp50_ = number_add (_tmp47_, _tmp49_);
		_g_object_unref0 (t2);
		t2 = _tmp50_;
		_g_object_unref0 (_tmp49_);
		_tmp51_ = t1;
		_tmp52_ = t2;
		_tmp53_ = number_multiply (_tmp51_, _tmp52_);
		_g_object_unref0 (t2);
		t2 = _tmp53_;
		_tmp54_ = t2;
		_tmp55_ = np;
		_tmp56_ = number_divide_integer (_tmp54_, _tmp55_);
		_g_object_unref0 (t2);
		t2 = _tmp56_;
		_tmp57_ = t1;
		_tmp58_ = t2;
		_tmp59_ = number_subtract (_tmp57_, _tmp58_);
		_g_object_unref0 (t1);
		t1 = _tmp59_;
		_tmp60_ = t;
		if (_tmp60_ >= T) {
			break;
		}
		_tmp61_ = t;
		ts3 = _tmp61_;
		_tmp62_ = t;
		ts2 = _tmp62_;
		t = T;
		{
			gboolean _tmp63_ = FALSE;
			_tmp63_ = TRUE;
			while (TRUE) {
				gint _tmp66_ = 0;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				if (!_tmp63_) {
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					_tmp64_ = t;
					_tmp65_ = ts3;
					if (!(_tmp64_ > _tmp65_)) {
						break;
					}
				}
				_tmp63_ = FALSE;
				_tmp66_ = t;
				ts2 = _tmp66_;
				_tmp67_ = t;
				_tmp68_ = it0;
				t = (_tmp67_ + _tmp68_) / 2;
			}
		}
		_tmp69_ = ts2;
		_tmp70_ = MIN (_tmp69_, T);
		t = _tmp70_;
	}
	_tmp72_ = t2;
	_tmp73_ = _tmp72_->re_sign;
	if (_tmp73_ != 0) {
		Number* _tmp74_ = NULL;
		gint _tmp75_ = 0;
		Number* _tmp76_ = NULL;
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
		_tmp74_ = t1;
		_tmp75_ = _tmp74_->re_exponent;
		_tmp76_ = t2;
		_tmp77_ = _tmp76_->re_exponent;
		_tmp78_ = it0;
		_tmp71_ = ((_tmp75_ - _tmp77_) << 1) < (T - _tmp78_);
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		mperr ("*** ERROR OCCURRED IN ROOT, NEWTON ITERATION NOT CONVERGING PROPERLY *" \
"**");
	}
	_tmp79_ = n;
	if (_tmp79_ >= ((gint64) 0)) {
		Number* _tmp80_ = NULL;
		gint64 _tmp81_ = 0LL;
		Number* _tmp82_ = NULL;
		Number* _tmp83_ = NULL;
		Number* _tmp84_ = NULL;
		_tmp80_ = t1;
		_tmp81_ = n;
		_tmp82_ = number_xpowy_integer (_tmp80_, _tmp81_ - 1);
		_g_object_unref0 (t1);
		t1 = _tmp82_;
		_tmp83_ = t1;
		_tmp84_ = number_multiply (self, _tmp83_);
		result = _tmp84_;
		_g_object_unref0 (t2);
		_g_object_unref0 (t1);
		return result;
	}
	result = t1;
	_g_object_unref0 (t2);
	return result;
}


static Number* number_ext (Number* self, gint i, gint j) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint q = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint s = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	Number* z = NULL;
	Number* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Number* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	Number* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	Number* _tmp22_ = NULL;
	Number* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = number_is_zero (self);
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = T <= 2;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp3_ = 0;
		_tmp3_ = i;
		_tmp0_ = _tmp3_ == 0;
	}
	if (_tmp0_) {
		Number* _tmp4_ = NULL;
		_tmp4_ = _g_object_ref0 (self);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = j;
	_tmp6_ = i;
	q = ((_tmp5_ + 1) / _tmp6_) + 1;
	_tmp7_ = self->re_fraction[T - 2];
	_tmp8_ = self->re_fraction[T - 1];
	s = (BASE * _tmp7_) + _tmp8_;
	_tmp9_ = number_copy (self);
	z = _tmp9_;
	_tmp10_ = s;
	_tmp11_ = q;
	if (_tmp10_ <= _tmp11_) {
		Number* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		Number* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		_tmp12_ = z;
		_tmp12_->re_fraction[T - 2] = 0;
		_tmp13_ = _tmp12_->re_fraction[T - 2];
		_tmp14_ = z;
		_tmp14_->re_fraction[T - 1] = 0;
		_tmp15_ = _tmp14_->re_fraction[T - 1];
		result = z;
		return result;
	}
	_tmp16_ = s;
	_tmp17_ = q;
	if ((_tmp16_ + _tmp17_) < (BASE * BASE)) {
		result = z;
		return result;
	}
	_tmp18_ = z;
	_tmp18_->re_fraction[T - 2] = BASE - 1;
	_tmp19_ = _tmp18_->re_fraction[T - 2];
	_tmp20_ = z;
	_tmp20_->re_fraction[T - 1] = BASE;
	_tmp21_ = _tmp20_->re_fraction[T - 1];
	_tmp22_ = z;
	_tmp23_ = number_multiply_integer (_tmp22_, (gint64) 1);
	result = _tmp23_;
	_g_object_unref0 (z);
	return result;
}


static Number* number_ln_real (Number* self) {
	Number* result = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp5_ = NULL;
	Number* z = NULL;
	Number* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_eulers ();
	_tmp1_ = _tmp0_;
	_tmp2_ = number_equals (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	if (_tmp3_) {
		Number* _tmp4_ = NULL;
		_tmp4_ = number_new_integer ((gint64) 1);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = number_copy (self);
	t1 = _tmp5_;
	_tmp6_ = number_new_integer ((gint64) 0);
	z = _tmp6_;
	{
		gint k = 0;
		k = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				Number* t2 = NULL;
				Number* _tmp10_ = NULL;
				Number* _tmp11_ = NULL;
				Number* _tmp12_ = NULL;
				Number* _tmp13_ = NULL;
				Number* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				Number* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				gint e = 0;
				Number* _tmp26_ = NULL;
				gint _tmp27_ = 0;
				Number* _tmp28_ = NULL;
				gdouble rx = 0.0;
				Number* _tmp29_ = NULL;
				gdouble _tmp30_ = 0.0;
				Number* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gdouble rlx = 0.0;
				gdouble _tmp33_ = 0.0;
				gdouble _tmp34_ = 0.0;
				gint _tmp35_ = 0;
				gdouble _tmp36_ = 0.0;
				gdouble _tmp37_ = 0.0;
				Number* _tmp38_ = NULL;
				Number* _tmp39_ = NULL;
				Number* _tmp40_ = NULL;
				Number* _tmp41_ = NULL;
				Number* _tmp42_ = NULL;
				Number* _tmp43_ = NULL;
				Number* _tmp44_ = NULL;
				Number* _tmp45_ = NULL;
				Number* _tmp46_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = k;
					k = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = k;
				if (!(_tmp9_ < 10)) {
					break;
				}
				_tmp10_ = t1;
				_tmp11_ = number_new_integer ((gint64) (-1));
				_tmp12_ = _tmp11_;
				_tmp13_ = number_add (_tmp10_, _tmp12_);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp12_);
				t2 = _tmp14_;
				_tmp16_ = t2;
				_tmp17_ = number_is_zero (_tmp16_);
				if (_tmp17_) {
					_tmp15_ = TRUE;
				} else {
					Number* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					_tmp18_ = t2;
					_tmp19_ = _tmp18_->re_exponent;
					_tmp15_ = (_tmp19_ + 1) <= 0;
				}
				if (_tmp15_) {
					Number* _tmp20_ = NULL;
					Number* _tmp21_ = NULL;
					Number* _tmp22_ = NULL;
					Number* _tmp23_ = NULL;
					Number* _tmp24_ = NULL;
					Number* _tmp25_ = NULL;
					_tmp20_ = z;
					_tmp21_ = t2;
					_tmp22_ = number_lns (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = number_add (_tmp20_, _tmp23_);
					_tmp25_ = _tmp24_;
					_g_object_unref0 (_tmp23_);
					result = _tmp25_;
					_g_object_unref0 (t2);
					_g_object_unref0 (z);
					_g_object_unref0 (t1);
					return result;
				}
				_tmp26_ = t1;
				_tmp27_ = _tmp26_->re_exponent;
				e = _tmp27_;
				_tmp28_ = t1;
				_tmp28_->re_exponent = 0;
				_tmp29_ = t1;
				_tmp30_ = number_to_double (_tmp29_);
				rx = _tmp30_;
				_tmp31_ = t1;
				_tmp32_ = e;
				_tmp31_->re_exponent = _tmp32_;
				_tmp33_ = rx;
				_tmp34_ = log (_tmp33_);
				_tmp35_ = e;
				_tmp36_ = log ((gdouble) BASE);
				rlx = _tmp34_ + (_tmp35_ * _tmp36_);
				_tmp37_ = rlx;
				_tmp38_ = number_new_double (-_tmp37_);
				_g_object_unref0 (t2);
				t2 = _tmp38_;
				_tmp39_ = z;
				_tmp40_ = t2;
				_tmp41_ = number_subtract (_tmp39_, _tmp40_);
				_g_object_unref0 (z);
				z = _tmp41_;
				_tmp42_ = t2;
				_tmp43_ = number_epowy (_tmp42_);
				_g_object_unref0 (t2);
				t2 = _tmp43_;
				_tmp44_ = t1;
				_tmp45_ = t2;
				_tmp46_ = number_multiply (_tmp44_, _tmp45_);
				_g_object_unref0 (t1);
				t1 = _tmp46_;
				_g_object_unref0 (t2);
			}
		}
	}
	mperr ("*** ERROR IN LN, ITERATION NOT CONVERGING ***");
	result = z;
	_g_object_unref0 (t1);
	return result;
}


static Number* number_lns (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t2 = NULL;
	Number* _tmp2_ = NULL;
	Number* t1 = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	Number* z = NULL;
	Number* _tmp20_ = NULL;
	Number* _tmp21_ = NULL;
	gint it0 = 0;
	gint t = 0;
	gint _tmp22_ = 0;
	Number* t3 = NULL;
	gboolean _tmp51_ = FALSE;
	Number* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	Number* _tmp57_ = NULL;
	Number* _tmp58_ = NULL;
	gint _tmp59_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = _g_object_ref0 (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = number_copy (self);
	t2 = _tmp2_;
	_tmp3_ = number_divide_integer (self, (gint64) 4);
	t1 = _tmp3_;
	_tmp4_ = t1;
	_tmp5_ = number_new_fraction ((gint64) (-1), (gint64) 3);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_add (_tmp4_, _tmp6_);
	_g_object_unref0 (t1);
	t1 = _tmp7_;
	_g_object_unref0 (_tmp6_);
	_tmp8_ = t1;
	_tmp9_ = number_multiply (self, _tmp8_);
	_g_object_unref0 (t1);
	t1 = _tmp9_;
	_tmp10_ = t1;
	_tmp11_ = number_new_fraction ((gint64) 1, (gint64) 2);
	_tmp12_ = _tmp11_;
	_tmp13_ = number_add (_tmp10_, _tmp12_);
	_g_object_unref0 (t1);
	t1 = _tmp13_;
	_g_object_unref0 (_tmp12_);
	_tmp14_ = t1;
	_tmp15_ = number_multiply (self, _tmp14_);
	_g_object_unref0 (t1);
	t1 = _tmp15_;
	_tmp16_ = t1;
	_tmp17_ = number_new_integer ((gint64) (-1));
	_tmp18_ = _tmp17_;
	_tmp19_ = number_add (_tmp16_, _tmp18_);
	_g_object_unref0 (t1);
	t1 = _tmp19_;
	_g_object_unref0 (_tmp18_);
	_tmp20_ = t1;
	_tmp21_ = number_multiply (self, _tmp20_);
	z = _tmp21_;
	it0 = 5;
	_tmp22_ = it0;
	t = _tmp22_;
	while (TRUE) {
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		Number* _tmp29_ = NULL;
		Number* _tmp30_ = NULL;
		Number* _tmp31_ = NULL;
		Number* _tmp32_ = NULL;
		Number* _tmp33_ = NULL;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		Number* _tmp38_ = NULL;
		Number* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint ts3 = 0;
		gint _tmp42_ = 0;
		gint ts2 = 0;
		gint _tmp43_ = 0;
		gint _tmp50_ = 0;
		_tmp23_ = z;
		_tmp24_ = number_epowy (_tmp23_);
		_g_object_unref0 (t3);
		t3 = _tmp24_;
		_tmp25_ = t3;
		_tmp26_ = number_new_integer ((gint64) (-1));
		_tmp27_ = _tmp26_;
		_tmp28_ = number_add (_tmp25_, _tmp27_);
		_g_object_unref0 (t3);
		t3 = _tmp28_;
		_g_object_unref0 (_tmp27_);
		_tmp29_ = t2;
		_tmp30_ = t3;
		_tmp31_ = number_multiply (_tmp29_, _tmp30_);
		_g_object_unref0 (t1);
		t1 = _tmp31_;
		_tmp32_ = t3;
		_tmp33_ = t1;
		_tmp34_ = number_add (_tmp32_, _tmp33_);
		_g_object_unref0 (t3);
		t3 = _tmp34_;
		_tmp35_ = t2;
		_tmp36_ = t3;
		_tmp37_ = number_add (_tmp35_, _tmp36_);
		_g_object_unref0 (t3);
		t3 = _tmp37_;
		_tmp38_ = z;
		_tmp39_ = t3;
		_tmp40_ = number_subtract (_tmp38_, _tmp39_);
		_g_object_unref0 (z);
		z = _tmp40_;
		_tmp41_ = t;
		if (_tmp41_ >= T) {
			break;
		}
		_tmp42_ = t;
		ts3 = _tmp42_;
		_tmp43_ = t;
		ts2 = _tmp43_;
		t = T;
		{
			gboolean _tmp44_ = FALSE;
			_tmp44_ = TRUE;
			while (TRUE) {
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				if (!_tmp44_) {
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
					_tmp45_ = t;
					_tmp46_ = ts3;
					if (!(_tmp45_ > _tmp46_)) {
						break;
					}
				}
				_tmp44_ = FALSE;
				_tmp47_ = t;
				ts2 = _tmp47_;
				_tmp48_ = t;
				_tmp49_ = it0;
				t = (_tmp48_ + _tmp49_) / 2;
			}
		}
		_tmp50_ = ts2;
		t = _tmp50_;
	}
	_tmp52_ = t3;
	_tmp53_ = _tmp52_->re_sign;
	if (_tmp53_ != 0) {
		Number* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		_tmp54_ = t3;
		_tmp55_ = _tmp54_->re_exponent;
		_tmp56_ = it0;
		_tmp51_ = (_tmp55_ << 1) > (_tmp56_ - T);
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		mperr ("*** ERROR OCCURRED IN LNS, NEWTON ITERATION NOT CONVERGING PROPERLY **" \
"*");
	}
	_tmp57_ = z;
	_tmp58_ = z;
	_tmp59_ = _tmp58_->re_sign;
	_tmp57_->re_sign = -_tmp59_;
	result = z;
	_g_object_unref0 (t3);
	_g_object_unref0 (t1);
	_g_object_unref0 (t2);
	return result;
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static gint* _vala_array_dup2 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static gint* _vala_array_dup3 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static gint* _vala_array_dup4 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


static Number* number_add_real (Number* self, gint y_sign, Number* y) {
	Number* result = NULL;
	gint re_sign_prod = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gint exp_diff = 0;
	gint _tmp13_ = 0;
	Number* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint med = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean x_largest = FALSE;
	gint _tmp18_ = 0;
	Number* z = NULL;
	Number* _tmp34_ = NULL;
	gint* big_fraction = NULL;
	gint big_fraction_length1 = 0;
	gint _big_fraction_size_ = 0;
	gint* small_fraction = NULL;
	gint small_fraction_length1 = 0;
	gint _small_fraction_size_ = 0;
	gboolean _tmp35_ = FALSE;
	gint _tmp58_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = y_sign;
	_tmp1_ = self->re_sign;
	re_sign_prod = _tmp0_ * _tmp1_;
	_tmp2_ = number_is_zero (self);
	if (_tmp2_) {
		gint _tmp3_ = 0;
		Number* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp3_ = y_sign;
		_tmp4_ = y;
		_tmp5_ = _tmp4_->re_sign;
		if (_tmp3_ != _tmp5_) {
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
			_tmp6_ = y;
			_tmp7_ = number_invert_sign (_tmp6_);
			result = _tmp7_;
			return result;
		} else {
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			_tmp8_ = y;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			result = _tmp9_;
			return result;
		}
	} else {
		Number* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = y;
		_tmp11_ = number_is_zero (_tmp10_);
		if (_tmp11_) {
			Number* _tmp12_ = NULL;
			_tmp12_ = _g_object_ref0 (self);
			result = _tmp12_;
			return result;
		}
	}
	_tmp13_ = self->re_exponent;
	_tmp14_ = y;
	_tmp15_ = _tmp14_->re_exponent;
	exp_diff = _tmp13_ - _tmp15_;
	_tmp16_ = exp_diff;
	_tmp17_ = abs (_tmp16_);
	med = _tmp17_;
	x_largest = FALSE;
	_tmp18_ = exp_diff;
	if (_tmp18_ < 0) {
		x_largest = FALSE;
	} else {
		gint _tmp19_ = 0;
		_tmp19_ = exp_diff;
		if (_tmp19_ > 0) {
			x_largest = TRUE;
		} else {
			gint _tmp20_ = 0;
			_tmp20_ = re_sign_prod;
			if (_tmp20_ < 0) {
				gint j = 0;
				gint _tmp32_ = 0;
				{
					gboolean _tmp21_ = FALSE;
					j = 0;
					_tmp21_ = TRUE;
					while (TRUE) {
						gint _tmp23_ = 0;
						gint i = 0;
						gint _tmp24_ = 0;
						gint _tmp25_ = 0;
						Number* _tmp26_ = NULL;
						gint _tmp27_ = 0;
						gint _tmp28_ = 0;
						gint _tmp29_ = 0;
						if (!_tmp21_) {
							gint _tmp22_ = 0;
							_tmp22_ = j;
							j = _tmp22_ + 1;
						}
						_tmp21_ = FALSE;
						_tmp23_ = j;
						if (!(_tmp23_ < T)) {
							break;
						}
						_tmp24_ = j;
						_tmp25_ = self->re_fraction[_tmp24_];
						_tmp26_ = y;
						_tmp27_ = j;
						_tmp28_ = _tmp26_->re_fraction[_tmp27_];
						i = _tmp25_ - _tmp28_;
						_tmp29_ = i;
						if (_tmp29_ != 0) {
							gint _tmp30_ = 0;
							_tmp30_ = i;
							if (_tmp30_ < 0) {
								x_largest = FALSE;
							} else {
								gint _tmp31_ = 0;
								_tmp31_ = i;
								if (_tmp31_ > 0) {
									x_largest = TRUE;
								}
							}
							break;
						}
					}
				}
				_tmp32_ = j;
				if (_tmp32_ >= T) {
					Number* _tmp33_ = NULL;
					_tmp33_ = number_new_integer ((gint64) 0);
					result = _tmp33_;
					return result;
				}
			}
		}
	}
	_tmp34_ = number_new_integer ((gint64) 0);
	z = _tmp34_;
	_tmp35_ = x_largest;
	if (_tmp35_) {
		Number* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		Number* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gint* _tmp40_ = NULL;
		gint _tmp40__length1 = 0;
		Number* _tmp41_ = NULL;
		gint* _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		_tmp36_ = z;
		_tmp37_ = self->re_sign;
		_tmp36_->re_sign = _tmp37_;
		_tmp38_ = z;
		_tmp39_ = self->re_exponent;
		_tmp38_->re_exponent = _tmp39_;
		_tmp40_ = (self->re_fraction != NULL) ? _vala_array_dup1 (self->re_fraction, 1000) : ((gpointer) self->re_fraction);
		_tmp40__length1 = 1000;
		big_fraction = (g_free (big_fraction), NULL);
		big_fraction = _tmp40_;
		big_fraction_length1 = _tmp40__length1;
		_big_fraction_size_ = big_fraction_length1;
		_tmp41_ = y;
		_tmp42_ = (_tmp41_->re_fraction != NULL) ? _vala_array_dup2 (_tmp41_->re_fraction, 1000) : ((gpointer) _tmp41_->re_fraction);
		_tmp42__length1 = 1000;
		small_fraction = (g_free (small_fraction), NULL);
		small_fraction = _tmp42_;
		small_fraction_length1 = _tmp42__length1;
		_small_fraction_size_ = small_fraction_length1;
	} else {
		Number* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		Number* _tmp45_ = NULL;
		Number* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		Number* _tmp48_ = NULL;
		gint* _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		gint* _tmp50_ = NULL;
		gint _tmp50__length1 = 0;
		_tmp43_ = z;
		_tmp44_ = y_sign;
		_tmp43_->re_sign = _tmp44_;
		_tmp45_ = z;
		_tmp46_ = y;
		_tmp47_ = _tmp46_->re_exponent;
		_tmp45_->re_exponent = _tmp47_;
		_tmp48_ = y;
		_tmp49_ = (_tmp48_->re_fraction != NULL) ? _vala_array_dup3 (_tmp48_->re_fraction, 1000) : ((gpointer) _tmp48_->re_fraction);
		_tmp49__length1 = 1000;
		big_fraction = (g_free (big_fraction), NULL);
		big_fraction = _tmp49_;
		big_fraction_length1 = _tmp49__length1;
		_big_fraction_size_ = big_fraction_length1;
		_tmp50_ = (self->re_fraction != NULL) ? _vala_array_dup4 (self->re_fraction, 1000) : ((gpointer) self->re_fraction);
		_tmp50__length1 = 1000;
		small_fraction = (g_free (small_fraction), NULL);
		small_fraction = _tmp50_;
		small_fraction_length1 = _tmp50__length1;
		_small_fraction_size_ = small_fraction_length1;
	}
	{
		gint i = 0;
		i = 3;
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = TRUE;
			while (TRUE) {
				gint _tmp53_ = 0;
				gint _tmp54_ = 0;
				Number* _tmp55_ = NULL;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				if (!_tmp51_) {
					gint _tmp52_ = 0;
					_tmp52_ = i;
					i = _tmp52_ - 1;
				}
				_tmp51_ = FALSE;
				_tmp53_ = i;
				_tmp54_ = med;
				if (!(_tmp53_ >= _tmp54_)) {
					break;
				}
				_tmp55_ = z;
				_tmp56_ = i;
				_tmp55_->re_fraction[T + _tmp56_] = 0;
				_tmp57_ = _tmp55_->re_fraction[T + _tmp56_];
			}
		}
	}
	_tmp58_ = re_sign_prod;
	if (_tmp58_ >= 0) {
		gint _tmp59_ = 0;
		gint i = 0;
		gint c = 0;
		gint _tmp118_ = 0;
		_tmp59_ = med;
		if ((T + 3) < _tmp59_) {
			const gchar* _tmp60_ = NULL;
			Number* _tmp61_ = NULL;
			_tmp60_ = _ ("Overflow: the result couldn't be calculated");
			mperr (_tmp60_);
			_tmp61_ = number_new_integer ((gint64) 0);
			result = _tmp61_;
			small_fraction = (g_free (small_fraction), NULL);
			big_fraction = (g_free (big_fraction), NULL);
			_g_object_unref0 (z);
			return result;
		}
		i = 0;
		{
			gboolean _tmp62_ = FALSE;
			i = T + 3;
			_tmp62_ = TRUE;
			while (TRUE) {
				gint _tmp64_ = 0;
				Number* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gint* _tmp67_ = NULL;
				gint _tmp67__length1 = 0;
				gint _tmp68_ = 0;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				gint _tmp71_ = 0;
				if (!_tmp62_) {
					gint _tmp63_ = 0;
					_tmp63_ = i;
					i = _tmp63_ - 1;
				}
				_tmp62_ = FALSE;
				_tmp64_ = i;
				if (!(_tmp64_ >= T)) {
					break;
				}
				_tmp65_ = z;
				_tmp66_ = i;
				_tmp67_ = small_fraction;
				_tmp67__length1 = small_fraction_length1;
				_tmp68_ = i;
				_tmp69_ = med;
				_tmp70_ = _tmp67_[_tmp68_ - _tmp69_];
				_tmp65_->re_fraction[_tmp66_] = _tmp70_;
				_tmp71_ = _tmp65_->re_fraction[_tmp66_];
			}
		}
		c = 0;
		{
			gboolean _tmp72_ = FALSE;
			_tmp72_ = TRUE;
			while (TRUE) {
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint* _tmp76_ = NULL;
				gint _tmp76__length1 = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint* _tmp79_ = NULL;
				gint _tmp79__length1 = 0;
				gint _tmp80_ = 0;
				gint _tmp81_ = 0;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				if (!_tmp72_) {
					gint _tmp73_ = 0;
					_tmp73_ = i;
					i = _tmp73_ - 1;
				}
				_tmp72_ = FALSE;
				_tmp74_ = i;
				_tmp75_ = med;
				if (!(_tmp74_ >= _tmp75_)) {
					break;
				}
				_tmp76_ = big_fraction;
				_tmp76__length1 = big_fraction_length1;
				_tmp77_ = i;
				_tmp78_ = _tmp76_[_tmp77_];
				_tmp79_ = small_fraction;
				_tmp79__length1 = small_fraction_length1;
				_tmp80_ = i;
				_tmp81_ = med;
				_tmp82_ = _tmp79_[_tmp80_ - _tmp81_];
				_tmp83_ = c;
				c = (_tmp78_ + _tmp82_) + _tmp83_;
				_tmp84_ = c;
				if (_tmp84_ < BASE) {
					Number* _tmp85_ = NULL;
					gint _tmp86_ = 0;
					gint _tmp87_ = 0;
					gint _tmp88_ = 0;
					_tmp85_ = z;
					_tmp86_ = i;
					_tmp87_ = c;
					_tmp85_->re_fraction[_tmp86_] = _tmp87_;
					_tmp88_ = _tmp85_->re_fraction[_tmp86_];
					c = 0;
				} else {
					Number* _tmp89_ = NULL;
					gint _tmp90_ = 0;
					gint _tmp91_ = 0;
					gint _tmp92_ = 0;
					_tmp89_ = z;
					_tmp90_ = i;
					_tmp91_ = c;
					_tmp89_->re_fraction[_tmp90_] = _tmp91_ - BASE;
					_tmp92_ = _tmp89_->re_fraction[_tmp90_];
					c = 1;
				}
			}
		}
		{
			gboolean _tmp93_ = FALSE;
			_tmp93_ = TRUE;
			while (TRUE) {
				gint _tmp95_ = 0;
				gint* _tmp96_ = NULL;
				gint _tmp96__length1 = 0;
				gint _tmp97_ = 0;
				gint _tmp98_ = 0;
				gint _tmp99_ = 0;
				gint _tmp100_ = 0;
				Number* _tmp115_ = NULL;
				gint _tmp116_ = 0;
				gint _tmp117_ = 0;
				if (!_tmp93_) {
					gint _tmp94_ = 0;
					_tmp94_ = i;
					i = _tmp94_ - 1;
				}
				_tmp93_ = FALSE;
				_tmp95_ = i;
				if (!(_tmp95_ >= 0)) {
					break;
				}
				_tmp96_ = big_fraction;
				_tmp96__length1 = big_fraction_length1;
				_tmp97_ = i;
				_tmp98_ = _tmp96_[_tmp97_];
				_tmp99_ = c;
				c = _tmp98_ + _tmp99_;
				_tmp100_ = c;
				if (_tmp100_ < BASE) {
					Number* _tmp101_ = NULL;
					gint _tmp102_ = 0;
					gint _tmp103_ = 0;
					gint _tmp104_ = 0;
					gint _tmp105_ = 0;
					_tmp101_ = z;
					_tmp102_ = i;
					_tmp103_ = c;
					_tmp101_->re_fraction[_tmp102_] = _tmp103_;
					_tmp104_ = _tmp101_->re_fraction[_tmp102_];
					_tmp105_ = i;
					i = _tmp105_ - 1;
					{
						gboolean _tmp106_ = FALSE;
						_tmp106_ = TRUE;
						while (TRUE) {
							gint _tmp108_ = 0;
							Number* _tmp109_ = NULL;
							gint _tmp110_ = 0;
							gint* _tmp111_ = NULL;
							gint _tmp111__length1 = 0;
							gint _tmp112_ = 0;
							gint _tmp113_ = 0;
							gint _tmp114_ = 0;
							if (!_tmp106_) {
								gint _tmp107_ = 0;
								_tmp107_ = i;
								i = _tmp107_ - 1;
							}
							_tmp106_ = FALSE;
							_tmp108_ = i;
							if (!(_tmp108_ >= 0)) {
								break;
							}
							_tmp109_ = z;
							_tmp110_ = i;
							_tmp111_ = big_fraction;
							_tmp111__length1 = big_fraction_length1;
							_tmp112_ = i;
							_tmp113_ = _tmp111_[_tmp112_];
							_tmp109_->re_fraction[_tmp110_] = _tmp113_;
							_tmp114_ = _tmp109_->re_fraction[_tmp110_];
						}
					}
					c = 0;
					break;
				}
				_tmp115_ = z;
				_tmp116_ = i;
				_tmp115_->re_fraction[_tmp116_] = 0;
				_tmp117_ = _tmp115_->re_fraction[_tmp116_];
				c = 1;
			}
		}
		_tmp118_ = c;
		if (_tmp118_ != 0) {
			Number* _tmp128_ = NULL;
			gint _tmp129_ = 0;
			Number* _tmp130_ = NULL;
			gint _tmp131_ = 0;
			{
				gint j = 0;
				j = T + 3;
				{
					gboolean _tmp119_ = FALSE;
					_tmp119_ = TRUE;
					while (TRUE) {
						gint _tmp121_ = 0;
						Number* _tmp122_ = NULL;
						gint _tmp123_ = 0;
						Number* _tmp124_ = NULL;
						gint _tmp125_ = 0;
						gint _tmp126_ = 0;
						gint _tmp127_ = 0;
						if (!_tmp119_) {
							gint _tmp120_ = 0;
							_tmp120_ = j;
							j = _tmp120_ - 1;
						}
						_tmp119_ = FALSE;
						_tmp121_ = j;
						if (!(_tmp121_ > 0)) {
							break;
						}
						_tmp122_ = z;
						_tmp123_ = j;
						_tmp124_ = z;
						_tmp125_ = j;
						_tmp126_ = _tmp124_->re_fraction[_tmp125_ - 1];
						_tmp122_->re_fraction[_tmp123_] = _tmp126_;
						_tmp127_ = _tmp122_->re_fraction[_tmp123_];
					}
				}
			}
			_tmp128_ = z;
			_tmp128_->re_fraction[0] = 1;
			_tmp129_ = _tmp128_->re_fraction[0];
			_tmp130_ = z;
			_tmp131_ = _tmp130_->re_exponent;
			_tmp130_->re_exponent = _tmp131_ + 1;
		}
	} else {
		gint c = 0;
		gint i = 0;
		c = 0;
		i = 0;
		{
			gint _tmp132_ = 0;
			gboolean _tmp133_ = FALSE;
			_tmp132_ = med;
			i = (T + _tmp132_) - 1;
			_tmp133_ = TRUE;
			while (TRUE) {
				gint _tmp135_ = 0;
				Number* _tmp136_ = NULL;
				gint _tmp137_ = 0;
				gint _tmp138_ = 0;
				gint* _tmp139_ = NULL;
				gint _tmp139__length1 = 0;
				gint _tmp140_ = 0;
				gint _tmp141_ = 0;
				gint _tmp142_ = 0;
				gint _tmp143_ = 0;
				Number* _tmp144_ = NULL;
				gint _tmp145_ = 0;
				gint _tmp146_ = 0;
				if (!_tmp133_) {
					gint _tmp134_ = 0;
					_tmp134_ = i;
					i = _tmp134_ - 1;
				}
				_tmp133_ = FALSE;
				_tmp135_ = i;
				if (!(_tmp135_ >= T)) {
					break;
				}
				_tmp136_ = z;
				_tmp137_ = i;
				_tmp138_ = c;
				_tmp139_ = small_fraction;
				_tmp139__length1 = small_fraction_length1;
				_tmp140_ = i;
				_tmp141_ = med;
				_tmp142_ = _tmp139_[_tmp140_ - _tmp141_];
				_tmp136_->re_fraction[_tmp137_] = _tmp138_ - _tmp142_;
				_tmp143_ = _tmp136_->re_fraction[_tmp137_];
				c = 0;
				_tmp144_ = z;
				_tmp145_ = i;
				_tmp146_ = _tmp144_->re_fraction[_tmp145_];
				if (_tmp146_ < 0) {
					Number* _tmp147_ = NULL;
					gint _tmp148_ = 0;
					gint _tmp149_ = 0;
					c = -1;
					_tmp147_ = z;
					_tmp148_ = i;
					_tmp147_->re_fraction[_tmp148_] += BASE;
					_tmp149_ = _tmp147_->re_fraction[_tmp148_];
				}
			}
		}
		{
			gboolean _tmp150_ = FALSE;
			_tmp150_ = TRUE;
			while (TRUE) {
				gint _tmp152_ = 0;
				gint _tmp153_ = 0;
				gint* _tmp154_ = NULL;
				gint _tmp154__length1 = 0;
				gint _tmp155_ = 0;
				gint _tmp156_ = 0;
				gint _tmp157_ = 0;
				gint* _tmp158_ = NULL;
				gint _tmp158__length1 = 0;
				gint _tmp159_ = 0;
				gint _tmp160_ = 0;
				gint _tmp161_ = 0;
				gint _tmp162_ = 0;
				if (!_tmp150_) {
					gint _tmp151_ = 0;
					_tmp151_ = i;
					i = _tmp151_ - 1;
				}
				_tmp150_ = FALSE;
				_tmp152_ = i;
				_tmp153_ = med;
				if (!(_tmp152_ >= _tmp153_)) {
					break;
				}
				_tmp154_ = big_fraction;
				_tmp154__length1 = big_fraction_length1;
				_tmp155_ = i;
				_tmp156_ = _tmp154_[_tmp155_];
				_tmp157_ = c;
				_tmp158_ = small_fraction;
				_tmp158__length1 = small_fraction_length1;
				_tmp159_ = i;
				_tmp160_ = med;
				_tmp161_ = _tmp158_[_tmp159_ - _tmp160_];
				c = (_tmp156_ + _tmp157_) - _tmp161_;
				_tmp162_ = c;
				if (_tmp162_ >= 0) {
					Number* _tmp163_ = NULL;
					gint _tmp164_ = 0;
					gint _tmp165_ = 0;
					gint _tmp166_ = 0;
					_tmp163_ = z;
					_tmp164_ = i;
					_tmp165_ = c;
					_tmp163_->re_fraction[_tmp164_] = _tmp165_;
					_tmp166_ = _tmp163_->re_fraction[_tmp164_];
					c = 0;
				} else {
					Number* _tmp167_ = NULL;
					gint _tmp168_ = 0;
					gint _tmp169_ = 0;
					gint _tmp170_ = 0;
					_tmp167_ = z;
					_tmp168_ = i;
					_tmp169_ = c;
					_tmp167_->re_fraction[_tmp168_] = _tmp169_ + BASE;
					_tmp170_ = _tmp167_->re_fraction[_tmp168_];
					c = -1;
				}
			}
		}
		{
			gboolean _tmp171_ = FALSE;
			_tmp171_ = TRUE;
			while (TRUE) {
				gint _tmp173_ = 0;
				gint* _tmp174_ = NULL;
				gint _tmp174__length1 = 0;
				gint _tmp175_ = 0;
				gint _tmp176_ = 0;
				gint _tmp177_ = 0;
				gint _tmp178_ = 0;
				Number* _tmp193_ = NULL;
				gint _tmp194_ = 0;
				gint _tmp195_ = 0;
				gint _tmp196_ = 0;
				if (!_tmp171_) {
					gint _tmp172_ = 0;
					_tmp172_ = i;
					i = _tmp172_ - 1;
				}
				_tmp171_ = FALSE;
				_tmp173_ = i;
				if (!(_tmp173_ >= 0)) {
					break;
				}
				_tmp174_ = big_fraction;
				_tmp174__length1 = big_fraction_length1;
				_tmp175_ = i;
				_tmp176_ = _tmp174_[_tmp175_];
				_tmp177_ = c;
				c = _tmp176_ + _tmp177_;
				_tmp178_ = c;
				if (_tmp178_ >= 0) {
					Number* _tmp179_ = NULL;
					gint _tmp180_ = 0;
					gint _tmp181_ = 0;
					gint _tmp182_ = 0;
					gint _tmp183_ = 0;
					_tmp179_ = z;
					_tmp180_ = i;
					_tmp181_ = c;
					_tmp179_->re_fraction[_tmp180_] = _tmp181_;
					_tmp182_ = _tmp179_->re_fraction[_tmp180_];
					_tmp183_ = i;
					i = _tmp183_ - 1;
					{
						gboolean _tmp184_ = FALSE;
						_tmp184_ = TRUE;
						while (TRUE) {
							gint _tmp186_ = 0;
							Number* _tmp187_ = NULL;
							gint _tmp188_ = 0;
							gint* _tmp189_ = NULL;
							gint _tmp189__length1 = 0;
							gint _tmp190_ = 0;
							gint _tmp191_ = 0;
							gint _tmp192_ = 0;
							if (!_tmp184_) {
								gint _tmp185_ = 0;
								_tmp185_ = i;
								i = _tmp185_ - 1;
							}
							_tmp184_ = FALSE;
							_tmp186_ = i;
							if (!(_tmp186_ >= 0)) {
								break;
							}
							_tmp187_ = z;
							_tmp188_ = i;
							_tmp189_ = big_fraction;
							_tmp189__length1 = big_fraction_length1;
							_tmp190_ = i;
							_tmp191_ = _tmp189_[_tmp190_];
							_tmp187_->re_fraction[_tmp188_] = _tmp191_;
							_tmp192_ = _tmp187_->re_fraction[_tmp188_];
						}
					}
					break;
				}
				_tmp193_ = z;
				_tmp194_ = i;
				_tmp195_ = c;
				_tmp193_->re_fraction[_tmp194_] = _tmp195_ + BASE;
				_tmp196_ = _tmp193_->re_fraction[_tmp194_];
				c = -1;
			}
		}
	}
	mp_normalize (&z);
	result = z;
	small_fraction = (g_free (small_fraction), NULL);
	big_fraction = (g_free (big_fraction), NULL);
	return result;
}


static Number* number_multiply_real (Number* self, Number* y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Number* z = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	Number* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	Number* r = NULL;
	Number* _tmp14_ = NULL;
	gint c = 0;
	gint _tmp57_ = 0;
	Number* _tmp75_ = NULL;
	Number* _tmp76_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp1_ = self->re_sign;
	if (_tmp1_ == 0) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp2_ = y;
		_tmp3_ = _tmp2_->re_sign;
		_tmp0_ = _tmp3_ == 0;
	}
	if (_tmp0_) {
		Number* _tmp4_ = NULL;
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = number_new_integer ((gint64) 0);
	z = _tmp5_;
	_tmp6_ = z;
	_tmp7_ = self->re_sign;
	_tmp8_ = y;
	_tmp9_ = _tmp8_->re_sign;
	_tmp6_->re_sign = _tmp7_ * _tmp9_;
	_tmp10_ = z;
	_tmp11_ = self->re_exponent;
	_tmp12_ = y;
	_tmp13_ = _tmp12_->re_exponent;
	_tmp10_->re_exponent = _tmp11_ + _tmp13_;
	_tmp14_ = number_new_integer ((gint64) 0);
	r = _tmp14_;
	c = 8;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_ = 0;
				gint xi = 0;
				gint _tmp18_ = 0;
				gint _tmp19_ = 0;
				gint _tmp20_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_ = 0;
				gint _tmp55_ = 0;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				if (!(_tmp17_ < T)) {
					break;
				}
				_tmp18_ = i;
				_tmp19_ = self->re_fraction[_tmp18_];
				xi = _tmp19_;
				_tmp20_ = xi;
				if (_tmp20_ == 0) {
					continue;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							Number* _tmp26_ = NULL;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							Number* _tmp30_ = NULL;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							if (!_tmp21_) {
								gint _tmp22_ = 0;
								_tmp22_ = j;
								j = _tmp22_ + 1;
							}
							_tmp21_ = FALSE;
							_tmp23_ = j;
							_tmp24_ = i;
							_tmp25_ = MIN (T, (T + 3) - _tmp24_);
							if (!(_tmp23_ < _tmp25_)) {
								break;
							}
							_tmp26_ = r;
							_tmp27_ = i;
							_tmp28_ = j;
							_tmp29_ = xi;
							_tmp30_ = y;
							_tmp31_ = j;
							_tmp32_ = _tmp30_->re_fraction[_tmp31_];
							_tmp26_->re_fraction[(_tmp27_ + _tmp28_) + 1] += _tmp29_ * _tmp32_;
							_tmp33_ = _tmp26_->re_fraction[(_tmp27_ + _tmp28_) + 1];
						}
					}
				}
				_tmp34_ = c;
				c = _tmp34_ - 1;
				_tmp35_ = c;
				if (_tmp35_ > 0) {
					continue;
				}
				_tmp37_ = xi;
				if (_tmp37_ < 0) {
					_tmp36_ = TRUE;
				} else {
					gint _tmp38_ = 0;
					_tmp38_ = xi;
					_tmp36_ = _tmp38_ >= BASE;
				}
				if (_tmp36_) {
					Number* _tmp39_ = NULL;
					mperr ("*** ILLEGAL BASE B DIGIT IN CALL TO MULTIPLY, POSSIBLE OVERWRITING PRO" \
"BLEM ***");
					_tmp39_ = number_new_integer ((gint64) 0);
					result = _tmp39_;
					_g_object_unref0 (r);
					_g_object_unref0 (z);
					return result;
				}
				{
					gint j = 0;
					j = T + 3;
					{
						gboolean _tmp40_ = FALSE;
						_tmp40_ = TRUE;
						while (TRUE) {
							gint _tmp42_ = 0;
							gint ri = 0;
							Number* _tmp43_ = NULL;
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint _tmp49_ = 0;
							Number* _tmp50_ = NULL;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							gint _tmp54_ = 0;
							if (!_tmp40_) {
								gint _tmp41_ = 0;
								_tmp41_ = j;
								j = _tmp41_ - 1;
							}
							_tmp40_ = FALSE;
							_tmp42_ = j;
							if (!(_tmp42_ >= 0)) {
								break;
							}
							_tmp43_ = r;
							_tmp44_ = j;
							_tmp45_ = _tmp43_->re_fraction[_tmp44_];
							_tmp46_ = c;
							ri = _tmp45_ + _tmp46_;
							_tmp47_ = ri;
							if (_tmp47_ < 0) {
								Number* _tmp48_ = NULL;
								mperr ("*** INTEGER OVERFLOW IN MULTIPLY, B TOO LARGE ***");
								_tmp48_ = number_new_integer ((gint64) 0);
								result = _tmp48_;
								_g_object_unref0 (r);
								_g_object_unref0 (z);
								return result;
							}
							_tmp49_ = ri;
							c = _tmp49_ / BASE;
							_tmp50_ = r;
							_tmp51_ = j;
							_tmp52_ = ri;
							_tmp53_ = c;
							_tmp50_->re_fraction[_tmp51_] = _tmp52_ - (BASE * _tmp53_);
							_tmp54_ = _tmp50_->re_fraction[_tmp51_];
						}
					}
				}
				_tmp55_ = c;
				if (_tmp55_ != 0) {
					Number* _tmp56_ = NULL;
					mperr ("*** ILLEGAL BASE B DIGIT IN CALL TO MULTIPLY, POSSIBLE OVERWRITING PRO" \
"BLEM ***");
					_tmp56_ = number_new_integer ((gint64) 0);
					result = _tmp56_;
					_g_object_unref0 (r);
					_g_object_unref0 (z);
					return result;
				}
				c = 8;
			}
		}
	}
	_tmp57_ = c;
	if (_tmp57_ != 8) {
		gint _tmp73_ = 0;
		c = 0;
		{
			gint i = 0;
			i = T + 3;
			{
				gboolean _tmp58_ = FALSE;
				_tmp58_ = TRUE;
				while (TRUE) {
					gint _tmp60_ = 0;
					gint ri = 0;
					Number* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gint _tmp64_ = 0;
					gint _tmp65_ = 0;
					gint _tmp67_ = 0;
					Number* _tmp68_ = NULL;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
					if (!_tmp58_) {
						gint _tmp59_ = 0;
						_tmp59_ = i;
						i = _tmp59_ - 1;
					}
					_tmp58_ = FALSE;
					_tmp60_ = i;
					if (!(_tmp60_ >= 0)) {
						break;
					}
					_tmp61_ = r;
					_tmp62_ = i;
					_tmp63_ = _tmp61_->re_fraction[_tmp62_];
					_tmp64_ = c;
					ri = _tmp63_ + _tmp64_;
					_tmp65_ = ri;
					if (_tmp65_ < 0) {
						Number* _tmp66_ = NULL;
						mperr ("*** INTEGER OVERFLOW IN MULTIPLY, B TOO LARGE ***");
						_tmp66_ = number_new_integer ((gint64) 0);
						result = _tmp66_;
						_g_object_unref0 (r);
						_g_object_unref0 (z);
						return result;
					}
					_tmp67_ = ri;
					c = _tmp67_ / BASE;
					_tmp68_ = r;
					_tmp69_ = i;
					_tmp70_ = ri;
					_tmp71_ = c;
					_tmp68_->re_fraction[_tmp69_] = _tmp70_ - (BASE * _tmp71_);
					_tmp72_ = _tmp68_->re_fraction[_tmp69_];
				}
			}
		}
		_tmp73_ = c;
		if (_tmp73_ != 0) {
			Number* _tmp74_ = NULL;
			mperr ("*** ILLEGAL BASE B DIGIT IN CALL TO MULTIPLY, POSSIBLE OVERWRITING PRO" \
"BLEM ***");
			_tmp74_ = number_new_integer ((gint64) 0);
			result = _tmp74_;
			_g_object_unref0 (r);
			_g_object_unref0 (z);
			return result;
		}
	}
	_tmp75_ = z;
	_tmp75_->im_sign = 0;
	_tmp76_ = z;
	_tmp76_->im_exponent = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp77_ = FALSE;
			_tmp77_ = TRUE;
			while (TRUE) {
				gint _tmp79_ = 0;
				Number* _tmp80_ = NULL;
				Number* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				if (!_tmp77_) {
					gint _tmp78_ = 0;
					_tmp78_ = i;
					i = _tmp78_ + 1;
				}
				_tmp77_ = FALSE;
				_tmp79_ = i;
				_tmp80_ = z;
				if (!(_tmp79_ < 1000)) {
					break;
				}
				_tmp81_ = z;
				_tmp82_ = i;
				_tmp81_->im_fraction[_tmp82_] = 0;
				_tmp83_ = _tmp81_->im_fraction[_tmp82_];
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp84_ = FALSE;
			_tmp84_ = TRUE;
			while (TRUE) {
				gint _tmp86_ = 0;
				Number* _tmp87_ = NULL;
				gint _tmp88_ = 0;
				Number* _tmp89_ = NULL;
				gint _tmp90_ = 0;
				gint _tmp91_ = 0;
				gint _tmp92_ = 0;
				if (!_tmp84_) {
					gint _tmp85_ = 0;
					_tmp85_ = i;
					i = _tmp85_ + 1;
				}
				_tmp84_ = FALSE;
				_tmp86_ = i;
				if (!(_tmp86_ < SIZE)) {
					break;
				}
				_tmp87_ = z;
				_tmp88_ = i;
				_tmp89_ = r;
				_tmp90_ = i;
				_tmp91_ = _tmp89_->re_fraction[_tmp90_];
				_tmp87_->re_fraction[_tmp88_] = _tmp91_;
				_tmp92_ = _tmp87_->re_fraction[_tmp88_];
			}
		}
	}
	mp_normalize (&z);
	result = z;
	_g_object_unref0 (r);
	return result;
}


static Number* number_multiply_integer_real (Number* self, gint64 y) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Number* z = NULL;
	Number* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	Number* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint64 c = 0LL;
	gint64 _tmp13_ = 0LL;
	gint _tmp14_ = 0;
	gint64 _tmp83_ = 0LL;
	Number* _tmp85_ = NULL;
	Number* _tmp86_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_is_zero (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint64 _tmp2_ = 0LL;
		_tmp2_ = y;
		_tmp0_ = _tmp2_ == ((gint64) 0);
	}
	if (_tmp0_) {
		Number* _tmp3_ = NULL;
		_tmp3_ = number_new_integer ((gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_new_integer ((gint64) 0);
	z = _tmp4_;
	_tmp5_ = y;
	if (_tmp5_ < ((gint64) 0)) {
		gint64 _tmp6_ = 0LL;
		Number* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp6_ = y;
		y = -_tmp6_;
		_tmp7_ = z;
		_tmp8_ = self->re_sign;
		_tmp7_->re_sign = -_tmp8_;
	} else {
		Number* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		_tmp9_ = z;
		_tmp10_ = self->re_sign;
		_tmp9_->re_sign = _tmp10_;
	}
	_tmp11_ = z;
	_tmp12_ = self->re_exponent;
	_tmp11_->re_exponent = _tmp12_ + 4;
	c = (gint64) 0;
	_tmp13_ = y;
	_tmp14_ = MAX (BASE << 3, 32767 / BASE);
	if (_tmp13_ >= ((gint64) _tmp14_)) {
		gint64 j1 = 0LL;
		gint64 _tmp15_ = 0LL;
		gint64 j2 = 0LL;
		gint64 _tmp16_ = 0LL;
		gint64 _tmp17_ = 0LL;
		_tmp15_ = y;
		j1 = _tmp15_ / BASE;
		_tmp16_ = y;
		_tmp17_ = j1;
		j2 = _tmp16_ - (_tmp17_ * BASE);
		{
			gint i = 0;
			i = T + 3;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gint _tmp20_ = 0;
					gint64 c1 = 0LL;
					gint64 _tmp21_ = 0LL;
					gint64 c2 = 0LL;
					gint64 _tmp22_ = 0LL;
					gint64 _tmp23_ = 0LL;
					gint ix = 0;
					gint _tmp24_ = 0;
					gint64 t = 0LL;
					gint64 _tmp27_ = 0LL;
					gint _tmp28_ = 0;
					gint64 _tmp29_ = 0LL;
					gint64 is = 0LL;
					gint64 _tmp30_ = 0LL;
					gint64 _tmp31_ = 0LL;
					gint _tmp32_ = 0;
					gint64 _tmp33_ = 0LL;
					gint64 _tmp34_ = 0LL;
					Number* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gint64 _tmp37_ = 0LL;
					gint64 _tmp38_ = 0LL;
					gint _tmp39_ = 0;
					if (!_tmp18_) {
						gint _tmp19_ = 0;
						_tmp19_ = i;
						i = _tmp19_ - 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = i;
					if (!(_tmp20_ >= 0)) {
						break;
					}
					_tmp21_ = c;
					c1 = _tmp21_ / BASE;
					_tmp22_ = c;
					_tmp23_ = c1;
					c2 = _tmp22_ - (BASE * _tmp23_);
					ix = 0;
					_tmp24_ = i;
					if (_tmp24_ > 3) {
						gint _tmp25_ = 0;
						gint _tmp26_ = 0;
						_tmp25_ = i;
						_tmp26_ = self->re_fraction[_tmp25_ - 4];
						ix = _tmp26_;
					}
					_tmp27_ = j2;
					_tmp28_ = ix;
					_tmp29_ = c2;
					t = (_tmp27_ * _tmp28_) + _tmp29_;
					_tmp30_ = t;
					is = _tmp30_ / BASE;
					_tmp31_ = j1;
					_tmp32_ = ix;
					_tmp33_ = c1;
					_tmp34_ = is;
					c = ((_tmp31_ * _tmp32_) + _tmp33_) + _tmp34_;
					_tmp35_ = z;
					_tmp36_ = i;
					_tmp37_ = t;
					_tmp38_ = is;
					_tmp35_->re_fraction[_tmp36_] = (gint) (_tmp37_ - (BASE * _tmp38_));
					_tmp39_ = _tmp35_->re_fraction[_tmp36_];
				}
			}
		}
	} else {
		gint64 ri = 0LL;
		gint64 _tmp53_ = 0LL;
		ri = (gint64) 0;
		{
			gint i = 0;
			i = T + 3;
			{
				gboolean _tmp40_ = FALSE;
				_tmp40_ = TRUE;
				while (TRUE) {
					gint _tmp42_ = 0;
					gint64 _tmp43_ = 0LL;
					gint _tmp44_ = 0;
					gint _tmp45_ = 0;
					gint64 _tmp46_ = 0LL;
					gint64 _tmp47_ = 0LL;
					Number* _tmp48_ = NULL;
					gint _tmp49_ = 0;
					gint64 _tmp50_ = 0LL;
					gint64 _tmp51_ = 0LL;
					gint _tmp52_ = 0;
					if (!_tmp40_) {
						gint _tmp41_ = 0;
						_tmp41_ = i;
						i = _tmp41_ - 1;
					}
					_tmp40_ = FALSE;
					_tmp42_ = i;
					if (!(_tmp42_ >= 4)) {
						break;
					}
					_tmp43_ = y;
					_tmp44_ = i;
					_tmp45_ = self->re_fraction[_tmp44_ - 4];
					_tmp46_ = c;
					ri = (_tmp43_ * _tmp45_) + _tmp46_;
					_tmp47_ = ri;
					c = _tmp47_ / BASE;
					_tmp48_ = z;
					_tmp49_ = i;
					_tmp50_ = ri;
					_tmp51_ = c;
					_tmp48_->re_fraction[_tmp49_] = (gint) (_tmp50_ - (BASE * _tmp51_));
					_tmp52_ = _tmp48_->re_fraction[_tmp49_];
				}
			}
		}
		_tmp53_ = ri;
		if (_tmp53_ < ((gint64) 0)) {
			Number* _tmp54_ = NULL;
			mperr ("*** INTEGER OVERFLOW IN multiply_integer, B TOO LARGE ***");
			_tmp54_ = number_new_integer ((gint64) 0);
			result = _tmp54_;
			_g_object_unref0 (z);
			return result;
		}
		{
			gint i = 0;
			i = 3;
			{
				gboolean _tmp55_ = FALSE;
				_tmp55_ = TRUE;
				while (TRUE) {
					gint _tmp57_ = 0;
					gint64 t = 0LL;
					gint64 _tmp58_ = 0LL;
					gint64 _tmp59_ = 0LL;
					Number* _tmp60_ = NULL;
					gint _tmp61_ = 0;
					gint64 _tmp62_ = 0LL;
					gint64 _tmp63_ = 0LL;
					gint _tmp64_ = 0;
					if (!_tmp55_) {
						gint _tmp56_ = 0;
						_tmp56_ = i;
						i = _tmp56_ - 1;
					}
					_tmp55_ = FALSE;
					_tmp57_ = i;
					if (!(_tmp57_ >= 0)) {
						break;
					}
					_tmp58_ = c;
					t = _tmp58_;
					_tmp59_ = t;
					c = _tmp59_ / BASE;
					_tmp60_ = z;
					_tmp61_ = i;
					_tmp62_ = t;
					_tmp63_ = c;
					_tmp60_->re_fraction[_tmp61_] = (gint) (_tmp62_ - (BASE * _tmp63_));
					_tmp64_ = _tmp60_->re_fraction[_tmp61_];
				}
			}
		}
	}
	while (TRUE) {
		gint64 _tmp65_ = 0LL;
		gint64 t = 0LL;
		gint64 _tmp75_ = 0LL;
		gint64 _tmp76_ = 0LL;
		Number* _tmp77_ = NULL;
		gint64 _tmp78_ = 0LL;
		gint64 _tmp79_ = 0LL;
		gint _tmp80_ = 0;
		Number* _tmp81_ = NULL;
		gint _tmp82_ = 0;
		_tmp65_ = c;
		if (!(_tmp65_ != ((gint64) 0))) {
			break;
		}
		{
			gint i = 0;
			i = T + 3;
			{
				gboolean _tmp66_ = FALSE;
				_tmp66_ = TRUE;
				while (TRUE) {
					gint _tmp68_ = 0;
					Number* _tmp69_ = NULL;
					gint _tmp70_ = 0;
					Number* _tmp71_ = NULL;
					gint _tmp72_ = 0;
					gint _tmp73_ = 0;
					gint _tmp74_ = 0;
					if (!_tmp66_) {
						gint _tmp67_ = 0;
						_tmp67_ = i;
						i = _tmp67_ - 1;
					}
					_tmp66_ = FALSE;
					_tmp68_ = i;
					if (!(_tmp68_ >= 1)) {
						break;
					}
					_tmp69_ = z;
					_tmp70_ = i;
					_tmp71_ = z;
					_tmp72_ = i;
					_tmp73_ = _tmp71_->re_fraction[_tmp72_ - 1];
					_tmp69_->re_fraction[_tmp70_] = _tmp73_;
					_tmp74_ = _tmp69_->re_fraction[_tmp70_];
				}
			}
		}
		_tmp75_ = c;
		t = _tmp75_;
		_tmp76_ = t;
		c = _tmp76_ / BASE;
		_tmp77_ = z;
		_tmp78_ = t;
		_tmp79_ = c;
		_tmp77_->re_fraction[0] = (gint) (_tmp78_ - (BASE * _tmp79_));
		_tmp80_ = _tmp77_->re_fraction[0];
		_tmp81_ = z;
		_tmp82_ = _tmp81_->re_exponent;
		_tmp81_->re_exponent = _tmp82_ + 1;
	}
	_tmp83_ = c;
	if (_tmp83_ < ((gint64) 0)) {
		Number* _tmp84_ = NULL;
		mperr ("*** INTEGER OVERFLOW IN multiply_integer, B TOO LARGE ***");
		_tmp84_ = number_new_integer ((gint64) 0);
		result = _tmp84_;
		_g_object_unref0 (z);
		return result;
	}
	_tmp85_ = z;
	_tmp85_->im_sign = 0;
	_tmp86_ = z;
	_tmp86_->im_exponent = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp87_ = FALSE;
			_tmp87_ = TRUE;
			while (TRUE) {
				gint _tmp89_ = 0;
				Number* _tmp90_ = NULL;
				Number* _tmp91_ = NULL;
				gint _tmp92_ = 0;
				gint _tmp93_ = 0;
				if (!_tmp87_) {
					gint _tmp88_ = 0;
					_tmp88_ = i;
					i = _tmp88_ + 1;
				}
				_tmp87_ = FALSE;
				_tmp89_ = i;
				_tmp90_ = z;
				if (!(_tmp89_ < 1000)) {
					break;
				}
				_tmp91_ = z;
				_tmp92_ = i;
				_tmp91_->im_fraction[_tmp92_] = 0;
				_tmp93_ = _tmp91_->im_fraction[_tmp92_];
			}
		}
	}
	mp_normalize (&z);
	result = z;
	return result;
}


static Number* number_reciprocal_real (Number* self) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint t = 0;
	gint it0 = 0;
	gint _tmp12_ = 0;
	Number* t2 = NULL;
	gboolean _tmp35_ = FALSE;
	Number* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		_tmp1_ = _ ("Reciprocal of zero is undefined");
		mperr (_tmp1_);
		_tmp2_ = number_new_integer ((gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = number_copy (self);
	t1 = _tmp3_;
	_tmp4_ = t1;
	_tmp4_->re_exponent = 0;
	_tmp5_ = t1;
	_tmp6_ = number_to_double (_tmp5_);
	_tmp7_ = number_new_double (1.0 / _tmp6_);
	_g_object_unref0 (t1);
	t1 = _tmp7_;
	_tmp8_ = t1;
	_tmp9_ = t1;
	_tmp10_ = _tmp9_->re_exponent;
	_tmp11_ = self->re_exponent;
	_tmp9_->re_exponent = _tmp10_ - _tmp11_;
	t = 3;
	_tmp12_ = t;
	it0 = _tmp12_;
	while (TRUE) {
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gint ts3 = 0;
		gint _tmp26_ = 0;
		gint ts2 = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		_tmp13_ = t1;
		_tmp14_ = number_multiply (self, _tmp13_);
		_g_object_unref0 (t2);
		t2 = _tmp14_;
		_tmp15_ = t2;
		_tmp16_ = number_new_integer ((gint64) (-1));
		_tmp17_ = _tmp16_;
		_tmp18_ = number_add (_tmp15_, _tmp17_);
		_g_object_unref0 (t2);
		t2 = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_tmp19_ = t1;
		_tmp20_ = t2;
		_tmp21_ = number_multiply (_tmp19_, _tmp20_);
		_g_object_unref0 (t2);
		t2 = _tmp21_;
		_tmp22_ = t1;
		_tmp23_ = t2;
		_tmp24_ = number_subtract (_tmp22_, _tmp23_);
		_g_object_unref0 (t1);
		t1 = _tmp24_;
		_tmp25_ = t;
		if (_tmp25_ >= T) {
			break;
		}
		_tmp26_ = t;
		ts3 = _tmp26_;
		ts2 = 0;
		t = T;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				if (!_tmp27_) {
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp28_ = t;
					_tmp29_ = ts3;
					if (!(_tmp28_ > _tmp29_)) {
						break;
					}
				}
				_tmp27_ = FALSE;
				_tmp30_ = t;
				ts2 = _tmp30_;
				_tmp31_ = t;
				_tmp32_ = it0;
				t = (_tmp31_ + _tmp32_) / 2;
			}
		}
		_tmp33_ = ts2;
		_tmp34_ = MIN (_tmp33_, T);
		t = _tmp34_;
	}
	_tmp36_ = t2;
	_tmp37_ = _tmp36_->re_sign;
	if (_tmp37_ != 0) {
		Number* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		Number* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		_tmp38_ = t1;
		_tmp39_ = _tmp38_->re_exponent;
		_tmp40_ = t2;
		_tmp41_ = _tmp40_->re_exponent;
		_tmp42_ = it0;
		_tmp35_ = ((_tmp39_ - _tmp41_) << 1) < (T - _tmp42_);
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		mperr ("*** ERROR OCCURRED IN RECIPROCAL, NEWTON ITERATION NOT CONVERGING PROP" \
"ERLY ***");
	}
	result = t1;
	_g_object_unref0 (t2);
	return result;
}


static Number* number_divide_integer_real (Number* self, gint64 y) {
	Number* result = NULL;
	gint64 _tmp0_ = 0LL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gint64 _tmp6_ = 0LL;
	Number* z = NULL;
	Number* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	Number* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint64 c = 0LL;
	gint64 i = 0LL;
	gint b2 = 0;
	gint _tmp20_ = 0;
	gint64 _tmp21_ = 0LL;
	gint _tmp22_ = 0;
	gint64 j1 = 0LL;
	gint64 _tmp83_ = 0LL;
	gint64 j2 = 0LL;
	gint64 _tmp84_ = 0LL;
	gint64 _tmp85_ = 0LL;
	gint c2 = 0;
	Number* _tmp102_ = NULL;
	Number* _tmp103_ = NULL;
	gint _tmp104_ = 0;
	gint64 _tmp105_ = 0LL;
	gint64 _tmp106_ = 0LL;
	Number* _tmp144_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = y;
	if (_tmp0_ == ((gint64) 0)) {
		const gchar* _tmp1_ = NULL;
		Number* _tmp2_ = NULL;
		_tmp1_ = _ ("Division by zero is undefined");
		mperr (_tmp1_);
		_tmp2_ = number_new_integer ((gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = number_is_zero (self);
	if (_tmp3_) {
		Number* _tmp4_ = NULL;
		_tmp4_ = number_new_integer ((gint64) 0);
		result = _tmp4_;
		return result;
	}
	_tmp6_ = y;
	if (_tmp6_ == ((gint64) 1)) {
		_tmp5_ = TRUE;
	} else {
		gint64 _tmp7_ = 0LL;
		_tmp7_ = y;
		_tmp5_ = _tmp7_ == ((gint64) (-1));
	}
	if (_tmp5_) {
		gint64 _tmp8_ = 0LL;
		_tmp8_ = y;
		if (_tmp8_ < ((gint64) 0)) {
			Number* _tmp9_ = NULL;
			_tmp9_ = number_invert_sign (self);
			result = _tmp9_;
			return result;
		} else {
			Number* _tmp10_ = NULL;
			_tmp10_ = _g_object_ref0 (self);
			result = _tmp10_;
			return result;
		}
	}
	_tmp11_ = number_new_integer ((gint64) 0);
	z = _tmp11_;
	_tmp12_ = y;
	if (_tmp12_ < ((gint64) 0)) {
		gint64 _tmp13_ = 0LL;
		Number* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		_tmp13_ = y;
		y = -_tmp13_;
		_tmp14_ = z;
		_tmp15_ = self->re_sign;
		_tmp14_->re_sign = -_tmp15_;
	} else {
		Number* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp16_ = z;
		_tmp17_ = self->re_sign;
		_tmp16_->re_sign = _tmp17_;
	}
	_tmp18_ = z;
	_tmp19_ = self->re_exponent;
	_tmp18_->re_exponent = _tmp19_;
	c = (gint64) 0;
	i = (gint64) 0;
	_tmp20_ = MAX (BASE << 3, 32767 / BASE);
	b2 = _tmp20_;
	_tmp21_ = y;
	_tmp22_ = b2;
	if (_tmp21_ < ((gint64) _tmp22_)) {
		gint64 r1 = 0LL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint64 _tmp38_ = 0LL;
		Number* _tmp39_ = NULL;
		gint64 _tmp40_ = 0LL;
		gint _tmp41_ = 0;
		gint64 _tmp42_ = 0LL;
		gint64 _tmp43_ = 0LL;
		gint64 _tmp44_ = 0LL;
		gint64 kh = 0LL;
		gint64 _tmp45_ = 0LL;
		gint64 _tmp81_ = 0LL;
		r1 = (gint64) 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				gint64 _tmp25_ = 0LL;
				gint64 _tmp26_ = 0LL;
				gint64 _tmp30_ = 0LL;
				gint64 _tmp31_ = 0LL;
				gint64 _tmp32_ = 0LL;
				gint64 _tmp33_ = 0LL;
				if (!_tmp23_) {
					gint64 _tmp24_ = 0LL;
					_tmp24_ = r1;
					if (!(_tmp24_ == ((gint64) 0))) {
						break;
					}
				}
				_tmp23_ = FALSE;
				_tmp25_ = c;
				c = BASE * _tmp25_;
				_tmp26_ = i;
				if (_tmp26_ < ((gint64) T)) {
					gint64 _tmp27_ = 0LL;
					gint64 _tmp28_ = 0LL;
					gint _tmp29_ = 0;
					_tmp27_ = c;
					_tmp28_ = i;
					_tmp29_ = self->re_fraction[_tmp28_];
					c = _tmp27_ + _tmp29_;
				}
				_tmp30_ = i;
				i = _tmp30_ + 1;
				_tmp31_ = c;
				_tmp32_ = y;
				r1 = _tmp31_ / _tmp32_;
				_tmp33_ = r1;
				if (_tmp33_ < ((gint64) 0)) {
					Number* _tmp34_ = NULL;
					mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
					_tmp34_ = number_new_integer ((gint64) 0);
					result = _tmp34_;
					_g_object_unref0 (z);
					return result;
				}
			}
		}
		_tmp35_ = z;
		_tmp36_ = z;
		_tmp37_ = _tmp36_->re_exponent;
		_tmp38_ = i;
		_tmp36_->re_exponent = _tmp37_ + ((gint) (1 - _tmp38_));
		_tmp39_ = z;
		_tmp40_ = r1;
		_tmp39_->re_fraction[0] = (gint) _tmp40_;
		_tmp41_ = _tmp39_->re_fraction[0];
		_tmp42_ = c;
		_tmp43_ = y;
		_tmp44_ = r1;
		c = BASE * (_tmp42_ - (_tmp43_ * _tmp44_));
		kh = (gint64) 1;
		_tmp45_ = i;
		if (_tmp45_ < ((gint64) T)) {
			gint64 _tmp46_ = 0LL;
			gint64 _tmp65_ = 0LL;
			_tmp46_ = i;
			kh = (T + 1) - _tmp46_;
			{
				gint k = 0;
				k = 1;
				{
					gboolean _tmp47_ = FALSE;
					_tmp47_ = TRUE;
					while (TRUE) {
						gint _tmp49_ = 0;
						gint64 _tmp50_ = 0LL;
						gint64 _tmp51_ = 0LL;
						gint64 _tmp52_ = 0LL;
						gint _tmp53_ = 0;
						Number* _tmp54_ = NULL;
						gint _tmp55_ = 0;
						gint64 _tmp56_ = 0LL;
						gint64 _tmp57_ = 0LL;
						gint _tmp58_ = 0;
						gint64 _tmp59_ = 0LL;
						gint64 _tmp60_ = 0LL;
						Number* _tmp61_ = NULL;
						gint _tmp62_ = 0;
						gint _tmp63_ = 0;
						gint64 _tmp64_ = 0LL;
						if (!_tmp47_) {
							gint _tmp48_ = 0;
							_tmp48_ = k;
							k = _tmp48_ + 1;
						}
						_tmp47_ = FALSE;
						_tmp49_ = k;
						_tmp50_ = kh;
						if (!(((gint64) _tmp49_) < _tmp50_)) {
							break;
						}
						_tmp51_ = c;
						_tmp52_ = i;
						_tmp53_ = self->re_fraction[_tmp52_];
						c = _tmp51_ + _tmp53_;
						_tmp54_ = z;
						_tmp55_ = k;
						_tmp56_ = c;
						_tmp57_ = y;
						_tmp54_->re_fraction[_tmp55_] = (gint) (_tmp56_ / _tmp57_);
						_tmp58_ = _tmp54_->re_fraction[_tmp55_];
						_tmp59_ = c;
						_tmp60_ = y;
						_tmp61_ = z;
						_tmp62_ = k;
						_tmp63_ = _tmp61_->re_fraction[_tmp62_];
						c = BASE * (_tmp59_ - (_tmp60_ * _tmp63_));
						_tmp64_ = i;
						i = _tmp64_ + 1;
					}
				}
			}
			_tmp65_ = c;
			if (_tmp65_ < ((gint64) 0)) {
				Number* _tmp66_ = NULL;
				mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
				_tmp66_ = number_new_integer ((gint64) 0);
				result = _tmp66_;
				_g_object_unref0 (z);
				return result;
			}
		}
		{
			gint64 k = 0LL;
			gint64 _tmp67_ = 0LL;
			_tmp67_ = kh;
			k = _tmp67_;
			{
				gboolean _tmp68_ = FALSE;
				_tmp68_ = TRUE;
				while (TRUE) {
					gint64 _tmp70_ = 0LL;
					Number* _tmp71_ = NULL;
					gint64 _tmp72_ = 0LL;
					gint64 _tmp73_ = 0LL;
					gint64 _tmp74_ = 0LL;
					gint _tmp75_ = 0;
					gint64 _tmp76_ = 0LL;
					gint64 _tmp77_ = 0LL;
					Number* _tmp78_ = NULL;
					gint64 _tmp79_ = 0LL;
					gint _tmp80_ = 0;
					if (!_tmp68_) {
						gint64 _tmp69_ = 0LL;
						_tmp69_ = k;
						k = _tmp69_ + 1;
					}
					_tmp68_ = FALSE;
					_tmp70_ = k;
					if (!(_tmp70_ < ((gint64) (T + 4)))) {
						break;
					}
					_tmp71_ = z;
					_tmp72_ = k;
					_tmp73_ = c;
					_tmp74_ = y;
					_tmp71_->re_fraction[_tmp72_] = (gint) (_tmp73_ / _tmp74_);
					_tmp75_ = _tmp71_->re_fraction[_tmp72_];
					_tmp76_ = c;
					_tmp77_ = y;
					_tmp78_ = z;
					_tmp79_ = k;
					_tmp80_ = _tmp78_->re_fraction[_tmp79_];
					c = BASE * (_tmp76_ - (_tmp77_ * _tmp80_));
				}
			}
		}
		_tmp81_ = c;
		if (_tmp81_ < ((gint64) 0)) {
			Number* _tmp82_ = NULL;
			mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
			_tmp82_ = number_new_integer ((gint64) 0);
			result = _tmp82_;
			_g_object_unref0 (z);
			return result;
		}
		mp_normalize (&z);
		result = z;
		return result;
	}
	_tmp83_ = y;
	j1 = _tmp83_ / BASE;
	_tmp84_ = y;
	_tmp85_ = j1;
	j2 = _tmp84_ - (_tmp85_ * BASE);
	c2 = 0;
	{
		gboolean _tmp86_ = FALSE;
		_tmp86_ = TRUE;
		while (TRUE) {
			gint64 _tmp95_ = 0LL;
			gint _tmp96_ = 0;
			gint _tmp97_ = 0;
			gint64 _tmp98_ = 0LL;
			gint64 _tmp101_ = 0LL;
			if (!_tmp86_) {
				gboolean _tmp87_ = FALSE;
				gint64 _tmp88_ = 0LL;
				gint64 _tmp89_ = 0LL;
				_tmp88_ = c;
				_tmp89_ = j1;
				if (_tmp88_ < _tmp89_) {
					_tmp87_ = TRUE;
				} else {
					gboolean _tmp90_ = FALSE;
					gint64 _tmp91_ = 0LL;
					gint64 _tmp92_ = 0LL;
					_tmp91_ = c;
					_tmp92_ = j1;
					if (_tmp91_ == _tmp92_) {
						gint _tmp93_ = 0;
						gint64 _tmp94_ = 0LL;
						_tmp93_ = c2;
						_tmp94_ = j2;
						_tmp90_ = ((gint64) _tmp93_) < _tmp94_;
					} else {
						_tmp90_ = FALSE;
					}
					_tmp87_ = _tmp90_;
				}
				if (!_tmp87_) {
					break;
				}
			}
			_tmp86_ = FALSE;
			_tmp95_ = c;
			_tmp96_ = c2;
			c = (BASE * _tmp95_) + _tmp96_;
			_tmp98_ = i;
			if (_tmp98_ < ((gint64) T)) {
				gint64 _tmp99_ = 0LL;
				gint _tmp100_ = 0;
				_tmp99_ = i;
				_tmp100_ = self->re_fraction[_tmp99_];
				_tmp97_ = _tmp100_;
			} else {
				_tmp97_ = 0;
			}
			c2 = _tmp97_;
			_tmp101_ = i;
			i = _tmp101_ + 1;
		}
	}
	_tmp102_ = z;
	_tmp103_ = z;
	_tmp104_ = _tmp103_->re_exponent;
	_tmp105_ = i;
	_tmp103_->re_exponent = _tmp104_ + ((gint) (1 - _tmp105_));
	_tmp106_ = i;
	i = _tmp106_ - 1;
	{
		gint k = 0;
		k = 1;
		{
			gboolean _tmp107_ = FALSE;
			_tmp107_ = TRUE;
			while (TRUE) {
				gint _tmp109_ = 0;
				gint64 ir = 0LL;
				gint64 _tmp110_ = 0LL;
				gint64 _tmp111_ = 0LL;
				gint64 iq = 0LL;
				gint64 _tmp112_ = 0LL;
				gint64 _tmp113_ = 0LL;
				gint64 _tmp114_ = 0LL;
				gint64 _tmp115_ = 0LL;
				gint _tmp116_ = 0;
				gint64 _tmp120_ = 0LL;
				gint64 _tmp121_ = 0LL;
				gint64 _tmp122_ = 0LL;
				gint64 _tmp123_ = 0LL;
				gint64 _tmp127_ = 0LL;
				gint64 _tmp131_ = 0LL;
				gint64 iqj = 0LL;
				gint64 _tmp132_ = 0LL;
				gint64 _tmp133_ = 0LL;
				Number* _tmp134_ = NULL;
				gint _tmp135_ = 0;
				gint64 _tmp136_ = 0LL;
				gint64 _tmp137_ = 0LL;
				gint _tmp138_ = 0;
				gint64 _tmp139_ = 0LL;
				gint64 _tmp140_ = 0LL;
				gint64 _tmp141_ = 0LL;
				gint64 _tmp142_ = 0LL;
				if (!_tmp107_) {
					gint _tmp108_ = 0;
					_tmp108_ = k;
					k = _tmp108_ + 1;
				}
				_tmp107_ = FALSE;
				_tmp109_ = k;
				if (!(_tmp109_ <= (T + 4))) {
					break;
				}
				_tmp110_ = c;
				_tmp111_ = j1;
				ir = _tmp110_ / (_tmp111_ + 1);
				_tmp112_ = c;
				_tmp113_ = ir;
				_tmp114_ = j1;
				iq = _tmp112_ - (_tmp113_ * _tmp114_);
				_tmp115_ = iq;
				_tmp116_ = b2;
				if (_tmp115_ >= ((gint64) _tmp116_)) {
					gint64 _tmp117_ = 0LL;
					gint64 _tmp118_ = 0LL;
					gint64 _tmp119_ = 0LL;
					_tmp117_ = ir;
					ir = _tmp117_ + 1;
					_tmp118_ = iq;
					_tmp119_ = j1;
					iq = _tmp118_ - _tmp119_;
				}
				_tmp120_ = iq;
				_tmp121_ = ir;
				_tmp122_ = j2;
				iq = (_tmp120_ * BASE) - (_tmp121_ * _tmp122_);
				_tmp123_ = iq;
				if (_tmp123_ < ((gint64) 0)) {
					gint64 _tmp124_ = 0LL;
					gint64 _tmp125_ = 0LL;
					gint64 _tmp126_ = 0LL;
					_tmp124_ = ir;
					ir = _tmp124_ - 1;
					_tmp125_ = iq;
					_tmp126_ = y;
					iq = _tmp125_ + _tmp126_;
				}
				_tmp127_ = i;
				if (_tmp127_ < ((gint64) T)) {
					gint64 _tmp128_ = 0LL;
					gint64 _tmp129_ = 0LL;
					gint _tmp130_ = 0;
					_tmp128_ = iq;
					_tmp129_ = i;
					_tmp130_ = self->re_fraction[_tmp129_];
					iq = _tmp128_ + _tmp130_;
				}
				_tmp131_ = i;
				i = _tmp131_ + 1;
				_tmp132_ = iq;
				_tmp133_ = y;
				iqj = _tmp132_ / _tmp133_;
				_tmp134_ = z;
				_tmp135_ = k;
				_tmp136_ = iqj;
				_tmp137_ = ir;
				_tmp134_->re_fraction[_tmp135_ - 1] = (gint) (_tmp136_ + _tmp137_);
				_tmp138_ = _tmp134_->re_fraction[_tmp135_ - 1];
				_tmp139_ = iq;
				_tmp140_ = y;
				_tmp141_ = iqj;
				c = _tmp139_ - (_tmp140_ * _tmp141_);
				_tmp142_ = c;
				if (_tmp142_ < ((gint64) 0)) {
					Number* _tmp143_ = NULL;
					mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
					_tmp143_ = number_new_integer ((gint64) 0);
					result = _tmp143_;
					_g_object_unref0 (z);
					return result;
				}
			}
		}
	}
	mp_normalize (&z);
	mperr ("*** INTEGER OVERFLOW IN DIVIDE_INTEGER, B TOO LARGE ***");
	_tmp144_ = number_new_integer ((gint64) 0);
	result = _tmp144_;
	_g_object_unref0 (z);
	return result;
}


static Number* number_from_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	switch (_tmp0_) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			Number* _tmp1_ = NULL;
			_tmp1_ = _g_object_ref0 (self);
			result = _tmp1_;
			return result;
		}
		case ANGLE_UNIT_DEGREES:
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
			_tmp2_ = number_multiply_integer (self, (gint64) 180);
			_tmp3_ = _tmp2_;
			_tmp4_ = number_new_pi ();
			_tmp5_ = _tmp4_;
			_tmp6_ = number_divide (_tmp3_, _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp3_);
			result = _tmp7_;
			return result;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
			_tmp8_ = number_multiply_integer (self, (gint64) 200);
			_tmp9_ = _tmp8_;
			_tmp10_ = number_new_pi ();
			_tmp11_ = _tmp10_;
			_tmp12_ = number_divide (_tmp9_, _tmp11_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (_tmp9_);
			result = _tmp13_;
			return result;
		}
	}
}


static Number* number_to_radians (Number* self, AngleUnit unit) {
	Number* result = NULL;
	AngleUnit _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unit;
	switch (_tmp0_) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			Number* _tmp1_ = NULL;
			_tmp1_ = _g_object_ref0 (self);
			result = _tmp1_;
			return result;
		}
		case ANGLE_UNIT_DEGREES:
		{
			Number* _tmp2_ = NULL;
			Number* _tmp3_ = NULL;
			Number* _tmp4_ = NULL;
			Number* _tmp5_ = NULL;
			Number* _tmp6_ = NULL;
			Number* _tmp7_ = NULL;
			_tmp2_ = number_new_pi ();
			_tmp3_ = _tmp2_;
			_tmp4_ = number_multiply (self, _tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = number_divide_integer (_tmp5_, (gint64) 180);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_g_object_unref0 (_tmp3_);
			result = _tmp7_;
			return result;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			Number* _tmp8_ = NULL;
			Number* _tmp9_ = NULL;
			Number* _tmp10_ = NULL;
			Number* _tmp11_ = NULL;
			Number* _tmp12_ = NULL;
			Number* _tmp13_ = NULL;
			_tmp8_ = number_new_pi ();
			_tmp9_ = _tmp8_;
			_tmp10_ = number_multiply (self, _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = number_divide_integer (_tmp11_, (gint64) 200);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (_tmp9_);
			result = _tmp13_;
			return result;
		}
	}
}


static Number* number_sin1 (Number* self, gboolean do_sin) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t2 = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
	Number* t1 = NULL;
	gint i = 0;
	Number* z = NULL;
	gboolean _tmp10_ = FALSE;
	gint b2 = 0;
	gint _tmp16_ = 0;
	gboolean _tmp41_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = do_sin;
		if (_tmp1_) {
			Number* _tmp2_ = NULL;
			_tmp2_ = number_new_integer ((gint64) 0);
			result = _tmp2_;
			return result;
		} else {
			Number* _tmp3_ = NULL;
			_tmp3_ = number_new_integer ((gint64) 1);
			result = _tmp3_;
			return result;
		}
	}
	_tmp4_ = number_multiply (self, self);
	t2 = _tmp4_;
	_tmp5_ = t2;
	_tmp6_ = number_new_integer ((gint64) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_compare (_tmp5_, _tmp7_);
	_tmp9_ = _tmp8_ > 0;
	_g_object_unref0 (_tmp7_);
	if (_tmp9_) {
		mperr ("*** ABS (X) > 1 IN CALL TO SIN1 ***");
	}
	_tmp10_ = do_sin;
	if (_tmp10_) {
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		_tmp11_ = _g_object_ref0 (self);
		_g_object_unref0 (t1);
		t1 = _tmp11_;
		_tmp12_ = t1;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (z);
		z = _tmp13_;
		i = 2;
	} else {
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		_tmp14_ = number_new_integer ((gint64) 1);
		_g_object_unref0 (t1);
		t1 = _tmp14_;
		_tmp15_ = number_new_integer ((gint64) 0);
		_g_object_unref0 (z);
		z = _tmp15_;
		i = 1;
	}
	_tmp16_ = MAX (BASE, 64);
	b2 = 2 * _tmp16_;
	{
		gboolean _tmp17_ = FALSE;
		_tmp17_ = TRUE;
		while (TRUE) {
			Number* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			Number* _tmp22_ = NULL;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			Number* _tmp37_ = NULL;
			Number* _tmp38_ = NULL;
			Number* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			if (!_tmp17_) {
				Number* _tmp18_ = NULL;
				gint _tmp19_ = 0;
				_tmp18_ = t1;
				_tmp19_ = _tmp18_->re_sign;
				if (!(_tmp19_ != 0)) {
					break;
				}
			}
			_tmp17_ = FALSE;
			_tmp20_ = t1;
			_tmp21_ = _tmp20_->re_exponent;
			if ((T + _tmp21_) <= 0) {
				break;
			}
			_tmp22_ = t2;
			_tmp23_ = t1;
			_tmp24_ = number_multiply (_tmp22_, _tmp23_);
			_g_object_unref0 (t1);
			t1 = _tmp24_;
			_tmp25_ = i;
			_tmp26_ = b2;
			if (_tmp25_ > _tmp26_) {
				Number* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				Number* _tmp29_ = NULL;
				Number* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				Number* _tmp32_ = NULL;
				_tmp27_ = t1;
				_tmp28_ = i;
				_tmp29_ = number_divide_integer (_tmp27_, (gint64) (-_tmp28_));
				_g_object_unref0 (t1);
				t1 = _tmp29_;
				_tmp30_ = t1;
				_tmp31_ = i;
				_tmp32_ = number_divide_integer (_tmp30_, (gint64) (_tmp31_ + 1));
				_g_object_unref0 (t1);
				t1 = _tmp32_;
			} else {
				Number* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				Number* _tmp36_ = NULL;
				_tmp33_ = t1;
				_tmp34_ = i;
				_tmp35_ = i;
				_tmp36_ = number_divide_integer (_tmp33_, (gint64) ((-_tmp34_) * (_tmp35_ + 1)));
				_g_object_unref0 (t1);
				t1 = _tmp36_;
			}
			_tmp37_ = t1;
			_tmp38_ = z;
			_tmp39_ = number_add (_tmp37_, _tmp38_);
			_g_object_unref0 (z);
			z = _tmp39_;
			_tmp40_ = i;
			i = _tmp40_ + 2;
		}
	}
	_tmp41_ = do_sin;
	if (!_tmp41_) {
		Number* _tmp42_ = NULL;
		Number* _tmp43_ = NULL;
		Number* _tmp44_ = NULL;
		Number* _tmp45_ = NULL;
		_tmp42_ = z;
		_tmp43_ = number_new_integer ((gint64) 1);
		_tmp44_ = _tmp43_;
		_tmp45_ = number_add (_tmp42_, _tmp44_);
		_g_object_unref0 (z);
		z = _tmp45_;
		_g_object_unref0 (_tmp44_);
	}
	result = z;
	_g_object_unref0 (t1);
	_g_object_unref0 (t2);
	return result;
}


static Number* number_sin_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* x_radians = NULL;
	AngleUnit _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	gint xs = 0;
	Number* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* z = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gboolean _tmp12_ = FALSE;
	Number* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 0);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = unit;
	_tmp3_ = number_to_radians (self, _tmp2_);
	x_radians = _tmp3_;
	_tmp4_ = x_radians;
	_tmp5_ = _tmp4_->re_sign;
	xs = _tmp5_;
	_tmp6_ = x_radians;
	_tmp7_ = number_abs (_tmp6_);
	_g_object_unref0 (x_radians);
	x_radians = _tmp7_;
	_tmp8_ = x_radians;
	_tmp9_ = number_new_integer ((gint64) 1);
	_tmp10_ = _tmp9_;
	_tmp11_ = number_compare (_tmp8_, _tmp10_);
	_tmp12_ = _tmp11_ <= 0;
	_g_object_unref0 (_tmp10_);
	if (_tmp12_) {
		Number* _tmp13_ = NULL;
		Number* _tmp14_ = NULL;
		_tmp13_ = x_radians;
		_tmp14_ = number_sin1 (_tmp13_, TRUE);
		_g_object_unref0 (z);
		z = _tmp14_;
	} else {
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		Number* _tmp23_ = NULL;
		Number* _tmp24_ = NULL;
		Number* _tmp25_ = NULL;
		Number* _tmp26_ = NULL;
		Number* _tmp27_ = NULL;
		Number* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		Number* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		Number* _tmp34_ = NULL;
		Number* _tmp35_ = NULL;
		Number* _tmp36_ = NULL;
		Number* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		Number* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		Number* _tmp46_ = NULL;
		Number* _tmp47_ = NULL;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		_tmp15_ = number_new_pi ();
		_tmp16_ = _tmp15_;
		_tmp17_ = number_divide_integer (_tmp16_, (gint64) 4);
		_g_object_unref0 (z);
		z = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_tmp18_ = x_radians;
		_tmp19_ = z;
		_tmp20_ = number_divide (_tmp18_, _tmp19_);
		_g_object_unref0 (x_radians);
		x_radians = _tmp20_;
		_tmp21_ = x_radians;
		_tmp22_ = number_divide_integer (_tmp21_, (gint64) 8);
		_g_object_unref0 (x_radians);
		x_radians = _tmp22_;
		_tmp23_ = x_radians;
		_tmp24_ = number_fractional_component (_tmp23_);
		_g_object_unref0 (x_radians);
		x_radians = _tmp24_;
		_tmp25_ = x_radians;
		_tmp26_ = number_new_fraction ((gint64) (-1), (gint64) 2);
		_tmp27_ = _tmp26_;
		_tmp28_ = number_add (_tmp25_, _tmp27_);
		_g_object_unref0 (x_radians);
		x_radians = _tmp28_;
		_g_object_unref0 (_tmp27_);
		_tmp29_ = xs;
		_tmp30_ = x_radians;
		_tmp31_ = _tmp30_->re_sign;
		xs = (-_tmp29_) * _tmp31_;
		_tmp32_ = xs;
		if (_tmp32_ == 0) {
			Number* _tmp33_ = NULL;
			_tmp33_ = number_new_integer ((gint64) 0);
			result = _tmp33_;
			_g_object_unref0 (z);
			_g_object_unref0 (x_radians);
			return result;
		}
		_tmp34_ = x_radians;
		_tmp34_->re_sign = 1;
		_tmp35_ = x_radians;
		_tmp36_ = number_multiply_integer (_tmp35_, (gint64) 4);
		_g_object_unref0 (x_radians);
		x_radians = _tmp36_;
		_tmp37_ = x_radians;
		_tmp38_ = _tmp37_->re_exponent;
		if (_tmp38_ > 0) {
			Number* _tmp39_ = NULL;
			Number* _tmp40_ = NULL;
			Number* _tmp41_ = NULL;
			Number* _tmp42_ = NULL;
			_tmp39_ = x_radians;
			_tmp40_ = number_new_integer ((gint64) (-2));
			_tmp41_ = _tmp40_;
			_tmp42_ = number_add (_tmp39_, _tmp41_);
			_g_object_unref0 (x_radians);
			x_radians = _tmp42_;
			_g_object_unref0 (_tmp41_);
		}
		_tmp43_ = x_radians;
		_tmp44_ = number_is_zero (_tmp43_);
		if (_tmp44_) {
			Number* _tmp45_ = NULL;
			_tmp45_ = number_new_integer ((gint64) 0);
			result = _tmp45_;
			_g_object_unref0 (z);
			_g_object_unref0 (x_radians);
			return result;
		}
		_tmp46_ = x_radians;
		_tmp46_->re_sign = 1;
		_tmp47_ = x_radians;
		_tmp48_ = number_multiply_integer (_tmp47_, (gint64) 2);
		_g_object_unref0 (x_radians);
		x_radians = _tmp48_;
		_tmp49_ = x_radians;
		_tmp50_ = _tmp49_->re_exponent;
		if (_tmp50_ > 0) {
			Number* _tmp51_ = NULL;
			Number* _tmp52_ = NULL;
			Number* _tmp53_ = NULL;
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			Number* _tmp56_ = NULL;
			Number* _tmp57_ = NULL;
			Number* _tmp58_ = NULL;
			Number* _tmp59_ = NULL;
			_tmp51_ = x_radians;
			_tmp52_ = number_new_integer ((gint64) (-2));
			_tmp53_ = _tmp52_;
			_tmp54_ = number_add (_tmp51_, _tmp53_);
			_g_object_unref0 (x_radians);
			x_radians = _tmp54_;
			_g_object_unref0 (_tmp53_);
			_tmp55_ = x_radians;
			_tmp56_ = z;
			_tmp57_ = number_multiply (_tmp55_, _tmp56_);
			_g_object_unref0 (x_radians);
			x_radians = _tmp57_;
			_tmp58_ = x_radians;
			_tmp59_ = number_sin1 (_tmp58_, FALSE);
			_g_object_unref0 (z);
			z = _tmp59_;
		} else {
			Number* _tmp60_ = NULL;
			Number* _tmp61_ = NULL;
			Number* _tmp62_ = NULL;
			Number* _tmp63_ = NULL;
			Number* _tmp64_ = NULL;
			_tmp60_ = x_radians;
			_tmp61_ = z;
			_tmp62_ = number_multiply (_tmp60_, _tmp61_);
			_g_object_unref0 (x_radians);
			x_radians = _tmp62_;
			_tmp63_ = x_radians;
			_tmp64_ = number_sin1 (_tmp63_, TRUE);
			_g_object_unref0 (z);
			z = _tmp64_;
		}
	}
	_tmp65_ = z;
	_tmp66_ = xs;
	_tmp65_->re_sign = _tmp66_;
	result = z;
	_g_object_unref0 (x_radians);
	return result;
}


static Number* number_cos_real (Number* self, AngleUnit unit) {
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* z = NULL;
	AngleUnit _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_is_zero (self);
	if (_tmp0_) {
		Number* _tmp1_ = NULL;
		_tmp1_ = number_new_integer ((gint64) 1);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = unit;
	_tmp3_ = number_to_radians (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = number_abs (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	z = _tmp6_;
	_tmp7_ = z;
	_tmp8_ = number_new_integer ((gint64) 1);
	_tmp9_ = _tmp8_;
	_tmp10_ = number_compare (_tmp7_, _tmp9_);
	_tmp11_ = _tmp10_ <= 0;
	_g_object_unref0 (_tmp9_);
	if (_tmp11_) {
		Number* _tmp12_ = NULL;
		Number* _tmp13_ = NULL;
		_tmp12_ = z;
		_tmp13_ = number_sin1 (_tmp12_, FALSE);
		result = _tmp13_;
		_g_object_unref0 (z);
		return result;
	} else {
		Number* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		Number* _tmp16_ = NULL;
		Number* _tmp17_ = NULL;
		Number* _tmp18_ = NULL;
		Number* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		Number* _tmp21_ = NULL;
		Number* _tmp22_ = NULL;
		_tmp14_ = number_new_pi ();
		_tmp15_ = _tmp14_;
		_tmp16_ = number_divide_integer (_tmp15_, (gint64) 2);
		_tmp17_ = _tmp16_;
		_tmp18_ = z;
		_tmp19_ = number_subtract (_tmp17_, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = number_sin (_tmp20_, ANGLE_UNIT_RADIANS);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_g_object_unref0 (_tmp17_);
		_g_object_unref0 (_tmp15_);
		result = _tmp22_;
		_g_object_unref0 (z);
		return result;
	}
	_g_object_unref0 (z);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static Number* number_bitwise (Number* self, Number* y, BitwiseFunc bitwise_operator, void* bitwise_operator_target, gint wordlen) {
	Number* result = NULL;
	gchar* text1 = NULL;
	gchar* _tmp0_ = NULL;
	gchar* text2 = NULL;
	Number* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint offset1 = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint offset2 = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint offset_out = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp16_ = FALSE;
	gint _tmp17_ = 0;
	gchar* text_out = NULL;
	gint _tmp24_ = 0;
	gchar* _tmp25_ = NULL;
	gint text_out_length1 = 0;
	gint _text_out_size_ = 0;
	gchar* _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	Number* _tmp53_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_to_hex_string (self);
	text1 = _tmp0_;
	_tmp1_ = y;
	_tmp2_ = number_to_hex_string (_tmp1_);
	text2 = _tmp2_;
	_tmp3_ = text1;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	offset1 = _tmp5_ - 1;
	_tmp6_ = text2;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	offset2 = _tmp8_ - 1;
	_tmp9_ = wordlen;
	offset_out = (_tmp9_ / 4) - 1;
	_tmp10_ = offset_out;
	if (_tmp10_ <= 0) {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp12_ = offset1;
		_tmp13_ = offset2;
		if (_tmp12_ > _tmp13_) {
			gint _tmp14_ = 0;
			_tmp14_ = offset1;
			_tmp11_ = _tmp14_;
		} else {
			gint _tmp15_ = 0;
			_tmp15_ = offset2;
			_tmp11_ = _tmp15_;
		}
		offset_out = _tmp11_;
	}
	_tmp17_ = offset_out;
	if (_tmp17_ > 0) {
		gboolean _tmp18_ = FALSE;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		_tmp19_ = offset_out;
		_tmp20_ = offset1;
		if (_tmp19_ < _tmp20_) {
			_tmp18_ = TRUE;
		} else {
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			_tmp21_ = offset_out;
			_tmp22_ = offset2;
			_tmp18_ = _tmp21_ < _tmp22_;
		}
		_tmp16_ = _tmp18_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		Number* _tmp23_ = NULL;
		mperr ("Overflow. Try a bigger word size");
		_tmp23_ = number_new_integer ((gint64) 0);
		result = _tmp23_;
		_g_free0 (text2);
		_g_free0 (text1);
		return result;
	}
	_tmp24_ = offset_out;
	_tmp25_ = g_new0 (gchar, _tmp24_ + 1);
	text_out = _tmp25_;
	text_out_length1 = _tmp24_ + 1;
	_text_out_size_ = text_out_length1;
	{
		gchar* _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		gint _tmp27_ = 0;
		gchar _tmp28_ = '\0';
		gboolean _tmp29_ = FALSE;
		_tmp26_ = text_out;
		_tmp26__length1 = text_out_length1;
		_tmp27_ = offset_out;
		_tmp26_[_tmp27_ + 1] = '\0';
		_tmp28_ = _tmp26_[_tmp27_ + 1];
		_tmp29_ = TRUE;
		while (TRUE) {
			gint _tmp31_ = 0;
			gint v1 = 0;
			gint v2 = 0;
			static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
			gint _tmp32_ = 0;
			gint _tmp38_ = 0;
			gchar* _tmp44_ = NULL;
			gint _tmp44__length1 = 0;
			gint _tmp45_ = 0;
			BitwiseFunc _tmp46_ = NULL;
			void* _tmp46__target = NULL;
			gint _tmp47_ = 0;
			gint _tmp48_ = 0;
			gint _tmp49_ = 0;
			gchar _tmp50_ = '\0';
			gchar _tmp51_ = '\0';
			if (!_tmp29_) {
				gint _tmp30_ = 0;
				_tmp30_ = offset_out;
				offset_out = _tmp30_ - 1;
			}
			_tmp29_ = FALSE;
			_tmp31_ = offset_out;
			if (!(_tmp31_ >= 0)) {
				break;
			}
			v1 = 0;
			v2 = 0;
			_tmp32_ = offset1;
			if (_tmp32_ >= 0) {
				const gchar* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				gchar _tmp35_ = '\0';
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				_tmp33_ = text1;
				_tmp34_ = offset1;
				_tmp35_ = string_get (_tmp33_, (glong) _tmp34_);
				_tmp36_ = number_hex_to_int (self, _tmp35_);
				v1 = _tmp36_;
				_tmp37_ = offset1;
				offset1 = _tmp37_ - 1;
			}
			_tmp38_ = offset2;
			if (_tmp38_ >= 0) {
				const gchar* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				gchar _tmp41_ = '\0';
				gint _tmp42_ = 0;
				gint _tmp43_ = 0;
				_tmp39_ = text2;
				_tmp40_ = offset2;
				_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
				_tmp42_ = number_hex_to_int (self, _tmp41_);
				v2 = _tmp42_;
				_tmp43_ = offset2;
				offset2 = _tmp43_ - 1;
			}
			_tmp44_ = text_out;
			_tmp44__length1 = text_out_length1;
			_tmp45_ = offset_out;
			_tmp46_ = bitwise_operator;
			_tmp46__target = bitwise_operator_target;
			_tmp47_ = v1;
			_tmp48_ = v2;
			_tmp49_ = _tmp46_ (_tmp47_, _tmp48_, _tmp46__target);
			_tmp50_ = digits[_tmp49_];
			_tmp44_[_tmp45_] = _tmp50_;
			_tmp51_ = _tmp44_[_tmp45_];
		}
	}
	_tmp52_ = text_out;
	_tmp52__length1 = text_out_length1;
	_tmp53_ = mp_set_from_string ((const gchar*) _tmp52_, 16);
	result = _tmp53_;
	text_out = (g_free (text_out), NULL);
	_g_free0 (text2);
	_g_free0 (text1);
	return result;
}


static gint number_hex_to_int (Number* self, gchar digit) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_ = '\0';
	gboolean _tmp4_ = FALSE;
	gchar _tmp5_ = '\0';
	gboolean _tmp8_ = FALSE;
	gchar _tmp9_ = '\0';
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = digit;
	if (_tmp1_ >= '0') {
		gchar _tmp2_ = '\0';
		_tmp2_ = digit;
		_tmp0_ = _tmp2_ <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar _tmp3_ = '\0';
		_tmp3_ = digit;
		result = (gint) (_tmp3_ - '0');
		return result;
	}
	_tmp5_ = digit;
	if (_tmp5_ >= 'A') {
		gchar _tmp6_ = '\0';
		_tmp6_ = digit;
		_tmp4_ = _tmp6_ <= 'F';
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar _tmp7_ = '\0';
		_tmp7_ = digit;
		result = (_tmp7_ - 'A') + 10;
		return result;
	}
	_tmp9_ = digit;
	if (_tmp9_ >= 'a') {
		gchar _tmp10_ = '\0';
		_tmp10_ = digit;
		_tmp8_ = _tmp10_ <= 'f';
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar _tmp11_ = '\0';
		_tmp11_ = digit;
		result = (_tmp11_ - 'a') + 10;
		return result;
	}
	result = 0;
	return result;
}


static gchar* number_to_hex_string (Number* self) {
	gchar* result = NULL;
	Serializer* serializer = NULL;
	Serializer* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
	serializer = _tmp0_;
	_tmp1_ = serializer_to_string (serializer, self);
	result = _tmp1_;
	_g_object_unref0 (serializer);
	return result;
}


Number* number_construct (GType object_type) {
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	return self;
}


Number* number_new (void) {
	return number_construct (TYPE_NUMBER);
}


static void number_class_init (NumberClass * klass) {
	number_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
}


static void number_instance_init (Number * self) {
}


static void number_finalize (GObject* obj) {
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
}


GType number_get_type (void) {
	static volatile gsize number_type_id__volatile = 0;
	if (g_once_init_enter (&number_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
		GType number_type_id;
		number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
		g_once_init_leave (&number_type_id__volatile, number_type_id);
	}
	return number_type_id__volatile;
}


void mperr (const gchar* text) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (mp_error);
	mp_error = _tmp1_;
}


gchar* mp_get_error (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = mp_error;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void mp_clear_error (void) {
	_g_free0 (mp_error);
	mp_error = NULL;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


Number* mp_set_from_string (const gchar* str, gint default_base) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	static const gunichar base_digits[] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	gint index = 0;
	gunichar c = 0U;
	gint end = 0;
	gint _tmp7_ = 0;
	gint number_base = 0;
	gint base_multiplier = 0;
	gint _tmp24_ = 0;
	gboolean negate = FALSE;
	const gchar* _tmp26_ = NULL;
	gunichar _tmp27_ = 0U;
	gunichar _tmp28_ = 0U;
	Number* z = NULL;
	Number* _tmp34_ = NULL;
	static const gunichar fractions[] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
	static const gint numerators[] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
	static const gint denominators[] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
	gboolean has_fraction = FALSE;
	const gchar* _tmp54_ = NULL;
	gunichar _tmp55_ = 0U;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp77_ = FALSE;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gboolean _tmp108_ = FALSE;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
	if (_tmp1_ >= 0) {
		const gchar* _tmp2_ = NULL;
		Number* _tmp3_ = NULL;
		_tmp2_ = str;
		_tmp3_ = set_from_sexagesimal (_tmp2_);
		result = _tmp3_;
		return result;
	}
	index = 0;
	while (TRUE) {
		const gchar* _tmp4_ = NULL;
		gunichar _tmp5_ = 0U;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = str;
		_tmp6_ = string_get_next_char (_tmp4_, &index, &_tmp5_);
		c = _tmp5_;
		if (!_tmp6_) {
			break;
		}
	}
	_tmp7_ = index;
	end = _tmp7_;
	number_base = 0;
	base_multiplier = 1;
	while (TRUE) {
		const gchar* _tmp8_ = NULL;
		gunichar _tmp9_ = 0U;
		gboolean _tmp10_ = FALSE;
		gint value = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp8_ = str;
		_tmp10_ = string_get_prev_char (_tmp8_, &index, &_tmp9_);
		c = _tmp9_;
		if (!_tmp10_) {
			break;
		}
		value = -1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint _tmp13_ = 0;
					gunichar _tmp14_ = 0U;
					gint _tmp15_ = 0;
					gunichar _tmp16_ = 0U;
					if (!_tmp11_) {
						gint _tmp12_ = 0;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp13_ = i;
					if (!(_tmp13_ < G_N_ELEMENTS (base_digits))) {
						break;
					}
					_tmp14_ = c;
					_tmp15_ = i;
					_tmp16_ = base_digits[_tmp15_];
					if (_tmp14_ == _tmp16_) {
						gint _tmp17_ = 0;
						_tmp17_ = i;
						value = _tmp17_;
						break;
					}
				}
			}
		}
		_tmp18_ = value;
		if (_tmp18_ < 0) {
			break;
		}
		_tmp19_ = index;
		end = _tmp19_;
		_tmp20_ = number_base;
		_tmp21_ = value;
		_tmp22_ = base_multiplier;
		number_base = _tmp20_ + (_tmp21_ * _tmp22_);
		_tmp23_ = base_multiplier;
		base_multiplier = _tmp23_ * 10;
	}
	_tmp24_ = base_multiplier;
	if (_tmp24_ == 1) {
		gint _tmp25_ = 0;
		_tmp25_ = default_base;
		number_base = _tmp25_;
	}
	negate = FALSE;
	index = 0;
	_tmp26_ = str;
	string_get_next_char (_tmp26_, &index, &_tmp27_);
	c = _tmp27_;
	_tmp28_ = c;
	if (_tmp28_ == ((gunichar) '+')) {
		negate = FALSE;
	} else {
		gboolean _tmp29_ = FALSE;
		gunichar _tmp30_ = 0U;
		_tmp30_ = c;
		if (_tmp30_ == ((gunichar) '-')) {
			_tmp29_ = TRUE;
		} else {
			gunichar _tmp31_ = 0U;
			_tmp31_ = c;
			_tmp29_ = _tmp31_ == 8722U;
		}
		if (_tmp29_) {
			negate = TRUE;
		} else {
			const gchar* _tmp32_ = NULL;
			gunichar _tmp33_ = 0U;
			_tmp32_ = str;
			string_get_prev_char (_tmp32_, &index, &_tmp33_);
			c = _tmp33_;
		}
	}
	_tmp34_ = number_new_integer ((gint64) 0);
	z = _tmp34_;
	while (TRUE) {
		const gchar* _tmp35_ = NULL;
		gunichar _tmp36_ = 0U;
		gboolean _tmp37_ = FALSE;
		gint i = 0;
		gunichar _tmp38_ = 0U;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Number* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		Number* _tmp48_ = NULL;
		Number* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		Number* _tmp51_ = NULL;
		Number* _tmp52_ = NULL;
		Number* _tmp53_ = NULL;
		_tmp35_ = str;
		_tmp37_ = string_get_next_char (_tmp35_, &index, &_tmp36_);
		c = _tmp36_;
		if (!_tmp37_) {
			break;
		}
		_tmp38_ = c;
		_tmp39_ = number_base;
		_tmp40_ = char_val (_tmp38_, _tmp39_);
		i = _tmp40_;
		_tmp41_ = i;
		_tmp42_ = number_base;
		if (_tmp41_ > _tmp42_) {
			result = NULL;
			_g_object_unref0 (z);
			return result;
		}
		_tmp43_ = i;
		if (_tmp43_ < 0) {
			const gchar* _tmp44_ = NULL;
			gunichar _tmp45_ = 0U;
			_tmp44_ = str;
			string_get_prev_char (_tmp44_, &index, &_tmp45_);
			c = _tmp45_;
			break;
		}
		_tmp46_ = z;
		_tmp47_ = number_base;
		_tmp48_ = number_multiply_integer (_tmp46_, (gint64) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = i;
		_tmp51_ = number_new_integer ((gint64) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = number_add (_tmp49_, _tmp52_);
		_g_object_unref0 (z);
		z = _tmp53_;
		_g_object_unref0 (_tmp52_);
		_g_object_unref0 (_tmp49_);
	}
	has_fraction = FALSE;
	_tmp54_ = str;
	_tmp56_ = string_get_next_char (_tmp54_, &index, &_tmp55_);
	c = _tmp55_;
	if (_tmp56_) {
		gunichar _tmp74_ = 0U;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp57_ = FALSE;
				_tmp57_ = TRUE;
				while (TRUE) {
					gint _tmp59_ = 0;
					gunichar _tmp60_ = 0U;
					gint _tmp61_ = 0;
					gunichar _tmp62_ = 0U;
					if (!_tmp57_) {
						gint _tmp58_ = 0;
						_tmp58_ = i;
						i = _tmp58_ + 1;
					}
					_tmp57_ = FALSE;
					_tmp59_ = i;
					if (!(_tmp59_ < G_N_ELEMENTS (fractions))) {
						break;
					}
					_tmp60_ = c;
					_tmp61_ = i;
					_tmp62_ = fractions[_tmp61_];
					if (_tmp60_ == _tmp62_) {
						Number* fraction = NULL;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
						Number* _tmp67_ = NULL;
						Number* _tmp68_ = NULL;
						Number* _tmp69_ = NULL;
						Number* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gunichar _tmp72_ = 0U;
						gboolean _tmp73_ = FALSE;
						_tmp63_ = i;
						_tmp64_ = numerators[_tmp63_];
						_tmp65_ = i;
						_tmp66_ = denominators[_tmp65_];
						_tmp67_ = number_new_fraction ((gint64) _tmp64_, (gint64) _tmp66_);
						fraction = _tmp67_;
						_tmp68_ = z;
						_tmp69_ = fraction;
						_tmp70_ = number_add (_tmp68_, _tmp69_);
						_g_object_unref0 (z);
						z = _tmp70_;
						_tmp71_ = str;
						_tmp73_ = string_get_next_char (_tmp71_, &index, &_tmp72_);
						c = _tmp72_;
						if (!_tmp73_) {
							result = z;
							_g_object_unref0 (fraction);
							return result;
						} else {
							result = NULL;
							_g_object_unref0 (fraction);
							_g_object_unref0 (z);
							return result;
						}
						_g_object_unref0 (fraction);
					}
				}
			}
		}
		_tmp74_ = c;
		if (_tmp74_ == ((gunichar) '.')) {
			has_fraction = TRUE;
		} else {
			const gchar* _tmp75_ = NULL;
			gunichar _tmp76_ = 0U;
			_tmp75_ = str;
			string_get_prev_char (_tmp75_, &index, &_tmp76_);
			c = _tmp76_;
		}
	}
	_tmp77_ = has_fraction;
	if (_tmp77_) {
		Number* numerator = NULL;
		Number* _tmp78_ = NULL;
		Number* denominator = NULL;
		Number* _tmp79_ = NULL;
		Number* _tmp100_ = NULL;
		Number* _tmp101_ = NULL;
		Number* _tmp102_ = NULL;
		Number* _tmp103_ = NULL;
		Number* _tmp104_ = NULL;
		Number* _tmp105_ = NULL;
		_tmp78_ = number_new_integer ((gint64) 0);
		numerator = _tmp78_;
		_tmp79_ = number_new_integer ((gint64) 1);
		denominator = _tmp79_;
		while (TRUE) {
			const gchar* _tmp80_ = NULL;
			gunichar _tmp81_ = 0U;
			gboolean _tmp82_ = FALSE;
			gint i = 0;
			gunichar _tmp83_ = 0U;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
			gint _tmp86_ = 0;
			Number* _tmp89_ = NULL;
			gint _tmp90_ = 0;
			Number* _tmp91_ = NULL;
			Number* _tmp92_ = NULL;
			gint _tmp93_ = 0;
			Number* _tmp94_ = NULL;
			Number* _tmp95_ = NULL;
			gint _tmp96_ = 0;
			Number* _tmp97_ = NULL;
			Number* _tmp98_ = NULL;
			Number* _tmp99_ = NULL;
			_tmp80_ = str;
			_tmp82_ = string_get_next_char (_tmp80_, &index, &_tmp81_);
			c = _tmp81_;
			if (!_tmp82_) {
				break;
			}
			_tmp83_ = c;
			_tmp84_ = number_base;
			_tmp85_ = char_val (_tmp83_, _tmp84_);
			i = _tmp85_;
			_tmp86_ = i;
			if (_tmp86_ < 0) {
				const gchar* _tmp87_ = NULL;
				gunichar _tmp88_ = 0U;
				_tmp87_ = str;
				string_get_prev_char (_tmp87_, &index, &_tmp88_);
				c = _tmp88_;
				break;
			}
			_tmp89_ = denominator;
			_tmp90_ = number_base;
			_tmp91_ = number_multiply_integer (_tmp89_, (gint64) _tmp90_);
			_g_object_unref0 (denominator);
			denominator = _tmp91_;
			_tmp92_ = numerator;
			_tmp93_ = number_base;
			_tmp94_ = number_multiply_integer (_tmp92_, (gint64) _tmp93_);
			_g_object_unref0 (numerator);
			numerator = _tmp94_;
			_tmp95_ = numerator;
			_tmp96_ = i;
			_tmp97_ = number_new_integer ((gint64) _tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = number_add (_tmp95_, _tmp98_);
			_g_object_unref0 (numerator);
			numerator = _tmp99_;
			_g_object_unref0 (_tmp98_);
		}
		_tmp100_ = numerator;
		_tmp101_ = denominator;
		_tmp102_ = number_divide (_tmp100_, _tmp101_);
		_g_object_unref0 (numerator);
		numerator = _tmp102_;
		_tmp103_ = z;
		_tmp104_ = numerator;
		_tmp105_ = number_add (_tmp103_, _tmp104_);
		_g_object_unref0 (z);
		z = _tmp105_;
		_g_object_unref0 (denominator);
		_g_object_unref0 (numerator);
	}
	_tmp106_ = index;
	_tmp107_ = end;
	if (_tmp106_ != _tmp107_) {
		result = NULL;
		_g_object_unref0 (z);
		return result;
	}
	_tmp108_ = negate;
	if (_tmp108_) {
		Number* _tmp109_ = NULL;
		Number* _tmp110_ = NULL;
		_tmp109_ = z;
		_tmp110_ = number_invert_sign (_tmp109_);
		_g_object_unref0 (z);
		z = _tmp110_;
	}
	result = z;
	return result;
}


gint char_val (gunichar c, gint number_base) {
	gint result = 0;
	gunichar _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gint value = 0;
	gunichar _tmp2_ = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	_tmp0_ = c;
	_tmp1_ = g_unichar_isxdigit (_tmp0_);
	if (!_tmp1_) {
		result = -1;
		return result;
	}
	_tmp2_ = c;
	_tmp3_ = g_unichar_xdigit_value (_tmp2_);
	value = _tmp3_;
	_tmp4_ = value;
	_tmp5_ = number_base;
	if (_tmp4_ >= _tmp5_) {
		result = -1;
		return result;
	}
	result = value;
	return result;
}


Number* set_from_sexagesimal (const gchar* str) {
	Number* result = NULL;
	gint degree_index = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Number* degrees = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* _tmp9_ = NULL;
	gint minute_start = 0;
	gint _tmp10_ = 0;
	gunichar c = 0U;
	const gchar* _tmp11_ = NULL;
	gunichar _tmp12_ = 0U;
	const gchar* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gchar _tmp15_ = '\0';
	gint minute_index = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Number* minutes = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	Number* _tmp26_ = NULL;
	Number* _tmp27_ = NULL;
	Number* _tmp28_ = NULL;
	Number* _tmp29_ = NULL;
	Number* _tmp30_ = NULL;
	Number* _tmp31_ = NULL;
	Number* _tmp32_ = NULL;
	Number* _tmp33_ = NULL;
	gint second_start = 0;
	gint _tmp34_ = 0;
	const gchar* _tmp35_ = NULL;
	gunichar _tmp36_ = 0U;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gchar _tmp39_ = '\0';
	gint second_index = 0;
	const gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	Number* seconds = NULL;
	const gchar* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	Number* _tmp50_ = NULL;
	Number* _tmp51_ = NULL;
	Number* _tmp52_ = NULL;
	Number* _tmp53_ = NULL;
	Number* _tmp54_ = NULL;
	Number* _tmp55_ = NULL;
	Number* _tmp56_ = NULL;
	Number* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	gunichar _tmp59_ = 0U;
	const gchar* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gchar _tmp62_ = '\0';
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = str;
	_tmp1_ = string_index_of_char (_tmp0_, 176U, 0);
	degree_index = _tmp1_;
	_tmp2_ = degree_index;
	if (_tmp2_ < 0) {
		result = NULL;
		return result;
	}
	_tmp3_ = str;
	_tmp4_ = degree_index;
	_tmp5_ = string_substring (_tmp3_, (glong) 0, (glong) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = mp_set_from_string (_tmp6_, 10);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	degrees = _tmp8_;
	_tmp9_ = degrees;
	if (_tmp9_ == NULL) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp10_ = degree_index;
	minute_start = _tmp10_;
	_tmp11_ = str;
	string_get_next_char (_tmp11_, &minute_start, &_tmp12_);
	c = _tmp12_;
	_tmp13_ = str;
	_tmp14_ = minute_start;
	_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
	if (_tmp15_ == '\0') {
		result = degrees;
		return result;
	}
	_tmp16_ = str;
	_tmp17_ = minute_start;
	_tmp18_ = string_index_of_char (_tmp16_, (gunichar) '\'', _tmp17_);
	minute_index = _tmp18_;
	_tmp19_ = minute_index;
	if (_tmp19_ < 0) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp20_ = str;
	_tmp21_ = minute_start;
	_tmp22_ = minute_index;
	_tmp23_ = minute_start;
	_tmp24_ = string_substring (_tmp20_, (glong) _tmp21_, (glong) (_tmp22_ - _tmp23_));
	_tmp25_ = _tmp24_;
	_tmp26_ = mp_set_from_string (_tmp25_, 10);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	minutes = _tmp27_;
	_tmp28_ = minutes;
	if (_tmp28_ == NULL) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp29_ = degrees;
	_tmp30_ = minutes;
	_tmp31_ = number_divide_integer (_tmp30_, (gint64) 60);
	_tmp32_ = _tmp31_;
	_tmp33_ = number_add (_tmp29_, _tmp32_);
	_g_object_unref0 (degrees);
	degrees = _tmp33_;
	_g_object_unref0 (_tmp32_);
	_tmp34_ = minute_index;
	second_start = _tmp34_;
	_tmp35_ = str;
	string_get_next_char (_tmp35_, &second_start, &_tmp36_);
	c = _tmp36_;
	_tmp37_ = str;
	_tmp38_ = second_start;
	_tmp39_ = string_get (_tmp37_, (glong) _tmp38_);
	if (_tmp39_ == '\0') {
		result = degrees;
		_g_object_unref0 (minutes);
		return result;
	}
	_tmp40_ = str;
	_tmp41_ = second_start;
	_tmp42_ = string_index_of_char (_tmp40_, (gunichar) '"', _tmp41_);
	second_index = _tmp42_;
	_tmp43_ = second_index;
	if (_tmp43_ < 0) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp44_ = str;
	_tmp45_ = second_start;
	_tmp46_ = second_index;
	_tmp47_ = second_start;
	_tmp48_ = string_substring (_tmp44_, (glong) _tmp45_, (glong) (_tmp46_ - _tmp47_));
	_tmp49_ = _tmp48_;
	_tmp50_ = mp_set_from_string (_tmp49_, 10);
	_tmp51_ = _tmp50_;
	_g_free0 (_tmp49_);
	seconds = _tmp51_;
	_tmp52_ = seconds;
	if (_tmp52_ == NULL) {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp53_ = degrees;
	_tmp54_ = seconds;
	_tmp55_ = number_divide_integer (_tmp54_, (gint64) 3600);
	_tmp56_ = _tmp55_;
	_tmp57_ = number_add (_tmp53_, _tmp56_);
	_g_object_unref0 (degrees);
	degrees = _tmp57_;
	_g_object_unref0 (_tmp56_);
	_tmp58_ = str;
	string_get_next_char (_tmp58_, &second_index, &_tmp59_);
	c = _tmp59_;
	_tmp60_ = str;
	_tmp61_ = second_index;
	_tmp62_ = string_get (_tmp60_, (glong) _tmp61_);
	if (_tmp62_ == '\0') {
		result = degrees;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_g_object_unref0 (seconds);
	_g_object_unref0 (minutes);
	_g_object_unref0 (degrees);
}


void mp_gcd (gint64* k, gint64* l) {
	gint64 i = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp1_ = 0LL;
	gint64 j = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp17_ = 0LL;
	gint64 _tmp18_ = 0LL;
	gint64 _tmp19_ = 0LL;
	gint64 _tmp20_ = 0LL;
	_tmp0_ = *k;
	_tmp1_ = llabs (_tmp0_);
	i = _tmp1_;
	_tmp2_ = *l;
	_tmp3_ = llabs (_tmp2_);
	j = _tmp3_;
	_tmp4_ = j;
	if (_tmp4_ == ((gint64) 0)) {
		gint64 _tmp5_ = 0LL;
		*k = (gint64) 1;
		*l = (gint64) 0;
		_tmp5_ = i;
		if (_tmp5_ == ((gint64) 0)) {
			*k = (gint64) 0;
		}
		return;
	}
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gint64 _tmp8_ = 0LL;
			gint64 _tmp9_ = 0LL;
			gint64 _tmp10_ = 0LL;
			gint64 _tmp15_ = 0LL;
			gint64 _tmp16_ = 0LL;
			if (!_tmp6_) {
				gint64 _tmp7_ = 0LL;
				_tmp7_ = j;
				if (!(_tmp7_ != ((gint64) 0))) {
					break;
				}
			}
			_tmp6_ = FALSE;
			_tmp8_ = i;
			_tmp9_ = j;
			i = _tmp8_ % _tmp9_;
			_tmp10_ = i;
			if (_tmp10_ == ((gint64) 0)) {
				gint64 _tmp11_ = 0LL;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_ = 0LL;
				gint64 _tmp14_ = 0LL;
				_tmp11_ = *k;
				_tmp12_ = j;
				*k = _tmp11_ / _tmp12_;
				_tmp13_ = *l;
				_tmp14_ = j;
				*l = _tmp13_ / _tmp14_;
				return;
			}
			_tmp15_ = j;
			_tmp16_ = i;
			j = _tmp15_ % _tmp16_;
		}
	}
	_tmp17_ = *k;
	_tmp18_ = i;
	*k = _tmp17_ / _tmp18_;
	_tmp19_ = *l;
	_tmp20_ = i;
	*l = _tmp19_ / _tmp20_;
}


void mp_normalize (Number** x) {
	gint start_index = 0;
	gint _tmp7_ = 0;
	gint _tmp10_ = 0;
	g_return_if_fail (*x != NULL);
	{
		gboolean _tmp0_ = FALSE;
		start_index = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gboolean _tmp2_ = FALSE;
			gint _tmp3_ = 0;
			if (!_tmp0_) {
				gint _tmp1_ = 0;
				_tmp1_ = start_index;
				start_index = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp3_ = start_index;
			if (_tmp3_ < SIZE) {
				Number* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				_tmp4_ = *x;
				_tmp5_ = start_index;
				_tmp6_ = _tmp4_->re_fraction[_tmp5_];
				_tmp2_ = _tmp6_ == 0;
			} else {
				_tmp2_ = FALSE;
			}
			if (!_tmp2_) {
				break;
			}
		}
	}
	_tmp7_ = start_index;
	if (_tmp7_ >= SIZE) {
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		_tmp8_ = *x;
		_tmp8_->re_sign = 0;
		_tmp9_ = *x;
		_tmp9_->re_exponent = 0;
		return;
	}
	_tmp10_ = start_index;
	if (_tmp10_ > 0) {
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint i = 0;
		_tmp11_ = *x;
		_tmp12_ = *x;
		_tmp13_ = _tmp12_->re_exponent;
		_tmp14_ = start_index;
		_tmp12_->re_exponent = _tmp13_ - _tmp14_;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_ = 0;
				gint _tmp18_ = 0;
				Number* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				Number* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				if (!_tmp15_) {
					gint _tmp16_ = 0;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = start_index;
				if (!((_tmp17_ + _tmp18_) < SIZE)) {
					break;
				}
				_tmp19_ = *x;
				_tmp20_ = i;
				_tmp21_ = *x;
				_tmp22_ = i;
				_tmp23_ = start_index;
				_tmp24_ = _tmp21_->re_fraction[_tmp22_ + _tmp23_];
				_tmp19_->re_fraction[_tmp20_] = _tmp24_;
				_tmp25_ = _tmp19_->re_fraction[_tmp20_];
			}
		}
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				gint _tmp28_ = 0;
				Number* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
				if (!_tmp26_) {
					gint _tmp27_ = 0;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = i;
				if (!(_tmp28_ < SIZE)) {
					break;
				}
				_tmp29_ = *x;
				_tmp30_ = i;
				_tmp29_->re_fraction[_tmp30_] = 0;
				_tmp31_ = _tmp29_->re_fraction[_tmp30_];
			}
		}
	}
}


gboolean mp_is_overflow (Number* x, gint wordlen) {
	gboolean result = FALSE;
	Number* t2 = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = number_new_integer ((gint64) 2);
	_tmp1_ = _tmp0_;
	_tmp2_ = wordlen;
	_tmp3_ = number_xpowy_integer (_tmp1_, (gint64) _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	t2 = _tmp4_;
	_tmp5_ = x;
	_tmp6_ = number_compare (t2, _tmp5_);
	result = _tmp6_ > 0;
	_g_object_unref0 (t2);
	return result;
}



