/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_CODE_GENERATOR (vala_code_generator_get_type ())
#define VALA_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGenerator))
#define VALA_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))
#define VALA_IS_CODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_GENERATOR))
#define VALA_IS_CODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_GENERATOR))
#define VALA_CODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_GENERATOR, ValaCodeGeneratorClass))

typedef struct _ValaCodeGenerator ValaCodeGenerator;
typedef struct _ValaCodeGeneratorClass ValaCodeGeneratorClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_VARIABLE (vala_variable_get_type ())
#define VALA_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VARIABLE, ValaVariable))
#define VALA_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VARIABLE, ValaVariableClass))
#define VALA_IS_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VARIABLE))
#define VALA_IS_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VARIABLE))
#define VALA_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VARIABLE, ValaVariableClass))

typedef struct _ValaVariable ValaVariable;
typedef struct _ValaVariableClass ValaVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_SUBROUTINE (vala_subroutine_get_type ())
#define VALA_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutine))
#define VALA_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))
#define VALA_IS_SUBROUTINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SUBROUTINE))
#define VALA_IS_SUBROUTINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SUBROUTINE))
#define VALA_SUBROUTINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SUBROUTINE, ValaSubroutineClass))

typedef struct _ValaSubroutine ValaSubroutine;
typedef struct _ValaSubroutineClass ValaSubroutineClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;
typedef struct _ValaVariablePrivate ValaVariablePrivate;

#define VALA_TYPE_LOCKABLE (vala_lockable_get_type ())
#define VALA_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCKABLE, ValaLockable))
#define VALA_IS_LOCKABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCKABLE))
#define VALA_LOCKABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), VALA_TYPE_LOCKABLE, ValaLockableIface))

typedef struct _ValaLockable ValaLockable;
typedef struct _ValaLockableIface ValaLockableIface;
typedef struct _ValaFieldPrivate ValaFieldPrivate;

#define VALA_TYPE_MEMBER_BINDING (vala_member_binding_get_type ())

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaCodeContext* context);
	void (*emit) (ValaCodeNode* self, ValaCodeGenerator* codegen);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	gchar* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
	void (*add_namespace) (ValaSymbol* self, ValaNamespace* ns);
	void (*add_class) (ValaSymbol* self, ValaClass* cl);
	void (*add_interface) (ValaSymbol* self, ValaInterface* iface);
	void (*add_struct) (ValaSymbol* self, ValaStruct* st);
	void (*add_enum) (ValaSymbol* self, ValaEnum* en);
	void (*add_error_domain) (ValaSymbol* self, ValaErrorDomain* edomain);
	void (*add_delegate) (ValaSymbol* self, ValaDelegate* d);
	void (*add_constant) (ValaSymbol* self, ValaConstant* constant);
	void (*add_field) (ValaSymbol* self, ValaField* f);
	void (*add_method) (ValaSymbol* self, ValaMethod* m);
	void (*add_property) (ValaSymbol* self, ValaProperty* prop);
	void (*add_signal) (ValaSymbol* self, ValaSignal* sig);
	void (*add_constructor) (ValaSymbol* self, ValaConstructor* c);
	void (*add_destructor) (ValaSymbol* self, ValaDestructor* d);
};

struct _ValaVariable {
	ValaSymbol parent_instance;
	ValaVariablePrivate * priv;
};

struct _ValaVariableClass {
	ValaSymbolClass parent_class;
};

struct _ValaLockableIface {
	GTypeInterface parent_iface;
	gboolean (*get_lock_used) (ValaLockable* self);
	void (*set_lock_used) (ValaLockable* self, gboolean used);
};

struct _ValaField {
	ValaVariable parent_instance;
	ValaFieldPrivate * priv;
};

struct _ValaFieldClass {
	ValaVariableClass parent_class;
};

typedef enum  {
	VALA_MEMBER_BINDING_INSTANCE,
	VALA_MEMBER_BINDING_CLASS,
	VALA_MEMBER_BINDING_STATIC
} ValaMemberBinding;

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean lock_used;
};


static gpointer vala_field_parent_class = NULL;
static ValaLockableIface* vala_field_vala_lockable_parent_iface = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
GType vala_code_generator_get_type (void) G_GNUC_CONST;
GType vala_data_type_get_type (void) G_GNUC_CONST;
GType vala_expression_get_type (void) G_GNUC_CONST;
GType vala_symbol_get_type (void) G_GNUC_CONST;
GType vala_variable_get_type (void) G_GNUC_CONST;
GType vala_attribute_get_type (void) G_GNUC_CONST;
GType vala_namespace_get_type (void) G_GNUC_CONST;
GType vala_typesymbol_get_type (void) G_GNUC_CONST;
GType vala_object_type_symbol_get_type (void) G_GNUC_CONST;
GType vala_class_get_type (void) G_GNUC_CONST;
GType vala_interface_get_type (void) G_GNUC_CONST;
GType vala_struct_get_type (void) G_GNUC_CONST;
GType vala_enum_get_type (void) G_GNUC_CONST;
GType vala_error_domain_get_type (void) G_GNUC_CONST;
GType vala_delegate_get_type (void) G_GNUC_CONST;
GType vala_constant_get_type (void) G_GNUC_CONST;
GType vala_field_get_type (void) G_GNUC_CONST;
GType vala_subroutine_get_type (void) G_GNUC_CONST;
GType vala_method_get_type (void) G_GNUC_CONST;
GType vala_property_get_type (void) G_GNUC_CONST;
GType vala_signal_get_type (void) G_GNUC_CONST;
GType vala_constructor_get_type (void) G_GNUC_CONST;
GType vala_destructor_get_type (void) G_GNUC_CONST;
GType vala_lockable_get_type (void) G_GNUC_CONST;
GType vala_member_binding_get_type (void) G_GNUC_CONST;
#define VALA_FIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD, ValaFieldPrivate))
enum  {
	VALA_FIELD_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
ValaField* vala_field_new (const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaField* vala_field_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaVariable* vala_variable_new (ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
ValaVariable* vala_variable_construct (GType object_type, ValaDataType* variable_type, const gchar* name, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment);
static void vala_field_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_field (ValaCodeVisitor* self, ValaField* f);
static void vala_field_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_variable_get_variable_type (ValaVariable* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaExpression* vala_variable_get_initializer (ValaVariable* self);
static gboolean vala_field_real_get_lock_used (ValaLockable* base);
static void vala_field_real_set_lock_used (ValaLockable* base, gboolean used);
static void vala_field_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
void vala_variable_set_initializer (ValaVariable* self, ValaExpression* value);
static void vala_field_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
void vala_variable_set_variable_type (ValaVariable* self, ValaDataType* value);
gchar* vala_field_get_ctype (ValaField* self);
gchar* vala_code_node_get_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument, const gchar* default_value);
void vala_field_set_ctype (ValaField* self, const gchar* ctype);
void vala_code_node_set_attribute_string (ValaCodeNode* self, const gchar* attribute, const gchar* argument, const gchar* value, ValaSourceReference* source_reference);
static gboolean vala_field_real_check (ValaCodeNode* base, ValaCodeContext* context);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
ValaSemanticAnalyzer* vala_code_context_get_analyzer (ValaCodeContext* self);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
GType vala_void_type_get_type (void) G_GNUC_CONST;
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const gchar* message);
gboolean vala_code_node_check (ValaCodeNode* self, ValaCodeContext* context);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gchar* vala_code_node_to_string (ValaCodeNode* self);
gchar* vala_symbol_get_full_name (ValaSymbol* self);
void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
gboolean vala_expression_is_constant (ValaExpression* self);
ValaMemberBinding vala_field_get_binding (ValaField* self);
gboolean vala_class_get_is_compact (ValaClass* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_is_internal_symbol (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gboolean vala_symbol_get_hides (ValaSymbol* self);
ValaSymbol* vala_symbol_get_hidden_member (ValaSymbol* self);
void vala_report_warning (ValaSourceReference* source, const gchar* message);
void vala_field_set_binding (ValaField* self, ValaMemberBinding value);
gboolean vala_field_get_is_volatile (ValaField* self);
void vala_field_set_is_volatile (ValaField* self, gboolean value);
static void vala_field_finalize (ValaCodeNode* obj);


/**
 * Creates a new field.
 *
 * @param name   field name
 * @param type   field type
 * @param init   initializer expression
 * @param source reference to source code
 * @return       newly created field
 */
ValaField* vala_field_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaField* self = NULL;
	ValaDataType* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ValaExpression* _tmp2_ = NULL;
	ValaSourceReference* _tmp3_ = NULL;
	ValaComment* _tmp4_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	_tmp0_ = variable_type;
	_tmp1_ = name;
	_tmp2_ = initializer;
	_tmp3_ = source_reference;
	_tmp4_ = comment;
	self = (ValaField*) vala_variable_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	return self;
}


ValaField* vala_field_new (const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}


static void vala_field_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaField * self;
	ValaCodeVisitor* _tmp0_ = NULL;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_field (_tmp0_, self);
}


static void vala_field_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaField * self;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaCodeVisitor* _tmp2_ = NULL;
	ValaExpression* _tmp3_ = NULL;
	ValaExpression* _tmp4_ = NULL;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaExpression* _tmp5_ = NULL;
		ValaExpression* _tmp6_ = NULL;
		ValaCodeVisitor* _tmp7_ = NULL;
		_tmp5_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, _tmp7_);
	}
}


static gboolean vala_field_real_get_lock_used (ValaLockable* base) {
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	self = (ValaField*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void vala_field_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaField * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaField*) base;
	_tmp0_ = used;
	self->priv->lock_used = _tmp0_;
}


static void vala_field_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaField * self;
	ValaExpression* _tmp0_ = NULL;
	ValaExpression* _tmp1_ = NULL;
	ValaExpression* _tmp2_ = NULL;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_ = NULL;
		_tmp3_ = new_node;
		vala_variable_set_initializer ((ValaVariable*) self, _tmp3_);
	}
}


static void vala_field_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaField * self;
	ValaDataType* _tmp0_ = NULL;
	ValaDataType* _tmp1_ = NULL;
	ValaDataType* _tmp2_ = NULL;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_ = NULL;
		_tmp3_ = new_type;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp3_);
	}
}


gchar* vala_field_get_ctype (ValaField* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "type", NULL);
	result = _tmp0_;
	return result;
}


void vala_field_set_ctype (ValaField* self, const gchar* ctype) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctype != NULL);
	_tmp0_ = ctype;
	vala_code_node_set_attribute_string ((ValaCodeNode*) self, "CCode", "type", _tmp0_, NULL);
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_field_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_ = NULL;
	ValaSemanticAnalyzer* _tmp5_ = NULL;
	ValaSemanticAnalyzer* _tmp6_ = NULL;
	ValaSourceFile* _tmp7_ = NULL;
	ValaSourceFile* _tmp8_ = NULL;
	ValaSourceFile* _tmp9_ = NULL;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_ = NULL;
	ValaSemanticAnalyzer* _tmp11_ = NULL;
	ValaSemanticAnalyzer* _tmp12_ = NULL;
	ValaSymbol* _tmp13_ = NULL;
	ValaSymbol* _tmp14_ = NULL;
	ValaSymbol* _tmp15_ = NULL;
	ValaSourceReference* _tmp16_ = NULL;
	ValaSourceReference* _tmp17_ = NULL;
	ValaCodeContext* _tmp25_ = NULL;
	ValaSemanticAnalyzer* _tmp26_ = NULL;
	ValaSemanticAnalyzer* _tmp27_ = NULL;
	ValaDataType* _tmp28_ = NULL;
	ValaDataType* _tmp29_ = NULL;
	ValaDataType* _tmp32_ = NULL;
	ValaDataType* _tmp33_ = NULL;
	ValaCodeContext* _tmp34_ = NULL;
	ValaCodeContext* _tmp35_ = NULL;
	ValaSemanticAnalyzer* _tmp36_ = NULL;
	ValaSemanticAnalyzer* _tmp37_ = NULL;
	ValaDataType* _tmp38_ = NULL;
	ValaDataType* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	ValaExpression* _tmp51_ = NULL;
	ValaExpression* _tmp52_ = NULL;
	gboolean _tmp115_ = FALSE;
	ValaMemberBinding _tmp116_ = 0;
	gboolean field_in_header = FALSE;
	gboolean _tmp121_ = FALSE;
	ValaSymbol* _tmp122_ = NULL;
	ValaSymbol* _tmp123_ = NULL;
	gboolean _tmp133_ = FALSE;
	gboolean _tmp134_ = FALSE;
	gboolean _tmp135_ = FALSE;
	gboolean _tmp136_ = FALSE;
	ValaCodeContext* _tmp151_ = NULL;
	ValaSemanticAnalyzer* _tmp152_ = NULL;
	ValaSemanticAnalyzer* _tmp153_ = NULL;
	ValaSourceFile* _tmp154_ = NULL;
	ValaCodeContext* _tmp155_ = NULL;
	ValaSemanticAnalyzer* _tmp156_ = NULL;
	ValaSemanticAnalyzer* _tmp157_ = NULL;
	ValaSymbol* _tmp158_ = NULL;
	gboolean _tmp159_ = FALSE;
	gboolean _tmp160_ = FALSE;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_ = NULL;
		ValaSemanticAnalyzer* _tmp19_ = NULL;
		ValaSemanticAnalyzer* _tmp20_ = NULL;
		ValaSourceReference* _tmp21_ = NULL;
		ValaSourceReference* _tmp22_ = NULL;
		ValaSourceFile* _tmp23_ = NULL;
		ValaSourceFile* _tmp24_ = NULL;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_VOID_TYPE)) {
		ValaSourceReference* _tmp30_ = NULL;
		ValaSourceReference* _tmp31_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		vala_report_error (_tmp31_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp33_, _tmp34_);
	_tmp35_ = context;
	_tmp36_ = vala_code_context_get_analyzer (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_semantic_analyzer_is_type_accessible (_tmp37_, (ValaSymbol*) self, _tmp39_);
	if (!_tmp40_) {
		ValaSourceReference* _tmp41_ = NULL;
		ValaSourceReference* _tmp42_ = NULL;
		ValaDataType* _tmp43_ = NULL;
		ValaDataType* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strdup_printf ("field type `%s` is less accessible than field `%s`", _tmp46_, _tmp48_);
		_tmp50_ = _tmp49_;
		vala_report_error (_tmp42_, _tmp50_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp51_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp52_ = _tmp51_;
	if (_tmp52_ != NULL) {
		ValaExpression* _tmp53_ = NULL;
		ValaExpression* _tmp54_ = NULL;
		ValaDataType* _tmp55_ = NULL;
		ValaDataType* _tmp56_ = NULL;
		ValaExpression* _tmp57_ = NULL;
		ValaExpression* _tmp58_ = NULL;
		ValaCodeContext* _tmp59_ = NULL;
		gboolean _tmp60_ = FALSE;
		ValaExpression* _tmp61_ = NULL;
		ValaExpression* _tmp62_ = NULL;
		ValaDataType* _tmp63_ = NULL;
		ValaDataType* _tmp64_ = NULL;
		ValaExpression* _tmp67_ = NULL;
		ValaExpression* _tmp68_ = NULL;
		ValaDataType* _tmp69_ = NULL;
		ValaDataType* _tmp70_ = NULL;
		ValaDataType* _tmp71_ = NULL;
		ValaDataType* _tmp72_ = NULL;
		gboolean _tmp73_ = FALSE;
		gboolean _tmp88_ = FALSE;
		ValaSymbol* _tmp89_ = NULL;
		ValaSymbol* _tmp90_ = NULL;
		gboolean _tmp96_ = FALSE;
		gboolean _tmp97_ = FALSE;
		gboolean _tmp98_ = FALSE;
		ValaMemberBinding _tmp99_ = 0;
		gboolean _tmp111_ = FALSE;
		gboolean _tmp112_ = FALSE;
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		vala_expression_set_target_type (_tmp54_, _tmp56_);
		_tmp57_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp58_ = _tmp57_;
		_tmp59_ = context;
		_tmp60_ = vala_code_node_check ((ValaCodeNode*) _tmp58_, _tmp59_);
		if (!_tmp60_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_expression_get_value_type (_tmp62_);
		_tmp64_ = _tmp63_;
		if (_tmp64_ == NULL) {
			ValaSourceReference* _tmp65_ = NULL;
			ValaSourceReference* _tmp66_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp66_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_expression_get_value_type (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_data_type_compatible (_tmp70_, _tmp72_);
		if (!_tmp73_) {
			ValaSourceReference* _tmp74_ = NULL;
			ValaSourceReference* _tmp75_ = NULL;
			ValaExpression* _tmp76_ = NULL;
			ValaExpression* _tmp77_ = NULL;
			ValaDataType* _tmp78_ = NULL;
			ValaDataType* _tmp79_ = NULL;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_ = NULL;
			ValaDataType* _tmp82_ = NULL;
			ValaDataType* _tmp83_ = NULL;
			gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_expression_get_value_type (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_code_node_to_string ((ValaCodeNode*) _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_code_node_to_string ((ValaCodeNode*) _tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp81_, _tmp85_);
			_tmp87_ = _tmp86_;
			vala_report_error (_tmp75_, _tmp87_);
			_g_free0 (_tmp87_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp81_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp89_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp90_ = _tmp89_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, VALA_TYPE_NAMESPACE)) {
			ValaExpression* _tmp91_ = NULL;
			ValaExpression* _tmp92_ = NULL;
			gboolean _tmp93_ = FALSE;
			_tmp91_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp92_ = _tmp91_;
			_tmp93_ = vala_expression_is_constant (_tmp92_);
			_tmp88_ = !_tmp93_;
		} else {
			_tmp88_ = FALSE;
		}
		if (_tmp88_) {
			ValaSourceReference* _tmp94_ = NULL;
			ValaSourceReference* _tmp95_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp95_ = _tmp94_;
			vala_report_error (_tmp95_, "Non-constant field initializerS not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp99_ = self->priv->_binding;
		if (_tmp99_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp100_ = NULL;
			ValaSymbol* _tmp101_ = NULL;
			_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp101_ = _tmp100_;
			_tmp98_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_CLASS);
		} else {
			_tmp98_ = FALSE;
		}
		if (_tmp98_) {
			ValaSymbol* _tmp102_ = NULL;
			ValaSymbol* _tmp103_ = NULL;
			gboolean _tmp104_ = FALSE;
			gboolean _tmp105_ = FALSE;
			_tmp102_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp103_ = _tmp102_;
			_tmp104_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_CLASS, ValaClass));
			_tmp105_ = _tmp104_;
			_tmp97_ = _tmp105_;
		} else {
			_tmp97_ = FALSE;
		}
		if (_tmp97_) {
			ValaExpression* _tmp106_ = NULL;
			ValaExpression* _tmp107_ = NULL;
			gboolean _tmp108_ = FALSE;
			_tmp106_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp107_ = _tmp106_;
			_tmp108_ = vala_expression_is_constant (_tmp107_);
			_tmp96_ = !_tmp108_;
		} else {
			_tmp96_ = FALSE;
		}
		if (_tmp96_) {
			ValaSourceReference* _tmp109_ = NULL;
			ValaSourceReference* _tmp110_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp110_ = _tmp109_;
			vala_report_error (_tmp110_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp111_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp112_ = _tmp111_;
		if (_tmp112_) {
			ValaSourceReference* _tmp113_ = NULL;
			ValaSourceReference* _tmp114_ = NULL;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp114_ = _tmp113_;
			vala_report_error (_tmp114_, "External fields cannot use initializers");
		}
	}
	_tmp116_ = self->priv->_binding;
	if (_tmp116_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp117_ = NULL;
		ValaSymbol* _tmp118_ = NULL;
		_tmp117_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp118_ = _tmp117_;
		_tmp115_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp118_, VALA_TYPE_INTERFACE);
	} else {
		_tmp115_ = FALSE;
	}
	if (_tmp115_) {
		ValaSourceReference* _tmp119_ = NULL;
		ValaSourceReference* _tmp120_ = NULL;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp119_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp120_ = _tmp119_;
		vala_report_error (_tmp120_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp121_ = vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	field_in_header = !_tmp121_;
	_tmp122_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp123_ = _tmp122_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp124_ = NULL;
		ValaSymbol* _tmp125_ = NULL;
		ValaClass* _tmp126_ = NULL;
		gboolean _tmp127_ = FALSE;
		ValaClass* _tmp128_ = NULL;
		gboolean _tmp129_ = FALSE;
		gboolean _tmp130_ = FALSE;
		_tmp124_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp126_;
		_tmp128_ = cl;
		_tmp129_ = vala_class_get_is_compact (_tmp128_);
		_tmp130_ = _tmp129_;
		if (_tmp130_) {
			ValaClass* _tmp131_ = NULL;
			gboolean _tmp132_ = FALSE;
			_tmp131_ = cl;
			_tmp132_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp131_);
			_tmp127_ = !_tmp132_;
		} else {
			_tmp127_ = FALSE;
		}
		if (_tmp127_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp135_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp136_ = _tmp135_;
	if (!_tmp136_) {
		gboolean _tmp137_ = FALSE;
		gboolean _tmp138_ = FALSE;
		_tmp137_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp138_ = _tmp137_;
		_tmp134_ = !_tmp138_;
	} else {
		_tmp134_ = FALSE;
	}
	if (_tmp134_) {
		ValaSymbol* _tmp139_ = NULL;
		ValaSymbol* _tmp140_ = NULL;
		_tmp139_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp140_ = _tmp139_;
		_tmp133_ = _tmp140_ != NULL;
		_vala_code_node_unref0 (_tmp140_);
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		ValaSourceReference* _tmp141_ = NULL;
		ValaSourceReference* _tmp142_ = NULL;
		gchar* _tmp143_ = NULL;
		gchar* _tmp144_ = NULL;
		ValaSymbol* _tmp145_ = NULL;
		ValaSymbol* _tmp146_ = NULL;
		gchar* _tmp147_ = NULL;
		gchar* _tmp148_ = NULL;
		gchar* _tmp149_ = NULL;
		gchar* _tmp150_ = NULL;
		_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp142_ = _tmp141_;
		_tmp143_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp144_ = _tmp143_;
		_tmp145_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_symbol_get_full_name (_tmp146_);
		_tmp148_ = _tmp147_;
		_tmp149_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp144_, _tmp148_);
		_tmp150_ = _tmp149_;
		vala_report_warning (_tmp142_, _tmp150_);
		_g_free0 (_tmp150_);
		_g_free0 (_tmp148_);
		_vala_code_node_unref0 (_tmp146_);
		_g_free0 (_tmp144_);
	}
	_tmp151_ = context;
	_tmp152_ = vala_code_context_get_analyzer (_tmp151_);
	_tmp153_ = _tmp152_;
	_tmp154_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp153_, _tmp154_);
	_tmp155_ = context;
	_tmp156_ = vala_code_context_get_analyzer (_tmp155_);
	_tmp157_ = _tmp156_;
	_tmp158_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp157_, _tmp158_);
	_tmp159_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp160_ = _tmp159_;
	result = !_tmp160_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaMemberBinding vala_field_get_binding (ValaField* self) {
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void vala_field_set_binding (ValaField* self, ValaMemberBinding value) {
	ValaMemberBinding _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_binding = _tmp0_;
}


gboolean vala_field_get_is_volatile (ValaField* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_volatile;
	result = _tmp0_;
	return result;
}


void vala_field_set_is_volatile (ValaField* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_volatile = _tmp0_;
}


static void vala_field_class_init (ValaFieldClass * klass) {
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_add_private (klass, sizeof (ValaFieldPrivate));
	((ValaCodeNodeClass *) klass)->accept = vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = vala_field_real_check;
}


static void vala_field_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*)(ValaLockable*)) vala_field_real_get_lock_used;
	iface->set_lock_used = (void (*)(ValaLockable*, gboolean)) vala_field_real_set_lock_used;
}


static void vala_field_instance_init (ValaField * self) {
	self->priv = VALA_FIELD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void vala_field_finalize (ValaCodeNode* obj) {
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace field.
 */
GType vala_field_get_type (void) {
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}



