/* serializer.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 * Copyright (C) 2010 Robin Sonefors
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <langinfo.h>
#include <glib/gi18n-lib.h>


#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;
typedef struct _SerializerPrivate SerializerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;

struct _Serializer {
	GObject parent_instance;
	SerializerPrivate * priv;
};

struct _SerializerClass {
	GObjectClass parent_class;
};

struct _SerializerPrivate {
	gint leading_digits;
	gint trailing_digits;
	DisplayFormat format;
	gboolean show_tsep;
	gboolean show_zeroes;
	gint number_base;
	guint representation_base;
	gunichar radix;
	gunichar tsep;
	gint tsep_count;
	gchar* _error;
};


static gpointer serializer_parent_class = NULL;

GType display_format_get_type (void) G_GNUC_CONST;
GType serializer_get_type (void) G_GNUC_CONST;
#define SERIALIZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERIALIZER, SerializerPrivate))
enum  {
	SERIALIZER_DUMMY_PROPERTY,
	SERIALIZER_ERROR
};
Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits);
Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits);
GType number_get_type (void) G_GNUC_CONST;
gchar* serializer_to_string (Serializer* self, Number* x);
static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits);
gint serializer_get_base (Serializer* self);
static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits);
Number* serializer_from_string (Serializer* self, const gchar* str);
Number* mp_set_from_string (const gchar* str, gint default_base);
void serializer_set_base (Serializer* self, gint number_base);
void serializer_set_representation_base (Serializer* self, guint representation_base);
guint serializer_get_representation_base (Serializer* self);
void serializer_set_radix (Serializer* self, gunichar radix);
gunichar serializer_get_radix (Serializer* self);
void serializer_set_thousands_separator (Serializer* self, gunichar separator);
gunichar serializer_get_thousands_separator (Serializer* self);
gint serializer_get_thousands_separator_count (Serializer* self);
void serializer_set_thousands_separator_count (Serializer* self, gint count);
void serializer_set_show_thousands_separators (Serializer* self, gboolean visible);
gboolean serializer_get_show_thousands_separators (Serializer* self);
void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible);
gboolean serializer_get_show_trailing_zeroes (Serializer* self);
gint serializer_get_leading_digits (Serializer* self);
void serializer_set_leading_digits (Serializer* self, gint leading_digits);
gint serializer_get_trailing_digits (Serializer* self);
void serializer_set_trailing_digits (Serializer* self, gint trailing_digits);
DisplayFormat serializer_get_number_format (Serializer* self);
void serializer_set_number_format (Serializer* self, DisplayFormat format);
Number* number_real_component (Number* self);
static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string);
gboolean number_is_complex (Number* self);
Number* number_imaginary_component (Number* self);
gboolean number_is_negative (Number* self);
Number* number_abs (Number* self);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* number_xpowy_integer (Number* self, gint64 n);
Number* number_multiply_integer (Number* self, gint64 y);
Number* number_divide_integer (Number* self, gint64 y);
Number* number_add (Number* self, Number* y);
Number* number_floor (Number* self);
gboolean number_is_zero (Number* self);
Number* number_subtract (Number* self, Number* y);
gint64 number_to_integer (Number* self);
void serializer_set_error (Serializer* self, const gchar* value);
Number* number_fractional_component (Number* self);
static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits);
Number* number_divide (Number* self, Number* y);
gint number_compare (Number* self, Number* y);
Number* number_multiply (Number* self, Number* y);
static void serializer_append_exponent (Serializer* self, GString* string, gint exponent);
const gchar* serializer_get_error (Serializer* self);
static void serializer_finalize (GObject* obj);
static void _vala_serializer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_serializer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType display_format_get_type (void) {
	static volatile gsize display_format_type_id__volatile = 0;
	if (g_once_init_enter (&display_format_type_id__volatile)) {
		static const GEnumValue values[] = {{DISPLAY_FORMAT_AUTOMATIC, "DISPLAY_FORMAT_AUTOMATIC", "automatic"}, {DISPLAY_FORMAT_FIXED, "DISPLAY_FORMAT_FIXED", "fixed"}, {DISPLAY_FORMAT_SCIENTIFIC, "DISPLAY_FORMAT_SCIENTIFIC", "scientific"}, {DISPLAY_FORMAT_ENGINEERING, "DISPLAY_FORMAT_ENGINEERING", "engineering"}, {0, NULL, NULL}};
		GType display_format_type_id;
		display_format_type_id = g_enum_register_static ("DisplayFormat", values);
		g_once_init_leave (&display_format_type_id__volatile, display_format_type_id);
	}
	return display_format_type_id__volatile;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
#line 1026 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1027 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 173 "serializer.c"
}


Serializer* serializer_construct (GType object_type, DisplayFormat format, gint number_base, gint trailing_digits) {
	Serializer * self = NULL;
	gchar* radix_string = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gchar* tsep_string = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	DisplayFormat _tmp21_ = 0;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self = (Serializer*) g_object_new (object_type, NULL);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = nl_langinfo (RADIXCHAR);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	radix_string = _tmp1_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = radix_string;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp3_ != NULL) {
#line 205 "serializer.c"
		const gchar* _tmp4_ = NULL;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp4_ = radix_string;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
#line 211 "serializer.c"
	} else {
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp2_ = FALSE;
#line 215 "serializer.c"
	}
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp2_) {
#line 219 "serializer.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp5_ = radix_string;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp6_ = g_locale_to_utf8 (_tmp5_, (gssize) (-1), NULL, NULL, NULL);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp7_ = _tmp6_;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp8_ = string_get_char (_tmp7_, (glong) 0);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		self->priv->radix = _tmp8_;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_free0 (_tmp7_);
#line 236 "serializer.c"
	} else {
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		self->priv->radix = (gunichar) '.';
#line 240 "serializer.c"
	}
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp9_ = nl_langinfo (THOUSEP);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	tsep_string = _tmp10_;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp12_ = tsep_string;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp12_ != NULL) {
#line 252 "serializer.c"
		const gchar* _tmp13_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp13_ = tsep_string;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp11_ = g_strcmp0 (_tmp13_, "") != 0;
#line 258 "serializer.c"
	} else {
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp11_ = FALSE;
#line 262 "serializer.c"
	}
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp11_) {
#line 266 "serializer.c"
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gunichar _tmp17_ = 0U;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp14_ = tsep_string;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp15_ = g_locale_to_utf8 (_tmp14_, (gssize) (-1), NULL, NULL, NULL);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp16_ = _tmp15_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp17_ = string_get_char (_tmp16_, (glong) 0);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		self->priv->tsep = _tmp17_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_free0 (_tmp16_);
#line 283 "serializer.c"
	} else {
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		self->priv->tsep = (gunichar) ' ';
#line 287 "serializer.c"
	}
#line 50 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->tsep_count = 3;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp18_ = number_base;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->number_base = _tmp18_;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp19_ = number_base;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->representation_base = (guint) _tmp19_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->leading_digits = 12;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp20_ = trailing_digits;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->trailing_digits = _tmp20_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->show_zeroes = FALSE;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->show_tsep = FALSE;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp21_ = format;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->format = _tmp21_;
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (tsep_string);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (radix_string);
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return self;
#line 319 "serializer.c"
}


Serializer* serializer_new (DisplayFormat format, gint number_base, gint trailing_digits) {
#line 38 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return serializer_construct (TYPE_SERIALIZER, format, number_base, trailing_digits);
#line 326 "serializer.c"
}


gchar* serializer_to_string (Serializer* self, Number* x) {
	gchar* result = NULL;
	guint _tmp0_ = 0U;
	gint _tmp1_ = 0;
	DisplayFormat _tmp4_ = 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->representation_base;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = self->priv->number_base;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp0_ != ((guint) _tmp1_)) {
#line 345 "serializer.c"
		gint n_digits = 0;
		Number* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		n_digits = 0;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp2_ = x;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp3_ = serializer_cast_to_string (self, _tmp2_, &n_digits);
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		result = _tmp3_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		return result;
#line 359 "serializer.c"
	}
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp4_ = self->priv->format;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	switch (_tmp4_) {
#line 365 "serializer.c"
		default:
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case DISPLAY_FORMAT_AUTOMATIC:
#line 369 "serializer.c"
		{
			gint n_digits = 0;
			gchar* s0 = NULL;
			Number* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			gint _tmp7_ = 0;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			n_digits = 0;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp5_ = x;
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp6_ = serializer_cast_to_string (self, _tmp5_, &n_digits);
#line 74 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			s0 = _tmp6_;
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp7_ = serializer_get_base (self);
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			switch (_tmp7_) {
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				case 2:
#line 390 "serializer.c"
				{
					gint _tmp8_ = 0;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp8_ = n_digits;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp8_ <= 64) {
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = s0;
#line 81 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 401 "serializer.c"
					} else {
						Number* _tmp9_ = NULL;
						gchar* _tmp10_ = NULL;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp9_ = x;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp10_ = serializer_cast_to_exponential_string (self, _tmp9_, FALSE, &n_digits);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = _tmp10_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_g_free0 (s0);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 415 "serializer.c"
					}
				}
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				case 8:
#line 420 "serializer.c"
				{
					gint _tmp11_ = 0;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp11_ = n_digits;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp11_ <= 22) {
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = s0;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 431 "serializer.c"
					} else {
						Number* _tmp12_ = NULL;
						gchar* _tmp13_ = NULL;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp12_ = x;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp13_ = serializer_cast_to_exponential_string (self, _tmp12_, FALSE, &n_digits);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = _tmp13_;
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_g_free0 (s0);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 445 "serializer.c"
					}
				}
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				case 16:
#line 450 "serializer.c"
				{
					gint _tmp14_ = 0;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp14_ = n_digits;
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp14_ <= 16) {
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = s0;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 461 "serializer.c"
					} else {
						Number* _tmp15_ = NULL;
						gchar* _tmp16_ = NULL;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp15_ = x;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp16_ = serializer_cast_to_exponential_string (self, _tmp15_, FALSE, &n_digits);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = _tmp16_;
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_g_free0 (s0);
#line 95 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 475 "serializer.c"
					}
				}
				default:
#line 76 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				case 10:
#line 481 "serializer.c"
				{
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp17_ = n_digits;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp18_ = self->priv->leading_digits;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp17_ <= _tmp18_) {
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = s0;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 495 "serializer.c"
					} else {
						Number* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp19_ = x;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp20_ = serializer_cast_to_exponential_string (self, _tmp19_, FALSE, &n_digits);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						result = _tmp20_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_g_free0 (s0);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						return result;
#line 509 "serializer.c"
					}
				}
			}
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_free0 (s0);
#line 515 "serializer.c"
		}
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case DISPLAY_FORMAT_FIXED:
#line 519 "serializer.c"
		{
			gint n_digits = 0;
			Number* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			n_digits = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp21_ = x;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp22_ = serializer_cast_to_string (self, _tmp21_, &n_digits);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			result = _tmp22_;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			return result;
#line 534 "serializer.c"
		}
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case DISPLAY_FORMAT_SCIENTIFIC:
#line 538 "serializer.c"
		{
			guint _tmp23_ = 0U;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp23_ = self->priv->representation_base;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp23_ == ((guint) 10)) {
#line 545 "serializer.c"
				gint n_digits = 0;
				Number* _tmp24_ = NULL;
				gchar* _tmp25_ = NULL;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				n_digits = 0;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp24_ = x;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp25_ = serializer_cast_to_exponential_string (self, _tmp24_, FALSE, &n_digits);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				result = _tmp25_;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				return result;
#line 559 "serializer.c"
			} else {
				gint n_digits = 0;
				Number* _tmp26_ = NULL;
				gchar* _tmp27_ = NULL;
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				n_digits = 0;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp26_ = x;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp27_ = serializer_cast_to_string (self, _tmp26_, &n_digits);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				result = _tmp27_;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				return result;
#line 574 "serializer.c"
			}
		}
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case DISPLAY_FORMAT_ENGINEERING:
#line 579 "serializer.c"
		{
			guint _tmp28_ = 0U;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp28_ = self->priv->representation_base;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp28_ == ((guint) 10)) {
#line 586 "serializer.c"
				gint n_digits = 0;
				Number* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				n_digits = 0;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp29_ = x;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp30_ = serializer_cast_to_exponential_string (self, _tmp29_, TRUE, &n_digits);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				result = _tmp30_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				return result;
#line 600 "serializer.c"
			} else {
				gint n_digits = 0;
				Number* _tmp31_ = NULL;
				gchar* _tmp32_ = NULL;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				n_digits = 0;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp31_ = x;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp32_ = serializer_cast_to_string (self, _tmp31_, &n_digits);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				result = _tmp32_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				return result;
#line 615 "serializer.c"
			}
		}
	}
}


Number* serializer_from_string (Serializer* self, const gchar* str) {
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Number* _tmp2_ = NULL;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = str;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = self->priv->number_base;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = mp_set_from_string (_tmp0_, _tmp1_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp2_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 641 "serializer.c"
}


void serializer_set_base (Serializer* self, gint number_base) {
	gint _tmp0_ = 0;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = number_base;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->number_base = _tmp0_;
#line 653 "serializer.c"
}


gint serializer_get_base (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->number_base;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 668 "serializer.c"
}


void serializer_set_representation_base (Serializer* self, guint representation_base) {
	guint _tmp0_ = 0U;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = representation_base;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->representation_base = _tmp0_;
#line 680 "serializer.c"
}


guint serializer_get_representation_base (Serializer* self) {
	guint result = 0U;
	guint _tmp0_ = 0U;
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->representation_base;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 695 "serializer.c"
}


void serializer_set_radix (Serializer* self, gunichar radix) {
	gunichar _tmp0_ = 0U;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = radix;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->radix = _tmp0_;
#line 707 "serializer.c"
}


gunichar serializer_get_radix (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_ = 0U;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->radix;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 722 "serializer.c"
}


void serializer_set_thousands_separator (Serializer* self, gunichar separator) {
	gunichar _tmp0_ = 0U;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = separator;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->tsep = _tmp0_;
#line 734 "serializer.c"
}


gunichar serializer_get_thousands_separator (Serializer* self) {
	gunichar result = 0U;
	gunichar _tmp0_ = 0U;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->tsep;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 749 "serializer.c"
}


gint serializer_get_thousands_separator_count (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->tsep_count;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 764 "serializer.c"
}


void serializer_set_thousands_separator_count (Serializer* self, gint count) {
	gint _tmp0_ = 0;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = count;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->tsep_count = _tmp0_;
#line 776 "serializer.c"
}


void serializer_set_show_thousands_separators (Serializer* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = visible;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->show_tsep = _tmp0_;
#line 788 "serializer.c"
}


gboolean serializer_get_show_thousands_separators (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->show_tsep;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 803 "serializer.c"
}


void serializer_set_show_trailing_zeroes (Serializer* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
#line 198 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = visible;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->show_zeroes = _tmp0_;
#line 815 "serializer.c"
}


gboolean serializer_get_show_trailing_zeroes (Serializer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 203 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->show_zeroes;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 830 "serializer.c"
}


gint serializer_get_leading_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->leading_digits;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 845 "serializer.c"
}


void serializer_set_leading_digits (Serializer* self, gint leading_digits) {
	gint _tmp0_ = 0;
#line 213 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = leading_digits;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->leading_digits = _tmp0_;
#line 857 "serializer.c"
}


gint serializer_get_trailing_digits (Serializer* self) {
	gint result = 0;
	gint _tmp0_ = 0;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->trailing_digits;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 872 "serializer.c"
}


void serializer_set_trailing_digits (Serializer* self, gint trailing_digits) {
	gint _tmp0_ = 0;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = trailing_digits;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->trailing_digits = _tmp0_;
#line 884 "serializer.c"
}


DisplayFormat serializer_get_number_format (Serializer* self) {
	DisplayFormat result = 0;
	DisplayFormat _tmp0_ = 0;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->format;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 899 "serializer.c"
}


void serializer_set_number_format (Serializer* self, DisplayFormat format) {
	DisplayFormat _tmp0_ = 0;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = format;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->format = _tmp0_;
#line 911 "serializer.c"
}


static gchar* serializer_cast_to_string (Serializer* self, Number* x, gint* n_digits) {
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_ = NULL;
	Number* x_real = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GString* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GString* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = g_string_sized_new ((gsize) 1024);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	string = _tmp0_;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = x;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = number_real_component (_tmp1_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	x_real = _tmp2_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = x_real;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp4_ = self->priv->representation_base;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp5_ = string;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	serializer_cast_to_string_real (self, _tmp3_, (gint) _tmp4_, FALSE, n_digits, _tmp5_);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = x;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp7_ = number_is_complex (_tmp6_);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp7_) {
#line 958 "serializer.c"
		Number* x_im = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gboolean force_sign = FALSE;
		GString* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		GString* s = NULL;
		GString* _tmp13_ = NULL;
		gint n_complex_digits = 0;
		Number* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		gboolean _tmp16_ = FALSE;
		GString* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		GString* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp8_ = x;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp9_ = number_imaginary_component (_tmp8_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		x_im = _tmp9_;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		force_sign = TRUE;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp10_ = string;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp11_ = _tmp10_->str;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (g_strcmp0 (_tmp11_, "0") == 0) {
#line 992 "serializer.c"
			GString* _tmp12_ = NULL;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp12_ = string;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_assign (_tmp12_, "");
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			force_sign = FALSE;
#line 1000 "serializer.c"
		}
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp13_ = g_string_sized_new ((gsize) 1024);
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		s = _tmp13_;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		n_complex_digits = 0;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp14_ = x_im;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp15_ = self->priv->representation_base;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp16_ = force_sign;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp17_ = s;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		serializer_cast_to_string_real (self, _tmp14_, (gint) _tmp15_, _tmp16_, &n_complex_digits, _tmp17_);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp18_ = n_complex_digits;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp19_ = *n_digits;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp18_ > _tmp19_) {
#line 1024 "serializer.c"
			gint _tmp20_ = 0;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp20_ = n_complex_digits;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			*n_digits = _tmp20_;
#line 1030 "serializer.c"
		}
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp23_ = s;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp24_ = _tmp23_->str;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (g_strcmp0 (_tmp24_, "0") == 0) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp22_ = TRUE;
#line 1040 "serializer.c"
		} else {
			GString* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp25_ = s;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp26_ = _tmp25_->str;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp22_ = g_strcmp0 (_tmp26_, "+0") == 0;
#line 1050 "serializer.c"
		}
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp22_) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp21_ = TRUE;
#line 1056 "serializer.c"
		} else {
			GString* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp27_ = s;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp28_ = _tmp27_->str;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp21_ = g_strcmp0 (_tmp28_, "−0") == 0;
#line 1066 "serializer.c"
		}
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp21_) {
#line 1070 "serializer.c"
		} else {
			GString* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp29_ = s;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp30_ = _tmp29_->str;
#line 264 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (g_strcmp0 (_tmp30_, "1") == 0) {
#line 1080 "serializer.c"
				GString* _tmp31_ = NULL;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp31_ = string;
#line 266 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_append (_tmp31_, "i");
#line 1086 "serializer.c"
			} else {
				GString* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp32_ = s;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp33_ = _tmp32_->str;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (g_strcmp0 (_tmp33_, "+1") == 0) {
#line 1096 "serializer.c"
					GString* _tmp34_ = NULL;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp34_ = string;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					g_string_append (_tmp34_, "+i");
#line 1102 "serializer.c"
				} else {
					GString* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp35_ = s;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp36_ = _tmp35_->str;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (g_strcmp0 (_tmp36_, "−1") == 0) {
#line 1112 "serializer.c"
						GString* _tmp37_ = NULL;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp37_ = string;
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						g_string_append (_tmp37_, "−i");
#line 1118 "serializer.c"
					} else {
						GString* _tmp38_ = NULL;
						const gchar* _tmp39_ = NULL;
						GString* _tmp46_ = NULL;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp38_ = s;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp39_ = _tmp38_->str;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						if (g_strcmp0 (_tmp39_, "+0") == 0) {
#line 1129 "serializer.c"
							GString* _tmp40_ = NULL;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp40_ = string;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							g_string_append (_tmp40_, "+");
#line 1135 "serializer.c"
						} else {
							GString* _tmp41_ = NULL;
							const gchar* _tmp42_ = NULL;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp41_ = s;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp42_ = _tmp41_->str;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							if (g_strcmp0 (_tmp42_, "0") != 0) {
#line 1145 "serializer.c"
								GString* _tmp43_ = NULL;
								GString* _tmp44_ = NULL;
								const gchar* _tmp45_ = NULL;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp43_ = string;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp44_ = s;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp45_ = _tmp44_->str;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								g_string_append (_tmp43_, _tmp45_);
#line 1157 "serializer.c"
							}
						}
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp46_ = string;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						g_string_append (_tmp46_, "i");
#line 1164 "serializer.c"
					}
				}
			}
		}
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_string_free0 (s);
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_object_unref0 (x_im);
#line 1173 "serializer.c"
	}
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp47_ = string;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp48_ = _tmp47_->str;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp49_ = g_strdup (_tmp48_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp49_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (x_real);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_string_free0 (string);
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 1189 "serializer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return self ? g_object_ref (self) : NULL;
#line 1196 "serializer.c"
}


static void serializer_cast_to_string_real (Serializer* self, Number* x, gint number_base, gboolean force_sign, gint* n_digits, GString* string) {
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	static const gchar digits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
#line 1203 "serializer.c"
	Number* number = NULL;
	Number* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	Number* temp = NULL;
	gint _tmp6_ = 0;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Number* _tmp10_ = NULL;
	Number* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Number* rounded_number = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	Number* _tmp20_ = NULL;
	gint i = 0;
	gssize last_non_zero = 0L;
	GString* _tmp58_ = NULL;
	gssize _tmp59_ = 0L;
	GString* _tmp60_ = NULL;
	gunichar _tmp61_ = 0U;
	Number* _tmp62_ = NULL;
	Number* _tmp63_ = NULL;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp91_ = FALSE;
	GString* _tmp92_ = NULL;
	const gchar* _tmp93_ = NULL;
	gint _tmp100_ = 0;
	gint _tmp101_ = 0;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (x != NULL);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (string != NULL);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = x;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	number = _tmp1_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = number;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = number_is_negative (_tmp2_);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp3_) {
#line 1259 "serializer.c"
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp4_ = number;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp5_ = number_abs (_tmp4_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_object_unref0 (number);
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		number = _tmp5_;
#line 1270 "serializer.c"
	}
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = number_base;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp7_ = number_new_integer ((gint64) _tmp6_);
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp7_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp8_ = temp;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp9_ = self->priv->trailing_digits;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp10_ = number_xpowy_integer (_tmp8_, (gint64) (-(_tmp9_ + 1)));
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp10_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp11_ = temp;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp12_ = number_base;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp13_ = number_multiply_integer (_tmp11_, (gint64) _tmp12_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp13_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp14_ = temp;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp15_ = number_divide_integer (_tmp14_, (gint64) 2);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp15_;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp16_ = number;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp17_ = temp;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp18_ = number_add (_tmp16_, _tmp17_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	rounded_number = _tmp18_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp19_ = rounded_number;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp20_ = number_floor (_tmp19_);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp20_;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	i = 0;
#line 1324 "serializer.c"
	{
		gboolean _tmp21_ = FALSE;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp21_ = TRUE;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1331 "serializer.c"
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			gint _tmp26_ = 0;
			gint _tmp32_ = 0;
			Number* t = NULL;
			Number* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			Number* _tmp35_ = NULL;
			Number* _tmp36_ = NULL;
			Number* _tmp37_ = NULL;
			Number* t2 = NULL;
			Number* _tmp38_ = NULL;
			gint _tmp39_ = 0;
			Number* _tmp40_ = NULL;
			Number* t3 = NULL;
			Number* _tmp41_ = NULL;
			Number* _tmp42_ = NULL;
			Number* _tmp43_ = NULL;
			gint64 d = 0LL;
			Number* _tmp44_ = NULL;
			gint64 _tmp45_ = 0LL;
			gboolean _tmp46_ = FALSE;
			gint64 _tmp47_ = 0LL;
			gint _tmp55_ = 0;
			Number* _tmp56_ = NULL;
			Number* _tmp57_ = NULL;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp21_) {
#line 1360 "serializer.c"
				Number* _tmp22_ = NULL;
				gboolean _tmp23_ = FALSE;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp22_ = temp;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp23_ = number_is_zero (_tmp22_);
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (!(!_tmp23_)) {
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					break;
#line 1371 "serializer.c"
				}
			}
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp21_ = FALSE;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp26_ = number_base;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp26_ == 10) {
#line 1380 "serializer.c"
				gboolean _tmp27_ = FALSE;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp27_ = self->priv->show_tsep;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp25_ = _tmp27_;
#line 1386 "serializer.c"
			} else {
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp25_ = FALSE;
#line 1390 "serializer.c"
			}
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp25_) {
#line 1394 "serializer.c"
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp28_ = i;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp29_ = self->priv->tsep_count;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp24_ = _tmp28_ == _tmp29_;
#line 1403 "serializer.c"
			} else {
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp24_ = FALSE;
#line 1407 "serializer.c"
			}
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp24_) {
#line 1411 "serializer.c"
				GString* _tmp30_ = NULL;
				gunichar _tmp31_ = 0U;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp30_ = string;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp31_ = self->priv->tsep;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_prepend_unichar (_tmp30_, _tmp31_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				i = 0;
#line 1422 "serializer.c"
			}
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp32_ = i;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			i = _tmp32_ + 1;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp33_ = temp;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp34_ = number_base;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp35_ = number_divide_integer (_tmp33_, (gint64) _tmp34_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			t = _tmp35_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp36_ = t;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp37_ = number_floor (_tmp36_);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (t);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			t = _tmp37_;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp38_ = t;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp39_ = number_base;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp40_ = number_multiply_integer (_tmp38_, (gint64) _tmp39_);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			t2 = _tmp40_;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp41_ = temp;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp42_ = t2;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp43_ = number_subtract (_tmp41_, _tmp42_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			t3 = _tmp43_;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp44_ = t3;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp45_ = number_to_integer (_tmp44_);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			d = _tmp45_;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp47_ = d;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp47_ < ((gint64) 16)) {
#line 1470 "serializer.c"
				gint64 _tmp48_ = 0LL;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp48_ = d;
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp46_ = _tmp48_ >= ((gint64) 0);
#line 1476 "serializer.c"
			} else {
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp46_ = FALSE;
#line 1480 "serializer.c"
			}
#line 325 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp46_) {
#line 1484 "serializer.c"
				GString* _tmp49_ = NULL;
				gint64 _tmp50_ = 0LL;
				gchar _tmp51_ = '\0';
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp49_ = string;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp50_ = d;
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp51_ = digits[_tmp50_];
#line 327 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_prepend_c (_tmp49_, _tmp51_);
#line 1496 "serializer.c"
			} else {
				GString* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				GString* _tmp54_ = NULL;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp52_ = string;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_prepend_c (_tmp52_, '?');
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp53_ = _ ("Precision error");
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				serializer_set_error (self, _tmp53_);
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp54_ = string;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_assign (_tmp54_, "0");
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_g_object_unref0 (t3);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_g_object_unref0 (t2);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_g_object_unref0 (t);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1521 "serializer.c"
			}
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp55_ = *n_digits;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			*n_digits = _tmp55_ + 1;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp56_ = t;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp57_ = _g_object_ref0 (_tmp56_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (temp);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			temp = _tmp57_;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (t3);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (t2);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (t);
#line 1541 "serializer.c"
		}
	}
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp58_ = string;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp59_ = _tmp58_->len;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	last_non_zero = _tmp59_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp60_ = string;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp61_ = self->priv->radix;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_string_append_unichar (_tmp60_, _tmp61_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp62_ = rounded_number;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp63_ = number_fractional_component (_tmp62_);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	temp = _tmp63_;
#line 1564 "serializer.c"
	{
		gboolean _tmp64_ = FALSE;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		i = 0;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp64_ = TRUE;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1573 "serializer.c"
			gint _tmp66_ = 0;
			gint _tmp67_ = 0;
			Number* _tmp68_ = NULL;
			gboolean _tmp69_ = FALSE;
			Number* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			Number* _tmp72_ = NULL;
			Number* digit = NULL;
			Number* _tmp73_ = NULL;
			Number* _tmp74_ = NULL;
			gint64 d = 0LL;
			Number* _tmp75_ = NULL;
			gint64 _tmp76_ = 0LL;
			GString* _tmp77_ = NULL;
			gint64 _tmp78_ = 0LL;
			gchar _tmp79_ = '\0';
			gint64 _tmp80_ = 0LL;
			Number* _tmp83_ = NULL;
			Number* _tmp84_ = NULL;
			Number* _tmp85_ = NULL;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp64_) {
#line 1596 "serializer.c"
				gint _tmp65_ = 0;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp65_ = i;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				i = _tmp65_ + 1;
#line 1602 "serializer.c"
			}
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp64_ = FALSE;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp66_ = i;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp67_ = self->priv->trailing_digits;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!(_tmp66_ < _tmp67_)) {
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1614 "serializer.c"
			}
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp68_ = temp;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp69_ = number_is_zero (_tmp68_);
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp69_) {
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1624 "serializer.c"
			}
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp70_ = temp;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp71_ = number_base;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp72_ = number_multiply_integer (_tmp70_, (gint64) _tmp71_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (temp);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			temp = _tmp72_;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp73_ = temp;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp74_ = number_floor (_tmp73_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			digit = _tmp74_;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp75_ = digit;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp76_ = number_to_integer (_tmp75_);
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			d = _tmp76_;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp77_ = string;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp78_ = d;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp79_ = digits[_tmp78_];
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_append_c (_tmp77_, _tmp79_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp80_ = d;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp80_ != ((gint64) 0)) {
#line 1660 "serializer.c"
				GString* _tmp81_ = NULL;
				gssize _tmp82_ = 0L;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp81_ = string;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp82_ = _tmp81_->len;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				last_non_zero = _tmp82_;
#line 1669 "serializer.c"
			}
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp83_ = temp;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp84_ = digit;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp85_ = number_subtract (_tmp83_, _tmp84_);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (temp);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			temp = _tmp85_;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (digit);
#line 1683 "serializer.c"
		}
	}
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp87_ = self->priv->show_zeroes;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (!_tmp87_) {
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp86_ = TRUE;
#line 1692 "serializer.c"
	} else {
		gint _tmp88_ = 0;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp88_ = self->priv->trailing_digits;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp86_ = _tmp88_ == 0;
#line 1699 "serializer.c"
	}
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp86_) {
#line 1703 "serializer.c"
		GString* _tmp89_ = NULL;
		gssize _tmp90_ = 0L;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp89_ = string;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp90_ = last_non_zero;
#line 365 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		g_string_truncate (_tmp89_, (gsize) _tmp90_);
#line 1712 "serializer.c"
	}
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp92_ = string;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp93_ = _tmp92_->str;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (g_strcmp0 (_tmp93_, "0") != 0) {
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp91_ = TRUE;
#line 1722 "serializer.c"
	} else {
		gboolean _tmp94_ = FALSE;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp94_ = force_sign;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp91_ = _tmp94_;
#line 1729 "serializer.c"
	}
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp91_) {
#line 1733 "serializer.c"
		Number* _tmp95_ = NULL;
		gboolean _tmp96_ = FALSE;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp95_ = x;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp96_ = number_is_negative (_tmp95_);
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp96_) {
#line 1742 "serializer.c"
			GString* _tmp97_ = NULL;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp97_ = string;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_prepend (_tmp97_, "−");
#line 1748 "serializer.c"
		} else {
			gboolean _tmp98_ = FALSE;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp98_ = force_sign;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp98_) {
#line 1755 "serializer.c"
				GString* _tmp99_ = NULL;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp99_ = string;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_prepend (_tmp99_, "+");
#line 1761 "serializer.c"
			}
		}
	}
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp100_ = number_base;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp101_ = self->priv->number_base;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp100_ != _tmp101_) {
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		static const gchar* sub_digits[] = {"₀", "₁", "₂", "₃", "₄", "₅", "₆", "₇", "₈", "₉"};
#line 1773 "serializer.c"
		gint multiplier = 0;
		gint b = 0;
		gint _tmp102_ = 0;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		multiplier = 1;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp102_ = number_base;
#line 381 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		b = _tmp102_;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1785 "serializer.c"
			gint _tmp103_ = 0;
			gint _tmp104_ = 0;
			gint _tmp105_ = 0;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp103_ = number_base;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp104_ = multiplier;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!((_tmp103_ / _tmp104_) != 0)) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1797 "serializer.c"
			}
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp105_ = multiplier;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			multiplier = _tmp105_ * 10;
#line 1803 "serializer.c"
		}
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1807 "serializer.c"
			gint _tmp106_ = 0;
			gint d = 0;
			gint _tmp107_ = 0;
			gint _tmp108_ = 0;
			gint _tmp109_ = 0;
			GString* _tmp110_ = NULL;
			gint _tmp111_ = 0;
			const gchar* _tmp112_ = NULL;
			gint _tmp113_ = 0;
			gint _tmp114_ = 0;
			gint _tmp115_ = 0;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp106_ = multiplier;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!(_tmp106_ != 1)) {
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1825 "serializer.c"
			}
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp107_ = multiplier;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			multiplier = _tmp107_ / 10;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp108_ = b;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp109_ = multiplier;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			d = _tmp108_ / _tmp109_;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp110_ = string;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp111_ = d;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp112_ = sub_digits[_tmp111_];
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_append (_tmp110_, _tmp112_);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp113_ = b;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp114_ = d;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp115_ = multiplier;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			b = _tmp113_ - (_tmp114_ * _tmp115_);
#line 1853 "serializer.c"
		}
	}
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (rounded_number);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (temp);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (number);
#line 1862 "serializer.c"
}


static gint serializer_cast_to_exponential_string_real (Serializer* self, Number* x, GString* string, gboolean eng_format, gint* n_digits) {
	gint result = 0;
	Number* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Number* mantissa = NULL;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	Number* base_ = NULL;
	gint _tmp5_ = 0;
	Number* _tmp6_ = NULL;
	Number* base3 = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	Number* base10 = NULL;
	Number* _tmp9_ = NULL;
	Number* _tmp10_ = NULL;
	Number* t = NULL;
	Number* _tmp11_ = NULL;
	Number* base10inv = NULL;
	Number* _tmp12_ = NULL;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
	gint exponent = 0;
	Number* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GString* _tmp64_ = NULL;
	Number* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (x != NULL, 0);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (string != NULL, 0);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = x;
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = number_is_negative (_tmp0_);
#line 398 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp1_) {
#line 1907 "serializer.c"
		GString* _tmp2_ = NULL;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp2_ = string;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		g_string_append (_tmp2_, "−");
#line 1913 "serializer.c"
	}
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = x;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp4_ = number_abs (_tmp3_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	mantissa = _tmp4_;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp5_ = self->priv->number_base;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = number_new_integer ((gint64) _tmp5_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	base_ = _tmp6_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp7_ = base_;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp8_ = number_xpowy_integer (_tmp7_, (gint64) 3);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	base3 = _tmp8_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp9_ = base_;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp10_ = number_xpowy_integer (_tmp9_, (gint64) 10);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	base10 = _tmp10_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp11_ = number_new_integer ((gint64) 1);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	t = _tmp11_;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp12_ = t;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp13_ = base10;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp14_ = number_divide (_tmp12_, _tmp13_);
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	base10inv = _tmp14_;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	exponent = 0;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp15_ = mantissa;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp16_ = number_is_zero (_tmp15_);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (!_tmp16_) {
#line 1959 "serializer.c"
		Number* _tmp52_ = NULL;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 1963 "serializer.c"
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			gint _tmp22_ = 0;
			Number* _tmp23_ = NULL;
			Number* _tmp24_ = NULL;
			Number* _tmp25_ = NULL;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp18_ = eng_format;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp18_) {
#line 1974 "serializer.c"
				Number* _tmp19_ = NULL;
				Number* _tmp20_ = NULL;
				gint _tmp21_ = 0;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp19_ = mantissa;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp20_ = base10;
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp21_ = number_compare (_tmp19_, _tmp20_);
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp17_ = _tmp21_ >= 0;
#line 1986 "serializer.c"
			} else {
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp17_ = FALSE;
#line 1990 "serializer.c"
			}
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp17_) {
#line 412 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 1996 "serializer.c"
			}
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp22_ = exponent;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			exponent = _tmp22_ + 10;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp23_ = mantissa;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp24_ = base10inv;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp25_ = number_multiply (_tmp23_, _tmp24_);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (mantissa);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			mantissa = _tmp25_;
#line 2012 "serializer.c"
		}
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 2016 "serializer.c"
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			gint _tmp39_ = 0;
			Number* _tmp40_ = NULL;
			Number* _tmp41_ = NULL;
			Number* _tmp42_ = NULL;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp28_ = eng_format;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp28_) {
#line 2028 "serializer.c"
				Number* _tmp29_ = NULL;
				Number* _tmp30_ = NULL;
				gint _tmp31_ = 0;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp29_ = mantissa;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp30_ = base_;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp31_ = number_compare (_tmp29_, _tmp30_);
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp27_ = _tmp31_ >= 0;
#line 2040 "serializer.c"
			} else {
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp27_ = FALSE;
#line 2044 "serializer.c"
			}
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp27_) {
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp26_ = TRUE;
#line 2050 "serializer.c"
			} else {
				gboolean _tmp32_ = FALSE;
				gboolean _tmp33_ = FALSE;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp33_ = eng_format;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (_tmp33_) {
#line 2058 "serializer.c"
					gboolean _tmp34_ = FALSE;
					Number* _tmp35_ = NULL;
					Number* _tmp36_ = NULL;
					gint _tmp37_ = 0;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp35_ = mantissa;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp36_ = base3;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp37_ = number_compare (_tmp35_, _tmp36_);
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (_tmp37_ >= 0) {
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp34_ = TRUE;
#line 2073 "serializer.c"
					} else {
						gint _tmp38_ = 0;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp38_ = exponent;
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp34_ = (_tmp38_ % 3) != 0;
#line 2080 "serializer.c"
					}
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp32_ = _tmp34_;
#line 2084 "serializer.c"
				} else {
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp32_ = FALSE;
#line 2088 "serializer.c"
				}
#line 419 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp26_ = _tmp32_;
#line 2092 "serializer.c"
			}
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp26_) {
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 2098 "serializer.c"
			}
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp39_ = exponent;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			exponent = _tmp39_ + 1;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp40_ = mantissa;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp41_ = base_;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp42_ = number_divide (_tmp40_, _tmp41_);
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (mantissa);
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			mantissa = _tmp42_;
#line 2114 "serializer.c"
		}
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 2118 "serializer.c"
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_ = FALSE;
			gint _tmp48_ = 0;
			Number* _tmp49_ = NULL;
			Number* _tmp50_ = NULL;
			Number* _tmp51_ = NULL;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp44_ = eng_format;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp44_) {
#line 2129 "serializer.c"
				Number* _tmp45_ = NULL;
				Number* _tmp46_ = NULL;
				gint _tmp47_ = 0;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp45_ = mantissa;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp46_ = base10inv;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp47_ = number_compare (_tmp45_, _tmp46_);
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp43_ = _tmp47_ < 0;
#line 2141 "serializer.c"
			} else {
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp43_ = FALSE;
#line 2145 "serializer.c"
			}
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp43_) {
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 2151 "serializer.c"
			}
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp48_ = exponent;
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			exponent = _tmp48_ - 10;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp49_ = mantissa;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp50_ = base10;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp51_ = number_multiply (_tmp49_, _tmp50_);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (mantissa);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			mantissa = _tmp51_;
#line 2167 "serializer.c"
		}
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp52_ = number_new_integer ((gint64) 1);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_object_unref0 (t);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		t = _tmp52_;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		while (TRUE) {
#line 2177 "serializer.c"
			gboolean _tmp53_ = FALSE;
			Number* _tmp54_ = NULL;
			Number* _tmp55_ = NULL;
			gint _tmp56_ = 0;
			gint _tmp60_ = 0;
			Number* _tmp61_ = NULL;
			Number* _tmp62_ = NULL;
			Number* _tmp63_ = NULL;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp54_ = mantissa;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp55_ = t;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp56_ = number_compare (_tmp54_, _tmp55_);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (_tmp56_ < 0) {
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp53_ = TRUE;
#line 2196 "serializer.c"
			} else {
				gboolean _tmp57_ = FALSE;
				gboolean _tmp58_ = FALSE;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp58_ = eng_format;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (_tmp58_) {
#line 2204 "serializer.c"
					gint _tmp59_ = 0;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp59_ = exponent;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp57_ = (_tmp59_ % 3) != 0;
#line 2210 "serializer.c"
				} else {
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp57_ = FALSE;
#line 2214 "serializer.c"
				}
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp53_ = _tmp57_;
#line 2218 "serializer.c"
			}
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (!_tmp53_) {
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				break;
#line 2224 "serializer.c"
			}
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp60_ = exponent;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			exponent = _tmp60_ - 1;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp61_ = mantissa;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp62_ = base_;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp63_ = number_multiply (_tmp61_, _tmp62_);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_g_object_unref0 (mantissa);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			mantissa = _tmp63_;
#line 2240 "serializer.c"
		}
	}
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp64_ = string;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp65_ = mantissa;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp66_ = serializer_cast_to_string (self, _tmp65_, n_digits);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp67_ = _tmp66_;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_string_append (_tmp64_, _tmp67_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (_tmp67_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = exponent;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (base10inv);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (t);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (base10);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (base3);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (base_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (mantissa);
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 2271 "serializer.c"
}


static gchar* serializer_cast_to_exponential_string (Serializer* self, Number* x, gboolean eng_format, gint* n_digits) {
	gchar* result = NULL;
	GString* string = NULL;
	GString* _tmp0_ = NULL;
	Number* x_real = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	gint exponent = 0;
	Number* _tmp3_ = NULL;
	GString* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	GString* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	Number* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GString* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = g_string_sized_new ((gsize) 1024);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	string = _tmp0_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = x;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = number_real_component (_tmp1_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	x_real = _tmp2_;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp3_ = x_real;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp4_ = string;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp5_ = eng_format;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = serializer_cast_to_exponential_string_real (self, _tmp3_, _tmp4_, _tmp5_, n_digits);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	exponent = _tmp6_;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp7_ = string;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp8_ = exponent;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	serializer_append_exponent (self, _tmp7_, _tmp8_);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp9_ = x;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp10_ = number_is_complex (_tmp9_);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp10_) {
#line 2330 "serializer.c"
		Number* x_im = NULL;
		Number* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		GString* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		GString* s = NULL;
		GString* _tmp16_ = NULL;
		gint n_complex_digits = 0;
		Number* _tmp17_ = NULL;
		GString* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		GString* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		GString* _tmp50_ = NULL;
		gint _tmp51_ = 0;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp11_ = x;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp12_ = number_imaginary_component (_tmp11_);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		x_im = _tmp12_;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp13_ = string;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp14_ = _tmp13_->str;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (g_strcmp0 (_tmp14_, "0") == 0) {
#line 2363 "serializer.c"
			GString* _tmp15_ = NULL;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp15_ = string;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			g_string_assign (_tmp15_, "");
#line 2369 "serializer.c"
		}
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp16_ = g_string_sized_new ((gsize) 1024);
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		s = _tmp16_;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		n_complex_digits = 0;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp17_ = x_im;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp18_ = s;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp19_ = eng_format;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp20_ = serializer_cast_to_exponential_string_real (self, _tmp17_, _tmp18_, _tmp19_, &n_complex_digits);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		exponent = _tmp20_;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp21_ = n_complex_digits;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp22_ = *n_digits;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp21_ > _tmp22_) {
#line 2393 "serializer.c"
			gint _tmp23_ = 0;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp23_ = n_complex_digits;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			*n_digits = _tmp23_;
#line 2399 "serializer.c"
		}
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp26_ = s;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp27_ = _tmp26_->str;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (g_strcmp0 (_tmp27_, "0") == 0) {
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp25_ = TRUE;
#line 2409 "serializer.c"
		} else {
			GString* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp28_ = s;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp29_ = _tmp28_->str;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp25_ = g_strcmp0 (_tmp29_, "+0") == 0;
#line 2419 "serializer.c"
		}
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp25_) {
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp24_ = TRUE;
#line 2425 "serializer.c"
		} else {
			GString* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp30_ = s;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp31_ = _tmp30_->str;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp24_ = g_strcmp0 (_tmp31_, "−0") == 0;
#line 2435 "serializer.c"
		}
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		if (_tmp24_) {
#line 2439 "serializer.c"
		} else {
			GString* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp32_ = s;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp33_ = _tmp32_->str;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			if (g_strcmp0 (_tmp33_, "1") == 0) {
#line 2449 "serializer.c"
				GString* _tmp34_ = NULL;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp34_ = string;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_append (_tmp34_, "i");
#line 2455 "serializer.c"
			} else {
				GString* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp35_ = s;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp36_ = _tmp35_->str;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (g_strcmp0 (_tmp36_, "+1") == 0) {
#line 2465 "serializer.c"
					GString* _tmp37_ = NULL;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp37_ = string;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					g_string_append (_tmp37_, "+i");
#line 2471 "serializer.c"
				} else {
					GString* _tmp38_ = NULL;
					const gchar* _tmp39_ = NULL;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp38_ = s;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp39_ = _tmp38_->str;
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					if (g_strcmp0 (_tmp39_, "−1") == 0) {
#line 2481 "serializer.c"
						GString* _tmp40_ = NULL;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp40_ = string;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						g_string_append (_tmp40_, "−i");
#line 2487 "serializer.c"
					} else {
						GString* _tmp41_ = NULL;
						const gchar* _tmp42_ = NULL;
						GString* _tmp49_ = NULL;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp41_ = s;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp42_ = _tmp41_->str;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						if (g_strcmp0 (_tmp42_, "+0") == 0) {
#line 2498 "serializer.c"
							GString* _tmp43_ = NULL;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp43_ = string;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							g_string_append (_tmp43_, "+");
#line 2504 "serializer.c"
						} else {
							GString* _tmp44_ = NULL;
							const gchar* _tmp45_ = NULL;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp44_ = s;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							_tmp45_ = _tmp44_->str;
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
							if (g_strcmp0 (_tmp45_, "0") != 0) {
#line 2514 "serializer.c"
								GString* _tmp46_ = NULL;
								GString* _tmp47_ = NULL;
								const gchar* _tmp48_ = NULL;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp46_ = string;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp47_ = s;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								_tmp48_ = _tmp47_->str;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
								g_string_append (_tmp46_, _tmp48_);
#line 2526 "serializer.c"
							}
						}
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						_tmp49_ = string;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
						g_string_append (_tmp49_, "i");
#line 2533 "serializer.c"
					}
				}
			}
		}
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp50_ = string;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp51_ = exponent;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		serializer_append_exponent (self, _tmp50_, _tmp51_);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_string_free0 (s);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_g_object_unref0 (x_im);
#line 2548 "serializer.c"
	}
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp52_ = string;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp53_ = _tmp52_->str;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp54_ = g_strdup (_tmp53_);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp54_;
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_object_unref0 (x_real);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_string_free0 (string);
#line 492 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 2564 "serializer.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/home/mcatanzaro/jhbuild/install/share/vala-0.28/vapi/glib-2.0.vapi"
	return result;
#line 2582 "serializer.c"
}


static void serializer_append_exponent (Serializer* self, GString* string, gint exponent) {
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	static const gunichar super_digits[] = {8304U, 185U, 178U, 179U, 8308U, 8309U, 8310U, 8311U, 8312U, 8313U};
#line 2589 "serializer.c"
	gint _tmp0_ = 0;
	GString* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* super_value = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (string != NULL);
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = exponent;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp0_ == 0) {
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		return;
#line 2606 "serializer.c"
	}
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = string;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_string_append (_tmp1_, "×10");
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp2_ = exponent;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	if (_tmp2_ < 0) {
#line 2616 "serializer.c"
		gint _tmp3_ = 0;
		GString* _tmp4_ = NULL;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp3_ = exponent;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		exponent = -_tmp3_;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		_tmp4_ = string;
#line 506 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		g_string_append_unichar (_tmp4_, 8315U);
#line 2627 "serializer.c"
	}
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp5_ = exponent;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp6_ = g_strdup_printf ("%d", _tmp5_);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	super_value = _tmp6_;
#line 2635 "serializer.c"
	{
		gint i = 0;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		i = 0;
#line 2640 "serializer.c"
		{
			gboolean _tmp7_ = FALSE;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			_tmp7_ = TRUE;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
			while (TRUE) {
#line 2647 "serializer.c"
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				GString* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				gchar _tmp16_ = '\0';
				gunichar _tmp17_ = 0U;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (!_tmp7_) {
#line 2659 "serializer.c"
					gint _tmp8_ = 0;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					_tmp8_ = i;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					i = _tmp8_ + 1;
#line 2665 "serializer.c"
				}
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp7_ = FALSE;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp9_ = i;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp10_ = super_value;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp11_ = strlen (_tmp10_);
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp12_ = _tmp11_;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				if (!(_tmp9_ < _tmp12_)) {
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
					break;
#line 2681 "serializer.c"
				}
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp13_ = string;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp14_ = super_value;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp15_ = i;
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp16_ = string_get (_tmp14_, (glong) _tmp15_);
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				_tmp17_ = super_digits[_tmp16_ - '0'];
#line 511 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
				g_string_append_unichar (_tmp13_, _tmp17_);
#line 2695 "serializer.c"
			}
		}
	}
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (super_value);
#line 2701 "serializer.c"
}


const gchar* serializer_get_error (Serializer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = self->priv->_error;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	result = _tmp0_;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	return result;
#line 2716 "serializer.c"
}


void serializer_set_error (Serializer* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_return_if_fail (self != NULL);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp0_ = value;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (self->priv->_error);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->_error = _tmp1_;
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_object_notify ((GObject *) self, "error");
#line 2735 "serializer.c"
}


static void serializer_class_init (SerializerClass * klass) {
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	serializer_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_type_class_add_private (klass, sizeof (SerializerPrivate));
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_serializer_get_property;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_serializer_set_property;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = serializer_finalize;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SERIALIZER_ERROR, g_param_spec_string ("error", "error", "error", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2752 "serializer.c"
}


static void serializer_instance_init (Serializer * self) {
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv = SERIALIZER_GET_PRIVATE (self);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self->priv->_error = NULL;
#line 2761 "serializer.c"
}


static void serializer_finalize (GObject* obj) {
	Serializer * self;
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERIALIZER, Serializer);
#line 36 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	_g_free0 (self->priv->_error);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	G_OBJECT_CLASS (serializer_parent_class)->finalize (obj);
#line 2773 "serializer.c"
}


GType serializer_get_type (void) {
	static volatile gsize serializer_type_id__volatile = 0;
	if (g_once_init_enter (&serializer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SerializerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) serializer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Serializer), 0, (GInstanceInitFunc) serializer_instance_init, NULL };
		GType serializer_type_id;
		serializer_type_id = g_type_register_static (G_TYPE_OBJECT, "Serializer", &g_define_type_info, 0);
		g_once_init_leave (&serializer_type_id__volatile, serializer_type_id);
	}
	return serializer_type_id__volatile;
}


static void _vala_serializer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	switch (property_id) {
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case SERIALIZER_ERROR:
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		g_value_set_string (value, serializer_get_error (self));
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		break;
#line 2800 "serializer.c"
		default:
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		break;
#line 2806 "serializer.c"
	}
}


static void _vala_serializer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Serializer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SERIALIZER, Serializer);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
	switch (property_id) {
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		case SERIALIZER_ERROR:
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		serializer_set_error (self, g_value_get_string (value));
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		break;
#line 2822 "serializer.c"
		default:
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/mcatanzaro/jhbuild/checkout/gnome-calculator/src/serializer.vala"
		break;
#line 2828 "serializer.c"
	}
}



