/* ofono-backend.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from ofono-backend.vala, do not modify */

/*
 * Copyright (C) 2012 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Jeremy Whiting <jeremy.whiting@collabora.co.uk>
 *
 * Based on kf-backend.vala by:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks-internal.h>
#include <glib/gi18n-lib.h>


#define FOLKS_BACKENDS_OFONO_TYPE_BACKEND (folks_backends_ofono_backend_get_type ())
#define FOLKS_BACKENDS_OFONO_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend))
#define FOLKS_BACKENDS_OFONO_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackendClass))
#define FOLKS_BACKENDS_OFONO_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_OFONO_TYPE_BACKEND))
#define FOLKS_BACKENDS_OFONO_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_OFONO_TYPE_BACKEND))
#define FOLKS_BACKENDS_OFONO_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackendClass))

typedef struct _FolksBackendsOfonoBackend FolksBackendsOfonoBackend;
typedef struct _FolksBackendsOfonoBackendClass FolksBackendsOfonoBackendClass;
typedef struct _FolksBackendsOfonoBackendPrivate FolksBackendsOfonoBackendPrivate;

#define FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE (folks_backends_ofono_persona_store_get_type ())
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore))
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStoreClass))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_OFONO_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_OFONO_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStoreClass))

typedef struct _FolksBackendsOfonoPersonaStore FolksBackendsOfonoPersonaStore;
typedef struct _FolksBackendsOfonoPersonaStoreClass FolksBackendsOfonoPersonaStoreClass;

#define ORG_OFONO_TYPE_MODEM_PROPERTIES (org_ofono_modem_properties_get_type ())
typedef struct _orgofonoModemProperties orgofonoModemProperties;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ORG_OFONO_TYPE_MANAGER (org_ofono_manager_get_type ())
#define ORG_OFONO_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_OFONO_TYPE_MANAGER, orgofonoManager))
#define ORG_OFONO_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_OFONO_TYPE_MANAGER))
#define ORG_OFONO_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_OFONO_TYPE_MANAGER, orgofonoManagerIface))

typedef struct _orgofonoManager orgofonoManager;
typedef struct _orgofonoManagerIface orgofonoManagerIface;

#define ORG_OFONO_TYPE_MANAGER_PROXY (org_ofono_manager_proxy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsOfonoBackendPrepareData FolksBackendsOfonoBackendPrepareData;
typedef struct _FolksBackendsOfonoBackendUnprepareData FolksBackendsOfonoBackendUnprepareData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _FolksBackendsOfonoBackend {
	FolksBackend parent_instance;
	FolksBackendsOfonoBackendPrivate * priv;
};

struct _FolksBackendsOfonoBackendClass {
	FolksBackendClass parent_class;
};

struct _orgofonoModemProperties {
	char* path;
	GHashTable* properties;
};

struct _FolksBackendsOfonoBackendPrivate {
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
	orgofonoModemProperties* _modems;
	gint _modems_length1;
	gint __modems_size_;
};

struct _orgofonoManagerIface {
	GTypeInterface parent_iface;
	orgofonoModemProperties* (*GetModems) (orgofonoManager* self, int* result_length1, GError** error);
};

struct _FolksBackendsOfonoBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	orgofonoManager* manager;
	orgofonoManager* _tmp3_;
	orgofonoManager* _tmp4_;
	orgofonoManager* _tmp5_;
	orgofonoManager* _tmp6_;
	orgofonoManager* _tmp7_;
	orgofonoModemProperties* _tmp8_;
	orgofonoManager* _tmp9_;
	gint _tmp10_;
	orgofonoModemProperties* _tmp11_;
	gint _tmp8__length1;
	gint __tmp8__size_;
	orgofonoModemProperties* _tmp12_;
	gint _tmp12__length1;
	GError* e1;
	const gchar* _tmp13_;
	GError* _tmp14_;
	orgofonoModemProperties* _tmp15_;
	gint _tmp15__length1;
	orgofonoModemProperties* modem_collection;
	gint modem_collection_length1;
	gint _modem_collection_size_;
	gint modem_it;
	orgofonoModemProperties _tmp16_;
	orgofonoModemProperties modem;
	orgofonoModemProperties _tmp17_;
	const char* _tmp18_;
	orgofonoModemProperties _tmp19_;
	GHashTable* _tmp20_;
	GError * _inner_error_;
};

struct _FolksBackendsOfonoBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeIterator* _persona_store_it;
	GeeHashMap* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeIterator* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* _tmp9_;
	gboolean _tmp10_;
	FolksBackendsOfonoPersonaStore* persona_store;
	GeeIterator* _tmp11_;
	gpointer _tmp12_;
	FolksBackendsOfonoPersonaStore* _tmp13_;
	GeeHashMap* _tmp14_;
	GError * _inner_error_;
};


static gpointer folks_backends_ofono_backend_parent_class = NULL;

GType folks_backends_ofono_backend_get_type (void) G_GNUC_CONST;
GType folks_backends_ofono_persona_store_get_type (void) G_GNUC_CONST;
GType org_ofono_modem_properties_get_type (void) G_GNUC_CONST;
orgofonoModemProperties* org_ofono_modem_properties_dup (const orgofonoModemProperties* self);
void org_ofono_modem_properties_free (orgofonoModemProperties* self);
void org_ofono_modem_properties_copy (const orgofonoModemProperties* self, orgofonoModemProperties* dest);
void org_ofono_modem_properties_destroy (orgofonoModemProperties* self);
#define FOLKS_BACKENDS_OFONO_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackendPrivate))
enum  {
	FOLKS_BACKENDS_OFONO_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED,
	FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT,
	FOLKS_BACKENDS_OFONO_BACKEND_NAME,
	FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES
};
static void _vala_orgofonoModemProperties_array_free (orgofonoModemProperties* array, gint array_length);
static void folks_backends_ofono_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_ofono_backend_store_removed_cb (FolksBackendsOfonoBackend* self, FolksPersonaStore* store);
static void folks_backends_ofono_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store);
static void _folks_backends_ofono_backend_add_store (FolksBackendsOfonoBackend* self, FolksBackendsOfonoPersonaStore* store, gboolean notify);
static void folks_backends_ofono_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids);
static gchar* _folks_backends_ofono_backend_modem_alias (FolksBackendsOfonoBackend* self, GHashTable* properties);
FolksBackendsOfonoPersonaStore* folks_backends_ofono_persona_store_new (const char* path, const gchar* alias);
FolksBackendsOfonoPersonaStore* folks_backends_ofono_persona_store_construct (GType object_type, const char* path, const gchar* alias);
static void _vala_array_add1 (FolksBackendsOfonoPersonaStore*** array, int* length, int* size, FolksBackendsOfonoPersonaStore* value);
static void _folks_backends_ofono_backend_remove_store (FolksBackendsOfonoBackend* self, FolksBackendsOfonoPersonaStore* store, gboolean notify);
FolksBackendsOfonoBackend* folks_backends_ofono_backend_new (void);
FolksBackendsOfonoBackend* folks_backends_ofono_backend_construct (GType object_type);
static void _folks_backends_ofono_backend_add_modem (FolksBackendsOfonoBackend* self, const char* path, const gchar* alias);
static void folks_backends_ofono_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_ofono_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_ofono_backend_real_prepare_co (FolksBackendsOfonoBackendPrepareData* _data_);
GType org_ofono_manager_proxy_get_type (void) G_GNUC_CONST;
guint org_ofono_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_ofono_manager_get_type (void) G_GNUC_CONST;
static void folks_backends_ofono_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _folks_backends_ofono_backend_modem_added (FolksBackendsOfonoBackend* self, const char* path, GHashTable* properties);
static void __folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added (orgofonoManager* _sender, const char* path, GHashTable* properties, gpointer self);
static void _folks_backends_ofono_backend_modem_removed (FolksBackendsOfonoBackend* self, const char* path);
static void __folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed (orgofonoManager* _sender, const char* path, gpointer self);
orgofonoModemProperties* org_ofono_manager_GetModems (orgofonoManager* self, int* result_length1, GError** error);
static void folks_backends_ofono_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_ofono_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_ofono_backend_real_unprepare_co (FolksBackendsOfonoBackendUnprepareData* _data_);
static void __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static GObject * folks_backends_ofono_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_ofono_backend_finalize (GObject* obj);
static void _vala_folks_backends_ofono_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_orgofonoModemProperties_array_free (orgofonoModemProperties* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			org_ofono_modem_properties_destroy (&array[i]);
		}
	}
	g_free (array);
}


/**
   * {@inheritDoc}
   */
static void folks_backends_ofono_backend_real_disable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_) {
		FolksPersonaStore* _tmp5_ = NULL;
		_tmp5_ = store;
		_folks_backends_ofono_backend_store_removed_cb (self, _tmp5_);
	}
}


/**
   * {@inheritDoc}
   */
static void folks_backends_ofono_backend_real_enable_persona_store (FolksBackend* base, FolksPersonaStore* store) {
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp3_);
	if (_tmp4_ == FALSE) {
		FolksPersonaStore* _tmp5_ = NULL;
		_tmp5_ = store;
		_folks_backends_ofono_backend_add_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), TRUE);
	}
}


/**
   * {@inheritDoc}
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (FolksBackendsOfonoPersonaStore*** array, int* length, int* size, FolksBackendsOfonoPersonaStore* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksBackendsOfonoPersonaStore*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void folks_backends_ofono_backend_real_set_persona_stores (FolksBackend* base, GeeSet* storeids) {
	FolksBackendsOfonoBackend * self;
	gboolean added_stores = FALSE;
	FolksBackendsOfonoPersonaStore** removed_stores = NULL;
	FolksBackendsOfonoPersonaStore** _tmp0_ = NULL;
	gint removed_stores_length1 = 0;
	gint _removed_stores_size_ = 0;
	orgofonoModemProperties* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	added_stores = FALSE;
	_tmp0_ = g_new0 (FolksBackendsOfonoPersonaStore*, 0 + 1);
	removed_stores = _tmp0_;
	removed_stores_length1 = 0;
	_removed_stores_size_ = removed_stores_length1;
	_tmp1_ = self->priv->_modems;
	_tmp1__length1 = self->priv->_modems_length1;
	{
		orgofonoModemProperties* modem_collection = NULL;
		gint modem_collection_length1 = 0;
		gint _modem_collection_size_ = 0;
		gint modem_it = 0;
		modem_collection = _tmp1_;
		modem_collection_length1 = _tmp1__length1;
		for (modem_it = 0; modem_it < _tmp1__length1; modem_it = modem_it + 1) {
			orgofonoModemProperties _tmp2_ = {0};
			orgofonoModemProperties modem = {0};
			org_ofono_modem_properties_copy (&modem_collection[modem_it], &_tmp2_);
			modem = _tmp2_;
			{
				gboolean _tmp3_ = FALSE;
				GeeSet* _tmp4_ = NULL;
				orgofonoModemProperties _tmp5_ = {0};
				const char* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				_tmp4_ = storeids;
				_tmp5_ = modem;
				_tmp6_ = _tmp5_.path;
				_tmp7_ = gee_collection_contains ((GeeCollection*) _tmp4_, (const gchar*) _tmp6_);
				if (_tmp7_) {
					GeeHashMap* _tmp8_ = NULL;
					orgofonoModemProperties _tmp9_ = {0};
					const char* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					_tmp8_ = self->priv->_persona_stores;
					_tmp9_ = modem;
					_tmp10_ = _tmp9_.path;
					_tmp11_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, (const gchar*) _tmp10_);
					_tmp3_ = _tmp11_ == FALSE;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					gchar* alias = NULL;
					orgofonoModemProperties _tmp12_ = {0};
					GHashTable* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					FolksBackendsOfonoPersonaStore* store = NULL;
					orgofonoModemProperties _tmp15_ = {0};
					const char* _tmp16_ = NULL;
					const gchar* _tmp17_ = NULL;
					FolksBackendsOfonoPersonaStore* _tmp18_ = NULL;
					FolksBackendsOfonoPersonaStore* _tmp19_ = NULL;
					_tmp12_ = modem;
					_tmp13_ = _tmp12_.properties;
					_tmp14_ = _folks_backends_ofono_backend_modem_alias (self, _tmp13_);
					alias = _tmp14_;
					_tmp15_ = modem;
					_tmp16_ = _tmp15_.path;
					_tmp17_ = alias;
					_tmp18_ = folks_backends_ofono_persona_store_new (_tmp16_, _tmp17_);
					store = _tmp18_;
					_tmp19_ = store;
					_folks_backends_ofono_backend_add_store (self, _tmp19_, FALSE);
					added_stores = TRUE;
					_g_object_unref0 (store);
					_g_free0 (alias);
				}
				org_ofono_modem_properties_destroy (&modem);
			}
		}
	}
	{
		GeeIterator* _store_it = NULL;
		GeeHashMap* _tmp20_ = NULL;
		GeeCollection* _tmp21_ = NULL;
		GeeCollection* _tmp22_ = NULL;
		GeeCollection* _tmp23_ = NULL;
		GeeIterator* _tmp24_ = NULL;
		GeeIterator* _tmp25_ = NULL;
		_tmp20_ = self->priv->_persona_stores;
		_tmp21_ = gee_abstract_map_get_values ((GeeMap*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp24_ = gee_iterable_iterator ((GeeIterable*) _tmp23_);
		_tmp25_ = _tmp24_;
		_g_object_unref0 (_tmp23_);
		_store_it = _tmp25_;
		while (TRUE) {
			GeeIterator* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			FolksBackendsOfonoPersonaStore* store = NULL;
			GeeIterator* _tmp28_ = NULL;
			gpointer _tmp29_ = NULL;
			GeeSet* _tmp30_ = NULL;
			FolksBackendsOfonoPersonaStore* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			gboolean _tmp34_ = FALSE;
			_tmp26_ = _store_it;
			_tmp27_ = gee_iterator_next (_tmp26_);
			if (!_tmp27_) {
				break;
			}
			_tmp28_ = _store_it;
			_tmp29_ = gee_iterator_get (_tmp28_);
			store = (FolksBackendsOfonoPersonaStore*) _tmp29_;
			_tmp30_ = storeids;
			_tmp31_ = store;
			_tmp32_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = gee_collection_contains ((GeeCollection*) _tmp30_, _tmp33_);
			if (!_tmp34_) {
				FolksBackendsOfonoPersonaStore** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				FolksBackendsOfonoPersonaStore* _tmp36_ = NULL;
				FolksBackendsOfonoPersonaStore* _tmp37_ = NULL;
				_tmp35_ = removed_stores;
				_tmp35__length1 = removed_stores_length1;
				_tmp36_ = store;
				_tmp37_ = _g_object_ref0 (_tmp36_);
				_vala_array_add1 (&removed_stores, &removed_stores_length1, &_removed_stores_size_, _tmp37_);
			}
			_g_object_unref0 (store);
		}
		_g_object_unref0 (_store_it);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp38_ = FALSE;
			_tmp38_ = TRUE;
			while (TRUE) {
				gint _tmp40_ = 0;
				FolksBackendsOfonoPersonaStore** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				FolksBackendsOfonoPersonaStore** _tmp42_ = NULL;
				gint _tmp42__length1 = 0;
				gint _tmp43_ = 0;
				FolksBackendsOfonoPersonaStore* _tmp44_ = NULL;
				if (!_tmp38_) {
					gint _tmp39_ = 0;
					_tmp39_ = i;
					i = _tmp39_ + 1;
				}
				_tmp38_ = FALSE;
				_tmp40_ = i;
				_tmp41_ = removed_stores;
				_tmp41__length1 = removed_stores_length1;
				if (!(_tmp40_ < _tmp41__length1)) {
					break;
				}
				_tmp42_ = removed_stores;
				_tmp42__length1 = removed_stores_length1;
				_tmp43_ = i;
				_tmp44_ = _tmp42_[_tmp43_];
				_folks_backends_ofono_backend_remove_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), FALSE);
			}
		}
	}
	_tmp46_ = added_stores;
	if (_tmp46_) {
		_tmp45_ = TRUE;
	} else {
		FolksBackendsOfonoPersonaStore** _tmp47_ = NULL;
		gint _tmp47__length1 = 0;
		_tmp47_ = removed_stores;
		_tmp47__length1 = removed_stores_length1;
		_tmp45_ = _tmp47__length1 > 0;
	}
	if (_tmp45_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
	removed_stores = (_vala_array_free (removed_stores, removed_stores_length1, (GDestroyNotify) g_object_unref), NULL);
}


/**
   * {@inheritDoc}
   */
FolksBackendsOfonoBackend* folks_backends_ofono_backend_construct (GType object_type) {
	FolksBackendsOfonoBackend * self = NULL;
	self = (FolksBackendsOfonoBackend*) g_object_new (object_type, NULL);
	return self;
}


FolksBackendsOfonoBackend* folks_backends_ofono_backend_new (void) {
	return folks_backends_ofono_backend_construct (FOLKS_BACKENDS_OFONO_TYPE_BACKEND);
}


static void _folks_backends_ofono_backend_add_modem (FolksBackendsOfonoBackend* self, const char* path, const gchar* alias) {
	FolksBackendsOfonoPersonaStore* store = NULL;
	const char* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (alias != NULL);
	_tmp0_ = path;
	_tmp1_ = alias;
	_tmp2_ = folks_backends_ofono_persona_store_new (_tmp0_, _tmp1_);
	store = _tmp2_;
	_folks_backends_ofono_backend_add_store (self, store, TRUE);
	_g_object_unref0 (store);
}


static void folks_backends_ofono_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsOfonoBackendPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoBackendPrepareData, _data_);
}


static void folks_backends_ofono_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsOfonoBackend * self;
	FolksBackendsOfonoBackendPrepareData* _data_;
	FolksBackendsOfonoBackend* _tmp0_ = NULL;
	self = (FolksBackendsOfonoBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_ofono_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_ofono_backend_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_ofono_backend_real_prepare_co (_data_);
}


static void folks_backends_ofono_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsOfonoBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void folks_backends_ofono_backend_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsOfonoBackendPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_ofono_backend_real_prepare_co (_data_);
}


static void __folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added (orgofonoManager* _sender, const char* path, GHashTable* properties, gpointer self) {
	_folks_backends_ofono_backend_modem_added ((FolksBackendsOfonoBackend*) self, path, properties);
}


static void __folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed (orgofonoManager* _sender, const char* path, gpointer self) {
	_folks_backends_ofono_backend_modem_removed ((FolksBackendsOfonoBackend*) self, path);
}


static gboolean folks_backends_ofono_backend_real_prepare_co (FolksBackendsOfonoBackendPrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	folks_internal_profiling_start ("preparing Ofono.Backend", NULL);
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_;
	}
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		{
			_data_->_state_ = 1;
			g_async_initable_new_async (ORG_OFONO_TYPE_MANAGER_PROXY, 0, NULL, folks_backends_ofono_backend_prepare_ready, _data_, "g-flags", 0, "g-name", "org.ofono", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/", "g-interface-name", "org.ofono.Manager", "g-interface-info", g_type_get_qdata (ORG_OFONO_TYPE_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
			return FALSE;
			_state_1:
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
			_data_->_tmp3_ = (orgofonoManager*) _data_->_tmp4_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch1_g_error;
			}
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _data_->_tmp3_;
			_data_->_tmp3_ = NULL;
			_g_object_unref0 (_data_->manager);
			_data_->manager = _data_->_tmp5_;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->manager;
			g_signal_connect_object (_data_->_tmp6_, "modem-added", (GCallback) __folks_backends_ofono_backend_modem_added_org_ofono_manager_modem_added, _data_->self, 0);
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = _data_->manager;
			g_signal_connect_object (_data_->_tmp7_, "modem-removed", (GCallback) __folks_backends_ofono_backend_modem_removed_org_ofono_manager_modem_removed, _data_->self, 0);
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->manager;
			_data_->_tmp10_ = 0;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = org_ofono_manager_GetModems (_data_->_tmp9_, &_data_->_tmp10_, &_data_->_inner_error_);
			_data_->_tmp8__length1 = 0;
			_data_->__tmp8__size_ = 0;
			_data_->_tmp8_ = _data_->_tmp11_;
			_data_->_tmp8__length1 = _data_->_tmp10_;
			_data_->__tmp8__size_ = _data_->_tmp8__length1;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->_tmp3_);
				goto __catch1_g_error;
			}
			_data_->_tmp12_ = NULL;
			_data_->_tmp12__length1 = 0;
			_data_->_tmp12_ = _data_->_tmp8_;
			_data_->_tmp12__length1 = _data_->_tmp8__length1;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8__length1 = 0;
			_data_->self->priv->_modems = (_vala_orgofonoModemProperties_array_free (_data_->self->priv->_modems, _data_->self->priv->_modems_length1), NULL);
			_data_->self->priv->_modems = _data_->_tmp12_;
			_data_->self->priv->_modems_length1 = _data_->_tmp12__length1;
			_data_->self->priv->__modems_size_ = _data_->self->priv->_modems_length1;
			_data_->_tmp8_ = (_vala_orgofonoModemProperties_array_free (_data_->_tmp8_, _data_->_tmp8__length1), NULL);
			_g_object_unref0 (_data_->_tmp3_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->e1 = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _ ("No oFono object manager running, so the oFono backend will be inactive" \
". Either oFono isn’t installed or the service can’t be started.");
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_SERVICE_UNKNOWN, _data_->_tmp13_);
			_data_->_inner_error_ = _data_->_tmp14_;
			_g_error_free0 (_data_->e1);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->manager);
			goto __finally0;
		}
		_data_->_tmp15_ = NULL;
		_data_->_tmp15__length1 = 0;
		_data_->_tmp15_ = _data_->self->priv->_modems;
		_data_->_tmp15__length1 = _data_->self->priv->_modems_length1;
		{
			_data_->modem_collection_length1 = 0;
			_data_->_modem_collection_size_ = 0;
			_data_->modem_collection = _data_->_tmp15_;
			_data_->modem_collection_length1 = _data_->_tmp15__length1;
			for (_data_->modem_it = 0; _data_->modem_it < _data_->_tmp15__length1; _data_->modem_it = _data_->modem_it + 1) {
				memset (&_data_->_tmp16_, 0, sizeof (orgofonoModemProperties));
				org_ofono_modem_properties_copy (&_data_->modem_collection[_data_->modem_it], &_data_->_tmp16_);
				_data_->modem = _data_->_tmp16_;
				{
					memset (&_data_->_tmp17_, 0, sizeof (orgofonoModemProperties));
					_data_->_tmp17_ = _data_->modem;
					_data_->_tmp18_ = NULL;
					_data_->_tmp18_ = _data_->_tmp17_.path;
					memset (&_data_->_tmp19_, 0, sizeof (orgofonoModemProperties));
					_data_->_tmp19_ = _data_->modem;
					_data_->_tmp20_ = NULL;
					_data_->_tmp20_ = _data_->_tmp19_.properties;
					_folks_backends_ofono_backend_modem_added (_data_->self, _data_->_tmp18_, _data_->_tmp20_);
					org_ofono_modem_properties_destroy (&_data_->modem);
				}
			}
		}
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_g_object_unref0 (_data_->manager);
	}
	__finally0:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (_data_->_inner_error_->domain == G_DBUS_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	folks_internal_profiling_end ("preparing Ofono.Backend", NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_ofono_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsOfonoBackendUnprepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsOfonoBackendUnprepareData, _data_);
}


static void folks_backends_ofono_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsOfonoBackend * self;
	FolksBackendsOfonoBackendUnprepareData* _data_;
	FolksBackendsOfonoBackend* _tmp0_ = NULL;
	self = (FolksBackendsOfonoBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsOfonoBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_ofono_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_ofono_backend_real_unprepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_ofono_backend_real_unprepare_co (_data_);
}


static void folks_backends_ofono_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsOfonoBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static gboolean folks_backends_ofono_backend_real_unprepare_co (FolksBackendsOfonoBackendUnprepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = FALSE;
	_data_->_tmp1_ = _data_->self->priv->_is_prepared;
	if (!_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp0_ = _data_->_tmp2_ == TRUE;
	}
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		g_object_freeze_notify ((GObject*) _data_->self);
		{
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = _data_->self->priv->_persona_stores;
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = gee_abstract_map_get_values ((GeeMap*) _data_->_tmp3_);
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _data_->_tmp4_;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->_tmp5_;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp6_);
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = _data_->_tmp7_;
			_g_object_unref0 (_data_->_tmp6_);
			_data_->_persona_store_it = _data_->_tmp8_;
			while (TRUE) {
				_data_->_tmp9_ = NULL;
				_data_->_tmp9_ = _data_->_persona_store_it;
				_data_->_tmp10_ = FALSE;
				_data_->_tmp10_ = gee_iterator_next (_data_->_tmp9_);
				if (!_data_->_tmp10_) {
					break;
				}
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->_persona_store_it;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = gee_iterator_get (_data_->_tmp11_);
				_data_->persona_store = (FolksBackendsOfonoPersonaStore*) _data_->_tmp12_;
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _data_->persona_store;
				g_signal_emit_by_name ((FolksBackend*) _data_->self, "persona-store-removed", (FolksPersonaStore*) _data_->_tmp13_);
				_g_object_unref0 (_data_->persona_store);
			}
			_g_object_unref0 (_data_->_persona_store_it);
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->self->priv->_persona_stores;
		gee_abstract_map_clear ((GeeAbstractMap*) _data_->_tmp14_);
		g_object_notify ((GObject*) _data_->self, "persona-stores");
		_data_->self->priv->_is_quiescent = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_data_->self->priv->_is_prepared = FALSE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
	}
	__finally2:
	{
		g_object_thaw_notify ((GObject*) _data_->self);
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * Utility function to extract a modem's alias from its properties.
   *
   * @param properties, the properties of the modem.
   * @return the alias to use for this modem.
   */
static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gchar* _folks_backends_ofono_backend_modem_alias (FolksBackendsOfonoBackend* self, GHashTable* properties) {
	gchar* result = NULL;
	gchar* alias = NULL;
	gchar* _tmp0_ = NULL;
	GVariant* name_variant = NULL;
	GHashTable* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	GVariant* manufacturer_variant = NULL;
	GHashTable* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (properties != NULL, NULL);
	_tmp0_ = g_strdup ("");
	alias = _tmp0_;
	_tmp1_ = properties;
	_tmp2_ = g_hash_table_lookup (_tmp1_, "Name");
	_tmp3_ = _g_variant_ref0 ((GVariant*) _tmp2_);
	name_variant = _tmp3_;
	_tmp4_ = properties;
	_tmp5_ = g_hash_table_lookup (_tmp4_, "Manufacturer");
	_tmp6_ = _g_variant_ref0 ((GVariant*) _tmp5_);
	manufacturer_variant = _tmp6_;
	_tmp7_ = name_variant;
	if (_tmp7_ != NULL) {
		GVariant* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = name_variant;
		_tmp9_ = g_variant_get_string (_tmp8_, NULL);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (alias);
		alias = _tmp10_;
	} else {
		GVariant* _tmp11_ = NULL;
		_tmp11_ = manufacturer_variant;
		if (_tmp11_ != NULL) {
			GVariant* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp12_ = manufacturer_variant;
			_tmp13_ = g_variant_get_string (_tmp12_, NULL);
			_tmp14_ = g_strdup (_tmp13_);
			_g_free0 (alias);
			alias = _tmp14_;
		}
	}
	result = alias;
	_g_variant_unref0 (manufacturer_variant);
	_g_variant_unref0 (name_variant);
	return result;
}


static void _folks_backends_ofono_backend_modem_added (FolksBackendsOfonoBackend* self, const char* path, GHashTable* properties) {
	gboolean has_sim = FALSE;
	gboolean has_phonebook = FALSE;
	GVariant* features_variant = NULL;
	GHashTable* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
	gboolean _tmp9_ = FALSE;
	GVariant* interfaces_variant = NULL;
	GHashTable* _tmp10_ = NULL;
	gconstpointer _tmp11_ = NULL;
	GVariant* _tmp12_ = NULL;
	GVariant* _tmp13_ = NULL;
	gboolean _tmp19_ = FALSE;
	gchar* alias = NULL;
	GHashTable* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	const char* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (properties != NULL);
	has_sim = FALSE;
	has_phonebook = FALSE;
	_tmp0_ = properties;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "Features");
	_tmp2_ = _g_variant_ref0 ((GVariant*) _tmp1_);
	features_variant = _tmp2_;
	_tmp3_ = features_variant;
	if (_tmp3_ != NULL) {
		const gchar** features = NULL;
		GVariant* _tmp4_ = NULL;
		size_t _tmp5_;
		const gchar** _tmp6_ = NULL;
		gint features_length1 = 0;
		gint _features_size_ = 0;
		const gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		_tmp4_ = features_variant;
		_tmp6_ = g_variant_get_strv (_tmp4_, &_tmp5_);
		features = _tmp6_;
		features_length1 = _tmp5_;
		_features_size_ = features_length1;
		_tmp7_ = features;
		_tmp7__length1 = features_length1;
		{
			const gchar** feature_collection = NULL;
			gint feature_collection_length1 = 0;
			gint _feature_collection_size_ = 0;
			gint feature_it = 0;
			feature_collection = _tmp7_;
			feature_collection_length1 = _tmp7__length1;
			for (feature_it = 0; feature_it < _tmp7__length1; feature_it = feature_it + 1) {
				const gchar* feature = NULL;
				feature = feature_collection[feature_it];
				{
					const gchar* _tmp8_ = NULL;
					_tmp8_ = feature;
					if (g_strcmp0 (_tmp8_, "sim") == 0) {
						has_sim = TRUE;
						break;
					}
				}
			}
		}
		features = (g_free (features), NULL);
	}
	_tmp9_ = has_sim;
	if (_tmp9_ == FALSE) {
		_g_variant_unref0 (features_variant);
		return;
	}
	_tmp10_ = properties;
	_tmp11_ = g_hash_table_lookup (_tmp10_, "Interfaces");
	_tmp12_ = _g_variant_ref0 ((GVariant*) _tmp11_);
	interfaces_variant = _tmp12_;
	_tmp13_ = interfaces_variant;
	if (_tmp13_ != NULL) {
		const gchar** interfaces = NULL;
		GVariant* _tmp14_ = NULL;
		size_t _tmp15_;
		const gchar** _tmp16_ = NULL;
		gint interfaces_length1 = 0;
		gint _interfaces_size_ = 0;
		const gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		_tmp14_ = interfaces_variant;
		_tmp16_ = g_variant_get_strv (_tmp14_, &_tmp15_);
		interfaces = _tmp16_;
		interfaces_length1 = _tmp15_;
		_interfaces_size_ = interfaces_length1;
		_tmp17_ = interfaces;
		_tmp17__length1 = interfaces_length1;
		{
			const gchar** interf_collection = NULL;
			gint interf_collection_length1 = 0;
			gint _interf_collection_size_ = 0;
			gint interf_it = 0;
			interf_collection = _tmp17_;
			interf_collection_length1 = _tmp17__length1;
			for (interf_it = 0; interf_it < _tmp17__length1; interf_it = interf_it + 1) {
				const gchar* interf = NULL;
				interf = interf_collection[interf_it];
				{
					const gchar* _tmp18_ = NULL;
					_tmp18_ = interf;
					if (g_strcmp0 (_tmp18_, "org.ofono.Phonebook") == 0) {
						has_phonebook = TRUE;
						break;
					}
				}
			}
		}
		interfaces = (g_free (interfaces), NULL);
	}
	_tmp19_ = has_phonebook;
	if (_tmp19_ == FALSE) {
		_g_variant_unref0 (interfaces_variant);
		_g_variant_unref0 (features_variant);
		return;
	}
	_tmp20_ = properties;
	_tmp21_ = _folks_backends_ofono_backend_modem_alias (self, _tmp20_);
	alias = _tmp21_;
	_tmp22_ = path;
	_tmp23_ = alias;
	_folks_backends_ofono_backend_add_modem (self, _tmp22_, _tmp23_);
	_g_free0 (alias);
	_g_variant_unref0 (interfaces_variant);
	_g_variant_unref0 (features_variant);
}


/**
   * Utility function to add a persona store.
   *
   * @param store the store to add.
   * @param notify whether or not to emit notification signals.
   */
static void __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	_folks_backends_ofono_backend_store_removed_cb ((FolksBackendsOfonoBackend*) self, _sender);
}


static void _folks_backends_ofono_backend_add_store (FolksBackendsOfonoBackend* self, FolksBackendsOfonoPersonaStore* store, gboolean notify) {
	GeeHashMap* _tmp0_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp4_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp5_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = store;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = store;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp3_, _tmp4_);
	_tmp5_ = store;
	g_signal_connect_object ((FolksPersonaStore*) _tmp5_, "removed", (GCallback) __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	_tmp6_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) _tmp6_);
	_tmp7_ = notify;
	if (_tmp7_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}


/**
   * Utility function to remove a persona store.
   *
   * @param store the store to remove.
   * @param notify whether or not to emit notification signals.
   */
static void _folks_backends_ofono_backend_remove_store (FolksBackendsOfonoBackend* self, FolksBackendsOfonoPersonaStore* store, gboolean notify) {
	FolksBackendsOfonoPersonaStore* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GeeHashMap* _tmp2_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	FolksBackendsOfonoPersonaStore* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FolksPersonaStore*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __folks_backends_ofono_backend_store_removed_cb_folks_persona_store_removed, self);
	_tmp2_ = self->priv->_persona_stores;
	_tmp3_ = store;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp3_);
	_tmp5_ = _tmp4_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, _tmp5_, NULL);
	_tmp6_ = store;
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", (FolksPersonaStore*) _tmp6_);
	_tmp7_ = notify;
	if (_tmp7_) {
		g_object_notify ((GObject*) self, "persona-stores");
	}
}


static void _folks_backends_ofono_backend_modem_removed (FolksBackendsOfonoBackend* self, const char* path) {
	GeeHashMap* _tmp0_ = NULL;
	const char* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->_persona_stores;
	_tmp1_ = path;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (const gchar*) _tmp1_);
	if (_tmp2_) {
		GeeHashMap* _tmp3_ = NULL;
		const char* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		FolksBackendsOfonoPersonaStore* _tmp6_ = NULL;
		_tmp3_ = self->priv->_persona_stores;
		_tmp4_ = path;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (const gchar*) _tmp4_);
		_tmp6_ = (FolksBackendsOfonoPersonaStore*) _tmp5_;
		_folks_backends_ofono_backend_store_removed_cb (self, (FolksPersonaStore*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
}


static void _folks_backends_ofono_backend_store_removed_cb (FolksBackendsOfonoBackend* self, FolksPersonaStore* store) {
	FolksPersonaStore* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_folks_backends_ofono_backend_remove_store (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, FolksBackendsOfonoPersonaStore), TRUE);
}


static gboolean folks_backends_ofono_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_ofono_backend_real_get_is_quiescent (FolksBackend* base) {
	gboolean result;
	FolksBackendsOfonoBackend* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsOfonoBackend*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static const gchar* folks_backends_ofono_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsOfonoBackend* self;
	self = (FolksBackendsOfonoBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_ofono_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsOfonoBackend* self;
	GeeMap* _tmp0_ = NULL;
	self = (FolksBackendsOfonoBackend*) base;
	_tmp0_ = self->priv->_persona_stores_ro;
	result = _tmp0_;
	return result;
}


static GObject * folks_backends_ofono_backend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsOfonoBackend * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_backends_ofono_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_BACKENDS_OFONO_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = self->priv->_persona_stores;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp3_;
	return obj;
}


static void folks_backends_ofono_backend_class_init (FolksBackendsOfonoBackendClass * klass) {
	folks_backends_ofono_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsOfonoBackendPrivate));
	((FolksBackendClass *) klass)->disable_persona_store = folks_backends_ofono_backend_real_disable_persona_store;
	((FolksBackendClass *) klass)->enable_persona_store = folks_backends_ofono_backend_real_enable_persona_store;
	((FolksBackendClass *) klass)->set_persona_stores = folks_backends_ofono_backend_real_set_persona_stores;
	((FolksBackendClass *) klass)->prepare = folks_backends_ofono_backend_real_prepare;
	((FolksBackendClass *) klass)->prepare_finish = folks_backends_ofono_backend_real_prepare_finish;
	((FolksBackendClass *) klass)->unprepare = folks_backends_ofono_backend_real_unprepare;
	((FolksBackendClass *) klass)->unprepare_finish = folks_backends_ofono_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_ofono_backend_real_get_is_prepared;
	FOLKS_BACKEND_CLASS (klass)->get_is_quiescent = folks_backends_ofono_backend_real_get_is_quiescent;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_ofono_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_ofono_backend_real_get_persona_stores;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_ofono_backend_get_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_ofono_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_ofono_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES, g_param_spec_object ("persona-stores", "persona-stores", "persona-stores", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void folks_backends_ofono_backend_instance_init (FolksBackendsOfonoBackend * self) {
	self->priv = FOLKS_BACKENDS_OFONO_BACKEND_GET_PRIVATE (self);
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void folks_backends_ofono_backend_finalize (GObject* obj) {
	FolksBackendsOfonoBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_modems = (_vala_orgofonoModemProperties_array_free (self->priv->_modems, self->priv->_modems_length1), NULL);
	G_OBJECT_CLASS (folks_backends_ofono_backend_parent_class)->finalize (obj);
}


/**
 * A backend which loads {@link Persona}s from Modem
 * devices using the Ofono Phonebook D-Bus API and presents them
 * using one {@link PersonaStore} per device.
 *
 * @since 0.9.0
 */
GType folks_backends_ofono_backend_get_type (void) {
	static volatile gsize folks_backends_ofono_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_ofono_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsOfonoBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_ofono_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsOfonoBackend), 0, (GInstanceInitFunc) folks_backends_ofono_backend_instance_init, NULL };
		GType folks_backends_ofono_backend_type_id;
		folks_backends_ofono_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsOfonoBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_ofono_backend_type_id__volatile, folks_backends_ofono_backend_type_id);
	}
	return folks_backends_ofono_backend_type_id__volatile;
}


static void _vala_folks_backends_ofono_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsOfonoBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_OFONO_TYPE_BACKEND, FolksBackendsOfonoBackend);
	switch (property_id) {
		case FOLKS_BACKENDS_OFONO_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_IS_QUIESCENT:
		g_value_set_boolean (value, folks_backend_get_is_quiescent ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_OFONO_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



