/* dconf-model.c generated by valac 0.30.0, the Vala compiler
 * generated from dconf-model.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public License
  along with Dconf Editor; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <dconf.h>
#include <pango/pango.h>
#include <gio/gio.h>


#define TYPE_KEY (key_get_type ())
#define KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY, Key))
#define KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY, KeyClass))
#define IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY))
#define IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY))
#define KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY, KeyClass))

typedef struct _Key Key;
typedef struct _KeyClass KeyClass;
typedef struct _KeyPrivate KeyPrivate;

#define TYPE_DIRECTORY (directory_get_type ())
#define DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIRECTORY, Directory))
#define DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIRECTORY, DirectoryClass))
#define IS_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIRECTORY))
#define IS_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIRECTORY))
#define DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIRECTORY, DirectoryClass))

typedef struct _Directory Directory;
typedef struct _DirectoryClass DirectoryClass;

#define TYPE_SCHEMA_KEY (schema_key_get_type ())
#define SCHEMA_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_KEY, SchemaKey))
#define SCHEMA_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_KEY, SchemaKeyClass))
#define IS_SCHEMA_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_KEY))
#define IS_SCHEMA_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_KEY))
#define SCHEMA_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_KEY, SchemaKeyClass))

typedef struct _SchemaKey SchemaKey;
typedef struct _SchemaKeyClass SchemaKeyClass;

#define TYPE_SETTINGS_MODEL (settings_model_get_type ())
#define SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_MODEL, SettingsModel))
#define SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_MODEL, SettingsModelClass))
#define IS_SETTINGS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_MODEL))
#define IS_SETTINGS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_MODEL))
#define SETTINGS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_MODEL, SettingsModelClass))

typedef struct _SettingsModel SettingsModel;
typedef struct _SettingsModelClass SettingsModelClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _schema_key_unref0(var) ((var == NULL) ? NULL : (var = (schema_key_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _SettingsModelPrivate SettingsModelPrivate;

#define TYPE_SCHEMA_LIST (schema_list_get_type ())
#define SCHEMA_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_LIST, SchemaList))
#define SCHEMA_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_LIST, SchemaListClass))
#define IS_SCHEMA_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_LIST))
#define IS_SCHEMA_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_LIST))
#define SCHEMA_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_LIST, SchemaListClass))

typedef struct _SchemaList SchemaList;
typedef struct _SchemaListClass SchemaListClass;
typedef struct _SchemaListPrivate SchemaListPrivate;

#define TYPE_SCHEMA (schema_get_type ())
#define SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA, Schema))
#define SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA, SchemaClass))
#define IS_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA))
#define IS_SCHEMA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA))
#define SCHEMA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA, SchemaClass))

typedef struct _Schema Schema;
typedef struct _SchemaClass SchemaClass;

#define TYPE_SCHEMA_ENUM (schema_enum_get_type ())
#define SCHEMA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_ENUM, SchemaEnum))
#define SCHEMA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_ENUM, SchemaEnumClass))
#define IS_SCHEMA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_ENUM))
#define IS_SCHEMA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_ENUM))
#define SCHEMA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_ENUM, SchemaEnumClass))

typedef struct _SchemaEnum SchemaEnum;
typedef struct _SchemaEnumClass SchemaEnumClass;

#define TYPE_SCHEMA_FLAGS (schema_flags_get_type ())
#define SCHEMA_FLAGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_FLAGS, SchemaFlags))
#define SCHEMA_FLAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_FLAGS, SchemaFlagsClass))
#define IS_SCHEMA_FLAGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_FLAGS))
#define IS_SCHEMA_FLAGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_FLAGS))
#define SCHEMA_FLAGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_FLAGS, SchemaFlagsClass))

typedef struct _SchemaFlags SchemaFlags;
typedef struct _SchemaFlagsClass SchemaFlagsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SchemaKeyPrivate SchemaKeyPrivate;

#define TYPE_SCHEMA_VALUE_RANGE (schema_value_range_get_type ())
#define SCHEMA_VALUE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_VALUE_RANGE, SchemaValueRange))
#define SCHEMA_VALUE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_VALUE_RANGE, SchemaValueRangeClass))
#define IS_SCHEMA_VALUE_RANGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_VALUE_RANGE))
#define IS_SCHEMA_VALUE_RANGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_VALUE_RANGE))
#define SCHEMA_VALUE_RANGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_VALUE_RANGE, SchemaValueRangeClass))

typedef struct _SchemaValueRange SchemaValueRange;
typedef struct _SchemaValueRangeClass SchemaValueRangeClass;

#define TYPE_SCHEMA_CHOICE (schema_choice_get_type ())
#define SCHEMA_CHOICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_CHOICE, SchemaChoice))
#define SCHEMA_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_CHOICE, SchemaChoiceClass))
#define IS_SCHEMA_CHOICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_CHOICE))
#define IS_SCHEMA_CHOICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_CHOICE))
#define SCHEMA_CHOICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_CHOICE, SchemaChoiceClass))

typedef struct _SchemaChoice SchemaChoice;
typedef struct _SchemaChoiceClass SchemaChoiceClass;
typedef struct _DirectoryPrivate DirectoryPrivate;

#define TYPE_KEY_MODEL (key_model_get_type ())
#define KEY_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_MODEL, KeyModel))
#define KEY_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_MODEL, KeyModelClass))
#define IS_KEY_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_MODEL))
#define IS_KEY_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_MODEL))
#define KEY_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_MODEL, KeyModelClass))

typedef struct _KeyModel KeyModel;
typedef struct _KeyModelClass KeyModelClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _SchemaPrivate SchemaPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _KeyModelPrivate KeyModelPrivate;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define TYPE_ENUM_MODEL (enum_model_get_type ())
#define ENUM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENUM_MODEL, EnumModel))
#define ENUM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENUM_MODEL, EnumModelClass))
#define IS_ENUM_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENUM_MODEL))
#define IS_ENUM_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENUM_MODEL))
#define ENUM_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENUM_MODEL, EnumModelClass))

typedef struct _EnumModel EnumModel;
typedef struct _EnumModelClass EnumModelClass;
typedef struct _EnumModelPrivate EnumModelPrivate;
#define _schema_enum_unref0(var) ((var == NULL) ? NULL : (var = (schema_enum_unref (var), NULL)))

#define TYPE_SCHEMA_VALUE (schema_value_get_type ())
#define SCHEMA_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEMA_VALUE, SchemaValue))
#define SCHEMA_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEMA_VALUE, SchemaValueClass))
#define IS_SCHEMA_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEMA_VALUE))
#define IS_SCHEMA_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEMA_VALUE))
#define SCHEMA_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEMA_VALUE, SchemaValueClass))

typedef struct _SchemaValue SchemaValue;
typedef struct _SchemaValueClass SchemaValueClass;
typedef struct _SchemaValuePrivate SchemaValuePrivate;
typedef struct _SchemaEnumPrivate SchemaEnumPrivate;
#define _schema_list_unref0(var) ((var == NULL) ? NULL : (var = (schema_list_unref (var), NULL)))

struct _Key {
	GObject parent_instance;
	KeyPrivate * priv;
	Directory* parent;
	gchar* name;
	gchar* full_name;
	SchemaKey* schema;
};

struct _KeyClass {
	GObjectClass parent_class;
};

struct _KeyPrivate {
	SettingsModel* model;
	GVariant* _value;
};

struct _SettingsModel {
	GObject parent_instance;
	SettingsModelPrivate * priv;
	SchemaList* schemas;
	DConfClient* client;
};

struct _SettingsModelClass {
	GObjectClass parent_class;
};

struct _SchemaList {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaListPrivate * priv;
	GHashTable* schemas;
	GHashTable* keys;
	GHashTable* enums;
	GHashTable* flags;
};

struct _SchemaListClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaList *self);
};

struct _SchemaKey {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaKeyPrivate * priv;
	Schema* schema;
	gchar* name;
	gchar* type;
	GVariant* default_value;
	SchemaValueRange* range;
	SchemaValueRange* type_range;
	GList* choices;
	gchar* enum_name;
	gchar* summary;
	gchar* description;
	gchar* gettext_domain;
};

struct _SchemaKeyClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaKey *self);
};

struct _Directory {
	GObject parent_instance;
	DirectoryPrivate * priv;
	gchar* name;
	gchar* full_name;
	Directory* parent;
	GHashTable* _child_map;
	GList* _children;
	GHashTable* _key_map;
};

struct _DirectoryClass {
	GObjectClass parent_class;
};

struct _DirectoryPrivate {
	SettingsModel* model;
	KeyModel* _key_model;
	GList* _keys;
	gboolean have_children;
};

struct _Schema {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaPrivate * priv;
	SchemaList* list;
	gchar* id;
	gchar* path;
	GHashTable* keys;
};

struct _SchemaClass {
	GTypeClass parent_class;
	void (*finalize) (Schema *self);
};

struct _KeyModel {
	GObject parent_instance;
	KeyModelPrivate * priv;
};

struct _KeyModelClass {
	GObjectClass parent_class;
};

struct _KeyModelPrivate {
	Directory* directory;
};

struct _EnumModel {
	GObject parent_instance;
	EnumModelPrivate * priv;
};

struct _EnumModelClass {
	GObjectClass parent_class;
};

struct _EnumModelPrivate {
	SchemaEnum* schema_enum;
};

struct _SchemaValue {
	GObject parent_instance;
	SchemaValuePrivate * priv;
	guint index;
	gchar* nick;
	gint value;
};

struct _SchemaValueClass {
	GObjectClass parent_class;
};

struct _SchemaEnum {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SchemaEnumPrivate * priv;
	SchemaList* list;
	gchar* id;
	GList* values;
};

struct _SchemaEnumClass {
	GTypeClass parent_class;
	void (*finalize) (SchemaEnum *self);
};

struct _SettingsModelPrivate {
	Directory* root;
};


static gpointer key_parent_class = NULL;
static gpointer directory_parent_class = NULL;
static gpointer key_model_parent_class = NULL;
static GtkTreeModelIface* key_model_gtk_tree_model_parent_iface = NULL;
static gpointer enum_model_parent_class = NULL;
static GtkTreeModelIface* enum_model_gtk_tree_model_parent_iface = NULL;
static gpointer settings_model_parent_class = NULL;
static GtkTreeModelIface* settings_model_gtk_tree_model_parent_iface = NULL;

GType key_get_type (void) G_GNUC_CONST;
GType directory_get_type (void) G_GNUC_CONST;
gpointer schema_key_ref (gpointer instance);
void schema_key_unref (gpointer instance);
GParamSpec* param_spec_schema_key (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_key (GValue* value, gpointer v_object);
void value_take_schema_key (GValue* value, gpointer v_object);
gpointer value_get_schema_key (const GValue* value);
GType schema_key_get_type (void) G_GNUC_CONST;
GType settings_model_get_type (void) G_GNUC_CONST;
#define KEY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEY, KeyPrivate))
enum  {
	KEY_DUMMY_PROPERTY,
	KEY_HAS_SCHEMA,
	KEY_INDEX,
	KEY_TYPE_STRING,
	KEY_VALUE,
	KEY_IS_DEFAULT
};
GVariant* key_get_min (Key* self);
GVariant* key_get_value (Key* self);
GVariant* key_get_max (Key* self);
static void key_item_changed (Key* self, const gchar* key);
Key* key_new (SettingsModel* model, Directory* parent, const gchar* name, const gchar* full_name);
Key* key_construct (GType object_type, SettingsModel* model, Directory* parent, const gchar* name, const gchar* full_name);
gpointer schema_list_ref (gpointer instance);
void schema_list_unref (gpointer instance);
GParamSpec* param_spec_schema_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_list (GValue* value, gpointer v_object);
void value_take_schema_list (GValue* value, gpointer v_object);
gpointer value_get_schema_list (const GValue* value);
GType schema_list_get_type (void) G_GNUC_CONST;
gpointer schema_ref (gpointer instance);
void schema_unref (gpointer instance);
GParamSpec* param_spec_schema (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema (GValue* value, gpointer v_object);
void value_take_schema (GValue* value, gpointer v_object);
gpointer value_get_schema (const GValue* value);
GType schema_get_type (void) G_GNUC_CONST;
gpointer schema_enum_ref (gpointer instance);
void schema_enum_unref (gpointer instance);
GParamSpec* param_spec_schema_enum (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_enum (GValue* value, gpointer v_object);
void value_take_schema_enum (GValue* value, gpointer v_object);
gpointer value_get_schema_enum (const GValue* value);
GType schema_enum_get_type (void) G_GNUC_CONST;
gpointer schema_flags_ref (gpointer instance);
void schema_flags_unref (gpointer instance);
GParamSpec* param_spec_schema_flags (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_flags (GValue* value, gpointer v_object);
void value_take_schema_flags (GValue* value, gpointer v_object);
gpointer value_get_schema_flags (const GValue* value);
GType schema_flags_get_type (void) G_GNUC_CONST;
static void _key_item_changed_settings_model_item_changed (SettingsModel* _sender, const gchar* key, gpointer self);
void key_set_to_default (Key* self);
gboolean key_get_has_schema (Key* self);
static void key_update_value (Key* self);
gint key_get_index (Key* self);
GList* directory_get_keys (Directory* self);
const gchar* key_get_type_string (Key* self);
gpointer schema_value_range_ref (gpointer instance);
void schema_value_range_unref (gpointer instance);
GParamSpec* param_spec_schema_value_range (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_value_range (GValue* value, gpointer v_object);
void value_take_schema_value_range (GValue* value, gpointer v_object);
gpointer value_get_schema_value_range (const GValue* value);
GType schema_value_range_get_type (void) G_GNUC_CONST;
gpointer schema_choice_ref (gpointer instance);
void schema_choice_unref (gpointer instance);
GParamSpec* param_spec_schema_choice (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_schema_choice (GValue* value, gpointer v_object);
void value_take_schema_choice (GValue* value, gpointer v_object);
gpointer value_get_schema_choice (const GValue* value);
GType schema_choice_get_type (void) G_GNUC_CONST;
static void key_set_type_string (Key* self, const gchar* value);
void key_set_value (Key* self, GVariant* value);
gboolean key_get_is_default (Key* self);
static void key_finalize (GObject* obj);
static void _vala_key_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_key_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType key_model_get_type (void) G_GNUC_CONST;
#define DIRECTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DIRECTORY, DirectoryPrivate))
enum  {
	DIRECTORY_DUMMY_PROPERTY,
	DIRECTORY_KEY_MODEL,
	DIRECTORY_INDEX,
	DIRECTORY_CHILDREN,
	DIRECTORY_KEYS
};
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
Directory* directory_new (SettingsModel* model, Directory* parent, const gchar* name, const gchar* full_name);
Directory* directory_construct (GType object_type, SettingsModel* model, Directory* parent, const gchar* name, const gchar* full_name);
Directory* directory_get_child (Directory* self, const gchar* name);
static gint directory_compare_directories (Directory* a, Directory* b);
static gint _directory_compare_directories_gcompare_func (gconstpointer a, gconstpointer b);
Key* directory_get_key (Directory* self, const gchar* name);
gint directory_compare_keys (Key* a, Key* b);
static gint _directory_compare_keys_gcompare_func (gconstpointer a, gconstpointer b);
void directory_load_schema (Directory* self, Schema* schema, const gchar* path);
static void directory_update_children (Directory* self);
KeyModel* directory_get_key_model (Directory* self);
KeyModel* key_model_new (Directory* directory);
KeyModel* key_model_construct (GType object_type, Directory* directory);
static void directory_set_key_model (Directory* self, KeyModel* value);
gint directory_get_index (Directory* self);
GList* directory_get_children (Directory* self);
static void directory_set_children (Directory* self, GList* value);
static void directory_set_keys (Directory* self, GList* value);
static void directory_finalize (GObject* obj);
static void _vala_directory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_directory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define KEY_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEY_MODEL, KeyModelPrivate))
enum  {
	KEY_MODEL_DUMMY_PROPERTY
};
static void key_model_key_changed_cb (KeyModel* self, Key* key);
static void _key_model_key_changed_cb_key_value_changed (Key* _sender, gpointer self);
Key* key_model_get_key (KeyModel* self, GtkTreeIter* iter);
static GtkTreeModelFlags key_model_real_get_flags (GtkTreeModel* base);
static gint key_model_real_get_n_columns (GtkTreeModel* base);
static GType key_model_real_get_column_type (GtkTreeModel* base, gint index);
static void key_model_set_iter (KeyModel* self, GtkTreeIter* iter, Key* key);
static gboolean key_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static GtkTreePath* key_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void key_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
static gboolean key_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean key_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean key_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint key_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean key_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean key_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void key_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void key_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void key_model_finalize (GObject* obj);
GType enum_model_get_type (void) G_GNUC_CONST;
#define ENUM_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ENUM_MODEL, EnumModelPrivate))
enum  {
	ENUM_MODEL_DUMMY_PROPERTY
};
EnumModel* enum_model_new (SchemaEnum* schema_enum);
EnumModel* enum_model_construct (GType object_type, SchemaEnum* schema_enum);
static GtkTreeModelFlags enum_model_real_get_flags (GtkTreeModel* base);
static gint enum_model_real_get_n_columns (GtkTreeModel* base);
static GType enum_model_real_get_column_type (GtkTreeModel* base, gint index);
GType schema_value_get_type (void) G_GNUC_CONST;
static void enum_model_set_iter (EnumModel* self, GtkTreeIter* iter, SchemaValue* value);
SchemaValue* enum_model_get_enum_value (EnumModel* self, GtkTreeIter* iter);
static gboolean enum_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static GtkTreePath* enum_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void enum_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
static gboolean enum_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean enum_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean enum_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint enum_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean enum_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean enum_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void enum_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void enum_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void enum_model_finalize (GObject* obj);
#define SETTINGS_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SETTINGS_MODEL, SettingsModelPrivate))
enum  {
	SETTINGS_MODEL_DUMMY_PROPERTY
};
static void settings_model_watch_func (SettingsModel* self, DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag);
SettingsModel* settings_model_new (void);
SettingsModel* settings_model_construct (GType object_type);
static void _settings_model_watch_func_dconf_client_changed (DConfClient* _sender, const gchar* prefix, gchar** changes, const gchar* tag, gpointer self);
SchemaList* schema_list_new (void);
SchemaList* schema_list_construct (GType object_type);
static gchar** _vala_array_dup1 (gchar** self, int length);
void schema_list_load_directory (SchemaList* self, const gchar* dir, GError** error);
static GtkTreeModelFlags settings_model_real_get_flags (GtkTreeModel* base);
static gint settings_model_real_get_n_columns (GtkTreeModel* base);
static GType settings_model_real_get_column_type (GtkTreeModel* base, gint index);
static void settings_model_set_iter (SettingsModel* self, GtkTreeIter* iter, Directory* directory);
Directory* settings_model_get_directory (SettingsModel* self, GtkTreeIter* iter);
static gboolean settings_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path);
static GtkTreePath* settings_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter);
static void settings_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value);
static gboolean settings_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean settings_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent);
static gboolean settings_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter);
static gint settings_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter);
static gboolean settings_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n);
static gboolean settings_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child);
static void settings_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void settings_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter);
static void settings_model_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GVariant* key_get_min (Key* self) {
	GVariant* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantClass _tmp2_ = 0;
#line 82 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = key_get_value (self);
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _tmp0_;
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = g_variant_classify (_tmp1_);
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	switch (_tmp2_) {
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_BYTE:
#line 567 "dconf-model.c"
		{
			GVariant* _tmp3_ = NULL;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp3_ = g_variant_new_byte ((guchar) 0);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp3_);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp3_;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 578 "dconf-model.c"
		}
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_INT16:
#line 582 "dconf-model.c"
		{
			GVariant* _tmp4_ = NULL;
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp4_ = g_variant_new_int16 (G_MININT16);
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp4_);
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp4_;
#line 87 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 593 "dconf-model.c"
		}
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_UINT16:
#line 597 "dconf-model.c"
		{
			GVariant* _tmp5_ = NULL;
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp5_ = g_variant_new_uint16 (0U);
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp5_);
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp5_;
#line 88 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 608 "dconf-model.c"
		}
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_INT32:
#line 612 "dconf-model.c"
		{
			GVariant* _tmp6_ = NULL;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp6_ = g_variant_new_int32 (G_MININT32);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp6_);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp6_;
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 623 "dconf-model.c"
		}
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_UINT32:
#line 627 "dconf-model.c"
		{
			GVariant* _tmp7_ = NULL;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp7_ = g_variant_new_uint32 (0U);
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp7_);
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp7_;
#line 90 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 638 "dconf-model.c"
		}
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_INT64:
#line 642 "dconf-model.c"
		{
			GVariant* _tmp8_ = NULL;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp8_ = g_variant_new_int64 (G_MININT64);
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp8_);
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp8_;
#line 91 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 653 "dconf-model.c"
		}
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_UINT64:
#line 657 "dconf-model.c"
		{
			GVariant* _tmp9_ = NULL;
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp9_ = g_variant_new_uint64 (0ULL);
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp9_);
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp9_;
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 668 "dconf-model.c"
		}
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_DOUBLE:
#line 672 "dconf-model.c"
		{
			GVariant* _tmp10_ = NULL;
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp10_ = g_variant_new_double (DBL_MIN);
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp10_);
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp10_;
#line 93 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 683 "dconf-model.c"
		}
		default:
		{
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = NULL;
#line 94 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 691 "dconf-model.c"
		}
	}
}


GVariant* key_get_max (Key* self) {
	GVariant* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariantClass _tmp2_ = 0;
#line 98 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = key_get_value (self);
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _tmp0_;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = g_variant_classify (_tmp1_);
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	switch (_tmp2_) {
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_BYTE:
#line 714 "dconf-model.c"
		{
			GVariant* _tmp3_ = NULL;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp3_ = g_variant_new_byte ((guchar) 255);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp3_);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp3_;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 725 "dconf-model.c"
		}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_INT16:
#line 729 "dconf-model.c"
		{
			GVariant* _tmp4_ = NULL;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp4_ = g_variant_new_int16 (G_MAXINT16);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp4_);
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp4_;
#line 103 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 740 "dconf-model.c"
		}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_UINT16:
#line 744 "dconf-model.c"
		{
			GVariant* _tmp5_ = NULL;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp5_ = g_variant_new_uint16 (G_MAXUINT16);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp5_);
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp5_;
#line 104 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 755 "dconf-model.c"
		}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_INT32:
#line 759 "dconf-model.c"
		{
			GVariant* _tmp6_ = NULL;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp6_ = g_variant_new_int32 (G_MAXINT32);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp6_);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp6_;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 770 "dconf-model.c"
		}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_UINT32:
#line 774 "dconf-model.c"
		{
			GVariant* _tmp7_ = NULL;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp7_ = g_variant_new_uint32 (G_MAXUINT32);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp7_);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp7_;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 785 "dconf-model.c"
		}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_INT64:
#line 789 "dconf-model.c"
		{
			GVariant* _tmp8_ = NULL;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp8_ = g_variant_new_int64 (G_MAXINT64);
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp8_);
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp8_;
#line 107 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 800 "dconf-model.c"
		}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_UINT64:
#line 804 "dconf-model.c"
		{
			GVariant* _tmp9_ = NULL;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp9_ = g_variant_new_uint64 (G_MAXUINT64);
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp9_);
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp9_;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 815 "dconf-model.c"
		}
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case G_VARIANT_CLASS_DOUBLE:
#line 819 "dconf-model.c"
		{
			GVariant* _tmp10_ = NULL;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp10_ = g_variant_new_double (DBL_MAX);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_variant_ref_sink (_tmp10_);
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp10_;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 830 "dconf-model.c"
		}
		default:
		{
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = NULL;
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 838 "dconf-model.c"
		}
	}
}


static void key_item_changed (Key* self, const gchar* key) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (key != NULL);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = key;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = g_str_has_suffix (_tmp2_, "/");
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp3_) {
#line 859 "dconf-model.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = self->full_name;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = key;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp6_ = g_str_has_prefix (_tmp4_, _tmp5_);
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = _tmp6_;
#line 871 "dconf-model.c"
	} else {
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = FALSE;
#line 875 "dconf-model.c"
	}
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp1_) {
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp0_ = TRUE;
#line 881 "dconf-model.c"
	} else {
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp7_ = key;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp8_ = self->full_name;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp0_ = g_strcmp0 (_tmp7_, _tmp8_) == 0;
#line 891 "dconf-model.c"
	}
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_) {
#line 124 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_signal_emit_by_name (self, "value-changed");
#line 897 "dconf-model.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self ? g_object_ref (self) : NULL;
#line 905 "dconf-model.c"
}


static gpointer _schema_key_ref0 (gpointer self) {
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self ? schema_key_ref (self) : NULL;
#line 912 "dconf-model.c"
}


static void _key_item_changed_settings_model_item_changed (SettingsModel* _sender, const gchar* key, gpointer self) {
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_item_changed ((Key*) self, key);
#line 919 "dconf-model.c"
}


Key* key_construct (GType object_type, SettingsModel* model, Directory* parent, const gchar* name, const gchar* full_name) {
	Key * self = NULL;
	SettingsModel* _tmp0_ = NULL;
	SettingsModel* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	Directory* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	SettingsModel* _tmp8_ = NULL;
	SchemaList* _tmp9_ = NULL;
	GHashTable* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	SchemaKey* _tmp13_ = NULL;
	SettingsModel* _tmp14_ = NULL;
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (full_name != NULL, NULL);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (Key*) g_object_new (object_type, NULL);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = model;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->model);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->model = _tmp1_;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = parent;
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->parent);
#line 130 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->parent = _tmp3_;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = name;
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_free0 (self->name);
#line 131 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->name = _tmp5_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = full_name;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_free0 (self->full_name);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->full_name = _tmp7_;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = model;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp9_ = _tmp8_->schemas;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp10_ = _tmp9_->keys;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp11_ = full_name;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp13_ = _schema_key_ref0 ((SchemaKey*) _tmp12_);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_schema_key_unref0 (self->schema);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->schema = _tmp13_;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp14_ = model;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_signal_connect_object (_tmp14_, "item-changed", (GCallback) _key_item_changed_settings_model_item_changed, self, 0);
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self;
#line 1004 "dconf-model.c"
}


Key* key_new (SettingsModel* model, Directory* parent, const gchar* name, const gchar* full_name) {
#line 127 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return key_construct (TYPE_KEY, model, parent, name, full_name);
#line 1011 "dconf-model.c"
}


void key_set_to_default (Key* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = key_get_has_schema (self);
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _tmp0_;
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (!_tmp1_) {
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return;
#line 1029 "dconf-model.c"
	}
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_variant_unref0 (self->priv->_value);
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->_value = NULL;
#line 1035 "dconf-model.c"
	{
		SettingsModel* _tmp2_ = NULL;
		DConfClient* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = self->priv->model;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = _tmp2_->client;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = self->full_name;
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		dconf_client_write_sync (_tmp3_, _tmp4_, NULL, NULL, NULL, &_inner_error_);
#line 146 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1050 "dconf-model.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		e = _inner_error_;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_inner_error_ = NULL;
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_error_free0 (e);
#line 1064 "dconf-model.c"
	}
	__finally0:
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_clear_error (&_inner_error_);
#line 144 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return;
#line 1075 "dconf-model.c"
	}
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_signal_emit_by_name (self, "value-changed");
#line 1079 "dconf-model.c"
}


static void key_update_value (Key* self) {
	SettingsModel* _tmp0_ = NULL;
	DConfClient* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GVariant* _tmp3_ = NULL;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->priv->model;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _tmp0_->client;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = self->full_name;
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = dconf_client_read (_tmp1_, _tmp2_);
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_variant_unref0 (self->priv->_value);
#line 156 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->_value = _tmp3_;
#line 1102 "dconf-model.c"
}


gboolean key_get_has_schema (Key* self) {
	gboolean result;
	SchemaKey* _tmp0_ = NULL;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->schema;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp0_ != NULL;
#line 32 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1117 "dconf-model.c"
}


gint key_get_index (Key* self) {
	gint result;
	Directory* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->parent;
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = directory_get_keys (_tmp0_);
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = g_list_index (_tmp2_, self);
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp3_;
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1141 "dconf-model.c"
}


const gchar* key_get_type_string (Key* self) {
	const gchar* result;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = key_get_value (self);
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _tmp0_;
#line 45 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp1_ != NULL) {
#line 1157 "dconf-model.c"
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		GVariant* _tmp4_ = NULL;
		GVariant* _tmp5_ = NULL;
		const GVariantType* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = key_get_value (self);
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = _tmp4_;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp6_ = G_VARIANT_TYPE_STRING;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp7_ = g_variant_is_of_type (_tmp5_, _tmp6_);
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (_tmp7_) {
#line 1174 "dconf-model.c"
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp8_ = key_get_has_schema (self);
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp9_ = _tmp8_;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp3_ = _tmp9_;
#line 1183 "dconf-model.c"
		} else {
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp3_ = FALSE;
#line 1187 "dconf-model.c"
		}
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (_tmp3_) {
#line 1191 "dconf-model.c"
			SchemaKey* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp10_ = self->schema;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp11_ = _tmp10_->enum_name;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp2_ = _tmp11_ != NULL;
#line 1200 "dconf-model.c"
		} else {
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp2_ = FALSE;
#line 1204 "dconf-model.c"
		}
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (_tmp2_) {
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = "<enum>";
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 1212 "dconf-model.c"
		} else {
			GVariant* _tmp12_ = NULL;
			GVariant* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
#line 50 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp12_ = key_get_value (self);
#line 50 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp13_ = _tmp12_;
#line 50 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp14_ = g_variant_get_type_string (_tmp13_);
#line 50 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			result = _tmp14_;
#line 50 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			return result;
#line 1227 "dconf-model.c"
		}
	} else {
		SchemaKey* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp15_ = self->schema;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp16_ = _tmp15_->type;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = _tmp16_;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 1240 "dconf-model.c"
	}
}


static void key_set_type_string (Key* self, const gchar* value) {
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_notify ((GObject *) self, "type-string");
#line 1250 "dconf-model.c"
}


GVariant* key_get_value (Key* self) {
	GVariant* result;
	GVariant* _tmp0_ = NULL;
#line 60 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_update_value (self);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->priv->_value;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ != NULL) {
#line 1265 "dconf-model.c"
		GVariant* _tmp1_ = NULL;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = self->priv->_value;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = _tmp1_;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 1273 "dconf-model.c"
	} else {
		SchemaKey* _tmp2_ = NULL;
		GVariant* _tmp3_ = NULL;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = self->schema;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = _tmp2_->default_value;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = _tmp3_;
#line 66 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 1285 "dconf-model.c"
	}
}


static gpointer _g_variant_ref0 (gpointer self) {
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self ? g_variant_ref (self) : NULL;
#line 1293 "dconf-model.c"
}


void key_set_value (Key* self, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 68 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = value;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _g_variant_ref0 (_tmp0_);
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_variant_unref0 (self->priv->_value);
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->_value = _tmp1_;
#line 1311 "dconf-model.c"
	{
		SettingsModel* _tmp2_ = NULL;
		DConfClient* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GVariant* _tmp5_ = NULL;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = self->priv->model;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = _tmp2_->client;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = self->full_name;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = value;
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		dconf_client_write_sync (_tmp3_, _tmp4_, _tmp5_, NULL, NULL, &_inner_error_);
#line 73 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1329 "dconf-model.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		e = _inner_error_;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_inner_error_ = NULL;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_error_free0 (e);
#line 1343 "dconf-model.c"
	}
	__finally1:
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_clear_error (&_inner_error_);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return;
#line 1354 "dconf-model.c"
	}
#line 78 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_signal_emit_by_name (self, "value-changed");
#line 68 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_notify ((GObject *) self, "value");
#line 1360 "dconf-model.c"
}


gboolean key_get_is_default (Key* self) {
	gboolean result;
	GVariant* _tmp0_ = NULL;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_update_value (self);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->priv->_value;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp0_ == NULL;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1377 "dconf-model.c"
}


static void key_class_init (KeyClass * klass) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_parent_class = g_type_class_peek_parent (klass);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_type_class_add_private (klass, sizeof (KeyPrivate));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_key_get_property;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_key_set_property;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->finalize = key_finalize;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_HAS_SCHEMA, g_param_spec_boolean ("has-schema", "has-schema", "has-schema", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_INDEX, g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_TYPE_STRING, g_param_spec_string ("type-string", "type-string", "type-string", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_VALUE, g_param_spec_variant ("value", "value", "value", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), KEY_IS_DEFAULT, g_param_spec_boolean ("is-default", "is-default", "is-default", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_signal_new ("value_changed", TYPE_KEY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1404 "dconf-model.c"
}


static void key_instance_init (Key * self) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv = KEY_GET_PRIVATE (self);
#line 1411 "dconf-model.c"
}


static void key_finalize (GObject* obj) {
	Key * self;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEY, Key);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->model);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->parent);
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_free0 (self->name);
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_free0 (self->full_name);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_schema_key_unref0 (self->schema);
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_variant_unref0 (self->priv->_value);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (key_parent_class)->finalize (obj);
#line 1433 "dconf-model.c"
}


GType key_get_type (void) {
	static volatile gsize key_type_id__volatile = 0;
	if (g_once_init_enter (&key_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Key), 0, (GInstanceInitFunc) key_instance_init, NULL };
		GType key_type_id;
		key_type_id = g_type_register_static (G_TYPE_OBJECT, "Key", &g_define_type_info, 0);
		g_once_init_leave (&key_type_id__volatile, key_type_id);
	}
	return key_type_id__volatile;
}


static void _vala_key_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Key * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_KEY, Key);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	switch (property_id) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case KEY_HAS_SCHEMA:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_boolean (value, key_get_has_schema (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case KEY_INDEX:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_int (value, key_get_index (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case KEY_TYPE_STRING:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_string (value, key_get_type_string (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case KEY_VALUE:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_variant (value, key_get_value (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case KEY_IS_DEFAULT:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_boolean (value, key_get_is_default (self));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 1484 "dconf-model.c"
		default:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 1490 "dconf-model.c"
	}
}


static void _vala_key_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Key * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_KEY, Key);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	switch (property_id) {
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case KEY_TYPE_STRING:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		key_set_type_string (self, g_value_get_string (value));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case KEY_VALUE:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		key_set_value (self, g_value_get_variant (value));
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 1512 "dconf-model.c"
		default:
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 19 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 1518 "dconf-model.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	var = (g_free (var), NULL);
#line 1526 "dconf-model.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1533 "dconf-model.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_list_free (self);
#line 1542 "dconf-model.c"
}


Directory* directory_construct (GType object_type, SettingsModel* model, Directory* parent, const gchar* name, const gchar* full_name) {
	Directory * self = NULL;
	SettingsModel* _tmp0_ = NULL;
	SettingsModel* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	Directory* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (model != NULL, NULL);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (full_name != NULL, NULL);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (Directory*) g_object_new (object_type, NULL);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = model;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->model);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->model = _tmp1_;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = parent;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->parent);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->parent = _tmp3_;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = name;
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_free0 (self->name);
#line 208 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->name = _tmp5_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = full_name;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_free0 (self->full_name);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->full_name = _tmp7_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self;
#line 1598 "dconf-model.c"
}


Directory* directory_new (SettingsModel* model, Directory* parent, const gchar* name, const gchar* full_name) {
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return directory_construct (TYPE_DIRECTORY, model, parent, name, full_name);
#line 1605 "dconf-model.c"
}


static gint _directory_compare_directories_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = directory_compare_directories ((Directory*) a, (Directory*) b);
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1614 "dconf-model.c"
}


Directory* directory_get_child (Directory* self, const gchar* name) {
	Directory* result = NULL;
	Directory* directory = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	Directory* _tmp3_ = NULL;
	Directory* _tmp4_ = NULL;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->_child_map;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = name;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _g_object_ref0 ((Directory*) _tmp2_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory = _tmp3_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = directory;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp4_ == NULL) {
#line 1644 "dconf-model.c"
		SettingsModel* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		Directory* _tmp13_ = NULL;
		Directory* _tmp14_ = NULL;
		Directory* _tmp15_ = NULL;
		GHashTable* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		Directory* _tmp19_ = NULL;
		Directory* _tmp20_ = NULL;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = self->priv->model;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp6_ = name;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp7_ = self->full_name;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp8_ = name;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp10_ = _tmp9_;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp11_ = g_strconcat (_tmp10_, "/", NULL);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp12_ = _tmp11_;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp13_ = directory_new (_tmp5_, self, _tmp6_, _tmp12_);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (directory);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		directory = _tmp13_;
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_free0 (_tmp12_);
#line 218 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_free0 (_tmp10_);
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp14_ = directory;
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp15_ = _g_object_ref0 (_tmp14_);
#line 219 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		self->_children = g_list_insert_sorted (self->_children, _tmp15_, _directory_compare_directories_gcompare_func);
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp16_ = self->_child_map;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp17_ = name;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp18_ = g_strdup (_tmp17_);
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp19_ = directory;
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp20_ = _g_object_ref0 (_tmp19_);
#line 220 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_hash_table_insert (_tmp16_, _tmp18_, _tmp20_);
#line 1705 "dconf-model.c"
	}
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = directory;
#line 223 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1711 "dconf-model.c"
}


static gint directory_compare_directories (Directory* a, Directory* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	Directory* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Directory* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = g_strcmp0;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = a;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_->name;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = b;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_->name;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp5_;
#line 228 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1743 "dconf-model.c"
}


static gint _directory_compare_keys_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = directory_compare_keys ((Key*) a, (Key*) b);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1752 "dconf-model.c"
}


Key* directory_get_key (Directory* self, const gchar* name) {
	Key* result = NULL;
	Key* key = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	Key* _tmp3_ = NULL;
	Key* _tmp4_ = NULL;
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 231 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->_key_map;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = name;
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _g_object_ref0 ((Key*) _tmp2_);
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key = _tmp3_;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = key;
#line 235 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp4_ == NULL) {
#line 1782 "dconf-model.c"
		SettingsModel* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		Key* _tmp11_ = NULL;
		Key* _tmp12_ = NULL;
		Key* _tmp13_ = NULL;
		GHashTable* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		Key* _tmp17_ = NULL;
		Key* _tmp18_ = NULL;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = self->priv->model;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp6_ = name;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp7_ = self->full_name;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp8_ = name;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp9_ = g_strconcat (_tmp7_, _tmp8_, NULL);
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp10_ = _tmp9_;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp11_ = key_new (_tmp5_, self, _tmp6_, _tmp10_);
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (key);
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		key = _tmp11_;
#line 237 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_free0 (_tmp10_);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp12_ = key;
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		self->priv->_keys = g_list_insert_sorted (self->priv->_keys, _tmp13_, _directory_compare_keys_gcompare_func);
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp14_ = self->_key_map;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp15_ = name;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp16_ = g_strdup (_tmp15_);
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp17_ = key;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp18_ = _g_object_ref0 (_tmp17_);
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_hash_table_insert (_tmp14_, _tmp16_, _tmp18_);
#line 1835 "dconf-model.c"
	}
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = key;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1841 "dconf-model.c"
}


gint directory_compare_keys (Key* a, Key* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	Key* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Key* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = g_strcmp0;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = a;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_->name;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = b;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_->name;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp5_;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 1873 "dconf-model.c"
}


void directory_load_schema (Directory* self, Schema* schema, const gchar* path) {
	const gchar* _tmp0_ = NULL;
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (schema != NULL);
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (path != NULL);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = path;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (g_strcmp0 (_tmp0_, "") == 0) {
#line 1889 "dconf-model.c"
		Schema* _tmp1_ = NULL;
		GHashTable* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = schema;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = _tmp1_->keys;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = g_hash_table_get_values (_tmp2_);
#line 1899 "dconf-model.c"
		{
			GList* schema_key_collection = NULL;
			GList* schema_key_it = NULL;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			schema_key_collection = _tmp3_;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			for (schema_key_it = schema_key_collection; schema_key_it != NULL; schema_key_it = schema_key_it->next) {
#line 1907 "dconf-model.c"
				SchemaKey* schema_key = NULL;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				schema_key = (SchemaKey*) schema_key_it->data;
#line 1911 "dconf-model.c"
				{
					SchemaKey* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
					Key* _tmp6_ = NULL;
					Key* _tmp7_ = NULL;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp4_ = schema_key;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp5_ = _tmp4_->name;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp6_ = directory_get_key (self, _tmp5_);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp7_ = _tmp6_;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_object_unref0 (_tmp7_);
#line 1927 "dconf-model.c"
				}
			}
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_g_list_free0 (schema_key_collection);
#line 1932 "dconf-model.c"
		}
	} else {
		gchar** tokens = NULL;
		const gchar* _tmp8_ = NULL;
		gchar** _tmp9_ = NULL;
		gchar** _tmp10_ = NULL;
		gint tokens_length1 = 0;
		gint _tokens_size_ = 0;
		gchar* name = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		Directory* directory = NULL;
		const gchar* _tmp14_ = NULL;
		Directory* _tmp15_ = NULL;
		Directory* _tmp16_ = NULL;
		Schema* _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		const gchar* _tmp19_ = NULL;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp8_ = path;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "/", 2);
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		tokens = _tmp10_;
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		tokens_length1 = _vala_array_length (_tmp9_);
#line 259 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tokens_size_ = tokens_length1;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp11_ = tokens;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp11__length1 = tokens_length1;
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp12_ = _tmp11_[0];
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 260 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		name = _tmp13_;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp14_ = name;
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp15_ = directory_get_child (self, _tmp14_);
#line 262 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		directory = _tmp15_;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp16_ = directory;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp17_ = schema;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp18_ = tokens;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp18__length1 = tokens_length1;
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp19_ = _tmp18_[1];
#line 263 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		directory_load_schema (_tmp16_, _tmp17_, _tmp19_);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (directory);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_free0 (name);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
#line 1998 "dconf-model.c"
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1230 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1231 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1231 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1231 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1232 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1232 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 2032 "dconf-model.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1233 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1233 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1233 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 2041 "dconf-model.c"
	}
#line 1235 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1235 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 2047 "dconf-model.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1236 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1236 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1236 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 2056 "dconf-model.c"
	}
#line 1238 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1238 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 2062 "dconf-model.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1238 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1238 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1238 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 2071 "dconf-model.c"
	} else {
#line 1238 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 2075 "dconf-model.c"
	}
#line 1238 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1239 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1239 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 2083 "dconf-model.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1239 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1239 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1239 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 2092 "dconf-model.c"
	} else {
#line 1239 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 2096 "dconf-model.c"
	}
#line 1239 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1240 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1240 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1240 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1241 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1241 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1241 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1241 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1241 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1241 "/run/media/triton/gobelin/jhbuild/slash/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2118 "dconf-model.c"
}


static void directory_update_children (Directory* self) {
	gboolean _tmp0_ = FALSE;
	gchar** items = NULL;
	SettingsModel* _tmp1_ = NULL;
	DConfClient* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar** _tmp5_ = NULL;
	gint items_length1 = 0;
	gint _items_size_ = 0;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->priv->have_children;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_) {
#line 270 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return;
#line 2140 "dconf-model.c"
	}
#line 271 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->have_children = TRUE;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = self->priv->model;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_->client;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = self->full_name;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = dconf_client_list (_tmp2_, _tmp3_, &_tmp4_);
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	items = _tmp5_;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	items_length1 = _tmp4_;
#line 273 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_items_size_ = items_length1;
#line 2158 "dconf-model.c"
	{
		gint i = 0;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		i = 0;
#line 2163 "dconf-model.c"
		{
			gboolean _tmp6_ = FALSE;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp6_ = TRUE;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			while (TRUE) {
#line 2170 "dconf-model.c"
				gint _tmp8_ = 0;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gchar* item_name = NULL;
				const gchar* _tmp10_ = NULL;
				gchar** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (!_tmp6_) {
#line 2185 "dconf-model.c"
					gint _tmp7_ = 0;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp7_ = i;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					i = _tmp7_ + 1;
#line 2191 "dconf-model.c"
				}
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp6_ = FALSE;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp8_ = i;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp9_ = items;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp9__length1 = items_length1;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (!(_tmp8_ < _tmp9__length1)) {
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					break;
#line 2205 "dconf-model.c"
				}
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp10_ = self->full_name;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp11_ = items;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp11__length1 = items_length1;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp12_ = i;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp13_ = _tmp11_[_tmp12_];
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				item_name = _tmp14_;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp15_ = item_name;
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp16_ = dconf_is_dir (_tmp15_, NULL);
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (_tmp16_) {
#line 2227 "dconf-model.c"
					gchar* dir_name = NULL;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp18_ = 0;
					const gchar* _tmp19_ = NULL;
					gchar* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					Directory* _tmp22_ = NULL;
					Directory* _tmp23_ = NULL;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp17_ = items;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp17__length1 = items_length1;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp18_ = i;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp19_ = _tmp17_[_tmp18_];
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp20_ = string_slice (_tmp19_, (glong) 0, (glong) -1);
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					dir_name = _tmp20_;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp21_ = dir_name;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp22_ = directory_get_child (self, _tmp21_);
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp23_ = _tmp22_;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_object_unref0 (_tmp23_);
#line 278 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_free0 (dir_name);
#line 2259 "dconf-model.c"
				} else {
					gchar** _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					gint _tmp25_ = 0;
					const gchar* _tmp26_ = NULL;
					Key* _tmp27_ = NULL;
					Key* _tmp28_ = NULL;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp24_ = items;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp24__length1 = items_length1;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp25_ = i;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp26_ = _tmp24_[_tmp25_];
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp27_ = directory_get_key (self, _tmp26_);
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp28_ = _tmp27_;
#line 285 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_object_unref0 (_tmp28_);
#line 2281 "dconf-model.c"
				}
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_g_free0 (item_name);
#line 2285 "dconf-model.c"
			}
		}
	}
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	items = (_vala_array_free (items, items_length1, (GDestroyNotify) g_free), NULL);
#line 2291 "dconf-model.c"
}


KeyModel* directory_get_key_model (Directory* self) {
	KeyModel* result;
	KeyModel* _tmp0_ = NULL;
	KeyModel* _tmp2_ = NULL;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory_update_children (self);
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->priv->_key_model;
#line 174 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == NULL) {
#line 2307 "dconf-model.c"
		KeyModel* _tmp1_ = NULL;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = key_model_new (self);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (self->priv->_key_model);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		self->priv->_key_model = _tmp1_;
#line 2315 "dconf-model.c"
	}
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = self->priv->_key_model;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp2_;
#line 176 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2323 "dconf-model.c"
}


static void directory_set_key_model (Directory* self, KeyModel* value) {
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_notify ((GObject *) self, "key-model");
#line 2332 "dconf-model.c"
}


gint directory_get_index (Directory* self) {
	gint result;
	Directory* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->parent;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = directory_get_children (_tmp0_);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = g_list_index (_tmp2_, self);
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp3_;
#line 183 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2356 "dconf-model.c"
}


GList* directory_get_children (Directory* self) {
	GList* result;
	GList* _tmp0_ = NULL;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory_update_children (self);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->_children;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp0_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2373 "dconf-model.c"
}


static void directory_set_children (Directory* self, GList* value) {
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_notify ((GObject *) self, "children");
#line 2382 "dconf-model.c"
}


GList* directory_get_keys (Directory* self) {
	GList* result;
	GList* _tmp0_ = NULL;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory_update_children (self);
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = self->priv->_keys;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp0_;
#line 198 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2399 "dconf-model.c"
}


static void directory_set_keys (Directory* self, GList* value) {
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_notify ((GObject *) self, "keys");
#line 2408 "dconf-model.c"
}


static void directory_class_init (DirectoryClass * klass) {
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory_parent_class = g_type_class_peek_parent (klass);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_type_class_add_private (klass, sizeof (DirectoryPrivate));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_directory_get_property;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_directory_set_property;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->finalize = directory_finalize;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIRECTORY_KEY_MODEL, g_param_spec_object ("key-model", "key-model", "key-model", TYPE_KEY_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIRECTORY_INDEX, g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIRECTORY_CHILDREN, g_param_spec_pointer ("children", "children", "children", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DIRECTORY_KEYS, g_param_spec_pointer ("keys", "keys", "keys", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2431 "dconf-model.c"
}


static void directory_instance_init (Directory * self) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv = DIRECTORY_GET_PRIVATE (self);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = g_str_hash;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = g_str_equal;
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->_child_map = _tmp2_;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->_children = NULL;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = g_str_hash;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = g_str_equal;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->_key_map = _tmp5_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->_keys = NULL;
#line 2464 "dconf-model.c"
}


static void directory_finalize (GObject* obj) {
	Directory * self;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DIRECTORY, Directory);
#line 162 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->model);
#line 164 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_free0 (self->name);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_free0 (self->full_name);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->parent);
#line 169 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->_key_model);
#line 186 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_hash_table_unref0 (self->_child_map);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	__g_list_free__g_object_unref0_0 (self->_children);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_hash_table_unref0 (self->_key_map);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	__g_list_free__g_object_unref0_0 (self->priv->_keys);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (directory_parent_class)->finalize (obj);
#line 2492 "dconf-model.c"
}


GType directory_get_type (void) {
	static volatile gsize directory_type_id__volatile = 0;
	if (g_once_init_enter (&directory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Directory), 0, (GInstanceInitFunc) directory_instance_init, NULL };
		GType directory_type_id;
		directory_type_id = g_type_register_static (G_TYPE_OBJECT, "Directory", &g_define_type_info, 0);
		g_once_init_leave (&directory_type_id__volatile, directory_type_id);
	}
	return directory_type_id__volatile;
}


static void _vala_directory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Directory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DIRECTORY, Directory);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	switch (property_id) {
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case DIRECTORY_KEY_MODEL:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_object (value, directory_get_key_model (self));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case DIRECTORY_INDEX:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_int (value, directory_get_index (self));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case DIRECTORY_CHILDREN:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_pointer (value, directory_get_children (self));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case DIRECTORY_KEYS:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_pointer (value, directory_get_keys (self));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 2537 "dconf-model.c"
		default:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 2543 "dconf-model.c"
	}
}


static void _vala_directory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Directory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DIRECTORY, Directory);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	switch (property_id) {
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case DIRECTORY_KEY_MODEL:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		directory_set_key_model (self, g_value_get_object (value));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case DIRECTORY_CHILDREN:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		directory_set_children (self, g_value_get_pointer (value));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		case DIRECTORY_KEYS:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		directory_set_keys (self, g_value_get_pointer (value));
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 2571 "dconf-model.c"
		default:
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		break;
#line 2577 "dconf-model.c"
	}
}


static void _key_model_key_changed_cb_key_value_changed (Key* _sender, gpointer self) {
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_model_key_changed_cb ((KeyModel*) self, _sender);
#line 2585 "dconf-model.c"
}


KeyModel* key_model_construct (GType object_type, Directory* directory) {
	KeyModel * self = NULL;
	Directory* _tmp0_ = NULL;
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (directory != NULL, NULL);
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) g_object_new (object_type, NULL);
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = directory;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->directory);
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->directory = _tmp1_;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = directory;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = directory_get_keys (_tmp2_);
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_;
#line 2614 "dconf-model.c"
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		key_collection = _tmp4_;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
#line 2622 "dconf-model.c"
			Key* _tmp5_ = NULL;
			Key* key = NULL;
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp5_ = _g_object_ref0 ((Key*) key_it->data);
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			key = _tmp5_;
#line 2629 "dconf-model.c"
			{
				Key* _tmp6_ = NULL;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp6_ = key;
#line 299 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				g_signal_connect_object (_tmp6_, "value-changed", (GCallback) _key_model_key_changed_cb_key_value_changed, self, 0);
#line 298 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_g_object_unref0 (key);
#line 2638 "dconf-model.c"
			}
		}
	}
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self;
#line 2644 "dconf-model.c"
}


KeyModel* key_model_new (Directory* directory) {
#line 295 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return key_model_construct (TYPE_KEY_MODEL, directory);
#line 2651 "dconf-model.c"
}


static void key_model_key_changed_cb (KeyModel* self, Key* key) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 302 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (key != NULL);
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) self, &_tmp0_);
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iter = _tmp0_;
#line 305 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (!_tmp1_) {
#line 306 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return;
#line 2671 "dconf-model.c"
	}
	{
		gboolean _tmp2_ = FALSE;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = TRUE;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		while (TRUE) {
#line 2679 "dconf-model.c"
			GtkTreeIter _tmp4_ = {0};
			Key* _tmp5_ = NULL;
			Key* _tmp6_ = NULL;
			Key* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			if (!_tmp2_) {
#line 2687 "dconf-model.c"
				gboolean _tmp3_ = FALSE;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp3_ = gtk_tree_model_iter_next ((GtkTreeModel*) self, &iter);
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (!_tmp3_) {
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					break;
#line 2695 "dconf-model.c"
				}
			}
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp2_ = FALSE;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp4_ = iter;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp5_ = key_model_get_key (self, &_tmp4_);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp6_ = _tmp5_;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp7_ = key;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp8_ = _tmp6_ == _tmp7_;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_g_object_unref0 (_tmp6_);
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			if (_tmp8_) {
#line 2714 "dconf-model.c"
				GtkTreeIter _tmp9_ = {0};
				GtkTreePath* _tmp10_ = NULL;
				GtkTreePath* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp9_ = iter;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp10_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp9_);
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp11_ = _tmp10_;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp12_ = iter;
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				gtk_tree_model_row_changed ((GtkTreeModel*) self, _tmp11_, &_tmp12_);
#line 312 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_gtk_tree_path_free0 (_tmp11_);
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				return;
#line 2733 "dconf-model.c"
			}
		}
	}
}


static GtkTreeModelFlags key_model_real_get_flags (GtkTreeModel* base) {
	KeyModel * self;
	GtkTreeModelFlags result = 0;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = GTK_TREE_MODEL_LIST_ONLY;
#line 320 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2749 "dconf-model.c"
}


static gint key_model_real_get_n_columns (GtkTreeModel* base) {
	KeyModel * self;
	gint result = 0;
#line 323 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = 3;
#line 325 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2762 "dconf-model.c"
}


static GType key_model_real_get_column_type (GtkTreeModel* base, gint index) {
	KeyModel * self;
	GType result = 0UL;
	gint _tmp0_ = 0;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = index;
#line 330 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == 0) {
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = TYPE_KEY;
#line 331 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 2780 "dconf-model.c"
	} else {
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = G_TYPE_STRING;
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 2786 "dconf-model.c"
	}
}


static void key_model_set_iter (KeyModel* self, GtkTreeIter* iter, Key* key) {
	Key* _tmp0_ = NULL;
	Key* _tmp1_ = NULL;
	Key* _tmp2_ = NULL;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (key != NULL);
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).stamp = 0;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = key;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data = _tmp0_;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = key;
#line 340 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data2 = _tmp1_;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = key;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data3 = _tmp2_;
#line 2815 "dconf-model.c"
}


Key* key_model_get_key (KeyModel* self, GtkTreeIter* iter) {
	Key* result = NULL;
	GtkTreeIter _tmp0_ = {0};
	void* _tmp1_ = NULL;
	Key* _tmp2_ = NULL;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _tmp0_.user_data;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_KEY, Key));
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp2_;
#line 346 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2838 "dconf-model.c"
}


static gboolean key_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	KeyModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreePath* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkTreePath* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 349 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 351 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = path;
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = gtk_tree_path_get_depth (_tmp0_);
#line 353 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp1_ != 1) {
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 2872 "dconf-model.c"
		}
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 2876 "dconf-model.c"
	}
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = path;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = gtk_tree_path_get_indices_with_depth (_tmp2_, &_tmp3_);
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = _tmp4_[0];
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, &_tmp6_, NULL, _tmp5_);
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_vala_iter = _tmp6_;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp7_;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 2894 "dconf-model.c"
	}
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2898 "dconf-model.c"
}


static GtkTreePath* key_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	GtkTreePath* result = NULL;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	Key* _tmp2_ = NULL;
	Key* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = gtk_tree_path_new ();
#line 361 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	path = _tmp0_;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = *iter;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = key_model_get_key (self, &_tmp1_);
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _tmp2_;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = key_get_index (_tmp3_);
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = _tmp4_;
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	gtk_tree_path_append_index (path, _tmp5_);
#line 362 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp3_);
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = path;
#line 363 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 2938 "dconf-model.c"
}


static void key_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	KeyModel * self;
	GValue _vala_value = {0};
	Key* key = NULL;
	GtkTreeIter _tmp0_ = {0};
	Key* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = key_model_get_key (self, &_tmp0_);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key = _tmp1_;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = column;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp2_ == 0) {
#line 2963 "dconf-model.c"
		Key* _tmp3_ = NULL;
		GValue _tmp4_ = {0};
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = key;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_init (&_tmp4_, TYPE_KEY);
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_object (&_tmp4_, _tmp3_);
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 371 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_vala_value = _tmp4_;
#line 2976 "dconf-model.c"
	} else {
		gint _tmp5_ = 0;
#line 372 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = column;
#line 372 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (_tmp5_ == 1) {
#line 2983 "dconf-model.c"
			Key* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			GValue _tmp8_ = {0};
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp6_ = key;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp7_ = _tmp6_->name;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_value_init (&_tmp8_, G_TYPE_STRING);
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_value_set_string (&_tmp8_, _tmp7_);
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 373 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_vala_value = _tmp8_;
#line 2999 "dconf-model.c"
		} else {
			gint _tmp9_ = 0;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp9_ = column;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			if (_tmp9_ == 2) {
#line 3006 "dconf-model.c"
				gchar* _tmp10_ = NULL;
				Key* _tmp11_ = NULL;
				GVariant* _tmp12_ = NULL;
				GVariant* _tmp13_ = NULL;
				GValue _tmp19_ = {0};
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp11_ = key;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp12_ = key_get_value (_tmp11_);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp13_ = _tmp12_;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (_tmp13_ != NULL) {
#line 3020 "dconf-model.c"
					Key* _tmp14_ = NULL;
					GVariant* _tmp15_ = NULL;
					GVariant* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp14_ = key;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp15_ = key_get_value (_tmp14_);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp16_ = _tmp15_;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp17_ = g_variant_print (_tmp16_, FALSE);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_free0 (_tmp10_);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp10_ = _tmp17_;
#line 3037 "dconf-model.c"
				} else {
					gchar* _tmp18_ = NULL;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp18_ = g_strdup ("");
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_free0 (_tmp10_);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp10_ = _tmp18_;
#line 3046 "dconf-model.c"
				}
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				g_value_init (&_tmp19_, G_TYPE_STRING);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				g_value_set_string (&_tmp19_, _tmp10_);
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 375 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_vala_value = _tmp19_;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_g_free0 (_tmp10_);
#line 3058 "dconf-model.c"
			} else {
				gint _tmp20_ = 0;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp20_ = column;
#line 376 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (_tmp20_ == 4) {
#line 3065 "dconf-model.c"
					PangoWeight _tmp21_ = 0;
					Key* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					gboolean _tmp24_ = FALSE;
					GValue _tmp25_ = {0};
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp22_ = key;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp23_ = key_get_is_default (_tmp22_);
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp24_ = _tmp23_;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					if (_tmp24_) {
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						_tmp21_ = PANGO_WEIGHT_NORMAL;
#line 3081 "dconf-model.c"
					} else {
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						_tmp21_ = PANGO_WEIGHT_BOLD;
#line 3085 "dconf-model.c"
					}
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					g_value_init (&_tmp25_, pango_weight_get_type ());
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					g_value_set_enum (&_tmp25_, _tmp21_);
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 377 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_vala_value = _tmp25_;
#line 3095 "dconf-model.c"
				} else {
					GValue _tmp26_ = {0};
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					g_value_init (&_tmp26_, G_TYPE_INT);
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					g_value_set_int (&_tmp26_, 0);
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 379 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_vala_value = _tmp26_;
#line 3106 "dconf-model.c"
				}
			}
		}
	}
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (key);
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (value) {
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*value = _vala_value;
#line 3117 "dconf-model.c"
	} else {
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 3121 "dconf-model.c"
	}
}


static gboolean key_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	gboolean result = FALSE;
	gint index = 0;
	GtkTreeIter _tmp0_ = {0};
	Key* _tmp1_ = NULL;
	Key* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	Directory* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	Directory* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gconstpointer _tmp15_ = NULL;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = key_model_get_key (self, &_tmp0_);
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = key_get_index (_tmp2_);
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = _tmp4_;
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 384 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	index = _tmp5_;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = index;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = self->priv->directory;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = directory_get_keys (_tmp7_);
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp9_ = _tmp8_;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp10_ = g_list_length (_tmp9_);
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (((guint) _tmp6_) >= (_tmp10_ - 1)) {
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 386 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3182 "dconf-model.c"
	}
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp11_ = self->priv->directory;
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp12_ = directory_get_keys (_tmp11_);
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp13_ = _tmp12_;
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp14_ = index;
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp15_ = g_list_nth_data (_tmp13_, (guint) (_tmp14_ + 1));
#line 387 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_model_set_iter (self, iter, (Key*) _tmp15_);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3200 "dconf-model.c"
}


static gboolean key_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	KeyModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkTreeIter* _tmp1_ = NULL;
	Directory* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
#line 391 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = parent;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp1_ != NULL) {
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp0_ = TRUE;
#line 3224 "dconf-model.c"
	} else {
		Directory* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = self->priv->directory;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = directory_get_keys (_tmp2_);
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = _tmp3_;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = g_list_length (_tmp4_);
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp0_ = _tmp5_ == ((guint) 0);
#line 3240 "dconf-model.c"
	}
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_) {
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 3250 "dconf-model.c"
		}
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3254 "dconf-model.c"
	}
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = self->priv->directory;
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = directory_get_keys (_tmp6_);
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = _tmp7_;
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_model_set_iter (self, &_vala_iter, (Key*) _tmp9_);
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 3272 "dconf-model.c"
	}
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3276 "dconf-model.c"
}


static gboolean key_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	gboolean result = FALSE;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = FALSE;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3291 "dconf-model.c"
}


static gint key_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	gint result = 0;
	GtkTreeIter* _tmp0_ = NULL;
#line 407 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = iter;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == NULL) {
#line 3305 "dconf-model.c"
		Directory* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = self->priv->directory;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = directory_get_keys (_tmp1_);
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = _tmp2_;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = g_list_length (_tmp3_);
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = (gint) _tmp4_;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3322 "dconf-model.c"
	} else {
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = 0;
#line 412 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3328 "dconf-model.c"
	}
}


static gboolean key_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	KeyModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreeIter* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Directory* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	Directory* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gconstpointer _tmp10_ = NULL;
#line 415 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 417 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = parent;
#line 419 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ != NULL) {
#line 420 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 420 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 420 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 3362 "dconf-model.c"
		}
#line 420 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3366 "dconf-model.c"
	}
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = n;
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = self->priv->directory;
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = directory_get_keys (_tmp2_);
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_;
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = g_list_length (_tmp4_);
#line 422 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (((guint) _tmp1_) >= _tmp5_) {
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 3386 "dconf-model.c"
		}
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3390 "dconf-model.c"
	}
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = self->priv->directory;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = directory_get_keys (_tmp6_);
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = _tmp7_;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp9_ = n;
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp10_ = g_list_nth_data (_tmp8_, (guint) _tmp9_);
#line 424 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_model_set_iter (self, &_vala_iter, (Key*) _tmp10_);
#line 425 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 425 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 425 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 3410 "dconf-model.c"
	}
#line 425 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3414 "dconf-model.c"
}


static gboolean key_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	KeyModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 428 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (child != NULL, FALSE);
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 431 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = FALSE;
#line 431 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 431 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 3434 "dconf-model.c"
	}
#line 431 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3438 "dconf-model.c"
}


static void key_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	GtkTreeIter _tmp0_ = {0};
	Key* _tmp1_ = NULL;
	Key* _tmp2_ = NULL;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 434 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 436 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 436 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = key_model_get_key (self, &_tmp0_);
#line 436 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 436 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_ref ((GObject*) _tmp2_);
#line 436 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 3461 "dconf-model.c"
}


static void key_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	KeyModel * self;
	GtkTreeIter _tmp0_ = {0};
	Key* _tmp1_ = NULL;
	Key* _tmp2_ = NULL;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (KeyModel*) base;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = key_model_get_key (self, &_tmp0_);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_unref ((GObject*) _tmp2_);
#line 441 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 3484 "dconf-model.c"
}


static void key_model_class_init (KeyModelClass * klass) {
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_model_parent_class = g_type_class_peek_parent (klass);
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_type_class_add_private (klass, sizeof (KeyModelPrivate));
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->finalize = key_model_finalize;
#line 3495 "dconf-model.c"
}


static void key_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	key_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_flags = (GtkTreeModelFlags (*)(GtkTreeModel*)) key_model_real_get_flags;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_n_columns = (gint (*)(GtkTreeModel*)) key_model_real_get_n_columns;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_column_type = (GType (*)(GtkTreeModel*, gint)) key_model_real_get_column_type;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_iter = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) key_model_real_get_iter;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_path = (GtkTreePath* (*)(GtkTreeModel*, GtkTreeIter*)) key_model_real_get_path;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_value = (void (*)(GtkTreeModel*, GtkTreeIter*, gint, GValue*)) key_model_real_get_value;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_next = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) key_model_real_iter_next;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_children = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) key_model_real_iter_children;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_has_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) key_model_real_iter_has_child;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_n_children = (gint (*)(GtkTreeModel*, GtkTreeIter*)) key_model_real_iter_n_children;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_nth_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) key_model_real_iter_nth_child;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_parent = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) key_model_real_iter_parent;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->ref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) key_model_real_ref_node;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->unref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) key_model_real_unref_node;
#line 3530 "dconf-model.c"
}


static void key_model_instance_init (KeyModel * self) {
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv = KEY_MODEL_GET_PRIVATE (self);
#line 3537 "dconf-model.c"
}


static void key_model_finalize (GObject* obj) {
	KeyModel * self;
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEY_MODEL, KeyModel);
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->directory);
#line 291 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (key_model_parent_class)->finalize (obj);
#line 3549 "dconf-model.c"
}


GType key_model_get_type (void) {
	static volatile gsize key_model_type_id__volatile = 0;
	if (g_once_init_enter (&key_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeyModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) key_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyModel), 0, (GInstanceInitFunc) key_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) key_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType key_model_type_id;
		key_model_type_id = g_type_register_static (G_TYPE_OBJECT, "KeyModel", &g_define_type_info, 0);
		g_type_add_interface_static (key_model_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&key_model_type_id__volatile, key_model_type_id);
	}
	return key_model_type_id__volatile;
}


static gpointer _schema_enum_ref0 (gpointer self) {
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self ? schema_enum_ref (self) : NULL;
#line 3570 "dconf-model.c"
}


EnumModel* enum_model_construct (GType object_type, SchemaEnum* schema_enum) {
	EnumModel * self = NULL;
	SchemaEnum* _tmp0_ = NULL;
	SchemaEnum* _tmp1_ = NULL;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (schema_enum != NULL, NULL);
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) g_object_new (object_type, NULL);
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = schema_enum;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _schema_enum_ref0 (_tmp0_);
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_schema_enum_unref0 (self->priv->schema_enum);
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->schema_enum = _tmp1_;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self;
#line 3592 "dconf-model.c"
}


EnumModel* enum_model_new (SchemaEnum* schema_enum) {
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return enum_model_construct (TYPE_ENUM_MODEL, schema_enum);
#line 3599 "dconf-model.c"
}


static GtkTreeModelFlags enum_model_real_get_flags (GtkTreeModel* base) {
	EnumModel * self;
	GtkTreeModelFlags result = 0;
#line 454 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = GTK_TREE_MODEL_LIST_ONLY;
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3612 "dconf-model.c"
}


static gint enum_model_real_get_n_columns (GtkTreeModel* base) {
	EnumModel * self;
	gint result = 0;
#line 459 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 461 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = 2;
#line 461 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3625 "dconf-model.c"
}


static GType enum_model_real_get_column_type (GtkTreeModel* base, gint index) {
	EnumModel * self;
	GType result = 0UL;
	gint _tmp0_ = 0;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = index;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == 0) {
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = G_TYPE_STRING;
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3643 "dconf-model.c"
	} else {
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = G_TYPE_INT;
#line 469 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3649 "dconf-model.c"
	}
}


static void enum_model_set_iter (EnumModel* self, GtkTreeIter* iter, SchemaValue* value) {
	SchemaValue* _tmp0_ = NULL;
	SchemaValue* _tmp1_ = NULL;
	SchemaValue* _tmp2_ = NULL;
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 472 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (value != NULL);
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).stamp = 0;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = value;
#line 475 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data = _tmp0_;
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = value;
#line 476 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data2 = _tmp1_;
#line 477 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = value;
#line 477 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data3 = _tmp2_;
#line 3678 "dconf-model.c"
}


SchemaValue* enum_model_get_enum_value (EnumModel* self, GtkTreeIter* iter) {
	SchemaValue* result = NULL;
	GtkTreeIter _tmp0_ = {0};
	void* _tmp1_ = NULL;
	SchemaValue* _tmp2_ = NULL;
#line 480 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 480 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = _tmp0_.user_data;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SCHEMA_VALUE, SchemaValue));
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp2_;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3701 "dconf-model.c"
}


static gboolean enum_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	EnumModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreePath* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkTreePath* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 485 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 487 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = path;
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = gtk_tree_path_get_depth (_tmp0_);
#line 489 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp1_ != 1) {
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 3735 "dconf-model.c"
		}
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3739 "dconf-model.c"
	}
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = path;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = gtk_tree_path_get_indices_with_depth (_tmp2_, &_tmp3_);
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = _tmp4_[0];
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, &_tmp6_, NULL, _tmp5_);
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_vala_iter = _tmp6_;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp7_;
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 3757 "dconf-model.c"
	}
#line 492 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3761 "dconf-model.c"
}


static GtkTreePath* enum_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	GtkTreePath* result = NULL;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	SchemaValue* _tmp2_ = NULL;
	SchemaValue* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
#line 495 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 495 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = gtk_tree_path_new ();
#line 497 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	path = _tmp0_;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = *iter;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = enum_model_get_enum_value (self, &_tmp1_);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _tmp2_;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_->index;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	gtk_tree_path_append_index (path, (gint) _tmp4_);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp3_);
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = path;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3798 "dconf-model.c"
}


static void enum_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	EnumModel * self;
	GValue _vala_value = {0};
	gint _tmp0_ = 0;
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = column;
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == 0) {
#line 3814 "dconf-model.c"
		GtkTreeIter _tmp1_ = {0};
		SchemaValue* _tmp2_ = NULL;
		SchemaValue* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GValue _tmp5_ = {0};
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = *iter;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = enum_model_get_enum_value (self, &_tmp1_);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = _tmp2_;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = _tmp3_->nick;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_init (&_tmp5_, G_TYPE_STRING);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_string (&_tmp5_, _tmp4_);
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_vala_value = _tmp5_;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (_tmp3_);
#line 3838 "dconf-model.c"
	} else {
		gint _tmp6_ = 0;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp6_ = column;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (_tmp6_ == 1) {
#line 3845 "dconf-model.c"
			GtkTreeIter _tmp7_ = {0};
			SchemaValue* _tmp8_ = NULL;
			SchemaValue* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			GValue _tmp11_ = {0};
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp7_ = *iter;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp8_ = enum_model_get_enum_value (self, &_tmp7_);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp9_ = _tmp8_;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp10_ = _tmp9_->value;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_value_init (&_tmp11_, G_TYPE_INT);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_value_set_int (&_tmp11_, _tmp10_);
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_vala_value = _tmp11_;
#line 507 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_g_object_unref0 (_tmp9_);
#line 3869 "dconf-model.c"
		} else {
			GValue _tmp12_ = {0};
#line 509 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_value_init (&_tmp12_, G_TYPE_INT);
#line 509 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			g_value_set_int (&_tmp12_, 0);
#line 509 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 509 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_vala_value = _tmp12_;
#line 3880 "dconf-model.c"
		}
	}
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (value) {
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*value = _vala_value;
#line 3887 "dconf-model.c"
	} else {
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 3891 "dconf-model.c"
	}
}


static gboolean enum_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	gboolean result = FALSE;
	guint index = 0U;
	GtkTreeIter _tmp0_ = {0};
	SchemaValue* _tmp1_ = NULL;
	SchemaValue* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	SchemaEnum* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	SchemaEnum* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	gconstpointer _tmp12_ = NULL;
#line 512 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 512 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = enum_model_get_enum_value (self, &_tmp0_);
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _tmp2_->index;
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_;
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 514 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	index = _tmp4_;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = index;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = self->priv->schema_enum;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = _tmp6_->values;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = g_list_length (_tmp7_);
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp5_ >= (_tmp8_ - 1)) {
#line 516 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 516 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 3945 "dconf-model.c"
	}
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp9_ = self->priv->schema_enum;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp10_ = _tmp9_->values;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp11_ = index;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp12_ = g_list_nth_data (_tmp10_, _tmp11_ + 1);
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	enum_model_set_iter (self, iter, (SchemaValue*) _tmp12_);
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 518 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 3961 "dconf-model.c"
}


static gboolean enum_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	EnumModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GtkTreeIter* _tmp1_ = NULL;
	SchemaEnum* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	gconstpointer _tmp7_ = NULL;
#line 521 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = parent;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp1_ != NULL) {
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp0_ = TRUE;
#line 3984 "dconf-model.c"
	} else {
		SchemaEnum* _tmp2_ = NULL;
		GList* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = self->priv->schema_enum;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = _tmp2_->values;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = g_list_length (_tmp3_);
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp0_ = _tmp4_ == ((guint) 0);
#line 3997 "dconf-model.c"
	}
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_) {
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 4007 "dconf-model.c"
		}
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4011 "dconf-model.c"
	}
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = self->priv->schema_enum;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = _tmp5_->values;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = g_list_nth_data (_tmp6_, (guint) 0);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	enum_model_set_iter (self, &_vala_iter, (SchemaValue*) _tmp7_);
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 4027 "dconf-model.c"
	}
#line 530 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 4031 "dconf-model.c"
}


static gboolean enum_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	gboolean result = FALSE;
#line 533 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 533 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = FALSE;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 4046 "dconf-model.c"
}


static gint enum_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	gint result = 0;
	GtkTreeIter* _tmp0_ = NULL;
#line 538 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = iter;
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == NULL) {
#line 4060 "dconf-model.c"
		SchemaEnum* _tmp1_ = NULL;
		GList* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = self->priv->schema_enum;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = _tmp1_->values;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = g_list_length (_tmp2_);
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = (gint) _tmp3_;
#line 541 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4074 "dconf-model.c"
	} else {
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = 0;
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4080 "dconf-model.c"
	}
}


static gboolean enum_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	EnumModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreeIter* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	SchemaEnum* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	SchemaEnum* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gconstpointer _tmp8_ = NULL;
#line 546 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 550 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = parent;
#line 550 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ != NULL) {
#line 551 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 551 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 551 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 4112 "dconf-model.c"
		}
#line 551 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4116 "dconf-model.c"
	}
#line 553 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = n;
#line 553 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = self->priv->schema_enum;
#line 553 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _tmp2_->values;
#line 553 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = g_list_length (_tmp3_);
#line 553 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (((guint) _tmp1_) >= _tmp4_) {
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 4134 "dconf-model.c"
		}
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4138 "dconf-model.c"
	}
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = self->priv->schema_enum;
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = _tmp5_->values;
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = n;
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = g_list_nth_data (_tmp6_, (guint) _tmp7_);
#line 555 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	enum_model_set_iter (self, &_vala_iter, (SchemaValue*) _tmp8_);
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 4156 "dconf-model.c"
	}
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 4160 "dconf-model.c"
}


static gboolean enum_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	EnumModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (child != NULL, FALSE);
#line 561 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = FALSE;
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 4180 "dconf-model.c"
	}
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 4184 "dconf-model.c"
}


static void enum_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	GtkTreeIter _tmp0_ = {0};
	SchemaValue* _tmp1_ = NULL;
	SchemaValue* _tmp2_ = NULL;
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = enum_model_get_enum_value (self, &_tmp0_);
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_ref ((GObject*) _tmp2_);
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 4207 "dconf-model.c"
}


static void enum_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	EnumModel * self;
	GtkTreeIter _tmp0_ = {0};
	SchemaValue* _tmp1_ = NULL;
	SchemaValue* _tmp2_ = NULL;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (EnumModel*) base;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = enum_model_get_enum_value (self, &_tmp0_);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_unref ((GObject*) _tmp2_);
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 4230 "dconf-model.c"
}


static void enum_model_class_init (EnumModelClass * klass) {
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	enum_model_parent_class = g_type_class_peek_parent (klass);
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_type_class_add_private (klass, sizeof (EnumModelPrivate));
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->finalize = enum_model_finalize;
#line 4241 "dconf-model.c"
}


static void enum_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	enum_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_flags = (GtkTreeModelFlags (*)(GtkTreeModel*)) enum_model_real_get_flags;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_n_columns = (gint (*)(GtkTreeModel*)) enum_model_real_get_n_columns;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_column_type = (GType (*)(GtkTreeModel*, gint)) enum_model_real_get_column_type;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_iter = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) enum_model_real_get_iter;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_path = (GtkTreePath* (*)(GtkTreeModel*, GtkTreeIter*)) enum_model_real_get_path;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_value = (void (*)(GtkTreeModel*, GtkTreeIter*, gint, GValue*)) enum_model_real_get_value;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_next = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) enum_model_real_iter_next;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_children = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) enum_model_real_iter_children;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_has_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) enum_model_real_iter_has_child;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_n_children = (gint (*)(GtkTreeModel*, GtkTreeIter*)) enum_model_real_iter_n_children;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_nth_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) enum_model_real_iter_nth_child;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_parent = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) enum_model_real_iter_parent;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->ref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) enum_model_real_ref_node;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->unref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) enum_model_real_unref_node;
#line 4276 "dconf-model.c"
}


static void enum_model_instance_init (EnumModel * self) {
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv = ENUM_MODEL_GET_PRIVATE (self);
#line 4283 "dconf-model.c"
}


static void enum_model_finalize (GObject* obj) {
	EnumModel * self;
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENUM_MODEL, EnumModel);
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_schema_enum_unref0 (self->priv->schema_enum);
#line 445 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (enum_model_parent_class)->finalize (obj);
#line 4295 "dconf-model.c"
}


GType enum_model_get_type (void) {
	static volatile gsize enum_model_type_id__volatile = 0;
	if (g_once_init_enter (&enum_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EnumModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) enum_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EnumModel), 0, (GInstanceInitFunc) enum_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) enum_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType enum_model_type_id;
		enum_model_type_id = g_type_register_static (G_TYPE_OBJECT, "EnumModel", &g_define_type_info, 0);
		g_type_add_interface_static (enum_model_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&enum_model_type_id__volatile, enum_model_type_id);
	}
	return enum_model_type_id__volatile;
}


static void settings_model_watch_func (SettingsModel* self, DConfClient* client, const gchar* path, gchar** items, int items_length1, const gchar* tag) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (client != NULL);
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (path != NULL);
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = items;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0__length1 = items_length1;
#line 4326 "dconf-model.c"
	{
		gchar** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		item_collection = _tmp0_;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		item_collection_length1 = _tmp0__length1;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
#line 4338 "dconf-model.c"
			gchar* _tmp1_ = NULL;
			gchar* item = NULL;
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp1_ = g_strdup (item_collection[item_it]);
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			item = _tmp1_;
#line 4345 "dconf-model.c"
			{
				const gchar* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp2_ = path;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp3_ = item;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp5_ = _tmp4_;
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				g_signal_emit_by_name (self, "item-changed", _tmp5_);
#line 587 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_g_free0 (_tmp5_);
#line 586 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_g_free0 (item);
#line 4365 "dconf-model.c"
			}
		}
	}
}


static void _settings_model_watch_func_dconf_client_changed (DConfClient* _sender, const gchar* prefix, gchar** changes, const gchar* tag, gpointer self) {
#line 594 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	settings_model_watch_func ((SettingsModel*) self, _sender, prefix, changes, _vala_array_length (changes), tag);
#line 4375 "dconf-model.c"
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = g_new0 (gchar*, length + 1);
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	for (i = 0; i < length; i++) {
#line 4386 "dconf-model.c"
		gchar* _tmp0_ = NULL;
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp0_ = g_strdup (self[i]);
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result[i] = _tmp0_;
#line 4392 "dconf-model.c"
	}
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 4396 "dconf-model.c"
}


SettingsModel* settings_model_construct (GType object_type) {
	SettingsModel * self = NULL;
	DConfClient* _tmp0_ = NULL;
	DConfClient* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	DConfClient* _tmp3_ = NULL;
	SchemaList* _tmp4_ = NULL;
	SchemaList* _tmp30_ = NULL;
	GHashTable* _tmp31_ = NULL;
	GList* _tmp32_ = NULL;
	GError * _inner_error_ = NULL;
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) g_object_new (object_type, NULL);
#line 593 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = dconf_client_new ();
#line 593 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->client);
#line 593 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->client = _tmp0_;
#line 594 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = self->client;
#line 594 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _settings_model_watch_func_dconf_client_changed, self, 0);
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = directory_new (self, NULL, "/", "/");
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->root);
#line 595 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv->root = _tmp2_;
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = self->client;
#line 596 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	dconf_client_watch_sync (_tmp3_, "/");
#line 598 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = schema_list_new ();
#line 598 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_schema_list_unref0 (self->schemas);
#line 598 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->schemas = _tmp4_;
#line 4439 "dconf-model.c"
	{
		gchar** dirs = NULL;
		gchar** _tmp5_ = NULL;
		gchar** _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint dirs_length1 = 0;
		gint _dirs_size_ = 0;
		gchar* dir = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp6_ = _tmp5_ = g_get_system_data_dirs ();
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup1 (_tmp6_, _vala_array_length (_tmp5_)) : ((gpointer) _tmp6_);
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp7__length1 = _vala_array_length (_tmp5_);
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		dirs = _tmp7_;
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		dirs_length1 = _tmp7__length1;
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_dirs_size_ = dirs_length1;
#line 4464 "dconf-model.c"
		{
			gint i = 0;
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp8_ = dirs;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp8__length1 = dirs_length1;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			i = _tmp8__length1 - 1;
#line 4475 "dconf-model.c"
			{
				gboolean _tmp9_ = FALSE;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp9_ = TRUE;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				while (TRUE) {
#line 4482 "dconf-model.c"
					gint _tmp11_ = 0;
					gchar* path = NULL;
					gchar** _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					gint _tmp13_ = 0;
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					GFile* _tmp17_ = NULL;
					GFile* _tmp18_ = NULL;
					gboolean _tmp19_ = FALSE;
					gboolean _tmp20_ = FALSE;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					if (!_tmp9_) {
#line 4497 "dconf-model.c"
						gint _tmp10_ = 0;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						_tmp10_ = i;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						i = _tmp10_ - 1;
#line 4503 "dconf-model.c"
					}
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp9_ = FALSE;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp11_ = i;
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					if (!(_tmp11_ >= 0)) {
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						break;
#line 4513 "dconf-model.c"
					}
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp12_ = dirs;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp12__length1 = dirs_length1;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp13_ = i;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp14_ = _tmp12_[_tmp13_];
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp15_ = g_build_filename (_tmp14_, "glib-2.0", "schemas", NULL);
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					path = _tmp15_;
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp16_ = path;
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp17_ = g_file_new_for_path (_tmp16_);
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp18_ = _tmp17_;
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp19_ = g_file_query_exists (_tmp18_, NULL);
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp20_ = _tmp19_;
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_object_unref0 (_tmp18_);
#line 609 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					if (_tmp20_) {
#line 4541 "dconf-model.c"
						SchemaList* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						_tmp21_ = self->schemas;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						_tmp22_ = path;
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						schema_list_load_directory (_tmp21_, _tmp22_, &_inner_error_);
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
							_g_free0 (path);
#line 610 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
							dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
#line 4556 "dconf-model.c"
							goto __catch2_g_error;
						}
					}
#line 606 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_free0 (path);
#line 4562 "dconf-model.c"
				}
			}
		}
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp23_ = g_getenv ("GSETTINGS_SCHEMA_DIR");
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp24_ = g_strdup (_tmp23_);
#line 613 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		dir = _tmp24_;
#line 614 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp25_ = dir;
#line 614 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (_tmp25_ != NULL) {
#line 4576 "dconf-model.c"
			SchemaList* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp26_ = self->schemas;
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp27_ = dir;
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			schema_list_load_directory (_tmp26_, _tmp27_, &_inner_error_);
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_g_free0 (dir);
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
#line 4591 "dconf-model.c"
				goto __catch2_g_error;
			}
		}
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_free0 (dir);
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
#line 4599 "dconf-model.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		e = _inner_error_;
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_inner_error_ = NULL;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp28_ = e;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp29_ = _tmp28_->message;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_warning ("dconf-model.vala:617: Failed to parse schemas: %s", _tmp29_);
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_error_free0 (e);
#line 4619 "dconf-model.c"
	}
	__finally2:
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_clear_error (&_inner_error_);
#line 599 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return NULL;
#line 4630 "dconf-model.c"
	}
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp30_ = self->schemas;
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp31_ = _tmp30_->schemas;
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp32_ = g_hash_table_get_values (_tmp31_);
#line 4638 "dconf-model.c"
	{
		GList* schema_collection = NULL;
		GList* schema_it = NULL;
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		schema_collection = _tmp32_;
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		for (schema_it = schema_collection; schema_it != NULL; schema_it = schema_it->next) {
#line 4646 "dconf-model.c"
			Schema* schema = NULL;
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			schema = (Schema*) schema_it->data;
#line 4650 "dconf-model.c"
			{
				Directory* _tmp33_ = NULL;
				Schema* _tmp34_ = NULL;
				Schema* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				Schema* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp33_ = self->priv->root;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp34_ = schema;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp35_ = schema;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp36_ = _tmp35_->path;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp37_ = schema;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp38_ = _tmp37_->path;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp39_ = strlen (_tmp38_);
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp40_ = _tmp39_;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp41_ = string_slice (_tmp36_, (glong) 1, (glong) _tmp40_);
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp42_ = _tmp41_;
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				directory_load_schema (_tmp33_, _tmp34_, _tmp42_);
#line 622 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_g_free0 (_tmp42_);
#line 4686 "dconf-model.c"
			}
		}
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_list_free0 (schema_collection);
#line 4691 "dconf-model.c"
	}
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return self;
#line 4695 "dconf-model.c"
}


SettingsModel* settings_model_new (void) {
#line 591 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return settings_model_construct (TYPE_SETTINGS_MODEL);
#line 4702 "dconf-model.c"
}


static GtkTreeModelFlags settings_model_real_get_flags (GtkTreeModel* base) {
	SettingsModel * self;
	GtkTreeModelFlags result = 0;
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = 0;
#line 627 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 4715 "dconf-model.c"
}


static gint settings_model_real_get_n_columns (GtkTreeModel* base) {
	SettingsModel * self;
	gint result = 0;
#line 630 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 632 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = 2;
#line 632 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 4728 "dconf-model.c"
}


static GType settings_model_real_get_column_type (GtkTreeModel* base, gint index) {
	SettingsModel * self;
	GType result = 0UL;
	gint _tmp0_ = 0;
#line 635 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 637 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = index;
#line 637 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == 0) {
#line 638 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = TYPE_DIRECTORY;
#line 638 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4746 "dconf-model.c"
	} else {
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = G_TYPE_STRING;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4752 "dconf-model.c"
	}
}


static void settings_model_set_iter (SettingsModel* self, GtkTreeIter* iter, Directory* directory) {
	Directory* _tmp0_ = NULL;
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (self != NULL);
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 643 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (directory != NULL);
#line 645 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).stamp = 0;
#line 646 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = directory;
#line 646 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data = _tmp0_;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = directory;
#line 647 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data2 = _tmp1_;
#line 648 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = directory;
#line 648 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	(*iter).user_data3 = _tmp2_;
#line 4781 "dconf-model.c"
}


Directory* settings_model_get_directory (SettingsModel* self, GtkTreeIter* iter) {
	Directory* result = NULL;
	GtkTreeIter* _tmp0_ = NULL;
#line 651 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 653 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = iter;
#line 653 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == NULL) {
#line 4794 "dconf-model.c"
		Directory* _tmp1_ = NULL;
		Directory* _tmp2_ = NULL;
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = self->priv->root;
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = _tmp2_;
#line 654 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4805 "dconf-model.c"
	} else {
		GtkTreeIter* _tmp3_ = NULL;
		void* _tmp4_ = NULL;
		Directory* _tmp5_ = NULL;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp3_ = iter;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = (*_tmp3_).user_data;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_DIRECTORY, Directory));
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = _tmp5_;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4820 "dconf-model.c"
	}
}


static gboolean settings_model_real_get_iter (GtkTreeModel* base, GtkTreeIter* iter, GtkTreePath* path) {
	SettingsModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTreePath* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
#line 659 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 659 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 661 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = path;
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = gtk_tree_path_get_indices_with_depth (_tmp0_, &_tmp1_);
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _tmp2_[0];
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, &_tmp4_, NULL, _tmp3_);
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_vala_iter = _tmp4_;
#line 663 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (!_tmp5_) {
#line 664 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 664 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 664 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 4859 "dconf-model.c"
		}
#line 664 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 4863 "dconf-model.c"
	}
	{
		gint i = 0;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		i = 1;
#line 4869 "dconf-model.c"
		{
			gboolean _tmp6_ = FALSE;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp6_ = TRUE;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			while (TRUE) {
#line 4876 "dconf-model.c"
				gint _tmp8_ = 0;
				GtkTreePath* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				GtkTreeIter parent = {0};
				GtkTreeIter _tmp11_ = {0};
				GtkTreeIter _tmp12_ = {0};
				GtkTreePath* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gint* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				GtkTreeIter _tmp18_ = {0};
				gboolean _tmp19_ = FALSE;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (!_tmp6_) {
#line 4892 "dconf-model.c"
					gint _tmp7_ = 0;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp7_ = i;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					i = _tmp7_ + 1;
#line 4898 "dconf-model.c"
				}
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp6_ = FALSE;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp8_ = i;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp9_ = path;
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp10_ = gtk_tree_path_get_depth (_tmp9_);
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (!(_tmp8_ < _tmp10_)) {
#line 666 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					break;
#line 4912 "dconf-model.c"
				}
#line 668 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp11_ = _vala_iter;
#line 668 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				parent = _tmp11_;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp12_ = parent;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp13_ = path;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp15_ = gtk_tree_path_get_indices_with_depth (_tmp13_, &_tmp14_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp16_ = i;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp17_ = _tmp15_[_tmp16_];
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp19_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) self, &_tmp18_, &_tmp12_, _tmp17_);
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_vala_iter = _tmp18_;
#line 669 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (!_tmp19_) {
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					result = FALSE;
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					if (iter) {
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
						*iter = _vala_iter;
#line 4940 "dconf-model.c"
					}
#line 670 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					return result;
#line 4944 "dconf-model.c"
				}
			}
		}
	}
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 4955 "dconf-model.c"
	}
#line 673 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 4959 "dconf-model.c"
}


static GtkTreePath* settings_model_real_get_path (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	GtkTreePath* result = NULL;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_ = NULL;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 676 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 678 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = gtk_tree_path_new ();
#line 678 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	path = _tmp0_;
#line 4976 "dconf-model.c"
	{
		Directory* d = NULL;
		GtkTreeIter _tmp1_ = {0};
		Directory* _tmp2_ = NULL;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = *iter;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = settings_model_get_directory (self, &_tmp1_);
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		d = _tmp2_;
#line 4987 "dconf-model.c"
		{
			gboolean _tmp3_ = FALSE;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			_tmp3_ = TRUE;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			while (TRUE) {
#line 4994 "dconf-model.c"
				Directory* _tmp7_ = NULL;
				Directory* _tmp8_ = NULL;
				GtkTreePath* _tmp9_ = NULL;
				Directory* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (!_tmp3_) {
#line 5003 "dconf-model.c"
					Directory* _tmp4_ = NULL;
					Directory* _tmp5_ = NULL;
					Directory* _tmp6_ = NULL;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp4_ = d;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp5_ = _tmp4_->parent;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_tmp6_ = _g_object_ref0 (_tmp5_);
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					_g_object_unref0 (d);
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					d = _tmp6_;
#line 5017 "dconf-model.c"
				}
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp3_ = FALSE;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp7_ = d;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp8_ = self->priv->root;
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				if (!(_tmp7_ != _tmp8_)) {
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
					break;
#line 5029 "dconf-model.c"
				}
#line 680 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp9_ = path;
#line 680 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp10_ = d;
#line 680 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp11_ = directory_get_index (_tmp10_);
#line 680 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				_tmp12_ = _tmp11_;
#line 680 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
				gtk_tree_path_prepend_index (_tmp9_, (gint) _tmp12_);
#line 5041 "dconf-model.c"
			}
		}
#line 679 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (d);
#line 5046 "dconf-model.c"
	}
#line 681 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = path;
#line 681 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 5052 "dconf-model.c"
}


static void settings_model_real_get_value (GtkTreeModel* base, GtkTreeIter* iter, gint column, GValue* value) {
	SettingsModel * self;
	GValue _vala_value = {0};
	gint _tmp0_ = 0;
#line 684 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 684 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 686 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = column;
#line 686 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp0_ == 0) {
#line 5068 "dconf-model.c"
		GtkTreeIter _tmp1_ = {0};
		Directory* _tmp2_ = NULL;
		GValue _tmp3_ = {0};
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp1_ = *iter;
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp2_ = settings_model_get_directory (self, &_tmp1_);
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_init (&_tmp3_, TYPE_DIRECTORY);
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_take_object (&_tmp3_, _tmp2_);
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 687 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_vala_value = _tmp3_;
#line 5084 "dconf-model.c"
	} else {
		GtkTreeIter _tmp4_ = {0};
		Directory* _tmp5_ = NULL;
		Directory* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		GValue _tmp8_ = {0};
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp4_ = *iter;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp5_ = settings_model_get_directory (self, &_tmp4_);
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp6_ = _tmp5_;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_tmp7_ = _tmp6_->name;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_init (&_tmp8_, G_TYPE_STRING);
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		g_value_set_string (&_tmp8_, _tmp7_);
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_vala_value = _tmp8_;
#line 689 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (_tmp6_);
#line 5109 "dconf-model.c"
	}
#line 684 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (value) {
#line 684 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*value = _vala_value;
#line 5115 "dconf-model.c"
	} else {
#line 684 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		G_IS_VALUE (&_vala_value) ? (g_value_unset (&_vala_value), NULL) : NULL;
#line 5119 "dconf-model.c"
	}
}


static gboolean settings_model_real_iter_next (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	gboolean result = FALSE;
	Directory* directory = NULL;
	GtkTreeIter _tmp0_ = {0};
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Directory* _tmp5_ = NULL;
	Directory* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	Directory* _tmp10_ = NULL;
	Directory* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	Directory* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gconstpointer _tmp17_ = NULL;
#line 692 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 692 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 694 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 694 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = settings_model_get_directory (self, &_tmp0_);
#line 694 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory = _tmp1_;
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = directory;
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = directory_get_index (_tmp2_);
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_;
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = directory;
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = _tmp5_->parent;
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = directory_get_children (_tmp6_);
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = _tmp7_;
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp9_ = g_list_length (_tmp8_);
#line 695 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (((guint) _tmp4_) >= (_tmp9_ - 1)) {
#line 696 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 696 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (directory);
#line 696 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 5180 "dconf-model.c"
	}
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp10_ = directory;
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp11_ = _tmp10_->parent;
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp12_ = directory_get_children (_tmp11_);
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp13_ = _tmp12_;
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp14_ = directory;
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp15_ = directory_get_index (_tmp14_);
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp16_ = _tmp15_;
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp17_ = g_list_nth_data (_tmp13_, (guint) (_tmp16_ + 1));
#line 697 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	settings_model_set_iter (self, iter, (Directory*) _tmp17_);
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (directory);
#line 699 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 5206 "dconf-model.c"
}


static gboolean settings_model_real_iter_children (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent) {
	SettingsModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	Directory* directory = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	Directory* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	gconstpointer _tmp9_ = NULL;
#line 702 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 704 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = parent;
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = settings_model_get_directory (self, _tmp0_);
#line 706 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory = _tmp1_;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = directory;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = directory_get_children (_tmp2_);
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_;
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = g_list_length (_tmp4_);
#line 707 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp5_ == ((guint) 0)) {
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (directory);
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 5253 "dconf-model.c"
		}
#line 708 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 5257 "dconf-model.c"
	}
#line 709 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = directory;
#line 709 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = directory_get_children (_tmp6_);
#line 709 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = _tmp7_;
#line 709 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp9_ = g_list_nth_data (_tmp8_, (guint) 0);
#line 709 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	settings_model_set_iter (self, &_vala_iter, (Directory*) _tmp9_);
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (directory);
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 5277 "dconf-model.c"
	}
#line 711 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 5281 "dconf-model.c"
}


static gboolean settings_model_real_iter_has_child (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	gboolean result = FALSE;
	GtkTreeIter _tmp0_ = {0};
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	gboolean _tmp6_ = FALSE;
#line 714 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 714 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = settings_model_get_directory (self, &_tmp0_);
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = directory_get_children (_tmp2_);
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_;
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = g_list_length (_tmp4_);
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = _tmp5_ > ((guint) 0);
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp6_;
#line 716 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 5319 "dconf-model.c"
}


static gint settings_model_real_iter_n_children (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	gint result = 0;
	GtkTreeIter* _tmp0_ = NULL;
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	gint _tmp6_ = 0;
#line 719 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = iter;
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = settings_model_get_directory (self, _tmp0_);
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = directory_get_children (_tmp2_);
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = _tmp3_;
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = g_list_length (_tmp4_);
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = (gint) _tmp5_;
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = _tmp6_;
#line 721 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 5355 "dconf-model.c"
}


static gboolean settings_model_real_iter_nth_child (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* parent, gint n) {
	SettingsModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	Directory* directory = NULL;
	GtkTreeIter* _tmp0_ = NULL;
	Directory* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Directory* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	Directory* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gconstpointer _tmp11_ = NULL;
#line 724 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 726 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = parent;
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = settings_model_get_directory (self, _tmp0_);
#line 728 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory = _tmp1_;
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = n;
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = directory;
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = directory_get_children (_tmp3_);
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = _tmp4_;
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = g_list_length (_tmp5_);
#line 729 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (((guint) _tmp2_) >= _tmp6_) {
#line 730 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 730 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (directory);
#line 730 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 730 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 5406 "dconf-model.c"
		}
#line 730 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 5410 "dconf-model.c"
	}
#line 731 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp7_ = directory;
#line 731 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp8_ = directory_get_children (_tmp7_);
#line 731 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp9_ = _tmp8_;
#line 731 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp10_ = n;
#line 731 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp11_ = g_list_nth_data (_tmp9_, (guint) _tmp10_);
#line 731 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	settings_model_set_iter (self, &_vala_iter, (Directory*) _tmp11_);
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (directory);
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 5432 "dconf-model.c"
	}
#line 733 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 5436 "dconf-model.c"
}


static gboolean settings_model_real_iter_parent (GtkTreeModel* base, GtkTreeIter* iter, GtkTreeIter* child) {
	SettingsModel * self;
	GtkTreeIter _vala_iter = {0};
	gboolean result = FALSE;
	Directory* directory = NULL;
	GtkTreeIter _tmp0_ = {0};
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
	Directory* _tmp3_ = NULL;
	Directory* _tmp4_ = NULL;
	Directory* _tmp5_ = NULL;
	Directory* _tmp6_ = NULL;
#line 736 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 736 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_val_if_fail (child != NULL, FALSE);
#line 738 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	memset (&_vala_iter, 0, sizeof (GtkTreeIter));
#line 740 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *child;
#line 740 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = settings_model_get_directory (self, &_tmp0_);
#line 740 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	directory = _tmp1_;
#line 741 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = directory;
#line 741 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp3_ = _tmp2_->parent;
#line 741 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp4_ = self->priv->root;
#line 741 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (_tmp3_ == _tmp4_) {
#line 742 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		result = FALSE;
#line 742 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		_g_object_unref0 (directory);
#line 742 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		if (iter) {
#line 742 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
			*iter = _vala_iter;
#line 5480 "dconf-model.c"
		}
#line 742 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		return result;
#line 5484 "dconf-model.c"
	}
#line 744 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp5_ = directory;
#line 744 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp6_ = _tmp5_->parent;
#line 744 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	settings_model_set_iter (self, &_vala_iter, _tmp6_);
#line 746 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	result = TRUE;
#line 746 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (directory);
#line 746 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	if (iter) {
#line 746 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
		*iter = _vala_iter;
#line 5500 "dconf-model.c"
	}
#line 746 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	return result;
#line 5504 "dconf-model.c"
}


static void settings_model_real_ref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	GtkTreeIter _tmp0_ = {0};
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
#line 749 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 749 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 751 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 751 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = settings_model_get_directory (self, &_tmp0_);
#line 751 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 751 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_ref ((GObject*) _tmp2_);
#line 751 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 5527 "dconf-model.c"
}


static void settings_model_real_unref_node (GtkTreeModel* base, GtkTreeIter* iter) {
	SettingsModel * self;
	GtkTreeIter _tmp0_ = {0};
	Directory* _tmp1_ = NULL;
	Directory* _tmp2_ = NULL;
#line 754 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = (SettingsModel*) base;
#line 754 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_return_if_fail (iter != NULL);
#line 756 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp0_ = *iter;
#line 756 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp1_ = settings_model_get_directory (self, &_tmp0_);
#line 756 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_tmp2_ = _tmp1_;
#line 756 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_object_unref ((GObject*) _tmp2_);
#line 756 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (_tmp2_);
#line 5550 "dconf-model.c"
}


static void settings_model_class_init (SettingsModelClass * klass) {
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	settings_model_parent_class = g_type_class_peek_parent (klass);
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_type_class_add_private (klass, sizeof (SettingsModelPrivate));
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (klass)->finalize = settings_model_finalize;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	g_signal_new ("item_changed", TYPE_SETTINGS_MODEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 5563 "dconf-model.c"
}


static void settings_model_gtk_tree_model_interface_init (GtkTreeModelIface * iface) {
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	settings_model_gtk_tree_model_parent_iface = g_type_interface_peek_parent (iface);
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_flags = (GtkTreeModelFlags (*)(GtkTreeModel*)) settings_model_real_get_flags;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_n_columns = (gint (*)(GtkTreeModel*)) settings_model_real_get_n_columns;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_column_type = (GType (*)(GtkTreeModel*, gint)) settings_model_real_get_column_type;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_iter = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreePath*)) settings_model_real_get_iter;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_path = (GtkTreePath* (*)(GtkTreeModel*, GtkTreeIter*)) settings_model_real_get_path;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->get_value = (void (*)(GtkTreeModel*, GtkTreeIter*, gint, GValue*)) settings_model_real_get_value;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_next = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) settings_model_real_iter_next;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_children = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) settings_model_real_iter_children;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_has_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*)) settings_model_real_iter_has_child;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_n_children = (gint (*)(GtkTreeModel*, GtkTreeIter*)) settings_model_real_iter_n_children;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_nth_child = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*, gint)) settings_model_real_iter_nth_child;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->iter_parent = (gboolean (*)(GtkTreeModel*, GtkTreeIter*, GtkTreeIter*)) settings_model_real_iter_parent;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->ref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) settings_model_real_ref_node;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	iface->unref_node = (void (*)(GtkTreeModel*, GtkTreeIter*)) settings_model_real_unref_node;
#line 5598 "dconf-model.c"
}


static void settings_model_instance_init (SettingsModel * self) {
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self->priv = SETTINGS_MODEL_GET_PRIVATE (self);
#line 5605 "dconf-model.c"
}


static void settings_model_finalize (GObject* obj) {
	SettingsModel * self;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SETTINGS_MODEL, SettingsModel);
#line 578 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_schema_list_unref0 (self->schemas);
#line 580 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->client);
#line 581 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	_g_object_unref0 (self->priv->root);
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/dconf-editor/editor/dconf-model.vala"
	G_OBJECT_CLASS (settings_model_parent_class)->finalize (obj);
#line 5621 "dconf-model.c"
}


GType settings_model_get_type (void) {
	static volatile gsize settings_model_type_id__volatile = 0;
	if (g_once_init_enter (&settings_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SettingsModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) settings_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SettingsModel), 0, (GInstanceInitFunc) settings_model_instance_init, NULL };
		static const GInterfaceInfo gtk_tree_model_info = { (GInterfaceInitFunc) settings_model_gtk_tree_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType settings_model_type_id;
		settings_model_type_id = g_type_register_static (G_TYPE_OBJECT, "SettingsModel", &g_define_type_info, 0);
		g_type_add_interface_static (settings_model_type_id, GTK_TYPE_TREE_MODEL, &gtk_tree_model_info);
		g_once_init_leave (&settings_model_type_id__volatile, settings_model_type_id);
	}
	return settings_model_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



