/*
 *  Copyright © 2000, 2003 Marco Pesenti Gritti
 *  Copyright © 2003, 2004 Christian Persch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined (__EPHY_EPIPHANY_H_INSIDE__) && !defined (EPIPHANY_COMPILATION)
#error "Only <epiphany/epiphany.h> can be included directly."
#endif

#ifndef EPHY_LANGS_H
#define EPHY_LANGS_H

#include <glib.h>

G_BEGIN_DECLS

#define ISO_639_DOMAIN	"iso_639"
#define ISO_3166_DOMAIN	"iso_3166"

void			     ephy_langs_append_languages (GArray *array);

void			     ephy_langs_sanitise	 (GArray *array);

char			   **ephy_langs_get_languages	 (void);

GHashTable		    *ephy_langs_iso_639_table	 (void);

GHashTable		    *ephy_langs_iso_3166_table   (void);

G_END_DECLS

#endif
