/* timer.c generated by valac 0.30.0.15-6463e, the Vala compiler
 * generated from timer.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define CLOCKS_TYPE_ANALOG_FRAME (clocks_analog_frame_get_type ())
#define CLOCKS_ANALOG_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrame))
#define CLOCKS_ANALOG_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrameClass))
#define CLOCKS_IS_ANALOG_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_ANALOG_FRAME))
#define CLOCKS_IS_ANALOG_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_ANALOG_FRAME))
#define CLOCKS_ANALOG_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrameClass))

typedef struct _ClocksAnalogFrame ClocksAnalogFrame;
typedef struct _ClocksAnalogFrameClass ClocksAnalogFrameClass;
typedef struct _ClocksAnalogFramePrivate ClocksAnalogFramePrivate;

#define CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME (clocks_timer_countdown_frame_get_type ())
#define CLOCKS_TIMER_COUNTDOWN_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrame))
#define CLOCKS_TIMER_COUNTDOWN_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrameClass))
#define CLOCKS_TIMER_IS_COUNTDOWN_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME))
#define CLOCKS_TIMER_IS_COUNTDOWN_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME))
#define CLOCKS_TIMER_COUNTDOWN_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrameClass))

typedef struct _ClocksTimerCountdownFrame ClocksTimerCountdownFrame;
typedef struct _ClocksTimerCountdownFrameClass ClocksTimerCountdownFrameClass;
typedef struct _ClocksTimerCountdownFramePrivate ClocksTimerCountdownFramePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())

#define CLOCKS_TIMER_TYPE_FACE (clocks_timer_face_get_type ())
#define CLOCKS_TIMER_FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace))
#define CLOCKS_TIMER_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))
#define CLOCKS_TIMER_IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_FACE))
#define CLOCKS_TIMER_FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFaceClass))

typedef struct _ClocksTimerFace ClocksTimerFace;
typedef struct _ClocksTimerFaceClass ClocksTimerFaceClass;
typedef struct _ClocksTimerFacePrivate ClocksTimerFacePrivate;

#define CLOCKS_TIMER_FACE_TYPE_STATE (clocks_timer_face_state_get_type ())

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _ClocksAnalogFrame {
	GtkFrame parent_instance;
	ClocksAnalogFramePrivate * priv;
};

struct _ClocksAnalogFrameClass {
	GtkFrameClass parent_class;
	void (*draw_progress) (ClocksAnalogFrame* self, cairo_t* cr, gint center_x, gint center_y, gint radius);
};

struct _ClocksTimerCountdownFrame {
	ClocksAnalogFrame parent_instance;
	ClocksTimerCountdownFramePrivate * priv;
};

struct _ClocksTimerCountdownFrameClass {
	ClocksAnalogFrameClass parent_class;
};

struct _ClocksTimerCountdownFramePrivate {
	gdouble _span;
	gdouble elapsed;
	gdouble elapsed_before_pause;
};

typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	void (*update_header_bar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksHeaderBar* (*get_header_bar) (ClocksClock* self);
	void (*set_header_bar) (ClocksClock* self, ClocksHeaderBar* value);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
};

struct _ClocksTimerFace {
	GtkStack parent_instance;
	ClocksTimerFacePrivate * priv;
};

struct _ClocksTimerFaceClass {
	GtkStackClass parent_class;
	void (*ring) (ClocksTimerFace* self);
};

typedef enum  {
	CLOCKS_TIMER_FACE_STATE_STOPPED,
	CLOCKS_TIMER_FACE_STATE_RUNNING,
	CLOCKS_TIMER_FACE_STATE_PAUSED
} ClocksTimerFaceState;

struct _ClocksTimerFacePrivate {
	gchar* _label;
	ClocksHeaderBar* _header_bar;
	ClocksPanelId _panel_id;
	ClocksTimerFaceState _state;
	GSettings* settings;
	guint tick_id;
	gdouble span;
	GTimer* timer;
	ClocksUtilsBell* bell;
	GNotification* notification;
	ClocksAnalogFrame* setup_frame;
	GtkGrid* grid_spinbuttons;
	GtkSpinButton* h_spinbutton;
	GtkSpinButton* m_spinbutton;
	GtkSpinButton* s_spinbutton;
	GtkButton* start_button;
	ClocksTimerCountdownFrame* countdown_frame;
	GtkSpinButton* h_label;
	GtkSpinButton* m_label;
	GtkSpinButton* s_label;
	GtkButton* left_button;
};


static gpointer clocks_timer_countdown_frame_parent_class = NULL;
static gpointer clocks_timer_face_parent_class = NULL;
static ClocksClockIface* clocks_timer_face_clocks_clock_parent_iface = NULL;

GType clocks_analog_frame_get_type (void) G_GNUC_CONST;
GType clocks_timer_countdown_frame_get_type (void) G_GNUC_CONST;
#define CLOCKS_TIMER_COUNTDOWN_FRAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFramePrivate))
enum  {
	CLOCKS_TIMER_COUNTDOWN_FRAME_DUMMY_PROPERTY,
	CLOCKS_TIMER_COUNTDOWN_FRAME_SPAN
};
static gdouble clocks_timer_countdown_frame_get_progress (ClocksTimerCountdownFrame* self);
gdouble clocks_timer_countdown_frame_get_span (ClocksTimerCountdownFrame* self);
void clocks_timer_countdown_frame_update (ClocksTimerCountdownFrame* self, gdouble e);
void clocks_timer_countdown_frame_pause (ClocksTimerCountdownFrame* self);
void clocks_timer_countdown_frame_reset (ClocksTimerCountdownFrame* self);
static void clocks_timer_countdown_frame_real_draw_progress (ClocksAnalogFrame* base, cairo_t* cr, gint center_x, gint center_y, gint radius);
#define CLOCKS_ANALOG_FRAME_LINE_WIDTH 6
ClocksTimerCountdownFrame* clocks_timer_countdown_frame_new (void);
ClocksTimerCountdownFrame* clocks_timer_countdown_frame_construct (GType object_type);
ClocksAnalogFrame* clocks_analog_frame_new (void);
ClocksAnalogFrame* clocks_analog_frame_construct (GType object_type);
void clocks_timer_countdown_frame_set_span (ClocksTimerCountdownFrame* self, gdouble value);
static void clocks_timer_countdown_frame_finalize (GObject* obj);
static void _vala_clocks_timer_countdown_frame_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_timer_countdown_frame_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_header_bar_get_type (void) G_GNUC_CONST;
GType clocks_panel_id_get_type (void) G_GNUC_CONST;
GType clocks_clock_get_type (void) G_GNUC_CONST;
GType clocks_timer_face_get_type (void) G_GNUC_CONST;
GType clocks_timer_face_state_get_type (void) G_GNUC_CONST;
GType clocks_utils_bell_get_type (void) G_GNUC_CONST;
#define CLOCKS_TIMER_FACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TIMER_TYPE_FACE, ClocksTimerFacePrivate))
enum  {
	CLOCKS_TIMER_FACE_DUMMY_PROPERTY,
	CLOCKS_TIMER_FACE_LABEL,
	CLOCKS_TIMER_FACE_HEADER_BAR,
	CLOCKS_TIMER_FACE_PANEL_ID,
	CLOCKS_TIMER_FACE_STATE
};
ClocksTimerFace* clocks_timer_face_new (ClocksHeaderBar* header_bar);
ClocksTimerFace* clocks_timer_face_construct (GType object_type, ClocksHeaderBar* header_bar);
ClocksUtilsBell* clocks_utils_bell_new (const gchar* soundid);
ClocksUtilsBell* clocks_utils_bell_construct (GType object_type, const gchar* soundid);
static void clocks_timer_face_reset (ClocksTimerFace* self);
static gboolean clocks_timer_face_show_leading_zeros (ClocksTimerFace* self, GtkSpinButton* spin_button);
static gboolean _clocks_timer_face_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender, gpointer self);
static gint clocks_timer_face_input_minutes (ClocksTimerFace* self, GtkSpinButton* spin_button, gdouble* new_value);
static gint _clocks_timer_face_input_minutes_gtk_spin_button_input (GtkSpinButton* _sender, gdouble* new_value, gpointer self);
static gint clocks_timer_face_input_seconds (ClocksTimerFace* self, GtkSpinButton* spin_button, gdouble* new_value);
static gint _clocks_timer_face_input_seconds_gtk_spin_button_input (GtkSpinButton* _sender, gdouble* new_value, gpointer self);
static void clocks_timer_face_update_start_button (ClocksTimerFace* self);
static void _clocks_timer_face_update_start_button_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void clocks_timer_face_on_start_button_clicked (ClocksTimerFace* self);
static void clocks_timer_face_start (ClocksTimerFace* self);
static void _clocks_timer_face_on_start_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_timer_face_on_left_button_clicked (ClocksTimerFace* self);
ClocksTimerFaceState clocks_timer_face_get_state (ClocksTimerFace* self);
static void clocks_timer_face_pause (ClocksTimerFace* self);
static void _clocks_timer_face_on_left_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_timer_face_on_right_button_clicked (ClocksTimerFace* self);
static void _clocks_timer_face_on_right_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_timer_face_set_state (ClocksTimerFace* self, ClocksTimerFaceState value);
static void clocks_timer_face_remove_tick (ClocksTimerFace* self);
static void clocks_timer_face_update_countdown_label (ClocksTimerFace* self, gint h, gint m, gint s);
static void clocks_timer_face_add_tick (ClocksTimerFace* self);
static gboolean ___lambda41_ (ClocksTimerFace* self, GtkWidget* c);
static gboolean clocks_timer_face_count (ClocksTimerFace* self);
static gboolean ____lambda41__gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static void clocks_timer_face_update_countdown (ClocksTimerFace* self, gdouble elapsed);
void clocks_utils_time_to_hms (gdouble t, gint* h, gint* m, gint* s, gdouble* remainder);
static void clocks_timer_face_real_grab_focus (GtkWidget* base);
static gboolean clocks_timer_face_real_escape_pressed (ClocksClock* base);
static void clocks_timer_face_real_ring (ClocksTimerFace* self);
void clocks_utils_bell_ring_once (ClocksUtilsBell* self);
static void clocks_timer_face_finalize (GObject* obj);
const gchar* clocks_clock_get_label (ClocksClock* self);
ClocksHeaderBar* clocks_clock_get_header_bar (ClocksClock* self);
ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
static void _vala_clocks_timer_face_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_clock_set_label (ClocksClock* self, const gchar* value);
void clocks_clock_set_header_bar (ClocksClock* self, ClocksHeaderBar* value);
void clocks_clock_set_panel_id (ClocksClock* self, ClocksPanelId value);
static void _vala_clocks_timer_face_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gdouble clocks_timer_countdown_frame_get_progress (ClocksTimerCountdownFrame* self) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->_span;
	if (_tmp1_ != ((gdouble) 0)) {
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp2_ = self->priv->elapsed_before_pause;
		_tmp3_ = self->priv->elapsed;
		_tmp4_ = self->priv->_span;
		_tmp0_ = (_tmp2_ + _tmp3_) / _tmp4_;
	} else {
		_tmp0_ = (gdouble) 0;
	}
	result = _tmp0_;
	return result;
}


void clocks_timer_countdown_frame_update (ClocksTimerCountdownFrame* self, gdouble e) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = e;
	self->priv->elapsed = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void clocks_timer_countdown_frame_pause (ClocksTimerCountdownFrame* self) {
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->elapsed_before_pause;
	_tmp1_ = self->priv->elapsed;
	self->priv->elapsed_before_pause = _tmp0_ + _tmp1_;
	self->priv->elapsed = (gdouble) 0;
}


void clocks_timer_countdown_frame_reset (ClocksTimerCountdownFrame* self) {
	g_return_if_fail (self != NULL);
	self->priv->elapsed_before_pause = (gdouble) 0;
	self->priv->elapsed = (gdouble) 0;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void clocks_timer_countdown_frame_real_draw_progress (ClocksAnalogFrame* base, cairo_t* cr, gint center_x, gint center_y, gint radius) {
	ClocksTimerCountdownFrame * self;
	gdouble progress = 0.0;
	gdouble _tmp0_ = 0.0;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	GdkRGBA color = {0};
	GtkStateFlags _tmp3_ = 0;
	GdkRGBA _tmp4_ = {0};
	cairo_t* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	cairo_t* _tmp9_ = NULL;
	GdkRGBA _tmp10_ = {0};
	cairo_t* _tmp11_ = NULL;
	cairo_t* _tmp12_ = NULL;
	cairo_t* _tmp13_ = NULL;
	self = (ClocksTimerCountdownFrame*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = clocks_timer_countdown_frame_get_progress (self);
	progress = _tmp0_;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	gtk_style_context_save (context);
	gtk_style_context_add_class (context, "progress");
	_tmp3_ = gtk_style_context_get_state (context);
	gtk_style_context_get_color (context, _tmp3_, &_tmp4_);
	color = _tmp4_;
	_tmp5_ = cr;
	_tmp6_ = center_x;
	_tmp7_ = center_y;
	_tmp8_ = radius;
	cairo_arc (_tmp5_, (gdouble) _tmp6_, (gdouble) _tmp7_, (gdouble) (_tmp8_ - (CLOCKS_ANALOG_FRAME_LINE_WIDTH / 2)), 1.5 * G_PI, (1.5 + ((1 - progress) * 2)) * G_PI);
	_tmp9_ = cr;
	_tmp10_ = color;
	gdk_cairo_set_source_rgba (_tmp9_, &_tmp10_);
	_tmp11_ = cr;
	cairo_set_line_width (_tmp11_, (gdouble) CLOCKS_ANALOG_FRAME_LINE_WIDTH);
	_tmp12_ = cr;
	cairo_set_line_cap (_tmp12_, CAIRO_LINE_CAP_ROUND);
	_tmp13_ = cr;
	cairo_stroke (_tmp13_);
	gtk_style_context_restore (context);
	_g_object_unref0 (context);
}


ClocksTimerCountdownFrame* clocks_timer_countdown_frame_construct (GType object_type) {
	ClocksTimerCountdownFrame * self = NULL;
	self = (ClocksTimerCountdownFrame*) clocks_analog_frame_construct (object_type);
	return self;
}


ClocksTimerCountdownFrame* clocks_timer_countdown_frame_new (void) {
	return clocks_timer_countdown_frame_construct (CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME);
}


gdouble clocks_timer_countdown_frame_get_span (ClocksTimerCountdownFrame* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_span;
	result = _tmp0_;
	return result;
}


void clocks_timer_countdown_frame_set_span (ClocksTimerCountdownFrame* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_span = _tmp0_;
	g_object_notify ((GObject *) self, "span");
}


static void clocks_timer_countdown_frame_class_init (ClocksTimerCountdownFrameClass * klass) {
	clocks_timer_countdown_frame_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksTimerCountdownFramePrivate));
	((ClocksAnalogFrameClass *) klass)->draw_progress = clocks_timer_countdown_frame_real_draw_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_timer_countdown_frame_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_timer_countdown_frame_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_timer_countdown_frame_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_COUNTDOWN_FRAME_SPAN, g_param_spec_double ("span", "span", "span", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_timer_countdown_frame_instance_init (ClocksTimerCountdownFrame * self) {
	self->priv = CLOCKS_TIMER_COUNTDOWN_FRAME_GET_PRIVATE (self);
	self->priv->_span = (gdouble) 0;
}


static void clocks_timer_countdown_frame_finalize (GObject* obj) {
	ClocksTimerCountdownFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrame);
	G_OBJECT_CLASS (clocks_timer_countdown_frame_parent_class)->finalize (obj);
}


GType clocks_timer_countdown_frame_get_type (void) {
	static volatile gsize clocks_timer_countdown_frame_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_timer_countdown_frame_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksTimerCountdownFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_timer_countdown_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksTimerCountdownFrame), 0, (GInstanceInitFunc) clocks_timer_countdown_frame_instance_init, NULL };
		GType clocks_timer_countdown_frame_type_id;
		clocks_timer_countdown_frame_type_id = g_type_register_static (CLOCKS_TYPE_ANALOG_FRAME, "ClocksTimerCountdownFrame", &g_define_type_info, 0);
		g_once_init_leave (&clocks_timer_countdown_frame_type_id__volatile, clocks_timer_countdown_frame_type_id);
	}
	return clocks_timer_countdown_frame_type_id__volatile;
}


static void _vala_clocks_timer_countdown_frame_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksTimerCountdownFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrame);
	switch (property_id) {
		case CLOCKS_TIMER_COUNTDOWN_FRAME_SPAN:
		g_value_set_double (value, clocks_timer_countdown_frame_get_span (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_timer_countdown_frame_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksTimerCountdownFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrame);
	switch (property_id) {
		case CLOCKS_TIMER_COUNTDOWN_FRAME_SPAN:
		clocks_timer_countdown_frame_set_span (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType clocks_timer_face_state_get_type (void) {
	static volatile gsize clocks_timer_face_state_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_timer_face_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_TIMER_FACE_STATE_STOPPED, "CLOCKS_TIMER_FACE_STATE_STOPPED", "stopped"}, {CLOCKS_TIMER_FACE_STATE_RUNNING, "CLOCKS_TIMER_FACE_STATE_RUNNING", "running"}, {CLOCKS_TIMER_FACE_STATE_PAUSED, "CLOCKS_TIMER_FACE_STATE_PAUSED", "paused"}, {0, NULL, NULL}};
		GType clocks_timer_face_state_type_id;
		clocks_timer_face_state_type_id = g_enum_register_static ("ClocksTimerFaceState", values);
		g_once_init_leave (&clocks_timer_face_state_type_id__volatile, clocks_timer_face_state_type_id);
	}
	return clocks_timer_face_state_type_id__volatile;
}


ClocksTimerFace* clocks_timer_face_construct (GType object_type, ClocksHeaderBar* header_bar) {
	ClocksTimerFace * self = NULL;
	const gchar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GTimer* _tmp3_ = NULL;
	ClocksUtilsBell* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GNotification* _tmp6_ = NULL;
	GNotification* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	g_return_val_if_fail (header_bar != NULL, NULL);
	_tmp0_ = _ ("Timer");
	_tmp1_ = header_bar;
	self = (ClocksTimerFace*) g_object_new (object_type, "label", _tmp0_, "header-bar", _tmp1_, "panel-id", CLOCKS_PANEL_ID_TIMER, "transition-type", GTK_STACK_TRANSITION_TYPE_CROSSFADE, NULL);
	_tmp2_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	self->priv->tick_id = (guint) 0;
	self->priv->span = (gdouble) 0;
	_tmp3_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp3_;
	_tmp4_ = clocks_utils_bell_new ("complete");
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp4_;
	_tmp5_ = _ ("Time is up!");
	_tmp6_ = g_notification_new (_tmp5_);
	_g_object_unref0 (self->priv->notification);
	self->priv->notification = _tmp6_;
	_tmp7_ = self->priv->notification;
	_tmp8_ = _ ("Timer countdown finished");
	g_notification_set_body (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->grid_spinbuttons;
	gtk_widget_set_direction ((GtkWidget*) _tmp9_, GTK_TEXT_DIR_LTR);
	clocks_timer_face_reset (self);
	return self;
}


ClocksTimerFace* clocks_timer_face_new (ClocksHeaderBar* header_bar) {
	return clocks_timer_face_construct (CLOCKS_TIMER_TYPE_FACE, header_bar);
}


static gboolean clocks_timer_face_show_leading_zeros (ClocksTimerFace* self, GtkSpinButton* spin_button) {
	gboolean result = FALSE;
	GtkSpinButton* _tmp0_ = NULL;
	GtkSpinButton* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (spin_button != NULL, FALSE);
	_tmp0_ = spin_button;
	_tmp1_ = spin_button;
	_tmp2_ = gtk_spin_button_get_value_as_int (_tmp1_);
	_tmp3_ = g_strdup_printf ("%02i", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	result = TRUE;
	return result;
}


static gboolean _clocks_timer_face_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender, gpointer self) {
	gboolean result;
	result = clocks_timer_face_show_leading_zeros ((ClocksTimerFace*) self, _sender);
	return result;
}


static gint clocks_timer_face_input_minutes (ClocksTimerFace* self, GtkSpinButton* spin_button, gdouble* new_value) {
	gdouble _vala_new_value = 0.0;
	gint result = 0;
	gint entered_value = 0;
	GtkSpinButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp10_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (spin_button != NULL, 0);
	_tmp0_ = spin_button;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = atoi (_tmp1_);
	entered_value = _tmp2_;
	_tmp3_ = entered_value;
	if (_tmp3_ > 59) {
		gint current_hours = 0;
		GtkSpinButton* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		GtkSpinButton* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gdouble _tmp9_ = 0.0;
		_tmp4_ = self->priv->h_spinbutton;
		_tmp5_ = gtk_spin_button_get_value_as_int (_tmp4_);
		current_hours = _tmp5_;
		_tmp6_ = self->priv->h_spinbutton;
		_tmp7_ = current_hours;
		_tmp8_ = entered_value;
		_tmp9_ = MIN ((gdouble) 99, (gdouble) (_tmp7_ + (_tmp8_ / 60)));
		gtk_spin_button_set_value (_tmp6_, _tmp9_);
	}
	_tmp10_ = entered_value;
	_vala_new_value = (gdouble) (_tmp10_ % 60);
	result = 1;
	if (new_value) {
		*new_value = _vala_new_value;
	}
	return result;
}


static gint _clocks_timer_face_input_minutes_gtk_spin_button_input (GtkSpinButton* _sender, gdouble* new_value, gpointer self) {
	gint result;
	result = clocks_timer_face_input_minutes ((ClocksTimerFace*) self, _sender, new_value);
	return result;
}


static gint clocks_timer_face_input_seconds (ClocksTimerFace* self, GtkSpinButton* spin_button, gdouble* new_value) {
	gdouble _vala_new_value = 0.0;
	gint result = 0;
	gint entered_value = 0;
	GtkSpinButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp18_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (spin_button != NULL, 0);
	_tmp0_ = spin_button;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = atoi (_tmp1_);
	entered_value = _tmp2_;
	_tmp3_ = entered_value;
	if (_tmp3_ > 59) {
		gint current_minutes = 0;
		GtkSpinButton* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint new_minutes = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		GtkSpinButton* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		_tmp4_ = self->priv->m_spinbutton;
		_tmp5_ = gtk_spin_button_get_value_as_int (_tmp4_);
		current_minutes = _tmp5_;
		_tmp6_ = current_minutes;
		_tmp7_ = entered_value;
		new_minutes = _tmp6_ + (_tmp7_ / 60);
		_tmp8_ = new_minutes;
		if (_tmp8_ > 59) {
			gint current_hours = 0;
			GtkSpinButton* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			GtkSpinButton* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gdouble _tmp14_ = 0.0;
			gint _tmp15_ = 0;
			_tmp9_ = self->priv->h_spinbutton;
			_tmp10_ = gtk_spin_button_get_value_as_int (_tmp9_);
			current_hours = _tmp10_;
			_tmp11_ = self->priv->h_spinbutton;
			_tmp12_ = current_hours;
			_tmp13_ = new_minutes;
			_tmp14_ = MIN ((gdouble) 99, (gdouble) (_tmp12_ + (_tmp13_ / 60)));
			gtk_spin_button_set_value (_tmp11_, _tmp14_);
			_tmp15_ = new_minutes;
			new_minutes = _tmp15_ % 60;
		}
		_tmp16_ = self->priv->m_spinbutton;
		_tmp17_ = new_minutes;
		gtk_spin_button_set_value (_tmp16_, (gdouble) _tmp17_);
	}
	_tmp18_ = entered_value;
	_vala_new_value = (gdouble) (_tmp18_ % 60);
	result = 1;
	if (new_value) {
		*new_value = _vala_new_value;
	}
	return result;
}


static gint _clocks_timer_face_input_seconds_gtk_spin_button_input (GtkSpinButton* _sender, gdouble* new_value, gpointer self) {
	gint result;
	result = clocks_timer_face_input_seconds ((ClocksTimerFace*) self, _sender, new_value);
	return result;
}


static void clocks_timer_face_update_start_button (ClocksTimerFace* self) {
	gint h = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint m = 0;
	GtkSpinButton* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint s = 0;
	GtkSpinButton* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->h_spinbutton;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	h = _tmp1_;
	_tmp2_ = self->priv->m_spinbutton;
	_tmp3_ = gtk_spin_button_get_value_as_int (_tmp2_);
	m = _tmp3_;
	_tmp4_ = self->priv->s_spinbutton;
	_tmp5_ = gtk_spin_button_get_value_as_int (_tmp4_);
	s = _tmp5_;
	_tmp8_ = h;
	if (_tmp8_ != 0) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp9_ = 0;
		_tmp9_ = m;
		_tmp7_ = _tmp9_ != 0;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp10_ = 0;
		_tmp10_ = s;
		_tmp6_ = _tmp10_ != 0;
	}
	if (_tmp6_) {
		GtkButton* _tmp11_ = NULL;
		GtkButton* _tmp12_ = NULL;
		GtkStyleContext* _tmp13_ = NULL;
		_tmp11_ = self->priv->start_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
		_tmp12_ = self->priv->start_button;
		_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
		gtk_style_context_add_class (_tmp13_, "suggested-action");
	} else {
		GtkButton* _tmp14_ = NULL;
		GtkButton* _tmp15_ = NULL;
		GtkStyleContext* _tmp16_ = NULL;
		_tmp14_ = self->priv->start_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
		_tmp15_ = self->priv->start_button;
		_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
		gtk_style_context_remove_class (_tmp16_, "suggested-action");
	}
}


static void _clocks_timer_face_update_start_button_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	clocks_timer_face_update_start_button ((ClocksTimerFace*) self);
}


static void clocks_timer_face_on_start_button_clicked (ClocksTimerFace* self) {
	g_return_if_fail (self != NULL);
	clocks_timer_face_start (self);
}


static void _clocks_timer_face_on_start_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	clocks_timer_face_on_start_button_clicked ((ClocksTimerFace*) self);
}


static void clocks_timer_face_on_left_button_clicked (ClocksTimerFace* self) {
	ClocksTimerFaceState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_state;
	switch (_tmp0_) {
		case CLOCKS_TIMER_FACE_STATE_RUNNING:
		{
			GtkButton* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			GtkButton* _tmp3_ = NULL;
			GtkStyleContext* _tmp4_ = NULL;
			clocks_timer_face_pause (self);
			_tmp1_ = self->priv->left_button;
			_tmp2_ = _ ("Continue");
			gtk_button_set_label (_tmp1_, _tmp2_);
			_tmp3_ = self->priv->left_button;
			_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
			gtk_style_context_add_class (_tmp4_, "suggested-action");
			break;
		}
		case CLOCKS_TIMER_FACE_STATE_PAUSED:
		{
			GtkButton* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			GtkButton* _tmp7_ = NULL;
			GtkStyleContext* _tmp8_ = NULL;
			clocks_timer_face_start (self);
			_tmp5_ = self->priv->left_button;
			_tmp6_ = _ ("Pause");
			gtk_button_set_label (_tmp5_, _tmp6_);
			_tmp7_ = self->priv->left_button;
			_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
			gtk_style_context_remove_class (_tmp8_, "suggested-action");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void _clocks_timer_face_on_left_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	clocks_timer_face_on_left_button_clicked ((ClocksTimerFace*) self);
}


static void clocks_timer_face_on_right_button_clicked (ClocksTimerFace* self) {
	GtkButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	clocks_timer_face_reset (self);
	_tmp0_ = self->priv->left_button;
	_tmp1_ = _ ("Pause");
	gtk_button_set_label (_tmp0_, _tmp1_);
}


static void _clocks_timer_face_on_right_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	clocks_timer_face_on_right_button_clicked ((ClocksTimerFace*) self);
}


static void clocks_timer_face_reset (ClocksTimerFace* self) {
	GTimer* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkSpinButton* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	GtkSpinButton* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	GtkSpinButton* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GtkButton* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	ClocksTimerCountdownFrame* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	ClocksTimerCountdownFrame* _tmp15_ = NULL;
	ClocksAnalogFrame* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	clocks_timer_face_set_state (self, CLOCKS_TIMER_FACE_STATE_STOPPED);
	_tmp0_ = self->priv->timer;
	g_timer_reset (_tmp0_);
	clocks_timer_face_remove_tick (self);
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_uint (_tmp1_, "timer");
	self->priv->span = (gdouble) _tmp2_;
	_tmp3_ = self->priv->h_spinbutton;
	_tmp4_ = self->priv->span;
	gtk_spin_button_set_value (_tmp3_, (gdouble) (((gint) _tmp4_) / 3600));
	_tmp5_ = self->priv->m_spinbutton;
	_tmp6_ = self->priv->span;
	gtk_spin_button_set_value (_tmp5_, (gdouble) (((gint) _tmp6_) / 60));
	_tmp7_ = self->priv->s_spinbutton;
	_tmp8_ = self->priv->span;
	gtk_spin_button_set_value (_tmp7_, fmod (_tmp8_, 60));
	_tmp9_ = self->priv->left_button;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_remove_class (_tmp10_, "clocks-go");
	_tmp11_ = self->priv->countdown_frame;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
	gtk_style_context_remove_class (_tmp12_, "clocks-paused");
	_tmp13_ = self->priv->start_button;
	_tmp14_ = self->priv->span;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, _tmp14_ > ((gdouble) 0));
	_tmp15_ = self->priv->countdown_frame;
	clocks_timer_countdown_frame_reset (_tmp15_);
	_tmp16_ = self->priv->setup_frame;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp16_);
}


static void clocks_timer_face_start (ClocksTimerFace* self) {
	ClocksTimerCountdownFrame* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ClocksTimerFaceState _tmp3_ = 0;
	GTimer* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->countdown_frame;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "clocks-paused");
	_tmp3_ = self->priv->_state;
	if (_tmp3_ == CLOCKS_TIMER_FACE_STATE_STOPPED) {
		guint _tmp4_ = 0U;
		_tmp4_ = self->priv->tick_id;
		_tmp2_ = _tmp4_ == ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint h = 0;
		GtkSpinButton* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint m = 0;
		GtkSpinButton* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint s = 0;
		GtkSpinButton* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GSettings* _tmp14_ = NULL;
		gdouble _tmp15_ = 0.0;
		ClocksTimerCountdownFrame* _tmp16_ = NULL;
		gdouble _tmp17_ = 0.0;
		ClocksTimerCountdownFrame* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp5_ = self->priv->h_spinbutton;
		_tmp6_ = gtk_spin_button_get_value_as_int (_tmp5_);
		h = _tmp6_;
		_tmp7_ = self->priv->m_spinbutton;
		_tmp8_ = gtk_spin_button_get_value_as_int (_tmp7_);
		m = _tmp8_;
		_tmp9_ = self->priv->s_spinbutton;
		_tmp10_ = gtk_spin_button_get_value_as_int (_tmp9_);
		s = _tmp10_;
		_tmp11_ = h;
		_tmp12_ = m;
		_tmp13_ = s;
		self->priv->span = (gdouble) (((_tmp11_ * 3600) + (_tmp12_ * 60)) + _tmp13_);
		_tmp14_ = self->priv->settings;
		_tmp15_ = self->priv->span;
		g_settings_set_uint (_tmp14_, "timer", (guint) _tmp15_);
		_tmp16_ = self->priv->countdown_frame;
		_tmp17_ = self->priv->span;
		clocks_timer_countdown_frame_set_span (_tmp16_, _tmp17_);
		_tmp18_ = self->priv->countdown_frame;
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp18_);
		_tmp19_ = h;
		_tmp20_ = m;
		_tmp21_ = s;
		clocks_timer_face_update_countdown_label (self, _tmp19_, _tmp20_, _tmp21_);
	}
	clocks_timer_face_set_state (self, CLOCKS_TIMER_FACE_STATE_RUNNING);
	_tmp22_ = self->priv->timer;
	g_timer_start (_tmp22_);
	clocks_timer_face_add_tick (self);
}


static void clocks_timer_face_pause (ClocksTimerFace* self) {
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GTimer* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	ClocksTimerCountdownFrame* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	ClocksTimerCountdownFrame* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	clocks_timer_face_set_state (self, CLOCKS_TIMER_FACE_STATE_PAUSED);
	_tmp0_ = self->priv->timer;
	g_timer_stop (_tmp0_);
	_tmp1_ = self->priv->span;
	_tmp2_ = self->priv->timer;
	_tmp3_ = g_timer_elapsed (_tmp2_, NULL);
	self->priv->span = _tmp1_ - _tmp3_;
	_tmp4_ = self->priv->countdown_frame;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "clocks-paused");
	_tmp6_ = self->priv->countdown_frame;
	clocks_timer_countdown_frame_pause (_tmp6_);
	clocks_timer_face_remove_tick (self);
}


static gboolean ___lambda41_ (ClocksTimerFace* self, GtkWidget* c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = clocks_timer_face_count (self);
	result = _tmp0_;
	return result;
}


static gboolean ____lambda41__gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = ___lambda41_ ((ClocksTimerFace*) self, widget);
	return result;
}


static void clocks_timer_face_add_tick (ClocksTimerFace* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tick_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = gtk_widget_add_tick_callback ((GtkWidget*) self, ____lambda41__gtk_tick_callback, g_object_ref (self), g_object_unref);
		self->priv->tick_id = _tmp1_;
	}
}


static void clocks_timer_face_remove_tick (ClocksTimerFace* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tick_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->tick_id;
		gtk_widget_remove_tick_callback ((GtkWidget*) self, _tmp1_);
		self->priv->tick_id = (guint) 0;
	}
}


static gboolean clocks_timer_face_count (ClocksTimerFace* self) {
	gboolean result = FALSE;
	gdouble e = 0.0;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->timer;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	e = _tmp1_;
	_tmp2_ = e;
	_tmp3_ = self->priv->span;
	if (_tmp2_ >= _tmp3_) {
		clocks_timer_face_update_countdown_label (self, 0, 0, 0);
		g_signal_emit_by_name (self, "ring");
		clocks_timer_face_reset (self);
		result = FALSE;
		return result;
	}
	_tmp4_ = e;
	clocks_timer_face_update_countdown (self, _tmp4_);
	result = TRUE;
	return result;
}


static void clocks_timer_face_update_countdown (ClocksTimerFace* self, gdouble elapsed) {
	GtkSpinButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->h_label;
	_tmp1_ = gtk_widget_get_mapped ((GtkWidget*) _tmp0_);
	if (_tmp1_) {
		gdouble t = 0.0;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gint h = 0;
		gint m = 0;
		gint s = 0;
		gdouble r = 0.0;
		gdouble _tmp5_ = 0.0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		ClocksTimerCountdownFrame* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		_tmp2_ = self->priv->span;
		_tmp3_ = elapsed;
		_tmp4_ = ceil (_tmp2_ - _tmp3_);
		t = _tmp4_;
		_tmp5_ = t;
		clocks_utils_time_to_hms (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
		h = _tmp6_;
		m = _tmp7_;
		s = _tmp8_;
		r = _tmp9_;
		_tmp10_ = h;
		_tmp11_ = m;
		_tmp12_ = s;
		clocks_timer_face_update_countdown_label (self, _tmp10_, _tmp11_, _tmp12_);
		_tmp13_ = self->priv->countdown_frame;
		_tmp14_ = elapsed;
		clocks_timer_countdown_frame_update (_tmp13_, _tmp14_);
	}
}


static void clocks_timer_face_update_countdown_label (ClocksTimerFace* self, gint h, gint m, gint s) {
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GtkSpinButton* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkSpinButton* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->h_label;
	_tmp1_ = h;
	gtk_spin_button_set_value (_tmp0_, (gdouble) _tmp1_);
	_tmp2_ = self->priv->m_label;
	_tmp3_ = m;
	gtk_spin_button_set_value (_tmp2_, (gdouble) _tmp3_);
	_tmp4_ = self->priv->s_label;
	_tmp5_ = s;
	gtk_spin_button_set_value (_tmp4_, (gdouble) _tmp5_);
}


static void clocks_timer_face_real_grab_focus (GtkWidget* base) {
	ClocksTimerFace * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	ClocksAnalogFrame* _tmp2_ = NULL;
	self = (ClocksTimerFace*) base;
	_tmp0_ = gtk_stack_get_visible_child ((GtkStack*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->setup_frame;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget)) {
		GtkButton* _tmp3_ = NULL;
		_tmp3_ = self->priv->start_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	}
}


static gboolean clocks_timer_face_real_escape_pressed (ClocksClock* base) {
	ClocksTimerFace * self;
	gboolean result = FALSE;
	ClocksTimerFaceState _tmp0_ = 0;
	self = (ClocksTimerFace*) base;
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == CLOCKS_TIMER_FACE_STATE_STOPPED) {
		result = FALSE;
		return result;
	}
	clocks_timer_face_reset (self);
	result = TRUE;
	return result;
}


static const gchar* clocks_timer_face_real_get_label (ClocksClock* base) {
	const gchar* result;
	ClocksTimerFace* self;
	const gchar* _tmp0_ = NULL;
	self = (ClocksTimerFace*) base;
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


static void clocks_timer_face_real_set_label (ClocksClock* base, const gchar* value) {
	ClocksTimerFace* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (ClocksTimerFace*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp1_;
	g_object_notify ((GObject *) self, "label");
}


static ClocksHeaderBar* clocks_timer_face_real_get_header_bar (ClocksClock* base) {
	ClocksHeaderBar* result;
	ClocksTimerFace* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	self = (ClocksTimerFace*) base;
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}


static void clocks_timer_face_real_set_header_bar (ClocksClock* base, ClocksHeaderBar* value) {
	ClocksTimerFace* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	self = (ClocksTimerFace*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_header_bar);
	self->priv->_header_bar = _tmp1_;
	g_object_notify ((GObject *) self, "header-bar");
}


static ClocksPanelId clocks_timer_face_real_get_panel_id (ClocksClock* base) {
	ClocksPanelId result;
	ClocksTimerFace* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksTimerFace*) base;
	_tmp0_ = self->priv->_panel_id;
	result = _tmp0_;
	return result;
}


static void clocks_timer_face_real_set_panel_id (ClocksClock* base, ClocksPanelId value) {
	ClocksTimerFace* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksTimerFace*) base;
	_tmp0_ = value;
	self->priv->_panel_id = _tmp0_;
	g_object_notify ((GObject *) self, "panel-id");
}


ClocksTimerFaceState clocks_timer_face_get_state (ClocksTimerFace* self) {
	ClocksTimerFaceState result;
	ClocksTimerFaceState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_state;
	result = _tmp0_;
	return result;
}


static void clocks_timer_face_set_state (ClocksTimerFace* self, ClocksTimerFaceState value) {
	ClocksTimerFaceState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_state = _tmp0_;
	g_object_notify ((GObject *) self, "state");
}


static void clocks_timer_face_real_ring (ClocksTimerFace* self) {
	GApplication* app = NULL;
	GApplication* _tmp0_ = NULL;
	GApplication* _tmp1_ = NULL;
	GNotification* _tmp2_ = NULL;
	ClocksUtilsBell* _tmp3_ = NULL;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = self->priv->notification;
	g_application_send_notification (app, NULL, _tmp2_);
	_tmp3_ = self->priv->bell;
	clocks_utils_bell_ring_once (_tmp3_);
	_g_object_unref0 (app);
}


static void clocks_timer_face_class_init (ClocksTimerFaceClass * klass) {
	gint ClocksTimerFace_private_offset;
	clocks_timer_face_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksTimerFacePrivate));
	((GtkWidgetClass *) klass)->grab_focus = clocks_timer_face_real_grab_focus;
	((ClocksTimerFaceClass *) klass)->ring = clocks_timer_face_real_ring;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_timer_face_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_timer_face_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_timer_face_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_FACE_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_FACE_HEADER_BAR, g_param_spec_object ("header-bar", "header-bar", "header-bar", CLOCKS_TYPE_HEADER_BAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_FACE_PANEL_ID, g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_FACE_STATE, g_param_spec_enum ("state", "state", "state", CLOCKS_TIMER_FACE_TYPE_STATE, CLOCKS_TIMER_FACE_STATE_STOPPED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	ClocksTimerFace_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/timer.ui");
	g_signal_new ("ring", CLOCKS_TIMER_TYPE_FACE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksTimerFaceClass, ring), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_frame", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, setup_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_spinbuttons", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, grid_spinbuttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "h_spinbutton", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, h_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "m_spinbutton", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, m_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "s_spinbutton", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, s_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_button", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, start_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "countdown_frame", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, countdown_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "h_label", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, h_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "m_label", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, m_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "s_label", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, s_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_button", FALSE, ClocksTimerFace_private_offset + G_STRUCT_OFFSET (ClocksTimerFacePrivate, left_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "show_leading_zeros", G_CALLBACK(_clocks_timer_face_show_leading_zeros_gtk_spin_button_output));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "input_minutes", G_CALLBACK(_clocks_timer_face_input_minutes_gtk_spin_button_input));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "input_seconds", G_CALLBACK(_clocks_timer_face_input_seconds_gtk_spin_button_input));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "update_start_button", G_CALLBACK(_clocks_timer_face_update_start_button_gtk_editable_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_start_button_clicked", G_CALLBACK(_clocks_timer_face_on_start_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_left_button_clicked", G_CALLBACK(_clocks_timer_face_on_left_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_right_button_clicked", G_CALLBACK(_clocks_timer_face_on_right_button_clicked_gtk_button_clicked));
}


static void clocks_timer_face_clocks_clock_interface_init (ClocksClockIface * iface) {
	clocks_timer_face_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->escape_pressed = (gboolean (*)(ClocksClock*)) clocks_timer_face_real_escape_pressed;
	iface->get_label = clocks_timer_face_real_get_label;
	iface->set_label = clocks_timer_face_real_set_label;
	iface->get_header_bar = clocks_timer_face_real_get_header_bar;
	iface->set_header_bar = clocks_timer_face_real_set_header_bar;
	iface->get_panel_id = clocks_timer_face_real_get_panel_id;
	iface->set_panel_id = clocks_timer_face_real_set_panel_id;
}


static void clocks_timer_face_instance_init (ClocksTimerFace * self) {
	self->priv = CLOCKS_TIMER_FACE_GET_PRIVATE (self);
	self->priv->_state = CLOCKS_TIMER_FACE_STATE_STOPPED;
	g_type_ensure (CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME);
	g_type_ensure (CLOCKS_TYPE_ANALOG_FRAME);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_timer_face_finalize (GObject* obj) {
	ClocksTimerFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_header_bar);
	_g_object_unref0 (self->priv->settings);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->bell);
	_g_object_unref0 (self->priv->notification);
	_g_object_unref0 (self->priv->setup_frame);
	_g_object_unref0 (self->priv->grid_spinbuttons);
	_g_object_unref0 (self->priv->h_spinbutton);
	_g_object_unref0 (self->priv->m_spinbutton);
	_g_object_unref0 (self->priv->s_spinbutton);
	_g_object_unref0 (self->priv->start_button);
	_g_object_unref0 (self->priv->countdown_frame);
	_g_object_unref0 (self->priv->h_label);
	_g_object_unref0 (self->priv->m_label);
	_g_object_unref0 (self->priv->s_label);
	_g_object_unref0 (self->priv->left_button);
	G_OBJECT_CLASS (clocks_timer_face_parent_class)->finalize (obj);
}


GType clocks_timer_face_get_type (void) {
	static volatile gsize clocks_timer_face_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_timer_face_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksTimerFaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_timer_face_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksTimerFace), 0, (GInstanceInitFunc) clocks_timer_face_instance_init, NULL };
		static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_timer_face_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_timer_face_type_id;
		clocks_timer_face_type_id = g_type_register_static (gtk_stack_get_type (), "ClocksTimerFace", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_timer_face_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
		g_once_init_leave (&clocks_timer_face_type_id__volatile, clocks_timer_face_type_id);
	}
	return clocks_timer_face_type_id__volatile;
}


static void _vala_clocks_timer_face_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksTimerFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace);
	switch (property_id) {
		case CLOCKS_TIMER_FACE_LABEL:
		g_value_set_string (value, clocks_clock_get_label ((ClocksClock*) self));
		break;
		case CLOCKS_TIMER_FACE_HEADER_BAR:
		g_value_set_object (value, clocks_clock_get_header_bar ((ClocksClock*) self));
		break;
		case CLOCKS_TIMER_FACE_PANEL_ID:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		case CLOCKS_TIMER_FACE_STATE:
		g_value_set_enum (value, clocks_timer_face_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_timer_face_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksTimerFace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_FACE, ClocksTimerFace);
	switch (property_id) {
		case CLOCKS_TIMER_FACE_LABEL:
		clocks_clock_set_label ((ClocksClock*) self, g_value_get_string (value));
		break;
		case CLOCKS_TIMER_FACE_HEADER_BAR:
		clocks_clock_set_header_bar ((ClocksClock*) self, g_value_get_object (value));
		break;
		case CLOCKS_TIMER_FACE_PANEL_ID:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		case CLOCKS_TIMER_FACE_STATE:
		clocks_timer_face_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



