/* command-signals.c generated by valac 0.29.3.10-b87a, the Vala compiler
 * generated from command-signals.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <readline/readline.h>


#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS (folks_inspect_commands_signals_get_type ())
#define FOLKS_INSPECT_COMMANDS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignals))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))

typedef struct _FolksInspectCommandsSignals FolksInspectCommandsSignals;
typedef struct _FolksInspectCommandsSignalsClass FolksInspectCommandsSignalsClass;
typedef struct _FolksInspectCommandsSignalsPrivate FolksInspectCommandsSignalsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))

#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksInspectCommandsSignalsRunData FolksInspectCommandsSignalsRunData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gint (*run_finish) (FolksInspectCommand* self, GAsyncResult* _res_);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectCommandsSignals {
	FolksInspectCommand parent_instance;
	FolksInspectCommandsSignalsPrivate * priv;
};

struct _FolksInspectCommandsSignalsClass {
	FolksInspectCommandClass parent_class;
};

struct _FolksInspectCommandsSignalsRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksInspectCommandsSignals* self;
	gchar* command_string;
	gint result;
	const gchar* _tmp0_;
	FolksInspectClient* _tmp1_;
	FolksInspectSignalManager* _tmp2_;
	FolksInspectSignalManager* _tmp3_;
	gchar** parts;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint parts_length1;
	gint _parts_size_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	GType class_type;
	GObject* class_instance;
	gchar* signal_name;
	gchar* detail_string;
	gboolean _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	const gchar* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GType _tmp31_;
	GObject* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	const gchar* _tmp38_;
	guint signal_count;
	FolksInspectClient* _tmp39_;
	FolksInspectSignalManager* _tmp40_;
	FolksInspectSignalManager* _tmp41_;
	GType _tmp42_;
	GObject* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	guint _tmp46_;
	guint _tmp47_;
	guint _vala1_signal_count;
	FolksInspectClient* _tmp48_;
	FolksInspectSignalManager* _tmp49_;
	FolksInspectSignalManager* _tmp50_;
	GType _tmp51_;
	GObject* _tmp52_;
	const gchar* _tmp53_;
	const gchar* _tmp54_;
	guint _tmp55_;
	guint _tmp56_;
	gchar** _tmp57_;
	gint _tmp57__length1;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	GType _tmp61_;
	GObject* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gboolean _tmp65_;
	gboolean _tmp66_;
	const gchar* _tmp67_;
	FolksInspectClient* _tmp68_;
	FolksInspectSignalManager* _tmp69_;
	FolksInspectSignalManager* _tmp70_;
	GType _tmp71_;
	GObject* _tmp72_;
	GType _tmp73_;
	GObject* _tmp74_;
	GType _tmp75_;
	FolksInspectClient* _tmp76_;
	FolksInspectSignalManager* _tmp77_;
	FolksInspectSignalManager* _tmp78_;
	GType _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
};


static gpointer folks_inspect_commands_signals_parent_class = NULL;

gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
GType folks_inspect_commands_signals_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_COMMANDS_SIGNALS_DUMMY_PROPERTY
};
FolksInspectCommandsSignals* folks_inspect_commands_signals_new (FolksInspectClient* client);
FolksInspectCommandsSignals* folks_inspect_commands_signals_construct (GType object_type, FolksInspectClient* client);
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_commands_signals_real_run_data_free (gpointer _data);
static void folks_inspect_commands_signals_real_run (FolksInspectCommand* base, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_inspect_commands_signals_real_run_co (FolksInspectCommandsSignalsRunData* _data_);
GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST;
FolksInspectSignalManager* folks_inspect_client_get_signal_manager (FolksInspectClient* self);
void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self, GType class_type, GObject* class_instance);
gboolean folks_inspect_utils_validate_subcommand (const gchar* command, const gchar* command_string, const gchar* subcommand, gchar** valid_subcommands, int valid_subcommands_length1);
const gchar* folks_inspect_command_get_name (FolksInspectCommand* self);
void folks_inspect_utils_print_line (const gchar* format, ...);
static gboolean folks_inspect_commands_signals_parse_signal_id (FolksInspectCommandsSignals* self, const gchar* input, GType* class_type, GObject** class_instance, gchar** signal_name, gchar** detail_string);
guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self, GType class_type, const gchar* signal_name, const gchar* detail_string);
static gchar** folks_inspect_commands_signals_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup14 (gchar** self, int length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* FOLKS_INSPECT_COMMANDS_SIGNALS__valid_subcommands[2] = {"connect", "disconnect"};

FolksInspectCommandsSignals* folks_inspect_commands_signals_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommandsSignals* self = NULL;
	FolksInspectClient* _tmp0_ = NULL;
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = client;
	self = (FolksInspectCommandsSignals*) folks_inspect_command_construct (object_type, _tmp0_);
	return self;
}


FolksInspectCommandsSignals* folks_inspect_commands_signals_new (FolksInspectClient* client) {
	return folks_inspect_commands_signals_construct (FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, client);
}


static void folks_inspect_commands_signals_real_run_data_free (gpointer _data) {
	FolksInspectCommandsSignalsRunData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command_string);
	_folks_inspect_command_unref0 (_data_->self);
	g_slice_free (FolksInspectCommandsSignalsRunData, _data_);
}


static gpointer _folks_inspect_command_ref0 (gpointer self) {
	return self ? folks_inspect_command_ref (self) : NULL;
}


static void folks_inspect_commands_signals_real_run (FolksInspectCommand* base, const gchar* command_string, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksInspectCommandsSignals * self;
	FolksInspectCommandsSignalsRunData* _data_;
	FolksInspectCommandsSignals* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (FolksInspectCommandsSignals*) base;
	_data_ = g_slice_new0 (FolksInspectCommandsSignalsRunData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_inspect_commands_signals_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_inspect_commands_signals_real_run_data_free);
	_tmp0_ = _folks_inspect_command_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = command_string;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->command_string);
	_data_->command_string = _tmp2_;
	folks_inspect_commands_signals_real_run_co (_data_);
}


static gint folks_inspect_commands_signals_real_run_finish (FolksInspectCommand* base, GAsyncResult* _res_) {
	gint result;
	FolksInspectCommandsSignalsRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gboolean folks_inspect_commands_signals_real_run_co (FolksInspectCommandsSignalsRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->command_string;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = ((FolksInspectCommand*) _data_->self)->client;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = folks_inspect_client_get_signal_manager (_data_->_tmp1_);
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp2_;
		folks_inspect_signal_manager_list_signals (_data_->_tmp3_, G_TYPE_INVALID, NULL);
	} else {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->command_string;
		_data_->_tmp5_ = NULL;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp5_ = g_strsplit (_data_->_tmp4_, " ", 2);
		_data_->parts_length1 = 0;
		_data_->_parts_size_ = 0;
		_data_->parts = _data_->_tmp6_;
		_data_->parts_length1 = _vala_array_length (_data_->_tmp5_);
		_data_->_parts_size_ = _data_->parts_length1;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = folks_inspect_command_get_name ((FolksInspectCommand*) _data_->self);
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->command_string;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10__length1 = 0;
		_data_->_tmp10_ = _data_->parts;
		_data_->_tmp10__length1 = _data_->parts_length1;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp10_[0];
		_data_->_tmp12_ = FALSE;
		_data_->_tmp12_ = folks_inspect_utils_validate_subcommand (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp11_, FOLKS_INSPECT_COMMANDS_SIGNALS__valid_subcommands, G_N_ELEMENTS (FOLKS_INSPECT_COMMANDS_SIGNALS__valid_subcommands));
		if (!_data_->_tmp12_) {
			_data_->result = 1;
			_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14__length1 = 0;
		_data_->_tmp14_ = _data_->parts;
		_data_->_tmp14__length1 = _data_->parts_length1;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_tmp14_[0];
		if (g_strcmp0 (_data_->_tmp15_, "connect") == 0) {
			_data_->_tmp13_ = TRUE;
		} else {
			_data_->_tmp16_ = NULL;
			_data_->_tmp16__length1 = 0;
			_data_->_tmp16_ = _data_->parts;
			_data_->_tmp16__length1 = _data_->parts_length1;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->_tmp16_[0];
			_data_->_tmp13_ = g_strcmp0 (_data_->_tmp17_, "disconnect") == 0;
		}
		if (_data_->_tmp13_) {
			_data_->_tmp19_ = NULL;
			_data_->_tmp19__length1 = 0;
			_data_->_tmp19_ = _data_->parts;
			_data_->_tmp19__length1 = _data_->parts_length1;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_[1];
			if (_data_->_tmp20_ == NULL) {
				_data_->_tmp18_ = TRUE;
			} else {
				_data_->_tmp21_ = NULL;
				_data_->_tmp21__length1 = 0;
				_data_->_tmp21_ = _data_->parts;
				_data_->_tmp21__length1 = _data_->parts_length1;
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = _data_->_tmp21_[1];
				_data_->_tmp23_ = NULL;
				_data_->_tmp23_ = string_strip (_data_->_tmp22_);
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _data_->_tmp23_;
				_data_->_tmp18_ = g_strcmp0 (_data_->_tmp24_, "") == 0;
				_g_free0 (_data_->_tmp24_);
			}
			if (_data_->_tmp18_) {
				_data_->_tmp25_ = NULL;
				_data_->_tmp25__length1 = 0;
				_data_->_tmp25_ = _data_->parts;
				_data_->_tmp25__length1 = _data_->parts_length1;
				_data_->_tmp26_ = NULL;
				_data_->_tmp26_ = _data_->_tmp25_[1];
				folks_inspect_utils_print_line ("Unrecognised signal identifier '%s'.", _data_->_tmp26_);
				_data_->result = 1;
				_g_free0 (_data_->detail_string);
				_g_free0 (_data_->signal_name);
				_g_object_unref0 (_data_->class_instance);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp27_ = NULL;
			_data_->_tmp27__length1 = 0;
			_data_->_tmp27_ = _data_->parts;
			_data_->_tmp27__length1 = _data_->parts_length1;
			_data_->_tmp28_ = NULL;
			_data_->_tmp28_ = _data_->_tmp27_[1];
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = string_strip (_data_->_tmp28_);
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->_tmp29_;
			_data_->_tmp31_ = 0UL;
			_data_->_tmp32_ = NULL;
			_data_->_tmp33_ = NULL;
			_data_->_tmp34_ = NULL;
			_data_->_tmp35_ = FALSE;
			_data_->_tmp35_ = folks_inspect_commands_signals_parse_signal_id (_data_->self, _data_->_tmp30_, &_data_->_tmp31_, &_data_->_tmp32_, &_data_->_tmp33_, &_data_->_tmp34_);
			_data_->class_type = _data_->_tmp31_;
			_g_object_unref0 (_data_->class_instance);
			_data_->class_instance = _data_->_tmp32_;
			_g_free0 (_data_->signal_name);
			_data_->signal_name = _data_->_tmp33_;
			_g_free0 (_data_->detail_string);
			_data_->detail_string = _data_->_tmp34_;
			_data_->_tmp36_ = FALSE;
			_data_->_tmp36_ = _data_->_tmp35_ == FALSE;
			_g_free0 (_data_->_tmp30_);
			if (_data_->_tmp36_) {
				_data_->result = 1;
				_g_free0 (_data_->detail_string);
				_g_free0 (_data_->signal_name);
				_g_object_unref0 (_data_->class_instance);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp37_ = NULL;
			_data_->_tmp37__length1 = 0;
			_data_->_tmp37_ = _data_->parts;
			_data_->_tmp37__length1 = _data_->parts_length1;
			_data_->_tmp38_ = NULL;
			_data_->_tmp38_ = _data_->_tmp37_[0];
			if (g_strcmp0 (_data_->_tmp38_, "connect") == 0) {
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp40_ = NULL;
				_data_->_tmp40_ = folks_inspect_client_get_signal_manager (_data_->_tmp39_);
				_data_->_tmp41_ = NULL;
				_data_->_tmp41_ = _data_->_tmp40_;
				_data_->_tmp42_ = 0UL;
				_data_->_tmp42_ = _data_->class_type;
				_data_->_tmp43_ = NULL;
				_data_->_tmp43_ = _data_->class_instance;
				_data_->_tmp44_ = NULL;
				_data_->_tmp44_ = _data_->signal_name;
				_data_->_tmp45_ = NULL;
				_data_->_tmp45_ = _data_->detail_string;
				_data_->_tmp46_ = 0U;
				_data_->_tmp46_ = folks_inspect_signal_manager_connect_to_signal (_data_->_tmp41_, _data_->_tmp42_, _data_->_tmp43_, _data_->_tmp44_, _data_->_tmp45_);
				_data_->signal_count = _data_->_tmp46_;
				_data_->_tmp47_ = 0U;
				_data_->_tmp47_ = _data_->signal_count;
				folks_inspect_utils_print_line ("Connected to %u signals.", _data_->_tmp47_);
			} else {
				_data_->_tmp48_ = NULL;
				_data_->_tmp48_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp49_ = NULL;
				_data_->_tmp49_ = folks_inspect_client_get_signal_manager (_data_->_tmp48_);
				_data_->_tmp50_ = NULL;
				_data_->_tmp50_ = _data_->_tmp49_;
				_data_->_tmp51_ = 0UL;
				_data_->_tmp51_ = _data_->class_type;
				_data_->_tmp52_ = NULL;
				_data_->_tmp52_ = _data_->class_instance;
				_data_->_tmp53_ = NULL;
				_data_->_tmp53_ = _data_->signal_name;
				_data_->_tmp54_ = NULL;
				_data_->_tmp54_ = _data_->detail_string;
				_data_->_tmp55_ = 0U;
				_data_->_tmp55_ = folks_inspect_signal_manager_disconnect_from_signal (_data_->_tmp50_, _data_->_tmp51_, _data_->_tmp52_, _data_->_tmp53_, _data_->_tmp54_);
				_data_->_vala1_signal_count = _data_->_tmp55_;
				_data_->_tmp56_ = 0U;
				_data_->_tmp56_ = _data_->_vala1_signal_count;
				folks_inspect_utils_print_line ("Disconnected from %u signals.", _data_->_tmp56_);
			}
		} else {
			_data_->_tmp57_ = NULL;
			_data_->_tmp57__length1 = 0;
			_data_->_tmp57_ = _data_->parts;
			_data_->_tmp57__length1 = _data_->parts_length1;
			_data_->_tmp58_ = NULL;
			_data_->_tmp58_ = _data_->_tmp57_[0];
			_data_->_tmp59_ = NULL;
			_data_->_tmp59_ = string_strip (_data_->_tmp58_);
			_data_->_tmp60_ = NULL;
			_data_->_tmp60_ = _data_->_tmp59_;
			_data_->_tmp61_ = 0UL;
			_data_->_tmp62_ = NULL;
			_data_->_tmp63_ = NULL;
			_data_->_tmp64_ = NULL;
			_data_->_tmp65_ = FALSE;
			_data_->_tmp65_ = folks_inspect_commands_signals_parse_signal_id (_data_->self, _data_->_tmp60_, &_data_->_tmp61_, &_data_->_tmp62_, &_data_->_tmp63_, &_data_->_tmp64_);
			_data_->class_type = _data_->_tmp61_;
			_g_object_unref0 (_data_->class_instance);
			_data_->class_instance = _data_->_tmp62_;
			_g_free0 (_data_->signal_name);
			_data_->signal_name = _data_->_tmp63_;
			_g_free0 (_data_->detail_string);
			_data_->detail_string = _data_->_tmp64_;
			_data_->_tmp66_ = FALSE;
			_data_->_tmp66_ = _data_->_tmp65_ == FALSE;
			_g_free0 (_data_->_tmp60_);
			if (_data_->_tmp66_) {
				_data_->result = 1;
				_g_free0 (_data_->detail_string);
				_g_free0 (_data_->signal_name);
				_g_object_unref0 (_data_->class_instance);
				_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp67_ = NULL;
			_data_->_tmp67_ = _data_->signal_name;
			if (_data_->_tmp67_ == NULL) {
				_data_->_tmp68_ = NULL;
				_data_->_tmp68_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp69_ = NULL;
				_data_->_tmp69_ = folks_inspect_client_get_signal_manager (_data_->_tmp68_);
				_data_->_tmp70_ = NULL;
				_data_->_tmp70_ = _data_->_tmp69_;
				_data_->_tmp71_ = 0UL;
				_data_->_tmp71_ = _data_->class_type;
				_data_->_tmp72_ = NULL;
				_data_->_tmp72_ = _data_->class_instance;
				folks_inspect_signal_manager_list_signals (_data_->_tmp70_, _data_->_tmp71_, _data_->_tmp72_);
			} else {
				_data_->_tmp73_ = 0UL;
				_data_->_tmp73_ = _data_->class_type;
				if (_data_->_tmp73_ == G_TYPE_INVALID) {
					_data_->_tmp74_ = NULL;
					_data_->_tmp74_ = _data_->class_instance;
					_data_->_tmp75_ = 0UL;
					_data_->_tmp75_ = G_TYPE_FROM_INSTANCE (_data_->_tmp74_);
					_data_->class_type = _data_->_tmp75_;
				}
				_data_->_tmp76_ = NULL;
				_data_->_tmp76_ = ((FolksInspectCommand*) _data_->self)->client;
				_data_->_tmp77_ = NULL;
				_data_->_tmp77_ = folks_inspect_client_get_signal_manager (_data_->_tmp76_);
				_data_->_tmp78_ = NULL;
				_data_->_tmp78_ = _data_->_tmp77_;
				_data_->_tmp79_ = 0UL;
				_data_->_tmp79_ = _data_->class_type;
				_data_->_tmp80_ = NULL;
				_data_->_tmp80_ = _data_->signal_name;
				_data_->_tmp81_ = NULL;
				_data_->_tmp81_ = _data_->detail_string;
				folks_inspect_signal_manager_show_signal_details (_data_->_tmp78_, _data_->_tmp79_, _data_->_tmp80_, _data_->_tmp81_);
			}
		}
		_g_free0 (_data_->detail_string);
		_g_free0 (_data_->signal_name);
		_g_object_unref0 (_data_->class_instance);
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
	}
	_data_->result = 0;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_backend_name_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup14 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** folks_inspect_commands_signals_real_complete_subcommand (FolksInspectCommand* base, const gchar* subcommand, int* result_length1) {
	FolksInspectCommandsSignals * self;
	gchar** result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	self = (FolksInspectCommandsSignals*) base;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp0_ = subcommand;
	_tmp2_ = _tmp1_ = rl_completion_matches (_tmp0_, _folks_inspect_utils_backend_name_completion_cb_rl_compentry_func_t);
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup14 (_tmp2_, _vala_array_length (_tmp1_)) : ((gpointer) _tmp2_);
	_tmp3__length1 = _vala_array_length (_tmp1_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_ = NULL;
	guint64 _tmp1_ = 0ULL;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean folks_inspect_commands_signals_parse_signal_id (FolksInspectCommandsSignals* self, const gchar* input, GType* class_type, GObject** class_instance, gchar** signal_name, gchar** detail_string) {
	GType _vala_class_type = 0UL;
	GObject* _vala_class_instance = NULL;
	gchar* _vala_signal_name = NULL;
	gchar* _vala_detail_string = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gchar** parts = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gchar* class_name_or_instance = NULL;
	gchar** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gchar* signal_name_inner = NULL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gchar* detail_string_inner = NULL;
	gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_ = NULL;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	const gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (input != NULL, FALSE);
	_tmp1_ = input;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = input;
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	_vala_assert (_tmp0_, "input != null && input != \"\"");
	_vala_class_type = G_TYPE_INVALID;
	_g_object_unref0 (_vala_class_instance);
	_vala_class_instance = NULL;
	_g_free0 (_vala_signal_name);
	_vala_signal_name = NULL;
	_g_free0 (_vala_detail_string);
	_vala_detail_string = NULL;
	_tmp3_ = input;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "::", 3);
	parts = _tmp5_;
	parts_length1 = _vala_array_length (_tmp4_);
	_parts_size_ = parts_length1;
	_tmp6_ = parts;
	_tmp6__length1 = parts_length1;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = g_strdup (_tmp7_);
	class_name_or_instance = _tmp8_;
	_tmp10_ = parts;
	_tmp10__length1 = parts_length1;
	if (_tmp10__length1 > 1) {
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		_tmp11_ = parts;
		_tmp11__length1 = parts_length1;
		_tmp12_ = _tmp11_[1];
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = NULL;
	}
	_tmp13_ = g_strdup (_tmp9_);
	signal_name_inner = _tmp13_;
	_tmp15_ = parts;
	_tmp15__length1 = parts_length1;
	if (_tmp15__length1 > 2) {
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		const gchar* _tmp17_ = NULL;
		_tmp16_ = parts;
		_tmp16__length1 = parts_length1;
		_tmp17_ = _tmp16_[2];
		_tmp14_ = _tmp17_;
	} else {
		_tmp14_ = NULL;
	}
	_tmp18_ = g_strdup (_tmp14_);
	detail_string_inner = _tmp18_;
	_tmp20_ = signal_name_inner;
	if (g_strcmp0 (_tmp20_, "") == 0) {
		_tmp19_ = TRUE;
	} else {
		const gchar* _tmp21_ = NULL;
		_tmp21_ = detail_string_inner;
		_tmp19_ = g_strcmp0 (_tmp21_, "") == 0;
	}
	if (_tmp19_) {
		const gchar* _tmp22_ = NULL;
		_tmp22_ = input;
		folks_inspect_utils_print_line ("Invalid signal identifier '%s'.", _tmp22_);
		result = FALSE;
		_g_free0 (detail_string_inner);
		_g_free0 (signal_name_inner);
		_g_free0 (class_name_or_instance);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (class_type) {
			*class_type = _vala_class_type;
		}
		if (class_instance) {
			*class_instance = _vala_class_instance;
		} else {
			_g_object_unref0 (_vala_class_instance);
		}
		if (signal_name) {
			*signal_name = _vala_signal_name;
		} else {
			_g_free0 (_vala_signal_name);
		}
		if (detail_string) {
			*detail_string = _vala_detail_string;
		} else {
			_g_free0 (_vala_detail_string);
		}
		return result;
	}
	_tmp25_ = class_name_or_instance;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ > 2) {
		const gchar* _tmp28_ = NULL;
		gchar _tmp29_ = '\0';
		_tmp28_ = class_name_or_instance;
		_tmp29_ = string_get (_tmp28_, (glong) 0);
		_tmp24_ = _tmp29_ == '0';
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		const gchar* _tmp30_ = NULL;
		gchar _tmp31_ = '\0';
		_tmp30_ = class_name_or_instance;
		_tmp31_ = string_get (_tmp30_, (glong) 1);
		_tmp23_ = _tmp31_ == 'x';
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		guint64 address = 0ULL;
		const gchar* _tmp32_ = NULL;
		guint64 _tmp33_ = 0ULL;
		guint64 _tmp34_ = 0ULL;
		GObject* _tmp35_ = NULL;
		GObject* _tmp36_ = NULL;
		GType _tmp37_ = 0UL;
		gboolean _tmp38_ = FALSE;
		_tmp32_ = class_name_or_instance;
		_tmp33_ = uint64_parse (_tmp32_);
		address = _tmp33_;
		_tmp34_ = address;
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, G_TYPE_OBJECT, GObject));
		_g_object_unref0 (_vala_class_instance);
		_vala_class_instance = _tmp35_;
		_tmp36_ = _vala_class_instance;
		_tmp37_ = G_TYPE_FROM_INSTANCE (_tmp36_);
		_tmp38_ = G_TYPE_IS_OBJECT (_tmp37_);
		_vala_assert (_tmp38_, "class_instance.get_type ().is_object ()");
	} else {
		const gchar* _tmp39_ = NULL;
		GType _tmp40_ = 0UL;
		gboolean _tmp41_ = FALSE;
		GType _tmp42_ = 0UL;
		_tmp39_ = class_name_or_instance;
		_tmp40_ = g_type_from_name (_tmp39_);
		_vala_class_type = _tmp40_;
		_tmp42_ = _vala_class_type;
		if (_tmp42_ == G_TYPE_INVALID) {
			_tmp41_ = TRUE;
		} else {
			gboolean _tmp43_ = FALSE;
			GType _tmp44_ = 0UL;
			gboolean _tmp45_ = FALSE;
			_tmp44_ = _vala_class_type;
			_tmp45_ = G_TYPE_IS_INSTANTIATABLE (_tmp44_);
			if (_tmp45_ == FALSE) {
				GType _tmp46_ = 0UL;
				gboolean _tmp47_ = FALSE;
				_tmp46_ = _vala_class_type;
				_tmp47_ = G_TYPE_IS_INTERFACE (_tmp46_);
				_tmp43_ = _tmp47_ == FALSE;
			} else {
				_tmp43_ = FALSE;
			}
			_tmp41_ = _tmp43_;
		}
		if (_tmp41_) {
			const gchar* _tmp48_ = NULL;
			_tmp48_ = class_name_or_instance;
			folks_inspect_utils_print_line ("Unrecognised class name '%s'.", _tmp48_);
			result = FALSE;
			_g_free0 (detail_string_inner);
			_g_free0 (signal_name_inner);
			_g_free0 (class_name_or_instance);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			if (class_type) {
				*class_type = _vala_class_type;
			}
			if (class_instance) {
				*class_instance = _vala_class_instance;
			} else {
				_g_object_unref0 (_vala_class_instance);
			}
			if (signal_name) {
				*signal_name = _vala_signal_name;
			} else {
				_g_free0 (_vala_signal_name);
			}
			if (detail_string) {
				*detail_string = _vala_detail_string;
			} else {
				_g_free0 (_vala_detail_string);
			}
			return result;
		}
	}
	_tmp49_ = signal_name_inner;
	_tmp50_ = g_strdup (_tmp49_);
	_g_free0 (_vala_signal_name);
	_vala_signal_name = _tmp50_;
	_tmp51_ = detail_string_inner;
	_tmp52_ = g_strdup (_tmp51_);
	_g_free0 (_vala_detail_string);
	_vala_detail_string = _tmp52_;
	result = TRUE;
	_g_free0 (detail_string_inner);
	_g_free0 (signal_name_inner);
	_g_free0 (class_name_or_instance);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (class_type) {
		*class_type = _vala_class_type;
	}
	if (class_instance) {
		*class_instance = _vala_class_instance;
	} else {
		_g_object_unref0 (_vala_class_instance);
	}
	if (signal_name) {
		*signal_name = _vala_signal_name;
	} else {
		_g_free0 (_vala_signal_name);
	}
	if (detail_string) {
		*detail_string = _vala_detail_string;
	} else {
		_g_free0 (_vala_detail_string);
	}
	return result;
}


static const gchar* folks_inspect_commands_signals_real_get_name (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "signals";
	return result;
}


static const gchar* folks_inspect_commands_signals_real_get_description (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "Allow connection to and display of signals emitted by " "libfolks.";
	return result;
}


static const gchar* folks_inspect_commands_signals_real_get_help (FolksInspectCommand* base) {
	const gchar* result;
	FolksInspectCommandsSignals* self;
	self = (FolksInspectCommandsSignals*) base;
	result = "signals                                            " "List signals we're currently connected to.\n" "signals connect [class name]                       " "Connect to all the signals on all the instances of that " "class.\n" "signals connect [class name]::[signal name]        " "Connect to the given signal on all the instances of that " "class.\n" "signals connect [object pointer]                   " "Connect to all the signals on a particular class instance.\n" "signals connect [object pointer]::[signal name]    " "Connect to the given signal on a particular class instance.\n" "signals disconnect                                 " "(As for 'connect'.)\n" "signals [class name]                               " "List all the signals on all the instances of that class, " "highlighting the ones we're currently connected to.\n" "signals [object pointer]                           " "List all the signals on a particular class instance, " "highlighting the ones we're currently connected to.\n" "signals [class name]::[signal name]                " "Show the details of this signal.\n" "signals [object pointer]::[signal name]            " "Show the details of this signal.";
	return result;
}


static void folks_inspect_commands_signals_class_init (FolksInspectCommandsSignalsClass * klass) {
	folks_inspect_commands_signals_parent_class = g_type_class_peek_parent (klass);
	((FolksInspectCommandClass *) klass)->run = folks_inspect_commands_signals_real_run;
	((FolksInspectCommandClass *) klass)->run_finish = folks_inspect_commands_signals_real_run_finish;
	((FolksInspectCommandClass *) klass)->complete_subcommand = folks_inspect_commands_signals_real_complete_subcommand;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_name = folks_inspect_commands_signals_real_get_name;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_description = folks_inspect_commands_signals_real_get_description;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->get_help = folks_inspect_commands_signals_real_get_help;
}


static void folks_inspect_commands_signals_instance_init (FolksInspectCommandsSignals * self) {
}


GType folks_inspect_commands_signals_get_type (void) {
	static volatile gsize folks_inspect_commands_signals_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_commands_signals_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandsSignalsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_commands_signals_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommandsSignals), 0, (GInstanceInitFunc) folks_inspect_commands_signals_instance_init, NULL };
		GType folks_inspect_commands_signals_type_id;
		folks_inspect_commands_signals_type_id = g_type_register_static (FOLKS_INSPECT_TYPE_COMMAND, "FolksInspectCommandsSignals", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_commands_signals_type_id__volatile, folks_inspect_commands_signals_type_id);
	}
	return folks_inspect_commands_signals_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



