/* math-function.c generated by valac 0.32.1, the Vala compiler
 * generated from math-function.vala, do not modify */

/*
 * Copyright (C) 2013 Garima Joshi
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_MATH_FUNCTION (math_function_get_type ())
#define MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_FUNCTION, MathFunction))
#define MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_FUNCTION, MathFunctionClass))
#define IS_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_FUNCTION))
#define IS_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_FUNCTION))
#define MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_FUNCTION, MathFunctionClass))

typedef struct _MathFunction MathFunction;
typedef struct _MathFunctionClass MathFunctionClass;
typedef struct _MathFunctionPrivate MathFunctionPrivate;

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;

#define TYPE_PARSER (parser_get_type ())
#define PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PARSER, Parser))
#define PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PARSER, ParserClass))
#define IS_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PARSER))
#define IS_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PARSER))
#define PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PARSER, ParserClass))

typedef struct _Parser Parser;
typedef struct _ParserClass ParserClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_EXPRESSION_PARSER (expression_parser_get_type ())
#define EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXPRESSION_PARSER, ExpressionParser))
#define EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXPRESSION_PARSER, ExpressionParserClass))
#define IS_EXPRESSION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXPRESSION_PARSER))
#define IS_EXPRESSION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXPRESSION_PARSER))
#define EXPRESSION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXPRESSION_PARSER, ExpressionParserClass))

typedef struct _ExpressionParser ExpressionParser;
typedef struct _ExpressionParserClass ExpressionParserClass;

#define TYPE_FUNCTION_PARSER (function_parser_get_type ())
#define FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FUNCTION_PARSER, FunctionParser))
#define FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FUNCTION_PARSER, FunctionParserClass))
#define IS_FUNCTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FUNCTION_PARSER))
#define IS_FUNCTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FUNCTION_PARSER))
#define FUNCTION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FUNCTION_PARSER, FunctionParserClass))

typedef struct _FunctionParser FunctionParser;
typedef struct _FunctionParserClass FunctionParserClass;

#define TYPE_ERROR_CODE (error_code_get_type ())
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParserPrivate ParserPrivate;

#define TYPE_ANGLE_UNIT (angle_unit_get_type ())
typedef struct _ExpressionParserPrivate ExpressionParserPrivate;
typedef struct _FunctionParserPrivate FunctionParserPrivate;

#define TYPE_BUILT_IN_MATH_FUNCTION (built_in_math_function_get_type ())
#define BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunction))
#define BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))
#define IS_BUILT_IN_MATH_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILT_IN_MATH_FUNCTION))
#define IS_BUILT_IN_MATH_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILT_IN_MATH_FUNCTION))
#define BUILT_IN_MATH_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILT_IN_MATH_FUNCTION, BuiltInMathFunctionClass))

typedef struct _BuiltInMathFunction BuiltInMathFunction;
typedef struct _BuiltInMathFunctionClass BuiltInMathFunctionClass;
typedef struct _BuiltInMathFunctionPrivate BuiltInMathFunctionPrivate;

struct _MathFunction {
	GObject parent_instance;
	MathFunctionPrivate * priv;
};

struct _MathFunctionClass {
	GObjectClass parent_class;
	Number* (*evaluate) (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
	gboolean (*is_custom_function) (MathFunction* self);
};

struct _MathFunctionPrivate {
	gchar* _name;
	gchar** _arguments;
	gint _arguments_length1;
	gint __arguments_size_;
	gchar* _expression;
	gchar* _description;
};

typedef enum  {
	ERROR_CODE_NONE,
	ERROR_CODE_INVALID,
	ERROR_CODE_OVERFLOW,
	ERROR_CODE_UNKNOWN_VARIABLE,
	ERROR_CODE_UNKNOWN_FUNCTION,
	ERROR_CODE_UNKNOWN_CONVERSION,
	ERROR_CODE_MP
} ErrorCode;

typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Parser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ParserPrivate * priv;
	gint number_base;
	gint wordlen;
	AngleUnit angle_units;
};

struct _ParserClass {
	GTypeClass parent_class;
	void (*finalize) (Parser *self);
	gboolean (*variable_is_defined) (Parser* self, const gchar* name);
	Number* (*get_variable) (Parser* self, const gchar* name);
	void (*set_variable) (Parser* self, const gchar* name, Number* x);
	gboolean (*function_is_defined) (Parser* self, const gchar* name);
	Number* (*convert) (Parser* self, Number* x, const gchar* x_units, const gchar* z_units);
};

struct _ExpressionParser {
	Parser parent_instance;
	ExpressionParserPrivate * priv;
};

struct _ExpressionParserClass {
	ParserClass parent_class;
};

struct _ExpressionParserPrivate {
	Parser* _root_parser;
};

struct _FunctionParser {
	ExpressionParser parent_instance;
	FunctionParserPrivate * priv;
};

struct _FunctionParserClass {
	ExpressionParserClass parent_class;
};

struct _FunctionParserPrivate {
	Number** _parameters;
	gint _parameters_length1;
	gint __parameters_size_;
	MathFunction* _function;
};

struct _BuiltInMathFunction {
	MathFunction parent_instance;
	BuiltInMathFunctionPrivate * priv;
};

struct _BuiltInMathFunctionClass {
	MathFunctionClass parent_class;
};


static gpointer math_function_parent_class = NULL;
static gpointer expression_parser_parent_class = NULL;
static gpointer function_parser_parent_class = NULL;
static gpointer built_in_math_function_parent_class = NULL;

GType math_function_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
gpointer parser_ref (gpointer instance);
void parser_unref (gpointer instance);
GParamSpec* param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_parser (GValue* value, gpointer v_object);
void value_take_parser (GValue* value, gpointer v_object);
gpointer value_get_parser (const GValue* value);
GType parser_get_type (void) G_GNUC_CONST;
#define MATH_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_FUNCTION, MathFunctionPrivate))
enum  {
	MATH_FUNCTION_DUMMY_PROPERTY,
	MATH_FUNCTION_NAME,
	MATH_FUNCTION_ARGUMENTS,
	MATH_FUNCTION_EXPRESSION,
	MATH_FUNCTION_DESCRIPTION
};
MathFunction* math_function_new (const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description);
MathFunction* math_function_construct (GType object_type, const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description);
static gchar** _vala_array_dup4 (gchar** self, int length);
Number* math_function_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
static Number* math_function_real_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser);
GType expression_parser_get_type (void) G_GNUC_CONST;
GType function_parser_get_type (void) G_GNUC_CONST;
FunctionParser* function_parser_new (MathFunction* function, Parser* root_parser, Number** parameters, int parameters_length1);
FunctionParser* function_parser_construct (GType object_type, MathFunction* function, Parser* root_parser, Number** parameters, int parameters_length1);
GType error_code_get_type (void) G_GNUC_CONST;
Number* parser_parse (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
void parser_set_error (Parser* self, ErrorCode errorno, const gchar* token, guint token_start, guint token_end);
gboolean math_function_validate (MathFunction* self, Parser* root_parser);
static gboolean math_function_is_name_valid (MathFunction* self, const gchar* x);
const gchar* math_function_get_name (MathFunction* self);
gchar** math_function_get_arguments (MathFunction* self, int* result_length1);
gboolean parser_create_parse_tree (Parser* self, guint* representation_base, ErrorCode* error_code, gchar** error_token, guint* error_start, guint* error_end);
gboolean math_function_is_custom_function (MathFunction* self);
static gboolean math_function_real_is_custom_function (MathFunction* self);
const gchar* math_function_get_expression (MathFunction* self);
const gchar* math_function_get_description (MathFunction* self);
static void math_function_finalize (GObject* obj);
static void _vala_math_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType angle_unit_get_type (void) G_GNUC_CONST;
#define EXPRESSION_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EXPRESSION_PARSER, ExpressionParserPrivate))
enum  {
	EXPRESSION_PARSER_DUMMY_PROPERTY
};
ExpressionParser* expression_parser_new (const gchar* expression, Parser* root_parser);
ExpressionParser* expression_parser_construct (GType object_type, const gchar* expression, Parser* root_parser);
Parser* parser_new (const gchar* input, gint number_base, gint wordlen, AngleUnit angle_units);
Parser* parser_construct (GType object_type, const gchar* input, gint number_base, gint wordlen, AngleUnit angle_units);
static gboolean expression_parser_real_variable_is_defined (Parser* base, const gchar* name);
gboolean parser_variable_is_defined (Parser* self, const gchar* name);
static Number* expression_parser_real_get_variable (Parser* base, const gchar* name);
Number* parser_get_variable (Parser* self, const gchar* name);
static gboolean expression_parser_real_function_is_defined (Parser* base, const gchar* name);
gboolean parser_function_is_defined (Parser* self, const gchar* name);
static void expression_parser_finalize (Parser* obj);
#define FUNCTION_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FUNCTION_PARSER, FunctionParserPrivate))
enum  {
	FUNCTION_PARSER_DUMMY_PROPERTY
};
static Number** _vala_array_dup5 (Number** self, int length);
static gboolean function_parser_real_variable_is_defined (Parser* base, const gchar* name);
static gchar** _vala_array_dup6 (gchar** self, int length);
static Number* function_parser_real_get_variable (Parser* base, const gchar* name);
static gchar** _vala_array_dup7 (gchar** self, int length);
static void function_parser_finalize (Parser* obj);
GType built_in_math_function_get_type (void) G_GNUC_CONST;
enum  {
	BUILT_IN_MATH_FUNCTION_DUMMY_PROPERTY
};
BuiltInMathFunction* built_in_math_function_new (const gchar* function_name, const gchar* description);
BuiltInMathFunction* built_in_math_function_construct (GType object_type, const gchar* function_name, const gchar* description);
static Number* built_in_math_function_real_evaluate (MathFunction* base, Number** args, int args_length1, Parser* root_parser);
Number* evaluate_built_in_function (const gchar* name, Number** args, int args_length1, Parser* root_parser);
static gboolean built_in_math_function_real_is_custom_function (MathFunction* base);
Number* number_logarithm (Number* self, gint64 n);
gint64 number_to_integer (Number* self);
Number* number_ln (Number* self);
Number* number_sqrt (Number* self);
Number* number_abs (Number* self);
Number* number_sgn (Number* self);
Number* number_arg (Number* self, AngleUnit unit);
Number* number_conjugate (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_sin (Number* self, AngleUnit unit);
Number* number_cos (Number* self, AngleUnit unit);
Number* number_tan (Number* self, AngleUnit unit);
Number* number_asin (Number* self, AngleUnit unit);
Number* number_acos (Number* self, AngleUnit unit);
Number* number_atan (Number* self, AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_cosh (Number* self);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_ones_complement (Number* self, gint wordlen);
Number* number_twos_complement (Number* self, gint wordlen);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


MathFunction* math_function_construct (GType object_type, const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description) {
	MathFunction * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp8_ = NULL;
	g_return_val_if_fail (function_name != NULL, NULL);
	self = (MathFunction*) g_object_new (object_type, NULL);
	_tmp0_ = function_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	_tmp2_ = arguments;
	_tmp2__length1 = arguments_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup4 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_arguments = _tmp3_;
	self->priv->_arguments_length1 = _tmp3__length1;
	self->priv->__arguments_size_ = self->priv->_arguments_length1;
	_tmp4_ = expression;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = expression;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (self->priv->_expression);
		self->priv->_expression = _tmp6_;
	} else {
		gchar* _tmp7_ = NULL;
		_tmp7_ = g_strdup ("");
		_g_free0 (self->priv->_expression);
		self->priv->_expression = _tmp7_;
	}
	_tmp8_ = description;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp9_ = description;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp10_;
	} else {
		gchar* _tmp11_ = NULL;
		_tmp11_ = g_strdup ("");
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp11_;
	}
	return self;
}


MathFunction* math_function_new (const gchar* function_name, gchar** arguments, int arguments_length1, const gchar* expression, const gchar* description) {
	return math_function_construct (TYPE_MATH_FUNCTION, function_name, arguments, arguments_length1, expression, description);
}


static Number* math_function_real_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser) {
	Number* result = NULL;
	FunctionParser* parser = NULL;
	Parser* _tmp0_ = NULL;
	Number** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	FunctionParser* _tmp2_ = NULL;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	Number* ans = NULL;
	FunctionParser* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	ErrorCode _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	Number* _tmp9_ = NULL;
	ErrorCode _tmp10_ = 0;
	Parser* _tmp11_ = NULL;
	ErrorCode _tmp12_ = 0;
	const gchar* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	_tmp0_ = root_parser;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = function_parser_new (self, _tmp0_, _tmp1_, _tmp1__length1);
	parser = _tmp2_;
	_tmp3_ = parser;
	_tmp9_ = parser_parse ((Parser*) _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
	representation_base = _tmp4_;
	error_code = _tmp5_;
	_g_free0 (error_token);
	error_token = _tmp6_;
	error_start = _tmp7_;
	error_end = _tmp8_;
	ans = _tmp9_;
	_tmp10_ = error_code;
	if (_tmp10_ == ERROR_CODE_NONE) {
		result = ans;
		_g_free0 (error_token);
		_parser_unref0 (parser);
		return result;
	}
	_tmp11_ = root_parser;
	_tmp12_ = error_code;
	_tmp13_ = error_token;
	_tmp14_ = error_start;
	_tmp15_ = error_end;
	parser_set_error (_tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_);
	result = NULL;
	_g_object_unref0 (ans);
	_g_free0 (error_token);
	_parser_unref0 (parser);
	return result;
}


Number* math_function_evaluate (MathFunction* self, Number** args, int args_length1, Parser* root_parser) {
	g_return_val_if_fail (self != NULL, NULL);
	return MATH_FUNCTION_GET_CLASS (self)->evaluate (self, args, args_length1, root_parser);
}


gboolean math_function_validate (MathFunction* self, Parser* root_parser) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	Number** args = NULL;
	Number** _tmp10_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	FunctionParser* parser = NULL;
	Parser* _tmp11_ = NULL;
	Number** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	FunctionParser* _tmp13_ = NULL;
	guint representation_base = 0U;
	ErrorCode error_code = 0;
	gchar* error_token = NULL;
	guint error_start = 0U;
	guint error_end = 0U;
	FunctionParser* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	ErrorCode _tmp16_ = 0;
	gchar* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	ErrorCode _tmp20_ = 0;
	Parser* _tmp21_ = NULL;
	ErrorCode _tmp22_ = 0;
	const gchar* _tmp23_ = NULL;
	guint _tmp24_ = 0U;
	guint _tmp25_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = math_function_get_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = math_function_is_name_valid (self, _tmp1_);
	if (!_tmp2_) {
		Parser* _tmp3_ = NULL;
		_tmp3_ = root_parser;
		parser_set_error (_tmp3_, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
		result = FALSE;
		return result;
	}
	_tmp4_ = math_function_get_arguments (self, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	{
		gchar** argument_collection = NULL;
		gint argument_collection_length1 = 0;
		gint _argument_collection_size_ = 0;
		gint argument_it = 0;
		argument_collection = _tmp5_;
		argument_collection_length1 = _tmp5__length1;
		for (argument_it = 0; argument_it < _tmp5__length1; argument_it = argument_it + 1) {
			gchar* _tmp6_ = NULL;
			gchar* argument = NULL;
			_tmp6_ = g_strdup (argument_collection[argument_it]);
			argument = _tmp6_;
			{
				const gchar* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				_tmp7_ = argument;
				_tmp8_ = math_function_is_name_valid (self, _tmp7_);
				if (!_tmp8_) {
					Parser* _tmp9_ = NULL;
					_tmp9_ = root_parser;
					parser_set_error (_tmp9_, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
					result = FALSE;
					_g_free0 (argument);
					return result;
				}
				_g_free0 (argument);
			}
		}
	}
	_tmp10_ = g_new0 (Number*, 0 + 1);
	args = _tmp10_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp11_ = root_parser;
	_tmp12_ = args;
	_tmp12__length1 = args_length1;
	_tmp13_ = function_parser_new (self, _tmp11_, _tmp12_, _tmp12__length1);
	parser = _tmp13_;
	_tmp14_ = parser;
	parser_create_parse_tree ((Parser*) _tmp14_, &_tmp15_, &_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_);
	representation_base = _tmp15_;
	error_code = _tmp16_;
	_g_free0 (error_token);
	error_token = _tmp17_;
	error_start = _tmp18_;
	error_end = _tmp19_;
	_tmp20_ = error_code;
	if (_tmp20_ == ERROR_CODE_NONE) {
		result = TRUE;
		_g_free0 (error_token);
		_parser_unref0 (parser);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	_tmp21_ = root_parser;
	_tmp22_ = error_code;
	_tmp23_ = error_token;
	_tmp24_ = error_start;
	_tmp25_ = error_end;
	parser_set_error (_tmp21_, _tmp22_, _tmp23_, _tmp24_, _tmp25_);
	result = FALSE;
	_g_free0 (error_token);
	_parser_unref0 (parser);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean math_function_is_name_valid (MathFunction* self, const gchar* x) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (x != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				const gchar* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gunichar current_char = 0U;
				const gchar* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gunichar _tmp8_ = 0U;
				gunichar _tmp9_ = 0U;
				gboolean _tmp10_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = x;
				_tmp4_ = strlen (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = x;
				_tmp7_ = i;
				_tmp8_ = string_get_char (_tmp6_, (glong) _tmp7_);
				current_char = _tmp8_;
				_tmp9_ = current_char;
				_tmp10_ = g_unichar_isalpha (_tmp9_);
				if (!_tmp10_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean math_function_real_is_custom_function (MathFunction* self) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


gboolean math_function_is_custom_function (MathFunction* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return MATH_FUNCTION_GET_CLASS (self)->is_custom_function (self);
}


const gchar* math_function_get_name (MathFunction* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


gchar** math_function_get_arguments (MathFunction* self, int* result_length1) {
	gchar** result;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_arguments;
	_tmp0__length1 = self->priv->_arguments_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


const gchar* math_function_get_expression (MathFunction* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}


const gchar* math_function_get_description (MathFunction* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}


static void math_function_class_init (MathFunctionClass * klass) {
	math_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathFunctionPrivate));
	((MathFunctionClass *) klass)->evaluate = math_function_real_evaluate;
	((MathFunctionClass *) klass)->is_custom_function = math_function_real_is_custom_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_math_function_get_property;
	G_OBJECT_CLASS (klass)->finalize = math_function_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_ARGUMENTS, g_param_spec_boxed ("arguments", "arguments", "arguments", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_EXPRESSION, g_param_spec_string ("expression", "expression", "expression", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_FUNCTION_DESCRIPTION, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void math_function_instance_init (MathFunction * self) {
	self->priv = MATH_FUNCTION_GET_PRIVATE (self);
}


static void math_function_finalize (GObject* obj) {
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_FUNCTION, MathFunction);
	_g_free0 (self->priv->_name);
	self->priv->_arguments = (_vala_array_free (self->priv->_arguments, self->priv->_arguments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_expression);
	_g_free0 (self->priv->_description);
	G_OBJECT_CLASS (math_function_parent_class)->finalize (obj);
}


GType math_function_get_type (void) {
	static volatile gsize math_function_type_id__volatile = 0;
	if (g_once_init_enter (&math_function_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathFunction), 0, (GInstanceInitFunc) math_function_instance_init, NULL };
		GType math_function_type_id;
		math_function_type_id = g_type_register_static (G_TYPE_OBJECT, "MathFunction", &g_define_type_info, 0);
		g_once_init_leave (&math_function_type_id__volatile, math_function_type_id);
	}
	return math_function_type_id__volatile;
}


static void _vala_math_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathFunction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_FUNCTION, MathFunction);
	switch (property_id) {
		case MATH_FUNCTION_NAME:
		g_value_set_string (value, math_function_get_name (self));
		break;
		case MATH_FUNCTION_ARGUMENTS:
		{
			int length;
			g_value_set_boxed (value, math_function_get_arguments (self, &length));
		}
		break;
		case MATH_FUNCTION_EXPRESSION:
		g_value_set_string (value, math_function_get_expression (self));
		break;
		case MATH_FUNCTION_DESCRIPTION:
		g_value_set_string (value, math_function_get_description (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _parser_ref0 (gpointer self) {
	return self ? parser_ref (self) : NULL;
}


ExpressionParser* expression_parser_construct (GType object_type, const gchar* expression, Parser* root_parser) {
	ExpressionParser* self = NULL;
	const gchar* _tmp0_ = NULL;
	Parser* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Parser* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Parser* _tmp5_ = NULL;
	AngleUnit _tmp6_ = 0;
	Parser* _tmp7_ = NULL;
	Parser* _tmp8_ = NULL;
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp0_ = expression;
	_tmp1_ = root_parser;
	_tmp2_ = _tmp1_->number_base;
	_tmp3_ = root_parser;
	_tmp4_ = _tmp3_->wordlen;
	_tmp5_ = root_parser;
	_tmp6_ = _tmp5_->angle_units;
	self = (ExpressionParser*) parser_construct (object_type, _tmp0_, _tmp2_, _tmp4_, _tmp6_);
	_tmp7_ = root_parser;
	_tmp8_ = _parser_ref0 (_tmp7_);
	_parser_unref0 (self->priv->_root_parser);
	self->priv->_root_parser = _tmp8_;
	return self;
}


ExpressionParser* expression_parser_new (const gchar* expression, Parser* root_parser) {
	return expression_parser_construct (TYPE_EXPRESSION_PARSER, expression, root_parser);
}


static gboolean expression_parser_real_variable_is_defined (Parser* base, const gchar* name) {
	ExpressionParser * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Parser* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = PARSER_CLASS (expression_parser_parent_class)->variable_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), _tmp0_);
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->_root_parser;
	_tmp3_ = name;
	_tmp4_ = parser_variable_is_defined (_tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static Number* expression_parser_real_get_variable (Parser* base, const gchar* name) {
	ExpressionParser * self;
	Number* result = NULL;
	Number* value = NULL;
	const gchar* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Parser* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = PARSER_CLASS (expression_parser_parent_class)->get_variable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), _tmp0_);
	value = _tmp1_;
	_tmp2_ = value;
	if (_tmp2_ != NULL) {
		result = value;
		return result;
	}
	_tmp3_ = self->priv->_root_parser;
	_tmp4_ = name;
	_tmp5_ = parser_get_variable (_tmp3_, _tmp4_);
	result = _tmp5_;
	_g_object_unref0 (value);
	return result;
}


static gboolean expression_parser_real_function_is_defined (Parser* base, const gchar* name) {
	ExpressionParser * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	Parser* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = (ExpressionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = name;
	_tmp1_ = PARSER_CLASS (expression_parser_parent_class)->function_is_defined (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PARSER, Parser), _tmp0_);
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp2_ = self->priv->_root_parser;
	_tmp3_ = name;
	_tmp4_ = parser_function_is_defined (_tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static void expression_parser_class_init (ExpressionParserClass * klass) {
	expression_parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = expression_parser_finalize;
	g_type_class_add_private (klass, sizeof (ExpressionParserPrivate));
	((ParserClass *) klass)->variable_is_defined = expression_parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = expression_parser_real_get_variable;
	((ParserClass *) klass)->function_is_defined = expression_parser_real_function_is_defined;
}


static void expression_parser_instance_init (ExpressionParser * self) {
	self->priv = EXPRESSION_PARSER_GET_PRIVATE (self);
}


static void expression_parser_finalize (Parser* obj) {
	ExpressionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXPRESSION_PARSER, ExpressionParser);
	_parser_unref0 (self->priv->_root_parser);
	PARSER_CLASS (expression_parser_parent_class)->finalize (obj);
}


GType expression_parser_get_type (void) {
	static volatile gsize expression_parser_type_id__volatile = 0;
	if (g_once_init_enter (&expression_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ExpressionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) expression_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExpressionParser), 0, (GInstanceInitFunc) expression_parser_instance_init, NULL };
		GType expression_parser_type_id;
		expression_parser_type_id = g_type_register_static (TYPE_PARSER, "ExpressionParser", &g_define_type_info, 0);
		g_once_init_leave (&expression_parser_type_id__volatile, expression_parser_type_id);
	}
	return expression_parser_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Number** _vala_array_dup5 (Number** self, int length) {
	Number** result;
	int i;
	result = g_new0 (Number*, length + 1);
	for (i = 0; i < length; i++) {
		Number* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


FunctionParser* function_parser_construct (GType object_type, MathFunction* function, Parser* root_parser, Number** parameters, int parameters_length1) {
	FunctionParser* self = NULL;
	MathFunction* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Parser* _tmp3_ = NULL;
	MathFunction* _tmp4_ = NULL;
	MathFunction* _tmp5_ = NULL;
	Number** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	Number** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_val_if_fail (function != NULL, NULL);
	_tmp0_ = function;
	_tmp1_ = math_function_get_expression (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = root_parser;
	self = (FunctionParser*) expression_parser_construct (object_type, _tmp2_, _tmp3_);
	_tmp4_ = function;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->_function);
	self->priv->_function = _tmp5_;
	_tmp6_ = parameters;
	_tmp6__length1 = parameters_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup5 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_parameters = _tmp7_;
	self->priv->_parameters_length1 = _tmp7__length1;
	self->priv->__parameters_size_ = self->priv->_parameters_length1;
	return self;
}


FunctionParser* function_parser_new (MathFunction* function, Parser* root_parser, Number** parameters, int parameters_length1) {
	return function_parser_construct (TYPE_FUNCTION_PARSER, function, root_parser, parameters, parameters_length1);
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean function_parser_real_variable_is_defined (Parser* base, const gchar* name) {
	FunctionParser * self;
	gboolean result = FALSE;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint argument_names_length1 = 0;
	gint _argument_names_size_ = 0;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	self = (FunctionParser*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->_function;
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup6 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	argument_names = _tmp3_;
	argument_names_length1 = _tmp3__length1;
	_argument_names_size_ = argument_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = argument_names;
				_tmp7__length1 = argument_names_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = argument_names;
				_tmp8__length1 = argument_names_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = name;
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
					result = TRUE;
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp12_ = name;
	_tmp13_ = PARSER_CLASS (function_parser_parent_class)->variable_is_defined ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), _tmp12_);
	result = _tmp13_;
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Number* function_parser_real_get_variable (Parser* base, const gchar* name) {
	FunctionParser * self;
	Number* result = NULL;
	gchar** argument_names = NULL;
	MathFunction* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint argument_names_length1 = 0;
	gint _argument_names_size_ = 0;
	const gchar* _tmp18_ = NULL;
	Number* _tmp19_ = NULL;
	self = (FunctionParser*) base;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->_function;
	_tmp1_ = math_function_get_arguments (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup7 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	argument_names = _tmp3_;
	argument_names_length1 = _tmp3__length1;
	_argument_names_size_ = argument_names_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = argument_names;
				_tmp7__length1 = argument_names_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = argument_names;
				_tmp8__length1 = argument_names_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = name;
				if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
					Number** _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					gint _tmp13_ = 0;
					_tmp12_ = self->priv->_parameters;
					_tmp12__length1 = self->priv->_parameters_length1;
					_tmp13_ = i;
					if (_tmp12__length1 > _tmp13_) {
						Number** _tmp14_ = NULL;
						gint _tmp14__length1 = 0;
						gint _tmp15_ = 0;
						Number* _tmp16_ = NULL;
						Number* _tmp17_ = NULL;
						_tmp14_ = self->priv->_parameters;
						_tmp14__length1 = self->priv->_parameters_length1;
						_tmp15_ = i;
						_tmp16_ = _tmp14_[_tmp15_];
						_tmp17_ = _g_object_ref0 (_tmp16_);
						result = _tmp17_;
						argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					result = NULL;
					argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp18_ = name;
	_tmp19_ = PARSER_CLASS (function_parser_parent_class)->get_variable ((Parser*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_EXPRESSION_PARSER, ExpressionParser), _tmp18_);
	result = _tmp19_;
	argument_names = (_vala_array_free (argument_names, argument_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void function_parser_class_init (FunctionParserClass * klass) {
	function_parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = function_parser_finalize;
	g_type_class_add_private (klass, sizeof (FunctionParserPrivate));
	((ParserClass *) klass)->variable_is_defined = function_parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = function_parser_real_get_variable;
}


static void function_parser_instance_init (FunctionParser * self) {
	self->priv = FUNCTION_PARSER_GET_PRIVATE (self);
}


static void function_parser_finalize (Parser* obj) {
	FunctionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FUNCTION_PARSER, FunctionParser);
	self->priv->_parameters = (_vala_array_free (self->priv->_parameters, self->priv->_parameters_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_function);
	PARSER_CLASS (function_parser_parent_class)->finalize (obj);
}


GType function_parser_get_type (void) {
	static volatile gsize function_parser_type_id__volatile = 0;
	if (g_once_init_enter (&function_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FunctionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionParser), 0, (GInstanceInitFunc) function_parser_instance_init, NULL };
		GType function_parser_type_id;
		function_parser_type_id = g_type_register_static (TYPE_EXPRESSION_PARSER, "FunctionParser", &g_define_type_info, 0);
		g_once_init_leave (&function_parser_type_id__volatile, function_parser_type_id);
	}
	return function_parser_type_id__volatile;
}


BuiltInMathFunction* built_in_math_function_construct (GType object_type, const gchar* function_name, const gchar* description) {
	BuiltInMathFunction * self = NULL;
	gchar** arguments = NULL;
	gchar** _tmp0_ = NULL;
	gint arguments_length1 = 0;
	gint _arguments_size_ = 0;
	gchar* expression = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_val_if_fail (function_name != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	arguments = _tmp0_;
	arguments_length1 = 0;
	_arguments_size_ = arguments_length1;
	_tmp1_ = g_strdup ("");
	expression = _tmp1_;
	_tmp2_ = function_name;
	_tmp3_ = description;
	self = (BuiltInMathFunction*) math_function_construct (object_type, _tmp2_, arguments, arguments_length1, expression, _tmp3_);
	_g_free0 (expression);
	arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


BuiltInMathFunction* built_in_math_function_new (const gchar* function_name, const gchar* description) {
	return built_in_math_function_construct (TYPE_BUILT_IN_MATH_FUNCTION, function_name, description);
}


static Number* built_in_math_function_real_evaluate (MathFunction* base, Number** args, int args_length1, Parser* root_parser) {
	BuiltInMathFunction * self;
	Number* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	Number** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Parser* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	self = (BuiltInMathFunction*) base;
	_tmp0_ = math_function_get_name ((MathFunction*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = root_parser;
	_tmp4_ = evaluate_built_in_function (_tmp1_, _tmp2_, _tmp2__length1, _tmp3_);
	result = _tmp4_;
	return result;
}


static gboolean built_in_math_function_real_is_custom_function (MathFunction* base) {
	BuiltInMathFunction * self;
	gboolean result = FALSE;
	self = (BuiltInMathFunction*) base;
	result = FALSE;
	return result;
}


static void built_in_math_function_class_init (BuiltInMathFunctionClass * klass) {
	built_in_math_function_parent_class = g_type_class_peek_parent (klass);
	((MathFunctionClass *) klass)->evaluate = built_in_math_function_real_evaluate;
	((MathFunctionClass *) klass)->is_custom_function = built_in_math_function_real_is_custom_function;
}


static void built_in_math_function_instance_init (BuiltInMathFunction * self) {
}


GType built_in_math_function_get_type (void) {
	static volatile gsize built_in_math_function_type_id__volatile = 0;
	if (g_once_init_enter (&built_in_math_function_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuiltInMathFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) built_in_math_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuiltInMathFunction), 0, (GInstanceInitFunc) built_in_math_function_instance_init, NULL };
		GType built_in_math_function_type_id;
		built_in_math_function_type_id = g_type_register_static (TYPE_MATH_FUNCTION, "BuiltInMathFunction", &g_define_type_info, 0);
		g_once_init_leave (&built_in_math_function_type_id__volatile, built_in_math_function_type_id);
	}
	return built_in_math_function_type_id__volatile;
}


Number* evaluate_built_in_function (const gchar* name, Number** args, int args_length1, Parser* root_parser) {
	Number* result = NULL;
	gchar* lower_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	Number* x = NULL;
	Number** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	Number* _tmp3_ = NULL;
	Number* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
	lower_name = _tmp1_;
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	x = _tmp4_;
	_tmp5_ = lower_name;
	if (g_strcmp0 (_tmp5_, "log") == 0) {
		Number** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = args;
		_tmp6__length1 = args_length1;
		if (_tmp6__length1 <= 1) {
			Number* _tmp7_ = NULL;
			Number* _tmp8_ = NULL;
			_tmp7_ = x;
			_tmp8_ = number_logarithm (_tmp7_, (gint64) 10);
			result = _tmp8_;
			_g_object_unref0 (x);
			_g_free0 (lower_name);
			return result;
		} else {
			gint64 log_base = 0LL;
			Number** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			Number* _tmp10_ = NULL;
			gint64 _tmp11_ = 0LL;
			gint64 _tmp12_ = 0LL;
			_tmp9_ = args;
			_tmp9__length1 = args_length1;
			_tmp10_ = _tmp9_[1];
			_tmp11_ = number_to_integer (_tmp10_);
			log_base = _tmp11_;
			_tmp12_ = log_base;
			if (_tmp12_ < ((gint64) 0)) {
				result = NULL;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			} else {
				Number* _tmp13_ = NULL;
				gint64 _tmp14_ = 0LL;
				Number* _tmp15_ = NULL;
				_tmp13_ = x;
				_tmp14_ = log_base;
				_tmp15_ = number_logarithm (_tmp13_, _tmp14_);
				result = _tmp15_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			}
		}
	} else {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = lower_name;
		if (g_strcmp0 (_tmp16_, "ln") == 0) {
			Number* _tmp17_ = NULL;
			Number* _tmp18_ = NULL;
			_tmp17_ = x;
			_tmp18_ = number_ln (_tmp17_);
			result = _tmp18_;
			_g_object_unref0 (x);
			_g_free0 (lower_name);
			return result;
		} else {
			const gchar* _tmp19_ = NULL;
			_tmp19_ = lower_name;
			if (g_strcmp0 (_tmp19_, "sqrt") == 0) {
				Number* _tmp20_ = NULL;
				Number* _tmp21_ = NULL;
				_tmp20_ = x;
				_tmp21_ = number_sqrt (_tmp20_);
				result = _tmp21_;
				_g_object_unref0 (x);
				_g_free0 (lower_name);
				return result;
			} else {
				const gchar* _tmp22_ = NULL;
				_tmp22_ = lower_name;
				if (g_strcmp0 (_tmp22_, "abs") == 0) {
					Number* _tmp23_ = NULL;
					Number* _tmp24_ = NULL;
					_tmp23_ = x;
					_tmp24_ = number_abs (_tmp23_);
					result = _tmp24_;
					_g_object_unref0 (x);
					_g_free0 (lower_name);
					return result;
				} else {
					const gchar* _tmp25_ = NULL;
					_tmp25_ = lower_name;
					if (g_strcmp0 (_tmp25_, "sgn") == 0) {
						Number* _tmp26_ = NULL;
						Number* _tmp27_ = NULL;
						_tmp26_ = x;
						_tmp27_ = number_sgn (_tmp26_);
						result = _tmp27_;
						_g_object_unref0 (x);
						_g_free0 (lower_name);
						return result;
					} else {
						const gchar* _tmp28_ = NULL;
						_tmp28_ = lower_name;
						if (g_strcmp0 (_tmp28_, "arg") == 0) {
							Number* _tmp29_ = NULL;
							Parser* _tmp30_ = NULL;
							AngleUnit _tmp31_ = 0;
							Number* _tmp32_ = NULL;
							_tmp29_ = x;
							_tmp30_ = root_parser;
							_tmp31_ = _tmp30_->angle_units;
							_tmp32_ = number_arg (_tmp29_, _tmp31_);
							result = _tmp32_;
							_g_object_unref0 (x);
							_g_free0 (lower_name);
							return result;
						} else {
							const gchar* _tmp33_ = NULL;
							_tmp33_ = lower_name;
							if (g_strcmp0 (_tmp33_, "conj") == 0) {
								Number* _tmp34_ = NULL;
								Number* _tmp35_ = NULL;
								_tmp34_ = x;
								_tmp35_ = number_conjugate (_tmp34_);
								result = _tmp35_;
								_g_object_unref0 (x);
								_g_free0 (lower_name);
								return result;
							} else {
								const gchar* _tmp36_ = NULL;
								_tmp36_ = lower_name;
								if (g_strcmp0 (_tmp36_, "int") == 0) {
									Number* _tmp37_ = NULL;
									Number* _tmp38_ = NULL;
									_tmp37_ = x;
									_tmp38_ = number_integer_component (_tmp37_);
									result = _tmp38_;
									_g_object_unref0 (x);
									_g_free0 (lower_name);
									return result;
								} else {
									const gchar* _tmp39_ = NULL;
									_tmp39_ = lower_name;
									if (g_strcmp0 (_tmp39_, "frac") == 0) {
										Number* _tmp40_ = NULL;
										Number* _tmp41_ = NULL;
										_tmp40_ = x;
										_tmp41_ = number_fractional_component (_tmp40_);
										result = _tmp41_;
										_g_object_unref0 (x);
										_g_free0 (lower_name);
										return result;
									} else {
										const gchar* _tmp42_ = NULL;
										_tmp42_ = lower_name;
										if (g_strcmp0 (_tmp42_, "floor") == 0) {
											Number* _tmp43_ = NULL;
											Number* _tmp44_ = NULL;
											_tmp43_ = x;
											_tmp44_ = number_floor (_tmp43_);
											result = _tmp44_;
											_g_object_unref0 (x);
											_g_free0 (lower_name);
											return result;
										} else {
											const gchar* _tmp45_ = NULL;
											_tmp45_ = lower_name;
											if (g_strcmp0 (_tmp45_, "ceil") == 0) {
												Number* _tmp46_ = NULL;
												Number* _tmp47_ = NULL;
												_tmp46_ = x;
												_tmp47_ = number_ceiling (_tmp46_);
												result = _tmp47_;
												_g_object_unref0 (x);
												_g_free0 (lower_name);
												return result;
											} else {
												const gchar* _tmp48_ = NULL;
												_tmp48_ = lower_name;
												if (g_strcmp0 (_tmp48_, "round") == 0) {
													Number* _tmp49_ = NULL;
													Number* _tmp50_ = NULL;
													_tmp49_ = x;
													_tmp50_ = number_round (_tmp49_);
													result = _tmp50_;
													_g_object_unref0 (x);
													_g_free0 (lower_name);
													return result;
												} else {
													const gchar* _tmp51_ = NULL;
													_tmp51_ = lower_name;
													if (g_strcmp0 (_tmp51_, "re") == 0) {
														Number* _tmp52_ = NULL;
														Number* _tmp53_ = NULL;
														_tmp52_ = x;
														_tmp53_ = number_real_component (_tmp52_);
														result = _tmp53_;
														_g_object_unref0 (x);
														_g_free0 (lower_name);
														return result;
													} else {
														const gchar* _tmp54_ = NULL;
														_tmp54_ = lower_name;
														if (g_strcmp0 (_tmp54_, "im") == 0) {
															Number* _tmp55_ = NULL;
															Number* _tmp56_ = NULL;
															_tmp55_ = x;
															_tmp56_ = number_imaginary_component (_tmp55_);
															result = _tmp56_;
															_g_object_unref0 (x);
															_g_free0 (lower_name);
															return result;
														} else {
															const gchar* _tmp57_ = NULL;
															_tmp57_ = lower_name;
															if (g_strcmp0 (_tmp57_, "sin") == 0) {
																Number* _tmp58_ = NULL;
																Parser* _tmp59_ = NULL;
																AngleUnit _tmp60_ = 0;
																Number* _tmp61_ = NULL;
																_tmp58_ = x;
																_tmp59_ = root_parser;
																_tmp60_ = _tmp59_->angle_units;
																_tmp61_ = number_sin (_tmp58_, _tmp60_);
																result = _tmp61_;
																_g_object_unref0 (x);
																_g_free0 (lower_name);
																return result;
															} else {
																const gchar* _tmp62_ = NULL;
																_tmp62_ = lower_name;
																if (g_strcmp0 (_tmp62_, "cos") == 0) {
																	Number* _tmp63_ = NULL;
																	Parser* _tmp64_ = NULL;
																	AngleUnit _tmp65_ = 0;
																	Number* _tmp66_ = NULL;
																	_tmp63_ = x;
																	_tmp64_ = root_parser;
																	_tmp65_ = _tmp64_->angle_units;
																	_tmp66_ = number_cos (_tmp63_, _tmp65_);
																	result = _tmp66_;
																	_g_object_unref0 (x);
																	_g_free0 (lower_name);
																	return result;
																} else {
																	const gchar* _tmp67_ = NULL;
																	_tmp67_ = lower_name;
																	if (g_strcmp0 (_tmp67_, "tan") == 0) {
																		Number* _tmp68_ = NULL;
																		Parser* _tmp69_ = NULL;
																		AngleUnit _tmp70_ = 0;
																		Number* _tmp71_ = NULL;
																		_tmp68_ = x;
																		_tmp69_ = root_parser;
																		_tmp70_ = _tmp69_->angle_units;
																		_tmp71_ = number_tan (_tmp68_, _tmp70_);
																		result = _tmp71_;
																		_g_object_unref0 (x);
																		_g_free0 (lower_name);
																		return result;
																	} else {
																		gboolean _tmp72_ = FALSE;
																		const gchar* _tmp73_ = NULL;
																		_tmp73_ = lower_name;
																		if (g_strcmp0 (_tmp73_, "sin⁻¹") == 0) {
																			_tmp72_ = TRUE;
																		} else {
																			const gchar* _tmp74_ = NULL;
																			_tmp74_ = lower_name;
																			_tmp72_ = g_strcmp0 (_tmp74_, "asin") == 0;
																		}
																		if (_tmp72_) {
																			Number* _tmp75_ = NULL;
																			Parser* _tmp76_ = NULL;
																			AngleUnit _tmp77_ = 0;
																			Number* _tmp78_ = NULL;
																			_tmp75_ = x;
																			_tmp76_ = root_parser;
																			_tmp77_ = _tmp76_->angle_units;
																			_tmp78_ = number_asin (_tmp75_, _tmp77_);
																			result = _tmp78_;
																			_g_object_unref0 (x);
																			_g_free0 (lower_name);
																			return result;
																		} else {
																			gboolean _tmp79_ = FALSE;
																			const gchar* _tmp80_ = NULL;
																			_tmp80_ = lower_name;
																			if (g_strcmp0 (_tmp80_, "cos⁻¹") == 0) {
																				_tmp79_ = TRUE;
																			} else {
																				const gchar* _tmp81_ = NULL;
																				_tmp81_ = lower_name;
																				_tmp79_ = g_strcmp0 (_tmp81_, "acos") == 0;
																			}
																			if (_tmp79_) {
																				Number* _tmp82_ = NULL;
																				Parser* _tmp83_ = NULL;
																				AngleUnit _tmp84_ = 0;
																				Number* _tmp85_ = NULL;
																				_tmp82_ = x;
																				_tmp83_ = root_parser;
																				_tmp84_ = _tmp83_->angle_units;
																				_tmp85_ = number_acos (_tmp82_, _tmp84_);
																				result = _tmp85_;
																				_g_object_unref0 (x);
																				_g_free0 (lower_name);
																				return result;
																			} else {
																				gboolean _tmp86_ = FALSE;
																				const gchar* _tmp87_ = NULL;
																				_tmp87_ = lower_name;
																				if (g_strcmp0 (_tmp87_, "tan⁻¹") == 0) {
																					_tmp86_ = TRUE;
																				} else {
																					const gchar* _tmp88_ = NULL;
																					_tmp88_ = lower_name;
																					_tmp86_ = g_strcmp0 (_tmp88_, "atan") == 0;
																				}
																				if (_tmp86_) {
																					Number* _tmp89_ = NULL;
																					Parser* _tmp90_ = NULL;
																					AngleUnit _tmp91_ = 0;
																					Number* _tmp92_ = NULL;
																					_tmp89_ = x;
																					_tmp90_ = root_parser;
																					_tmp91_ = _tmp90_->angle_units;
																					_tmp92_ = number_atan (_tmp89_, _tmp91_);
																					result = _tmp92_;
																					_g_object_unref0 (x);
																					_g_free0 (lower_name);
																					return result;
																				} else {
																					const gchar* _tmp93_ = NULL;
																					_tmp93_ = lower_name;
																					if (g_strcmp0 (_tmp93_, "sinh") == 0) {
																						Number* _tmp94_ = NULL;
																						Number* _tmp95_ = NULL;
																						_tmp94_ = x;
																						_tmp95_ = number_sinh (_tmp94_);
																						result = _tmp95_;
																						_g_object_unref0 (x);
																						_g_free0 (lower_name);
																						return result;
																					} else {
																						const gchar* _tmp96_ = NULL;
																						_tmp96_ = lower_name;
																						if (g_strcmp0 (_tmp96_, "cosh") == 0) {
																							Number* _tmp97_ = NULL;
																							Number* _tmp98_ = NULL;
																							_tmp97_ = x;
																							_tmp98_ = number_cosh (_tmp97_);
																							result = _tmp98_;
																							_g_object_unref0 (x);
																							_g_free0 (lower_name);
																							return result;
																						} else {
																							const gchar* _tmp99_ = NULL;
																							_tmp99_ = lower_name;
																							if (g_strcmp0 (_tmp99_, "tanh") == 0) {
																								Number* _tmp100_ = NULL;
																								Number* _tmp101_ = NULL;
																								_tmp100_ = x;
																								_tmp101_ = number_tanh (_tmp100_);
																								result = _tmp101_;
																								_g_object_unref0 (x);
																								_g_free0 (lower_name);
																								return result;
																							} else {
																								gboolean _tmp102_ = FALSE;
																								const gchar* _tmp103_ = NULL;
																								_tmp103_ = lower_name;
																								if (g_strcmp0 (_tmp103_, "sinh⁻¹") == 0) {
																									_tmp102_ = TRUE;
																								} else {
																									const gchar* _tmp104_ = NULL;
																									_tmp104_ = lower_name;
																									_tmp102_ = g_strcmp0 (_tmp104_, "asinh") == 0;
																								}
																								if (_tmp102_) {
																									Number* _tmp105_ = NULL;
																									Number* _tmp106_ = NULL;
																									_tmp105_ = x;
																									_tmp106_ = number_asinh (_tmp105_);
																									result = _tmp106_;
																									_g_object_unref0 (x);
																									_g_free0 (lower_name);
																									return result;
																								} else {
																									gboolean _tmp107_ = FALSE;
																									const gchar* _tmp108_ = NULL;
																									_tmp108_ = lower_name;
																									if (g_strcmp0 (_tmp108_, "cosh⁻¹") == 0) {
																										_tmp107_ = TRUE;
																									} else {
																										const gchar* _tmp109_ = NULL;
																										_tmp109_ = lower_name;
																										_tmp107_ = g_strcmp0 (_tmp109_, "acosh") == 0;
																									}
																									if (_tmp107_) {
																										Number* _tmp110_ = NULL;
																										Number* _tmp111_ = NULL;
																										_tmp110_ = x;
																										_tmp111_ = number_acosh (_tmp110_);
																										result = _tmp111_;
																										_g_object_unref0 (x);
																										_g_free0 (lower_name);
																										return result;
																									} else {
																										gboolean _tmp112_ = FALSE;
																										const gchar* _tmp113_ = NULL;
																										_tmp113_ = lower_name;
																										if (g_strcmp0 (_tmp113_, "tanh⁻¹") == 0) {
																											_tmp112_ = TRUE;
																										} else {
																											const gchar* _tmp114_ = NULL;
																											_tmp114_ = lower_name;
																											_tmp112_ = g_strcmp0 (_tmp114_, "atanh") == 0;
																										}
																										if (_tmp112_) {
																											Number* _tmp115_ = NULL;
																											Number* _tmp116_ = NULL;
																											_tmp115_ = x;
																											_tmp116_ = number_atanh (_tmp115_);
																											result = _tmp116_;
																											_g_object_unref0 (x);
																											_g_free0 (lower_name);
																											return result;
																										} else {
																											const gchar* _tmp117_ = NULL;
																											_tmp117_ = lower_name;
																											if (g_strcmp0 (_tmp117_, "ones") == 0) {
																												Number* _tmp118_ = NULL;
																												Parser* _tmp119_ = NULL;
																												gint _tmp120_ = 0;
																												Number* _tmp121_ = NULL;
																												_tmp118_ = x;
																												_tmp119_ = root_parser;
																												_tmp120_ = _tmp119_->wordlen;
																												_tmp121_ = number_ones_complement (_tmp118_, _tmp120_);
																												result = _tmp121_;
																												_g_object_unref0 (x);
																												_g_free0 (lower_name);
																												return result;
																											} else {
																												const gchar* _tmp122_ = NULL;
																												_tmp122_ = lower_name;
																												if (g_strcmp0 (_tmp122_, "twos") == 0) {
																													Number* _tmp123_ = NULL;
																													Parser* _tmp124_ = NULL;
																													gint _tmp125_ = 0;
																													Number* _tmp126_ = NULL;
																													_tmp123_ = x;
																													_tmp124_ = root_parser;
																													_tmp125_ = _tmp124_->wordlen;
																													_tmp126_ = number_twos_complement (_tmp123_, _tmp125_);
																													result = _tmp126_;
																													_g_object_unref0 (x);
																													_g_free0 (lower_name);
																													return result;
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (x);
	_g_free0 (lower_name);
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



