/* utils.c generated by valac 0.34.0.3-63fa6, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gee.h>
#include <folks/folks.h>
#include <stdarg.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define FOLKS_INSPECT_TYPE_UTILS (folks_inspect_utils_get_type ())
#define FOLKS_INSPECT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils))
#define FOLKS_INSPECT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))
#define FOLKS_INSPECT_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))

typedef struct _FolksInspectUtils FolksInspectUtils;
typedef struct _FolksInspectUtilsClass FolksInspectUtilsClass;
typedef struct _FolksInspectUtilsPrivate FolksInspectUtilsPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;
typedef struct _FolksInspectParamSpecUtils FolksInspectParamSpecUtils;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksInspectUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectUtilsPrivate * priv;
};

struct _FolksInspectUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectUtils *self);
};

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectParamSpecUtils {
	GParamSpec parent_instance;
};


static gpointer folks_inspect_utils_parent_class = NULL;
static guint folks_inspect_utils_indentation;
static guint folks_inspect_utils_indentation = (guint) 0;
static gchar* folks_inspect_utils_indentation_string;
static gchar* folks_inspect_utils_indentation_string = NULL;
extern FILE* folks_inspect_utils_output_filestream;
FILE* folks_inspect_utils_output_filestream = NULL;
static GeeMapIterator* folks_inspect_utils_command_name_iter;
static GeeMapIterator* folks_inspect_utils_command_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_individual_id_iter;
static GeeMapIterator* folks_inspect_utils_individual_id_iter = NULL;
static GeeIterator* folks_inspect_utils_persona_uid_iter;
static GeeIterator* folks_inspect_utils_persona_uid_iter = NULL;
static GeeIterator* folks_inspect_utils_backend_name_iter;
static GeeIterator* folks_inspect_utils_backend_name_iter = NULL;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter;
static GeeMapIterator* folks_inspect_utils_persona_store_id_iter = NULL;
extern FolksInspectClient* main_client;

gpointer folks_inspect_utils_ref (gpointer instance);
void folks_inspect_utils_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_utils (GValue* value, gpointer v_object);
void folks_inspect_value_take_utils (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_utils (const GValue* value);
GType folks_inspect_utils_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_UTILS_DUMMY_PROPERTY
};
gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
void folks_inspect_utils_init (void);
static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_date_time_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_date_time_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
void folks_inspect_utils_indent (void);
void folks_inspect_utils_unindent (void);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas);
static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value);
void folks_inspect_utils_print_persona (FolksPersona* persona);
void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state);
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state);
gboolean folks_inspect_utils_validate_subcommand (const gchar* command, const gchar* command_string, const gchar* subcommand, gchar** valid_subcommands, int valid_subcommands_length1);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
FolksInspectUtils* folks_inspect_utils_new (void);
FolksInspectUtils* folks_inspect_utils_construct (GType object_type);
static void folks_inspect_utils_finalize (FolksInspectUtils* obj);


static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_object_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_persona_store_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_string_array_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_date_time_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_date_time_to_string (src_value, dest_value);
}


void folks_inspect_utils_init (void) {
	gchar* _tmp0_ = NULL;
	FILE* _tmp1_ = NULL;
	_tmp0_ = g_strdup ("");
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
	folks_inspect_utils_indentation = (guint) 0;
	_tmp1_ = stdout;
	folks_inspect_utils_output_filestream = _tmp1_;
	g_value_register_transform_func (G_TYPE_OBJECT, G_TYPE_STRING, _folks_inspect_utils_transform_object_to_string_gvalue_transform);
	g_value_register_transform_func (FOLKS_TYPE_PERSONA_STORE, G_TYPE_STRING, _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_STRV, G_TYPE_STRING, _folks_inspect_utils_transform_string_array_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_DATE_TIME, G_TYPE_STRING, _folks_inspect_utils_transform_date_time_to_string_gvalue_transform);
}


static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest) {
	GValue _vala_dest = {0};
	gchar* output = NULL;
	GObject* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GValue _tmp3_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = g_strdup_printf ("%p", _tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	output = NULL;
	g_value_init (&_tmp3_, G_TYPE_STRING);
	g_value_take_string (&_tmp3_, _tmp2_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp3_;
	_g_free0 (output);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest) {
	GValue _vala_dest = {0};
	FolksPersonaStore* store = NULL;
	GValue _tmp0_ = {0};
	FolksPersonaStore* _tmp1_ = NULL;
	gchar* output = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GValue _tmp10_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = *src;
	_tmp1_ = _g_object_ref0 (g_value_get_object (&_tmp0_));
	store = _tmp1_;
	_tmp2_ = folks_persona_store_get_type_id (store);
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_persona_store_get_id (store);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_persona_store_get_display_name (store);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%p: %s, %s (%s)", store, _tmp3_, _tmp5_, _tmp7_);
	output = _tmp8_;
	_tmp9_ = output;
	output = NULL;
	g_value_init (&_tmp10_, G_TYPE_STRING);
	g_value_take_string (&_tmp10_, _tmp9_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp10_;
	_g_free0 (output);
	_g_object_unref0 (store);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}


static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest) {
	GValue _vala_dest = {0};
	gchar** array = NULL;
	GValue _tmp0_ = {0};
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gchar* output = NULL;
	gchar* _tmp1_ = NULL;
	gboolean first = FALSE;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GValue _tmp15_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = *src;
	array = g_value_get_boxed (&_tmp0_);
	array_length1 = g_strv_length (g_value_get_boxed (&_tmp0_));
	_array_size_ = array_length1;
	_tmp1_ = g_strdup ("{ ");
	output = _tmp1_;
	first = TRUE;
	_tmp2_ = array;
	_tmp2__length1 = array_length1;
	{
		gchar** element_collection = NULL;
		gint element_collection_length1 = 0;
		gint _element_collection_size_ = 0;
		gint element_it = 0;
		element_collection = _tmp2_;
		element_collection_length1 = _tmp2__length1;
		for (element_it = 0; element_it < _tmp2__length1; element_it = element_it + 1) {
			gchar* _tmp3_ = NULL;
			gchar* element = NULL;
			_tmp3_ = g_strdup (element_collection[element_it]);
			element = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				_tmp4_ = first;
				if (_tmp4_ == FALSE) {
					const gchar* _tmp5_ = NULL;
					gchar* _tmp6_ = NULL;
					_tmp5_ = output;
					_tmp6_ = g_strconcat (_tmp5_, ", ", NULL);
					_g_free0 (output);
					output = _tmp6_;
				}
				_tmp7_ = output;
				_tmp8_ = element;
				_tmp9_ = g_strdup_printf ("'%s'", _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_tmp7_, _tmp10_, NULL);
				_g_free0 (output);
				output = _tmp11_;
				_g_free0 (_tmp10_);
				first = FALSE;
				_g_free0 (element);
			}
		}
	}
	_tmp12_ = output;
	_tmp13_ = g_strconcat (_tmp12_, " }", NULL);
	_g_free0 (output);
	output = _tmp13_;
	_tmp14_ = output;
	output = NULL;
	g_value_init (&_tmp15_, G_TYPE_STRING);
	g_value_take_string (&_tmp15_, _tmp14_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp15_;
	_g_free0 (output);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}


static void folks_inspect_utils_transform_date_time_to_string (GValue* src, GValue* dest) {
	GValue _vala_dest = {0};
	GDateTime* date_time = NULL;
	GValue _tmp0_ = {0};
	gchar* output = NULL;
	gchar* _tmp1_ = NULL;
	GDateTime* _tmp2_ = NULL;
	gchar* _tmp5_ = NULL;
	GValue _tmp6_ = {0};
	g_return_if_fail (src != NULL);
	_tmp0_ = *src;
	date_time = g_value_get_boxed (&_tmp0_);
	_tmp1_ = g_strdup ("(null)");
	output = _tmp1_;
	_tmp2_ = date_time;
	if (_tmp2_ != NULL) {
		GDateTime* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp3_ = date_time;
		_tmp4_ = g_date_time_format ((GDateTime*) _tmp3_, "%FT%T%z");
		_g_free0 (output);
		output = _tmp4_;
	}
	_tmp5_ = output;
	output = NULL;
	g_value_init (&_tmp6_, G_TYPE_STRING);
	g_value_take_string (&_tmp6_, _tmp5_);
	G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	_vala_dest = _tmp6_;
	_g_free0 (output);
	if (dest) {
		*dest = _vala_dest;
	} else {
		G_IS_VALUE (&_vala_dest) ? (g_value_unset (&_vala_dest), NULL) : NULL;
	}
}


void folks_inspect_utils_indent (void) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	_tmp0_ = folks_inspect_utils_indentation;
	folks_inspect_utils_indentation = _tmp0_ + 2;
	_tmp1_ = folks_inspect_utils_indentation;
	_tmp2_ = g_strnfill ((gsize) _tmp1_, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp2_;
}


void folks_inspect_utils_unindent (void) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	_tmp0_ = folks_inspect_utils_indentation;
	folks_inspect_utils_indentation = _tmp0_ - 2;
	_tmp1_ = folks_inspect_utils_indentation;
	_tmp2_ = g_strnfill ((gsize) _tmp1_, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp2_;
}


void folks_inspect_utils_print_line (const gchar* format, ...) {
	va_list valist = {0};
	gchar* output = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* str = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	FILE* _tmp4_ = NULL;
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = format;
	_tmp1_ = g_strdup_vprintf (_tmp0_, valist);
	output = _tmp1_;
	_tmp2_ = folks_inspect_utils_indentation_string;
	_tmp3_ = g_strdup_printf ("%s%s\n", _tmp2_, output);
	str = _tmp3_;
	_tmp4_ = folks_inspect_utils_output_filestream;
	fprintf (_tmp4_, "%s", str);
	_g_free0 (str);
	_g_free0 (output);
	va_end (valist);
}


void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas) {
	FolksIndividual* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	FolksIndividual* _tmp3_ = NULL;
	GeeSet* _tmp4_ = NULL;
	GeeSet* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GParamSpec** properties = NULL;
	FolksIndividual* _tmp8_ = NULL;
	GObjectClass* _tmp9_ = NULL;
	guint _tmp10_;
	GParamSpec** _tmp11_ = NULL;
	gint properties_length1 = 0;
	gint _properties_size_ = 0;
	GParamSpec** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gboolean _tmp33_ = FALSE;
	g_return_if_fail (individual != NULL);
	_tmp0_ = individual;
	_tmp1_ = folks_individual_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = individual;
	_tmp4_ = folks_individual_get_personas (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	folks_inspect_utils_print_line ("Individual '%s' with %u personas:", _tmp2_, (guint) _tmp7_);
	_tmp8_ = individual;
	_tmp9_ = G_OBJECT_GET_CLASS ((GObject*) _tmp8_);
	_tmp11_ = g_object_class_list_properties (_tmp9_, &_tmp10_);
	properties = _tmp11_;
	properties_length1 = _tmp10_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp12_ = properties;
	_tmp12__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp12_;
		pspec_collection_length1 = _tmp12__length1;
		for (pspec_it = 0; pspec_it < _tmp12__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
				GParamSpec* _tmp17_ = NULL;
				GType _tmp18_ = 0UL;
				GValue _tmp19_ = {0};
				GValue _tmp20_ = {0};
				FolksIndividual* _tmp21_ = NULL;
				GParamSpec* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				FolksIndividual* _tmp24_ = NULL;
				GType _tmp25_ = 0UL;
				GParamSpec* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				GValue _tmp28_ = {0};
				gchar* _tmp29_ = NULL;
				GParamSpec* _tmp30_ = NULL;
				const gchar* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				_tmp14_ = show_personas;
				if (_tmp14_ == TRUE) {
					GParamSpec* _tmp15_ = NULL;
					const gchar* _tmp16_ = NULL;
					_tmp15_ = pspec;
					_tmp16_ = g_param_spec_get_name (_tmp15_);
					_tmp13_ = g_strcmp0 (_tmp16_, "personas") == 0;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				_tmp17_ = pspec;
				_tmp18_ = _tmp17_->value_type;
				g_value_init (&_tmp19_, _tmp18_);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp19_;
				_tmp20_ = prop_value;
				_tmp21_ = individual;
				_tmp22_ = pspec;
				_tmp23_ = g_param_spec_get_name (_tmp22_);
				g_object_get_property ((GObject*) _tmp21_, _tmp23_, &prop_value);
				_tmp24_ = individual;
				_tmp25_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp24_);
				_tmp26_ = pspec;
				_tmp27_ = g_param_spec_get_name (_tmp26_);
				_tmp28_ = prop_value;
				_tmp29_ = folks_inspect_utils_property_to_string (_tmp25_, _tmp27_, &_tmp28_);
				_g_free0 (output_string);
				output_string = _tmp29_;
				_tmp30_ = pspec;
				_tmp31_ = g_param_spec_get_nick (_tmp30_);
				_tmp32_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp31_, _tmp32_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	_tmp33_ = show_personas;
	if (_tmp33_ == TRUE) {
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			GeeIterator* _persona_it = NULL;
			FolksIndividual* _tmp34_ = NULL;
			GeeSet* _tmp35_ = NULL;
			GeeSet* _tmp36_ = NULL;
			GeeIterator* _tmp37_ = NULL;
			_tmp34_ = individual;
			_tmp35_ = folks_individual_get_personas (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = gee_iterable_iterator ((GeeIterable*) _tmp36_);
			_persona_it = _tmp37_;
			while (TRUE) {
				GeeIterator* _tmp38_ = NULL;
				gboolean _tmp39_ = FALSE;
				FolksPersona* persona = NULL;
				GeeIterator* _tmp40_ = NULL;
				gpointer _tmp41_ = NULL;
				FolksPersona* _tmp42_ = NULL;
				_tmp38_ = _persona_it;
				_tmp39_ = gee_iterator_next (_tmp38_);
				if (!_tmp39_) {
					break;
				}
				_tmp40_ = _persona_it;
				_tmp41_ = gee_iterator_get (_tmp40_);
				persona = (FolksPersona*) _tmp41_;
				_tmp42_ = persona;
				folks_inspect_utils_print_persona (_tmp42_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
	properties = (g_free (properties), NULL);
}


void folks_inspect_utils_print_persona (FolksPersona* persona) {
	FolksPersona* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GParamSpec** properties = NULL;
	FolksPersona* _tmp3_ = NULL;
	GObjectClass* _tmp4_ = NULL;
	guint _tmp5_;
	GParamSpec** _tmp6_ = NULL;
	gint properties_length1 = 0;
	gint _properties_size_ = 0;
	GParamSpec** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_uid (_tmp0_);
	_tmp2_ = _tmp1_;
	folks_inspect_utils_print_line ("Persona '%s':", _tmp2_);
	_tmp3_ = persona;
	_tmp4_ = G_OBJECT_GET_CLASS ((GObject*) _tmp3_);
	_tmp6_ = g_object_class_list_properties (_tmp4_, &_tmp5_);
	properties = _tmp6_;
	properties_length1 = _tmp5_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp7_ = properties;
	_tmp7__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp7_;
		pspec_collection_length1 = _tmp7__length1;
		for (pspec_it = 0; pspec_it < _tmp7__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				GParamSpec* _tmp8_ = NULL;
				GType _tmp9_ = 0UL;
				GValue _tmp10_ = {0};
				GValue _tmp11_ = {0};
				FolksPersona* _tmp12_ = NULL;
				GParamSpec* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				FolksPersona* _tmp15_ = NULL;
				GType _tmp16_ = 0UL;
				GParamSpec* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				GValue _tmp19_ = {0};
				gchar* _tmp20_ = NULL;
				GParamSpec* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				_tmp8_ = pspec;
				_tmp9_ = _tmp8_->value_type;
				g_value_init (&_tmp10_, _tmp9_);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp10_;
				_tmp11_ = prop_value;
				_tmp12_ = persona;
				_tmp13_ = pspec;
				_tmp14_ = g_param_spec_get_name (_tmp13_);
				g_object_get_property ((GObject*) _tmp12_, _tmp14_, &prop_value);
				_tmp15_ = persona;
				_tmp16_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp15_);
				_tmp17_ = pspec;
				_tmp18_ = g_param_spec_get_name (_tmp17_);
				_tmp19_ = prop_value;
				_tmp20_ = folks_inspect_utils_property_to_string (_tmp16_, _tmp18_, &_tmp19_);
				_g_free0 (output_string);
				output_string = _tmp20_;
				_tmp21_ = pspec;
				_tmp22_ = g_param_spec_get_nick (_tmp21_);
				_tmp23_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp22_, _tmp23_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	properties = (g_free (properties), NULL);
}


void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas) {
	FolksPersonaStore* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	FolksPersonaStore* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	FolksPersonaStore* _tmp9_ = NULL;
	GeeMap* _tmp10_ = NULL;
	GeeMap* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GParamSpec** properties = NULL;
	FolksPersonaStore* _tmp14_ = NULL;
	GObjectClass* _tmp15_ = NULL;
	guint _tmp16_;
	GParamSpec** _tmp17_ = NULL;
	gint properties_length1 = 0;
	gint _properties_size_ = 0;
	GParamSpec** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gboolean _tmp39_ = FALSE;
	g_return_if_fail (store != NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_is_prepared (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == FALSE) {
		FolksPersonaStore* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		_tmp3_ = store;
		_tmp4_ = folks_persona_store_get_id (_tmp3_);
		_tmp5_ = _tmp4_;
		folks_inspect_utils_print_line ("Persona store '%s':", _tmp5_);
		folks_inspect_utils_indent ();
		folks_inspect_utils_print_line ("Not prepared.");
		folks_inspect_utils_unindent ();
		return;
	}
	_tmp6_ = store;
	_tmp7_ = folks_persona_store_get_id (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = store;
	_tmp10_ = folks_persona_store_get_personas (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = gee_map_get_size (_tmp11_);
	_tmp13_ = _tmp12_;
	folks_inspect_utils_print_line ("Persona store '%s' with %u personas:", _tmp8_, (guint) _tmp13_);
	_tmp14_ = store;
	_tmp15_ = G_OBJECT_GET_CLASS ((GObject*) _tmp14_);
	_tmp17_ = g_object_class_list_properties (_tmp15_, &_tmp16_);
	properties = _tmp17_;
	properties_length1 = _tmp16_;
	_properties_size_ = properties_length1;
	folks_inspect_utils_indent ();
	_tmp18_ = properties;
	_tmp18__length1 = properties_length1;
	{
		GParamSpec** pspec_collection = NULL;
		gint pspec_collection_length1 = 0;
		gint _pspec_collection_size_ = 0;
		gint pspec_it = 0;
		pspec_collection = _tmp18_;
		pspec_collection_length1 = _tmp18__length1;
		for (pspec_it = 0; pspec_it < _tmp18__length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec = NULL;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				GParamSpec* _tmp23_ = NULL;
				GType _tmp24_ = 0UL;
				GValue _tmp25_ = {0};
				GValue _tmp26_ = {0};
				FolksPersonaStore* _tmp27_ = NULL;
				GParamSpec* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				FolksPersonaStore* _tmp30_ = NULL;
				GType _tmp31_ = 0UL;
				GParamSpec* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				GValue _tmp34_ = {0};
				gchar* _tmp35_ = NULL;
				GParamSpec* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				const gchar* _tmp38_ = NULL;
				_tmp20_ = show_personas;
				if (_tmp20_ == TRUE) {
					GParamSpec* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					_tmp21_ = pspec;
					_tmp22_ = g_param_spec_get_name (_tmp21_);
					_tmp19_ = g_strcmp0 (_tmp22_, "personas") == 0;
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				_tmp23_ = pspec;
				_tmp24_ = _tmp23_->value_type;
				g_value_init (&_tmp25_, _tmp24_);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp25_;
				_tmp26_ = prop_value;
				_tmp27_ = store;
				_tmp28_ = pspec;
				_tmp29_ = g_param_spec_get_name (_tmp28_);
				g_object_get_property ((GObject*) _tmp27_, _tmp29_, &prop_value);
				_tmp30_ = store;
				_tmp31_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp30_);
				_tmp32_ = pspec;
				_tmp33_ = g_param_spec_get_name (_tmp32_);
				_tmp34_ = prop_value;
				_tmp35_ = folks_inspect_utils_property_to_string (_tmp31_, _tmp33_, &_tmp34_);
				_g_free0 (output_string);
				output_string = _tmp35_;
				_tmp36_ = pspec;
				_tmp37_ = g_param_spec_get_nick (_tmp36_);
				_tmp38_ = output_string;
				folks_inspect_utils_print_line ("%-20s  %s", _tmp37_, _tmp38_);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	_tmp39_ = show_personas;
	if (_tmp39_ == TRUE) {
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		{
			GeeIterator* _persona_it = NULL;
			FolksPersonaStore* _tmp40_ = NULL;
			GeeMap* _tmp41_ = NULL;
			GeeMap* _tmp42_ = NULL;
			GeeCollection* _tmp43_ = NULL;
			GeeCollection* _tmp44_ = NULL;
			GeeCollection* _tmp45_ = NULL;
			GeeIterator* _tmp46_ = NULL;
			GeeIterator* _tmp47_ = NULL;
			_tmp40_ = store;
			_tmp41_ = folks_persona_store_get_personas (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = gee_map_get_values (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = _tmp44_;
			_tmp46_ = gee_iterable_iterator ((GeeIterable*) _tmp45_);
			_tmp47_ = _tmp46_;
			_g_object_unref0 (_tmp45_);
			_persona_it = _tmp47_;
			while (TRUE) {
				GeeIterator* _tmp48_ = NULL;
				gboolean _tmp49_ = FALSE;
				FolksPersona* persona = NULL;
				GeeIterator* _tmp50_ = NULL;
				gpointer _tmp51_ = NULL;
				FolksPersona* _tmp52_ = NULL;
				_tmp48_ = _persona_it;
				_tmp49_ = gee_iterator_next (_tmp48_);
				if (!_tmp49_) {
					break;
				}
				_tmp50_ = _persona_it;
				_tmp51_ = gee_iterator_get (_tmp50_);
				persona = (FolksPersona*) _tmp51_;
				_tmp52_ = persona;
				folks_inspect_utils_print_persona (_tmp52_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
	properties = (g_free (properties), NULL);
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value) {
	gchar* result = NULL;
	gchar* output_string = NULL;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_ = 0UL;
	gboolean _tmp2_ = FALSE;
	GValue _tmp218_ = {0};
	gchar* _tmp219_ = NULL;
	g_return_val_if_fail (prop_name != NULL, NULL);
	g_return_val_if_fail (prop_value != NULL, NULL);
	_tmp1_ = object_type;
	_tmp2_ = g_type_is_a (_tmp1_, FOLKS_TYPE_INDIVIDUAL);
	if (_tmp2_) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = prop_name;
		_tmp0_ = g_strcmp0 (_tmp3_, "personas") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeSet* personas = NULL;
		GObject* _tmp4_ = NULL;
		GeeSet* _tmp5_ = NULL;
		GeeSet* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		_tmp4_ = g_value_get_object (prop_value);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_SET, GeeSet));
		personas = _tmp5_;
		_tmp6_ = personas;
		_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("List of %u personas", (guint) _tmp8_);
		result = _tmp9_;
		_g_object_unref0 (personas);
		_g_free0 (output_string);
		return result;
	} else {
		gboolean _tmp10_ = FALSE;
		GType _tmp11_ = 0UL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = object_type;
		_tmp12_ = g_type_is_a (_tmp11_, FOLKS_TYPE_PERSONA_STORE);
		if (_tmp12_) {
			const gchar* _tmp13_ = NULL;
			_tmp13_ = prop_name;
			_tmp10_ = g_strcmp0 (_tmp13_, "personas") == 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GeeMap* personas = NULL;
			GObject* _tmp14_ = NULL;
			GeeMap* _tmp15_ = NULL;
			GeeMap* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gchar* _tmp19_ = NULL;
			_tmp14_ = g_value_get_object (prop_value);
			_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_MAP, GeeMap));
			personas = _tmp15_;
			_tmp16_ = personas;
			_tmp17_ = gee_map_get_size (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf ("Set of %u personas", (guint) _tmp18_);
			result = _tmp19_;
			_g_object_unref0 (personas);
			_g_free0 (output_string);
			return result;
		} else {
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_ = NULL;
			_tmp23_ = prop_name;
			if (g_strcmp0 (_tmp23_, "groups") == 0) {
				_tmp22_ = TRUE;
			} else {
				const gchar* _tmp24_ = NULL;
				_tmp24_ = prop_name;
				_tmp22_ = g_strcmp0 (_tmp24_, "local-ids") == 0;
			}
			if (_tmp22_) {
				_tmp21_ = TRUE;
			} else {
				const gchar* _tmp25_ = NULL;
				_tmp25_ = prop_name;
				_tmp21_ = g_strcmp0 (_tmp25_, "supported-fields") == 0;
			}
			if (_tmp21_) {
				_tmp20_ = TRUE;
			} else {
				const gchar* _tmp26_ = NULL;
				_tmp26_ = prop_name;
				_tmp20_ = g_strcmp0 (_tmp26_, "anti-links") == 0;
			}
			if (_tmp20_) {
				GeeSet* groups = NULL;
				GObject* _tmp27_ = NULL;
				GeeSet* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gboolean first = FALSE;
				const gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				_tmp27_ = g_value_get_object (prop_value);
				_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_SET, GeeSet));
				groups = _tmp28_;
				_tmp29_ = g_strdup ("{ ");
				_g_free0 (output_string);
				output_string = _tmp29_;
				first = TRUE;
				{
					GeeIterator* _group_it = NULL;
					GeeSet* _tmp30_ = NULL;
					GeeIterator* _tmp31_ = NULL;
					_tmp30_ = groups;
					_tmp31_ = gee_iterable_iterator ((GeeIterable*) _tmp30_);
					_group_it = _tmp31_;
					while (TRUE) {
						GeeIterator* _tmp32_ = NULL;
						gboolean _tmp33_ = FALSE;
						gchar* group = NULL;
						GeeIterator* _tmp34_ = NULL;
						gpointer _tmp35_ = NULL;
						gboolean _tmp36_ = FALSE;
						const gchar* _tmp39_ = NULL;
						const gchar* _tmp40_ = NULL;
						gchar* _tmp41_ = NULL;
						gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						_tmp32_ = _group_it;
						_tmp33_ = gee_iterator_next (_tmp32_);
						if (!_tmp33_) {
							break;
						}
						_tmp34_ = _group_it;
						_tmp35_ = gee_iterator_get (_tmp34_);
						group = (gchar*) _tmp35_;
						_tmp36_ = first;
						if (_tmp36_ == FALSE) {
							const gchar* _tmp37_ = NULL;
							gchar* _tmp38_ = NULL;
							_tmp37_ = output_string;
							_tmp38_ = g_strconcat (_tmp37_, ", ", NULL);
							_g_free0 (output_string);
							output_string = _tmp38_;
						}
						_tmp39_ = output_string;
						_tmp40_ = group;
						_tmp41_ = g_strdup_printf ("'%s'", _tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
						_g_free0 (output_string);
						output_string = _tmp43_;
						_g_free0 (_tmp42_);
						first = FALSE;
						_g_free0 (group);
					}
					_g_object_unref0 (_group_it);
				}
				_tmp44_ = output_string;
				_tmp45_ = g_strconcat (_tmp44_, " }", NULL);
				_g_free0 (output_string);
				output_string = _tmp45_;
				result = output_string;
				_g_object_unref0 (groups);
				return result;
			} else {
				const gchar* _tmp46_ = NULL;
				_tmp46_ = prop_name;
				if (g_strcmp0 (_tmp46_, "avatar") == 0) {
					gchar* ret = NULL;
					GLoadableIcon* avatar = NULL;
					GObject* _tmp47_ = NULL;
					GLoadableIcon* _tmp48_ = NULL;
					gboolean _tmp49_ = FALSE;
					gboolean _tmp50_ = FALSE;
					GLoadableIcon* _tmp51_ = NULL;
					ret = NULL;
					_tmp47_ = g_value_get_object (prop_value);
					_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, g_loadable_icon_get_type (), GLoadableIcon));
					avatar = _tmp48_;
					_tmp51_ = avatar;
					if (_tmp51_ != NULL) {
						GLoadableIcon* _tmp52_ = NULL;
						_tmp52_ = avatar;
						_tmp50_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, g_file_icon_get_type ());
					} else {
						_tmp50_ = FALSE;
					}
					if (_tmp50_) {
						GLoadableIcon* _tmp53_ = NULL;
						GFile* _tmp54_ = NULL;
						_tmp53_ = avatar;
						_tmp54_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, g_file_icon_get_type (), GFileIcon));
						_tmp49_ = _tmp54_ != NULL;
					} else {
						_tmp49_ = FALSE;
					}
					if (_tmp49_) {
						GLoadableIcon* _tmp55_ = NULL;
						GLoadableIcon* _tmp56_ = NULL;
						GFile* _tmp57_ = NULL;
						gchar* _tmp58_ = NULL;
						gchar* _tmp59_ = NULL;
						gchar* _tmp60_ = NULL;
						_tmp55_ = avatar;
						_tmp56_ = avatar;
						_tmp57_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, g_file_icon_get_type (), GFileIcon));
						_tmp58_ = g_file_get_uri (_tmp57_);
						_tmp59_ = _tmp58_;
						_tmp60_ = g_strdup_printf ("%p (file: %s)", _tmp55_, _tmp59_);
						_g_free0 (ret);
						ret = _tmp60_;
						_g_free0 (_tmp59_);
					} else {
						GLoadableIcon* _tmp61_ = NULL;
						_tmp61_ = avatar;
						if (_tmp61_ != NULL) {
							GLoadableIcon* _tmp62_ = NULL;
							gchar* _tmp63_ = NULL;
							_tmp62_ = avatar;
							_tmp63_ = g_strdup_printf ("%p", _tmp62_);
							_g_free0 (ret);
							ret = _tmp63_;
						}
					}
					result = ret;
					_g_object_unref0 (avatar);
					_g_free0 (output_string);
					return result;
				} else {
					const gchar* _tmp64_ = NULL;
					_tmp64_ = prop_name;
					if (g_strcmp0 (_tmp64_, "file") == 0) {
						gchar* ret = NULL;
						GFile* file = NULL;
						GObject* _tmp65_ = NULL;
						GFile* _tmp66_ = NULL;
						GFile* _tmp67_ = NULL;
						ret = NULL;
						_tmp65_ = g_value_get_object (prop_value);
						_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, G_TYPE_FILE, GFile));
						file = _tmp66_;
						_tmp67_ = file;
						if (_tmp67_ != NULL) {
							GFile* _tmp68_ = NULL;
							GFile* _tmp69_ = NULL;
							gchar* _tmp70_ = NULL;
							gchar* _tmp71_ = NULL;
							gchar* _tmp72_ = NULL;
							_tmp68_ = file;
							_tmp69_ = file;
							_tmp70_ = g_file_get_uri (_tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = g_strdup_printf ("%p (file: %s)", _tmp68_, _tmp71_);
							_g_free0 (ret);
							ret = _tmp72_;
							_g_free0 (_tmp71_);
						}
						result = ret;
						_g_object_unref0 (file);
						_g_free0 (output_string);
						return result;
					} else {
						gboolean _tmp73_ = FALSE;
						const gchar* _tmp74_ = NULL;
						_tmp74_ = prop_name;
						if (g_strcmp0 (_tmp74_, "im-addresses") == 0) {
							_tmp73_ = TRUE;
						} else {
							const gchar* _tmp75_ = NULL;
							_tmp75_ = prop_name;
							_tmp73_ = g_strcmp0 (_tmp75_, "web-service-addresses") == 0;
						}
						if (_tmp73_) {
							GeeMultiMap* prop_list = NULL;
							GObject* _tmp76_ = NULL;
							GeeMultiMap* _tmp77_ = NULL;
							gchar* _tmp78_ = NULL;
							gboolean first = FALSE;
							const gchar* _tmp117_ = NULL;
							gchar* _tmp118_ = NULL;
							_tmp76_ = g_value_get_object (prop_value);
							_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
							prop_list = _tmp77_;
							_tmp78_ = g_strdup ("{ ");
							_g_free0 (output_string);
							output_string = _tmp78_;
							first = TRUE;
							{
								GeeIterator* _k_it = NULL;
								GeeMultiMap* _tmp79_ = NULL;
								GeeSet* _tmp80_ = NULL;
								GeeSet* _tmp81_ = NULL;
								GeeIterator* _tmp82_ = NULL;
								GeeIterator* _tmp83_ = NULL;
								_tmp79_ = prop_list;
								_tmp80_ = gee_multi_map_get_keys (_tmp79_);
								_tmp81_ = _tmp80_;
								_tmp82_ = gee_iterable_iterator ((GeeIterable*) _tmp81_);
								_tmp83_ = _tmp82_;
								_g_object_unref0 (_tmp81_);
								_k_it = _tmp83_;
								while (TRUE) {
									GeeIterator* _tmp84_ = NULL;
									gboolean _tmp85_ = FALSE;
									gchar* k = NULL;
									GeeIterator* _tmp86_ = NULL;
									gpointer _tmp87_ = NULL;
									gboolean _tmp88_ = FALSE;
									const gchar* _tmp91_ = NULL;
									const gchar* _tmp92_ = NULL;
									gchar* _tmp93_ = NULL;
									gchar* _tmp94_ = NULL;
									gchar* _tmp95_ = NULL;
									GeeCollection* v = NULL;
									GeeMultiMap* _tmp96_ = NULL;
									const gchar* _tmp97_ = NULL;
									GeeCollection* _tmp98_ = NULL;
									gboolean _first = FALSE;
									const gchar* _tmp115_ = NULL;
									gchar* _tmp116_ = NULL;
									_tmp84_ = _k_it;
									_tmp85_ = gee_iterator_next (_tmp84_);
									if (!_tmp85_) {
										break;
									}
									_tmp86_ = _k_it;
									_tmp87_ = gee_iterator_get (_tmp86_);
									k = (gchar*) _tmp87_;
									_tmp88_ = first;
									if (_tmp88_ == FALSE) {
										const gchar* _tmp89_ = NULL;
										gchar* _tmp90_ = NULL;
										_tmp89_ = output_string;
										_tmp90_ = g_strconcat (_tmp89_, ", ", NULL);
										_g_free0 (output_string);
										output_string = _tmp90_;
									}
									_tmp91_ = output_string;
									_tmp92_ = k;
									_tmp93_ = g_strdup_printf ("'%s' : { ", _tmp92_);
									_tmp94_ = _tmp93_;
									_tmp95_ = g_strconcat (_tmp91_, _tmp94_, NULL);
									_g_free0 (output_string);
									output_string = _tmp95_;
									_g_free0 (_tmp94_);
									first = FALSE;
									_tmp96_ = prop_list;
									_tmp97_ = k;
									_tmp98_ = gee_multi_map_get (_tmp96_, _tmp97_);
									v = _tmp98_;
									_first = TRUE;
									{
										GeeIterator* _a_it = NULL;
										GeeCollection* _tmp99_ = NULL;
										GeeIterator* _tmp100_ = NULL;
										_tmp99_ = v;
										_tmp100_ = gee_iterable_iterator ((GeeIterable*) _tmp99_);
										_a_it = _tmp100_;
										while (TRUE) {
											GeeIterator* _tmp101_ = NULL;
											gboolean _tmp102_ = FALSE;
											FolksAbstractFieldDetails* a = NULL;
											GeeIterator* _tmp103_ = NULL;
											gpointer _tmp104_ = NULL;
											gboolean _tmp105_ = FALSE;
											const gchar* _tmp108_ = NULL;
											FolksAbstractFieldDetails* _tmp109_ = NULL;
											gconstpointer _tmp110_ = NULL;
											const gchar* _tmp111_ = NULL;
											gchar* _tmp112_ = NULL;
											gchar* _tmp113_ = NULL;
											gchar* _tmp114_ = NULL;
											_tmp101_ = _a_it;
											_tmp102_ = gee_iterator_next (_tmp101_);
											if (!_tmp102_) {
												break;
											}
											_tmp103_ = _a_it;
											_tmp104_ = gee_iterator_get (_tmp103_);
											a = (FolksAbstractFieldDetails*) _tmp104_;
											_tmp105_ = _first;
											if (_tmp105_ == FALSE) {
												const gchar* _tmp106_ = NULL;
												gchar* _tmp107_ = NULL;
												_tmp106_ = output_string;
												_tmp107_ = g_strconcat (_tmp106_, ", ", NULL);
												_g_free0 (output_string);
												output_string = _tmp107_;
											}
											_tmp108_ = output_string;
											_tmp109_ = a;
											_tmp110_ = folks_abstract_field_details_get_value (_tmp109_);
											_tmp111_ = _tmp110_;
											_tmp112_ = g_strdup_printf ("'%s'", (const gchar*) _tmp111_);
											_tmp113_ = _tmp112_;
											_tmp114_ = g_strconcat (_tmp108_, _tmp113_, NULL);
											_g_free0 (output_string);
											output_string = _tmp114_;
											_g_free0 (_tmp113_);
											_first = FALSE;
											_g_object_unref0 (a);
										}
										_g_object_unref0 (_a_it);
									}
									_tmp115_ = output_string;
									_tmp116_ = g_strconcat (_tmp115_, " }", NULL);
									_g_free0 (output_string);
									output_string = _tmp116_;
									_g_object_unref0 (v);
									_g_free0 (k);
								}
								_g_object_unref0 (_k_it);
							}
							_tmp117_ = output_string;
							_tmp118_ = g_strconcat (_tmp117_, " }", NULL);
							_g_free0 (output_string);
							output_string = _tmp118_;
							result = output_string;
							_g_object_unref0 (prop_list);
							return result;
						} else {
							gboolean _tmp119_ = FALSE;
							gboolean _tmp120_ = FALSE;
							const gchar* _tmp121_ = NULL;
							_tmp121_ = prop_name;
							if (g_strcmp0 (_tmp121_, "email-addresses") == 0) {
								_tmp120_ = TRUE;
							} else {
								const gchar* _tmp122_ = NULL;
								_tmp122_ = prop_name;
								_tmp120_ = g_strcmp0 (_tmp122_, "phone-numbers") == 0;
							}
							if (_tmp120_) {
								_tmp119_ = TRUE;
							} else {
								const gchar* _tmp123_ = NULL;
								_tmp123_ = prop_name;
								_tmp119_ = g_strcmp0 (_tmp123_, "urls") == 0;
							}
							if (_tmp119_) {
								gchar* _tmp124_ = NULL;
								gboolean first = FALSE;
								GeeSet* prop_list = NULL;
								GObject* _tmp125_ = NULL;
								GeeSet* _tmp126_ = NULL;
								const gchar* _tmp141_ = NULL;
								gchar* _tmp142_ = NULL;
								_tmp124_ = g_strdup ("{ ");
								_g_free0 (output_string);
								output_string = _tmp124_;
								first = TRUE;
								_tmp125_ = g_value_get_object (prop_value);
								_tmp126_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, GEE_TYPE_SET, GeeSet));
								prop_list = _tmp126_;
								{
									GeeIterator* _p_it = NULL;
									GeeSet* _tmp127_ = NULL;
									GeeIterator* _tmp128_ = NULL;
									_tmp127_ = prop_list;
									_tmp128_ = gee_iterable_iterator ((GeeIterable*) _tmp127_);
									_p_it = _tmp128_;
									while (TRUE) {
										GeeIterator* _tmp129_ = NULL;
										gboolean _tmp130_ = FALSE;
										FolksAbstractFieldDetails* p = NULL;
										GeeIterator* _tmp131_ = NULL;
										gpointer _tmp132_ = NULL;
										gboolean _tmp133_ = FALSE;
										const gchar* _tmp136_ = NULL;
										FolksAbstractFieldDetails* _tmp137_ = NULL;
										gconstpointer _tmp138_ = NULL;
										const gchar* _tmp139_ = NULL;
										gchar* _tmp140_ = NULL;
										_tmp129_ = _p_it;
										_tmp130_ = gee_iterator_next (_tmp129_);
										if (!_tmp130_) {
											break;
										}
										_tmp131_ = _p_it;
										_tmp132_ = gee_iterator_get (_tmp131_);
										p = (FolksAbstractFieldDetails*) _tmp132_;
										_tmp133_ = first;
										if (!_tmp133_) {
											const gchar* _tmp134_ = NULL;
											gchar* _tmp135_ = NULL;
											_tmp134_ = output_string;
											_tmp135_ = g_strconcat (_tmp134_, ", ", NULL);
											_g_free0 (output_string);
											output_string = _tmp135_;
										}
										_tmp136_ = output_string;
										_tmp137_ = p;
										_tmp138_ = folks_abstract_field_details_get_value (_tmp137_);
										_tmp139_ = _tmp138_;
										_tmp140_ = g_strconcat (_tmp136_, (const gchar*) _tmp139_, NULL);
										_g_free0 (output_string);
										output_string = _tmp140_;
										first = FALSE;
										_g_object_unref0 (p);
									}
									_g_object_unref0 (_p_it);
								}
								_tmp141_ = output_string;
								_tmp142_ = g_strconcat (_tmp141_, " }", NULL);
								_g_free0 (output_string);
								output_string = _tmp142_;
								result = output_string;
								_g_object_unref0 (prop_list);
								return result;
							} else {
								const gchar* _tmp143_ = NULL;
								_tmp143_ = prop_name;
								if (g_strcmp0 (_tmp143_, "birthday") == 0) {
									GDateTime* dobj = NULL;
									void* _tmp144_ = NULL;
									GDateTime* _tmp145_ = NULL;
									_tmp144_ = g_value_get_boxed (prop_value);
									dobj = (GDateTime*) _tmp144_;
									_tmp145_ = dobj;
									if (_tmp145_ != NULL) {
										GDateTime* _tmp146_ = NULL;
										gchar* _tmp147_ = NULL;
										_tmp146_ = dobj;
										_tmp147_ = g_date_time_to_string (_tmp146_);
										result = _tmp147_;
										_g_free0 (output_string);
										return result;
									} else {
										gchar* _tmp148_ = NULL;
										_tmp148_ = g_strdup ("");
										result = _tmp148_;
										_g_free0 (output_string);
										return result;
									}
								} else {
									const gchar* _tmp149_ = NULL;
									_tmp149_ = prop_name;
									if (g_strcmp0 (_tmp149_, "postal-addresses") == 0) {
										gchar* _tmp150_ = NULL;
										gboolean first = FALSE;
										GeeSet* prop_list = NULL;
										GObject* _tmp151_ = NULL;
										GeeSet* _tmp152_ = NULL;
										const gchar* _tmp169_ = NULL;
										gchar* _tmp170_ = NULL;
										_tmp150_ = g_strdup ("{ ");
										_g_free0 (output_string);
										output_string = _tmp150_;
										first = TRUE;
										_tmp151_ = g_value_get_object (prop_value);
										_tmp152_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, GEE_TYPE_SET, GeeSet));
										prop_list = _tmp152_;
										{
											GeeIterator* _p_it = NULL;
											GeeSet* _tmp153_ = NULL;
											GeeIterator* _tmp154_ = NULL;
											_tmp153_ = prop_list;
											_tmp154_ = gee_iterable_iterator ((GeeIterable*) _tmp153_);
											_p_it = _tmp154_;
											while (TRUE) {
												GeeIterator* _tmp155_ = NULL;
												gboolean _tmp156_ = FALSE;
												FolksPostalAddressFieldDetails* p = NULL;
												GeeIterator* _tmp157_ = NULL;
												gpointer _tmp158_ = NULL;
												gboolean _tmp159_ = FALSE;
												const gchar* _tmp162_ = NULL;
												FolksPostalAddressFieldDetails* _tmp163_ = NULL;
												gconstpointer _tmp164_ = NULL;
												FolksPostalAddress* _tmp165_ = NULL;
												gchar* _tmp166_ = NULL;
												gchar* _tmp167_ = NULL;
												gchar* _tmp168_ = NULL;
												_tmp155_ = _p_it;
												_tmp156_ = gee_iterator_next (_tmp155_);
												if (!_tmp156_) {
													break;
												}
												_tmp157_ = _p_it;
												_tmp158_ = gee_iterator_get (_tmp157_);
												p = (FolksPostalAddressFieldDetails*) _tmp158_;
												_tmp159_ = first;
												if (!_tmp159_) {
													const gchar* _tmp160_ = NULL;
													gchar* _tmp161_ = NULL;
													_tmp160_ = output_string;
													_tmp161_ = g_strconcat (_tmp160_, ". ", NULL);
													_g_free0 (output_string);
													output_string = _tmp161_;
												}
												_tmp162_ = output_string;
												_tmp163_ = p;
												_tmp164_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp163_);
												_tmp165_ = _tmp164_;
												_tmp166_ = folks_postal_address_to_string ((FolksPostalAddress*) _tmp165_);
												_tmp167_ = _tmp166_;
												_tmp168_ = g_strconcat (_tmp162_, _tmp167_, NULL);
												_g_free0 (output_string);
												output_string = _tmp168_;
												_g_free0 (_tmp167_);
												first = FALSE;
												_g_object_unref0 (p);
											}
											_g_object_unref0 (_p_it);
										}
										_tmp169_ = output_string;
										_tmp170_ = g_strconcat (_tmp169_, " }", NULL);
										_g_free0 (output_string);
										output_string = _tmp170_;
										result = output_string;
										_g_object_unref0 (prop_list);
										return result;
									} else {
										const gchar* _tmp171_ = NULL;
										_tmp171_ = prop_name;
										if (g_strcmp0 (_tmp171_, "notes") == 0) {
											GeeSet* notes = NULL;
											GObject* _tmp172_ = NULL;
											GeeSet* _tmp173_ = NULL;
											gchar* _tmp174_ = NULL;
											gboolean first = FALSE;
											const gchar* _tmp189_ = NULL;
											gchar* _tmp190_ = NULL;
											_tmp172_ = g_value_get_object (prop_value);
											_tmp173_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp172_, GEE_TYPE_SET) ? ((GeeSet*) _tmp172_) : NULL);
											notes = _tmp173_;
											_tmp174_ = g_strdup ("{ ");
											_g_free0 (output_string);
											output_string = _tmp174_;
											first = TRUE;
											{
												GeeIterator* _note_it = NULL;
												GeeSet* _tmp175_ = NULL;
												GeeIterator* _tmp176_ = NULL;
												_tmp175_ = notes;
												_tmp176_ = gee_iterable_iterator ((GeeIterable*) _tmp175_);
												_note_it = _tmp176_;
												while (TRUE) {
													GeeIterator* _tmp177_ = NULL;
													gboolean _tmp178_ = FALSE;
													FolksNoteFieldDetails* note = NULL;
													GeeIterator* _tmp179_ = NULL;
													gpointer _tmp180_ = NULL;
													gboolean _tmp181_ = FALSE;
													const gchar* _tmp184_ = NULL;
													FolksNoteFieldDetails* _tmp185_ = NULL;
													const gchar* _tmp186_ = NULL;
													const gchar* _tmp187_ = NULL;
													gchar* _tmp188_ = NULL;
													_tmp177_ = _note_it;
													_tmp178_ = gee_iterator_next (_tmp177_);
													if (!_tmp178_) {
														break;
													}
													_tmp179_ = _note_it;
													_tmp180_ = gee_iterator_get (_tmp179_);
													note = (FolksNoteFieldDetails*) _tmp180_;
													_tmp181_ = first;
													if (!_tmp181_) {
														const gchar* _tmp182_ = NULL;
														gchar* _tmp183_ = NULL;
														_tmp182_ = output_string;
														_tmp183_ = g_strconcat (_tmp182_, ", ", NULL);
														_g_free0 (output_string);
														output_string = _tmp183_;
													}
													_tmp184_ = output_string;
													_tmp185_ = note;
													_tmp186_ = folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) _tmp185_);
													_tmp187_ = _tmp186_;
													_tmp188_ = g_strconcat (_tmp184_, _tmp187_, NULL);
													_g_free0 (output_string);
													output_string = _tmp188_;
													first = FALSE;
													_g_object_unref0 (note);
												}
												_g_object_unref0 (_note_it);
											}
											_tmp189_ = output_string;
											_tmp190_ = g_strconcat (_tmp189_, " }", NULL);
											_g_free0 (output_string);
											output_string = _tmp190_;
											result = output_string;
											_g_object_unref0 (notes);
											return result;
										} else {
											const gchar* _tmp191_ = NULL;
											_tmp191_ = prop_name;
											if (g_strcmp0 (_tmp191_, "roles") == 0) {
												GeeSet* roles = NULL;
												GObject* _tmp192_ = NULL;
												GeeSet* _tmp193_ = NULL;
												gchar* _tmp194_ = NULL;
												gboolean first = FALSE;
												const gchar* _tmp211_ = NULL;
												gchar* _tmp212_ = NULL;
												_tmp192_ = g_value_get_object (prop_value);
												_tmp193_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, GEE_TYPE_SET, GeeSet));
												roles = _tmp193_;
												_tmp194_ = g_strdup ("{ ");
												_g_free0 (output_string);
												output_string = _tmp194_;
												first = TRUE;
												{
													GeeIterator* _role_it = NULL;
													GeeSet* _tmp195_ = NULL;
													GeeIterator* _tmp196_ = NULL;
													_tmp195_ = roles;
													_tmp196_ = gee_iterable_iterator ((GeeIterable*) _tmp195_);
													_role_it = _tmp196_;
													while (TRUE) {
														GeeIterator* _tmp197_ = NULL;
														gboolean _tmp198_ = FALSE;
														FolksRoleFieldDetails* role = NULL;
														GeeIterator* _tmp199_ = NULL;
														gpointer _tmp200_ = NULL;
														gboolean _tmp201_ = FALSE;
														const gchar* _tmp204_ = NULL;
														FolksRoleFieldDetails* _tmp205_ = NULL;
														gconstpointer _tmp206_ = NULL;
														FolksRole* _tmp207_ = NULL;
														gchar* _tmp208_ = NULL;
														gchar* _tmp209_ = NULL;
														gchar* _tmp210_ = NULL;
														_tmp197_ = _role_it;
														_tmp198_ = gee_iterator_next (_tmp197_);
														if (!_tmp198_) {
															break;
														}
														_tmp199_ = _role_it;
														_tmp200_ = gee_iterator_get (_tmp199_);
														role = (FolksRoleFieldDetails*) _tmp200_;
														_tmp201_ = first;
														if (!_tmp201_) {
															const gchar* _tmp202_ = NULL;
															gchar* _tmp203_ = NULL;
															_tmp202_ = output_string;
															_tmp203_ = g_strconcat (_tmp202_, ", ", NULL);
															_g_free0 (output_string);
															output_string = _tmp203_;
														}
														_tmp204_ = output_string;
														_tmp205_ = role;
														_tmp206_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp205_);
														_tmp207_ = _tmp206_;
														_tmp208_ = folks_role_to_string ((FolksRole*) _tmp207_);
														_tmp209_ = _tmp208_;
														_tmp210_ = g_strconcat (_tmp204_, _tmp209_, NULL);
														_g_free0 (output_string);
														output_string = _tmp210_;
														_g_free0 (_tmp209_);
														first = FALSE;
														_g_object_unref0 (role);
													}
													_g_object_unref0 (_role_it);
												}
												_tmp211_ = output_string;
												_tmp212_ = g_strconcat (_tmp211_, " }", NULL);
												_g_free0 (output_string);
												output_string = _tmp212_;
												result = output_string;
												_g_object_unref0 (roles);
												return result;
											} else {
												const gchar* _tmp213_ = NULL;
												_tmp213_ = prop_name;
												if (g_strcmp0 (_tmp213_, "structured-name") == 0) {
													FolksStructuredName* sn = NULL;
													GObject* _tmp214_ = NULL;
													gchar* ret = NULL;
													FolksStructuredName* _tmp215_ = NULL;
													_tmp214_ = g_value_get_object (prop_value);
													sn = G_TYPE_CHECK_INSTANCE_CAST (_tmp214_, FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName);
													ret = NULL;
													_tmp215_ = sn;
													if (_tmp215_ != NULL) {
														FolksStructuredName* _tmp216_ = NULL;
														gchar* _tmp217_ = NULL;
														_tmp216_ = sn;
														_tmp217_ = folks_structured_name_to_string (_tmp216_);
														_g_free0 (ret);
														ret = _tmp217_;
													}
													result = ret;
													_g_free0 (output_string);
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp218_ = *prop_value;
	_tmp219_ = folks_inspect_utils_transform_value_to_string (&_tmp218_);
	result = _tmp219_;
	_g_free0 (output_string);
	return result;
}


gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value) {
	gchar* result = NULL;
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (prop_value != NULL, NULL);
	_tmp0_ = G_VALUE_TYPE (prop_value);
	_tmp1_ = g_value_type_transformable (_tmp0_, G_TYPE_STRING);
	if (_tmp1_) {
		GValue string_value = {0};
		GValue _tmp2_ = {0};
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		g_value_init (&_tmp2_, G_TYPE_STRING);
		string_value = _tmp2_;
		g_value_transform (prop_value, &string_value);
		_tmp3_ = g_value_get_string (&string_value);
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		G_IS_VALUE (&string_value) ? (g_value_unset (&string_value), NULL) : NULL;
		return result;
	} else {
		GType _tmp5_ = 0UL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp5_ = G_VALUE_TYPE (prop_value);
		_tmp6_ = g_type_name (_tmp5_);
		_tmp7_ = g_type_name (G_TYPE_STRING);
		_tmp8_ = g_strdup_printf ("Can't convert from type '%s' to '%s'", _tmp6_, _tmp7_);
		result = _tmp8_;
		return result;
	}
}


gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_ = NULL;
		GeeHashMap* _tmp2_ = NULL;
		GeeMapIterator* _tmp3_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = _tmp1_->commands;
		_tmp3_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp2_);
		_g_object_unref0 (folks_inspect_utils_command_name_iter);
		folks_inspect_utils_command_name_iter = _tmp3_;
	}
	while (TRUE) {
		GeeMapIterator* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gchar* command_name = NULL;
		GeeMapIterator* _tmp6_ = NULL;
		gpointer _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp4_ = folks_inspect_utils_command_name_iter;
		_tmp5_ = gee_map_iterator_next (_tmp4_);
		if (!(_tmp5_ == TRUE)) {
			break;
		}
		_tmp6_ = folks_inspect_utils_command_name_iter;
		_tmp7_ = gee_map_iterator_get_key (_tmp6_);
		command_name = (gchar*) _tmp7_;
		_tmp8_ = command_name;
		_tmp9_ = word;
		_tmp10_ = g_str_has_prefix (_tmp8_, _tmp9_);
		if (_tmp10_) {
			result = command_name;
			return result;
		}
		_g_free0 (command_name);
	}
	_g_object_unref0 (folks_inspect_utils_command_name_iter);
	folks_inspect_utils_command_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_ = NULL;
		FolksIndividualAggregator* _tmp2_ = NULL;
		FolksIndividualAggregator* _tmp3_ = NULL;
		GeeMap* _tmp4_ = NULL;
		GeeMap* _tmp5_ = NULL;
		GeeMapIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_aggregator (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_individual_aggregator_get_individuals (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_map_map_iterator (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp6_;
	}
	while (TRUE) {
		GeeMapIterator* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gchar* id = NULL;
		GeeMapIterator* _tmp9_ = NULL;
		gpointer _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp7_ = folks_inspect_utils_individual_id_iter;
		_tmp8_ = gee_map_iterator_next (_tmp7_);
		if (!(_tmp8_ == TRUE)) {
			break;
		}
		_tmp9_ = folks_inspect_utils_individual_id_iter;
		_tmp10_ = gee_map_iterator_get_key (_tmp9_);
		id = (gchar*) _tmp10_;
		_tmp11_ = id;
		_tmp12_ = word;
		_tmp13_ = g_str_has_prefix (_tmp11_, _tmp12_);
		if (_tmp13_) {
			result = id;
			return result;
		}
		_g_free0 (id);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_ = NULL;
		FolksIndividualAggregator* _tmp2_ = NULL;
		FolksIndividualAggregator* _tmp3_ = NULL;
		GeeMap* _tmp4_ = NULL;
		GeeMap* _tmp5_ = NULL;
		GeeMapIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_aggregator (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_individual_aggregator_get_individuals (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_map_map_iterator (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp6_;
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		GeeIterator* _tmp8_ = NULL;
		FolksIndividual* individual = NULL;
		GeeMapIterator* _tmp11_ = NULL;
		gpointer _tmp12_ = NULL;
		GeeIterator* _tmp13_ = NULL;
		_tmp8_ = folks_inspect_utils_persona_uid_iter;
		if (_tmp8_ != NULL) {
			_tmp7_ = TRUE;
		} else {
			GeeMapIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			_tmp9_ = folks_inspect_utils_individual_id_iter;
			_tmp10_ = gee_map_iterator_next (_tmp9_);
			_tmp7_ = _tmp10_ == TRUE;
		}
		if (!_tmp7_) {
			break;
		}
		_tmp11_ = folks_inspect_utils_individual_id_iter;
		_tmp12_ = gee_map_iterator_get_value (_tmp11_);
		individual = (FolksIndividual*) _tmp12_;
		_tmp13_ = folks_inspect_utils_persona_uid_iter;
		if (_tmp13_ == NULL) {
			FolksIndividual* _tmp14_ = NULL;
			FolksIndividual* _tmp15_ = NULL;
			GeeSet* _tmp16_ = NULL;
			GeeSet* _tmp17_ = NULL;
			GeeIterator* _tmp18_ = NULL;
			_tmp14_ = individual;
			_vala_assert (_tmp14_ != NULL, "individual != null");
			_tmp15_ = individual;
			_tmp16_ = folks_individual_get_personas (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
			_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
			folks_inspect_utils_persona_uid_iter = _tmp18_;
		}
		while (TRUE) {
			GeeIterator* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			FolksPersona* persona = NULL;
			GeeIterator* _tmp21_ = NULL;
			gpointer _tmp22_ = NULL;
			FolksPersona* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gboolean _tmp27_ = FALSE;
			_tmp19_ = folks_inspect_utils_persona_uid_iter;
			_tmp20_ = gee_iterator_next (_tmp19_);
			if (!_tmp20_) {
				break;
			}
			_tmp21_ = folks_inspect_utils_persona_uid_iter;
			_tmp22_ = gee_iterator_get (_tmp21_);
			persona = (FolksPersona*) _tmp22_;
			_tmp23_ = persona;
			_tmp24_ = folks_persona_get_uid (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = word;
			_tmp27_ = g_str_has_prefix (_tmp25_, _tmp26_);
			if (_tmp27_) {
				FolksPersona* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				gchar* _tmp31_ = NULL;
				_tmp28_ = persona;
				_tmp29_ = folks_persona_get_uid (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup (_tmp30_);
				result = _tmp31_;
				_g_object_unref0 (persona);
				_g_object_unref0 (individual);
				return result;
			}
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (folks_inspect_utils_persona_uid_iter);
		folks_inspect_utils_persona_uid_iter = NULL;
		_g_object_unref0 (individual);
	}
	_g_object_unref0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_ = NULL;
		FolksBackendStore* _tmp2_ = NULL;
		FolksBackendStore* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_backend_store (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_backend_store_list_backends (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	while (TRUE) {
		GeeIterator* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		FolksBackend* backend = NULL;
		GeeIterator* _tmp9_ = NULL;
		gpointer _tmp10_ = NULL;
		FolksBackend* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp7_ = folks_inspect_utils_backend_name_iter;
		_tmp8_ = gee_iterator_next (_tmp7_);
		if (!(_tmp8_ == TRUE)) {
			break;
		}
		_tmp9_ = folks_inspect_utils_backend_name_iter;
		_tmp10_ = gee_iterator_get (_tmp9_);
		backend = (FolksBackend*) _tmp10_;
		_tmp11_ = backend;
		_tmp12_ = folks_backend_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = word;
		_tmp15_ = g_str_has_prefix (_tmp13_, _tmp14_);
		if (_tmp15_) {
			FolksBackend* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			_tmp16_ = backend;
			_tmp17_ = folks_backend_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup (_tmp18_);
			result = _tmp19_;
			_g_object_unref0 (backend);
			return result;
		}
		_g_object_unref0 (backend);
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = state;
	if (_tmp0_ == 0) {
		FolksInspectClient* _tmp1_ = NULL;
		FolksBackendStore* _tmp2_ = NULL;
		FolksBackendStore* _tmp3_ = NULL;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_ = NULL;
		GeeIterator* _tmp6_ = NULL;
		_tmp1_ = main_client;
		_tmp2_ = folks_inspect_client_get_backend_store (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = folks_backend_store_list_backends (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		GeeMapIterator* _tmp8_ = NULL;
		GeeMapIterator* _tmp11_ = NULL;
		_tmp8_ = folks_inspect_utils_persona_store_id_iter;
		if (_tmp8_ != NULL) {
			_tmp7_ = TRUE;
		} else {
			GeeIterator* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			_tmp9_ = folks_inspect_utils_backend_name_iter;
			_tmp10_ = gee_iterator_next (_tmp9_);
			_tmp7_ = _tmp10_ == TRUE;
		}
		if (!_tmp7_) {
			break;
		}
		_tmp11_ = folks_inspect_utils_persona_store_id_iter;
		if (_tmp11_ == NULL) {
			FolksBackend* backend = NULL;
			GeeIterator* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			FolksBackend* _tmp14_ = NULL;
			GeeMap* _tmp15_ = NULL;
			GeeMap* _tmp16_ = NULL;
			GeeMapIterator* _tmp17_ = NULL;
			_tmp12_ = folks_inspect_utils_backend_name_iter;
			_tmp13_ = gee_iterator_get (_tmp12_);
			backend = (FolksBackend*) _tmp13_;
			_tmp14_ = backend;
			_tmp15_ = folks_backend_get_persona_stores (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = gee_map_map_iterator (_tmp16_);
			_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
			folks_inspect_utils_persona_store_id_iter = _tmp17_;
			_g_object_unref0 (backend);
		}
		while (TRUE) {
			GeeMapIterator* _tmp18_ = NULL;
			gboolean _tmp19_ = FALSE;
			gchar* id = NULL;
			GeeMapIterator* _tmp20_ = NULL;
			gpointer _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gboolean _tmp24_ = FALSE;
			_tmp18_ = folks_inspect_utils_persona_store_id_iter;
			_tmp19_ = gee_map_iterator_next (_tmp18_);
			if (!(_tmp19_ == TRUE)) {
				break;
			}
			_tmp20_ = folks_inspect_utils_persona_store_id_iter;
			_tmp21_ = gee_map_iterator_get_key (_tmp20_);
			id = (gchar*) _tmp21_;
			_tmp22_ = id;
			_tmp23_ = word;
			_tmp24_ = g_str_has_prefix (_tmp22_, _tmp23_);
			if (_tmp24_) {
				result = id;
				return result;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


gboolean folks_inspect_utils_validate_subcommand (const gchar* command, const gchar* command_string, const gchar* subcommand, gchar** valid_subcommands, int valid_subcommands_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_val_if_fail (command != NULL, FALSE);
	_tmp1_ = subcommand;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp2_ = subcommand;
		_tmp3_ = valid_subcommands;
		_tmp3__length1 = valid_subcommands_length1;
		_tmp0_ = _vala_string_array_contains (_tmp3_, _tmp3__length1, _tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = command_string;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = command_string;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = "";
	}
	_tmp7_ = command;
	folks_inspect_utils_print_line ("Unrecognised '%s' command '%s'.", _tmp7_, _tmp4_);
	folks_inspect_utils_print_line ("Valid commands:");
	folks_inspect_utils_indent ();
	_tmp8_ = valid_subcommands;
	_tmp8__length1 = valid_subcommands_length1;
	{
		gchar** c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp8_;
		c_collection_length1 = _tmp8__length1;
		for (c_it = 0; c_it < _tmp8__length1; c_it = c_it + 1) {
			gchar* _tmp9_ = NULL;
			gchar* c = NULL;
			_tmp9_ = g_strdup (c_collection[c_it]);
			c = _tmp9_;
			{
				const gchar* _tmp10_ = NULL;
				_tmp10_ = c;
				folks_inspect_utils_print_line ("%s", _tmp10_);
				_g_free0 (c);
			}
		}
	}
	folks_inspect_utils_unindent ();
	result = FALSE;
	return result;
}


FolksInspectUtils* folks_inspect_utils_construct (GType object_type) {
	FolksInspectUtils* self = NULL;
	self = (FolksInspectUtils*) g_type_create_instance (object_type);
	return self;
}


FolksInspectUtils* folks_inspect_utils_new (void) {
	return folks_inspect_utils_construct (FOLKS_INSPECT_TYPE_UTILS);
}


static void folks_inspect_value_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void folks_inspect_value_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		folks_inspect_utils_unref (value->data[0].v_pointer);
	}
}


static void folks_inspect_value_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer folks_inspect_value_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* folks_inspect_value_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FolksInspectUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* folks_inspect_value_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FolksInspectUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FolksInspectParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer folks_inspect_value_get_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}


void folks_inspect_value_set_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


void folks_inspect_value_take_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


static void folks_inspect_utils_class_init (FolksInspectUtilsClass * klass) {
	gchar* _tmp0_ = NULL;
	FILE* _tmp1_ = NULL;
	folks_inspect_utils_parent_class = g_type_class_peek_parent (klass);
	((FolksInspectUtilsClass *) klass)->finalize = folks_inspect_utils_finalize;
	_tmp0_ = g_strdup ("");
	folks_inspect_utils_indentation_string = _tmp0_;
	_tmp1_ = stdout;
	folks_inspect_utils_output_filestream = _tmp1_;
}


static void folks_inspect_utils_instance_init (FolksInspectUtils * self) {
	self->ref_count = 1;
}


static void folks_inspect_utils_finalize (FolksInspectUtils* obj) {
	FolksInspectUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils);
	g_signal_handlers_destroy (self);
}


GType folks_inspect_utils_get_type (void) {
	static volatile gsize folks_inspect_utils_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_utils_init, folks_inspect_value_utils_free_value, folks_inspect_value_utils_copy_value, folks_inspect_value_utils_peek_pointer, "p", folks_inspect_value_utils_collect_value, "p", folks_inspect_value_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectUtils), 0, (GInstanceInitFunc) folks_inspect_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType folks_inspect_utils_type_id;
		folks_inspect_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&folks_inspect_utils_type_id__volatile, folks_inspect_utils_type_id);
	}
	return folks_inspect_utils_type_id__volatile;
}


gpointer folks_inspect_utils_ref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void folks_inspect_utils_unref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



