// Generated by gmmproc 2.51.2 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/menushell.h>
#include <gtkmm/private/menushell_p.h>


/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtk/gtk.h>


namespace Gtk
{

// All ctors are manually implemented just to initialize accel_window_.

MenuShell::MenuShell()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Gtk::Container(Glib::ConstructParams(menushell_class_.init())),
  accel_window_ (nullptr)
{}

MenuShell::MenuShell(const Glib::ConstructParams& construct_params)
:
  Glib::ObjectBase(nullptr),
  Gtk::Container  (construct_params),
  accel_window_   (nullptr)
{}

MenuShell::MenuShell(GtkMenuShell* castitem)
:
  Gtk::Container((GtkContainer*) castitem),
  accel_window_ (nullptr)
{}

// Why do we need a custom dtor?
// We don't actually need it, but a gmmproc-generated destructor calls destroy_().
// That's unnecessary here. GtkMenuShell is an abstract base class. When ~MenuShell()
// is executed, destroy_() has already been called by the destructor of a subclass.
MenuShell::~MenuShell() noexcept
{}

void MenuShell::accelerate(Window& window)
{
  // accel_window_ is used by menuitems that are added to the menushell
  // after it has been accelerated.
  accel_window_ = &window;

  for(auto widget : get_children())
  {
    auto menuitem = dynamic_cast<MenuItem*>(widget);
    if (menuitem)
    {
      menuitem->accelerate(window);
    }
  }
}

void MenuShell::accelerate(Widget& parent)
{
  Gtk::Window* toplevel_window
      = dynamic_cast<Gtk::Window*>(parent.get_toplevel());
  if(toplevel_window)
    accelerate(*toplevel_window);
}

void MenuShell_Class::insert_vfunc_callback(GtkMenuShell* self, GtkWidget* child, int position)
{
  try
  {
    const auto obj = dynamic_cast<MenuShell*>(
        Glib::ObjectBase::_get_current_wrapper((GObject*) self));

    // If MenuShell is accelerated initialize accelerators of new MenuItem.
    if(obj && obj->accel_window_ && GTK_IS_MENU_ITEM(child))
    {
      Glib::wrap((GtkMenuItem*) child)->accelerate(*obj->accel_window_);
    }
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  const auto base = static_cast<GtkMenuShellClass*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)));

  if(base && base->insert)
    (*base->insert)(self, child, position);
}

} // namespace Gtk


namespace
{


static const Glib::SignalProxyInfo MenuShell_signal_deactivate_info =
{
  "deactivate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo MenuShell_signal_selection_done_info =
{
  "selection_done",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static gboolean MenuShell_signal_move_selected_callback(GtkMenuShell* self, gint p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<gboolean(int)>;

  auto obj = dynamic_cast<MenuShell*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean MenuShell_signal_move_selected_notify_callback(GtkMenuShell* self, gint p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(int)>;

  auto obj = dynamic_cast<MenuShell*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo MenuShell_signal_move_selected_info =
{
  "move-selected",
  (GCallback) &MenuShell_signal_move_selected_callback,
  (GCallback) &MenuShell_signal_move_selected_notify_callback
};


static void MenuShell_signal_insert_callback(GtkMenuShell* self, GtkWidget* p0,gint p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Widget*, int)>;

  auto obj = dynamic_cast<MenuShell*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, p1
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo MenuShell_signal_insert_info =
{
  "insert",
  (GCallback) &MenuShell_signal_insert_callback,
  (GCallback) &MenuShell_signal_insert_callback
};


} // anonymous namespace


namespace Glib
{

Gtk::MenuShell* wrap(GtkMenuShell* object, bool take_copy)
{
  return dynamic_cast<Gtk::MenuShell *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& MenuShell_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &MenuShell_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_menu_shell_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void MenuShell_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

    klass->insert = &insert_vfunc_callback;
  
  klass->deactivate = &deactivate_callback;
  klass->selection_done = &selection_done_callback;
  klass->move_selected = &move_selected_callback;
  klass->insert = &insert_callback;
}


void MenuShell_Class::deactivate_callback(GtkMenuShell* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_deactivate();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->deactivate)
    (*base->deactivate)(self);
}
void MenuShell_Class::selection_done_callback(GtkMenuShell* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_selection_done();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_done)
    (*base->selection_done)(self);
}
gboolean MenuShell_Class::move_selected_callback(GtkMenuShell* self, gint p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return obj->on_move_selected(p0
);
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->move_selected)
    return (*base->move_selected)(self, p0);

  using RType = gboolean;
  return RType();
}
void MenuShell_Class::insert_callback(GtkMenuShell* self, GtkWidget* p0, gint p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_insert(Glib::wrap(p0)
, p1
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->insert)
    (*base->insert)(self, p0, p1);
}


Glib::ObjectBase* MenuShell_Class::wrap_new(GObject* o)
{
  return manage(new MenuShell((GtkMenuShell*)(o)));

}


/* The implementation: */


MenuShell::MenuShell(MenuShell&& src) noexcept
: Gtk::Container(std::move(src))
{}

MenuShell& MenuShell::operator=(MenuShell&& src) noexcept
{
  Gtk::Container::operator=(std::move(src));
  return *this;
}

MenuShell::CppClassType MenuShell::menushell_class_; // initialize static member

GType MenuShell::get_type()
{
  return menushell_class_.init().get_type();
}


GType MenuShell::get_base_type()
{
  return gtk_menu_shell_get_type();
}


void MenuShell::append(MenuItem& child)
{
  gtk_menu_shell_append(gobj(), (child).Gtk::Widget::gobj());
}

void MenuShell::prepend(MenuItem& child)
{
  gtk_menu_shell_prepend(gobj(), (child).Gtk::Widget::gobj());
}

void MenuShell::insert(MenuItem& child, int position)
{
  gtk_menu_shell_insert(gobj(), (child).Gtk::Widget::gobj(), position);
}

void MenuShell::select_item(MenuItem& menu_item)
{
  gtk_menu_shell_select_item(gobj(), (menu_item).Gtk::Widget::gobj());
}

void MenuShell::deselect()
{
  gtk_menu_shell_deselect(gobj());
}

void MenuShell::activate_item(MenuItem& menu_item, bool force_deactivate)
{
  gtk_menu_shell_activate_item(gobj(), (menu_item).Gtk::Widget::gobj(), static_cast<int>(force_deactivate));
}

void MenuShell::select_first(bool search_sensitive)
{
  gtk_menu_shell_select_first(gobj(), static_cast<int>(search_sensitive));
}

void MenuShell::deactivate()
{
  gtk_menu_shell_deactivate(gobj());
}

void MenuShell::cancel()
{
  gtk_menu_shell_cancel(gobj());
}

bool MenuShell::get_take_focus() const
{
  return gtk_menu_shell_get_take_focus(const_cast<GtkMenuShell*>(gobj()));
}

void MenuShell::set_take_focus(bool take_focus)
{
  gtk_menu_shell_set_take_focus(gobj(), static_cast<int>(take_focus));
}

Widget* MenuShell::get_selected_item()
{
  return Glib::wrap(gtk_menu_shell_get_selected_item(gobj()));
}

const Widget* MenuShell::get_selected_item() const
{
  return Glib::wrap(gtk_menu_shell_get_selected_item(const_cast<GtkMenuShell*>(gobj())));
}

Widget* MenuShell::get_parent_shell()
{
  return Glib::wrap(gtk_menu_shell_get_parent_shell(gobj()));
}

const Widget* MenuShell::get_parent_shell() const
{
  return Glib::wrap(gtk_menu_shell_get_parent_shell(const_cast<GtkMenuShell*>(gobj())));
}

void MenuShell::bind_model(const Glib::RefPtr<Gio::MenuModel>& model, const Glib::ustring& action_namespace, bool with_separators)
{
  gtk_menu_shell_bind_model(gobj(), Glib::unwrap(model), action_namespace.empty() ? nullptr : action_namespace.c_str(), static_cast<int>(with_separators));
}

void MenuShell::bind_model(const Glib::RefPtr<Gio::MenuModel>& model, bool with_separators)
{
  gtk_menu_shell_bind_model(gobj(), Glib::unwrap(model), nullptr, static_cast<int>(with_separators));
}


Glib::SignalProxy<void()> MenuShell::signal_deactivate()
{
  return Glib::SignalProxy<void() >(this, &MenuShell_signal_deactivate_info);
}


Glib::SignalProxy<void()> MenuShell::signal_selection_done()
{
  return Glib::SignalProxy<void() >(this, &MenuShell_signal_selection_done_info);
}


Glib::SignalProxy<gboolean(int)> MenuShell::signal_move_selected()
{
  return Glib::SignalProxy<gboolean(int) >(this, &MenuShell_signal_move_selected_info);
}


Glib::SignalProxy<void(Widget*, int)> MenuShell::signal_insert()
{
  return Glib::SignalProxy<void(Widget*, int) >(this, &MenuShell_signal_insert_info);
}


Glib::PropertyProxy< bool > MenuShell::property_take_focus() 
{
  return Glib::PropertyProxy< bool >(this, "take-focus");
}

Glib::PropertyProxy_ReadOnly< bool > MenuShell::property_take_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "take-focus");
}


void Gtk::MenuShell::on_deactivate()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->deactivate)
    (*base->deactivate)(gobj());
}
void Gtk::MenuShell::on_selection_done()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_done)
    (*base->selection_done)(gobj());
}
gboolean Gtk::MenuShell::on_move_selected(int distance)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->move_selected)
    return (*base->move_selected)(gobj(),distance);

  using RType = gboolean;
  return RType();
}
void Gtk::MenuShell::on_insert(Widget* child, int position)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->insert)
    (*base->insert)(gobj(),(GtkWidget*)Glib::unwrap(child),position);
}


} // namespace Gtk


