// Generated by gmmproc 2.53.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/snapshot.h>
#include <gtkmm/private/snapshot_p.h>


/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>

/* Why reinterpret_cast<Snapshot*>(gobject) is needed:
 *
 * A Snapshot instance is in fact always a GtkSnapshot instance.
 * Unfortunately, GtkSnapshot cannot be a member of Snapshot,
 * because it is an opaque struct. Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Snapshot does not have any member data, and
 * it is impossible to derive from it. This is ensured by using final on the
 * class and by using = delete on the default constructor.
 * This trick is used also in classes declared as _CLASS_OPAQUE_REFCOUNTED.
 */

namespace Gtk
{

void Snapshot::push(bool keep_coordinates, const Glib::ustring& name)
{
  if (name.empty())
    gtk_snapshot_push(gobj(), keep_coordinates, nullptr);
  else
    gtk_snapshot_push(gobj(), keep_coordinates, "%s", name.c_str());
}

void Snapshot::push_cross_fade(double progress, const Glib::ustring& name)
{
  if (name.empty())
    gtk_snapshot_push_cross_fade(gobj(), progress, nullptr);
  else
    gtk_snapshot_push_cross_fade(gobj(), progress, "%s", name.c_str());
}

::Cairo::RefPtr< ::Cairo::Context> Snapshot::append_cairo(
  const graphene_rect_t* bounds, const Glib::ustring& name)
{
  cairo_t* cr = nullptr;
  if (name.empty())
    cr = gtk_snapshot_append_cairo(gobj(), bounds, nullptr);
  else
    cr = gtk_snapshot_append_cairo(gobj(), bounds, "%s", name.c_str());

  return ::Cairo::make_refptr_for_instance< ::Cairo::Context>(
    new ::Cairo::Context(cr, true /* has_reference */));
}

::Cairo::RefPtr< ::Cairo::Context> Snapshot::append_cairo(
  const Gdk::Rectangle& bounds, const Glib::ustring& name)
{
  graphene_rect_t rect;
  graphene_rect_init(&rect, bounds.get_x(), bounds.get_y(),
    bounds.get_width(), bounds.get_height());

  return append_cairo(&rect, name);
}

GtkSnapshot* Snapshot::gobj()
{
  return reinterpret_cast<GtkSnapshot*>(this);
}

const GtkSnapshot* Snapshot::gobj() const
{
  return reinterpret_cast<const GtkSnapshot*>(this);
}

} //namespace Gtk

namespace Glib
{

Gtk::Snapshot* wrap(GtkSnapshot* gobject)
{
  return reinterpret_cast<Gtk::Snapshot*>(gobject);
}

} //namespace Glib

namespace
{
} // anonymous namespace


namespace Gtk
{


void Snapshot::pop()
{
  gtk_snapshot_pop(gobj());
}

void Snapshot::offset(int x, int y)
{
  gtk_snapshot_offset(gobj(), x, y);
}

void Snapshot::get_offset(int& x, int& y) const
{
  gtk_snapshot_get_offset(const_cast<GtkSnapshot*>(gobj()), &(x), &(y));
}

bool Snapshot::clips_rect(const Gdk::Rectangle& bounds) const
{
  return gtk_snapshot_clips_rect(const_cast<GtkSnapshot*>(gobj()), (bounds).gobj());
}

void Snapshot::render_backgrount(const Glib::RefPtr<StyleContext>& context, double x, double y, double width, double height)
{
  gtk_snapshot_render_background(gobj(), Glib::unwrap(context), x, y, width, height);
}

void Snapshot::render_frame(const Glib::RefPtr<StyleContext>& context, double x, double y, double width, double height)
{
  gtk_snapshot_render_frame(gobj(), Glib::unwrap(context), x, y, width, height);
}

void Snapshot::render_focus(const Glib::RefPtr<StyleContext>& context, double x, double y, double width, double height)
{
  gtk_snapshot_render_focus(gobj(), Glib::unwrap(context), x, y, width, height);
}

void Snapshot::render_layout(const Glib::RefPtr<StyleContext>& context, double x, double y, const Glib::RefPtr<Pango::Layout>& layout)
{
  gtk_snapshot_render_layout(gobj(), Glib::unwrap(context), x, y, Glib::unwrap(layout));
}

void Snapshot::render_insertion_cursor(const Glib::RefPtr<StyleContext>& context, double x, double y, const Glib::RefPtr<Pango::Layout>& layout, int index, Pango::Direction direction)
{
  gtk_snapshot_render_insertion_cursor(gobj(), Glib::unwrap(context), x, y, Glib::unwrap(layout), index, ((PangoDirection)(direction)));
}

void Snapshot::render_icon(const Glib::RefPtr<StyleContext>& context, const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, double x, double y)
{
  gtk_snapshot_render_icon(gobj(), Glib::unwrap(context), Glib::unwrap(pixbuf), x, y);
}


} // namespace Gtk


