// Generated by gmmproc 2.53.2 -- DO NOT MODIFY!
#ifndef _GDKMM_CURSOR_H
#define _GDKMM_CURSOR_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gdkmm/display.h>
#include <gdkmm/pixbuf.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkCursor = struct _GdkCursor;
using GdkCursorClass = struct _GdkCursorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Cursor_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{

/** This represents a cursor.
 */

class Cursor : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Cursor;
  using CppClassType = Cursor_Class;
  using BaseObjectType = GdkCursor;
  using BaseClassType = GdkCursorClass;

  // noncopyable
  Cursor(const Cursor&) = delete;
  Cursor& operator=(const Cursor&) = delete;

private:  friend class Cursor_Class;
  static CppClassType cursor_class_;

protected:
  explicit Cursor(const Glib::ConstructParams& construct_params);
  explicit Cursor(GdkCursor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Cursor(Cursor&& src) noexcept;
  Cursor& operator=(Cursor&& src) noexcept;

  ~Cursor() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkCursor*       gobj()       { return reinterpret_cast<GdkCursor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkCursor* gobj() const { return reinterpret_cast<GdkCursor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkCursor* gobj_copy();

private:

   //We use DO_NOT_DERIVE_GTYPE because glib does not allow us to derive from a non-fundamental (abstract) type, for some reason.

protected:

  explicit Cursor(const Glib::RefPtr<Display>& display, const Glib::ustring& name);
  

public:
  /** @addtogroup gdkmmEnums gdkmm Enums and Flags */

  /** 
   *  @var Type X_CURSOR
   * ![](X_cursor.png).
   * 
   *  @var Type ARROW
   * ![](arrow.png).
   * 
   *  @var Type BASED_ARROW_DOWN
   * ![](based_arrow_down.png).
   * 
   *  @var Type BASED_ARROW_UP
   * ![](based_arrow_up.png).
   * 
   *  @var Type BOAT
   * ![](boat.png).
   * 
   *  @var Type BOGOSITY
   * ![](bogosity.png).
   * 
   *  @var Type BOTTOM_LEFT_CORNER
   * ![](bottom_left_corner.png).
   * 
   *  @var Type BOTTOM_RIGHT_CORNER
   * ![](bottom_right_corner.png).
   * 
   *  @var Type BOTTOM_SIDE
   * ![](bottom_side.png).
   * 
   *  @var Type BOTTOM_TEE
   * ![](bottom_tee.png).
   * 
   *  @var Type BOX_SPIRAL
   * ![](box_spiral.png).
   * 
   *  @var Type CENTER_PTR
   * ![](center_ptr.png).
   * 
   *  @var Type CIRCLE
   * ![](circle.png).
   * 
   *  @var Type CLOCK
   * ![](clock.png).
   * 
   *  @var Type COFFEE_MUG
   * ![](coffee_mug.png).
   * 
   *  @var Type CROSS
   * ![](cross.png).
   * 
   *  @var Type CROSS_REVERSE
   * ![](cross_reverse.png).
   * 
   *  @var Type CROSSHAIR
   * ![](crosshair.png).
   * 
   *  @var Type DIAMOND_CROSS
   * ![](diamond_cross.png).
   * 
   *  @var Type DOT
   * ![](dot.png).
   * 
   *  @var Type DOTBOX
   * ![](dotbox.png).
   * 
   *  @var Type DOUBLE_ARROW
   * ![](double_arrow.png).
   * 
   *  @var Type DRAFT_LARGE
   * ![](draft_large.png).
   * 
   *  @var Type DRAFT_SMALL
   * ![](draft_small.png).
   * 
   *  @var Type DRAPED_BOX
   * ![](draped_box.png).
   * 
   *  @var Type EXCHANGE
   * ![](exchange.png).
   * 
   *  @var Type FLEUR
   * ![](fleur.png).
   * 
   *  @var Type GOBBLER
   * ![](gobbler.png).
   * 
   *  @var Type GUMBY
   * ![](gumby.png).
   * 
   *  @var Type HAND1
   * ![](hand1.png).
   * 
   *  @var Type HAND2
   * ![](hand2.png).
   * 
   *  @var Type HEART
   * ![](heart.png).
   * 
   *  @var Type ICON
   * ![](icon.png).
   * 
   *  @var Type IRON_CROSS
   * ![](iron_cross.png).
   * 
   *  @var Type LEFT_PTR
   * ![](left_ptr.png).
   * 
   *  @var Type LEFT_SIDE
   * ![](left_side.png).
   * 
   *  @var Type LEFT_TEE
   * ![](left_tee.png).
   * 
   *  @var Type LEFTBUTTON
   * ![](leftbutton.png).
   * 
   *  @var Type LL_ANGLE
   * ![](ll_angle.png).
   * 
   *  @var Type LR_ANGLE
   * ![](lr_angle.png).
   * 
   *  @var Type MAN
   * ![](man.png).
   * 
   *  @var Type MIDDLEBUTTON
   * ![](middlebutton.png).
   * 
   *  @var Type MOUSE
   * ![](mouse.png).
   * 
   *  @var Type PENCIL
   * ![](pencil.png).
   * 
   *  @var Type PIRATE
   * ![](pirate.png).
   * 
   *  @var Type PLUS
   * ![](plus.png).
   * 
   *  @var Type QUESTION_ARROW
   * ![](question_arrow.png).
   * 
   *  @var Type RIGHT_PTR
   * ![](right_ptr.png).
   * 
   *  @var Type RIGHT_SIDE
   * ![](right_side.png).
   * 
   *  @var Type RIGHT_TEE
   * ![](right_tee.png).
   * 
   *  @var Type RIGHTBUTTON
   * ![](rightbutton.png).
   * 
   *  @var Type RTL_LOGO
   * ![](rtl_logo.png).
   * 
   *  @var Type SAILBOAT
   * ![](sailboat.png).
   * 
   *  @var Type SB_DOWN_ARROW
   * ![](sb_down_arrow.png).
   * 
   *  @var Type SB_H_DOUBLE_ARROW
   * ![](sb_h_double_arrow.png).
   * 
   *  @var Type SB_LEFT_ARROW
   * ![](sb_left_arrow.png).
   * 
   *  @var Type SB_RIGHT_ARROW
   * ![](sb_right_arrow.png).
   * 
   *  @var Type SB_UP_ARROW
   * ![](sb_up_arrow.png).
   * 
   *  @var Type SB_V_DOUBLE_ARROW
   * ![](sb_v_double_arrow.png).
   * 
   *  @var Type SHUTTLE
   * ![](shuttle.png).
   * 
   *  @var Type SIZING
   * ![](sizing.png).
   * 
   *  @var Type SPIDER
   * ![](spider.png).
   * 
   *  @var Type SPRAYCAN
   * ![](spraycan.png).
   * 
   *  @var Type STAR
   * ![](star.png).
   * 
   *  @var Type TARGET
   * ![](target.png).
   * 
   *  @var Type TCROSS
   * ![](tcross.png).
   * 
   *  @var Type TOP_LEFT_ARROW
   * ![](top_left_arrow.png).
   * 
   *  @var Type TOP_LEFT_CORNER
   * ![](top_left_corner.png).
   * 
   *  @var Type TOP_RIGHT_CORNER
   * ![](top_right_corner.png).
   * 
   *  @var Type TOP_SIDE
   * ![](top_side.png).
   * 
   *  @var Type TOP_TEE
   * ![](top_tee.png).
   * 
   *  @var Type TREK
   * ![](trek.png).
   * 
   *  @var Type UL_ANGLE
   * ![](ul_angle.png).
   * 
   *  @var Type UMBRELLA
   * ![](umbrella.png).
   * 
   *  @var Type UR_ANGLE
   * ![](ur_angle.png).
   * 
   *  @var Type WATCH
   * ![](watch.png).
   * 
   *  @var Type XTERM
   * ![](xterm.png).
   * 
   *  @var Type LAST_CURSOR
   * Last cursor type.
   * 
   *  @var Type BLANK_CURSOR
   * Blank cursor. @newin{2,16}
   * 
   *  @var Type CURSOR_IS_PIXMAP
   * Type of cursors constructed with
   * Gdk::Cursor::new_from_pixbuf().
   * 
   *  @enum Type
   * 
   * Predefined cursors.
   * 
   * Note that these IDs are directly taken from the X cursor font, and many
   * of these cursors are either not useful, or are not available on other platforms.
   * 
   * The recommended way to create cursors is to use Gdk::Cursor::new_from_name().
   *
   * @ingroup gdkmmEnums
   */
  enum class Type
  {
    X_CURSOR = 0,
    ARROW = 2,
    BASED_ARROW_DOWN = 4,
    BASED_ARROW_UP = 6,
    BOAT = 8,
    BOGOSITY = 10,
    BOTTOM_LEFT_CORNER = 12,
    BOTTOM_RIGHT_CORNER = 14,
    BOTTOM_SIDE = 16,
    BOTTOM_TEE = 18,
    BOX_SPIRAL = 20,
    CENTER_PTR = 22,
    CIRCLE = 24,
    CLOCK = 26,
    COFFEE_MUG = 28,
    CROSS = 30,
    CROSS_REVERSE = 32,
    CROSSHAIR = 34,
    DIAMOND_CROSS = 36,
    DOT = 38,
    DOTBOX = 40,
    DOUBLE_ARROW = 42,
    DRAFT_LARGE = 44,
    DRAFT_SMALL = 46,
    DRAPED_BOX = 48,
    EXCHANGE = 50,
    FLEUR = 52,
    GOBBLER = 54,
    GUMBY = 56,
    HAND1 = 58,
    HAND2 = 60,
    HEART = 62,
    ICON = 64,
    IRON_CROSS = 66,
    LEFT_PTR = 68,
    LEFT_SIDE = 70,
    LEFT_TEE = 72,
    LEFTBUTTON = 74,
    LL_ANGLE = 76,
    LR_ANGLE = 78,
    MAN = 80,
    MIDDLEBUTTON = 82,
    MOUSE = 84,
    PENCIL = 86,
    PIRATE = 88,
    PLUS = 90,
    QUESTION_ARROW = 92,
    RIGHT_PTR = 94,
    RIGHT_SIDE = 96,
    RIGHT_TEE = 98,
    RIGHTBUTTON = 100,
    RTL_LOGO = 102,
    SAILBOAT = 104,
    SB_DOWN_ARROW = 106,
    SB_H_DOUBLE_ARROW = 108,
    SB_LEFT_ARROW = 110,
    SB_RIGHT_ARROW = 112,
    SB_UP_ARROW = 114,
    SB_V_DOUBLE_ARROW = 116,
    SHUTTLE = 118,
    SIZING = 120,
    SPIDER = 122,
    SPRAYCAN = 124,
    STAR = 126,
    TARGET = 128,
    TCROSS = 130,
    TOP_LEFT_ARROW = 132,
    TOP_LEFT_CORNER = 134,
    TOP_RIGHT_CORNER = 136,
    TOP_SIDE = 138,
    TOP_TEE = 140,
    TREK = 142,
    UL_ANGLE = 144,
    UMBRELLA = 146,
    UR_ANGLE = 148,
    WATCH = 150,
    XTERM = 152,
    LAST_CURSOR = 153,
    BLANK_CURSOR = -2,
    CURSOR_IS_PIXMAP = -1
  };


  //We use _WRAP_METHOD() instead of _WRAP_CREATE() and constructors,
  //because the gdk_cursor_new_*() functions actually return existing instances sometimes,
  //but constructors assume that they own the instance.
  //And we would have to have to use the gdk_cursor_new_*() functions in the constructors anyway,
  //because they do more than just call g_object_new().
  
  /** Creates a new cursor from the set of builtin cursors.
   * 
   * @newin{2,2}
   * 
   * @param display The Gdk::Display for which the cursor will be created.
   * @param cursor_type Cursor to create.
   * @return A new Gdk::Cursor.
   */
  static Glib::RefPtr<Cursor> create(const Glib::RefPtr<Display>& display, Type cursor_type);
  
  /** Creates a new cursor from a pixbuf.
   * 
   * Not all GDK backends support RGBA cursors. If they are not
   * supported, a monochrome approximation will be displayed.
   * The functions Gdk::Display::supports_cursor_alpha() and
   * Gdk::Display::supports_cursor_color() can be used to determine
   * whether RGBA cursors are supported;
   * Gdk::Display::get_default_cursor_size() and
   * Gdk::Display::get_maximal_cursor_size() give information about
   * cursor sizes.
   * 
   * If @a x or @a y are `-1`, the pixbuf must have
   * options named “x_hot” and “y_hot”, resp., containing
   * integer values between `0` and the width resp. height of
   * the pixbuf. (Since: 3.0)
   * 
   * On the X backend, support for RGBA cursors requires a
   * sufficently new version of the X Render extension.
   * 
   * @newin{2,4}
   * 
   * @param display The Gdk::Display for which the cursor will be created.
   * @param pixbuf The Gdk::Pixbuf containing the cursor image.
   * @param x The horizontal offset of the “hotspot” of the cursor.
   * @param y The vertical offset of the “hotspot” of the cursor.
   * @return A new Gdk::Cursor.
   */
  static Glib::RefPtr<Cursor> create(const Glib::RefPtr<Display>& display, const Glib::RefPtr<Pixbuf>& pixbuf, int x, int y);

 
  /** Creates a new cursor from a cairo image surface.
   * 
   * Not all GDK backends support RGBA cursors. If they are not
   * supported, a monochrome approximation will be displayed.
   * The functions Gdk::Display::supports_cursor_alpha() and
   * Gdk::Display::supports_cursor_color() can be used to determine
   * whether RGBA cursors are supported;
   * Gdk::Display::get_default_cursor_size() and
   * Gdk::Display::get_maximal_cursor_size() give information about
   * cursor sizes.
   * 
   * On the X backend, support for RGBA cursors requires a
   * sufficently new version of the X Render extension.
   * 
   * @newin{3,10}
   * 
   * @param display The Gdk::Display for which the cursor will be created.
   * @param surface The cairo image surface containing the cursor pixel data.
   * @param x The horizontal offset of the “hotspot” of the cursor.
   * @param y The vertical offset of the “hotspot” of the cursor.
   * @return A new Gdk::Cursor.
   */
  static Glib::RefPtr<Cursor> create(const Glib::RefPtr<Display>& display, const ::Cairo::RefPtr< ::Cairo::Surface>& surface, double x, double y);

  
  /** Creates a new cursor by looking up @a name in the current cursor
   * theme.
   * 
   * A recommended set of cursor names that will work across different
   * platforms can be found in the CSS specification:
   * - "none"
   * - ![](default_cursor.png) "default"
   * - ![](help_cursor.png) "help"
   * - ![](pointer_cursor.png) "pointer"
   * - ![](context_menu_cursor.png) "context-menu"
   * - ![](progress_cursor.png) "progress"
   * - ![](wait_cursor.png) "wait"
   * - ![](cell_cursor.png) "cell"
   * - ![](crosshair_cursor.png) "crosshair"
   * - ![](text_cursor.png) "text"
   * - ![](vertical_text_cursor.png) "vertical-text"
   * - ![](alias_cursor.png) "alias"
   * - ![](copy_cursor.png) "copy"
   * - ![](no_drop_cursor.png) "no-drop"
   * - ![](move_cursor.png) "move"
   * - ![](not_allowed_cursor.png) "not-allowed"
   * - ![](grab_cursor.png) "grab"
   * - ![](grabbing_cursor.png) "grabbing"
   * - ![](all_scroll_cursor.png) "all-scroll"
   * - ![](col_resize_cursor.png) "col-resize"
   * - ![](row_resize_cursor.png) "row-resize"
   * - ![](n_resize_cursor.png) "n-resize"
   * - ![](e_resize_cursor.png) "e-resize"
   * - ![](s_resize_cursor.png) "s-resize"
   * - ![](w_resize_cursor.png) "w-resize"
   * - ![](ne_resize_cursor.png) "ne-resize"
   * - ![](nw_resize_cursor.png) "nw-resize"
   * - ![](sw_resize_cursor.png) "sw-resize"
   * - ![](se_resize_cursor.png) "se-resize"
   * - ![](ew_resize_cursor.png) "ew-resize"
   * - ![](ns_resize_cursor.png) "ns-resize"
   * - ![](nesw_resize_cursor.png) "nesw-resize"
   * - ![](nwse_resize_cursor.png) "nwse-resize"
   * - ![](zoom_in_cursor.png) "zoom-in"
   * - ![](zoom_out_cursor.png) "zoom-out"
   * 
   * 
   * @newin{2,8}
   * 
   * @param display The Gdk::Display for which the cursor will be created.
   * @param name The name of the cursor.
   * @return A new Gdk::Cursor, or <tt>nullptr</tt> if there is no
   * cursor with the given name.
   */
  static Glib::RefPtr<Cursor> create(const Glib::RefPtr<Display>& display, const Glib::ustring& name);

  
  /** Returns the display on which the Gdk::Cursor is defined.
   * 
   * @newin{2,2}
   * 
   * @return The Gdk::Display associated to @a cursor.
   */
  Glib::RefPtr<Display> get_display();
  
  /** Returns the display on which the Gdk::Cursor is defined.
   * 
   * @newin{2,2}
   * 
   * @return The Gdk::Display associated to @a cursor.
   */
  Glib::RefPtr<const Display> get_display() const;

  
  /** Returns a Gdk::Pixbuf with the image used to display the cursor.
   * 
   * Note that depending on the capabilities of the windowing system and 
   * on the cursor, GDK may not be able to obtain the image data. In this 
   * case, <tt>nullptr</tt> is returned.
   * 
   * @newin{2,8}
   * 
   * @return A Gdk::Pixbuf representing
   *  @a cursor, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_image();
  
  /** Returns a Gdk::Pixbuf with the image used to display the cursor.
   * 
   * Note that depending on the capabilities of the windowing system and 
   * on the cursor, GDK may not be able to obtain the image data. In this 
   * case, <tt>nullptr</tt> is returned.
   * 
   * @newin{2,8}
   * 
   * @return A Gdk::Pixbuf representing
   *  @a cursor, or <tt>nullptr</tt>.
   */
  Glib::RefPtr<const Gdk::Pixbuf> get_image() const;

  //TODO: Should this always be const?
 

  /** Returns a cairo image surface with the image used to display the cursor.
   * 
   * Note that depending on the capabilities of the windowing system and
   * on the cursor, GDK may not be able to obtain the image data. In this
   * case, <tt>nullptr</tt> is returned.
   * 
   * @newin{3,10}
   * 
   * @param x_hot Location to store the hotspot x position,
   * or <tt>nullptr</tt>.
   * @param y_hot Location to store the hotspot y position,
   * or <tt>nullptr</tt>.
   * @return A #cairo_surface_t
   * representing @a cursor, or <tt>nullptr</tt>.
   */
  ::Cairo::RefPtr< ::Cairo::Surface> get_surface(double& x_hot, double& y_hot);
  
  /** Returns a cairo image surface with the image used to display the cursor.
   * 
   * Note that depending on the capabilities of the windowing system and
   * on the cursor, GDK may not be able to obtain the image data. In this
   * case, <tt>nullptr</tt> is returned.
   * 
   * @newin{3,10}
   * 
   * @param x_hot Location to store the hotspot x position,
   * or <tt>nullptr</tt>.
   * @param y_hot Location to store the hotspot y position,
   * or <tt>nullptr</tt>.
   * @return A #cairo_surface_t
   * representing @a cursor, or <tt>nullptr</tt>.
   */
  ::Cairo::RefPtr<const ::Cairo::Surface> get_surface(double& x_hot, double& y_hot) const;

  
  /** Returns the cursor type for this cursor.
   * 
   * @newin{2,22}
   * 
   * @return A Gdk::Cursor::Type.
   */
  Type get_cursor_type() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} //namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Cursor::Type> : public Glib::Value_Enum<Gdk::Cursor::Type>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Cursor
   */
  Glib::RefPtr<Gdk::Cursor> wrap(GdkCursor* object, bool take_copy = false);
}


#endif /* _GDKMM_CURSOR_H */

