/* baobab-application.c generated by valac 0.38.1.8-0ab50-dirty, the Vala compiler
 * generated from baobab-application.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include "config.h"


#define BAOBAB_TYPE_APPLICATION (baobab_application_get_type ())
#define BAOBAB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplication))
#define BAOBAB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))
#define BAOBAB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))

typedef struct _BaobabApplication BaobabApplication;
typedef struct _BaobabApplicationClass BaobabApplicationClass;
typedef struct _BaobabApplicationPrivate BaobabApplicationPrivate;
enum  {
	BAOBAB_APPLICATION_DUMMY_PROPERTY,
	BAOBAB_APPLICATION_LAST_PROPERTY
};
static GParamSpec* baobab_application_properties[BAOBAB_APPLICATION_LAST_PROPERTY];

#define BAOBAB_TYPE_WINDOW (baobab_window_get_type ())
#define BAOBAB_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_WINDOW, BaobabWindow))
#define BAOBAB_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_WINDOW, BaobabWindowClass))
#define BAOBAB_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_WINDOW))
#define BAOBAB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_WINDOW))
#define BAOBAB_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_WINDOW, BaobabWindowClass))

typedef struct _BaobabWindow BaobabWindow;
typedef struct _BaobabWindowClass BaobabWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _BaobabApplication {
	GtkApplication parent_instance;
	BaobabApplicationPrivate * priv;
};

struct _BaobabApplicationClass {
	GtkApplicationClass parent_class;
};

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;


static gpointer baobab_application_parent_class = NULL;

GType baobab_application_get_type (void) G_GNUC_CONST;
static void baobab_application_on_quit_activate (BaobabApplication* self);
static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_application_real_activate (GApplication* base);
BaobabWindow* baobab_window_new (BaobabApplication* app);
BaobabWindow* baobab_window_construct (GType object_type, BaobabApplication* app);
GType baobab_window_get_type (void) G_GNUC_CONST;
static void baobab_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
void baobab_window_scan_directory (BaobabWindow* self, GFile* directory, BaobabScanFlags flags);
BaobabApplication* baobab_application_get_default (void);
GHashTable* baobab_application_get_excluded_locations (BaobabApplication* self);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static gchar* _variant_get1 (GVariant* value);
static void baobab_application_real_startup (GApplication* base);
static gint baobab_application_real_handle_local_options (GApplication* base, GVariantDict* options);
BaobabApplication* baobab_application_new (void);
BaobabApplication* baobab_application_construct (GType object_type);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry BAOBAB_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, N_ ("Print version information and exit"), NULL}, {NULL}};
static const GActionEntry BAOBAB_APPLICATION_action_entries[1] = {{"quit", _baobab_application_on_quit_activate_gsimple_action_activate_callback}};

static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_application_on_quit_activate ((BaobabApplication*) self);
}


static void baobab_application_real_activate (GApplication* base) {
	BaobabApplication * self;
	BaobabWindow* _tmp0_;
	BaobabWindow* _tmp1_;
	self = (BaobabApplication*) base;
	_tmp0_ = baobab_window_new (self);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	BaobabApplication * self;
	GFile** _tmp0_;
	gint _tmp0__length1;
	self = (BaobabApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files;
	_tmp0__length1 = files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp0_;
		file_collection_length1 = _tmp0__length1;
		for (file_it = 0; file_it < _tmp0__length1; file_it = file_it + 1) {
			GFile* _tmp1_;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				BaobabWindow* window = NULL;
				BaobabWindow* _tmp2_;
				BaobabWindow* _tmp3_;
				GFile* _tmp4_;
				_tmp2_ = baobab_window_new (self);
				g_object_ref_sink (_tmp2_);
				window = _tmp2_;
				_tmp3_ = window;
				_tmp4_ = file;
				baobab_window_scan_directory (_tmp3_, _tmp4_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
				_g_object_unref0 (window);
				_g_object_unref0 (file);
			}
		}
	}
}


BaobabApplication* baobab_application_get_default (void) {
	BaobabApplication* result = NULL;
	GApplication* _tmp0_;
	BaobabApplication* _tmp1_;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BAOBAB_TYPE_APPLICATION, BaobabApplication));
	result = _tmp1_;
	return result;
}


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
	return result;
}


static gboolean _g_file_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = g_file_equal (a, (GFile*) b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


GHashTable* baobab_application_get_excluded_locations (BaobabApplication* self) {
	GHashTable* result = NULL;
	GHashTable* excluded_locations = NULL;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GFile* _tmp2_;
	GHashTable* _tmp3_;
	GFile* _tmp4_;
	GHashTable* _tmp5_;
	GFile* _tmp6_;
	GFile* home = NULL;
	const gchar* _tmp7_;
	GFile* _tmp8_;
	GHashTable* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* root = NULL;
	GFile* _tmp12_;
	GSettings* prefs_settings = NULL;
	GSettings* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, NULL, _g_object_unref0_);
	excluded_locations = _tmp0_;
	_tmp1_ = excluded_locations;
	_tmp2_ = g_file_new_for_path ("/proc");
	g_hash_table_add (_tmp1_, _tmp2_);
	_tmp3_ = excluded_locations;
	_tmp4_ = g_file_new_for_path ("/sys");
	g_hash_table_add (_tmp3_, _tmp4_);
	_tmp5_ = excluded_locations;
	_tmp6_ = g_file_new_for_path ("/selinux");
	g_hash_table_add (_tmp5_, _tmp6_);
	_tmp7_ = g_get_home_dir ();
	_tmp8_ = g_file_new_for_path (_tmp7_);
	home = _tmp8_;
	_tmp9_ = excluded_locations;
	_tmp10_ = home;
	_tmp11_ = g_file_get_child (_tmp10_, ".gvfs");
	g_hash_table_add (_tmp9_, _tmp11_);
	_tmp12_ = g_file_new_for_path ("/");
	root = _tmp12_;
	_tmp13_ = g_settings_new ("org.gnome.baobab.preferences");
	prefs_settings = _tmp13_;
	{
		GVariantIter* _uri_it = NULL;
		GSettings* _tmp14_;
		GVariant* _tmp15_;
		GVariant* _tmp16_;
		GVariantIter* _tmp17_;
		GVariantIter* _tmp18_;
		GVariant* uri = NULL;
		_tmp14_ = prefs_settings;
		_tmp15_ = g_settings_get_value (_tmp14_, "excluded-uris");
		_tmp16_ = _tmp15_;
		_tmp17_ = g_variant_iter_new (_tmp16_);
		_tmp18_ = _tmp17_;
		_g_variant_unref0 (_tmp16_);
		_uri_it = _tmp18_;
		while (TRUE) {
			GVariantIter* _tmp19_;
			GVariant* _tmp20_;
			GVariant* _tmp21_;
			GFile* file = NULL;
			GVariant* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			gboolean _tmp29_;
			_tmp19_ = _uri_it;
			_tmp20_ = g_variant_iter_next_value (_tmp19_);
			_g_variant_unref0 (uri);
			uri = _tmp20_;
			_tmp21_ = uri;
			if (!(_tmp21_ != NULL)) {
				break;
			}
			_tmp22_ = uri;
			_tmp23_ = _variant_get1 (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_file_new_for_uri (_tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp24_);
			file = _tmp26_;
			_tmp27_ = file;
			_tmp28_ = root;
			_tmp29_ = g_file_equal (_tmp27_, _tmp28_);
			if (!_tmp29_) {
				GHashTable* _tmp30_;
				GFile* _tmp31_;
				GFile* _tmp32_;
				_tmp30_ = excluded_locations;
				_tmp31_ = file;
				_tmp32_ = _g_object_ref0 (_tmp31_);
				g_hash_table_add (_tmp30_, _tmp32_);
			}
			_g_object_unref0 (file);
		}
		_g_variant_unref0 (uri);
		_g_variant_iter_free0 (_uri_it);
	}
	result = excluded_locations;
	_g_object_unref0 (prefs_settings);
	_g_object_unref0 (root);
	_g_object_unref0 (home);
	return result;
}


static void baobab_application_real_startup (GApplication* base) {
	BaobabApplication * self;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GFile* css_file = NULL;
	GFile* _tmp1_;
	GdkScreen* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GError * _inner_error_ = NULL;
	self = (BaobabApplication*) base;
	G_APPLICATION_CLASS (baobab_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	_tmp1_ = g_file_new_for_uri ("resource:///org/gnome/baobab/baobab.css");
	css_file = _tmp1_;
	{
		gtk_css_provider_load_from_file (css_provider, css_file, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("baobab-application.vala:81: loading css: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (css_file);
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = gdk_screen_get_default ();
	gtk_style_context_add_provider_for_screen (_tmp4_, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp5_ = g_strdup ("F10");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.gear-menu", _tmp7_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = g_strdup ("<Primary>r");
	_tmp9_ = g_new0 (gchar*, 1 + 1);
	_tmp9_[0] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.reload", _tmp10_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (css_file);
	_g_object_unref0 (css_provider);
}


static gint baobab_application_real_handle_local_options (GApplication* base, GVariantDict* options) {
	BaobabApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_;
	gboolean _tmp1_;
	self = (BaobabApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	_tmp0_ = options;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		const gchar* _tmp2_;
		_tmp2_ = g_get_application_name ();
		g_print ("%s %s\n", _tmp2_, VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}


BaobabApplication* baobab_application_construct (GType object_type) {
	BaobabApplication * self = NULL;
	self = (BaobabApplication*) g_object_new (object_type, "application-id", "org.gnome.baobab", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_application_add_main_option_entries ((GApplication*) self, BAOBAB_APPLICATION_option_entries);
	g_action_map_add_action_entries ((GActionMap*) self, BAOBAB_APPLICATION_action_entries, G_N_ELEMENTS (BAOBAB_APPLICATION_action_entries), self);
	return self;
}


BaobabApplication* baobab_application_new (void) {
	return baobab_application_construct (BAOBAB_TYPE_APPLICATION);
}


static void baobab_application_on_quit_activate (BaobabApplication* self) {
	g_return_if_fail (self != NULL);
	g_application_quit ((GApplication*) self);
}


static void baobab_application_class_init (BaobabApplicationClass * klass) {
	baobab_application_parent_class = g_type_class_peek_parent (klass);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication *)) baobab_application_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication *, GFile**, int, const gchar*)) baobab_application_real_open;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication *)) baobab_application_real_startup;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication *, GVariantDict*)) baobab_application_real_handle_local_options;
}


static void baobab_application_instance_init (BaobabApplication * self) {
}


GType baobab_application_get_type (void) {
	static volatile gsize baobab_application_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabApplication), 0, (GInstanceInitFunc) baobab_application_instance_init, NULL };
		GType baobab_application_type_id;
		baobab_application_type_id = g_type_register_static (gtk_application_get_type (), "BaobabApplication", &g_define_type_info, 0);
		g_once_init_leave (&baobab_application_type_id__volatile, baobab_application_type_id);
	}
	return baobab_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



