/* tracker-direct.c generated by valac 0.38.1, the Vala compiler
 * generated from tracker-direct.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 * Copyright (C) 2017, Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <gio/gio.h>
#include "libtracker-data/tracker-data-manager.h"
#include <stdlib.h>
#include <string.h>
#include "libtracker-data/tracker-db-interface.h"
#include "libtracker-common/tracker-locale.h"
#include "libtracker-data/tracker-db-manager.h"
#include "libtracker-data/tracker-db-interface-sqlite.h"
#include "libtracker-data/tracker-sparql-query.h"
#include "libtracker-common/tracker-date-time.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include <gobject/gvaluecollector.h>


#define TRACKER_DIRECT_TYPE_CONNECTION (tracker_direct_connection_get_type ())
#define TRACKER_DIRECT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnection))
#define TRACKER_DIRECT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionClass))
#define TRACKER_DIRECT_IS_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_DIRECT_TYPE_CONNECTION))
#define TRACKER_DIRECT_IS_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_DIRECT_TYPE_CONNECTION))
#define TRACKER_DIRECT_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionClass))

typedef struct _TrackerDirectConnection TrackerDirectConnection;
typedef struct _TrackerDirectConnectionClass TrackerDirectConnectionClass;
typedef struct _TrackerDirectConnectionPrivate TrackerDirectConnectionPrivate;

#define TRACKER_DIRECT_CONNECTION_TYPE_TASK (tracker_direct_connection_task_get_type ())
#define TRACKER_DIRECT_CONNECTION_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_DIRECT_CONNECTION_TYPE_TASK, TrackerDirectConnectionTask))
#define TRACKER_DIRECT_CONNECTION_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_DIRECT_CONNECTION_TYPE_TASK, TrackerDirectConnectionTaskClass))
#define TRACKER_DIRECT_CONNECTION_IS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_DIRECT_CONNECTION_TYPE_TASK))
#define TRACKER_DIRECT_CONNECTION_IS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_DIRECT_CONNECTION_TYPE_TASK))
#define TRACKER_DIRECT_CONNECTION_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_DIRECT_CONNECTION_TYPE_TASK, TrackerDirectConnectionTaskClass))

typedef struct _TrackerDirectConnectionTask TrackerDirectConnectionTask;
typedef struct _TrackerDirectConnectionTaskClass TrackerDirectConnectionTaskClass;
enum  {
	TRACKER_DIRECT_CONNECTION_DUMMY_PROPERTY,
	TRACKER_DIRECT_CONNECTION_LAST_PROPERTY
};
static GParamSpec* tracker_direct_connection_properties[TRACKER_DIRECT_CONNECTION_LAST_PROPERTY];

#define TRACKER_DIRECT_CONNECTION_TYPE_TASK_TYPE (tracker_direct_connection_task_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _TrackerDirectConnectionTaskPrivate TrackerDirectConnectionTaskPrivate;

#define TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK (tracker_direct_connection_update_task_get_type ())
#define TRACKER_DIRECT_CONNECTION_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK, TrackerDirectConnectionUpdateTask))
#define TRACKER_DIRECT_CONNECTION_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK, TrackerDirectConnectionUpdateTaskClass))
#define TRACKER_DIRECT_CONNECTION_IS_UPDATE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK))
#define TRACKER_DIRECT_CONNECTION_IS_UPDATE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK))
#define TRACKER_DIRECT_CONNECTION_UPDATE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK, TrackerDirectConnectionUpdateTaskClass))

typedef struct _TrackerDirectConnectionUpdateTask TrackerDirectConnectionUpdateTask;
typedef struct _TrackerDirectConnectionUpdateTaskClass TrackerDirectConnectionUpdateTaskClass;
typedef struct _TrackerDirectConnectionUpdateTaskPrivate TrackerDirectConnectionUpdateTaskPrivate;
#define _tracker_direct_connection_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_direct_connection_task_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK (tracker_direct_connection_turtle_task_get_type ())
#define TRACKER_DIRECT_CONNECTION_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK, TrackerDirectConnectionTurtleTask))
#define TRACKER_DIRECT_CONNECTION_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK, TrackerDirectConnectionTurtleTaskClass))
#define TRACKER_DIRECT_CONNECTION_IS_TURTLE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK))
#define TRACKER_DIRECT_CONNECTION_IS_TURTLE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK))
#define TRACKER_DIRECT_CONNECTION_TURTLE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK, TrackerDirectConnectionTurtleTaskClass))

typedef struct _TrackerDirectConnectionTurtleTask TrackerDirectConnectionTurtleTask;
typedef struct _TrackerDirectConnectionTurtleTaskClass TrackerDirectConnectionTurtleTaskClass;
typedef struct _TrackerDirectConnectionTurtleTaskPrivate TrackerDirectConnectionTurtleTaskPrivate;
typedef struct _TrackerDirectConnectionInitAsyncData TrackerDirectConnectionInitAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _TrackerDirectConnectionQueryAsyncData TrackerDirectConnectionQueryAsyncData;
typedef struct _TrackerDirectConnectionUpdateAsyncData TrackerDirectConnectionUpdateAsyncData;
typedef struct _TrackerDirectConnectionUpdateBlankAsyncData TrackerDirectConnectionUpdateBlankAsyncData;
typedef struct _TrackerDirectConnectionLoadAsyncData TrackerDirectConnectionLoadAsyncData;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
enum  {
	TRACKER_DIRECT_CONNECTION_TASK_DUMMY_PROPERTY,
	TRACKER_DIRECT_CONNECTION_TASK_LAST_PROPERTY
};
static GParamSpec* tracker_direct_connection_task_properties[TRACKER_DIRECT_CONNECTION_TASK_LAST_PROPERTY];
typedef struct _TrackerDirectConnectionParamSpecTask TrackerDirectConnectionParamSpecTask;
enum  {
	TRACKER_DIRECT_CONNECTION_UPDATE_TASK_DUMMY_PROPERTY,
	TRACKER_DIRECT_CONNECTION_UPDATE_TASK_LAST_PROPERTY
};
static GParamSpec* tracker_direct_connection_update_task_properties[TRACKER_DIRECT_CONNECTION_UPDATE_TASK_LAST_PROPERTY];
enum  {
	TRACKER_DIRECT_CONNECTION_TURTLE_TASK_DUMMY_PROPERTY,
	TRACKER_DIRECT_CONNECTION_TURTLE_TASK_LAST_PROPERTY
};
static GParamSpec* tracker_direct_connection_turtle_task_properties[TRACKER_DIRECT_CONNECTION_TURTLE_TASK_LAST_PROPERTY];

struct _TrackerDirectConnection {
	TrackerSparqlConnection parent_instance;
	TrackerDirectConnectionPrivate * priv;
	GSourceFunc init_callback;
	gpointer init_callback_target;
	GDestroyNotify init_callback_target_destroy_notify;
};

struct _TrackerDirectConnectionClass {
	TrackerSparqlConnectionClass parent_class;
};

struct _TrackerDirectConnectionPrivate {
	GFile* database_loc;
	GFile* journal_loc;
	GFile* ontology_loc;
	TrackerSparqlConnectionFlags flags;
	TrackerDataManager* data_manager;
	GMutex mutex;
	GThread* thread;
	GMutex init_mutex;
	GCond init_cond;
	gboolean initialized;
	GError* init_error;
	GAsyncQueue* update_queue;
	TrackerNamespaceManager* namespace_manager;
};

typedef enum  {
	TRACKER_DIRECT_CONNECTION_TASK_TYPE_QUERY,
	TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE,
	TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE_BLANK,
	TRACKER_DIRECT_CONNECTION_TASK_TYPE_TURTLE
} TrackerDirectConnectionTaskType;

struct _Block1Data {
	int _ref_count_;
	TrackerDBInterface* iface;
};

struct _TrackerDirectConnectionTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerDirectConnectionTaskPrivate * priv;
	TrackerDirectConnectionTaskType type;
	gint priority;
	GCancellable* cancellable;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GError* error;
};

struct _TrackerDirectConnectionTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerDirectConnectionTask *self);
};

struct _TrackerDirectConnectionUpdateTask {
	TrackerDirectConnectionTask parent_instance;
	TrackerDirectConnectionUpdateTaskPrivate * priv;
	gchar* sparql;
	GVariant* blank_nodes;
};

struct _TrackerDirectConnectionUpdateTaskClass {
	TrackerDirectConnectionTaskClass parent_class;
};

struct _TrackerDirectConnectionTurtleTask {
	TrackerDirectConnectionTask parent_instance;
	TrackerDirectConnectionTurtleTaskPrivate * priv;
	GFile* file;
};

struct _TrackerDirectConnectionTurtleTaskClass {
	TrackerDirectConnectionTaskClass parent_class;
};

struct _TrackerDirectConnectionInitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* self;
	gint io_priority;
	GCancellable* cancellable;
	gboolean result;
	GThread* _tmp0_;
	gboolean _tmp1_;
};

struct _Block2Data {
	int _ref_count_;
	TrackerDirectConnection* self;
	GError* sparql_error;
	GError* io_error;
	GError* dbus_error;
	GError* _error_;
	TrackerSparqlCursor* _result_;
	GMainContext* context;
	gchar* sparql;
	gpointer _async_data_;
};

struct _TrackerDirectConnectionQueryAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* self;
	gchar* sparql;
	GCancellable* cancellable;
	TrackerSparqlCursor* result;
	Block2Data* _data2_;
	const gchar* _tmp0_;
	GMainContext* _tmp1_;
	GMainContext* _tmp2_;
	GCancellable* _tmp3_;
	gboolean _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	gboolean _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	TrackerSparqlCursor* _tmp18_;
	TrackerSparqlCursor* _tmp19_;
	GError * _inner_error_;
};

struct _TrackerDirectConnectionUpdateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	TrackerDirectConnectionUpdateTask* task;
	const gchar* _tmp0_;
	gint _tmp1_;
	GCancellable* _tmp2_;
	TrackerDirectConnectionUpdateTask* _tmp3_;
	TrackerDirectConnectionUpdateTask* _tmp4_;
	GAsyncQueue* _tmp5_;
	TrackerDirectConnectionUpdateTask* _tmp6_;
	TrackerDirectConnectionTask* _tmp7_;
	TrackerDirectConnectionUpdateTask* _tmp8_;
	GError* _tmp9_;
	TrackerDirectConnectionUpdateTask* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	GError * _inner_error_;
};

struct _TrackerDirectConnectionUpdateBlankAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* self;
	gchar* sparql;
	gint priority;
	GCancellable* cancellable;
	GVariant* result;
	TrackerDirectConnectionUpdateTask* task;
	const gchar* _tmp0_;
	gint _tmp1_;
	GCancellable* _tmp2_;
	TrackerDirectConnectionUpdateTask* _tmp3_;
	TrackerDirectConnectionUpdateTask* _tmp4_;
	GAsyncQueue* _tmp5_;
	TrackerDirectConnectionUpdateTask* _tmp6_;
	TrackerDirectConnectionTask* _tmp7_;
	TrackerDirectConnectionUpdateTask* _tmp8_;
	GError* _tmp9_;
	TrackerDirectConnectionUpdateTask* _tmp10_;
	GError* _tmp11_;
	GError* _tmp12_;
	TrackerDirectConnectionUpdateTask* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GError * _inner_error_;
};

struct _TrackerDirectConnectionLoadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* self;
	GFile* file;
	GCancellable* cancellable;
	TrackerDirectConnectionTurtleTask* task;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	TrackerDirectConnectionTurtleTask* _tmp2_;
	TrackerDirectConnectionTurtleTask* _tmp3_;
	GAsyncQueue* _tmp4_;
	TrackerDirectConnectionTurtleTask* _tmp5_;
	TrackerDirectConnectionTask* _tmp6_;
	TrackerDirectConnectionTurtleTask* _tmp7_;
	GError* _tmp8_;
	TrackerDirectConnectionTurtleTask* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	GError * _inner_error_;
};

struct _TrackerDirectConnectionParamSpecTask {
	GParamSpec parent_instance;
};


static gpointer tracker_direct_connection_parent_class = NULL;
static gpointer tracker_direct_connection_task_parent_class = NULL;
static gpointer tracker_direct_connection_update_task_parent_class = NULL;
static gpointer tracker_direct_connection_turtle_task_parent_class = NULL;
static GAsyncInitableIface * tracker_direct_connection_g_async_initable_parent_iface = NULL;
static GInitableIface * tracker_direct_connection_g_initable_parent_iface = NULL;

GType tracker_direct_connection_get_type (void) G_GNUC_CONST;
static gpointer tracker_direct_connection_task_ref (gpointer instance);
static void tracker_direct_connection_task_unref (gpointer instance);
static GParamSpec* tracker_direct_connection_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void tracker_direct_connection_value_set_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void tracker_direct_connection_value_take_task (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_direct_connection_value_get_task (const GValue* value) G_GNUC_UNUSED;
static GType tracker_direct_connection_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define TRACKER_DIRECT_CONNECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnectionPrivate))
static GType tracker_direct_connection_task_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void tracker_direct_connection_wal_checkpoint (TrackerDBInterface* iface, gboolean blocking);
static void tracker_direct_connection_wal_checkpoint_on_thread (TrackerDBInterface* iface);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void* __lambda4_ (Block1Data* _data1_);
static gpointer ___lambda4__gthread_func (gpointer self);
static void tracker_direct_connection_wal_hook (TrackerDBInterface* iface, gint n_pages);
static void* tracker_direct_connection_thread_func (TrackerDirectConnection* self);
static void _tracker_direct_connection_wal_hook_tracker_db_wal_callback (TrackerDBInterface* iface, gint n_pages);
static GType tracker_direct_connection_update_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType tracker_direct_connection_turtle_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void tracker_direct_connection_real_init_async_data_free (gpointer _data);
static void tracker_direct_connection_real_init_async (GAsyncInitable* base, gint io_priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_direct_connection_real_init_async_co (TrackerDirectConnectionInitAsyncData* _data_);
static gboolean _tracker_direct_connection_real_init_async_co_gsource_func (gpointer self);
static gpointer _tracker_direct_connection_thread_func_gthread_func (gpointer self);
static gboolean tracker_direct_connection_real_init (GInitable* base, GCancellable* cancellable, GError** error);
TrackerDirectConnection* tracker_direct_connection_new (TrackerSparqlConnectionFlags connection_flags, GFile* loc, GFile* journal, GFile* ontology, GError** error);
TrackerDirectConnection* tracker_direct_connection_construct (GType object_type, TrackerSparqlConnectionFlags connection_flags, GFile* loc, GFile* journal, GFile* ontology, GError** error);
static void _tracker_direct_connection_task_unref0_ (gpointer var);
static void tracker_direct_connection_real_dispose (GObject* base);
static TrackerSparqlCursor* tracker_direct_connection_query_unlocked (TrackerDirectConnection* self, const gchar* sparql, GError** error);
static TrackerSparqlCursor* tracker_direct_connection_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error);
static void tracker_direct_connection_real_query_async_data_free (gpointer _data);
static void tracker_direct_connection_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_direct_connection_real_query_async_co (TrackerDirectConnectionQueryAsyncData* _data_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block2Data* _data2_, GIOSchedulerJob* job, GCancellable* cancellable);
static gboolean __lambda6_ (Block2Data* _data2_);
static gboolean ___lambda6__gsource_func (gpointer self);
static gboolean ___lambda5__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self);
static void tracker_direct_connection_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_direct_connection_real_update_async_data_free (gpointer _data);
static void tracker_direct_connection_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_direct_connection_real_update_async_co (TrackerDirectConnectionUpdateAsyncData* _data_);
static TrackerDirectConnectionUpdateTask* tracker_direct_connection_update_task_new (const gchar* sparql, gint priority, GCancellable* cancellable);
static TrackerDirectConnectionUpdateTask* tracker_direct_connection_update_task_construct (GType object_type, const gchar* sparql, gint priority, GCancellable* cancellable);
static gboolean _tracker_direct_connection_real_update_async_co_gsource_func (gpointer self);
static GVariant* tracker_direct_connection_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error);
static void tracker_direct_connection_real_update_blank_async_data_free (gpointer _data);
static void tracker_direct_connection_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_direct_connection_real_update_blank_async_co (TrackerDirectConnectionUpdateBlankAsyncData* _data_);
static TrackerDirectConnectionUpdateTask* tracker_direct_connection_update_task_new_blank (const gchar* sparql, gint priority, GCancellable* cancellable);
static TrackerDirectConnectionUpdateTask* tracker_direct_connection_update_task_construct_blank (GType object_type, const gchar* sparql, gint priority, GCancellable* cancellable);
static gboolean _tracker_direct_connection_real_update_blank_async_co_gsource_func (gpointer self);
static void tracker_direct_connection_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error);
static void tracker_direct_connection_real_load_async_data_free (gpointer _data);
static void tracker_direct_connection_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tracker_direct_connection_real_load_async_co (TrackerDirectConnectionLoadAsyncData* _data_);
static TrackerDirectConnectionTurtleTask* tracker_direct_connection_turtle_task_new (GFile* file, GCancellable* cancellable);
static TrackerDirectConnectionTurtleTask* tracker_direct_connection_turtle_task_construct (GType object_type, GFile* file, GCancellable* cancellable);
static gboolean _tracker_direct_connection_real_load_async_co_gsource_func (gpointer self);
static TrackerNamespaceManager* tracker_direct_connection_real_get_namespace_manager (TrackerSparqlConnection* base);
static TrackerDirectConnectionTask* tracker_direct_connection_task_construct (GType object_type);
static void tracker_direct_connection_task_finalize (TrackerDirectConnectionTask * obj);
static void tracker_direct_connection_update_task_set (TrackerDirectConnectionUpdateTask* self, TrackerDirectConnectionTaskType type, const gchar* sparql, gint priority, GCancellable* cancellable);
static void tracker_direct_connection_update_task_finalize (TrackerDirectConnectionTask * obj);
static void tracker_direct_connection_turtle_task_finalize (TrackerDirectConnectionTask * obj);
static void tracker_direct_connection_finalize (GObject * obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


static GType tracker_direct_connection_task_type_get_type (void) {
	static volatile gsize tracker_direct_connection_task_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_connection_task_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_DIRECT_CONNECTION_TASK_TYPE_QUERY, "TRACKER_DIRECT_CONNECTION_TASK_TYPE_QUERY", "query"}, {TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE, "TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE", "update"}, {TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE_BLANK, "TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE_BLANK", "update-blank"}, {TRACKER_DIRECT_CONNECTION_TASK_TYPE_TURTLE, "TRACKER_DIRECT_CONNECTION_TASK_TYPE_TURTLE", "turtle"}, {0, NULL, NULL}};
		GType tracker_direct_connection_task_type_type_id;
		tracker_direct_connection_task_type_type_id = g_enum_register_static ("TrackerDirectConnectionTaskType", values);
		g_once_init_leave (&tracker_direct_connection_task_type_type_id__volatile, tracker_direct_connection_task_type_type_id);
	}
	return tracker_direct_connection_task_type_type_id__volatile;
}


static void tracker_direct_connection_wal_checkpoint (TrackerDBInterface* iface, gboolean blocking) {
	GError * _inner_error_ = NULL;
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (iface != NULL);
#line 450 "tracker-direct.c"
	{
		TrackerDBInterface* _tmp0_;
		gboolean _tmp1_;
#line 94 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_debug ("Checkpointing database...");
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = iface;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = blocking;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_db_interface_sqlite_wal_checkpoint (_tmp0_, _tmp1_, &_inner_error_);
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 464 "tracker-direct.c"
			goto __catch0_g_error;
		}
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_debug ("Checkpointing complete...");
#line 469 "tracker-direct.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = e;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = _tmp2_->message;
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_warning ("%s", _tmp3_);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 489 "tracker-direct.c"
	}
	__finally0:
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 93 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return;
#line 500 "tracker-direct.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self ? g_object_ref (self) : NULL;
#line 508 "tracker-direct.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return _data1_;
#line 517 "tracker-direct.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data1_->iface);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_slice_free (Block1Data, _data1_);
#line 530 "tracker-direct.c"
	}
}


static void* __lambda4_ (Block1Data* _data1_) {
	void* result = NULL;
	TrackerDBInterface* _tmp0_;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = _data1_->iface;
#line 104 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_wal_checkpoint (_tmp0_, FALSE);
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = NULL;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 546 "tracker-direct.c"
}


static gpointer ___lambda4__gthread_func (gpointer self) {
	gpointer result;
	result = __lambda4_ (self);
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	block1_data_unref (self);
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 557 "tracker-direct.c"
}


static void tracker_direct_connection_wal_checkpoint_on_thread (TrackerDBInterface* iface) {
	Block1Data* _data1_;
	TrackerDBInterface* _tmp0_;
	TrackerDBInterface* _tmp1_;
	GThread* _tmp2_;
	GThread* _tmp3_;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (iface != NULL);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data1_->_ref_count_ = 1;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = iface;
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data1_->iface);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data1_->iface = _tmp1_;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = g_thread_new ("wal-checkpoint", ___lambda4__gthread_func, block1_data_ref (_data1_));
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = _tmp2_;
#line 103 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_thread_unref0 (_tmp3_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	block1_data_unref (_data1_);
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data1_ = NULL;
#line 591 "tracker-direct.c"
}


static void tracker_direct_connection_wal_hook (TrackerDBInterface* iface, gint n_pages) {
	TrackerDataManager* manager = NULL;
	TrackerDBInterface* _tmp0_;
	GObject* _tmp1_;
	TrackerDataManager* _tmp2_;
	TrackerDBInterface* wal_iface = NULL;
	TrackerDataManager* _tmp3_;
	TrackerDBInterface* _tmp4_;
	TrackerDBInterface* _tmp5_;
	gint _tmp6_;
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (iface != NULL);
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = iface;
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = tracker_db_interface_get_user_data (_tmp0_);
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TRACKER_TYPE_DATA_MANAGER, TrackerDataManager));
#line 110 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	manager = _tmp2_;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = manager;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = tracker_data_manager_get_wal_db_interface (_tmp3_);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	wal_iface = _tmp5_;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp6_ = n_pages;
#line 113 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_tmp6_ >= 10000) {
#line 627 "tracker-direct.c"
		TrackerDBInterface* _tmp7_;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = wal_iface;
#line 116 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_direct_connection_wal_checkpoint (_tmp7_, TRUE);
#line 633 "tracker-direct.c"
	} else {
		gint _tmp8_;
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = n_pages;
#line 117 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_tmp8_ >= 1000) {
#line 640 "tracker-direct.c"
			TrackerDBInterface* _tmp9_;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp9_ = wal_iface;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			tracker_direct_connection_wal_checkpoint_on_thread (_tmp9_);
#line 646 "tracker-direct.c"
		}
	}
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (wal_iface);
#line 109 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (manager);
#line 653 "tracker-direct.c"
}


static void _tracker_direct_connection_wal_hook_tracker_db_wal_callback (TrackerDBInterface* iface, gint n_pages) {
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_wal_hook (iface, n_pages);
#line 660 "tracker-direct.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self ? g_error_copy (self) : NULL;
#line 667 "tracker-direct.c"
}


static gpointer _tracker_direct_connection_task_ref0 (gpointer self) {
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self ? tracker_direct_connection_task_ref (self) : NULL;
#line 674 "tracker-direct.c"
}


static void* tracker_direct_connection_thread_func (TrackerDirectConnection* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_mutex_lock (&self->priv->init_mutex);
#line 685 "tracker-direct.c"
	{
		TrackerDBManagerFlags db_flags = 0;
		TrackerSparqlConnectionFlags _tmp0_;
		TrackerDBManagerFlags _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		TrackerDataManager* _tmp6_;
		TrackerDataManager* _tmp7_;
		TrackerDBInterface* iface = NULL;
		TrackerDataManager* _tmp8_;
		TrackerDBInterface* _tmp9_;
		TrackerDBInterface* _tmp10_;
		TrackerDBInterface* _tmp11_;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_locale_sanity_check ();
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		db_flags = TRACKER_DB_MANAGER_ENABLE_MUTEXES;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = self->priv->flags;
#line 128 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if ((_tmp0_ & TRACKER_SPARQL_CONNECTION_FLAGS_READONLY) != 0) {
#line 708 "tracker-direct.c"
			TrackerDBManagerFlags _tmp1_;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp1_ = db_flags;
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			db_flags = _tmp1_ | TRACKER_DB_MANAGER_READONLY;
#line 714 "tracker-direct.c"
		}
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = db_flags;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = self->priv->database_loc;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = self->priv->journal_loc;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = self->priv->ontology_loc;
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = tracker_data_manager_new (_tmp2_, _tmp3_, _tmp4_, _tmp5_, FALSE, FALSE, (guint) 100, (guint) 100);
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (self->priv->data_manager);
#line 131 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		self->priv->data_manager = _tmp6_;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = self->priv->data_manager;
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_initable_init ((GInitable*) _tmp7_, NULL, &_inner_error_);
#line 134 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 736 "tracker-direct.c"
			goto __catch1_g_error;
		}
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = self->priv->data_manager;
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = tracker_data_manager_get_writable_db_interface (_tmp8_);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp10_ = _g_object_ref0 (_tmp9_);
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		iface = _tmp10_;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp11_ = iface;
#line 137 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_db_interface_sqlite_wal_hook (_tmp11_, _tracker_direct_connection_wal_hook_tracker_db_wal_callback);
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (iface);
#line 753 "tracker-direct.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		GError* _tmp13_;
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp12_ = e;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp13_ = _g_error_copy0 (_tmp12_);
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (self->priv->init_error);
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		self->priv->init_error = _tmp13_;
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 775 "tracker-direct.c"
	}
	__finally1:
	{
		GSourceFunc _tmp14_;
		void* _tmp14__target;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp14_ = self->init_callback;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp14__target = self->init_callback_target;
#line 141 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_tmp14_ != NULL) {
#line 787 "tracker-direct.c"
			GSourceFunc _tmp15_;
			void* _tmp15__target;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp15_ = self->init_callback;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp15__target = self->init_callback_target;
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp15_ (_tmp15__target);
#line 796 "tracker-direct.c"
		} else {
#line 144 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			self->priv->initialized = TRUE;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_cond_signal (&self->priv->init_cond);
#line 146 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_mutex_unlock (&self->priv->init_mutex);
#line 804 "tracker-direct.c"
		}
	}
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 125 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 815 "tracker-direct.c"
	}
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	while (TRUE) {
#line 819 "tracker-direct.c"
		TrackerDirectConnectionTask* task = NULL;
		GAsyncQueue* _tmp16_;
		gpointer _tmp17_;
		TrackerDirectConnectionTask* _tmp49_;
		GSourceFunc _tmp50_;
		void* _tmp50__target;
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp16_ = self->priv->update_queue;
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp17_ = g_async_queue_pop (_tmp16_);
#line 151 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		task = (TrackerDirectConnectionTask*) _tmp17_;
#line 832 "tracker-direct.c"
		{
			TrackerDirectConnectionTask* _tmp18_;
			TrackerDirectConnectionTaskType _tmp19_;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp18_ = task;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp19_ = _tmp18_->type;
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			switch (_tmp19_) {
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				case TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE:
#line 844 "tracker-direct.c"
				{
					TrackerDirectConnectionUpdateTask* update_task = NULL;
					TrackerDirectConnectionTask* _tmp20_;
					TrackerDirectConnectionUpdateTask* _tmp21_;
					TrackerDirectConnectionUpdateTask* _tmp22_;
					const gchar* _tmp23_;
					TrackerDirectConnectionUpdateTask* _tmp24_;
					gint _tmp25_;
					TrackerDirectConnectionUpdateTask* _tmp26_;
					GCancellable* _tmp27_;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp20_ = task;
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp21_ = _tracker_direct_connection_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK, TrackerDirectConnectionUpdateTask));
#line 156 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					update_task = _tmp21_;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp22_ = update_task;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp23_ = _tmp22_->sparql;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp24_ = update_task;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp25_ = ((TrackerDirectConnectionTask*) _tmp24_)->priority;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp26_ = update_task;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp27_ = ((TrackerDirectConnectionTask*) _tmp26_)->cancellable;
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					tracker_sparql_connection_update ((TrackerSparqlConnection*) self, _tmp23_, _tmp25_, _tmp27_, &_inner_error_);
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						_tracker_direct_connection_task_unref0 (update_task);
#line 879 "tracker-direct.c"
						goto __catch2_g_error;
					}
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tracker_direct_connection_task_unref0 (update_task);
#line 158 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					break;
#line 886 "tracker-direct.c"
				}
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				case TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE_BLANK:
#line 890 "tracker-direct.c"
				{
					TrackerDirectConnectionUpdateTask* update_task = NULL;
					TrackerDirectConnectionTask* _tmp28_;
					TrackerDirectConnectionUpdateTask* _tmp29_;
					GVariant* _tmp30_ = NULL;
					TrackerDirectConnectionUpdateTask* _tmp31_;
					const gchar* _tmp32_;
					TrackerDirectConnectionUpdateTask* _tmp33_;
					gint _tmp34_;
					TrackerDirectConnectionUpdateTask* _tmp35_;
					GCancellable* _tmp36_;
					GVariant* _tmp37_;
					TrackerDirectConnectionUpdateTask* _tmp38_;
					GVariant* _tmp39_;
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp28_ = task;
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp29_ = _tracker_direct_connection_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK, TrackerDirectConnectionUpdateTask));
#line 160 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					update_task = _tmp29_;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp31_ = update_task;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp32_ = _tmp31_->sparql;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp33_ = update_task;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp34_ = ((TrackerDirectConnectionTask*) _tmp33_)->priority;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp35_ = update_task;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp36_ = ((TrackerDirectConnectionTask*) _tmp35_)->cancellable;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp37_ = tracker_sparql_connection_update_blank ((TrackerSparqlConnection*) self, _tmp32_, _tmp34_, _tmp36_, &_inner_error_);
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp30_ = _tmp37_;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						_tracker_direct_connection_task_unref0 (update_task);
#line 931 "tracker-direct.c"
						goto __catch2_g_error;
					}
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp38_ = update_task;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp39_ = _tmp30_;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp30_ = NULL;
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_g_variant_unref0 (_tmp38_->blank_nodes);
#line 161 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp38_->blank_nodes = _tmp39_;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_g_variant_unref0 (_tmp30_);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tracker_direct_connection_task_unref0 (update_task);
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					break;
#line 950 "tracker-direct.c"
				}
#line 154 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				case TRACKER_DIRECT_CONNECTION_TASK_TYPE_TURTLE:
#line 954 "tracker-direct.c"
				{
					TrackerDirectConnectionTurtleTask* turtle_task = NULL;
					TrackerDirectConnectionTask* _tmp40_;
					TrackerDirectConnectionTurtleTask* _tmp41_;
					TrackerDirectConnectionTurtleTask* _tmp42_;
					GFile* _tmp43_;
					TrackerDirectConnectionTurtleTask* _tmp44_;
					GCancellable* _tmp45_;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp40_ = task;
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp41_ = _tracker_direct_connection_task_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK, TrackerDirectConnectionTurtleTask));
#line 164 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					turtle_task = _tmp41_;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp42_ = turtle_task;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp43_ = _tmp42_->file;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp44_ = turtle_task;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp45_ = ((TrackerDirectConnectionTask*) _tmp44_)->cancellable;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					tracker_sparql_connection_load ((TrackerSparqlConnection*) self, _tmp43_, _tmp45_, &_inner_error_);
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						_tracker_direct_connection_task_unref0 (turtle_task);
#line 983 "tracker-direct.c"
						goto __catch2_g_error;
					}
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tracker_direct_connection_task_unref0 (turtle_task);
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					break;
#line 990 "tracker-direct.c"
				}
				default:
				{
#line 168 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					break;
#line 996 "tracker-direct.c"
				}
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			TrackerDirectConnectionTask* _tmp46_;
			GError* _tmp47_;
			GError* _tmp48_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			e = _inner_error_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_inner_error_ = NULL;
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp46_ = task;
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp47_ = e;
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp48_ = _g_error_copy0 (_tmp47_);
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_error_free0 (_tmp46_->error);
#line 171 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp46_->error = _tmp48_;
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_error_free0 (e);
#line 1023 "tracker-direct.c"
		}
		__finally2:
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tracker_direct_connection_task_unref0 (task);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_inner_error_);
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 1036 "tracker-direct.c"
		}
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp49_ = task;
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp50_ = _tmp49_->callback;
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp50__target = _tmp49_->callback_target;
#line 174 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp50_ (_tmp50__target);
#line 150 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tracker_direct_connection_task_unref0 (task);
#line 1048 "tracker-direct.c"
	}
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1052 "tracker-direct.c"
}


static void tracker_direct_connection_real_init_async_data_free (gpointer _data) {
	TrackerDirectConnectionInitAsyncData* _data_;
	_data_ = _data;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_slice_free (TrackerDirectConnectionInitAsyncData, _data_);
#line 1065 "tracker-direct.c"
}


static void tracker_direct_connection_real_init_async (GAsyncInitable* base, gint io_priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerDirectConnection * self;
	TrackerDirectConnectionInitAsyncData* _data_;
	TrackerDirectConnection* _tmp0_;
	gint _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_slice_new0 (TrackerDirectConnectionInitAsyncData);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_direct_connection_real_init_async_data_free);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self = _tmp0_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = io_priority;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->io_priority = _tmp1_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = cancellable;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->cancellable = _tmp3_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_init_async_co (_data_);
#line 1102 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_init_finish (GAsyncInitable* base, GAsyncResult* _res_, GError** error) {
	gboolean result;
	TrackerDirectConnectionInitAsyncData* _data_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (NULL == _data_) {
#line 1113 "tracker-direct.c"
		gboolean _tmp0_ = FALSE;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return _tmp0_;
#line 1117 "tracker-direct.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = _data_->result;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1123 "tracker-direct.c"
}


static gboolean _tracker_direct_connection_real_init_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_direct_connection_real_init_async_co (self);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1132 "tracker-direct.c"
}


static gpointer _tracker_direct_connection_thread_func_gthread_func (gpointer self) {
	gpointer result;
	result = tracker_direct_connection_thread_func ((TrackerDirectConnection*) self);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_object_unref (self);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1143 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_init_async_co (TrackerDirectConnectionInitAsyncData* _data_) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	switch (_data_->_state_) {
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 0:
#line 1152 "tracker-direct.c"
		goto _state_0;
		default:
#line 178 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_assert_not_reached ();
#line 1157 "tracker-direct.c"
	}
	_state_0:
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	(_data_->self->init_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->init_callback_target_destroy_notify (_data_->self->init_callback_target), NULL);
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self->init_callback = NULL;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self->init_callback_target = NULL;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self->init_callback_target_destroy_notify = NULL;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self->init_callback = _tracker_direct_connection_real_init_async_co_gsource_func;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self->init_callback_target = _data_;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self->init_callback_target_destroy_notify = NULL;
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp0_ = g_thread_new ("database", _tracker_direct_connection_thread_func_gthread_func, g_object_ref (_data_->self));
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_thread_unref0 (_data_->self->priv->thread);
#line 180 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self->priv->thread = _data_->_tmp0_;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp1_ = _data_->self->priv->initialized;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->result = _data_->_tmp1_;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_state_ != 0) {
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1192 "tracker-direct.c"
		}
	}
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_object_unref (_data_->_async_result);
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 1199 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_init (GInitable* base, GCancellable* cancellable, GError** error) {
	TrackerDirectConnection * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
#line 185 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 1209 "tracker-direct.c"
	{
		GThread* _tmp0_;
		GError* _tmp2_;
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = g_thread_new ("database", _tracker_direct_connection_thread_func_gthread_func, g_object_ref (self));
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_thread_unref0 (self->priv->thread);
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		self->priv->thread = _tmp0_;
#line 189 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_mutex_lock (&self->priv->init_mutex);
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		while (TRUE) {
#line 1223 "tracker-direct.c"
			gboolean _tmp1_;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp1_ = self->priv->initialized;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			if (!(!_tmp1_)) {
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				break;
#line 1231 "tracker-direct.c"
			}
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_cond_wait (&self->priv->init_cond, &self->priv->init_mutex);
#line 1235 "tracker-direct.c"
		}
#line 192 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_mutex_unlock (&self->priv->init_mutex);
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = self->priv->init_error;
#line 194 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_tmp2_ != NULL) {
#line 1243 "tracker-direct.c"
			GError* _tmp3_;
			GError* _tmp4_;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp3_ = self->priv->init_error;
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tmp4_ = _g_error_copy0 (_tmp3_);
#line 195 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_inner_error_ = _tmp4_;
#line 1252 "tracker-direct.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = e;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = _tmp5_->message;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp6_);
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp7_;
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 1277 "tracker-direct.c"
		goto __finally3;
	}
	__finally3:
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "tracker-direct.c"
		gboolean _tmp8_ = FALSE;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return _tmp8_;
#line 1289 "tracker-direct.c"
	}
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = TRUE;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1295 "tracker-direct.c"
}


static void _tracker_direct_connection_task_unref0_ (gpointer var) {
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	(var == NULL) ? NULL : (var = (tracker_direct_connection_task_unref (var), NULL));
#line 1302 "tracker-direct.c"
}


TrackerDirectConnection* tracker_direct_connection_construct (GType object_type, TrackerSparqlConnectionFlags connection_flags, GFile* loc, GFile* journal, GFile* ontology, GError** error) {
	TrackerDirectConnection * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	TrackerSparqlConnectionFlags _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp10_;
	GAsyncQueue* _tmp14_;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (loc != NULL, NULL);
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) tracker_sparql_connection_construct (object_type);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = loc;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->priv->database_loc);
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->priv->database_loc = _tmp1_;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = journal;
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->priv->journal_loc);
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->priv->journal_loc = _tmp3_;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = ontology;
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->priv->ontology_loc);
#line 206 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->priv->ontology_loc = _tmp5_;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp6_ = connection_flags;
#line 207 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->priv->flags = _tmp6_;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp7_ = self->priv->journal_loc;
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_tmp7_ == NULL) {
#line 1354 "tracker-direct.c"
		GFile* _tmp8_;
		GFile* _tmp9_;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = self->priv->database_loc;
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = _g_object_ref0 (_tmp8_);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (self->priv->journal_loc);
#line 210 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		self->priv->journal_loc = _tmp9_;
#line 1365 "tracker-direct.c"
	}
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp10_ = self->priv->ontology_loc;
#line 211 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_tmp10_ == NULL) {
#line 1371 "tracker-direct.c"
		gchar* _tmp11_;
		gchar* _tmp12_;
		GFile* _tmp13_;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp11_ = g_build_filename (SHAREDIR, "tracker", "ontologies", "nepomuk", NULL);
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp12_ = _tmp11_;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp13_ = g_file_new_for_path (_tmp12_);
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (self->priv->ontology_loc);
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		self->priv->ontology_loc = _tmp13_;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_free0 (_tmp12_);
#line 1387 "tracker-direct.c"
	}
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp14_ = g_async_queue_new_full (_tracker_direct_connection_task_unref0_);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_async_queue_unref0 (self->priv->update_queue);
#line 214 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->priv->update_queue = _tmp14_;
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self;
#line 1397 "tracker-direct.c"
}


TrackerDirectConnection* tracker_direct_connection_new (TrackerSparqlConnectionFlags connection_flags, GFile* loc, GFile* journal, GFile* ontology, GError** error) {
#line 203 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return tracker_direct_connection_construct (TRACKER_DIRECT_TYPE_CONNECTION, connection_flags, loc, journal, ontology, error);
#line 1404 "tracker-direct.c"
}


static void tracker_direct_connection_real_dispose (GObject* base) {
	TrackerDirectConnection * self;
	TrackerDataManager* _tmp0_;
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = self->priv->data_manager;
#line 218 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_data_manager_shutdown (_tmp0_);
#line 219 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	G_OBJECT_CLASS (tracker_direct_connection_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, TRACKER_SPARQL_TYPE_CONNECTION, TrackerSparqlConnection));
#line 1419 "tracker-direct.c"
}


static TrackerSparqlCursor* tracker_direct_connection_query_unlocked (TrackerDirectConnection* self, const gchar* sparql, GError** error) {
	TrackerSparqlCursor* result = NULL;
	GError * _inner_error_ = NULL;
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 222 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 1430 "tracker-direct.c"
	{
		TrackerSparqlQuery* query_object = NULL;
		TrackerDataManager* _tmp0_;
		const gchar* _tmp1_;
		TrackerSparqlQuery* _tmp2_;
		TrackerDBCursor* cursor = NULL;
		TrackerSparqlQuery* _tmp3_;
		TrackerDBCursor* _tmp4_;
		TrackerDBCursor* _tmp5_;
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = self->priv->data_manager;
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = sparql;
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = tracker_sparql_query_new (_tmp0_, _tmp1_);
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		query_object = _tmp2_;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = query_object;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = tracker_sparql_query_execute_cursor (_tmp3_, &_inner_error_);
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		cursor = _tmp4_;
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_object_unref0 (query_object);
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_DB_INTERFACE_ERROR) {
#line 1460 "tracker-direct.c"
				goto __catch4_tracker_db_interface_error;
			}
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_DATE_ERROR) {
#line 1465 "tracker-direct.c"
				goto __catch4_tracker_date_error;
			}
			goto __finally4;
		}
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = cursor;
#line 226 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_sparql_cursor_set_connection ((TrackerSparqlCursor*) _tmp5_, (TrackerSparqlConnection*) self);
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		result = (TrackerSparqlCursor*) cursor;
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (query_object);
#line 227 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return result;
#line 1480 "tracker-direct.c"
	}
	goto __finally4;
	__catch4_tracker_db_interface_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = e;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = _tmp6_->message;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _tmp7_);
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp8_;
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 1503 "tracker-direct.c"
		goto __finally4;
	}
	goto __finally4;
	__catch4_tracker_date_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = e;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp10_ = _tmp9_->message;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp11_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, _tmp10_);
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp11_;
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 1527 "tracker-direct.c"
		goto __finally4;
	}
	__finally4:
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if ((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 1537 "tracker-direct.c"
	} else {
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 223 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 1545 "tracker-direct.c"
	}
}


static TrackerSparqlCursor* tracker_direct_connection_real_query (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GError** error) {
	TrackerDirectConnection * self;
	TrackerSparqlCursor* result = NULL;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	GError * _inner_error_ = NULL;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 235 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = cancellable;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_tmp1_ != NULL) {
#line 1564 "tracker-direct.c"
		GCancellable* _tmp2_;
		gboolean _tmp3_;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = cancellable;
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = g_cancellable_is_cancelled (_tmp2_);
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = _tmp3_;
#line 1573 "tracker-direct.c"
	} else {
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = FALSE;
#line 1577 "tracker-direct.c"
	}
#line 238 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_tmp0_) {
#line 1581 "tracker-direct.c"
		GError* _tmp4_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = _tmp4_;
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_propagate_error (error, _inner_error_);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 1593 "tracker-direct.c"
		} else {
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_inner_error_);
#line 239 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return NULL;
#line 1601 "tracker-direct.c"
		}
	}
#line 242 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_mutex_lock (&self->priv->mutex);
#line 1606 "tracker-direct.c"
	{
		TrackerSparqlCursor* _tmp5_ = NULL;
		const gchar* _tmp6_;
		TrackerSparqlCursor* _tmp7_;
		TrackerSparqlCursor* _tmp8_;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = sparql;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = tracker_direct_connection_query_unlocked (self, _tmp6_, &_inner_error_);
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = _tmp7_;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1620 "tracker-direct.c"
			goto __finally5;
		}
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = _tmp5_;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = NULL;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		result = _tmp8_;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_tmp5_);
#line 1631 "tracker-direct.c"
		{
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_mutex_unlock (&self->priv->mutex);
#line 1635 "tracker-direct.c"
		}
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return result;
#line 1639 "tracker-direct.c"
	}
	__finally5:
	{
#line 246 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_mutex_unlock (&self->priv->mutex);
#line 1645 "tracker-direct.c"
	}
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 1653 "tracker-direct.c"
	} else {
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 243 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 1661 "tracker-direct.c"
	}
}


static void tracker_direct_connection_real_query_async_data_free (gpointer _data) {
	TrackerDirectConnectionQueryAsyncData* _data_;
	_data_ = _data;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->result);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_slice_free (TrackerDirectConnectionQueryAsyncData, _data_);
#line 1677 "tracker-direct.c"
}


static void tracker_direct_connection_real_query_async (TrackerSparqlConnection* base, const gchar* sparql, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerDirectConnection * self;
	TrackerDirectConnectionQueryAsyncData* _data_;
	TrackerDirectConnection* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_slice_new0 (TrackerDirectConnectionQueryAsyncData);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_direct_connection_real_query_async_data_free);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self = _tmp0_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = sparql;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->sparql);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->sparql = _tmp2_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = cancellable;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->cancellable = _tmp4_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_query_async_co (_data_);
#line 1719 "tracker-direct.c"
}


static TrackerSparqlCursor* tracker_direct_connection_real_query_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerSparqlCursor* result;
	TrackerDirectConnectionQueryAsyncData* _data_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (NULL == _data_) {
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 1732 "tracker-direct.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = _data_->result;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->result = NULL;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1740 "tracker-direct.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return _data2_;
#line 1749 "tracker-direct.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1758 "tracker-direct.c"
		TrackerDirectConnection* self;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		self = _data2_->self;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_main_context_unref0 (_data2_->context);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data2_->_result_);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->_error_);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->io_error);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_free0 (_data2_->sparql);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (self);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_slice_free (Block2Data, _data2_);
#line 1780 "tracker-direct.c"
	}
}


static gpointer _g_main_context_ref0 (gpointer self) {
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self ? g_main_context_ref (self) : NULL;
#line 1788 "tracker-direct.c"
}


static gboolean __lambda6_ (Block2Data* _data2_) {
	TrackerDirectConnection* self;
	gboolean result = FALSE;
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = _data2_->self;
#line 273 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_query_async_co (_data2_->_async_data_);
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = FALSE;
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1803 "tracker-direct.c"
}


static gboolean ___lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1812 "tracker-direct.c"
}


static gboolean __lambda5_ (Block2Data* _data2_, GIOSchedulerJob* job, GCancellable* cancellable) {
	TrackerDirectConnection* self;
	gboolean result = FALSE;
	GMainContext* _tmp14_;
	GError * _inner_error_ = NULL;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = _data2_->self;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (job != NULL, FALSE);
#line 1825 "tracker-direct.c"
	{
		TrackerSparqlCursor* _tmp0_ = NULL;
		const gchar* _tmp1_;
		GCancellable* _tmp2_;
		TrackerSparqlCursor* _tmp3_;
		TrackerSparqlCursor* _tmp4_;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = _data2_->sparql;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = cancellable;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = tracker_sparql_connection_query ((TrackerSparqlConnection*) self, _tmp1_, _tmp2_, &_inner_error_);
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = _tmp3_;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1844 "tracker-direct.c"
				goto __catch6_g_io_error;
			}
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 1849 "tracker-direct.c"
				goto __catch6_tracker_sparql_error;
			}
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_inner_error_->domain == G_DBUS_ERROR) {
#line 1854 "tracker-direct.c"
				goto __catch6_g_dbus_error;
			}
			goto __catch6_g_error;
		}
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = _tmp0_;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = NULL;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_data2_->_result_);
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->_result_ = _tmp4_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (_tmp0_);
#line 1869 "tracker-direct.c"
	}
	goto __finally6;
	__catch6_g_io_error:
	{
		GError* e_io = NULL;
		GError* _tmp5_;
		GError* _tmp6_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e_io = _inner_error_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = e_io;
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = _g_error_copy0 (_tmp5_);
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->io_error);
#line 263 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->io_error = _tmp6_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_io);
#line 1891 "tracker-direct.c"
	}
	goto __finally6;
	__catch6_tracker_sparql_error:
	{
		GError* e_spql = NULL;
		GError* _tmp7_;
		GError* _tmp8_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e_spql = _inner_error_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = e_spql;
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp8_ = _g_error_copy0 (_tmp7_);
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->sparql_error);
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->sparql_error = _tmp8_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_spql);
#line 1913 "tracker-direct.c"
	}
	goto __finally6;
	__catch6_g_dbus_error:
	{
		GError* e_dbus = NULL;
		GError* _tmp9_;
		GError* _tmp10_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e_dbus = _inner_error_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp9_ = e_dbus;
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp10_ = _g_error_copy0 (_tmp9_);
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->dbus_error);
#line 267 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->dbus_error = _tmp10_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e_dbus);
#line 1935 "tracker-direct.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		GError* _tmp12_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		e = _inner_error_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_inner_error_ = NULL;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp11_ = e;
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp12_ = _g_error_copy0 (_tmp11_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (_data2_->_error_);
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data2_->_error_ = _tmp12_;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_error_free0 (e);
#line 1957 "tracker-direct.c"
	}
	__finally6:
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1962 "tracker-direct.c"
		gboolean _tmp13_ = FALSE;
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_clear_error (&_inner_error_);
#line 260 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return _tmp13_;
#line 1970 "tracker-direct.c"
	}
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp14_ = _data2_->context;
#line 272 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_main_context_invoke_full (_tmp14_, G_PRIORITY_DEFAULT, ___lambda6__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = FALSE;
#line 277 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1980 "tracker-direct.c"
}


static gboolean ___lambda5__gio_scheduler_job_func (GIOSchedulerJob* job, GCancellable* cancellable, gpointer self) {
	gboolean result;
	result = __lambda5_ (self, job, cancellable);
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 1989 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_query_async_co (TrackerDirectConnectionQueryAsyncData* _data_) {
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	switch (_data_->_state_) {
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 0:
#line 1998 "tracker-direct.c"
		goto _state_0;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 1:
#line 2002 "tracker-direct.c"
		goto _state_1;
		default:
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_assert_not_reached ();
#line 2007 "tracker-direct.c"
	}
	_state_0:
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_ = g_slice_new0 (Block2Data);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->_ref_count_ = 1;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->self = g_object_ref (_data_->self);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->_data2_->sparql);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->sparql = _data_->_tmp0_;
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->_async_data_ = _data_;
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->sparql_error = NULL;
#line 253 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->io_error = NULL;
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->dbus_error = NULL;
#line 255 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->_error_ = NULL;
#line 256 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->_result_ = NULL;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp1_ = g_main_context_get_thread_default ();
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp2_ = _g_main_context_ref0 (_data_->_tmp1_);
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_->context = _data_->_tmp2_;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp3_ = _data_->cancellable;
#line 259 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_io_scheduler_push_job (___lambda5__gio_scheduler_job_func, block2_data_ref (_data_->_data2_), block2_data_unref, G_PRIORITY_DEFAULT, _data_->_tmp3_);
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_state_ = 1;
#line 280 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 2048 "tracker-direct.c"
	_state_1:
	;
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp5_ = _data_->cancellable;
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_tmp5_ != NULL) {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp6_ = _data_->cancellable;
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp7_ = g_cancellable_is_cancelled (_data_->_tmp6_);
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp4_ = _data_->_tmp7_;
#line 2061 "tracker-direct.c"
	} else {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp4_ = FALSE;
#line 2065 "tracker-direct.c"
	}
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_tmp4_) {
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp8_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Operation was cancelled");
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_inner_error_ = _data_->_tmp8_;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			block2_data_unref (_data_->_data2_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_data2_ = NULL;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_object_unref (_data_->_async_result);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return FALSE;
#line 2085 "tracker-direct.c"
		} else {
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			block2_data_unref (_data_->_data2_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_data2_ = NULL;
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_data_->_inner_error_);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_object_unref (_data_->_async_result);
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return FALSE;
#line 2099 "tracker-direct.c"
		}
	} else {
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp9_ = _data_->_data2_->sparql_error;
#line 284 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (_data_->_tmp9_ != NULL) {
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp10_ = _data_->_data2_->sparql_error;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp11_ = _g_error_copy0 (_data_->_tmp10_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_inner_error_ = _data_->_tmp11_;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				block2_data_unref (_data_->_data2_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_data2_ = NULL;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				g_object_unref (_data_->_async_result);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				return FALSE;
#line 2124 "tracker-direct.c"
			} else {
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				block2_data_unref (_data_->_data2_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_data2_ = NULL;
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				g_clear_error (&_data_->_inner_error_);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				g_object_unref (_data_->_async_result);
#line 285 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				return FALSE;
#line 2138 "tracker-direct.c"
			}
		} else {
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_data_->_tmp12_ = _data_->_data2_->io_error;
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			if (_data_->_tmp12_ != NULL) {
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp13_ = _data_->_data2_->io_error;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_inner_error_ = _data_->_tmp14_;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					block2_data_unref (_data_->_data2_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data2_ = NULL;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					g_object_unref (_data_->_async_result);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 2163 "tracker-direct.c"
				} else {
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					block2_data_unref (_data_->_data2_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data2_ = NULL;
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					g_clear_error (&_data_->_inner_error_);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					g_object_unref (_data_->_async_result);
#line 287 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 2177 "tracker-direct.c"
				}
			} else {
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				_data_->_tmp15_ = _data_->_data2_->dbus_error;
#line 288 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				if (_data_->_tmp15_ != NULL) {
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp16_ = _data_->_data2_->dbus_error;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_inner_error_ = _data_->_tmp17_;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						block2_data_unref (_data_->_data2_);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						_data_->_data2_ = NULL;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						g_object_unref (_data_->_async_result);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						return FALSE;
#line 2202 "tracker-direct.c"
					} else {
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						block2_data_unref (_data_->_data2_);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						_data_->_data2_ = NULL;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						g_clear_error (&_data_->_inner_error_);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						g_object_unref (_data_->_async_result);
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						return FALSE;
#line 2216 "tracker-direct.c"
					}
				} else {
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp18_ = _data_->_data2_->_result_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_tmp19_ = _g_object_ref0 (_data_->_tmp18_);
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->result = _data_->_tmp19_;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					block2_data_unref (_data_->_data2_);
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_data_->_data2_ = NULL;
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					if (_data_->_state_ != 0) {
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
						while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2237 "tracker-direct.c"
						}
					}
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					g_object_unref (_data_->_async_result);
#line 291 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					return FALSE;
#line 2244 "tracker-direct.c"
				}
			}
		}
	}
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	block2_data_unref (_data_->_data2_);
#line 250 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_data2_ = NULL;
#line 2253 "tracker-direct.c"
}


static void tracker_direct_connection_real_update (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerDirectConnection * self;
	GError * _inner_error_ = NULL;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 295 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (sparql != NULL);
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_mutex_lock (&self->priv->mutex);
#line 2266 "tracker-direct.c"
	{
		TrackerData* data = NULL;
		TrackerDataManager* _tmp0_;
		TrackerData* _tmp1_;
		TrackerData* _tmp2_;
		TrackerData* _tmp3_;
		const gchar* _tmp4_;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = self->priv->data_manager;
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = tracker_data_manager_get_data (_tmp0_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 298 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		data = _tmp2_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = data;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = sparql;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_data_update_sparql (_tmp3_, _tmp4_, &_inner_error_);
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_object_unref0 (data);
#line 2292 "tracker-direct.c"
			goto __finally7;
		}
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (data);
#line 2297 "tracker-direct.c"
	}
	__finally7:
	{
#line 301 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_mutex_unlock (&self->priv->mutex);
#line 2303 "tracker-direct.c"
	}
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 297 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return;
#line 2311 "tracker-direct.c"
	}
}


static void tracker_direct_connection_real_update_async_data_free (gpointer _data) {
	TrackerDirectConnectionUpdateAsyncData* _data_;
	_data_ = _data;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->sparql);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_slice_free (TrackerDirectConnectionUpdateAsyncData, _data_);
#line 2327 "tracker-direct.c"
}


static void tracker_direct_connection_real_update_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerDirectConnection * self;
	TrackerDirectConnectionUpdateAsyncData* _data_;
	TrackerDirectConnection* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_slice_new0 (TrackerDirectConnectionUpdateAsyncData);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_direct_connection_real_update_async_data_free);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self = _tmp0_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = sparql;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->sparql);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->sparql = _tmp2_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = priority;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->priority = _tmp3_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = cancellable;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->cancellable = _tmp5_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_update_async_co (_data_);
#line 2374 "tracker-direct.c"
}


static void tracker_direct_connection_real_update_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerDirectConnectionUpdateAsyncData* _data_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (NULL == _data_) {
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return;
#line 2386 "tracker-direct.c"
	}
}


static gboolean _tracker_direct_connection_real_update_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_direct_connection_real_update_async_co (self);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 2396 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_update_async_co (TrackerDirectConnectionUpdateAsyncData* _data_) {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	switch (_data_->_state_) {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 0:
#line 2405 "tracker-direct.c"
		goto _state_0;
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 1:
#line 2409 "tracker-direct.c"
		goto _state_1;
		default:
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_assert_not_reached ();
#line 2414 "tracker-direct.c"
	}
	_state_0:
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp1_ = _data_->priority;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp2_ = _data_->cancellable;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp3_ = tracker_direct_connection_update_task_new (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->task = _data_->_tmp3_;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp4_ = _data_->task;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	(((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target_destroy_notify (((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target), NULL);
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback = NULL;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target = NULL;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target_destroy_notify = NULL;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback = _tracker_direct_connection_real_update_async_co_gsource_func;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target = _data_;
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target_destroy_notify = NULL;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp5_ = _data_->self->priv->update_queue;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp6_ = _data_->task;
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp7_ = _tracker_direct_connection_task_ref0 ((TrackerDirectConnectionTask*) _data_->_tmp6_);
#line 308 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_async_queue_push (_data_->_tmp5_, _data_->_tmp7_);
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_state_ = 1;
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 2455 "tracker-direct.c"
	_state_1:
	;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp8_ = _data_->task;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp9_ = ((TrackerDirectConnectionTask*) _data_->_tmp8_)->error;
#line 311 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_tmp9_ != NULL) {
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp10_ = _data_->task;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp11_ = ((TrackerDirectConnectionTask*) _data_->_tmp10_)->error;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_inner_error_ = _data_->_tmp12_;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tracker_direct_connection_task_unref0 (_data_->task);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_object_unref (_data_->_async_result);
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return FALSE;
#line 2480 "tracker-direct.c"
	}
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tracker_direct_connection_task_unref0 (_data_->task);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_state_ != 0) {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2492 "tracker-direct.c"
		}
	}
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_object_unref (_data_->_async_result);
#line 305 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 2499 "tracker-direct.c"
}


static GVariant* tracker_direct_connection_real_update_blank (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GError** error) {
	TrackerDirectConnection * self;
	GVariant* result = NULL;
	GVariant* blank_nodes = NULL;
	GError * _inner_error_ = NULL;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 315 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	blank_nodes = NULL;
#line 317 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_mutex_lock (&self->priv->mutex);
#line 2516 "tracker-direct.c"
	{
		TrackerData* data = NULL;
		TrackerDataManager* _tmp0_;
		TrackerData* _tmp1_;
		TrackerData* _tmp2_;
		GVariant* _tmp3_ = NULL;
		TrackerData* _tmp4_;
		const gchar* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = self->priv->data_manager;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = tracker_data_manager_get_data (_tmp0_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		data = _tmp2_;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = data;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = sparql;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = tracker_data_update_sparql_blank (_tmp4_, _tmp5_, &_inner_error_);
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = _tmp6_;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_object_unref0 (data);
#line 2547 "tracker-direct.c"
			goto __finally8;
		}
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = _tmp3_;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = NULL;
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_variant_unref0 (blank_nodes);
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		blank_nodes = _tmp7_;
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_variant_unref0 (_tmp3_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (data);
#line 2562 "tracker-direct.c"
	}
	__finally8:
	{
#line 322 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_mutex_unlock (&self->priv->mutex);
#line 2568 "tracker-direct.c"
	}
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_propagate_error (error, _inner_error_);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_variant_unref0 (blank_nodes);
#line 318 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 2578 "tracker-direct.c"
	}
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = blank_nodes;
#line 325 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 2584 "tracker-direct.c"
}


static void tracker_direct_connection_real_update_blank_async_data_free (gpointer _data) {
	TrackerDirectConnectionUpdateBlankAsyncData* _data_;
	_data_ = _data;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->sparql);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_variant_unref0 (_data_->result);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_slice_free (TrackerDirectConnectionUpdateBlankAsyncData, _data_);
#line 2601 "tracker-direct.c"
}


static void tracker_direct_connection_real_update_blank_async (TrackerSparqlConnection* base, const gchar* sparql, gint priority, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerDirectConnection * self;
	TrackerDirectConnectionUpdateBlankAsyncData* _data_;
	TrackerDirectConnection* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_slice_new0 (TrackerDirectConnectionUpdateBlankAsyncData);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_direct_connection_real_update_blank_async_data_free);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self = _tmp0_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = sparql;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (_data_->sparql);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->sparql = _tmp2_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = priority;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->priority = _tmp3_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = cancellable;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->cancellable = _tmp5_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_update_blank_async_co (_data_);
#line 2648 "tracker-direct.c"
}


static GVariant* tracker_direct_connection_real_update_blank_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	GVariant* result;
	TrackerDirectConnectionUpdateBlankAsyncData* _data_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (NULL == _data_) {
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return NULL;
#line 2661 "tracker-direct.c"
	}
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = _data_->result;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->result = NULL;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 2669 "tracker-direct.c"
}


static gboolean _tracker_direct_connection_real_update_blank_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_direct_connection_real_update_blank_async_co (self);
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 2678 "tracker-direct.c"
}


static gpointer _g_variant_ref0 (gpointer self) {
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self ? g_variant_ref (self) : NULL;
#line 2685 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_update_blank_async_co (TrackerDirectConnectionUpdateBlankAsyncData* _data_) {
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	switch (_data_->_state_) {
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 0:
#line 2694 "tracker-direct.c"
		goto _state_0;
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 1:
#line 2698 "tracker-direct.c"
		goto _state_1;
		default:
#line 328 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_assert_not_reached ();
#line 2703 "tracker-direct.c"
	}
	_state_0:
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp0_ = _data_->sparql;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp1_ = _data_->priority;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp2_ = _data_->cancellable;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp3_ = tracker_direct_connection_update_task_new_blank (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp2_);
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->task = _data_->_tmp3_;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp4_ = _data_->task;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	(((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target_destroy_notify (((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target), NULL);
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback = NULL;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target = NULL;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target_destroy_notify = NULL;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback = _tracker_direct_connection_real_update_blank_async_co_gsource_func;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target = _data_;
#line 330 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp4_)->callback_target_destroy_notify = NULL;
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp5_ = _data_->self->priv->update_queue;
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp6_ = _data_->task;
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp7_ = _tracker_direct_connection_task_ref0 ((TrackerDirectConnectionTask*) _data_->_tmp6_);
#line 331 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_async_queue_push (_data_->_tmp5_, _data_->_tmp7_);
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_state_ = 1;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 2744 "tracker-direct.c"
	_state_1:
	;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp8_ = _data_->task;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp9_ = ((TrackerDirectConnectionTask*) _data_->_tmp8_)->error;
#line 334 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_tmp9_ != NULL) {
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp10_ = _data_->task;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp11_ = ((TrackerDirectConnectionTask*) _data_->_tmp10_)->error;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp12_ = _g_error_copy0 (_data_->_tmp11_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_inner_error_ = _data_->_tmp12_;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tracker_direct_connection_task_unref0 (_data_->task);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_object_unref (_data_->_async_result);
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return FALSE;
#line 2769 "tracker-direct.c"
	}
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp13_ = _data_->task;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp14_ = _data_->_tmp13_->blank_nodes;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp15_ = _g_variant_ref0 (_data_->_tmp14_);
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->result = _data_->_tmp15_;
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tracker_direct_connection_task_unref0 (_data_->task);
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_state_ != 0) {
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2789 "tracker-direct.c"
		}
	}
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_object_unref (_data_->_async_result);
#line 337 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 2796 "tracker-direct.c"
}


static void tracker_direct_connection_real_load (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GError** error) {
	TrackerDirectConnection * self;
	GError * _inner_error_ = NULL;
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (file != NULL);
#line 341 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_mutex_lock (&self->priv->mutex);
#line 2809 "tracker-direct.c"
	{
		TrackerData* data = NULL;
		TrackerDataManager* _tmp0_;
		TrackerData* _tmp1_;
		TrackerData* _tmp2_;
		TrackerData* _tmp3_;
		GFile* _tmp4_;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = self->priv->data_manager;
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp1_ = tracker_data_manager_get_data (_tmp0_);
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 343 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		data = _tmp2_;
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = data;
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = file;
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_data_load_turtle_file (_tmp3_, _tmp4_, &_inner_error_);
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_object_unref0 (data);
#line 2835 "tracker-direct.c"
			goto __finally9;
		}
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (data);
#line 2840 "tracker-direct.c"
	}
	__finally9:
	{
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_mutex_unlock (&self->priv->mutex);
#line 2846 "tracker-direct.c"
	}
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (((_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_inner_error_->domain == G_IO_ERROR)) || (_inner_error_->domain == G_DBUS_ERROR)) {
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_propagate_error (error, _inner_error_);
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return;
#line 2856 "tracker-direct.c"
		} else {
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_inner_error_);
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return;
#line 2864 "tracker-direct.c"
		}
	}
}


static void tracker_direct_connection_real_load_async_data_free (gpointer _data) {
	TrackerDirectConnectionLoadAsyncData* _data_;
	_data_ = _data;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->file);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_slice_free (TrackerDirectConnectionLoadAsyncData, _data_);
#line 2881 "tracker-direct.c"
}


static void tracker_direct_connection_real_load_async (TrackerSparqlConnection* base, GFile* file, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TrackerDirectConnection * self;
	TrackerDirectConnectionLoadAsyncData* _data_;
	TrackerDirectConnection* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_slice_new0 (TrackerDirectConnectionLoadAsyncData);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_direct_connection_real_load_async_data_free);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->self = _tmp0_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = file;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->file);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->file = _tmp2_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = cancellable;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (_data_->cancellable);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->cancellable = _tmp4_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_real_load_async_co (_data_);
#line 2923 "tracker-direct.c"
}


static void tracker_direct_connection_real_load_finish (TrackerSparqlConnection* base, GAsyncResult* _res_, GError** error) {
	TrackerDirectConnectionLoadAsyncData* _data_;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (NULL == _data_) {
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return;
#line 2935 "tracker-direct.c"
	}
}


static gboolean _tracker_direct_connection_real_load_async_co_gsource_func (gpointer self) {
	gboolean result;
	result = tracker_direct_connection_real_load_async_co (self);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 2945 "tracker-direct.c"
}


static gboolean tracker_direct_connection_real_load_async_co (TrackerDirectConnectionLoadAsyncData* _data_) {
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	switch (_data_->_state_) {
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 0:
#line 2954 "tracker-direct.c"
		goto _state_0;
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		case 1:
#line 2958 "tracker-direct.c"
		goto _state_1;
		default:
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_assert_not_reached ();
#line 2963 "tracker-direct.c"
	}
	_state_0:
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp0_ = _data_->file;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp2_ = tracker_direct_connection_turtle_task_new (_data_->_tmp0_, _data_->_tmp1_);
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->task = _data_->_tmp2_;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp3_ = _data_->task;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	(((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback_target_destroy_notify == NULL) ? NULL : (((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback_target_destroy_notify (((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback_target), NULL);
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback = NULL;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback_target = NULL;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback_target_destroy_notify = NULL;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback = _tracker_direct_connection_real_load_async_co_gsource_func;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback_target = _data_;
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) _data_->_tmp3_)->callback_target_destroy_notify = NULL;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp4_ = _data_->self->priv->update_queue;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp5_ = _data_->task;
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp6_ = _tracker_direct_connection_task_ref0 ((TrackerDirectConnectionTask*) _data_->_tmp5_);
#line 353 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_async_queue_push (_data_->_tmp4_, _data_->_tmp6_);
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_state_ = 1;
#line 354 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 3002 "tracker-direct.c"
	_state_1:
	;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp7_ = _data_->task;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_data_->_tmp8_ = ((TrackerDirectConnectionTask*) _data_->_tmp7_)->error;
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_tmp8_ != NULL) {
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp9_ = _data_->task;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp10_ = ((TrackerDirectConnectionTask*) _data_->_tmp9_)->error;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp11_ = _data_->_tmp10_->message;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_tmp12_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_INTERNAL, _data_->_tmp11_);
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_data_->_inner_error_ = _data_->_tmp12_;
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (((_data_->_inner_error_->domain == TRACKER_SPARQL_ERROR) || (_data_->_inner_error_->domain == G_IO_ERROR)) || (_data_->_inner_error_->domain == G_DBUS_ERROR)) {
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tracker_direct_connection_task_unref0 (_data_->task);
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_object_unref (_data_->_async_result);
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return FALSE;
#line 3031 "tracker-direct.c"
		} else {
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_tracker_direct_connection_task_unref0 (_data_->task);
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_clear_error (&_data_->_inner_error_);
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_object_unref (_data_->_async_result);
#line 357 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return FALSE;
#line 3043 "tracker-direct.c"
		}
	}
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tracker_direct_connection_task_unref0 (_data_->task);
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_data_->_state_ != 0) {
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3056 "tracker-direct.c"
		}
	}
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_object_unref (_data_->_async_result);
#line 350 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return FALSE;
#line 3063 "tracker-direct.c"
}


static TrackerNamespaceManager* tracker_direct_connection_real_get_namespace_manager (TrackerSparqlConnection* base) {
	TrackerDirectConnection * self;
	TrackerNamespaceManager* result = NULL;
	gboolean _tmp0_ = FALSE;
	TrackerNamespaceManager* _tmp1_;
	TrackerNamespaceManager* _tmp17_;
	TrackerNamespaceManager* _tmp18_;
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnection*) base;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = self->priv->namespace_manager;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_tmp1_ == NULL) {
#line 3080 "tracker-direct.c"
		TrackerDataManager* _tmp2_;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp2_ = self->priv->data_manager;
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 3086 "tracker-direct.c"
	} else {
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp0_ = FALSE;
#line 3090 "tracker-direct.c"
	}
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (_tmp0_) {
#line 3094 "tracker-direct.c"
		GHashTable* ht = NULL;
		TrackerDataManager* _tmp3_;
		GHashTable* _tmp4_;
		TrackerNamespaceManager* _tmp5_;
		GHashTable* _tmp6_;
		GList* _tmp7_;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp3_ = self->priv->data_manager;
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp4_ = tracker_data_manager_get_namespaces (_tmp3_);
#line 362 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		ht = _tmp4_;
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp5_ = tracker_namespace_manager_new ();
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_object_unref0 (self->priv->namespace_manager);
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		self->priv->namespace_manager = _tmp5_;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp6_ = ht;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_tmp7_ = g_hash_table_get_keys (_tmp6_);
#line 3117 "tracker-direct.c"
		{
			GList* prefix_collection = NULL;
			GList* prefix_it = NULL;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			prefix_collection = _tmp7_;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			for (prefix_it = prefix_collection; prefix_it != NULL; prefix_it = prefix_it->next) {
#line 3125 "tracker-direct.c"
				const gchar* prefix = NULL;
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
				prefix = (const gchar*) prefix_it->data;
#line 3129 "tracker-direct.c"
				{
					const gchar* _tmp8_;
					GHashTable* _tmp9_;
					const gchar* _tmp10_;
					gconstpointer _tmp11_;
					TrackerNamespaceManager* _tmp12_;
					const gchar* _tmp13_;
					GHashTable* _tmp14_;
					const gchar* _tmp15_;
					gconstpointer _tmp16_;
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp8_ = prefix;
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp9_ = ht;
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp10_ = prefix;
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
#line 366 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					g_print ("%s %s\n", _tmp8_, (const gchar*) _tmp11_);
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp12_ = self->priv->namespace_manager;
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp13_ = prefix;
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp14_ = ht;
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp15_ = prefix;
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
					tracker_namespace_manager_add_prefix (_tmp12_, _tmp13_, (const gchar*) _tmp16_);
#line 3162 "tracker-direct.c"
				}
			}
#line 365 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			_g_list_free0 (prefix_collection);
#line 3167 "tracker-direct.c"
		}
#line 361 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		_g_hash_table_unref0 (ht);
#line 3171 "tracker-direct.c"
	}
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp17_ = self->priv->namespace_manager;
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp18_ = _g_object_ref0 (_tmp17_);
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	result = _tmp18_;
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return result;
#line 3181 "tracker-direct.c"
}


static TrackerDirectConnectionTask* tracker_direct_connection_task_construct (GType object_type) {
	TrackerDirectConnectionTask* self = NULL;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnectionTask*) g_type_create_instance (object_type);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self;
#line 3191 "tracker-direct.c"
}


static void tracker_direct_connection_value_task_init (GValue* value) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	value->data[0].v_pointer = NULL;
#line 3198 "tracker-direct.c"
}


static void tracker_direct_connection_value_task_free_value (GValue* value) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (value->data[0].v_pointer) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_direct_connection_task_unref (value->data[0].v_pointer);
#line 3207 "tracker-direct.c"
	}
}


static void tracker_direct_connection_value_task_copy_value (const GValue* src_value, GValue* dest_value) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (src_value->data[0].v_pointer) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		dest_value->data[0].v_pointer = tracker_direct_connection_task_ref (src_value->data[0].v_pointer);
#line 3217 "tracker-direct.c"
	} else {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3221 "tracker-direct.c"
	}
}


static gpointer tracker_direct_connection_value_task_peek_pointer (const GValue* value) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return value->data[0].v_pointer;
#line 3229 "tracker-direct.c"
}


static gchar* tracker_direct_connection_value_task_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (collect_values[0].v_pointer) {
#line 3236 "tracker-direct.c"
		TrackerDirectConnectionTask * object;
		object = collect_values[0].v_pointer;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		if (object->parent_instance.g_class == NULL) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3243 "tracker-direct.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3247 "tracker-direct.c"
		}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		value->data[0].v_pointer = tracker_direct_connection_task_ref (object);
#line 3251 "tracker-direct.c"
	} else {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		value->data[0].v_pointer = NULL;
#line 3255 "tracker-direct.c"
	}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return NULL;
#line 3259 "tracker-direct.c"
}


static gchar* tracker_direct_connection_value_task_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TrackerDirectConnectionTask ** object_p;
	object_p = collect_values[0].v_pointer;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (!object_p) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3270 "tracker-direct.c"
	}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (!value->data[0].v_pointer) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		*object_p = NULL;
#line 3276 "tracker-direct.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		*object_p = value->data[0].v_pointer;
#line 3280 "tracker-direct.c"
	} else {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		*object_p = tracker_direct_connection_task_ref (value->data[0].v_pointer);
#line 3284 "tracker-direct.c"
	}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return NULL;
#line 3288 "tracker-direct.c"
}


static GParamSpec* tracker_direct_connection_param_spec_task (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	TrackerDirectConnectionParamSpecTask* spec;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_DIRECT_CONNECTION_TYPE_TASK), NULL);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return G_PARAM_SPEC (spec);
#line 3302 "tracker-direct.c"
}


static gpointer tracker_direct_connection_value_get_task (const GValue* value) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_DIRECT_CONNECTION_TYPE_TASK), NULL);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return value->data[0].v_pointer;
#line 3311 "tracker-direct.c"
}


static void tracker_direct_connection_value_set_task (GValue* value, gpointer v_object) {
	TrackerDirectConnectionTask * old;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_DIRECT_CONNECTION_TYPE_TASK));
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	old = value->data[0].v_pointer;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (v_object) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_DIRECT_CONNECTION_TYPE_TASK));
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		value->data[0].v_pointer = v_object;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_direct_connection_task_ref (value->data[0].v_pointer);
#line 3331 "tracker-direct.c"
	} else {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		value->data[0].v_pointer = NULL;
#line 3335 "tracker-direct.c"
	}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (old) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_direct_connection_task_unref (old);
#line 3341 "tracker-direct.c"
	}
}


static void tracker_direct_connection_value_take_task (GValue* value, gpointer v_object) {
	TrackerDirectConnectionTask * old;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_DIRECT_CONNECTION_TYPE_TASK));
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	old = value->data[0].v_pointer;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (v_object) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_DIRECT_CONNECTION_TYPE_TASK));
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		value->data[0].v_pointer = v_object;
#line 3360 "tracker-direct.c"
	} else {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		value->data[0].v_pointer = NULL;
#line 3364 "tracker-direct.c"
	}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (old) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		tracker_direct_connection_task_unref (old);
#line 3370 "tracker-direct.c"
	}
}


static void tracker_direct_connection_task_class_init (TrackerDirectConnectionTaskClass * klass) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_task_parent_class = g_type_class_peek_parent (klass);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTaskClass *) klass)->finalize = tracker_direct_connection_task_finalize;
#line 3380 "tracker-direct.c"
}


static void tracker_direct_connection_task_instance_init (TrackerDirectConnectionTask * self) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->ref_count = 1;
#line 3387 "tracker-direct.c"
}


static void tracker_direct_connection_task_finalize (TrackerDirectConnectionTask * obj) {
	TrackerDirectConnectionTask * self;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_DIRECT_CONNECTION_TYPE_TASK, TrackerDirectConnectionTask);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_signal_handlers_destroy (self);
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->cancellable);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	(self->callback_target_destroy_notify == NULL) ? NULL : (self->callback_target_destroy_notify (self->callback_target), NULL);
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->callback = NULL;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->callback_target = NULL;
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->callback_target_destroy_notify = NULL;
#line 58 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_error_free0 (self->error);
#line 3409 "tracker-direct.c"
}


static GType tracker_direct_connection_task_get_type (void) {
	static volatile gsize tracker_direct_connection_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_connection_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_direct_connection_value_task_init, tracker_direct_connection_value_task_free_value, tracker_direct_connection_value_task_copy_value, tracker_direct_connection_value_task_peek_pointer, "p", tracker_direct_connection_value_task_collect_value, "p", tracker_direct_connection_value_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDirectConnectionTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_direct_connection_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDirectConnectionTask), 0, (GInstanceInitFunc) tracker_direct_connection_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_direct_connection_task_type_id;
		tracker_direct_connection_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerDirectConnectionTask", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&tracker_direct_connection_task_type_id__volatile, tracker_direct_connection_task_type_id);
	}
	return tracker_direct_connection_task_type_id__volatile;
}


static gpointer tracker_direct_connection_task_ref (gpointer instance) {
	TrackerDirectConnectionTask * self;
	self = instance;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_atomic_int_inc (&self->ref_count);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return instance;
#line 3434 "tracker-direct.c"
}


static void tracker_direct_connection_task_unref (gpointer instance) {
	TrackerDirectConnectionTask * self;
	self = instance;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		TRACKER_DIRECT_CONNECTION_TASK_GET_CLASS (self)->finalize (self);
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3447 "tracker-direct.c"
	}
}


static void tracker_direct_connection_update_task_set (TrackerDirectConnectionUpdateTask* self, TrackerDirectConnectionTaskType type, const gchar* sparql, gint priority, GCancellable* cancellable) {
	TrackerDirectConnectionTaskType _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	GCancellable* _tmp4_;
	GCancellable* _tmp5_;
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_if_fail (sparql != NULL);
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = type;
#line 66 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) self)->type = _tmp0_;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = sparql;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (self->sparql);
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->sparql = _tmp2_;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = priority;
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) self)->priority = _tmp3_;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp4_ = cancellable;
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (((TrackerDirectConnectionTask*) self)->cancellable);
#line 69 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) self)->cancellable = _tmp5_;
#line 3487 "tracker-direct.c"
}


static TrackerDirectConnectionUpdateTask* tracker_direct_connection_update_task_construct (GType object_type, const gchar* sparql, gint priority, GCancellable* cancellable) {
	TrackerDirectConnectionUpdateTask* self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	GCancellable* _tmp2_;
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnectionUpdateTask*) tracker_direct_connection_task_construct (object_type);
#line 73 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = sparql;
#line 73 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = priority;
#line 73 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = cancellable;
#line 73 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_update_task_set (self, TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE, _tmp0_, _tmp1_, _tmp2_);
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self;
#line 3510 "tracker-direct.c"
}


static TrackerDirectConnectionUpdateTask* tracker_direct_connection_update_task_new (const gchar* sparql, gint priority, GCancellable* cancellable) {
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return tracker_direct_connection_update_task_construct (TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK, sparql, priority, cancellable);
#line 3517 "tracker-direct.c"
}


static TrackerDirectConnectionUpdateTask* tracker_direct_connection_update_task_construct_blank (GType object_type, const gchar* sparql, gint priority, GCancellable* cancellable) {
	TrackerDirectConnectionUpdateTask* self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	GCancellable* _tmp2_;
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnectionUpdateTask*) tracker_direct_connection_task_construct (object_type);
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = sparql;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = priority;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = cancellable;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_update_task_set (self, TRACKER_DIRECT_CONNECTION_TASK_TYPE_UPDATE_BLANK, _tmp0_, _tmp1_, _tmp2_);
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self;
#line 3540 "tracker-direct.c"
}


static TrackerDirectConnectionUpdateTask* tracker_direct_connection_update_task_new_blank (const gchar* sparql, gint priority, GCancellable* cancellable) {
#line 76 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return tracker_direct_connection_update_task_construct_blank (TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK, sparql, priority, cancellable);
#line 3547 "tracker-direct.c"
}


static void tracker_direct_connection_update_task_class_init (TrackerDirectConnectionUpdateTaskClass * klass) {
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_update_task_parent_class = g_type_class_peek_parent (klass);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTaskClass *) klass)->finalize = tracker_direct_connection_update_task_finalize;
#line 3556 "tracker-direct.c"
}


static void tracker_direct_connection_update_task_instance_init (TrackerDirectConnectionUpdateTask * self) {
}


static void tracker_direct_connection_update_task_finalize (TrackerDirectConnectionTask * obj) {
	TrackerDirectConnectionUpdateTask * self;
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_DIRECT_CONNECTION_TYPE_UPDATE_TASK, TrackerDirectConnectionUpdateTask);
#line 62 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_free0 (self->sparql);
#line 63 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_variant_unref0 (self->blank_nodes);
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	TRACKER_DIRECT_CONNECTION_TASK_CLASS (tracker_direct_connection_update_task_parent_class)->finalize (obj);
#line 3574 "tracker-direct.c"
}


static GType tracker_direct_connection_update_task_get_type (void) {
	static volatile gsize tracker_direct_connection_update_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_connection_update_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDirectConnectionUpdateTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_direct_connection_update_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDirectConnectionUpdateTask), 0, (GInstanceInitFunc) tracker_direct_connection_update_task_instance_init, NULL };
		GType tracker_direct_connection_update_task_type_id;
		tracker_direct_connection_update_task_type_id = g_type_register_static (TRACKER_DIRECT_CONNECTION_TYPE_TASK, "TrackerDirectConnectionUpdateTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_direct_connection_update_task_type_id__volatile, tracker_direct_connection_update_task_type_id);
	}
	return tracker_direct_connection_update_task_type_id__volatile;
}


static TrackerDirectConnectionTurtleTask* tracker_direct_connection_turtle_task_construct (GType object_type, GFile* file, GCancellable* cancellable) {
	TrackerDirectConnectionTurtleTask* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = (TrackerDirectConnectionTurtleTask*) tracker_direct_connection_task_construct (object_type);
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) self)->type = TRACKER_DIRECT_CONNECTION_TASK_TYPE_TURTLE;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp0_ = file;
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->file);
#line 86 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->file = _tmp1_;
#line 87 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) self)->priority = G_PRIORITY_DEFAULT;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp2_ = cancellable;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (((TrackerDirectConnectionTask*) self)->cancellable);
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTask*) self)->cancellable = _tmp3_;
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return self;
#line 3622 "tracker-direct.c"
}


static TrackerDirectConnectionTurtleTask* tracker_direct_connection_turtle_task_new (GFile* file, GCancellable* cancellable) {
#line 84 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	return tracker_direct_connection_turtle_task_construct (TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK, file, cancellable);
#line 3629 "tracker-direct.c"
}


static void tracker_direct_connection_turtle_task_class_init (TrackerDirectConnectionTurtleTaskClass * klass) {
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_turtle_task_parent_class = g_type_class_peek_parent (klass);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerDirectConnectionTaskClass *) klass)->finalize = tracker_direct_connection_turtle_task_finalize;
#line 3638 "tracker-direct.c"
}


static void tracker_direct_connection_turtle_task_instance_init (TrackerDirectConnectionTurtleTask * self) {
}


static void tracker_direct_connection_turtle_task_finalize (TrackerDirectConnectionTask * obj) {
	TrackerDirectConnectionTurtleTask * self;
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_DIRECT_CONNECTION_TYPE_TURTLE_TASK, TrackerDirectConnectionTurtleTask);
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->file);
#line 81 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	TRACKER_DIRECT_CONNECTION_TASK_CLASS (tracker_direct_connection_turtle_task_parent_class)->finalize (obj);
#line 3654 "tracker-direct.c"
}


static GType tracker_direct_connection_turtle_task_get_type (void) {
	static volatile gsize tracker_direct_connection_turtle_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_connection_turtle_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDirectConnectionTurtleTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_direct_connection_turtle_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDirectConnectionTurtleTask), 0, (GInstanceInitFunc) tracker_direct_connection_turtle_task_instance_init, NULL };
		GType tracker_direct_connection_turtle_task_type_id;
		tracker_direct_connection_turtle_task_type_id = g_type_register_static (TRACKER_DIRECT_CONNECTION_TYPE_TASK, "TrackerDirectConnectionTurtleTask", &g_define_type_info, 0);
		g_once_init_leave (&tracker_direct_connection_turtle_task_type_id__volatile, tracker_direct_connection_turtle_task_type_id);
	}
	return tracker_direct_connection_turtle_task_type_id__volatile;
}


static void tracker_direct_connection_class_init (TrackerDirectConnectionClass * klass) {
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_parent_class = g_type_class_peek_parent (klass);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_type_class_add_private (klass, sizeof (TrackerDirectConnectionPrivate));
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((GObjectClass *) klass)->dispose = (void (*) (GObject *)) tracker_direct_connection_real_dispose;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->query = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GError**)) tracker_direct_connection_real_query;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->query_async = (void (*) (TrackerSparqlConnection *, const gchar*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_direct_connection_real_query_async;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->query_finish = (TrackerSparqlCursor* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_direct_connection_real_query_finish;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->update = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_direct_connection_real_update;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->update_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_direct_connection_real_update_async;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->update_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_direct_connection_real_update_finish;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank = (GVariant* (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GError**)) tracker_direct_connection_real_update_blank;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_async = (void (*) (TrackerSparqlConnection *, const gchar*, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_direct_connection_real_update_blank_async;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->update_blank_finish = (GVariant* (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_direct_connection_real_update_blank_finish;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->load = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GError**)) tracker_direct_connection_real_load;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->load_async = (void (*) (TrackerSparqlConnection *, GFile*, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_direct_connection_real_load_async;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->load_finish = (void (*) (TrackerSparqlConnection *, GAsyncResult*, GError**)) tracker_direct_connection_real_load_finish;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	((TrackerSparqlConnectionClass *) klass)->get_namespace_manager = (TrackerNamespaceManager* (*) (TrackerSparqlConnection *)) tracker_direct_connection_real_get_namespace_manager;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_direct_connection_finalize;
#line 3705 "tracker-direct.c"
}


static void tracker_direct_connection_g_async_initable_interface_init (GAsyncInitableIface * iface) {
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_g_async_initable_parent_iface = g_type_interface_peek_parent (iface);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	iface->init_async = (void (*) (GAsyncInitable *, gint, GCancellable*, GAsyncReadyCallback, gpointer)) tracker_direct_connection_real_init_async;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	iface->init_finish = (gboolean (*) (GAsyncInitable *, GAsyncResult*, GError**)) tracker_direct_connection_real_init_finish;
#line 3716 "tracker-direct.c"
}


static void tracker_direct_connection_g_initable_interface_init (GInitableIface * iface) {
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	tracker_direct_connection_g_initable_parent_iface = g_type_interface_peek_parent (iface);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	iface->init = (gboolean (*) (GInitable *, GCancellable*, GError**)) tracker_direct_connection_real_init;
#line 3725 "tracker-direct.c"
}


static void tracker_direct_connection_instance_init (TrackerDirectConnection * self) {
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->priv = TRACKER_DIRECT_CONNECTION_GET_PRIVATE (self);
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_mutex_init (&self->priv->mutex);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_mutex_init (&self->priv->init_mutex);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	g_cond_init (&self->priv->init_cond);
#line 3738 "tracker-direct.c"
}


static void tracker_direct_connection_finalize (GObject * obj) {
	TrackerDirectConnection * self;
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_DIRECT_TYPE_CONNECTION, TrackerDirectConnection);
#line 22 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->priv->database_loc);
#line 23 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->priv->journal_loc);
#line 24 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->priv->ontology_loc);
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->priv->data_manager);
#line 30 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_vala_clear_GMutex (&self->priv->mutex);
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_thread_unref0 (self->priv->thread);
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_vala_clear_GMutex (&self->priv->init_mutex);
#line 35 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_vala_clear_GCond (&self->priv->init_cond);
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_error_free0 (self->priv->init_error);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	(self->init_callback_target_destroy_notify == NULL) ? NULL : (self->init_callback_target_destroy_notify (self->init_callback_target), NULL);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->init_callback = NULL;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->init_callback_target = NULL;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	self->init_callback_target_destroy_notify = NULL;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_async_queue_unref0 (self->priv->update_queue);
#line 41 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	_g_object_unref0 (self->priv->namespace_manager);
#line 21 "/home/carlos/Source/gnome/tracker/src/libtracker-direct/tracker-direct.vala"
	G_OBJECT_CLASS (tracker_direct_connection_parent_class)->finalize (obj);
#line 3778 "tracker-direct.c"
}


GType tracker_direct_connection_get_type (void) {
	static volatile gsize tracker_direct_connection_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_direct_connection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerDirectConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_direct_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerDirectConnection), 0, (GInstanceInitFunc) tracker_direct_connection_instance_init, NULL };
		static const GInterfaceInfo g_async_initable_info = { (GInterfaceInitFunc) tracker_direct_connection_g_async_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) tracker_direct_connection_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tracker_direct_connection_type_id;
		tracker_direct_connection_type_id = g_type_register_static (TRACKER_SPARQL_TYPE_CONNECTION, "TrackerDirectConnection", &g_define_type_info, 0);
		g_type_add_interface_static (tracker_direct_connection_type_id, g_async_initable_get_type (), &g_async_initable_info);
		g_type_add_interface_static (tracker_direct_connection_type_id, g_initable_get_type (), &g_initable_info);
		g_once_init_leave (&tracker_direct_connection_type_id__volatile, tracker_direct_connection_type_id);
	}
	return tracker_direct_connection_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



