/* valagtkmodule.c generated by valac, the Vala compiler
 * generated from valagtkmodule.vala, do not modify */

/* valagtkmodule.vala
 *
 * Copyright (C) 2013  Jürg Billeter
 * Copyright (C) 2013-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <glib/gstdio.h>
#include <valaccode.h>

enum  {
	VALA_GTK_MODULE_DUMMY_PROPERTY,
	VALA_GTK_MODULE_LAST_PROPERTY
};
static GParamSpec* vala_gtk_module_properties[VALA_GTK_MODULE_LAST_PROPERTY];
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaGtkModulePrivate {
	ValaHashMap* type_id_to_vala_map;
	ValaHashMap* cclass_to_vala_map;
	ValaHashMap* gresource_to_file_map;
	ValaHashMap* current_handler_to_signal_map;
	ValaHashMap* current_child_to_class_map;
	ValaList* current_required_app_classes;
};


static gpointer vala_gtk_module_parent_class = NULL;

#define VALA_GTK_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GTK_MODULE, ValaGtkModulePrivate))
static void vala_gtk_module_ensure_type_id_to_vala_map (ValaGtkModule* self);
static void vala_gtk_module_recurse_type_id_to_vala_map (ValaGtkModule* self, ValaNamespace* ns);
static void vala_gtk_module_ensure_cclass_to_vala_map (ValaGtkModule* self);
static void vala_gtk_module_recurse_cclass_to_vala_map (ValaGtkModule* self, ValaNamespace* ns);
static void vala_gtk_module_ensure_gresource_to_file_map (ValaGtkModule* self);
static void vala_gtk_module_process_current_ui_resource (ValaGtkModule* self, const gchar* ui_resource, ValaCodeNode* node);
static gboolean vala_gtk_module_is_gtk_template (ValaGtkModule* self, ValaClass* cl);
static void vala_gtk_module_real_generate_class_init (ValaGTypeModule* base, ValaClass* cl);
static void vala_gtk_module_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_gtk_module_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_gtk_module_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_gtk_module_real_end_instance_init (ValaGTypeModule* base, ValaClass* cl);
static void vala_gtk_module_finalize (ValaCodeVisitor * obj);


static void vala_gtk_module_ensure_type_id_to_vala_map (ValaGtkModule* self) {
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->type_id_to_vala_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->type_id_to_vala_map);
	self->priv->type_id_to_vala_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_gtk_module_recurse_type_id_to_vala_map (self, _tmp8_);
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void vala_gtk_module_recurse_type_id_to_vala_map (ValaGtkModule* self, ValaNamespace* ns) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	{
		ValaList* _cl_list = NULL;
		ValaNamespace* _tmp0_;
		ValaList* _tmp1_;
		gint _cl_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _cl_index = 0;
		_tmp0_ = ns;
		_tmp1_ = vala_namespace_get_classes (_tmp0_);
		_cl_list = _tmp1_;
		_tmp2_ = _cl_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_cl_size = _tmp4_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaClass* cl = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaClass* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _cl_index;
			_cl_index = _tmp5_ + 1;
			_tmp6_ = _cl_index;
			_tmp7_ = _cl_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _cl_list;
			_tmp9_ = _cl_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			cl = (ValaClass*) _tmp10_;
			_tmp11_ = cl;
			_tmp12_ = vala_class_get_is_compact (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				gchar* type_id = NULL;
				ValaClass* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gint i = 0;
				const gchar* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				ValaHashMap* _tmp27_;
				const gchar* _tmp28_;
				ValaClass* _tmp29_;
				_tmp14_ = cl;
				_tmp15_ = vala_ccode_base_module_get_ccode_type_id ((ValaCodeNode*) _tmp14_);
				type_id = _tmp15_;
				_tmp16_ = type_id;
				if (_tmp16_ == NULL) {
					_g_free0 (type_id);
					_vala_code_node_unref0 (cl);
					continue;
				}
				_tmp17_ = type_id;
				_tmp18_ = string_index_of_char (_tmp17_, (gunichar) '(', 0);
				i = _tmp18_;
				_tmp19_ = i;
				if (_tmp19_ > 0) {
					const gchar* _tmp20_;
					gint _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp20_ = type_id;
					_tmp21_ = i;
					_tmp22_ = string_substring (_tmp20_, (glong) 0, (glong) (_tmp21_ - 1));
					_tmp23_ = _tmp22_;
					_tmp24_ = string_strip (_tmp23_);
					_g_free0 (type_id);
					type_id = _tmp24_;
					_g_free0 (_tmp23_);
				} else {
					const gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp25_ = type_id;
					_tmp26_ = string_strip (_tmp25_);
					_g_free0 (type_id);
					type_id = _tmp26_;
				}
				_tmp27_ = self->priv->type_id_to_vala_map;
				_tmp28_ = type_id;
				_tmp29_ = cl;
				vala_map_set ((ValaMap*) _tmp27_, _tmp28_, _tmp29_);
				_g_free0 (type_id);
			}
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _inner_list = NULL;
		ValaNamespace* _tmp30_;
		ValaList* _tmp31_;
		gint _inner_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _inner_index = 0;
		_tmp30_ = ns;
		_tmp31_ = vala_namespace_get_namespaces (_tmp30_);
		_inner_list = _tmp31_;
		_tmp32_ = _inner_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_inner_size = _tmp34_;
		_inner_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			ValaNamespace* inner = NULL;
			ValaList* _tmp38_;
			gint _tmp39_;
			gpointer _tmp40_;
			ValaNamespace* _tmp41_;
			_tmp35_ = _inner_index;
			_inner_index = _tmp35_ + 1;
			_tmp36_ = _inner_index;
			_tmp37_ = _inner_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _inner_list;
			_tmp39_ = _inner_index;
			_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
			inner = (ValaNamespace*) _tmp40_;
			_tmp41_ = inner;
			vala_gtk_module_recurse_type_id_to_vala_map (self, _tmp41_);
			_vala_code_node_unref0 (inner);
		}
		_vala_iterable_unref0 (_inner_list);
	}
}


static void vala_gtk_module_ensure_cclass_to_vala_map (ValaGtkModule* self) {
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaNamespace* _tmp7_;
	ValaNamespace* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cclass_to_vala_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->cclass_to_vala_map);
	self->priv->cclass_to_vala_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_context_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	vala_gtk_module_recurse_cclass_to_vala_map (self, _tmp8_);
}


static void vala_gtk_module_recurse_cclass_to_vala_map (ValaGtkModule* self, ValaNamespace* ns) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	{
		ValaList* _cl_list = NULL;
		ValaNamespace* _tmp0_;
		ValaList* _tmp1_;
		gint _cl_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _cl_index = 0;
		_tmp0_ = ns;
		_tmp1_ = vala_namespace_get_classes (_tmp0_);
		_cl_list = _tmp1_;
		_tmp2_ = _cl_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_cl_size = _tmp4_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaClass* cl = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaClass* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _cl_index;
			_cl_index = _tmp5_ + 1;
			_tmp6_ = _cl_index;
			_tmp7_ = _cl_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _cl_list;
			_tmp9_ = _cl_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			cl = (ValaClass*) _tmp10_;
			_tmp11_ = cl;
			_tmp12_ = vala_class_get_is_compact (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				ValaHashMap* _tmp14_;
				ValaClass* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				ValaClass* _tmp18_;
				_tmp14_ = self->priv->cclass_to_vala_map;
				_tmp15_ = cl;
				_tmp16_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = cl;
				vala_map_set ((ValaMap*) _tmp14_, _tmp17_, _tmp18_);
				_g_free0 (_tmp17_);
			}
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _inner_list = NULL;
		ValaNamespace* _tmp19_;
		ValaList* _tmp20_;
		gint _inner_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _inner_index = 0;
		_tmp19_ = ns;
		_tmp20_ = vala_namespace_get_namespaces (_tmp19_);
		_inner_list = _tmp20_;
		_tmp21_ = _inner_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_inner_size = _tmp23_;
		_inner_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaNamespace* inner = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaNamespace* _tmp30_;
			_tmp24_ = _inner_index;
			_inner_index = _tmp24_ + 1;
			_tmp25_ = _inner_index;
			_tmp26_ = _inner_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _inner_list;
			_tmp28_ = _inner_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			inner = (ValaNamespace*) _tmp29_;
			_tmp30_ = inner;
			vala_gtk_module_recurse_cclass_to_vala_map (self, _tmp30_);
			_vala_code_node_unref0 (inner);
		}
		_vala_iterable_unref0 (_inner_list);
	}
}


static void vala_gtk_module_ensure_gresource_to_file_map (ValaGtkModule* self) {
	ValaHashMap* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashMap* _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaCodeContext* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gresource_to_file_map;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp1_, _tmp2_, _tmp3_);
	_vala_map_unref0 (self->priv->gresource_to_file_map);
	self->priv->gresource_to_file_map = _tmp4_;
	_tmp5_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->gresources;
	_tmp7__length1 = _tmp6_->gresources_length1;
	{
		gchar** gresource_collection = NULL;
		gint gresource_collection_length1 = 0;
		gint _gresource_collection_size_ = 0;
		gint gresource_it = 0;
		gresource_collection = _tmp7_;
		gresource_collection_length1 = _tmp7__length1;
		for (gresource_it = 0; gresource_it < _tmp7__length1; gresource_it = gresource_it + 1) {
			gchar* _tmp8_;
			gchar* gresource = NULL;
			_tmp8_ = g_strdup (gresource_collection[gresource_it]);
			gresource = _tmp8_;
			{
				const gchar* _tmp9_;
				gboolean _tmp10_;
				ValaMarkupReader* reader = NULL;
				const gchar* _tmp14_;
				ValaMarkupReader* _tmp15_;
				gint state = 0;
				gchar* prefix = NULL;
				gchar* alias = NULL;
				ValaMarkupTokenType current_token = 0;
				ValaMarkupReader* _tmp16_;
				ValaMarkupTokenType _tmp17_;
				_tmp9_ = gresource;
				_tmp10_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
				if (!_tmp10_) {
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp11_ = gresource;
					_tmp12_ = g_strdup_printf ("GResources file `%s' does not exist", _tmp11_);
					_tmp13_ = _tmp12_;
					vala_report_error (NULL, _tmp13_);
					_g_free0 (_tmp13_);
					_g_free0 (gresource);
					continue;
				}
				_tmp14_ = gresource;
				_tmp15_ = vala_markup_reader_new (_tmp14_);
				reader = _tmp15_;
				state = 0;
				prefix = NULL;
				alias = NULL;
				_tmp16_ = reader;
				_tmp17_ = vala_markup_reader_read_token (_tmp16_, NULL, NULL);
				current_token = _tmp17_;
				while (TRUE) {
					ValaMarkupTokenType _tmp18_;
					gboolean _tmp19_ = FALSE;
					ValaMarkupTokenType _tmp20_;
					ValaMarkupReader* _tmp58_;
					ValaMarkupTokenType _tmp59_;
					_tmp18_ = current_token;
					if (!(_tmp18_ != VALA_MARKUP_TOKEN_TYPE_EOF)) {
						break;
					}
					_tmp20_ = current_token;
					if (_tmp20_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
						ValaMarkupReader* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						_tmp21_ = reader;
						_tmp22_ = vala_markup_reader_get_name (_tmp21_);
						_tmp23_ = _tmp22_;
						_tmp19_ = g_strcmp0 (_tmp23_, "gresource") == 0;
					} else {
						_tmp19_ = FALSE;
					}
					if (_tmp19_) {
						ValaMarkupReader* _tmp24_;
						gchar* _tmp25_;
						_tmp24_ = reader;
						_tmp25_ = vala_markup_reader_get_attribute (_tmp24_, "prefix");
						_g_free0 (prefix);
						prefix = _tmp25_;
					} else {
						gboolean _tmp26_ = FALSE;
						ValaMarkupTokenType _tmp27_;
						_tmp27_ = current_token;
						if (_tmp27_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
							ValaMarkupReader* _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							_tmp28_ = reader;
							_tmp29_ = vala_markup_reader_get_name (_tmp28_);
							_tmp30_ = _tmp29_;
							_tmp26_ = g_strcmp0 (_tmp30_, "file") == 0;
						} else {
							_tmp26_ = FALSE;
						}
						if (_tmp26_) {
							ValaMarkupReader* _tmp31_;
							gchar* _tmp32_;
							_tmp31_ = reader;
							_tmp32_ = vala_markup_reader_get_attribute (_tmp31_, "alias");
							_g_free0 (alias);
							alias = _tmp32_;
							state = 1;
						} else {
							gboolean _tmp33_ = FALSE;
							gint _tmp34_;
							_tmp34_ = state;
							if (_tmp34_ == 1) {
								ValaMarkupTokenType _tmp35_;
								_tmp35_ = current_token;
								_tmp33_ = _tmp35_ == VALA_MARKUP_TOKEN_TYPE_TEXT;
							} else {
								_tmp33_ = FALSE;
							}
							if (_tmp33_) {
								gchar* name = NULL;
								ValaMarkupReader* _tmp36_;
								const gchar* _tmp37_;
								const gchar* _tmp38_;
								gchar* _tmp39_;
								gchar* filename = NULL;
								ValaCodeContext* _tmp40_;
								ValaCodeContext* _tmp41_;
								const gchar* _tmp42_;
								const gchar* _tmp43_;
								gchar* _tmp44_;
								const gchar* _tmp45_;
								ValaHashMap* _tmp52_;
								const gchar* _tmp53_;
								const gchar* _tmp54_;
								gchar* _tmp55_;
								gchar* _tmp56_;
								const gchar* _tmp57_;
								_tmp36_ = reader;
								_tmp37_ = vala_markup_reader_get_content (_tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = g_strdup (_tmp38_);
								name = _tmp39_;
								_tmp40_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
								_tmp41_ = _tmp40_;
								_tmp42_ = gresource;
								_tmp43_ = name;
								_tmp44_ = vala_code_context_get_gresource_path (_tmp41_, _tmp42_, _tmp43_);
								filename = _tmp44_;
								_tmp45_ = alias;
								if (_tmp45_ != NULL) {
									ValaHashMap* _tmp46_;
									const gchar* _tmp47_;
									const gchar* _tmp48_;
									gchar* _tmp49_;
									gchar* _tmp50_;
									const gchar* _tmp51_;
									_tmp46_ = self->priv->gresource_to_file_map;
									_tmp47_ = prefix;
									_tmp48_ = alias;
									_tmp49_ = g_build_filename (_tmp47_, _tmp48_, NULL);
									_tmp50_ = _tmp49_;
									_tmp51_ = filename;
									vala_map_set ((ValaMap*) _tmp46_, _tmp50_, _tmp51_);
									_g_free0 (_tmp50_);
								}
								_tmp52_ = self->priv->gresource_to_file_map;
								_tmp53_ = prefix;
								_tmp54_ = name;
								_tmp55_ = g_build_filename (_tmp53_, _tmp54_, NULL);
								_tmp56_ = _tmp55_;
								_tmp57_ = filename;
								vala_map_set ((ValaMap*) _tmp52_, _tmp56_, _tmp57_);
								_g_free0 (_tmp56_);
								state = 0;
								_g_free0 (filename);
								_g_free0 (name);
							}
						}
					}
					_tmp58_ = reader;
					_tmp59_ = vala_markup_reader_read_token (_tmp58_, NULL, NULL);
					current_token = _tmp59_;
				}
				_g_free0 (alias);
				_g_free0 (prefix);
				_vala_markup_reader_unref0 (reader);
				_g_free0 (gresource);
			}
		}
	}
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex = NULL;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_ = NULL;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void vala_gtk_module_process_current_ui_resource (ValaGtkModule* self, const gchar* ui_resource, ValaCodeNode* node) {
	gchar* ui_file = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GEqualFunc _tmp16_;
	ValaHashMap* _tmp17_;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	GEqualFunc _tmp20_;
	ValaHashMap* _tmp21_;
	ValaMarkupReader* reader = NULL;
	const gchar* _tmp22_;
	ValaMarkupReader* _tmp23_;
	ValaClass* current_class = NULL;
	gboolean template_tag_found = FALSE;
	ValaMarkupTokenType current_token = 0;
	ValaMarkupReader* _tmp24_;
	ValaMarkupTokenType _tmp25_;
	gboolean _tmp106_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ui_resource != NULL);
	g_return_if_fail (node != NULL);
	vala_gtk_module_ensure_type_id_to_vala_map (self);
	vala_gtk_module_ensure_cclass_to_vala_map (self);
	vala_gtk_module_ensure_gresource_to_file_map (self);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	self->priv->current_handler_to_signal_map = NULL;
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	self->priv->current_child_to_class_map = NULL;
	_tmp0_ = self->priv->gresource_to_file_map;
	_tmp1_ = ui_resource;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	ui_file = (gchar*) _tmp2_;
	_tmp4_ = ui_file;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = ui_file;
		_tmp6_ = g_file_test (_tmp5_, G_FILE_TEST_EXISTS);
		_tmp3_ = !_tmp6_;
	}
	if (_tmp3_) {
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp7_ = node;
		vala_code_node_set_error (_tmp7_, TRUE);
		_tmp8_ = node;
		_tmp9_ = vala_code_node_get_source_reference (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = ui_resource;
		_tmp12_ = g_strdup_printf ("UI resource not found: `%s'. Please make sure to specify the proper GR" \
"esources xml files with --gresources and alternative search locations " \
"with --gresourcesdir.", _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp10_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (ui_file);
		return;
	}
	_tmp14_ = g_str_hash;
	_tmp15_ = g_str_equal;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_, _tmp15_, _tmp16_);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	self->priv->current_handler_to_signal_map = _tmp17_;
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_, _tmp19_, _tmp20_);
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	self->priv->current_child_to_class_map = _tmp21_;
	_tmp22_ = ui_file;
	_tmp23_ = vala_markup_reader_new (_tmp22_);
	reader = _tmp23_;
	current_class = NULL;
	template_tag_found = FALSE;
	_tmp24_ = reader;
	_tmp25_ = vala_markup_reader_read_token (_tmp24_, NULL, NULL);
	current_token = _tmp25_;
	while (TRUE) {
		ValaMarkupTokenType _tmp26_;
		const gchar* current_name = NULL;
		ValaMarkupReader* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gboolean _tmp30_ = FALSE;
		ValaMarkupTokenType _tmp31_;
		ValaMarkupReader* _tmp104_;
		ValaMarkupTokenType _tmp105_;
		_tmp26_ = current_token;
		if (!(_tmp26_ != VALA_MARKUP_TOKEN_TYPE_EOF)) {
			break;
		}
		_tmp27_ = reader;
		_tmp28_ = vala_markup_reader_get_name (_tmp27_);
		_tmp29_ = _tmp28_;
		current_name = _tmp29_;
		_tmp31_ = current_token;
		if (_tmp31_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gboolean _tmp32_ = FALSE;
			const gchar* _tmp33_;
			_tmp33_ = current_name;
			if (g_strcmp0 (_tmp33_, "object") == 0) {
				_tmp32_ = TRUE;
			} else {
				const gchar* _tmp34_;
				_tmp34_ = current_name;
				_tmp32_ = g_strcmp0 (_tmp34_, "template") == 0;
			}
			_tmp30_ = _tmp32_;
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			const gchar* _tmp35_;
			ValaClass* _tmp43_;
			ValaClass* _tmp59_;
			_vala_code_node_unref0 (current_class);
			current_class = NULL;
			_tmp35_ = current_name;
			if (g_strcmp0 (_tmp35_, "object") == 0) {
				gchar* type_id = NULL;
				ValaMarkupReader* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp36_ = reader;
				_tmp37_ = vala_markup_reader_get_attribute (_tmp36_, "type-func");
				type_id = _tmp37_;
				_tmp38_ = type_id;
				if (_tmp38_ != NULL) {
					ValaHashMap* _tmp39_;
					const gchar* _tmp40_;
					gpointer _tmp41_;
					_tmp39_ = self->priv->type_id_to_vala_map;
					_tmp40_ = type_id;
					_tmp41_ = vala_map_get ((ValaMap*) _tmp39_, _tmp40_);
					_vala_code_node_unref0 (current_class);
					current_class = (ValaClass*) _tmp41_;
				}
				_g_free0 (type_id);
			} else {
				const gchar* _tmp42_;
				_tmp42_ = current_name;
				if (g_strcmp0 (_tmp42_, "template") == 0) {
					template_tag_found = TRUE;
				}
			}
			_tmp43_ = current_class;
			if (_tmp43_ == NULL) {
				gchar* class_name = NULL;
				ValaMarkupReader* _tmp44_;
				gchar* _tmp45_;
				const gchar* _tmp46_;
				ValaHashMap* _tmp56_;
				const gchar* _tmp57_;
				gpointer _tmp58_;
				_tmp44_ = reader;
				_tmp45_ = vala_markup_reader_get_attribute (_tmp44_, "class");
				class_name = _tmp45_;
				_tmp46_ = class_name;
				if (_tmp46_ == NULL) {
					ValaCodeNode* _tmp47_;
					ValaSourceReference* _tmp48_;
					ValaSourceReference* _tmp49_;
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					gchar* _tmp52_;
					gchar* _tmp53_;
					ValaMarkupReader* _tmp54_;
					ValaMarkupTokenType _tmp55_;
					_tmp47_ = node;
					_tmp48_ = vala_code_node_get_source_reference (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = current_name;
					_tmp51_ = ui_file;
					_tmp52_ = g_strdup_printf ("Invalid %s in ui file `%s'", _tmp50_, _tmp51_);
					_tmp53_ = _tmp52_;
					vala_report_error (_tmp49_, _tmp53_);
					_g_free0 (_tmp53_);
					_tmp54_ = reader;
					_tmp55_ = vala_markup_reader_read_token (_tmp54_, NULL, NULL);
					current_token = _tmp55_;
					_g_free0 (class_name);
					continue;
				}
				_tmp56_ = self->priv->cclass_to_vala_map;
				_tmp57_ = class_name;
				_tmp58_ = vala_map_get ((ValaMap*) _tmp56_, _tmp57_);
				_vala_code_node_unref0 (current_class);
				current_class = (ValaClass*) _tmp58_;
				_g_free0 (class_name);
			}
			_tmp59_ = current_class;
			if (_tmp59_ != NULL) {
				gchar* child_name = NULL;
				ValaMarkupReader* _tmp60_;
				gchar* _tmp61_;
				const gchar* _tmp62_;
				_tmp60_ = reader;
				_tmp61_ = vala_markup_reader_get_attribute (_tmp60_, "id");
				child_name = _tmp61_;
				_tmp62_ = child_name;
				if (_tmp62_ != NULL) {
					ValaHashMap* _tmp63_;
					const gchar* _tmp64_;
					ValaClass* _tmp65_;
					_tmp63_ = self->priv->current_child_to_class_map;
					_tmp64_ = child_name;
					_tmp65_ = current_class;
					vala_map_set ((ValaMap*) _tmp63_, _tmp64_, _tmp65_);
				}
				_g_free0 (child_name);
			}
		} else {
			gboolean _tmp66_ = FALSE;
			gboolean _tmp67_ = FALSE;
			ValaClass* _tmp68_;
			_tmp68_ = current_class;
			if (_tmp68_ != NULL) {
				ValaMarkupTokenType _tmp69_;
				_tmp69_ = current_token;
				_tmp67_ = _tmp69_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				const gchar* _tmp70_;
				_tmp70_ = current_name;
				_tmp66_ = g_strcmp0 (_tmp70_, "signal") == 0;
			} else {
				_tmp66_ = FALSE;
			}
			if (_tmp66_) {
				gchar* signal_name = NULL;
				ValaMarkupReader* _tmp71_;
				gchar* _tmp72_;
				gchar* handler_name = NULL;
				ValaMarkupReader* _tmp73_;
				gchar* _tmp74_;
				ValaClass* _tmp75_;
				_tmp71_ = reader;
				_tmp72_ = vala_markup_reader_get_attribute (_tmp71_, "name");
				signal_name = _tmp72_;
				_tmp73_ = reader;
				_tmp74_ = vala_markup_reader_get_attribute (_tmp73_, "handler");
				handler_name = _tmp74_;
				_tmp75_ = current_class;
				if (_tmp75_ != NULL) {
					gboolean _tmp76_ = FALSE;
					const gchar* _tmp77_;
					gint sep_idx = 0;
					const gchar* _tmp87_;
					gint _tmp88_;
					gint _tmp89_;
					ValaSignal* sig = NULL;
					ValaClass* _tmp93_;
					const gchar* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaSymbol* _tmp97_;
					ValaSignal* _tmp98_;
					ValaSignal* _tmp99_;
					ValaSignal* _tmp100_;
					_tmp77_ = signal_name;
					if (_tmp77_ == NULL) {
						_tmp76_ = TRUE;
					} else {
						const gchar* _tmp78_;
						_tmp78_ = handler_name;
						_tmp76_ = _tmp78_ == NULL;
					}
					if (_tmp76_) {
						ValaCodeNode* _tmp79_;
						ValaSourceReference* _tmp80_;
						ValaSourceReference* _tmp81_;
						const gchar* _tmp82_;
						gchar* _tmp83_;
						gchar* _tmp84_;
						ValaMarkupReader* _tmp85_;
						ValaMarkupTokenType _tmp86_;
						_tmp79_ = node;
						_tmp80_ = vala_code_node_get_source_reference (_tmp79_);
						_tmp81_ = _tmp80_;
						_tmp82_ = ui_file;
						_tmp83_ = g_strdup_printf ("Invalid signal in ui file `%s'", _tmp82_);
						_tmp84_ = _tmp83_;
						vala_report_error (_tmp81_, _tmp84_);
						_g_free0 (_tmp84_);
						_tmp85_ = reader;
						_tmp86_ = vala_markup_reader_read_token (_tmp85_, NULL, NULL);
						current_token = _tmp86_;
						_g_free0 (handler_name);
						_g_free0 (signal_name);
						continue;
					}
					_tmp87_ = signal_name;
					_tmp88_ = string_index_of (_tmp87_, "::", 0);
					sep_idx = _tmp88_;
					_tmp89_ = sep_idx;
					if (_tmp89_ >= 0) {
						const gchar* _tmp90_;
						gint _tmp91_;
						gchar* _tmp92_;
						_tmp90_ = signal_name;
						_tmp91_ = sep_idx;
						_tmp92_ = string_substring (_tmp90_, (glong) 0, (glong) _tmp91_);
						_g_free0 (signal_name);
						signal_name = _tmp92_;
					}
					_tmp93_ = current_class;
					_tmp94_ = signal_name;
					_tmp95_ = string_replace (_tmp94_, "-", "_");
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp93_, _tmp96_);
					_tmp98_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_SIGNAL) ? ((ValaSignal*) _tmp97_) : NULL;
					if (_tmp98_ == NULL) {
						_vala_code_node_unref0 (_tmp97_);
					}
					_tmp99_ = _tmp98_;
					_g_free0 (_tmp96_);
					sig = _tmp99_;
					_tmp100_ = sig;
					if (_tmp100_ != NULL) {
						ValaHashMap* _tmp101_;
						const gchar* _tmp102_;
						ValaSignal* _tmp103_;
						_tmp101_ = self->priv->current_handler_to_signal_map;
						_tmp102_ = handler_name;
						_tmp103_ = sig;
						vala_map_set ((ValaMap*) _tmp101_, _tmp102_, _tmp103_);
					}
					_vala_code_node_unref0 (sig);
				}
				_g_free0 (handler_name);
				_g_free0 (signal_name);
			}
		}
		_tmp104_ = reader;
		_tmp105_ = vala_markup_reader_read_token (_tmp104_, NULL, NULL);
		current_token = _tmp105_;
	}
	_tmp106_ = template_tag_found;
	if (!_tmp106_) {
		ValaCodeNode* _tmp107_;
		ValaSourceReference* _tmp108_;
		ValaSourceReference* _tmp109_;
		const gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		_tmp107_ = node;
		_tmp108_ = vala_code_node_get_source_reference (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = ui_resource;
		_tmp111_ = g_strdup_printf ("ui resource `%s' does not describe a valid composite template", _tmp110_);
		_tmp112_ = _tmp111_;
		vala_report_error (_tmp109_, _tmp112_);
		_g_free0 (_tmp112_);
	}
	_vala_code_node_unref0 (current_class);
	_vala_markup_reader_unref0 (reader);
	_g_free0 (ui_file);
}


static gboolean vala_gtk_module_is_gtk_template (ValaGtkModule* self, ValaClass* cl) {
	gboolean result = FALSE;
	ValaAttribute* attr = NULL;
	ValaClass* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = cl;
	_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp0_, "GtkTemplate");
	attr = _tmp1_;
	_tmp2_ = attr;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaClass* _tmp4_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->gtk_widget_type;
		if (_tmp4_ == NULL) {
			_tmp3_ = TRUE;
		} else {
			ValaClass* _tmp5_;
			ValaClass* _tmp6_;
			gboolean _tmp7_;
			_tmp5_ = cl;
			_tmp6_ = ((ValaCCodeBaseModule*) self)->gtk_widget_type;
			_tmp7_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp5_, (ValaTypeSymbol*) _tmp6_);
			_tmp3_ = !_tmp7_;
		}
		if (_tmp3_) {
			ValaClass* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp8_ = cl;
			_tmp9_ = vala_code_node_get_error ((ValaCodeNode*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (!_tmp10_) {
				ValaAttribute* _tmp11_;
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				ValaClass* _tmp14_;
				_tmp11_ = attr;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp11_);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "subclassing Gtk.Widget is required for using Gtk templates");
				_tmp14_ = cl;
				vala_code_node_set_error ((ValaCodeNode*) _tmp14_, TRUE);
			}
			result = FALSE;
			_vala_code_node_unref0 (attr);
			return result;
		}
		result = TRUE;
		_vala_code_node_unref0 (attr);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (attr);
	return result;
}


static void vala_gtk_module_real_generate_class_init (ValaGTypeModule* base, ValaClass* cl) {
	ValaGtkModule * self;
	ValaClass* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaClass* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ValaClass* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gchar* ui = NULL;
	ValaClass* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp40_;
	ValaClass* _tmp41_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeIdentifier* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaClass* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	ValaCCodeConstant* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunctionCall* _tmp61_;
	ValaList* _tmp62_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	VALA_GTYPE_MODULE_CLASS (vala_gtk_module_parent_class)->generate_class_init ((ValaGTypeModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), _tmp0_);
	_tmp2_ = cl;
	_tmp3_ = vala_code_node_get_error ((ValaCodeNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		ValaClass* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = cl;
		_tmp6_ = vala_gtk_module_is_gtk_template (self, _tmp5_);
		_tmp1_ = !_tmp6_;
	}
	if (_tmp1_) {
		return;
	}
	_tmp7_ = cl;
	_tmp8_ = vala_class_get_has_private_fields (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gchar* private_offset = NULL;
		ValaClass* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaCCodeFunction* _tmp15_;
		ValaCCodeFunction* _tmp16_;
		const gchar* _tmp17_;
		ValaCCodeVariableDeclarator* _tmp18_;
		ValaCCodeVariableDeclarator* _tmp19_;
		ValaCCodeFunctionCall* cgetprivcall = NULL;
		ValaCCodeIdentifier* _tmp20_;
		ValaCCodeIdentifier* _tmp21_;
		ValaCCodeFunctionCall* _tmp22_;
		ValaCCodeFunctionCall* _tmp23_;
		ValaCCodeFunctionCall* _tmp24_;
		ValaCCodeIdentifier* _tmp25_;
		ValaCCodeIdentifier* _tmp26_;
		ValaCCodeFunction* _tmp27_;
		ValaCCodeFunction* _tmp28_;
		const gchar* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeFunctionCall* _tmp32_;
		_tmp10_ = cl;
		_tmp11_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("%s_private_offset", _tmp12_);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		private_offset = _tmp14_;
		_tmp15_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = private_offset;
		_tmp18_ = vala_ccode_variable_declarator_new (_tmp17_, NULL, NULL);
		_tmp19_ = _tmp18_;
		vala_ccode_function_add_declaration (_tmp16_, "gint", (ValaCCodeDeclarator*) _tmp19_, 0);
		_vala_ccode_node_unref0 (_tmp19_);
		_tmp20_ = vala_ccode_identifier_new ("g_type_class_get_instance_private_offset");
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
		_tmp23_ = _tmp22_;
		_vala_ccode_node_unref0 (_tmp21_);
		cgetprivcall = _tmp23_;
		_tmp24_ = cgetprivcall;
		_tmp25_ = vala_ccode_identifier_new ("klass");
		_tmp26_ = _tmp25_;
		vala_ccode_function_call_add_argument (_tmp24_, (ValaCCodeExpression*) _tmp26_);
		_vala_ccode_node_unref0 (_tmp26_);
		_tmp27_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = private_offset;
		_tmp30_ = vala_ccode_identifier_new (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = cgetprivcall;
		vala_ccode_function_add_assignment (_tmp28_, (ValaCCodeExpression*) _tmp31_, (ValaCCodeExpression*) _tmp32_);
		_vala_ccode_node_unref0 (_tmp31_);
		_vala_ccode_node_unref0 (cgetprivcall);
		_g_free0 (private_offset);
	}
	_tmp33_ = cl;
	_tmp34_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp33_, "GtkTemplate", "ui", NULL);
	ui = _tmp34_;
	_tmp35_ = ui;
	if (_tmp35_ == NULL) {
		ValaClass* _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaClass* _tmp39_;
		_tmp36_ = cl;
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp36_);
		_tmp38_ = _tmp37_;
		vala_report_error (_tmp38_, "empty ui resource declaration for Gtk widget template");
		_tmp39_ = cl;
		vala_code_node_set_error ((ValaCodeNode*) _tmp39_, TRUE);
		_g_free0 (ui);
		return;
	}
	_tmp40_ = ui;
	_tmp41_ = cl;
	vala_gtk_module_process_current_ui_resource (self, _tmp40_, (ValaCodeNode*) _tmp41_);
	_tmp42_ = vala_ccode_identifier_new ("gtk_widget_class_set_template_from_resource");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	call = _tmp45_;
	_tmp46_ = call;
	_tmp47_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = call;
	_tmp50_ = cl;
	_tmp51_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp50_, "GtkTemplate", "ui", NULL);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strconcat ("\"", _tmp52_, NULL);
	_tmp54_ = _tmp53_;
	_tmp55_ = g_strconcat (_tmp54_, "\"", NULL);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_ccode_constant_new (_tmp56_);
	_tmp58_ = _tmp57_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp58_);
	_vala_ccode_node_unref0 (_tmp58_);
	_g_free0 (_tmp56_);
	_g_free0 (_tmp54_);
	_g_free0 (_tmp52_);
	_tmp59_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp60_ = _tmp59_;
	_tmp61_ = call;
	vala_ccode_function_add_expression (_tmp60_, (ValaCCodeExpression*) _tmp61_);
	_tmp62_ = self->priv->current_required_app_classes;
	vala_collection_clear ((ValaCollection*) _tmp62_);
	_vala_ccode_node_unref0 (call);
	_g_free0 (ui);
}


static void vala_gtk_module_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaGtkModule * self;
	ValaProperty* _tmp0_;
	ValaAttribute* _tmp1_;
	ValaAttribute* _tmp2_;
	gboolean _tmp3_;
	ValaProperty* _tmp7_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp0_, "GtkChild");
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_vala_code_node_unref0 (_tmp2_);
	if (_tmp3_) {
		ValaProperty* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp4_ = prop;
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp4_);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "Annotating properties with [GtkChild] is not yet supported");
	}
	_tmp7_ = prop;
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_property ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), _tmp7_);
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer _vala_ccode_node_ref0 (gpointer self) {
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void vala_gtk_module_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaGtkModule * self;
	ValaField* _tmp0_;
	ValaClass* cl = NULL;
	ValaClass* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaClass* _tmp5_;
	gboolean _tmp9_ = FALSE;
	ValaField* _tmp10_;
	ValaMemberBinding _tmp11_;
	ValaMemberBinding _tmp12_;
	ValaClass* _tmp16_;
	gboolean _tmp17_;
	ValaCCodeBaseModuleEmitContext* _tmp21_;
	gchar* gtk_name = NULL;
	ValaField* _tmp22_;
	ValaField* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	ValaClass* child_class = NULL;
	ValaHashMap* _tmp27_;
	const gchar* _tmp28_;
	gpointer _tmp29_;
	ValaClass* _tmp30_;
	ValaClass* field_class = NULL;
	ValaField* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	ValaTypeSymbol* _tmp40_;
	ValaTypeSymbol* _tmp41_;
	ValaClass* _tmp42_;
	gboolean _tmp43_ = FALSE;
	ValaClass* _tmp44_;
	gboolean internal_child = FALSE;
	ValaField* _tmp59_;
	gboolean _tmp60_;
	ValaCCodeExpression* offset = NULL;
	ValaField* _tmp61_;
	gboolean _tmp62_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeFunctionCall* _tmp111_;
	ValaCCodeFunctionCall* _tmp112_;
	ValaCCodeIdentifier* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeFunctionCall* _tmp115_;
	const gchar* _tmp116_;
	gchar* _tmp117_;
	gchar* _tmp118_;
	ValaCCodeConstant* _tmp119_;
	ValaCCodeConstant* _tmp120_;
	const gchar* _tmp121_ = NULL;
	gboolean _tmp122_;
	ValaCCodeFunctionCall* _tmp123_;
	ValaCCodeConstant* _tmp124_;
	ValaCCodeConstant* _tmp125_;
	ValaCCodeFunctionCall* _tmp126_;
	ValaCCodeExpression* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFunctionCall* _tmp130_;
	gboolean _tmp131_ = FALSE;
	ValaClass* _tmp132_;
	gboolean _tmp133_;
	gboolean _tmp134_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_field ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), _tmp0_);
	_tmp1_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	cl = _tmp3_;
	_tmp5_ = cl;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		ValaClass* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = cl;
		_tmp7_ = vala_code_node_get_error ((ValaCodeNode*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp10_ = f;
	_tmp11_ = vala_field_get_binding (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != VALA_MEMBER_BINDING_INSTANCE) {
		_tmp9_ = TRUE;
	} else {
		ValaField* _tmp13_;
		ValaAttribute* _tmp14_;
		ValaAttribute* _tmp15_;
		_tmp13_ = f;
		_tmp14_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp13_, "GtkChild");
		_tmp15_ = _tmp14_;
		_tmp9_ = _tmp15_ == NULL;
		_vala_code_node_unref0 (_tmp15_);
	}
	if (_tmp9_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp16_ = cl;
	_tmp17_ = vala_gtk_module_is_gtk_template (self, _tmp16_);
	if (!_tmp17_) {
		ValaField* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		_tmp18_ = f;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		vala_report_error (_tmp20_, "[GtkChild] is only allowed in classes with a [GtkTemplate] attribute");
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp21_ = ((ValaCCodeBaseModule*) self)->class_init_context;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp21_);
	_tmp22_ = f;
	_tmp23_ = f;
	_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp22_, "GtkChild", "name", _tmp25_);
	gtk_name = _tmp26_;
	_tmp27_ = self->priv->current_child_to_class_map;
	_tmp28_ = gtk_name;
	_tmp29_ = vala_map_get ((ValaMap*) _tmp27_, _tmp28_);
	child_class = (ValaClass*) _tmp29_;
	_tmp30_ = child_class;
	if (_tmp30_ == NULL) {
		ValaField* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp31_ = f;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = gtk_name;
		_tmp35_ = g_strdup_printf ("could not find child `%s'", _tmp34_);
		_tmp36_ = _tmp35_;
		vala_report_error (_tmp33_, _tmp36_);
		_g_free0 (_tmp36_);
		_vala_code_node_unref0 (child_class);
		_g_free0 (gtk_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp37_ = f;
	_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_data_type_get_data_type (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp41_) : NULL);
	field_class = _tmp42_;
	_tmp44_ = field_class;
	if (_tmp44_ == NULL) {
		_tmp43_ = TRUE;
	} else {
		ValaClass* _tmp45_;
		ValaClass* _tmp46_;
		gboolean _tmp47_;
		_tmp45_ = child_class;
		_tmp46_ = field_class;
		_tmp47_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp45_, (ValaTypeSymbol*) _tmp46_);
		_tmp43_ = !_tmp47_;
	}
	if (_tmp43_) {
		ValaField* _tmp48_;
		ValaSourceReference* _tmp49_;
		ValaSourceReference* _tmp50_;
		ValaClass* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		ValaClass* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp48_ = f;
		_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = child_class;
		_tmp52_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = field_class;
		_tmp55_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strdup_printf ("cannot convert from Gtk child type `%s' to `%s'", _tmp53_, _tmp56_);
		_tmp58_ = _tmp57_;
		vala_report_error (_tmp50_, _tmp58_);
		_g_free0 (_tmp58_);
		_g_free0 (_tmp56_);
		_g_free0 (_tmp53_);
		_vala_code_node_unref0 (field_class);
		_vala_code_node_unref0 (child_class);
		_g_free0 (gtk_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp59_ = f;
	_tmp60_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp59_, "GtkChild", "internal", FALSE);
	internal_child = _tmp60_;
	_tmp61_ = f;
	_tmp62_ = vala_symbol_is_private_symbol ((ValaSymbol*) _tmp61_);
	if (_tmp62_) {
		ValaCCodeFunctionCall* private_field_offset = NULL;
		ValaCCodeIdentifier* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeFunctionCall* _tmp65_;
		ValaCCodeFunctionCall* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaClass* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeIdentifier* _tmp74_;
		ValaCCodeFunctionCall* _tmp75_;
		ValaField* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		ValaCCodeIdentifier* _tmp79_;
		ValaCCodeIdentifier* _tmp80_;
		ValaClass* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		ValaCCodeIdentifier* _tmp86_;
		ValaCCodeIdentifier* _tmp87_;
		ValaCCodeFunctionCall* _tmp88_;
		ValaCCodeBinaryExpression* _tmp89_;
		_tmp63_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
		_tmp66_ = _tmp65_;
		_vala_ccode_node_unref0 (_tmp64_);
		private_field_offset = _tmp66_;
		_tmp67_ = private_field_offset;
		_tmp68_ = cl;
		_tmp69_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = g_strdup_printf ("%sPrivate", _tmp70_);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_ccode_identifier_new (_tmp72_);
		_tmp74_ = _tmp73_;
		vala_ccode_function_call_add_argument (_tmp67_, (ValaCCodeExpression*) _tmp74_);
		_vala_ccode_node_unref0 (_tmp74_);
		_g_free0 (_tmp72_);
		_g_free0 (_tmp70_);
		_tmp75_ = private_field_offset;
		_tmp76_ = f;
		_tmp77_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_ccode_identifier_new (_tmp78_);
		_tmp80_ = _tmp79_;
		vala_ccode_function_call_add_argument (_tmp75_, (ValaCCodeExpression*) _tmp80_);
		_vala_ccode_node_unref0 (_tmp80_);
		_g_free0 (_tmp78_);
		_tmp81_ = cl;
		_tmp82_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp81_);
		_tmp83_ = _tmp82_;
		_tmp84_ = g_strdup_printf ("%s_private_offset", _tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = vala_ccode_identifier_new (_tmp85_);
		_tmp87_ = _tmp86_;
		_tmp88_ = private_field_offset;
		_tmp89_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
		_vala_ccode_node_unref0 (offset);
		offset = (ValaCCodeExpression*) _tmp89_;
		_vala_ccode_node_unref0 (_tmp87_);
		_g_free0 (_tmp85_);
		_g_free0 (_tmp83_);
		_vala_ccode_node_unref0 (private_field_offset);
	} else {
		ValaCCodeFunctionCall* offset_call = NULL;
		ValaCCodeIdentifier* _tmp90_;
		ValaCCodeIdentifier* _tmp91_;
		ValaCCodeFunctionCall* _tmp92_;
		ValaCCodeFunctionCall* _tmp93_;
		ValaCCodeFunctionCall* _tmp94_;
		ValaClass* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		ValaCCodeIdentifier* _tmp98_;
		ValaCCodeIdentifier* _tmp99_;
		ValaCCodeFunctionCall* _tmp100_;
		ValaField* _tmp101_;
		gchar* _tmp102_;
		gchar* _tmp103_;
		ValaCCodeIdentifier* _tmp104_;
		ValaCCodeIdentifier* _tmp105_;
		ValaCCodeFunctionCall* _tmp106_;
		ValaCCodeExpression* _tmp107_;
		_tmp90_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp91_);
		_tmp93_ = _tmp92_;
		_vala_ccode_node_unref0 (_tmp91_);
		offset_call = _tmp93_;
		_tmp94_ = offset_call;
		_tmp95_ = cl;
		_tmp96_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_ccode_identifier_new (_tmp97_);
		_tmp99_ = _tmp98_;
		vala_ccode_function_call_add_argument (_tmp94_, (ValaCCodeExpression*) _tmp99_);
		_vala_ccode_node_unref0 (_tmp99_);
		_g_free0 (_tmp97_);
		_tmp100_ = offset_call;
		_tmp101_ = f;
		_tmp102_ = vala_ccode_base_module_get_ccode_name ((ValaCodeNode*) _tmp101_);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_ccode_identifier_new (_tmp103_);
		_tmp105_ = _tmp104_;
		vala_ccode_function_call_add_argument (_tmp100_, (ValaCCodeExpression*) _tmp105_);
		_vala_ccode_node_unref0 (_tmp105_);
		_g_free0 (_tmp103_);
		_tmp106_ = offset_call;
		_tmp107_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp106_);
		_vala_ccode_node_unref0 (offset);
		offset = _tmp107_;
		_vala_ccode_node_unref0 (offset_call);
	}
	_tmp108_ = vala_ccode_identifier_new ("gtk_widget_class_bind_template_child_full");
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp109_);
	_tmp111_ = _tmp110_;
	_vala_ccode_node_unref0 (_tmp109_);
	call = _tmp111_;
	_tmp112_ = call;
	_tmp113_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
	_tmp114_ = _tmp113_;
	vala_ccode_function_call_add_argument (_tmp112_, (ValaCCodeExpression*) _tmp114_);
	_vala_ccode_node_unref0 (_tmp114_);
	_tmp115_ = call;
	_tmp116_ = gtk_name;
	_tmp117_ = g_strdup_printf ("\"%s\"", _tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_ccode_constant_new (_tmp118_);
	_tmp120_ = _tmp119_;
	vala_ccode_function_call_add_argument (_tmp115_, (ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (_tmp120_);
	_g_free0 (_tmp118_);
	_tmp122_ = internal_child;
	if (_tmp122_) {
		_tmp121_ = "TRUE";
	} else {
		_tmp121_ = "FALSE";
	}
	_tmp123_ = call;
	_tmp124_ = vala_ccode_constant_new (_tmp121_);
	_tmp125_ = _tmp124_;
	vala_ccode_function_call_add_argument (_tmp123_, (ValaCCodeExpression*) _tmp125_);
	_vala_ccode_node_unref0 (_tmp125_);
	_tmp126_ = call;
	_tmp127_ = offset;
	vala_ccode_function_call_add_argument (_tmp126_, _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = call;
	vala_ccode_function_add_expression (_tmp129_, (ValaCCodeExpression*) _tmp130_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = field_class;
	_tmp133_ = vala_symbol_get_external ((ValaSymbol*) _tmp132_);
	_tmp134_ = _tmp133_;
	if (!_tmp134_) {
		ValaClass* _tmp135_;
		gboolean _tmp136_;
		gboolean _tmp137_;
		_tmp135_ = field_class;
		_tmp136_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp135_);
		_tmp137_ = _tmp136_;
		_tmp131_ = !_tmp137_;
	} else {
		_tmp131_ = FALSE;
	}
	if (_tmp131_) {
		ValaList* _tmp138_;
		ValaClass* _tmp139_;
		_tmp138_ = self->priv->current_required_app_classes;
		_tmp139_ = field_class;
		vala_collection_add ((ValaCollection*) _tmp138_, _tmp139_);
	}
	_vala_ccode_node_unref0 (call);
	_vala_ccode_node_unref0 (offset);
	_vala_code_node_unref0 (field_class);
	_vala_code_node_unref0 (child_class);
	_g_free0 (gtk_name);
	_vala_code_node_unref0 (cl);
}


static void vala_gtk_module_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaGtkModule * self;
	ValaMethod* _tmp0_;
	ValaClass* cl = NULL;
	ValaClass* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaClass* _tmp6_;
	gboolean _tmp12_ = FALSE;
	ValaMethod* _tmp13_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	gchar* handler_name = NULL;
	ValaMethod* _tmp19_;
	ValaMethod* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	ValaSignal* sig = NULL;
	ValaHashMap* _tmp24_;
	const gchar* _tmp25_;
	gpointer _tmp26_;
	ValaSignal* _tmp27_;
	ValaCCodeBaseModuleEmitContext* _tmp34_;
	ValaSignal* _tmp35_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->visit_method ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule), _tmp0_);
	_tmp1_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	cl = _tmp3_;
	_tmp6_ = cl;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		ValaClass* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = cl;
		_tmp8_ = vala_code_node_get_error ((ValaCodeNode*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		ValaClass* _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = cl;
		_tmp11_ = vala_gtk_module_is_gtk_template (self, _tmp10_);
		_tmp4_ = !_tmp11_;
	}
	if (_tmp4_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp13_ = m;
	_tmp14_ = vala_method_get_binding (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_INSTANCE) {
		_tmp12_ = TRUE;
	} else {
		ValaMethod* _tmp16_;
		ValaAttribute* _tmp17_;
		ValaAttribute* _tmp18_;
		_tmp16_ = m;
		_tmp17_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp16_, "GtkCallback");
		_tmp18_ = _tmp17_;
		_tmp12_ = _tmp18_ == NULL;
		_vala_code_node_unref0 (_tmp18_);
	}
	if (_tmp12_) {
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp19_ = m;
	_tmp20_ = m;
	_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp19_, "GtkCallback", "name", _tmp22_);
	handler_name = _tmp23_;
	_tmp24_ = self->priv->current_handler_to_signal_map;
	_tmp25_ = handler_name;
	_tmp26_ = vala_map_get ((ValaMap*) _tmp24_, _tmp25_);
	sig = (ValaSignal*) _tmp26_;
	_tmp27_ = sig;
	if (_tmp27_ == NULL) {
		ValaMethod* _tmp28_;
		ValaSourceReference* _tmp29_;
		ValaSourceReference* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp28_ = m;
		_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = handler_name;
		_tmp32_ = g_strdup_printf ("could not find signal for handler `%s'", _tmp31_);
		_tmp33_ = _tmp32_;
		vala_report_error (_tmp30_, _tmp33_);
		_g_free0 (_tmp33_);
		_vala_code_node_unref0 (sig);
		_g_free0 (handler_name);
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp34_ = ((ValaCCodeBaseModule*) self)->class_init_context;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp34_);
	_tmp35_ = sig;
	if (_tmp35_ != NULL) {
		ValaSignal* _tmp36_;
		ValaCodeContext* _tmp37_;
		ValaCodeContext* _tmp38_;
		ValaMethodType* method_type = NULL;
		ValaMethod* _tmp39_;
		ValaMethodType* _tmp40_;
		ValaSignalType* signal_type = NULL;
		ValaSignal* _tmp41_;
		ValaSignalType* _tmp42_;
		ValaDelegateType* delegate_type = NULL;
		ValaSignalType* _tmp43_;
		ValaDelegateType* _tmp44_;
		ValaMethodType* _tmp45_;
		ValaDelegateType* _tmp46_;
		gboolean _tmp47_;
		_tmp36_ = sig;
		_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp38_ = _tmp37_;
		vala_code_node_check ((ValaCodeNode*) _tmp36_, _tmp38_);
		_tmp39_ = m;
		_tmp40_ = vala_method_type_new (_tmp39_);
		method_type = _tmp40_;
		_tmp41_ = sig;
		_tmp42_ = vala_signal_type_new (_tmp41_);
		signal_type = _tmp42_;
		_tmp43_ = signal_type;
		_tmp44_ = vala_signal_type_get_handler_type (_tmp43_);
		delegate_type = _tmp44_;
		_tmp45_ = method_type;
		_tmp46_ = delegate_type;
		_tmp47_ = vala_data_type_compatible ((ValaDataType*) _tmp45_, (ValaDataType*) _tmp46_);
		if (!_tmp47_) {
			ValaMethod* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaSourceReference* _tmp50_;
			ValaMethodType* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaDelegateType* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			ValaDelegateType* _tmp57_;
			ValaMethod* _tmp58_;
			const gchar* _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			_tmp48_ = m;
			_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = method_type;
			_tmp52_ = vala_code_node_to_string ((ValaCodeNode*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = delegate_type;
			_tmp55_ = vala_code_node_to_string ((ValaCodeNode*) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = delegate_type;
			_tmp58_ = m;
			_tmp59_ = vala_symbol_get_name ((ValaSymbol*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp57_, _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", _tmp53_, _tmp56_, _tmp62_);
			_tmp64_ = _tmp63_;
			vala_report_error (_tmp50_, _tmp64_);
			_g_free0 (_tmp64_);
			_g_free0 (_tmp62_);
			_g_free0 (_tmp56_);
			_g_free0 (_tmp53_);
		} else {
			gchar* wrapper = NULL;
			ValaMethod* _tmp65_;
			ValaSignalType* _tmp66_;
			ValaDelegateType* _tmp67_;
			ValaDelegateType* _tmp68_;
			ValaMethod* _tmp69_;
			gchar* _tmp70_;
			gchar* _tmp71_;
			ValaCCodeFunctionCall* call = NULL;
			ValaCCodeIdentifier* _tmp72_;
			ValaCCodeIdentifier* _tmp73_;
			ValaCCodeFunctionCall* _tmp74_;
			ValaCCodeFunctionCall* _tmp75_;
			ValaCCodeFunctionCall* _tmp76_;
			ValaCCodeIdentifier* _tmp77_;
			ValaCCodeIdentifier* _tmp78_;
			ValaCCodeFunctionCall* _tmp79_;
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			ValaCCodeConstant* _tmp83_;
			ValaCCodeConstant* _tmp84_;
			ValaCCodeFunctionCall* _tmp85_;
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			ValaCCodeIdentifier* _tmp89_;
			ValaCCodeIdentifier* _tmp90_;
			ValaCCodeFunction* _tmp91_;
			ValaCCodeFunction* _tmp92_;
			ValaCCodeFunctionCall* _tmp93_;
			_tmp65_ = m;
			_tmp66_ = signal_type;
			_tmp67_ = vala_signal_type_get_handler_type (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = m;
			_tmp70_ = vala_ccode_delegate_module_generate_delegate_wrapper ((ValaCCodeDelegateModule*) self, _tmp65_, _tmp68_, (ValaCodeNode*) _tmp69_);
			_tmp71_ = _tmp70_;
			_vala_code_node_unref0 (_tmp68_);
			wrapper = _tmp71_;
			_tmp72_ = vala_ccode_identifier_new ("gtk_widget_class_bind_template_callback_full");
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_vala_ccode_node_unref0 (_tmp73_);
			call = _tmp75_;
			_tmp76_ = call;
			_tmp77_ = vala_ccode_identifier_new ("GTK_WIDGET_CLASS (klass)");
			_tmp78_ = _tmp77_;
			vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
			_vala_ccode_node_unref0 (_tmp78_);
			_tmp79_ = call;
			_tmp80_ = handler_name;
			_tmp81_ = g_strdup_printf ("\"%s\"", _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_ccode_constant_new (_tmp82_);
			_tmp84_ = _tmp83_;
			vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp84_);
			_vala_ccode_node_unref0 (_tmp84_);
			_g_free0 (_tmp82_);
			_tmp85_ = call;
			_tmp86_ = wrapper;
			_tmp87_ = g_strdup_printf ("G_CALLBACK(%s)", _tmp86_);
			_tmp88_ = _tmp87_;
			_tmp89_ = vala_ccode_identifier_new (_tmp88_);
			_tmp90_ = _tmp89_;
			vala_ccode_function_call_add_argument (_tmp85_, (ValaCCodeExpression*) _tmp90_);
			_vala_ccode_node_unref0 (_tmp90_);
			_g_free0 (_tmp88_);
			_tmp91_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp92_ = _tmp91_;
			_tmp93_ = call;
			vala_ccode_function_add_expression (_tmp92_, (ValaCCodeExpression*) _tmp93_);
			_vala_ccode_node_unref0 (call);
			_g_free0 (wrapper);
		}
		_vala_code_node_unref0 (delegate_type);
		_vala_code_node_unref0 (signal_type);
		_vala_code_node_unref0 (method_type);
	}
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_vala_code_node_unref0 (sig);
	_g_free0 (handler_name);
	_vala_code_node_unref0 (cl);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void vala_gtk_module_real_end_instance_init (ValaGTypeModule* base, ValaClass* cl) {
	ValaGtkModule * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaClass* _tmp2_;
	ValaCCodeFunctionCall* call = NULL;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeFunctionCall* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunction* _tmp39_;
	ValaCCodeFunction* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	self = (ValaGtkModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp2_ = cl;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaClass* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = cl;
		_tmp4_ = vala_code_node_get_error ((ValaCodeNode*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ValaClass* _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = cl;
		_tmp7_ = vala_gtk_module_is_gtk_template (self, _tmp6_);
		_tmp0_ = !_tmp7_;
	}
	if (_tmp0_) {
		return;
	}
	{
		ValaList* _req_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _req_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _req_index = 0;
		_tmp8_ = self->priv->current_required_app_classes;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_req_list = _tmp9_;
		_tmp10_ = _req_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_req_size = _tmp12_;
		_req_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaClass* req = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaCCodeFunctionCall* call = NULL;
			ValaCCodeIdentifier* _tmp19_;
			ValaCCodeIdentifier* _tmp20_;
			ValaCCodeFunctionCall* _tmp21_;
			ValaCCodeFunctionCall* _tmp22_;
			ValaCCodeFunctionCall* _tmp23_;
			ValaClass* _tmp24_;
			ValaDataType* _tmp25_;
			ValaDataType* _tmp26_;
			ValaCCodeExpression* _tmp27_;
			ValaCCodeExpression* _tmp28_;
			ValaCCodeFunction* _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunctionCall* _tmp31_;
			_tmp13_ = _req_index;
			_req_index = _tmp13_ + 1;
			_tmp14_ = _req_index;
			_tmp15_ = _req_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _req_list;
			_tmp17_ = _req_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			req = (ValaClass*) _tmp18_;
			_tmp19_ = vala_ccode_identifier_new ("g_type_ensure");
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp20_);
			_tmp22_ = _tmp21_;
			_vala_ccode_node_unref0 (_tmp20_);
			call = _tmp22_;
			_tmp23_ = call;
			_tmp24_ = req;
			_tmp25_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaTypeSymbol*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_ccode_base_module_get_type_id_expression ((ValaCCodeBaseModule*) self, _tmp26_, FALSE);
			_tmp28_ = _tmp27_;
			vala_ccode_function_call_add_argument (_tmp23_, _tmp28_);
			_vala_ccode_node_unref0 (_tmp28_);
			_vala_code_node_unref0 (_tmp26_);
			_tmp29_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp30_ = _tmp29_;
			_tmp31_ = call;
			vala_ccode_function_add_expression (_tmp30_, (ValaCCodeExpression*) _tmp31_);
			_vala_ccode_node_unref0 (call);
			_vala_code_node_unref0 (req);
		}
		_vala_iterable_unref0 (_req_list);
	}
	_tmp32_ = vala_ccode_identifier_new ("gtk_widget_init_template");
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp33_);
	_tmp35_ = _tmp34_;
	_vala_ccode_node_unref0 (_tmp33_);
	call = _tmp35_;
	_tmp36_ = call;
	_tmp37_ = vala_ccode_identifier_new ("GTK_WIDGET (self)");
	_tmp38_ = _tmp37_;
	vala_ccode_function_call_add_argument (_tmp36_, (ValaCCodeExpression*) _tmp38_);
	_vala_ccode_node_unref0 (_tmp38_);
	_tmp39_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp40_ = _tmp39_;
	_tmp41_ = call;
	vala_ccode_function_add_expression (_tmp40_, (ValaCCodeExpression*) _tmp41_);
	_vala_ccode_node_unref0 (call);
}


ValaGtkModule* vala_gtk_module_construct (GType object_type) {
	ValaGtkModule* self = NULL;
	self = (ValaGtkModule*) vala_gsignal_module_construct (object_type);
	return self;
}


ValaGtkModule* vala_gtk_module_new (void) {
	return vala_gtk_module_construct (VALA_TYPE_GTK_MODULE);
}


static void vala_gtk_module_class_init (ValaGtkModuleClass * klass) {
	vala_gtk_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gtk_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaGtkModulePrivate));
	((ValaGTypeModuleClass *) klass)->generate_class_init = (void (*) (ValaGTypeModule *, ValaClass*)) vala_gtk_module_real_generate_class_init;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor *, ValaProperty*)) vala_gtk_module_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor *, ValaField*)) vala_gtk_module_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor *, ValaMethod*)) vala_gtk_module_real_visit_method;
	((ValaGTypeModuleClass *) klass)->end_instance_init = (void (*) (ValaGTypeModule *, ValaClass*)) vala_gtk_module_real_end_instance_init;
}


static void vala_gtk_module_instance_init (ValaGtkModule * self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GEqualFunc _tmp6_;
	ValaHashMap* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	self->priv = VALA_GTK_MODULE_GET_PRIVATE (self);
	self->priv->type_id_to_vala_map = NULL;
	self->priv->cclass_to_vala_map = NULL;
	self->priv->gresource_to_file_map = NULL;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_, _tmp2_);
	self->priv->current_handler_to_signal_map = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_, _tmp6_);
	self->priv->current_child_to_class_map = _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->current_required_app_classes = (ValaList*) _tmp9_;
}


static void vala_gtk_module_finalize (ValaCodeVisitor * obj) {
	ValaGtkModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GTK_MODULE, ValaGtkModule);
	_vala_map_unref0 (self->priv->type_id_to_vala_map);
	_vala_map_unref0 (self->priv->cclass_to_vala_map);
	_vala_map_unref0 (self->priv->gresource_to_file_map);
	_vala_map_unref0 (self->priv->current_handler_to_signal_map);
	_vala_map_unref0 (self->priv->current_child_to_class_map);
	_vala_iterable_unref0 (self->priv->current_required_app_classes);
	VALA_CODE_VISITOR_CLASS (vala_gtk_module_parent_class)->finalize (obj);
}


GType vala_gtk_module_get_type (void) {
	static volatile gsize vala_gtk_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gtk_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGtkModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gtk_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGtkModule), 0, (GInstanceInitFunc) vala_gtk_module_instance_init, NULL };
		GType vala_gtk_module_type_id;
		vala_gtk_module_type_id = g_type_register_static (VALA_TYPE_GSIGNAL_MODULE, "ValaGtkModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gtk_module_type_id__volatile, vala_gtk_module_type_id);
	}
	return vala_gtk_module_type_id__volatile;
}



