/* valaccode.c generated by valac, the Vala compiler
 * generated from valaccode.vala, do not modify */

/* valaccode.vala
 *
 * Copyright (C) 2017  Rico Tzschichholz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Rico Tzschichholz <ricotz@ubuntu.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include "valacodegen.h"
#include <string.h>
#include <stdlib.h>
#include <float.h>
#include <math.h>

#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_attribute_cache_unref0(var) ((var == NULL) ? NULL : (var = (vala_attribute_cache_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))


extern gint* vala_ccode_attribute_cache_index;
gint* vala_ccode_attribute_cache_index = NULL;

G_GNUC_INTERNAL ValaCCodeAttribute* vala_get_ccode_attribute (ValaCodeNode* node);
static gint* _int_dup (gint* self);


static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}


static gpointer
_vala_attribute_cache_ref0 (gpointer self)
{
	return self ? vala_attribute_cache_ref (self) : NULL;
}


G_GNUC_INTERNAL ValaCCodeAttribute*
vala_get_ccode_attribute (ValaCodeNode* node)
{
	ValaCCodeAttribute* result = NULL;
	gint* _tmp0_;
	ValaAttributeCache* attr = NULL;
	gint* _tmp3_;
	ValaAttributeCache* _tmp4_;
	ValaAttributeCache* _tmp5_;
	ValaAttributeCache* _tmp9_;
	ValaCCodeAttribute* _tmp10_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_ccode_attribute_cache_index;
	if (_tmp0_ == NULL) {
		gint _tmp1_;
		gint* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_cache_index ();
		_tmp2_ = __int_dup0 (&_tmp1_);
		_g_free0 (vala_ccode_attribute_cache_index);
		vala_ccode_attribute_cache_index = _tmp2_;
	}
	_tmp3_ = vala_ccode_attribute_cache_index;
	_tmp4_ = vala_code_node_get_attribute_cache (node, *_tmp3_);
	attr = _tmp4_;
	_tmp5_ = attr;
	if (_tmp5_ == NULL) {
		ValaCCodeAttribute* _tmp6_;
		gint* _tmp7_;
		ValaAttributeCache* _tmp8_;
		_tmp6_ = vala_ccode_attribute_new (node);
		_vala_attribute_cache_unref0 (attr);
		attr = (ValaAttributeCache*) _tmp6_;
		_tmp7_ = vala_ccode_attribute_cache_index;
		_tmp8_ = attr;
		vala_code_node_set_attribute_cache (node, *_tmp7_, _tmp8_);
	}
	_tmp9_ = attr;
	_tmp10_ = _vala_attribute_cache_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_CCODE_ATTRIBUTE, ValaCCodeAttribute));
	result = _tmp10_;
	_vala_attribute_cache_unref0 (attr);
	return result;
}


gchar*
vala_get_ccode_name (ValaCodeNode* node)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_const_name (ValaCodeNode* node)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_const_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_type_name (ValaInterface* iface)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (iface != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) iface);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_type_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gchar*
string_replace (const gchar* self, 
                const gchar* old, 
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar*
vala_get_ccode_lower_case_name (ValaCodeNode* node, 
                                const gchar* infix)
{
	gchar* result = NULL;
	ValaSymbol* sym = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) node) : NULL);
	sym = _tmp0_;
	_tmp1_ = sym;
	if (_tmp1_ != NULL) {
		ValaSymbol* _tmp2_;
		if (infix == NULL) {
			infix = "";
		}
		_tmp2_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_DELEGATE)) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			ValaSymbol* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			ValaSymbol* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			_tmp3_ = sym;
			_tmp4_ = vala_symbol_get_parent_symbol (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_get_ccode_lower_case_prefix (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = sym;
			_tmp9_ = vala_symbol_get_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_symbol_camel_case_to_lower_case (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup_printf ("%s%s%s", _tmp7_, infix, _tmp12_);
			_tmp14_ = _tmp13_;
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			result = _tmp14_;
			_vala_code_node_unref0 (sym);
			return result;
		} else {
			ValaSymbol* _tmp15_;
			_tmp15_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_SIGNAL)) {
				ValaSymbol* _tmp16_;
				ValaCCodeAttribute* _tmp17_;
				ValaCCodeAttribute* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp16_ = sym;
				_tmp17_ = vala_get_ccode_attribute ((ValaCodeNode*) _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = vala_ccode_attribute_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = string_replace (_tmp20_, "-", "_");
				_tmp22_ = _tmp21_;
				_vala_attribute_cache_unref0 (_tmp18_);
				result = _tmp22_;
				_vala_code_node_unref0 (sym);
				return result;
			} else {
				ValaSymbol* _tmp23_;
				_tmp23_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_ERROR_CODE)) {
					ValaSymbol* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					_tmp24_ = sym;
					_tmp25_ = vala_get_ccode_name ((ValaCodeNode*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_utf8_strdown (_tmp26_, (gssize) -1);
					_tmp28_ = _tmp27_;
					_g_free0 (_tmp26_);
					result = _tmp28_;
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					ValaSymbol* _tmp29_;
					ValaSymbol* _tmp30_;
					ValaSymbol* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					ValaSymbol* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					_tmp29_ = sym;
					_tmp30_ = vala_symbol_get_parent_symbol (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = vala_get_ccode_lower_case_prefix (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = sym;
					_tmp35_ = vala_get_ccode_lower_case_suffix (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strdup_printf ("%s%s%s", _tmp33_, infix, _tmp36_);
					_tmp38_ = _tmp37_;
					_g_free0 (_tmp36_);
					_g_free0 (_tmp33_);
					result = _tmp38_;
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_ERROR_TYPE)) {
			ValaErrorType* type = NULL;
			ValaErrorType* _tmp39_;
			ValaErrorType* _tmp40_;
			ValaErrorDomain* _tmp41_;
			ValaErrorDomain* _tmp42_;
			_tmp39_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_ERROR_TYPE, ValaErrorType));
			type = _tmp39_;
			_tmp40_ = type;
			_tmp41_ = vala_error_type_get_error_domain (_tmp40_);
			_tmp42_ = _tmp41_;
			if (_tmp42_ == NULL) {
				if (infix == NULL) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup ("g_error");
					result = _tmp43_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					gchar* _tmp44_;
					_tmp44_ = g_strdup_printf ("g_%s_error", infix);
					result = _tmp44_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				}
			} else {
				ValaErrorType* _tmp45_;
				ValaErrorCode* _tmp46_;
				ValaErrorCode* _tmp47_;
				_tmp45_ = type;
				_tmp46_ = vala_error_type_get_error_code (_tmp45_);
				_tmp47_ = _tmp46_;
				if (_tmp47_ == NULL) {
					ValaErrorType* _tmp48_;
					ValaErrorDomain* _tmp49_;
					ValaErrorDomain* _tmp50_;
					gchar* _tmp51_;
					_tmp48_ = type;
					_tmp49_ = vala_error_type_get_error_domain (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp50_, infix);
					result = _tmp51_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					ValaErrorType* _tmp52_;
					ValaErrorCode* _tmp53_;
					ValaErrorCode* _tmp54_;
					gchar* _tmp55_;
					_tmp52_ = type;
					_tmp53_ = vala_error_type_get_error_code (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp54_, infix);
					result = _tmp55_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				}
			}
			_vala_code_node_unref0 (type);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegateType* type = NULL;
				ValaDelegateType* _tmp56_;
				ValaDelegateType* _tmp57_;
				ValaDelegate* _tmp58_;
				ValaDelegate* _tmp59_;
				gchar* _tmp60_;
				_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				type = _tmp56_;
				_tmp57_ = type;
				_tmp58_ = vala_delegate_type_get_delegate_symbol (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp59_, infix);
				result = _tmp60_;
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (sym);
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_POINTER_TYPE)) {
					ValaPointerType* type = NULL;
					ValaPointerType* _tmp61_;
					ValaPointerType* _tmp62_;
					ValaDataType* _tmp63_;
					ValaDataType* _tmp64_;
					gchar* _tmp65_;
					_tmp61_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_POINTER_TYPE, ValaPointerType));
					type = _tmp61_;
					_tmp62_ = type;
					_tmp63_ = vala_pointer_type_get_base_type (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp64_, infix);
					result = _tmp65_;
					_vala_code_node_unref0 (type);
					_vala_code_node_unref0 (sym);
					return result;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_GENERIC_TYPE)) {
						gchar* _tmp66_;
						_tmp66_ = g_strdup ("valageneric");
						result = _tmp66_;
						_vala_code_node_unref0 (sym);
						return result;
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_VOID_TYPE)) {
							gchar* _tmp67_;
							_tmp67_ = g_strdup ("valavoid");
							result = _tmp67_;
							_vala_code_node_unref0 (sym);
							return result;
						} else {
							ValaDataType* type = NULL;
							ValaDataType* _tmp68_;
							ValaDataType* _tmp69_;
							ValaTypeSymbol* _tmp70_;
							ValaTypeSymbol* _tmp71_;
							gchar* _tmp72_;
							_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_DATA_TYPE, ValaDataType));
							type = _tmp68_;
							_tmp69_ = type;
							_tmp70_ = vala_data_type_get_data_type (_tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp71_, infix);
							result = _tmp72_;
							_vala_code_node_unref0 (type);
							_vala_code_node_unref0 (sym);
							return result;
						}
					}
				}
			}
		}
	}
	_vala_code_node_unref0 (sym);
}


gchar*
vala_get_ccode_upper_case_name (ValaSymbol* sym, 
                                const gchar* infix)
{
	gchar* result = NULL;
	g_return_val_if_fail (sym != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_PROPERTY)) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp0_ = vala_symbol_get_parent_symbol (sym);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp1_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_symbol_get_name (sym);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_camel_case_to_lower_case (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%s_%s", _tmp3_, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_ascii_strup (_tmp9_, (gssize) -1);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp3_);
		result = _tmp11_;
		return result;
	} else {
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) sym, infix);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_ascii_strup (_tmp13_, (gssize) -1);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		result = _tmp15_;
		return result;
	}
}


gchar*
vala_get_ccode_header_filenames (ValaSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_header_filenames (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_prefix (ValaSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_prefix (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_lower_case_prefix (ValaSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_lower_case_prefix (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_lower_case_suffix (ValaSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_lower_case_suffix (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_ref_function (ValaTypeSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_ref_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_quark_name (ValaErrorDomain* edomain)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (edomain != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) edomain, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "-quark", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


gboolean
vala_is_reference_counting (ValaTypeSymbol* sym)
{
	gboolean result = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = vala_get_ccode_ref_function (sym);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_ != NULL;
		_g_free0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_INTERFACE)) {
			result = TRUE;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
}


gboolean
vala_get_ccode_ref_function_void (ValaClass* cl)
{
	gboolean result = FALSE;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_ref_function_void (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gboolean
vala_get_ccode_free_function_address_of (ValaClass* cl)
{
	gboolean result = FALSE;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (cl != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_free_function_address_of (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar*
vala_get_ccode_unref_function (ValaObjectTypeSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_unref_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_ref_sink_function (ValaObjectTypeSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_ref_sink_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_copy_function (ValaTypeSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_copy_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_destroy_function (ValaTypeSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_destroy_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_dup_function (ValaTypeSymbol* sym)
{
	gchar* result = NULL;
	gchar* _tmp6_;
	g_return_val_if_fail (sym != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT)) {
		ValaCCodeAttribute* _tmp0_;
		ValaCCodeAttribute* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_ccode_attribute_get_dup_function (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		_tmp5_ = _tmp4_;
		_vala_attribute_cache_unref0 (_tmp1_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = vala_get_ccode_copy_function (sym);
	result = _tmp6_;
	return result;
}


gchar*
vala_get_ccode_free_function (ValaTypeSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_free_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gboolean
vala_get_ccode_is_gboxed (ValaTypeSymbol* sym)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_get_ccode_free_function (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "g_boxed_free") == 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}


gboolean
vala_get_ccode_finish_instance (ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_finish_instance (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar*
vala_get_ccode_type_id (ValaCodeNode* node)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_type_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_marshaller_type_name (ValaCodeNode* node)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_marshaller_type_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_get_value_function (ValaCodeNode* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_get_value_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_set_value_function (ValaCodeNode* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_set_value_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_take_value_function (ValaCodeNode* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_take_value_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_param_spec_function (ValaCodeNode* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_param_spec_function (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_type_check_function (ValaTypeSymbol* sym)
{
	gchar* result = NULL;
	ValaClass* cl = NULL;
	ValaClass* _tmp0_;
	gchar* a = NULL;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaClass* _tmp3_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_CLASS) ? ((ValaClass*) sym) : NULL);
	cl = _tmp0_;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sym, "CCode", "type_check_function", NULL);
	a = _tmp1_;
	_tmp3_ = cl;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = a;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = a;
		_vala_code_node_unref0 (cl);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		ValaClass* _tmp9_;
		_tmp9_ = cl;
		if (_tmp9_ != NULL) {
			ValaClass* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp10_ = cl;
			_tmp11_ = vala_class_get_is_compact (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp8_ = _tmp12_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_STRUCT);
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_ENUM);
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (sym, VALA_TYPE_DELEGATE);
		}
		if (_tmp5_) {
			gchar* _tmp13_;
			_tmp13_ = g_strdup ("");
			result = _tmp13_;
			_g_free0 (a);
			_vala_code_node_unref0 (cl);
			return result;
		} else {
			gchar* _tmp14_;
			_tmp14_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sym, "IS_");
			result = _tmp14_;
			_g_free0 (a);
			_vala_code_node_unref0 (cl);
			return result;
		}
	}
	_g_free0 (a);
	_vala_code_node_unref0 (cl);
}


gchar*
vala_get_ccode_default_value (ValaTypeSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_default_value (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gboolean
vala_get_ccode_has_copy_function (ValaStruct* st)
{
	gboolean result = FALSE;
	g_return_val_if_fail (st != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) st, "CCode", "has_copy_function", TRUE);
	return result;
}


gboolean
vala_get_ccode_has_destroy_function (ValaStruct* st)
{
	gboolean result = FALSE;
	g_return_val_if_fail (st != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) st, "CCode", "has_destroy_function", TRUE);
	return result;
}


gdouble
vala_get_ccode_instance_pos (ValaCodeNode* node)
{
	gdouble result = 0.0;
	g_return_val_if_fail (node != NULL, 0.0);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_DELEGATE)) {
		result = vala_code_node_get_attribute_double (node, "CCode", "instance_pos", (gdouble) -2);
		return result;
	} else {
		result = vala_code_node_get_attribute_double (node, "CCode", "instance_pos", (gdouble) 0);
		return result;
	}
}


gboolean
vala_get_ccode_array_length (ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_array_length (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar*
vala_get_ccode_array_length_type (ValaCodeNode* node)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_array_length_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gboolean
vala_get_ccode_array_null_terminated (ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_array_null_terminated (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar*
vala_get_ccode_array_length_name (ValaCodeNode* node)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_array_length_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_array_length_expr (ValaCodeNode* node)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_array_length_expr (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gdouble
vala_get_ccode_array_length_pos (ValaCodeNode* node)
{
	gdouble result = 0.0;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaAttribute* _tmp2_;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = vala_code_node_get_attribute (node, "CCode");
	a = _tmp0_;
	_tmp2_ = a;
	if (_tmp2_ != NULL) {
		ValaAttribute* _tmp3_;
		_tmp3_ = a;
		_tmp1_ = vala_attribute_has_argument (_tmp3_, "array_length_pos");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaAttribute* _tmp4_;
		_tmp4_ = a;
		result = vala_attribute_get_double (_tmp4_, "array_length_pos", (gdouble) 0);
		_vala_code_node_unref0 (a);
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaParameter* _tmp5_;
		ValaParameter* _tmp6_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_PARAMETER, ValaParameter));
		param = _tmp5_;
		_tmp6_ = param;
		result = vala_get_ccode_pos (_tmp6_) + 0.1;
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (a);
		return result;
	} else {
		result = (gdouble) -3;
		_vala_code_node_unref0 (a);
		return result;
	}
	_vala_code_node_unref0 (a);
}


gdouble
vala_get_ccode_delegate_target_pos (ValaCodeNode* node)
{
	gdouble result = 0.0;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaAttribute* _tmp2_;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = vala_code_node_get_attribute (node, "CCode");
	a = _tmp0_;
	_tmp2_ = a;
	if (_tmp2_ != NULL) {
		ValaAttribute* _tmp3_;
		_tmp3_ = a;
		_tmp1_ = vala_attribute_has_argument (_tmp3_, "delegate_target_pos");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaAttribute* _tmp4_;
		_tmp4_ = a;
		result = vala_attribute_get_double (_tmp4_, "delegate_target_pos", (gdouble) 0);
		_vala_code_node_unref0 (a);
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaParameter* _tmp5_;
		ValaParameter* _tmp6_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_PARAMETER, ValaParameter));
		param = _tmp5_;
		_tmp6_ = param;
		result = vala_get_ccode_pos (_tmp6_) + 0.1;
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (a);
		return result;
	} else {
		result = (gdouble) -3;
		_vala_code_node_unref0 (a);
		return result;
	}
	_vala_code_node_unref0 (a);
}


gdouble
vala_get_ccode_destroy_notify_pos (ValaCodeNode* node)
{
	gdouble result = 0.0;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaAttribute* _tmp2_;
	g_return_val_if_fail (node != NULL, 0.0);
	_tmp0_ = vala_code_node_get_attribute (node, "CCode");
	a = _tmp0_;
	_tmp2_ = a;
	if (_tmp2_ != NULL) {
		ValaAttribute* _tmp3_;
		_tmp3_ = a;
		_tmp1_ = vala_attribute_has_argument (_tmp3_, "destroy_notify_pos");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaAttribute* _tmp4_;
		_tmp4_ = a;
		result = vala_attribute_get_double (_tmp4_, "destroy_notify_pos", (gdouble) 0);
		_vala_code_node_unref0 (a);
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALA_TYPE_PARAMETER)) {
		ValaParameter* param = NULL;
		ValaParameter* _tmp5_;
		ValaParameter* _tmp6_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (node, VALA_TYPE_PARAMETER, ValaParameter));
		param = _tmp5_;
		_tmp6_ = param;
		result = vala_get_ccode_pos (_tmp6_) + 0.1;
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (a);
		return result;
	} else {
		result = (gdouble) -3;
		_vala_code_node_unref0 (a);
		return result;
	}
	_vala_code_node_unref0 (a);
}


gboolean
vala_get_ccode_delegate_target (ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_delegate_target (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar*
vala_get_ccode_delegate_target_name (ValaVariable* variable)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (variable != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) variable);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_delegate_target_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gdouble
vala_get_ccode_pos (ValaParameter* param)
{
	gdouble result = 0.0;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	g_return_val_if_fail (param != NULL, 0.0);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) param);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_pos (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}


gchar*
vala_get_ccode_type (ValaCodeNode* node)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_ctype (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gboolean
vala_get_ccode_simple_generics (ValaMethod* m)
{
	gboolean result = FALSE;
	g_return_val_if_fail (m != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "CCode", "simple_generics", FALSE);
	return result;
}


gchar*
vala_get_ccode_real_name (ValaSymbol* sym)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) sym);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_real_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_constructv_name (ValaCreationMethod* m)
{
	gchar* result = NULL;
	static const char infix[] = "constructv";
	ValaClass* parent = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1_) : NULL);
	parent = _tmp2_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, ".new") == 0) {
		ValaClass* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = parent;
		_tmp6_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%s%s", _tmp7_, infix);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		_vala_code_node_unref0 (parent);
		return result;
	} else {
		ValaClass* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp10_ = parent;
		_tmp11_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup_printf ("%s%s_%s", _tmp12_, infix, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp12_);
		result = _tmp16_;
		_vala_code_node_unref0 (parent);
		return result;
	}
	_vala_code_node_unref0 (parent);
}


gchar*
vala_get_ccode_vfunc_name (ValaMethod* m)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_vfunc_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_finish_name (ValaMethod* m)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_finish_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_finish_vfunc_name (ValaMethod* m)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_finish_vfunc_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gchar*
vala_get_ccode_finish_real_name (ValaMethod* m)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_finish_real_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


gboolean
vala_get_ccode_no_accessor_method (ValaProperty* p)
{
	gboolean result = FALSE;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) p, "NoAccessorMethod");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


gboolean
vala_get_ccode_concrete_accessor (ValaProperty* p)
{
	gboolean result = FALSE;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) p, "ConcreteAccessor");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


gboolean
vala_get_ccode_has_type_id (ValaTypeSymbol* sym)
{
	gboolean result = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", TRUE);
	return result;
}


gboolean
vala_get_ccode_has_new_function (ValaMethod* m)
{
	gboolean result = FALSE;
	g_return_val_if_fail (m != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "CCode", "has_new_function", TRUE);
	return result;
}


gboolean
vala_get_ccode_has_generic_type_parameter (ValaMethod* m)
{
	gboolean result = FALSE;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaAttribute* _tmp2_;
	g_return_val_if_fail (m != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) m, "CCode");
	a = _tmp0_;
	_tmp2_ = a;
	if (_tmp2_ != NULL) {
		ValaAttribute* _tmp3_;
		_tmp3_ = a;
		_tmp1_ = vala_attribute_has_argument (_tmp3_, "generic_type_pos");
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (a);
	return result;
}


gdouble
vala_get_ccode_generic_type_pos (ValaMethod* m)
{
	gdouble result = 0.0;
	g_return_val_if_fail (m != NULL, 0.0);
	result = vala_code_node_get_attribute_double ((ValaCodeNode*) m, "CCode", "generic_type_pos", (gdouble) 0);
	return result;
}


gchar*
vala_get_ccode_sentinel (ValaMethod* m)
{
	gchar* result = NULL;
	ValaCCodeAttribute* _tmp0_;
	ValaCCodeAttribute* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = vala_get_ccode_attribute ((ValaCodeNode*) m);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_attribute_get_sentinel (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_attribute_cache_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}



