/* valabaseaccess.c generated by valac, the Vala compiler
 * generated from valabaseaccess.vala, do not modify */

/* valabaseaccess.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

enum  {
	VALA_BASE_ACCESS_0_PROPERTY,
	VALA_BASE_ACCESS_NUM_PROPERTIES
};
static GParamSpec* vala_base_access_properties[VALA_BASE_ACCESS_NUM_PROPERTIES];
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))


static gpointer vala_base_access_parent_class = NULL;

static void vala_base_access_real_accept (ValaCodeNode* base, 
                                   ValaCodeVisitor* visitor);
static gchar* vala_base_access_real_to_string (ValaCodeNode* base);
static gboolean vala_base_access_real_is_pure (ValaExpression* base);
static gboolean vala_base_access_real_check (ValaCodeNode* base, 
                                      ValaCodeContext* context);
static void vala_base_access_real_emit (ValaCodeNode* base, 
                                 ValaCodeGenerator* codegen);


/**
 * Creates a new base access expression.
 *
 * @param source reference to source code
 * @return       newly created base access expression
 */
ValaBaseAccess*
vala_base_access_construct (GType object_type, 
                            ValaSourceReference* source)
{
	ValaBaseAccess* self = NULL;
	self = (ValaBaseAccess*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaBaseAccess*
vala_base_access_new (ValaSourceReference* source)
{
	return vala_base_access_construct (VALA_TYPE_BASE_ACCESS, source);
}


static void
vala_base_access_real_accept (ValaCodeNode* base, 
                              ValaCodeVisitor* visitor)
{
	ValaBaseAccess * self;
	self = (ValaBaseAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_base_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gchar*
vala_base_access_real_to_string (ValaCodeNode* base)
{
	ValaBaseAccess * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = (ValaBaseAccess*) base;
	_tmp0_ = g_strdup ("base");
	result = _tmp0_;
	return result;
}


static gboolean
vala_base_access_real_is_pure (ValaExpression* base)
{
	ValaBaseAccess * self;
	gboolean result = FALSE;
	self = (ValaBaseAccess*) base;
	result = TRUE;
	return result;
}


static gboolean
vala_base_access_real_check (ValaCodeNode* base, 
                             ValaCodeContext* context)
{
	ValaBaseAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp8_;
	ValaSemanticAnalyzer* _tmp9_;
	ValaClass* _tmp10_;
	ValaClass* _tmp11_;
	ValaDataType* _tmp62_;
	ValaDataType* _tmp63_;
	ValaTypeSymbol* _tmp64_;
	ValaTypeSymbol* _tmp65_;
	gboolean _tmp66_;
	gboolean _tmp67_;
	self = (ValaBaseAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	if (!vala_semantic_analyzer_is_in_instance_method (_tmp5_)) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "Base access invalid outside of instance methods");
		result = FALSE;
		return result;
	}
	_tmp8_ = vala_code_context_get_analyzer (context);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_semantic_analyzer_get_current_class (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ == NULL) {
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaStruct* _tmp14_;
		ValaStruct* _tmp15_;
		ValaSemanticAnalyzer* _tmp26_;
		ValaSemanticAnalyzer* _tmp27_;
		ValaStruct* _tmp28_;
		ValaStruct* _tmp29_;
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_semantic_analyzer_get_current_struct (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == NULL) {
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp17_ = _tmp16_;
			vala_report_error (_tmp17_, "Base access invalid outside of class and struct");
			result = FALSE;
			return result;
		} else {
			ValaSemanticAnalyzer* _tmp18_;
			ValaSemanticAnalyzer* _tmp19_;
			ValaStruct* _tmp20_;
			ValaStruct* _tmp21_;
			ValaDataType* _tmp22_;
			ValaDataType* _tmp23_;
			_tmp18_ = vala_code_context_get_analyzer (context);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_semantic_analyzer_get_current_struct (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_struct_get_base_type (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_ == NULL) {
				ValaSourceReference* _tmp24_;
				ValaSourceReference* _tmp25_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp25_ = _tmp24_;
				vala_report_error (_tmp25_, "Base access invalid without base type");
				result = FALSE;
				return result;
			}
		}
		_tmp26_ = vala_code_context_get_analyzer (context);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_semantic_analyzer_get_current_struct (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_struct_get_base_type (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp31_);
	} else {
		ValaSemanticAnalyzer* _tmp32_;
		ValaSemanticAnalyzer* _tmp33_;
		ValaClass* _tmp34_;
		ValaClass* _tmp35_;
		ValaClass* _tmp36_;
		ValaClass* _tmp37_;
		_tmp32_ = vala_code_context_get_analyzer (context);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_semantic_analyzer_get_current_class (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_class_get_base_class (_tmp35_);
		_tmp37_ = _tmp36_;
		if (_tmp37_ == NULL) {
			ValaSourceReference* _tmp38_;
			ValaSourceReference* _tmp39_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp39_ = _tmp38_;
			vala_report_error (_tmp39_, "Base access invalid without base class");
			result = FALSE;
			return result;
		} else {
			{
				ValaList* _base_type_list = NULL;
				ValaSemanticAnalyzer* _tmp40_;
				ValaSemanticAnalyzer* _tmp41_;
				ValaClass* _tmp42_;
				ValaClass* _tmp43_;
				ValaList* _tmp44_;
				gint _base_type_size = 0;
				ValaList* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				gint _base_type_index = 0;
				_tmp40_ = vala_code_context_get_analyzer (context);
				_tmp41_ = _tmp40_;
				_tmp42_ = vala_semantic_analyzer_get_current_class (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_class_get_base_types (_tmp43_);
				_base_type_list = _tmp44_;
				_tmp45_ = _base_type_list;
				_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
				_tmp47_ = _tmp46_;
				_base_type_size = _tmp47_;
				_base_type_index = -1;
				while (TRUE) {
					gint _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					ValaDataType* base_type = NULL;
					ValaList* _tmp51_;
					gint _tmp52_;
					gpointer _tmp53_;
					ValaDataType* _tmp54_;
					ValaTypeSymbol* _tmp55_;
					ValaTypeSymbol* _tmp56_;
					_tmp48_ = _base_type_index;
					_base_type_index = _tmp48_ + 1;
					_tmp49_ = _base_type_index;
					_tmp50_ = _base_type_size;
					if (!(_tmp49_ < _tmp50_)) {
						break;
					}
					_tmp51_ = _base_type_list;
					_tmp52_ = _base_type_index;
					_tmp53_ = vala_list_get (_tmp51_, _tmp52_);
					base_type = (ValaDataType*) _tmp53_;
					_tmp54_ = base_type;
					_tmp55_ = vala_data_type_get_data_type (_tmp54_);
					_tmp56_ = _tmp55_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp56_, VALA_TYPE_CLASS)) {
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						ValaDataType* _tmp60_;
						ValaDataType* _tmp61_;
						_tmp57_ = base_type;
						_tmp58_ = vala_data_type_copy (_tmp57_);
						_tmp59_ = _tmp58_;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp59_);
						_vala_code_node_unref0 (_tmp59_);
						_tmp60_ = vala_expression_get_value_type ((ValaExpression*) self);
						_tmp61_ = _tmp60_;
						vala_data_type_set_value_owned (_tmp61_, FALSE);
					}
					_vala_code_node_unref0 (base_type);
				}
				_vala_iterable_unref0 (_base_type_list);
			}
		}
	}
	_tmp62_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_data_type_get_data_type (_tmp63_);
	_tmp65_ = _tmp64_;
	vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp65_);
	_tmp66_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp67_ = _tmp66_;
	result = !_tmp67_;
	return result;
}


static void
vala_base_access_real_emit (ValaCodeNode* base, 
                            ValaCodeGenerator* codegen)
{
	ValaBaseAccess * self;
	self = (ValaBaseAccess*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_base_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_base_access_class_init (ValaBaseAccessClass * klass)
{
	vala_base_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_base_access_real_accept;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_base_access_real_to_string;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_base_access_real_is_pure;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_base_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_base_access_real_emit;
}


static void
vala_base_access_instance_init (ValaBaseAccess * self)
{
}


/**
 * Represents an access to base class members in the source code.
 */
GType
vala_base_access_get_type (void)
{
	static volatile gsize vala_base_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_base_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBaseAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_base_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBaseAccess), 0, (GInstanceInitFunc) vala_base_access_instance_init, NULL };
		GType vala_base_access_type_id;
		vala_base_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBaseAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_base_access_type_id__volatile, vala_base_access_type_id);
	}
	return vala_base_access_type_id__volatile;
}



