/* valaflowanalyzer.c generated by valac, the Vala compiler
 * generated from valaflowanalyzer.vala, do not modify */

/* valaflowanalyzer.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET (vala_flow_analyzer_jump_target_get_type ())
#define VALA_FLOW_ANALYZER_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))

typedef struct _ValaFlowAnalyzerJumpTarget ValaFlowAnalyzerJumpTarget;
typedef struct _ValaFlowAnalyzerJumpTargetClass ValaFlowAnalyzerJumpTargetClass;
enum  {
	VALA_FLOW_ANALYZER_0_PROPERTY,
	VALA_FLOW_ANALYZER_NUM_PROPERTIES
};
static GParamSpec* vala_flow_analyzer_properties[VALA_FLOW_ANALYZER_NUM_PROPERTIES];
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_basic_block_unref0(var) ((var == NULL) ? NULL : (var = (vala_basic_block_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_flow_analyzer_jump_target_unref0(var) ((var == NULL) ? NULL : (var = (vala_flow_analyzer_jump_target_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_phi_function_unref0(var) ((var == NULL) ? NULL : (var = (vala_phi_function_unref (var), NULL)))
typedef struct _ValaFlowAnalyzerJumpTargetPrivate ValaFlowAnalyzerJumpTargetPrivate;
enum  {
	VALA_FLOW_ANALYZER_JUMP_TARGET_0_PROPERTY,
	VALA_FLOW_ANALYZER_JUMP_TARGET_NUM_PROPERTIES
};
static GParamSpec* vala_flow_analyzer_jump_target_properties[VALA_FLOW_ANALYZER_JUMP_TARGET_NUM_PROPERTIES];
typedef struct _ValaFlowAnalyzerParamSpecJumpTarget ValaFlowAnalyzerParamSpecJumpTarget;

struct _ValaFlowAnalyzerPrivate {
	ValaCodeContext* context;
	ValaBasicBlock* current_block;
	gboolean unreachable_reported;
	ValaList* jump_stack;
	ValaMap* var_map;
	ValaSet* used_vars;
	ValaMap* phi_functions;
};

struct _ValaFlowAnalyzerJumpTarget {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaFlowAnalyzerJumpTargetPrivate * priv;
};

struct _ValaFlowAnalyzerJumpTargetClass {
	GTypeClass parent_class;
	void (*finalize) (ValaFlowAnalyzerJumpTarget *self);
};

struct _ValaFlowAnalyzerJumpTargetPrivate {
	gboolean _is_break_target;
	gboolean _is_continue_target;
	gboolean _is_return_target;
	gboolean _is_exit_target;
	gboolean _is_error_target;
	ValaErrorDomain* _error_domain;
	ValaErrorCode* _error_code;
	ValaClass* _error_class;
	gboolean _is_finally_clause;
	ValaBasicBlock* _basic_block;
	ValaBasicBlock* _last_block;
	ValaCatchClause* _catch_clause;
};

struct _ValaFlowAnalyzerParamSpecJumpTarget {
	GParamSpec parent_instance;
};


static gpointer vala_flow_analyzer_parent_class = NULL;
static gpointer vala_flow_analyzer_jump_target_parent_class = NULL;

static gpointer vala_flow_analyzer_jump_target_ref (gpointer instance);
static void vala_flow_analyzer_jump_target_unref (gpointer instance);
static GParamSpec* vala_flow_analyzer_param_spec_jump_target (const gchar* name, 
                                                       const gchar* nick, 
                                                       const gchar* blurb, 
                                                       GType object_type, 
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_set_jump_target (GValue* value, 
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_take_jump_target (GValue* value, 
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_flow_analyzer_value_get_jump_target (const GValue* value) G_GNUC_UNUSED;
static GType vala_flow_analyzer_jump_target_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_FLOW_ANALYZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzerPrivate))
static void vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base, 
                                                ValaSourceFile* source_file);
static void vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base, 
                                          ValaClass* cl);
static void vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base, 
                                           ValaStruct* st);
static void vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base, 
                                              ValaInterface* iface);
static void vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base, 
                                         ValaEnum* en);
static void vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base, 
                                                 ValaErrorDomain* ed);
static void vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base, 
                                          ValaField* f);
static void vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base, 
                                                      ValaLambdaExpression* le);
static void vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self);
static void vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base, 
                                           ValaMethod* m);
static void vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self, 
                                          ValaSubroutine* m);
static void vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base, 
                                           ValaSignal* sig);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_return_target (GType object_type, 
                                                                                    ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_exit_target (GType object_type, 
                                                                                  ValaBasicBlock* basic_block);
static void vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self, 
                                      ValaBasicBlock* entry_block);
static ValaList* vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self, 
                                                   ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self, 
                                              ValaList* block_list, 
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self, 
                                                  ValaList* block_list, 
                                                  ValaBasicBlock* entry_block);
static void vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self, 
                                              ValaList* block_list, 
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self, 
                                         ValaBasicBlock* entry_block);
static void vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self, 
                                              ValaBasicBlock* current, 
                                              ValaList* list);
static ValaBasicBlock* vala_flow_analyzer_intersect (ValaFlowAnalyzer* self, 
                                              ValaBasicBlock** idoms, 
                                              int idoms_length1, 
                                              ValaBasicBlock* b1, 
                                              ValaBasicBlock* b2);
static ValaMap* vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self, 
                                                ValaList* block_list, 
                                                ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self, 
                                               ValaBasicBlock* block);
static ValaVariable* vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self, 
                                                     ValaMap* var_map, 
                                                     ValaVariable* var_symbol);
static void vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base, 
                                                    ValaCreationMethod* m);
static void vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base, 
                                             ValaProperty* prop);
static void vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base, 
                                                      ValaPropertyAccessor* acc);
static void vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base, 
                                          ValaBlock* b);
static void vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base, 
                                                          ValaDeclarationStatement* stmt);
static gboolean vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self, 
                                         ValaCodeNode* node);
static void vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self, 
                                       ValaCodeNode* node, 
                                       gboolean always_fail);
static void vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base, 
                                                   ValaLocalVariable* local);
static void vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base, 
                                                         ValaExpressionStatement* stmt);
static gboolean vala_flow_analyzer_always_true (ValaFlowAnalyzer* self, 
                                         ValaExpression* condition);
static gboolean vala_flow_analyzer_always_false (ValaFlowAnalyzer* self, 
                                          ValaExpression* condition);
static void vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base, 
                                                 ValaIfStatement* stmt);
static void vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base, 
                                                     ValaSwitchStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_break_target (GType object_type, 
                                                                                   ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base, 
                                         ValaLoop* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_continue_target (GType object_type, 
                                                                                      ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base, 
                                                      ValaForeachStatement* stmt);
static void vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base, 
                                                    ValaBreakStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base, 
                                                       ValaContinueStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base, 
                                                     ValaReturnStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorDomain* vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorCode* vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base, 
                                                    ValaYieldStatement* stmt);
static void vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base, 
                                                    ValaThrowStatement* stmt);
static void vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base, 
                                                  ValaTryStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_any_target (GType object_type, 
                                                                                 ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block, 
                                                                               ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type, 
                                                                                     ValaBasicBlock* basic_block, 
                                                                                     ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block, 
                                                                             ValaCatchClause* catch_clause, 
                                                                             ValaErrorDomain* error_domain, 
                                                                             ValaErrorCode* error_code, 
                                                                             ValaClass* error_class);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_error_target (GType object_type, 
                                                                                   ValaBasicBlock* basic_block, 
                                                                                   ValaCatchClause* catch_clause, 
                                                                                   ValaErrorDomain* error_domain, 
                                                                                   ValaErrorCode* error_code, 
                                                                                   ValaClass* error_class);
static ValaCatchClause* vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base, 
                                                   ValaLockStatement* stmt);
static void vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base, 
                                                     ValaUnlockStatement* stmt);
static void vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base, 
                                               ValaExpression* expr);
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetPrivate))
static void vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self, 
                                                     ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self, 
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self, 
                                                            gboolean value);
static void vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self, 
                                                          gboolean value);
static void vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self, 
                                                        gboolean value);
static void vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self, 
                                                      ValaCatchClause* value);
static void vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self, 
                                                      ValaErrorDomain* value);
static void vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self, 
                                                    ValaErrorCode* value);
static void vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self, 
                                                     ValaClass* value);
static void vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self, 
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self, 
                                                    ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self, 
                                                           gboolean value);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new (void);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct (GType object_type);
static ValaClass* vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj);
static void vala_flow_analyzer_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array, 
                          gint array_length, 
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, 
                       gint array_length, 
                       GDestroyNotify destroy_func);


ValaFlowAnalyzer*
vala_flow_analyzer_construct (GType object_type)
{
	ValaFlowAnalyzer* self = NULL;
	self = (ValaFlowAnalyzer*) vala_code_visitor_construct (object_type);
	return self;
}


ValaFlowAnalyzer*
vala_flow_analyzer_new (void)
{
	return vala_flow_analyzer_construct (VALA_TYPE_FLOW_ANALYZER);
}


/**
 * Build control flow graph in the specified context.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


void
vala_flow_analyzer_analyze (ValaFlowAnalyzer* self, 
                            ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaList* source_files = NULL;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_code_context_get_source_files (context);
	source_files = _tmp1_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _file_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _file_index = 0;
		_tmp2_ = source_files;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_file_list = _tmp3_;
		_tmp4_ = _file_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_file_size = _tmp6_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaSourceFile* _tmp13_;
			ValaSourceFileType _tmp14_;
			ValaSourceFileType _tmp15_;
			_tmp7_ = _file_index;
			_file_index = _tmp7_ + 1;
			_tmp8_ = _file_index;
			_tmp9_ = _file_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _file_list;
			_tmp11_ = _file_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			file = (ValaSourceFile*) _tmp12_;
			_tmp13_ = file;
			_tmp14_ = vala_source_file_get_file_type (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaSourceFile* _tmp16_;
				_tmp16_ = file;
				vala_source_file_accept (_tmp16_, (ValaCodeVisitor*) self);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_iterable_unref0 (source_files);
}


static void
vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base, 
                                           ValaSourceFile* source_file)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (source_file != NULL);
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base, 
                                     ValaClass* cl)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (cl != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base, 
                                      ValaStruct* st)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (st != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base, 
                                         ValaInterface* iface)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (iface != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base, 
                                    ValaEnum* en)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (en != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base, 
                                            ValaErrorDomain* ed)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (ed != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ed, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base, 
                                     ValaField* f)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (f != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = vala_symbol_get_used ((ValaSymbol*) f);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp3_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
			gboolean _tmp4_ = FALSE;
			ValaCodeContext* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_internal_header_filename (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				_tmp4_ = TRUE;
			} else {
				ValaCodeContext* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp8_ = self->priv->context;
				_tmp9_ = vala_code_context_get_use_fast_vapi (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp4_ = _tmp10_;
			}
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
		} else {
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_symbol_get_full_name ((ValaSymbol*) f);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup_printf ("field `%s' never used", _tmp14_);
			_tmp16_ = _tmp15_;
			vala_report_warning (_tmp12_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
		}
	}
}


static gpointer
_vala_basic_block_ref0 (gpointer self)
{
	return self ? vala_basic_block_ref (self) : NULL;
}


static void
vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base, 
                                                 ValaLambdaExpression* le)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* old_current_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	gboolean old_unreachable_reported = FALSE;
	gboolean _tmp2_;
	ValaList* old_jump_stack = NULL;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaList* _tmp8_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (le != NULL);
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	old_current_block = _tmp1_;
	_tmp2_ = self->priv->unreachable_reported;
	old_unreachable_reported = _tmp2_;
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = _vala_iterable_ref0 (_tmp3_);
	old_jump_stack = _tmp4_;
	vala_flow_analyzer_mark_unreachable (self);
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp5_);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = (ValaList*) _tmp6_;
	vala_code_node_accept_children ((ValaCodeNode*) le, (ValaCodeVisitor*) self);
	_tmp7_ = _vala_basic_block_ref0 (old_current_block);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp7_;
	self->priv->unreachable_reported = old_unreachable_reported;
	_tmp8_ = _vala_iterable_ref0 (old_jump_stack);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = _tmp8_;
	_vala_iterable_unref0 (old_jump_stack);
	_vala_basic_block_unref0 (old_current_block);
}


static void
vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base, 
                                      ValaMethod* m)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) m)) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = vala_symbol_get_used ((ValaSymbol*) m);
		_tmp6_ = _tmp5_;
		_tmp4_ = !_tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = vala_method_get_entry_point (m);
		_tmp8_ = _tmp7_;
		_tmp3_ = !_tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = vala_method_get_overrides (m);
		_tmp10_ = _tmp9_;
		_tmp2_ = !_tmp10_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp12_ = vala_method_get_base_interface_method (m);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == NULL) {
			_tmp11_ = TRUE;
		} else {
			ValaMethod* _tmp14_;
			ValaMethod* _tmp15_;
			_tmp14_ = vala_method_get_base_interface_method (m);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ == m;
		}
		_tmp1_ = _tmp11_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp16_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
			gboolean _tmp17_ = FALSE;
			ValaCodeContext* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = self->priv->context;
			_tmp19_ = vala_code_context_get_internal_header_filename (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ != NULL) {
				_tmp17_ = TRUE;
			} else {
				ValaCodeContext* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = self->priv->context;
				_tmp22_ = vala_code_context_get_use_fast_vapi (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp17_ = _tmp23_;
			}
			_tmp16_ = _tmp17_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
		} else {
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_symbol_get_full_name ((ValaSymbol*) m);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strdup_printf ("method `%s' never used", _tmp27_);
			_tmp29_ = _tmp28_;
			vala_report_warning (_tmp25_, _tmp29_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
		}
	}
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) m);
}


static void
vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base, 
                                      ValaSignal* sig)
{
	ValaFlowAnalyzer * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_signal_get_default_handler (sig);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		_tmp2_ = vala_signal_get_default_handler (sig);
		_tmp3_ = _tmp2_;
		vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) _tmp3_);
	}
}


static void
vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self, 
                                     ValaSubroutine* m)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaBasicBlock* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaBasicBlock* _tmp37_;
	ValaBasicBlock* _tmp38_;
	ValaBasicBlock* _tmp39_;
	ValaBasicBlock* _tmp40_;
	ValaBasicBlock* _tmp41_;
	ValaList* _tmp42_;
	ValaBasicBlock* _tmp43_;
	ValaBasicBlock* _tmp44_;
	ValaFlowAnalyzerJumpTarget* _tmp45_;
	ValaFlowAnalyzerJumpTarget* _tmp46_;
	ValaList* _tmp47_;
	ValaBasicBlock* _tmp48_;
	ValaBasicBlock* _tmp49_;
	ValaFlowAnalyzerJumpTarget* _tmp50_;
	ValaFlowAnalyzerJumpTarget* _tmp51_;
	ValaList* _tmp52_;
	ValaList* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gpointer _tmp56_;
	ValaFlowAnalyzerJumpTarget* _tmp57_;
	ValaBasicBlock* _tmp58_;
	ValaBasicBlock* _tmp66_;
	ValaBasicBlock* _tmp67_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_subroutine_get_body (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = vala_basic_block_new_entry ();
	_tmp3_ = _tmp2_;
	vala_subroutine_set_entry_block (m, _tmp3_);
	_vala_basic_block_unref0 (_tmp3_);
	_tmp4_ = vala_basic_block_new ();
	_tmp5_ = _tmp4_;
	vala_subroutine_set_return_block (m, _tmp5_);
	_vala_basic_block_unref0 (_tmp5_);
	_tmp6_ = vala_basic_block_new_exit ();
	_tmp7_ = _tmp6_;
	vala_subroutine_set_exit_block (m, _tmp7_);
	_vala_basic_block_unref0 (_tmp7_);
	_tmp8_ = vala_subroutine_get_return_block (m);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_subroutine_get_exit_block (m);
	_tmp11_ = _tmp10_;
	vala_basic_block_connect (_tmp9_, _tmp11_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_METHOD)) {
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_callable_get_parameters ((ValaCallable*) G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_METHOD, ValaMethod));
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				ValaParameter* param = NULL;
				ValaList* _tmp19_;
				gint _tmp20_;
				gpointer _tmp21_;
				ValaParameter* _tmp22_;
				ValaParameterDirection _tmp23_;
				ValaParameterDirection _tmp24_;
				_tmp16_ = _param_index;
				_param_index = _tmp16_ + 1;
				_tmp17_ = _param_index;
				_tmp18_ = _param_size;
				if (!(_tmp17_ < _tmp18_)) {
					break;
				}
				_tmp19_ = _param_list;
				_tmp20_ = _param_index;
				_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
				param = (ValaParameter*) _tmp21_;
				_tmp22_ = param;
				_tmp23_ = vala_parameter_get_direction (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaMemberAccess* param_ma = NULL;
					ValaParameter* _tmp25_;
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					ValaParameter* _tmp28_;
					ValaSourceReference* _tmp29_;
					ValaSourceReference* _tmp30_;
					ValaMemberAccess* _tmp31_;
					ValaMemberAccess* _tmp32_;
					ValaParameter* _tmp33_;
					ValaBasicBlock* _tmp34_;
					ValaBasicBlock* _tmp35_;
					ValaMemberAccess* _tmp36_;
					_tmp25_ = param;
					_tmp26_ = vala_symbol_get_name ((ValaSymbol*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp28_ = param;
					_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = vala_member_access_new_simple (_tmp27_, _tmp30_);
					param_ma = _tmp31_;
					_tmp32_ = param_ma;
					_tmp33_ = param;
					vala_expression_set_symbol_reference ((ValaExpression*) _tmp32_, (ValaSymbol*) _tmp33_);
					_tmp34_ = vala_subroutine_get_return_block (m);
					_tmp35_ = _tmp34_;
					_tmp36_ = param_ma;
					vala_basic_block_add_node (_tmp35_, (ValaCodeNode*) _tmp36_);
					_vala_code_node_unref0 (param_ma);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	_tmp37_ = vala_basic_block_new ();
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp37_;
	_tmp38_ = vala_subroutine_get_entry_block (m);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->priv->current_block;
	vala_basic_block_connect (_tmp39_, _tmp40_);
	_tmp41_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp41_, (ValaCodeNode*) m);
	_tmp42_ = self->priv->jump_stack;
	_tmp43_ = vala_subroutine_get_return_block (m);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_flow_analyzer_jump_target_new_return_target (_tmp44_);
	_tmp46_ = _tmp45_;
	vala_collection_add ((ValaCollection*) _tmp42_, _tmp46_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp46_);
	_tmp47_ = self->priv->jump_stack;
	_tmp48_ = vala_subroutine_get_exit_block (m);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_flow_analyzer_jump_target_new_exit_target (_tmp49_);
	_tmp51_ = _tmp50_;
	vala_collection_add ((ValaCollection*) _tmp47_, _tmp51_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp51_);
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	_tmp52_ = self->priv->jump_stack;
	_tmp53_ = self->priv->jump_stack;
	_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_list_remove_at (_tmp52_, _tmp55_ - 1);
	_tmp57_ = (ValaFlowAnalyzerJumpTarget*) _tmp56_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp57_);
	_tmp58_ = self->priv->current_block;
	if (_tmp58_ != NULL) {
		gboolean _tmp59_;
		gboolean _tmp60_;
		ValaBasicBlock* _tmp63_;
		ValaBasicBlock* _tmp64_;
		ValaBasicBlock* _tmp65_;
		_tmp59_ = vala_subroutine_get_has_result (m);
		_tmp60_ = _tmp59_;
		if (_tmp60_) {
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp62_ = _tmp61_;
			vala_report_error (_tmp62_, "missing return statement at end of subroutine body");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		}
		_tmp63_ = self->priv->current_block;
		_tmp64_ = vala_subroutine_get_return_block (m);
		_tmp65_ = _tmp64_;
		vala_basic_block_connect (_tmp63_, _tmp65_);
	}
	_tmp66_ = vala_subroutine_get_entry_block (m);
	_tmp67_ = _tmp66_;
	vala_flow_analyzer_analyze_body (self, _tmp67_);
}


static void
vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self, 
                                 ValaBasicBlock* entry_block)
{
	ValaList* block_list = NULL;
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_depth_first_list (self, entry_block);
	block_list = _tmp0_;
	vala_flow_analyzer_build_dominator_tree (self, block_list, entry_block);
	vala_flow_analyzer_build_dominator_frontier (self, block_list, entry_block);
	vala_flow_analyzer_insert_phi_functions (self, block_list, entry_block);
	vala_flow_analyzer_check_variables (self, entry_block);
	_vala_iterable_unref0 (block_list);
}


static ValaList*
vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self, 
                                         ValaBasicBlock* entry_block)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp0_);
	list = _tmp1_;
	vala_flow_analyzer_depth_first_traverse (self, entry_block, (ValaList*) list);
	result = (ValaList*) list;
	return result;
}


static void
vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self, 
                                         ValaBasicBlock* current, 
                                         ValaList* list)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp14_;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_basic_block_get_postorder_visited (current);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_basic_block_set_postorder_visited (current, TRUE);
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp2_;
		gint _succ_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _succ_index = 0;
		_tmp2_ = vala_basic_block_get_successors (current);
		_succ_list = _tmp2_;
		_tmp3_ = _succ_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_succ_size = _tmp5_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaBasicBlock* _tmp12_;
			ValaBasicBlock* _tmp13_;
			_tmp6_ = _succ_index;
			_succ_index = _tmp6_ + 1;
			_tmp7_ = _succ_index;
			_tmp8_ = _succ_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _succ_list;
			_tmp10_ = _succ_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			_tmp12_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp11_);
			succ = _tmp12_;
			_tmp13_ = succ;
			vala_flow_analyzer_depth_first_traverse (self, _tmp13_, list);
			_vala_basic_block_unref0 (succ);
		}
		_vala_iterable_unref0 (_succ_list);
	}
	_tmp14_ = vala_collection_get_size ((ValaCollection*) list);
	_tmp15_ = _tmp14_;
	vala_basic_block_set_postorder_number (current, _tmp15_);
	vala_list_insert (list, 0, current);
}


static void
vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self, 
                                         ValaList* block_list, 
                                         ValaBasicBlock* entry_block)
{
	ValaBasicBlock** idoms = NULL;
	gint _tmp0_;
	gint _tmp1_;
	ValaBasicBlock** _tmp2_;
	gint idoms_length1;
	gint _idoms_size_;
	ValaBasicBlock** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaBasicBlock* _tmp7_;
	gboolean changed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (ValaBasicBlock*, _tmp1_ + 1);
	idoms = _tmp2_;
	idoms_length1 = _tmp1_;
	_idoms_size_ = idoms_length1;
	_tmp3_ = idoms;
	_tmp3__length1 = idoms_length1;
	_tmp4_ = vala_basic_block_get_postorder_number (entry_block);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_basic_block_ref0 (entry_block);
	_vala_basic_block_unref0 (_tmp3_[_tmp5_]);
	_tmp3_[_tmp5_] = _tmp6_;
	_tmp7_ = _tmp3_[_tmp5_];
	changed = TRUE;
	while (TRUE) {
		gboolean _tmp8_;
		_tmp8_ = changed;
		if (!_tmp8_) {
			break;
		}
		changed = FALSE;
		{
			ValaList* _block_list = NULL;
			ValaList* _tmp9_;
			gint _block_size = 0;
			ValaList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _block_index = 0;
			_tmp9_ = _vala_iterable_ref0 (block_list);
			_block_list = _tmp9_;
			_tmp10_ = _block_list;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_block_size = _tmp12_;
			_block_index = -1;
			while (TRUE) {
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_;
				ValaBasicBlock* block = NULL;
				ValaList* _tmp16_;
				gint _tmp17_;
				gpointer _tmp18_;
				ValaBasicBlock* _tmp19_;
				ValaBasicBlock* new_idom = NULL;
				gboolean first = FALSE;
				ValaBasicBlock** _tmp44_;
				gint _tmp44__length1;
				ValaBasicBlock* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				ValaBasicBlock* _tmp48_;
				ValaBasicBlock* _tmp49_;
				_tmp13_ = _block_index;
				_block_index = _tmp13_ + 1;
				_tmp14_ = _block_index;
				_tmp15_ = _block_size;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = _block_list;
				_tmp17_ = _block_index;
				_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
				block = (ValaBasicBlock*) _tmp18_;
				_tmp19_ = block;
				if (_tmp19_ == entry_block) {
					_vala_basic_block_unref0 (block);
					continue;
				}
				new_idom = NULL;
				first = TRUE;
				{
					ValaList* _pred_list = NULL;
					ValaBasicBlock* _tmp20_;
					ValaList* _tmp21_;
					gint _pred_size = 0;
					ValaList* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					gint _pred_index = 0;
					_tmp20_ = block;
					_tmp21_ = vala_basic_block_get_predecessors (_tmp20_);
					_pred_list = _tmp21_;
					_tmp22_ = _pred_list;
					_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
					_tmp24_ = _tmp23_;
					_pred_size = _tmp24_;
					_pred_index = -1;
					while (TRUE) {
						gint _tmp25_;
						gint _tmp26_;
						gint _tmp27_;
						ValaBasicBlock* pred = NULL;
						ValaList* _tmp28_;
						gint _tmp29_;
						gpointer _tmp30_;
						ValaBasicBlock* _tmp31_;
						ValaBasicBlock** _tmp32_;
						gint _tmp32__length1;
						ValaBasicBlock* _tmp33_;
						gint _tmp34_;
						gint _tmp35_;
						ValaBasicBlock* _tmp36_;
						_tmp25_ = _pred_index;
						_pred_index = _tmp25_ + 1;
						_tmp26_ = _pred_index;
						_tmp27_ = _pred_size;
						if (!(_tmp26_ < _tmp27_)) {
							break;
						}
						_tmp28_ = _pred_list;
						_tmp29_ = _pred_index;
						_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
						_tmp31_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp30_);
						pred = _tmp31_;
						_tmp32_ = idoms;
						_tmp32__length1 = idoms_length1;
						_tmp33_ = pred;
						_tmp34_ = vala_basic_block_get_postorder_number (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = _tmp32_[_tmp35_];
						if (_tmp36_ != NULL) {
							gboolean _tmp37_;
							_tmp37_ = first;
							if (_tmp37_) {
								ValaBasicBlock* _tmp38_;
								ValaBasicBlock* _tmp39_;
								_tmp38_ = pred;
								_tmp39_ = _vala_basic_block_ref0 (_tmp38_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp39_;
								first = FALSE;
							} else {
								ValaBasicBlock** _tmp40_;
								gint _tmp40__length1;
								ValaBasicBlock* _tmp41_;
								ValaBasicBlock* _tmp42_;
								ValaBasicBlock* _tmp43_;
								_tmp40_ = idoms;
								_tmp40__length1 = idoms_length1;
								_tmp41_ = pred;
								_tmp42_ = new_idom;
								_tmp43_ = vala_flow_analyzer_intersect (self, _tmp40_, _tmp40__length1, _tmp41_, _tmp42_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp43_;
							}
						}
						_vala_basic_block_unref0 (pred);
					}
					_vala_iterable_unref0 (_pred_list);
				}
				_tmp44_ = idoms;
				_tmp44__length1 = idoms_length1;
				_tmp45_ = block;
				_tmp46_ = vala_basic_block_get_postorder_number (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = _tmp44_[_tmp47_];
				_tmp49_ = new_idom;
				if (_tmp48_ != _tmp49_) {
					ValaBasicBlock** _tmp50_;
					gint _tmp50__length1;
					ValaBasicBlock* _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					ValaBasicBlock* _tmp54_;
					ValaBasicBlock* _tmp55_;
					ValaBasicBlock* _tmp56_;
					_tmp50_ = idoms;
					_tmp50__length1 = idoms_length1;
					_tmp51_ = block;
					_tmp52_ = vala_basic_block_get_postorder_number (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = new_idom;
					_tmp55_ = _vala_basic_block_ref0 (_tmp54_);
					_vala_basic_block_unref0 (_tmp50_[_tmp53_]);
					_tmp50_[_tmp53_] = _tmp55_;
					_tmp56_ = _tmp50_[_tmp53_];
					changed = TRUE;
				}
				_vala_basic_block_unref0 (new_idom);
				_vala_basic_block_unref0 (block);
			}
			_vala_iterable_unref0 (_block_list);
		}
	}
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp57_;
		gint _block_size = 0;
		ValaList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _block_index = 0;
		_tmp57_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp57_;
		_tmp58_ = _block_list;
		_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_block_size = _tmp60_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp64_;
			gint _tmp65_;
			gpointer _tmp66_;
			ValaBasicBlock* _tmp67_;
			ValaBasicBlock** _tmp68_;
			gint _tmp68__length1;
			ValaBasicBlock* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			ValaBasicBlock* _tmp72_;
			ValaBasicBlock* _tmp73_;
			_tmp61_ = _block_index;
			_block_index = _tmp61_ + 1;
			_tmp62_ = _block_index;
			_tmp63_ = _block_size;
			if (!(_tmp62_ < _tmp63_)) {
				break;
			}
			_tmp64_ = _block_list;
			_tmp65_ = _block_index;
			_tmp66_ = vala_list_get (_tmp64_, _tmp65_);
			block = (ValaBasicBlock*) _tmp66_;
			_tmp67_ = block;
			if (_tmp67_ == entry_block) {
				_vala_basic_block_unref0 (block);
				continue;
			}
			_tmp68_ = idoms;
			_tmp68__length1 = idoms_length1;
			_tmp69_ = block;
			_tmp70_ = vala_basic_block_get_postorder_number (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = _tmp68_[_tmp71_];
			_tmp73_ = block;
			vala_basic_block_add_child (_tmp72_, _tmp73_);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	idoms = (_vala_array_free (idoms, idoms_length1, (GDestroyNotify) vala_basic_block_unref), NULL);
}


static ValaBasicBlock*
vala_flow_analyzer_intersect (ValaFlowAnalyzer* self, 
                              ValaBasicBlock** idoms, 
                              int idoms_length1, 
                              ValaBasicBlock* b1, 
                              ValaBasicBlock* b2)
{
	ValaBasicBlock* result = NULL;
	ValaBasicBlock* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (b1 != NULL, NULL);
	g_return_val_if_fail (b2 != NULL, NULL);
	while (TRUE) {
		if (!(b1 != b2)) {
			break;
		}
		while (TRUE) {
			gint _tmp0_;
			gint _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			ValaBasicBlock* _tmp6_;
			_tmp0_ = vala_basic_block_get_postorder_number (b1);
			_tmp1_ = _tmp0_;
			_tmp2_ = vala_basic_block_get_postorder_number (b2);
			_tmp3_ = _tmp2_;
			if (!(_tmp1_ < _tmp3_)) {
				break;
			}
			_tmp4_ = vala_basic_block_get_postorder_number (b2);
			_tmp5_ = _tmp4_;
			_tmp6_ = idoms[_tmp5_];
			b1 = _tmp6_;
		}
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaBasicBlock* _tmp13_;
			_tmp7_ = vala_basic_block_get_postorder_number (b2);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_basic_block_get_postorder_number (b1);
			_tmp10_ = _tmp9_;
			if (!(_tmp8_ < _tmp10_)) {
				break;
			}
			_tmp11_ = vala_basic_block_get_postorder_number (b2);
			_tmp12_ = _tmp11_;
			_tmp13_ = idoms[_tmp12_];
			b2 = _tmp13_;
		}
	}
	_tmp14_ = _vala_basic_block_ref0 (b1);
	result = _tmp14_;
	return result;
}


static void
vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self, 
                                             ValaList* block_list, 
                                             ValaBasicBlock* entry_block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
		_tmp1_ = _tmp0_;
		i = _tmp1_ - 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				ValaBasicBlock* block = NULL;
				gint _tmp5_;
				gpointer _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ >= 0)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = vala_list_get (block_list, _tmp5_);
				block = (ValaBasicBlock*) _tmp6_;
				{
					ValaList* _succ_list = NULL;
					ValaBasicBlock* _tmp7_;
					ValaList* _tmp8_;
					gint _succ_size = 0;
					ValaList* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gint _succ_index = 0;
					_tmp7_ = block;
					_tmp8_ = vala_basic_block_get_successors (_tmp7_);
					_succ_list = _tmp8_;
					_tmp9_ = _succ_list;
					_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
					_tmp11_ = _tmp10_;
					_succ_size = _tmp11_;
					_succ_index = -1;
					while (TRUE) {
						gint _tmp12_;
						gint _tmp13_;
						gint _tmp14_;
						ValaBasicBlock* succ = NULL;
						ValaList* _tmp15_;
						gint _tmp16_;
						gpointer _tmp17_;
						ValaBasicBlock* _tmp18_;
						ValaBasicBlock* _tmp19_;
						ValaBasicBlock* _tmp20_;
						ValaBasicBlock* _tmp21_;
						ValaBasicBlock* _tmp22_;
						_tmp12_ = _succ_index;
						_succ_index = _tmp12_ + 1;
						_tmp13_ = _succ_index;
						_tmp14_ = _succ_size;
						if (!(_tmp13_ < _tmp14_)) {
							break;
						}
						_tmp15_ = _succ_list;
						_tmp16_ = _succ_index;
						_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
						_tmp18_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp17_);
						succ = _tmp18_;
						_tmp19_ = succ;
						_tmp20_ = vala_basic_block_get_parent (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = block;
						if (_tmp21_ != _tmp22_) {
							ValaBasicBlock* _tmp23_;
							ValaBasicBlock* _tmp24_;
							_tmp23_ = block;
							_tmp24_ = succ;
							vala_basic_block_add_dominator_frontier (_tmp23_, _tmp24_);
						}
						_vala_basic_block_unref0 (succ);
					}
					_vala_iterable_unref0 (_succ_list);
				}
				{
					ValaList* _child_list = NULL;
					ValaBasicBlock* _tmp25_;
					ValaList* _tmp26_;
					gint _child_size = 0;
					ValaList* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gint _child_index = 0;
					_tmp25_ = block;
					_tmp26_ = vala_basic_block_get_children (_tmp25_);
					_child_list = _tmp26_;
					_tmp27_ = _child_list;
					_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
					_tmp29_ = _tmp28_;
					_child_size = _tmp29_;
					_child_index = -1;
					while (TRUE) {
						gint _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						ValaBasicBlock* child = NULL;
						ValaList* _tmp33_;
						gint _tmp34_;
						gpointer _tmp35_;
						_tmp30_ = _child_index;
						_child_index = _tmp30_ + 1;
						_tmp31_ = _child_index;
						_tmp32_ = _child_size;
						if (!(_tmp31_ < _tmp32_)) {
							break;
						}
						_tmp33_ = _child_list;
						_tmp34_ = _child_index;
						_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
						child = (ValaBasicBlock*) _tmp35_;
						{
							ValaIterator* _child_frontier_it = NULL;
							ValaBasicBlock* _tmp36_;
							ValaSet* _tmp37_;
							ValaSet* _tmp38_;
							ValaIterator* _tmp39_;
							ValaIterator* _tmp40_;
							_tmp36_ = child;
							_tmp37_ = vala_basic_block_get_dominator_frontier (_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp39_ = vala_iterable_iterator ((ValaIterable*) _tmp38_);
							_tmp40_ = _tmp39_;
							_vala_iterable_unref0 (_tmp38_);
							_child_frontier_it = _tmp40_;
							while (TRUE) {
								ValaIterator* _tmp41_;
								ValaBasicBlock* child_frontier = NULL;
								ValaIterator* _tmp42_;
								gpointer _tmp43_;
								ValaBasicBlock* _tmp44_;
								ValaBasicBlock* _tmp45_;
								ValaBasicBlock* _tmp46_;
								ValaBasicBlock* _tmp47_;
								_tmp41_ = _child_frontier_it;
								if (!vala_iterator_next (_tmp41_)) {
									break;
								}
								_tmp42_ = _child_frontier_it;
								_tmp43_ = vala_iterator_get (_tmp42_);
								child_frontier = (ValaBasicBlock*) _tmp43_;
								_tmp44_ = child_frontier;
								_tmp45_ = vala_basic_block_get_parent (_tmp44_);
								_tmp46_ = _tmp45_;
								_tmp47_ = block;
								if (_tmp46_ != _tmp47_) {
									ValaBasicBlock* _tmp48_;
									ValaBasicBlock* _tmp49_;
									_tmp48_ = block;
									_tmp49_ = child_frontier;
									vala_basic_block_add_dominator_frontier (_tmp48_, _tmp49_);
								}
								_vala_basic_block_unref0 (child_frontier);
							}
							_vala_iterator_unref0 (_child_frontier_it);
						}
						_vala_basic_block_unref0 (child);
					}
					_vala_iterable_unref0 (_child_list);
				}
				_vala_basic_block_unref0 (block);
			}
		}
	}
}


static ValaMap*
vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self, 
                                       ValaList* block_list, 
                                       ValaBasicBlock* entry_block)
{
	ValaMap* result = NULL;
	ValaHashMap* map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (block_list != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SET, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	map = _tmp3_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp4_;
		gint _block_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _block_index = 0;
		_tmp4_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp4_;
		_tmp5_ = _block_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_block_size = _tmp7_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp14_;
			ValaArrayList* _tmp15_;
			_tmp8_ = _block_index;
			_block_index = _tmp8_ + 1;
			_tmp9_ = _block_index;
			_tmp10_ = _block_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _block_list;
			_tmp12_ = _block_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			block = (ValaBasicBlock*) _tmp13_;
			_tmp14_ = g_direct_equal;
			_tmp15_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
			defined_variables = _tmp15_;
			{
				ValaList* _node_list = NULL;
				ValaBasicBlock* _tmp16_;
				ValaList* _tmp17_;
				gint _node_size = 0;
				ValaList* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _node_index = 0;
				_tmp16_ = block;
				_tmp17_ = vala_basic_block_get_nodes (_tmp16_);
				_node_list = _tmp17_;
				_tmp18_ = _node_list;
				_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
				_tmp20_ = _tmp19_;
				_node_size = _tmp20_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp24_;
					gint _tmp25_;
					gpointer _tmp26_;
					ValaCodeNode* _tmp27_;
					ValaArrayList* _tmp28_;
					_tmp21_ = _node_index;
					_node_index = _tmp21_ + 1;
					_tmp22_ = _node_index;
					_tmp23_ = _node_size;
					if (!(_tmp22_ < _tmp23_)) {
						break;
					}
					_tmp24_ = _node_list;
					_tmp25_ = _node_index;
					_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
					node = (ValaCodeNode*) _tmp26_;
					_tmp27_ = node;
					_tmp28_ = defined_variables;
					vala_code_node_get_defined_variables (_tmp27_, (ValaCollection*) _tmp28_);
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp29_;
				ValaArrayList* _tmp30_;
				gint _variable_size = 0;
				ValaArrayList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _variable_index = 0;
				_tmp29_ = defined_variables;
				_tmp30_ = _vala_iterable_ref0 (_tmp29_);
				_variable_list = _tmp30_;
				_tmp31_ = _variable_list;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_variable_size = _tmp33_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp37_;
					gint _tmp38_;
					gpointer _tmp39_;
					ValaSet* block_set = NULL;
					ValaHashMap* _tmp40_;
					ValaVariable* _tmp41_;
					gpointer _tmp42_;
					ValaSet* _tmp43_;
					ValaSet* _tmp50_;
					ValaBasicBlock* _tmp51_;
					_tmp34_ = _variable_index;
					_variable_index = _tmp34_ + 1;
					_tmp35_ = _variable_index;
					_tmp36_ = _variable_size;
					if (!(_tmp35_ < _tmp36_)) {
						break;
					}
					_tmp37_ = _variable_list;
					_tmp38_ = _variable_index;
					_tmp39_ = vala_list_get ((ValaList*) _tmp37_, _tmp38_);
					variable = (ValaVariable*) _tmp39_;
					_tmp40_ = map;
					_tmp41_ = variable;
					_tmp42_ = vala_map_get ((ValaMap*) _tmp40_, _tmp41_);
					block_set = (ValaSet*) _tmp42_;
					_tmp43_ = block_set;
					if (_tmp43_ == NULL) {
						GHashFunc _tmp44_;
						GEqualFunc _tmp45_;
						ValaHashSet* _tmp46_;
						ValaHashMap* _tmp47_;
						ValaVariable* _tmp48_;
						ValaSet* _tmp49_;
						_tmp44_ = g_direct_hash;
						_tmp45_ = g_direct_equal;
						_tmp46_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp44_, _tmp45_);
						_vala_iterable_unref0 (block_set);
						block_set = (ValaSet*) _tmp46_;
						_tmp47_ = map;
						_tmp48_ = variable;
						_tmp49_ = block_set;
						vala_map_set ((ValaMap*) _tmp47_, _tmp48_, _tmp49_);
					}
					_tmp50_ = block_set;
					_tmp51_ = block;
					vala_collection_add ((ValaCollection*) _tmp50_, _tmp51_);
					_vala_iterable_unref0 (block_set);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	result = (ValaMap*) map;
	return result;
}


static void
vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self, 
                                         ValaList* block_list, 
                                         ValaBasicBlock* entry_block)
{
	ValaMap* assign = NULL;
	ValaMap* _tmp0_;
	gint counter = 0;
	ValaArrayList* work_list = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaHashMap* added = NULL;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	ValaHashMap* phi = NULL;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_assignment_map (self, block_list, entry_block);
	assign = _tmp0_;
	counter = 0;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp1_);
	work_list = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp3_, _tmp4_, _tmp5_);
	added = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp7_, _tmp8_, _tmp9_);
	phi = _tmp10_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp11_;
		gint _block_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _block_index = 0;
		_tmp11_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp11_;
		_tmp12_ = _block_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_block_size = _tmp14_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			ValaHashMap* _tmp21_;
			ValaBasicBlock* _tmp22_;
			ValaHashMap* _tmp23_;
			ValaBasicBlock* _tmp24_;
			_tmp15_ = _block_index;
			_block_index = _tmp15_ + 1;
			_tmp16_ = _block_index;
			_tmp17_ = _block_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _block_list;
			_tmp19_ = _block_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			block = (ValaBasicBlock*) _tmp20_;
			_tmp21_ = added;
			_tmp22_ = block;
			vala_map_set ((ValaMap*) _tmp21_, _tmp22_, (gpointer) ((gintptr) 0));
			_tmp23_ = phi;
			_tmp24_ = block;
			vala_map_set ((ValaMap*) _tmp23_, _tmp24_, (gpointer) ((gintptr) 0));
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	{
		ValaIterator* _variable_it = NULL;
		ValaMap* _tmp25_;
		ValaSet* _tmp26_;
		ValaSet* _tmp27_;
		ValaIterator* _tmp28_;
		ValaIterator* _tmp29_;
		_tmp25_ = assign;
		_tmp26_ = vala_map_get_keys (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_iterable_iterator ((ValaIterable*) _tmp27_);
		_tmp29_ = _tmp28_;
		_vala_iterable_unref0 (_tmp27_);
		_variable_it = _tmp29_;
		while (TRUE) {
			ValaIterator* _tmp30_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp31_;
			gpointer _tmp32_;
			gint _tmp33_;
			_tmp30_ = _variable_it;
			if (!vala_iterator_next (_tmp30_)) {
				break;
			}
			_tmp31_ = _variable_it;
			_tmp32_ = vala_iterator_get (_tmp31_);
			variable = (ValaVariable*) _tmp32_;
			_tmp33_ = counter;
			counter = _tmp33_ + 1;
			{
				ValaIterator* _block_it = NULL;
				ValaMap* _tmp34_;
				ValaVariable* _tmp35_;
				gpointer _tmp36_;
				ValaSet* _tmp37_;
				ValaIterator* _tmp38_;
				ValaIterator* _tmp39_;
				_tmp34_ = assign;
				_tmp35_ = variable;
				_tmp36_ = vala_map_get (_tmp34_, _tmp35_);
				_tmp37_ = (ValaSet*) _tmp36_;
				_tmp38_ = vala_iterable_iterator ((ValaIterable*) _tmp37_);
				_tmp39_ = _tmp38_;
				_vala_iterable_unref0 (_tmp37_);
				_block_it = _tmp39_;
				while (TRUE) {
					ValaIterator* _tmp40_;
					ValaBasicBlock* block = NULL;
					ValaIterator* _tmp41_;
					gpointer _tmp42_;
					ValaArrayList* _tmp43_;
					ValaBasicBlock* _tmp44_;
					ValaHashMap* _tmp45_;
					ValaBasicBlock* _tmp46_;
					gint _tmp47_;
					_tmp40_ = _block_it;
					if (!vala_iterator_next (_tmp40_)) {
						break;
					}
					_tmp41_ = _block_it;
					_tmp42_ = vala_iterator_get (_tmp41_);
					block = (ValaBasicBlock*) _tmp42_;
					_tmp43_ = work_list;
					_tmp44_ = block;
					vala_collection_add ((ValaCollection*) _tmp43_, _tmp44_);
					_tmp45_ = added;
					_tmp46_ = block;
					_tmp47_ = counter;
					vala_map_set ((ValaMap*) _tmp45_, _tmp46_, (gpointer) ((gintptr) _tmp47_));
					_vala_basic_block_unref0 (block);
				}
				_vala_iterator_unref0 (_block_it);
			}
			while (TRUE) {
				ValaArrayList* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				ValaBasicBlock* block = NULL;
				ValaArrayList* _tmp51_;
				gpointer _tmp52_;
				_tmp48_ = work_list;
				_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
				_tmp50_ = _tmp49_;
				if (!(_tmp50_ > 0)) {
					break;
				}
				_tmp51_ = work_list;
				_tmp52_ = vala_list_remove_at ((ValaList*) _tmp51_, 0);
				block = (ValaBasicBlock*) _tmp52_;
				{
					ValaIterator* _frontier_it = NULL;
					ValaBasicBlock* _tmp53_;
					ValaSet* _tmp54_;
					ValaSet* _tmp55_;
					ValaIterator* _tmp56_;
					ValaIterator* _tmp57_;
					_tmp53_ = block;
					_tmp54_ = vala_basic_block_get_dominator_frontier (_tmp53_);
					_tmp55_ = _tmp54_;
					_tmp56_ = vala_iterable_iterator ((ValaIterable*) _tmp55_);
					_tmp57_ = _tmp56_;
					_vala_iterable_unref0 (_tmp55_);
					_frontier_it = _tmp57_;
					while (TRUE) {
						ValaIterator* _tmp58_;
						ValaBasicBlock* frontier = NULL;
						ValaIterator* _tmp59_;
						gpointer _tmp60_;
						gint blockPhi = 0;
						ValaHashMap* _tmp61_;
						ValaBasicBlock* _tmp62_;
						gpointer _tmp63_;
						gint _tmp64_;
						gint _tmp65_;
						_tmp58_ = _frontier_it;
						if (!vala_iterator_next (_tmp58_)) {
							break;
						}
						_tmp59_ = _frontier_it;
						_tmp60_ = vala_iterator_get (_tmp59_);
						frontier = (ValaBasicBlock*) _tmp60_;
						_tmp61_ = phi;
						_tmp62_ = frontier;
						_tmp63_ = vala_map_get ((ValaMap*) _tmp61_, _tmp62_);
						blockPhi = (gint) ((gintptr) _tmp63_);
						_tmp64_ = blockPhi;
						_tmp65_ = counter;
						if (_tmp64_ < _tmp65_) {
							ValaBasicBlock* _tmp66_;
							ValaVariable* _tmp67_;
							ValaBasicBlock* _tmp68_;
							ValaList* _tmp69_;
							ValaList* _tmp70_;
							gint _tmp71_;
							gint _tmp72_;
							ValaPhiFunction* _tmp73_;
							ValaPhiFunction* _tmp74_;
							ValaHashMap* _tmp75_;
							ValaBasicBlock* _tmp76_;
							gint _tmp77_;
							gint block_added = 0;
							ValaHashMap* _tmp78_;
							ValaBasicBlock* _tmp79_;
							gpointer _tmp80_;
							gint _tmp81_;
							gint _tmp82_;
							_tmp66_ = frontier;
							_tmp67_ = variable;
							_tmp68_ = frontier;
							_tmp69_ = vala_basic_block_get_predecessors (_tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = vala_collection_get_size ((ValaCollection*) _tmp70_);
							_tmp72_ = _tmp71_;
							_tmp73_ = vala_phi_function_new (_tmp67_, _tmp72_);
							_tmp74_ = _tmp73_;
							vala_basic_block_add_phi_function (_tmp66_, _tmp74_);
							_vala_phi_function_unref0 (_tmp74_);
							_vala_iterable_unref0 (_tmp70_);
							_tmp75_ = phi;
							_tmp76_ = frontier;
							_tmp77_ = counter;
							vala_map_set ((ValaMap*) _tmp75_, _tmp76_, (gpointer) ((gintptr) _tmp77_));
							_tmp78_ = added;
							_tmp79_ = frontier;
							_tmp80_ = vala_map_get ((ValaMap*) _tmp78_, _tmp79_);
							block_added = (gint) ((gintptr) _tmp80_);
							_tmp81_ = block_added;
							_tmp82_ = counter;
							if (_tmp81_ < _tmp82_) {
								ValaHashMap* _tmp83_;
								ValaBasicBlock* _tmp84_;
								gint _tmp85_;
								ValaArrayList* _tmp86_;
								ValaBasicBlock* _tmp87_;
								_tmp83_ = added;
								_tmp84_ = frontier;
								_tmp85_ = counter;
								vala_map_set ((ValaMap*) _tmp83_, _tmp84_, (gpointer) ((gintptr) _tmp85_));
								_tmp86_ = work_list;
								_tmp87_ = frontier;
								vala_collection_add ((ValaCollection*) _tmp86_, _tmp87_);
							}
						}
						_vala_basic_block_unref0 (frontier);
					}
					_vala_iterator_unref0 (_frontier_it);
				}
				_vala_basic_block_unref0 (block);
			}
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	_vala_map_unref0 (phi);
	_vala_map_unref0 (added);
	_vala_iterable_unref0 (work_list);
	_vala_map_unref0 (assign);
}


static void
vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self, 
                                    ValaBasicBlock* entry_block)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	ValaArrayList* used_vars_queue = NULL;
	GEqualFunc _tmp11_;
	ValaArrayList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = (ValaSet*) _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_PHI_FUNCTION, (GBoxedCopyFunc) vala_phi_function_ref, (GDestroyNotify) vala_phi_function_unref, _tmp7_, _tmp8_, _tmp9_);
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = (ValaMap*) _tmp10_;
	vala_flow_analyzer_check_block_variables (self, entry_block);
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp11_);
	used_vars_queue = _tmp12_;
	{
		ValaIterator* _variable_it = NULL;
		ValaSet* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp13_ = self->priv->used_vars;
		_tmp14_ = vala_iterable_iterator ((ValaIterable*) _tmp13_);
		_variable_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaArrayList* _tmp18_;
			ValaVariable* _tmp19_;
			_tmp15_ = _variable_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _variable_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			variable = (ValaVariable*) _tmp17_;
			_tmp18_ = used_vars_queue;
			_tmp19_ = variable;
			vala_collection_add ((ValaCollection*) _tmp18_, _tmp19_);
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	while (TRUE) {
		ValaArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		ValaVariable* used_var = NULL;
		ValaArrayList* _tmp23_;
		gpointer _tmp24_;
		ValaPhiFunction* phi = NULL;
		ValaMap* _tmp25_;
		ValaVariable* _tmp26_;
		gpointer _tmp27_;
		ValaPhiFunction* _tmp28_;
		_tmp20_ = used_vars_queue;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		if (!(_tmp22_ > 0)) {
			break;
		}
		_tmp23_ = used_vars_queue;
		_tmp24_ = vala_list_remove_at ((ValaList*) _tmp23_, 0);
		used_var = (ValaVariable*) _tmp24_;
		_tmp25_ = self->priv->phi_functions;
		_tmp26_ = used_var;
		_tmp27_ = vala_map_get (_tmp25_, _tmp26_);
		phi = (ValaPhiFunction*) _tmp27_;
		_tmp28_ = phi;
		if (_tmp28_ != NULL) {
			{
				ValaList* _variable_list = NULL;
				ValaPhiFunction* _tmp29_;
				ValaList* _tmp30_;
				ValaList* _tmp31_;
				ValaList* _tmp32_;
				gint _variable_size = 0;
				ValaList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _variable_index = 0;
				_tmp29_ = phi;
				_tmp30_ = vala_phi_function_get_operands (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = _vala_iterable_ref0 (_tmp31_);
				_variable_list = _tmp32_;
				_tmp33_ = _variable_list;
				_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_variable_size = _tmp35_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp36_;
					gint _tmp37_;
					gint _tmp38_;
					ValaVariable* variable = NULL;
					ValaList* _tmp39_;
					gint _tmp40_;
					gpointer _tmp41_;
					ValaVariable* _tmp42_;
					ValaSet* _tmp60_;
					ValaVariable* _tmp61_;
					_tmp36_ = _variable_index;
					_variable_index = _tmp36_ + 1;
					_tmp37_ = _variable_index;
					_tmp38_ = _variable_size;
					if (!(_tmp37_ < _tmp38_)) {
						break;
					}
					_tmp39_ = _variable_list;
					_tmp40_ = _variable_index;
					_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
					variable = (ValaVariable*) _tmp41_;
					_tmp42_ = variable;
					if (_tmp42_ == NULL) {
						ValaVariable* _tmp43_;
						_tmp43_ = used_var;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_LOCAL_VARIABLE)) {
							ValaVariable* _tmp44_;
							ValaSourceReference* _tmp45_;
							ValaSourceReference* _tmp46_;
							ValaVariable* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							gchar* _tmp50_;
							gchar* _tmp51_;
							_tmp44_ = used_var;
							_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp44_);
							_tmp46_ = _tmp45_;
							_tmp47_ = used_var;
							_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp49_);
							_tmp51_ = _tmp50_;
							vala_report_error (_tmp46_, _tmp51_);
							_g_free0 (_tmp51_);
						} else {
							ValaVariable* _tmp52_;
							ValaSourceReference* _tmp53_;
							ValaSourceReference* _tmp54_;
							ValaVariable* _tmp55_;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							gchar* _tmp58_;
							gchar* _tmp59_;
							_tmp52_ = used_var;
							_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = used_var;
							_tmp56_ = vala_symbol_get_name ((ValaSymbol*) _tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp57_);
							_tmp59_ = _tmp58_;
							vala_report_warning (_tmp54_, _tmp59_);
							_g_free0 (_tmp59_);
						}
						_vala_code_node_unref0 (variable);
						continue;
					}
					_tmp60_ = self->priv->used_vars;
					_tmp61_ = variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp60_, _tmp61_)) {
						ValaVariable* _tmp62_;
						ValaVariable* _tmp63_;
						ValaSourceReference* _tmp64_;
						ValaSourceReference* _tmp65_;
						ValaSet* _tmp66_;
						ValaVariable* _tmp67_;
						ValaArrayList* _tmp68_;
						ValaVariable* _tmp69_;
						_tmp62_ = variable;
						_tmp63_ = used_var;
						_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
						_tmp65_ = _tmp64_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp62_, _tmp65_);
						_tmp66_ = self->priv->used_vars;
						_tmp67_ = variable;
						vala_collection_add ((ValaCollection*) _tmp66_, _tmp67_);
						_tmp68_ = used_vars_queue;
						_tmp69_ = variable;
						vala_collection_add ((ValaCollection*) _tmp68_, _tmp69_);
					}
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
		}
		_vala_phi_function_unref0 (phi);
		_vala_code_node_unref0 (used_var);
	}
	_vala_iterable_unref0 (used_vars_queue);
}


static void
vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self, 
                                          ValaBasicBlock* block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp0_;
		ValaSet* _tmp1_;
		ValaIterator* _tmp2_;
		ValaIterator* _tmp3_;
		_tmp0_ = vala_basic_block_get_phi_functions (block);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_vala_iterable_unref0 (_tmp1_);
		_phi_it = _tmp3_;
		while (TRUE) {
			ValaIterator* _tmp4_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp5_;
			gpointer _tmp6_;
			ValaVariable* versioned_var = NULL;
			ValaMap* _tmp7_;
			ValaPhiFunction* _tmp8_;
			ValaVariable* _tmp9_;
			ValaVariable* _tmp10_;
			ValaVariable* _tmp11_;
			ValaMap* _tmp12_;
			ValaVariable* _tmp13_;
			ValaPhiFunction* _tmp14_;
			_tmp4_ = _phi_it;
			if (!vala_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _phi_it;
			_tmp6_ = vala_iterator_get (_tmp5_);
			phi = (ValaPhiFunction*) _tmp6_;
			_tmp7_ = self->priv->var_map;
			_tmp8_ = phi;
			_tmp9_ = vala_phi_function_get_original_variable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_flow_analyzer_process_assignment (self, _tmp7_, _tmp10_);
			versioned_var = _tmp11_;
			_tmp12_ = self->priv->phi_functions;
			_tmp13_ = versioned_var;
			_tmp14_ = phi;
			vala_map_set (_tmp12_, _tmp13_, _tmp14_);
			_vala_code_node_unref0 (versioned_var);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp15_;
		gint _node_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _node_index = 0;
		_tmp15_ = vala_basic_block_get_nodes (block);
		_node_list = _tmp15_;
		_tmp16_ = _node_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_node_size = _tmp18_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp22_;
			gint _tmp23_;
			gpointer _tmp24_;
			ValaArrayList* used_variables = NULL;
			GEqualFunc _tmp25_;
			ValaArrayList* _tmp26_;
			ValaCodeNode* _tmp27_;
			ValaArrayList* _tmp28_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp78_;
			ValaArrayList* _tmp79_;
			ValaCodeNode* _tmp80_;
			ValaArrayList* _tmp81_;
			_tmp19_ = _node_index;
			_node_index = _tmp19_ + 1;
			_tmp20_ = _node_index;
			_tmp21_ = _node_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _node_list;
			_tmp23_ = _node_index;
			_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
			node = (ValaCodeNode*) _tmp24_;
			_tmp25_ = g_direct_equal;
			_tmp26_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp25_);
			used_variables = _tmp26_;
			_tmp27_ = node;
			_tmp28_ = used_variables;
			vala_code_node_get_used_variables (_tmp27_, (ValaCollection*) _tmp28_);
			{
				ValaArrayList* _var_symbol_list = NULL;
				ValaArrayList* _tmp29_;
				ValaArrayList* _tmp30_;
				gint _var_symbol_size = 0;
				ValaArrayList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _var_symbol_index = 0;
				_tmp29_ = used_variables;
				_tmp30_ = _vala_iterable_ref0 (_tmp29_);
				_var_symbol_list = _tmp30_;
				_tmp31_ = _var_symbol_list;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_var_symbol_size = _tmp33_;
				_var_symbol_index = -1;
				while (TRUE) {
					gint _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					ValaVariable* var_symbol = NULL;
					ValaArrayList* _tmp37_;
					gint _tmp38_;
					gpointer _tmp39_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp40_;
					ValaVariable* _tmp41_;
					gpointer _tmp42_;
					gboolean _tmp43_ = FALSE;
					ValaList* _tmp44_;
					ValaVariable* versioned_variable = NULL;
					ValaList* _tmp65_;
					ValaList* _tmp66_;
					gint _tmp67_;
					gint _tmp68_;
					gpointer _tmp69_;
					ValaSet* _tmp70_;
					ValaVariable* _tmp71_;
					ValaSet* _tmp76_;
					ValaVariable* _tmp77_;
					_tmp34_ = _var_symbol_index;
					_var_symbol_index = _tmp34_ + 1;
					_tmp35_ = _var_symbol_index;
					_tmp36_ = _var_symbol_size;
					if (!(_tmp35_ < _tmp36_)) {
						break;
					}
					_tmp37_ = _var_symbol_list;
					_tmp38_ = _var_symbol_index;
					_tmp39_ = vala_list_get ((ValaList*) _tmp37_, _tmp38_);
					var_symbol = (ValaVariable*) _tmp39_;
					_tmp40_ = self->priv->var_map;
					_tmp41_ = var_symbol;
					_tmp42_ = vala_map_get (_tmp40_, (ValaSymbol*) _tmp41_);
					variable_stack = (ValaList*) _tmp42_;
					_tmp44_ = variable_stack;
					if (_tmp44_ == NULL) {
						_tmp43_ = TRUE;
					} else {
						ValaList* _tmp45_;
						gint _tmp46_;
						gint _tmp47_;
						_tmp45_ = variable_stack;
						_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
						_tmp47_ = _tmp46_;
						_tmp43_ = _tmp47_ == 0;
					}
					if (_tmp43_) {
						ValaVariable* _tmp48_;
						_tmp48_ = var_symbol;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_LOCAL_VARIABLE)) {
							ValaCodeNode* _tmp49_;
							ValaSourceReference* _tmp50_;
							ValaSourceReference* _tmp51_;
							ValaVariable* _tmp52_;
							const gchar* _tmp53_;
							const gchar* _tmp54_;
							gchar* _tmp55_;
							gchar* _tmp56_;
							_tmp49_ = node;
							_tmp50_ = vala_code_node_get_source_reference (_tmp49_);
							_tmp51_ = _tmp50_;
							_tmp52_ = var_symbol;
							_tmp53_ = vala_symbol_get_name ((ValaSymbol*) _tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp54_);
							_tmp56_ = _tmp55_;
							vala_report_error (_tmp51_, _tmp56_);
							_g_free0 (_tmp56_);
						} else {
							ValaCodeNode* _tmp57_;
							ValaSourceReference* _tmp58_;
							ValaSourceReference* _tmp59_;
							ValaVariable* _tmp60_;
							const gchar* _tmp61_;
							const gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							_tmp57_ = node;
							_tmp58_ = vala_code_node_get_source_reference (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = var_symbol;
							_tmp61_ = vala_symbol_get_name ((ValaSymbol*) _tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp62_);
							_tmp64_ = _tmp63_;
							vala_report_warning (_tmp59_, _tmp64_);
							_g_free0 (_tmp64_);
						}
						_vala_iterable_unref0 (variable_stack);
						_vala_code_node_unref0 (var_symbol);
						continue;
					}
					_tmp65_ = variable_stack;
					_tmp66_ = variable_stack;
					_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = vala_list_get (_tmp65_, _tmp68_ - 1);
					versioned_variable = (ValaVariable*) _tmp69_;
					_tmp70_ = self->priv->used_vars;
					_tmp71_ = versioned_variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp70_, _tmp71_)) {
						ValaVariable* _tmp72_;
						ValaCodeNode* _tmp73_;
						ValaSourceReference* _tmp74_;
						ValaSourceReference* _tmp75_;
						_tmp72_ = versioned_variable;
						_tmp73_ = node;
						_tmp74_ = vala_code_node_get_source_reference (_tmp73_);
						_tmp75_ = _tmp74_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp72_, _tmp75_);
					}
					_tmp76_ = self->priv->used_vars;
					_tmp77_ = versioned_variable;
					vala_collection_add ((ValaCollection*) _tmp76_, _tmp77_);
					_vala_code_node_unref0 (versioned_variable);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (var_symbol);
				}
				_vala_iterable_unref0 (_var_symbol_list);
			}
			_tmp78_ = g_direct_equal;
			_tmp79_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp78_);
			defined_variables = _tmp79_;
			_tmp80_ = node;
			_tmp81_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp80_, (ValaCollection*) _tmp81_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp82_;
				ValaArrayList* _tmp83_;
				gint _variable_size = 0;
				ValaArrayList* _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				gint _variable_index = 0;
				_tmp82_ = defined_variables;
				_tmp83_ = _vala_iterable_ref0 (_tmp82_);
				_variable_list = _tmp83_;
				_tmp84_ = _variable_list;
				_tmp85_ = vala_collection_get_size ((ValaCollection*) _tmp84_);
				_tmp86_ = _tmp85_;
				_variable_size = _tmp86_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp87_;
					gint _tmp88_;
					gint _tmp89_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp90_;
					gint _tmp91_;
					gpointer _tmp92_;
					ValaMap* _tmp93_;
					ValaVariable* _tmp94_;
					ValaVariable* _tmp95_;
					ValaVariable* _tmp96_;
					_tmp87_ = _variable_index;
					_variable_index = _tmp87_ + 1;
					_tmp88_ = _variable_index;
					_tmp89_ = _variable_size;
					if (!(_tmp88_ < _tmp89_)) {
						break;
					}
					_tmp90_ = _variable_list;
					_tmp91_ = _variable_index;
					_tmp92_ = vala_list_get ((ValaList*) _tmp90_, _tmp91_);
					variable = (ValaVariable*) _tmp92_;
					_tmp93_ = self->priv->var_map;
					_tmp94_ = variable;
					_tmp95_ = vala_flow_analyzer_process_assignment (self, _tmp93_, _tmp94_);
					_tmp96_ = _tmp95_;
					_vala_code_node_unref0 (_tmp96_);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_iterable_unref0 (used_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp97_;
		gint _succ_size = 0;
		ValaList* _tmp98_;
		gint _tmp99_;
		gint _tmp100_;
		gint _succ_index = 0;
		_tmp97_ = vala_basic_block_get_successors (block);
		_succ_list = _tmp97_;
		_tmp98_ = _succ_list;
		_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
		_tmp100_ = _tmp99_;
		_succ_size = _tmp100_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp101_;
			gint _tmp102_;
			gint _tmp103_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp104_;
			gint _tmp105_;
			gpointer _tmp106_;
			ValaBasicBlock* _tmp107_;
			gint j = 0;
			_tmp101_ = _succ_index;
			_succ_index = _tmp101_ + 1;
			_tmp102_ = _succ_index;
			_tmp103_ = _succ_size;
			if (!(_tmp102_ < _tmp103_)) {
				break;
			}
			_tmp104_ = _succ_list;
			_tmp105_ = _succ_index;
			_tmp106_ = vala_list_get (_tmp104_, _tmp105_);
			_tmp107_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp106_);
			succ = _tmp107_;
			j = 0;
			{
				ValaList* _pred_list = NULL;
				ValaBasicBlock* _tmp108_;
				ValaList* _tmp109_;
				gint _pred_size = 0;
				ValaList* _tmp110_;
				gint _tmp111_;
				gint _tmp112_;
				gint _pred_index = 0;
				_tmp108_ = succ;
				_tmp109_ = vala_basic_block_get_predecessors (_tmp108_);
				_pred_list = _tmp109_;
				_tmp110_ = _pred_list;
				_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
				_tmp112_ = _tmp111_;
				_pred_size = _tmp112_;
				_pred_index = -1;
				while (TRUE) {
					gint _tmp113_;
					gint _tmp114_;
					gint _tmp115_;
					ValaBasicBlock* pred = NULL;
					ValaList* _tmp116_;
					gint _tmp117_;
					gpointer _tmp118_;
					ValaBasicBlock* _tmp119_;
					ValaBasicBlock* _tmp120_;
					gint _tmp121_;
					_tmp113_ = _pred_index;
					_pred_index = _tmp113_ + 1;
					_tmp114_ = _pred_index;
					_tmp115_ = _pred_size;
					if (!(_tmp114_ < _tmp115_)) {
						break;
					}
					_tmp116_ = _pred_list;
					_tmp117_ = _pred_index;
					_tmp118_ = vala_list_get (_tmp116_, _tmp117_);
					_tmp119_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp118_);
					pred = _tmp119_;
					_tmp120_ = pred;
					if (_tmp120_ == block) {
						_vala_basic_block_unref0 (pred);
						break;
					}
					_tmp121_ = j;
					j = _tmp121_ + 1;
					_vala_basic_block_unref0 (pred);
				}
				_vala_iterable_unref0 (_pred_list);
			}
			{
				ValaIterator* _phi_it = NULL;
				ValaBasicBlock* _tmp122_;
				ValaSet* _tmp123_;
				ValaSet* _tmp124_;
				ValaIterator* _tmp125_;
				ValaIterator* _tmp126_;
				_tmp122_ = succ;
				_tmp123_ = vala_basic_block_get_phi_functions (_tmp122_);
				_tmp124_ = _tmp123_;
				_tmp125_ = vala_iterable_iterator ((ValaIterable*) _tmp124_);
				_tmp126_ = _tmp125_;
				_vala_iterable_unref0 (_tmp124_);
				_phi_it = _tmp126_;
				while (TRUE) {
					ValaIterator* _tmp127_;
					ValaPhiFunction* phi = NULL;
					ValaIterator* _tmp128_;
					gpointer _tmp129_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp130_;
					ValaPhiFunction* _tmp131_;
					ValaVariable* _tmp132_;
					ValaVariable* _tmp133_;
					gpointer _tmp134_;
					gboolean _tmp135_ = FALSE;
					ValaList* _tmp136_;
					_tmp127_ = _phi_it;
					if (!vala_iterator_next (_tmp127_)) {
						break;
					}
					_tmp128_ = _phi_it;
					_tmp129_ = vala_iterator_get (_tmp128_);
					phi = (ValaPhiFunction*) _tmp129_;
					_tmp130_ = self->priv->var_map;
					_tmp131_ = phi;
					_tmp132_ = vala_phi_function_get_original_variable (_tmp131_);
					_tmp133_ = _tmp132_;
					_tmp134_ = vala_map_get (_tmp130_, (ValaSymbol*) _tmp133_);
					variable_stack = (ValaList*) _tmp134_;
					_tmp136_ = variable_stack;
					if (_tmp136_ != NULL) {
						ValaList* _tmp137_;
						gint _tmp138_;
						gint _tmp139_;
						_tmp137_ = variable_stack;
						_tmp138_ = vala_collection_get_size ((ValaCollection*) _tmp137_);
						_tmp139_ = _tmp138_;
						_tmp135_ = _tmp139_ > 0;
					} else {
						_tmp135_ = FALSE;
					}
					if (_tmp135_) {
						ValaPhiFunction* _tmp140_;
						ValaList* _tmp141_;
						ValaList* _tmp142_;
						gint _tmp143_;
						ValaList* _tmp144_;
						ValaList* _tmp145_;
						gint _tmp146_;
						gint _tmp147_;
						gpointer _tmp148_;
						ValaVariable* _tmp149_;
						_tmp140_ = phi;
						_tmp141_ = vala_phi_function_get_operands (_tmp140_);
						_tmp142_ = _tmp141_;
						_tmp143_ = j;
						_tmp144_ = variable_stack;
						_tmp145_ = variable_stack;
						_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
						_tmp147_ = _tmp146_;
						_tmp148_ = vala_list_get (_tmp144_, _tmp147_ - 1);
						_tmp149_ = (ValaVariable*) _tmp148_;
						vala_list_set (_tmp142_, _tmp143_, _tmp149_);
						_vala_code_node_unref0 (_tmp149_);
					}
					_vala_iterable_unref0 (variable_stack);
					_vala_phi_function_unref0 (phi);
				}
				_vala_iterator_unref0 (_phi_it);
			}
			_vala_basic_block_unref0 (succ);
		}
		_vala_iterable_unref0 (_succ_list);
	}
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp150_;
		gint _child_size = 0;
		ValaList* _tmp151_;
		gint _tmp152_;
		gint _tmp153_;
		gint _child_index = 0;
		_tmp150_ = vala_basic_block_get_children (block);
		_child_list = _tmp150_;
		_tmp151_ = _child_list;
		_tmp152_ = vala_collection_get_size ((ValaCollection*) _tmp151_);
		_tmp153_ = _tmp152_;
		_child_size = _tmp153_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp154_;
			gint _tmp155_;
			gint _tmp156_;
			ValaBasicBlock* child = NULL;
			ValaList* _tmp157_;
			gint _tmp158_;
			gpointer _tmp159_;
			ValaBasicBlock* _tmp160_;
			_tmp154_ = _child_index;
			_child_index = _tmp154_ + 1;
			_tmp155_ = _child_index;
			_tmp156_ = _child_size;
			if (!(_tmp155_ < _tmp156_)) {
				break;
			}
			_tmp157_ = _child_list;
			_tmp158_ = _child_index;
			_tmp159_ = vala_list_get (_tmp157_, _tmp158_);
			child = (ValaBasicBlock*) _tmp159_;
			_tmp160_ = child;
			vala_flow_analyzer_check_block_variables (self, _tmp160_);
			_vala_basic_block_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp161_;
		ValaSet* _tmp162_;
		ValaIterator* _tmp163_;
		ValaIterator* _tmp164_;
		_tmp161_ = vala_basic_block_get_phi_functions (block);
		_tmp162_ = _tmp161_;
		_tmp163_ = vala_iterable_iterator ((ValaIterable*) _tmp162_);
		_tmp164_ = _tmp163_;
		_vala_iterable_unref0 (_tmp162_);
		_phi_it = _tmp164_;
		while (TRUE) {
			ValaIterator* _tmp165_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp166_;
			gpointer _tmp167_;
			ValaList* variable_stack = NULL;
			ValaMap* _tmp168_;
			ValaPhiFunction* _tmp169_;
			ValaVariable* _tmp170_;
			ValaVariable* _tmp171_;
			gpointer _tmp172_;
			ValaList* _tmp173_;
			ValaList* _tmp174_;
			gint _tmp175_;
			gint _tmp176_;
			gpointer _tmp177_;
			ValaVariable* _tmp178_;
			_tmp165_ = _phi_it;
			if (!vala_iterator_next (_tmp165_)) {
				break;
			}
			_tmp166_ = _phi_it;
			_tmp167_ = vala_iterator_get (_tmp166_);
			phi = (ValaPhiFunction*) _tmp167_;
			_tmp168_ = self->priv->var_map;
			_tmp169_ = phi;
			_tmp170_ = vala_phi_function_get_original_variable (_tmp169_);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_map_get (_tmp168_, (ValaSymbol*) _tmp171_);
			variable_stack = (ValaList*) _tmp172_;
			_tmp173_ = variable_stack;
			_tmp174_ = variable_stack;
			_tmp175_ = vala_collection_get_size ((ValaCollection*) _tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_list_remove_at (_tmp173_, _tmp176_ - 1);
			_tmp178_ = (ValaVariable*) _tmp177_;
			_vala_code_node_unref0 (_tmp178_);
			_vala_iterable_unref0 (variable_stack);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp179_;
		gint _node_size = 0;
		ValaList* _tmp180_;
		gint _tmp181_;
		gint _tmp182_;
		gint _node_index = 0;
		_tmp179_ = vala_basic_block_get_nodes (block);
		_node_list = _tmp179_;
		_tmp180_ = _node_list;
		_tmp181_ = vala_collection_get_size ((ValaCollection*) _tmp180_);
		_tmp182_ = _tmp181_;
		_node_size = _tmp182_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp183_;
			gint _tmp184_;
			gint _tmp185_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp186_;
			gint _tmp187_;
			gpointer _tmp188_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp189_;
			ValaArrayList* _tmp190_;
			ValaCodeNode* _tmp191_;
			ValaArrayList* _tmp192_;
			_tmp183_ = _node_index;
			_node_index = _tmp183_ + 1;
			_tmp184_ = _node_index;
			_tmp185_ = _node_size;
			if (!(_tmp184_ < _tmp185_)) {
				break;
			}
			_tmp186_ = _node_list;
			_tmp187_ = _node_index;
			_tmp188_ = vala_list_get (_tmp186_, _tmp187_);
			node = (ValaCodeNode*) _tmp188_;
			_tmp189_ = g_direct_equal;
			_tmp190_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp189_);
			defined_variables = _tmp190_;
			_tmp191_ = node;
			_tmp192_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp191_, (ValaCollection*) _tmp192_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp193_;
				ValaArrayList* _tmp194_;
				gint _variable_size = 0;
				ValaArrayList* _tmp195_;
				gint _tmp196_;
				gint _tmp197_;
				gint _variable_index = 0;
				_tmp193_ = defined_variables;
				_tmp194_ = _vala_iterable_ref0 (_tmp193_);
				_variable_list = _tmp194_;
				_tmp195_ = _variable_list;
				_tmp196_ = vala_collection_get_size ((ValaCollection*) _tmp195_);
				_tmp197_ = _tmp196_;
				_variable_size = _tmp197_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp198_;
					gint _tmp199_;
					gint _tmp200_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp201_;
					gint _tmp202_;
					gpointer _tmp203_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp204_;
					ValaVariable* _tmp205_;
					gpointer _tmp206_;
					ValaList* _tmp207_;
					ValaList* _tmp208_;
					gint _tmp209_;
					gint _tmp210_;
					gpointer _tmp211_;
					ValaVariable* _tmp212_;
					_tmp198_ = _variable_index;
					_variable_index = _tmp198_ + 1;
					_tmp199_ = _variable_index;
					_tmp200_ = _variable_size;
					if (!(_tmp199_ < _tmp200_)) {
						break;
					}
					_tmp201_ = _variable_list;
					_tmp202_ = _variable_index;
					_tmp203_ = vala_list_get ((ValaList*) _tmp201_, _tmp202_);
					variable = (ValaVariable*) _tmp203_;
					_tmp204_ = self->priv->var_map;
					_tmp205_ = variable;
					_tmp206_ = vala_map_get (_tmp204_, (ValaSymbol*) _tmp205_);
					variable_stack = (ValaList*) _tmp206_;
					_tmp207_ = variable_stack;
					_tmp208_ = variable_stack;
					_tmp209_ = vala_collection_get_size ((ValaCollection*) _tmp208_);
					_tmp210_ = _tmp209_;
					_tmp211_ = vala_list_remove_at (_tmp207_, _tmp210_ - 1);
					_tmp212_ = (ValaVariable*) _tmp211_;
					_vala_code_node_unref0 (_tmp212_);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static ValaVariable*
vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self, 
                                       ValaMap* var_map, 
                                       ValaVariable* var_symbol)
{
	ValaVariable* result = NULL;
	ValaList* variable_stack = NULL;
	gpointer _tmp0_;
	ValaList* _tmp1_;
	ValaVariable* versioned_var = NULL;
	ValaList* _tmp23_;
	ValaVariable* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_map != NULL, NULL);
	g_return_val_if_fail (var_symbol != NULL, NULL);
	_tmp0_ = vala_map_get (var_map, (ValaSymbol*) var_symbol);
	variable_stack = (ValaList*) _tmp0_;
	_tmp1_ = variable_stack;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		ValaList* _tmp4_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (variable_stack);
		variable_stack = (ValaList*) _tmp3_;
		_tmp4_ = variable_stack;
		vala_map_set (var_map, (ValaSymbol*) var_symbol, _tmp4_);
		vala_variable_set_single_assignment (var_symbol, TRUE);
	} else {
		vala_variable_set_single_assignment (var_symbol, FALSE);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (var_symbol, VALA_TYPE_LOCAL_VARIABLE)) {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaLocalVariable* _tmp13_;
		_tmp5_ = vala_variable_get_variable_type (var_symbol);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_copy (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_local_variable_new (_tmp8_, _tmp10_, NULL, _tmp12_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp13_;
		_vala_code_node_unref0 (_tmp8_);
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type (var_symbol);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_data_type_copy (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_parameter_new (_tmp15_, _tmp19_, _tmp21_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp22_;
		_vala_code_node_unref0 (_tmp19_);
	}
	_tmp23_ = variable_stack;
	_tmp24_ = versioned_var;
	vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
	result = versioned_var;
	_vala_iterable_unref0 (variable_stack);
	return result;
}


static void
vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base, 
                                               ValaCreationMethod* m)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	vala_code_visitor_visit_method ((ValaCodeVisitor*) self, (ValaMethod*) m);
}


static void
vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base, 
                                        ValaProperty* prop)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (prop != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base, 
                                                 ValaPropertyAccessor* acc)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (acc != NULL);
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) acc);
}


static void
vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base, 
                                     ValaBlock* b)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (b != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) self);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base, 
                                                     ValaDeclarationStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaBasicBlock* _tmp16_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaLocalVariable* _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaLocalVariable* _tmp21_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_declaration_statement_get_declaration (stmt);
		_tmp1_ = _tmp0_;
		vala_code_node_set_unreachable ((ValaCodeNode*) _tmp1_, TRUE);
		return;
	}
	_tmp2_ = vala_declaration_statement_get_declaration (stmt);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_used (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = vala_declaration_statement_get_declaration (stmt);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_declaration_statement_get_declaration (stmt);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("local variable `%s' declared but never used", _tmp13_);
		_tmp15_ = _tmp14_;
		vala_report_warning (_tmp9_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp16_, (ValaCodeNode*) stmt);
	_tmp17_ = vala_declaration_statement_get_declaration (stmt);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp18_) : NULL);
	local = _tmp19_;
	_tmp21_ = local;
	if (_tmp21_ != NULL) {
		ValaLocalVariable* _tmp22_;
		ValaExpression* _tmp23_;
		ValaExpression* _tmp24_;
		_tmp22_ = local;
		_tmp23_ = vala_variable_get_initializer ((ValaVariable*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		ValaLocalVariable* _tmp25_;
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp25_ = local;
		_tmp26_ = vala_variable_get_initializer ((ValaVariable*) _tmp25_);
		_tmp27_ = _tmp26_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp27_, FALSE);
	}
	_vala_code_node_unref0 (local);
}


static void
vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base, 
                                              ValaLocalVariable* local)
{
	ValaFlowAnalyzer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) local);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) local);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
}


static void
vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base, 
                                                    ValaExpressionStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, FALSE);
	_tmp1_ = vala_expression_statement_get_expression (stmt);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_METHOD_CALL)) {
		ValaMethodCall* expr = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaMethodCall* _tmp5_;
		ValaMemberAccess* ma = NULL;
		ValaMethodCall* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaMemberAccess* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMemberAccess* _tmp12_;
		_tmp3_ = vala_expression_statement_get_expression (stmt);
		_tmp4_ = _tmp3_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
		expr = _tmp5_;
		_tmp6_ = expr;
		_tmp7_ = vala_method_call_get_call (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp8_) : NULL);
		ma = _tmp9_;
		_tmp12_ = ma;
		if (_tmp12_ != NULL) {
			ValaMemberAccess* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp13_ = ma;
			_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaMemberAccess* _tmp16_;
			ValaSymbol* _tmp17_;
			ValaSymbol* _tmp18_;
			ValaAttribute* _tmp19_;
			ValaAttribute* _tmp20_;
			_tmp16_ = ma;
			_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp18_, "NoReturn");
			_tmp20_ = _tmp19_;
			_tmp10_ = _tmp20_ != NULL;
			_vala_code_node_unref0 (_tmp20_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			vala_flow_analyzer_mark_unreachable (self);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (expr);
			return;
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
}


static gboolean
vala_flow_analyzer_always_true (ValaFlowAnalyzer* self, 
                                ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean
vala_flow_analyzer_always_false (ValaFlowAnalyzer* self, 
                                 ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (condition, VALA_TYPE_BOOLEAN_LITERAL) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static void
vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base, 
                                            ValaIfStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaBlock* _tmp12_;
	ValaBlock* _tmp13_;
	ValaBasicBlock* last_true_block = NULL;
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	ValaBlock* _tmp21_;
	ValaBlock* _tmp22_;
	ValaBasicBlock* last_false_block = NULL;
	ValaBasicBlock* _tmp25_;
	ValaBasicBlock* _tmp26_;
	gboolean _tmp27_ = FALSE;
	ValaBasicBlock* _tmp28_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_if_statement_get_condition (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_if_statement_get_condition (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = self->priv->current_block;
	_tmp6_ = _vala_basic_block_ref0 (_tmp5_);
	last_block = _tmp6_;
	_tmp7_ = vala_if_statement_get_condition (stmt);
	_tmp8_ = _tmp7_;
	if (vala_flow_analyzer_always_false (self, _tmp8_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp9_;
		ValaBasicBlock* _tmp10_;
		ValaBasicBlock* _tmp11_;
		_tmp9_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp9_;
		_tmp10_ = last_block;
		_tmp11_ = self->priv->current_block;
		vala_basic_block_connect (_tmp10_, _tmp11_);
	}
	_tmp12_ = vala_if_statement_get_true_statement (stmt);
	_tmp13_ = _tmp12_;
	vala_code_node_accept ((ValaCodeNode*) _tmp13_, (ValaCodeVisitor*) self);
	_tmp14_ = self->priv->current_block;
	_tmp15_ = _vala_basic_block_ref0 (_tmp14_);
	last_true_block = _tmp15_;
	_tmp16_ = vala_if_statement_get_condition (stmt);
	_tmp17_ = _tmp16_;
	if (vala_flow_analyzer_always_true (self, _tmp17_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp18_;
		ValaBasicBlock* _tmp19_;
		ValaBasicBlock* _tmp20_;
		_tmp18_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp18_;
		_tmp19_ = last_block;
		_tmp20_ = self->priv->current_block;
		vala_basic_block_connect (_tmp19_, _tmp20_);
	}
	_tmp21_ = vala_if_statement_get_false_statement (stmt);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaBlock* _tmp23_;
		ValaBlock* _tmp24_;
		_tmp23_ = vala_if_statement_get_false_statement (stmt);
		_tmp24_ = _tmp23_;
		vala_code_node_accept ((ValaCodeNode*) _tmp24_, (ValaCodeVisitor*) self);
	}
	_tmp25_ = self->priv->current_block;
	_tmp26_ = _vala_basic_block_ref0 (_tmp25_);
	last_false_block = _tmp26_;
	_tmp28_ = last_true_block;
	if (_tmp28_ != NULL) {
		_tmp27_ = TRUE;
	} else {
		ValaBasicBlock* _tmp29_;
		_tmp29_ = last_false_block;
		_tmp27_ = _tmp29_ != NULL;
	}
	if (_tmp27_) {
		ValaBasicBlock* _tmp30_;
		ValaBasicBlock* _tmp31_;
		ValaBasicBlock* _tmp34_;
		_tmp30_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp30_;
		_tmp31_ = last_true_block;
		if (_tmp31_ != NULL) {
			ValaBasicBlock* _tmp32_;
			ValaBasicBlock* _tmp33_;
			_tmp32_ = last_true_block;
			_tmp33_ = self->priv->current_block;
			vala_basic_block_connect (_tmp32_, _tmp33_);
		}
		_tmp34_ = last_false_block;
		if (_tmp34_ != NULL) {
			ValaBasicBlock* _tmp35_;
			ValaBasicBlock* _tmp36_;
			_tmp35_ = last_false_block;
			_tmp36_ = self->priv->current_block;
			vala_basic_block_connect (_tmp35_, _tmp36_);
		}
	}
	_vala_basic_block_unref0 (last_false_block);
	_vala_basic_block_unref0 (last_true_block);
	_vala_basic_block_unref0 (last_block);
}


static void
vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base, 
                                                ValaSwitchStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* after_switch_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaList* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaFlowAnalyzerJumpTarget* _tmp3_;
	ValaFlowAnalyzerJumpTarget* _tmp4_;
	ValaBasicBlock* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaBasicBlock* condition_block = NULL;
	ValaBasicBlock* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	gboolean has_default_label = FALSE;
	gboolean _tmp45_;
	ValaBasicBlock* _tmp48_;
	ValaList* _tmp49_;
	ValaList* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gboolean _tmp53_;
	ValaList* _tmp56_;
	ValaList* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gpointer _tmp60_;
	ValaFlowAnalyzerJumpTarget* _tmp61_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	after_switch_block = _tmp0_;
	_tmp1_ = self->priv->jump_stack;
	_tmp2_ = after_switch_block;
	_tmp3_ = vala_flow_analyzer_jump_target_new_break_target (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp4_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp4_);
	_tmp5_ = self->priv->current_block;
	_tmp6_ = vala_switch_statement_get_expression (stmt);
	_tmp7_ = _tmp6_;
	vala_basic_block_add_node (_tmp5_, (ValaCodeNode*) _tmp7_);
	_tmp8_ = self->priv->current_block;
	_tmp9_ = _vala_basic_block_ref0 (_tmp8_);
	condition_block = _tmp9_;
	_tmp10_ = vala_switch_statement_get_expression (stmt);
	_tmp11_ = _tmp10_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp11_, FALSE);
	has_default_label = FALSE;
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp12_;
		gint _section_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _section_index = 0;
		_tmp12_ = vala_switch_statement_get_sections (stmt);
		_section_list = _tmp12_;
		_tmp13_ = _section_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_section_size = _tmp15_;
		_section_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaSwitchSection* section = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaBasicBlock* _tmp22_;
			ValaBasicBlock* _tmp23_;
			ValaBasicBlock* _tmp24_;
			ValaSwitchSection* _tmp37_;
			ValaBasicBlock* _tmp38_;
			_tmp16_ = _section_index;
			_section_index = _tmp16_ + 1;
			_tmp17_ = _section_index;
			_tmp18_ = _section_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _section_list;
			_tmp20_ = _section_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			section = (ValaSwitchSection*) _tmp21_;
			_tmp22_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp22_;
			_tmp23_ = condition_block;
			_tmp24_ = self->priv->current_block;
			vala_basic_block_connect (_tmp23_, _tmp24_);
			{
				ValaList* _section_stmt_list = NULL;
				ValaSwitchSection* _tmp25_;
				ValaList* _tmp26_;
				gint _section_stmt_size = 0;
				ValaList* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _section_stmt_index = 0;
				_tmp25_ = section;
				_tmp26_ = vala_block_get_statements ((ValaBlock*) _tmp25_);
				_section_stmt_list = _tmp26_;
				_tmp27_ = _section_stmt_list;
				_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				_section_stmt_size = _tmp29_;
				_section_stmt_index = -1;
				while (TRUE) {
					gint _tmp30_;
					gint _tmp31_;
					gint _tmp32_;
					ValaStatement* section_stmt = NULL;
					ValaList* _tmp33_;
					gint _tmp34_;
					gpointer _tmp35_;
					ValaStatement* _tmp36_;
					_tmp30_ = _section_stmt_index;
					_section_stmt_index = _tmp30_ + 1;
					_tmp31_ = _section_stmt_index;
					_tmp32_ = _section_stmt_size;
					if (!(_tmp31_ < _tmp32_)) {
						break;
					}
					_tmp33_ = _section_stmt_list;
					_tmp34_ = _section_stmt_index;
					_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
					section_stmt = (ValaStatement*) _tmp35_;
					_tmp36_ = section_stmt;
					vala_code_node_accept ((ValaCodeNode*) _tmp36_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (section_stmt);
				}
				_vala_iterable_unref0 (_section_stmt_list);
			}
			_tmp37_ = section;
			if (vala_switch_section_has_default_label (_tmp37_)) {
				has_default_label = TRUE;
			}
			_tmp38_ = self->priv->current_block;
			if (_tmp38_ != NULL) {
				ValaSwitchSection* _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaSourceReference* _tmp41_;
				ValaSwitchSection* _tmp42_;
				ValaBasicBlock* _tmp43_;
				ValaBasicBlock* _tmp44_;
				_tmp39_ = section;
				_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				vala_report_error (_tmp41_, "missing break statement at end of switch section");
				_tmp42_ = section;
				vala_code_node_set_error ((ValaCodeNode*) _tmp42_, TRUE);
				_tmp43_ = self->priv->current_block;
				_tmp44_ = after_switch_block;
				vala_basic_block_connect (_tmp43_, _tmp44_);
			}
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	_tmp45_ = has_default_label;
	if (!_tmp45_) {
		ValaBasicBlock* _tmp46_;
		ValaBasicBlock* _tmp47_;
		_tmp46_ = condition_block;
		_tmp47_ = after_switch_block;
		vala_basic_block_connect (_tmp46_, _tmp47_);
	}
	_tmp48_ = after_switch_block;
	_tmp49_ = vala_basic_block_get_predecessors (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = _tmp52_ > 0;
	_vala_iterable_unref0 (_tmp50_);
	if (_tmp53_) {
		ValaBasicBlock* _tmp54_;
		ValaBasicBlock* _tmp55_;
		_tmp54_ = after_switch_block;
		_tmp55_ = _vala_basic_block_ref0 (_tmp54_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp55_;
	} else {
		vala_flow_analyzer_mark_unreachable (self);
	}
	_tmp56_ = self->priv->jump_stack;
	_tmp57_ = self->priv->jump_stack;
	_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_list_remove_at (_tmp56_, _tmp59_ - 1);
	_tmp61_ = (ValaFlowAnalyzerJumpTarget*) _tmp60_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp61_);
	_vala_basic_block_unref0 (condition_block);
	_vala_basic_block_unref0 (after_switch_block);
}


static void
vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base, 
                                    ValaLoop* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaList* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaFlowAnalyzerJumpTarget* _tmp3_;
	ValaFlowAnalyzerJumpTarget* _tmp4_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaList* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaFlowAnalyzerJumpTarget* _tmp8_;
	ValaFlowAnalyzerJumpTarget* _tmp9_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaBasicBlock* _tmp12_;
	ValaBasicBlock* _tmp13_;
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBlock* _tmp16_;
	ValaBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp21_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	ValaList* _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gpointer _tmp33_;
	ValaFlowAnalyzerJumpTarget* _tmp34_;
	ValaList* _tmp35_;
	ValaList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gpointer _tmp39_;
	ValaFlowAnalyzerJumpTarget* _tmp40_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	loop_block = _tmp0_;
	_tmp1_ = self->priv->jump_stack;
	_tmp2_ = loop_block;
	_tmp3_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp4_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp4_);
	_tmp5_ = vala_basic_block_new ();
	after_loop_block = _tmp5_;
	_tmp6_ = self->priv->jump_stack;
	_tmp7_ = after_loop_block;
	_tmp8_ = vala_flow_analyzer_jump_target_new_break_target (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp9_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp9_);
	_tmp10_ = self->priv->current_block;
	_tmp11_ = _vala_basic_block_ref0 (_tmp10_);
	last_block = _tmp11_;
	_tmp12_ = last_block;
	_tmp13_ = loop_block;
	vala_basic_block_connect (_tmp12_, _tmp13_);
	_tmp14_ = loop_block;
	_tmp15_ = _vala_basic_block_ref0 (_tmp14_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp15_;
	_tmp16_ = vala_loop_get_body (stmt);
	_tmp17_ = _tmp16_;
	vala_code_node_accept ((ValaCodeNode*) _tmp17_, (ValaCodeVisitor*) self);
	_tmp18_ = self->priv->current_block;
	if (_tmp18_ != NULL) {
		ValaBasicBlock* _tmp19_;
		ValaBasicBlock* _tmp20_;
		_tmp19_ = self->priv->current_block;
		_tmp20_ = loop_block;
		vala_basic_block_connect (_tmp19_, _tmp20_);
	}
	_tmp21_ = after_loop_block;
	_tmp22_ = vala_basic_block_get_predecessors (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_ == 0;
	_vala_iterable_unref0 (_tmp23_);
	if (_tmp26_) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp27_;
		ValaBasicBlock* _tmp28_;
		_tmp27_ = after_loop_block;
		_tmp28_ = _vala_basic_block_ref0 (_tmp27_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp28_;
	}
	_tmp29_ = self->priv->jump_stack;
	_tmp30_ = self->priv->jump_stack;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_list_remove_at (_tmp29_, _tmp32_ - 1);
	_tmp34_ = (ValaFlowAnalyzerJumpTarget*) _tmp33_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp34_);
	_tmp35_ = self->priv->jump_stack;
	_tmp36_ = self->priv->jump_stack;
	_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_list_remove_at (_tmp35_, _tmp38_ - 1);
	_tmp40_ = (ValaFlowAnalyzerJumpTarget*) _tmp39_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp40_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}


static void
vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base, 
                                                 ValaForeachStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaList* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaFlowAnalyzerJumpTarget* _tmp8_;
	ValaFlowAnalyzerJumpTarget* _tmp9_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp10_;
	ValaList* _tmp11_;
	ValaBasicBlock* _tmp12_;
	ValaFlowAnalyzerJumpTarget* _tmp13_;
	ValaFlowAnalyzerJumpTarget* _tmp14_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp21_;
	ValaBlock* _tmp22_;
	ValaBlock* _tmp23_;
	ValaBasicBlock* _tmp24_;
	ValaBasicBlock* _tmp27_;
	ValaBasicBlock* _tmp28_;
	ValaBasicBlock* _tmp29_;
	ValaBasicBlock* _tmp32_;
	ValaBasicBlock* _tmp33_;
	ValaList* _tmp34_;
	ValaList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gpointer _tmp38_;
	ValaFlowAnalyzerJumpTarget* _tmp39_;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gpointer _tmp44_;
	ValaFlowAnalyzerJumpTarget* _tmp45_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_foreach_statement_get_collection (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_foreach_statement_get_collection (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = vala_basic_block_new ();
	loop_block = _tmp5_;
	_tmp6_ = self->priv->jump_stack;
	_tmp7_ = loop_block;
	_tmp8_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp9_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp9_);
	_tmp10_ = vala_basic_block_new ();
	after_loop_block = _tmp10_;
	_tmp11_ = self->priv->jump_stack;
	_tmp12_ = after_loop_block;
	_tmp13_ = vala_flow_analyzer_jump_target_new_break_target (_tmp12_);
	_tmp14_ = _tmp13_;
	vala_collection_add ((ValaCollection*) _tmp11_, _tmp14_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp14_);
	_tmp15_ = self->priv->current_block;
	_tmp16_ = _vala_basic_block_ref0 (_tmp15_);
	last_block = _tmp16_;
	_tmp17_ = last_block;
	_tmp18_ = loop_block;
	vala_basic_block_connect (_tmp17_, _tmp18_);
	_tmp19_ = loop_block;
	_tmp20_ = _vala_basic_block_ref0 (_tmp19_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp20_;
	_tmp21_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp21_, (ValaCodeNode*) stmt);
	_tmp22_ = vala_foreach_statement_get_body (stmt);
	_tmp23_ = _tmp22_;
	vala_code_node_accept ((ValaCodeNode*) _tmp23_, (ValaCodeVisitor*) self);
	_tmp24_ = self->priv->current_block;
	if (_tmp24_ != NULL) {
		ValaBasicBlock* _tmp25_;
		ValaBasicBlock* _tmp26_;
		_tmp25_ = self->priv->current_block;
		_tmp26_ = loop_block;
		vala_basic_block_connect (_tmp25_, _tmp26_);
	}
	_tmp27_ = last_block;
	_tmp28_ = after_loop_block;
	vala_basic_block_connect (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->current_block;
	if (_tmp29_ != NULL) {
		ValaBasicBlock* _tmp30_;
		ValaBasicBlock* _tmp31_;
		_tmp30_ = self->priv->current_block;
		_tmp31_ = after_loop_block;
		vala_basic_block_connect (_tmp30_, _tmp31_);
	}
	_tmp32_ = after_loop_block;
	_tmp33_ = _vala_basic_block_ref0 (_tmp32_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp33_;
	_tmp34_ = self->priv->jump_stack;
	_tmp35_ = self->priv->jump_stack;
	_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_list_remove_at (_tmp34_, _tmp37_ - 1);
	_tmp39_ = (ValaFlowAnalyzerJumpTarget*) _tmp38_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp39_);
	_tmp40_ = self->priv->jump_stack;
	_tmp41_ = self->priv->jump_stack;
	_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_list_remove_at (_tmp40_, _tmp43_ - 1);
	_tmp45_ = (ValaFlowAnalyzerJumpTarget*) _tmp44_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp45_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}


static void
vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base, 
                                               ValaBreakStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp28_;
	ValaSourceReference* _tmp29_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_;
				ValaFlowAnalyzerJumpTarget* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = self->priv->jump_stack;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp9_;
				_tmp10_ = jump_target;
				_tmp11_ = vala_flow_analyzer_jump_target_get_is_break_target (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					ValaBasicBlock* _tmp13_;
					ValaFlowAnalyzerJumpTarget* _tmp14_;
					ValaBasicBlock* _tmp15_;
					ValaBasicBlock* _tmp16_;
					_tmp13_ = self->priv->current_block;
					_tmp14_ = jump_target;
					_tmp15_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp14_);
					_tmp16_ = _tmp15_;
					vala_basic_block_connect (_tmp13_, _tmp16_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp17_ = jump_target;
					_tmp18_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						ValaBasicBlock* _tmp20_;
						ValaFlowAnalyzerJumpTarget* _tmp21_;
						ValaBasicBlock* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaFlowAnalyzerJumpTarget* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						_tmp20_ = self->priv->current_block;
						_tmp21_ = jump_target;
						_tmp22_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp21_);
						_tmp23_ = _tmp22_;
						vala_basic_block_connect (_tmp20_, _tmp23_);
						_tmp24_ = jump_target;
						_tmp25_ = vala_flow_analyzer_jump_target_get_last_block (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = _vala_basic_block_ref0 (_tmp26_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp27_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp29_ = _tmp28_;
	vala_report_error (_tmp29_, "no enclosing loop or switch statement found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base, 
                                                  ValaContinueStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp28_;
	ValaSourceReference* _tmp29_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_;
				ValaFlowAnalyzerJumpTarget* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = self->priv->jump_stack;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp9_;
				_tmp10_ = jump_target;
				_tmp11_ = vala_flow_analyzer_jump_target_get_is_continue_target (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					ValaBasicBlock* _tmp13_;
					ValaFlowAnalyzerJumpTarget* _tmp14_;
					ValaBasicBlock* _tmp15_;
					ValaBasicBlock* _tmp16_;
					_tmp13_ = self->priv->current_block;
					_tmp14_ = jump_target;
					_tmp15_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp14_);
					_tmp16_ = _tmp15_;
					vala_basic_block_connect (_tmp13_, _tmp16_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp17_ = jump_target;
					_tmp18_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						ValaBasicBlock* _tmp20_;
						ValaFlowAnalyzerJumpTarget* _tmp21_;
						ValaBasicBlock* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaFlowAnalyzerJumpTarget* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						_tmp20_ = self->priv->current_block;
						_tmp21_ = jump_target;
						_tmp22_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp21_);
						_tmp23_ = _tmp22_;
						vala_basic_block_connect (_tmp20_, _tmp23_);
						_tmp24_ = jump_target;
						_tmp25_ = vala_flow_analyzer_jump_target_get_last_block (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = _vala_basic_block_ref0 (_tmp26_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp27_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp29_ = _tmp28_;
	vala_report_error (_tmp29_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base, 
                                                ValaReturnStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	_tmp1_ = vala_return_statement_get_return_expression (stmt);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_return_statement_get_return_expression (stmt);
		_tmp4_ = _tmp3_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	}
	{
		gint i = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->jump_stack;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		i = _tmp7_ - 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaFlowAnalyzerJumpTarget* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ - 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				if (!(_tmp10_ >= 0)) {
					break;
				}
				_tmp11_ = self->priv->jump_stack;
				_tmp12_ = i;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp13_;
				_tmp14_ = jump_target;
				_tmp15_ = vala_flow_analyzer_jump_target_get_is_return_target (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					ValaBasicBlock* _tmp17_;
					ValaFlowAnalyzerJumpTarget* _tmp18_;
					ValaBasicBlock* _tmp19_;
					ValaBasicBlock* _tmp20_;
					_tmp17_ = self->priv->current_block;
					_tmp18_ = jump_target;
					_tmp19_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp18_);
					_tmp20_ = _tmp19_;
					vala_basic_block_connect (_tmp17_, _tmp20_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp21_;
					gboolean _tmp22_;
					gboolean _tmp23_;
					_tmp21_ = jump_target;
					_tmp22_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_) {
						ValaBasicBlock* _tmp24_;
						ValaFlowAnalyzerJumpTarget* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						ValaFlowAnalyzerJumpTarget* _tmp28_;
						ValaBasicBlock* _tmp29_;
						ValaBasicBlock* _tmp30_;
						ValaBasicBlock* _tmp31_;
						_tmp24_ = self->priv->current_block;
						_tmp25_ = jump_target;
						_tmp26_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp25_);
						_tmp27_ = _tmp26_;
						vala_basic_block_connect (_tmp24_, _tmp27_);
						_tmp28_ = jump_target;
						_tmp29_ = vala_flow_analyzer_jump_target_get_last_block (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = _vala_basic_block_ref0 (_tmp30_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp31_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp33_ = _tmp32_;
	vala_report_error (_tmp33_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self, 
                                  ValaCodeNode* node, 
                                  gboolean always_fail)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_code_node_get_tree_can_fail (node);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaBasicBlock* last_block = NULL;
		ValaBasicBlock* _tmp2_;
		ValaBasicBlock* _tmp3_;
		_tmp2_ = self->priv->current_block;
		_tmp3_ = _vala_basic_block_ref0 (_tmp2_);
		last_block = _tmp3_;
		{
			ValaList* _error_data_type_list = NULL;
			ValaList* _tmp4_;
			gint _error_data_type_size = 0;
			ValaList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _error_data_type_index = 0;
			_tmp4_ = vala_code_node_get_error_types (node);
			_error_data_type_list = _tmp4_;
			_tmp5_ = _error_data_type_list;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_error_data_type_size = _tmp7_;
			_error_data_type_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				ValaDataType* error_data_type = NULL;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaErrorType* error_type = NULL;
				ValaDataType* _tmp14_;
				ValaErrorType* _tmp15_;
				ValaBasicBlock* _tmp16_;
				ValaBasicBlock* _tmp17_;
				_tmp8_ = _error_data_type_index;
				_error_data_type_index = _tmp8_ + 1;
				_tmp9_ = _error_data_type_index;
				_tmp10_ = _error_data_type_size;
				if (!(_tmp9_ < _tmp10_)) {
					break;
				}
				_tmp11_ = _error_data_type_list;
				_tmp12_ = _error_data_type_index;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				error_data_type = (ValaDataType*) _tmp13_;
				_tmp14_ = error_data_type;
				_tmp15_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_ERROR_TYPE) ? ((ValaErrorType*) _tmp14_) : NULL);
				error_type = _tmp15_;
				_tmp16_ = last_block;
				_tmp17_ = _vala_basic_block_ref0 (_tmp16_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp17_;
				self->priv->unreachable_reported = TRUE;
				{
					gint i = 0;
					ValaList* _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp18_ = self->priv->jump_stack;
					_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
					_tmp20_ = _tmp19_;
					i = _tmp20_ - 1;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							gint _tmp23_;
							ValaFlowAnalyzerJumpTarget* jump_target = NULL;
							ValaList* _tmp24_;
							gint _tmp25_;
							gpointer _tmp26_;
							ValaFlowAnalyzerJumpTarget* _tmp27_;
							gboolean _tmp28_;
							gboolean _tmp29_;
							if (!_tmp21_) {
								gint _tmp22_;
								_tmp22_ = i;
								i = _tmp22_ - 1;
							}
							_tmp21_ = FALSE;
							_tmp23_ = i;
							if (!(_tmp23_ >= 0)) {
								break;
							}
							_tmp24_ = self->priv->jump_stack;
							_tmp25_ = i;
							_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
							jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp26_;
							_tmp27_ = jump_target;
							_tmp28_ = vala_flow_analyzer_jump_target_get_is_exit_target (_tmp27_);
							_tmp29_ = _tmp28_;
							if (_tmp29_) {
								ValaBasicBlock* _tmp30_;
								ValaFlowAnalyzerJumpTarget* _tmp31_;
								ValaBasicBlock* _tmp32_;
								ValaBasicBlock* _tmp33_;
								_tmp30_ = self->priv->current_block;
								_tmp31_ = jump_target;
								_tmp32_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp31_);
								_tmp33_ = _tmp32_;
								vala_basic_block_connect (_tmp30_, _tmp33_);
								vala_flow_analyzer_mark_unreachable (self);
								_vala_flow_analyzer_jump_target_unref0 (jump_target);
								break;
							} else {
								ValaFlowAnalyzerJumpTarget* _tmp34_;
								gboolean _tmp35_;
								gboolean _tmp36_;
								_tmp34_ = jump_target;
								_tmp35_ = vala_flow_analyzer_jump_target_get_is_error_target (_tmp34_);
								_tmp36_ = _tmp35_;
								if (_tmp36_) {
									gboolean _tmp37_ = FALSE;
									ValaFlowAnalyzerJumpTarget* _tmp38_;
									ValaErrorDomain* _tmp39_;
									ValaErrorDomain* _tmp40_;
									_tmp38_ = jump_target;
									_tmp39_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp38_);
									_tmp40_ = _tmp39_;
									if (_tmp40_ == NULL) {
										_tmp37_ = TRUE;
									} else {
										gboolean _tmp41_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp42_;
										ValaErrorDomain* _tmp43_;
										ValaErrorDomain* _tmp44_;
										ValaErrorType* _tmp45_;
										ValaErrorDomain* _tmp46_;
										ValaErrorDomain* _tmp47_;
										_tmp42_ = jump_target;
										_tmp43_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp42_);
										_tmp44_ = _tmp43_;
										_tmp45_ = error_type;
										_tmp46_ = vala_error_type_get_error_domain (_tmp45_);
										_tmp47_ = _tmp46_;
										if (_tmp44_ == _tmp47_) {
											gboolean _tmp48_ = FALSE;
											ValaFlowAnalyzerJumpTarget* _tmp49_;
											ValaErrorCode* _tmp50_;
											ValaErrorCode* _tmp51_;
											_tmp49_ = jump_target;
											_tmp50_ = vala_flow_analyzer_jump_target_get_error_code (_tmp49_);
											_tmp51_ = _tmp50_;
											if (_tmp51_ == NULL) {
												_tmp48_ = TRUE;
											} else {
												ValaFlowAnalyzerJumpTarget* _tmp52_;
												ValaErrorCode* _tmp53_;
												ValaErrorCode* _tmp54_;
												ValaErrorType* _tmp55_;
												ValaErrorCode* _tmp56_;
												ValaErrorCode* _tmp57_;
												_tmp52_ = jump_target;
												_tmp53_ = vala_flow_analyzer_jump_target_get_error_code (_tmp52_);
												_tmp54_ = _tmp53_;
												_tmp55_ = error_type;
												_tmp56_ = vala_error_type_get_error_code (_tmp55_);
												_tmp57_ = _tmp56_;
												_tmp48_ = _tmp54_ == _tmp57_;
											}
											_tmp41_ = _tmp48_;
										} else {
											_tmp41_ = FALSE;
										}
										_tmp37_ = _tmp41_;
									}
									if (_tmp37_) {
										ValaBasicBlock* _tmp58_;
										ValaFlowAnalyzerJumpTarget* _tmp59_;
										ValaBasicBlock* _tmp60_;
										ValaBasicBlock* _tmp61_;
										_tmp58_ = self->priv->current_block;
										_tmp59_ = jump_target;
										_tmp60_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp59_);
										_tmp61_ = _tmp60_;
										vala_basic_block_connect (_tmp58_, _tmp61_);
										vala_flow_analyzer_mark_unreachable (self);
										_vala_flow_analyzer_jump_target_unref0 (jump_target);
										break;
									} else {
										gboolean _tmp62_ = FALSE;
										ValaErrorType* _tmp63_;
										ValaErrorDomain* _tmp64_;
										ValaErrorDomain* _tmp65_;
										_tmp63_ = error_type;
										_tmp64_ = vala_error_type_get_error_domain (_tmp63_);
										_tmp65_ = _tmp64_;
										if (_tmp65_ == NULL) {
											_tmp62_ = TRUE;
										} else {
											gboolean _tmp66_ = FALSE;
											ValaErrorType* _tmp67_;
											ValaErrorDomain* _tmp68_;
											ValaErrorDomain* _tmp69_;
											ValaFlowAnalyzerJumpTarget* _tmp70_;
											ValaErrorDomain* _tmp71_;
											ValaErrorDomain* _tmp72_;
											_tmp67_ = error_type;
											_tmp68_ = vala_error_type_get_error_domain (_tmp67_);
											_tmp69_ = _tmp68_;
											_tmp70_ = jump_target;
											_tmp71_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp70_);
											_tmp72_ = _tmp71_;
											if (_tmp69_ == _tmp72_) {
												gboolean _tmp73_ = FALSE;
												ValaErrorType* _tmp74_;
												ValaErrorCode* _tmp75_;
												ValaErrorCode* _tmp76_;
												_tmp74_ = error_type;
												_tmp75_ = vala_error_type_get_error_code (_tmp74_);
												_tmp76_ = _tmp75_;
												if (_tmp76_ == NULL) {
													_tmp73_ = TRUE;
												} else {
													ValaErrorType* _tmp77_;
													ValaErrorCode* _tmp78_;
													ValaErrorCode* _tmp79_;
													ValaFlowAnalyzerJumpTarget* _tmp80_;
													ValaErrorCode* _tmp81_;
													ValaErrorCode* _tmp82_;
													_tmp77_ = error_type;
													_tmp78_ = vala_error_type_get_error_code (_tmp77_);
													_tmp79_ = _tmp78_;
													_tmp80_ = jump_target;
													_tmp81_ = vala_flow_analyzer_jump_target_get_error_code (_tmp80_);
													_tmp82_ = _tmp81_;
													_tmp73_ = _tmp79_ == _tmp82_;
												}
												_tmp66_ = _tmp73_;
											} else {
												_tmp66_ = FALSE;
											}
											_tmp62_ = _tmp66_;
										}
										if (_tmp62_) {
											ValaBasicBlock* _tmp83_;
											ValaFlowAnalyzerJumpTarget* _tmp84_;
											ValaBasicBlock* _tmp85_;
											ValaBasicBlock* _tmp86_;
											_tmp83_ = self->priv->current_block;
											_tmp84_ = jump_target;
											_tmp85_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp84_);
											_tmp86_ = _tmp85_;
											vala_basic_block_connect (_tmp83_, _tmp86_);
										}
									}
								} else {
									ValaFlowAnalyzerJumpTarget* _tmp87_;
									gboolean _tmp88_;
									gboolean _tmp89_;
									_tmp87_ = jump_target;
									_tmp88_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp87_);
									_tmp89_ = _tmp88_;
									if (_tmp89_) {
										ValaBasicBlock* _tmp90_;
										ValaFlowAnalyzerJumpTarget* _tmp91_;
										ValaBasicBlock* _tmp92_;
										ValaBasicBlock* _tmp93_;
										ValaFlowAnalyzerJumpTarget* _tmp94_;
										ValaBasicBlock* _tmp95_;
										ValaBasicBlock* _tmp96_;
										ValaBasicBlock* _tmp97_;
										_tmp90_ = self->priv->current_block;
										_tmp91_ = jump_target;
										_tmp92_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp91_);
										_tmp93_ = _tmp92_;
										vala_basic_block_connect (_tmp90_, _tmp93_);
										_tmp94_ = jump_target;
										_tmp95_ = vala_flow_analyzer_jump_target_get_last_block (_tmp94_);
										_tmp96_ = _tmp95_;
										_tmp97_ = _vala_basic_block_ref0 (_tmp96_);
										_vala_basic_block_unref0 (self->priv->current_block);
										self->priv->current_block = _tmp97_;
									}
								}
							}
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
						}
					}
				}
				_vala_code_node_unref0 (error_type);
				_vala_code_node_unref0 (error_data_type);
			}
			_vala_iterable_unref0 (_error_data_type_list);
		}
		if (!always_fail) {
			ValaBasicBlock* _tmp98_;
			ValaBasicBlock* _tmp99_;
			ValaBasicBlock* _tmp100_;
			_tmp98_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp98_;
			_tmp99_ = last_block;
			_tmp100_ = self->priv->current_block;
			vala_basic_block_connect (_tmp99_, _tmp100_);
		}
		_vala_basic_block_unref0 (last_block);
	}
}


static void
vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base, 
                                               ValaYieldStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base, 
                                               ValaThrowStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base, 
                                             ValaTryStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* before_try_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	ValaBasicBlock* after_try_block = NULL;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* finally_block = NULL;
	ValaBlock* _tmp3_;
	ValaBlock* _tmp4_;
	gint finally_jump_stack_size = 0;
	ValaList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	ValaList* catch_clauses = NULL;
	ValaList* _tmp37_;
	ValaBasicBlock* _tmp74_;
	ValaBasicBlock* _tmp75_;
	ValaBlock* _tmp76_;
	ValaBlock* _tmp77_;
	ValaBasicBlock* _tmp78_;
	ValaList* catch_stack = NULL;
	GEqualFunc _tmp86_;
	ValaArrayList* _tmp87_;
	ValaBasicBlock* _tmp173_;
	ValaBasicBlock* _tmp180_;
	ValaList* _tmp181_;
	ValaList* _tmp182_;
	gint _tmp183_;
	gint _tmp184_;
	gboolean _tmp185_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	before_try_block = _tmp1_;
	_tmp2_ = vala_basic_block_new ();
	after_try_block = _tmp2_;
	finally_block = NULL;
	_tmp3_ = vala_try_statement_get_finally_body (stmt);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaBasicBlock* _tmp5_;
		ValaBasicBlock* _tmp6_;
		ValaBasicBlock* _tmp7_;
		ValaBasicBlock* invalid_block = NULL;
		ValaBasicBlock* _tmp8_;
		ValaList* _tmp9_;
		ValaBasicBlock* _tmp10_;
		ValaFlowAnalyzerJumpTarget* _tmp11_;
		ValaFlowAnalyzerJumpTarget* _tmp12_;
		ValaBlock* _tmp13_;
		ValaBlock* _tmp14_;
		ValaBasicBlock* _tmp15_;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gboolean _tmp20_;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gpointer _tmp27_;
		ValaFlowAnalyzerJumpTarget* _tmp28_;
		ValaList* _tmp29_;
		ValaBasicBlock* _tmp30_;
		ValaBasicBlock* _tmp31_;
		ValaFlowAnalyzerJumpTarget* _tmp32_;
		ValaFlowAnalyzerJumpTarget* _tmp33_;
		_tmp5_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (finally_block);
		finally_block = _tmp5_;
		_tmp6_ = finally_block;
		_tmp7_ = _vala_basic_block_ref0 (_tmp6_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp7_;
		_tmp8_ = vala_basic_block_new ();
		invalid_block = _tmp8_;
		_tmp9_ = self->priv->jump_stack;
		_tmp10_ = invalid_block;
		_tmp11_ = vala_flow_analyzer_jump_target_new_any_target (_tmp10_);
		_tmp12_ = _tmp11_;
		vala_collection_add ((ValaCollection*) _tmp9_, _tmp12_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp12_);
		_tmp13_ = vala_try_statement_get_finally_body (stmt);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, (ValaCodeVisitor*) self);
		_tmp15_ = invalid_block;
		_tmp16_ = vala_basic_block_get_predecessors (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_ > 0;
		_vala_iterable_unref0 (_tmp17_);
		if (_tmp20_) {
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
			_tmp22_ = _tmp21_;
			vala_report_error (_tmp22_, "jump out of finally block not permitted");
			vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
			_vala_basic_block_unref0 (invalid_block);
			_vala_basic_block_unref0 (finally_block);
			_vala_basic_block_unref0 (after_try_block);
			_vala_basic_block_unref0 (before_try_block);
			return;
		}
		_tmp23_ = self->priv->jump_stack;
		_tmp24_ = self->priv->jump_stack;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_list_remove_at (_tmp23_, _tmp26_ - 1);
		_tmp28_ = (ValaFlowAnalyzerJumpTarget*) _tmp27_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp28_);
		_tmp29_ = self->priv->jump_stack;
		_tmp30_ = finally_block;
		_tmp31_ = self->priv->current_block;
		_tmp32_ = vala_flow_analyzer_jump_target_new_finally_clause (_tmp30_, _tmp31_);
		_tmp33_ = _tmp32_;
		vala_collection_add ((ValaCollection*) _tmp29_, _tmp33_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp33_);
		_vala_basic_block_unref0 (invalid_block);
	}
	_tmp34_ = self->priv->jump_stack;
	_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	finally_jump_stack_size = _tmp36_;
	_tmp37_ = vala_try_statement_get_catch_clauses (stmt);
	catch_clauses = _tmp37_;
	{
		gint i = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		_tmp38_ = catch_clauses;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		i = _tmp40_ - 1;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				gint _tmp43_;
				ValaCatchClause* catch_clause = NULL;
				ValaList* _tmp44_;
				gint _tmp45_;
				gpointer _tmp46_;
				ValaCatchClause* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				if (!_tmp41_) {
					gint _tmp42_;
					_tmp42_ = i;
					i = _tmp42_ - 1;
				}
				_tmp41_ = FALSE;
				_tmp43_ = i;
				if (!(_tmp43_ >= 0)) {
					break;
				}
				_tmp44_ = catch_clauses;
				_tmp45_ = i;
				_tmp46_ = vala_list_get (_tmp44_, _tmp45_);
				catch_clause = (ValaCatchClause*) _tmp46_;
				_tmp47_ = catch_clause;
				_tmp48_ = vala_catch_clause_get_error_type (_tmp47_);
				_tmp49_ = _tmp48_;
				if (_tmp49_ != NULL) {
					ValaErrorType* error_type = NULL;
					ValaCatchClause* _tmp50_;
					ValaDataType* _tmp51_;
					ValaDataType* _tmp52_;
					ValaErrorType* _tmp53_;
					ValaList* _tmp54_;
					ValaBasicBlock* _tmp55_;
					ValaBasicBlock* _tmp56_;
					ValaCatchClause* _tmp57_;
					ValaCatchClause* _tmp58_;
					ValaDataType* _tmp59_;
					ValaDataType* _tmp60_;
					ValaTypeSymbol* _tmp61_;
					ValaTypeSymbol* _tmp62_;
					ValaErrorType* _tmp63_;
					ValaErrorCode* _tmp64_;
					ValaErrorCode* _tmp65_;
					ValaFlowAnalyzerJumpTarget* _tmp66_;
					ValaFlowAnalyzerJumpTarget* _tmp67_;
					_tmp50_ = catch_clause;
					_tmp51_ = vala_catch_clause_get_error_type (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					error_type = _tmp53_;
					_tmp54_ = self->priv->jump_stack;
					_tmp55_ = vala_basic_block_new ();
					_tmp56_ = _tmp55_;
					_tmp57_ = catch_clause;
					_tmp58_ = catch_clause;
					_tmp59_ = vala_catch_clause_get_error_type (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = vala_data_type_get_data_type (_tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = error_type;
					_tmp64_ = vala_error_type_get_error_code (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = vala_flow_analyzer_jump_target_new_error_target (_tmp56_, _tmp57_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_ERROR_DOMAIN) ? ((ValaErrorDomain*) _tmp62_) : NULL, _tmp65_, NULL);
					_tmp67_ = _tmp66_;
					vala_collection_add ((ValaCollection*) _tmp54_, _tmp67_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp67_);
					_vala_basic_block_unref0 (_tmp56_);
					_vala_code_node_unref0 (error_type);
				} else {
					ValaList* _tmp68_;
					ValaBasicBlock* _tmp69_;
					ValaBasicBlock* _tmp70_;
					ValaCatchClause* _tmp71_;
					ValaFlowAnalyzerJumpTarget* _tmp72_;
					ValaFlowAnalyzerJumpTarget* _tmp73_;
					_tmp68_ = self->priv->jump_stack;
					_tmp69_ = vala_basic_block_new ();
					_tmp70_ = _tmp69_;
					_tmp71_ = catch_clause;
					_tmp72_ = vala_flow_analyzer_jump_target_new_error_target (_tmp70_, _tmp71_, NULL, NULL, NULL);
					_tmp73_ = _tmp72_;
					vala_collection_add ((ValaCollection*) _tmp68_, _tmp73_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp73_);
					_vala_basic_block_unref0 (_tmp70_);
				}
				_vala_code_node_unref0 (catch_clause);
			}
		}
	}
	_tmp74_ = before_try_block;
	_tmp75_ = _vala_basic_block_ref0 (_tmp74_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp75_;
	_tmp76_ = vala_try_statement_get_body (stmt);
	_tmp77_ = _tmp76_;
	vala_code_node_accept ((ValaCodeNode*) _tmp77_, (ValaCodeVisitor*) self);
	_tmp78_ = self->priv->current_block;
	if (_tmp78_ != NULL) {
		ValaBasicBlock* _tmp79_;
		ValaBasicBlock* _tmp84_;
		ValaBasicBlock* _tmp85_;
		_tmp79_ = finally_block;
		if (_tmp79_ != NULL) {
			ValaBasicBlock* _tmp80_;
			ValaBasicBlock* _tmp81_;
			ValaBasicBlock* _tmp82_;
			ValaBasicBlock* _tmp83_;
			_tmp80_ = self->priv->current_block;
			_tmp81_ = finally_block;
			vala_basic_block_connect (_tmp80_, _tmp81_);
			_tmp82_ = finally_block;
			_tmp83_ = _vala_basic_block_ref0 (_tmp82_);
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp83_;
		}
		_tmp84_ = self->priv->current_block;
		_tmp85_ = after_try_block;
		vala_basic_block_connect (_tmp84_, _tmp85_);
	}
	_tmp86_ = g_direct_equal;
	_tmp87_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp86_);
	catch_stack = (ValaList*) _tmp87_;
	{
		gint i = 0;
		ValaList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		_tmp88_ = self->priv->jump_stack;
		_tmp89_ = vala_collection_get_size ((ValaCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		i = _tmp90_ - 1;
		{
			gboolean _tmp91_ = FALSE;
			_tmp91_ = TRUE;
			while (TRUE) {
				gint _tmp93_;
				gint _tmp94_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp95_;
				gint _tmp96_;
				gpointer _tmp97_;
				ValaList* _tmp98_;
				ValaFlowAnalyzerJumpTarget* _tmp99_;
				if (!_tmp91_) {
					gint _tmp92_;
					_tmp92_ = i;
					i = _tmp92_ - 1;
				}
				_tmp91_ = FALSE;
				_tmp93_ = i;
				_tmp94_ = finally_jump_stack_size;
				if (!(_tmp93_ >= _tmp94_)) {
					break;
				}
				_tmp95_ = self->priv->jump_stack;
				_tmp96_ = i;
				_tmp97_ = vala_list_remove_at (_tmp95_, _tmp96_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp97_;
				_tmp98_ = catch_stack;
				_tmp99_ = jump_target;
				vala_collection_add ((ValaCollection*) _tmp98_, _tmp99_);
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	{
		ValaList* _jump_target_list = NULL;
		ValaList* _tmp100_;
		ValaList* _tmp101_;
		gint _jump_target_size = 0;
		ValaList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _jump_target_index = 0;
		_tmp100_ = catch_stack;
		_tmp101_ = _vala_iterable_ref0 (_tmp100_);
		_jump_target_list = _tmp101_;
		_tmp102_ = _jump_target_list;
		_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_jump_target_size = _tmp104_;
		_jump_target_index = -1;
		while (TRUE) {
			gint _tmp105_;
			gint _tmp106_;
			gint _tmp107_;
			ValaFlowAnalyzerJumpTarget* jump_target = NULL;
			ValaList* _tmp108_;
			gint _tmp109_;
			gpointer _tmp110_;
			ValaFlowAnalyzerJumpTarget* _tmp139_;
			ValaBasicBlock* _tmp140_;
			ValaBasicBlock* _tmp141_;
			ValaList* _tmp142_;
			ValaList* _tmp143_;
			gint _tmp144_;
			gint _tmp145_;
			gboolean _tmp146_;
			_tmp105_ = _jump_target_index;
			_jump_target_index = _tmp105_ + 1;
			_tmp106_ = _jump_target_index;
			_tmp107_ = _jump_target_size;
			if (!(_tmp106_ < _tmp107_)) {
				break;
			}
			_tmp108_ = _jump_target_list;
			_tmp109_ = _jump_target_index;
			_tmp110_ = vala_list_get (_tmp108_, _tmp109_);
			jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp110_;
			{
				ValaList* _prev_target_list = NULL;
				ValaList* _tmp111_;
				ValaList* _tmp112_;
				gint _prev_target_size = 0;
				ValaList* _tmp113_;
				gint _tmp114_;
				gint _tmp115_;
				gint _prev_target_index = 0;
				_tmp111_ = catch_stack;
				_tmp112_ = _vala_iterable_ref0 (_tmp111_);
				_prev_target_list = _tmp112_;
				_tmp113_ = _prev_target_list;
				_tmp114_ = vala_collection_get_size ((ValaCollection*) _tmp113_);
				_tmp115_ = _tmp114_;
				_prev_target_size = _tmp115_;
				_prev_target_index = -1;
				while (TRUE) {
					gint _tmp116_;
					gint _tmp117_;
					gint _tmp118_;
					ValaFlowAnalyzerJumpTarget* prev_target = NULL;
					ValaList* _tmp119_;
					gint _tmp120_;
					gpointer _tmp121_;
					ValaFlowAnalyzerJumpTarget* _tmp122_;
					ValaFlowAnalyzerJumpTarget* _tmp123_;
					gboolean _tmp124_ = FALSE;
					ValaFlowAnalyzerJumpTarget* _tmp125_;
					ValaErrorDomain* _tmp126_;
					ValaErrorDomain* _tmp127_;
					ValaFlowAnalyzerJumpTarget* _tmp128_;
					ValaErrorDomain* _tmp129_;
					ValaErrorDomain* _tmp130_;
					_tmp116_ = _prev_target_index;
					_prev_target_index = _tmp116_ + 1;
					_tmp117_ = _prev_target_index;
					_tmp118_ = _prev_target_size;
					if (!(_tmp117_ < _tmp118_)) {
						break;
					}
					_tmp119_ = _prev_target_list;
					_tmp120_ = _prev_target_index;
					_tmp121_ = vala_list_get (_tmp119_, _tmp120_);
					prev_target = (ValaFlowAnalyzerJumpTarget*) _tmp121_;
					_tmp122_ = prev_target;
					_tmp123_ = jump_target;
					if (_tmp122_ == _tmp123_) {
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						break;
					}
					_tmp125_ = prev_target;
					_tmp126_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp125_);
					_tmp127_ = _tmp126_;
					_tmp128_ = jump_target;
					_tmp129_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp128_);
					_tmp130_ = _tmp129_;
					if (_tmp127_ == _tmp130_) {
						ValaFlowAnalyzerJumpTarget* _tmp131_;
						ValaErrorCode* _tmp132_;
						ValaErrorCode* _tmp133_;
						ValaFlowAnalyzerJumpTarget* _tmp134_;
						ValaErrorCode* _tmp135_;
						ValaErrorCode* _tmp136_;
						_tmp131_ = prev_target;
						_tmp132_ = vala_flow_analyzer_jump_target_get_error_code (_tmp131_);
						_tmp133_ = _tmp132_;
						_tmp134_ = jump_target;
						_tmp135_ = vala_flow_analyzer_jump_target_get_error_code (_tmp134_);
						_tmp136_ = _tmp135_;
						_tmp124_ = _tmp133_ == _tmp136_;
					} else {
						_tmp124_ = FALSE;
					}
					if (_tmp124_) {
						ValaSourceReference* _tmp137_;
						ValaSourceReference* _tmp138_;
						_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
						_tmp138_ = _tmp137_;
						vala_report_error (_tmp138_, "double catch clause of same error detected");
						vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						_vala_iterable_unref0 (_prev_target_list);
						_vala_flow_analyzer_jump_target_unref0 (jump_target);
						_vala_iterable_unref0 (_jump_target_list);
						_vala_iterable_unref0 (catch_stack);
						_vala_iterable_unref0 (catch_clauses);
						_vala_basic_block_unref0 (finally_block);
						_vala_basic_block_unref0 (after_try_block);
						_vala_basic_block_unref0 (before_try_block);
						return;
					}
					_vala_flow_analyzer_jump_target_unref0 (prev_target);
				}
				_vala_iterable_unref0 (_prev_target_list);
			}
			_tmp139_ = jump_target;
			_tmp140_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_basic_block_get_predecessors (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = _tmp145_ == 0;
			_vala_iterable_unref0 (_tmp143_);
			if (_tmp146_) {
				ValaFlowAnalyzerJumpTarget* _tmp147_;
				ValaCatchClause* _tmp148_;
				ValaCatchClause* _tmp149_;
				ValaSourceReference* _tmp150_;
				ValaSourceReference* _tmp151_;
				_tmp147_ = jump_target;
				_tmp148_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp149_);
				_tmp151_ = _tmp150_;
				vala_report_warning (_tmp151_, "unreachable catch clause detected");
			} else {
				ValaFlowAnalyzerJumpTarget* _tmp152_;
				ValaBasicBlock* _tmp153_;
				ValaBasicBlock* _tmp154_;
				ValaBasicBlock* _tmp155_;
				ValaBasicBlock* _tmp156_;
				ValaFlowAnalyzerJumpTarget* _tmp157_;
				ValaCatchClause* _tmp158_;
				ValaCatchClause* _tmp159_;
				ValaFlowAnalyzerJumpTarget* _tmp160_;
				ValaCatchClause* _tmp161_;
				ValaCatchClause* _tmp162_;
				ValaBlock* _tmp163_;
				ValaBlock* _tmp164_;
				ValaBasicBlock* _tmp165_;
				_tmp152_ = jump_target;
				_tmp153_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = _vala_basic_block_ref0 (_tmp154_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp155_;
				_tmp156_ = self->priv->current_block;
				_tmp157_ = jump_target;
				_tmp158_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp157_);
				_tmp159_ = _tmp158_;
				vala_basic_block_add_node (_tmp156_, (ValaCodeNode*) _tmp159_);
				_tmp160_ = jump_target;
				_tmp161_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp160_);
				_tmp162_ = _tmp161_;
				_tmp163_ = vala_catch_clause_get_body (_tmp162_);
				_tmp164_ = _tmp163_;
				vala_code_node_accept ((ValaCodeNode*) _tmp164_, (ValaCodeVisitor*) self);
				_tmp165_ = self->priv->current_block;
				if (_tmp165_ != NULL) {
					ValaBasicBlock* _tmp166_;
					ValaBasicBlock* _tmp171_;
					ValaBasicBlock* _tmp172_;
					_tmp166_ = finally_block;
					if (_tmp166_ != NULL) {
						ValaBasicBlock* _tmp167_;
						ValaBasicBlock* _tmp168_;
						ValaBasicBlock* _tmp169_;
						ValaBasicBlock* _tmp170_;
						_tmp167_ = self->priv->current_block;
						_tmp168_ = finally_block;
						vala_basic_block_connect (_tmp167_, _tmp168_);
						_tmp169_ = finally_block;
						_tmp170_ = _vala_basic_block_ref0 (_tmp169_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp170_;
					}
					_tmp171_ = self->priv->current_block;
					_tmp172_ = after_try_block;
					vala_basic_block_connect (_tmp171_, _tmp172_);
				}
			}
			_vala_flow_analyzer_jump_target_unref0 (jump_target);
		}
		_vala_iterable_unref0 (_jump_target_list);
	}
	_tmp173_ = finally_block;
	if (_tmp173_ != NULL) {
		ValaList* _tmp174_;
		ValaList* _tmp175_;
		gint _tmp176_;
		gint _tmp177_;
		gpointer _tmp178_;
		ValaFlowAnalyzerJumpTarget* _tmp179_;
		_tmp174_ = self->priv->jump_stack;
		_tmp175_ = self->priv->jump_stack;
		_tmp176_ = vala_collection_get_size ((ValaCollection*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_list_remove_at (_tmp174_, _tmp177_ - 1);
		_tmp179_ = (ValaFlowAnalyzerJumpTarget*) _tmp178_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp179_);
	}
	_tmp180_ = after_try_block;
	_tmp181_ = vala_basic_block_get_predecessors (_tmp180_);
	_tmp182_ = _tmp181_;
	_tmp183_ = vala_collection_get_size ((ValaCollection*) _tmp182_);
	_tmp184_ = _tmp183_;
	_tmp185_ = _tmp184_ > 0;
	_vala_iterable_unref0 (_tmp182_);
	if (_tmp185_) {
		ValaBasicBlock* _tmp186_;
		ValaBasicBlock* _tmp187_;
		_tmp186_ = after_try_block;
		_tmp187_ = _vala_basic_block_ref0 (_tmp186_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp187_;
	} else {
		vala_try_statement_set_after_try_block_reachable (stmt, FALSE);
		vala_flow_analyzer_mark_unreachable (self);
	}
	_vala_iterable_unref0 (catch_stack);
	_vala_iterable_unref0 (catch_clauses);
	_vala_basic_block_unref0 (finally_block);
	_vala_basic_block_unref0 (after_try_block);
	_vala_basic_block_unref0 (before_try_block);
}


static void
vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base, 
                                              ValaLockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}


static void
vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base, 
                                                ValaUnlockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}


static void
vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base, 
                                          ValaExpression* expr)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (expr != NULL);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (expr, VALA_TYPE_LAMBDA_EXPRESSION)) {
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
	}
}


static gboolean
vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self, 
                                ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = self->priv->current_block;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		vala_code_node_set_unreachable (node, TRUE);
		_tmp1_ = self->priv->unreachable_reported;
		if (!_tmp1_) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference (node);
			_tmp3_ = _tmp2_;
			vala_report_warning (_tmp3_, "unreachable code detected");
			self->priv->unreachable_reported = TRUE;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void
vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self)
{
	g_return_if_fail (self != NULL);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = NULL;
	self->priv->unreachable_reported = FALSE;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_break_target (GType object_type, 
                                                       ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_break_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_continue_target (GType object_type, 
                                                          ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_continue_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_return_target (GType object_type, 
                                                        ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_return_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_exit_target (GType object_type, 
                                                      ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_exit_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_error_target (GType object_type, 
                                                       ValaBasicBlock* basic_block, 
                                                       ValaCatchClause* catch_clause, 
                                                       ValaErrorDomain* error_domain, 
                                                       ValaErrorCode* error_code, 
                                                       ValaClass* error_class)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (catch_clause != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_catch_clause (self, catch_clause);
	vala_flow_analyzer_jump_target_set_error_domain (self, error_domain);
	vala_flow_analyzer_jump_target_set_error_code (self, error_code);
	vala_flow_analyzer_jump_target_set_error_class (self, error_class);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block, 
                                                 ValaCatchClause* catch_clause, 
                                                 ValaErrorDomain* error_domain, 
                                                 ValaErrorCode* error_code, 
                                                 ValaClass* error_class)
{
	return vala_flow_analyzer_jump_target_construct_error_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, catch_clause, error_domain, error_code, error_class);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_any_target (GType object_type, 
                                                     ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_any_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type, 
                                                         ValaBasicBlock* basic_block, 
                                                         ValaBasicBlock* last_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (last_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_last_block (self, last_block);
	vala_flow_analyzer_jump_target_set_is_finally_clause (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block, 
                                                   ValaBasicBlock* last_block)
{
	return vala_flow_analyzer_jump_target_construct_finally_clause (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, last_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct (GType object_type)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new (void)
{
	return vala_flow_analyzer_jump_target_construct (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET);
}


static gboolean
vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_break_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self, 
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_break_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_continue_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self, 
                                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_continue_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_return_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self, 
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_return_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_exit_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self, 
                                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_exit_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_error_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self, 
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_error_target = value;
}


static ValaErrorDomain*
vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorDomain* result;
	ValaErrorDomain* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_domain;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self, 
                                                 ValaErrorDomain* value)
{
	ValaErrorDomain* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_domain);
	self->priv->_error_domain = _tmp0_;
}


static ValaErrorCode*
vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorCode* result;
	ValaErrorCode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_code;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self, 
                                               ValaErrorCode* value)
{
	ValaErrorCode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_code);
	self->priv->_error_code = _tmp0_;
}


static ValaClass*
vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_class;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self, 
                                                ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_class);
	self->priv->_error_class = _tmp0_;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_finally_clause;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self, 
                                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_finally_clause = value;
}


static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basic_block;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self, 
                                                ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	self->priv->_basic_block = _tmp0_;
}


static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_block;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self, 
                                               ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_last_block);
	self->priv->_last_block = _tmp0_;
}


static ValaCatchClause*
vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self)
{
	ValaCatchClause* result;
	ValaCatchClause* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_catch_clause;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self, 
                                                 ValaCatchClause* value)
{
	ValaCatchClause* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_catch_clause);
	self->priv->_catch_clause = _tmp0_;
}


static void
vala_flow_analyzer_value_jump_target_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_flow_analyzer_value_jump_target_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_flow_analyzer_jump_target_unref (value->data[0].v_pointer);
	}
}


static void
vala_flow_analyzer_value_jump_target_copy_value (const GValue* src_value, 
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_flow_analyzer_value_jump_target_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_flow_analyzer_value_jump_target_collect_value (GValue* value, 
                                                    guint n_collect_values, 
                                                    GTypeCValue* collect_values, 
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaFlowAnalyzerJumpTarget * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_flow_analyzer_value_jump_target_lcopy_value (const GValue* value, 
                                                  guint n_collect_values, 
                                                  GTypeCValue* collect_values, 
                                                  guint collect_flags)
{
	ValaFlowAnalyzerJumpTarget ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_flow_analyzer_param_spec_jump_target (const gchar* name, 
                                           const gchar* nick, 
                                           const gchar* blurb, 
                                           GType object_type, 
                                           GParamFlags flags)
{
	ValaFlowAnalyzerParamSpecJumpTarget* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_flow_analyzer_value_get_jump_target (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	return value->data[0].v_pointer;
}


static void
vala_flow_analyzer_value_set_jump_target (GValue* value, 
                                          gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}


static void
vala_flow_analyzer_value_take_jump_target (GValue* value, 
                                           gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}


static void
vala_flow_analyzer_jump_target_class_init (ValaFlowAnalyzerJumpTargetClass * klass)
{
	vala_flow_analyzer_jump_target_parent_class = g_type_class_peek_parent (klass);
	((ValaFlowAnalyzerJumpTargetClass *) klass)->finalize = vala_flow_analyzer_jump_target_finalize;
	g_type_class_add_private (klass, sizeof (ValaFlowAnalyzerJumpTargetPrivate));
}


static void
vala_flow_analyzer_jump_target_instance_init (ValaFlowAnalyzerJumpTarget * self)
{
	self->priv = VALA_FLOW_ANALYZER_JUMP_TARGET_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->priv->_error_domain);
	_vala_code_node_unref0 (self->priv->_error_code);
	_vala_code_node_unref0 (self->priv->_error_class);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	_vala_basic_block_unref0 (self->priv->_last_block);
	_vala_code_node_unref0 (self->priv->_catch_clause);
}


static GType
vala_flow_analyzer_jump_target_get_type (void)
{
	static volatile gsize vala_flow_analyzer_jump_target_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_jump_target_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_flow_analyzer_value_jump_target_init, vala_flow_analyzer_value_jump_target_free_value, vala_flow_analyzer_value_jump_target_copy_value, vala_flow_analyzer_value_jump_target_peek_pointer, "p", vala_flow_analyzer_value_jump_target_collect_value, "p", vala_flow_analyzer_value_jump_target_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerJumpTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_jump_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzerJumpTarget), 0, (GInstanceInitFunc) vala_flow_analyzer_jump_target_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_flow_analyzer_jump_target_type_id;
		vala_flow_analyzer_jump_target_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaFlowAnalyzerJumpTarget", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_flow_analyzer_jump_target_type_id__volatile, vala_flow_analyzer_jump_target_type_id);
	}
	return vala_flow_analyzer_jump_target_type_id__volatile;
}


static gpointer
vala_flow_analyzer_jump_target_ref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_flow_analyzer_jump_target_unref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
vala_flow_analyzer_class_init (ValaFlowAnalyzerClass * klass)
{
	vala_flow_analyzer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_flow_analyzer_finalize;
	g_type_class_add_private (klass, sizeof (ValaFlowAnalyzerPrivate));
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor *, ValaSourceFile*)) vala_flow_analyzer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor *, ValaClass*)) vala_flow_analyzer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor *, ValaStruct*)) vala_flow_analyzer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor *, ValaInterface*)) vala_flow_analyzer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor *, ValaEnum*)) vala_flow_analyzer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor *, ValaErrorDomain*)) vala_flow_analyzer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor *, ValaField*)) vala_flow_analyzer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor *, ValaLambdaExpression*)) vala_flow_analyzer_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor *, ValaMethod*)) vala_flow_analyzer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor *, ValaSignal*)) vala_flow_analyzer_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor *, ValaCreationMethod*)) vala_flow_analyzer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor *, ValaProperty*)) vala_flow_analyzer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor *, ValaPropertyAccessor*)) vala_flow_analyzer_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor *, ValaBlock*)) vala_flow_analyzer_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor *, ValaDeclarationStatement*)) vala_flow_analyzer_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor *, ValaLocalVariable*)) vala_flow_analyzer_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor *, ValaExpressionStatement*)) vala_flow_analyzer_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor *, ValaIfStatement*)) vala_flow_analyzer_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor *, ValaSwitchStatement*)) vala_flow_analyzer_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_loop = (void (*) (ValaCodeVisitor *, ValaLoop*)) vala_flow_analyzer_real_visit_loop;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor *, ValaForeachStatement*)) vala_flow_analyzer_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_break_statement = (void (*) (ValaCodeVisitor *, ValaBreakStatement*)) vala_flow_analyzer_real_visit_break_statement;
	((ValaCodeVisitorClass *) klass)->visit_continue_statement = (void (*) (ValaCodeVisitor *, ValaContinueStatement*)) vala_flow_analyzer_real_visit_continue_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor *, ValaReturnStatement*)) vala_flow_analyzer_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor *, ValaYieldStatement*)) vala_flow_analyzer_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor *, ValaThrowStatement*)) vala_flow_analyzer_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor *, ValaTryStatement*)) vala_flow_analyzer_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = (void (*) (ValaCodeVisitor *, ValaLockStatement*)) vala_flow_analyzer_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_unlock_statement = (void (*) (ValaCodeVisitor *, ValaUnlockStatement*)) vala_flow_analyzer_real_visit_unlock_statement;
	((ValaCodeVisitorClass *) klass)->visit_expression = (void (*) (ValaCodeVisitor *, ValaExpression*)) vala_flow_analyzer_real_visit_expression;
}


static void
vala_flow_analyzer_instance_init (ValaFlowAnalyzer * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_FLOW_ANALYZER_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp0_);
	self->priv->jump_stack = (ValaList*) _tmp1_;
}


static void
vala_flow_analyzer_finalize (ValaCodeVisitor * obj)
{
	ValaFlowAnalyzer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzer);
	_vala_code_context_unref0 (self->priv->context);
	_vala_basic_block_unref0 (self->priv->current_block);
	_vala_iterable_unref0 (self->priv->jump_stack);
	_vala_map_unref0 (self->priv->var_map);
	_vala_iterable_unref0 (self->priv->used_vars);
	_vala_map_unref0 (self->priv->phi_functions);
	VALA_CODE_VISITOR_CLASS (vala_flow_analyzer_parent_class)->finalize (obj);
}


/**
 * Code visitor building the control flow graph.
 */
GType
vala_flow_analyzer_get_type (void)
{
	static volatile gsize vala_flow_analyzer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzer), 0, (GInstanceInitFunc) vala_flow_analyzer_instance_init, NULL };
		GType vala_flow_analyzer_type_id;
		vala_flow_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaFlowAnalyzer", &g_define_type_info, 0);
		g_once_init_leave (&vala_flow_analyzer_type_id__volatile, vala_flow_analyzer_type_id);
	}
	return vala_flow_analyzer_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array, 
                     gint array_length, 
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array, 
                  gint array_length, 
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



