// Generated by gmmproc 2.55.2 -- DO NOT MODIFY!
#ifndef _GDKMM_TEXTURE_H
#define _GDKMM_TEXTURE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2017 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkTexture = struct _GdkTexture;
using GdkTextureClass = struct _GdkTextureClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class Texture_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gio
{
class File;
}

namespace Gdk
{
class GLContext;
class Pixbuf;

/** Pixel data.
 *
 * %Gdk::Texture is the basic element used to refer to pixel data.
 * It is primarily meant for pixel data that will not change over
 * multiple frames, and will be used for a long time.
 *
 * You cannot get your pixel data back once you've uploaded it.
 *
 * %Gdk::Texture is an immutable object: That means you cannot change
 * anything about it.
 *
 * @newin{3,94}
 */

class Texture : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Texture;
  using CppClassType = Texture_Class;
  using BaseObjectType = GdkTexture;
  using BaseClassType = GdkTextureClass;

  // noncopyable
  Texture(const Texture&) = delete;
  Texture& operator=(const Texture&) = delete;

private:  friend class Texture_Class;
  static CppClassType texture_class_;

protected:
  explicit Texture(const Glib::ConstructParams& construct_params);
  explicit Texture(GdkTexture* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Texture(Texture&& src) noexcept;
  Texture& operator=(Texture&& src) noexcept;

  ~Texture() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkTexture*       gobj()       { return reinterpret_cast<GdkTexture*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkTexture* gobj() const { return reinterpret_cast<GdkTexture*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkTexture* gobj_copy();

private:


protected:
  Texture();

public:
  // All gdk_texture_new_*() functions do more than call g_object_new().
  
  /** Creates a new texture object holding the given data.
   * The data is assumed to be in CAIRO_FORMAT_ARGB32 format.
   * 
   * @param data The pixel data.
   * @param width The number of pixels in each row.
   * @param height The number of rows.
   * @param stride The distance from the beginning of one row to the next, in bytes.
   * @return A new Gdk::Texture.
   */
  static Glib::RefPtr<Texture> create_for_data(const guchar* data, int width, int height, int stride);
  
  /** Creates a new texture object representing the GdkPixbuf.
   * 
   * @param pixbuf A Gdk::Pixbuf.
   * @return A new Gdk::Texture.
   */
  static Glib::RefPtr<Texture> create_for_pixbuf(const Glib::RefPtr<Pixbuf>& pixbuf);
  
  /** Creates a new texture by loading an image from a resource.
   * The file format is detected automatically.
   * 
   * It is a fatal error if @a resource_path does not specify a valid
   * image resource and the program will abort if that happens.
   * If you are unsure about the validity of a resource, use
   * new_from_file() to load it.
   * 
   * @param resource_path The path of the resource file.
   * @return A newly-created texture.
   */
  static Glib::RefPtr<Texture> create_from_resource(const std::string& resource_path);
  
  /** Creates a new texture by loading an image from a file.  The file format is
   * detected automatically. If <tt>nullptr</tt> is returned, then @a error will be set.
   * 
   * @param file File to load.
   * @return A newly-created Gdk::Texture or <tt>nullptr</tt> if an error occured.
   * 
   * @throws Glib::Error
   */
  static Glib::RefPtr<Texture> create_from_file(const Glib::RefPtr<Gio::File>& file);

  /** For instance,
   * void on_gl_resources_released();
   */
  using SlotGLReleased = sigc::slot<void()>;

  
  /** Creates a new texture for an existing GL texture.
   * 
   * Note that the GL texture must not be modified until @a slot is called,
   * which will happen when the GdkTexture object is finalized, or due to
   * an explicit call of release_gl().
   * 
   * @param context A Gdk::GLContext.
   * @param id The ID of a texture that was created with @a context.
   * @param width The nominal width of the texture.
   * @param height The nominal height of the texture.
   * @param slot A destroy notify that will be called when the GL resources
   * are released.
   * @return A newly-created Gdk::Texture.
   */
  static Glib::RefPtr<Texture> create_for_gl(const Glib::RefPtr<GLContext>& context, guint id, int width, int height, const SlotGLReleased& slot =  {});
  
  /** Releases the GL resources held by a Gdk::Texture that
   * was created with new_for_gl().
   * 
   * The texture contents are still available via the
   * download() function, after this function
   * has been called.
   */
  void release_gl();

  
  /** Returns the width of @a texture.
   * 
   * @return The width of the Gdk::Texture.
   */
  int get_width() const;
  
  /** Returns the height of the @a texture.
   * 
   * @return The height of the Gdk::Texture.
   */
  int get_height() const;
  
  /** Downloads the @a texture into local memory. This may be
   * an expensive operation, as the actual texture data may
   * reside on a GPU or on a remote display server.
   * 
   * The data format of the downloaded data is equivalent to
   * Cairo::Surface::Format::ARGB32, so every downloaded pixel requires
   * 4 bytes of memory.
   * 
   * Downloading a texture into a Cairo image surface:
   * 
   * [C example ellipted]
   * 
   * @param data Pointer to enough memory to be filled with the
   * downloaded data of @a texture.
   * @param stride Rowstride in bytes.
   */
  void download(guchar* data, gsize stride) const;

  /** The width of the texture.
   *
   * Default value: 1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width() const;


  /** The height of the texture.
   *
   * Default value: 1
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_height() const;


  // There are no public signals or vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::Texture
   */
  Glib::RefPtr<Gdk::Texture> wrap(GdkTexture* object, bool take_copy = false);
}


#endif /* _GDKMM_TEXTURE_H */

