/* tracker-sparql-scanner.c generated by valac 0.40.6, the Vala compiler
 * generated from tracker-sparql-scanner.vala, do not modify */

/*
 * Copyright (C) 2009, Nokia
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */


#include <glib.h>
#include <glib-object.h>
#include "libtracker-sparql/tracker-sparql.h"
#include <stdlib.h>
#include <string.h>


#define TRACKER_TYPE_SPARQL_SCANNER (tracker_sparql_scanner_get_type ())
#define TRACKER_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner))
#define TRACKER_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))
#define TRACKER_IS_SPARQL_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_IS_SPARQL_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_SPARQL_SCANNER))
#define TRACKER_SPARQL_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerClass))

typedef struct _TrackerSparqlScanner TrackerSparqlScanner;
typedef struct _TrackerSparqlScannerClass TrackerSparqlScannerClass;
typedef struct _TrackerSparqlScannerPrivate TrackerSparqlScannerPrivate;
enum  {
	TRACKER_SPARQL_SCANNER_0_PROPERTY,
	TRACKER_SPARQL_SCANNER_NUM_PROPERTIES
};
static GParamSpec* tracker_sparql_scanner_properties[TRACKER_SPARQL_SCANNER_NUM_PROPERTIES];

#define TRACKER_TYPE_SOURCE_LOCATION (tracker_source_location_get_type ())
typedef struct _TrackerSourceLocation TrackerSourceLocation;

#define TRACKER_TYPE_SPARQL_TOKEN_TYPE (tracker_sparql_token_type_get_type ())

struct _TrackerSparqlScanner {
	GObject parent_instance;
	TrackerSparqlScannerPrivate * priv;
};

struct _TrackerSparqlScannerClass {
	GObjectClass parent_class;
};

struct _TrackerSparqlScannerPrivate {
	gchar* current;
	gchar* end;
	gint line;
	gint column;
};

struct _TrackerSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};

typedef enum  {
	TRACKER_SPARQL_TOKEN_TYPE_NONE,
	TRACKER_SPARQL_TOKEN_TYPE_A,
	TRACKER_SPARQL_TOKEN_TYPE_ABS,
	TRACKER_SPARQL_TOKEN_TYPE_AS,
	TRACKER_SPARQL_TOKEN_TYPE_ASC,
	TRACKER_SPARQL_TOKEN_TYPE_ASK,
	TRACKER_SPARQL_TOKEN_TYPE_ATBASE,
	TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_AVG,
	TRACKER_SPARQL_TOKEN_TYPE_BASE,
	TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE,
	TRACKER_SPARQL_TOKEN_TYPE_BIND,
	TRACKER_SPARQL_TOKEN_TYPE_BOUND,
	TRACKER_SPARQL_TOKEN_TYPE_BY,
	TRACKER_SPARQL_TOKEN_TYPE_CEIL,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_COALESCE,
	TRACKER_SPARQL_TOKEN_TYPE_COLON,
	TRACKER_SPARQL_TOKEN_TYPE_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_CONTAINS,
	TRACKER_SPARQL_TOKEN_TYPE_COMMA,
	TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT,
	TRACKER_SPARQL_TOKEN_TYPE_COUNT,
	TRACKER_SPARQL_TOKEN_TYPE_DATA,
	TRACKER_SPARQL_TOKEN_TYPE_DATATYPE,
	TRACKER_SPARQL_TOKEN_TYPE_DAY,
	TRACKER_SPARQL_TOKEN_TYPE_DECIMAL,
	TRACKER_SPARQL_TOKEN_TYPE_DELETE,
	TRACKER_SPARQL_TOKEN_TYPE_DESC,
	TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE,
	TRACKER_SPARQL_TOKEN_TYPE_DISTINCT,
	TRACKER_SPARQL_TOKEN_TYPE_DIV,
	TRACKER_SPARQL_TOKEN_TYPE_DOT,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE,
	TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX,
	TRACKER_SPARQL_TOKEN_TYPE_DROP,
	TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI,
	TRACKER_SPARQL_TOKEN_TYPE_EOF,
	TRACKER_SPARQL_TOKEN_TYPE_EXISTS,
	TRACKER_SPARQL_TOKEN_TYPE_FALSE,
	TRACKER_SPARQL_TOKEN_TYPE_FILTER,
	TRACKER_SPARQL_TOKEN_TYPE_FLOOR,
	TRACKER_SPARQL_TOKEN_TYPE_FROM,
	TRACKER_SPARQL_TOKEN_TYPE_GRAPH,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP,
	TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT,
	TRACKER_SPARQL_TOKEN_TYPE_HAVING,
	TRACKER_SPARQL_TOKEN_TYPE_HOURS,
	TRACKER_SPARQL_TOKEN_TYPE_IF,
	TRACKER_SPARQL_TOKEN_TYPE_INSERT,
	TRACKER_SPARQL_TOKEN_TYPE_INTEGER,
	TRACKER_SPARQL_TOKEN_TYPE_INTO,
	TRACKER_SPARQL_TOKEN_TYPE_IRI_REF,
	TRACKER_SPARQL_TOKEN_TYPE_ISBLANK,
	TRACKER_SPARQL_TOKEN_TYPE_ISIRI,
	TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL,
	TRACKER_SPARQL_TOKEN_TYPE_ISURI,
	TRACKER_SPARQL_TOKEN_TYPE_LANG,
	TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES,
	TRACKER_SPARQL_TOKEN_TYPE_LCASE,
	TRACKER_SPARQL_TOKEN_TYPE_LIMIT,
	TRACKER_SPARQL_TOKEN_TYPE_MAX,
	TRACKER_SPARQL_TOKEN_TYPE_MD5,
	TRACKER_SPARQL_TOKEN_TYPE_MIN,
	TRACKER_SPARQL_TOKEN_TYPE_MINUS,
	TRACKER_SPARQL_TOKEN_TYPE_MINUTES,
	TRACKER_SPARQL_TOKEN_TYPE_MONTH,
	TRACKER_SPARQL_TOKEN_TYPE_NAMED,
	TRACKER_SPARQL_TOKEN_TYPE_NOT,
	TRACKER_SPARQL_TOKEN_TYPE_NOW,
	TRACKER_SPARQL_TOKEN_TYPE_NULL,
	TRACKER_SPARQL_TOKEN_TYPE_OFFSET,
	TRACKER_SPARQL_TOKEN_TYPE_OP_AND,
	TRACKER_SPARQL_TOKEN_TYPE_OP_EQ,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_GT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_LT,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NE,
	TRACKER_SPARQL_TOKEN_TYPE_OP_NEG,
	TRACKER_SPARQL_TOKEN_TYPE_OP_OR,
	TRACKER_SPARQL_TOKEN_TYPE_OP_IN,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET,
	TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS,
	TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL,
	TRACKER_SPARQL_TOKEN_TYPE_OR,
	TRACKER_SPARQL_TOKEN_TYPE_ORDER,
	TRACKER_SPARQL_TOKEN_TYPE_PLUS,
	TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_PREFIX,
	TRACKER_SPARQL_TOKEN_TYPE_RAND,
	TRACKER_SPARQL_TOKEN_TYPE_REDUCED,
	TRACKER_SPARQL_TOKEN_TYPE_REGEX,
	TRACKER_SPARQL_TOKEN_TYPE_REPLACE,
	TRACKER_SPARQL_TOKEN_TYPE_ROUND,
	TRACKER_SPARQL_TOKEN_TYPE_SAMETERM,
	TRACKER_SPARQL_TOKEN_TYPE_SECONDS,
	TRACKER_SPARQL_TOKEN_TYPE_SELECT,
	TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON,
	TRACKER_SPARQL_TOKEN_TYPE_SHA1,
	TRACKER_SPARQL_TOKEN_TYPE_SHA256,
	TRACKER_SPARQL_TOKEN_TYPE_SHA512,
	TRACKER_SPARQL_TOKEN_TYPE_SILENT,
	TRACKER_SPARQL_TOKEN_TYPE_STAR,
	TRACKER_SPARQL_TOKEN_TYPE_STR,
	TRACKER_SPARQL_TOKEN_TYPE_STRAFTER,
	TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE,
	TRACKER_SPARQL_TOKEN_TYPE_STRENDS,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1,
	TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2,
	TRACKER_SPARQL_TOKEN_TYPE_STRLEN,
	TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS,
	TRACKER_SPARQL_TOKEN_TYPE_SUBSTR,
	TRACKER_SPARQL_TOKEN_TYPE_SUM,
	TRACKER_SPARQL_TOKEN_TYPE_TRUE,
	TRACKER_SPARQL_TOKEN_TYPE_UCASE,
	TRACKER_SPARQL_TOKEN_TYPE_UNION,
	TRACKER_SPARQL_TOKEN_TYPE_VAR,
	TRACKER_SPARQL_TOKEN_TYPE_WHERE,
	TRACKER_SPARQL_TOKEN_TYPE_WITH,
	TRACKER_SPARQL_TOKEN_TYPE_YEAR
} TrackerSparqlTokenType;


static gpointer tracker_sparql_scanner_parent_class = NULL;

GType tracker_sparql_scanner_get_type (void) G_GNUC_CONST;
#define TRACKER_SPARQL_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScannerPrivate))
TrackerSparqlScanner* tracker_sparql_scanner_new (gchar* input,
                                                  gsize len);
TrackerSparqlScanner* tracker_sparql_scanner_construct (GType object_type,
                                                        gchar* input,
                                                        gsize len);
GType tracker_source_location_get_type (void) G_GNUC_CONST;
TrackerSourceLocation* tracker_source_location_dup (const TrackerSourceLocation* self);
void tracker_source_location_free (TrackerSourceLocation* self);
void tracker_sparql_scanner_seek (TrackerSparqlScanner* self,
                                  TrackerSourceLocation* location);
GType tracker_sparql_token_type_get_type (void) G_GNUC_CONST;
static TrackerSparqlTokenType tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self,
                                                                         gchar* begin,
                                                                         gint len);
static gboolean tracker_sparql_scanner_matches (TrackerSparqlScanner* self,
                                         gchar* begin,
                                         const gchar* keyword);
static TrackerSparqlTokenType tracker_sparql_scanner_read_number (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self,
                                            gchar c);
static gboolean tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self,
                                                  gchar c);
static gboolean tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self,
                                                 gchar c);
TrackerSparqlTokenType tracker_sparql_scanner_read_token (TrackerSparqlScanner* self,
                                                          TrackerSourceLocation* token_begin,
                                                          TrackerSourceLocation* token_end,
                                                          GError** error);
static void tracker_sparql_scanner_space (TrackerSparqlScanner* self);
void tracker_source_location_init (TrackerSourceLocation *self,
                                   gchar* pos,
                                   gint line,
                                   gint column);
static gboolean tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self);
static gboolean tracker_sparql_scanner_comment (TrackerSparqlScanner* self);
static void tracker_sparql_scanner_finalize (GObject * obj);
const gchar* tracker_sparql_token_type_to_string (TrackerSparqlTokenType self);


TrackerSparqlScanner*
tracker_sparql_scanner_construct (GType object_type,
                                  gchar* input,
                                  gsize len)
{
	TrackerSparqlScanner * self = NULL;
	gchar* begin = NULL;
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self = (TrackerSparqlScanner*) g_object_new (object_type, NULL);
#line 28 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	begin = input;
#line 29 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->end = begin + len;
#line 31 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->current = begin;
#line 33 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->line = 1;
#line 34 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->column = 1;
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return self;
#line 269 "tracker-sparql-scanner.c"
}


TrackerSparqlScanner*
tracker_sparql_scanner_new (gchar* input,
                            gsize len)
{
#line 27 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return tracker_sparql_scanner_construct (TRACKER_TYPE_SPARQL_SCANNER, input, len);
#line 279 "tracker-sparql-scanner.c"
}


void
tracker_sparql_scanner_seek (TrackerSparqlScanner* self,
                             TrackerSourceLocation* location)
{
	TrackerSourceLocation _tmp0_;
	gchar* _tmp1_;
	TrackerSourceLocation _tmp2_;
	gint _tmp3_;
	TrackerSourceLocation _tmp4_;
	gint _tmp5_;
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (location != NULL);
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = *location;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = _tmp0_.pos;
#line 38 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->current = _tmp1_;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = *location;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = _tmp2_.line;
#line 39 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->line = _tmp3_;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = *location;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp5_ = _tmp4_.column;
#line 40 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv->column = _tmp5_;
#line 315 "tracker-sparql-scanner.c"
}


static TrackerSparqlTokenType
tracker_sparql_scanner_get_identifier_or_keyword (TrackerSparqlScanner* self,
                                                  gchar* begin,
                                                  gint len)
{
	TrackerSparqlTokenType result = 0;
#line 43 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	switch (len) {
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 1:
#line 331 "tracker-sparql-scanner.c"
		{
			gchar _tmp0_;
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = begin[0];
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp0_) {
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 342 "tracker-sparql-scanner.c"
				{
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					result = TRACKER_SPARQL_TOKEN_TYPE_A;
#line 49 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					return result;
#line 348 "tracker-sparql-scanner.c"
				}
				default:
#line 46 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 353 "tracker-sparql-scanner.c"
			}
#line 51 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 357 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 2:
#line 361 "tracker-sparql-scanner.c"
		{
			gchar _tmp1_;
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp1_ = begin[0];
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp1_) {
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 372 "tracker-sparql-scanner.c"
				{
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "AS")) {
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_AS;
#line 56 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 380 "tracker-sparql-scanner.c"
					}
#line 57 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 384 "tracker-sparql-scanner.c"
				}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 390 "tracker-sparql-scanner.c"
				{
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "BY")) {
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BY;
#line 60 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 398 "tracker-sparql-scanner.c"
					}
#line 61 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 402 "tracker-sparql-scanner.c"
				}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 408 "tracker-sparql-scanner.c"
				{
					gchar _tmp2_;
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp2_ = begin[1];
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp2_) {
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'F':
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'f':
#line 419 "tracker-sparql-scanner.c"
						{
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "IF")) {
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_IF;
#line 67 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 427 "tracker-sparql-scanner.c"
							}
#line 68 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 431 "tracker-sparql-scanner.c"
						}
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 437 "tracker-sparql-scanner.c"
						{
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "IN")) {
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_OP_IN;
#line 71 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 445 "tracker-sparql-scanner.c"
							}
#line 72 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 449 "tracker-sparql-scanner.c"
						}
						default:
#line 64 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 454 "tracker-sparql-scanner.c"
					}
#line 74 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 458 "tracker-sparql-scanner.c"
				}
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 464 "tracker-sparql-scanner.c"
				{
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OR")) {
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OR;
#line 77 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 472 "tracker-sparql-scanner.c"
					}
#line 78 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 476 "tracker-sparql-scanner.c"
				}
				default:
#line 53 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 481 "tracker-sparql-scanner.c"
			}
#line 80 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 485 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 3:
#line 489 "tracker-sparql-scanner.c"
		{
			gchar _tmp3_;
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp3_ = begin[0];
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp3_) {
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'A':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'a':
#line 500 "tracker-sparql-scanner.c"
				{
					gchar _tmp4_;
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp4_ = begin[1];
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp4_) {
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 511 "tracker-sparql-scanner.c"
						{
							gchar _tmp5_;
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp5_ = begin[2];
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp5_) {
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'C':
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'c':
#line 522 "tracker-sparql-scanner.c"
								{
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ASC")) {
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASC;
#line 91 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 530 "tracker-sparql-scanner.c"
									}
#line 92 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 534 "tracker-sparql-scanner.c"
								}
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'K':
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'k':
#line 540 "tracker-sparql-scanner.c"
								{
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ASK")) {
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ASK;
#line 95 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 548 "tracker-sparql-scanner.c"
									}
#line 96 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 552 "tracker-sparql-scanner.c"
								}
								default:
#line 88 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 557 "tracker-sparql-scanner.c"
							}
#line 98 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 561 "tracker-sparql-scanner.c"
						}
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'B':
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'b':
#line 567 "tracker-sparql-scanner.c"
						{
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "ABS")) {
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_ABS;
#line 101 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 575 "tracker-sparql-scanner.c"
							}
#line 102 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 579 "tracker-sparql-scanner.c"
						}
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'V':
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'v':
#line 585 "tracker-sparql-scanner.c"
						{
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "AVG")) {
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_AVG;
#line 105 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 593 "tracker-sparql-scanner.c"
							}
#line 106 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 597 "tracker-sparql-scanner.c"
						}
						default:
#line 85 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 602 "tracker-sparql-scanner.c"
					}
#line 108 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 606 "tracker-sparql-scanner.c"
				}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 612 "tracker-sparql-scanner.c"
				{
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "DAY")) {
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DAY;
#line 111 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 620 "tracker-sparql-scanner.c"
					}
#line 112 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 624 "tracker-sparql-scanner.c"
				}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 630 "tracker-sparql-scanner.c"
				{
					gchar _tmp6_;
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp6_ = begin[1];
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp6_) {
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 641 "tracker-sparql-scanner.c"
						{
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MAX")) {
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MAX;
#line 118 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 649 "tracker-sparql-scanner.c"
							}
#line 119 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 653 "tracker-sparql-scanner.c"
						}
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'D':
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'd':
#line 659 "tracker-sparql-scanner.c"
						{
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MD5")) {
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MD5;
#line 122 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 667 "tracker-sparql-scanner.c"
							}
#line 123 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 671 "tracker-sparql-scanner.c"
						}
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 677 "tracker-sparql-scanner.c"
						{
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "MIN")) {
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_MIN;
#line 126 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 685 "tracker-sparql-scanner.c"
							}
#line 127 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 689 "tracker-sparql-scanner.c"
						}
						default:
#line 115 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 694 "tracker-sparql-scanner.c"
					}
#line 129 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 698 "tracker-sparql-scanner.c"
				}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 704 "tracker-sparql-scanner.c"
				{
					gchar _tmp7_;
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp7_ = begin[2];
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp7_) {
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 715 "tracker-sparql-scanner.c"
						{
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "NOT")) {
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_NOT;
#line 135 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 723 "tracker-sparql-scanner.c"
							}
#line 136 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 727 "tracker-sparql-scanner.c"
						}
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'W':
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'w':
#line 733 "tracker-sparql-scanner.c"
						{
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "NOW")) {
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_NOW;
#line 139 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 741 "tracker-sparql-scanner.c"
							}
#line 140 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 745 "tracker-sparql-scanner.c"
						}
						default:
#line 132 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 750 "tracker-sparql-scanner.c"
					}
#line 142 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 754 "tracker-sparql-scanner.c"
				}
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 760 "tracker-sparql-scanner.c"
				{
					gchar _tmp8_;
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp8_ = begin[1];
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp8_) {
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 771 "tracker-sparql-scanner.c"
						{
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STR")) {
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STR;
#line 148 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 779 "tracker-sparql-scanner.c"
							}
#line 149 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 783 "tracker-sparql-scanner.c"
						}
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'U':
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'u':
#line 789 "tracker-sparql-scanner.c"
						{
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SUM")) {
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUM;
#line 152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 797 "tracker-sparql-scanner.c"
							}
#line 153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 801 "tracker-sparql-scanner.c"
						}
						default:
#line 145 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 806 "tracker-sparql-scanner.c"
					}
#line 155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 810 "tracker-sparql-scanner.c"
				}
				default:
#line 82 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 815 "tracker-sparql-scanner.c"
			}
#line 157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 819 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 4:
#line 823 "tracker-sparql-scanner.c"
		{
			gchar _tmp9_;
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp9_ = begin[0];
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp9_) {
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 834 "tracker-sparql-scanner.c"
				{
					gchar _tmp10_;
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp10_ = begin[1];
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp10_) {
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 845 "tracker-sparql-scanner.c"
						{
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "BASE")) {
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_BASE;
#line 165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 853 "tracker-sparql-scanner.c"
							}
#line 166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 857 "tracker-sparql-scanner.c"
						}
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 863 "tracker-sparql-scanner.c"
						{
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "BIND")) {
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_BIND;
#line 169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 871 "tracker-sparql-scanner.c"
							}
#line 170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 875 "tracker-sparql-scanner.c"
						}
						default:
#line 162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 880 "tracker-sparql-scanner.c"
					}
#line 172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 884 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 890 "tracker-sparql-scanner.c"
				{
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CEIL")) {
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CEIL;
#line 175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 898 "tracker-sparql-scanner.c"
					}
#line 176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 902 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 908 "tracker-sparql-scanner.c"
				{
					gchar _tmp11_;
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp11_ = begin[1];
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp11_) {
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 919 "tracker-sparql-scanner.c"
						{
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DATA")) {
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATA;
#line 182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 927 "tracker-sparql-scanner.c"
							}
#line 183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 931 "tracker-sparql-scanner.c"
						}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 937 "tracker-sparql-scanner.c"
						{
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DESC")) {
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESC;
#line 186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 945 "tracker-sparql-scanner.c"
							}
#line 187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 949 "tracker-sparql-scanner.c"
						}
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'R':
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'r':
#line 955 "tracker-sparql-scanner.c"
						{
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DROP")) {
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DROP;
#line 190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 963 "tracker-sparql-scanner.c"
							}
#line 191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 967 "tracker-sparql-scanner.c"
						}
						default:
#line 179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 972 "tracker-sparql-scanner.c"
					}
#line 193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 976 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 982 "tracker-sparql-scanner.c"
				{
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "FROM")) {
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FROM;
#line 196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 990 "tracker-sparql-scanner.c"
					}
#line 197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 994 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1000 "tracker-sparql-scanner.c"
				{
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "INTO")) {
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INTO;
#line 200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1008 "tracker-sparql-scanner.c"
					}
#line 201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1012 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'L':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'l':
#line 1018 "tracker-sparql-scanner.c"
				{
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "LANG")) {
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_LANG;
#line 204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1026 "tracker-sparql-scanner.c"
					}
#line 205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1030 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 1036 "tracker-sparql-scanner.c"
				{
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "NULL")) {
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NULL;
#line 208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1044 "tracker-sparql-scanner.c"
					}
#line 209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1048 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 1054 "tracker-sparql-scanner.c"
				{
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "RAND")) {
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_RAND;
#line 212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1062 "tracker-sparql-scanner.c"
					}
#line 213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1066 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 1072 "tracker-sparql-scanner.c"
				{
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "SHA1")) {
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_SHA1;
#line 216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1080 "tracker-sparql-scanner.c"
					}
#line 217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1084 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'T':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 't':
#line 1090 "tracker-sparql-scanner.c"
				{
#line 220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "TRUE")) {
#line 220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_TRUE;
#line 220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1098 "tracker-sparql-scanner.c"
					}
#line 221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1102 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'W':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'w':
#line 1108 "tracker-sparql-scanner.c"
				{
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "WITH")) {
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WITH;
#line 224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1116 "tracker-sparql-scanner.c"
					}
#line 225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1120 "tracker-sparql-scanner.c"
				}
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'Y':
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'y':
#line 1126 "tracker-sparql-scanner.c"
				{
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "YEAR")) {
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_YEAR;
#line 228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1134 "tracker-sparql-scanner.c"
					}
#line 229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1138 "tracker-sparql-scanner.c"
				}
				default:
#line 159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1143 "tracker-sparql-scanner.c"
			}
#line 231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1147 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 5:
#line 1151 "tracker-sparql-scanner.c"
		{
			gchar _tmp12_;
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp12_ = begin[0];
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp12_) {
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'B':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'b':
#line 1162 "tracker-sparql-scanner.c"
				{
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "BOUND")) {
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_BOUND;
#line 236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1170 "tracker-sparql-scanner.c"
					}
#line 237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1174 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 1180 "tracker-sparql-scanner.c"
				{
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "COUNT")) {
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_COUNT;
#line 240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1188 "tracker-sparql-scanner.c"
					}
#line 241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1192 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'G':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'g':
#line 1198 "tracker-sparql-scanner.c"
				{
					gchar _tmp13_;
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp13_ = begin[2];
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp13_) {
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1209 "tracker-sparql-scanner.c"
						{
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "GRAPH")) {
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GRAPH;
#line 247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1217 "tracker-sparql-scanner.c"
							}
#line 248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1221 "tracker-sparql-scanner.c"
						}
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'O':
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'o':
#line 1227 "tracker-sparql-scanner.c"
						{
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "GROUP")) {
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_GROUP;
#line 251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1235 "tracker-sparql-scanner.c"
							}
#line 252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1239 "tracker-sparql-scanner.c"
						}
						default:
#line 244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1244 "tracker-sparql-scanner.c"
					}
#line 254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1248 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'H':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'h':
#line 1254 "tracker-sparql-scanner.c"
				{
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "HOURS")) {
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HOURS;
#line 257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1262 "tracker-sparql-scanner.c"
					}
#line 258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1266 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'L':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'l':
#line 1272 "tracker-sparql-scanner.c"
				{
					gchar _tmp14_;
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp14_ = begin[1];
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp14_) {
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'C':
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'c':
#line 1283 "tracker-sparql-scanner.c"
						{
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "LCASE")) {
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_LCASE;
#line 264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1291 "tracker-sparql-scanner.c"
							}
#line 265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1295 "tracker-sparql-scanner.c"
						}
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 1301 "tracker-sparql-scanner.c"
						{
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "LIMIT")) {
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_LIMIT;
#line 268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1309 "tracker-sparql-scanner.c"
							}
#line 269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1313 "tracker-sparql-scanner.c"
						}
						default:
#line 261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1318 "tracker-sparql-scanner.c"
					}
#line 271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1322 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 1328 "tracker-sparql-scanner.c"
				{
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "MONTH")) {
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_MONTH;
#line 274 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1336 "tracker-sparql-scanner.c"
					}
#line 275 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1340 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'N':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'n':
#line 1346 "tracker-sparql-scanner.c"
				{
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "NAMED")) {
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_NAMED;
#line 278 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1354 "tracker-sparql-scanner.c"
					}
#line 279 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1358 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 1364 "tracker-sparql-scanner.c"
				{
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ORDER")) {
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ORDER;
#line 282 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1372 "tracker-sparql-scanner.c"
					}
#line 283 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1376 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 1382 "tracker-sparql-scanner.c"
				{
					gchar _tmp15_;
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp15_ = begin[1];
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp15_) {
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 1393 "tracker-sparql-scanner.c"
						{
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REGEX")) {
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REGEX;
#line 289 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1401 "tracker-sparql-scanner.c"
							}
#line 290 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1405 "tracker-sparql-scanner.c"
						}
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'O':
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'o':
#line 1411 "tracker-sparql-scanner.c"
						{
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "ROUND")) {
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_ROUND;
#line 293 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1419 "tracker-sparql-scanner.c"
							}
#line 294 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1423 "tracker-sparql-scanner.c"
						}
						default:
#line 286 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1428 "tracker-sparql-scanner.c"
					}
#line 296 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1432 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'U':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'u':
#line 1438 "tracker-sparql-scanner.c"
				{
					gchar _tmp16_;
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp16_ = begin[1];
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp16_) {
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 1449 "tracker-sparql-scanner.c"
						{
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "UNION")) {
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_UNION;
#line 302 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1457 "tracker-sparql-scanner.c"
							}
#line 303 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1461 "tracker-sparql-scanner.c"
						}
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'C':
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'c':
#line 1467 "tracker-sparql-scanner.c"
						{
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "UCASE")) {
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_UCASE;
#line 306 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1475 "tracker-sparql-scanner.c"
							}
#line 307 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1479 "tracker-sparql-scanner.c"
						}
						default:
#line 299 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1484 "tracker-sparql-scanner.c"
					}
#line 309 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1488 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'W':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'w':
#line 1494 "tracker-sparql-scanner.c"
				{
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "WHERE")) {
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_WHERE;
#line 312 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1502 "tracker-sparql-scanner.c"
					}
#line 313 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1506 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1512 "tracker-sparql-scanner.c"
				{
					gchar _tmp17_;
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp17_ = begin[1];
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp17_) {
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 1523 "tracker-sparql-scanner.c"
						{
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "FALSE")) {
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_FALSE;
#line 319 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1531 "tracker-sparql-scanner.c"
							}
#line 320 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1535 "tracker-sparql-scanner.c"
						}
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'L':
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'l':
#line 1541 "tracker-sparql-scanner.c"
						{
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "FLOOR")) {
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_FLOOR;
#line 323 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1549 "tracker-sparql-scanner.c"
							}
#line 324 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1553 "tracker-sparql-scanner.c"
						}
						default:
#line 316 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1558 "tracker-sparql-scanner.c"
					}
#line 326 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1562 "tracker-sparql-scanner.c"
				}
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1568 "tracker-sparql-scanner.c"
				{
					gchar _tmp18_;
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp18_ = begin[1];
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp18_) {
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 1579 "tracker-sparql-scanner.c"
						{
							gchar _tmp19_;
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp19_ = begin[2];
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp19_) {
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'I':
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'i':
#line 1590 "tracker-sparql-scanner.c"
								{
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ISIRI")) {
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISIRI;
#line 335 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1598 "tracker-sparql-scanner.c"
									}
#line 336 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1602 "tracker-sparql-scanner.c"
								}
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'U':
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case 'u':
#line 1608 "tracker-sparql-scanner.c"
								{
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "ISURI")) {
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_ISURI;
#line 339 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1616 "tracker-sparql-scanner.c"
									}
#line 340 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1620 "tracker-sparql-scanner.c"
								}
								default:
#line 332 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 1625 "tracker-sparql-scanner.c"
							}
#line 342 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1629 "tracker-sparql-scanner.c"
						}
						default:
#line 329 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1634 "tracker-sparql-scanner.c"
					}
#line 344 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1638 "tracker-sparql-scanner.c"
				}
				default:
#line 233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1643 "tracker-sparql-scanner.c"
			}
#line 346 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1647 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 6:
#line 1651 "tracker-sparql-scanner.c"
		{
			gchar _tmp20_;
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp20_ = begin[0];
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp20_) {
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 1662 "tracker-sparql-scanner.c"
				{
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CONCAT")) {
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONCAT;
#line 351 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1670 "tracker-sparql-scanner.c"
					}
#line 352 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1674 "tracker-sparql-scanner.c"
				}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 1680 "tracker-sparql-scanner.c"
				{
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "DELETE")) {
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_DELETE;
#line 355 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1688 "tracker-sparql-scanner.c"
					}
#line 356 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1692 "tracker-sparql-scanner.c"
				}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'E':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'e':
#line 1698 "tracker-sparql-scanner.c"
				{
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "EXISTS")) {
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_EXISTS;
#line 359 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1706 "tracker-sparql-scanner.c"
					}
#line 360 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1710 "tracker-sparql-scanner.c"
				}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'F':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'f':
#line 1716 "tracker-sparql-scanner.c"
				{
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "FILTER")) {
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_FILTER;
#line 363 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1724 "tracker-sparql-scanner.c"
					}
#line 364 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1728 "tracker-sparql-scanner.c"
				}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'H':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'h':
#line 1734 "tracker-sparql-scanner.c"
				{
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "HAVING")) {
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_HAVING;
#line 367 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1742 "tracker-sparql-scanner.c"
					}
#line 368 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1746 "tracker-sparql-scanner.c"
				}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 1752 "tracker-sparql-scanner.c"
				{
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "INSERT")) {
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_INSERT;
#line 371 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1760 "tracker-sparql-scanner.c"
					}
#line 372 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1764 "tracker-sparql-scanner.c"
				}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 1770 "tracker-sparql-scanner.c"
				{
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OFFSET")) {
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OFFSET;
#line 375 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1778 "tracker-sparql-scanner.c"
					}
#line 376 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1782 "tracker-sparql-scanner.c"
				}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'P':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'p':
#line 1788 "tracker-sparql-scanner.c"
				{
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "PREFIX")) {
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_PREFIX;
#line 379 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1796 "tracker-sparql-scanner.c"
					}
#line 380 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1800 "tracker-sparql-scanner.c"
				}
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 1806 "tracker-sparql-scanner.c"
				{
					gchar _tmp21_;
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp21_ = begin[1];
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp21_) {
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 1817 "tracker-sparql-scanner.c"
						{
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SELECT")) {
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SELECT;
#line 386 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1825 "tracker-sparql-scanner.c"
							}
#line 387 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1829 "tracker-sparql-scanner.c"
						}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 1835 "tracker-sparql-scanner.c"
						{
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SILENT")) {
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SILENT;
#line 390 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1843 "tracker-sparql-scanner.c"
							}
#line 391 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1847 "tracker-sparql-scanner.c"
						}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 1853 "tracker-sparql-scanner.c"
						{
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRLEN")) {
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRLEN;
#line 394 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1861 "tracker-sparql-scanner.c"
							}
#line 395 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1865 "tracker-sparql-scanner.c"
						}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'U':
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'u':
#line 1871 "tracker-sparql-scanner.c"
						{
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SUBSTR")) {
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SUBSTR;
#line 398 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 1879 "tracker-sparql-scanner.c"
							}
#line 399 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1883 "tracker-sparql-scanner.c"
						}
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'H':
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'h':
#line 1889 "tracker-sparql-scanner.c"
						{
							gchar _tmp22_;
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp22_ = begin[3];
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp22_) {
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '2':
#line 1898 "tracker-sparql-scanner.c"
								{
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "SHA256")) {
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_SHA256;
#line 404 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1906 "tracker-sparql-scanner.c"
									}
#line 405 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1910 "tracker-sparql-scanner.c"
								}
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '5':
#line 1914 "tracker-sparql-scanner.c"
								{
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (tracker_sparql_scanner_matches (self, begin, "SHA512")) {
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										result = TRACKER_SPARQL_TOKEN_TYPE_SHA512;
#line 407 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										return result;
#line 1922 "tracker-sparql-scanner.c"
									}
#line 408 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 1926 "tracker-sparql-scanner.c"
								}
								default:
#line 402 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 1931 "tracker-sparql-scanner.c"
							}
#line 410 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 1935 "tracker-sparql-scanner.c"
						}
						default:
#line 383 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 1940 "tracker-sparql-scanner.c"
					}
#line 412 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1944 "tracker-sparql-scanner.c"
				}
				default:
#line 348 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 1949 "tracker-sparql-scanner.c"
			}
#line 414 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 1953 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 7:
#line 1957 "tracker-sparql-scanner.c"
		{
			gchar _tmp23_;
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp23_ = begin[0];
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp23_) {
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'M':
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'm':
#line 1968 "tracker-sparql-scanner.c"
				{
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "MINUTES")) {
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_MINUTES;
#line 419 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 1976 "tracker-sparql-scanner.c"
					}
#line 420 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 1980 "tracker-sparql-scanner.c"
				}
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'R':
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'r':
#line 1986 "tracker-sparql-scanner.c"
				{
					gchar _tmp24_;
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp24_ = begin[2];
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp24_) {
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'D':
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'd':
#line 1997 "tracker-sparql-scanner.c"
						{
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REDUCED")) {
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REDUCED;
#line 426 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2005 "tracker-sparql-scanner.c"
							}
#line 427 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2009 "tracker-sparql-scanner.c"
						}
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'P':
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'p':
#line 2015 "tracker-sparql-scanner.c"
						{
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "REPLACE")) {
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_REPLACE;
#line 430 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2023 "tracker-sparql-scanner.c"
							}
#line 431 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2027 "tracker-sparql-scanner.c"
						}
						default:
#line 423 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2032 "tracker-sparql-scanner.c"
					}
#line 433 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2036 "tracker-sparql-scanner.c"
				}
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2042 "tracker-sparql-scanner.c"
				{
					gchar _tmp25_;
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp25_ = begin[1];
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp25_) {
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 2053 "tracker-sparql-scanner.c"
						{
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SECONDS")) {
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SECONDS;
#line 439 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2061 "tracker-sparql-scanner.c"
							}
#line 440 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2065 "tracker-sparql-scanner.c"
						}
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 2071 "tracker-sparql-scanner.c"
						{
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRENDS")) {
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRENDS;
#line 443 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2079 "tracker-sparql-scanner.c"
							}
#line 444 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2083 "tracker-sparql-scanner.c"
						}
						default:
#line 436 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2088 "tracker-sparql-scanner.c"
					}
#line 446 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2092 "tracker-sparql-scanner.c"
				}
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 2098 "tracker-sparql-scanner.c"
				{
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ISBLANK")) {
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISBLANK;
#line 449 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2106 "tracker-sparql-scanner.c"
					}
#line 450 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2110 "tracker-sparql-scanner.c"
				}
				default:
#line 416 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2115 "tracker-sparql-scanner.c"
			}
#line 452 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2119 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 8:
#line 2123 "tracker-sparql-scanner.c"
		{
			gchar _tmp26_;
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp26_ = begin[0];
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp26_) {
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 2134 "tracker-sparql-scanner.c"
				{
					gchar _tmp27_;
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp27_ = begin[2];
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp27_) {
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 2145 "tracker-sparql-scanner.c"
						{
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "COALESCE")) {
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_COALESCE;
#line 460 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2153 "tracker-sparql-scanner.c"
							}
#line 461 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2157 "tracker-sparql-scanner.c"
						}
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'N':
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'n':
#line 2163 "tracker-sparql-scanner.c"
						{
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "CONTAINS")) {
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_CONTAINS;
#line 464 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2171 "tracker-sparql-scanner.c"
							}
#line 465 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2175 "tracker-sparql-scanner.c"
						}
						default:
#line 457 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2180 "tracker-sparql-scanner.c"
					}
#line 467 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2184 "tracker-sparql-scanner.c"
				}
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'D':
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'd':
#line 2190 "tracker-sparql-scanner.c"
				{
					gchar _tmp28_;
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp28_ = begin[1];
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp28_) {
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 2201 "tracker-sparql-scanner.c"
						{
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DATATYPE")) {
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DATATYPE;
#line 473 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2209 "tracker-sparql-scanner.c"
							}
#line 474 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2213 "tracker-sparql-scanner.c"
						}
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'E':
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'e':
#line 2219 "tracker-sparql-scanner.c"
						{
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DESCRIBE")) {
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE;
#line 477 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2227 "tracker-sparql-scanner.c"
							}
#line 478 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2231 "tracker-sparql-scanner.c"
						}
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'I':
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'i':
#line 2237 "tracker-sparql-scanner.c"
						{
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "DISTINCT")) {
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_DISTINCT;
#line 481 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2245 "tracker-sparql-scanner.c"
							}
#line 482 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2249 "tracker-sparql-scanner.c"
						}
						default:
#line 470 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2254 "tracker-sparql-scanner.c"
					}
#line 484 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2258 "tracker-sparql-scanner.c"
				}
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'O':
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'o':
#line 2264 "tracker-sparql-scanner.c"
				{
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "OPTIONAL")) {
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL;
#line 487 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2272 "tracker-sparql-scanner.c"
					}
#line 488 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2276 "tracker-sparql-scanner.c"
				}
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2282 "tracker-sparql-scanner.c"
				{
					gchar _tmp29_;
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp29_ = begin[1];
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp29_) {
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'A':
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'a':
#line 2293 "tracker-sparql-scanner.c"
						{
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "SAMETERM")) {
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_SAMETERM;
#line 494 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2301 "tracker-sparql-scanner.c"
							}
#line 495 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2305 "tracker-sparql-scanner.c"
						}
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'T':
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 't':
#line 2311 "tracker-sparql-scanner.c"
						{
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRAFTER")) {
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRAFTER;
#line 498 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2319 "tracker-sparql-scanner.c"
							}
#line 499 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2323 "tracker-sparql-scanner.c"
						}
						default:
#line 491 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2328 "tracker-sparql-scanner.c"
					}
#line 501 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2332 "tracker-sparql-scanner.c"
				}
				default:
#line 454 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2337 "tracker-sparql-scanner.c"
			}
#line 503 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2341 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 9:
#line 2345 "tracker-sparql-scanner.c"
		{
			gchar _tmp30_;
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp30_ = begin[0];
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			switch (_tmp30_) {
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'C':
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'c':
#line 2356 "tracker-sparql-scanner.c"
				{
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "CONSTRUCT")) {
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT;
#line 508 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2364 "tracker-sparql-scanner.c"
					}
#line 509 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2368 "tracker-sparql-scanner.c"
				}
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'I':
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'i':
#line 2374 "tracker-sparql-scanner.c"
				{
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (tracker_sparql_scanner_matches (self, begin, "ISLITERAL")) {
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						result = TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL;
#line 512 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						return result;
#line 2382 "tracker-sparql-scanner.c"
					}
#line 513 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2386 "tracker-sparql-scanner.c"
				}
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 'S':
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				case 's':
#line 2392 "tracker-sparql-scanner.c"
				{
					gchar _tmp31_;
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp31_ = begin[3];
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					switch (_tmp31_) {
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'B':
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'b':
#line 2403 "tracker-sparql-scanner.c"
						{
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRBEFORE")) {
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE;
#line 519 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2411 "tracker-sparql-scanner.c"
							}
#line 520 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2415 "tracker-sparql-scanner.c"
						}
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 'S':
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						case 's':
#line 2421 "tracker-sparql-scanner.c"
						{
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (tracker_sparql_scanner_matches (self, begin, "STRSTARTS")) {
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								result = TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS;
#line 523 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return result;
#line 2429 "tracker-sparql-scanner.c"
							}
#line 524 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 2433 "tracker-sparql-scanner.c"
						}
						default:
#line 516 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 2438 "tracker-sparql-scanner.c"
					}
#line 526 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 2442 "tracker-sparql-scanner.c"
				}
				default:
#line 505 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2447 "tracker-sparql-scanner.c"
			}
#line 528 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2451 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 11:
#line 2455 "tracker-sparql-scanner.c"
		{
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "LANGMATCHES")) {
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES;
#line 530 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2463 "tracker-sparql-scanner.c"
			}
#line 531 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2467 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 12:
#line 2471 "tracker-sparql-scanner.c"
		{
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "GROUP_CONCAT")) {
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT;
#line 533 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2479 "tracker-sparql-scanner.c"
			}
#line 534 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2483 "tracker-sparql-scanner.c"
		}
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case 14:
#line 2487 "tracker-sparql-scanner.c"
		{
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (tracker_sparql_scanner_matches (self, begin, "ENCODE_FOR_URI")) {
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				result = TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI;
#line 536 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				return result;
#line 2495 "tracker-sparql-scanner.c"
			}
#line 537 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 2499 "tracker-sparql-scanner.c"
		}
		default:
#line 44 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		break;
#line 2504 "tracker-sparql-scanner.c"
	}
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX;
#line 539 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 2510 "tracker-sparql-scanner.c"
}


static TrackerSparqlTokenType
tracker_sparql_scanner_read_number (TrackerSparqlScanner* self)
{
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gboolean _tmp39_ = FALSE;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp60_;
	gchar* _tmp61_;
#line 542 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 543 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	type = TRACKER_SPARQL_TOKEN_TYPE_INTEGER;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->current;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = self->priv->end;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp3_ < (_tmp4_ - 2)) {
#line 2543 "tracker-sparql-scanner.c"
		gchar* _tmp5_;
		gchar _tmp6_;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = self->priv->current;
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = _tmp5_[0];
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = _tmp6_ == '0';
#line 2552 "tracker-sparql-scanner.c"
	} else {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = FALSE;
#line 2556 "tracker-sparql-scanner.c"
	}
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 2560 "tracker-sparql-scanner.c"
		gchar* _tmp7_;
		gchar _tmp8_;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->current;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = _tmp7_[1];
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = _tmp8_ == 'x';
#line 2569 "tracker-sparql-scanner.c"
	} else {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = FALSE;
#line 2573 "tracker-sparql-scanner.c"
	}
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 2577 "tracker-sparql-scanner.c"
		gchar* _tmp9_;
		gchar _tmp10_;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = self->priv->current;
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp10_ = _tmp9_[2];
#line 547 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = g_ascii_isxdigit (_tmp10_);
#line 2586 "tracker-sparql-scanner.c"
	} else {
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = FALSE;
#line 2590 "tracker-sparql-scanner.c"
	}
#line 546 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp0_) {
#line 2594 "tracker-sparql-scanner.c"
		gchar* _tmp11_;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp11_ = self->priv->current;
#line 549 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp11_ + 2;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2602 "tracker-sparql-scanner.c"
			gboolean _tmp12_ = FALSE;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp17_;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp13_ = self->priv->current;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp14_ = self->priv->end;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp13_ < _tmp14_) {
#line 2613 "tracker-sparql-scanner.c"
				gchar* _tmp15_;
				gchar _tmp16_;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp15_ = self->priv->current;
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp16_ = _tmp15_[0];
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp12_ = g_ascii_isxdigit (_tmp16_);
#line 2622 "tracker-sparql-scanner.c"
			} else {
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp12_ = FALSE;
#line 2626 "tracker-sparql-scanner.c"
			}
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp12_) {
#line 550 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2632 "tracker-sparql-scanner.c"
			}
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp17_ = self->priv->current;
#line 551 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp17_ + 1;
#line 2638 "tracker-sparql-scanner.c"
		}
	} else {
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2643 "tracker-sparql-scanner.c"
			gboolean _tmp18_ = FALSE;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp23_;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp19_ = self->priv->current;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp20_ = self->priv->end;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp19_ < _tmp20_) {
#line 2654 "tracker-sparql-scanner.c"
				gchar* _tmp21_;
				gchar _tmp22_;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp21_ = self->priv->current;
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp22_ = _tmp21_[0];
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp18_ = g_ascii_isdigit (_tmp22_);
#line 2663 "tracker-sparql-scanner.c"
			} else {
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp18_ = FALSE;
#line 2667 "tracker-sparql-scanner.c"
			}
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp18_) {
#line 555 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2673 "tracker-sparql-scanner.c"
			}
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp23_ = self->priv->current;
#line 556 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp23_ + 1;
#line 2679 "tracker-sparql-scanner.c"
		}
	}
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp26_ = self->priv->current;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp27_ = self->priv->end;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp26_ < (_tmp27_ - 1)) {
#line 2688 "tracker-sparql-scanner.c"
		gchar* _tmp28_;
		gchar _tmp29_;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp28_ = self->priv->current;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp29_ = _tmp28_[0];
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp25_ = _tmp29_ == '.';
#line 2697 "tracker-sparql-scanner.c"
	} else {
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp25_ = FALSE;
#line 2701 "tracker-sparql-scanner.c"
	}
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp25_) {
#line 2705 "tracker-sparql-scanner.c"
		gchar* _tmp30_;
		gchar _tmp31_;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp30_ = self->priv->current;
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp31_ = _tmp30_[1];
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp24_ = g_ascii_isdigit (_tmp31_);
#line 2714 "tracker-sparql-scanner.c"
	} else {
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp24_ = FALSE;
#line 2718 "tracker-sparql-scanner.c"
	}
#line 561 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp24_) {
#line 2722 "tracker-sparql-scanner.c"
		gchar* _tmp32_;
#line 562 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp32_ = self->priv->current;
#line 563 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp32_ + 1;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2732 "tracker-sparql-scanner.c"
			gboolean _tmp33_ = FALSE;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp38_;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp34_ = self->priv->current;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp35_ = self->priv->end;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp34_ < _tmp35_) {
#line 2743 "tracker-sparql-scanner.c"
				gchar* _tmp36_;
				gchar _tmp37_;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp36_ = self->priv->current;
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp37_ = _tmp36_[0];
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp33_ = g_ascii_isdigit (_tmp37_);
#line 2752 "tracker-sparql-scanner.c"
			} else {
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp33_ = FALSE;
#line 2756 "tracker-sparql-scanner.c"
			}
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp33_) {
#line 564 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2762 "tracker-sparql-scanner.c"
			}
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp38_ = self->priv->current;
#line 565 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp38_ + 1;
#line 2768 "tracker-sparql-scanner.c"
		}
	}
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp40_ = self->priv->current;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp41_ = self->priv->end;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp40_ < _tmp41_) {
#line 2777 "tracker-sparql-scanner.c"
		gchar* _tmp42_;
		gchar _tmp43_;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp42_ = self->priv->current;
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp43_ = _tmp42_[0];
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp39_ = g_ascii_tolower (_tmp43_) == 'e';
#line 2786 "tracker-sparql-scanner.c"
	} else {
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp39_ = FALSE;
#line 2790 "tracker-sparql-scanner.c"
	}
#line 570 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp39_) {
#line 2794 "tracker-sparql-scanner.c"
		gchar* _tmp44_;
		gboolean _tmp45_ = FALSE;
		gchar* _tmp46_;
		gchar* _tmp47_;
#line 571 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp44_ = self->priv->current;
#line 572 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp44_ + 1;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp46_ = self->priv->current;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp47_ = self->priv->end;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp46_ < _tmp47_) {
#line 2811 "tracker-sparql-scanner.c"
			gboolean _tmp48_ = FALSE;
			gchar* _tmp49_;
			gchar _tmp50_;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp49_ = self->priv->current;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp50_ = _tmp49_[0];
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp50_ == '+') {
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp48_ = TRUE;
#line 2823 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp51_;
				gchar _tmp52_;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp51_ = self->priv->current;
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp52_ = _tmp51_[0];
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp48_ = _tmp52_ == '-';
#line 2833 "tracker-sparql-scanner.c"
			}
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp45_ = _tmp48_;
#line 2837 "tracker-sparql-scanner.c"
		} else {
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp45_ = FALSE;
#line 2841 "tracker-sparql-scanner.c"
		}
#line 573 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp45_) {
#line 2845 "tracker-sparql-scanner.c"
			gchar* _tmp53_;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp53_ = self->priv->current;
#line 574 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp53_ + 1;
#line 2851 "tracker-sparql-scanner.c"
		}
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		while (TRUE) {
#line 2855 "tracker-sparql-scanner.c"
			gboolean _tmp54_ = FALSE;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp59_;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp55_ = self->priv->current;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp56_ = self->priv->end;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (_tmp55_ < _tmp56_) {
#line 2866 "tracker-sparql-scanner.c"
				gchar* _tmp57_;
				gchar _tmp58_;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp57_ = self->priv->current;
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp58_ = _tmp57_[0];
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp54_ = g_ascii_isdigit (_tmp58_);
#line 2875 "tracker-sparql-scanner.c"
			} else {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp54_ = FALSE;
#line 2879 "tracker-sparql-scanner.c"
			}
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (!_tmp54_) {
#line 576 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2885 "tracker-sparql-scanner.c"
			}
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp59_ = self->priv->current;
#line 577 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->current = _tmp59_ + 1;
#line 2891 "tracker-sparql-scanner.c"
		}
	}
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp60_ = self->priv->current;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp61_ = self->priv->end;
#line 582 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp60_ < _tmp61_) {
#line 2900 "tracker-sparql-scanner.c"
		gchar* _tmp62_;
		gchar _tmp63_;
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp62_ = self->priv->current;
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp63_ = _tmp62_[0];
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		switch (_tmp63_) {
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'l':
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'L':
#line 2913 "tracker-sparql-scanner.c"
			{
				TrackerSparqlTokenType _tmp64_;
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp64_ = type;
#line 586 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp64_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 2920 "tracker-sparql-scanner.c"
					gchar* _tmp65_;
					gboolean _tmp66_ = FALSE;
					gchar* _tmp67_;
					gchar* _tmp68_;
#line 587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp65_ = self->priv->current;
#line 587 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					self->priv->current = _tmp65_ + 1;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp67_ = self->priv->current;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp68_ = self->priv->end;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp67_ < _tmp68_) {
#line 2935 "tracker-sparql-scanner.c"
						gchar* _tmp69_;
						gchar _tmp70_;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp69_ = self->priv->current;
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp70_ = _tmp69_[0];
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp66_ = g_ascii_tolower (_tmp70_) == 'l';
#line 2944 "tracker-sparql-scanner.c"
					} else {
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp66_ = FALSE;
#line 2948 "tracker-sparql-scanner.c"
					}
#line 588 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp66_) {
#line 2952 "tracker-sparql-scanner.c"
						gchar* _tmp71_;
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp71_ = self->priv->current;
#line 589 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp71_ + 1;
#line 2958 "tracker-sparql-scanner.c"
					}
				}
#line 592 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 2963 "tracker-sparql-scanner.c"
			}
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'u':
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'U':
#line 2969 "tracker-sparql-scanner.c"
			{
				TrackerSparqlTokenType _tmp72_;
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp72_ = type;
#line 595 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp72_ == TRACKER_SPARQL_TOKEN_TYPE_INTEGER) {
#line 2976 "tracker-sparql-scanner.c"
					gchar* _tmp73_;
					gboolean _tmp74_ = FALSE;
					gchar* _tmp75_;
					gchar* _tmp76_;
#line 596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp73_ = self->priv->current;
#line 596 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					self->priv->current = _tmp73_ + 1;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp75_ = self->priv->current;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp76_ = self->priv->end;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp75_ < _tmp76_) {
#line 2991 "tracker-sparql-scanner.c"
						gchar* _tmp77_;
						gchar _tmp78_;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp77_ = self->priv->current;
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp78_ = _tmp77_[0];
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp74_ = g_ascii_tolower (_tmp78_) == 'l';
#line 3000 "tracker-sparql-scanner.c"
					} else {
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp74_ = FALSE;
#line 3004 "tracker-sparql-scanner.c"
					}
#line 597 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					if (_tmp74_) {
#line 3008 "tracker-sparql-scanner.c"
						gchar* _tmp79_;
						gboolean _tmp80_ = FALSE;
						gchar* _tmp81_;
						gchar* _tmp82_;
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp79_ = self->priv->current;
#line 598 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp79_ + 1;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp81_ = self->priv->current;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp82_ = self->priv->end;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp81_ < _tmp82_) {
#line 3023 "tracker-sparql-scanner.c"
							gchar* _tmp83_;
							gchar _tmp84_;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp83_ = self->priv->current;
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp84_ = _tmp83_[0];
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp80_ = g_ascii_tolower (_tmp84_) == 'l';
#line 3032 "tracker-sparql-scanner.c"
						} else {
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp80_ = FALSE;
#line 3036 "tracker-sparql-scanner.c"
						}
#line 599 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp80_) {
#line 3040 "tracker-sparql-scanner.c"
							gchar* _tmp85_;
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp85_ = self->priv->current;
#line 600 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp85_ + 1;
#line 3046 "tracker-sparql-scanner.c"
						}
					}
				}
#line 604 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3052 "tracker-sparql-scanner.c"
			}
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'f':
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'F':
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'd':
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			case 'D':
#line 3062 "tracker-sparql-scanner.c"
			{
				gchar* _tmp86_;
#line 609 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp86_ = self->priv->current;
#line 610 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				self->priv->current = _tmp86_ + 1;
#line 611 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				break;
#line 3073 "tracker-sparql-scanner.c"
			}
			default:
#line 583 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 3078 "tracker-sparql-scanner.c"
		}
	}
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = type;
#line 615 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3085 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_is_pn_char (TrackerSparqlScanner* self,
                                   gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
#line 618 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 3102 "tracker-sparql-scanner.c"
	} else {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = c == '_';
#line 3106 "tracker-sparql-scanner.c"
	}
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3112 "tracker-sparql-scanner.c"
	} else {
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = c == '-';
#line 3116 "tracker-sparql-scanner.c"
	}
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 619 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3122 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_is_pn_local_char (TrackerSparqlScanner* self,
                                         gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 622 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = TRUE;
#line 3140 "tracker-sparql-scanner.c"
	} else {
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = c == '_';
#line 3144 "tracker-sparql-scanner.c"
	}
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp2_) {
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = TRUE;
#line 3150 "tracker-sparql-scanner.c"
	} else {
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = c == '-';
#line 3154 "tracker-sparql-scanner.c"
	}
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_) {
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3160 "tracker-sparql-scanner.c"
	} else {
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = c == '.';
#line 3164 "tracker-sparql-scanner.c"
	}
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 623 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3170 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_is_varname_char (TrackerSparqlScanner* self,
                                        gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 626 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (g_ascii_isalnum (c)) {
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 3186 "tracker-sparql-scanner.c"
	} else {
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = c == '_';
#line 3190 "tracker-sparql-scanner.c"
	}
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = _tmp0_;
#line 627 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 3196 "tracker-sparql-scanner.c"
}


TrackerSparqlTokenType
tracker_sparql_scanner_read_token (TrackerSparqlScanner* self,
                                   TrackerSourceLocation* token_begin,
                                   TrackerSourceLocation* token_end,
                                   GError** error)
{
	TrackerSourceLocation _vala_token_begin = {0};
	TrackerSourceLocation _vala_token_end = {0};
	TrackerSparqlTokenType result = 0;
	TrackerSparqlTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp284_;
	gchar* _tmp290_;
	gint _tmp291_;
	gint _tmp292_;
	GError * _inner_error_ = NULL;
#line 630 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 631 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_sparql_scanner_space (self);
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp0_ = self->priv->current;
#line 634 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	begin = _tmp0_;
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = begin;
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->line;
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp3_ = self->priv->column;
#line 635 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
#line 637 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	token_length_in_chars = -1;
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp4_ = self->priv->current;
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp5_ = self->priv->end;
#line 639 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp4_ >= _tmp5_) {
#line 640 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		type = TRACKER_SPARQL_TOKEN_TYPE_EOF;
#line 3249 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = self->priv->current;
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = _tmp6_[0];
#line 641 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (g_ascii_isalpha (_tmp7_)) {
#line 3259 "tracker-sparql-scanner.c"
			gint len = 0;
			gchar* _tmp15_;
			gint _tmp16_;
#line 643 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			len = 0;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			while (TRUE) {
#line 3267 "tracker-sparql-scanner.c"
				gboolean _tmp8_ = FALSE;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp13_;
				gint _tmp14_;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp9_ = self->priv->current;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp10_ = self->priv->end;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (_tmp9_ < _tmp10_) {
#line 3279 "tracker-sparql-scanner.c"
					gchar* _tmp11_;
					gchar _tmp12_;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp11_ = self->priv->current;
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp12_ = _tmp11_[0];
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp8_ = tracker_sparql_scanner_is_pn_char (self, _tmp12_);
#line 3288 "tracker-sparql-scanner.c"
				} else {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp8_ = FALSE;
#line 3292 "tracker-sparql-scanner.c"
				}
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!_tmp8_) {
#line 644 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 3298 "tracker-sparql-scanner.c"
				}
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp13_ = self->priv->current;
#line 645 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				self->priv->current = _tmp13_ + 1;
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp14_ = len;
#line 646 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				len = _tmp14_ + 1;
#line 3308 "tracker-sparql-scanner.c"
			}
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp15_ = begin;
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp16_ = len;
#line 648 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			type = tracker_sparql_scanner_get_identifier_or_keyword (self, _tmp15_, _tmp16_);
#line 3316 "tracker-sparql-scanner.c"
		} else {
			gchar* _tmp17_;
			gchar _tmp18_;
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp17_ = self->priv->current;
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp18_ = _tmp17_[0];
#line 649 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			if (g_ascii_isdigit (_tmp18_)) {
#line 650 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				type = tracker_sparql_scanner_read_number (self);
#line 3328 "tracker-sparql-scanner.c"
			} else {
				gchar* _tmp19_;
				gchar _tmp20_;
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp19_ = self->priv->current;
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp20_ = _tmp19_[0];
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				switch (_tmp20_) {
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '{':
#line 3340 "tracker-sparql-scanner.c"
					{
						gchar* _tmp21_;
#line 654 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE;
#line 655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp21_ = self->priv->current;
#line 655 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp21_ + 1;
#line 656 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3351 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '}':
#line 3355 "tracker-sparql-scanner.c"
					{
						gchar* _tmp22_;
#line 658 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE;
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp22_ = self->priv->current;
#line 659 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp22_ + 1;
#line 660 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3366 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '(':
#line 3370 "tracker-sparql-scanner.c"
					{
						gchar* _tmp23_;
#line 662 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS;
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp23_ = self->priv->current;
#line 663 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp23_ + 1;
#line 664 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3381 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ')':
#line 3385 "tracker-sparql-scanner.c"
					{
						gchar* _tmp24_;
#line 666 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS;
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp24_ = self->priv->current;
#line 667 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp24_ + 1;
#line 668 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3396 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '[':
#line 3400 "tracker-sparql-scanner.c"
					{
						gchar* _tmp25_;
#line 670 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp25_ = self->priv->current;
#line 671 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp25_ + 1;
#line 672 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3411 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ']':
#line 3415 "tracker-sparql-scanner.c"
					{
						gchar* _tmp26_;
#line 674 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp26_ = self->priv->current;
#line 675 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp26_ + 1;
#line 676 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3426 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '.':
#line 3430 "tracker-sparql-scanner.c"
					{
						gchar* _tmp27_;
#line 678 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DOT;
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp27_ = self->priv->current;
#line 679 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp27_ + 1;
#line 680 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3441 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ':':
#line 3445 "tracker-sparql-scanner.c"
					{
						gchar* _tmp28_;
						gchar* _tmp35_;
						gchar _tmp36_;
#line 682 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COLON;
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp28_ = self->priv->current;
#line 683 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp28_ + 1;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3458 "tracker-sparql-scanner.c"
							gboolean _tmp29_ = FALSE;
							gchar* _tmp30_;
							gchar* _tmp31_;
							gchar* _tmp34_;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp30_ = self->priv->current;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp31_ = self->priv->end;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp30_ < _tmp31_) {
#line 3469 "tracker-sparql-scanner.c"
								gchar* _tmp32_;
								gchar _tmp33_;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp32_ = self->priv->current;
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp33_ = _tmp32_[0];
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp29_ = tracker_sparql_scanner_is_pn_local_char (self, _tmp33_);
#line 3478 "tracker-sparql-scanner.c"
							} else {
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp29_ = FALSE;
#line 3482 "tracker-sparql-scanner.c"
							}
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp29_) {
#line 684 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3488 "tracker-sparql-scanner.c"
							}
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp34_ = self->priv->current;
#line 685 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp34_ + 1;
#line 3494 "tracker-sparql-scanner.c"
						}
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp35_ = self->priv->current;
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp36_ = _tmp35_[-1];
#line 687 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp36_ == '.') {
#line 3502 "tracker-sparql-scanner.c"
							gchar* _tmp37_;
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp37_ = self->priv->current;
#line 689 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp37_ - 1;
#line 3508 "tracker-sparql-scanner.c"
						}
#line 691 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3512 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ',':
#line 3516 "tracker-sparql-scanner.c"
					{
						gchar* _tmp38_;
#line 693 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_COMMA;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp38_ = self->priv->current;
#line 694 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp38_ + 1;
#line 695 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3527 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case ';':
#line 3531 "tracker-sparql-scanner.c"
					{
						gchar* _tmp39_;
#line 697 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp39_ = self->priv->current;
#line 698 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp39_ + 1;
#line 699 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3542 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '?':
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '$':
#line 3548 "tracker-sparql-scanner.c"
					{
						gchar* _tmp40_;
#line 702 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp40_ = self->priv->current;
#line 703 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp40_ + 1;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 3559 "tracker-sparql-scanner.c"
							gboolean _tmp41_ = FALSE;
							gchar* _tmp42_;
							gchar* _tmp43_;
							gchar* _tmp46_;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp42_ = self->priv->current;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp43_ = self->priv->end;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp42_ < _tmp43_) {
#line 3570 "tracker-sparql-scanner.c"
								gchar* _tmp44_;
								gchar _tmp45_;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp44_ = self->priv->current;
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp45_ = _tmp44_[0];
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp41_ = tracker_sparql_scanner_is_varname_char (self, _tmp45_);
#line 3579 "tracker-sparql-scanner.c"
							} else {
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp41_ = FALSE;
#line 3583 "tracker-sparql-scanner.c"
							}
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp41_) {
#line 704 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3589 "tracker-sparql-scanner.c"
							}
#line 705 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_VAR;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp46_ = self->priv->current;
#line 706 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp46_ + 1;
#line 3597 "tracker-sparql-scanner.c"
						}
#line 708 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3601 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '@':
#line 3605 "tracker-sparql-scanner.c"
					{
						gchar* _tmp47_;
						gboolean _tmp48_ = FALSE;
						gchar* _tmp49_;
						gchar* _tmp50_;
						gint _tmp51_;
						gint _tmp52_;
#line 710 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp47_ = self->priv->current;
#line 711 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp47_ + 1;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp49_ = self->priv->current;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp50_ = self->priv->end;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp51_ = strlen ("prefix");
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp52_ = _tmp51_;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp49_ < (_tmp50_ - _tmp52_)) {
#line 3629 "tracker-sparql-scanner.c"
							gchar* _tmp53_;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp53_ = self->priv->current;
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp48_ = tracker_sparql_scanner_matches (self, _tmp53_, "PREFIX");
#line 3635 "tracker-sparql-scanner.c"
						} else {
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp48_ = FALSE;
#line 3639 "tracker-sparql-scanner.c"
						}
#line 712 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp48_) {
#line 3643 "tracker-sparql-scanner.c"
							gchar* _tmp54_;
							gint _tmp55_;
							gint _tmp56_;
#line 713 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp54_ = self->priv->current;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp55_ = strlen ("prefix");
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp56_ = _tmp55_;
#line 714 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp54_ + _tmp56_;
#line 3657 "tracker-sparql-scanner.c"
						} else {
							gboolean _tmp57_ = FALSE;
							gchar* _tmp58_;
							gchar* _tmp59_;
							gint _tmp60_;
							gint _tmp61_;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp58_ = self->priv->current;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp59_ = self->priv->end;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp60_ = strlen ("base");
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp61_ = _tmp60_;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp58_ < (_tmp59_ - _tmp61_)) {
#line 3674 "tracker-sparql-scanner.c"
								gchar* _tmp62_;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp62_ = self->priv->current;
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp57_ = tracker_sparql_scanner_matches (self, _tmp62_, "BASE");
#line 3680 "tracker-sparql-scanner.c"
							} else {
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp57_ = FALSE;
#line 3684 "tracker-sparql-scanner.c"
							}
#line 715 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp57_) {
#line 3688 "tracker-sparql-scanner.c"
								gchar* _tmp63_;
								gint _tmp64_;
								gint _tmp65_;
#line 716 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_ATBASE;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp63_ = self->priv->current;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp64_ = strlen ("base");
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp65_ = _tmp64_;
#line 717 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp63_ + _tmp65_;
#line 3702 "tracker-sparql-scanner.c"
							}
						}
#line 719 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3707 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '|':
#line 3711 "tracker-sparql-scanner.c"
					{
						gchar* _tmp66_;
						gchar* _tmp67_;
						gchar* _tmp68_;
#line 721 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp66_ = self->priv->current;
#line 722 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp66_ + 1;
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp67_ = self->priv->current;
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp68_ = self->priv->end;
#line 723 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp67_ < _tmp68_) {
#line 3728 "tracker-sparql-scanner.c"
							gchar* _tmp69_;
							gchar _tmp70_;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp69_ = self->priv->current;
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp70_ = _tmp69_[0];
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp70_) {
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '|':
#line 3739 "tracker-sparql-scanner.c"
								{
									gchar* _tmp71_;
#line 726 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_OR;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp71_ = self->priv->current;
#line 727 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp71_ + 1;
#line 728 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3750 "tracker-sparql-scanner.c"
								}
								default:
#line 724 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3755 "tracker-sparql-scanner.c"
							}
						}
#line 731 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3760 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '&':
#line 3764 "tracker-sparql-scanner.c"
					{
						gchar* _tmp72_;
						gchar* _tmp73_;
						gchar* _tmp74_;
#line 733 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp72_ = self->priv->current;
#line 734 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp72_ + 1;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp73_ = self->priv->current;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp74_ = self->priv->end;
#line 735 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp73_ < _tmp74_) {
#line 3781 "tracker-sparql-scanner.c"
							gchar* _tmp75_;
							gchar _tmp76_;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp75_ = self->priv->current;
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp76_ = _tmp75_[0];
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp76_) {
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '&':
#line 3792 "tracker-sparql-scanner.c"
								{
									gchar* _tmp77_;
#line 738 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_AND;
#line 739 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp77_ = self->priv->current;
#line 739 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp77_ + 1;
#line 740 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3803 "tracker-sparql-scanner.c"
								}
								default:
#line 736 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3808 "tracker-sparql-scanner.c"
							}
						}
#line 743 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3813 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '=':
#line 3817 "tracker-sparql-scanner.c"
					{
						gchar* _tmp78_;
#line 745 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_EQ;
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp78_ = self->priv->current;
#line 746 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp78_ + 1;
#line 747 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 3828 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '<':
#line 3832 "tracker-sparql-scanner.c"
					{
						gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
#line 749 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_LT;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp79_ = self->priv->current;
#line 750 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp79_ + 1;
#line 751 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp80_ = self->priv->current;
#line 751 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp81_ = self->priv->end;
#line 751 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp80_ < _tmp81_) {
#line 3849 "tracker-sparql-scanner.c"
							gboolean _tmp95_ = FALSE;
							gchar* _tmp96_;
							gchar* _tmp97_;
							gchar* _tmp102_;
							gchar _tmp103_;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							while (TRUE) {
#line 3857 "tracker-sparql-scanner.c"
								gboolean _tmp82_ = FALSE;
								gchar* _tmp83_;
								gchar* _tmp84_;
								gboolean _tmp87_ = FALSE;
								gchar* _tmp88_;
								gchar _tmp89_;
								gchar* _tmp92_;
								gchar _tmp93_;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp83_ = self->priv->current;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp84_ = self->priv->end;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp83_ < _tmp84_) {
#line 3872 "tracker-sparql-scanner.c"
									gchar* _tmp85_;
									gchar _tmp86_;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp85_ = self->priv->current;
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp86_ = _tmp85_[0];
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp82_ = _tmp86_ != '>';
#line 3881 "tracker-sparql-scanner.c"
								} else {
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp82_ = FALSE;
#line 3885 "tracker-sparql-scanner.c"
								}
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (!_tmp82_) {
#line 753 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3891 "tracker-sparql-scanner.c"
								}
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp88_ = self->priv->current;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp89_ = _tmp88_[0];
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (((gint) _tmp89_) >= 0x00) {
#line 3899 "tracker-sparql-scanner.c"
									gchar* _tmp90_;
									gchar _tmp91_;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp90_ = self->priv->current;
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp91_ = _tmp90_[0];
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp87_ = ((gint) _tmp91_) < 0x20;
#line 3908 "tracker-sparql-scanner.c"
								} else {
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp87_ = FALSE;
#line 3912 "tracker-sparql-scanner.c"
								}
#line 754 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp87_) {
#line 756 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 3918 "tracker-sparql-scanner.c"
								}
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp92_ = self->priv->current;
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp93_ = _tmp92_[0];
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								switch (_tmp93_) {
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '<':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '>':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '"':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case ' ':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '{':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '}':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '|':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '^':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '`':
#line 758 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\\':
#line 3946 "tracker-sparql-scanner.c"
									{
#line 770 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 3950 "tracker-sparql-scanner.c"
									}
									default:
									{
										gchar* _tmp94_;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp94_ = self->priv->current;
#line 772 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp94_ + 1;
#line 773 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										continue;
#line 3961 "tracker-sparql-scanner.c"
									}
								}
#line 775 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 3966 "tracker-sparql-scanner.c"
							}
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp96_ = self->priv->current;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp97_ = self->priv->end;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp96_ < _tmp97_) {
#line 3974 "tracker-sparql-scanner.c"
								gchar* _tmp98_;
								gchar _tmp99_;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp98_ = self->priv->current;
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp99_ = _tmp98_[0];
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp95_ = _tmp99_ == '>';
#line 3983 "tracker-sparql-scanner.c"
							} else {
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp95_ = FALSE;
#line 3987 "tracker-sparql-scanner.c"
							}
#line 777 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp95_) {
#line 3991 "tracker-sparql-scanner.c"
								gchar* _tmp100_;
#line 778 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_IRI_REF;
#line 779 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp100_ = self->priv->current;
#line 779 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp100_ + 1;
#line 780 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4001 "tracker-sparql-scanner.c"
							} else {
								gchar* _tmp101_;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp101_ = begin;
#line 782 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp101_ + 1;
#line 4008 "tracker-sparql-scanner.c"
							}
#line 784 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp102_ = self->priv->current;
#line 784 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp103_ = _tmp102_[0];
#line 784 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							switch (_tmp103_) {
#line 784 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								case '=':
#line 4018 "tracker-sparql-scanner.c"
								{
									gchar* _tmp104_;
#line 786 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									type = TRACKER_SPARQL_TOKEN_TYPE_OP_LE;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp104_ = self->priv->current;
#line 787 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									self->priv->current = _tmp104_ + 1;
#line 788 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4029 "tracker-sparql-scanner.c"
								}
								default:
#line 784 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4034 "tracker-sparql-scanner.c"
							}
						}
#line 791 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4039 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '>':
#line 4043 "tracker-sparql-scanner.c"
					{
						gchar* _tmp105_;
						gboolean _tmp106_ = FALSE;
						gchar* _tmp107_;
						gchar* _tmp108_;
#line 793 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_GT;
#line 794 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp105_ = self->priv->current;
#line 794 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp105_ + 1;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp107_ = self->priv->current;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp108_ = self->priv->end;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp107_ < _tmp108_) {
#line 4061 "tracker-sparql-scanner.c"
							gchar* _tmp109_;
							gchar _tmp110_;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp109_ = self->priv->current;
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp110_ = _tmp109_[0];
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp106_ = _tmp110_ == '=';
#line 4070 "tracker-sparql-scanner.c"
						} else {
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp106_ = FALSE;
#line 4074 "tracker-sparql-scanner.c"
						}
#line 795 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp106_) {
#line 4078 "tracker-sparql-scanner.c"
							gchar* _tmp111_;
#line 796 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_GE;
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp111_ = self->priv->current;
#line 797 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp111_ + 1;
#line 4086 "tracker-sparql-scanner.c"
						}
#line 799 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4090 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '!':
#line 4094 "tracker-sparql-scanner.c"
					{
						gchar* _tmp112_;
						gboolean _tmp113_ = FALSE;
						gchar* _tmp114_;
						gchar* _tmp115_;
#line 801 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_OP_NEG;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp112_ = self->priv->current;
#line 802 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp112_ + 1;
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp114_ = self->priv->current;
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp115_ = self->priv->end;
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp114_ < _tmp115_) {
#line 4112 "tracker-sparql-scanner.c"
							gchar* _tmp116_;
							gchar _tmp117_;
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp116_ = self->priv->current;
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp117_ = _tmp116_[0];
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp113_ = _tmp117_ == '=';
#line 4121 "tracker-sparql-scanner.c"
						} else {
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp113_ = FALSE;
#line 4125 "tracker-sparql-scanner.c"
						}
#line 803 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp113_) {
#line 4129 "tracker-sparql-scanner.c"
							gchar* _tmp118_;
#line 804 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_OP_NE;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp118_ = self->priv->current;
#line 805 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp118_ + 1;
#line 4137 "tracker-sparql-scanner.c"
						}
#line 807 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4141 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '+':
#line 4145 "tracker-sparql-scanner.c"
					{
						gchar* _tmp119_;
#line 809 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_PLUS;
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp119_ = self->priv->current;
#line 810 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp119_ + 1;
#line 811 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4156 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '-':
#line 4160 "tracker-sparql-scanner.c"
					{
						gchar* _tmp120_;
#line 813 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_MINUS;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp120_ = self->priv->current;
#line 814 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp120_ + 1;
#line 815 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4171 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '*':
#line 4175 "tracker-sparql-scanner.c"
					{
						gchar* _tmp121_;
#line 817 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_STAR;
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp121_ = self->priv->current;
#line 818 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp121_ + 1;
#line 819 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4186 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '/':
#line 4190 "tracker-sparql-scanner.c"
					{
						gchar* _tmp122_;
#line 821 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_DIV;
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp122_ = self->priv->current;
#line 822 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp122_ + 1;
#line 823 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 4201 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '\'':
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '"':
#line 4207 "tracker-sparql-scanner.c"
					{
						gboolean _tmp123_ = FALSE;
						gboolean _tmp124_ = FALSE;
						gchar* _tmp125_;
						gchar* _tmp126_;
						gchar* _tmp192_;
						gchar _tmp193_;
						gchar* _tmp194_;
						gboolean _tmp250_ = FALSE;
						gchar* _tmp251_;
						gchar* _tmp252_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp125_ = self->priv->current;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp126_ = self->priv->end;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp125_ < (_tmp126_ - 6)) {
#line 4225 "tracker-sparql-scanner.c"
							gchar* _tmp127_;
							gchar _tmp128_;
							gchar* _tmp129_;
							gchar _tmp130_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp127_ = begin;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp128_ = _tmp127_[1];
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp129_ = begin;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp130_ = _tmp129_[0];
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp124_ = _tmp128_ == _tmp130_;
#line 4240 "tracker-sparql-scanner.c"
						} else {
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp124_ = FALSE;
#line 4244 "tracker-sparql-scanner.c"
						}
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp124_) {
#line 4248 "tracker-sparql-scanner.c"
							gchar* _tmp131_;
							gchar _tmp132_;
							gchar* _tmp133_;
							gchar _tmp134_;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp131_ = begin;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp132_ = _tmp131_[2];
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp133_ = begin;
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp134_ = _tmp133_[0];
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp123_ = _tmp132_ == _tmp134_;
#line 4263 "tracker-sparql-scanner.c"
						} else {
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp123_ = FALSE;
#line 4267 "tracker-sparql-scanner.c"
						}
#line 826 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp123_) {
#line 4271 "tracker-sparql-scanner.c"
							gchar* _tmp135_;
							gchar _tmp136_;
							gchar* _tmp137_;
							gboolean _tmp173_ = FALSE;
							gboolean _tmp174_ = FALSE;
							gchar* _tmp175_;
							gchar _tmp176_;
							gchar* _tmp177_;
							gchar _tmp178_;
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp135_ = begin;
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp136_ = _tmp135_[0];
#line 827 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp136_ == '\'') {
#line 828 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1;
#line 4289 "tracker-sparql-scanner.c"
							} else {
#line 830 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2;
#line 4293 "tracker-sparql-scanner.c"
							}
#line 833 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							token_length_in_chars = 6;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp137_ = self->priv->current;
#line 834 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp137_ + 3;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							while (TRUE) {
#line 4303 "tracker-sparql-scanner.c"
								gchar* _tmp138_;
								gchar* _tmp139_;
								gboolean _tmp140_ = FALSE;
								gboolean _tmp141_ = FALSE;
								gchar* _tmp142_;
								gchar _tmp143_;
								gchar* _tmp144_;
								gchar _tmp145_;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp138_ = self->priv->current;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp139_ = self->priv->end;
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (!(_tmp138_ < (_tmp139_ - 4))) {
#line 835 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4320 "tracker-sparql-scanner.c"
								}
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp142_ = self->priv->current;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp143_ = _tmp142_[0];
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp144_ = begin;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp145_ = _tmp144_[0];
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp143_ == _tmp145_) {
#line 4332 "tracker-sparql-scanner.c"
									gchar* _tmp146_;
									gchar _tmp147_;
									gchar* _tmp148_;
									gchar _tmp149_;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp146_ = self->priv->current;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp147_ = _tmp146_[1];
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp148_ = begin;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp149_ = _tmp148_[0];
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp141_ = _tmp147_ == _tmp149_;
#line 4347 "tracker-sparql-scanner.c"
								} else {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp141_ = FALSE;
#line 4351 "tracker-sparql-scanner.c"
								}
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp141_) {
#line 4355 "tracker-sparql-scanner.c"
									gchar* _tmp150_;
									gchar _tmp151_;
									gchar* _tmp152_;
									gchar _tmp153_;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp150_ = self->priv->current;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp151_ = _tmp150_[2];
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp152_ = begin;
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp153_ = _tmp152_[0];
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp140_ = _tmp151_ == _tmp153_;
#line 4370 "tracker-sparql-scanner.c"
								} else {
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp140_ = FALSE;
#line 4374 "tracker-sparql-scanner.c"
								}
#line 836 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp140_) {
#line 837 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4380 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp154_;
									gchar _tmp155_;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp154_ = self->priv->current;
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp155_ = _tmp154_[0];
#line 838 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (_tmp155_ == '\n') {
#line 4390 "tracker-sparql-scanner.c"
										gchar* _tmp156_;
										gint _tmp157_;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp156_ = self->priv->current;
#line 839 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp156_ + 1;
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp157_ = self->priv->line;
#line 840 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->line = _tmp157_ + 1;
#line 841 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->column = 1;
#line 842 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = 3;
#line 4405 "tracker-sparql-scanner.c"
									} else {
										gchar* _tmp158_;
										gchar _tmp159_;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp158_ = self->priv->current;
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp159_ = _tmp158_[0];
#line 843 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (((gint) ((guchar) _tmp159_)) <= 0x7f) {
#line 4415 "tracker-sparql-scanner.c"
											gchar* _tmp160_;
											gint _tmp161_;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp160_ = self->priv->current;
#line 845 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp160_ + 1;
#line 846 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp161_ = token_length_in_chars;
#line 846 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp161_ + 1;
#line 4426 "tracker-sparql-scanner.c"
										} else {
											gunichar u = 0U;
											gchar* _tmp162_;
											gchar* _tmp163_;
											gchar* _tmp164_;
											gunichar _tmp165_;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp162_ = self->priv->current;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp163_ = self->priv->end;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp164_ = self->priv->current;
#line 848 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											u = g_utf8_get_char_validated ((const gchar*) _tmp162_, (gssize) ((glong) (_tmp163_ - _tmp164_)));
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp165_ = u;
#line 849 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											if (_tmp165_ != ((gunichar) -1)) {
#line 4445 "tracker-sparql-scanner.c"
												gchar* _tmp166_;
												gunichar _tmp167_;
												gint _tmp168_;
#line 850 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp166_ = self->priv->current;
#line 850 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp167_ = u;
#line 850 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												self->priv->current = _tmp166_ + g_unichar_to_utf8 (_tmp167_, NULL);
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp168_ = token_length_in_chars;
#line 851 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												token_length_in_chars = _tmp168_ + 1;
#line 4459 "tracker-sparql-scanner.c"
											} else {
												gint _tmp169_;
												gint _tmp170_;
												gint _tmp171_;
												GError* _tmp172_;
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp169_ = self->priv->line;
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp170_ = self->priv->column;
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp171_ = token_length_in_chars;
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp172_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp169_, _tmp170_ + _tmp171_);
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_inner_error_ = _tmp172_;
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_propagate_error (error, _inner_error_);
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													return 0;
#line 4481 "tracker-sparql-scanner.c"
												} else {
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													g_clear_error (&_inner_error_);
#line 853 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													return 0;
#line 4489 "tracker-sparql-scanner.c"
												}
											}
										}
									}
								}
							}
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp175_ = self->priv->current;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp176_ = _tmp175_[0];
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp177_ = begin;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp178_ = _tmp177_[0];
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp176_ == _tmp178_) {
#line 4506 "tracker-sparql-scanner.c"
								gchar* _tmp179_;
								gchar _tmp180_;
								gchar* _tmp181_;
								gchar _tmp182_;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp179_ = self->priv->current;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp180_ = _tmp179_[1];
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp181_ = begin;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp182_ = _tmp181_[0];
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp174_ = _tmp180_ == _tmp182_;
#line 4521 "tracker-sparql-scanner.c"
							} else {
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp174_ = FALSE;
#line 4525 "tracker-sparql-scanner.c"
							}
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp174_) {
#line 4529 "tracker-sparql-scanner.c"
								gchar* _tmp183_;
								gchar _tmp184_;
								gchar* _tmp185_;
								gchar _tmp186_;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp183_ = self->priv->current;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp184_ = _tmp183_[2];
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp185_ = begin;
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp186_ = _tmp185_[0];
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp173_ = _tmp184_ == _tmp186_;
#line 4544 "tracker-sparql-scanner.c"
							} else {
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp173_ = FALSE;
#line 4548 "tracker-sparql-scanner.c"
							}
#line 857 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp173_) {
#line 4552 "tracker-sparql-scanner.c"
								gchar* _tmp187_;
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp187_ = self->priv->current;
#line 858 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp187_ + 3;
#line 4558 "tracker-sparql-scanner.c"
							} else {
								gint _tmp188_;
								gint _tmp189_;
								gint _tmp190_;
								GError* _tmp191_;
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp188_ = self->priv->line;
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp189_ = self->priv->column;
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp190_ = token_length_in_chars;
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp191_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected \"\"\"", _tmp188_, _tmp189_ + _tmp190_);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_inner_error_ = _tmp191_;
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_propagate_error (error, _inner_error_);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									return 0;
#line 4580 "tracker-sparql-scanner.c"
								} else {
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									g_clear_error (&_inner_error_);
#line 860 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									return 0;
#line 4588 "tracker-sparql-scanner.c"
								}
							}
#line 862 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							break;
#line 4593 "tracker-sparql-scanner.c"
						}
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp192_ = begin;
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp193_ = _tmp192_[0];
#line 865 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp193_ == '\'') {
#line 866 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1;
#line 4603 "tracker-sparql-scanner.c"
						} else {
#line 868 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2;
#line 4607 "tracker-sparql-scanner.c"
						}
#line 871 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						token_length_in_chars = 2;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp194_ = self->priv->current;
#line 872 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp194_ + 1;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						while (TRUE) {
#line 4617 "tracker-sparql-scanner.c"
							gboolean _tmp195_ = FALSE;
							gchar* _tmp196_;
							gchar* _tmp197_;
							gchar* _tmp202_;
							gchar _tmp203_;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp196_ = self->priv->current;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp197_ = self->priv->end;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp196_ < _tmp197_) {
#line 4629 "tracker-sparql-scanner.c"
								gchar* _tmp198_;
								gchar _tmp199_;
								gchar* _tmp200_;
								gchar _tmp201_;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp198_ = self->priv->current;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp199_ = _tmp198_[0];
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp200_ = begin;
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp201_ = _tmp200_[0];
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp195_ = _tmp199_ != _tmp201_;
#line 4644 "tracker-sparql-scanner.c"
							} else {
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp195_ = FALSE;
#line 4648 "tracker-sparql-scanner.c"
							}
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (!_tmp195_) {
#line 873 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								break;
#line 4654 "tracker-sparql-scanner.c"
							}
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp202_ = self->priv->current;
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp203_ = _tmp202_[0];
#line 874 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_tmp203_ == '\\') {
#line 4662 "tracker-sparql-scanner.c"
								gchar* _tmp204_;
								gint _tmp205_;
								gchar* _tmp206_;
								gchar* _tmp207_;
								gchar* _tmp208_;
								gchar _tmp209_;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp204_ = self->priv->current;
#line 875 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								self->priv->current = _tmp204_ + 1;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp205_ = token_length_in_chars;
#line 876 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								token_length_in_chars = _tmp205_ + 1;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp206_ = self->priv->current;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp207_ = self->priv->end;
#line 877 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp206_ >= _tmp207_) {
#line 878 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4685 "tracker-sparql-scanner.c"
								}
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp208_ = self->priv->current;
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp209_ = _tmp208_[0];
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								switch (_tmp209_) {
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\'':
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '"':
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case '\\':
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'b':
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'f':
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'n':
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'r':
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 't':
#line 4709 "tracker-sparql-scanner.c"
									{
										gchar* _tmp210_;
										gint _tmp211_;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp210_ = self->priv->current;
#line 890 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp210_ + 1;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp211_ = token_length_in_chars;
#line 891 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp211_ + 1;
#line 892 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 4723 "tracker-sparql-scanner.c"
									}
#line 881 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									case 'u':
#line 4727 "tracker-sparql-scanner.c"
									{
										gchar* _tmp226_;
										gint _tmp227_;
										{
											gint i = 0;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											i = 0;
#line 4735 "tracker-sparql-scanner.c"
											{
												gboolean _tmp212_ = FALSE;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												_tmp212_ = TRUE;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												while (TRUE) {
#line 4742 "tracker-sparql-scanner.c"
													gint _tmp214_;
													gboolean _tmp215_ = FALSE;
													gchar* _tmp216_;
													gint _tmp217_;
													gchar* _tmp218_;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (!_tmp212_) {
#line 4750 "tracker-sparql-scanner.c"
														gint _tmp213_;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp213_ = i;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														i = _tmp213_ + 1;
#line 4756 "tracker-sparql-scanner.c"
													}
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp212_ = FALSE;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp214_ = i;
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (!(_tmp214_ < 4)) {
#line 894 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														break;
#line 4766 "tracker-sparql-scanner.c"
													}
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp216_ = self->priv->current;
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp217_ = i;
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													_tmp218_ = self->priv->end;
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (((_tmp216_ + _tmp217_) + 1) >= _tmp218_) {
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp215_ = TRUE;
#line 4778 "tracker-sparql-scanner.c"
													} else {
														gchar* _tmp219_;
														gint _tmp220_;
														gchar _tmp221_;
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp219_ = self->priv->current;
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp220_ = i;
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp221_ = _tmp219_[_tmp220_ + 1];
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp215_ = !g_ascii_isxdigit (_tmp221_);
#line 4791 "tracker-sparql-scanner.c"
													}
#line 895 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
													if (_tmp215_) {
#line 4795 "tracker-sparql-scanner.c"
														gint _tmp222_;
														gint _tmp223_;
														gint _tmp224_;
														GError* _tmp225_;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp222_ = self->priv->line;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp223_ = self->priv->column;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp224_ = token_length_in_chars;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_tmp225_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", _tmp222_, _tmp223_ + _tmp224_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														_inner_error_ = _tmp225_;
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
														if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_propagate_error (error, _inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															return 0;
#line 4816 "tracker-sparql-scanner.c"
														} else {
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															g_clear_error (&_inner_error_);
#line 896 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
															return 0;
#line 4824 "tracker-sparql-scanner.c"
														}
													}
												}
											}
										}
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp226_ = self->priv->current;
#line 899 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp226_ + 5;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp227_ = token_length_in_chars;
#line 900 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp227_ + 5;
#line 901 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										break;
#line 4840 "tracker-sparql-scanner.c"
									}
									default:
									{
										gint _tmp228_;
										gint _tmp229_;
										gint _tmp230_;
										GError* _tmp231_;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp228_ = self->priv->line;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp229_ = self->priv->column;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp230_ = token_length_in_chars;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp231_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid escape sequence", _tmp228_, _tmp229_ + _tmp230_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_inner_error_ = _tmp231_;
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_propagate_error (error, _inner_error_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											return 0;
#line 4864 "tracker-sparql-scanner.c"
										} else {
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											g_clear_error (&_inner_error_);
#line 903 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											return 0;
#line 4872 "tracker-sparql-scanner.c"
										}
									}
								}
							} else {
								gchar* _tmp232_;
								gchar _tmp233_;
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp232_ = self->priv->current;
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								_tmp233_ = _tmp232_[0];
#line 905 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								if (_tmp233_ == '\n') {
#line 906 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									break;
#line 4887 "tracker-sparql-scanner.c"
								} else {
									gchar* _tmp234_;
									gchar _tmp235_;
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp234_ = self->priv->current;
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									_tmp235_ = _tmp234_[0];
#line 907 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
									if (((gint) ((guchar) _tmp235_)) <= 0x7f) {
#line 4897 "tracker-sparql-scanner.c"
										gchar* _tmp236_;
										gint _tmp237_;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp236_ = self->priv->current;
#line 909 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										self->priv->current = _tmp236_ + 1;
#line 910 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp237_ = token_length_in_chars;
#line 910 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										token_length_in_chars = _tmp237_ + 1;
#line 4908 "tracker-sparql-scanner.c"
									} else {
										gunichar u = 0U;
										gchar* _tmp238_;
										gchar* _tmp239_;
										gchar* _tmp240_;
										gunichar _tmp241_;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp238_ = self->priv->current;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp239_ = self->priv->end;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp240_ = self->priv->current;
#line 912 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										u = g_utf8_get_char_validated ((const gchar*) _tmp238_, (gssize) ((glong) (_tmp239_ - _tmp240_)));
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										_tmp241_ = u;
#line 913 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
										if (_tmp241_ != ((gunichar) -1)) {
#line 4927 "tracker-sparql-scanner.c"
											gchar* _tmp242_;
											gunichar _tmp243_;
											gint _tmp244_;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp242_ = self->priv->current;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp243_ = u;
#line 914 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp242_ + g_unichar_to_utf8 (_tmp243_, NULL);
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp244_ = token_length_in_chars;
#line 915 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											token_length_in_chars = _tmp244_ + 1;
#line 4941 "tracker-sparql-scanner.c"
										} else {
											gchar* _tmp245_;
											gint _tmp246_;
											gint _tmp247_;
											gint _tmp248_;
											GError* _tmp249_;
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp245_ = self->priv->current;
#line 917 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											self->priv->current = _tmp245_ + 1;
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp246_ = self->priv->line;
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp247_ = self->priv->column;
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp248_ = token_length_in_chars;
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_tmp249_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp246_, _tmp247_ + _tmp248_);
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											_inner_error_ = _tmp249_;
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
											if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_propagate_error (error, _inner_error_);
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												return 0;
#line 4968 "tracker-sparql-scanner.c"
											} else {
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												g_clear_error (&_inner_error_);
#line 918 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
												return 0;
#line 4976 "tracker-sparql-scanner.c"
											}
										}
									}
								}
							}
						}
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp251_ = self->priv->current;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp252_ = self->priv->end;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp251_ < _tmp252_) {
#line 4989 "tracker-sparql-scanner.c"
							gchar* _tmp253_;
							gchar _tmp254_;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp253_ = self->priv->current;
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp254_ = _tmp253_[0];
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp250_ = _tmp254_ != '\n';
#line 4998 "tracker-sparql-scanner.c"
						} else {
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp250_ = FALSE;
#line 5002 "tracker-sparql-scanner.c"
						}
#line 922 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp250_) {
#line 5006 "tracker-sparql-scanner.c"
							gchar* _tmp255_;
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp255_ = self->priv->current;
#line 923 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp255_ + 1;
#line 5012 "tracker-sparql-scanner.c"
						} else {
							gint _tmp256_;
							gint _tmp257_;
							gint _tmp258_;
							gchar* _tmp259_;
							gchar _tmp260_;
							GError* _tmp261_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp256_ = self->priv->line;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp257_ = self->priv->column;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp258_ = token_length_in_chars;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp259_ = begin;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp260_ = _tmp259_[0];
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp261_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, expected %c", _tmp256_, _tmp257_ + _tmp258_, (gint) _tmp260_);
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp261_;
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5040 "tracker-sparql-scanner.c"
							} else {
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 925 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5048 "tracker-sparql-scanner.c"
							}
						}
#line 927 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 5053 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '^':
#line 5057 "tracker-sparql-scanner.c"
					{
						gboolean _tmp262_ = FALSE;
						gchar* _tmp263_;
						gchar* _tmp264_;
#line 929 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_NONE;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp263_ = self->priv->current;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp264_ = self->priv->end;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp263_ < (_tmp264_ - 2)) {
#line 5070 "tracker-sparql-scanner.c"
							gchar* _tmp265_;
							gchar _tmp266_;
							gchar* _tmp267_;
							gchar _tmp268_;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp265_ = self->priv->current;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp266_ = _tmp265_[0];
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp267_ = self->priv->current;
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp268_ = _tmp267_[1];
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp262_ = _tmp266_ == _tmp268_;
#line 5085 "tracker-sparql-scanner.c"
						} else {
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp262_ = FALSE;
#line 5089 "tracker-sparql-scanner.c"
						}
#line 930 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp262_) {
#line 5093 "tracker-sparql-scanner.c"
							gchar* _tmp269_;
#line 931 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							type = TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp269_ = self->priv->current;
#line 932 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							self->priv->current = _tmp269_ + 2;
#line 5101 "tracker-sparql-scanner.c"
						} else {
							gint _tmp270_;
							gint _tmp271_;
							GError* _tmp272_;
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp270_ = self->priv->line;
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp271_ = self->priv->column;
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp272_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", _tmp270_, _tmp271_);
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp272_;
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5120 "tracker-sparql-scanner.c"
							} else {
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 934 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5128 "tracker-sparql-scanner.c"
							}
						}
#line 936 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 5133 "tracker-sparql-scanner.c"
					}
#line 652 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					case '_':
#line 5137 "tracker-sparql-scanner.c"
					{
						gchar* _tmp273_;
#line 938 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						type = TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE;
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp273_ = self->priv->current;
#line 939 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						self->priv->current = _tmp273_ + 1;
#line 940 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						break;
#line 5148 "tracker-sparql-scanner.c"
					}
					default:
					{
						gunichar u = 0U;
						gchar* _tmp274_;
						gchar* _tmp275_;
						gchar* _tmp276_;
						gunichar _tmp277_;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp274_ = self->priv->current;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp275_ = self->priv->end;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp276_ = self->priv->current;
#line 942 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						u = g_utf8_get_char_validated ((const gchar*) _tmp274_, (gssize) ((glong) (_tmp275_ - _tmp276_)));
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						_tmp277_ = u;
#line 943 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
						if (_tmp277_ != ((gunichar) -1)) {
#line 5169 "tracker-sparql-scanner.c"
							gint _tmp278_;
							gint _tmp279_;
							GError* _tmp280_;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp278_ = self->priv->line;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp279_ = self->priv->column;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp280_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: syntax error, unexpected character", _tmp278_, _tmp279_);
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp280_;
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5187 "tracker-sparql-scanner.c"
							} else {
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 944 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5195 "tracker-sparql-scanner.c"
							}
						} else {
							gint _tmp281_;
							gint _tmp282_;
							GError* _tmp283_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp281_ = self->priv->line;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp282_ = self->priv->column;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_tmp283_ = g_error_new (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_PARSE, "%d.%d: invalid UTF-8 character", _tmp281_, _tmp282_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							_inner_error_ = _tmp283_;
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
							if (_inner_error_->domain == TRACKER_SPARQL_ERROR) {
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_propagate_error (error, _inner_error_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5215 "tracker-sparql-scanner.c"
							} else {
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								g_clear_error (&_inner_error_);
#line 946 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
								return 0;
#line 5223 "tracker-sparql-scanner.c"
							}
						}
					}
				}
			}
		}
	}
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp284_ = token_length_in_chars;
#line 951 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp284_ < 0) {
#line 5235 "tracker-sparql-scanner.c"
		gint _tmp285_;
		gchar* _tmp286_;
		gchar* _tmp287_;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp285_ = self->priv->column;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp286_ = self->priv->current;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp287_ = begin;
#line 952 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp285_ + ((gint) (_tmp286_ - _tmp287_));
#line 5247 "tracker-sparql-scanner.c"
	} else {
		gint _tmp288_;
		gint _tmp289_;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp288_ = self->priv->column;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp289_ = token_length_in_chars;
#line 954 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp288_ + _tmp289_;
#line 5257 "tracker-sparql-scanner.c"
	}
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp290_ = self->priv->current;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp291_ = self->priv->line;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp292_ = self->priv->column;
#line 957 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_source_location_init (&_vala_token_end, _tmp290_, _tmp291_, _tmp292_ - 1);
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = type;
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_begin) {
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		*token_begin = _vala_token_begin;
#line 5273 "tracker-sparql-scanner.c"
	}
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (token_end) {
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		*token_end = _vala_token_end;
#line 5279 "tracker-sparql-scanner.c"
	}
#line 959 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5283 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_matches (TrackerSparqlScanner* self,
                                gchar* begin,
                                const gchar* keyword)
{
	gboolean result = FALSE;
	gchar* keyword_array = NULL;
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 962 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (keyword != NULL, FALSE);
#line 963 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	keyword_array = (gchar*) keyword;
#line 5300 "tracker-sparql-scanner.c"
	{
		gint i = 0;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		i = 0;
#line 5305 "tracker-sparql-scanner.c"
		{
			gboolean _tmp0_ = FALSE;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = TRUE;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			while (TRUE) {
#line 5312 "tracker-sparql-scanner.c"
				gchar* _tmp2_;
				gint _tmp3_;
				gchar _tmp4_;
				gint _tmp5_;
				gchar _tmp6_;
				gchar* _tmp7_;
				gint _tmp8_;
				gchar _tmp9_;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!_tmp0_) {
#line 5323 "tracker-sparql-scanner.c"
					gint _tmp1_;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					_tmp1_ = i;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					i = _tmp1_ + 1;
#line 5329 "tracker-sparql-scanner.c"
				}
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp0_ = FALSE;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp2_ = keyword_array;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp3_ = i;
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp4_ = _tmp2_[_tmp3_];
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (!(((gint) _tmp4_) != 0)) {
#line 964 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					break;
#line 5343 "tracker-sparql-scanner.c"
				}
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp5_ = i;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp6_ = begin[_tmp5_];
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp7_ = keyword_array;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp8_ = i;
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				_tmp9_ = _tmp7_[_tmp8_];
#line 965 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
				if (g_ascii_toupper (_tmp6_) != _tmp9_) {
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					result = FALSE;
#line 966 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
					return result;
#line 5361 "tracker-sparql-scanner.c"
				}
			}
		}
	}
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRUE;
#line 969 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5370 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_whitespace (TrackerSparqlScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
#line 972 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 973 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	found = FALSE;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5385 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gchar _tmp6_;
		gchar* _tmp8_;
		gint _tmp9_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp1_ = self->priv->current;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp2_ = self->priv->end;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp1_ < _tmp2_) {
#line 5399 "tracker-sparql-scanner.c"
			gchar* _tmp3_;
			gchar _tmp4_;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp3_ = self->priv->current;
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp4_ = _tmp3_[0];
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = g_ascii_isspace (_tmp4_);
#line 5408 "tracker-sparql-scanner.c"
		} else {
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = FALSE;
#line 5412 "tracker-sparql-scanner.c"
		}
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp0_) {
#line 974 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5418 "tracker-sparql-scanner.c"
		}
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp5_ = self->priv->current;
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = _tmp5_[0];
#line 975 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp6_ == '\n') {
#line 5426 "tracker-sparql-scanner.c"
			gint _tmp7_;
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp7_ = self->priv->line;
#line 976 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->line = _tmp7_ + 1;
#line 977 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			self->priv->column = 0;
#line 5434 "tracker-sparql-scanner.c"
		}
#line 979 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		found = TRUE;
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp8_ = self->priv->current;
#line 980 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp8_ + 1;
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp9_ = self->priv->column;
#line 981 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->column = _tmp9_ + 1;
#line 5446 "tracker-sparql-scanner.c"
	}
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = found;
#line 983 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5452 "tracker-sparql-scanner.c"
}


static gboolean
tracker_sparql_scanner_comment (TrackerSparqlScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 986 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp1_ = self->priv->current;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	_tmp2_ = self->priv->end;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp1_ >= _tmp2_) {
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = TRUE;
#line 5473 "tracker-sparql-scanner.c"
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp3_ = self->priv->current;
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp4_ = _tmp3_[0];
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp0_ = _tmp4_ != '#';
#line 5483 "tracker-sparql-scanner.c"
	}
#line 987 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	if (_tmp0_) {
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		result = FALSE;
#line 988 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		return result;
#line 5491 "tracker-sparql-scanner.c"
	}
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5495 "tracker-sparql-scanner.c"
		gboolean _tmp5_ = FALSE;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp10_;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp6_ = self->priv->current;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp7_ = self->priv->end;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (_tmp6_ < _tmp7_) {
#line 5506 "tracker-sparql-scanner.c"
			gchar* _tmp8_;
			gchar _tmp9_;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp8_ = self->priv->current;
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp9_ = _tmp8_[0];
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp5_ = _tmp9_ != '\n';
#line 5515 "tracker-sparql-scanner.c"
		} else {
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp5_ = FALSE;
#line 5519 "tracker-sparql-scanner.c"
		}
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp5_) {
#line 993 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5525 "tracker-sparql-scanner.c"
		}
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		_tmp10_ = self->priv->current;
#line 994 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		self->priv->current = _tmp10_ + 1;
#line 5531 "tracker-sparql-scanner.c"
	}
#line 997 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	result = TRUE;
#line 997 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return result;
#line 5537 "tracker-sparql-scanner.c"
}


static void
tracker_sparql_scanner_space (TrackerSparqlScanner* self)
{
#line 1000 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_return_if_fail (self != NULL);
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	while (TRUE) {
#line 5548 "tracker-sparql-scanner.c"
		gboolean _tmp0_ = FALSE;
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (tracker_sparql_scanner_whitespace (self)) {
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = TRUE;
#line 5554 "tracker-sparql-scanner.c"
		} else {
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			_tmp0_ = tracker_sparql_scanner_comment (self);
#line 5558 "tracker-sparql-scanner.c"
		}
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		if (!_tmp0_) {
#line 1001 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			break;
#line 5564 "tracker-sparql-scanner.c"
		}
	}
}


static void
tracker_sparql_scanner_class_init (TrackerSparqlScannerClass * klass)
{
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	tracker_sparql_scanner_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_type_class_add_private (klass, sizeof (TrackerSparqlScannerPrivate));
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (klass)->finalize = tracker_sparql_scanner_finalize;
#line 5579 "tracker-sparql-scanner.c"
}


static void
tracker_sparql_scanner_instance_init (TrackerSparqlScanner * self)
{
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self->priv = TRACKER_SPARQL_SCANNER_GET_PRIVATE (self);
#line 5588 "tracker-sparql-scanner.c"
}


static void
tracker_sparql_scanner_finalize (GObject * obj)
{
	TrackerSparqlScanner * self;
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_SPARQL_SCANNER, TrackerSparqlScanner);
#line 20 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	G_OBJECT_CLASS (tracker_sparql_scanner_parent_class)->finalize (obj);
#line 5600 "tracker-sparql-scanner.c"
}


GType
tracker_sparql_scanner_get_type (void)
{
	static volatile gsize tracker_sparql_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerSparqlScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_sparql_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerSparqlScanner), 0, (GInstanceInitFunc) tracker_sparql_scanner_instance_init, NULL };
		GType tracker_sparql_scanner_type_id;
		tracker_sparql_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerSparqlScanner", &g_define_type_info, 0);
		g_once_init_leave (&tracker_sparql_scanner_type_id__volatile, tracker_sparql_scanner_type_id);
	}
	return tracker_sparql_scanner_type_id__volatile;
}


void
tracker_source_location_init (TrackerSourceLocation *self,
                              gchar* pos,
                              gint line,
                              gint column)
{
#line 1014 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	memset (self, 0, sizeof (TrackerSourceLocation));
#line 1015 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).pos = pos;
#line 1016 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).line = line;
#line 1017 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	(*self).column = column;
#line 5632 "tracker-sparql-scanner.c"
}


TrackerSourceLocation*
tracker_source_location_dup (const TrackerSourceLocation* self)
{
	TrackerSourceLocation* dup;
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	dup = g_new0 (TrackerSourceLocation, 1);
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	memcpy (dup, self, sizeof (TrackerSourceLocation));
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	return dup;
#line 5646 "tracker-sparql-scanner.c"
}


void
tracker_source_location_free (TrackerSourceLocation* self)
{
#line 1009 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	g_free (self);
#line 5655 "tracker-sparql-scanner.c"
}


GType
tracker_source_location_get_type (void)
{
	static volatile gsize tracker_source_location_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_source_location_type_id__volatile)) {
		GType tracker_source_location_type_id;
		tracker_source_location_type_id = g_boxed_type_register_static ("TrackerSourceLocation", (GBoxedCopyFunc) tracker_source_location_dup, (GBoxedFreeFunc) tracker_source_location_free);
		g_once_init_leave (&tracker_source_location_type_id__volatile, tracker_source_location_type_id);
	}
	return tracker_source_location_type_id__volatile;
}


const gchar*
tracker_sparql_token_type_to_string (TrackerSparqlTokenType self)
{
	const gchar* result = NULL;
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
	switch (self) {
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_A:
#line 5680 "tracker-sparql-scanner.c"
		{
#line 1151 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`a'";
#line 1151 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5686 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ABS:
#line 5690 "tracker-sparql-scanner.c"
		{
#line 1152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ABS'";
#line 1152 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5696 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AS:
#line 5700 "tracker-sparql-scanner.c"
		{
#line 1153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`AS'";
#line 1153 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5706 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASC:
#line 5710 "tracker-sparql-scanner.c"
		{
#line 1154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ASC'";
#line 1154 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5716 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ASK:
#line 5720 "tracker-sparql-scanner.c"
		{
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ASK'";
#line 1155 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5726 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATBASE:
#line 5730 "tracker-sparql-scanner.c"
		{
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`@base'";
#line 1156 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5736 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX:
#line 5740 "tracker-sparql-scanner.c"
		{
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`@prefix'";
#line 1157 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5746 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_AVG:
#line 5750 "tracker-sparql-scanner.c"
		{
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`AVG'";
#line 1158 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5756 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BASE:
#line 5760 "tracker-sparql-scanner.c"
		{
#line 1159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BASE'";
#line 1159 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5766 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE:
#line 5770 "tracker-sparql-scanner.c"
		{
#line 1160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "blank node";
#line 1160 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5776 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BIND:
#line 5780 "tracker-sparql-scanner.c"
		{
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BIND'";
#line 1161 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5786 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BOUND:
#line 5790 "tracker-sparql-scanner.c"
		{
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BOUND'";
#line 1162 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5796 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_BY:
#line 5800 "tracker-sparql-scanner.c"
		{
#line 1163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`BY'";
#line 1163 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5806 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CEIL:
#line 5810 "tracker-sparql-scanner.c"
		{
#line 1164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CEIL'";
#line 1164 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5816 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE:
#line 5820 "tracker-sparql-scanner.c"
		{
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`}'";
#line 1165 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5826 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET:
#line 5830 "tracker-sparql-scanner.c"
		{
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`]'";
#line 1166 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5836 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS:
#line 5840 "tracker-sparql-scanner.c"
		{
#line 1167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`)'";
#line 1167 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5846 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COALESCE:
#line 5850 "tracker-sparql-scanner.c"
		{
#line 1168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`COALESCE'";
#line 1168 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5856 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COLON:
#line 5860 "tracker-sparql-scanner.c"
		{
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`:'";
#line 1169 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5866 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONCAT:
#line 5870 "tracker-sparql-scanner.c"
		{
#line 1170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONCAT'";
#line 1170 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5876 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONTAINS:
#line 5880 "tracker-sparql-scanner.c"
		{
#line 1171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONTAINS'";
#line 1171 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5886 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COMMA:
#line 5890 "tracker-sparql-scanner.c"
		{
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`,'";
#line 1172 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5896 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT:
#line 5900 "tracker-sparql-scanner.c"
		{
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`CONSTRUCT'";
#line 1173 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5906 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_COUNT:
#line 5910 "tracker-sparql-scanner.c"
		{
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`COUNT'";
#line 1174 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5916 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DATATYPE:
#line 5920 "tracker-sparql-scanner.c"
		{
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DATATYPE'";
#line 1175 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5926 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DAY:
#line 5930 "tracker-sparql-scanner.c"
		{
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DAY'";
#line 1176 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5936 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DECIMAL:
#line 5940 "tracker-sparql-scanner.c"
		{
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DECIMAL'";
#line 1177 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5946 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DELETE:
#line 5950 "tracker-sparql-scanner.c"
		{
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DELETE'";
#line 1178 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5956 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESC:
#line 5960 "tracker-sparql-scanner.c"
		{
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DESC'";
#line 1179 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5966 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE:
#line 5970 "tracker-sparql-scanner.c"
		{
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DESCRIBE'";
#line 1180 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5976 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DISTINCT:
#line 5980 "tracker-sparql-scanner.c"
		{
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DISTINCT'";
#line 1181 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5986 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE:
#line 5990 "tracker-sparql-scanner.c"
		{
#line 1182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DOUBLE'";
#line 1182 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 5996 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX:
#line 6000 "tracker-sparql-scanner.c"
		{
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`^^'";
#line 1183 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6006 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_DROP:
#line 6010 "tracker-sparql-scanner.c"
		{
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`DROP'";
#line 1184 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6016 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI:
#line 6020 "tracker-sparql-scanner.c"
		{
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ENCODE_FOR_URI'";
#line 1185 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6026 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EOF:
#line 6030 "tracker-sparql-scanner.c"
		{
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "end of file";
#line 1186 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6036 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_EXISTS:
#line 6040 "tracker-sparql-scanner.c"
		{
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`EXISTS'";
#line 1187 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6046 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FALSE:
#line 6050 "tracker-sparql-scanner.c"
		{
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`false'";
#line 1188 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6056 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FILTER:
#line 6060 "tracker-sparql-scanner.c"
		{
#line 1189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FILTER'";
#line 1189 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6066 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FLOOR:
#line 6070 "tracker-sparql-scanner.c"
		{
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FLOOR'";
#line 1190 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6076 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_FROM:
#line 6080 "tracker-sparql-scanner.c"
		{
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`FROM'";
#line 1191 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6086 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GRAPH:
#line 6090 "tracker-sparql-scanner.c"
		{
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GRAPH'";
#line 1192 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6096 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP:
#line 6100 "tracker-sparql-scanner.c"
		{
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GROUP'";
#line 1193 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6106 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT:
#line 6110 "tracker-sparql-scanner.c"
		{
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`GROUP_CONCAT'";
#line 1194 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6116 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HAVING:
#line 6120 "tracker-sparql-scanner.c"
		{
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`HAVING'";
#line 1195 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6126 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_HOURS:
#line 6130 "tracker-sparql-scanner.c"
		{
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`HOURS'";
#line 1196 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6136 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IF:
#line 6140 "tracker-sparql-scanner.c"
		{
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`IF'";
#line 1197 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6146 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INSERT:
#line 6150 "tracker-sparql-scanner.c"
		{
#line 1198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INSERT'";
#line 1198 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6156 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTEGER:
#line 6160 "tracker-sparql-scanner.c"
		{
#line 1199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INTEGER'";
#line 1199 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6166 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_INTO:
#line 6170 "tracker-sparql-scanner.c"
		{
#line 1200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`INTO'";
#line 1200 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6176 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_IRI_REF:
#line 6180 "tracker-sparql-scanner.c"
		{
#line 1201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "IRI reference";
#line 1201 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6186 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISBLANK:
#line 6190 "tracker-sparql-scanner.c"
		{
#line 1202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISBLANK'";
#line 1202 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6196 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISIRI:
#line 6200 "tracker-sparql-scanner.c"
		{
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISIRI'";
#line 1203 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6206 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL:
#line 6210 "tracker-sparql-scanner.c"
		{
#line 1204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISLITERAL'";
#line 1204 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6216 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ISURI:
#line 6220 "tracker-sparql-scanner.c"
		{
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ISURI'";
#line 1205 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6226 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANG:
#line 6230 "tracker-sparql-scanner.c"
		{
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LANG'";
#line 1206 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6236 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES:
#line 6240 "tracker-sparql-scanner.c"
		{
#line 1207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LANGMATCHES'";
#line 1207 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6246 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LCASE:
#line 6250 "tracker-sparql-scanner.c"
		{
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LCASE'";
#line 1208 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6256 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_LIMIT:
#line 6260 "tracker-sparql-scanner.c"
		{
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`LIMIT'";
#line 1209 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6266 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MAX:
#line 6270 "tracker-sparql-scanner.c"
		{
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MAX'";
#line 1210 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6276 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MD5:
#line 6280 "tracker-sparql-scanner.c"
		{
#line 1211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MD5'";
#line 1211 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6286 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MIN:
#line 6290 "tracker-sparql-scanner.c"
		{
#line 1212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MIN'";
#line 1212 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6296 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUS:
#line 6300 "tracker-sparql-scanner.c"
		{
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`-'";
#line 1213 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6306 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MINUTES:
#line 6310 "tracker-sparql-scanner.c"
		{
#line 1214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MINUTES'";
#line 1214 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6316 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_MONTH:
#line 6320 "tracker-sparql-scanner.c"
		{
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`MONTH'";
#line 1215 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6326 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NAMED:
#line 6330 "tracker-sparql-scanner.c"
		{
#line 1216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NAMED'";
#line 1216 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6336 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOT:
#line 6340 "tracker-sparql-scanner.c"
		{
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NOT'";
#line 1217 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6346 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_NOW:
#line 6350 "tracker-sparql-scanner.c"
		{
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`NOW'";
#line 1218 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6356 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OFFSET:
#line 6360 "tracker-sparql-scanner.c"
		{
#line 1219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OFFSET'";
#line 1219 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6366 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_AND:
#line 6370 "tracker-sparql-scanner.c"
		{
#line 1220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`&&'";
#line 1220 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6376 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_EQ:
#line 6380 "tracker-sparql-scanner.c"
		{
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`='";
#line 1221 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6386 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GE:
#line 6390 "tracker-sparql-scanner.c"
		{
#line 1222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`>='";
#line 1222 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6396 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_GT:
#line 6400 "tracker-sparql-scanner.c"
		{
#line 1223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`>'";
#line 1223 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6406 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LE:
#line 6410 "tracker-sparql-scanner.c"
		{
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`<='";
#line 1224 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6416 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_LT:
#line 6420 "tracker-sparql-scanner.c"
		{
#line 1225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`<'";
#line 1225 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6426 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NE:
#line 6430 "tracker-sparql-scanner.c"
		{
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`!='";
#line 1226 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6436 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_NEG:
#line 6440 "tracker-sparql-scanner.c"
		{
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`!'";
#line 1227 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6446 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_OR:
#line 6450 "tracker-sparql-scanner.c"
		{
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`||'";
#line 1228 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6456 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OP_IN:
#line 6460 "tracker-sparql-scanner.c"
		{
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`IN'";
#line 1229 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6466 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE:
#line 6470 "tracker-sparql-scanner.c"
		{
#line 1230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`{'";
#line 1230 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6476 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET:
#line 6480 "tracker-sparql-scanner.c"
		{
#line 1231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`['";
#line 1231 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6486 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS:
#line 6490 "tracker-sparql-scanner.c"
		{
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`('";
#line 1232 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6496 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL:
#line 6500 "tracker-sparql-scanner.c"
		{
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OPTIONAL'";
#line 1233 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6506 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_OR:
#line 6510 "tracker-sparql-scanner.c"
		{
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`OR'";
#line 1234 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6516 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ORDER:
#line 6520 "tracker-sparql-scanner.c"
		{
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ORDER'";
#line 1235 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6526 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PLUS:
#line 6530 "tracker-sparql-scanner.c"
		{
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`+'";
#line 1236 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6536 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX:
#line 6540 "tracker-sparql-scanner.c"
		{
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "prefixed name";
#line 1237 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6546 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_PREFIX:
#line 6550 "tracker-sparql-scanner.c"
		{
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`PREFIX'";
#line 1238 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6556 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_RAND:
#line 6560 "tracker-sparql-scanner.c"
		{
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`RAND'";
#line 1239 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6566 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REDUCED:
#line 6570 "tracker-sparql-scanner.c"
		{
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REDUCED'";
#line 1240 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6576 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REGEX:
#line 6580 "tracker-sparql-scanner.c"
		{
#line 1241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REGEX'";
#line 1241 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6586 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_REPLACE:
#line 6590 "tracker-sparql-scanner.c"
		{
#line 1242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`REPLACE'";
#line 1242 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6596 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_ROUND:
#line 6600 "tracker-sparql-scanner.c"
		{
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`ROUND'";
#line 1243 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6606 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SAMETERM:
#line 6610 "tracker-sparql-scanner.c"
		{
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SAMETERM'";
#line 1244 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6616 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SECONDS:
#line 6620 "tracker-sparql-scanner.c"
		{
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SECONDS'";
#line 1245 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6626 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SELECT:
#line 6630 "tracker-sparql-scanner.c"
		{
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SELECT'";
#line 1246 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6636 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON:
#line 6640 "tracker-sparql-scanner.c"
		{
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`;'";
#line 1247 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6646 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA1:
#line 6650 "tracker-sparql-scanner.c"
		{
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA1'";
#line 1248 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6656 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA256:
#line 6660 "tracker-sparql-scanner.c"
		{
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA256'";
#line 1249 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6666 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SHA512:
#line 6670 "tracker-sparql-scanner.c"
		{
#line 1250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SHA512'";
#line 1250 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6676 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SILENT:
#line 6680 "tracker-sparql-scanner.c"
		{
#line 1251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SILENT'";
#line 1251 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6686 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STAR:
#line 6690 "tracker-sparql-scanner.c"
		{
#line 1252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`*'";
#line 1252 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6696 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STR:
#line 6700 "tracker-sparql-scanner.c"
		{
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STR'";
#line 1253 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6706 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRAFTER:
#line 6710 "tracker-sparql-scanner.c"
		{
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRAFTER'";
#line 1254 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6716 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE:
#line 6720 "tracker-sparql-scanner.c"
		{
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRBEFORE'";
#line 1255 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6726 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRENDS:
#line 6730 "tracker-sparql-scanner.c"
		{
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRENDS'";
#line 1256 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6736 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1:
#line 6740 "tracker-sparql-scanner.c"
		{
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1257 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6746 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2:
#line 6750 "tracker-sparql-scanner.c"
		{
#line 1258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1258 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6756 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1:
#line 6760 "tracker-sparql-scanner.c"
		{
#line 1259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1259 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6766 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2:
#line 6770 "tracker-sparql-scanner.c"
		{
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "string literal";
#line 1260 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6776 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRLEN:
#line 6780 "tracker-sparql-scanner.c"
		{
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRLEN'";
#line 1261 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6786 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS:
#line 6790 "tracker-sparql-scanner.c"
		{
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`STRSTARTS'";
#line 1262 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6796 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUBSTR:
#line 6800 "tracker-sparql-scanner.c"
		{
#line 1263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SUBSTR'";
#line 1263 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6806 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_SUM:
#line 6810 "tracker-sparql-scanner.c"
		{
#line 1264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`SUM'";
#line 1264 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6816 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_TRUE:
#line 6820 "tracker-sparql-scanner.c"
		{
#line 1265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`true'";
#line 1265 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6826 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UCASE:
#line 6830 "tracker-sparql-scanner.c"
		{
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`UCASE'";
#line 1266 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6836 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_UNION:
#line 6840 "tracker-sparql-scanner.c"
		{
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`UNION'";
#line 1267 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6846 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_VAR:
#line 6850 "tracker-sparql-scanner.c"
		{
#line 1268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "variable";
#line 1268 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6856 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WHERE:
#line 6860 "tracker-sparql-scanner.c"
		{
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`WHERE'";
#line 1269 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6866 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_WITH:
#line 6870 "tracker-sparql-scanner.c"
		{
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`WITH'";
#line 1270 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6876 "tracker-sparql-scanner.c"
		}
#line 1150 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
		case TRACKER_SPARQL_TOKEN_TYPE_YEAR:
#line 6880 "tracker-sparql-scanner.c"
		{
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "`YEAR'";
#line 1271 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6886 "tracker-sparql-scanner.c"
		}
		default:
		{
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			result = "unknown token";
#line 1272 "/home/carlos/Source/gnome/tracker/src/libtracker-data/tracker-sparql-scanner.vala"
			return result;
#line 6894 "tracker-sparql-scanner.c"
		}
	}
}


GType
tracker_sparql_token_type_get_type (void)
{
	static volatile gsize tracker_sparql_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_sparql_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{TRACKER_SPARQL_TOKEN_TYPE_NONE, "TRACKER_SPARQL_TOKEN_TYPE_NONE", "none"}, {TRACKER_SPARQL_TOKEN_TYPE_A, "TRACKER_SPARQL_TOKEN_TYPE_A", "a"}, {TRACKER_SPARQL_TOKEN_TYPE_ABS, "TRACKER_SPARQL_TOKEN_TYPE_ABS", "abs"}, {TRACKER_SPARQL_TOKEN_TYPE_AS, "TRACKER_SPARQL_TOKEN_TYPE_AS", "as"}, {TRACKER_SPARQL_TOKEN_TYPE_ASC, "TRACKER_SPARQL_TOKEN_TYPE_ASC", "asc"}, {TRACKER_SPARQL_TOKEN_TYPE_ASK, "TRACKER_SPARQL_TOKEN_TYPE_ASK", "ask"}, {TRACKER_SPARQL_TOKEN_TYPE_ATBASE, "TRACKER_SPARQL_TOKEN_TYPE_ATBASE", "atbase"}, {TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX, "TRACKER_SPARQL_TOKEN_TYPE_ATPREFIX", "atprefix"}, {TRACKER_SPARQL_TOKEN_TYPE_AVG, "TRACKER_SPARQL_TOKEN_TYPE_AVG", "avg"}, {TRACKER_SPARQL_TOKEN_TYPE_BASE, "TRACKER_SPARQL_TOKEN_TYPE_BASE", "base"}, {TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE, "TRACKER_SPARQL_TOKEN_TYPE_BLANK_NODE", "blank-node"}, {TRACKER_SPARQL_TOKEN_TYPE_BIND, "TRACKER_SPARQL_TOKEN_TYPE_BIND", "bind"}, {TRACKER_SPARQL_TOKEN_TYPE_BOUND, "TRACKER_SPARQL_TOKEN_TYPE_BOUND", "bound"}, {TRACKER_SPARQL_TOKEN_TYPE_BY, "TRACKER_SPARQL_TOKEN_TYPE_BY", "by"}, {TRACKER_SPARQL_TOKEN_TYPE_CEIL, "TRACKER_SPARQL_TOKEN_TYPE_CEIL", "ceil"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACE", "close-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_BRACKET", "close-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_CLOSE_PARENS", "close-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_COALESCE, "TRACKER_SPARQL_TOKEN_TYPE_COALESCE", "coalesce"}, {TRACKER_SPARQL_TOKEN_TYPE_COLON, "TRACKER_SPARQL_TOKEN_TYPE_COLON", "colon"}, {TRACKER_SPARQL_TOKEN_TYPE_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_CONCAT", "concat"}, {TRACKER_SPARQL_TOKEN_TYPE_CONTAINS, "TRACKER_SPARQL_TOKEN_TYPE_CONTAINS", "contains"}, {TRACKER_SPARQL_TOKEN_TYPE_COMMA, "TRACKER_SPARQL_TOKEN_TYPE_COMMA", "comma"}, {TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT, "TRACKER_SPARQL_TOKEN_TYPE_CONSTRUCT", "construct"}, {TRACKER_SPARQL_TOKEN_TYPE_COUNT, "TRACKER_SPARQL_TOKEN_TYPE_COUNT", "count"}, {TRACKER_SPARQL_TOKEN_TYPE_DATA, "TRACKER_SPARQL_TOKEN_TYPE_DATA", "data"}, {TRACKER_SPARQL_TOKEN_TYPE_DATATYPE, "TRACKER_SPARQL_TOKEN_TYPE_DATATYPE", "datatype"}, {TRACKER_SPARQL_TOKEN_TYPE_DAY, "TRACKER_SPARQL_TOKEN_TYPE_DAY", "day"}, {TRACKER_SPARQL_TOKEN_TYPE_DECIMAL, "TRACKER_SPARQL_TOKEN_TYPE_DECIMAL", "decimal"}, {TRACKER_SPARQL_TOKEN_TYPE_DELETE, "TRACKER_SPARQL_TOKEN_TYPE_DELETE", "delete"}, {TRACKER_SPARQL_TOKEN_TYPE_DESC, "TRACKER_SPARQL_TOKEN_TYPE_DESC", "desc"}, {TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE, "TRACKER_SPARQL_TOKEN_TYPE_DESCRIBE", "describe"}, {TRACKER_SPARQL_TOKEN_TYPE_DISTINCT, "TRACKER_SPARQL_TOKEN_TYPE_DISTINCT", "distinct"}, {TRACKER_SPARQL_TOKEN_TYPE_DIV, "TRACKER_SPARQL_TOKEN_TYPE_DIV", "div"}, {TRACKER_SPARQL_TOKEN_TYPE_DOT, "TRACKER_SPARQL_TOKEN_TYPE_DOT", "dot"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE", "double"}, {TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX, "TRACKER_SPARQL_TOKEN_TYPE_DOUBLE_CIRCUMFLEX", "double-circumflex"}, {TRACKER_SPARQL_TOKEN_TYPE_DROP, "TRACKER_SPARQL_TOKEN_TYPE_DROP", "drop"}, {TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI, "TRACKER_SPARQL_TOKEN_TYPE_ENCODE_FOR_URI", "encode-for-uri"}, {TRACKER_SPARQL_TOKEN_TYPE_EOF, "TRACKER_SPARQL_TOKEN_TYPE_EOF", "eof"}, {TRACKER_SPARQL_TOKEN_TYPE_EXISTS, "TRACKER_SPARQL_TOKEN_TYPE_EXISTS", "exists"}, {TRACKER_SPARQL_TOKEN_TYPE_FALSE, "TRACKER_SPARQL_TOKEN_TYPE_FALSE", "false"}, {TRACKER_SPARQL_TOKEN_TYPE_FILTER, "TRACKER_SPARQL_TOKEN_TYPE_FILTER", "filter"}, {TRACKER_SPARQL_TOKEN_TYPE_FLOOR, "TRACKER_SPARQL_TOKEN_TYPE_FLOOR", "floor"}, {TRACKER_SPARQL_TOKEN_TYPE_FROM, "TRACKER_SPARQL_TOKEN_TYPE_FROM", "from"}, {TRACKER_SPARQL_TOKEN_TYPE_GRAPH, "TRACKER_SPARQL_TOKEN_TYPE_GRAPH", "graph"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP, "TRACKER_SPARQL_TOKEN_TYPE_GROUP", "group"}, {TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT, "TRACKER_SPARQL_TOKEN_TYPE_GROUP_CONCAT", "group-concat"}, {TRACKER_SPARQL_TOKEN_TYPE_HAVING, "TRACKER_SPARQL_TOKEN_TYPE_HAVING", "having"}, {TRACKER_SPARQL_TOKEN_TYPE_HOURS, "TRACKER_SPARQL_TOKEN_TYPE_HOURS", "hours"}, {TRACKER_SPARQL_TOKEN_TYPE_IF, "TRACKER_SPARQL_TOKEN_TYPE_IF", "if"}, {TRACKER_SPARQL_TOKEN_TYPE_INSERT, "TRACKER_SPARQL_TOKEN_TYPE_INSERT", "insert"}, {TRACKER_SPARQL_TOKEN_TYPE_INTEGER, "TRACKER_SPARQL_TOKEN_TYPE_INTEGER", "integer"}, {TRACKER_SPARQL_TOKEN_TYPE_INTO, "TRACKER_SPARQL_TOKEN_TYPE_INTO", "into"}, {TRACKER_SPARQL_TOKEN_TYPE_IRI_REF, "TRACKER_SPARQL_TOKEN_TYPE_IRI_REF", "iri-ref"}, {TRACKER_SPARQL_TOKEN_TYPE_ISBLANK, "TRACKER_SPARQL_TOKEN_TYPE_ISBLANK", "isblank"}, {TRACKER_SPARQL_TOKEN_TYPE_ISIRI, "TRACKER_SPARQL_TOKEN_TYPE_ISIRI", "isiri"}, {TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL, "TRACKER_SPARQL_TOKEN_TYPE_ISLITERAL", "isliteral"}, {TRACKER_SPARQL_TOKEN_TYPE_ISURI, "TRACKER_SPARQL_TOKEN_TYPE_ISURI", "isuri"}, {TRACKER_SPARQL_TOKEN_TYPE_LANG, "TRACKER_SPARQL_TOKEN_TYPE_LANG", "lang"}, {TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES, "TRACKER_SPARQL_TOKEN_TYPE_LANGMATCHES", "langmatches"}, {TRACKER_SPARQL_TOKEN_TYPE_LCASE, "TRACKER_SPARQL_TOKEN_TYPE_LCASE", "lcase"}, {TRACKER_SPARQL_TOKEN_TYPE_LIMIT, "TRACKER_SPARQL_TOKEN_TYPE_LIMIT", "limit"}, {TRACKER_SPARQL_TOKEN_TYPE_MAX, "TRACKER_SPARQL_TOKEN_TYPE_MAX", "max"}, {TRACKER_SPARQL_TOKEN_TYPE_MD5, "TRACKER_SPARQL_TOKEN_TYPE_MD5", "md5"}, {TRACKER_SPARQL_TOKEN_TYPE_MIN, "TRACKER_SPARQL_TOKEN_TYPE_MIN", "min"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUS, "TRACKER_SPARQL_TOKEN_TYPE_MINUS", "minus"}, {TRACKER_SPARQL_TOKEN_TYPE_MINUTES, "TRACKER_SPARQL_TOKEN_TYPE_MINUTES", "minutes"}, {TRACKER_SPARQL_TOKEN_TYPE_MONTH, "TRACKER_SPARQL_TOKEN_TYPE_MONTH", "month"}, {TRACKER_SPARQL_TOKEN_TYPE_NAMED, "TRACKER_SPARQL_TOKEN_TYPE_NAMED", "named"}, {TRACKER_SPARQL_TOKEN_TYPE_NOT, "TRACKER_SPARQL_TOKEN_TYPE_NOT", "not"}, {TRACKER_SPARQL_TOKEN_TYPE_NOW, "TRACKER_SPARQL_TOKEN_TYPE_NOW", "now"}, {TRACKER_SPARQL_TOKEN_TYPE_NULL, "TRACKER_SPARQL_TOKEN_TYPE_NULL", "null"}, {TRACKER_SPARQL_TOKEN_TYPE_OFFSET, "TRACKER_SPARQL_TOKEN_TYPE_OFFSET", "offset"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_AND, "TRACKER_SPARQL_TOKEN_TYPE_OP_AND", "op-and"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_EQ, "TRACKER_SPARQL_TOKEN_TYPE_OP_EQ", "op-eq"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GE, "TRACKER_SPARQL_TOKEN_TYPE_OP_GE", "op-ge"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_GT, "TRACKER_SPARQL_TOKEN_TYPE_OP_GT", "op-gt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LE, "TRACKER_SPARQL_TOKEN_TYPE_OP_LE", "op-le"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_LT, "TRACKER_SPARQL_TOKEN_TYPE_OP_LT", "op-lt"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NE, "TRACKER_SPARQL_TOKEN_TYPE_OP_NE", "op-ne"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_NEG, "TRACKER_SPARQL_TOKEN_TYPE_OP_NEG", "op-neg"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_OR, "TRACKER_SPARQL_TOKEN_TYPE_OP_OR", "op-or"}, {TRACKER_SPARQL_TOKEN_TYPE_OP_IN, "TRACKER_SPARQL_TOKEN_TYPE_OP_IN", "op-in"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACE", "open-brace"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_BRACKET", "open-bracket"}, {TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS, "TRACKER_SPARQL_TOKEN_TYPE_OPEN_PARENS", "open-parens"}, {TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL, "TRACKER_SPARQL_TOKEN_TYPE_OPTIONAL", "optional"}, {TRACKER_SPARQL_TOKEN_TYPE_OR, "TRACKER_SPARQL_TOKEN_TYPE_OR", "or"}, {TRACKER_SPARQL_TOKEN_TYPE_ORDER, "TRACKER_SPARQL_TOKEN_TYPE_ORDER", "order"}, {TRACKER_SPARQL_TOKEN_TYPE_PLUS, "TRACKER_SPARQL_TOKEN_TYPE_PLUS", "plus"}, {TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PN_PREFIX", "pn-prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_PREFIX, "TRACKER_SPARQL_TOKEN_TYPE_PREFIX", "prefix"}, {TRACKER_SPARQL_TOKEN_TYPE_RAND, "TRACKER_SPARQL_TOKEN_TYPE_RAND", "rand"}, {TRACKER_SPARQL_TOKEN_TYPE_REDUCED, "TRACKER_SPARQL_TOKEN_TYPE_REDUCED", "reduced"}, {TRACKER_SPARQL_TOKEN_TYPE_REGEX, "TRACKER_SPARQL_TOKEN_TYPE_REGEX", "regex"}, {TRACKER_SPARQL_TOKEN_TYPE_REPLACE, "TRACKER_SPARQL_TOKEN_TYPE_REPLACE", "replace"}, {TRACKER_SPARQL_TOKEN_TYPE_ROUND, "TRACKER_SPARQL_TOKEN_TYPE_ROUND", "round"}, {TRACKER_SPARQL_TOKEN_TYPE_SAMETERM, "TRACKER_SPARQL_TOKEN_TYPE_SAMETERM", "sameterm"}, {TRACKER_SPARQL_TOKEN_TYPE_SECONDS, "TRACKER_SPARQL_TOKEN_TYPE_SECONDS", "seconds"}, {TRACKER_SPARQL_TOKEN_TYPE_SELECT, "TRACKER_SPARQL_TOKEN_TYPE_SELECT", "select"}, {TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON, "TRACKER_SPARQL_TOKEN_TYPE_SEMICOLON", "semicolon"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA1, "TRACKER_SPARQL_TOKEN_TYPE_SHA1", "sha1"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA256, "TRACKER_SPARQL_TOKEN_TYPE_SHA256", "sha256"}, {TRACKER_SPARQL_TOKEN_TYPE_SHA512, "TRACKER_SPARQL_TOKEN_TYPE_SHA512", "sha512"}, {TRACKER_SPARQL_TOKEN_TYPE_SILENT, "TRACKER_SPARQL_TOKEN_TYPE_SILENT", "silent"}, {TRACKER_SPARQL_TOKEN_TYPE_STAR, "TRACKER_SPARQL_TOKEN_TYPE_STAR", "star"}, {TRACKER_SPARQL_TOKEN_TYPE_STR, "TRACKER_SPARQL_TOKEN_TYPE_STR", "str"}, {TRACKER_SPARQL_TOKEN_TYPE_STRAFTER, "TRACKER_SPARQL_TOKEN_TYPE_STRAFTER", "strafter"}, {TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE, "TRACKER_SPARQL_TOKEN_TYPE_STRBEFORE", "strbefore"}, {TRACKER_SPARQL_TOKEN_TYPE_STRENDS, "TRACKER_SPARQL_TOKEN_TYPE_STRENDS", "strends"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL1", "string-literal1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL2", "string-literal2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG1", "string-literal-long1"}, {TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2, "TRACKER_SPARQL_TOKEN_TYPE_STRING_LITERAL_LONG2", "string-literal-long2"}, {TRACKER_SPARQL_TOKEN_TYPE_STRLEN, "TRACKER_SPARQL_TOKEN_TYPE_STRLEN", "strlen"}, {TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS, "TRACKER_SPARQL_TOKEN_TYPE_STRSTARTS", "strstarts"}, {TRACKER_SPARQL_TOKEN_TYPE_SUBSTR, "TRACKER_SPARQL_TOKEN_TYPE_SUBSTR", "substr"}, {TRACKER_SPARQL_TOKEN_TYPE_SUM, "TRACKER_SPARQL_TOKEN_TYPE_SUM", "sum"}, {TRACKER_SPARQL_TOKEN_TYPE_TRUE, "TRACKER_SPARQL_TOKEN_TYPE_TRUE", "true"}, {TRACKER_SPARQL_TOKEN_TYPE_UCASE, "TRACKER_SPARQL_TOKEN_TYPE_UCASE", "ucase"}, {TRACKER_SPARQL_TOKEN_TYPE_UNION, "TRACKER_SPARQL_TOKEN_TYPE_UNION", "union"}, {TRACKER_SPARQL_TOKEN_TYPE_VAR, "TRACKER_SPARQL_TOKEN_TYPE_VAR", "var"}, {TRACKER_SPARQL_TOKEN_TYPE_WHERE, "TRACKER_SPARQL_TOKEN_TYPE_WHERE", "where"}, {TRACKER_SPARQL_TOKEN_TYPE_WITH, "TRACKER_SPARQL_TOKEN_TYPE_WITH", "with"}, {TRACKER_SPARQL_TOKEN_TYPE_YEAR, "TRACKER_SPARQL_TOKEN_TYPE_YEAR", "year"}, {0, NULL, NULL}};
		GType tracker_sparql_token_type_type_id;
		tracker_sparql_token_type_type_id = g_enum_register_static ("TrackerSparqlTokenType", values);
		g_once_init_leave (&tracker_sparql_token_type_type_id__volatile, tracker_sparql_token_type_type_id);
	}
	return tracker_sparql_token_type_type_id__volatile;
}



