// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_UNIXFDMESSAGE_H
#define _GIOMM_UNIXFDMESSAGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/arrayhandle.h>
#include <giomm/socketcontrolmessage.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GUnixFDMessage GUnixFDMessage;
typedef struct _GUnixFDMessageClass GUnixFDMessageClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class UnixFDMessage_Class; } // namespace Gio
namespace Gio
{

class UnixFDList;

/** UnixFDMessage — A GSocketControlMessage containing a GUnixFDList.
 * This SocketControlMessage contains a UnixFDList. It may be sent using
 * Gio::Socket::send() and received using Gio::Socket::receive() over
 * UNIX sockets (ie: sockets in the Gio::SOCKET_ADDRESS_UNIX family). The file
 * descriptors are copied between processes by the kernel.
 *
 * For an easier way to send and receive file descriptors over stream-oriented
 * UNIX sockets, see Gio::UnixConnection::send_fd() and
 * Gio::UnixConnection::receive_fd().
 *
 * @ingroup NetworkIO
 * @newin{2,28}
 */

class UnixFDMessage : public SocketControlMessage
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef UnixFDMessage CppObjectType;
  typedef UnixFDMessage_Class CppClassType;
  typedef GUnixFDMessage BaseObjectType;
  typedef GUnixFDMessageClass BaseClassType;

private:  friend class UnixFDMessage_Class;
  static CppClassType unixfdmessage_class_;

private:
  // noncopyable
  UnixFDMessage(const UnixFDMessage&);
  UnixFDMessage& operator=(const UnixFDMessage&);

protected:
  explicit UnixFDMessage(const Glib::ConstructParams& construct_params);
  explicit UnixFDMessage(GUnixFDMessage* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~UnixFDMessage();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GUnixFDMessage*       gobj()       { return reinterpret_cast<GUnixFDMessage*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GUnixFDMessage* gobj() const { return reinterpret_cast<GUnixFDMessage*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GUnixFDMessage* gobj_copy();

private:

  //This is not available in on Win32.
//This source file will not be compiled,
//and the class will not be registered in wrap_init.h or wrap_init.cc


protected:
  UnixFDMessage();
    explicit UnixFDMessage(const Glib::RefPtr<UnixFDList>& fd_list);


public:
  
  /** Creates a new UnixFDMessage containing an empty file descriptor
   * list.
   * 
   * @newin{2,22}
   * @return A new UnixFDMessage.
   */

  
  static Glib::RefPtr<UnixFDMessage> create();


  /** Creates a new UnixFDMessage containing @a list.
   * 
   * @newin{2,24}
   * @param fd_list A UnixFDList.
   * @return A new UnixFDMessage.
   */

  
  static Glib::RefPtr<UnixFDMessage> create(const Glib::RefPtr<UnixFDList>& fd_list);


  /** Gets the UnixFDList contained in @a message.  This function does not
   * return a reference to the caller, but the returned list is valid for
   * the lifetime of @a message.
   * 
   * @newin{2,24}
   * @return The UnixFDList from @a message.
   */
  Glib::RefPtr<UnixFDList> get_fd_list();
  
  /** Gets the UnixFDList contained in @a message.  This function does not
   * return a reference to the caller, but the returned list is valid for
   * the lifetime of @a message.
   * 
   * @newin{2,24}
   * @return The UnixFDList from @a message.
   */
  Glib::RefPtr<const UnixFDList> get_fd_list() const;

  
  /** Adds a file descriptor to @a message.
   * 
   * The file descriptor is duplicated using dup(). You keep your copy
   * of the descriptor and the copy contained in @a message will be closed
   * when @a message is finalized.
   * 
   * A possible cause of failure is exceeding the per-process or
   * system-wide file descriptor limit.
   * 
   * @newin{2,22}
   * @param fd A valid open file descriptor.
   * @return <tt>true</tt> in case of success, else <tt>false</tt> (and @a error is set).
   */
  bool append_fd(int fd);


  /** Returns the array of file descriptors that is contained in this object.
   *
   * After this call, the descriptors are no longer contained in message.
   * Further calls will return an empty list (unless more descriptors have
   * been added).
   *
   * The caller is responsible for closing all of the file descriptors.
   *
   * @return An array of file descriptors.
   *
   * @newin{2,28}
   */
  Glib::ArrayHandle<int> steal_fds();
  

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<UnixFDList> > property_fd_list() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::UnixFDMessage
   */
  Glib::RefPtr<Gio::UnixFDMessage> wrap(GUnixFDMessage* object, bool take_copy = false);
}


#endif /* _GIOMM_UNIXFDMESSAGE_H */

