/* rygel-media-export-metadata-extractor.c generated by valac 0.42.2, the Vala compiler
 * generated from rygel-media-export-metadata-extractor.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <gio/gunixoutputstream.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <glib/gi18n-lib.h>
#include <fcntl.h>
#include <gio/gunixinputstream.h>


#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;
typedef struct _RygelMediaExportMetadataExtractorPrivate RygelMediaExportMetadataExtractorPrivate;
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_0_PROPERTY,
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_NUM_PROPERTIES
};
static GParamSpec* rygel_media_export_metadata_extractor_properties[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportMetadataExtractorRunData RygelMediaExportMetadataExtractorRunData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
enum  {
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_EXTRACTION_DONE_SIGNAL,
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_ERROR_SIGNAL,
	RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_NUM_SIGNALS
};
static guint rygel_media_export_metadata_extractor_signals[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_NUM_SIGNALS] = {0};

typedef enum  {
	METADATA_EXTRACTOR_ERROR_GENERAL,
	METADATA_EXTRACTOR_ERROR_BLACKLIST
} MetadataExtractorError;
#define METADATA_EXTRACTOR_ERROR metadata_extractor_error_quark ()
struct _RygelMediaExportMetadataExtractor {
	GObject parent_instance;
	RygelMediaExportMetadataExtractorPrivate * priv;
};

struct _RygelMediaExportMetadataExtractorClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMetadataExtractorPrivate {
	gboolean extract_metadata;
	GUnixOutputStream* input_stream;
	GDataInputStream* output_stream;
	GCancellable* child_io_cancellable;
	GSubprocessLauncher* launcher;
	gchar* error_uri;
	gchar** MX_EXTRACT_ARGV;
	gint MX_EXTRACT_ARGV_length1;
	gint _MX_EXTRACT_ARGV_size_;
};

struct _RygelMediaExportMetadataExtractorRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMediaExportMetadataExtractor* self;
	gint* pipe_in;
	gint* _tmp0_;
	gint pipe_in_length1;
	gint _pipe_in_size_;
	gint* pipe_out;
	gint* _tmp1_;
	gint pipe_out_length1;
	gint _pipe_out_size_;
	gboolean restart;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint* _tmp5_;
	gint _tmp5__length1;
	GSubprocessLauncher* _tmp6_;
	GSubprocessLauncher* _tmp7_;
	gint* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	GSubprocessLauncher* _tmp10_;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint _tmp14_;
	GUnixOutputStream* _tmp15_;
	gint* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	GUnixInputStream* _tmp18_;
	GUnixInputStream* _tmp19_;
	GDataInputStream* _tmp20_;
	GCancellable* _tmp21_;
	GDataInputStream* _tmp22_;
	GCancellable* _tmp23_;
	gboolean _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	GSubprocess* subprocess;
	GSubprocessLauncher* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	GSubprocess* _tmp32_;
	GSubprocess* _tmp33_;
	GError* _error_;
	GError* _tmp34_;
	const gchar* _tmp35_;
	GCancellable* _tmp36_;
	gchar* msg;
	gchar* _tmp37_;
	const gchar* _tmp38_;
	GFile* _tmp39_;
	GFile* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GError* _tmp43_;
	GError* _tmp44_;
	GError* _vala1__error_;
	GError* _tmp45_;
	const gchar* _tmp46_;
	GError * _inner_error_;
};

struct _Block4Data {
	int _ref_count_;
	RygelMediaExportMetadataExtractor* self;
	GFile* file;
	gchar* content_type;
};


static gint RygelMediaExportMetadataExtractor_private_offset;
static gpointer rygel_media_export_metadata_extractor_parent_class = NULL;
static GVariantType* rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE;
static GVariantType* rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE = NULL;

GQuark metadata_extractor_error_quark (void);
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
gboolean g_unix_open_pipe (gint* fds,
                           gint flags,
                           GError** error);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_new (void);
RygelMediaExportMetadataExtractor* rygel_media_export_metadata_extractor_construct (GType object_type);
static void rygel_media_export_metadata_extractor_on_config_changed (RygelMediaExportMetadataExtractor* self,
                                                              RygelConfiguration* config,
                                                              const gchar* section,
                                                              const gchar* key);
static void _rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                                   const gchar* section,
                                                                                                   const gchar* key,
                                                                                                   gpointer self);
#define RYGEL_MEDIA_EXPORT_PLUGIN_NAME "MediaExport"
void rygel_media_export_metadata_extractor_stop (RygelMediaExportMetadataExtractor* self);
static void rygel_media_export_metadata_extractor_run_data_free (gpointer _data);
static void rygel_media_export_metadata_extractor_run_async_ready_wrapper (GObject *source_object,
                                                                    GAsyncResult *res,
                                                                    void *user_data);
void rygel_media_export_metadata_extractor_run (RygelMediaExportMetadataExtractor* self,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
void rygel_media_export_metadata_extractor_run_finish (RygelMediaExportMetadataExtractor* self,
                                                       GAsyncResult* _res_);
static gboolean rygel_media_export_metadata_extractor_run_co (RygelMediaExportMetadataExtractorRunData* _data_);
static void rygel_media_export_metadata_extractor_on_input (RygelMediaExportMetadataExtractor* self,
                                                     GObject* object,
                                                     GAsyncResult* _result_);
static void _rygel_media_export_metadata_extractor_on_input_gasync_ready_callback (GObject* source_object,
                                                                            GAsyncResult* res,
                                                                            gpointer self);
static void rygel_media_export_metadata_extractor_run_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self,
                                                    GFile* file,
                                                    const gchar* content_type);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static gboolean ___lambda6_ (Block4Data* _data4_);
static gboolean ____lambda6__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_VARIANT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void rygel_media_export_metadata_extractor_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark
metadata_extractor_error_quark (void)
{
	return g_quark_from_static_string ("metadata_extractor_error-quark");
}


static inline gpointer
rygel_media_export_metadata_extractor_get_instance_private (RygelMediaExportMetadataExtractor* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaExportMetadataExtractor_private_offset);
}


static void
_rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender,
                                                                                              const gchar* section,
                                                                                              const gchar* key,
                                                                                              gpointer self)
{
	rygel_media_export_metadata_extractor_on_config_changed ((RygelMediaExportMetadataExtractor*) self, _sender, section, key);
}


RygelMediaExportMetadataExtractor*
rygel_media_export_metadata_extractor_construct (GType object_type)
{
	RygelMediaExportMetadataExtractor * self = NULL;
	GCancellable* _tmp0_;
	RygelMetaConfig* config = NULL;
	RygelMetaConfig* _tmp1_;
	self = (RygelMediaExportMetadataExtractor*) g_object_new (object_type, NULL);
	_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->child_io_cancellable);
	self->priv->child_io_cancellable = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	config = _tmp1_;
	g_signal_connect_object ((RygelConfiguration*) config, "setting-changed", (GCallback) _rygel_media_export_metadata_extractor_on_config_changed_rygel_configuration_setting_changed, self, 0);
	rygel_media_export_metadata_extractor_on_config_changed (self, (RygelConfiguration*) config, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "extract-metadata");
	_g_object_unref0 (config);
	return self;
}


RygelMediaExportMetadataExtractor*
rygel_media_export_metadata_extractor_new (void)
{
	return rygel_media_export_metadata_extractor_construct (RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR);
}


static guint8*
string_get_data (const gchar* self,
                 int* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void
rygel_media_export_metadata_extractor_stop (RygelMediaExportMetadataExtractor* self)
{
	GCancellable* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->child_io_cancellable;
	g_cancellable_cancel (_tmp0_);
	{
		gchar* s = NULL;
		gchar* _tmp1_;
		GUnixOutputStream* _tmp2_;
		const gchar* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		GUnixOutputStream* _tmp6_;
		_tmp1_ = g_strdup ("QUIT\n");
		s = _tmp1_;
		_tmp2_ = self->priv->input_stream;
		_tmp3_ = s;
		_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		g_output_stream_write_all ((GOutputStream*) _tmp2_, _tmp5_, (gsize) _tmp5__length1, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (s);
			goto __catch25_g_error;
		}
		_tmp6_ = self->priv->input_stream;
		g_output_stream_flush ((GOutputStream*) _tmp6_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (s);
			goto __catch25_g_error;
		}
		_g_free0 (s);
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("rygel-media-export-metadata-extractor.vala:104: %s", _ ("Failed to gracefully stop the process. Using KILL"));
		_g_error_free0 (_error_);
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void
rygel_media_export_metadata_extractor_run_data_free (gpointer _data)
{
	RygelMediaExportMetadataExtractorRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportMetadataExtractorRunData, _data_);
}


static void
rygel_media_export_metadata_extractor_run_async_ready_wrapper (GObject *source_object,
                                                               GAsyncResult *res,
                                                               void *user_data)
{
	RygelMediaExportMetadataExtractorRunData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
rygel_media_export_metadata_extractor_run (RygelMediaExportMetadataExtractor* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	RygelMediaExportMetadataExtractorRunData* _data_;
	RygelMediaExportMetadataExtractor* _tmp0_;
	_data_ = g_slice_new0 (RygelMediaExportMetadataExtractorRunData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_media_export_metadata_extractor_run_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_export_metadata_extractor_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_export_metadata_extractor_run_co (_data_);
}


void
rygel_media_export_metadata_extractor_run_finish (RygelMediaExportMetadataExtractor* self,
                                                  GAsyncResult* _res_)
{
	RygelMediaExportMetadataExtractorRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void
_rygel_media_export_metadata_extractor_on_input_gasync_ready_callback (GObject* source_object,
                                                                       GAsyncResult* res,
                                                                       gpointer self)
{
	rygel_media_export_metadata_extractor_on_input ((RygelMediaExportMetadataExtractor*) self, source_object, res);
	g_object_unref (self);
}


static void
rygel_media_export_metadata_extractor_run_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	RygelMediaExportMetadataExtractorRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	rygel_media_export_metadata_extractor_run_co (_data_);
}


static gboolean
rygel_media_export_metadata_extractor_run_co (RygelMediaExportMetadataExtractorRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_new0 (gint, 2);
	_data_->_tmp0_[0] = 0;
	_data_->_tmp0_[1] = 0;
	_data_->pipe_in = _data_->_tmp0_;
	_data_->pipe_in_length1 = 2;
	_data_->_pipe_in_size_ = _data_->pipe_in_length1;
	_data_->_tmp1_ = g_new0 (gint, 2);
	_data_->_tmp1_[0] = 0;
	_data_->_tmp1_[1] = 0;
	_data_->pipe_out = _data_->_tmp1_;
	_data_->pipe_out_length1 = 2;
	_data_->_pipe_out_size_ = _data_->pipe_out_length1;
	_data_->restart = FALSE;
	{
		_data_->_tmp2_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp2_) {
				_data_->_tmp3_ = _data_->restart;
				if (!_data_->_tmp3_) {
					break;
				}
			}
			_data_->_tmp2_ = FALSE;
			_data_->restart = FALSE;
			{
				_data_->_tmp4_ = _data_->pipe_in;
				_data_->_tmp4__length1 = _data_->pipe_in_length1;
				g_unix_open_pipe (_data_->_tmp4_, FD_CLOEXEC, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch26_g_error;
				}
				_data_->_tmp5_ = _data_->pipe_out;
				_data_->_tmp5__length1 = _data_->pipe_out_length1;
				g_unix_open_pipe (_data_->_tmp5_, FD_CLOEXEC, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch26_g_error;
				}
				_data_->_tmp6_ = g_subprocess_launcher_new (G_SUBPROCESS_FLAGS_NONE);
				_g_object_unref0 (_data_->self->priv->launcher);
				_data_->self->priv->launcher = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->self->priv->launcher;
				_data_->_tmp8_ = _data_->pipe_in;
				_data_->_tmp8__length1 = _data_->pipe_in_length1;
				_data_->_tmp9_ = _data_->_tmp8_[0];
				g_subprocess_launcher_take_fd (_data_->_tmp7_, _data_->_tmp9_, 3);
				_data_->_tmp10_ = _data_->self->priv->launcher;
				_data_->_tmp11_ = _data_->pipe_out;
				_data_->_tmp11__length1 = _data_->pipe_out_length1;
				_data_->_tmp12_ = _data_->_tmp11_[1];
				g_subprocess_launcher_take_fd (_data_->_tmp10_, _data_->_tmp12_, 4);
				_data_->_tmp13_ = _data_->pipe_in;
				_data_->_tmp13__length1 = _data_->pipe_in_length1;
				_data_->_tmp14_ = _data_->_tmp13_[1];
				_data_->_tmp15_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->_tmp14_, TRUE);
				_g_object_unref0 (_data_->self->priv->input_stream);
				_data_->self->priv->input_stream = _data_->_tmp15_;
				_data_->_tmp16_ = _data_->pipe_out;
				_data_->_tmp16__length1 = _data_->pipe_out_length1;
				_data_->_tmp17_ = _data_->_tmp16_[0];
				_data_->_tmp18_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->_tmp17_, TRUE);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp20_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp19_);
				_g_object_unref0 (_data_->self->priv->output_stream);
				_data_->self->priv->output_stream = _data_->_tmp20_;
				_g_object_unref0 (_data_->_tmp19_);
				_data_->_tmp21_ = g_cancellable_new ();
				_g_object_unref0 (_data_->self->priv->child_io_cancellable);
				_data_->self->priv->child_io_cancellable = _data_->_tmp21_;
				_data_->_tmp22_ = _data_->self->priv->output_stream;
				_data_->_tmp23_ = _data_->self->priv->child_io_cancellable;
				g_data_input_stream_read_line_async (_data_->_tmp22_, G_PRIORITY_DEFAULT, _data_->_tmp23_, _rygel_media_export_metadata_extractor_on_input_gasync_ready_callback, g_object_ref (_data_->self));
				_g_free0 (_data_->self->priv->error_uri);
				_data_->self->priv->error_uri = NULL;
				_data_->_tmp24_ = _data_->self->priv->extract_metadata;
				if (_data_->_tmp24_) {
					_data_->_tmp25_ = _data_->self->priv->MX_EXTRACT_ARGV;
					_data_->_tmp25__length1 = _data_->self->priv->MX_EXTRACT_ARGV_length1;
					_data_->_tmp26_ = g_strdup ("--extract-metadata");
					_g_free0 (_data_->_tmp25_[4]);
					_data_->_tmp25_[4] = _data_->_tmp26_;
					_data_->_tmp27_ = _data_->_tmp25_[4];
				} else {
					_data_->_tmp28_ = _data_->self->priv->MX_EXTRACT_ARGV;
					_data_->_tmp28__length1 = _data_->self->priv->MX_EXTRACT_ARGV_length1;
					_g_free0 (_data_->_tmp28_[4]);
					_data_->_tmp28_[4] = NULL;
					_data_->_tmp29_ = _data_->_tmp28_[4];
				}
				_data_->_tmp30_ = _data_->self->priv->launcher;
				_data_->_tmp31_ = _data_->self->priv->MX_EXTRACT_ARGV;
				_data_->_tmp31__length1 = _data_->self->priv->MX_EXTRACT_ARGV_length1;
				_data_->_tmp32_ = g_subprocess_launcher_spawnv (_data_->_tmp30_, _data_->_tmp31_, &_data_->_inner_error_);
				_data_->subprocess = _data_->_tmp32_;
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					goto __catch26_g_error;
				}
				{
					_data_->_tmp33_ = _data_->subprocess;
					_data_->_state_ = 1;
					g_subprocess_wait_check_async (_data_->_tmp33_, NULL, rygel_media_export_metadata_extractor_run_ready, _data_);
					return FALSE;
					_state_1:
					g_subprocess_wait_check_finish (_data_->_tmp33_, _data_->_res_, &_data_->_inner_error_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						goto __catch27_g_error;
					}
				}
				goto __finally27;
				__catch27_g_error:
				{
					_data_->_error_ = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp34_ = _data_->_error_;
					_data_->_tmp35_ = _data_->_tmp34_->message;
					g_warning (_ ("Process check_async failed: %s"), _data_->_tmp35_);
					_data_->restart = TRUE;
					_data_->_tmp36_ = _data_->self->priv->child_io_cancellable;
					g_cancellable_cancel (_data_->_tmp36_);
					_data_->_tmp37_ = g_strdup (_ ("Process died while handling URI %s"));
					_data_->msg = _data_->_tmp37_;
					_data_->_tmp38_ = _data_->self->priv->error_uri;
					_data_->_tmp39_ = g_file_new_for_uri (_data_->_tmp38_);
					_data_->_tmp40_ = _data_->_tmp39_;
					_data_->_tmp41_ = _data_->msg;
					_data_->_tmp42_ = _data_->self->priv->error_uri;
					_data_->_tmp43_ = g_error_new (METADATA_EXTRACTOR_ERROR, METADATA_EXTRACTOR_ERROR_BLACKLIST, _data_->_tmp41_, _data_->_tmp42_);
					_data_->_tmp44_ = _data_->_tmp43_;
					g_signal_emit (_data_->self, rygel_media_export_metadata_extractor_signals[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_ERROR_SIGNAL], 0, _data_->_tmp40_, _data_->_tmp44_);
					_g_error_free0 (_data_->_tmp44_);
					_g_object_unref0 (_data_->_tmp40_);
					_g_free0 (_data_->msg);
					_g_error_free0 (_data_->_error_);
				}
				__finally27:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->subprocess);
					goto __catch26_g_error;
				}
				_g_object_unref0 (_data_->subprocess);
			}
			goto __finally26;
			__catch26_g_error:
			{
				_data_->_vala1__error_ = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp45_ = _data_->_vala1__error_;
				_data_->_tmp46_ = _data_->_tmp45_->message;
				g_warning (_ ("Setting up extraction subprocess failed: %s"), _data_->_tmp46_);
				_g_error_free0 (_data_->_vala1__error_);
			}
			__finally26:
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_data_->pipe_out = (g_free (_data_->pipe_out), NULL);
				_data_->pipe_in = (g_free (_data_->pipe_in), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	g_debug ("rygel-media-export-metadata-extractor.vala:169: Metadata extractor fin" \
"ished.");
	_data_->pipe_out = (g_free (_data_->pipe_out), NULL);
	_data_->pipe_in = (g_free (_data_->pipe_in), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static guint64
uint64_parse (const gchar* str)
{
	guint64 result = 0ULL;
	guint64 _tmp0_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = g_ascii_strtoull (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


static void
rygel_media_export_metadata_extractor_on_input (RygelMediaExportMetadataExtractor* self,
                                                GObject* object,
                                                GAsyncResult* _result_)
{
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	{
		GDataInputStream* stream = NULL;
		GDataInputStream* _tmp0_;
		gchar* str = NULL;
		GDataInputStream* _tmp1_;
		gchar* _tmp2_;
		GDataInputStream* _tmp53_;
		GCancellable* _tmp54_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, g_data_input_stream_get_type ()) ? ((GDataInputStream*) object) : NULL);
		stream = _tmp0_;
		_tmp1_ = stream;
		_tmp2_ = g_data_input_stream_read_line_finish (_tmp1_, _result_, NULL, &_inner_error_);
		str = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (stream);
			goto __catch28_g_error;
		}
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				const gchar* _tmp4_;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				const gchar* _tmp7_;
				gchar** parts = NULL;
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gchar** _tmp13_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* uri = NULL;
				gchar** _tmp26_;
				gint _tmp26__length1;
				const gchar* _tmp27_;
				gchar* _tmp28_;
				guint64 length = 0ULL;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gchar** _tmp31_;
				gint _tmp31__length1;
				const gchar* _tmp32_;
				const gchar* _tmp37_;
				guint8* buf = NULL;
				guint64 _tmp38_;
				guint8* _tmp39_;
				gint buf_length1;
				gint _buf_size_;
				gsize bytes = 0UL;
				GDataInputStream* _tmp40_;
				guint8* _tmp41_;
				gint _tmp41__length1;
				GCancellable* _tmp42_;
				gsize _tmp43_ = 0UL;
				guint64 _tmp44_;
				gsize _tmp45_;
				GVariant* v = NULL;
				const GVariantType* _tmp46_;
				guint8* _tmp47_;
				gint _tmp47__length1;
				GVariant* _tmp48_;
				const gchar* _tmp49_;
				GFile* _tmp50_;
				GFile* _tmp51_;
				GVariant* _tmp52_;
				if (!_tmp3_) {
					if (!FALSE) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp4_ = str;
				if (_tmp4_ == NULL) {
					break;
				}
				_tmp7_ = str;
				if (!g_str_has_prefix (_tmp7_, "RESULT|")) {
					const gchar* _tmp8_;
					_tmp8_ = str;
					_tmp6_ = !g_str_has_prefix (_tmp8_, "ERROR|");
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					const gchar* _tmp9_;
					_tmp9_ = str;
					_tmp5_ = !g_str_has_prefix (_tmp9_, "SKIP|");
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					const gchar* _tmp10_;
					_tmp10_ = str;
					g_warning (_ ("Received invalid string from child: %s"), _tmp10_);
					break;
				}
				_tmp11_ = str;
				_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "|", 0);
				parts = _tmp13_;
				parts_length1 = _vala_array_length (_tmp12_);
				_parts_size_ = parts_length1;
				_tmp14_ = parts;
				_tmp14__length1 = parts_length1;
				if (_tmp14__length1 != 4) {
					const gchar* _tmp15_;
					_tmp15_ = str;
					g_warning (_ ("Received ill-formed response string %s from child…"), _tmp15_);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					break;
				}
				_tmp16_ = parts;
				_tmp16__length1 = parts_length1;
				_tmp17_ = _tmp16_[0];
				if (g_strcmp0 (_tmp17_, "ERROR") == 0) {
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					GFile* _tmp20_;
					GFile* _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					GError* _tmp24_;
					GError* _tmp25_;
					_tmp18_ = parts;
					_tmp18__length1 = parts_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = g_file_new_for_uri (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = parts;
					_tmp22__length1 = parts_length1;
					_tmp23_ = _tmp22_[3];
					_tmp24_ = g_error_new_literal (METADATA_EXTRACTOR_ERROR, METADATA_EXTRACTOR_ERROR_GENERAL, _tmp23_);
					_tmp25_ = _tmp24_;
					g_signal_emit (self, rygel_media_export_metadata_extractor_signals[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_ERROR_SIGNAL], 0, _tmp21_, _tmp25_);
					_g_error_free0 (_tmp25_);
					_g_object_unref0 (_tmp21_);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					break;
				}
				_tmp26_ = parts;
				_tmp26__length1 = parts_length1;
				_tmp27_ = _tmp26_[1];
				_tmp28_ = g_strdup (_tmp27_);
				uri = _tmp28_;
				_tmp29_ = parts;
				_tmp29__length1 = parts_length1;
				_tmp30_ = _tmp29_[2];
				length = uint64_parse (_tmp30_);
				_tmp31_ = parts;
				_tmp31__length1 = parts_length1;
				_tmp32_ = _tmp31_[0];
				if (g_strcmp0 (_tmp32_, "SKIP") == 0) {
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					GFile* _tmp35_;
					GFile* _tmp36_;
					_tmp33_ = uri;
					g_debug ("rygel-media-export-metadata-extractor.vala:210: Extractor binary told " \
"us to skip %s", _tmp33_);
					_tmp34_ = uri;
					_tmp35_ = g_file_new_for_uri (_tmp34_);
					_tmp36_ = _tmp35_;
					g_signal_emit (self, rygel_media_export_metadata_extractor_signals[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_EXTRACTION_DONE_SIGNAL], 0, _tmp36_, NULL);
					_g_object_unref0 (_tmp36_);
					_g_free0 (uri);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					break;
				}
				_tmp37_ = uri;
				g_debug ("rygel-media-export-metadata-extractor.vala:217: Found serialized data " \
"for uri %s", _tmp37_);
				_tmp38_ = length;
				_tmp39_ = g_new0 (guint8, _tmp38_);
				buf = _tmp39_;
				buf_length1 = _tmp38_;
				_buf_size_ = buf_length1;
				_tmp40_ = self->priv->output_stream;
				_tmp41_ = buf;
				_tmp41__length1 = buf_length1;
				_tmp42_ = self->priv->child_io_cancellable;
				g_input_stream_read_all ((GInputStream*) _tmp40_, _tmp41_, (gsize) _tmp41__length1, &_tmp43_, _tmp42_, &_inner_error_);
				bytes = _tmp43_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					buf = (g_free (buf), NULL);
					_g_free0 (uri);
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (str);
					_g_object_unref0 (stream);
					goto __catch28_g_error;
				}
				_tmp44_ = length;
				_tmp45_ = bytes;
				g_debug ("Expected %" G_GSIZE_FORMAT " bytes, got %" G_GSIZE_FORMAT, _tmp44_, _tmp45_);
				_tmp46_ = rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE;
				_tmp47_ = buf;
				_tmp47__length1 = buf_length1;
				_tmp48_ = g_variant_new_from_data (_tmp46_, (guchar*) _tmp47_, (_tmp47__length1 * sizeof (guint8)) / sizeof (guchar), TRUE, NULL, NULL);
				g_variant_ref_sink (_tmp48_);
				v = _tmp48_;
				_tmp49_ = uri;
				_tmp50_ = g_file_new_for_uri (_tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = v;
				g_signal_emit (self, rygel_media_export_metadata_extractor_signals[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_EXTRACTION_DONE_SIGNAL], 0, _tmp51_, _tmp52_);
				_g_object_unref0 (_tmp51_);
				_g_variant_unref0 (v);
				buf = (g_free (buf), NULL);
				_g_free0 (uri);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_tmp53_ = self->priv->output_stream;
		_tmp54_ = self->priv->child_io_cancellable;
		g_data_input_stream_read_line_async (_tmp53_, G_PRIORITY_DEFAULT, _tmp54_, _rygel_media_export_metadata_extractor_on_input_gasync_ready_callback, g_object_ref (self));
		_g_free0 (str);
		_g_object_unref0 (stream);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp55_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp55_ = _error_;
		if (g_error_matches (_tmp55_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			g_debug ("rygel-media-export-metadata-extractor.vala:239: Read was cancelled, pr" \
"ocess probably died…");
		} else {
			GError* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			GFile* _tmp59_;
			GFile* _tmp60_;
			GError* _tmp61_;
			GError* _tmp62_;
			_tmp56_ = _error_;
			_tmp57_ = _tmp56_->message;
			g_warning (_ ("Read from child failed: %s"), _tmp57_);
			_tmp58_ = self->priv->error_uri;
			_tmp59_ = g_file_new_for_uri (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = g_error_new_literal (METADATA_EXTRACTOR_ERROR, METADATA_EXTRACTOR_ERROR_GENERAL, "Failed");
			_tmp62_ = _tmp61_;
			g_signal_emit (self, rygel_media_export_metadata_extractor_signals[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_ERROR_SIGNAL], 0, _tmp60_, _tmp62_);
			_g_error_free0 (_tmp62_);
			_g_object_unref0 (_tmp60_);
		}
		_g_error_free0 (_error_);
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		RygelMediaExportMetadataExtractor* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->file);
		_g_free0 (_data4_->content_type);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean
___lambda6_ (Block4Data* _data4_)
{
	RygelMediaExportMetadataExtractor* self;
	gboolean result = FALSE;
	self = _data4_->self;
	rygel_media_export_metadata_extractor_extract (self, _data4_->file, _data4_->content_type);
	result = FALSE;
	return result;
}


static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self);
	return result;
}


void
rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self,
                                               GFile* file,
                                               const gchar* content_type)
{
	Block4Data* _data4_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	gchar* _tmp3_;
	gchar* s = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (content_type != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (_data4_->file);
	_data4_->file = _tmp0_;
	_tmp1_ = g_strdup (content_type);
	_g_free0 (_data4_->content_type);
	_data4_->content_type = _tmp1_;
	_tmp2_ = self->priv->child_io_cancellable;
	if (g_cancellable_is_cancelled (_tmp2_)) {
		g_debug ("rygel-media-export-metadata-extractor.vala:253: Child apparently alrea" \
"dy died, scheduling command for later");
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda6__gsource_func, block4_data_ref (_data4_), block4_data_unref);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp3_ = g_file_get_uri (_data4_->file);
	_g_free0 (self->priv->error_uri);
	self->priv->error_uri = _tmp3_;
	_tmp4_ = g_file_get_uri (_data4_->file);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("EXTRACT %s|%s\n", _tmp5_, _data4_->content_type);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	s = _tmp7_;
	{
		GUnixOutputStream* _tmp8_;
		const gchar* _tmp9_;
		guint8* _tmp10_;
		gint _tmp10__length1;
		guint8* _tmp11_;
		gint _tmp11__length1;
		GCancellable* _tmp12_;
		GUnixOutputStream* _tmp13_;
		const gchar* _tmp14_;
		_tmp8_ = self->priv->input_stream;
		_tmp9_ = s;
		_tmp10_ = string_get_data (_tmp9_, &_tmp10__length1);
		_tmp11_ = _tmp10_;
		_tmp11__length1 = _tmp10__length1;
		_tmp12_ = self->priv->child_io_cancellable;
		g_output_stream_write_all ((GOutputStream*) _tmp8_, _tmp11_, (gsize) _tmp11__length1, NULL, _tmp12_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch29_g_error;
		}
		_tmp13_ = self->priv->input_stream;
		g_output_stream_flush ((GOutputStream*) _tmp13_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch29_g_error;
		}
		_tmp14_ = s;
		g_debug ("rygel-media-export-metadata-extractor.vala:268: Sent command to extrac" \
"tor process: %s", _tmp14_);
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_warning (_ ("Failed to send command to child: %s"), _tmp16_);
		_g_error_free0 (_error_);
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (s);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (s);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static gchar*
bool_to_string (gboolean self)
{
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void
rygel_media_export_metadata_extractor_on_config_changed (RygelMediaExportMetadataExtractor* self,
                                                         RygelConfiguration* config,
                                                         const gchar* section,
                                                         const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GUnixOutputStream* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (section, RYGEL_MEDIA_EXPORT_PLUGIN_NAME) != 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, "extract-metadata") != 0;
	}
	if (_tmp0_) {
		return;
	}
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = rygel_configuration_get_bool (config, RYGEL_MEDIA_EXPORT_PLUGIN_NAME, "extract-metadata", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
		self->priv->extract_metadata = _tmp1_;
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		self->priv->extract_metadata = TRUE;
		_g_error_free0 (_error_);
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp3_ = self->priv->input_stream;
	if (_tmp3_ != NULL) {
		GCancellable* _tmp4_;
		_tmp4_ = self->priv->child_io_cancellable;
		_tmp2_ = !g_cancellable_is_cancelled (_tmp4_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		{
			gchar* s = NULL;
			gboolean _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			GUnixOutputStream* _tmp10_;
			const gchar* _tmp11_;
			guint8* _tmp12_;
			gint _tmp12__length1;
			guint8* _tmp13_;
			gint _tmp13__length1;
			GUnixOutputStream* _tmp14_;
			const gchar* _tmp15_;
			_tmp5_ = self->priv->extract_metadata;
			_tmp6_ = bool_to_string (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup_printf ("METADATA %s\n", _tmp7_);
			_tmp9_ = _tmp8_;
			_g_free0 (_tmp7_);
			s = _tmp9_;
			_tmp10_ = self->priv->input_stream;
			_tmp11_ = s;
			_tmp12_ = string_get_data (_tmp11_, &_tmp12__length1);
			_tmp13_ = _tmp12_;
			_tmp13__length1 = _tmp12__length1;
			g_output_stream_write_all ((GOutputStream*) _tmp10_, _tmp13_, (gsize) _tmp13__length1, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (s);
				goto __catch31_g_error;
			}
			_tmp14_ = self->priv->input_stream;
			g_output_stream_flush ((GOutputStream*) _tmp14_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (s);
				goto __catch31_g_error;
			}
			_tmp15_ = s;
			g_debug ("rygel-media-export-metadata-extractor.vala:298: Sent config change to " \
"child: %s", _tmp15_);
			_g_free0 (s);
		}
		goto __finally31;
		__catch31_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp16_ = _error_;
			_tmp17_ = _tmp16_->message;
			g_debug ("rygel-media-export-metadata-extractor.vala:300: Failed to set meta-dat" \
"a extraction state: %s", _tmp17_);
			_g_error_free0 (_error_);
		}
		__finally31:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void
g_cclosure_user_marshal_VOID__OBJECT_VARIANT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_VARIANT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_VARIANT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_VARIANT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_variant (param_values + 2), data2);
}


static void
g_cclosure_user_marshal_VOID__OBJECT_POINTER (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static void
rygel_media_export_metadata_extractor_class_init (RygelMediaExportMetadataExtractorClass * klass)
{
	GVariantType* _tmp0_;
	rygel_media_export_metadata_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaExportMetadataExtractor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_metadata_extractor_finalize;
	rygel_media_export_metadata_extractor_signals[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_EXTRACTION_DONE_SIGNAL] = g_signal_new ("extraction-done", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_VARIANT, G_TYPE_NONE, 2, g_file_get_type (), G_TYPE_VARIANT);
	/**
	     * Signalize that an error occured during metadata extraction
	     */
	rygel_media_export_metadata_extractor_signals[RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_ERROR_SIGNAL] = g_signal_new ("error", RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_POINTER, G_TYPE_NONE, 2, g_file_get_type (), G_TYPE_POINTER);
	_tmp0_ = g_variant_type_new ("a{sv}");
	_g_variant_type_free0 (rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE);
	rygel_media_export_metadata_extractor_SERIALIZED_DATA_TYPE = _tmp0_;
}


static void
rygel_media_export_metadata_extractor_instance_init (RygelMediaExportMetadataExtractor * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	self->priv = rygel_media_export_metadata_extractor_get_instance_private (self);
	self->priv->error_uri = NULL;
	_tmp0_ = g_strdup (MX_EXTRACT_PATH);
	_tmp1_ = g_strdup ("--input-fd=3");
	_tmp2_ = g_strdup ("--output-fd=4");
	_tmp3_ = g_strdup ("--extract-metadata");
	_tmp4_ = g_new0 (gchar*, 5 + 1);
	_tmp4_[0] = _tmp0_;
	_tmp4_[1] = _tmp1_;
	_tmp4_[2] = _tmp2_;
	_tmp4_[3] = _tmp3_;
	_tmp4_[4] = NULL;
	self->priv->MX_EXTRACT_ARGV = _tmp4_;
	self->priv->MX_EXTRACT_ARGV_length1 = 5;
	self->priv->_MX_EXTRACT_ARGV_size_ = self->priv->MX_EXTRACT_ARGV_length1;
}


static void
rygel_media_export_metadata_extractor_finalize (GObject * obj)
{
	RygelMediaExportMetadataExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor);
	_g_object_unref0 (self->priv->input_stream);
	_g_object_unref0 (self->priv->output_stream);
	_g_object_unref0 (self->priv->child_io_cancellable);
	_g_object_unref0 (self->priv->launcher);
	_g_free0 (self->priv->error_uri);
	self->priv->MX_EXTRACT_ARGV = (_vala_array_free (self->priv->MX_EXTRACT_ARGV, self->priv->MX_EXTRACT_ARGV_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (rygel_media_export_metadata_extractor_parent_class)->finalize (obj);
}


/**
 * Metadata extractor based on Gstreamer. Just set the URI of the media on the
 * uri property, it will extact the metadata for you and emit signal
 * metadata_available for each key/value pair extracted.
 */
GType
rygel_media_export_metadata_extractor_get_type (void)
{
	static volatile gsize rygel_media_export_metadata_extractor_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_metadata_extractor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMetadataExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_metadata_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMetadataExtractor), 0, (GInstanceInitFunc) rygel_media_export_metadata_extractor_instance_init, NULL };
		GType rygel_media_export_metadata_extractor_type_id;
		rygel_media_export_metadata_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMetadataExtractor", &g_define_type_info, 0);
		RygelMediaExportMetadataExtractor_private_offset = g_type_add_instance_private (rygel_media_export_metadata_extractor_type_id, sizeof (RygelMediaExportMetadataExtractorPrivate));
		g_once_init_leave (&rygel_media_export_metadata_extractor_type_id__volatile, rygel_media_export_metadata_extractor_type_id);
	}
	return rygel_media_export_metadata_extractor_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



