/* rygel-main.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-main.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2012 Openismus GmbH.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2014 Jens Georg <mail@jensge.org>
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *         Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <glib.h>
#include <rygel-core.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <glib-unix.h>
#include <signal.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <libgssdp/gssdp.h>
#include <locale.h>
#include <unistd.h>

#define RYGEL_TYPE_MAIN (rygel_main_get_type ())
#define RYGEL_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MAIN, RygelMain))
#define RYGEL_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MAIN, RygelMainClass))
#define RYGEL_IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MAIN))
#define RYGEL_IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MAIN))
#define RYGEL_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MAIN, RygelMainClass))

typedef struct _RygelMain RygelMain;
typedef struct _RygelMainClass RygelMainClass;
typedef struct _RygelMainPrivate RygelMainPrivate;

#define RYGEL_TYPE_ACL (rygel_acl_get_type ())
#define RYGEL_ACL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ACL, RygelAcl))
#define RYGEL_ACL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ACL, RygelAclClass))
#define RYGEL_IS_ACL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ACL))
#define RYGEL_IS_ACL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ACL))
#define RYGEL_ACL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ACL, RygelAclClass))

typedef struct _RygelAcl RygelAcl;
typedef struct _RygelAclClass RygelAclClass;
enum  {
	RYGEL_MAIN_0_PROPERTY,
	RYGEL_MAIN_NUM_PROPERTIES
};
static GParamSpec* rygel_main_properties[RYGEL_MAIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMainCreateDeviceData RygelMainCreateDeviceData;

#define RYGEL_TYPE_DBUS_SERVICE (rygel_dbus_service_get_type ())
#define RYGEL_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusService))
#define RYGEL_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))
#define RYGEL_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DBUS_SERVICE))
#define RYGEL_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DBUS_SERVICE, RygelDBusServiceClass))

typedef struct _RygelDBusService RygelDBusService;
typedef struct _RygelDBusServiceClass RygelDBusServiceClass;

struct _RygelMain {
	GObject parent_instance;
	RygelMainPrivate * priv;
	gboolean need_restart;
};

struct _RygelMainClass {
	GObjectClass parent_class;
};

struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	GUPnPContextManager* context_manager;
	GeeArrayList* factories;
	GeeArrayList* root_devices;
	RygelConfiguration* config;
	RygelLogHandler* log_handler;
	RygelAcl* acl;
	GMainLoop* main_loop;
	gint exit_code;
};

struct _RygelMainCreateDeviceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	RygelMain* self;
	RygelPlugin* plugin;
	RygelRootDeviceFactory* factory;
	RygelRootDevice* device;
	RygelRootDevice* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GError* _error_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError * _inner_error_;
};

static gint RygelMain_private_offset;
static gpointer rygel_main_parent_class = NULL;
static gint rygel_main_PLUGIN_TIMEOUT;
static gint rygel_main_PLUGIN_TIMEOUT = 5;

GType rygel_main_get_type (void) G_GNUC_CONST;
GType rygel_acl_get_type (void) G_GNUC_CONST;
static RygelMain* rygel_main_new (GError** error);
static RygelMain* rygel_main_construct (GType object_type,
                                 GError** error);
RygelAcl* rygel_acl_new (void);
RygelAcl* rygel_acl_construct (GType object_type);
static void rygel_main_on_plugin_loaded (RygelMain* self,
                                  RygelPluginLoader* plugin_loader,
                                  RygelPlugin* plugin);
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender,
                                                                        RygelPlugin* plugin,
                                                                        gpointer self);
static gboolean __lambda6_ (RygelMain* self);
void rygel_main_restart (RygelMain* self);
static gboolean ___lambda6__gsource_func (gpointer self);
static gboolean __lambda7_ (RygelMain* self);
void rygel_main_exit (RygelMain* self,
                      gint exit_code);
static gboolean ___lambda7__gsource_func (gpointer self);
static gboolean __lambda8_ (RygelMain* self);
static gboolean ___lambda8__gsource_func (gpointer self);
static gint rygel_main_run (RygelMain* self);
void rygel_main_dbus_available (RygelMain* self);
static GUPnPContextManager* rygel_main_create_context_manager (RygelMain* self);
static gboolean __lambda9_ (RygelMain* self);
static gboolean ___lambda9__gsource_func (gpointer self);
static void rygel_main_create_device (RygelMain* self,
                               RygelPlugin* plugin,
                               RygelRootDeviceFactory* factory,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static void rygel_main_create_device_finish (RygelMain* self,
                                      GAsyncResult* _res_);
static void rygel_main_on_context_available (RygelMain* self,
                                      GUPnPContextManager* manager,
                                      GUPnPContext* context);
static void _rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender,
                                                                               GUPnPContext* context,
                                                                               gpointer self);
static void rygel_main_on_context_unavailable (RygelMain* self,
                                        GUPnPContextManager* manager,
                                        GUPnPContext* context);
static void _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender,
                                                                                   GUPnPContext* context,
                                                                                   gpointer self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      const gchar* needle);
static void rygel_main_create_device_data_free (gpointer _data);
static void rygel_main_create_device_async_ready_wrapper (GObject *source_object,
                                                   GAsyncResult *res,
                                                   void *user_data);
static gboolean rygel_main_create_device_co (RygelMainCreateDeviceData* _data_);
static gboolean _rygel_main_create_device_co_gsource_func (gpointer self);
static void rygel_main_on_plugin_active_notify (RygelMain* self,
                                         GObject* obj,
                                         GParamSpec* spec);
static void _rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void rygel_main_register_default_configurations (void);
static gint rygel_main_main (gchar** args,
                      gint args_length1);
GType rygel_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_dbus_service_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
RygelDBusService* rygel_dbus_service_new (RygelMain* main);
RygelDBusService* rygel_dbus_service_construct (GType object_type,
                                                RygelMain* main);
void rygel_dbus_service_publish (RygelDBusService* self);
void rygel_dbus_service_unpublish (RygelDBusService* self);
static void rygel_main_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
rygel_main_get_instance_private (RygelMain* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMain_private_offset);
}

static void
_rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender,
                                                                   RygelPlugin* plugin,
                                                                   gpointer self)
{
	rygel_main_on_plugin_loaded ((RygelMain*) self, _sender, plugin);
}

static gboolean
__lambda6_ (RygelMain* self)
{
	gboolean result = FALSE;
	rygel_main_restart (self);
	result = TRUE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((RygelMain*) self);
	return result;
}

static gboolean
__lambda7_ (RygelMain* self)
{
	gboolean result = FALSE;
	rygel_main_exit (self, 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ ((RygelMain*) self);
	return result;
}

static gboolean
__lambda8_ (RygelMain* self)
{
	gboolean result = FALSE;
	rygel_main_exit (self, 0);
	result = FALSE;
	return result;
}

static gboolean
___lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda8_ ((RygelMain*) self);
	return result;
}

static RygelMain*
rygel_main_construct (GType object_type,
                      GError** error)
{
	RygelMain * self = NULL;
	RygelLogHandler* _tmp0_;
	RygelMetaConfig* _tmp1_;
	RygelPluginLoader* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GMainLoop* _tmp5_;
	RygelAcl* _tmp6_;
	RygelPluginLoader* _tmp7_;
	self = (RygelMain*) g_object_new (object_type, NULL);
	g_set_application_name (_ (PACKAGE_NAME));
	_tmp0_ = rygel_log_handler_get_default ();
	_g_object_unref0 (self->priv->log_handler);
	self->priv->log_handler = _tmp0_;
	_tmp1_ = rygel_meta_config_get_default ();
	_g_object_unref0 (self->priv->config);
	self->priv->config = (RygelConfiguration*) _tmp1_;
	_tmp2_ = rygel_plugin_loader_new ();
	_g_object_unref0 (self->priv->plugin_loader);
	self->priv->plugin_loader = _tmp2_;
	_tmp3_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = _tmp3_;
	_tmp4_ = gee_array_list_new (RYGEL_TYPE_ROOT_DEVICE_FACTORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->factories);
	self->priv->factories = _tmp4_;
	_tmp5_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp5_;
	_tmp6_ = rygel_acl_new ();
	_g_object_unref0 (self->priv->acl);
	self->priv->acl = _tmp6_;
	self->priv->exit_code = 0;
	_tmp7_ = self->priv->plugin_loader;
	g_signal_connect_object (_tmp7_, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGHUP, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGINT, ___lambda7__gsource_func, g_object_ref (self), g_object_unref);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGTERM, ___lambda8__gsource_func, g_object_ref (self), g_object_unref);
	return self;
}

static RygelMain*
rygel_main_new (GError** error)
{
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
}

void
rygel_main_exit (RygelMain* self,
                 gint exit_code)
{
	GMainLoop* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->exit_code = exit_code;
	_g_object_unref0 (self->priv->root_devices);
	self->priv->root_devices = NULL;
	_tmp0_ = self->priv->main_loop;
	g_main_loop_quit (_tmp0_);
}

void
rygel_main_restart (RygelMain* self)
{
	g_return_if_fail (self != NULL);
	self->need_restart = TRUE;
	rygel_main_exit (self, 0);
}

static gint
rygel_main_run (RygelMain* self)
{
	gint result = 0;
	GMainLoop* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	g_message (_ ("Rygel v%s starting…"), PACKAGE_VERSION);
	_tmp0_ = self->priv->main_loop;
	g_main_loop_run (_tmp0_);
	result = self->priv->exit_code;
	return result;
}

static gboolean
__lambda9_ (RygelMain* self)
{
	gboolean result = FALSE;
	RygelPluginLoader* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	_tmp0_ = self->priv->plugin_loader;
	_tmp1_ = rygel_plugin_loader_list_plugins (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_size (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		g_warning (ngettext ("No plugins found in %d second; giving up…", "No plugins found in %d seconds; giving up…", (gulong) rygel_main_PLUGIN_TIMEOUT), rygel_main_PLUGIN_TIMEOUT);
		rygel_main_exit (self, -82);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda9_ ((RygelMain*) self);
	return result;
}

void
rygel_main_dbus_available (RygelMain* self)
{
	GUPnPContextManager* _tmp0_;
	RygelPluginLoader* _tmp1_;
	gint timeout = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = rygel_main_create_context_manager (self);
	_g_object_unref0 (self->priv->context_manager);
	self->priv->context_manager = _tmp0_;
	_tmp1_ = self->priv->plugin_loader;
	rygel_recursive_module_loader_load_modules ((RygelRecursiveModuleLoader*) _tmp1_);
	timeout = rygel_main_PLUGIN_TIMEOUT;
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp2_;
		gint _tmp3_ = 0;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		_tmp3_ = rygel_configuration_get_int ((RygelConfiguration*) config, "plugin", "TIMEOUT", 0, G_MAXINT, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch5_g_error;
		}
		timeout = _tmp3_;
		_g_object_unref0 (config);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (timeout == 0) {
		g_debug ("rygel-main.vala:106: Plugin timeout disabled...");
		return;
	}
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) timeout, ___lambda9__gsource_func, g_object_ref (self), g_object_unref);
}

static void
rygel_main_on_plugin_loaded (RygelMain* self,
                             RygelPluginLoader* plugin_loader,
                             RygelPlugin* plugin)
{
	GeeIterator* iterator = NULL;
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_loader != NULL);
	g_return_if_fail (plugin != NULL);
	_tmp0_ = self->priv->factories;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iterator = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		gpointer _tmp4_;
		RygelRootDeviceFactory* _tmp5_;
		_tmp2_ = iterator;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iterator;
		_tmp4_ = gee_iterator_get (_tmp3_);
		_tmp5_ = (RygelRootDeviceFactory*) _tmp4_;
		rygel_main_create_device (self, plugin, _tmp5_, NULL, NULL);
		_g_object_unref0 (_tmp5_);
	}
	_g_object_unref0 (iterator);
}

static void
_rygel_main_on_context_available_gupnp_context_manager_context_available (GUPnPContextManager* _sender,
                                                                          GUPnPContext* context,
                                                                          gpointer self)
{
	rygel_main_on_context_available ((RygelMain*) self, _sender, context);
}

static void
_rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable (GUPnPContextManager* _sender,
                                                                              GUPnPContext* context,
                                                                              gpointer self)
{
	rygel_main_on_context_unavailable ((RygelMain*) self, _sender, context);
}

static GUPnPContextManager*
rygel_main_create_context_manager (RygelMain* self)
{
	GUPnPContextManager* result = NULL;
	gint port = 0;
	GUPnPContextManager* manager = NULL;
	GUPnPContextManager* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	port = 0;
	{
		gint _tmp0_ = 0;
		RygelConfiguration* _tmp1_;
		_tmp1_ = self->priv->config;
		_tmp0_ = rygel_configuration_get_port (_tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		port = _tmp0_;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = gupnp_context_manager_create ((guint) port);
	manager = _tmp2_;
	g_signal_connect_object (manager, "context-available", (GCallback) _rygel_main_on_context_available_gupnp_context_manager_context_available, self, 0);
	g_signal_connect_object (manager, "context-unavailable", (GCallback) _rygel_main_on_context_unavailable_gupnp_context_manager_context_unavailable, self, 0);
	result = manager;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             const gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
rygel_main_on_context_available (RygelMain* self,
                                 GUPnPContextManager* manager,
                                 GUPnPContext* context)
{
	gchar** ifaces = NULL;
	gint ifaces_length1;
	gint _ifaces_size_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	RygelAcl* _tmp7_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	ifaces = NULL;
	ifaces_length1 = 0;
	_ifaces_size_ = ifaces_length1;
	_tmp0_ = gssdp_client_get_network ((GSSDPClient*) context);
	_tmp1_ = _tmp0_;
	_tmp2_ = gssdp_client_get_interface ((GSSDPClient*) context);
	_tmp3_ = _tmp2_;
	g_object_get ((GSSDPClient*) context, "host-ip", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	g_debug ("rygel-main.vala:153: New network %s (%s) context available. IP: %s", _tmp1_, _tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->acl;
	gupnp_context_set_acl (context, (GUPnPAcl*) _tmp7_);
	{
		gchar** _tmp8_ = NULL;
		RygelConfiguration* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp8__length1;
		gint __tmp8__size_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp9_ = self->priv->config;
		_tmp11_ = _tmp10_ = rygel_configuration_get_interfaces (_tmp9_, &_inner_error_);
		_tmp8_ = _tmp11_;
		_tmp8__length1 = _vala_array_length (_tmp10_);
		__tmp8__size_ = _tmp8__length1;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp12_ = _tmp8_;
		_tmp12__length1 = _tmp8__length1;
		_tmp8_ = NULL;
		_tmp8__length1 = 0;
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
		ifaces = _tmp12_;
		ifaces_length1 = _tmp12__length1;
		_ifaces_size_ = ifaces_length1;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (err);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp16_ = ifaces;
	_tmp16__length1 = ifaces_length1;
	if (_tmp16_ == NULL) {
		_tmp15_ = TRUE;
	} else {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp17_ = gssdp_client_get_interface ((GSSDPClient*) context);
		_tmp18_ = _tmp17_;
		_tmp19_ = ifaces;
		_tmp19__length1 = ifaces_length1;
		_tmp15_ = _vala_string_array_contains (_tmp19_, _tmp19__length1, _tmp18_);
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		_tmp20_ = gssdp_client_get_network ((GSSDPClient*) context);
		_tmp21_ = _tmp20_;
		_tmp22_ = ifaces;
		_tmp22__length1 = ifaces_length1;
		_tmp14_ = _vala_string_array_contains (_tmp22_, _tmp22__length1, _tmp21_);
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		g_object_get ((GSSDPClient*) context, "host-ip", &_tmp23_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = ifaces;
		_tmp26__length1 = ifaces_length1;
		_tmp13_ = _vala_string_array_contains (_tmp26_, _tmp26__length1, _tmp25_);
		_g_free0 (_tmp25_);
	}
	if (_tmp13_) {
		{
			RygelRootDeviceFactory* factory = NULL;
			RygelRootDeviceFactory* _tmp27_;
			GeeArrayList* _tmp28_;
			RygelRootDeviceFactory* _tmp29_;
			GeeIterator* iterator = NULL;
			RygelPluginLoader* _tmp30_;
			GeeCollection* _tmp31_;
			GeeCollection* _tmp32_;
			GeeIterator* _tmp33_;
			GeeIterator* _tmp34_;
			_tmp27_ = rygel_root_device_factory_new (context, &_inner_error_);
			factory = _tmp27_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch8_g_error;
			}
			_tmp28_ = self->priv->factories;
			_tmp29_ = factory;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp29_);
			_tmp30_ = self->priv->plugin_loader;
			_tmp31_ = rygel_plugin_loader_list_plugins (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
			_tmp34_ = _tmp33_;
			_g_object_unref0 (_tmp32_);
			iterator = _tmp34_;
			while (TRUE) {
				GeeIterator* _tmp35_;
				GeeIterator* _tmp36_;
				gpointer _tmp37_;
				RygelPlugin* _tmp38_;
				RygelRootDeviceFactory* _tmp39_;
				_tmp35_ = iterator;
				if (!gee_iterator_next (_tmp35_)) {
					break;
				}
				_tmp36_ = iterator;
				_tmp37_ = gee_iterator_get (_tmp36_);
				_tmp38_ = (RygelPlugin*) _tmp37_;
				_tmp39_ = factory;
				rygel_main_create_device (self, _tmp38_, _tmp39_, NULL, NULL);
				_g_object_unref0 (_tmp38_);
			}
			_g_object_unref0 (iterator);
			_g_object_unref0 (factory);
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* err = NULL;
			GError* _tmp40_;
			const gchar* _tmp41_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp40_ = err;
			_tmp41_ = _tmp40_->message;
			g_warning (_ ("Failed to create root device factory: %s"), _tmp41_);
			_g_error_free0 (err);
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	} else {
		const gchar* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		_tmp42_ = gssdp_client_get_network ((GSSDPClient*) context);
		_tmp43_ = _tmp42_;
		_tmp44_ = gssdp_client_get_interface ((GSSDPClient*) context);
		_tmp45_ = _tmp44_;
		g_debug ("rygel-main.vala:181: Ignoring network %s (%s) context.", _tmp43_, _tmp45_);
		g_object_set ((GSSDPClient*) context, "active", FALSE, NULL);
	}
	ifaces = (_vala_array_free (ifaces, ifaces_length1, (GDestroyNotify) g_free), NULL);
}

static void
rygel_main_on_context_unavailable (RygelMain* self,
                                   GUPnPContextManager* manager,
                                   GUPnPContext* context)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GeeIterator* factory_iter = NULL;
	GeeArrayList* _tmp7_;
	GeeIterator* _tmp8_;
	GeeIterator* device_iter = NULL;
	GeeArrayList* _tmp17_;
	GeeIterator* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = gssdp_client_get_network ((GSSDPClient*) context);
	_tmp1_ = _tmp0_;
	_tmp2_ = gssdp_client_get_interface ((GSSDPClient*) context);
	_tmp3_ = _tmp2_;
	g_object_get ((GSSDPClient*) context, "host-ip", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	g_debug ("rygel-main.vala:190: Network %s (%s) context now unavailable. IP: %s", _tmp1_, _tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->factories;
	_tmp8_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp7_);
	factory_iter = _tmp8_;
	while (TRUE) {
		GeeIterator* _tmp9_;
		GeeIterator* _tmp10_;
		gpointer _tmp11_;
		RygelRootDeviceFactory* _tmp12_;
		GUPnPContext* _tmp13_;
		GUPnPContext* _tmp14_;
		gboolean _tmp15_;
		_tmp9_ = factory_iter;
		if (!gee_iterator_next (_tmp9_)) {
			break;
		}
		_tmp10_ = factory_iter;
		_tmp11_ = gee_iterator_get (_tmp10_);
		_tmp12_ = (RygelRootDeviceFactory*) _tmp11_;
		_tmp13_ = rygel_root_device_factory_get_context (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = context == _tmp14_;
		_g_object_unref0 (_tmp12_);
		if (_tmp15_) {
			GeeIterator* _tmp16_;
			_tmp16_ = factory_iter;
			gee_iterator_remove (_tmp16_);
		}
	}
	_tmp17_ = self->priv->root_devices;
	_tmp18_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp17_);
	device_iter = _tmp18_;
	while (TRUE) {
		GeeIterator* _tmp19_;
		GeeIterator* _tmp20_;
		gpointer _tmp21_;
		RygelRootDevice* _tmp22_;
		GUPnPContext* _tmp23_;
		GUPnPContext* _tmp24_;
		gboolean _tmp25_;
		_tmp19_ = device_iter;
		if (!gee_iterator_next (_tmp19_)) {
			break;
		}
		_tmp20_ = device_iter;
		_tmp21_ = gee_iterator_get (_tmp20_);
		_tmp22_ = (RygelRootDevice*) _tmp21_;
		_tmp23_ = gupnp_device_info_get_context ((GUPnPDeviceInfo*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = context == _tmp24_;
		_g_object_unref0 (_tmp22_);
		if (_tmp25_) {
			GeeIterator* _tmp26_;
			_tmp26_ = device_iter;
			gee_iterator_remove (_tmp26_);
		}
	}
	_g_object_unref0 (device_iter);
	_g_object_unref0 (factory_iter);
}

static void
rygel_main_create_device_data_free (gpointer _data)
{
	RygelMainCreateDeviceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->plugin);
	_g_object_unref0 (_data_->factory);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMainCreateDeviceData, _data_);
}

static void
rygel_main_create_device_async_ready_wrapper (GObject *source_object,
                                              GAsyncResult *res,
                                              void *user_data)
{
	RygelMainCreateDeviceData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
rygel_main_create_device (RygelMain* self,
                          RygelPlugin* plugin,
                          RygelRootDeviceFactory* factory,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	RygelMainCreateDeviceData* _data_;
	RygelMain* _tmp0_;
	RygelPlugin* _tmp1_;
	RygelRootDeviceFactory* _tmp2_;
	_data_ = g_slice_new0 (RygelMainCreateDeviceData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, rygel_main_create_device_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, rygel_main_create_device_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (plugin);
	_g_object_unref0 (_data_->plugin);
	_data_->plugin = _tmp1_;
	_tmp2_ = _g_object_ref0 (factory);
	_g_object_unref0 (_data_->factory);
	_data_->factory = _tmp2_;
	rygel_main_create_device_co (_data_);
}

static void
rygel_main_create_device_finish (RygelMain* self,
                                 GAsyncResult* _res_)
{
	RygelMainCreateDeviceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_rygel_main_create_device_co_gsource_func (gpointer self)
{
	gboolean result;
	result = rygel_main_create_device_co (self);
	return result;
}

static void
_rygel_main_on_plugin_active_notify_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	rygel_main_on_plugin_active_notify ((RygelMain*) self, _sender, pspec);
}

static gboolean
rygel_main_create_device_co (RygelMainCreateDeviceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_main_create_device_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	{
		_data_->_tmp0_ = rygel_root_device_factory_create (_data_->factory, _data_->plugin, &_data_->_inner_error_);
		_data_->device = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
		_data_->_tmp1_ = rygel_plugin_get_active (_data_->plugin);
		_data_->_tmp2_ = _data_->_tmp1_;
		gupnp_root_device_set_available ((GUPnPRootDevice*) _data_->device, _data_->_tmp2_);
		_data_->_tmp3_ = _data_->self->priv->root_devices;
		if (_data_->_tmp3_ != NULL) {
			_data_->_tmp4_ = _data_->self->priv->root_devices;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp4_, _data_->device);
			g_signal_connect_object ((GObject*) _data_->plugin, "notify::active", (GCallback) _rygel_main_on_plugin_active_notify_g_object_notify, _data_->self, 0);
		}
		_g_object_unref0 (_data_->device);
	}
	goto __finally9;
	__catch9_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp5_ = rygel_plugin_get_name (_data_->plugin);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _data_->_error_;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning (_ ("Failed to create RootDevice for %s. Reason: %s"), _data_->_tmp6_, _data_->_tmp8_);
		_g_error_free0 (_data_->_error_);
	}
	__finally9:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
rygel_main_on_plugin_active_notify (RygelMain* self,
                                    GObject* obj,
                                    GParamSpec* spec)
{
	GeeArrayList* _tmp0_;
	RygelPlugin* plugin = NULL;
	RygelPlugin* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = self->priv->root_devices;
	if (G_UNLIKELY (_tmp0_ == NULL)) {
		return;
	}
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (obj, RYGEL_TYPE_PLUGIN) ? ((RygelPlugin*) obj) : NULL);
	plugin = _tmp1_;
	{
		GeeArrayList* _device_list = NULL;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		gint _device_size = 0;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _device_index = 0;
		_tmp2_ = self->priv->root_devices;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_device_list = _tmp3_;
		_tmp4_ = _device_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_device_size = _tmp6_;
		_device_index = -1;
		while (TRUE) {
			RygelRootDevice* device = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			RygelRootDevice* _tmp9_;
			GUPnPResourceFactory* _tmp10_;
			GUPnPResourceFactory* _tmp11_;
			RygelPlugin* _tmp12_;
			_device_index = _device_index + 1;
			if (!(_device_index < _device_size)) {
				break;
			}
			_tmp7_ = _device_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _device_index);
			device = (RygelRootDevice*) _tmp8_;
			_tmp9_ = device;
			_tmp10_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = plugin;
			if (_tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gupnp_resource_factory_get_type (), GUPnPResourceFactory)) {
				RygelRootDevice* _tmp13_;
				RygelPlugin* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp13_ = device;
				_tmp14_ = plugin;
				_tmp15_ = rygel_plugin_get_active (_tmp14_);
				_tmp16_ = _tmp15_;
				gupnp_root_device_set_available ((GUPnPRootDevice*) _tmp13_, _tmp16_);
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_list);
	}
	_g_object_unref0 (plugin);
}

static void
rygel_main_register_default_configurations (void)
{
	RygelCmdlineConfig* cmdline_config = NULL;
	RygelCmdlineConfig* _tmp0_;
	RygelCmdlineConfig* _tmp1_;
	RygelEnvironmentConfig* _tmp2_;
	RygelEnvironmentConfig* _tmp3_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_cmdline_config_get_default ();
	cmdline_config = _tmp0_;
	_tmp1_ = cmdline_config;
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp1_);
	_tmp2_ = rygel_environment_config_get_default ();
	_tmp3_ = _tmp2_;
	rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		gchar* config_file = NULL;
		RygelCmdlineConfig* _tmp4_;
		gchar* _tmp5_;
		RygelUserConfig* user_config = NULL;
		const gchar* _tmp6_;
		RygelUserConfig* _tmp7_;
		RygelUserConfig* _tmp8_;
		_tmp4_ = cmdline_config;
		_tmp5_ = rygel_cmdline_config_get_config_file (_tmp4_, &_inner_error_);
		config_file = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
		_tmp6_ = config_file;
		_tmp7_ = rygel_user_config_new (_tmp6_, &_inner_error_);
		user_config = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (config_file);
			goto __catch10_g_error;
		}
		_tmp8_ = user_config;
		rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp8_);
		_g_object_unref0 (user_config);
		_g_free0 (config_file);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			RygelUserConfig* user_config = NULL;
			RygelUserConfig* _tmp9_;
			RygelUserConfig* _tmp10_;
			_tmp9_ = rygel_user_config_get_default (&_inner_error_);
			user_config = _tmp9_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch11_g_error;
			}
			_tmp10_ = user_config;
			rygel_meta_config_register_configuration ((RygelConfiguration*) _tmp10_);
			_g_object_unref0 (user_config);
		}
		goto __finally11;
		__catch11_g_error:
		{
			GError* err = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			err = _inner_error_;
			_inner_error_ = NULL;
			_tmp11_ = err;
			_tmp12_ = _tmp11_->message;
			g_warning (_ ("Failed to load user configuration: %s"), _tmp12_);
			_g_error_free0 (err);
		}
		__finally11:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_error_free0 (_error_);
			_g_error_free0 (_error_);
			_g_object_unref0 (cmdline_config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_error_free0 (_error_);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (cmdline_config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (cmdline_config);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gint
rygel_main_main (gchar** args,
                 gint args_length1)
{
	gint result = 0;
	RygelMain* main = NULL;
	RygelDBusService* service = NULL;
	gchar** original_args = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint original_args_length1;
	gint _original_args_size_;
	gint exit_code = 0;
	RygelMain* _tmp9_;
	RygelDBusService* _tmp10_;
	RygelMain* _tmp12_;
	GError * _inner_error_ = NULL;
	main = NULL;
	service = NULL;
	_tmp0_ = (args != NULL) ? _vala_array_dup1 (args, args_length1) : ((gpointer) args);
	_tmp0__length1 = args_length1;
	original_args = _tmp0_;
	original_args_length1 = _tmp0__length1;
	_original_args_size_ = original_args_length1;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	{
		RygelMain* _tmp1_ = NULL;
		RygelMain* _tmp2_;
		RygelMain* _tmp3_;
		RygelMain* _tmp4_;
		RygelDBusService* _tmp5_;
		RygelDBusService* _tmp6_;
		rygel_cmdline_config_parse_args (&args, (gint*) (&args_length1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch12_rygel_cmdline_config_error_version_only;
			}
			goto __catch12_g_error;
		}
		rygel_main_register_default_configurations ();
		_tmp2_ = rygel_main_new (&_inner_error_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, RYGEL_CMDLINE_CONFIG_ERROR, RYGEL_CMDLINE_CONFIG_ERROR_VERSION_ONLY)) {
				goto __catch12_rygel_cmdline_config_error_version_only;
			}
			goto __catch12_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (main);
		main = _tmp3_;
		_tmp4_ = main;
		_tmp5_ = rygel_dbus_service_new (_tmp4_);
		_g_object_unref0 (service);
		service = _tmp5_;
		_tmp6_ = service;
		rygel_dbus_service_publish (_tmp6_);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally12;
	__catch12_rygel_cmdline_config_error_version_only:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		result = 0;
		_g_error_free0 (err);
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (service);
		_g_object_unref0 (main);
		return result;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = err->message;
		g_error ("rygel-main.vala:301: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp8_ = -1;
		original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (service);
		_g_object_unref0 (main);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp8_;
	}
	_tmp9_ = main;
	exit_code = rygel_main_run (_tmp9_);
	_tmp10_ = service;
	if (_tmp10_ != NULL) {
		RygelDBusService* _tmp11_;
		_tmp11_ = service;
		rygel_dbus_service_unpublish (_tmp11_);
	}
	_tmp12_ = main;
	if (_tmp12_->need_restart) {
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		_tmp13_ = original_args;
		_tmp13__length1 = original_args_length1;
		_tmp14_ = _tmp13_[0];
		_tmp15_ = original_args;
		_tmp15__length1 = original_args_length1;
		execvp (_tmp14_, _tmp15_);
	}
	result = exit_code;
	original_args = (_vala_array_free (original_args, original_args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (service);
	_g_object_unref0 (main);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return rygel_main_main (argv, argc);
}

static void
rygel_main_class_init (RygelMainClass * klass)
{
	rygel_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMain_private_offset);
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
}

static void
rygel_main_instance_init (RygelMain * self)
{
	self->priv = rygel_main_get_instance_private (self);
}

static void
rygel_main_finalize (GObject * obj)
{
	RygelMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MAIN, RygelMain);
	_g_object_unref0 (self->priv->plugin_loader);
	_g_object_unref0 (self->priv->context_manager);
	_g_object_unref0 (self->priv->factories);
	_g_object_unref0 (self->priv->root_devices);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->log_handler);
	_g_object_unref0 (self->priv->acl);
	_g_main_loop_unref0 (self->priv->main_loop);
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
}

GType
rygel_main_get_type (void)
{
	static volatile gsize rygel_main_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		GType rygel_main_type_id;
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
		RygelMain_private_offset = g_type_add_instance_private (rygel_main_type_id, sizeof (RygelMainPrivate));
		g_once_init_leave (&rygel_main_type_id__volatile, rygel_main_type_id);
	}
	return rygel_main_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

