/* valadoc.c generated by valac, the Vala compiler
 * generated from valadoc.vala, do not modify */

/* valadoc.vala
 *
 * Copyright (C) 2008-2014 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valadoc.h>
#include <stdio.h>
#include <vala.h>
#include <locale.h>
#include <glib/gstdio.h>

#define TYPE_VALA_DOC (vala_doc_get_type ())
#define VALA_DOC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VALA_DOC, ValaDoc))
#define VALA_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VALA_DOC, ValaDocClass))
#define IS_VALA_DOC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VALA_DOC))
#define IS_VALA_DOC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VALA_DOC))
#define VALA_DOC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VALA_DOC, ValaDocClass))

typedef struct _ValaDoc ValaDoc;
typedef struct _ValaDocClass ValaDocClass;
typedef struct _ValaDocPrivate ValaDocPrivate;
enum  {
	VALA_DOC_0_PROPERTY,
	VALA_DOC_NUM_PROPERTIES
};
static GParamSpec* vala_doc_properties[VALA_DOC_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define VALADOC_DRIVERS_TYPE_DRIVER (valadoc_drivers_driver_get_type ())
#define VALADOC_DRIVERS_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALADOC_DRIVERS_TYPE_DRIVER, ValadocDriversDriver))
#define VALADOC_DRIVERS_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALADOC_DRIVERS_TYPE_DRIVER, ValadocDriversDriverClass))
#define VALADOC_DRIVERS_IS_DRIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALADOC_DRIVERS_TYPE_DRIVER))
#define VALADOC_DRIVERS_IS_DRIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALADOC_DRIVERS_TYPE_DRIVER))
#define VALADOC_DRIVERS_DRIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALADOC_DRIVERS_TYPE_DRIVER, ValadocDriversDriverClass))

typedef struct _ValadocDriversDriver ValadocDriversDriver;
typedef struct _ValadocDriversDriverClass ValadocDriversDriverClass;
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaDoc {
	GObject parent_instance;
	ValaDocPrivate * priv;
};

struct _ValaDocClass {
	GObjectClass parent_class;
};

static gpointer vala_doc_parent_class = NULL;
static gchar* vala_doc_wikidirectory;
static gchar* vala_doc_wikidirectory = NULL;
static gchar* vala_doc_pkg_version;
static gchar* vala_doc_pkg_version = NULL;
static gchar* vala_doc_docletpath;
static gchar* vala_doc_docletpath = NULL;
static gchar** vala_doc_pluginargs;
static gchar** vala_doc_pluginargs = NULL;
static gchar* vala_doc_directory;
static gchar* vala_doc_directory = NULL;
static gchar* vala_doc_pkg_name;
static gchar* vala_doc_pkg_name = NULL;
static gchar* vala_doc_gir_name;
static gchar* vala_doc_gir_name = NULL;
static gchar* vala_doc_gir_namespace;
static gchar* vala_doc_gir_namespace = NULL;
static gchar* vala_doc_gir_version;
static gchar* vala_doc_gir_version = NULL;
static gchar* vala_doc_driverpath;
static gchar* vala_doc_driverpath = NULL;
static gboolean vala_doc_add_inherited;
static gboolean vala_doc_add_inherited = FALSE;
static gboolean vala_doc__protected;
static gboolean vala_doc__protected = TRUE;
static gboolean vala_doc__internal;
static gboolean vala_doc__internal = FALSE;
static gboolean vala_doc_with_deps;
static gboolean vala_doc_with_deps = FALSE;
static gboolean vala_doc__private;
static gboolean vala_doc__private = FALSE;
static gboolean vala_doc_version;
static gboolean vala_doc_version = FALSE;
static gboolean vala_doc_use_svg_images;
static gboolean vala_doc_use_svg_images = FALSE;
static gboolean vala_doc_disable_diagnostic_colors;
static gboolean vala_doc_disable_diagnostic_colors = FALSE;
static gboolean vala_doc_verbose;
static gboolean vala_doc_verbose = FALSE;
static gboolean vala_doc_force;
static gboolean vala_doc_force = FALSE;
static gboolean vala_doc_fatal_warnings;
static gboolean vala_doc_fatal_warnings = FALSE;
static gchar* vala_doc_basedir;
static gchar* vala_doc_basedir = NULL;
static gchar** vala_doc_defines;
static gchar** vala_doc_defines = NULL;
static gboolean vala_doc_experimental;
static gboolean vala_doc_experimental = FALSE;
static gboolean vala_doc_experimental_non_null;
static gboolean vala_doc_experimental_non_null = FALSE;
static gchar* vala_doc_profile;
static gchar* vala_doc_profile = NULL;
static gchar** vala_doc_import_packages;
static gchar** vala_doc_import_packages = NULL;
static gchar** vala_doc_import_directories;
static gchar** vala_doc_import_directories = NULL;
static gchar** vala_doc_vapi_directories;
static gchar** vala_doc_vapi_directories = NULL;
static gchar** vala_doc_metadata_directories;
static gchar** vala_doc_metadata_directories = NULL;
static gchar** vala_doc_gir_directories;
static gchar** vala_doc_gir_directories = NULL;
static gchar** vala_doc_tsources;
static gchar** vala_doc_tsources = NULL;
static gchar** vala_doc_packages;
static gchar** vala_doc_packages = NULL;
static gchar** vala_doc_alternative_resource_dirs;
static gchar** vala_doc_alternative_resource_dirs = NULL;
static gchar* vala_doc_target_glib;
static gchar* vala_doc_target_glib = NULL;

GType vala_doc_get_type (void) G_GNUC_CONST;
#define VALA_DOC_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gint vala_doc_quit (ValadocErrorReporter* reporter);
static gboolean vala_doc_check_pkg_name (void);
static gchar* vala_doc_get_pkg_name (ValaDoc* self);
static ValadocModuleLoader* vala_doc_create_module_loader (ValaDoc* self,
                                                    ValadocErrorReporter* reporter,
                                                    ValadocDoclet* * doclet,
                                                    ValadocDriver* * driver);
ValadocDriversDriver* valadoc_drivers_driver_new (void);
ValadocDriversDriver* valadoc_drivers_driver_construct (GType object_type);
GType valadoc_drivers_driver_get_type (void) G_GNUC_CONST;
static gint vala_doc_run (ValaDoc* self,
                   ValadocErrorReporter* reporter);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
static gchar** _vala_array_dup2 (gchar** self,
                          int length);
static gchar** _vala_array_dup3 (gchar** self,
                          int length);
static gchar** _vala_array_dup4 (gchar** self,
                          int length);
static gchar** _vala_array_dup5 (gchar** self,
                          int length);
static gchar** _vala_array_dup6 (gchar** self,
                          int length);
static gchar** _vala_array_dup7 (gchar** self,
                          int length);
static gchar** _vala_array_dup8 (gchar** self,
                          int length);
static gint vala_doc_main (gchar** args,
                    gint args_length1);
ValaDoc* vala_doc_new (void);
ValaDoc* vala_doc_construct (GType object_type);
static void vala_doc_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_DOC_options[33] = {{"directory", 'o', 0, G_OPTION_ARG_FILENAME, &vala_doc_directory, "Output directory", "DIRECTORY"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_doc_basedir, "Base source directory", "DIRECTORY"}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_defines, "Define SYMBOL", "SYMBOL..."}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_profile, "Use the given profile instead of the default", "PROFILE"}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_experimental, "Enable experimental features", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"driver", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_driverpath, "Name of an driver or path to a custom driver", NULL}, {"importdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_import_directories, "Look for external documentation in DIRECTORY", "DIRECTORY..."}, {"import", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_import_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"alternative-resource-dir", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_alternative_resource_dirs, "Alternative resource directories", "DIRECTORY..."}, {"wiki", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_doc_wikidirectory, "Wiki directory", "DIRECTORY"}, {"deps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_with_deps, "Adds packages to the documentation", NULL}, {"doclet", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_docletpath, "Name of an included doclet or path to custom doclet", "PLUGIN"}, {"doclet-arg", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_doc_pluginargs, "Pass arguments to the doclet", "ARG"}, {"no-protected", (gchar) 0, (gint) G_OPTION_FLAG_REVERSE, G_OPTION_ARG_NONE, &vala_doc__protected, "Removes protected elements from documentation", NULL}, {"internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc__internal, "Adds internal elements to documentation", NULL}, {"private", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc__private, "Adds private elements to documentation", NULL}, {"use-svg-images", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_use_svg_images, "Generate SVG image charts instead of PNG", NULL}, {"package-name", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_pkg_name, "package name", "NAME"}, {"package-version", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_pkg_version, "package version", "VERSION"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_gir_name, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_version, "Display version number", NULL}, {"force", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_force, "force", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_fatal_warnings, "Treat warnings as fatal", NULL}, {"verbose", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_verbose, "Show all warnings", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_doc_disable_diagnostic_colors, "Disable colored output", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_doc_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_doc_tsources, NULL, "FILE..."}, {NULL}};

static gint
vala_doc_quit (ValadocErrorReporter* reporter)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (reporter != NULL, 0);
	_tmp1_ = valadoc_error_reporter_get_errors (reporter);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		gboolean _tmp3_ = FALSE;
		if (!vala_doc_fatal_warnings) {
			_tmp3_ = TRUE;
		} else {
			gint _tmp4_;
			gint _tmp5_;
			_tmp4_ = valadoc_error_reporter_get_warnings (reporter);
			_tmp5_ = _tmp4_;
			_tmp3_ = _tmp5_ == 0;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FILE* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = stdout;
		_tmp7_ = valadoc_error_reporter_get_warnings (reporter);
		_tmp8_ = _tmp7_;
		fprintf (_tmp6_, "Succeeded - %d warning(s)\n", _tmp8_);
		result = 0;
		return result;
	} else {
		FILE* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp9_ = stdout;
		_tmp10_ = valadoc_error_reporter_get_errors (reporter);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_error_reporter_get_warnings (reporter);
		_tmp13_ = _tmp12_;
		fprintf (_tmp9_, "Failed: %d error(s), %d warning(s)\n", _tmp11_, _tmp13_);
		result = 1;
		return result;
	}
}

static gboolean
vala_doc_check_pkg_name (void)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	_tmp0_ = vala_doc_pkg_name;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp2_ = vala_doc_pkg_name;
	if (g_strcmp0 (_tmp2_, "glib-2.0") == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = vala_doc_pkg_name;
		_tmp1_ = g_strcmp0 (_tmp3_, "gobject-2.0") == 0;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = vala_doc_tsources;
	_tmp4__length1 = _vala_array_length (vala_doc_tsources);
	{
		gchar** package_collection = NULL;
		gint package_collection_length1 = 0;
		gint _package_collection_size_ = 0;
		gint package_it = 0;
		package_collection = _tmp4_;
		package_collection_length1 = _tmp4__length1;
		for (package_it = 0; package_it < _tmp4__length1; package_it = package_it + 1) {
			gchar* _tmp5_;
			gchar* package = NULL;
			_tmp5_ = g_strdup (package_collection[package_it]);
			package = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = vala_doc_pkg_name;
				_tmp7_ = package;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					result = FALSE;
					_g_free0 (package);
					return result;
				}
				_g_free0 (package);
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
vala_doc_get_pkg_name (ValaDoc* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_doc_pkg_name;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		_tmp1_ = vala_doc_directory;
		if (g_str_has_suffix (_tmp1_, "/")) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = vala_doc_directory;
			_tmp3_ = g_path_get_dirname (_tmp2_);
			_g_free0 (vala_doc_pkg_name);
			vala_doc_pkg_name = _tmp3_;
		} else {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = vala_doc_directory;
			_tmp5_ = g_path_get_basename (_tmp4_);
			_g_free0 (vala_doc_pkg_name);
			vala_doc_pkg_name = _tmp5_;
		}
	}
	_tmp6_ = vala_doc_pkg_name;
	_tmp7_ = g_strdup (_tmp6_);
	result = _tmp7_;
	return result;
}

static ValadocModuleLoader*
vala_doc_create_module_loader (ValaDoc* self,
                               ValadocErrorReporter* reporter,
                               ValadocDoclet* * doclet,
                               ValadocDriver* * driver)
{
	ValadocDoclet* _vala_doclet = NULL;
	ValadocDriver* _vala_driver = NULL;
	ValadocModuleLoader* result = NULL;
	ValadocModuleLoader* modules = NULL;
	ValadocModuleLoader* _tmp0_;
	gchar* pluginpath = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	ValadocModuleLoader* _tmp4_;
	const gchar* _tmp5_;
	ValadocDoclet* _tmp6_;
	ValadocDoclet* _tmp7_;
	ValadocDriversDriver* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValadocDriver* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	_tmp0_ = valadoc_module_loader_get_instance ();
	modules = _tmp0_;
	_g_object_unref0 (_vala_doclet);
	_vala_doclet = NULL;
	_g_object_unref0 (_vala_driver);
	_vala_driver = NULL;
	_tmp1_ = vala_doc_docletpath;
	_tmp2_ = valadoc_module_loader_get_doclet_path (_tmp1_, reporter);
	pluginpath = _tmp2_;
	_tmp3_ = pluginpath;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_free0 (pluginpath);
		_g_object_unref0 (modules);
		if (doclet) {
			*doclet = _vala_doclet;
		} else {
			_g_object_unref0 (_vala_doclet);
		}
		if (driver) {
			*driver = _vala_driver;
		} else {
			_g_object_unref0 (_vala_driver);
		}
		return result;
	}
	_tmp4_ = modules;
	_tmp5_ = pluginpath;
	_tmp6_ = valadoc_module_loader_create_doclet (_tmp4_, _tmp5_);
	_g_object_unref0 (_vala_doclet);
	_vala_doclet = _tmp6_;
	_tmp7_ = _vala_doclet;
	if (_tmp7_ == NULL) {
		valadoc_error_reporter_simple_error (reporter, NULL, "failed to load doclet");
		result = NULL;
		_g_free0 (pluginpath);
		_g_object_unref0 (modules);
		if (doclet) {
			*doclet = _vala_doclet;
		} else {
			_g_object_unref0 (_vala_doclet);
		}
		if (driver) {
			*driver = _vala_driver;
		} else {
			_g_object_unref0 (_vala_driver);
		}
		return result;
	}
	_tmp8_ = valadoc_drivers_driver_new ();
	_g_object_unref0 (_vala_driver);
	_vala_driver = (ValadocDriver*) _tmp8_;
	_tmp10_ = _vala_driver;
	if (_tmp10_ != NULL) {
		ValadocDoclet* _tmp11_;
		_tmp11_ = _vala_doclet;
		_tmp9_ = _tmp11_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	_vala_assert (_tmp9_, "driver != null && doclet != null");
	result = modules;
	_g_free0 (pluginpath);
	if (doclet) {
		*doclet = _vala_doclet;
	} else {
		_g_object_unref0 (_vala_doclet);
	}
	if (driver) {
		*driver = _vala_driver;
	} else {
		_g_object_unref0 (_vala_driver);
	}
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gchar**
_vala_array_dup5 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gchar**
_vala_array_dup6 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gchar**
_vala_array_dup7 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gchar**
_vala_array_dup8 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static gint
vala_doc_run (ValaDoc* self,
              ValadocErrorReporter* reporter)
{
	gint result = 0;
	ValadocSettings* settings = NULL;
	ValadocSettings* _tmp0_;
	ValadocSettings* _tmp1_;
	ValadocSettings* _tmp2_;
	gchar* _tmp3_;
	ValadocSettings* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	ValadocSettings* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	ValadocSettings* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	ValadocSettings* _tmp25_;
	ValadocSettings* _tmp26_;
	ValadocSettings* _tmp27_;
	ValadocSettings* _tmp28_;
	ValadocSettings* _tmp29_;
	ValadocSettings* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	ValadocSettings* _tmp33_;
	ValadocSettings* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	ValadocSettings* _tmp37_;
	gchar** _tmp38_;
	gint _tmp38__length1;
	gchar** _tmp39_;
	gint _tmp39__length1;
	ValadocSettings* _tmp40_;
	ValadocSettings* _tmp41_;
	ValadocSettings* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	ValadocSettings* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	ValadocSettings* _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar** _tmp50_;
	gint _tmp50__length1;
	ValadocSettings* _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	gchar** _tmp53_;
	gint _tmp53__length1;
	ValadocSettings* _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	gchar** _tmp56_;
	gint _tmp56__length1;
	ValadocSettings* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	ValadocSettings* _tmp60_;
	ValadocSettings* _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	gchar** _tmp63_;
	gint _tmp63__length1;
	ValadocSettings* _tmp64_;
	gchar** _tmp65_;
	gint _tmp65__length1;
	gchar** _tmp66_;
	gint _tmp66__length1;
	ValadocSettings* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	ValadocSettings* _tmp70_;
	gchar** _tmp71_;
	gint _tmp71__length1;
	gchar** _tmp72_;
	gint _tmp72__length1;
	ValadocSettings* _tmp73_;
	gchar** _tmp74_;
	gint _tmp74__length1;
	gchar** _tmp75_;
	gint _tmp75__length1;
	ValadocDoclet* doclet = NULL;
	ValadocDriver* driver = NULL;
	ValadocModuleLoader* modules = NULL;
	ValadocDoclet* _tmp76_ = NULL;
	ValadocDriver* _tmp77_ = NULL;
	ValadocModuleLoader* _tmp78_;
	gboolean _tmp79_ = FALSE;
	gint _tmp80_;
	gint _tmp81_;
	ValadocApiTree* doctree = NULL;
	ValadocDriver* _tmp83_;
	ValadocSettings* _tmp84_;
	ValadocApiTree* _tmp85_;
	gint _tmp86_;
	gint _tmp87_;
	ValadocApiChildSymbolRegistrar* registrar = NULL;
	ValadocApiChildSymbolRegistrar* _tmp88_;
	ValadocApiTree* _tmp89_;
	ValadocApiChildSymbolRegistrar* _tmp90_;
	ValadocDocumentationParser* docparser = NULL;
	ValadocSettings* _tmp91_;
	ValadocApiTree* _tmp92_;
	ValadocModuleLoader* _tmp93_;
	ValadocDocumentationParser* _tmp94_;
	ValadocApiTree* _tmp95_;
	ValadocImporterDocumentationImporter** importers = NULL;
	ValadocApiTree* _tmp96_;
	ValadocDocumentationParser* _tmp97_;
	ValadocModuleLoader* _tmp98_;
	ValadocSettings* _tmp99_;
	ValadocImporterValadocDocumentationImporter* _tmp100_;
	ValadocApiTree* _tmp101_;
	ValadocDocumentationParser* _tmp102_;
	ValadocModuleLoader* _tmp103_;
	ValadocSettings* _tmp104_;
	ValadocImporterGirDocumentationImporter* _tmp105_;
	ValadocImporterDocumentationImporter** _tmp106_;
	gint importers_length1;
	gint _importers_size_;
	ValadocApiTree* _tmp107_;
	ValadocDocumentationParser* _tmp108_;
	gint _tmp109_;
	gint _tmp110_;
	ValadocApiTree* _tmp111_;
	ValadocImporterDocumentationImporter** _tmp112_;
	gint _tmp112__length1;
	gchar** _tmp113_;
	gint _tmp113__length1;
	gchar** _tmp114_;
	gint _tmp114__length1;
	gint _tmp115_;
	gint _tmp116_;
	ValadocApiTree* _tmp117_;
	ValadocDocumentationParser* _tmp118_;
	gint _tmp119_;
	gint _tmp120_;
	const gchar* _tmp121_;
	ValadocDoclet* _tmp126_;
	ValadocSettings* _tmp127_;
	ValadocApiTree* _tmp128_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (reporter != NULL, 0);
	_tmp0_ = valadoc_settings_new ();
	settings = _tmp0_;
	_tmp1_ = settings;
	valadoc_error_reporter_set_settings (reporter, _tmp1_);
	_tmp2_ = settings;
	_tmp3_ = vala_doc_get_pkg_name (self);
	_g_free0 (_tmp2_->pkg_name);
	_tmp2_->pkg_name = _tmp3_;
	_tmp4_ = settings;
	_tmp5_ = vala_doc_gir_namespace;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_tmp4_->gir_namespace);
	_tmp4_->gir_namespace = _tmp6_;
	_tmp7_ = settings;
	_tmp8_ = vala_doc_gir_version;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (_tmp7_->gir_version);
	_tmp7_->gir_version = _tmp9_;
	_tmp10_ = vala_doc_gir_name;
	if (_tmp10_ != NULL) {
		ValadocSettings* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		ValadocSettings* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		ValadocSettings* _tmp17_;
		const gchar* _tmp18_;
		_tmp11_ = settings;
		_tmp12_ = vala_doc_gir_name;
		_tmp13_ = g_path_get_basename (_tmp12_);
		_g_free0 (_tmp11_->gir_name);
		_tmp11_->gir_name = _tmp13_;
		_tmp14_ = settings;
		_tmp15_ = vala_doc_gir_name;
		_tmp16_ = g_path_get_dirname (_tmp15_);
		_g_free0 (_tmp14_->gir_directory);
		_tmp14_->gir_directory = _tmp16_;
		_tmp17_ = settings;
		_tmp18_ = _tmp17_->gir_directory;
		if (g_strcmp0 (_tmp18_, "") == 0) {
			ValadocSettings* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp19_ = settings;
			_tmp20_ = vala_doc_directory;
			_tmp21_ = g_path_get_dirname (_tmp20_);
			_g_free0 (_tmp19_->gir_directory);
			_tmp19_->gir_directory = _tmp21_;
		}
	}
	_tmp22_ = settings;
	_tmp23_ = vala_doc_pkg_version;
	_tmp24_ = g_strdup (_tmp23_);
	_g_free0 (_tmp22_->pkg_version);
	_tmp22_->pkg_version = _tmp24_;
	_tmp25_ = settings;
	_tmp25_->add_inherited = vala_doc_add_inherited;
	_tmp26_ = settings;
	_tmp26_->_protected = vala_doc__protected;
	_tmp27_ = settings;
	_tmp27_->_internal = vala_doc__internal;
	_tmp28_ = settings;
	_tmp28_->with_deps = vala_doc_with_deps;
	_tmp29_ = settings;
	_tmp29_->_private = vala_doc__private;
	_tmp30_ = settings;
	_tmp31_ = vala_doc_directory;
	_tmp32_ = vala_code_context_realpath (_tmp31_);
	_g_free0 (_tmp30_->path);
	_tmp30_->path = _tmp32_;
	_tmp33_ = settings;
	_tmp33_->verbose = vala_doc_verbose;
	_tmp34_ = settings;
	_tmp35_ = vala_doc_wikidirectory;
	_tmp36_ = g_strdup (_tmp35_);
	_g_free0 (_tmp34_->wiki_directory);
	_tmp34_->wiki_directory = _tmp36_;
	_tmp37_ = settings;
	_tmp38_ = vala_doc_pluginargs;
	_tmp38__length1 = _vala_array_length (vala_doc_pluginargs);
	_tmp39_ = (_tmp38_ != NULL) ? _vala_array_dup1 (_tmp38_, _tmp38__length1) : ((gpointer) _tmp38_);
	_tmp39__length1 = _tmp38__length1;
	_tmp37_->pluginargs = (_vala_array_free (_tmp37_->pluginargs, _tmp37_->pluginargs_length1, (GDestroyNotify) g_free), NULL);
	_tmp37_->pluginargs = _tmp39_;
	_tmp37_->pluginargs_length1 = _tmp39__length1;
	_tmp40_ = settings;
	_tmp40_->experimental = vala_doc_experimental;
	_tmp41_ = settings;
	_tmp41_->experimental_non_null = vala_doc_experimental_non_null;
	_tmp42_ = settings;
	_tmp43_ = vala_doc_basedir;
	_tmp44_ = g_strdup (_tmp43_);
	_g_free0 (_tmp42_->basedir);
	_tmp42_->basedir = _tmp44_;
	_tmp45_ = settings;
	_tmp46_ = vala_doc_directory;
	_tmp47_ = g_strdup (_tmp46_);
	_g_free0 (_tmp45_->directory);
	_tmp45_->directory = _tmp47_;
	_tmp48_ = settings;
	_tmp49_ = vala_doc_vapi_directories;
	_tmp49__length1 = _vala_array_length (vala_doc_vapi_directories);
	_tmp50_ = (_tmp49_ != NULL) ? _vala_array_dup2 (_tmp49_, _tmp49__length1) : ((gpointer) _tmp49_);
	_tmp50__length1 = _tmp49__length1;
	_tmp48_->vapi_directories = (_vala_array_free (_tmp48_->vapi_directories, _tmp48_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp48_->vapi_directories = _tmp50_;
	_tmp48_->vapi_directories_length1 = _tmp50__length1;
	_tmp51_ = settings;
	_tmp52_ = vala_doc_metadata_directories;
	_tmp52__length1 = _vala_array_length (vala_doc_metadata_directories);
	_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup3 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
	_tmp53__length1 = _tmp52__length1;
	_tmp51_->metadata_directories = (_vala_array_free (_tmp51_->metadata_directories, _tmp51_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp51_->metadata_directories = _tmp53_;
	_tmp51_->metadata_directories_length1 = _tmp53__length1;
	_tmp54_ = settings;
	_tmp55_ = vala_doc_gir_directories;
	_tmp55__length1 = _vala_array_length (vala_doc_gir_directories);
	_tmp56_ = (_tmp55_ != NULL) ? _vala_array_dup4 (_tmp55_, _tmp55__length1) : ((gpointer) _tmp55_);
	_tmp56__length1 = _tmp55__length1;
	_tmp54_->gir_directories = (_vala_array_free (_tmp54_->gir_directories, _tmp54_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp54_->gir_directories = _tmp56_;
	_tmp54_->gir_directories_length1 = _tmp56__length1;
	_tmp57_ = settings;
	_tmp58_ = vala_doc_target_glib;
	_tmp59_ = g_strdup (_tmp58_);
	_g_free0 (_tmp57_->target_glib);
	_tmp57_->target_glib = _tmp59_;
	_tmp60_ = settings;
	_tmp60_->use_svg_images = vala_doc_use_svg_images;
	_tmp61_ = settings;
	_tmp62_ = vala_doc_tsources;
	_tmp62__length1 = _vala_array_length (vala_doc_tsources);
	_tmp63_ = (_tmp62_ != NULL) ? _vala_array_dup5 (_tmp62_, _tmp62__length1) : ((gpointer) _tmp62_);
	_tmp63__length1 = _tmp62__length1;
	_tmp61_->source_files = (_vala_array_free (_tmp61_->source_files, _tmp61_->source_files_length1, (GDestroyNotify) g_free), NULL);
	_tmp61_->source_files = _tmp63_;
	_tmp61_->source_files_length1 = _tmp63__length1;
	_tmp64_ = settings;
	_tmp65_ = vala_doc_packages;
	_tmp65__length1 = _vala_array_length (vala_doc_packages);
	_tmp66_ = (_tmp65_ != NULL) ? _vala_array_dup6 (_tmp65_, _tmp65__length1) : ((gpointer) _tmp65_);
	_tmp66__length1 = _tmp65__length1;
	_tmp64_->packages = (_vala_array_free (_tmp64_->packages, _tmp64_->packages_length1, (GDestroyNotify) g_free), NULL);
	_tmp64_->packages = _tmp66_;
	_tmp64_->packages_length1 = _tmp66__length1;
	_tmp67_ = settings;
	_tmp68_ = vala_doc_profile;
	_tmp69_ = g_strdup (_tmp68_);
	_g_free0 (_tmp67_->profile);
	_tmp67_->profile = _tmp69_;
	_tmp70_ = settings;
	_tmp71_ = vala_doc_defines;
	_tmp71__length1 = _vala_array_length (vala_doc_defines);
	_tmp72_ = (_tmp71_ != NULL) ? _vala_array_dup7 (_tmp71_, _tmp71__length1) : ((gpointer) _tmp71_);
	_tmp72__length1 = _tmp71__length1;
	_tmp70_->defines = (_vala_array_free (_tmp70_->defines, _tmp70_->defines_length1, (GDestroyNotify) g_free), NULL);
	_tmp70_->defines = _tmp72_;
	_tmp70_->defines_length1 = _tmp72__length1;
	_tmp73_ = settings;
	_tmp74_ = vala_doc_alternative_resource_dirs;
	_tmp74__length1 = _vala_array_length (vala_doc_alternative_resource_dirs);
	_tmp75_ = (_tmp74_ != NULL) ? _vala_array_dup8 (_tmp74_, _tmp74__length1) : ((gpointer) _tmp74_);
	_tmp75__length1 = _tmp74__length1;
	_tmp73_->alternative_resource_dirs = (_vala_array_free (_tmp73_->alternative_resource_dirs, _tmp73_->alternative_resource_dirs_length1, (GDestroyNotify) g_free), NULL);
	_tmp73_->alternative_resource_dirs = _tmp75_;
	_tmp73_->alternative_resource_dirs_length1 = _tmp75__length1;
	doclet = NULL;
	driver = NULL;
	_tmp78_ = vala_doc_create_module_loader (self, reporter, &_tmp76_, &_tmp77_);
	_g_object_unref0 (doclet);
	doclet = _tmp76_;
	_g_object_unref0 (driver);
	driver = _tmp77_;
	modules = _tmp78_;
	_tmp80_ = valadoc_error_reporter_get_errors (reporter);
	_tmp81_ = _tmp80_;
	if (_tmp81_ > 0) {
		_tmp79_ = TRUE;
	} else {
		ValadocModuleLoader* _tmp82_;
		_tmp82_ = modules;
		_tmp79_ = _tmp82_ == NULL;
	}
	if (_tmp79_) {
		result = vala_doc_quit (reporter);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp83_ = driver;
	_tmp84_ = settings;
	_tmp85_ = valadoc_driver_build (_tmp83_, _tmp84_, reporter);
	doctree = _tmp85_;
	_tmp86_ = valadoc_error_reporter_get_errors (reporter);
	_tmp87_ = _tmp86_;
	if (_tmp87_ > 0) {
		_g_object_unref0 (driver);
		driver = NULL;
		_g_object_unref0 (doclet);
		doclet = NULL;
		result = vala_doc_quit (reporter);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp88_ = valadoc_api_child_symbol_registrar_new ();
	registrar = _tmp88_;
	_tmp89_ = doctree;
	_tmp90_ = registrar;
	valadoc_api_tree_accept (_tmp89_, (ValadocApiVisitor*) _tmp90_);
	_tmp91_ = settings;
	_tmp92_ = doctree;
	_tmp93_ = modules;
	_tmp94_ = valadoc_documentation_parser_new (_tmp91_, reporter, _tmp92_, _tmp93_);
	docparser = _tmp94_;
	_tmp95_ = doctree;
	if (!valadoc_api_tree_create_tree (_tmp95_)) {
		result = vala_doc_quit (reporter);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp96_ = doctree;
	_tmp97_ = docparser;
	_tmp98_ = modules;
	_tmp99_ = settings;
	_tmp100_ = valadoc_importer_valadoc_documentation_importer_new (_tmp96_, _tmp97_, _tmp98_, _tmp99_, reporter);
	_tmp101_ = doctree;
	_tmp102_ = docparser;
	_tmp103_ = modules;
	_tmp104_ = settings;
	_tmp105_ = valadoc_importer_gir_documentation_importer_new (_tmp101_, _tmp102_, _tmp103_, _tmp104_, reporter);
	_tmp106_ = g_new0 (ValadocImporterDocumentationImporter*, 2 + 1);
	_tmp106_[0] = (ValadocImporterDocumentationImporter*) _tmp100_;
	_tmp106_[1] = (ValadocImporterDocumentationImporter*) _tmp105_;
	importers = _tmp106_;
	importers_length1 = 2;
	_importers_size_ = importers_length1;
	_tmp107_ = doctree;
	_tmp108_ = docparser;
	valadoc_api_tree_parse_comments (_tmp107_, _tmp108_);
	_tmp109_ = valadoc_error_reporter_get_errors (reporter);
	_tmp110_ = _tmp109_;
	if (_tmp110_ > 0) {
		result = vala_doc_quit (reporter);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp111_ = doctree;
	_tmp112_ = importers;
	_tmp112__length1 = importers_length1;
	_tmp113_ = vala_doc_import_packages;
	_tmp113__length1 = _vala_array_length (vala_doc_import_packages);
	_tmp114_ = vala_doc_import_directories;
	_tmp114__length1 = _vala_array_length (vala_doc_import_directories);
	valadoc_api_tree_import_comments (_tmp111_, _tmp112_, (gint) _tmp112__length1, _tmp113_, (gint) _tmp113__length1, _tmp114_, (gint) _tmp114__length1);
	_tmp115_ = valadoc_error_reporter_get_errors (reporter);
	_tmp116_ = _tmp115_;
	if (_tmp116_ > 0) {
		result = vala_doc_quit (reporter);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp117_ = doctree;
	_tmp118_ = docparser;
	valadoc_api_tree_check_comments (_tmp117_, _tmp118_);
	_tmp119_ = valadoc_error_reporter_get_errors (reporter);
	_tmp120_ = _tmp119_;
	if (_tmp120_ > 0) {
		result = vala_doc_quit (reporter);
		importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (docparser);
		_g_object_unref0 (registrar);
		_valadoc_api_tree_unref0 (doctree);
		_g_object_unref0 (modules);
		_g_object_unref0 (driver);
		_g_object_unref0 (doclet);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp121_ = vala_doc_gir_name;
	if (_tmp121_ != NULL) {
		ValadocDriver* _tmp122_;
		ValadocSettings* _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		_tmp122_ = driver;
		_tmp123_ = settings;
		valadoc_driver_write_gir (_tmp122_, _tmp123_, reporter);
		_tmp124_ = valadoc_error_reporter_get_errors (reporter);
		_tmp125_ = _tmp124_;
		if (_tmp125_ > 0) {
			result = vala_doc_quit (reporter);
			importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (docparser);
			_g_object_unref0 (registrar);
			_valadoc_api_tree_unref0 (doctree);
			_g_object_unref0 (modules);
			_g_object_unref0 (driver);
			_g_object_unref0 (doclet);
			_g_object_unref0 (settings);
			return result;
		}
	}
	_tmp126_ = doclet;
	_tmp127_ = settings;
	_tmp128_ = doctree;
	valadoc_doclet_process (_tmp126_, _tmp127_, _tmp128_, reporter);
	result = vala_doc_quit (reporter);
	importers = (_vala_array_free (importers, importers_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (docparser);
	_g_object_unref0 (registrar);
	_valadoc_api_tree_unref0 (doctree);
	_g_object_unref0 (modules);
	_g_object_unref0 (driver);
	_g_object_unref0 (doclet);
	_g_object_unref0 (settings);
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
vala_doc_main (gchar** args,
               gint args_length1)
{
	gint result = 0;
	ValadocErrorReporter* reporter = NULL;
	ValadocErrorReporter* _tmp0_;
	const gchar* _tmp19_;
	const gchar* _tmp24_;
	const gchar* _tmp30_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	ValadocErrorReporter* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	const gchar* _tmp45_;
	ValaDoc* valadoc = NULL;
	ValaDoc* _tmp77_;
	ValaDoc* _tmp78_;
	ValadocErrorReporter* _tmp79_;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	_tmp0_ = valadoc_error_reporter_new (NULL);
	reporter = _tmp0_;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		GOptionContext* _tmp4_;
		_tmp1_ = g_option_context_new ("- Vala Documentation Tool");
		opt_context = _tmp1_;
		_tmp2_ = opt_context;
		g_option_context_set_help_enabled (_tmp2_, TRUE);
		_tmp3_ = opt_context;
		g_option_context_add_main_entries (_tmp3_, VALA_DOC_options, NULL);
		_tmp4_ = opt_context;
		g_option_context_parse (_tmp4_, (gint*) (&args_length1), &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp5_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch1_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_g_object_unref0 (reporter);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp5_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally1;
	__catch1_g_option_error:
	{
		GError* e = NULL;
		ValadocErrorReporter* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		FILE* _tmp9_;
		const gchar* _tmp10_;
		ValadocErrorReporter* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = reporter;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		valadoc_error_reporter_simple_error (_tmp6_, NULL, "%s", _tmp8_);
		_tmp9_ = stdout;
		_tmp10_ = args[0];
		fprintf (_tmp9_, "Run '%s --help' to see a full list of available command line options.\n", _tmp10_);
		_tmp11_ = reporter;
		result = vala_doc_quit (_tmp11_);
		_g_error_free0 (e);
		_g_object_unref0 (reporter);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp12_ = -1;
		_g_object_unref0 (reporter);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp12_;
	}
	if (vala_doc_disable_diagnostic_colors == FALSE) {
		const gchar* env_colors = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp13_;
		_tmp14_ = env_colors;
		if (_tmp14_ != NULL) {
			ValadocErrorReporter* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = reporter;
			_tmp16_ = env_colors;
			valadoc_error_reporter_set_colors (_tmp15_, _tmp16_);
		} else {
			ValadocErrorReporter* _tmp17_;
			_tmp17_ = reporter;
			valadoc_error_reporter_set_colors (_tmp17_, VALA_DOC_DEFAULT_COLORS);
		}
	}
	if (vala_doc_version) {
		FILE* _tmp18_;
		_tmp18_ = stdout;
		fprintf (_tmp18_, "Valadoc %s\n", VALA_BUILD_VERSION);
		result = 0;
		_g_object_unref0 (reporter);
		return result;
	}
	_tmp19_ = vala_doc_directory;
	if (_tmp19_ == NULL) {
		ValadocErrorReporter* _tmp20_;
		ValadocErrorReporter* _tmp21_;
		_tmp20_ = reporter;
		valadoc_error_reporter_simple_error (_tmp20_, NULL, "No output directory specified.");
		_tmp21_ = reporter;
		result = vala_doc_quit (_tmp21_);
		_g_object_unref0 (reporter);
		return result;
	}
	if (!vala_doc_check_pkg_name ()) {
		ValadocErrorReporter* _tmp22_;
		ValadocErrorReporter* _tmp23_;
		_tmp22_ = reporter;
		valadoc_error_reporter_simple_error (_tmp22_, NULL, "File already exists");
		_tmp23_ = reporter;
		result = vala_doc_quit (_tmp23_);
		_g_object_unref0 (reporter);
		return result;
	}
	_tmp24_ = vala_doc_directory;
	if (g_file_test (_tmp24_, G_FILE_TEST_EXISTS)) {
		if (vala_doc_force == TRUE) {
			gboolean tmp = FALSE;
			const gchar* _tmp25_;
			_tmp25_ = vala_doc_directory;
			tmp = valadoc_remove_directory (_tmp25_);
			if (tmp == FALSE) {
				ValadocErrorReporter* _tmp26_;
				ValadocErrorReporter* _tmp27_;
				_tmp26_ = reporter;
				valadoc_error_reporter_simple_error (_tmp26_, NULL, "Can't remove directory.");
				_tmp27_ = reporter;
				result = vala_doc_quit (_tmp27_);
				_g_object_unref0 (reporter);
				return result;
			}
		} else {
			ValadocErrorReporter* _tmp28_;
			ValadocErrorReporter* _tmp29_;
			_tmp28_ = reporter;
			valadoc_error_reporter_simple_error (_tmp28_, NULL, "File already exists");
			_tmp29_ = reporter;
			result = vala_doc_quit (_tmp29_);
			_g_object_unref0 (reporter);
			return result;
		}
	}
	_tmp30_ = vala_doc_wikidirectory;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_;
		_tmp31_ = vala_doc_wikidirectory;
		if (!g_file_test (_tmp31_, G_FILE_TEST_IS_DIR)) {
			ValadocErrorReporter* _tmp32_;
			ValadocErrorReporter* _tmp33_;
			_tmp32_ = reporter;
			valadoc_error_reporter_simple_error (_tmp32_, NULL, "Wiki-directory does not exist.");
			_tmp33_ = reporter;
			result = vala_doc_quit (_tmp33_);
			_g_object_unref0 (reporter);
			return result;
		}
	}
	_tmp34_ = vala_doc_alternative_resource_dirs;
	_tmp34__length1 = _vala_array_length (vala_doc_alternative_resource_dirs);
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp34_;
		dir_collection_length1 = _tmp34__length1;
		for (dir_it = 0; dir_it < _tmp34__length1; dir_it = dir_it + 1) {
			const gchar* dir = NULL;
			dir = dir_collection[dir_it];
			{
				const gchar* _tmp35_;
				_tmp35_ = dir;
				if (!g_file_test (_tmp35_, G_FILE_TEST_IS_DIR)) {
					ValadocErrorReporter* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					gchar* _tmp39_;
					ValadocErrorReporter* _tmp40_;
					_tmp36_ = reporter;
					_tmp37_ = dir;
					_tmp38_ = g_strdup_printf ("alternative resource directory '%s' does not exist.", _tmp37_);
					_tmp39_ = _tmp38_;
					valadoc_error_reporter_simple_error (_tmp36_, NULL, "%s", _tmp39_);
					_g_free0 (_tmp39_);
					_tmp40_ = reporter;
					result = vala_doc_quit (_tmp40_);
					_g_object_unref0 (reporter);
					return result;
				}
			}
		}
	}
	_tmp41_ = reporter;
	_tmp42_ = valadoc_error_reporter_get_errors (_tmp41_);
	_tmp43_ = _tmp42_;
	if (_tmp43_ > 0) {
		ValadocErrorReporter* _tmp44_;
		_tmp44_ = reporter;
		result = vala_doc_quit (_tmp44_);
		_g_object_unref0 (reporter);
		return result;
	}
	_tmp45_ = vala_doc_gir_name;
	if (_tmp45_ != NULL) {
		glong gir_len = 0L;
		const gchar* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint last_hyphen = 0;
		const gchar* _tmp49_;
		gboolean _tmp50_ = FALSE;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		const gchar* _tmp59_;
		gboolean _tmp60_ = FALSE;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_ = FALSE;
		const gchar* _tmp63_;
		gboolean report_warning = FALSE;
		gchar** _tmp70_;
		gint _tmp70__length1;
		_tmp46_ = vala_doc_gir_name;
		_tmp47_ = strlen (_tmp46_);
		_tmp48_ = _tmp47_;
		gir_len = (glong) _tmp48_;
		_tmp49_ = vala_doc_gir_name;
		last_hyphen = string_last_index_of_char (_tmp49_, (gunichar) '-', 0);
		if (last_hyphen == -1) {
			_tmp50_ = TRUE;
		} else {
			const gchar* _tmp51_;
			_tmp51_ = vala_doc_gir_name;
			_tmp50_ = !g_str_has_suffix (_tmp51_, ".gir");
		}
		if (_tmp50_) {
			ValadocErrorReporter* _tmp52_;
			const gchar* _tmp53_;
			ValadocErrorReporter* _tmp54_;
			_tmp52_ = reporter;
			_tmp53_ = vala_doc_gir_name;
			valadoc_error_reporter_simple_error (_tmp52_, NULL, "GIR file name '%s' is not well-formed, expected NAME-VERSION.gir", _tmp53_);
			_tmp54_ = reporter;
			result = vala_doc_quit (_tmp54_);
			_g_object_unref0 (reporter);
			return result;
		}
		_tmp55_ = vala_doc_gir_name;
		_tmp56_ = string_substring (_tmp55_, (glong) 0, (glong) last_hyphen);
		_g_free0 (vala_doc_gir_namespace);
		vala_doc_gir_namespace = _tmp56_;
		_tmp57_ = vala_doc_gir_name;
		_tmp58_ = string_substring (_tmp57_, (glong) (last_hyphen + 1), (gir_len - last_hyphen) - 5);
		_g_free0 (vala_doc_gir_version);
		vala_doc_gir_version = _tmp58_;
		_tmp59_ = vala_doc_gir_version;
		g_strcanon (_tmp59_, "0123456789.", '?');
		_tmp63_ = vala_doc_gir_namespace;
		if (g_strcmp0 (_tmp63_, "") == 0) {
			_tmp62_ = TRUE;
		} else {
			const gchar* _tmp64_;
			_tmp64_ = vala_doc_gir_version;
			_tmp62_ = g_strcmp0 (_tmp64_, "") == 0;
		}
		if (_tmp62_) {
			_tmp61_ = TRUE;
		} else {
			const gchar* _tmp65_;
			_tmp65_ = vala_doc_gir_version;
			_tmp61_ = !g_ascii_isdigit (string_get (_tmp65_, (glong) 0));
		}
		if (_tmp61_) {
			_tmp60_ = TRUE;
		} else {
			const gchar* _tmp66_;
			_tmp66_ = vala_doc_gir_version;
			_tmp60_ = string_contains (_tmp66_, "?");
		}
		if (_tmp60_) {
			ValadocErrorReporter* _tmp67_;
			const gchar* _tmp68_;
			ValadocErrorReporter* _tmp69_;
			_tmp67_ = reporter;
			_tmp68_ = vala_doc_gir_name;
			valadoc_error_reporter_simple_error (_tmp67_, NULL, "GIR file name '%s' is not well-formed, expected NAME-VERSION.gir", _tmp68_);
			_tmp69_ = reporter;
			result = vala_doc_quit (_tmp69_);
			_g_object_unref0 (reporter);
			return result;
		}
		report_warning = TRUE;
		_tmp70_ = vala_doc_tsources;
		_tmp70__length1 = _vala_array_length (vala_doc_tsources);
		{
			gchar** source_collection = NULL;
			gint source_collection_length1 = 0;
			gint _source_collection_size_ = 0;
			gint source_it = 0;
			source_collection = _tmp70_;
			source_collection_length1 = _tmp70__length1;
			for (source_it = 0; source_it < _tmp70__length1; source_it = source_it + 1) {
				gchar* _tmp71_;
				gchar* source = NULL;
				_tmp71_ = g_strdup (source_collection[source_it]);
				source = _tmp71_;
				{
					gboolean _tmp72_ = FALSE;
					const gchar* _tmp73_;
					_tmp73_ = source;
					if (g_str_has_suffix (_tmp73_, ".vala")) {
						_tmp72_ = TRUE;
					} else {
						const gchar* _tmp74_;
						_tmp74_ = source;
						_tmp72_ = g_str_has_suffix (_tmp74_, ".gs");
					}
					if (_tmp72_) {
						report_warning = FALSE;
						_g_free0 (source);
						break;
					}
					_g_free0 (source);
				}
			}
		}
		if (report_warning == TRUE) {
			ValadocErrorReporter* _tmp75_;
			ValadocErrorReporter* _tmp76_;
			_tmp75_ = reporter;
			valadoc_error_reporter_simple_error (_tmp75_, NULL, "No source file specified to be compiled to gir.");
			_tmp76_ = reporter;
			result = vala_doc_quit (_tmp76_);
			_g_object_unref0 (reporter);
			return result;
		}
	}
	_tmp77_ = vala_doc_new ();
	valadoc = _tmp77_;
	_tmp78_ = valadoc;
	_tmp79_ = reporter;
	result = vala_doc_run (_tmp78_, _tmp79_);
	_g_object_unref0 (valadoc);
	_g_object_unref0 (reporter);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_doc_main (argv, argc);
}

ValaDoc*
vala_doc_construct (GType object_type)
{
	ValaDoc * self = NULL;
	self = (ValaDoc*) g_object_new (object_type, NULL);
	return self;
}

ValaDoc*
vala_doc_new (void)
{
	return vala_doc_construct (TYPE_VALA_DOC);
}

static void
vala_doc_class_init (ValaDocClass * klass)
{
	vala_doc_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = vala_doc_finalize;
}

static void
vala_doc_instance_init (ValaDoc * self)
{
}

static void
vala_doc_finalize (GObject * obj)
{
	ValaDoc * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VALA_DOC, ValaDoc);
	G_OBJECT_CLASS (vala_doc_parent_class)->finalize (obj);
}

GType
vala_doc_get_type (void)
{
	static volatile gsize vala_doc_type_id__volatile = 0;
	if (g_once_init_enter (&vala_doc_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDocClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_doc_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDoc), 0, (GInstanceInitFunc) vala_doc_instance_init, NULL };
		GType vala_doc_type_id;
		vala_doc_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaDoc", &g_define_type_info, 0);
		g_once_init_leave (&vala_doc_type_id__volatile, vala_doc_type_id);
	}
	return vala_doc_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

