/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;

static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp7_ = _expr_list;
			_tmp8_ = vala_list_get (_tmp7_, _expr_index);
			expr = (ValaExpression*) _tmp8_;
			_tmp9_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	if (index >= 0) {
		ValaList* _tmp3_;
		_tmp3_ = self->priv->argument_list;
		vala_list_set (_tmp3_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp15_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp16_;
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = method_type;
			_tmp17_ = vala_method_type_get_method_symbol (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "GLib.NC_") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 1);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				result = _tmp25_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaExpression* _tmp7_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			if (!vala_expression_is_accessible (_tmp7_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp8_ = vala_method_call_get_call (self);
	_tmp9_ = _tmp8_;
	result = vala_expression_is_accessible (_tmp9_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_method_call_get_call (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (_tmp5_);
	mtype = _tmp6_;
	_tmp7_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaMethod* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		ValaMethod* _tmp15_;
		_tmp8_ = mtype;
		_tmp9_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		m = _tmp11_;
		_tmp15_ = m;
		if (_tmp15_ != NULL) {
			ValaMethod* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = m;
			_tmp17_ = vala_method_get_coroutine (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = _tmp18_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			gboolean _tmp19_;
			_tmp19_ = self->priv->_is_yield_expression;
			_tmp13_ = !_tmp19_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp20_ = vala_method_call_get_call (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp23_ = _tmp22_;
			_tmp12_ = g_strcmp0 (_tmp23_, "end") != 0;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			ValaMethod* _tmp24_;
			_tmp24_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp24_, collection, source_reference);
		}
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp25_;
		_tmp25_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_OBJECT_TYPE)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp26_;
			ValaObjectTypeSymbol* _tmp27_;
			ValaObjectTypeSymbol* _tmp28_;
			ValaClass* _tmp29_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp30_;
			ValaCreationMethod* _tmp31_;
			ValaCreationMethod* _tmp32_;
			ValaCreationMethod* _tmp33_;
			ValaCreationMethod* _tmp34_;
			_tmp26_ = mtype;
			_tmp27_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp28_ = _tmp27_;
			_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp29_;
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_default_construction_method (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = _vala_code_node_ref0 (_tmp32_);
			m = _tmp33_;
			_tmp34_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp34_, collection, source_reference);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp35_;
			_tmp35_ = mtype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_DELEGATE_TYPE)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp36_;
				ValaDelegate* _tmp37_;
				ValaDelegate* _tmp38_;
				ValaDelegate* _tmp39_;
				ValaDelegate* _tmp40_;
				_tmp36_ = mtype;
				_tmp37_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp38_ = _tmp37_;
				_tmp39_ = _vala_code_node_ref0 (_tmp38_);
				d = _tmp39_;
				_tmp40_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp40_, collection, source_reference);
				_vala_code_node_unref0 (d);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp41_;
		ValaList* _tmp42_;
		gint _expr_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _expr_index = 0;
		_tmp41_ = self->priv->argument_list;
		_tmp42_ = _vala_iterable_ref0 (_tmp41_);
		_expr_list = _tmp42_;
		_tmp43_ = _expr_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_expr_size = _tmp45_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp46_;
			gpointer _tmp47_;
			ValaExpression* _tmp48_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp46_ = _expr_list;
			_tmp47_ = vala_list_get (_tmp46_, _expr_index);
			expr = (ValaExpression*) _tmp47_;
			_tmp48_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp48_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_vala_code_node_unref0 (mtype);
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp108_;
	ValaExpression* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	gboolean _tmp113_ = FALSE;
	ValaProfile _tmp114_;
	ValaProfile _tmp115_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp145_;
	gboolean _tmp238_ = FALSE;
	ValaExpression* _tmp239_;
	ValaExpression* _tmp240_;
	gboolean _tmp310_ = FALSE;
	gboolean _tmp311_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp326_;
	ValaDataType* _tmp327_;
	ValaList* params = NULL;
	ValaDataType* _tmp328_;
	ValaList* _tmp329_;
	ValaDataType* _tmp330_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp397_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp398_;
	ValaIterator* _tmp399_;
	gboolean _tmp448_ = FALSE;
	ValaDataType* _tmp449_;
	gboolean _tmp469_ = FALSE;
	ValaDataType* _tmp470_;
	ValaDataType* _tmp537_;
	ValaDataType* _tmp548_;
	ValaDataType* _tmp549_;
	ValaDataType* _tmp550_;
	ValaDataType* _tmp551_;
	ValaDataType* _tmp552_;
	ValaDataType* _tmp553_;
	ValaList* _tmp554_;
	ValaDataType* _tmp555_;
	ValaDataType* _tmp556_;
	ValaDataType* _tmp557_;
	ValaSemanticAnalyzer* _tmp781_;
	ValaSemanticAnalyzer* _tmp782_;
	ValaDataType* _tmp783_;
	ValaList* _tmp784_;
	ValaList* _tmp785_;
	ValaList* _tmp786_;
	gboolean _tmp787_;
	gboolean _tmp788_ = FALSE;
	gboolean _tmp789_ = FALSE;
	ValaCreationMethod* _tmp790_;
	gboolean _tmp819_;
	gboolean _tmp820_;
	gboolean _tmp873_;
	gboolean _tmp874_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_MEMBER_ACCESS)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			ValaMemberAccess* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaMemberAccess* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp91_ = FALSE;
			ValaMemberAccess* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp19_;
			_tmp20_ = ma;
			_tmp21_ = vala_member_access_get_prototype_access (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_method_call_get_call (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_expression_get_symbol_reference (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_type_arguments (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp60_;
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				ValaMethod* _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaMethod* _tmp65_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_SIGNAL)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					ValaMemberAccess* _tmp53_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp51_) : NULL);
					sig = _tmp52_;
					_tmp53_ = sig;
					if (_tmp53_ != NULL) {
						ValaMemberAccess* _tmp54_;
						ValaExpression* _tmp55_;
						ValaExpression* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						_tmp54_ = sig;
						_tmp55_ = vala_member_access_get_inner (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_expression_get_value_type (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = _vala_code_node_ref0 (_tmp58_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp59_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp60_ = ma;
				_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp62_) : NULL);
				m = _tmp63_;
				_tmp65_ = m;
				if (_tmp65_ != NULL) {
					ValaMethod* _tmp66_;
					gboolean _tmp67_;
					gboolean _tmp68_;
					_tmp66_ = m;
					_tmp67_ = vala_method_get_coroutine (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp64_ = _tmp68_;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					gboolean _tmp69_ = FALSE;
					ValaMemberAccess* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = ma;
					_tmp71_ = vala_member_access_get_member_name (_tmp70_);
					_tmp72_ = _tmp71_;
					if (g_strcmp0 (_tmp72_, "begin") == 0) {
						_tmp69_ = TRUE;
					} else {
						ValaMemberAccess* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						_tmp73_ = ma;
						_tmp74_ = vala_member_access_get_member_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp69_ = g_strcmp0 (_tmp75_, "end") == 0;
					}
					if (_tmp69_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp76_;
						ValaExpression* _tmp77_;
						ValaExpression* _tmp78_;
						ValaMemberAccess* _tmp79_;
						gboolean _tmp80_ = FALSE;
						ValaMemberAccess* _tmp81_;
						_tmp76_ = ma;
						_tmp77_ = vala_member_access_get_inner (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp78_) : NULL);
						method_access = _tmp79_;
						_tmp81_ = method_access;
						if (_tmp81_ != NULL) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp80_ = _tmp84_ != NULL;
						} else {
							_tmp80_ = FALSE;
						}
						if (_tmp80_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaDataType* _tmp88_;
							ValaDataType* _tmp89_;
							ValaDataType* _tmp90_;
							_tmp85_ = method_access;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_value_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp90_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp92_ = ma;
			_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
			_tmp94_ = _tmp93_;
			if (_tmp94_ != NULL) {
				ValaMemberAccess* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaAttribute* _tmp98_;
				_tmp95_ = ma;
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp97_, "Assert");
				_tmp91_ = _tmp98_ != NULL;
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaList* args = NULL;
				ValaList* _tmp99_;
				ValaList* _tmp100_;
				gint _tmp101_;
				gint _tmp102_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp99_ = vala_method_call_get_argument_list (self);
				args = _tmp99_;
				_tmp100_ = args;
				_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
				_tmp102_ = _tmp101_;
				if (_tmp102_ == 1) {
					ValaList* _tmp103_;
					gpointer _tmp104_;
					ValaExpression* _tmp105_;
					ValaSourceReference* _tmp106_;
					ValaSourceReference* _tmp107_;
					_tmp103_ = args;
					_tmp104_ = vala_list_get (_tmp103_, 0);
					_tmp105_ = (ValaExpression*) _tmp104_;
					_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp105_);
					_tmp107_ = _tmp106_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp107_);
					_vala_code_node_unref0 (_tmp105_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp108_ = vala_method_call_get_call (self);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_expression_get_value_type (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = _vala_code_node_ref0 (_tmp111_);
	mtype = _tmp112_;
	_tmp114_ = vala_code_context_get_profile (context);
	_tmp115_ = _tmp114_;
	if (_tmp115_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp116_;
		ValaExpression* _tmp117_;
		ValaSymbol* _tmp118_;
		ValaSymbol* _tmp119_;
		ValaSemanticAnalyzer* _tmp120_;
		ValaSemanticAnalyzer* _tmp121_;
		ValaClass* _tmp122_;
		_tmp116_ = vala_method_call_get_call (self);
		_tmp117_ = _tmp116_;
		_tmp118_ = vala_expression_get_symbol_reference (_tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_code_context_get_analyzer (context);
		_tmp121_ = _tmp120_;
		_tmp122_ = _tmp121_->object_type;
		_tmp113_ = _tmp119_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp113_ = FALSE;
	}
	gobject_chainup = _tmp113_;
	vala_method_call_set_is_chainup (self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp126_;
		ValaMemberAccess* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp139_ = FALSE;
		ValaMemberAccess* _tmp140_;
		_tmp123_ = vala_method_call_get_call (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = _vala_code_node_ref0 (_tmp124_);
		expr = _tmp125_;
		_tmp126_ = expr;
		_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp126_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp126_) : NULL);
		ma = _tmp127_;
		_tmp129_ = ma;
		if (_tmp129_ != NULL) {
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp132_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaMemberAccess* _tmp138_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = _vala_code_node_ref0 (_tmp135_);
			_vala_code_node_unref0 (expr);
			expr = _tmp136_;
			_tmp137_ = expr;
			_tmp138_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp137_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp137_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp138_;
		}
		_tmp140_ = ma;
		if (_tmp140_ != NULL) {
			ValaMemberAccess* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_member_access_get_member_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp139_ = g_strcmp0 (_tmp143_, "this") == 0;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp144_;
			_tmp144_ = expr;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_BASE_ACCESS)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp145_ = self->priv->_is_chainup;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp150_;
		ValaCreationMethod* _tmp158_;
		ValaDataType* _tmp159_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		_tmp149_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp148_, VALA_TYPE_CREATION_METHOD) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		if (_tmp149_ == NULL) {
			_vala_code_node_unref0 (_tmp148_);
		}
		cm = _tmp149_;
		_tmp150_ = cm;
		if (_tmp150_ == NULL) {
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp152_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp153_ = cm;
			_tmp154_ = vala_creation_method_get_chain_up (_tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp157_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp158_ = cm;
		vala_creation_method_set_chain_up (_tmp158_, TRUE);
		_tmp159_ = mtype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_OBJECT_TYPE)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp160_;
			ValaObjectType* _tmp161_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp162_;
			ValaObjectTypeSymbol* _tmp163_;
			ValaObjectTypeSymbol* _tmp164_;
			ValaClass* _tmp165_;
			ValaClass* _tmp166_;
			ValaCreationMethod* _tmp167_;
			ValaCreationMethod* _tmp168_;
			ValaCreationMethod* _tmp169_;
			ValaCreationMethod* _tmp170_;
			_tmp160_ = mtype;
			_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp161_;
			_tmp162_ = otype;
			_tmp163_ = vala_object_type_get_type_symbol (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp165_;
			_tmp166_ = cl;
			_tmp167_ = vala_class_get_default_construction_method (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = _vala_code_node_ref0 (_tmp168_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp169_;
			_tmp170_ = base_cm;
			if (_tmp170_ == NULL) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaClass* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = cl;
				_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strdup_printf ("chain up to `%s' not supported", _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp172_, _tmp177_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp178_;
				gboolean _tmp179_;
				gboolean _tmp180_;
				_tmp178_ = base_cm;
				_tmp179_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp178_);
				_tmp180_ = _tmp179_;
				if (!_tmp180_) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaCreationMethod* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					_tmp183_ = base_cm;
					_tmp184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = g_strdup_printf ("chain up to `%s' not supported", _tmp185_);
					_tmp187_ = _tmp186_;
					vala_report_error (_tmp182_, _tmp187_);
					_g_free0 (_tmp187_);
					_g_free0 (_tmp185_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp188_ = FALSE;
			ValaExpression* _tmp189_;
			ValaExpression* _tmp190_;
			ValaSymbol* _tmp191_;
			ValaSymbol* _tmp192_;
			_tmp189_ = vala_method_call_get_call (self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
			_tmp192_ = _tmp191_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, VALA_TYPE_CREATION_METHOD)) {
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp193_ = vala_method_call_get_call (self);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_expression_get_symbol_reference (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp188_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp198_, VALA_TYPE_CLASS);
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaExpression* _tmp199_;
				ValaExpression* _tmp200_;
				ValaSymbol* _tmp201_;
				ValaSymbol* _tmp202_;
				ValaCreationMethod* _tmp203_;
				ValaCreationMethod* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp199_ = vala_method_call_get_call (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_expression_get_symbol_reference (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp203_;
				_tmp204_ = base_cm;
				_tmp205_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (!_tmp206_) {
					ValaSourceReference* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaCreationMethod* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp208_ = _tmp207_;
					_tmp209_ = base_cm;
					_tmp210_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = g_strdup_printf ("chain up to `%s' not supported", _tmp211_);
					_tmp213_ = _tmp212_;
					vala_report_error (_tmp208_, _tmp213_);
					_g_free0 (_tmp213_);
					_g_free0 (_tmp211_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp214_;
					ValaSymbol* _tmp215_;
					ValaSymbol* _tmp216_;
					ValaClass* _tmp217_;
					gboolean _tmp218_ = FALSE;
					ValaClass* _tmp219_;
					ValaExpression* _tmp226_;
					ValaExpression* _tmp227_;
					ValaSemanticAnalyzer* _tmp228_;
					ValaSemanticAnalyzer* _tmp229_;
					ValaClass* _tmp230_;
					ValaObjectType* _tmp231_;
					ValaObjectType* _tmp232_;
					ValaExpression* _tmp233_;
					ValaExpression* _tmp234_;
					ValaDataType* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					_tmp214_ = cm;
					_tmp215_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp216_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp216_) : NULL);
					cl = _tmp217_;
					_tmp219_ = cl;
					if (_tmp219_ == NULL) {
						_tmp218_ = TRUE;
					} else {
						ValaClass* _tmp220_;
						ValaSemanticAnalyzer* _tmp221_;
						ValaSemanticAnalyzer* _tmp222_;
						ValaClass* _tmp223_;
						_tmp220_ = cl;
						_tmp221_ = vala_code_context_get_analyzer (context);
						_tmp222_ = _tmp221_;
						_tmp223_ = _tmp222_->object_type;
						_tmp218_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp220_, (ValaTypeSymbol*) _tmp223_);
					}
					if (_tmp218_) {
						ValaSourceReference* _tmp224_;
						ValaSourceReference* _tmp225_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp225_ = _tmp224_;
						vala_report_error (_tmp225_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp226_ = vala_method_call_get_call (self);
					_tmp227_ = _tmp226_;
					_tmp228_ = vala_code_context_get_analyzer (context);
					_tmp229_ = _tmp228_;
					_tmp230_ = _tmp229_->object_type;
					_tmp231_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp230_);
					_tmp232_ = _tmp231_;
					vala_expression_set_value_type (_tmp227_, (ValaDataType*) _tmp232_);
					_vala_code_node_unref0 (_tmp232_);
					_tmp233_ = vala_method_call_get_call (self);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_expression_get_value_type (_tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (_tmp236_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp237_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp239_ = vala_method_call_get_call (self);
	_tmp240_ = _tmp239_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp240_, VALA_TYPE_MEMBER_ACCESS)) {
		gboolean _tmp241_ = FALSE;
		gboolean _tmp242_ = FALSE;
		ValaExpression* _tmp243_;
		ValaExpression* _tmp244_;
		ValaSymbol* _tmp245_;
		ValaSymbol* _tmp246_;
		_tmp243_ = vala_method_call_get_call (self);
		_tmp244_ = _tmp243_;
		_tmp245_ = vala_expression_get_symbol_reference (_tmp244_);
		_tmp246_ = _tmp245_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp246_, VALA_TYPE_CREATION_METHOD)) {
			ValaExpression* _tmp247_;
			ValaExpression* _tmp248_;
			ValaSymbol* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			_tmp247_ = vala_method_call_get_call (self);
			_tmp248_ = _tmp247_;
			_tmp249_ = vala_expression_get_symbol_reference (_tmp248_);
			_tmp250_ = _tmp249_;
			_tmp251_ = vala_symbol_get_parent_symbol (_tmp250_);
			_tmp252_ = _tmp251_;
			_tmp242_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_STRUCT);
		} else {
			_tmp242_ = FALSE;
		}
		if (_tmp242_) {
			_tmp241_ = TRUE;
		} else {
			ValaExpression* _tmp253_;
			ValaExpression* _tmp254_;
			ValaSymbol* _tmp255_;
			ValaSymbol* _tmp256_;
			_tmp253_ = vala_method_call_get_call (self);
			_tmp254_ = _tmp253_;
			_tmp255_ = vala_expression_get_symbol_reference (_tmp254_);
			_tmp256_ = _tmp255_;
			_tmp241_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp256_, VALA_TYPE_STRUCT);
		}
		_tmp238_ = _tmp241_;
	} else {
		_tmp238_ = FALSE;
	}
	if (_tmp238_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp257_;
		ValaExpression* _tmp258_;
		ValaSymbol* _tmp259_;
		ValaSymbol* _tmp260_;
		ValaStruct* _tmp261_;
		gboolean _tmp262_ = FALSE;
		gboolean _tmp263_ = FALSE;
		ValaStruct* _tmp264_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp275_;
		ValaExpression* _tmp276_;
		ValaSourceReference* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaObjectCreationExpression* _tmp279_;
		ValaObjectCreationExpression* _tmp280_;
		ValaObjectCreationExpression* _tmp289_;
		ValaDataType* _tmp290_;
		ValaDataType* _tmp291_;
		ValaSemanticAnalyzer* _tmp292_;
		ValaSemanticAnalyzer* _tmp293_;
		ValaList* _tmp294_;
		ValaCodeNode* _tmp295_;
		ValaCodeNode* _tmp296_;
		ValaObjectCreationExpression* _tmp297_;
		ValaObjectCreationExpression* _tmp298_;
		_tmp257_ = vala_method_call_get_call (self);
		_tmp258_ = _tmp257_;
		_tmp259_ = vala_expression_get_symbol_reference (_tmp258_);
		_tmp260_ = _tmp259_;
		_tmp261_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp260_) : NULL);
		st = _tmp261_;
		_tmp264_ = st;
		if (_tmp264_ != NULL) {
			ValaStruct* _tmp265_;
			ValaCreationMethod* _tmp266_;
			ValaCreationMethod* _tmp267_;
			_tmp265_ = st;
			_tmp266_ = vala_struct_get_default_construction_method (_tmp265_);
			_tmp267_ = _tmp266_;
			_tmp263_ = _tmp267_ == NULL;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			gboolean _tmp268_ = FALSE;
			gboolean _tmp269_ = FALSE;
			ValaStruct* _tmp270_;
			_tmp270_ = st;
			if (vala_struct_is_boolean_type (_tmp270_)) {
				_tmp269_ = TRUE;
			} else {
				ValaStruct* _tmp271_;
				_tmp271_ = st;
				_tmp269_ = vala_struct_is_integer_type (_tmp271_);
			}
			if (_tmp269_) {
				_tmp268_ = TRUE;
			} else {
				ValaStruct* _tmp272_;
				_tmp272_ = st;
				_tmp268_ = vala_struct_is_floating_type (_tmp272_);
			}
			_tmp262_ = _tmp268_;
		} else {
			_tmp262_ = FALSE;
		}
		if (_tmp262_) {
			ValaSourceReference* _tmp273_;
			ValaSourceReference* _tmp274_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp274_ = _tmp273_;
			vala_report_error (_tmp274_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp275_ = vala_method_call_get_call (self);
		_tmp276_ = _tmp275_;
		_tmp277_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp278_ = _tmp277_;
		_tmp279_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp276_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp278_);
		struct_creation_expression = _tmp279_;
		_tmp280_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp280_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp281_;
			gint _arg_size = 0;
			ValaList* _tmp282_;
			gint _tmp283_;
			gint _tmp284_;
			gint _arg_index = 0;
			_tmp281_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp281_;
			_tmp282_ = _arg_list;
			_tmp283_ = vala_collection_get_size ((ValaCollection*) _tmp282_);
			_tmp284_ = _tmp283_;
			_arg_size = _tmp284_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp285_;
				gpointer _tmp286_;
				ValaObjectCreationExpression* _tmp287_;
				ValaExpression* _tmp288_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp285_ = _arg_list;
				_tmp286_ = vala_list_get (_tmp285_, _arg_index);
				arg = (ValaExpression*) _tmp286_;
				_tmp287_ = struct_creation_expression;
				_tmp288_ = arg;
				vala_object_creation_expression_add_argument (_tmp287_, _tmp288_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp289_ = struct_creation_expression;
		_tmp290_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp291_ = _tmp290_;
		vala_expression_set_target_type ((ValaExpression*) _tmp289_, _tmp291_);
		_tmp292_ = vala_code_context_get_analyzer (context);
		_tmp293_ = _tmp292_;
		_tmp294_ = _tmp293_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp294_, (ValaCodeNode*) self);
		_tmp295_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp296_, (ValaExpression*) self, (ValaExpression*) _tmp297_);
		_tmp298_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp298_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp299_ = FALSE;
		gboolean _tmp300_ = FALSE;
		gboolean _tmp301_;
		_tmp301_ = self->priv->_is_chainup;
		if (!_tmp301_) {
			ValaExpression* _tmp302_;
			ValaExpression* _tmp303_;
			_tmp302_ = vala_method_call_get_call (self);
			_tmp303_ = _tmp302_;
			_tmp300_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp303_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp300_ = FALSE;
		}
		if (_tmp300_) {
			ValaExpression* _tmp304_;
			ValaExpression* _tmp305_;
			ValaSymbol* _tmp306_;
			ValaSymbol* _tmp307_;
			_tmp304_ = vala_method_call_get_call (self);
			_tmp305_ = _tmp304_;
			_tmp306_ = vala_expression_get_symbol_reference (_tmp305_);
			_tmp307_ = _tmp306_;
			_tmp299_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp307_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp299_ = FALSE;
		}
		if (_tmp299_) {
			ValaSourceReference* _tmp308_;
			ValaSourceReference* _tmp309_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp309_ = _tmp308_;
			vala_report_error (_tmp309_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp311_ = self->priv->_is_chainup;
	if (!_tmp311_) {
		ValaDataType* _tmp312_;
		_tmp312_ = mtype;
		_tmp310_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp312_, VALA_TYPE_OBJECT_TYPE);
	} else {
		_tmp310_ = FALSE;
	}
	if (_tmp310_) {
		ValaSourceReference* _tmp313_;
		ValaSourceReference* _tmp314_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp313_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp314_ = _tmp313_;
		vala_report_error (_tmp314_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp315_ = FALSE;
		ValaDataType* _tmp316_;
		_tmp316_ = mtype;
		if (_tmp316_ != NULL) {
			ValaDataType* _tmp317_;
			_tmp317_ = mtype;
			_tmp315_ = vala_data_type_is_invokable (_tmp317_);
		} else {
			_tmp315_ = FALSE;
		}
		if (_tmp315_) {
		} else {
			ValaExpression* _tmp318_;
			ValaExpression* _tmp319_;
			ValaSymbol* _tmp320_;
			ValaSymbol* _tmp321_;
			_tmp318_ = vala_method_call_get_call (self);
			_tmp319_ = _tmp318_;
			_tmp320_ = vala_expression_get_symbol_reference (_tmp319_);
			_tmp321_ = _tmp320_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp321_, VALA_TYPE_CLASS)) {
				ValaSourceReference* _tmp322_;
				ValaSourceReference* _tmp323_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp322_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp323_ = _tmp322_;
				vala_report_error (_tmp323_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp324_;
				ValaSourceReference* _tmp325_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp324_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp325_ = _tmp324_;
				vala_report_error (_tmp325_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp326_ = mtype;
	_tmp327_ = vala_data_type_get_return_type (_tmp326_);
	ret_type = _tmp327_;
	_tmp328_ = mtype;
	_tmp329_ = vala_data_type_get_parameters (_tmp328_);
	params = _tmp329_;
	_tmp330_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp331_;
		ValaMethod* _tmp332_;
		ValaMethod* _tmp333_;
		ValaMethod* _tmp334_;
		gboolean _tmp335_ = FALSE;
		ValaMethod* _tmp336_;
		ValaMethod* _tmp373_;
		_tmp331_ = mtype;
		_tmp332_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp331_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp333_ = _tmp332_;
		_tmp334_ = _vala_code_node_ref0 (_tmp333_);
		m = _tmp334_;
		_tmp336_ = m;
		if (_tmp336_ != NULL) {
			ValaMethod* _tmp337_;
			gboolean _tmp338_;
			gboolean _tmp339_;
			_tmp337_ = m;
			_tmp338_ = vala_method_get_coroutine (_tmp337_);
			_tmp339_ = _tmp338_;
			_tmp335_ = _tmp339_;
		} else {
			_tmp335_ = FALSE;
		}
		if (_tmp335_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp340_;
			ValaExpression* _tmp341_;
			ValaMemberAccess* _tmp342_;
			gboolean _tmp343_;
			_tmp340_ = vala_method_call_get_call (self);
			_tmp341_ = _tmp340_;
			_tmp342_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp341_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp342_;
			_tmp343_ = self->priv->_is_yield_expression;
			if (!_tmp343_) {
				ValaMemberAccess* _tmp344_;
				const gchar* _tmp345_;
				const gchar* _tmp346_;
				_tmp344_ = ma;
				_tmp345_ = vala_member_access_get_member_name (_tmp344_);
				_tmp346_ = _tmp345_;
				if (g_strcmp0 (_tmp346_, "end") != 0) {
					ValaMemberAccess* _tmp347_;
					const gchar* _tmp348_;
					const gchar* _tmp349_;
					ValaMethod* _tmp353_;
					ValaList* _tmp354_;
					ValaVoidType* _tmp355_;
					_tmp347_ = ma;
					_tmp348_ = vala_member_access_get_member_name (_tmp347_);
					_tmp349_ = _tmp348_;
					if (g_strcmp0 (_tmp349_, "begin") != 0) {
						ValaMemberAccess* _tmp350_;
						ValaSourceReference* _tmp351_;
						ValaSourceReference* _tmp352_;
						_tmp350_ = ma;
						_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp350_);
						_tmp352_ = _tmp351_;
						vala_report_deprecated (_tmp352_, "implicit .begin is deprecated");
					}
					_tmp353_ = m;
					_tmp354_ = vala_method_get_async_begin_parameters (_tmp353_);
					_vala_iterable_unref0 (params);
					params = _tmp354_;
					_tmp355_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp355_;
				} else {
					ValaMethod* _tmp356_;
					ValaList* _tmp357_;
					_tmp356_ = m;
					_tmp357_ = vala_method_get_async_end_parameters (_tmp356_);
					_vala_iterable_unref0 (params);
					params = _tmp357_;
				}
			} else {
				gboolean _tmp358_ = FALSE;
				ValaMemberAccess* _tmp359_;
				const gchar* _tmp360_;
				const gchar* _tmp361_;
				_tmp359_ = ma;
				_tmp360_ = vala_member_access_get_member_name (_tmp359_);
				_tmp361_ = _tmp360_;
				if (g_strcmp0 (_tmp361_, "begin") == 0) {
					_tmp358_ = TRUE;
				} else {
					ValaMemberAccess* _tmp362_;
					const gchar* _tmp363_;
					const gchar* _tmp364_;
					_tmp362_ = ma;
					_tmp363_ = vala_member_access_get_member_name (_tmp362_);
					_tmp364_ = _tmp363_;
					_tmp358_ = g_strcmp0 (_tmp364_, "end") == 0;
				}
				if (_tmp358_) {
					ValaMemberAccess* _tmp365_;
					ValaSourceReference* _tmp366_;
					ValaSourceReference* _tmp367_;
					ValaMemberAccess* _tmp368_;
					const gchar* _tmp369_;
					const gchar* _tmp370_;
					gchar* _tmp371_;
					gchar* _tmp372_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp365_ = ma;
					_tmp366_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp365_);
					_tmp367_ = _tmp366_;
					_tmp368_ = ma;
					_tmp369_ = vala_member_access_get_member_name (_tmp368_);
					_tmp370_ = _tmp369_;
					_tmp371_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp370_);
					_tmp372_ = _tmp371_;
					vala_report_error (_tmp367_, _tmp372_);
					_g_free0 (_tmp372_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp373_ = m;
		if (_tmp373_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp374_;
			ValaExpression* _tmp375_;
			ValaMemberAccess* _tmp376_;
			gint n_type_params = 0;
			ValaMethod* _tmp377_;
			ValaList* _tmp378_;
			ValaList* _tmp379_;
			gint _tmp380_;
			gint _tmp381_;
			gint _tmp382_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp383_;
			ValaList* _tmp384_;
			ValaList* _tmp385_;
			gint _tmp386_;
			gint _tmp387_;
			gint _tmp388_;
			gboolean _tmp389_ = FALSE;
			_tmp374_ = vala_method_call_get_call (self);
			_tmp375_ = _tmp374_;
			_tmp376_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp375_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp376_;
			_tmp377_ = m;
			_tmp378_ = vala_method_get_type_parameters (_tmp377_);
			_tmp379_ = _tmp378_;
			_tmp380_ = vala_collection_get_size ((ValaCollection*) _tmp379_);
			_tmp381_ = _tmp380_;
			_tmp382_ = _tmp381_;
			_vala_iterable_unref0 (_tmp379_);
			n_type_params = _tmp382_;
			_tmp383_ = ma;
			_tmp384_ = vala_member_access_get_type_arguments (_tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = vala_collection_get_size ((ValaCollection*) _tmp385_);
			_tmp387_ = _tmp386_;
			_tmp388_ = _tmp387_;
			_vala_iterable_unref0 (_tmp385_);
			n_type_args = _tmp388_;
			if (n_type_args > 0) {
				_tmp389_ = n_type_args < n_type_params;
			} else {
				_tmp389_ = FALSE;
			}
			if (_tmp389_) {
				ValaMemberAccess* _tmp390_;
				ValaSourceReference* _tmp391_;
				ValaSourceReference* _tmp392_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp390_ = ma;
				_tmp391_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp390_);
				_tmp392_ = _tmp391_;
				vala_report_error (_tmp392_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp393_ = FALSE;
				if (n_type_args > 0) {
					_tmp393_ = n_type_args > n_type_params;
				} else {
					_tmp393_ = FALSE;
				}
				if (_tmp393_) {
					ValaMemberAccess* _tmp394_;
					ValaSourceReference* _tmp395_;
					ValaSourceReference* _tmp396_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp394_ = ma;
					_tmp395_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp394_);
					_tmp396_ = _tmp395_;
					vala_report_error (_tmp396_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp397_ = vala_method_call_get_argument_list (self);
	args = _tmp397_;
	_tmp398_ = args;
	_tmp399_ = vala_iterable_iterator ((ValaIterable*) _tmp398_);
	arg_it = _tmp399_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp400_;
		ValaList* _tmp401_;
		gint _param_size = 0;
		ValaList* _tmp402_;
		gint _tmp403_;
		gint _tmp404_;
		gint _param_index = 0;
		_tmp400_ = params;
		_tmp401_ = _vala_iterable_ref0 (_tmp400_);
		_param_list = _tmp401_;
		_tmp402_ = _param_list;
		_tmp403_ = vala_collection_get_size ((ValaCollection*) _tmp402_);
		_tmp404_ = _tmp403_;
		_param_size = _tmp404_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp405_;
			gpointer _tmp406_;
			ValaParameter* _tmp407_;
			ValaParameter* _tmp408_;
			gboolean _tmp409_;
			gboolean _tmp410_;
			ValaParameter* _tmp411_;
			gboolean _tmp412_;
			gboolean _tmp413_;
			ValaIterator* _tmp431_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp405_ = _param_list;
			_tmp406_ = vala_list_get (_tmp405_, _param_index);
			param = (ValaParameter*) _tmp406_;
			_tmp407_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp407_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp408_ = param;
			_tmp409_ = vala_parameter_get_ellipsis (_tmp408_);
			_tmp410_ = _tmp409_;
			if (_tmp410_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp411_ = param;
			_tmp412_ = vala_parameter_get_params_array (_tmp411_);
			_tmp413_ = _tmp412_;
			if (_tmp413_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp414_;
				ValaDataType* _tmp415_;
				ValaDataType* _tmp416_;
				ValaArrayType* _tmp417_;
				_tmp414_ = param;
				_tmp415_ = vala_variable_get_variable_type ((ValaVariable*) _tmp414_);
				_tmp416_ = _tmp415_;
				_tmp417_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp416_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp417_;
				while (TRUE) {
					ValaIterator* _tmp418_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp419_;
					gpointer _tmp420_;
					ValaExpression* _tmp421_;
					ValaArrayType* _tmp422_;
					ValaDataType* _tmp423_;
					ValaDataType* _tmp424_;
					ValaExpression* _tmp425_;
					ValaDataType* _tmp426_;
					ValaDataType* _tmp427_;
					ValaArrayType* _tmp428_;
					gboolean _tmp429_;
					gboolean _tmp430_;
					_tmp418_ = arg_it;
					if (!vala_iterator_next (_tmp418_)) {
						break;
					}
					_tmp419_ = arg_it;
					_tmp420_ = vala_iterator_get (_tmp419_);
					arg = (ValaExpression*) _tmp420_;
					_tmp421_ = arg;
					_tmp422_ = array_type;
					_tmp423_ = vala_array_type_get_element_type (_tmp422_);
					_tmp424_ = _tmp423_;
					vala_expression_set_target_type (_tmp421_, _tmp424_);
					_tmp425_ = arg;
					_tmp426_ = vala_expression_get_target_type (_tmp425_);
					_tmp427_ = _tmp426_;
					_tmp428_ = array_type;
					_tmp429_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp428_);
					_tmp430_ = _tmp429_;
					vala_data_type_set_value_owned (_tmp427_, _tmp430_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp431_ = arg_it;
			if (vala_iterator_next (_tmp431_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp432_;
				gpointer _tmp433_;
				ValaExpression* _tmp434_;
				ValaParameter* _tmp435_;
				ValaDataType* _tmp436_;
				ValaDataType* _tmp437_;
				ValaExpression* _tmp438_;
				ValaExpression* _tmp439_;
				ValaDataType* _tmp440_;
				ValaDataType* _tmp441_;
				ValaDataType* _tmp442_;
				ValaList* _tmp443_;
				ValaDataType* _tmp444_;
				ValaDataType* _tmp445_;
				ValaExpression* _tmp446_;
				ValaExpression* _tmp447_;
				_tmp432_ = arg_it;
				_tmp433_ = vala_iterator_get (_tmp432_);
				arg = (ValaExpression*) _tmp433_;
				_tmp434_ = arg;
				_tmp435_ = param;
				_tmp436_ = vala_variable_get_variable_type ((ValaVariable*) _tmp435_);
				_tmp437_ = _tmp436_;
				vala_expression_set_formal_target_type (_tmp434_, _tmp437_);
				_tmp438_ = arg;
				_tmp439_ = arg;
				_tmp440_ = vala_expression_get_formal_target_type (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = target_object_type;
				_tmp443_ = method_type_args;
				_tmp444_ = vala_data_type_get_actual_type (_tmp441_, _tmp442_, _tmp443_, (ValaCodeNode*) self);
				_tmp445_ = _tmp444_;
				vala_expression_set_target_type (_tmp438_, _tmp445_);
				_vala_code_node_unref0 (_tmp445_);
				_tmp446_ = arg;
				_tmp447_ = _vala_code_node_ref0 (_tmp446_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp447_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp449_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp449_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp450_;
		ValaMethod* _tmp451_;
		ValaMethod* _tmp452_;
		ValaAttribute* _tmp453_;
		_tmp450_ = mtype;
		_tmp451_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp450_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp452_ = _tmp451_;
		_tmp453_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp452_, "Print");
		_tmp448_ = _tmp453_ != NULL;
	} else {
		_tmp448_ = FALSE;
	}
	if (_tmp448_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp454_;
		ValaSourceReference* _tmp455_;
		ValaTemplate* _tmp456_;
		ValaList* _tmp467_;
		ValaTemplate* _tmp468_;
		_tmp454_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp455_ = _tmp454_;
		_tmp456_ = vala_template_new (_tmp455_);
		template = _tmp456_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp457_;
			ValaList* _tmp458_;
			gint _arg_size = 0;
			ValaList* _tmp459_;
			gint _tmp460_;
			gint _tmp461_;
			gint _arg_index = 0;
			_tmp457_ = self->priv->argument_list;
			_tmp458_ = _vala_iterable_ref0 (_tmp457_);
			_arg_list = _tmp458_;
			_tmp459_ = _arg_list;
			_tmp460_ = vala_collection_get_size ((ValaCollection*) _tmp459_);
			_tmp461_ = _tmp460_;
			_arg_size = _tmp461_;
			_arg_index = -1;
			while (TRUE) {
				ValaExpression* arg = NULL;
				ValaList* _tmp462_;
				gpointer _tmp463_;
				ValaExpression* _tmp464_;
				ValaTemplate* _tmp465_;
				ValaExpression* _tmp466_;
				_arg_index = _arg_index + 1;
				if (!(_arg_index < _arg_size)) {
					break;
				}
				_tmp462_ = _arg_list;
				_tmp463_ = vala_list_get (_tmp462_, _arg_index);
				arg = (ValaExpression*) _tmp463_;
				_tmp464_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp464_, NULL);
				_tmp465_ = template;
				_tmp466_ = arg;
				vala_template_add_expression (_tmp465_, _tmp466_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp467_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp467_);
		_tmp468_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp468_);
		_vala_code_node_unref0 (template);
	}
	_tmp470_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp470_, VALA_TYPE_METHOD_TYPE)) {
		ValaDataType* _tmp471_;
		ValaMethod* _tmp472_;
		ValaMethod* _tmp473_;
		gboolean _tmp474_;
		gboolean _tmp475_;
		_tmp471_ = mtype;
		_tmp472_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp471_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp473_ = _tmp472_;
		_tmp474_ = vala_method_get_printf_format (_tmp473_);
		_tmp475_ = _tmp474_;
		_tmp469_ = _tmp475_;
	} else {
		_tmp469_ = FALSE;
	}
	if (_tmp469_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp476_;
		ValaStringLiteral* _tmp521_;
		format_literal = NULL;
		_tmp476_ = last_arg;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp476_, VALA_TYPE_NULL_LITERAL)) {
		} else {
			ValaExpression* _tmp477_;
			_tmp477_ = last_arg;
			if (_tmp477_ != NULL) {
				ValaExpression* _tmp478_;
				ValaStringLiteral* _tmp479_;
				gboolean _tmp480_ = FALSE;
				ValaStringLiteral* _tmp481_;
				_tmp478_ = last_arg;
				_tmp479_ = vala_string_literal_get_format_literal (_tmp478_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp479_;
				_tmp481_ = format_literal;
				if (_tmp481_ == NULL) {
					ValaList* _tmp482_;
					gint _tmp483_;
					gint _tmp484_;
					ValaList* _tmp485_;
					gint _tmp486_;
					gint _tmp487_;
					_tmp482_ = args;
					_tmp483_ = vala_collection_get_size ((ValaCollection*) _tmp482_);
					_tmp484_ = _tmp483_;
					_tmp485_ = params;
					_tmp486_ = vala_collection_get_size ((ValaCollection*) _tmp485_);
					_tmp487_ = _tmp486_;
					_tmp480_ = _tmp484_ == (_tmp487_ - 1);
				} else {
					_tmp480_ = FALSE;
				}
				if (_tmp480_) {
					ValaStringLiteral* _tmp488_;
					ValaStringLiteral* _tmp489_;
					ValaSemanticAnalyzer* _tmp490_;
					ValaSemanticAnalyzer* _tmp491_;
					ValaDataType* _tmp492_;
					ValaDataType* _tmp493_;
					ValaDataType* _tmp494_;
					ValaList* _tmp495_;
					ValaList* _tmp496_;
					gint _tmp497_;
					gint _tmp498_;
					ValaStringLiteral* _tmp499_;
					ValaList* _tmp500_;
					ValaIterator* _tmp501_;
					_tmp488_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp488_;
					_tmp489_ = format_literal;
					_tmp490_ = vala_code_context_get_analyzer (context);
					_tmp491_ = _tmp490_;
					_tmp492_ = _tmp491_->string_type;
					_tmp493_ = vala_data_type_copy (_tmp492_);
					_tmp494_ = _tmp493_;
					vala_expression_set_target_type ((ValaExpression*) _tmp489_, _tmp494_);
					_vala_code_node_unref0 (_tmp494_);
					_tmp495_ = self->priv->argument_list;
					_tmp496_ = args;
					_tmp497_ = vala_collection_get_size ((ValaCollection*) _tmp496_);
					_tmp498_ = _tmp497_;
					_tmp499_ = format_literal;
					vala_list_insert (_tmp495_, _tmp498_ - 1, (ValaExpression*) _tmp499_);
					_tmp500_ = self->priv->argument_list;
					_tmp501_ = vala_iterable_iterator ((ValaIterable*) _tmp500_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp501_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp502_;
						ValaList* _tmp503_;
						gint _param_size = 0;
						ValaList* _tmp504_;
						gint _tmp505_;
						gint _tmp506_;
						gint _param_index = 0;
						_tmp502_ = params;
						_tmp503_ = _vala_iterable_ref0 (_tmp502_);
						_param_list = _tmp503_;
						_tmp504_ = _param_list;
						_tmp505_ = vala_collection_get_size ((ValaCollection*) _tmp504_);
						_tmp506_ = _tmp505_;
						_param_size = _tmp506_;
						_param_index = -1;
						while (TRUE) {
							ValaParameter* param = NULL;
							ValaList* _tmp507_;
							gpointer _tmp508_;
							ValaParameter* _tmp509_;
							gboolean _tmp510_;
							gboolean _tmp511_;
							ValaIterator* _tmp512_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp507_ = _param_list;
							_tmp508_ = vala_list_get (_tmp507_, _param_index);
							param = (ValaParameter*) _tmp508_;
							_tmp509_ = param;
							_tmp510_ = vala_parameter_get_ellipsis (_tmp509_);
							_tmp511_ = _tmp510_;
							if (_tmp511_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp512_ = arg_it;
							vala_iterator_next (_tmp512_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp513_;
				ValaExpression* _tmp514_;
				ValaMemberAccess* _tmp515_;
				ValaMemberAccess* _tmp516_;
				_tmp513_ = vala_method_call_get_call (self);
				_tmp514_ = _tmp513_;
				_tmp515_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp514_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp514_) : NULL);
				ma = _tmp515_;
				_tmp516_ = ma;
				if (_tmp516_ != NULL) {
					ValaMemberAccess* _tmp517_;
					ValaExpression* _tmp518_;
					ValaExpression* _tmp519_;
					ValaStringLiteral* _tmp520_;
					_tmp517_ = ma;
					_tmp518_ = vala_member_access_get_inner (_tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = vala_string_literal_get_format_literal (_tmp519_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp520_;
				}
				_vala_code_node_unref0 (ma);
			}
		}
		_tmp521_ = format_literal;
		if (_tmp521_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp522_;
			gchar* _tmp523_;
			ValaSemanticAnalyzer* _tmp524_;
			ValaSemanticAnalyzer* _tmp525_;
			const gchar* _tmp526_;
			ValaIterator* _tmp527_;
			ValaSourceReference* _tmp528_;
			ValaSourceReference* _tmp529_;
			_tmp522_ = format_literal;
			_tmp523_ = vala_string_literal_eval (_tmp522_);
			format = _tmp523_;
			_tmp524_ = vala_code_context_get_analyzer (context);
			_tmp525_ = _tmp524_;
			_tmp526_ = format;
			_tmp527_ = arg_it;
			_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp529_ = _tmp528_;
			if (!vala_semantic_analyzer_check_print_format (_tmp525_, _tmp526_, _tmp527_, _tmp529_)) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp530_;
		gint _arg_size = 0;
		ValaList* _tmp531_;
		gint _tmp532_;
		gint _tmp533_;
		gint _arg_index = 0;
		_tmp530_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp530_;
		_tmp531_ = _arg_list;
		_tmp532_ = vala_collection_get_size ((ValaCollection*) _tmp531_);
		_tmp533_ = _tmp532_;
		_arg_size = _tmp533_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp534_;
			gpointer _tmp535_;
			ValaExpression* _tmp536_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp534_ = _arg_list;
			_tmp535_ = vala_list_get (_tmp534_, _arg_index);
			arg = (ValaExpression*) _tmp535_;
			_tmp536_ = arg;
			vala_code_node_check ((ValaCodeNode*) _tmp536_, context);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp537_ = ret_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp537_, VALA_TYPE_VOID_TYPE)) {
		gboolean _tmp538_ = FALSE;
		gboolean _tmp539_ = FALSE;
		ValaCodeNode* _tmp540_;
		ValaCodeNode* _tmp541_;
		_tmp540_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp541_ = _tmp540_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp541_, VALA_TYPE_EXPRESSION_STATEMENT)) {
			ValaCodeNode* _tmp542_;
			ValaCodeNode* _tmp543_;
			_tmp542_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp543_ = _tmp542_;
			_tmp539_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp543_, VALA_TYPE_FOR_STATEMENT);
		} else {
			_tmp539_ = FALSE;
		}
		if (_tmp539_) {
			ValaCodeNode* _tmp544_;
			ValaCodeNode* _tmp545_;
			_tmp544_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp545_ = _tmp544_;
			_tmp538_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp545_, VALA_TYPE_YIELD_STATEMENT);
		} else {
			_tmp538_ = FALSE;
		}
		if (_tmp538_) {
			ValaSourceReference* _tmp546_;
			ValaSourceReference* _tmp547_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp546_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp547_ = _tmp546_;
			vala_report_error (_tmp547_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp548_ = ret_type;
	_tmp549_ = vala_data_type_copy (_tmp548_);
	_tmp550_ = _tmp549_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp550_);
	_vala_code_node_unref0 (_tmp550_);
	_tmp551_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp552_ = _tmp551_;
	_tmp553_ = target_object_type;
	_tmp554_ = method_type_args;
	_tmp555_ = vala_data_type_get_actual_type (_tmp552_, _tmp553_, _tmp554_, (ValaCodeNode*) self);
	_tmp556_ = _tmp555_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp556_);
	_vala_code_node_unref0 (_tmp556_);
	_tmp557_ = mtype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp557_, VALA_TYPE_METHOD_TYPE)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp558_;
		ValaMethod* _tmp559_;
		ValaMethod* _tmp560_;
		ValaMethod* _tmp561_;
		gboolean _tmp562_;
		ValaMethod* _tmp581_;
		gboolean _tmp582_;
		gboolean _tmp583_;
		ValaMethod* _tmp586_;
		gboolean _tmp587_;
		gboolean _tmp588_;
		gboolean _tmp593_ = FALSE;
		gboolean _tmp594_ = FALSE;
		gboolean _tmp595_ = FALSE;
		gboolean _tmp596_;
		gboolean _tmp597_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp609_;
		ValaSymbol* _tmp610_;
		ValaSymbol* _tmp611_;
		ValaDynamicSignal* _tmp612_;
		gboolean _tmp613_ = FALSE;
		ValaDynamicSignal* _tmp614_;
		gboolean _tmp656_ = FALSE;
		ValaMethod* _tmp657_;
		gboolean _tmp766_ = FALSE;
		ValaMethod* _tmp767_;
		_tmp558_ = mtype;
		_tmp559_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp558_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp560_ = _tmp559_;
		_tmp561_ = _vala_code_node_ref0 (_tmp560_);
		m = _tmp561_;
		_tmp562_ = self->priv->_is_yield_expression;
		if (_tmp562_) {
			ValaMethod* _tmp563_;
			gboolean _tmp564_;
			gboolean _tmp565_;
			gboolean _tmp568_ = FALSE;
			ValaSemanticAnalyzer* _tmp569_;
			ValaSemanticAnalyzer* _tmp570_;
			ValaMethod* _tmp571_;
			ValaMethod* _tmp572_;
			_tmp563_ = m;
			_tmp564_ = vala_method_get_coroutine (_tmp563_);
			_tmp565_ = _tmp564_;
			if (!_tmp565_) {
				ValaSourceReference* _tmp566_;
				ValaSourceReference* _tmp567_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp566_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp567_ = _tmp566_;
				vala_report_error (_tmp567_, "yield expression requires async method");
			}
			_tmp569_ = vala_code_context_get_analyzer (context);
			_tmp570_ = _tmp569_;
			_tmp571_ = vala_semantic_analyzer_get_current_method (_tmp570_);
			_tmp572_ = _tmp571_;
			if (_tmp572_ == NULL) {
				_tmp568_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp573_;
				ValaSemanticAnalyzer* _tmp574_;
				ValaMethod* _tmp575_;
				ValaMethod* _tmp576_;
				gboolean _tmp577_;
				gboolean _tmp578_;
				_tmp573_ = vala_code_context_get_analyzer (context);
				_tmp574_ = _tmp573_;
				_tmp575_ = vala_semantic_analyzer_get_current_method (_tmp574_);
				_tmp576_ = _tmp575_;
				_tmp577_ = vala_method_get_coroutine (_tmp576_);
				_tmp578_ = _tmp577_;
				_tmp568_ = !_tmp578_;
			}
			if (_tmp568_) {
				ValaSourceReference* _tmp579_;
				ValaSourceReference* _tmp580_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp580_ = _tmp579_;
				vala_report_error (_tmp580_, "yield expression not available outside async method");
			}
		}
		_tmp581_ = m;
		_tmp582_ = vala_method_get_returns_floating_reference (_tmp581_);
		_tmp583_ = _tmp582_;
		if (_tmp583_) {
			ValaDataType* _tmp584_;
			ValaDataType* _tmp585_;
			_tmp584_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp585_ = _tmp584_;
			vala_data_type_set_floating_reference (_tmp585_, TRUE);
		}
		_tmp586_ = m;
		_tmp587_ = vala_method_get_returns_modified_pointer (_tmp586_);
		_tmp588_ = _tmp587_;
		if (_tmp588_) {
			ValaExpression* _tmp589_;
			ValaExpression* _tmp590_;
			ValaExpression* _tmp591_;
			ValaExpression* _tmp592_;
			_tmp589_ = vala_method_call_get_call (self);
			_tmp590_ = _tmp589_;
			_tmp591_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp590_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp592_ = _tmp591_;
			vala_expression_set_lvalue (_tmp592_, TRUE);
		}
		_tmp596_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp597_ = _tmp596_;
		if (_tmp597_) {
			ValaDataType* _tmp598_;
			ValaDataType* _tmp599_;
			gboolean _tmp600_;
			gboolean _tmp601_;
			_tmp598_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp599_ = _tmp598_;
			_tmp600_ = vala_data_type_get_nullable (_tmp599_);
			_tmp601_ = _tmp600_;
			_tmp595_ = !_tmp601_;
		} else {
			_tmp595_ = FALSE;
		}
		if (_tmp595_) {
			ValaDataType* _tmp602_;
			ValaDataType* _tmp603_;
			gboolean _tmp604_;
			gboolean _tmp605_;
			_tmp602_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp603_ = _tmp602_;
			_tmp604_ = vala_data_type_get_floating_reference (_tmp603_);
			_tmp605_ = _tmp604_;
			_tmp594_ = _tmp605_;
		} else {
			_tmp594_ = FALSE;
		}
		if (_tmp594_) {
			ValaDataType* _tmp606_;
			_tmp606_ = ret_type;
			_tmp593_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp606_, VALA_TYPE_OBJECT_TYPE);
		} else {
			_tmp593_ = FALSE;
		}
		if (_tmp593_) {
			ValaDataType* _tmp607_;
			ValaDataType* _tmp608_;
			_tmp607_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp608_ = _tmp607_;
			vala_data_type_set_nullable (_tmp608_, TRUE);
		}
		_tmp609_ = m;
		_tmp610_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp609_);
		_tmp611_ = _tmp610_;
		_tmp612_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp611_, VALA_TYPE_DYNAMIC_SIGNAL) ? ((ValaDynamicSignal*) _tmp611_) : NULL);
		dynamic_sig = _tmp612_;
		_tmp614_ = dynamic_sig;
		if (_tmp614_ != NULL) {
			ValaDynamicSignal* _tmp615_;
			ValaExpression* _tmp616_;
			ValaExpression* _tmp617_;
			_tmp615_ = dynamic_sig;
			_tmp616_ = vala_dynamic_signal_get_handler (_tmp615_);
			_tmp617_ = _tmp616_;
			_tmp613_ = _tmp617_ != NULL;
		} else {
			_tmp613_ = FALSE;
		}
		if (_tmp613_) {
			ValaDynamicSignal* _tmp618_;
			ValaDynamicSignal* _tmp619_;
			ValaExpression* _tmp620_;
			ValaExpression* _tmp621_;
			ValaDataType* _tmp622_;
			ValaDataType* _tmp623_;
			ValaDataType* _tmp624_;
			ValaDataType* _tmp625_;
			ValaDataType* _tmp626_;
			ValaDataType* _tmp627_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp643_;
			ValaExpression* _tmp644_;
			ValaExpression* _tmp645_;
			ValaDynamicSignal* _tmp646_;
			ValaDynamicSignal* _tmp647_;
			ValaSymbol* _tmp648_;
			ValaSymbol* _tmp649_;
			ValaObjectType* _tmp650_;
			ValaObjectType* _tmp651_;
			ValaDelegate* _tmp652_;
			ValaDelegate* _tmp653_;
			ValaDelegateType* _tmp654_;
			ValaDelegateType* _tmp655_;
			_tmp618_ = dynamic_sig;
			_tmp619_ = dynamic_sig;
			_tmp620_ = vala_dynamic_signal_get_handler (_tmp619_);
			_tmp621_ = _tmp620_;
			_tmp622_ = vala_expression_get_value_type (_tmp621_);
			_tmp623_ = _tmp622_;
			_tmp624_ = vala_data_type_get_return_type (_tmp623_);
			_tmp625_ = _tmp624_;
			_tmp626_ = vala_data_type_copy (_tmp625_);
			_tmp627_ = _tmp626_;
			vala_callable_set_return_type ((ValaCallable*) _tmp618_, _tmp627_);
			_vala_code_node_unref0 (_tmp627_);
			_vala_code_node_unref0 (_tmp625_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp628_;
				ValaExpression* _tmp629_;
				ValaExpression* _tmp630_;
				ValaDataType* _tmp631_;
				ValaDataType* _tmp632_;
				ValaList* _tmp633_;
				gint _param_size = 0;
				ValaList* _tmp634_;
				gint _tmp635_;
				gint _tmp636_;
				gint _param_index = 0;
				_tmp628_ = dynamic_sig;
				_tmp629_ = vala_dynamic_signal_get_handler (_tmp628_);
				_tmp630_ = _tmp629_;
				_tmp631_ = vala_expression_get_value_type (_tmp630_);
				_tmp632_ = _tmp631_;
				_tmp633_ = vala_data_type_get_parameters (_tmp632_);
				_param_list = _tmp633_;
				_tmp634_ = _param_list;
				_tmp635_ = vala_collection_get_size ((ValaCollection*) _tmp634_);
				_tmp636_ = _tmp635_;
				_param_size = _tmp636_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp637_;
					gpointer _tmp638_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp637_ = _param_list;
					_tmp638_ = vala_list_get (_tmp637_, _param_index);
					param = (ValaParameter*) _tmp638_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp639_;
						ValaParameter* _tmp640_;
						ValaParameter* _tmp641_;
						ValaParameter* _tmp642_;
						_tmp639_ = dynamic_sig;
						_tmp640_ = param;
						_tmp641_ = vala_parameter_copy (_tmp640_);
						_tmp642_ = _tmp641_;
						vala_callable_add_parameter ((ValaCallable*) _tmp639_, _tmp642_);
						_vala_code_node_unref0 (_tmp642_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp643_ = dynamic_sig;
			_tmp644_ = vala_dynamic_signal_get_handler (_tmp643_);
			_tmp645_ = _tmp644_;
			_tmp646_ = dynamic_sig;
			_tmp647_ = dynamic_sig;
			_tmp648_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp647_);
			_tmp649_ = _tmp648_;
			_tmp650_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp649_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp651_ = _tmp650_;
			_tmp652_ = vala_signal_get_delegate ((ValaSignal*) _tmp646_, (ValaDataType*) _tmp651_, (ValaCodeNode*) self);
			_tmp653_ = _tmp652_;
			_tmp654_ = vala_delegate_type_new (_tmp653_);
			_tmp655_ = _tmp654_;
			vala_expression_set_target_type (_tmp645_, (ValaDataType*) _tmp655_);
			_vala_code_node_unref0 (_tmp655_);
			_vala_code_node_unref0 (_tmp653_);
			_vala_code_node_unref0 (_tmp651_);
		}
		_tmp657_ = m;
		if (_tmp657_ != NULL) {
			ValaMethod* _tmp658_;
			_tmp658_ = m;
			_tmp656_ = vala_method_has_type_parameters (_tmp658_);
		} else {
			_tmp656_ = FALSE;
		}
		if (_tmp656_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp659_;
			ValaExpression* _tmp660_;
			ValaMemberAccess* _tmp661_;
			ValaMemberAccess* _tmp662_;
			ValaList* _tmp663_;
			ValaList* _tmp664_;
			gint _tmp665_;
			gint _tmp666_;
			gboolean _tmp667_;
			_tmp659_ = vala_method_call_get_call (self);
			_tmp660_ = _tmp659_;
			_tmp661_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp660_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp661_;
			_tmp662_ = ma;
			_tmp663_ = vala_member_access_get_type_arguments (_tmp662_);
			_tmp664_ = _tmp663_;
			_tmp665_ = vala_collection_get_size ((ValaCollection*) _tmp664_);
			_tmp666_ = _tmp665_;
			_tmp667_ = _tmp666_ == 0;
			_vala_iterable_unref0 (_tmp664_);
			if (_tmp667_) {
				ValaList* _tmp733_;
				ValaIterator* _tmp734_;
				ValaDataType* _tmp760_;
				ValaDataType* _tmp761_;
				ValaDataType* _tmp762_;
				ValaList* _tmp763_;
				ValaDataType* _tmp764_;
				ValaDataType* _tmp765_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp668_;
					ValaList* _tmp669_;
					gint _type_param_size = 0;
					ValaList* _tmp670_;
					gint _tmp671_;
					gint _tmp672_;
					gint _type_param_index = 0;
					_tmp668_ = m;
					_tmp669_ = vala_method_get_type_parameters (_tmp668_);
					_type_param_list = _tmp669_;
					_tmp670_ = _type_param_list;
					_tmp671_ = vala_collection_get_size ((ValaCollection*) _tmp670_);
					_tmp672_ = _tmp671_;
					_type_param_size = _tmp672_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp673_;
						gpointer _tmp674_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp675_;
						ValaIterator* _tmp676_;
						gboolean _tmp711_ = FALSE;
						ValaDataType* _tmp712_;
						ValaDataType* _tmp722_;
						ValaMemberAccess* _tmp731_;
						ValaDataType* _tmp732_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp673_ = _type_param_list;
						_tmp674_ = vala_list_get (_tmp673_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp674_;
						type_arg = NULL;
						_tmp675_ = args;
						_tmp676_ = vala_iterable_iterator ((ValaIterable*) _tmp675_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp676_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp677_;
							ValaList* _tmp678_;
							gint _param_size = 0;
							ValaList* _tmp679_;
							gint _tmp680_;
							gint _tmp681_;
							gint _param_index = 0;
							_tmp677_ = params;
							_tmp678_ = _vala_iterable_ref0 (_tmp677_);
							_param_list = _tmp678_;
							_tmp679_ = _param_list;
							_tmp680_ = vala_collection_get_size ((ValaCollection*) _tmp679_);
							_tmp681_ = _tmp680_;
							_param_size = _tmp681_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp682_;
								gpointer _tmp683_;
								gboolean _tmp684_ = FALSE;
								ValaParameter* _tmp685_;
								gboolean _tmp686_;
								gboolean _tmp687_;
								ValaIterator* _tmp691_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp682_ = _param_list;
								_tmp683_ = vala_list_get (_tmp682_, _param_index);
								param = (ValaParameter*) _tmp683_;
								_tmp685_ = param;
								_tmp686_ = vala_parameter_get_ellipsis (_tmp685_);
								_tmp687_ = _tmp686_;
								if (_tmp687_) {
									_tmp684_ = TRUE;
								} else {
									ValaParameter* _tmp688_;
									gboolean _tmp689_;
									gboolean _tmp690_;
									_tmp688_ = param;
									_tmp689_ = vala_parameter_get_params_array (_tmp688_);
									_tmp690_ = _tmp689_;
									_tmp684_ = _tmp690_;
								}
								if (_tmp684_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp691_ = arg_it;
								if (vala_iterator_next (_tmp691_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp692_;
									gpointer _tmp693_;
									ValaParameter* _tmp694_;
									ValaDataType* _tmp695_;
									ValaDataType* _tmp696_;
									ValaTypeParameter* _tmp697_;
									ValaExpression* _tmp698_;
									ValaDataType* _tmp699_;
									ValaDataType* _tmp700_;
									ValaDataType* _tmp701_;
									ValaDataType* _tmp702_;
									ValaExpression* _tmp703_;
									ValaExpression* _tmp704_;
									ValaDataType* _tmp705_;
									ValaDataType* _tmp706_;
									ValaDataType* _tmp707_;
									ValaList* _tmp708_;
									ValaDataType* _tmp709_;
									ValaDataType* _tmp710_;
									_tmp692_ = arg_it;
									_tmp693_ = vala_iterator_get (_tmp692_);
									arg = (ValaExpression*) _tmp693_;
									_tmp694_ = param;
									_tmp695_ = vala_variable_get_variable_type ((ValaVariable*) _tmp694_);
									_tmp696_ = _tmp695_;
									_tmp697_ = type_param;
									_tmp698_ = arg;
									_tmp699_ = vala_expression_get_value_type (_tmp698_);
									_tmp700_ = _tmp699_;
									_tmp701_ = vala_data_type_infer_type_argument (_tmp696_, _tmp697_, _tmp700_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp701_;
									_tmp702_ = type_arg;
									if (_tmp702_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp703_ = arg;
									_tmp704_ = arg;
									_tmp705_ = vala_expression_get_formal_target_type (_tmp704_);
									_tmp706_ = _tmp705_;
									_tmp707_ = target_object_type;
									_tmp708_ = method_type_args;
									_tmp709_ = vala_data_type_get_actual_type (_tmp706_, _tmp707_, _tmp708_, (ValaCodeNode*) self);
									_tmp710_ = _tmp709_;
									vala_expression_set_target_type (_tmp703_, _tmp710_);
									_vala_code_node_unref0 (_tmp710_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp712_ = type_arg;
						if (_tmp712_ == NULL) {
							ValaDataType* _tmp713_;
							ValaDataType* _tmp714_;
							_tmp713_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp714_ = _tmp713_;
							_tmp711_ = _tmp714_ != NULL;
						} else {
							_tmp711_ = FALSE;
						}
						if (_tmp711_) {
							ValaMethod* _tmp715_;
							ValaDataType* _tmp716_;
							ValaDataType* _tmp717_;
							ValaTypeParameter* _tmp718_;
							ValaDataType* _tmp719_;
							ValaDataType* _tmp720_;
							ValaDataType* _tmp721_;
							_tmp715_ = m;
							_tmp716_ = vala_callable_get_return_type ((ValaCallable*) _tmp715_);
							_tmp717_ = _tmp716_;
							_tmp718_ = type_param;
							_tmp719_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp720_ = _tmp719_;
							_tmp721_ = vala_data_type_infer_type_argument (_tmp717_, _tmp718_, _tmp720_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp721_;
						}
						_tmp722_ = type_arg;
						if (_tmp722_ == NULL) {
							ValaMemberAccess* _tmp723_;
							ValaSourceReference* _tmp724_;
							ValaSourceReference* _tmp725_;
							ValaTypeParameter* _tmp726_;
							gchar* _tmp727_;
							gchar* _tmp728_;
							gchar* _tmp729_;
							gchar* _tmp730_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp723_ = ma;
							_tmp724_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp723_);
							_tmp725_ = _tmp724_;
							_tmp726_ = type_param;
							_tmp727_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp726_);
							_tmp728_ = _tmp727_;
							_tmp729_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp728_);
							_tmp730_ = _tmp729_;
							vala_report_error (_tmp725_, _tmp730_);
							_g_free0 (_tmp730_);
							_g_free0 (_tmp728_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp731_ = ma;
						_tmp732_ = type_arg;
						vala_member_access_add_type_argument (_tmp731_, _tmp732_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp733_ = args;
				_tmp734_ = vala_iterable_iterator ((ValaIterable*) _tmp733_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp734_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp735_;
					ValaList* _tmp736_;
					gint _param_size = 0;
					ValaList* _tmp737_;
					gint _tmp738_;
					gint _tmp739_;
					gint _param_index = 0;
					_tmp735_ = params;
					_tmp736_ = _vala_iterable_ref0 (_tmp735_);
					_param_list = _tmp736_;
					_tmp737_ = _param_list;
					_tmp738_ = vala_collection_get_size ((ValaCollection*) _tmp737_);
					_tmp739_ = _tmp738_;
					_param_size = _tmp739_;
					_param_index = -1;
					while (TRUE) {
						ValaParameter* param = NULL;
						ValaList* _tmp740_;
						gpointer _tmp741_;
						gboolean _tmp742_ = FALSE;
						ValaParameter* _tmp743_;
						gboolean _tmp744_;
						gboolean _tmp745_;
						ValaIterator* _tmp749_;
						_param_index = _param_index + 1;
						if (!(_param_index < _param_size)) {
							break;
						}
						_tmp740_ = _param_list;
						_tmp741_ = vala_list_get (_tmp740_, _param_index);
						param = (ValaParameter*) _tmp741_;
						_tmp743_ = param;
						_tmp744_ = vala_parameter_get_ellipsis (_tmp743_);
						_tmp745_ = _tmp744_;
						if (_tmp745_) {
							_tmp742_ = TRUE;
						} else {
							ValaParameter* _tmp746_;
							gboolean _tmp747_;
							gboolean _tmp748_;
							_tmp746_ = param;
							_tmp747_ = vala_parameter_get_params_array (_tmp746_);
							_tmp748_ = _tmp747_;
							_tmp742_ = _tmp748_;
						}
						if (_tmp742_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp749_ = arg_it;
						if (vala_iterator_next (_tmp749_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp750_;
							gpointer _tmp751_;
							ValaExpression* _tmp752_;
							ValaExpression* _tmp753_;
							ValaDataType* _tmp754_;
							ValaDataType* _tmp755_;
							ValaDataType* _tmp756_;
							ValaList* _tmp757_;
							ValaDataType* _tmp758_;
							ValaDataType* _tmp759_;
							_tmp750_ = arg_it;
							_tmp751_ = vala_iterator_get (_tmp750_);
							arg = (ValaExpression*) _tmp751_;
							_tmp752_ = arg;
							_tmp753_ = arg;
							_tmp754_ = vala_expression_get_formal_target_type (_tmp753_);
							_tmp755_ = _tmp754_;
							_tmp756_ = target_object_type;
							_tmp757_ = method_type_args;
							_tmp758_ = vala_data_type_get_actual_type (_tmp755_, _tmp756_, _tmp757_, (ValaCodeNode*) self);
							_tmp759_ = _tmp758_;
							vala_expression_set_target_type (_tmp752_, _tmp759_);
							_vala_code_node_unref0 (_tmp759_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp760_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp761_ = _tmp760_;
				_tmp762_ = target_object_type;
				_tmp763_ = method_type_args;
				_tmp764_ = vala_data_type_get_actual_type (_tmp761_, _tmp762_, _tmp763_, (ValaCodeNode*) self);
				_tmp765_ = _tmp764_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp765_);
				_vala_code_node_unref0 (_tmp765_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp767_ = m;
		if (_tmp767_ != NULL) {
			ValaMethod* _tmp768_;
			gboolean _tmp769_;
			gboolean _tmp770_;
			_tmp768_ = m;
			_tmp769_ = vala_method_get_coroutine (_tmp768_);
			_tmp770_ = _tmp769_;
			_tmp766_ = _tmp770_;
		} else {
			_tmp766_ = FALSE;
		}
		if (_tmp766_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp771_;
			ValaExpression* _tmp772_;
			ValaMemberAccess* _tmp773_;
			ValaMemberAccess* _tmp774_;
			const gchar* _tmp775_;
			const gchar* _tmp776_;
			_tmp771_ = vala_method_call_get_call (self);
			_tmp772_ = _tmp771_;
			_tmp773_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp772_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp773_;
			_tmp774_ = ma;
			_tmp775_ = vala_member_access_get_member_name (_tmp774_);
			_tmp776_ = _tmp775_;
			if (g_strcmp0 (_tmp776_, "end") == 0) {
				ValaMethod* _tmp777_;
				ValaMethod* _tmp778_;
				ValaMethod* _tmp779_;
				ValaMethodType* _tmp780_;
				_tmp777_ = m;
				_tmp778_ = vala_method_get_end_method (_tmp777_);
				_tmp779_ = _tmp778_;
				_tmp780_ = vala_method_type_new (_tmp779_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp780_;
				_vala_code_node_unref0 (_tmp779_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	}
	_tmp781_ = vala_code_context_get_analyzer (context);
	_tmp782_ = _tmp781_;
	_tmp783_ = mtype;
	_tmp784_ = params;
	_tmp785_ = vala_method_call_get_argument_list (self);
	_tmp786_ = _tmp785_;
	_tmp787_ = !vala_semantic_analyzer_check_arguments (_tmp782_, (ValaExpression*) self, _tmp783_, _tmp784_, _tmp786_);
	_vala_iterable_unref0 (_tmp786_);
	if (_tmp787_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	_tmp790_ = base_cm;
	if (_tmp790_ != NULL) {
		ValaCreationMethod* _tmp791_;
		_tmp791_ = base_cm;
		_tmp789_ = vala_method_is_variadic ((ValaMethod*) _tmp791_);
	} else {
		_tmp789_ = FALSE;
	}
	if (_tmp789_) {
		ValaList* _tmp792_;
		gint _tmp793_;
		gint _tmp794_;
		ValaCreationMethod* _tmp795_;
		ValaList* _tmp796_;
		ValaList* _tmp797_;
		gint _tmp798_;
		gint _tmp799_;
		_tmp792_ = args;
		_tmp793_ = vala_collection_get_size ((ValaCollection*) _tmp792_);
		_tmp794_ = _tmp793_;
		_tmp795_ = base_cm;
		_tmp796_ = vala_callable_get_parameters ((ValaCallable*) _tmp795_);
		_tmp797_ = _tmp796_;
		_tmp798_ = vala_collection_get_size ((ValaCollection*) _tmp797_);
		_tmp799_ = _tmp798_;
		_tmp788_ = _tmp794_ == _tmp799_;
		_vala_iterable_unref0 (_tmp797_);
	} else {
		_tmp788_ = FALSE;
	}
	if (_tmp788_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp800_;
		ValaList* _tmp801_;
		gint _tmp802_;
		gint _tmp803_;
		gpointer _tmp804_;
		gboolean _tmp805_ = FALSE;
		ValaExpression* _tmp806_;
		ValaDataType* _tmp807_;
		ValaDataType* _tmp808_;
		_tmp800_ = args;
		_tmp801_ = args;
		_tmp802_ = vala_collection_get_size ((ValaCollection*) _tmp801_);
		_tmp803_ = _tmp802_;
		_tmp804_ = vala_list_get (_tmp800_, _tmp803_ - 1);
		this_last_arg = (ValaExpression*) _tmp804_;
		_tmp806_ = this_last_arg;
		_tmp807_ = vala_expression_get_value_type (_tmp806_);
		_tmp808_ = _tmp807_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp808_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
			ValaExpression* _tmp809_;
			ValaDataType* _tmp810_;
			ValaDataType* _tmp811_;
			ValaTypeSymbol* _tmp812_;
			ValaTypeSymbol* _tmp813_;
			ValaSemanticAnalyzer* _tmp814_;
			ValaSemanticAnalyzer* _tmp815_;
			ValaDataType* _tmp816_;
			ValaTypeSymbol* _tmp817_;
			ValaTypeSymbol* _tmp818_;
			_tmp809_ = this_last_arg;
			_tmp810_ = vala_expression_get_value_type (_tmp809_);
			_tmp811_ = _tmp810_;
			_tmp812_ = vala_data_type_get_data_type (_tmp811_);
			_tmp813_ = _tmp812_;
			_tmp814_ = vala_code_context_get_analyzer (context);
			_tmp815_ = _tmp814_;
			_tmp816_ = _tmp815_->va_list_type;
			_tmp817_ = vala_data_type_get_data_type (_tmp816_);
			_tmp818_ = _tmp817_;
			_tmp805_ = _tmp813_ == _tmp818_;
		} else {
			_tmp805_ = FALSE;
		}
		if (_tmp805_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp819_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp820_ = _tmp819_;
	if (_tmp820_) {
		gboolean _tmp821_ = FALSE;
		ValaCodeNode* _tmp822_;
		ValaCodeNode* _tmp823_;
		_tmp822_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp823_ = _tmp822_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp823_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp821_ = TRUE;
		} else {
			ValaCodeNode* _tmp824_;
			ValaCodeNode* _tmp825_;
			_tmp824_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp825_ = _tmp824_;
			_tmp821_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp825_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp821_) {
		} else {
			ValaSemanticAnalyzer* _tmp826_;
			ValaSemanticAnalyzer* _tmp827_;
			ValaSymbol* _tmp828_;
			ValaSymbol* _tmp829_;
			_tmp826_ = vala_code_context_get_analyzer (context);
			_tmp827_ = _tmp826_;
			_tmp828_ = vala_semantic_analyzer_get_current_symbol (_tmp827_);
			_tmp829_ = _tmp828_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp829_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp830_;
				ValaSourceReference* _tmp831_;
				_tmp830_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp831_ = _tmp830_;
				vala_report_error (_tmp831_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp832_;
				ValaCodeNode* _tmp833_;
				ValaCodeNode* _tmp834_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp835_;
				ValaDataType* _tmp836_;
				ValaDataType* _tmp837_;
				ValaDataType* _tmp838_;
				gchar* _tmp839_;
				gchar* _tmp840_;
				ValaSourceReference* _tmp841_;
				ValaSourceReference* _tmp842_;
				ValaLocalVariable* _tmp843_;
				ValaLocalVariable* _tmp844_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp845_;
				ValaSourceReference* _tmp846_;
				ValaSourceReference* _tmp847_;
				ValaDeclarationStatement* _tmp848_;
				ValaSemanticAnalyzer* _tmp849_;
				ValaSemanticAnalyzer* _tmp850_;
				ValaBlock* _tmp851_;
				ValaDeclarationStatement* _tmp852_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp853_;
				ValaDataType* _tmp854_;
				ValaDataType* _tmp855_;
				ValaExpression* _tmp856_;
				ValaLocalVariable* _tmp857_;
				ValaDeclarationStatement* _tmp858_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp859_;
				ValaSemanticAnalyzer* _tmp860_;
				ValaSymbol* _tmp861_;
				ValaSymbol* _tmp862_;
				ValaBlock* _tmp863_;
				ValaBlock* _tmp864_;
				ValaLocalVariable* _tmp865_;
				ValaSemanticAnalyzer* _tmp866_;
				ValaSemanticAnalyzer* _tmp867_;
				ValaBlock* _tmp868_;
				ValaLocalVariable* _tmp869_;
				ValaCodeNode* _tmp870_;
				ValaExpression* _tmp871_;
				ValaExpression* _tmp872_;
				_tmp832_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp833_ = _tmp832_;
				_tmp834_ = _vala_code_node_ref0 (_tmp833_);
				old_parent_node = _tmp834_;
				_tmp835_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp836_ = _tmp835_;
				_tmp837_ = vala_data_type_copy (_tmp836_);
				_tmp838_ = _tmp837_;
				_tmp839_ = vala_code_node_get_temp_name ();
				_tmp840_ = _tmp839_;
				_tmp841_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp842_ = _tmp841_;
				_tmp843_ = vala_local_variable_new (_tmp838_, _tmp840_, NULL, _tmp842_);
				_tmp844_ = _tmp843_;
				_g_free0 (_tmp840_);
				_vala_code_node_unref0 (_tmp838_);
				local = _tmp844_;
				_tmp845_ = local;
				_tmp846_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp847_ = _tmp846_;
				_tmp848_ = vala_declaration_statement_new ((ValaSymbol*) _tmp845_, _tmp847_);
				decl = _tmp848_;
				_tmp849_ = vala_code_context_get_analyzer (context);
				_tmp850_ = _tmp849_;
				_tmp851_ = _tmp850_->insert_block;
				_tmp852_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp851_, (ValaStatement*) _tmp852_);
				_tmp853_ = local;
				_tmp854_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp855_ = _tmp854_;
				_tmp856_ = vala_semantic_analyzer_create_temp_access (_tmp853_, _tmp855_);
				temp_access = _tmp856_;
				_tmp857_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp857_, (ValaExpression*) self);
				_tmp858_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp858_, context);
				_tmp859_ = vala_code_context_get_analyzer (context);
				_tmp860_ = _tmp859_;
				_tmp861_ = vala_semantic_analyzer_get_current_symbol (_tmp860_);
				_tmp862_ = _tmp861_;
				_tmp863_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp862_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp863_;
				_tmp864_ = block;
				_tmp865_ = local;
				vala_block_remove_local_variable (_tmp864_, _tmp865_);
				_tmp866_ = vala_code_context_get_analyzer (context);
				_tmp867_ = _tmp866_;
				_tmp868_ = _tmp867_->insert_block;
				_tmp869_ = local;
				vala_block_add_local_variable (_tmp868_, _tmp869_);
				_tmp870_ = old_parent_node;
				_tmp871_ = temp_access;
				vala_code_node_replace_expression (_tmp870_, (ValaExpression*) self, _tmp871_);
				_tmp872_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp872_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp873_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp874_ = _tmp873_;
	result = !_tmp874_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		_tmp18_ = vala_method_call_get_call (self);
		_tmp19_ = _tmp18_;
		vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _expr_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _expr_index = 0;
		_tmp20_ = self->priv->argument_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_expr_list = _tmp21_;
		_tmp22_ = _expr_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_expr_size = _tmp24_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaExpression* _tmp27_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp25_ = _expr_list;
			_tmp26_ = vala_list_get (_tmp25_, _expr_index);
			expr = (ValaExpression*) _tmp26_;
			_tmp27_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp27_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = vala_list_get (_tmp7_, _arg_index);
			arg = (ValaExpression*) _tmp8_;
			_tmp9_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp9_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		format_arg = vala_method_get_format_arg_index (_tmp8_);
		if (format_arg >= 0) {
			ValaList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp10_ = self->priv->argument_list;
			_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp9_ = format_arg < _tmp12_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			ValaStringLiteral* _tmp16_;
			ValaStringLiteral* _tmp17_;
			_tmp13_ = self->priv->argument_list;
			_tmp14_ = vala_list_get (_tmp13_, format_arg);
			_tmp15_ = (ValaExpression*) _tmp14_;
			_tmp16_ = vala_string_literal_get_format_literal (_tmp15_);
			_tmp17_ = _tmp16_;
			_vala_code_node_unref0 (_tmp15_);
			result = _tmp17_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	gchar* result = NULL;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp22_;
	GString* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			ValaExpression* expr = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			GString* _tmp18_;
			ValaExpression* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_expr_index = _expr_index + 1;
			if (!(_expr_index < _expr_size)) {
				break;
			}
			_tmp15_ = _expr_list;
			_tmp16_ = vala_list_get (_tmp15_, _expr_index);
			expr = (ValaExpression*) _tmp16_;
			if (!first) {
				GString* _tmp17_;
				_tmp17_ = b;
				g_string_append (_tmp17_, ", ");
			}
			_tmp18_ = b;
			_tmp19_ = expr;
			_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			g_string_append (_tmp18_, _tmp21_);
			_g_free0 (_tmp21_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp22_ = b;
	g_string_append (_tmp22_, "))");
	_tmp23_ = b;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = g_strdup (_tmp24_);
	result = _tmp25_;
	_g_string_free0 (b);
	return result;
}

ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_yield_expression;
	return result;
}

void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}

