/* tracker-store.c generated by valac 0.43.90, the Vala compiler
 * generated from tracker-store.vala, do not modify */

/*
 * Copyright (C) 2009-2011, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 *
 * Author: Philip Van Hoof <philip@codeminded.be>
 */

#include <glib-object.h>
#include <glib.h>
#include "tracker-store/tracker-config.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "libtracker-data/tracker-class.h"
#include "tracker-store/tracker-events.h"
#include "libtracker-sparql/tracker-sparql.h"
#include "tracker-store/tracker-writeback.h"
#include "libtracker-direct/tracker-direct.h"
#include "libtracker-data/tracker-data-manager.h"
#include "libtracker-data/tracker-data-query.h"
#include "libtracker-data/tracker-data-update.h"
#include <gobject/gvaluecollector.h>

#define TRACKER_TYPE_STORE (tracker_store_get_type ())
#define TRACKER_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_TYPE_STORE, TrackerStore))
#define TRACKER_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_TYPE_STORE, TrackerStoreClass))
#define TRACKER_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_TYPE_STORE))
#define TRACKER_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_TYPE_STORE))
#define TRACKER_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_TYPE_STORE, TrackerStoreClass))

typedef struct _TrackerStore TrackerStore;
typedef struct _TrackerStoreClass TrackerStoreClass;
typedef struct _TrackerStorePrivate TrackerStorePrivate;
typedef void (*TrackerStoreSignalEmissionFunc) (GHashTable* graph_updated, GHashTable* writeback, gpointer user_data);

#define TRACKER_STORE_TYPE_CURSOR_TASK (tracker_store_cursor_task_get_type ())
#define TRACKER_STORE_CURSOR_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRACKER_STORE_TYPE_CURSOR_TASK, TrackerStoreCursorTask))
#define TRACKER_STORE_CURSOR_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRACKER_STORE_TYPE_CURSOR_TASK, TrackerStoreCursorTaskClass))
#define TRACKER_STORE_IS_CURSOR_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRACKER_STORE_TYPE_CURSOR_TASK))
#define TRACKER_STORE_IS_CURSOR_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRACKER_STORE_TYPE_CURSOR_TASK))
#define TRACKER_STORE_CURSOR_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRACKER_STORE_TYPE_CURSOR_TASK, TrackerStoreCursorTaskClass))

typedef struct _TrackerStoreCursorTask TrackerStoreCursorTask;
typedef struct _TrackerStoreCursorTaskClass TrackerStoreCursorTaskClass;
#define _tracker_store_cursor_task_unref0(var) ((var == NULL) ? NULL : (var = (tracker_store_cursor_task_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _TrackerStoreCursorTaskPrivate TrackerStoreCursorTaskPrivate;
typedef void (*TrackerStoreSparqlQueryInThread) (TrackerSparqlCursor* cursor, gpointer user_data, GError** error);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_thread_pool_free0(var) ((var == NULL) ? NULL : (var = (g_thread_pool_free (var, FALSE, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _TrackerStoreSparqlQueryData TrackerStoreSparqlQueryData;
typedef struct _TrackerStoreSparqlUpdateData TrackerStoreSparqlUpdateData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _TrackerStoreSparqlUpdateBlankData TrackerStoreSparqlUpdateBlankData;
typedef struct _TrackerStoreQueueTurtleImportData TrackerStoreQueueTurtleImportData;
typedef struct _TrackerStorePauseData TrackerStorePauseData;
typedef struct _TrackerStoreParamSpecCursorTask TrackerStoreParamSpecCursorTask;
typedef struct _TrackerParamSpecStore TrackerParamSpecStore;

struct _TrackerStore {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStorePrivate * priv;
};

struct _TrackerStoreClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStore *self);
};

struct _Block7Data {
	int _ref_count_;
	TrackerStoreCursorTask* task;
};

struct _TrackerStoreCursorTask {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrackerStoreCursorTaskPrivate * priv;
	TrackerSparqlCursor* cursor;
	GSourceFunc callback;
	gpointer callback_target;
	TrackerStoreSparqlQueryInThread thread_func;
	gpointer thread_func_target;
	GError* error;
};

struct _TrackerStoreCursorTaskClass {
	GTypeClass parent_class;
	void (*finalize) (TrackerStoreCursorTask *self);
};

struct _Block8Data {
	int _ref_count_;
	GCancellable* task_cancellable;
};

struct _Block9Data {
	int _ref_count_;
	GCancellable* cancellable;
	guint timeout_id;
	gpointer _async_data_;
};

struct _TrackerStoreSparqlQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* conn;
	gchar* sparql;
	gint priority;
	TrackerStoreSparqlQueryInThread in_thread;
	gpointer in_thread_target;
	gchar* client_id;
	Block9Data* _data9_;
	GCancellable* _tmp0_;
	TrackerSparqlCursor* cursor;
	GCancellable* _tmp1_;
	TrackerSparqlCursor* _tmp2_;
	TrackerStoreCursorTask* task;
	TrackerSparqlCursor* _tmp3_;
	TrackerStoreCursorTask* _tmp4_;
	TrackerStoreCursorTask* _tmp5_;
	TrackerStoreCursorTask* _tmp6_;
	GThreadPool* _tmp7_;
	TrackerStoreCursorTask* _tmp8_;
	TrackerStoreCursorTask* _tmp9_;
	GError* e;
	TrackerStoreCursorTask* _tmp10_;
	GError* _tmp11_;
	TrackerStoreCursorTask* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _inner_error0_;
};

struct _TrackerStoreSparqlUpdateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* conn;
	gchar* sparql;
	gint priority;
	gchar* client_id;
	GError* _tmp0_;
	gint _tmp1_;
	GCancellable* cancellable;
	GCancellable* _tmp2_;
	gint _tmp3_;
	GError* _inner_error0_;
};

struct _TrackerStoreSparqlUpdateBlankData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* conn;
	gchar* sparql;
	gint priority;
	gchar* client_id;
	GVariant* result;
	GError* _tmp0_;
	gint _tmp1_;
	GCancellable* cancellable;
	GCancellable* _tmp2_;
	GVariant* nodes;
	GVariant* _tmp3_;
	gint _tmp4_;
	GError* _inner_error0_;
};

struct _TrackerStoreQueueTurtleImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* conn;
	GFile* file;
	gchar* client_id;
	GError* _tmp0_;
	gint _tmp1_;
	GCancellable* cancellable;
	GCancellable* _tmp2_;
	gint _tmp3_;
	GError* _inner_error0_;
};

struct _TrackerStorePauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerDirectConnection* sparql_conn;
	TrackerDirectConnection* _tmp0_;
	TrackerDirectConnection* _tmp1_;
};

struct _TrackerStoreParamSpecCursorTask {
	GParamSpec parent_instance;
};

struct _TrackerParamSpecStore {
	GParamSpec parent_instance;
};

static gpointer tracker_store_parent_class = NULL;
static gint tracker_store_max_task_time;
static gint tracker_store_max_task_time = 0;
static gboolean tracker_store_active;
static gboolean tracker_store_active = FALSE;
static TrackerConfig* tracker_store_config;
static TrackerConfig* tracker_store_config = NULL;
static guint tracker_store_signal_timeout;
static guint tracker_store_signal_timeout = 0U;
static gint tracker_store_n_updates;
static gint tracker_store_n_updates = 0;
static GHashTable* tracker_store_client_cancellables;
static GHashTable* tracker_store_client_cancellables = NULL;
static TrackerStoreSignalEmissionFunc tracker_store_signal_callback;
static gpointer tracker_store_signal_callback_target;
static TrackerStoreSignalEmissionFunc tracker_store_signal_callback = NULL;
static gpointer tracker_store_signal_callback_target = NULL;
static GThreadPool* tracker_store_cursor_pool;
static GThreadPool* tracker_store_cursor_pool = NULL;
static gpointer tracker_store_cursor_task_parent_class = NULL;

gpointer tracker_store_ref (gpointer instance);
void tracker_store_unref (gpointer instance);
GParamSpec* tracker_param_spec_store (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void tracker_value_set_store (GValue* value,
                              gpointer v_object);
void tracker_value_take_store (GValue* value,
                               gpointer v_object);
gpointer tracker_value_get_store (const GValue* value);
GType tracker_store_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStore, tracker_store_unref)
static gpointer tracker_store_cursor_task_ref (gpointer instance);
static void tracker_store_cursor_task_unref (gpointer instance);
static GParamSpec* tracker_store_param_spec_cursor_task (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags) G_GNUC_UNUSED;
static void tracker_store_value_set_cursor_task (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static void tracker_store_value_take_cursor_task (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED;
static gpointer tracker_store_value_get_cursor_task (const GValue* value) G_GNUC_UNUSED;
static GType tracker_store_cursor_task_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TrackerStoreCursorTask, tracker_store_cursor_task_unref)
#define TRACKER_STORE_MAX_CONCURRENT_QUERIES 2
#define TRACKER_STORE_MAX_TASK_TIME 30
#define TRACKER_STORE_GRAPH_UPDATED_IMMEDIATE_EMIT_AT 50000
static void tracker_store_cursor_dispatch_cb (TrackerStoreCursorTask* task);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block7Data* _data7_);
static gboolean ___lambda6__gsource_func (gpointer self);
void tracker_store_init (TrackerConfig* config_p);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _tracker_store_cursor_dispatch_cb_gfunc (gpointer data,
                                              gpointer self);
void tracker_store_shutdown (void);
static GCancellable* tracker_store_create_cancellable (const gchar* client_id);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda7_ (Block8Data* _data8_);
static void ___lambda7__gfunc (gconstpointer data,
                        gpointer self);
static void tracker_store_do_emit_signals (void);
static void tracker_store_ensure_signal_timeout (void);
static gboolean ___lambda8_ (void);
static gboolean ____lambda8__gsource_func (gpointer self);
static void tracker_store_sparql_query_data_free (gpointer _data);
void tracker_store_sparql_query (TrackerDirectConnection* conn,
                                 const gchar* sparql,
                                 gint priority,
                                 TrackerStoreSparqlQueryInThread in_thread,
                                 gpointer in_thread_target,
                                 const gchar* client_id,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
void tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                        GError** error);
static gboolean tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean ___lambda9_ (Block9Data* _data9_);
static gboolean ____lambda9__gsource_func (gpointer self);
static void tracker_store_sparql_query_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static TrackerStoreCursorTask* tracker_store_cursor_task_new (TrackerSparqlCursor* cursor);
static TrackerStoreCursorTask* tracker_store_cursor_task_construct (GType object_type,
                                                             TrackerSparqlCursor* cursor);
static gboolean _tracker_store_sparql_query_co_gsource_func (gpointer self);
static void tracker_store_sparql_update_data_free (gpointer _data);
void tracker_store_sparql_update (TrackerDirectConnection* conn,
                                  const gchar* sparql,
                                  gint priority,
                                  const gchar* client_id,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
void tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                         GError** error);
static gboolean tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_);
static void tracker_store_sparql_update_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void tracker_store_sparql_update_blank_data_free (gpointer _data);
void tracker_store_sparql_update_blank (TrackerDirectConnection* conn,
                                        const gchar* sparql,
                                        gint priority,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
GVariant* tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                                    GError** error);
static gboolean tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_);
static void tracker_store_sparql_update_blank_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void tracker_store_queue_turtle_import_data_free (gpointer _data);
void tracker_store_queue_turtle_import (TrackerDirectConnection* conn,
                                        GFile* file,
                                        const gchar* client_id,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
void tracker_store_queue_turtle_import_finish (GAsyncResult* _res_,
                                               GError** error);
static gboolean tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_);
static void tracker_store_queue_turtle_import_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
void tracker_store_unreg_batches (const gchar* client_id);
static void tracker_store_pause_data_free (gpointer _data);
void tracker_store_pause (GAsyncReadyCallback _callback_,
                          gpointer _user_data_);
void tracker_store_pause_finish (GAsyncResult* _res_);
static gboolean tracker_store_pause_co (TrackerStorePauseData* _data_);
TrackerDirectConnection* tracker_main_get_sparql_connection (void);
void tracker_store_resume (void);
static void tracker_store_on_statements_committed (void);
static void tracker_store_check_graph_updated_signal (void);
static void tracker_store_on_statements_rolled_back (void);
static gboolean ___lambda10_ (void);
static gboolean ____lambda10__gsource_func (gpointer self);
static void tracker_store_on_statement_inserted (gint graph_id,
                                          const gchar* graph,
                                          gint subject_id,
                                          const gchar* subject,
                                          gint pred_id,
                                          gint object_id,
                                          const gchar* object,
                                          GPtrArray* rdf_types);
static void tracker_store_on_statement_deleted (gint graph_id,
                                         const gchar* graph,
                                         gint subject_id,
                                         const gchar* subject,
                                         gint pred_id,
                                         gint object_id,
                                         const gchar* object,
                                         GPtrArray* rdf_types);
void tracker_store_enable_signals (void);
TrackerDataManager* tracker_main_get_data_manager (void);
static void _tracker_store_on_statement_inserted_tracker_statement_callback (gint graph_id,
                                                                      const gchar* graph,
                                                                      gint subject_id,
                                                                      const gchar* subject,
                                                                      gint predicate_id,
                                                                      gint object_id,
                                                                      const gchar* object,
                                                                      GPtrArray* rdf_types,
                                                                      gpointer self);
static void _tracker_store_on_statement_deleted_tracker_statement_callback (gint graph_id,
                                                                     const gchar* graph,
                                                                     gint subject_id,
                                                                     const gchar* subject,
                                                                     gint predicate_id,
                                                                     gint object_id,
                                                                     const gchar* object,
                                                                     GPtrArray* rdf_types,
                                                                     gpointer self);
static void _tracker_store_on_statements_committed_tracker_commit_callback (gpointer self);
static void _tracker_store_on_statements_rolled_back_tracker_commit_callback (gpointer self);
void tracker_store_disable_signals (void);
void tracker_store_set_signal_callback (TrackerStoreSignalEmissionFunc func,
                                        gpointer func_target);
TrackerStore* tracker_store_new (void);
TrackerStore* tracker_store_construct (GType object_type);
static void tracker_store_cursor_task_finalize (TrackerStoreCursorTask * obj);
static void tracker_store_finalize (TrackerStore * obj);

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 55 "tracker-store.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 55 "tracker-store.vala"
	return _data7_;
#line 432 "tracker-store.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 55 "tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 55 "tracker-store.vala"
		_tracker_store_cursor_task_unref0 (_data7_->task);
#line 55 "tracker-store.vala"
		g_slice_free (Block7Data, _data7_);
#line 446 "tracker-store.c"
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
#line 59 "tracker-store.vala"
	return self ? g_error_copy (self) : NULL;
#line 455 "tracker-store.c"
}

static gboolean
__lambda6_ (Block7Data* _data7_)
{
	gboolean result = FALSE;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
#line 63 "tracker-store.vala"
	_tmp0_ = _data7_->task->callback;
#line 63 "tracker-store.vala"
	_tmp0__target = _data7_->task->callback_target;
#line 63 "tracker-store.vala"
	_tmp0_ (_tmp0__target);
#line 64 "tracker-store.vala"
	result = FALSE;
#line 64 "tracker-store.vala"
	return result;
#line 474 "tracker-store.c"
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ (self);
#line 62 "tracker-store.vala"
	return result;
#line 484 "tracker-store.c"
}

static void
tracker_store_cursor_dispatch_cb (TrackerStoreCursorTask* task)
{
	Block7Data* _data7_;
	GError* _inner_error0_ = NULL;
#line 55 "tracker-store.vala"
	g_return_if_fail (task != NULL);
#line 55 "tracker-store.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 55 "tracker-store.vala"
	_data7_->_ref_count_ = 1;
#line 55 "tracker-store.vala"
	_tracker_store_cursor_task_unref0 (_data7_->task);
#line 55 "tracker-store.vala"
	_data7_->task = task;
#line 502 "tracker-store.c"
	{
		TrackerStoreSparqlQueryInThread _tmp0_;
		gpointer _tmp0__target;
		TrackerSparqlCursor* _tmp1_;
#line 57 "tracker-store.vala"
		_tmp0_ = _data7_->task->thread_func;
#line 57 "tracker-store.vala"
		_tmp0__target = _data7_->task->thread_func_target;
#line 57 "tracker-store.vala"
		_tmp1_ = _data7_->task->cursor;
#line 57 "tracker-store.vala"
		_tmp0_ (_tmp1_, _tmp0__target, &_inner_error0_);
#line 57 "tracker-store.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 517 "tracker-store.c"
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		GError* _tmp3_;
#line 56 "tracker-store.vala"
		e = _inner_error0_;
#line 56 "tracker-store.vala"
		_inner_error0_ = NULL;
#line 59 "tracker-store.vala"
		_tmp2_ = e;
#line 59 "tracker-store.vala"
		_tmp3_ = _g_error_copy0 (_tmp2_);
#line 59 "tracker-store.vala"
		_g_error_free0 (_data7_->task->error);
#line 59 "tracker-store.vala"
		_data7_->task->error = _tmp3_;
#line 56 "tracker-store.vala"
		_g_error_free0 (e);
#line 541 "tracker-store.c"
	}
	__finally19:
#line 56 "tracker-store.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 56 "tracker-store.vala"
		block7_data_unref (_data7_);
#line 56 "tracker-store.vala"
		_data7_ = NULL;
#line 56 "tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 56 "tracker-store.vala"
		g_clear_error (&_inner_error0_);
#line 56 "tracker-store.vala"
		return;
#line 556 "tracker-store.c"
	}
#line 62 "tracker-store.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, block7_data_ref (_data7_), block7_data_unref);
#line 55 "tracker-store.vala"
	block7_data_unref (_data7_);
#line 55 "tracker-store.vala"
	_data7_ = NULL;
#line 564 "tracker-store.c"
}

static void
_g_free0_ (gpointer var)
{
#line 76 "tracker-store.vala"
	var = (g_free (var), NULL);
#line 572 "tracker-store.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 76 "tracker-store.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 580 "tracker-store.c"
}

static void
_tracker_store_cursor_dispatch_cb_gfunc (gpointer data,
                                         gpointer self)
{
#line 79 "tracker-store.vala"
	tracker_store_cursor_dispatch_cb ((TrackerStoreCursorTask*) data);
#line 589 "tracker-store.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 90 "tracker-store.vala"
	return self ? g_object_ref (self) : NULL;
#line 597 "tracker-store.c"
}

void
tracker_store_init (TrackerConfig* config_p)
{
	gchar* max_task_time_env = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	TrackerConfig* _tmp10_;
	GError* _inner_error0_ = NULL;
#line 68 "tracker-store.vala"
	g_return_if_fail (config_p != NULL);
#line 69 "tracker-store.vala"
	_tmp0_ = g_getenv ("TRACKER_STORE_MAX_TASK_TIME");
#line 69 "tracker-store.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 69 "tracker-store.vala"
	max_task_time_env = _tmp1_;
#line 70 "tracker-store.vala"
	_tmp2_ = max_task_time_env;
#line 70 "tracker-store.vala"
	if (_tmp2_ != NULL) {
#line 624 "tracker-store.c"
		const gchar* _tmp3_;
#line 71 "tracker-store.vala"
		_tmp3_ = max_task_time_env;
#line 71 "tracker-store.vala"
		tracker_store_max_task_time = atoi (_tmp3_);
#line 630 "tracker-store.c"
	} else {
#line 73 "tracker-store.vala"
		tracker_store_max_task_time = TRACKER_STORE_MAX_TASK_TIME;
#line 634 "tracker-store.c"
	}
#line 76 "tracker-store.vala"
	_tmp4_ = g_str_hash;
#line 76 "tracker-store.vala"
	_tmp5_ = g_str_equal;
#line 76 "tracker-store.vala"
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
#line 76 "tracker-store.vala"
	_g_hash_table_unref0 (tracker_store_client_cancellables);
#line 76 "tracker-store.vala"
	tracker_store_client_cancellables = _tmp6_;
#line 646 "tracker-store.c"
	{
		GThreadPool* _tmp7_ = NULL;
		GThreadPool* _tmp8_;
		GThreadPool* _tmp9_;
#line 79 "tracker-store.vala"
		_tmp8_ = g_thread_pool_new (_tracker_store_cursor_dispatch_cb_gfunc, NULL, 16, FALSE, &_inner_error0_);
#line 79 "tracker-store.vala"
		_tmp7_ = _tmp8_;
#line 79 "tracker-store.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 657 "tracker-store.c"
			goto __catch20_g_error;
		}
#line 79 "tracker-store.vala"
		_tmp9_ = _tmp7_;
#line 79 "tracker-store.vala"
		_tmp7_ = NULL;
#line 79 "tracker-store.vala"
		_g_thread_pool_free0 (tracker_store_cursor_pool);
#line 79 "tracker-store.vala"
		tracker_store_cursor_pool = _tmp9_;
#line 78 "tracker-store.vala"
		_g_thread_pool_free0 (_tmp7_);
#line 670 "tracker-store.c"
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
#line 78 "tracker-store.vala"
		e = _inner_error0_;
#line 78 "tracker-store.vala"
		_inner_error0_ = NULL;
#line 78 "tracker-store.vala"
		_g_error_free0 (e);
#line 682 "tracker-store.c"
	}
	__finally20:
#line 78 "tracker-store.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 78 "tracker-store.vala"
		_g_free0 (max_task_time_env);
#line 78 "tracker-store.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 78 "tracker-store.vala"
		g_clear_error (&_inner_error0_);
#line 78 "tracker-store.vala"
		return;
#line 695 "tracker-store.c"
	}
#line 87 "tracker-store.vala"
	g_thread_pool_set_max_idle_time ((guint) (15 * 1000));
#line 88 "tracker-store.vala"
	g_thread_pool_set_max_unused_threads (2);
#line 90 "tracker-store.vala"
	_tmp10_ = _g_object_ref0 (config_p);
#line 90 "tracker-store.vala"
	_g_object_unref0 (tracker_store_config);
#line 90 "tracker-store.vala"
	tracker_store_config = _tmp10_;
#line 68 "tracker-store.vala"
	_g_free0 (max_task_time_env);
#line 709 "tracker-store.c"
}

void
tracker_store_shutdown (void)
{
#line 94 "tracker-store.vala"
	if (tracker_store_signal_timeout != ((guint) 0)) {
#line 95 "tracker-store.vala"
		g_source_remove (tracker_store_signal_timeout);
#line 96 "tracker-store.vala"
		tracker_store_signal_timeout = (guint) 0;
#line 721 "tracker-store.c"
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
#line 100 "tracker-store.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 100 "tracker-store.vala"
	return _data8_;
#line 732 "tracker-store.c"
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 100 "tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 100 "tracker-store.vala"
		_g_object_unref0 (_data8_->task_cancellable);
#line 100 "tracker-store.vala"
		g_slice_free (Block8Data, _data8_);
#line 746 "tracker-store.c"
	}
}

static void
__lambda7_ (Block8Data* _data8_)
{
#line 110 "tracker-store.vala"
	g_cancellable_cancel (_data8_->task_cancellable);
#line 755 "tracker-store.c"
}

static void
___lambda7__gfunc (gconstpointer data,
                   gpointer self)
{
#line 109 "tracker-store.vala"
	__lambda7_ (self);
#line 764 "tracker-store.c"
}

static GCancellable*
tracker_store_create_cancellable (const gchar* client_id)
{
	GCancellable* result = NULL;
	Block8Data* _data8_;
	GCancellable* client_cancellable = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp9_;
	GCancellable* _tmp10_;
	GCancellable* _tmp11_;
#line 100 "tracker-store.vala"
	g_return_val_if_fail (client_id != NULL, NULL);
#line 100 "tracker-store.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 100 "tracker-store.vala"
	_data8_->_ref_count_ = 1;
#line 101 "tracker-store.vala"
	_tmp0_ = tracker_store_client_cancellables;
#line 101 "tracker-store.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, client_id);
#line 101 "tracker-store.vala"
	_tmp2_ = _g_object_ref0 ((GCancellable*) _tmp1_);
#line 101 "tracker-store.vala"
	client_cancellable = _tmp2_;
#line 103 "tracker-store.vala"
	_tmp3_ = client_cancellable;
#line 103 "tracker-store.vala"
	if (_tmp3_ == NULL) {
#line 798 "tracker-store.c"
		GCancellable* _tmp4_;
		GHashTable* _tmp5_;
		gchar* _tmp6_;
		GCancellable* _tmp7_;
		GCancellable* _tmp8_;
#line 104 "tracker-store.vala"
		_tmp4_ = g_cancellable_new ();
#line 104 "tracker-store.vala"
		_g_object_unref0 (client_cancellable);
#line 104 "tracker-store.vala"
		client_cancellable = _tmp4_;
#line 105 "tracker-store.vala"
		_tmp5_ = tracker_store_client_cancellables;
#line 105 "tracker-store.vala"
		_tmp6_ = g_strdup (client_id);
#line 105 "tracker-store.vala"
		_tmp7_ = client_cancellable;
#line 105 "tracker-store.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 105 "tracker-store.vala"
		g_hash_table_insert (_tmp5_, _tmp6_, _tmp8_);
#line 820 "tracker-store.c"
	}
#line 108 "tracker-store.vala"
	_tmp9_ = g_cancellable_new ();
#line 108 "tracker-store.vala"
	_data8_->task_cancellable = _tmp9_;
#line 109 "tracker-store.vala"
	_tmp10_ = client_cancellable;
#line 109 "tracker-store.vala"
	g_cancellable_connect (_tmp10_, (GCallback) ___lambda7__gfunc, block8_data_ref (_data8_), block8_data_unref);
#line 113 "tracker-store.vala"
	_tmp11_ = _g_object_ref0 (_data8_->task_cancellable);
#line 113 "tracker-store.vala"
	result = _tmp11_;
#line 113 "tracker-store.vala"
	_g_object_unref0 (client_cancellable);
#line 113 "tracker-store.vala"
	block8_data_unref (_data8_);
#line 113 "tracker-store.vala"
	_data8_ = NULL;
#line 113 "tracker-store.vala"
	return result;
#line 842 "tracker-store.c"
}

static void
tracker_store_do_emit_signals (void)
{
	TrackerStoreSignalEmissionFunc _tmp0_;
	gpointer _tmp0__target;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
#line 117 "tracker-store.vala"
	_tmp0_ = tracker_store_signal_callback;
#line 117 "tracker-store.vala"
	_tmp0__target = tracker_store_signal_callback_target;
#line 117 "tracker-store.vala"
	_tmp1_ = tracker_events_get_pending ();
#line 117 "tracker-store.vala"
	_tmp2_ = _tmp1_;
#line 117 "tracker-store.vala"
	_tmp3_ = tracker_writeback_get_ready ();
#line 117 "tracker-store.vala"
	_tmp4_ = _tmp3_;
#line 117 "tracker-store.vala"
	_tmp0_ (_tmp2_, _tmp4_, _tmp0__target);
#line 117 "tracker-store.vala"
	_g_hash_table_unref0 (_tmp4_);
#line 117 "tracker-store.vala"
	_g_hash_table_unref0 (_tmp2_);
#line 872 "tracker-store.c"
}

static gboolean
___lambda8_ (void)
{
	gboolean result = FALSE;
#line 123 "tracker-store.vala"
	tracker_store_do_emit_signals ();
#line 124 "tracker-store.vala"
	if (tracker_store_n_updates == 0) {
#line 125 "tracker-store.vala"
		tracker_store_signal_timeout = (guint) 0;
#line 126 "tracker-store.vala"
		result = FALSE;
#line 126 "tracker-store.vala"
		return result;
#line 889 "tracker-store.c"
	} else {
#line 128 "tracker-store.vala"
		result = TRUE;
#line 128 "tracker-store.vala"
		return result;
#line 895 "tracker-store.c"
	}
}

static gboolean
____lambda8__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda8_ ();
#line 122 "tracker-store.vala"
	return result;
#line 906 "tracker-store.c"
}

static void
tracker_store_ensure_signal_timeout (void)
{
#line 121 "tracker-store.vala"
	if (tracker_store_signal_timeout == ((guint) 0)) {
#line 914 "tracker-store.c"
		TrackerConfig* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
#line 122 "tracker-store.vala"
		_tmp0_ = tracker_store_config;
#line 122 "tracker-store.vala"
		_tmp1_ = tracker_config_get_graphupdated_delay (_tmp0_);
#line 122 "tracker-store.vala"
		_tmp2_ = _tmp1_;
#line 122 "tracker-store.vala"
		tracker_store_signal_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp2_, ____lambda8__gsource_func, NULL, NULL);
#line 926 "tracker-store.c"
	}
}

static void
tracker_store_sparql_query_data_free (gpointer _data)
{
	TrackerStoreSparqlQueryData* _data_;
	_data_ = _data;
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->conn);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "tracker-store.vala"
	g_slice_free (TrackerStoreSparqlQueryData, _data_);
#line 943 "tracker-store.c"
}

void
tracker_store_sparql_query (TrackerDirectConnection* conn,
                            const gchar* sparql,
                            gint priority,
                            TrackerStoreSparqlQueryInThread in_thread,
                            gpointer in_thread_target,
                            const gchar* client_id,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	TrackerStoreSparqlQueryData* _data_;
	TrackerDirectConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 22 "tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlQueryData);
#line 22 "tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_query_data_free);
#line 22 "tracker-store.vala"
	_tmp0_ = _g_object_ref0 (conn);
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->conn);
#line 22 "tracker-store.vala"
	_data_->conn = _tmp0_;
#line 22 "tracker-store.vala"
	_tmp1_ = g_strdup (sparql);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "tracker-store.vala"
	_data_->priority = priority;
#line 22 "tracker-store.vala"
	_data_->in_thread = in_thread;
#line 22 "tracker-store.vala"
	_data_->in_thread_target = in_thread_target;
#line 22 "tracker-store.vala"
	_tmp2_ = g_strdup (client_id);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "tracker-store.vala"
	_data_->client_id = _tmp2_;
#line 22 "tracker-store.vala"
	tracker_store_sparql_query_co (_data_);
#line 992 "tracker-store.c"
}

void
tracker_store_sparql_query_finish (GAsyncResult* _res_,
                                   GError** error)
{
	TrackerStoreSparqlQueryData* _data_;
#line 22 "tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "tracker-store.vala"
	if (NULL == _data_) {
#line 22 "tracker-store.vala"
		return;
#line 1006 "tracker-store.c"
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
#line 134 "tracker-store.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 134 "tracker-store.vala"
	return _data9_;
#line 1017 "tracker-store.c"
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 134 "tracker-store.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 134 "tracker-store.vala"
		_g_object_unref0 (_data9_->cancellable);
#line 134 "tracker-store.vala"
		g_slice_free (Block9Data, _data9_);
#line 1031 "tracker-store.c"
	}
}

static gboolean
___lambda9_ (Block9Data* _data9_)
{
	gboolean result = FALSE;
	GCancellable* _tmp0_;
#line 140 "tracker-store.vala"
	_tmp0_ = _data9_->cancellable;
#line 140 "tracker-store.vala"
	g_cancellable_cancel (_tmp0_);
#line 141 "tracker-store.vala"
	_data9_->timeout_id = (guint) 0;
#line 142 "tracker-store.vala"
	result = FALSE;
#line 142 "tracker-store.vala"
	return result;
#line 1050 "tracker-store.c"
}

static gboolean
____lambda9__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda9_ (self);
#line 139 "tracker-store.vala"
	return result;
#line 1060 "tracker-store.c"
}

static void
tracker_store_sparql_query_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	TrackerStoreSparqlQueryData* _data_;
#line 146 "tracker-store.vala"
	_data_ = _user_data_;
#line 146 "tracker-store.vala"
	_data_->_source_object_ = source_object;
#line 146 "tracker-store.vala"
	_data_->_res_ = _res_;
#line 146 "tracker-store.vala"
	tracker_store_sparql_query_co (_data_);
#line 1077 "tracker-store.c"
}

static gboolean
_tracker_store_sparql_query_co_gsource_func (gpointer self)
{
	gboolean result;
	result = tracker_store_sparql_query_co (self);
#line 153 "tracker-store.vala"
	return result;
#line 1087 "tracker-store.c"
}

static gpointer
_tracker_store_cursor_task_ref0 (gpointer self)
{
#line 156 "tracker-store.vala"
	return self ? tracker_store_cursor_task_ref (self) : NULL;
#line 1095 "tracker-store.c"
}

static gboolean
tracker_store_sparql_query_co (TrackerStoreSparqlQueryData* _data_)
{
#line 134 "tracker-store.vala"
	switch (_data_->_state_) {
#line 134 "tracker-store.vala"
		case 0:
#line 1105 "tracker-store.c"
		goto _state_0;
#line 134 "tracker-store.vala"
		case 1:
#line 1109 "tracker-store.c"
		goto _state_1;
#line 134 "tracker-store.vala"
		case 2:
#line 1113 "tracker-store.c"
		goto _state_2;
		default:
#line 134 "tracker-store.vala"
		g_assert_not_reached ();
#line 1118 "tracker-store.c"
	}
	_state_0:
#line 134 "tracker-store.vala"
	_data_->_data9_ = g_slice_new0 (Block9Data);
#line 134 "tracker-store.vala"
	_data_->_data9_->_ref_count_ = 1;
#line 134 "tracker-store.vala"
	_data_->_data9_->_async_data_ = _data_;
#line 135 "tracker-store.vala"
	_data_->_tmp0_ = tracker_store_create_cancellable (_data_->client_id);
#line 135 "tracker-store.vala"
	_data_->_data9_->cancellable = _data_->_tmp0_;
#line 136 "tracker-store.vala"
	_data_->_data9_->timeout_id = (guint) 0;
#line 138 "tracker-store.vala"
	if (tracker_store_max_task_time != 0) {
#line 139 "tracker-store.vala"
		_data_->_data9_->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) tracker_store_max_task_time, ____lambda9__gsource_func, block9_data_ref (_data_->_data9_), block9_data_unref);
#line 1137 "tracker-store.c"
	}
#line 146 "tracker-store.vala"
	_data_->_tmp1_ = _data_->_data9_->cancellable;
#line 146 "tracker-store.vala"
	_data_->_state_ = 1;
#line 146 "tracker-store.vala"
	tracker_sparql_connection_query_async ((TrackerSparqlConnection*) _data_->conn, _data_->sparql, _data_->_tmp1_, tracker_store_sparql_query_ready, _data_);
#line 146 "tracker-store.vala"
	return FALSE;
#line 1147 "tracker-store.c"
	_state_1:
#line 146 "tracker-store.vala"
	_data_->_tmp2_ = tracker_sparql_connection_query_finish ((TrackerSparqlConnection*) _data_->conn, _data_->_res_, &_data_->_inner_error0_);
#line 146 "tracker-store.vala"
	_data_->cursor = _data_->_tmp2_;
#line 146 "tracker-store.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 146 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 146 "tracker-store.vala"
		block9_data_unref (_data_->_data9_);
#line 146 "tracker-store.vala"
		_data_->_data9_ = NULL;
#line 146 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 146 "tracker-store.vala"
		return FALSE;
#line 1165 "tracker-store.c"
	}
#line 148 "tracker-store.vala"
	if (_data_->_data9_->timeout_id != ((guint) 0)) {
#line 149 "tracker-store.vala"
		g_source_remove (_data_->_data9_->timeout_id);
#line 1171 "tracker-store.c"
	}
#line 151 "tracker-store.vala"
	_data_->_tmp3_ = _data_->cursor;
#line 151 "tracker-store.vala"
	_data_->_tmp4_ = tracker_store_cursor_task_new (_data_->_tmp3_);
#line 151 "tracker-store.vala"
	_data_->task = _data_->_tmp4_;
#line 152 "tracker-store.vala"
	_data_->_tmp5_ = _data_->task;
#line 152 "tracker-store.vala"
	_data_->_tmp5_->thread_func = _data_->in_thread;
#line 152 "tracker-store.vala"
	_data_->_tmp5_->thread_func_target = _data_->in_thread_target;
#line 153 "tracker-store.vala"
	_data_->_tmp6_ = _data_->task;
#line 153 "tracker-store.vala"
	_data_->_tmp6_->callback = _tracker_store_sparql_query_co_gsource_func;
#line 153 "tracker-store.vala"
	_data_->_tmp6_->callback_target = _data_;
#line 1191 "tracker-store.c"
	{
#line 156 "tracker-store.vala"
		_data_->_tmp7_ = tracker_store_cursor_pool;
#line 156 "tracker-store.vala"
		_data_->_tmp8_ = _data_->task;
#line 156 "tracker-store.vala"
		_data_->_tmp9_ = _tracker_store_cursor_task_ref0 (_data_->_tmp8_);
#line 156 "tracker-store.vala"
		g_thread_pool_push (_data_->_tmp7_, _data_->_tmp9_, &_data_->_inner_error0_);
#line 156 "tracker-store.vala"
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 1203 "tracker-store.c"
			goto __catch21_g_error;
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
#line 155 "tracker-store.vala"
		_data_->e = _data_->_inner_error0_;
#line 155 "tracker-store.vala"
		_data_->_inner_error0_ = NULL;
#line 155 "tracker-store.vala"
		_g_error_free0 (_data_->e);
#line 1216 "tracker-store.c"
	}
	__finally21:
#line 155 "tracker-store.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 155 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 155 "tracker-store.vala"
		_tracker_store_cursor_task_unref0 (_data_->task);
#line 155 "tracker-store.vala"
		_g_object_unref0 (_data_->cursor);
#line 155 "tracker-store.vala"
		block9_data_unref (_data_->_data9_);
#line 155 "tracker-store.vala"
		_data_->_data9_ = NULL;
#line 155 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 155 "tracker-store.vala"
		return FALSE;
#line 1235 "tracker-store.c"
	}
#line 161 "tracker-store.vala"
	_data_->_state_ = 2;
#line 161 "tracker-store.vala"
	return FALSE;
#line 1241 "tracker-store.c"
	_state_2:
	;
#line 163 "tracker-store.vala"
	_data_->_tmp10_ = _data_->task;
#line 163 "tracker-store.vala"
	_data_->_tmp11_ = _data_->_tmp10_->error;
#line 163 "tracker-store.vala"
	if (_data_->_tmp11_ != NULL) {
#line 164 "tracker-store.vala"
		_data_->_tmp12_ = _data_->task;
#line 164 "tracker-store.vala"
		_data_->_tmp13_ = _data_->_tmp12_->error;
#line 164 "tracker-store.vala"
		_data_->_tmp14_ = _g_error_copy0 (_data_->_tmp13_);
#line 164 "tracker-store.vala"
		_data_->_inner_error0_ = _data_->_tmp14_;
#line 164 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 164 "tracker-store.vala"
		_tracker_store_cursor_task_unref0 (_data_->task);
#line 164 "tracker-store.vala"
		_g_object_unref0 (_data_->cursor);
#line 164 "tracker-store.vala"
		block9_data_unref (_data_->_data9_);
#line 164 "tracker-store.vala"
		_data_->_data9_ = NULL;
#line 164 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 164 "tracker-store.vala"
		return FALSE;
#line 1272 "tracker-store.c"
	}
#line 134 "tracker-store.vala"
	_tracker_store_cursor_task_unref0 (_data_->task);
#line 134 "tracker-store.vala"
	_g_object_unref0 (_data_->cursor);
#line 134 "tracker-store.vala"
	block9_data_unref (_data_->_data9_);
#line 134 "tracker-store.vala"
	_data_->_data9_ = NULL;
#line 134 "tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 134 "tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 134 "tracker-store.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 134 "tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1290 "tracker-store.c"
		}
	}
#line 134 "tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 134 "tracker-store.vala"
	return FALSE;
#line 1297 "tracker-store.c"
}

static void
tracker_store_sparql_update_data_free (gpointer _data)
{
	TrackerStoreSparqlUpdateData* _data_;
	_data_ = _data;
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->conn);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateData, _data_);
#line 1313 "tracker-store.c"
}

void
tracker_store_sparql_update (TrackerDirectConnection* conn,
                             const gchar* sparql,
                             gint priority,
                             const gchar* client_id,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	TrackerStoreSparqlUpdateData* _data_;
	TrackerDirectConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 22 "tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateData);
#line 22 "tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_data_free);
#line 22 "tracker-store.vala"
	_tmp0_ = _g_object_ref0 (conn);
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->conn);
#line 22 "tracker-store.vala"
	_data_->conn = _tmp0_;
#line 22 "tracker-store.vala"
	_tmp1_ = g_strdup (sparql);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "tracker-store.vala"
	_data_->priority = priority;
#line 22 "tracker-store.vala"
	_tmp2_ = g_strdup (client_id);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "tracker-store.vala"
	_data_->client_id = _tmp2_;
#line 22 "tracker-store.vala"
	tracker_store_sparql_update_co (_data_);
#line 1356 "tracker-store.c"
}

void
tracker_store_sparql_update_finish (GAsyncResult* _res_,
                                    GError** error)
{
	TrackerStoreSparqlUpdateData* _data_;
#line 22 "tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "tracker-store.vala"
	if (NULL == _data_) {
#line 22 "tracker-store.vala"
		return;
#line 1370 "tracker-store.c"
	}
}

static void
tracker_store_sparql_update_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	TrackerStoreSparqlUpdateData* _data_;
#line 173 "tracker-store.vala"
	_data_ = _user_data_;
#line 173 "tracker-store.vala"
	_data_->_source_object_ = source_object;
#line 173 "tracker-store.vala"
	_data_->_res_ = _res_;
#line 173 "tracker-store.vala"
	tracker_store_sparql_update_co (_data_);
#line 1388 "tracker-store.c"
}

static gboolean
tracker_store_sparql_update_co (TrackerStoreSparqlUpdateData* _data_)
{
#line 167 "tracker-store.vala"
	switch (_data_->_state_) {
#line 167 "tracker-store.vala"
		case 0:
#line 1398 "tracker-store.c"
		goto _state_0;
#line 167 "tracker-store.vala"
		case 1:
#line 1402 "tracker-store.c"
		goto _state_1;
		default:
#line 167 "tracker-store.vala"
		g_assert_not_reached ();
#line 1407 "tracker-store.c"
	}
	_state_0:
#line 168 "tracker-store.vala"
	if (!tracker_store_active) {
#line 169 "tracker-store.vala"
		_data_->_tmp0_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Store is not active");
#line 169 "tracker-store.vala"
		_data_->_inner_error0_ = _data_->_tmp0_;
#line 169 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 169 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 169 "tracker-store.vala"
		return FALSE;
#line 1422 "tracker-store.c"
	}
#line 170 "tracker-store.vala"
	_data_->_tmp1_ = tracker_store_n_updates;
#line 170 "tracker-store.vala"
	tracker_store_n_updates = _data_->_tmp1_ + 1;
#line 171 "tracker-store.vala"
	tracker_store_ensure_signal_timeout ();
#line 172 "tracker-store.vala"
	_data_->_tmp2_ = tracker_store_create_cancellable (_data_->client_id);
#line 172 "tracker-store.vala"
	_data_->cancellable = _data_->_tmp2_;
#line 173 "tracker-store.vala"
	_data_->_state_ = 1;
#line 173 "tracker-store.vala"
	tracker_sparql_connection_update_async ((TrackerSparqlConnection*) _data_->conn, _data_->sparql, _data_->priority, _data_->cancellable, tracker_store_sparql_update_ready, _data_);
#line 173 "tracker-store.vala"
	return FALSE;
#line 1440 "tracker-store.c"
	_state_1:
#line 173 "tracker-store.vala"
	tracker_sparql_connection_update_finish ((TrackerSparqlConnection*) _data_->conn, _data_->_res_, &_data_->_inner_error0_);
#line 173 "tracker-store.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 173 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 173 "tracker-store.vala"
		_g_object_unref0 (_data_->cancellable);
#line 173 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 173 "tracker-store.vala"
		return FALSE;
#line 1454 "tracker-store.c"
	}
#line 174 "tracker-store.vala"
	_data_->_tmp3_ = tracker_store_n_updates;
#line 174 "tracker-store.vala"
	tracker_store_n_updates = _data_->_tmp3_ - 1;
#line 167 "tracker-store.vala"
	_g_object_unref0 (_data_->cancellable);
#line 167 "tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 167 "tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 167 "tracker-store.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 167 "tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1470 "tracker-store.c"
		}
	}
#line 167 "tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 167 "tracker-store.vala"
	return FALSE;
#line 1477 "tracker-store.c"
}

static void
tracker_store_sparql_update_blank_data_free (gpointer _data)
{
	TrackerStoreSparqlUpdateBlankData* _data_;
	_data_ = _data;
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->conn);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "tracker-store.vala"
	_g_variant_unref0 (_data_->result);
#line 22 "tracker-store.vala"
	g_slice_free (TrackerStoreSparqlUpdateBlankData, _data_);
#line 1495 "tracker-store.c"
}

void
tracker_store_sparql_update_blank (TrackerDirectConnection* conn,
                                   const gchar* sparql,
                                   gint priority,
                                   const gchar* client_id,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	TrackerStoreSparqlUpdateBlankData* _data_;
	TrackerDirectConnection* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 22 "tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreSparqlUpdateBlankData);
#line 22 "tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_sparql_update_blank_data_free);
#line 22 "tracker-store.vala"
	_tmp0_ = _g_object_ref0 (conn);
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->conn);
#line 22 "tracker-store.vala"
	_data_->conn = _tmp0_;
#line 22 "tracker-store.vala"
	_tmp1_ = g_strdup (sparql);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->sparql);
#line 22 "tracker-store.vala"
	_data_->sparql = _tmp1_;
#line 22 "tracker-store.vala"
	_data_->priority = priority;
#line 22 "tracker-store.vala"
	_tmp2_ = g_strdup (client_id);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "tracker-store.vala"
	_data_->client_id = _tmp2_;
#line 22 "tracker-store.vala"
	tracker_store_sparql_update_blank_co (_data_);
#line 1538 "tracker-store.c"
}

GVariant*
tracker_store_sparql_update_blank_finish (GAsyncResult* _res_,
                                          GError** error)
{
	GVariant* result;
	TrackerStoreSparqlUpdateBlankData* _data_;
#line 22 "tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "tracker-store.vala"
	if (NULL == _data_) {
#line 22 "tracker-store.vala"
		return NULL;
#line 1553 "tracker-store.c"
	}
#line 22 "tracker-store.vala"
	result = _data_->result;
#line 22 "tracker-store.vala"
	_data_->result = NULL;
#line 22 "tracker-store.vala"
	return result;
#line 1561 "tracker-store.c"
}

static void
tracker_store_sparql_update_blank_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	TrackerStoreSparqlUpdateBlankData* _data_;
#line 183 "tracker-store.vala"
	_data_ = _user_data_;
#line 183 "tracker-store.vala"
	_data_->_source_object_ = source_object;
#line 183 "tracker-store.vala"
	_data_->_res_ = _res_;
#line 183 "tracker-store.vala"
	tracker_store_sparql_update_blank_co (_data_);
#line 1578 "tracker-store.c"
}

static gboolean
tracker_store_sparql_update_blank_co (TrackerStoreSparqlUpdateBlankData* _data_)
{
#line 177 "tracker-store.vala"
	switch (_data_->_state_) {
#line 177 "tracker-store.vala"
		case 0:
#line 1588 "tracker-store.c"
		goto _state_0;
#line 177 "tracker-store.vala"
		case 1:
#line 1592 "tracker-store.c"
		goto _state_1;
		default:
#line 177 "tracker-store.vala"
		g_assert_not_reached ();
#line 1597 "tracker-store.c"
	}
	_state_0:
#line 178 "tracker-store.vala"
	if (!tracker_store_active) {
#line 179 "tracker-store.vala"
		_data_->_tmp0_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Store is not active");
#line 179 "tracker-store.vala"
		_data_->_inner_error0_ = _data_->_tmp0_;
#line 179 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 179 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 179 "tracker-store.vala"
		return FALSE;
#line 1612 "tracker-store.c"
	}
#line 180 "tracker-store.vala"
	_data_->_tmp1_ = tracker_store_n_updates;
#line 180 "tracker-store.vala"
	tracker_store_n_updates = _data_->_tmp1_ + 1;
#line 181 "tracker-store.vala"
	tracker_store_ensure_signal_timeout ();
#line 182 "tracker-store.vala"
	_data_->_tmp2_ = tracker_store_create_cancellable (_data_->client_id);
#line 182 "tracker-store.vala"
	_data_->cancellable = _data_->_tmp2_;
#line 183 "tracker-store.vala"
	_data_->_state_ = 1;
#line 183 "tracker-store.vala"
	tracker_sparql_connection_update_blank_async ((TrackerSparqlConnection*) _data_->conn, _data_->sparql, _data_->priority, _data_->cancellable, tracker_store_sparql_update_blank_ready, _data_);
#line 183 "tracker-store.vala"
	return FALSE;
#line 1630 "tracker-store.c"
	_state_1:
#line 183 "tracker-store.vala"
	_data_->_tmp3_ = tracker_sparql_connection_update_blank_finish ((TrackerSparqlConnection*) _data_->conn, _data_->_res_, &_data_->_inner_error0_);
#line 183 "tracker-store.vala"
	_data_->nodes = _data_->_tmp3_;
#line 183 "tracker-store.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 183 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 183 "tracker-store.vala"
		_g_object_unref0 (_data_->cancellable);
#line 183 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 183 "tracker-store.vala"
		return FALSE;
#line 1646 "tracker-store.c"
	}
#line 184 "tracker-store.vala"
	_data_->_tmp4_ = tracker_store_n_updates;
#line 184 "tracker-store.vala"
	tracker_store_n_updates = _data_->_tmp4_ - 1;
#line 186 "tracker-store.vala"
	_data_->result = _data_->nodes;
#line 186 "tracker-store.vala"
	_g_object_unref0 (_data_->cancellable);
#line 186 "tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 186 "tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 186 "tracker-store.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 186 "tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1664 "tracker-store.c"
		}
	}
#line 186 "tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 186 "tracker-store.vala"
	return FALSE;
#line 1671 "tracker-store.c"
}

static void
tracker_store_queue_turtle_import_data_free (gpointer _data)
{
	TrackerStoreQueueTurtleImportData* _data_;
	_data_ = _data;
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->conn);
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "tracker-store.vala"
	g_slice_free (TrackerStoreQueueTurtleImportData, _data_);
#line 1687 "tracker-store.c"
}

void
tracker_store_queue_turtle_import (TrackerDirectConnection* conn,
                                   GFile* file,
                                   const gchar* client_id,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	TrackerStoreQueueTurtleImportData* _data_;
	TrackerDirectConnection* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
#line 22 "tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStoreQueueTurtleImportData);
#line 22 "tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_queue_turtle_import_data_free);
#line 22 "tracker-store.vala"
	_tmp0_ = _g_object_ref0 (conn);
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->conn);
#line 22 "tracker-store.vala"
	_data_->conn = _tmp0_;
#line 22 "tracker-store.vala"
	_tmp1_ = _g_object_ref0 (file);
#line 22 "tracker-store.vala"
	_g_object_unref0 (_data_->file);
#line 22 "tracker-store.vala"
	_data_->file = _tmp1_;
#line 22 "tracker-store.vala"
	_tmp2_ = g_strdup (client_id);
#line 22 "tracker-store.vala"
	_g_free0 (_data_->client_id);
#line 22 "tracker-store.vala"
	_data_->client_id = _tmp2_;
#line 22 "tracker-store.vala"
	tracker_store_queue_turtle_import_co (_data_);
#line 1727 "tracker-store.c"
}

void
tracker_store_queue_turtle_import_finish (GAsyncResult* _res_,
                                          GError** error)
{
	TrackerStoreQueueTurtleImportData* _data_;
#line 22 "tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 22 "tracker-store.vala"
	if (NULL == _data_) {
#line 22 "tracker-store.vala"
		return;
#line 1741 "tracker-store.c"
	}
}

static void
tracker_store_queue_turtle_import_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	TrackerStoreQueueTurtleImportData* _data_;
#line 195 "tracker-store.vala"
	_data_ = _user_data_;
#line 195 "tracker-store.vala"
	_data_->_source_object_ = source_object;
#line 195 "tracker-store.vala"
	_data_->_res_ = _res_;
#line 195 "tracker-store.vala"
	tracker_store_queue_turtle_import_co (_data_);
#line 1759 "tracker-store.c"
}

static gboolean
tracker_store_queue_turtle_import_co (TrackerStoreQueueTurtleImportData* _data_)
{
#line 189 "tracker-store.vala"
	switch (_data_->_state_) {
#line 189 "tracker-store.vala"
		case 0:
#line 1769 "tracker-store.c"
		goto _state_0;
#line 189 "tracker-store.vala"
		case 1:
#line 1773 "tracker-store.c"
		goto _state_1;
		default:
#line 189 "tracker-store.vala"
		g_assert_not_reached ();
#line 1778 "tracker-store.c"
	}
	_state_0:
#line 190 "tracker-store.vala"
	if (!tracker_store_active) {
#line 191 "tracker-store.vala"
		_data_->_tmp0_ = g_error_new_literal (TRACKER_SPARQL_ERROR, TRACKER_SPARQL_ERROR_UNSUPPORTED, "Store is not active");
#line 191 "tracker-store.vala"
		_data_->_inner_error0_ = _data_->_tmp0_;
#line 191 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 191 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 191 "tracker-store.vala"
		return FALSE;
#line 1793 "tracker-store.c"
	}
#line 192 "tracker-store.vala"
	_data_->_tmp1_ = tracker_store_n_updates;
#line 192 "tracker-store.vala"
	tracker_store_n_updates = _data_->_tmp1_ + 1;
#line 193 "tracker-store.vala"
	tracker_store_ensure_signal_timeout ();
#line 194 "tracker-store.vala"
	_data_->_tmp2_ = tracker_store_create_cancellable (_data_->client_id);
#line 194 "tracker-store.vala"
	_data_->cancellable = _data_->_tmp2_;
#line 195 "tracker-store.vala"
	_data_->_state_ = 1;
#line 195 "tracker-store.vala"
	tracker_sparql_connection_load_async ((TrackerSparqlConnection*) _data_->conn, _data_->file, _data_->cancellable, tracker_store_queue_turtle_import_ready, _data_);
#line 195 "tracker-store.vala"
	return FALSE;
#line 1811 "tracker-store.c"
	_state_1:
#line 195 "tracker-store.vala"
	tracker_sparql_connection_load_finish ((TrackerSparqlConnection*) _data_->conn, _data_->_res_, &_data_->_inner_error0_);
#line 195 "tracker-store.vala"
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
#line 195 "tracker-store.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
#line 195 "tracker-store.vala"
		_g_object_unref0 (_data_->cancellable);
#line 195 "tracker-store.vala"
		g_object_unref (_data_->_async_result);
#line 195 "tracker-store.vala"
		return FALSE;
#line 1825 "tracker-store.c"
	}
#line 196 "tracker-store.vala"
	_data_->_tmp3_ = tracker_store_n_updates;
#line 196 "tracker-store.vala"
	tracker_store_n_updates = _data_->_tmp3_ - 1;
#line 189 "tracker-store.vala"
	_g_object_unref0 (_data_->cancellable);
#line 189 "tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 189 "tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 189 "tracker-store.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 189 "tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1841 "tracker-store.c"
		}
	}
#line 189 "tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 189 "tracker-store.vala"
	return FALSE;
#line 1848 "tracker-store.c"
}

void
tracker_store_unreg_batches (const gchar* client_id)
{
	GCancellable* cancellable = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
#line 199 "tracker-store.vala"
	g_return_if_fail (client_id != NULL);
#line 200 "tracker-store.vala"
	_tmp0_ = tracker_store_client_cancellables;
#line 200 "tracker-store.vala"
	_tmp1_ = g_hash_table_lookup (_tmp0_, client_id);
#line 200 "tracker-store.vala"
	_tmp2_ = _g_object_ref0 ((GCancellable*) _tmp1_);
#line 200 "tracker-store.vala"
	cancellable = _tmp2_;
#line 202 "tracker-store.vala"
	_tmp3_ = cancellable;
#line 202 "tracker-store.vala"
	if (_tmp3_ != NULL) {
#line 1873 "tracker-store.c"
		GCancellable* _tmp4_;
		GHashTable* _tmp5_;
#line 203 "tracker-store.vala"
		_tmp4_ = cancellable;
#line 203 "tracker-store.vala"
		g_cancellable_cancel (_tmp4_);
#line 204 "tracker-store.vala"
		_tmp5_ = tracker_store_client_cancellables;
#line 204 "tracker-store.vala"
		g_hash_table_remove (_tmp5_, client_id);
#line 1884 "tracker-store.c"
	}
#line 199 "tracker-store.vala"
	_g_object_unref0 (cancellable);
#line 1888 "tracker-store.c"
}

static void
tracker_store_pause_data_free (gpointer _data)
{
	TrackerStorePauseData* _data_;
	_data_ = _data;
#line 22 "tracker-store.vala"
	g_slice_free (TrackerStorePauseData, _data_);
#line 1898 "tracker-store.c"
}

void
tracker_store_pause (GAsyncReadyCallback _callback_,
                     gpointer _user_data_)
{
	TrackerStorePauseData* _data_;
#line 22 "tracker-store.vala"
	_data_ = g_slice_new0 (TrackerStorePauseData);
#line 22 "tracker-store.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 22 "tracker-store.vala"
	g_task_set_task_data (_data_->_async_result, _data_, tracker_store_pause_data_free);
#line 22 "tracker-store.vala"
	tracker_store_pause_co (_data_);
#line 1914 "tracker-store.c"
}

void
tracker_store_pause_finish (GAsyncResult* _res_)
{
	TrackerStorePauseData* _data_;
#line 22 "tracker-store.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1923 "tracker-store.c"
}

static gboolean
tracker_store_pause_co (TrackerStorePauseData* _data_)
{
#line 208 "tracker-store.vala"
	switch (_data_->_state_) {
#line 208 "tracker-store.vala"
		case 0:
#line 1933 "tracker-store.c"
		goto _state_0;
		default:
#line 208 "tracker-store.vala"
		g_assert_not_reached ();
#line 1938 "tracker-store.c"
	}
	_state_0:
#line 209 "tracker-store.vala"
	tracker_store_active = FALSE;
#line 211 "tracker-store.vala"
	_data_->_tmp0_ = tracker_main_get_sparql_connection ();
#line 211 "tracker-store.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 211 "tracker-store.vala"
	_data_->sparql_conn = _data_->_tmp1_;
#line 212 "tracker-store.vala"
	tracker_direct_connection_sync (_data_->sparql_conn);
#line 208 "tracker-store.vala"
	_g_object_unref0 (_data_->sparql_conn);
#line 208 "tracker-store.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 208 "tracker-store.vala"
	if (_data_->_state_ != 0) {
#line 208 "tracker-store.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 208 "tracker-store.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1961 "tracker-store.c"
		}
	}
#line 208 "tracker-store.vala"
	g_object_unref (_data_->_async_result);
#line 208 "tracker-store.vala"
	return FALSE;
#line 1968 "tracker-store.c"
}

void
tracker_store_resume (void)
{
#line 216 "tracker-store.vala"
	tracker_store_active = TRUE;
#line 1976 "tracker-store.c"
}

static void
tracker_store_on_statements_committed (void)
{
#line 220 "tracker-store.vala"
	tracker_events_transact ();
#line 221 "tracker-store.vala"
	tracker_writeback_transact ();
#line 222 "tracker-store.vala"
	tracker_store_check_graph_updated_signal ();
#line 1988 "tracker-store.c"
}

static void
tracker_store_on_statements_rolled_back (void)
{
#line 226 "tracker-store.vala"
	tracker_events_reset_pending ();
#line 227 "tracker-store.vala"
	tracker_writeback_reset_pending ();
#line 1998 "tracker-store.c"
}

static gboolean
___lambda10_ (void)
{
	gboolean result = FALSE;
#line 235 "tracker-store.vala"
	tracker_store_do_emit_signals ();
#line 236 "tracker-store.vala"
	result = FALSE;
#line 236 "tracker-store.vala"
	return result;
#line 2011 "tracker-store.c"
}

static gboolean
____lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda10_ ();
#line 234 "tracker-store.vala"
	return result;
#line 2021 "tracker-store.c"
}

static void
tracker_store_check_graph_updated_signal (void)
{
#line 232 "tracker-store.vala"
	if (tracker_events_get_total () > ((guint) TRACKER_STORE_GRAPH_UPDATED_IMMEDIATE_EMIT_AT)) {
#line 234 "tracker-store.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda10__gsource_func, NULL, NULL);
#line 2031 "tracker-store.c"
	}
}

static void
tracker_store_on_statement_inserted (gint graph_id,
                                     const gchar* graph,
                                     gint subject_id,
                                     const gchar* subject,
                                     gint pred_id,
                                     gint object_id,
                                     const gchar* object,
                                     GPtrArray* rdf_types)
{
#line 241 "tracker-store.vala"
	g_return_if_fail (subject != NULL);
#line 241 "tracker-store.vala"
	g_return_if_fail (rdf_types != NULL);
#line 242 "tracker-store.vala"
	tracker_events_add_insert (graph_id, subject_id, subject, pred_id, object_id, object, rdf_types);
#line 243 "tracker-store.vala"
	tracker_writeback_check (graph_id, graph, subject_id, subject, pred_id, object_id, object, rdf_types);
#line 2053 "tracker-store.c"
}

static void
tracker_store_on_statement_deleted (gint graph_id,
                                    const gchar* graph,
                                    gint subject_id,
                                    const gchar* subject,
                                    gint pred_id,
                                    gint object_id,
                                    const gchar* object,
                                    GPtrArray* rdf_types)
{
#line 246 "tracker-store.vala"
	g_return_if_fail (subject != NULL);
#line 246 "tracker-store.vala"
	g_return_if_fail (rdf_types != NULL);
#line 247 "tracker-store.vala"
	tracker_events_add_delete (graph_id, subject_id, subject, pred_id, object_id, object, rdf_types);
#line 248 "tracker-store.vala"
	tracker_writeback_check (graph_id, graph, subject_id, subject, pred_id, object_id, object, rdf_types);
#line 2074 "tracker-store.c"
}

static void
_tracker_store_on_statement_inserted_tracker_statement_callback (gint graph_id,
                                                                 const gchar* graph,
                                                                 gint subject_id,
                                                                 const gchar* subject,
                                                                 gint predicate_id,
                                                                 gint object_id,
                                                                 const gchar* object,
                                                                 GPtrArray* rdf_types,
                                                                 gpointer self)
{
#line 254 "tracker-store.vala"
	tracker_store_on_statement_inserted (graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
#line 2090 "tracker-store.c"
}

static void
_tracker_store_on_statement_deleted_tracker_statement_callback (gint graph_id,
                                                                const gchar* graph,
                                                                gint subject_id,
                                                                const gchar* subject,
                                                                gint predicate_id,
                                                                gint object_id,
                                                                const gchar* object,
                                                                GPtrArray* rdf_types,
                                                                gpointer self)
{
#line 255 "tracker-store.vala"
	tracker_store_on_statement_deleted (graph_id, graph, subject_id, subject, predicate_id, object_id, object, rdf_types);
#line 2106 "tracker-store.c"
}

static void
_tracker_store_on_statements_committed_tracker_commit_callback (gpointer self)
{
#line 256 "tracker-store.vala"
	tracker_store_on_statements_committed ();
#line 2114 "tracker-store.c"
}

static void
_tracker_store_on_statements_rolled_back_tracker_commit_callback (gpointer self)
{
#line 257 "tracker-store.vala"
	tracker_store_on_statements_rolled_back ();
#line 2122 "tracker-store.c"
}

void
tracker_store_enable_signals (void)
{
	TrackerDataManager* data_manager = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	TrackerData* data = NULL;
	TrackerData* _tmp2_;
	TrackerData* _tmp3_;
#line 252 "tracker-store.vala"
	_tmp0_ = tracker_main_get_data_manager ();
#line 252 "tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 252 "tracker-store.vala"
	data_manager = _tmp1_;
#line 253 "tracker-store.vala"
	_tmp2_ = tracker_data_manager_get_data (data_manager);
#line 253 "tracker-store.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 253 "tracker-store.vala"
	data = _tmp3_;
#line 254 "tracker-store.vala"
	tracker_data_add_insert_statement_callback (data, _tracker_store_on_statement_inserted_tracker_statement_callback, NULL);
#line 255 "tracker-store.vala"
	tracker_data_add_delete_statement_callback (data, _tracker_store_on_statement_deleted_tracker_statement_callback, NULL);
#line 256 "tracker-store.vala"
	tracker_data_add_commit_statement_callback (data, _tracker_store_on_statements_committed_tracker_commit_callback, NULL);
#line 257 "tracker-store.vala"
	tracker_data_add_rollback_statement_callback (data, _tracker_store_on_statements_rolled_back_tracker_commit_callback, NULL);
#line 251 "tracker-store.vala"
	_g_object_unref0 (data);
#line 251 "tracker-store.vala"
	_g_object_unref0 (data_manager);
#line 2158 "tracker-store.c"
}

void
tracker_store_disable_signals (void)
{
	TrackerDataManager* data_manager = NULL;
	TrackerDataManager* _tmp0_;
	TrackerDataManager* _tmp1_;
	TrackerData* data = NULL;
	TrackerData* _tmp2_;
	TrackerData* _tmp3_;
#line 261 "tracker-store.vala"
	_tmp0_ = tracker_main_get_data_manager ();
#line 261 "tracker-store.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 261 "tracker-store.vala"
	data_manager = _tmp1_;
#line 262 "tracker-store.vala"
	_tmp2_ = tracker_data_manager_get_data (data_manager);
#line 262 "tracker-store.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 262 "tracker-store.vala"
	data = _tmp3_;
#line 263 "tracker-store.vala"
	tracker_data_remove_insert_statement_callback (data, _tracker_store_on_statement_inserted_tracker_statement_callback, NULL);
#line 264 "tracker-store.vala"
	tracker_data_remove_delete_statement_callback (data, _tracker_store_on_statement_deleted_tracker_statement_callback, NULL);
#line 265 "tracker-store.vala"
	tracker_data_remove_commit_statement_callback (data, _tracker_store_on_statements_committed_tracker_commit_callback, NULL);
#line 266 "tracker-store.vala"
	tracker_data_remove_rollback_statement_callback (data, _tracker_store_on_statements_rolled_back_tracker_commit_callback, NULL);
#line 260 "tracker-store.vala"
	_g_object_unref0 (data);
#line 260 "tracker-store.vala"
	_g_object_unref0 (data_manager);
#line 2194 "tracker-store.c"
}

void
tracker_store_set_signal_callback (TrackerStoreSignalEmissionFunc func,
                                   gpointer func_target)
{
#line 270 "tracker-store.vala"
	tracker_store_signal_callback = func;
#line 270 "tracker-store.vala"
	tracker_store_signal_callback_target = func_target;
#line 2205 "tracker-store.c"
}

TrackerStore*
tracker_store_construct (GType object_type)
{
	TrackerStore* self = NULL;
#line 22 "tracker-store.vala"
	self = (TrackerStore*) g_type_create_instance (object_type);
#line 22 "tracker-store.vala"
	return self;
#line 2216 "tracker-store.c"
}

TrackerStore*
tracker_store_new (void)
{
#line 22 "tracker-store.vala"
	return tracker_store_construct (TRACKER_TYPE_STORE);
#line 2224 "tracker-store.c"
}

static TrackerStoreCursorTask*
tracker_store_cursor_task_construct (GType object_type,
                                     TrackerSparqlCursor* cursor)
{
	TrackerStoreCursorTask* self = NULL;
	TrackerSparqlCursor* _tmp0_;
#line 48 "tracker-store.vala"
	g_return_val_if_fail (cursor != NULL, NULL);
#line 48 "tracker-store.vala"
	self = (TrackerStoreCursorTask*) g_type_create_instance (object_type);
#line 49 "tracker-store.vala"
	_tmp0_ = _g_object_ref0 (cursor);
#line 49 "tracker-store.vala"
	_g_object_unref0 (self->cursor);
#line 49 "tracker-store.vala"
	self->cursor = _tmp0_;
#line 48 "tracker-store.vala"
	return self;
#line 2245 "tracker-store.c"
}

static TrackerStoreCursorTask*
tracker_store_cursor_task_new (TrackerSparqlCursor* cursor)
{
#line 48 "tracker-store.vala"
	return tracker_store_cursor_task_construct (TRACKER_STORE_TYPE_CURSOR_TASK, cursor);
#line 2253 "tracker-store.c"
}

static void
tracker_store_value_cursor_task_init (GValue* value)
{
#line 42 "tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 2261 "tracker-store.c"
}

static void
tracker_store_value_cursor_task_free_value (GValue* value)
{
#line 42 "tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 42 "tracker-store.vala"
		tracker_store_cursor_task_unref (value->data[0].v_pointer);
#line 2271 "tracker-store.c"
	}
}

static void
tracker_store_value_cursor_task_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
#line 42 "tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 42 "tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_cursor_task_ref (src_value->data[0].v_pointer);
#line 2283 "tracker-store.c"
	} else {
#line 42 "tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2287 "tracker-store.c"
	}
}

static gpointer
tracker_store_value_cursor_task_peek_pointer (const GValue* value)
{
#line 42 "tracker-store.vala"
	return value->data[0].v_pointer;
#line 2296 "tracker-store.c"
}

static gchar*
tracker_store_value_cursor_task_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
#line 42 "tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 2307 "tracker-store.c"
		TrackerStoreCursorTask * object;
		object = collect_values[0].v_pointer;
#line 42 "tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 42 "tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2314 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 42 "tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2318 "tracker-store.c"
		}
#line 42 "tracker-store.vala"
		value->data[0].v_pointer = tracker_store_cursor_task_ref (object);
#line 2322 "tracker-store.c"
	} else {
#line 42 "tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 2326 "tracker-store.c"
	}
#line 42 "tracker-store.vala"
	return NULL;
#line 2330 "tracker-store.c"
}

static gchar*
tracker_store_value_cursor_task_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	TrackerStoreCursorTask ** object_p;
	object_p = collect_values[0].v_pointer;
#line 42 "tracker-store.vala"
	if (!object_p) {
#line 42 "tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2345 "tracker-store.c"
	}
#line 42 "tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 42 "tracker-store.vala"
		*object_p = NULL;
#line 2351 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 42 "tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 2355 "tracker-store.c"
	} else {
#line 42 "tracker-store.vala"
		*object_p = tracker_store_cursor_task_ref (value->data[0].v_pointer);
#line 2359 "tracker-store.c"
	}
#line 42 "tracker-store.vala"
	return NULL;
#line 2363 "tracker-store.c"
}

static GParamSpec*
tracker_store_param_spec_cursor_task (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	TrackerStoreParamSpecCursorTask* spec;
#line 42 "tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_STORE_TYPE_CURSOR_TASK), NULL);
#line 42 "tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 42 "tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 42 "tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 2382 "tracker-store.c"
}

static gpointer
tracker_store_value_get_cursor_task (const GValue* value)
{
#line 42 "tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_CURSOR_TASK), NULL);
#line 42 "tracker-store.vala"
	return value->data[0].v_pointer;
#line 2392 "tracker-store.c"
}

static void
tracker_store_value_set_cursor_task (GValue* value,
                                     gpointer v_object)
{
	TrackerStoreCursorTask * old;
#line 42 "tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_CURSOR_TASK));
#line 42 "tracker-store.vala"
	old = value->data[0].v_pointer;
#line 42 "tracker-store.vala"
	if (v_object) {
#line 42 "tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_CURSOR_TASK));
#line 42 "tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 42 "tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 42 "tracker-store.vala"
		tracker_store_cursor_task_ref (value->data[0].v_pointer);
#line 2414 "tracker-store.c"
	} else {
#line 42 "tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 2418 "tracker-store.c"
	}
#line 42 "tracker-store.vala"
	if (old) {
#line 42 "tracker-store.vala"
		tracker_store_cursor_task_unref (old);
#line 2424 "tracker-store.c"
	}
}

static void
tracker_store_value_take_cursor_task (GValue* value,
                                      gpointer v_object)
{
	TrackerStoreCursorTask * old;
#line 42 "tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_STORE_TYPE_CURSOR_TASK));
#line 42 "tracker-store.vala"
	old = value->data[0].v_pointer;
#line 42 "tracker-store.vala"
	if (v_object) {
#line 42 "tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_STORE_TYPE_CURSOR_TASK));
#line 42 "tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 42 "tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 2445 "tracker-store.c"
	} else {
#line 42 "tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 2449 "tracker-store.c"
	}
#line 42 "tracker-store.vala"
	if (old) {
#line 42 "tracker-store.vala"
		tracker_store_cursor_task_unref (old);
#line 2455 "tracker-store.c"
	}
}

static void
tracker_store_cursor_task_class_init (TrackerStoreCursorTaskClass * klass,
                                      gpointer klass_data)
{
#line 42 "tracker-store.vala"
	tracker_store_cursor_task_parent_class = g_type_class_peek_parent (klass);
#line 42 "tracker-store.vala"
	((TrackerStoreCursorTaskClass *) klass)->finalize = tracker_store_cursor_task_finalize;
#line 2467 "tracker-store.c"
}

static void
tracker_store_cursor_task_instance_init (TrackerStoreCursorTask * self,
                                         gpointer klass)
{
#line 42 "tracker-store.vala"
	self->ref_count = 1;
#line 2476 "tracker-store.c"
}

static void
tracker_store_cursor_task_finalize (TrackerStoreCursorTask * obj)
{
	TrackerStoreCursorTask * self;
#line 42 "tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_STORE_TYPE_CURSOR_TASK, TrackerStoreCursorTask);
#line 42 "tracker-store.vala"
	g_signal_handlers_destroy (self);
#line 43 "tracker-store.vala"
	_g_object_unref0 (self->cursor);
#line 46 "tracker-store.vala"
	_g_error_free0 (self->error);
#line 2491 "tracker-store.c"
}

static GType
tracker_store_cursor_task_get_type (void)
{
	static volatile gsize tracker_store_cursor_task_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_cursor_task_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_store_value_cursor_task_init, tracker_store_value_cursor_task_free_value, tracker_store_value_cursor_task_copy_value, tracker_store_value_cursor_task_peek_pointer, "p", tracker_store_value_cursor_task_collect_value, "p", tracker_store_value_cursor_task_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreCursorTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_cursor_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStoreCursorTask), 0, (GInstanceInitFunc) tracker_store_cursor_task_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_cursor_task_type_id;
		tracker_store_cursor_task_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStoreCursorTask", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_store_cursor_task_type_id__volatile, tracker_store_cursor_task_type_id);
	}
	return tracker_store_cursor_task_type_id__volatile;
}

static gpointer
tracker_store_cursor_task_ref (gpointer instance)
{
	TrackerStoreCursorTask * self;
	self = instance;
#line 42 "tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 42 "tracker-store.vala"
	return instance;
#line 2518 "tracker-store.c"
}

static void
tracker_store_cursor_task_unref (gpointer instance)
{
	TrackerStoreCursorTask * self;
	self = instance;
#line 42 "tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 42 "tracker-store.vala"
		TRACKER_STORE_CURSOR_TASK_GET_CLASS (self)->finalize (self);
#line 42 "tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2532 "tracker-store.c"
	}
}

static void
tracker_value_store_init (GValue* value)
{
#line 22 "tracker-store.vala"
	value->data[0].v_pointer = NULL;
#line 2541 "tracker-store.c"
}

static void
tracker_value_store_free_value (GValue* value)
{
#line 22 "tracker-store.vala"
	if (value->data[0].v_pointer) {
#line 22 "tracker-store.vala"
		tracker_store_unref (value->data[0].v_pointer);
#line 2551 "tracker-store.c"
	}
}

static void
tracker_value_store_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
#line 22 "tracker-store.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "tracker-store.vala"
		dest_value->data[0].v_pointer = tracker_store_ref (src_value->data[0].v_pointer);
#line 2563 "tracker-store.c"
	} else {
#line 22 "tracker-store.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2567 "tracker-store.c"
	}
}

static gpointer
tracker_value_store_peek_pointer (const GValue* value)
{
#line 22 "tracker-store.vala"
	return value->data[0].v_pointer;
#line 2576 "tracker-store.c"
}

static gchar*
tracker_value_store_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
#line 22 "tracker-store.vala"
	if (collect_values[0].v_pointer) {
#line 2587 "tracker-store.c"
		TrackerStore * object;
		object = collect_values[0].v_pointer;
#line 22 "tracker-store.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "tracker-store.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2594 "tracker-store.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "tracker-store.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2598 "tracker-store.c"
		}
#line 22 "tracker-store.vala"
		value->data[0].v_pointer = tracker_store_ref (object);
#line 2602 "tracker-store.c"
	} else {
#line 22 "tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 2606 "tracker-store.c"
	}
#line 22 "tracker-store.vala"
	return NULL;
#line 2610 "tracker-store.c"
}

static gchar*
tracker_value_store_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	TrackerStore ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "tracker-store.vala"
	if (!object_p) {
#line 22 "tracker-store.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2625 "tracker-store.c"
	}
#line 22 "tracker-store.vala"
	if (!value->data[0].v_pointer) {
#line 22 "tracker-store.vala"
		*object_p = NULL;
#line 2631 "tracker-store.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "tracker-store.vala"
		*object_p = value->data[0].v_pointer;
#line 2635 "tracker-store.c"
	} else {
#line 22 "tracker-store.vala"
		*object_p = tracker_store_ref (value->data[0].v_pointer);
#line 2639 "tracker-store.c"
	}
#line 22 "tracker-store.vala"
	return NULL;
#line 2643 "tracker-store.c"
}

GParamSpec*
tracker_param_spec_store (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	TrackerParamSpecStore* spec;
#line 22 "tracker-store.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TRACKER_TYPE_STORE), NULL);
#line 22 "tracker-store.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "tracker-store.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "tracker-store.vala"
	return G_PARAM_SPEC (spec);
#line 2662 "tracker-store.c"
}

gpointer
tracker_value_get_store (const GValue* value)
{
#line 22 "tracker-store.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE), NULL);
#line 22 "tracker-store.vala"
	return value->data[0].v_pointer;
#line 2672 "tracker-store.c"
}

void
tracker_value_set_store (GValue* value,
                         gpointer v_object)
{
	TrackerStore * old;
#line 22 "tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "tracker-store.vala"
	if (v_object) {
#line 22 "tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 22 "tracker-store.vala"
		tracker_store_ref (value->data[0].v_pointer);
#line 2694 "tracker-store.c"
	} else {
#line 22 "tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 2698 "tracker-store.c"
	}
#line 22 "tracker-store.vala"
	if (old) {
#line 22 "tracker-store.vala"
		tracker_store_unref (old);
#line 2704 "tracker-store.c"
	}
}

void
tracker_value_take_store (GValue* value,
                          gpointer v_object)
{
	TrackerStore * old;
#line 22 "tracker-store.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TRACKER_TYPE_STORE));
#line 22 "tracker-store.vala"
	old = value->data[0].v_pointer;
#line 22 "tracker-store.vala"
	if (v_object) {
#line 22 "tracker-store.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TRACKER_TYPE_STORE));
#line 22 "tracker-store.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "tracker-store.vala"
		value->data[0].v_pointer = v_object;
#line 2725 "tracker-store.c"
	} else {
#line 22 "tracker-store.vala"
		value->data[0].v_pointer = NULL;
#line 2729 "tracker-store.c"
	}
#line 22 "tracker-store.vala"
	if (old) {
#line 22 "tracker-store.vala"
		tracker_store_unref (old);
#line 2735 "tracker-store.c"
	}
}

static void
tracker_store_class_init (TrackerStoreClass * klass,
                          gpointer klass_data)
{
#line 22 "tracker-store.vala"
	tracker_store_parent_class = g_type_class_peek_parent (klass);
#line 22 "tracker-store.vala"
	((TrackerStoreClass *) klass)->finalize = tracker_store_finalize;
#line 2747 "tracker-store.c"
}

static void
tracker_store_instance_init (TrackerStore * self,
                             gpointer klass)
{
#line 22 "tracker-store.vala"
	self->ref_count = 1;
#line 2756 "tracker-store.c"
}

static void
tracker_store_finalize (TrackerStore * obj)
{
	TrackerStore * self;
#line 22 "tracker-store.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TRACKER_TYPE_STORE, TrackerStore);
#line 22 "tracker-store.vala"
	g_signal_handlers_destroy (self);
#line 2767 "tracker-store.c"
}

GType
tracker_store_get_type (void)
{
	static volatile gsize tracker_store_type_id__volatile = 0;
	if (g_once_init_enter (&tracker_store_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { tracker_value_store_init, tracker_value_store_free_value, tracker_value_store_copy_value, tracker_value_store_peek_pointer, "p", tracker_value_store_collect_value, "p", tracker_value_store_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TrackerStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerStore), 0, (GInstanceInitFunc) tracker_store_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tracker_store_type_id;
		tracker_store_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrackerStore", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tracker_store_type_id__volatile, tracker_store_type_id);
	}
	return tracker_store_type_id__volatile;
}

gpointer
tracker_store_ref (gpointer instance)
{
	TrackerStore * self;
	self = instance;
#line 22 "tracker-store.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "tracker-store.vala"
	return instance;
#line 2794 "tracker-store.c"
}

void
tracker_store_unref (gpointer instance)
{
	TrackerStore * self;
	self = instance;
#line 22 "tracker-store.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "tracker-store.vala"
		TRACKER_STORE_GET_CLASS (self)->finalize (self);
#line 22 "tracker-store.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2808 "tracker-store.c"
	}
}

