/* rygel-lms-all-videos.c generated by valac 0.42.1.67-6c68, the Vala compiler
 * generated from rygel-lms-all-videos.vala, do not modify */

/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <rygel-server.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <rygel-db.h>
#include <gio/gio.h>

#define RYGEL_LMS_TYPE_CATEGORY_CONTAINER (rygel_lms_category_container_get_type ())
#define RYGEL_LMS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainer))
#define RYGEL_LMS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_IS_CATEGORY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_CATEGORY_CONTAINER))
#define RYGEL_LMS_CATEGORY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_CATEGORY_CONTAINER, RygelLMSCategoryContainerClass))

typedef struct _RygelLMSCategoryContainer RygelLMSCategoryContainer;
typedef struct _RygelLMSCategoryContainerClass RygelLMSCategoryContainerClass;
typedef struct _RygelLMSCategoryContainerPrivate RygelLMSCategoryContainerPrivate;

#define RYGEL_LMS_TYPE_ALL_VIDEOS (rygel_lms_all_videos_get_type ())
#define RYGEL_LMS_ALL_VIDEOS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_ALL_VIDEOS, RygelLMSAllVideos))
#define RYGEL_LMS_ALL_VIDEOS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_ALL_VIDEOS, RygelLMSAllVideosClass))
#define RYGEL_LMS_IS_ALL_VIDEOS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_ALL_VIDEOS))
#define RYGEL_LMS_IS_ALL_VIDEOS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_ALL_VIDEOS))
#define RYGEL_LMS_ALL_VIDEOS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_ALL_VIDEOS, RygelLMSAllVideosClass))

typedef struct _RygelLMSAllVideos RygelLMSAllVideos;
typedef struct _RygelLMSAllVideosClass RygelLMSAllVideosClass;
typedef struct _RygelLMSAllVideosPrivate RygelLMSAllVideosPrivate;
enum  {
	RYGEL_LMS_ALL_VIDEOS_0_PROPERTY,
	RYGEL_LMS_ALL_VIDEOS_NUM_PROPERTIES
};
static GParamSpec* rygel_lms_all_videos_properties[RYGEL_LMS_ALL_VIDEOS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_LMS_TYPE_DATABASE (rygel_lms_database_get_type ())
#define RYGEL_LMS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabase))
#define RYGEL_LMS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))
#define RYGEL_LMS_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_LMS_TYPE_DATABASE))
#define RYGEL_LMS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_LMS_TYPE_DATABASE, RygelLMSDatabaseClass))

typedef struct _RygelLMSDatabase RygelLMSDatabase;
typedef struct _RygelLMSDatabaseClass RygelLMSDatabaseClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_database_cursor_iterator_unref0(var) ((var == NULL) ? NULL : (var = (rygel_database_cursor_iterator_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelLMSCategoryContainer {
	RygelMediaContainer parent_instance;
	RygelLMSCategoryContainerPrivate * priv;
	RygelDatabaseCursor* cursor_all;
	RygelDatabaseCursor* cursor_find_object;
	RygelDatabaseCursor* cursor_added;
	RygelDatabaseCursor* cursor_removed;
	gchar* child_prefix;
	gchar* ref_prefix;
};

struct _RygelLMSCategoryContainerClass {
	RygelMediaContainerClass parent_class;
	RygelMediaObject* (*object_from_statement) (RygelLMSCategoryContainer* self, sqlite3_stmt* statement);
	gchar* (*get_sql_all_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	gchar* (*get_sql_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* filter);
	guint (*get_child_count_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args);
	RygelMediaObjects* (*get_children_with_filter) (RygelLMSCategoryContainer* self, const gchar* where_filter, GValueArray* args, const gchar* sort_criteria, guint offset, guint max_count);
};

struct _RygelLMSAllVideos {
	RygelLMSCategoryContainer parent_instance;
	RygelLMSAllVideosPrivate * priv;
};

struct _RygelLMSAllVideosClass {
	RygelLMSCategoryContainerClass parent_class;
};

static gpointer rygel_lms_all_videos_parent_class = NULL;

GType rygel_lms_category_container_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelLMSCategoryContainer, g_object_unref)
GType rygel_lms_all_videos_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelLMSAllVideos, g_object_unref)
#define RYGEL_LMS_ALL_VIDEOS_SQL_ALL "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id " "LIMIT ? OFFSET ?;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_COUNT "SELECT count(videos.id) " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_FIND_OBJECT "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND files.id = ? AND videos.id = files.id;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_ADDED "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime = 0 AND videos.id = files.id " "AND update_id > ? AND update_id <= ?;"
#define RYGEL_LMS_ALL_VIDEOS_SQL_REMOVED "SELECT videos.id, title, artist, length, path, mtime, size, dlna_profi" \
"le, dlna_mime " "FROM videos, files " "WHERE dtime <> 0 AND videos.id = files.id " "AND update_id > ? AND update_id <= ?;"
static RygelMediaObject* rygel_lms_all_videos_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                                   sqlite3_stmt* statement);
gchar* rygel_lms_category_container_build_child_id (RygelLMSCategoryContainer* self,
                                                    gint db_id);
GType rygel_lms_database_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelLMSDatabase, g_object_unref)
RygelLMSDatabase* rygel_lms_category_container_get_lms_db (RygelLMSCategoryContainer* self);
static void _vala_GValue_array_free (GValue * array,
                              gint array_length);
RygelLMSAllVideos* rygel_lms_all_videos_new (const gchar* id,
                                             RygelMediaContainer* parent,
                                             const gchar* title,
                                             RygelLMSDatabase* lms_db);
RygelLMSAllVideos* rygel_lms_all_videos_construct (GType object_type,
                                                   const gchar* id,
                                                   RygelMediaContainer* parent,
                                                   const gchar* title,
                                                   RygelLMSDatabase* lms_db);
RygelLMSCategoryContainer* rygel_lms_category_container_construct (GType object_type,
                                                                   const gchar* db_id,
                                                                   RygelMediaContainer* parent,
                                                                   const gchar* title,
                                                                   RygelLMSDatabase* lms_db,
                                                                   const gchar* sql_all,
                                                                   const gchar* sql_find_object,
                                                                   const gchar* sql_count,
                                                                   const gchar* sql_added,
                                                                   const gchar* sql_removed);

static void
_vala_GValue_array_free (GValue * array,
                         gint array_length)
{
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

static RygelMediaObject*
rygel_lms_all_videos_real_object_from_statement (RygelLMSCategoryContainer* base,
                                                 sqlite3_stmt* statement)
{
	RygelLMSAllVideos * self;
	RygelMediaObject* result = NULL;
	gint id = 0;
	gchar* mime_type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* path = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* file = NULL;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gchar* title = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	RygelVideoItem* video = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	RygelVideoItem* _tmp17_;
	RygelVideoItem* _tmp18_;
	RygelVideoItem* _tmp19_;
	const gchar* _tmp20_;
	RygelVideoItem* _tmp21_;
	GTimeVal tv = {0};
	GTimeVal _tmp22_ = {0};
	RygelVideoItem* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	RygelVideoItem* _tmp26_;
	RygelVideoItem* _tmp27_;
	const gchar* _tmp28_;
	RygelVideoItem* _tmp29_;
	const gchar* _tmp30_;
	RygelVideoItem* _tmp31_;
	GFile* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* video_data = NULL;
	gchar* _tmp35_;
	GError* _inner_error0_ = NULL;
	self = (RygelLMSAllVideos*) base;
	g_return_val_if_fail (statement != NULL, NULL);
	id = sqlite3_column_int (statement, 0);
	_tmp0_ = (const gchar*) sqlite3_column_text (statement, 8);
	_tmp1_ = g_strdup (_tmp0_);
	mime_type = _tmp1_;
	_tmp2_ = (const gchar*) sqlite3_column_text (statement, 4);
	_tmp3_ = g_strdup (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	file = _tmp5_;
	_tmp7_ = mime_type;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = mime_type;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ == 0;
	}
	if (_tmp6_) {
		const gchar* _tmp11_;
		_tmp11_ = path;
		g_debug ("rygel-lms-all-videos.vala:77: Video item %d (%s) has no MIME type", id, _tmp11_);
	}
	_tmp12_ = (const gchar*) sqlite3_column_text (statement, 1);
	_tmp13_ = g_strdup (_tmp12_);
	title = _tmp13_;
	_tmp14_ = rygel_lms_category_container_build_child_id ((RygelLMSCategoryContainer*) self, id);
	_tmp15_ = _tmp14_;
	_tmp16_ = title;
	_tmp17_ = rygel_video_item_new (_tmp15_, (RygelMediaContainer*) self, _tmp16_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp15_);
	video = _tmp18_;
	_tmp19_ = video;
	_tmp20_ = (const gchar*) sqlite3_column_text (statement, 2);
	rygel_media_object_set_creator ((RygelMediaObject*) _tmp19_, _tmp20_);
	_tmp21_ = video;
	rygel_audio_item_set_duration ((RygelAudioItem*) _tmp21_, (glong) sqlite3_column_int (statement, 3));
	_tmp22_.tv_sec = (glong) sqlite3_column_int (statement, 5);
	_tmp22_.tv_usec = (glong) 0;
	tv = _tmp22_;
	_tmp23_ = video;
	_tmp24_ = g_time_val_to_iso8601 (&tv);
	_tmp25_ = _tmp24_;
	rygel_media_object_set_date ((RygelMediaObject*) _tmp23_, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = video;
	rygel_media_file_item_set_size ((RygelMediaFileItem*) _tmp26_, (gint64) sqlite3_column_int (statement, 6));
	_tmp27_ = video;
	_tmp28_ = (const gchar*) sqlite3_column_text (statement, 7);
	rygel_media_file_item_set_dlna_profile ((RygelMediaFileItem*) _tmp27_, _tmp28_);
	_tmp29_ = video;
	_tmp30_ = mime_type;
	rygel_media_file_item_set_mime_type ((RygelMediaFileItem*) _tmp29_, _tmp30_);
	_tmp31_ = video;
	_tmp32_ = file;
	_tmp33_ = g_file_get_uri (_tmp32_);
	_tmp34_ = _tmp33_;
	rygel_media_object_add_uri ((RygelMediaObject*) _tmp31_, _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = g_strdup ("select videos_videos.bitrate + videos_audios.bitrate, width, height, c" \
"hannels, sampling_rate " "from videos, videos_audios, videos_videos where videos.id = ? " "and videos.id = videos_audios.video_id and videos.id = videos_videos.v" \
"ideo_id;");
	video_data = _tmp35_;
	{
		GValue* args = NULL;
		GValue _tmp36_ = {0};
		GValue* _tmp37_;
		gint args_length1;
		gint _args_size_;
		RygelDatabaseCursor* cursor = NULL;
		RygelLMSDatabase* _tmp38_;
		RygelLMSDatabase* _tmp39_;
		const gchar* _tmp40_;
		GValue* _tmp41_;
		gint _tmp41__length1;
		RygelDatabaseCursor* _tmp42_;
		g_value_init (&_tmp36_, G_TYPE_INT);
		g_value_set_int (&_tmp36_, id);
		_tmp37_ = g_new0 (GValue, 1);
		_tmp37_[0] = _tmp36_;
		args = _tmp37_;
		args_length1 = 1;
		_args_size_ = args_length1;
		_tmp38_ = rygel_lms_category_container_get_lms_db ((RygelLMSCategoryContainer*) self);
		_tmp39_ = _tmp38_;
		_tmp40_ = video_data;
		_tmp41_ = args;
		_tmp41__length1 = args_length1;
		_tmp42_ = rygel_database_database_exec_cursor ((RygelDatabaseDatabase*) _tmp39_, _tmp40_, _tmp41_, (gint) _tmp41__length1, &_inner_error0_);
		cursor = _tmp42_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
				goto __catch10_rygel_database_database_error;
			}
			args = (_vala_GValue_array_free (args, args_length1), NULL);
			_g_free0 (video_data);
			_g_object_unref0 (video);
			_g_free0 (title);
			_g_object_unref0 (file);
			_g_free0 (path);
			_g_free0 (mime_type);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		{
			RygelDatabaseCursorIterator* _stmt_it = NULL;
			RygelDatabaseCursor* _tmp43_;
			RygelDatabaseCursorIterator* _tmp44_;
			_tmp43_ = cursor;
			_tmp44_ = rygel_database_cursor_iterator (_tmp43_);
			_stmt_it = _tmp44_;
			while (TRUE) {
				gboolean _tmp45_ = FALSE;
				RygelDatabaseCursorIterator* _tmp46_;
				sqlite3_stmt* stmt = NULL;
				RygelDatabaseCursorIterator* _tmp47_;
				sqlite3_stmt* _tmp48_;
				RygelVideoItem* _tmp49_;
				sqlite3_stmt* _tmp50_;
				RygelVideoItem* _tmp51_;
				sqlite3_stmt* _tmp52_;
				RygelVideoItem* _tmp53_;
				sqlite3_stmt* _tmp54_;
				RygelVideoItem* _tmp55_;
				sqlite3_stmt* _tmp56_;
				RygelVideoItem* _tmp57_;
				sqlite3_stmt* _tmp58_;
				_tmp46_ = _stmt_it;
				_tmp45_ = rygel_database_cursor_iterator_next (_tmp46_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch10_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					_g_free0 (video_data);
					_g_object_unref0 (video);
					_g_free0 (title);
					_g_object_unref0 (file);
					_g_free0 (path);
					_g_free0 (mime_type);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				if (!_tmp45_) {
					break;
				}
				_tmp47_ = _stmt_it;
				_tmp48_ = rygel_database_cursor_iterator_get (_tmp47_, &_inner_error0_);
				stmt = _tmp48_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					if (_inner_error0_->domain == RYGEL_DATABASE_DATABASE_ERROR) {
						goto __catch10_rygel_database_database_error;
					}
					_rygel_database_cursor_iterator_unref0 (_stmt_it);
					_g_object_unref0 (cursor);
					args = (_vala_GValue_array_free (args, args_length1), NULL);
					_g_free0 (video_data);
					_g_object_unref0 (video);
					_g_free0 (title);
					_g_object_unref0 (file);
					_g_free0 (path);
					_g_free0 (mime_type);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp49_ = video;
				_tmp50_ = stmt;
				rygel_audio_item_set_bitrate ((RygelAudioItem*) _tmp49_, sqlite3_column_int (_tmp50_, 0) / 8);
				_tmp51_ = video;
				_tmp52_ = stmt;
				rygel_visual_item_set_width ((RygelVisualItem*) _tmp51_, sqlite3_column_int (_tmp52_, 1));
				_tmp53_ = video;
				_tmp54_ = stmt;
				rygel_visual_item_set_height ((RygelVisualItem*) _tmp53_, sqlite3_column_int (_tmp54_, 2));
				_tmp55_ = video;
				_tmp56_ = stmt;
				rygel_audio_item_set_channels ((RygelAudioItem*) _tmp55_, sqlite3_column_int (_tmp56_, 3));
				_tmp57_ = video;
				_tmp58_ = stmt;
				rygel_audio_item_set_sample_freq ((RygelAudioItem*) _tmp57_, sqlite3_column_int (_tmp58_, 4));
			}
			_rygel_database_cursor_iterator_unref0 (_stmt_it);
		}
		_g_object_unref0 (cursor);
		args = (_vala_GValue_array_free (args, args_length1), NULL);
	}
	goto __finally10;
	__catch10_rygel_database_database_error:
	{
		GError* e = NULL;
		GError* _tmp59_;
		const gchar* _tmp60_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp59_ = e;
		_tmp60_ = _tmp59_->message;
		g_warning ("rygel-lms-all-videos.vala:109: Query failed: %s", _tmp60_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (video_data);
		_g_object_unref0 (video);
		_g_free0 (title);
		_g_object_unref0 (file);
		_g_free0 (path);
		_g_free0 (mime_type);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = (RygelMediaObject*) video;
	_g_free0 (video_data);
	_g_free0 (title);
	_g_object_unref0 (file);
	_g_free0 (path);
	_g_free0 (mime_type);
	return result;
}

RygelLMSAllVideos*
rygel_lms_all_videos_construct (GType object_type,
                                const gchar* id,
                                RygelMediaContainer* parent,
                                const gchar* title,
                                RygelLMSDatabase* lms_db)
{
	RygelLMSAllVideos * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	g_return_val_if_fail (lms_db != NULL, NULL);
	self = (RygelLMSAllVideos*) rygel_lms_category_container_construct (object_type, id, parent, title, lms_db, RYGEL_LMS_ALL_VIDEOS_SQL_ALL, RYGEL_LMS_ALL_VIDEOS_SQL_FIND_OBJECT, RYGEL_LMS_ALL_VIDEOS_SQL_COUNT, RYGEL_LMS_ALL_VIDEOS_SQL_ADDED, RYGEL_LMS_ALL_VIDEOS_SQL_REMOVED);
	return self;
}

RygelLMSAllVideos*
rygel_lms_all_videos_new (const gchar* id,
                          RygelMediaContainer* parent,
                          const gchar* title,
                          RygelLMSDatabase* lms_db)
{
	return rygel_lms_all_videos_construct (RYGEL_LMS_TYPE_ALL_VIDEOS, id, parent, title, lms_db);
}

static void
rygel_lms_all_videos_class_init (RygelLMSAllVideosClass * klass,
                                 gpointer klass_data)
{
	rygel_lms_all_videos_parent_class = g_type_class_peek_parent (klass);
	((RygelLMSCategoryContainerClass *) klass)->object_from_statement = (RygelMediaObject* (*) (RygelLMSCategoryContainer*, sqlite3_stmt*)) rygel_lms_all_videos_real_object_from_statement;
}

static void
rygel_lms_all_videos_instance_init (RygelLMSAllVideos * self,
                                    gpointer klass)
{
}

GType
rygel_lms_all_videos_get_type (void)
{
	static volatile gsize rygel_lms_all_videos_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_lms_all_videos_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLMSAllVideosClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_lms_all_videos_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLMSAllVideos), 0, (GInstanceInitFunc) rygel_lms_all_videos_instance_init, NULL };
		GType rygel_lms_all_videos_type_id;
		rygel_lms_all_videos_type_id = g_type_register_static (RYGEL_LMS_TYPE_CATEGORY_CONTAINER, "RygelLMSAllVideos", &g_define_type_info, 0);
		g_once_init_leave (&rygel_lms_all_videos_type_id__volatile, rygel_lms_all_videos_type_id);
	}
	return rygel_lms_all_videos_type_id__volatile;
}

