/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_PROPERTY);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CONSTANT)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_ARRAY_LENGTH_FIELD)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CONSTANT);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CONSTANT) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ENUM_VALUE)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp513_ = FALSE;
	gboolean _tmp514_ = FALSE;
	gboolean _tmp515_ = FALSE;
	ValaExpression* _tmp516_;
	ValaExpression* _tmp517_;
	ValaSymbol* _tmp543_;
	ValaSymbol* _tmp544_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp567_;
	ValaSymbol* _tmp568_;
	ValaSymbol* _tmp569_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp570_;
	ValaSymbol* _tmp571_;
	ValaSymbol* _tmp993_;
	ValaSymbol* _tmp994_;
	ValaVersionAttribute* _tmp995_;
	ValaVersionAttribute* _tmp996_;
	ValaSourceReference* _tmp997_;
	ValaSourceReference* _tmp998_;
	gboolean _tmp999_ = FALSE;
	ValaSymbolAccessibility _tmp1000_;
	gboolean _tmp1059_ = FALSE;
	gboolean _tmp1090_ = FALSE;
	gboolean _tmp1091_ = FALSE;
	ValaDataType* _tmp1346_;
	ValaDataType* _tmp1347_;
	gboolean _tmp1350_;
	gboolean _tmp1351_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		const gchar* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		_tmp19_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp18_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp19_;
		_tmp20_ = base_symbol;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->_member_name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = _tmp24_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp25_);
		_vala_code_node_unref0 (_tmp25_);
	} else {
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp26_ = vala_member_access_get_inner (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NULL) {
			const gchar* _tmp28_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			ValaSymbol* _tmp42_;
			gboolean _tmp152_ = FALSE;
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp28_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp28_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp29_;
				ValaSemanticAnalyzer* _tmp30_;
				_tmp29_ = vala_code_context_get_analyzer (context);
				_tmp30_ = _tmp29_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp30_)) {
					ValaSourceReference* _tmp31_;
					ValaSourceReference* _tmp32_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp32_ = _tmp31_;
					vala_report_error (_tmp32_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp33_ = vala_code_context_get_analyzer (context);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_semantic_analyzer_get_current_symbol (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _vala_code_node_ref0 (_tmp36_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = _vala_code_node_ref0 (_tmp41_);
			sym = _tmp42_;
			while (TRUE) {
				gboolean _tmp43_ = FALSE;
				ValaSymbol* _tmp44_;
				ValaSymbol* _tmp100_;
				const gchar* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				gboolean _tmp104_ = FALSE;
				gboolean _tmp105_ = FALSE;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSymbol* _tmp148_;
				ValaSymbol* _tmp149_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				_tmp44_ = sym;
				if (_tmp44_ != NULL) {
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp46_ = _tmp45_;
					_tmp43_ = _tmp46_ == NULL;
				} else {
					_tmp43_ = FALSE;
				}
				if (!_tmp43_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp47_;
					_tmp47_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_CREATION_METHOD)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp48_;
						ValaCreationMethod* _tmp49_;
						ValaCreationMethod* _tmp50_;
						ValaParameter* _tmp51_;
						ValaParameter* _tmp52_;
						ValaParameter* _tmp53_;
						_tmp48_ = sym;
						_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp49_;
						_tmp50_ = cm;
						_tmp51_ = vala_method_get_this_parameter ((ValaMethod*) _tmp50_);
						_tmp52_ = _tmp51_;
						_tmp53_ = _vala_code_node_ref0 (_tmp52_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp53_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp54_;
						_tmp54_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp55_;
							ValaProperty* _tmp56_;
							ValaProperty* _tmp57_;
							ValaParameter* _tmp58_;
							ValaParameter* _tmp59_;
							ValaParameter* _tmp60_;
							ValaProperty* _tmp61_;
							ValaMemberBinding _tmp62_;
							ValaMemberBinding _tmp63_;
							ValaProperty* _tmp64_;
							ValaMemberBinding _tmp65_;
							ValaMemberBinding _tmp66_;
							_tmp55_ = sym;
							_tmp56_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp56_;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_this_parameter (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_binding (_tmp61_);
							_tmp63_ = _tmp62_;
							may_access_instance_members = _tmp63_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp64_ = prop;
							_tmp65_ = vala_property_get_binding (_tmp64_);
							_tmp66_ = _tmp65_;
							may_access_klass_members = _tmp66_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp67_;
							_tmp67_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_CONSTRUCTOR)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp68_;
								ValaConstructor* _tmp69_;
								ValaConstructor* _tmp70_;
								ValaParameter* _tmp71_;
								ValaParameter* _tmp72_;
								ValaParameter* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaMemberBinding _tmp75_;
								ValaMemberBinding _tmp76_;
								_tmp68_ = sym;
								_tmp69_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp69_;
								_tmp70_ = c;
								_tmp71_ = vala_constructor_get_this_parameter (_tmp70_);
								_tmp72_ = _tmp71_;
								_tmp73_ = _vala_code_node_ref0 (_tmp72_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_binding (_tmp74_);
								_tmp76_ = _tmp75_;
								may_access_instance_members = _tmp76_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp77_;
								_tmp77_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_DESTRUCTOR)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp78_;
									ValaDestructor* _tmp79_;
									ValaDestructor* _tmp80_;
									ValaParameter* _tmp81_;
									ValaParameter* _tmp82_;
									ValaParameter* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaMemberBinding _tmp85_;
									ValaMemberBinding _tmp86_;
									_tmp78_ = sym;
									_tmp79_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp79_;
									_tmp80_ = d;
									_tmp81_ = vala_destructor_get_this_parameter (_tmp80_);
									_tmp82_ = _tmp81_;
									_tmp83_ = _vala_code_node_ref0 (_tmp82_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_binding (_tmp84_);
									_tmp86_ = _tmp85_;
									may_access_instance_members = _tmp86_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp87_;
									_tmp87_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_METHOD)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp88_;
										ValaMethod* _tmp89_;
										ValaMethod* _tmp90_;
										ValaParameter* _tmp91_;
										ValaParameter* _tmp92_;
										ValaParameter* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMemberBinding _tmp95_;
										ValaMemberBinding _tmp96_;
										ValaMethod* _tmp97_;
										ValaMemberBinding _tmp98_;
										ValaMemberBinding _tmp99_;
										_tmp88_ = sym;
										_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp89_;
										_tmp90_ = m;
										_tmp91_ = vala_method_get_this_parameter (_tmp90_);
										_tmp92_ = _tmp91_;
										_tmp93_ = _vala_code_node_ref0 (_tmp92_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_binding (_tmp94_);
										_tmp96_ = _tmp95_;
										may_access_instance_members = _tmp96_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp97_ = m;
										_tmp98_ = vala_method_get_binding (_tmp97_);
										_tmp99_ = _tmp98_;
										may_access_klass_members = _tmp99_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp100_ = sym;
				_tmp101_ = self->priv->_member_name;
				_tmp102_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp100_, _tmp101_);
				_tmp103_ = _tmp102_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
				_vala_code_node_unref0 (_tmp103_);
				_tmp106_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp107_ = _tmp106_;
				if (_tmp107_ == NULL) {
					ValaSymbol* _tmp108_;
					_tmp108_ = sym;
					_tmp105_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_TYPESYMBOL);
				} else {
					_tmp105_ = FALSE;
				}
				if (_tmp105_) {
					_tmp104_ = may_access_instance_members;
				} else {
					_tmp104_ = FALSE;
				}
				if (_tmp104_) {
					ValaParameter* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					const gchar* _tmp112_;
					ValaSymbol* _tmp113_;
					ValaSymbol* _tmp114_;
					gboolean _tmp115_ = FALSE;
					ValaSymbol* _tmp116_;
					ValaSymbol* _tmp117_;
					_tmp109_ = this_parameter;
					_tmp110_ = vala_variable_get_variable_type ((ValaVariable*) _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = self->priv->_member_name;
					_tmp113_ = vala_data_type_get_member (_tmp111_, _tmp112_);
					_tmp114_ = _tmp113_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp114_);
					_vala_code_node_unref0 (_tmp114_);
					_tmp116_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp117_ = _tmp116_;
					if (_tmp117_ != NULL) {
						ValaSymbol* _tmp118_;
						ValaSymbol* _tmp119_;
						_tmp118_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp119_ = _tmp118_;
						_tmp115_ = vala_member_access_is_instance_symbol (_tmp119_);
					} else {
						_tmp115_ = FALSE;
					}
					if (_tmp115_) {
						ValaSourceReference* _tmp120_;
						ValaSourceReference* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						ValaExpression* _tmp131_;
						ValaExpression* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaExpression* _tmp135_;
						ValaExpression* _tmp136_;
						ValaParameter* _tmp137_;
						ValaExpression* _tmp138_;
						ValaExpression* _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						const gchar* _tmp142_;
						ValaSymbol* _tmp143_;
						ValaSymbol* _tmp144_;
						_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_member_access_new (NULL, "this", _tmp121_);
						_tmp123_ = _tmp122_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp123_);
						_vala_code_node_unref0 (_tmp123_);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_data_type_copy (_tmp128_);
						_tmp130_ = _tmp129_;
						vala_expression_set_value_type (_tmp125_, _tmp130_);
						_vala_code_node_unref0 (_tmp130_);
						_tmp131_ = vala_member_access_get_inner (self);
						_tmp132_ = _tmp131_;
						_tmp133_ = vala_expression_get_value_type (_tmp132_);
						_tmp134_ = _tmp133_;
						vala_data_type_set_value_owned (_tmp134_, FALSE);
						_tmp135_ = vala_member_access_get_inner (self);
						_tmp136_ = _tmp135_;
						_tmp137_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp136_, (ValaSymbol*) _tmp137_);
						_tmp138_ = vala_member_access_get_inner (self);
						_tmp139_ = _tmp138_;
						_tmp140_ = vala_expression_get_value_type (_tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = self->priv->_member_name;
						_tmp143_ = vala_data_type_get_member (_tmp141_, _tmp142_);
						_tmp144_ = _tmp143_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp144_);
						_vala_code_node_unref0 (_tmp144_);
					}
				}
				_tmp145_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp146_ = _tmp145_;
				if (_tmp146_ == NULL) {
					ValaSymbol* _tmp147_;
					_tmp147_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp147_, VALA_TYPE_TYPESYMBOL)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp148_ = sym;
				_tmp149_ = vala_symbol_get_parent_symbol (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = _vala_code_node_ref0 (_tmp150_);
				_vala_code_node_unref0 (sym);
				sym = _tmp151_;
			}
			_tmp153_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp154_ = _tmp153_;
			if (_tmp154_ == NULL) {
				ValaSourceReference* _tmp155_;
				ValaSourceReference* _tmp156_;
				_tmp155_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp156_ = _tmp155_;
				_tmp152_ = _tmp156_ != NULL;
			} else {
				_tmp152_ = FALSE;
			}
			if (_tmp152_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp157_;
					ValaSourceReference* _tmp158_;
					ValaList* _tmp159_;
					ValaList* _tmp160_;
					ValaList* _tmp161_;
					gint _ns_size = 0;
					ValaList* _tmp162_;
					gint _tmp163_;
					gint _tmp164_;
					gint _ns_index = 0;
					_tmp157_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp158_ = _tmp157_;
					_tmp159_ = vala_source_reference_get_using_directives (_tmp158_);
					_tmp160_ = _tmp159_;
					_tmp161_ = _vala_iterable_ref0 (_tmp160_);
					_ns_list = _tmp161_;
					_tmp162_ = _ns_list;
					_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
					_tmp164_ = _tmp163_;
					_ns_size = _tmp164_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp165_;
						gpointer _tmp166_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp167_;
						ValaSymbol* _tmp168_;
						ValaSymbol* _tmp169_;
						ValaScope* _tmp170_;
						ValaScope* _tmp171_;
						const gchar* _tmp172_;
						ValaSymbol* _tmp173_;
						ValaSymbol* _tmp174_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp165_ = _ns_list;
						_tmp166_ = vala_list_get (_tmp165_, _ns_index);
						ns = (ValaUsingDirective*) _tmp166_;
						_tmp167_ = ns;
						_tmp168_ = vala_using_directive_get_namespace_symbol (_tmp167_);
						_tmp169_ = _tmp168_;
						_tmp170_ = vala_symbol_get_scope (_tmp169_);
						_tmp171_ = _tmp170_;
						_tmp172_ = self->priv->_member_name;
						_tmp173_ = vala_scope_lookup (_tmp171_, _tmp172_);
						local_sym = _tmp173_;
						_tmp174_ = local_sym;
						if (_tmp174_ != NULL) {
							gboolean _tmp175_ = FALSE;
							ValaSymbol* _tmp176_;
							ValaSymbol* _tmp177_;
							ValaSymbol* _tmp193_;
							_tmp176_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp177_ = _tmp176_;
							if (_tmp177_ != NULL) {
								ValaSymbol* _tmp178_;
								ValaSymbol* _tmp179_;
								ValaSymbol* _tmp180_;
								_tmp178_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp179_ = _tmp178_;
								_tmp180_ = local_sym;
								_tmp175_ = _tmp179_ != _tmp180_;
							} else {
								_tmp175_ = FALSE;
							}
							if (_tmp175_) {
								ValaSourceReference* _tmp181_;
								ValaSourceReference* _tmp182_;
								const gchar* _tmp183_;
								ValaSymbol* _tmp184_;
								ValaSymbol* _tmp185_;
								gchar* _tmp186_;
								gchar* _tmp187_;
								ValaSymbol* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								gchar* _tmp191_;
								gchar* _tmp192_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp182_ = _tmp181_;
								_tmp183_ = self->priv->_member_name;
								_tmp184_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp185_ = _tmp184_;
								_tmp186_ = vala_symbol_get_full_name (_tmp185_);
								_tmp187_ = _tmp186_;
								_tmp188_ = local_sym;
								_tmp189_ = vala_symbol_get_full_name (_tmp188_);
								_tmp190_ = _tmp189_;
								_tmp191_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp183_, _tmp187_, _tmp190_);
								_tmp192_ = _tmp191_;
								vala_report_error (_tmp182_, _tmp192_);
								_g_free0 (_tmp192_);
								_g_free0 (_tmp190_);
								_g_free0 (_tmp187_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp193_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp193_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp194_;
			ValaExpression* _tmp195_;
			gboolean _tmp196_;
			gboolean _tmp197_;
			ValaExpression* _tmp198_;
			ValaExpression* _tmp199_;
			ValaDataType* _tmp200_;
			ValaDataType* _tmp201_;
			ValaExpression* _tmp220_;
			ValaExpression* _tmp221_;
			gboolean _tmp237_ = FALSE;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			gboolean _tmp261_ = FALSE;
			ValaSymbol* _tmp262_;
			ValaSymbol* _tmp263_;
			gboolean _tmp298_ = FALSE;
			gboolean _tmp299_ = FALSE;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			_tmp194_ = vala_member_access_get_inner (self);
			_tmp195_ = _tmp194_;
			_tmp196_ = vala_code_node_get_error ((ValaCodeNode*) _tmp195_);
			_tmp197_ = _tmp196_;
			if (_tmp197_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp198_ = vala_member_access_get_inner (self);
			_tmp199_ = _tmp198_;
			_tmp200_ = vala_expression_get_value_type (_tmp199_);
			_tmp201_ = _tmp200_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp201_, VALA_TYPE_POINTER_TYPE)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp202_;
				ValaExpression* _tmp203_;
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				ValaPointerType* _tmp206_;
				gboolean _tmp207_ = FALSE;
				ValaPointerType* _tmp208_;
				_tmp202_ = vala_member_access_get_inner (self);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_expression_get_value_type (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp205_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp205_) : NULL);
				pointer_type = _tmp206_;
				_tmp208_ = pointer_type;
				if (_tmp208_ != NULL) {
					ValaPointerType* _tmp209_;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					_tmp209_ = pointer_type;
					_tmp210_ = vala_pointer_type_get_base_type (_tmp209_);
					_tmp211_ = _tmp210_;
					_tmp207_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp211_, VALA_TYPE_VALUE_TYPE);
				} else {
					_tmp207_ = FALSE;
				}
				if (_tmp207_) {
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaPointerIndirection* _tmp216_;
					ValaPointerIndirection* _tmp217_;
					ValaExpression* _tmp218_;
					ValaExpression* _tmp219_;
					_tmp212_ = vala_member_access_get_inner (self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_pointer_indirection_new (_tmp213_, _tmp215_);
					_tmp217_ = _tmp216_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp217_);
					_vala_code_node_unref0 (_tmp217_);
					_tmp218_ = vala_member_access_get_inner (self);
					_tmp219_ = _tmp218_;
					vala_code_node_check ((ValaCodeNode*) _tmp219_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp220_ = vala_member_access_get_inner (self);
			_tmp221_ = _tmp220_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp221_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp222_;
				ValaExpression* _tmp223_;
				ValaMemberAccess* _tmp224_;
				ValaMemberAccess* _tmp225_;
				gboolean _tmp226_;
				_tmp222_ = vala_member_access_get_inner (self);
				_tmp223_ = _tmp222_;
				_tmp224_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp223_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp224_;
				_tmp225_ = ma;
				_tmp226_ = _tmp225_->priv->_prototype_access;
				if (_tmp226_) {
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaSymbol* _tmp231_;
					ValaSymbol* _tmp232_;
					gchar* _tmp233_;
					gchar* _tmp234_;
					gchar* _tmp235_;
					gchar* _tmp236_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_expression_get_symbol_reference (_tmp230_);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_symbol_get_full_name (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp234_);
					_tmp236_ = _tmp235_;
					vala_report_error (_tmp228_, _tmp236_);
					_g_free0 (_tmp236_);
					_g_free0 (_tmp234_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp238_ = vala_member_access_get_inner (self);
			_tmp239_ = _tmp238_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp239_, VALA_TYPE_MEMBER_ACCESS)) {
				_tmp237_ = TRUE;
			} else {
				ValaExpression* _tmp240_;
				ValaExpression* _tmp241_;
				_tmp240_ = vala_member_access_get_inner (self);
				_tmp241_ = _tmp240_;
				_tmp237_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp241_, VALA_TYPE_BASE_ACCESS);
			}
			if (_tmp237_) {
				ValaExpression* _tmp242_;
				ValaExpression* _tmp243_;
				ValaSymbol* _tmp244_;
				ValaSymbol* _tmp245_;
				ValaSymbol* _tmp246_;
				gboolean _tmp247_ = FALSE;
				ValaSymbol* _tmp248_;
				ValaSymbol* _tmp249_;
				_tmp242_ = vala_member_access_get_inner (self);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = _vala_code_node_ref0 (_tmp245_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp246_;
				_tmp248_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp249_ = _tmp248_;
				if (_tmp249_ == NULL) {
					gboolean _tmp250_ = FALSE;
					ValaSymbol* _tmp251_;
					_tmp251_ = base_symbol;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp251_, VALA_TYPE_NAMESPACE)) {
						_tmp250_ = TRUE;
					} else {
						ValaSymbol* _tmp252_;
						_tmp252_ = base_symbol;
						_tmp250_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_TYPESYMBOL);
					}
					_tmp247_ = _tmp250_;
				} else {
					_tmp247_ = FALSE;
				}
				if (_tmp247_) {
					ValaSymbol* _tmp253_;
					ValaScope* _tmp254_;
					ValaScope* _tmp255_;
					const gchar* _tmp256_;
					ValaSymbol* _tmp257_;
					ValaSymbol* _tmp258_;
					ValaExpression* _tmp259_;
					ValaExpression* _tmp260_;
					_tmp253_ = base_symbol;
					_tmp254_ = vala_symbol_get_scope (_tmp253_);
					_tmp255_ = _tmp254_;
					_tmp256_ = self->priv->_member_name;
					_tmp257_ = vala_scope_lookup (_tmp255_, _tmp256_);
					_tmp258_ = _tmp257_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp258_);
					_vala_code_node_unref0 (_tmp258_);
					_tmp259_ = vala_member_access_get_inner (self);
					_tmp260_ = _tmp259_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp260_, VALA_TYPE_BASE_ACCESS)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp262_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp263_ = _tmp262_;
			if (_tmp263_ == NULL) {
				ValaExpression* _tmp264_;
				ValaExpression* _tmp265_;
				ValaDataType* _tmp266_;
				ValaDataType* _tmp267_;
				_tmp264_ = vala_member_access_get_inner (self);
				_tmp265_ = _tmp264_;
				_tmp266_ = vala_expression_get_value_type (_tmp265_);
				_tmp267_ = _tmp266_;
				_tmp261_ = _tmp267_ != NULL;
			} else {
				_tmp261_ = FALSE;
			}
			if (_tmp261_) {
				gboolean _tmp268_;
				ValaSymbol* _tmp296_;
				ValaSymbol* _tmp297_;
				_tmp268_ = self->priv->_pointer_member_access;
				if (_tmp268_) {
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					ValaDataType* _tmp271_;
					ValaDataType* _tmp272_;
					const gchar* _tmp273_;
					ValaSymbol* _tmp274_;
					ValaSymbol* _tmp275_;
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					_tmp271_ = vala_expression_get_value_type (_tmp270_);
					_tmp272_ = _tmp271_;
					_tmp273_ = self->priv->_member_name;
					_tmp274_ = vala_data_type_get_pointer_member (_tmp272_, _tmp273_);
					_tmp275_ = _tmp274_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp275_);
					_vala_code_node_unref0 (_tmp275_);
				} else {
					ValaExpression* _tmp276_;
					ValaExpression* _tmp277_;
					ValaDataType* _tmp278_;
					ValaDataType* _tmp279_;
					ValaTypeSymbol* _tmp280_;
					ValaTypeSymbol* _tmp281_;
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					const gchar* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaSymbol* _tmp295_;
					_tmp276_ = vala_member_access_get_inner (self);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_expression_get_value_type (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_data_type_get_data_type (_tmp279_);
					_tmp281_ = _tmp280_;
					if (_tmp281_ != NULL) {
						ValaExpression* _tmp282_;
						ValaExpression* _tmp283_;
						ValaDataType* _tmp284_;
						ValaDataType* _tmp285_;
						ValaTypeSymbol* _tmp286_;
						ValaTypeSymbol* _tmp287_;
						ValaSymbol* _tmp288_;
						_tmp282_ = vala_member_access_get_inner (self);
						_tmp283_ = _tmp282_;
						_tmp284_ = vala_expression_get_value_type (_tmp283_);
						_tmp285_ = _tmp284_;
						_tmp286_ = vala_data_type_get_data_type (_tmp285_);
						_tmp287_ = _tmp286_;
						_tmp288_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp287_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp288_;
					}
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = self->priv->_member_name;
					_tmp294_ = vala_data_type_get_member (_tmp292_, _tmp293_);
					_tmp295_ = _tmp294_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp295_);
					_vala_code_node_unref0 (_tmp295_);
				}
				_tmp296_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp297_ = _tmp296_;
				if (_tmp297_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp300_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp301_ = _tmp300_;
			if (_tmp301_ == NULL) {
				ValaExpression* _tmp302_;
				ValaExpression* _tmp303_;
				ValaDataType* _tmp304_;
				ValaDataType* _tmp305_;
				_tmp302_ = vala_member_access_get_inner (self);
				_tmp303_ = _tmp302_;
				_tmp304_ = vala_expression_get_value_type (_tmp303_);
				_tmp305_ = _tmp304_;
				_tmp299_ = _tmp305_ != NULL;
			} else {
				_tmp299_ = FALSE;
			}
			if (_tmp299_) {
				ValaExpression* _tmp306_;
				ValaExpression* _tmp307_;
				ValaDataType* _tmp308_;
				ValaDataType* _tmp309_;
				gboolean _tmp310_;
				gboolean _tmp311_;
				_tmp306_ = vala_member_access_get_inner (self);
				_tmp307_ = _tmp306_;
				_tmp308_ = vala_expression_get_value_type (_tmp307_);
				_tmp309_ = _tmp308_;
				_tmp310_ = vala_data_type_get_is_dynamic (_tmp309_);
				_tmp311_ = _tmp310_;
				_tmp298_ = _tmp311_;
			} else {
				_tmp298_ = FALSE;
			}
			if (_tmp298_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				ValaObjectType* _tmp316_;
				ValaCodeNode* _tmp317_;
				ValaCodeNode* _tmp318_;
				ValaSymbol* _tmp461_;
				ValaSymbol* _tmp462_;
				ValaSymbol* _tmp511_;
				ValaSymbol* _tmp512_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_expression_get_value_type (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp316_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp316_;
				_tmp317_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp318_ = _tmp317_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_METHOD_CALL)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp319_;
					ValaCodeNode* _tmp320_;
					ValaMethodCall* _tmp321_;
					ValaMethodCall* _tmp322_;
					ValaExpression* _tmp323_;
					ValaExpression* _tmp324_;
					_tmp319_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp321_;
					_tmp322_ = invoc;
					_tmp323_ = vala_method_call_get_call (_tmp322_);
					_tmp324_ = _tmp323_;
					if (_tmp324_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp325_;
						ValaDataType* _tmp326_;
						ValaDataType* _tmp327_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp342_;
						ValaExpression* _tmp343_;
						ValaDataType* _tmp344_;
						ValaDataType* _tmp345_;
						const gchar* _tmp346_;
						ValaDataType* _tmp347_;
						ValaSourceReference* _tmp348_;
						ValaSourceReference* _tmp349_;
						ValaDynamicMethod* _tmp350_;
						ValaDynamicMethod* _tmp351_;
						ValaMethodCall* _tmp352_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp353_;
						ValaErrorType* _tmp354_;
						ValaDynamicMethod* _tmp355_;
						ValaErrorType* _tmp356_;
						ValaDynamicMethod* _tmp357_;
						ValaDynamicMethod* _tmp358_;
						ValaParameter* _tmp359_;
						ValaParameter* _tmp360_;
						ValaObjectType* _tmp361_;
						ValaObjectTypeSymbol* _tmp362_;
						ValaObjectTypeSymbol* _tmp363_;
						ValaScope* _tmp364_;
						ValaScope* _tmp365_;
						ValaDynamicMethod* _tmp366_;
						ValaDynamicMethod* _tmp367_;
						_tmp325_ = invoc;
						_tmp326_ = vala_expression_get_target_type ((ValaExpression*) _tmp325_);
						_tmp327_ = _tmp326_;
						if (_tmp327_ != NULL) {
							ValaMethodCall* _tmp328_;
							ValaDataType* _tmp329_;
							ValaDataType* _tmp330_;
							ValaDataType* _tmp331_;
							ValaDataType* _tmp332_;
							_tmp328_ = invoc;
							_tmp329_ = vala_expression_get_target_type ((ValaExpression*) _tmp328_);
							_tmp330_ = _tmp329_;
							_tmp331_ = vala_data_type_copy (_tmp330_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp331_;
							_tmp332_ = ret_type;
							vala_data_type_set_value_owned (_tmp332_, TRUE);
						} else {
							ValaMethodCall* _tmp333_;
							ValaCodeNode* _tmp334_;
							ValaCodeNode* _tmp335_;
							_tmp333_ = invoc;
							_tmp334_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp333_);
							_tmp335_ = _tmp334_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp335_, VALA_TYPE_EXPRESSION_STATEMENT)) {
								ValaVoidType* _tmp336_;
								_tmp336_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp336_;
							} else {
								ValaExpression* _tmp337_;
								ValaExpression* _tmp338_;
								ValaDataType* _tmp339_;
								ValaDataType* _tmp340_;
								ValaDataType* _tmp341_;
								_tmp337_ = vala_member_access_get_inner (self);
								_tmp338_ = _tmp337_;
								_tmp339_ = vala_expression_get_value_type (_tmp338_);
								_tmp340_ = _tmp339_;
								_tmp341_ = vala_data_type_copy (_tmp340_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp341_;
							}
						}
						_tmp342_ = vala_member_access_get_inner (self);
						_tmp343_ = _tmp342_;
						_tmp344_ = vala_expression_get_value_type (_tmp343_);
						_tmp345_ = _tmp344_;
						_tmp346_ = self->priv->_member_name;
						_tmp347_ = ret_type;
						_tmp348_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp349_ = _tmp348_;
						_tmp350_ = vala_dynamic_method_new (_tmp345_, _tmp346_, _tmp347_, _tmp349_, NULL);
						m = _tmp350_;
						_tmp351_ = m;
						_tmp352_ = invoc;
						vala_dynamic_method_set_invocation (_tmp351_, _tmp352_);
						_tmp353_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp353_;
						_tmp354_ = err;
						vala_error_type_set_dynamic_error (_tmp354_, TRUE);
						_tmp355_ = m;
						_tmp356_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp355_, (ValaDataType*) _tmp356_);
						_tmp357_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp357_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp358_ = m;
						_tmp359_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp360_ = _tmp359_;
						vala_callable_add_parameter ((ValaCallable*) _tmp358_, _tmp360_);
						_vala_code_node_unref0 (_tmp360_);
						_tmp361_ = dynamic_object_type;
						_tmp362_ = vala_object_type_get_type_symbol (_tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_symbol_get_scope ((ValaSymbol*) _tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = m;
						vala_scope_add (_tmp365_, NULL, (ValaSymbol*) _tmp366_);
						_tmp367_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp367_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp368_;
					ValaCodeNode* _tmp369_;
					_tmp368_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp369_ = _tmp368_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp369_, VALA_TYPE_ASSIGNMENT)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp370_;
						ValaCodeNode* _tmp371_;
						ValaAssignment* _tmp372_;
						ValaAssignment* _tmp373_;
						ValaExpression* _tmp374_;
						ValaExpression* _tmp375_;
						_tmp370_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp371_ = _tmp370_;
						_tmp372_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp371_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp372_;
						_tmp373_ = a;
						_tmp374_ = vala_assignment_get_left (_tmp373_);
						_tmp375_ = _tmp374_;
						if (_tmp375_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp376_;
							ValaExpression* _tmp377_;
							ValaDataType* _tmp378_;
							ValaDataType* _tmp379_;
							const gchar* _tmp380_;
							ValaSourceReference* _tmp381_;
							ValaSourceReference* _tmp382_;
							ValaDynamicProperty* _tmp383_;
							ValaDynamicProperty* _tmp384_;
							ValaDynamicProperty* _tmp385_;
							ValaDynamicProperty* _tmp386_;
							ValaSourceReference* _tmp387_;
							ValaSourceReference* _tmp388_;
							ValaPropertyAccessor* _tmp389_;
							ValaPropertyAccessor* _tmp390_;
							ValaDynamicProperty* _tmp391_;
							ValaExpression* _tmp392_;
							ValaExpression* _tmp393_;
							ValaDataType* _tmp394_;
							ValaDataType* _tmp395_;
							ValaTypeSymbol* _tmp396_;
							ValaTypeSymbol* _tmp397_;
							ValaScope* _tmp398_;
							ValaScope* _tmp399_;
							ValaObjectType* _tmp400_;
							ValaObjectTypeSymbol* _tmp401_;
							ValaObjectTypeSymbol* _tmp402_;
							ValaScope* _tmp403_;
							ValaScope* _tmp404_;
							ValaDynamicProperty* _tmp405_;
							ValaDynamicProperty* _tmp406_;
							_tmp376_ = vala_member_access_get_inner (self);
							_tmp377_ = _tmp376_;
							_tmp378_ = vala_expression_get_value_type (_tmp377_);
							_tmp379_ = _tmp378_;
							_tmp380_ = self->priv->_member_name;
							_tmp381_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp382_ = _tmp381_;
							_tmp383_ = vala_dynamic_property_new (_tmp379_, _tmp380_, _tmp382_, NULL);
							prop = _tmp383_;
							_tmp384_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp384_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp385_ = prop;
							_tmp386_ = prop;
							_tmp387_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp386_);
							_tmp388_ = _tmp387_;
							_tmp389_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp388_, NULL);
							_tmp390_ = _tmp389_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp385_, _tmp390_);
							_vala_code_node_unref0 (_tmp390_);
							_tmp391_ = prop;
							_tmp392_ = vala_member_access_get_inner (self);
							_tmp393_ = _tmp392_;
							_tmp394_ = vala_expression_get_value_type (_tmp393_);
							_tmp395_ = _tmp394_;
							_tmp396_ = vala_data_type_get_data_type (_tmp395_);
							_tmp397_ = _tmp396_;
							_tmp398_ = vala_symbol_get_scope ((ValaSymbol*) _tmp397_);
							_tmp399_ = _tmp398_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp391_, _tmp399_);
							_tmp400_ = dynamic_object_type;
							_tmp401_ = vala_object_type_get_type_symbol (_tmp400_);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_symbol_get_scope ((ValaSymbol*) _tmp402_);
							_tmp404_ = _tmp403_;
							_tmp405_ = prop;
							vala_scope_add (_tmp404_, NULL, (ValaSymbol*) _tmp405_);
							_tmp406_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp406_);
							_vala_code_node_unref0 (prop);
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp407_ = FALSE;
						gboolean _tmp408_ = FALSE;
						ValaCodeNode* _tmp409_;
						ValaCodeNode* _tmp410_;
						_tmp409_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp410_ = _tmp409_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp410_, VALA_TYPE_MEMBER_ACCESS)) {
							ValaExpression* _tmp411_;
							ValaExpression* _tmp412_;
							_tmp411_ = vala_member_access_get_inner (self);
							_tmp412_ = _tmp411_;
							_tmp408_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp412_, VALA_TYPE_MEMBER_ACCESS);
						} else {
							_tmp408_ = FALSE;
						}
						if (_tmp408_) {
							ValaCodeNode* _tmp413_;
							ValaCodeNode* _tmp414_;
							ValaCodeNode* _tmp415_;
							ValaCodeNode* _tmp416_;
							_tmp413_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp414_ = _tmp413_;
							_tmp415_ = vala_code_node_get_parent_node (_tmp414_);
							_tmp416_ = _tmp415_;
							_tmp407_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp416_, VALA_TYPE_METHOD_CALL);
						} else {
							_tmp407_ = FALSE;
						}
						if (_tmp407_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp417_;
							ValaCodeNode* _tmp418_;
							ValaMemberAccess* _tmp419_;
							gboolean _tmp420_ = FALSE;
							ValaMemberAccess* _tmp421_;
							const gchar* _tmp422_;
							_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp418_ = _tmp417_;
							_tmp419_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp418_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp419_;
							_tmp421_ = ma;
							_tmp422_ = _tmp421_->priv->_member_name;
							if (g_strcmp0 (_tmp422_, "connect") == 0) {
								_tmp420_ = TRUE;
							} else {
								ValaMemberAccess* _tmp423_;
								const gchar* _tmp424_;
								_tmp423_ = ma;
								_tmp424_ = _tmp423_->priv->_member_name;
								_tmp420_ = g_strcmp0 (_tmp424_, "connect_after") == 0;
							}
							if (_tmp420_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp425_;
								ValaExpression* _tmp426_;
								ValaDataType* _tmp427_;
								ValaDataType* _tmp428_;
								const gchar* _tmp429_;
								ValaVoidType* _tmp430_;
								ValaVoidType* _tmp431_;
								ValaSourceReference* _tmp432_;
								ValaSourceReference* _tmp433_;
								ValaDynamicSignal* _tmp434_;
								ValaDynamicSignal* _tmp435_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp436_;
								ValaCodeNode* _tmp437_;
								ValaCodeNode* _tmp438_;
								ValaCodeNode* _tmp439_;
								ValaMethodCall* _tmp440_;
								ValaMethodCall* _tmp441_;
								ValaList* _tmp442_;
								ValaList* _tmp443_;
								gint _tmp444_;
								gint _tmp445_;
								gboolean _tmp446_;
								ValaDynamicSignal* _tmp453_;
								ValaObjectType* _tmp454_;
								ValaObjectTypeSymbol* _tmp455_;
								ValaObjectTypeSymbol* _tmp456_;
								ValaScope* _tmp457_;
								ValaScope* _tmp458_;
								ValaDynamicSignal* _tmp459_;
								ValaDynamicSignal* _tmp460_;
								_tmp425_ = vala_member_access_get_inner (self);
								_tmp426_ = _tmp425_;
								_tmp427_ = vala_expression_get_value_type (_tmp426_);
								_tmp428_ = _tmp427_;
								_tmp429_ = self->priv->_member_name;
								_tmp430_ = vala_void_type_new (NULL);
								_tmp431_ = _tmp430_;
								_tmp432_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp433_ = _tmp432_;
								_tmp434_ = vala_dynamic_signal_new (_tmp428_, _tmp429_, (ValaDataType*) _tmp431_, _tmp433_, NULL);
								_tmp435_ = _tmp434_;
								_vala_code_node_unref0 (_tmp431_);
								s = _tmp435_;
								_tmp436_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp437_ = _tmp436_;
								_tmp438_ = vala_code_node_get_parent_node (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp439_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp440_;
								_tmp441_ = mcall;
								_tmp442_ = vala_method_call_get_argument_list (_tmp441_);
								_tmp443_ = _tmp442_;
								_tmp444_ = vala_collection_get_size ((ValaCollection*) _tmp443_);
								_tmp445_ = _tmp444_;
								_tmp446_ = _tmp445_ > 0;
								_vala_iterable_unref0 (_tmp443_);
								if (_tmp446_) {
									ValaDynamicSignal* _tmp447_;
									ValaMethodCall* _tmp448_;
									ValaList* _tmp449_;
									ValaList* _tmp450_;
									gpointer _tmp451_;
									ValaExpression* _tmp452_;
									_tmp447_ = s;
									_tmp448_ = mcall;
									_tmp449_ = vala_method_call_get_argument_list (_tmp448_);
									_tmp450_ = _tmp449_;
									_tmp451_ = vala_list_get (_tmp450_, 0);
									_tmp452_ = (ValaExpression*) _tmp451_;
									vala_dynamic_signal_set_handler (_tmp447_, _tmp452_);
									_vala_code_node_unref0 (_tmp452_);
									_vala_iterable_unref0 (_tmp450_);
								}
								_tmp453_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp453_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp454_ = dynamic_object_type;
								_tmp455_ = vala_object_type_get_type_symbol (_tmp454_);
								_tmp456_ = _tmp455_;
								_tmp457_ = vala_symbol_get_scope ((ValaSymbol*) _tmp456_);
								_tmp458_ = _tmp457_;
								_tmp459_ = s;
								vala_scope_add (_tmp458_, NULL, (ValaSymbol*) _tmp459_);
								_tmp460_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp460_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp461_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp462_ = _tmp461_;
				if (_tmp462_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp463_;
					ValaExpression* _tmp464_;
					ValaDataType* _tmp465_;
					ValaDataType* _tmp466_;
					const gchar* _tmp467_;
					ValaSourceReference* _tmp468_;
					ValaSourceReference* _tmp469_;
					ValaDynamicProperty* _tmp470_;
					ValaDataType* _tmp471_;
					ValaDataType* _tmp472_;
					ValaDynamicProperty* _tmp483_;
					ValaDynamicProperty* _tmp484_;
					ValaDynamicProperty* _tmp485_;
					ValaDataType* _tmp486_;
					ValaDataType* _tmp487_;
					ValaDataType* _tmp488_;
					ValaDataType* _tmp489_;
					ValaDynamicProperty* _tmp490_;
					ValaSourceReference* _tmp491_;
					ValaSourceReference* _tmp492_;
					ValaPropertyAccessor* _tmp493_;
					ValaPropertyAccessor* _tmp494_;
					ValaDynamicProperty* _tmp495_;
					ValaExpression* _tmp496_;
					ValaExpression* _tmp497_;
					ValaDataType* _tmp498_;
					ValaDataType* _tmp499_;
					ValaTypeSymbol* _tmp500_;
					ValaTypeSymbol* _tmp501_;
					ValaScope* _tmp502_;
					ValaScope* _tmp503_;
					ValaObjectType* _tmp504_;
					ValaObjectTypeSymbol* _tmp505_;
					ValaObjectTypeSymbol* _tmp506_;
					ValaScope* _tmp507_;
					ValaScope* _tmp508_;
					ValaDynamicProperty* _tmp509_;
					ValaDynamicProperty* _tmp510_;
					_tmp463_ = vala_member_access_get_inner (self);
					_tmp464_ = _tmp463_;
					_tmp465_ = vala_expression_get_value_type (_tmp464_);
					_tmp466_ = _tmp465_;
					_tmp467_ = self->priv->_member_name;
					_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp469_ = _tmp468_;
					_tmp470_ = vala_dynamic_property_new (_tmp466_, _tmp467_, _tmp469_, NULL);
					prop = _tmp470_;
					_tmp471_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp472_ = _tmp471_;
					if (_tmp472_ != NULL) {
						ValaDynamicProperty* _tmp473_;
						ValaDataType* _tmp474_;
						ValaDataType* _tmp475_;
						_tmp473_ = prop;
						_tmp474_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp475_ = _tmp474_;
						vala_property_set_property_type ((ValaProperty*) _tmp473_, _tmp475_);
					} else {
						ValaDynamicProperty* _tmp476_;
						ValaExpression* _tmp477_;
						ValaExpression* _tmp478_;
						ValaDataType* _tmp479_;
						ValaDataType* _tmp480_;
						ValaDataType* _tmp481_;
						ValaDataType* _tmp482_;
						_tmp476_ = prop;
						_tmp477_ = vala_member_access_get_inner (self);
						_tmp478_ = _tmp477_;
						_tmp479_ = vala_expression_get_value_type (_tmp478_);
						_tmp480_ = _tmp479_;
						_tmp481_ = vala_data_type_copy (_tmp480_);
						_tmp482_ = _tmp481_;
						vala_property_set_property_type ((ValaProperty*) _tmp476_, _tmp482_);
						_vala_code_node_unref0 (_tmp482_);
					}
					_tmp483_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp483_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp484_ = prop;
					_tmp485_ = prop;
					_tmp486_ = vala_property_get_property_type ((ValaProperty*) _tmp485_);
					_tmp487_ = _tmp486_;
					_tmp488_ = vala_data_type_copy (_tmp487_);
					_tmp489_ = _tmp488_;
					_tmp490_ = prop;
					_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp490_);
					_tmp492_ = _tmp491_;
					_tmp493_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp489_, NULL, _tmp492_, NULL);
					_tmp494_ = _tmp493_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp484_, _tmp494_);
					_vala_code_node_unref0 (_tmp494_);
					_vala_code_node_unref0 (_tmp489_);
					_tmp495_ = prop;
					_tmp496_ = vala_member_access_get_inner (self);
					_tmp497_ = _tmp496_;
					_tmp498_ = vala_expression_get_value_type (_tmp497_);
					_tmp499_ = _tmp498_;
					_tmp500_ = vala_data_type_get_data_type (_tmp499_);
					_tmp501_ = _tmp500_;
					_tmp502_ = vala_symbol_get_scope ((ValaSymbol*) _tmp501_);
					_tmp503_ = _tmp502_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp495_, _tmp503_);
					_tmp504_ = dynamic_object_type;
					_tmp505_ = vala_object_type_get_type_symbol (_tmp504_);
					_tmp506_ = _tmp505_;
					_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
					_tmp508_ = _tmp507_;
					_tmp509_ = prop;
					vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
					_tmp510_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
					_vala_code_node_unref0 (prop);
				}
				_tmp511_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp512_ = _tmp511_;
				if (_tmp512_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
		}
	}
	_tmp516_ = vala_member_access_get_inner (self);
	_tmp517_ = _tmp516_;
	if (_tmp517_ == NULL) {
		ValaSymbol* _tmp518_;
		ValaSymbol* _tmp519_;
		_tmp518_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp519_ = _tmp518_;
		_tmp515_ = _tmp519_ == NULL;
	} else {
		_tmp515_ = FALSE;
	}
	if (_tmp515_) {
		ValaDataType* _tmp520_;
		ValaDataType* _tmp521_;
		_tmp520_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp521_ = _tmp520_;
		_tmp514_ = _tmp521_ != NULL;
	} else {
		_tmp514_ = FALSE;
	}
	if (_tmp514_) {
		ValaDataType* _tmp522_;
		ValaDataType* _tmp523_;
		ValaTypeSymbol* _tmp524_;
		ValaTypeSymbol* _tmp525_;
		_tmp522_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp523_ = _tmp522_;
		_tmp524_ = vala_data_type_get_data_type (_tmp523_);
		_tmp525_ = _tmp524_;
		_tmp513_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp525_, VALA_TYPE_ENUM);
	} else {
		_tmp513_ = FALSE;
	}
	if (_tmp513_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp526_;
		ValaDataType* _tmp527_;
		ValaTypeSymbol* _tmp528_;
		ValaTypeSymbol* _tmp529_;
		ValaEnum* _tmp530_;
		_tmp526_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp527_ = _tmp526_;
		_tmp528_ = vala_data_type_get_data_type (_tmp527_);
		_tmp529_ = _tmp528_;
		_tmp530_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp529_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp530_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp531_;
			ValaList* _tmp532_;
			gint _val_size = 0;
			ValaList* _tmp533_;
			gint _tmp534_;
			gint _tmp535_;
			gint _val_index = 0;
			_tmp531_ = enum_type;
			_tmp532_ = vala_enum_get_values (_tmp531_);
			_val_list = _tmp532_;
			_tmp533_ = _val_list;
			_tmp534_ = vala_collection_get_size ((ValaCollection*) _tmp533_);
			_tmp535_ = _tmp534_;
			_val_size = _tmp535_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp536_;
				gpointer _tmp537_;
				const gchar* _tmp538_;
				ValaEnumValue* _tmp539_;
				const gchar* _tmp540_;
				const gchar* _tmp541_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp536_ = _val_list;
				_tmp537_ = vala_list_get (_tmp536_, _val_index);
				val = (ValaEnumValue*) _tmp537_;
				_tmp538_ = self->priv->_member_name;
				_tmp539_ = val;
				_tmp540_ = vala_symbol_get_name ((ValaSymbol*) _tmp539_);
				_tmp541_ = _tmp540_;
				if (g_strcmp0 (_tmp538_, _tmp541_) == 0) {
					ValaEnumValue* _tmp542_;
					_tmp542_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp542_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp543_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp544_ = _tmp543_;
	if (_tmp544_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp545_;
		gboolean _tmp546_ = FALSE;
		ValaExpression* _tmp547_;
		ValaExpression* _tmp548_;
		ValaSourceReference* _tmp561_;
		ValaSourceReference* _tmp562_;
		const gchar* _tmp563_;
		const gchar* _tmp564_;
		gchar* _tmp565_;
		gchar* _tmp566_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp545_ = g_strdup ("(null)");
		base_type_name = _tmp545_;
		_tmp547_ = vala_member_access_get_inner (self);
		_tmp548_ = _tmp547_;
		if (_tmp548_ != NULL) {
			ValaExpression* _tmp549_;
			ValaExpression* _tmp550_;
			ValaDataType* _tmp551_;
			ValaDataType* _tmp552_;
			_tmp549_ = vala_member_access_get_inner (self);
			_tmp550_ = _tmp549_;
			_tmp551_ = vala_expression_get_value_type (_tmp550_);
			_tmp552_ = _tmp551_;
			_tmp546_ = _tmp552_ != NULL;
		} else {
			_tmp546_ = FALSE;
		}
		if (_tmp546_) {
			ValaExpression* _tmp553_;
			ValaExpression* _tmp554_;
			ValaDataType* _tmp555_;
			ValaDataType* _tmp556_;
			gchar* _tmp557_;
			_tmp553_ = vala_member_access_get_inner (self);
			_tmp554_ = _tmp553_;
			_tmp555_ = vala_expression_get_value_type (_tmp554_);
			_tmp556_ = _tmp555_;
			_tmp557_ = vala_code_node_to_string ((ValaCodeNode*) _tmp556_);
			_g_free0 (base_type_name);
			base_type_name = _tmp557_;
		} else {
			ValaSymbol* _tmp558_;
			_tmp558_ = base_symbol;
			if (_tmp558_ != NULL) {
				ValaSymbol* _tmp559_;
				gchar* _tmp560_;
				_tmp559_ = base_symbol;
				_tmp560_ = vala_symbol_get_full_name (_tmp559_);
				_g_free0 (base_type_name);
				base_type_name = _tmp560_;
			}
		}
		_tmp561_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp562_ = _tmp561_;
		_tmp563_ = self->priv->_member_name;
		_tmp564_ = base_type_name;
		_tmp565_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp563_, _tmp564_);
		_tmp566_ = _tmp565_;
		vala_report_error (_tmp562_, _tmp566_);
		_g_free0 (_tmp566_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp567_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp568_ = _tmp567_;
	_tmp569_ = _vala_code_node_ref0 (_tmp568_);
	member = _tmp569_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp570_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp570_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp571_ = member;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp571_, VALA_TYPE_LOCAL_VARIABLE)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp572_;
		ValaLocalVariable* _tmp573_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp574_;
		ValaSymbol* _tmp575_;
		ValaSymbol* _tmp576_;
		ValaBlock* _tmp577_;
		gboolean _tmp578_ = FALSE;
		ValaBlock* _tmp579_;
		_tmp572_ = member;
		_tmp573_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp572_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp573_;
		_tmp574_ = local;
		_tmp575_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp574_);
		_tmp576_ = _tmp575_;
		_tmp577_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp576_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp576_) : NULL);
		block = _tmp577_;
		_tmp579_ = block;
		if (_tmp579_ != NULL) {
			ValaSemanticAnalyzer* _tmp580_;
			ValaSemanticAnalyzer* _tmp581_;
			ValaBlock* _tmp582_;
			ValaSymbol* _tmp583_;
			ValaSymbol* _tmp584_;
			ValaSemanticAnalyzer* _tmp585_;
			ValaSemanticAnalyzer* _tmp586_;
			ValaSymbol* _tmp587_;
			ValaSymbol* _tmp588_;
			_tmp580_ = vala_code_context_get_analyzer (context);
			_tmp581_ = _tmp580_;
			_tmp582_ = block;
			_tmp583_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp581_, (ValaSymbol*) _tmp582_);
			_tmp584_ = _tmp583_;
			_tmp585_ = vala_code_context_get_analyzer (context);
			_tmp586_ = _tmp585_;
			_tmp587_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp586_);
			_tmp588_ = _tmp587_;
			_tmp578_ = _tmp584_ != _tmp588_;
			_vala_code_node_unref0 (_tmp584_);
		} else {
			_tmp578_ = FALSE;
		}
		if (_tmp578_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp589_;
			ValaSemanticAnalyzer* _tmp590_;
			ValaSymbol* _tmp591_;
			ValaSymbol* _tmp592_;
			ValaSymbol* _tmp593_;
			ValaLocalVariable* _tmp606_;
			ValaBlock* _tmp607_;
			_tmp589_ = vala_code_context_get_analyzer (context);
			_tmp590_ = _tmp589_;
			_tmp591_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp590_);
			_tmp592_ = _tmp591_;
			_tmp593_ = _vala_code_node_ref0 (_tmp592_);
			sym = _tmp593_;
			while (TRUE) {
				ValaSymbol* _tmp594_;
				ValaBlock* _tmp595_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp596_;
				ValaMethod* _tmp597_;
				ValaMethod* _tmp598_;
				ValaSymbol* _tmp602_;
				ValaSymbol* _tmp603_;
				ValaSymbol* _tmp604_;
				ValaSymbol* _tmp605_;
				_tmp594_ = sym;
				_tmp595_ = block;
				if (!(_tmp594_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp595_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp596_ = sym;
				_tmp597_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp596_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp596_) : NULL);
				method = _tmp597_;
				_tmp598_ = method;
				if (_tmp598_ != NULL) {
					ValaMethod* _tmp599_;
					ValaMethod* _tmp600_;
					ValaLocalVariable* _tmp601_;
					_tmp599_ = method;
					vala_method_set_closure (_tmp599_, TRUE);
					_tmp600_ = method;
					_tmp601_ = local;
					vala_method_add_captured_variable (_tmp600_, _tmp601_);
				}
				_tmp602_ = sym;
				_tmp603_ = vala_symbol_get_parent_symbol (_tmp602_);
				_tmp604_ = _tmp603_;
				_tmp605_ = _vala_code_node_ref0 (_tmp604_);
				_vala_code_node_unref0 (sym);
				sym = _tmp605_;
				_vala_code_node_unref0 (method);
			}
			_tmp606_ = local;
			vala_local_variable_set_captured (_tmp606_, TRUE);
			_tmp607_ = block;
			vala_block_set_captured (_tmp607_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp608_;
		_tmp608_ = member;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp608_, VALA_TYPE_PARAMETER)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp609_;
			ValaParameter* _tmp610_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp611_;
			ValaSymbol* _tmp612_;
			ValaSymbol* _tmp613_;
			ValaMethod* _tmp614_;
			gboolean _tmp615_ = FALSE;
			gboolean _tmp616_ = FALSE;
			ValaMethod* _tmp617_;
			_tmp609_ = member;
			_tmp610_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp609_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp610_;
			_tmp611_ = param;
			_tmp612_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp611_);
			_tmp613_ = _tmp612_;
			_tmp614_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp613_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp613_) : NULL);
			m = _tmp614_;
			_tmp617_ = m;
			if (_tmp617_ != NULL) {
				ValaMethod* _tmp618_;
				ValaSemanticAnalyzer* _tmp619_;
				ValaSemanticAnalyzer* _tmp620_;
				ValaSymbol* _tmp621_;
				ValaSymbol* _tmp622_;
				_tmp618_ = m;
				_tmp619_ = vala_code_context_get_analyzer (context);
				_tmp620_ = _tmp619_;
				_tmp621_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp620_);
				_tmp622_ = _tmp621_;
				_tmp616_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp618_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp622_;
			} else {
				_tmp616_ = FALSE;
			}
			if (_tmp616_) {
				ValaParameter* _tmp623_;
				ValaMethod* _tmp624_;
				ValaParameter* _tmp625_;
				ValaParameter* _tmp626_;
				_tmp623_ = param;
				_tmp624_ = m;
				_tmp625_ = vala_method_get_this_parameter (_tmp624_);
				_tmp626_ = _tmp625_;
				_tmp615_ = _tmp623_ != _tmp626_;
			} else {
				_tmp615_ = FALSE;
			}
			if (_tmp615_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp627_;
				ValaSemanticAnalyzer* _tmp628_;
				ValaSymbol* _tmp629_;
				ValaSymbol* _tmp630_;
				ValaSymbol* _tmp631_;
				ValaParameter* _tmp642_;
				ValaMethod* _tmp643_;
				ValaBlock* _tmp644_;
				ValaBlock* _tmp645_;
				ValaParameter* _tmp646_;
				ValaParameterDirection _tmp647_;
				ValaParameterDirection _tmp648_;
				_tmp627_ = vala_code_context_get_analyzer (context);
				_tmp628_ = _tmp627_;
				_tmp629_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp628_);
				_tmp630_ = _tmp629_;
				_tmp631_ = _vala_code_node_ref0 (_tmp630_);
				sym = _tmp631_;
				while (TRUE) {
					ValaSymbol* _tmp632_;
					ValaMethod* _tmp633_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp634_;
					ValaMethod* _tmp635_;
					ValaMethod* _tmp636_;
					ValaSymbol* _tmp638_;
					ValaSymbol* _tmp639_;
					ValaSymbol* _tmp640_;
					ValaSymbol* _tmp641_;
					_tmp632_ = sym;
					_tmp633_ = m;
					if (!(_tmp632_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp633_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp634_ = sym;
					_tmp635_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp634_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp634_) : NULL);
					method = _tmp635_;
					_tmp636_ = method;
					if (_tmp636_ != NULL) {
						ValaMethod* _tmp637_;
						_tmp637_ = method;
						vala_method_set_closure (_tmp637_, TRUE);
					}
					_tmp638_ = sym;
					_tmp639_ = vala_symbol_get_parent_symbol (_tmp638_);
					_tmp640_ = _tmp639_;
					_tmp641_ = _vala_code_node_ref0 (_tmp640_);
					_vala_code_node_unref0 (sym);
					sym = _tmp641_;
					_vala_code_node_unref0 (method);
				}
				_tmp642_ = param;
				vala_parameter_set_captured (_tmp642_, TRUE);
				_tmp643_ = m;
				_tmp644_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp643_);
				_tmp645_ = _tmp644_;
				vala_block_set_captured (_tmp645_, TRUE);
				_tmp646_ = param;
				_tmp647_ = vala_parameter_get_direction (_tmp646_);
				_tmp648_ = _tmp647_;
				if (_tmp648_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp649_;
					ValaSourceReference* _tmp650_;
					ValaParameter* _tmp651_;
					gchar* _tmp652_;
					gchar* _tmp653_;
					gchar* _tmp654_;
					gchar* _tmp655_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp649_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp650_ = _tmp649_;
					_tmp651_ = param;
					_tmp652_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp651_);
					_tmp653_ = _tmp652_;
					_tmp654_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp653_);
					_tmp655_ = _tmp654_;
					vala_report_error (_tmp650_, _tmp655_);
					_g_free0 (_tmp655_);
					_g_free0 (_tmp653_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp656_;
				ValaSymbol* _tmp657_;
				ValaSymbol* _tmp658_;
				ValaSymbol* _tmp659_;
				ValaSymbol* _tmp660_;
				ValaPropertyAccessor* _tmp661_;
				gboolean _tmp662_ = FALSE;
				gboolean _tmp663_ = FALSE;
				ValaPropertyAccessor* _tmp664_;
				_tmp656_ = param;
				_tmp657_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp656_);
				_tmp658_ = _tmp657_;
				_tmp659_ = vala_symbol_get_parent_symbol (_tmp658_);
				_tmp660_ = _tmp659_;
				_tmp661_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp660_, VALA_TYPE_PROPERTY_ACCESSOR) ? ((ValaPropertyAccessor*) _tmp660_) : NULL);
				acc = _tmp661_;
				_tmp664_ = acc;
				if (_tmp664_ != NULL) {
					ValaPropertyAccessor* _tmp665_;
					ValaSemanticAnalyzer* _tmp666_;
					ValaSemanticAnalyzer* _tmp667_;
					ValaSymbol* _tmp668_;
					ValaSymbol* _tmp669_;
					_tmp665_ = acc;
					_tmp666_ = vala_code_context_get_analyzer (context);
					_tmp667_ = _tmp666_;
					_tmp668_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp667_);
					_tmp669_ = _tmp668_;
					_tmp663_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp665_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp669_;
				} else {
					_tmp663_ = FALSE;
				}
				if (_tmp663_) {
					ValaParameter* _tmp670_;
					ValaPropertyAccessor* _tmp671_;
					ValaProperty* _tmp672_;
					ValaProperty* _tmp673_;
					ValaParameter* _tmp674_;
					ValaParameter* _tmp675_;
					_tmp670_ = param;
					_tmp671_ = acc;
					_tmp672_ = vala_property_accessor_get_prop (_tmp671_);
					_tmp673_ = _tmp672_;
					_tmp674_ = vala_property_get_this_parameter (_tmp673_);
					_tmp675_ = _tmp674_;
					_tmp662_ = _tmp670_ != _tmp675_;
				} else {
					_tmp662_ = FALSE;
				}
				if (_tmp662_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp676_;
					ValaSemanticAnalyzer* _tmp677_;
					ValaSymbol* _tmp678_;
					ValaSymbol* _tmp679_;
					ValaSymbol* _tmp680_;
					ValaParameter* _tmp691_;
					ValaPropertyAccessor* _tmp692_;
					ValaBlock* _tmp693_;
					ValaBlock* _tmp694_;
					_tmp676_ = vala_code_context_get_analyzer (context);
					_tmp677_ = _tmp676_;
					_tmp678_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp677_);
					_tmp679_ = _tmp678_;
					_tmp680_ = _vala_code_node_ref0 (_tmp679_);
					sym = _tmp680_;
					while (TRUE) {
						ValaSymbol* _tmp681_;
						ValaMethod* _tmp682_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp683_;
						ValaMethod* _tmp684_;
						ValaMethod* _tmp685_;
						ValaSymbol* _tmp687_;
						ValaSymbol* _tmp688_;
						ValaSymbol* _tmp689_;
						ValaSymbol* _tmp690_;
						_tmp681_ = sym;
						_tmp682_ = m;
						if (!(_tmp681_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp682_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp683_ = sym;
						_tmp684_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp683_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp683_) : NULL);
						method = _tmp684_;
						_tmp685_ = method;
						if (_tmp685_ != NULL) {
							ValaMethod* _tmp686_;
							_tmp686_ = method;
							vala_method_set_closure (_tmp686_, TRUE);
						}
						_tmp687_ = sym;
						_tmp688_ = vala_symbol_get_parent_symbol (_tmp687_);
						_tmp689_ = _tmp688_;
						_tmp690_ = _vala_code_node_ref0 (_tmp689_);
						_vala_code_node_unref0 (sym);
						sym = _tmp690_;
						_vala_code_node_unref0 (method);
					}
					_tmp691_ = param;
					vala_parameter_set_captured (_tmp691_, TRUE);
					_tmp692_ = acc;
					_tmp693_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp692_);
					_tmp694_ = _tmp693_;
					vala_block_set_captured (_tmp694_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp695_;
			_tmp695_ = member;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp695_, VALA_TYPE_FIELD)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp696_;
				ValaField* _tmp697_;
				ValaField* _tmp698_;
				ValaSymbolAccessibility _tmp699_;
				ValaSymbolAccessibility _tmp700_;
				ValaField* _tmp701_;
				ValaMemberBinding _tmp702_;
				ValaMemberBinding _tmp703_;
				ValaField* _tmp704_;
				ValaMemberBinding _tmp705_;
				ValaMemberBinding _tmp706_;
				ValaField* _tmp707_;
				ValaDataType* _tmp708_;
				ValaDataType* _tmp709_;
				_tmp696_ = member;
				_tmp697_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_FIELD, ValaField));
				f = _tmp697_;
				_tmp698_ = f;
				_tmp699_ = vala_symbol_get_access ((ValaSymbol*) _tmp698_);
				_tmp700_ = _tmp699_;
				access = _tmp700_;
				_tmp701_ = f;
				_tmp702_ = vala_field_get_binding (_tmp701_);
				_tmp703_ = _tmp702_;
				instance = _tmp703_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp704_ = f;
				_tmp705_ = vala_field_get_binding (_tmp704_);
				_tmp706_ = _tmp705_;
				klass = _tmp706_ == VALA_MEMBER_BINDING_CLASS;
				_tmp707_ = f;
				_tmp708_ = vala_variable_get_variable_type ((ValaVariable*) _tmp707_);
				_tmp709_ = _tmp708_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp709_, VALA_TYPE_GENERIC_TYPE)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp710_;
				_tmp710_ = member;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp710_, VALA_TYPE_CONSTANT)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp711_;
					ValaConstant* _tmp712_;
					ValaConstant* _tmp713_;
					ValaSymbolAccessibility _tmp714_;
					ValaSymbolAccessibility _tmp715_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp716_;
					ValaSymbol* _tmp717_;
					ValaSymbol* _tmp718_;
					ValaBlock* _tmp719_;
					gboolean _tmp720_ = FALSE;
					ValaBlock* _tmp721_;
					_tmp711_ = member;
					_tmp712_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp711_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp712_;
					_tmp713_ = c;
					_tmp714_ = vala_symbol_get_access ((ValaSymbol*) _tmp713_);
					_tmp715_ = _tmp714_;
					access = _tmp715_;
					_tmp716_ = c;
					_tmp717_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp716_);
					_tmp718_ = _tmp717_;
					_tmp719_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp718_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp718_) : NULL);
					block = _tmp719_;
					_tmp721_ = block;
					if (_tmp721_ != NULL) {
						ValaSemanticAnalyzer* _tmp722_;
						ValaSemanticAnalyzer* _tmp723_;
						ValaBlock* _tmp724_;
						ValaSymbol* _tmp725_;
						ValaSymbol* _tmp726_;
						ValaSemanticAnalyzer* _tmp727_;
						ValaSemanticAnalyzer* _tmp728_;
						ValaSymbol* _tmp729_;
						ValaSymbol* _tmp730_;
						_tmp722_ = vala_code_context_get_analyzer (context);
						_tmp723_ = _tmp722_;
						_tmp724_ = block;
						_tmp725_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp723_, (ValaSymbol*) _tmp724_);
						_tmp726_ = _tmp725_;
						_tmp727_ = vala_code_context_get_analyzer (context);
						_tmp728_ = _tmp727_;
						_tmp729_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp728_);
						_tmp730_ = _tmp729_;
						_tmp720_ = _tmp726_ != _tmp730_;
						_vala_code_node_unref0 (_tmp726_);
					} else {
						_tmp720_ = FALSE;
					}
					if (_tmp720_) {
						ValaSourceReference* _tmp731_;
						ValaSourceReference* _tmp732_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp731_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp732_ = _tmp731_;
						vala_report_error (_tmp732_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp733_;
					_tmp733_ = member;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp733_, VALA_TYPE_METHOD)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp734_;
						ValaMethod* _tmp735_;
						ValaMethod* _tmp736_;
						gboolean _tmp737_;
						gboolean _tmp738_;
						ValaMethod* _tmp840_;
						ValaSymbolAccessibility _tmp841_;
						ValaSymbolAccessibility _tmp842_;
						ValaMethod* _tmp843_;
						ValaMethod* _tmp847_;
						ValaMemberBinding _tmp848_;
						ValaMemberBinding _tmp849_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp868_;
						ValaDataType* _tmp869_;
						ValaDataType* _tmp870_;
						ValaGenericType* _tmp871_;
						gboolean _tmp872_ = FALSE;
						ValaGenericType* _tmp873_;
						_tmp734_ = member;
						_tmp735_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp734_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp735_;
						_tmp736_ = m;
						_tmp737_ = vala_method_get_is_async_callback (_tmp736_);
						_tmp738_ = _tmp737_;
						if (_tmp738_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp739_;
							ValaSemanticAnalyzer* _tmp740_;
							ValaMethod* _tmp741_;
							ValaMethod* _tmp742_;
							ValaMethod* _tmp743_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp744_;
							ValaMethod* _tmp777_;
							ValaSemanticAnalyzer* _tmp778_;
							ValaSemanticAnalyzer* _tmp779_;
							ValaMethod* _tmp780_;
							ValaMethod* _tmp781_;
							ValaMethod* _tmp800_;
							ValaMethod* _tmp801_;
							ValaMethod* _tmp802_;
							ValaSymbol* _tmp803_;
							ValaSymbol* _tmp804_;
							ValaSymbol* _tmp805_;
							_tmp739_ = vala_code_context_get_analyzer (context);
							_tmp740_ = _tmp739_;
							_tmp741_ = vala_semantic_analyzer_get_current_async_method (_tmp740_);
							_tmp742_ = _tmp741_;
							_tmp743_ = _vala_code_node_ref0 (_tmp742_);
							async_method = _tmp743_;
							is_valid_access = FALSE;
							_tmp744_ = async_method;
							if (_tmp744_ != NULL) {
								ValaMethod* _tmp745_;
								ValaMethod* _tmp746_;
								ValaMethod* _tmp747_;
								ValaMethod* _tmp748_;
								gboolean _tmp749_;
								_tmp745_ = m;
								_tmp746_ = async_method;
								_tmp747_ = vala_method_get_callback_method (_tmp746_);
								_tmp748_ = _tmp747_;
								_tmp749_ = _tmp745_ == _tmp748_;
								_vala_code_node_unref0 (_tmp748_);
								if (_tmp749_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp750_ = FALSE;
									ValaMethod* _tmp751_;
									ValaMethod* _tmp752_;
									ValaMethod* _tmp753_;
									_tmp751_ = async_method;
									_tmp752_ = vala_method_get_base_method (_tmp751_);
									_tmp753_ = _tmp752_;
									if (_tmp753_ != NULL) {
										ValaMethod* _tmp754_;
										ValaMethod* _tmp755_;
										ValaMethod* _tmp756_;
										ValaMethod* _tmp757_;
										ValaMethod* _tmp758_;
										ValaMethod* _tmp759_;
										_tmp754_ = m;
										_tmp755_ = async_method;
										_tmp756_ = vala_method_get_base_method (_tmp755_);
										_tmp757_ = _tmp756_;
										_tmp758_ = vala_method_get_callback_method (_tmp757_);
										_tmp759_ = _tmp758_;
										_tmp750_ = _tmp754_ == _tmp759_;
										_vala_code_node_unref0 (_tmp759_);
									} else {
										_tmp750_ = FALSE;
									}
									if (_tmp750_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp760_ = FALSE;
										ValaMethod* _tmp761_;
										ValaMethod* _tmp762_;
										ValaMethod* _tmp763_;
										_tmp761_ = async_method;
										_tmp762_ = vala_method_get_base_interface_method (_tmp761_);
										_tmp763_ = _tmp762_;
										if (_tmp763_ != NULL) {
											ValaMethod* _tmp764_;
											ValaMethod* _tmp765_;
											ValaMethod* _tmp766_;
											ValaMethod* _tmp767_;
											ValaMethod* _tmp768_;
											ValaMethod* _tmp769_;
											_tmp764_ = m;
											_tmp765_ = async_method;
											_tmp766_ = vala_method_get_base_interface_method (_tmp765_);
											_tmp767_ = _tmp766_;
											_tmp768_ = vala_method_get_callback_method (_tmp767_);
											_tmp769_ = _tmp768_;
											_tmp760_ = _tmp764_ == _tmp769_;
											_vala_code_node_unref0 (_tmp769_);
										} else {
											_tmp760_ = FALSE;
										}
										if (_tmp760_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp770_;
								ValaSourceReference* _tmp771_;
								ValaMethod* _tmp772_;
								gchar* _tmp773_;
								gchar* _tmp774_;
								gchar* _tmp775_;
								gchar* _tmp776_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp770_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp771_ = _tmp770_;
								_tmp772_ = m;
								_tmp773_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp772_);
								_tmp774_ = _tmp773_;
								_tmp775_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp774_);
								_tmp776_ = _tmp775_;
								vala_report_error (_tmp771_, _tmp776_);
								_g_free0 (_tmp776_);
								_g_free0 (_tmp774_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp777_ = async_method;
							_tmp778_ = vala_code_context_get_analyzer (context);
							_tmp779_ = _tmp778_;
							_tmp780_ = vala_semantic_analyzer_get_current_method (_tmp779_);
							_tmp781_ = _tmp780_;
							if (_tmp777_ != _tmp781_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp782_;
								ValaSemanticAnalyzer* _tmp783_;
								ValaMethod* _tmp784_;
								ValaMethod* _tmp785_;
								ValaSymbol* _tmp786_;
								ValaMethod* _tmp797_;
								ValaBlock* _tmp798_;
								ValaBlock* _tmp799_;
								_tmp782_ = vala_code_context_get_analyzer (context);
								_tmp783_ = _tmp782_;
								_tmp784_ = vala_semantic_analyzer_get_current_method (_tmp783_);
								_tmp785_ = _tmp784_;
								_tmp786_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp785_);
								sym = _tmp786_;
								while (TRUE) {
									ValaSymbol* _tmp787_;
									ValaMethod* _tmp788_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp789_;
									ValaMethod* _tmp790_;
									ValaMethod* _tmp791_;
									ValaSymbol* _tmp793_;
									ValaSymbol* _tmp794_;
									ValaSymbol* _tmp795_;
									ValaSymbol* _tmp796_;
									_tmp787_ = sym;
									_tmp788_ = async_method;
									if (!(_tmp787_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp788_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp789_ = sym;
									_tmp790_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp789_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp789_) : NULL);
									method = _tmp790_;
									_tmp791_ = method;
									if (_tmp791_ != NULL) {
										ValaMethod* _tmp792_;
										_tmp792_ = method;
										vala_method_set_closure (_tmp792_, TRUE);
									}
									_tmp793_ = sym;
									_tmp794_ = vala_symbol_get_parent_symbol (_tmp793_);
									_tmp795_ = _tmp794_;
									_tmp796_ = _vala_code_node_ref0 (_tmp795_);
									_vala_code_node_unref0 (sym);
									sym = _tmp796_;
									_vala_code_node_unref0 (method);
								}
								_tmp797_ = async_method;
								_tmp798_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp797_);
								_tmp799_ = _tmp798_;
								vala_block_set_captured (_tmp799_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp800_ = async_method;
							_tmp801_ = vala_method_get_callback_method (_tmp800_);
							_vala_code_node_unref0 (m);
							m = _tmp801_;
							_tmp802_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp802_);
							_tmp803_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp804_ = _tmp803_;
							_tmp805_ = _vala_code_node_ref0 (_tmp804_);
							_vala_code_node_unref0 (member);
							member = _tmp805_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp806_;
							ValaMethod* _tmp807_;
							ValaMethod* _tmp808_;
							_tmp806_ = m;
							_tmp807_ = vala_method_get_base_method (_tmp806_);
							_tmp808_ = _tmp807_;
							if (_tmp808_ != NULL) {
								ValaMethod* _tmp809_;
								ValaMethod* _tmp810_;
								ValaMethod* _tmp811_;
								ValaMethod* _tmp812_;
								ValaMethod* _tmp813_;
								ValaSignal* _tmp814_;
								ValaSignal* _tmp815_;
								ValaSymbol* _tmp820_;
								ValaSymbol* _tmp821_;
								ValaSymbol* _tmp822_;
								_tmp809_ = m;
								_tmp810_ = vala_method_get_base_method (_tmp809_);
								_tmp811_ = _tmp810_;
								_tmp812_ = _vala_code_node_ref0 (_tmp811_);
								_vala_code_node_unref0 (m);
								m = _tmp812_;
								_tmp813_ = m;
								_tmp814_ = vala_method_get_signal_reference (_tmp813_);
								_tmp815_ = _tmp814_;
								if (_tmp815_ != NULL) {
									ValaMethod* _tmp816_;
									ValaSignal* _tmp817_;
									ValaSignal* _tmp818_;
									_tmp816_ = m;
									_tmp817_ = vala_method_get_signal_reference (_tmp816_);
									_tmp818_ = _tmp817_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp818_);
								} else {
									ValaMethod* _tmp819_;
									_tmp819_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp819_);
								}
								_tmp820_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp821_ = _tmp820_;
								_tmp822_ = _vala_code_node_ref0 (_tmp821_);
								_vala_code_node_unref0 (member);
								member = _tmp822_;
							} else {
								ValaMethod* _tmp823_;
								ValaMethod* _tmp824_;
								ValaMethod* _tmp825_;
								_tmp823_ = m;
								_tmp824_ = vala_method_get_base_interface_method (_tmp823_);
								_tmp825_ = _tmp824_;
								if (_tmp825_ != NULL) {
									ValaMethod* _tmp826_;
									ValaMethod* _tmp827_;
									ValaMethod* _tmp828_;
									ValaMethod* _tmp829_;
									ValaMethod* _tmp830_;
									ValaSignal* _tmp831_;
									ValaSignal* _tmp832_;
									ValaSymbol* _tmp837_;
									ValaSymbol* _tmp838_;
									ValaSymbol* _tmp839_;
									_tmp826_ = m;
									_tmp827_ = vala_method_get_base_interface_method (_tmp826_);
									_tmp828_ = _tmp827_;
									_tmp829_ = _vala_code_node_ref0 (_tmp828_);
									_vala_code_node_unref0 (m);
									m = _tmp829_;
									_tmp830_ = m;
									_tmp831_ = vala_method_get_signal_reference (_tmp830_);
									_tmp832_ = _tmp831_;
									if (_tmp832_ != NULL) {
										ValaMethod* _tmp833_;
										ValaSignal* _tmp834_;
										ValaSignal* _tmp835_;
										_tmp833_ = m;
										_tmp834_ = vala_method_get_signal_reference (_tmp833_);
										_tmp835_ = _tmp834_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp835_);
									} else {
										ValaMethod* _tmp836_;
										_tmp836_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp836_);
									}
									_tmp837_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp838_ = _tmp837_;
									_tmp839_ = _vala_code_node_ref0 (_tmp838_);
									_vala_code_node_unref0 (member);
									member = _tmp839_;
								}
							}
						}
						_tmp840_ = m;
						_tmp841_ = vala_symbol_get_access ((ValaSymbol*) _tmp840_);
						_tmp842_ = _tmp841_;
						access = _tmp842_;
						_tmp843_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp843_, VALA_TYPE_CREATION_METHOD)) {
							ValaMethod* _tmp844_;
							ValaMemberBinding _tmp845_;
							ValaMemberBinding _tmp846_;
							_tmp844_ = m;
							_tmp845_ = vala_method_get_binding (_tmp844_);
							_tmp846_ = _tmp845_;
							instance = _tmp846_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp847_ = m;
						_tmp848_ = vala_method_get_binding (_tmp847_);
						_tmp849_ = _tmp848_;
						klass = _tmp849_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp850_;
							ValaList* _tmp851_;
							gint _param_size = 0;
							ValaList* _tmp852_;
							gint _tmp853_;
							gint _tmp854_;
							gint _param_index = 0;
							_tmp850_ = m;
							_tmp851_ = vala_callable_get_parameters ((ValaCallable*) _tmp850_);
							_param_list = _tmp851_;
							_tmp852_ = _param_list;
							_tmp853_ = vala_collection_get_size ((ValaCollection*) _tmp852_);
							_tmp854_ = _tmp853_;
							_param_size = _tmp854_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp855_;
								gpointer _tmp856_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp857_;
								ValaDataType* _tmp858_;
								ValaDataType* _tmp859_;
								ValaGenericType* _tmp860_;
								gboolean _tmp861_ = FALSE;
								ValaGenericType* _tmp862_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp855_ = _param_list;
								_tmp856_ = vala_list_get (_tmp855_, _param_index);
								param = (ValaParameter*) _tmp856_;
								_tmp857_ = param;
								_tmp858_ = vala_variable_get_variable_type ((ValaVariable*) _tmp857_);
								_tmp859_ = _tmp858_;
								_tmp860_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp859_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp859_) : NULL);
								generic_type = _tmp860_;
								_tmp862_ = generic_type;
								if (_tmp862_ != NULL) {
									ValaGenericType* _tmp863_;
									ValaTypeParameter* _tmp864_;
									ValaTypeParameter* _tmp865_;
									ValaSymbol* _tmp866_;
									ValaSymbol* _tmp867_;
									_tmp863_ = generic_type;
									_tmp864_ = vala_generic_type_get_type_parameter (_tmp863_);
									_tmp865_ = _tmp864_;
									_tmp866_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp865_);
									_tmp867_ = _tmp866_;
									_tmp861_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp867_, VALA_TYPE_TYPESYMBOL);
								} else {
									_tmp861_ = FALSE;
								}
								if (_tmp861_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp868_ = m;
						_tmp869_ = vala_callable_get_return_type ((ValaCallable*) _tmp868_);
						_tmp870_ = _tmp869_;
						_tmp871_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp870_, VALA_TYPE_GENERIC_TYPE) ? ((ValaGenericType*) _tmp870_) : NULL);
						generic_type = _tmp871_;
						_tmp873_ = generic_type;
						if (_tmp873_ != NULL) {
							ValaGenericType* _tmp874_;
							ValaTypeParameter* _tmp875_;
							ValaTypeParameter* _tmp876_;
							ValaSymbol* _tmp877_;
							ValaSymbol* _tmp878_;
							_tmp874_ = generic_type;
							_tmp875_ = vala_generic_type_get_type_parameter (_tmp874_);
							_tmp876_ = _tmp875_;
							_tmp877_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp876_);
							_tmp878_ = _tmp877_;
							_tmp872_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp878_, VALA_TYPE_TYPESYMBOL);
						} else {
							_tmp872_ = FALSE;
						}
						if (_tmp872_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp879_;
						_tmp879_ = member;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp879_, VALA_TYPE_PROPERTY)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp880_;
							ValaProperty* _tmp881_;
							ValaProperty* _tmp882_;
							ValaProperty* _tmp883_;
							ValaProperty* _tmp884_;
							ValaProperty* _tmp885_;
							ValaProperty* _tmp905_;
							ValaSymbolAccessibility _tmp906_;
							ValaSymbolAccessibility _tmp907_;
							gboolean _tmp908_;
							gboolean _tmp909_;
							ValaProperty* _tmp974_;
							ValaMemberBinding _tmp975_;
							ValaMemberBinding _tmp976_;
							ValaProperty* _tmp977_;
							ValaDataType* _tmp978_;
							ValaDataType* _tmp979_;
							_tmp880_ = member;
							_tmp881_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp880_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp881_;
							_tmp882_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp882_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp883_ = prop;
							_tmp884_ = vala_property_get_base_property (_tmp883_);
							_tmp885_ = _tmp884_;
							if (_tmp885_ != NULL) {
								ValaProperty* _tmp886_;
								ValaProperty* _tmp887_;
								ValaProperty* _tmp888_;
								ValaProperty* _tmp889_;
								ValaProperty* _tmp890_;
								ValaSymbol* _tmp891_;
								ValaSymbol* _tmp892_;
								ValaSymbol* _tmp893_;
								_tmp886_ = prop;
								_tmp887_ = vala_property_get_base_property (_tmp886_);
								_tmp888_ = _tmp887_;
								_tmp889_ = _vala_code_node_ref0 (_tmp888_);
								_vala_code_node_unref0 (prop);
								prop = _tmp889_;
								_tmp890_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp890_);
								_tmp891_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp892_ = _tmp891_;
								_tmp893_ = _vala_code_node_ref0 (_tmp892_);
								_vala_code_node_unref0 (member);
								member = _tmp893_;
							} else {
								ValaProperty* _tmp894_;
								ValaProperty* _tmp895_;
								ValaProperty* _tmp896_;
								_tmp894_ = prop;
								_tmp895_ = vala_property_get_base_interface_property (_tmp894_);
								_tmp896_ = _tmp895_;
								if (_tmp896_ != NULL) {
									ValaProperty* _tmp897_;
									ValaProperty* _tmp898_;
									ValaProperty* _tmp899_;
									ValaProperty* _tmp900_;
									ValaProperty* _tmp901_;
									ValaSymbol* _tmp902_;
									ValaSymbol* _tmp903_;
									ValaSymbol* _tmp904_;
									_tmp897_ = prop;
									_tmp898_ = vala_property_get_base_interface_property (_tmp897_);
									_tmp899_ = _tmp898_;
									_tmp900_ = _vala_code_node_ref0 (_tmp899_);
									_vala_code_node_unref0 (prop);
									prop = _tmp900_;
									_tmp901_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp901_);
									_tmp902_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp903_ = _tmp902_;
									_tmp904_ = _vala_code_node_ref0 (_tmp903_);
									_vala_code_node_unref0 (member);
									member = _tmp904_;
								}
							}
							_tmp905_ = prop;
							_tmp906_ = vala_symbol_get_access ((ValaSymbol*) _tmp905_);
							_tmp907_ = _tmp906_;
							access = _tmp907_;
							_tmp908_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp909_ = _tmp908_;
							if (_tmp909_) {
								ValaProperty* _tmp910_;
								ValaPropertyAccessor* _tmp911_;
								ValaPropertyAccessor* _tmp912_;
								ValaProperty* _tmp920_;
								ValaSymbolAccessibility _tmp921_;
								ValaSymbolAccessibility _tmp922_;
								_tmp910_ = prop;
								_tmp911_ = vala_property_get_set_accessor (_tmp910_);
								_tmp912_ = _tmp911_;
								if (_tmp912_ == NULL) {
									ValaSourceReference* _tmp913_;
									ValaSourceReference* _tmp914_;
									ValaProperty* _tmp915_;
									gchar* _tmp916_;
									gchar* _tmp917_;
									gchar* _tmp918_;
									gchar* _tmp919_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp913_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp914_ = _tmp913_;
									_tmp915_ = prop;
									_tmp916_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp915_);
									_tmp917_ = _tmp916_;
									_tmp918_ = g_strdup_printf ("Property `%s' is read-only", _tmp917_);
									_tmp919_ = _tmp918_;
									vala_report_error (_tmp914_, _tmp919_);
									_g_free0 (_tmp919_);
									_g_free0 (_tmp917_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp920_ = prop;
								_tmp921_ = vala_symbol_get_access ((ValaSymbol*) _tmp920_);
								_tmp922_ = _tmp921_;
								if (_tmp922_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp923_;
									ValaPropertyAccessor* _tmp924_;
									ValaPropertyAccessor* _tmp925_;
									ValaSymbolAccessibility _tmp926_;
									ValaSymbolAccessibility _tmp927_;
									_tmp923_ = prop;
									_tmp924_ = vala_property_get_set_accessor (_tmp923_);
									_tmp925_ = _tmp924_;
									_tmp926_ = vala_symbol_get_access ((ValaSymbol*) _tmp925_);
									_tmp927_ = _tmp926_;
									access = _tmp927_;
								} else {
									gboolean _tmp928_ = FALSE;
									ValaProperty* _tmp929_;
									ValaSymbolAccessibility _tmp930_;
									ValaSymbolAccessibility _tmp931_;
									_tmp929_ = prop;
									_tmp930_ = vala_symbol_get_access ((ValaSymbol*) _tmp929_);
									_tmp931_ = _tmp930_;
									if (_tmp931_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp932_;
										ValaPropertyAccessor* _tmp933_;
										ValaPropertyAccessor* _tmp934_;
										ValaSymbolAccessibility _tmp935_;
										ValaSymbolAccessibility _tmp936_;
										_tmp932_ = prop;
										_tmp933_ = vala_property_get_set_accessor (_tmp932_);
										_tmp934_ = _tmp933_;
										_tmp935_ = vala_symbol_get_access ((ValaSymbol*) _tmp934_);
										_tmp936_ = _tmp935_;
										_tmp928_ = _tmp936_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp928_ = FALSE;
									}
									if (_tmp928_) {
										ValaProperty* _tmp937_;
										ValaPropertyAccessor* _tmp938_;
										ValaPropertyAccessor* _tmp939_;
										ValaSymbolAccessibility _tmp940_;
										ValaSymbolAccessibility _tmp941_;
										_tmp937_ = prop;
										_tmp938_ = vala_property_get_set_accessor (_tmp937_);
										_tmp939_ = _tmp938_;
										_tmp940_ = vala_symbol_get_access ((ValaSymbol*) _tmp939_);
										_tmp941_ = _tmp940_;
										access = _tmp941_;
									}
								}
							} else {
								ValaProperty* _tmp942_;
								ValaPropertyAccessor* _tmp943_;
								ValaPropertyAccessor* _tmp944_;
								ValaProperty* _tmp952_;
								ValaSymbolAccessibility _tmp953_;
								ValaSymbolAccessibility _tmp954_;
								_tmp942_ = prop;
								_tmp943_ = vala_property_get_get_accessor (_tmp942_);
								_tmp944_ = _tmp943_;
								if (_tmp944_ == NULL) {
									ValaSourceReference* _tmp945_;
									ValaSourceReference* _tmp946_;
									ValaProperty* _tmp947_;
									gchar* _tmp948_;
									gchar* _tmp949_;
									gchar* _tmp950_;
									gchar* _tmp951_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp945_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp946_ = _tmp945_;
									_tmp947_ = prop;
									_tmp948_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp947_);
									_tmp949_ = _tmp948_;
									_tmp950_ = g_strdup_printf ("Property `%s' is write-only", _tmp949_);
									_tmp951_ = _tmp950_;
									vala_report_error (_tmp946_, _tmp951_);
									_g_free0 (_tmp951_);
									_g_free0 (_tmp949_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp952_ = prop;
								_tmp953_ = vala_symbol_get_access ((ValaSymbol*) _tmp952_);
								_tmp954_ = _tmp953_;
								if (_tmp954_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp955_;
									ValaPropertyAccessor* _tmp956_;
									ValaPropertyAccessor* _tmp957_;
									ValaSymbolAccessibility _tmp958_;
									ValaSymbolAccessibility _tmp959_;
									_tmp955_ = prop;
									_tmp956_ = vala_property_get_get_accessor (_tmp955_);
									_tmp957_ = _tmp956_;
									_tmp958_ = vala_symbol_get_access ((ValaSymbol*) _tmp957_);
									_tmp959_ = _tmp958_;
									access = _tmp959_;
								} else {
									gboolean _tmp960_ = FALSE;
									ValaProperty* _tmp961_;
									ValaSymbolAccessibility _tmp962_;
									ValaSymbolAccessibility _tmp963_;
									_tmp961_ = prop;
									_tmp962_ = vala_symbol_get_access ((ValaSymbol*) _tmp961_);
									_tmp963_ = _tmp962_;
									if (_tmp963_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp964_;
										ValaPropertyAccessor* _tmp965_;
										ValaPropertyAccessor* _tmp966_;
										ValaSymbolAccessibility _tmp967_;
										ValaSymbolAccessibility _tmp968_;
										_tmp964_ = prop;
										_tmp965_ = vala_property_get_get_accessor (_tmp964_);
										_tmp966_ = _tmp965_;
										_tmp967_ = vala_symbol_get_access ((ValaSymbol*) _tmp966_);
										_tmp968_ = _tmp967_;
										_tmp960_ = _tmp968_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp960_ = FALSE;
									}
									if (_tmp960_) {
										ValaProperty* _tmp969_;
										ValaPropertyAccessor* _tmp970_;
										ValaPropertyAccessor* _tmp971_;
										ValaSymbolAccessibility _tmp972_;
										ValaSymbolAccessibility _tmp973_;
										_tmp969_ = prop;
										_tmp970_ = vala_property_get_get_accessor (_tmp969_);
										_tmp971_ = _tmp970_;
										_tmp972_ = vala_symbol_get_access ((ValaSymbol*) _tmp971_);
										_tmp973_ = _tmp972_;
										access = _tmp973_;
									}
								}
							}
							_tmp974_ = prop;
							_tmp975_ = vala_property_get_binding (_tmp974_);
							_tmp976_ = _tmp975_;
							instance = _tmp976_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp977_ = prop;
							_tmp978_ = vala_property_get_property_type (_tmp977_);
							_tmp979_ = _tmp978_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp979_, VALA_TYPE_GENERIC_TYPE)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp980_;
							_tmp980_ = member;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp980_, VALA_TYPE_SIGNAL)) {
								ValaSymbol* _tmp981_;
								ValaSymbolAccessibility _tmp982_;
								ValaSymbolAccessibility _tmp983_;
								instance = TRUE;
								_tmp981_ = member;
								_tmp982_ = vala_symbol_get_access (_tmp981_);
								_tmp983_ = _tmp982_;
								access = _tmp983_;
							} else {
								gboolean _tmp984_ = FALSE;
								gboolean _tmp985_;
								_tmp985_ = self->priv->_creation_member;
								if (!_tmp985_) {
									ValaSymbol* _tmp986_;
									_tmp986_ = member;
									_tmp984_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp986_, VALA_TYPE_ERROR_CODE);
								} else {
									_tmp984_ = FALSE;
								}
								if (_tmp984_) {
									ValaSymbol* _tmp987_;
									ValaConstant* _tmp988_;
									ValaConstant* _tmp989_;
									ValaSymbol* _tmp990_;
									ValaSymbol* _tmp991_;
									ValaSymbol* _tmp992_;
									_tmp987_ = member;
									_tmp988_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp987_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp989_ = _tmp988_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp989_);
									_tmp990_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp991_ = _tmp990_;
									_tmp992_ = _vala_code_node_ref0 (_tmp991_);
									_vala_code_node_unref0 (member);
									member = _tmp992_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp993_ = member;
	vala_symbol_set_used (_tmp993_, TRUE);
	_tmp994_ = member;
	_tmp995_ = vala_symbol_get_version (_tmp994_);
	_tmp996_ = _tmp995_;
	_tmp997_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp998_ = _tmp997_;
	vala_version_attribute_check (_tmp996_, _tmp998_);
	_tmp1000_ = access;
	if (_tmp1000_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1001_;
		ValaSymbol* _tmp1002_;
		ValaSymbol* _tmp1003_;
		_tmp1001_ = member;
		_tmp1002_ = vala_symbol_get_parent_symbol (_tmp1001_);
		_tmp1003_ = _tmp1002_;
		_tmp999_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1003_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp999_ = FALSE;
	}
	if (_tmp999_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1004_;
		ValaSymbol* _tmp1005_;
		ValaSymbol* _tmp1006_;
		ValaTypeSymbol* _tmp1007_;
		gboolean in_subtype = FALSE;
		_tmp1004_ = member;
		_tmp1005_ = vala_symbol_get_parent_symbol (_tmp1004_);
		_tmp1006_ = _tmp1005_;
		_tmp1007_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1006_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1007_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1008_;
			ValaSemanticAnalyzer* _tmp1009_;
			ValaSymbol* _tmp1010_;
			ValaSymbol* _tmp1011_;
			ValaSymbol* _tmp1012_;
			_tmp1008_ = vala_code_context_get_analyzer (context);
			_tmp1009_ = _tmp1008_;
			_tmp1010_ = vala_semantic_analyzer_get_current_symbol (_tmp1009_);
			_tmp1011_ = _tmp1010_;
			_tmp1012_ = _vala_code_node_ref0 (_tmp1011_);
			this_symbol = _tmp1012_;
			{
				gboolean _tmp1013_ = FALSE;
				_tmp1013_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1018_;
					ValaSymbol* _tmp1019_;
					ValaTypeSymbol* _tmp1020_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1021_;
					ValaClass* _tmp1022_;
					gboolean _tmp1023_ = FALSE;
					ValaClass* _tmp1024_;
					if (!_tmp1013_) {
						ValaSymbol* _tmp1014_;
						ValaSymbol* _tmp1015_;
						ValaSymbol* _tmp1016_;
						ValaSymbol* _tmp1017_;
						_tmp1014_ = this_symbol;
						_tmp1015_ = vala_symbol_get_parent_symbol (_tmp1014_);
						_tmp1016_ = _tmp1015_;
						_tmp1017_ = _vala_code_node_ref0 (_tmp1016_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1017_;
					}
					_tmp1013_ = FALSE;
					_tmp1018_ = this_symbol;
					if (!(_tmp1018_ != NULL)) {
						break;
					}
					_tmp1019_ = this_symbol;
					_tmp1020_ = target_type;
					if (_tmp1019_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1020_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1021_ = this_symbol;
					_tmp1022_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1021_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1021_) : NULL);
					cl = _tmp1022_;
					_tmp1024_ = cl;
					if (_tmp1024_ != NULL) {
						ValaClass* _tmp1025_;
						ValaTypeSymbol* _tmp1026_;
						_tmp1025_ = cl;
						_tmp1026_ = target_type;
						_tmp1023_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1025_, _tmp1026_);
					} else {
						_tmp1023_ = FALSE;
					}
					if (_tmp1023_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1027_;
			ValaSourceReference* _tmp1028_;
			ValaSymbol* _tmp1029_;
			gchar* _tmp1030_;
			gchar* _tmp1031_;
			gchar* _tmp1032_;
			gchar* _tmp1033_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1027_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1028_ = _tmp1027_;
			_tmp1029_ = member;
			_tmp1030_ = vala_symbol_get_full_name (_tmp1029_);
			_tmp1031_ = _tmp1030_;
			_tmp1032_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1031_);
			_tmp1033_ = _tmp1032_;
			vala_report_error (_tmp1028_, _tmp1033_);
			_g_free0 (_tmp1033_);
			_g_free0 (_tmp1031_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1034_;
		_tmp1034_ = access;
		if (_tmp1034_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1035_;
			ValaSymbol* _tmp1036_;
			ValaSymbol* _tmp1037_;
			ValaSymbol* _tmp1038_;
			gboolean in_target_type = FALSE;
			_tmp1035_ = member;
			_tmp1036_ = vala_symbol_get_parent_symbol (_tmp1035_);
			_tmp1037_ = _tmp1036_;
			_tmp1038_ = _vala_code_node_ref0 (_tmp1037_);
			target_type = _tmp1038_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1039_;
				ValaSemanticAnalyzer* _tmp1040_;
				ValaSymbol* _tmp1041_;
				ValaSymbol* _tmp1042_;
				ValaSymbol* _tmp1043_;
				_tmp1039_ = vala_code_context_get_analyzer (context);
				_tmp1040_ = _tmp1039_;
				_tmp1041_ = vala_semantic_analyzer_get_current_symbol (_tmp1040_);
				_tmp1042_ = _tmp1041_;
				_tmp1043_ = _vala_code_node_ref0 (_tmp1042_);
				this_symbol = _tmp1043_;
				{
					gboolean _tmp1044_ = FALSE;
					_tmp1044_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1049_;
						ValaSymbol* _tmp1050_;
						ValaSymbol* _tmp1051_;
						if (!_tmp1044_) {
							ValaSymbol* _tmp1045_;
							ValaSymbol* _tmp1046_;
							ValaSymbol* _tmp1047_;
							ValaSymbol* _tmp1048_;
							_tmp1045_ = this_symbol;
							_tmp1046_ = vala_symbol_get_parent_symbol (_tmp1045_);
							_tmp1047_ = _tmp1046_;
							_tmp1048_ = _vala_code_node_ref0 (_tmp1047_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1048_;
						}
						_tmp1044_ = FALSE;
						_tmp1049_ = this_symbol;
						if (!(_tmp1049_ != NULL)) {
							break;
						}
						_tmp1050_ = target_type;
						_tmp1051_ = this_symbol;
						if (_tmp1050_ == _tmp1051_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1052_;
				ValaSourceReference* _tmp1053_;
				ValaSymbol* _tmp1054_;
				gchar* _tmp1055_;
				gchar* _tmp1056_;
				gchar* _tmp1057_;
				gchar* _tmp1058_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1052_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1053_ = _tmp1052_;
				_tmp1054_ = member;
				_tmp1055_ = vala_symbol_get_full_name (_tmp1054_);
				_tmp1056_ = _tmp1055_;
				_tmp1057_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1056_);
				_tmp1058_ = _tmp1057_;
				vala_report_error (_tmp1053_, _tmp1058_);
				_g_free0 (_tmp1058_);
				_g_free0 (_tmp1056_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	if (generics) {
		ValaExpression* _tmp1060_;
		ValaExpression* _tmp1061_;
		_tmp1060_ = vala_member_access_get_inner (self);
		_tmp1061_ = _tmp1060_;
		_tmp1059_ = _tmp1061_ != NULL;
	} else {
		_tmp1059_ = FALSE;
	}
	if (_tmp1059_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1062_;
		ValaExpression* _tmp1063_;
		ValaDataType* _tmp1064_;
		ValaDataType* _tmp1065_;
		ValaDataType* _tmp1066_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1067_;
		ValaExpression* _tmp1068_;
		ValaDataType* _tmp1069_;
		ValaDataType* _tmp1070_;
		ValaPointerType* _tmp1071_;
		ValaPointerType* _tmp1072_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1077_;
		ValaObjectType* _tmp1078_;
		gboolean _tmp1079_ = FALSE;
		gboolean _tmp1080_ = FALSE;
		ValaObjectType* _tmp1081_;
		_tmp1062_ = vala_member_access_get_inner (self);
		_tmp1063_ = _tmp1062_;
		_tmp1064_ = vala_expression_get_value_type (_tmp1063_);
		_tmp1065_ = _tmp1064_;
		_tmp1066_ = _vala_code_node_ref0 (_tmp1065_);
		instance_type = _tmp1066_;
		_tmp1067_ = vala_member_access_get_inner (self);
		_tmp1068_ = _tmp1067_;
		_tmp1069_ = vala_expression_get_value_type (_tmp1068_);
		_tmp1070_ = _tmp1069_;
		_tmp1071_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1070_, VALA_TYPE_POINTER_TYPE) ? ((ValaPointerType*) _tmp1070_) : NULL);
		pointer_type = _tmp1071_;
		_tmp1072_ = pointer_type;
		if (_tmp1072_ != NULL) {
			ValaPointerType* _tmp1073_;
			ValaDataType* _tmp1074_;
			ValaDataType* _tmp1075_;
			ValaDataType* _tmp1076_;
			_tmp1073_ = pointer_type;
			_tmp1074_ = vala_pointer_type_get_base_type (_tmp1073_);
			_tmp1075_ = _tmp1074_;
			_tmp1076_ = _vala_code_node_ref0 (_tmp1075_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1076_;
		}
		_tmp1077_ = instance_type;
		_tmp1078_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1077_, VALA_TYPE_OBJECT_TYPE) ? ((ValaObjectType*) _tmp1077_) : NULL);
		object_type = _tmp1078_;
		_tmp1081_ = object_type;
		if (_tmp1081_ != NULL) {
			ValaObjectType* _tmp1082_;
			ValaObjectTypeSymbol* _tmp1083_;
			ValaObjectTypeSymbol* _tmp1084_;
			_tmp1082_ = object_type;
			_tmp1083_ = vala_object_type_get_type_symbol (_tmp1082_);
			_tmp1084_ = _tmp1083_;
			_tmp1080_ = vala_object_type_symbol_has_type_parameters (_tmp1084_);
		} else {
			_tmp1080_ = FALSE;
		}
		if (_tmp1080_) {
			ValaDataType* _tmp1085_;
			_tmp1085_ = instance_type;
			_tmp1079_ = !vala_data_type_has_type_arguments (_tmp1085_);
		} else {
			_tmp1079_ = FALSE;
		}
		if (_tmp1079_) {
			ValaExpression* _tmp1086_;
			ValaExpression* _tmp1087_;
			ValaSourceReference* _tmp1088_;
			ValaSourceReference* _tmp1089_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1086_ = vala_member_access_get_inner (self);
			_tmp1087_ = _tmp1086_;
			_tmp1088_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1087_);
			_tmp1089_ = _tmp1088_;
			vala_report_error (_tmp1089_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	if (instance) {
		_tmp1091_ = !may_access_instance_members;
	} else {
		_tmp1091_ = FALSE;
	}
	if (_tmp1091_) {
		_tmp1090_ = TRUE;
	} else {
		gboolean _tmp1092_ = FALSE;
		if (klass) {
			_tmp1092_ = !may_access_klass_members;
		} else {
			_tmp1092_ = FALSE;
		}
		_tmp1090_ = _tmp1092_;
	}
	if (_tmp1090_) {
		ValaSymbol* _tmp1093_;
		ValaSymbol* _tmp1094_;
		ValaDataType* _tmp1117_;
		ValaDataType* _tmp1118_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1093_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1094_ = _tmp1093_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1094_, VALA_TYPE_METHOD)) {
			ValaSemanticAnalyzer* _tmp1095_;
			ValaSemanticAnalyzer* _tmp1096_;
			ValaSymbol* _tmp1097_;
			ValaSymbol* _tmp1098_;
			gboolean _tmp1099_;
			gboolean _tmp1100_;
			ValaDataType* _tmp1101_;
			ValaDataType* _tmp1102_;
			_tmp1095_ = vala_code_context_get_analyzer (context);
			_tmp1096_ = _tmp1095_;
			_tmp1097_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1098_ = _tmp1097_;
			_tmp1099_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1100_ = _tmp1099_;
			_tmp1101_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1096_, _tmp1098_, _tmp1100_);
			_tmp1102_ = _tmp1101_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1102_);
			_vala_code_node_unref0 (_tmp1102_);
		} else {
			ValaSymbol* _tmp1103_;
			ValaSymbol* _tmp1104_;
			_tmp1103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1104_ = _tmp1103_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1104_, VALA_TYPE_FIELD)) {
				ValaSymbol* _tmp1105_;
				ValaSymbol* _tmp1106_;
				ValaFieldPrototype* _tmp1107_;
				ValaFieldPrototype* _tmp1108_;
				_tmp1105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1106_ = _tmp1105_;
				_tmp1107_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1106_, VALA_TYPE_FIELD, ValaField));
				_tmp1108_ = _tmp1107_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1108_);
				_vala_code_node_unref0 (_tmp1108_);
			} else {
				ValaSymbol* _tmp1109_;
				ValaSymbol* _tmp1110_;
				_tmp1109_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1110_ = _tmp1109_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1110_, VALA_TYPE_PROPERTY)) {
					ValaSymbol* _tmp1111_;
					ValaSymbol* _tmp1112_;
					ValaPropertyPrototype* _tmp1113_;
					ValaPropertyPrototype* _tmp1114_;
					_tmp1111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1112_ = _tmp1111_;
					_tmp1113_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1112_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1114_ = _tmp1113_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1114_);
					_vala_code_node_unref0 (_tmp1114_);
				} else {
					ValaInvalidType* _tmp1115_;
					ValaInvalidType* _tmp1116_;
					_tmp1115_ = vala_invalid_type_new ();
					_tmp1116_ = _tmp1115_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1116_);
					_vala_code_node_unref0 (_tmp1116_);
				}
			}
		}
		_tmp1117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1118_ = _tmp1117_;
		if (_tmp1118_ != NULL) {
			ValaDataType* _tmp1119_;
			ValaDataType* _tmp1120_;
			ValaDataType* _tmp1121_;
			ValaDataType* _tmp1122_;
			gboolean _tmp1123_;
			gboolean _tmp1124_;
			_tmp1119_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1120_ = _tmp1119_;
			_tmp1121_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1122_ = _tmp1121_;
			_tmp1123_ = vala_data_type_get_value_owned (_tmp1122_);
			_tmp1124_ = _tmp1123_;
			vala_data_type_set_value_owned (_tmp1120_, _tmp1124_);
		}
	} else {
		gboolean _tmp1125_ = FALSE;
		gboolean _tmp1146_ = FALSE;
		gboolean _tmp1147_ = FALSE;
		gboolean _tmp1148_ = FALSE;
		gboolean _tmp1149_ = FALSE;
		gboolean _tmp1166_ = FALSE;
		gboolean _tmp1167_ = FALSE;
		gboolean _tmp1168_ = FALSE;
		gboolean _tmp1169_ = FALSE;
		gboolean _tmp1170_ = FALSE;
		gboolean _tmp1171_;
		gboolean _tmp1172_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1199_;
		ValaSymbol* _tmp1200_;
		ValaMethod* _tmp1201_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1202_;
		ValaExpression* _tmp1203_;
		ValaMemberAccess* _tmp1204_;
		gboolean _tmp1205_ = FALSE;
		gboolean _tmp1206_ = FALSE;
		gboolean _tmp1207_ = FALSE;
		gboolean _tmp1208_ = FALSE;
		gboolean _tmp1209_ = FALSE;
		ValaMethod* _tmp1210_;
		ValaSemanticAnalyzer* _tmp1247_;
		ValaSemanticAnalyzer* _tmp1248_;
		ValaSymbol* _tmp1249_;
		ValaSymbol* _tmp1250_;
		gboolean _tmp1251_;
		gboolean _tmp1252_;
		ValaDataType* _tmp1253_;
		ValaDataType* _tmp1254_;
		gboolean _tmp1255_ = FALSE;
		ValaExpression* _tmp1256_;
		ValaExpression* _tmp1257_;
		ValaSymbol* _tmp1270_;
		ValaSymbol* _tmp1271_;
		if (instance) {
			ValaExpression* _tmp1126_;
			ValaExpression* _tmp1127_;
			_tmp1126_ = vala_member_access_get_inner (self);
			_tmp1127_ = _tmp1126_;
			_tmp1125_ = _tmp1127_ == NULL;
		} else {
			_tmp1125_ = FALSE;
		}
		if (_tmp1125_) {
			ValaSourceReference* _tmp1128_;
			ValaSourceReference* _tmp1129_;
			ValaMemberAccess* _tmp1130_;
			ValaMemberAccess* _tmp1131_;
			ValaExpression* _tmp1132_;
			ValaExpression* _tmp1133_;
			ValaParameter* _tmp1134_;
			ValaDataType* _tmp1135_;
			ValaDataType* _tmp1136_;
			ValaDataType* _tmp1137_;
			ValaDataType* _tmp1138_;
			ValaExpression* _tmp1139_;
			ValaExpression* _tmp1140_;
			ValaDataType* _tmp1141_;
			ValaDataType* _tmp1142_;
			ValaExpression* _tmp1143_;
			ValaExpression* _tmp1144_;
			ValaParameter* _tmp1145_;
			_tmp1128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1129_ = _tmp1128_;
			_tmp1130_ = vala_member_access_new (NULL, "this", _tmp1129_);
			_tmp1131_ = _tmp1130_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1131_);
			_vala_code_node_unref0 (_tmp1131_);
			_tmp1132_ = vala_member_access_get_inner (self);
			_tmp1133_ = _tmp1132_;
			_tmp1134_ = this_parameter;
			_tmp1135_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1134_);
			_tmp1136_ = _tmp1135_;
			_tmp1137_ = vala_data_type_copy (_tmp1136_);
			_tmp1138_ = _tmp1137_;
			vala_expression_set_value_type (_tmp1133_, _tmp1138_);
			_vala_code_node_unref0 (_tmp1138_);
			_tmp1139_ = vala_member_access_get_inner (self);
			_tmp1140_ = _tmp1139_;
			_tmp1141_ = vala_expression_get_value_type (_tmp1140_);
			_tmp1142_ = _tmp1141_;
			vala_data_type_set_value_owned (_tmp1142_, FALSE);
			_tmp1143_ = vala_member_access_get_inner (self);
			_tmp1144_ = _tmp1143_;
			_tmp1145_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1144_, (ValaSymbol*) _tmp1145_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1149_ = !klass;
		} else {
			_tmp1149_ = FALSE;
		}
		if (_tmp1149_) {
			ValaSymbol* _tmp1150_;
			ValaSymbol* _tmp1151_;
			_tmp1150_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1151_ = _tmp1150_;
			_tmp1148_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1151_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp1148_ = FALSE;
		}
		if (_tmp1148_) {
			_tmp1147_ = may_access_instance_members;
		} else {
			_tmp1147_ = FALSE;
		}
		if (_tmp1147_) {
			ValaExpression* _tmp1152_;
			ValaExpression* _tmp1153_;
			_tmp1152_ = vala_member_access_get_inner (self);
			_tmp1153_ = _tmp1152_;
			_tmp1146_ = _tmp1153_ != NULL;
		} else {
			_tmp1146_ = FALSE;
		}
		if (_tmp1146_) {
			ValaExpression* _tmp1154_;
			ValaExpression* _tmp1155_;
			ValaSymbol* _tmp1156_;
			ValaSymbol* _tmp1157_;
			_tmp1154_ = vala_member_access_get_inner (self);
			_tmp1155_ = _tmp1154_;
			_tmp1156_ = vala_expression_get_symbol_reference (_tmp1155_);
			_tmp1157_ = _tmp1156_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1157_, VALA_TYPE_METHOD)) {
			} else {
				ValaSourceReference* _tmp1158_;
				ValaSourceReference* _tmp1159_;
				ValaSymbol* _tmp1160_;
				ValaSymbol* _tmp1161_;
				gchar* _tmp1162_;
				gchar* _tmp1163_;
				gchar* _tmp1164_;
				gchar* _tmp1165_;
				_tmp1158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1159_ = _tmp1158_;
				_tmp1160_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1161_ = _tmp1160_;
				_tmp1162_ = vala_symbol_get_full_name (_tmp1161_);
				_tmp1163_ = _tmp1162_;
				_tmp1164_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1163_);
				_tmp1165_ = _tmp1164_;
				vala_report_warning (_tmp1159_, _tmp1165_);
				_g_free0 (_tmp1165_);
				_g_free0 (_tmp1163_);
			}
		}
		_tmp1171_ = vala_code_context_get_experimental_non_null (context);
		_tmp1172_ = _tmp1171_;
		if (_tmp1172_) {
			_tmp1170_ = instance;
		} else {
			_tmp1170_ = FALSE;
		}
		if (_tmp1170_) {
			ValaExpression* _tmp1173_;
			ValaExpression* _tmp1174_;
			ValaDataType* _tmp1175_;
			ValaDataType* _tmp1176_;
			gboolean _tmp1177_;
			gboolean _tmp1178_;
			_tmp1173_ = vala_member_access_get_inner (self);
			_tmp1174_ = _tmp1173_;
			_tmp1175_ = vala_expression_get_value_type (_tmp1174_);
			_tmp1176_ = _tmp1175_;
			_tmp1177_ = vala_data_type_get_nullable (_tmp1176_);
			_tmp1178_ = _tmp1177_;
			_tmp1169_ = _tmp1178_;
		} else {
			_tmp1169_ = FALSE;
		}
		if (_tmp1169_) {
			ValaExpression* _tmp1179_;
			ValaExpression* _tmp1180_;
			ValaDataType* _tmp1181_;
			ValaDataType* _tmp1182_;
			_tmp1179_ = vala_member_access_get_inner (self);
			_tmp1180_ = _tmp1179_;
			_tmp1181_ = vala_expression_get_value_type (_tmp1180_);
			_tmp1182_ = _tmp1181_;
			_tmp1168_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1182_, VALA_TYPE_POINTER_TYPE);
		} else {
			_tmp1168_ = FALSE;
		}
		if (_tmp1168_) {
			ValaExpression* _tmp1183_;
			ValaExpression* _tmp1184_;
			ValaDataType* _tmp1185_;
			ValaDataType* _tmp1186_;
			_tmp1183_ = vala_member_access_get_inner (self);
			_tmp1184_ = _tmp1183_;
			_tmp1185_ = vala_expression_get_value_type (_tmp1184_);
			_tmp1186_ = _tmp1185_;
			_tmp1167_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1186_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1167_ = FALSE;
		}
		if (_tmp1167_) {
			ValaExpression* _tmp1187_;
			ValaExpression* _tmp1188_;
			ValaDataType* _tmp1189_;
			ValaDataType* _tmp1190_;
			_tmp1187_ = vala_member_access_get_inner (self);
			_tmp1188_ = _tmp1187_;
			_tmp1189_ = vala_expression_get_value_type (_tmp1188_);
			_tmp1190_ = _tmp1189_;
			_tmp1166_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1190_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp1166_ = FALSE;
		}
		if (_tmp1166_) {
			ValaSourceReference* _tmp1191_;
			ValaSourceReference* _tmp1192_;
			ValaSymbol* _tmp1193_;
			ValaSymbol* _tmp1194_;
			gchar* _tmp1195_;
			gchar* _tmp1196_;
			gchar* _tmp1197_;
			gchar* _tmp1198_;
			_tmp1191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1192_ = _tmp1191_;
			_tmp1193_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1194_ = _tmp1193_;
			_tmp1195_ = vala_symbol_get_full_name (_tmp1194_);
			_tmp1196_ = _tmp1195_;
			_tmp1197_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1196_);
			_tmp1198_ = _tmp1197_;
			vala_report_error (_tmp1192_, _tmp1198_);
			_g_free0 (_tmp1198_);
			_g_free0 (_tmp1196_);
		}
		_tmp1199_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1200_ = _tmp1199_;
		_tmp1201_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1200_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp1200_) : NULL);
		m = _tmp1201_;
		_tmp1202_ = vala_member_access_get_inner (self);
		_tmp1203_ = _tmp1202_;
		_tmp1204_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1203_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp1203_) : NULL);
		inner_ma = _tmp1204_;
		_tmp1210_ = m;
		if (_tmp1210_ != NULL) {
			ValaMethod* _tmp1211_;
			ValaMemberBinding _tmp1212_;
			ValaMemberBinding _tmp1213_;
			_tmp1211_ = m;
			_tmp1212_ = vala_method_get_binding (_tmp1211_);
			_tmp1213_ = _tmp1212_;
			_tmp1209_ = _tmp1213_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1209_ = FALSE;
		}
		if (_tmp1209_) {
			ValaMethod* _tmp1214_;
			ValaSymbol* _tmp1215_;
			ValaSymbol* _tmp1216_;
			_tmp1214_ = m;
			_tmp1215_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1214_);
			_tmp1216_ = _tmp1215_;
			_tmp1208_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1216_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
		} else {
			_tmp1208_ = FALSE;
		}
		if (_tmp1208_) {
			ValaExpression* _tmp1217_;
			ValaExpression* _tmp1218_;
			_tmp1217_ = vala_member_access_get_inner (self);
			_tmp1218_ = _tmp1217_;
			_tmp1207_ = _tmp1218_ != NULL;
		} else {
			_tmp1207_ = FALSE;
		}
		if (_tmp1207_) {
			ValaExpression* _tmp1219_;
			ValaExpression* _tmp1220_;
			ValaDataType* _tmp1221_;
			ValaDataType* _tmp1222_;
			_tmp1219_ = vala_member_access_get_inner (self);
			_tmp1220_ = _tmp1219_;
			_tmp1221_ = vala_expression_get_value_type (_tmp1220_);
			_tmp1222_ = _tmp1221_;
			_tmp1206_ = _tmp1222_ == NULL;
		} else {
			_tmp1206_ = FALSE;
		}
		if (_tmp1206_) {
			ValaMemberAccess* _tmp1223_;
			ValaList* _tmp1224_;
			gint _tmp1225_;
			gint _tmp1226_;
			_tmp1223_ = inner_ma;
			_tmp1224_ = _tmp1223_->priv->type_argument_list;
			_tmp1225_ = vala_collection_get_size ((ValaCollection*) _tmp1224_);
			_tmp1226_ = _tmp1225_;
			_tmp1205_ = _tmp1226_ > 0;
		} else {
			_tmp1205_ = FALSE;
		}
		if (_tmp1205_) {
			ValaExpression* _tmp1227_;
			ValaExpression* _tmp1228_;
			ValaMethod* _tmp1229_;
			ValaSymbol* _tmp1230_;
			ValaSymbol* _tmp1231_;
			ValaObjectType* _tmp1232_;
			ValaObjectType* _tmp1233_;
			_tmp1227_ = vala_member_access_get_inner (self);
			_tmp1228_ = _tmp1227_;
			_tmp1229_ = m;
			_tmp1230_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1229_);
			_tmp1231_ = _tmp1230_;
			_tmp1232_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1231_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1233_ = _tmp1232_;
			vala_expression_set_value_type (_tmp1228_, (ValaDataType*) _tmp1233_);
			_vala_code_node_unref0 (_tmp1233_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1234_;
				ValaList* _tmp1235_;
				ValaList* _tmp1236_;
				gint _type_argument_size = 0;
				ValaList* _tmp1237_;
				gint _tmp1238_;
				gint _tmp1239_;
				gint _type_argument_index = 0;
				_tmp1234_ = inner_ma;
				_tmp1235_ = _tmp1234_->priv->type_argument_list;
				_tmp1236_ = _vala_iterable_ref0 (_tmp1235_);
				_type_argument_list = _tmp1236_;
				_tmp1237_ = _type_argument_list;
				_tmp1238_ = vala_collection_get_size ((ValaCollection*) _tmp1237_);
				_tmp1239_ = _tmp1238_;
				_type_argument_size = _tmp1239_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1240_;
					gpointer _tmp1241_;
					ValaExpression* _tmp1242_;
					ValaExpression* _tmp1243_;
					ValaDataType* _tmp1244_;
					ValaDataType* _tmp1245_;
					ValaDataType* _tmp1246_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1240_ = _type_argument_list;
					_tmp1241_ = vala_list_get (_tmp1240_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1241_;
					_tmp1242_ = vala_member_access_get_inner (self);
					_tmp1243_ = _tmp1242_;
					_tmp1244_ = vala_expression_get_value_type (_tmp1243_);
					_tmp1245_ = _tmp1244_;
					_tmp1246_ = type_argument;
					vala_data_type_add_type_argument (_tmp1245_, _tmp1246_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1247_ = vala_code_context_get_analyzer (context);
		_tmp1248_ = _tmp1247_;
		_tmp1249_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1250_ = _tmp1249_;
		_tmp1251_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1252_ = _tmp1251_;
		_tmp1253_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1248_, _tmp1250_, _tmp1252_);
		_tmp1254_ = _tmp1253_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1254_);
		_vala_code_node_unref0 (_tmp1254_);
		_tmp1256_ = vala_member_access_get_inner (self);
		_tmp1257_ = _tmp1256_;
		if (_tmp1257_ != NULL) {
			ValaDataType* _tmp1258_;
			ValaDataType* _tmp1259_;
			_tmp1258_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1259_ = _tmp1258_;
			_tmp1255_ = _tmp1259_ != NULL;
		} else {
			_tmp1255_ = FALSE;
		}
		if (_tmp1255_) {
			ValaDataType* _tmp1260_;
			ValaDataType* _tmp1261_;
			ValaExpression* _tmp1262_;
			ValaExpression* _tmp1263_;
			ValaDataType* _tmp1264_;
			ValaDataType* _tmp1265_;
			ValaDataType* _tmp1266_;
			ValaDataType* _tmp1267_;
			_tmp1260_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1261_ = _tmp1260_;
			_tmp1262_ = vala_member_access_get_inner (self);
			_tmp1263_ = _tmp1262_;
			_tmp1264_ = vala_expression_get_value_type (_tmp1263_);
			_tmp1265_ = _tmp1264_;
			_tmp1266_ = vala_data_type_get_actual_type (_tmp1261_, _tmp1265_, NULL, (ValaCodeNode*) self);
			_tmp1267_ = _tmp1266_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1267_);
			_vala_code_node_unref0 (_tmp1267_);
		} else {
			ValaDataType* _tmp1268_;
			ValaDataType* _tmp1269_;
			_tmp1268_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1269_ = _tmp1268_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1269_);
		}
		_tmp1270_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1271_ = _tmp1270_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1271_, VALA_TYPE_METHOD)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1272_;
			ValaSymbol* _tmp1273_;
			ValaMethod* _tmp1274_;
			ValaDataType* _tmp1275_;
			ValaDataType* _tmp1276_;
			gboolean _tmp1283_ = FALSE;
			_tmp1272_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1273_ = _tmp1272_;
			_tmp1274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1273_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1274_;
			_tmp1275_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1276_ = _tmp1275_;
			if (_tmp1276_ != NULL) {
				ValaDataType* _tmp1277_;
				ValaDataType* _tmp1278_;
				ValaDataType* _tmp1279_;
				ValaDataType* _tmp1280_;
				gboolean _tmp1281_;
				gboolean _tmp1282_;
				_tmp1277_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1278_ = _tmp1277_;
				_tmp1279_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1280_ = _tmp1279_;
				_tmp1281_ = vala_data_type_get_value_owned (_tmp1280_);
				_tmp1282_ = _tmp1281_;
				vala_data_type_set_value_owned (_tmp1278_, _tmp1282_);
			}
			if (instance) {
				ValaMethod* _tmp1284_;
				ValaSymbol* _tmp1285_;
				ValaSymbol* _tmp1286_;
				_tmp1284_ = method;
				_tmp1285_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1284_);
				_tmp1286_ = _tmp1285_;
				_tmp1283_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1286_, VALA_TYPE_TYPESYMBOL);
			} else {
				_tmp1283_ = FALSE;
			}
			if (_tmp1283_) {
				ValaExpression* _tmp1287_;
				ValaExpression* _tmp1288_;
				ValaMethod* _tmp1289_;
				ValaSymbol* _tmp1290_;
				ValaSymbol* _tmp1291_;
				ValaDataType* _tmp1292_;
				ValaDataType* _tmp1293_;
				ValaExpression* _tmp1294_;
				ValaExpression* _tmp1295_;
				ValaDataType* _tmp1296_;
				ValaDataType* _tmp1297_;
				ValaMethod* _tmp1298_;
				ValaParameter* _tmp1299_;
				ValaParameter* _tmp1300_;
				ValaDataType* _tmp1301_;
				ValaDataType* _tmp1302_;
				gboolean _tmp1303_;
				gboolean _tmp1304_;
				_tmp1287_ = vala_member_access_get_inner (self);
				_tmp1288_ = _tmp1287_;
				_tmp1289_ = method;
				_tmp1290_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1289_);
				_tmp1291_ = _tmp1290_;
				_tmp1292_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1291_);
				_tmp1293_ = _tmp1292_;
				vala_expression_set_target_type (_tmp1288_, _tmp1293_);
				_vala_code_node_unref0 (_tmp1293_);
				_tmp1294_ = vala_member_access_get_inner (self);
				_tmp1295_ = _tmp1294_;
				_tmp1296_ = vala_expression_get_target_type (_tmp1295_);
				_tmp1297_ = _tmp1296_;
				_tmp1298_ = method;
				_tmp1299_ = vala_method_get_this_parameter (_tmp1298_);
				_tmp1300_ = _tmp1299_;
				_tmp1301_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1300_);
				_tmp1302_ = _tmp1301_;
				_tmp1303_ = vala_data_type_get_value_owned (_tmp1302_);
				_tmp1304_ = _tmp1303_;
				vala_data_type_set_value_owned (_tmp1297_, _tmp1304_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1305_;
			ValaSymbol* _tmp1306_;
			_tmp1305_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1306_ = _tmp1305_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1306_, VALA_TYPE_PROPERTY)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1307_;
				ValaSymbol* _tmp1308_;
				ValaProperty* _tmp1309_;
				gboolean _tmp1310_ = FALSE;
				_tmp1307_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1308_ = _tmp1307_;
				_tmp1309_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1308_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1309_;
				if (instance) {
					ValaProperty* _tmp1311_;
					ValaSymbol* _tmp1312_;
					ValaSymbol* _tmp1313_;
					_tmp1311_ = prop;
					_tmp1312_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1311_);
					_tmp1313_ = _tmp1312_;
					_tmp1310_ = _tmp1313_ != NULL;
				} else {
					_tmp1310_ = FALSE;
				}
				if (_tmp1310_) {
					ValaExpression* _tmp1314_;
					ValaExpression* _tmp1315_;
					ValaProperty* _tmp1316_;
					ValaSymbol* _tmp1317_;
					ValaSymbol* _tmp1318_;
					ValaDataType* _tmp1319_;
					ValaDataType* _tmp1320_;
					_tmp1314_ = vala_member_access_get_inner (self);
					_tmp1315_ = _tmp1314_;
					_tmp1316_ = prop;
					_tmp1317_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1316_);
					_tmp1318_ = _tmp1317_;
					_tmp1319_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1318_);
					_tmp1320_ = _tmp1319_;
					vala_expression_set_target_type (_tmp1315_, _tmp1320_);
					_vala_code_node_unref0 (_tmp1320_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1321_ = FALSE;
				gboolean _tmp1322_ = FALSE;
				gboolean _tmp1323_ = FALSE;
				ValaSymbol* _tmp1324_;
				ValaSymbol* _tmp1325_;
				_tmp1324_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1325_ = _tmp1324_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1325_, VALA_TYPE_FIELD)) {
					_tmp1323_ = TRUE;
				} else {
					ValaSymbol* _tmp1326_;
					ValaSymbol* _tmp1327_;
					_tmp1326_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1327_ = _tmp1326_;
					_tmp1323_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1327_, VALA_TYPE_SIGNAL);
				}
				if (_tmp1323_) {
					_tmp1322_ = instance;
				} else {
					_tmp1322_ = FALSE;
				}
				if (_tmp1322_) {
					ValaSymbol* _tmp1328_;
					ValaSymbol* _tmp1329_;
					ValaSymbol* _tmp1330_;
					ValaSymbol* _tmp1331_;
					_tmp1328_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1329_ = _tmp1328_;
					_tmp1330_ = vala_symbol_get_parent_symbol (_tmp1329_);
					_tmp1331_ = _tmp1330_;
					_tmp1321_ = _tmp1331_ != NULL;
				} else {
					_tmp1321_ = FALSE;
				}
				if (_tmp1321_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1332_;
					ValaSymbol* _tmp1333_;
					ValaSymbol* _tmp1334_;
					ValaSymbol* _tmp1335_;
					ValaDataType* _tmp1336_;
					ValaExpression* _tmp1337_;
					ValaExpression* _tmp1338_;
					ValaDataType* _tmp1339_;
					ValaExpression* _tmp1340_;
					ValaExpression* _tmp1341_;
					ValaDataType* _tmp1342_;
					ValaDataType* _tmp1343_;
					ValaDataType* _tmp1344_;
					ValaDataType* _tmp1345_;
					_tmp1332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1333_ = _tmp1332_;
					_tmp1334_ = vala_symbol_get_parent_symbol (_tmp1333_);
					_tmp1335_ = _tmp1334_;
					_tmp1336_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1335_);
					parent_type = _tmp1336_;
					_tmp1337_ = vala_member_access_get_inner (self);
					_tmp1338_ = _tmp1337_;
					_tmp1339_ = parent_type;
					_tmp1340_ = vala_member_access_get_inner (self);
					_tmp1341_ = _tmp1340_;
					_tmp1342_ = vala_expression_get_value_type (_tmp1341_);
					_tmp1343_ = _tmp1342_;
					_tmp1344_ = vala_data_type_get_actual_type (_tmp1339_, _tmp1343_, NULL, (ValaCodeNode*) self);
					_tmp1345_ = _tmp1344_;
					vala_expression_set_target_type (_tmp1338_, _tmp1345_);
					_vala_code_node_unref0 (_tmp1345_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1346_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1347_ = _tmp1346_;
	if (_tmp1347_ != NULL) {
		ValaDataType* _tmp1348_;
		ValaDataType* _tmp1349_;
		_tmp1348_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1349_ = _tmp1348_;
		vala_code_node_check ((ValaCodeNode*) _tmp1349_, context);
	}
	_tmp1350_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1351_ = _tmp1350_;
	result = !_tmp1351_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_FIELD)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_METHOD)) {
			_tmp4_ = !G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_PROPERTY)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALA_TYPE_SIGNAL)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaMemberAccess* _tmp58_;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	ValaMemberAccess* _tmp61_;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_FIELD)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_PROPERTY)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_PARAMETER)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		gboolean _tmp46_ = FALSE;
		ValaCodeContext* _tmp47_;
		ValaCodeContext* _tmp48_;
		ValaProfile _tmp49_;
		ValaProfile _tmp50_;
		gboolean _tmp51_;
		_tmp47_ = vala_code_context_get ();
		_tmp48_ = _tmp47_;
		_tmp49_ = vala_code_context_get_profile (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = _tmp50_ == VALA_PROFILE_GOBJECT;
		_vala_code_context_unref0 (_tmp48_);
		if (_tmp51_) {
			ValaExpression* _tmp52_;
			ValaExpression* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDataType* _tmp55_;
			_tmp52_ = vala_member_access_get_inner (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_expression_get_value_type (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp46_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp55_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp46_ = FALSE;
		}
		_tmp34_ = _tmp46_;
	}
	struct_or_array = _tmp34_;
	_tmp56_ = vala_member_access_get_inner (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp57_) : NULL);
	ma = _tmp58_;
	_tmp61_ = ma;
	if (_tmp61_ == NULL) {
		_tmp60_ = struct_or_array;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		_tmp62_ = vala_member_access_get_inner (self);
		_tmp63_ = _tmp62_;
		_tmp59_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, VALA_TYPE_POINTER_INDIRECTION);
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		ValaExpression* _tmp64_;
		ValaExpression* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaMemberAccess* _tmp68_;
		_tmp64_ = vala_member_access_get_inner (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp67_ = _tmp66_;
		_tmp68_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp67_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp68_;
	}
	if (instance) {
		_tmp72_ = struct_or_array;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		gboolean _tmp73_ = FALSE;
		ValaSymbol* _tmp74_;
		ValaSymbol* _tmp75_;
		_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp75_ = _tmp74_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_METHOD)) {
			_tmp73_ = TRUE;
		} else {
			gboolean _tmp76_;
			gboolean _tmp77_;
			_tmp76_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp77_ = _tmp76_;
			_tmp73_ = _tmp77_;
		}
		_tmp71_ = _tmp73_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		ValaMemberAccess* _tmp80_;
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaSymbol* _tmp82_;
			ValaSymbol* _tmp83_;
			_tmp81_ = ma;
			_tmp82_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp79_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_VARIABLE);
		} else {
			_tmp79_ = FALSE;
		}
		if (_tmp79_) {
			_tmp78_ = TRUE;
		} else {
			ValaExpression* _tmp84_;
			ValaExpression* _tmp85_;
			_tmp84_ = vala_member_access_get_inner (self);
			_tmp85_ = _tmp84_;
			_tmp78_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, VALA_TYPE_ELEMENT_ACCESS);
		}
		_tmp70_ = _tmp78_;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		_tmp69_ = !this_access;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, VALA_TYPE_METHOD)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp91_ = _tmp96_ != NULL;
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaMemberAccess* _tmp97_;
		_tmp97_ = ma;
		if (_tmp97_ != NULL) {
			ValaMemberAccess* _tmp98_;
			ValaMemberAccess* _tmp99_;
			_tmp98_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp98_, TRUE);
			_tmp99_ = ma;
			vala_member_access_check_lvalue_access (_tmp99_);
		}
	}
	_vala_code_node_unref0 (ma);
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

