/* utils.c generated by valac, the Vala compiler
 * generated from utils.vala, do not modify */

/* utils.vala
 *
 * Copyright (C) 2010 Luca Bruno
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valadoc.h>
#include <float.h>
#include <math.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define GTKDOC_TYPE_TEXT_WRITER (gtkdoc_text_writer_get_type ())
#define GTKDOC_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriter))
#define GTKDOC_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))
#define GTKDOC_IS_TEXT_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_IS_TEXT_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_TEXT_WRITER))
#define GTKDOC_TEXT_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriterClass))

typedef struct _GtkdocTextWriter GtkdocTextWriter;
typedef struct _GtkdocTextWriterClass GtkdocTextWriterClass;
typedef struct _GtkdocTextWriterPrivate GtkdocTextWriterPrivate;
typedef struct _GtkdocParamSpecTextWriter GtkdocParamSpecTextWriter;

struct _GtkdocTextWriter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	gchar* filename;
	gchar* mode;
	GtkdocTextWriterPrivate * priv;
};

struct _GtkdocTextWriterClass {
	GTypeClass parent_class;
	void (*finalize) (GtkdocTextWriter *self);
};

struct _GtkdocTextWriterPrivate {
	FILE* stream;
};

struct _GtkdocParamSpecTextWriter {
	GParamSpec parent_instance;
};

static gint GtkdocTextWriter_private_offset;
static gpointer gtkdoc_text_writer_parent_class = NULL;

gchar* gtkdoc_get_section (const gchar* filename);
gchar* gtkdoc_commentize (const gchar* comment);
gchar* gtkdoc_get_cname (ValadocApiItem* item);
gchar* gtkdoc_get_dbus_interface (ValadocApiItem* item);
gchar* gtkdoc_get_docbook_type_link (ValadocApiClass* cls);
gchar* gtkdoc_to_docbook_id (const gchar* name);
gchar* gtkdoc_get_gtkdoc_link (ValadocApiNode* symbol);
gchar* gtkdoc_get_docbook_link (ValadocApiItem* item,
                                gboolean is_dbus,
                                gboolean is_async_finish);
gdouble gtkdoc_get_parameter_pos (ValadocApiNode* node,
                                  const gchar* name);
gchar* gtkdoc_to_lower_case (const gchar* camel);
gboolean gtkdoc_package_exists (const gchar* package_name,
                                ValadocErrorReporter* reporter);
gboolean gtkdoc_is_generated_by_vala (const gchar* filename);
gpointer gtkdoc_text_writer_ref (gpointer instance);
void gtkdoc_text_writer_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_text_writer (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
void gtkdoc_value_set_text_writer (GValue* value,
                                   gpointer v_object);
void gtkdoc_value_take_text_writer (GValue* value,
                                    gpointer v_object);
gpointer gtkdoc_value_get_text_writer (const GValue* value);
GType gtkdoc_text_writer_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocTextWriter, gtkdoc_text_writer_unref)
GtkdocTextWriter* gtkdoc_text_writer_new (const gchar* filename,
                                          const gchar* mode);
GtkdocTextWriter* gtkdoc_text_writer_construct (GType object_type,
                                                const gchar* filename,
                                                const gchar* mode);
gboolean gtkdoc_text_writer_open (GtkdocTextWriter* self);
void gtkdoc_text_writer_close (GtkdocTextWriter* self);
void gtkdoc_text_writer_write_line (GtkdocTextWriter* self,
                                    const gchar* line);
static void gtkdoc_text_writer_finalize (GtkdocTextWriter * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gchar*
gtkdoc_get_section (const gchar* filename)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = string_substring (filename, (glong) 0, (glong) string_last_index_of_char (filename, (gunichar) '.', 0));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_path_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

gchar*
gtkdoc_commentize (const gchar* comment)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
	g_return_val_if_fail (comment != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (comment, "\n", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = _vala_g_strjoinv ("\n * ", _tmp2_, (gint) _vala_array_length (_tmp0_));
	_tmp4_ = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp4_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

gchar*
gtkdoc_get_cname (ValadocApiItem* item)
{
	gchar* result = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_METHOD)) {
		gchar* _tmp0_;
		_tmp0_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		result = _tmp0_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_FORMAL_PARAMETER)) {
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			return result;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_CONSTANT)) {
				gchar* _tmp4_;
				_tmp4_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				result = _tmp4_;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_PROPERTY)) {
					gchar* _tmp5_;
					_tmp5_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
					result = _tmp5_;
					return result;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_SIGNAL)) {
						gchar* name = NULL;
						gchar* _tmp6_;
						const gchar* _tmp7_;
						gchar* _tmp8_;
						_tmp6_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
						name = _tmp6_;
						_tmp7_ = name;
						_tmp8_ = string_replace (_tmp7_, "_", "-");
						result = _tmp8_;
						_g_free0 (name);
						return result;
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_CLASS)) {
							gchar* _tmp9_;
							_tmp9_ = valadoc_api_class_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CLASS, ValadocApiClass));
							result = _tmp9_;
							return result;
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_STRUCT)) {
								gchar* _tmp10_;
								_tmp10_ = valadoc_api_struct_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_STRUCT, ValadocApiStruct));
								result = _tmp10_;
								return result;
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_INTERFACE)) {
									gchar* _tmp11_;
									_tmp11_ = valadoc_api_interface_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
									result = _tmp11_;
									return result;
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_ERROR_DOMAIN)) {
										gchar* _tmp12_;
										_tmp12_ = valadoc_api_error_domain_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ERROR_DOMAIN, ValadocApiErrorDomain));
										result = _tmp12_;
										return result;
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_ERROR_CODE)) {
											gchar* _tmp13_;
											_tmp13_ = valadoc_api_error_code_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ERROR_CODE, ValadocApiErrorCode));
											result = _tmp13_;
											return result;
										} else {
											if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_DELEGATE)) {
												gchar* _tmp14_;
												_tmp14_ = valadoc_api_delegate_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_DELEGATE, ValadocApiDelegate));
												result = _tmp14_;
												return result;
											} else {
												if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_ENUM)) {
													gchar* _tmp15_;
													_tmp15_ = valadoc_api_enum_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ENUM, ValadocApiEnum));
													result = _tmp15_;
													return result;
												} else {
													if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_ENUM_VALUE)) {
														gchar* _tmp16_;
														_tmp16_ = valadoc_api_enum_value_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ENUM_VALUE, ValadocApiEnumValue));
														result = _tmp16_;
														return result;
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

gchar*
gtkdoc_get_dbus_interface (ValadocApiItem* item)
{
	gchar* result = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_CLASS)) {
		gchar* _tmp0_;
		_tmp0_ = valadoc_api_class_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CLASS, ValadocApiClass));
		result = _tmp0_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_INTERFACE)) {
			gchar* _tmp1_;
			_tmp1_ = valadoc_api_interface_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface));
			result = _tmp1_;
			return result;
		}
	}
	result = NULL;
	return result;
}

gchar*
gtkdoc_get_docbook_type_link (ValadocApiClass* cls)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result = NULL;
	g_return_val_if_fail (cls != NULL, NULL);
	_tmp0_ = valadoc_api_class_get_type_id (cls);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtkdoc_to_docbook_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_api_class_get_type_id (cls);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("<link linkend=\"%s:CAPS\"><literal>%s</literal></link>", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
gtkdoc_get_gtkdoc_link (ValadocApiNode* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_;
	gchar* _tmp58_;
	gchar* result = NULL;
	g_return_val_if_fail (symbol != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_CLASS)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_INTERFACE);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_STRUCT);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_ENUM);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_ERROR_DOMAIN);
	}
	if (_tmp0_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = gtkdoc_get_cname ((ValadocApiItem*) symbol);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("#%s", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		result = _tmp7_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_METHOD)) {
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup_printf ("%s ()", _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_CONSTANT)) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_ENUM_VALUE);
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_ERROR_CODE);
	}
	if (_tmp12_) {
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp14_ = gtkdoc_get_cname ((ValadocApiItem*) symbol);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("%%%s", _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp15_);
		result = _tmp17_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_SIGNAL)) {
		ValadocApiItem* _tmp18_;
		ValadocApiItem* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp18_ = valadoc_api_item_get_parent ((ValadocApiItem*) symbol);
		_tmp19_ = _tmp18_;
		_tmp20_ = gtkdoc_get_cname (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("#%s::%s", _tmp21_, _tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		result = _tmp25_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_PROPERTY)) {
		ValadocApiItem* _tmp26_;
		ValadocApiItem* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp26_ = valadoc_api_item_get_parent ((ValadocApiItem*) symbol);
		_tmp27_ = _tmp26_;
		_tmp28_ = gtkdoc_get_cname (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf ("#%s:%s", _tmp29_, _tmp31_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		result = _tmp33_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_FIELD)) {
		gboolean _tmp35_ = FALSE;
		ValadocApiItem* _tmp36_;
		ValadocApiItem* _tmp37_;
		_tmp36_ = valadoc_api_item_get_parent ((ValadocApiItem*) symbol);
		_tmp37_ = _tmp36_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALADOC_API_TYPE_CLASS)) {
			_tmp35_ = TRUE;
		} else {
			ValadocApiItem* _tmp38_;
			ValadocApiItem* _tmp39_;
			_tmp38_ = valadoc_api_item_get_parent ((ValadocApiItem*) symbol);
			_tmp39_ = _tmp38_;
			_tmp35_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALADOC_API_TYPE_STRUCT);
		}
		_tmp34_ = _tmp35_;
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		ValadocApiField* field = NULL;
		ValadocApiField* _tmp40_;
		ValadocApiField* _tmp41_;
		gboolean _tmp42_;
		gboolean _tmp43_;
		_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (symbol, VALADOC_API_TYPE_FIELD) ? ((ValadocApiField*) symbol) : NULL);
		field = _tmp40_;
		_tmp41_ = field;
		_tmp42_ = valadoc_api_field_get_is_static (_tmp41_);
		_tmp43_ = _tmp42_;
		if (_tmp43_) {
			ValadocApiField* _tmp44_;
			gchar* _tmp45_;
			_tmp44_ = field;
			_tmp45_ = valadoc_api_field_get_cname (_tmp44_);
			result = _tmp45_;
			_g_object_unref0 (field);
			return result;
		} else {
			ValadocApiItem* _tmp46_;
			ValadocApiItem* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			ValadocApiField* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			_tmp46_ = valadoc_api_item_get_parent ((ValadocApiItem*) symbol);
			_tmp47_ = _tmp46_;
			_tmp48_ = gtkdoc_get_cname (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = field;
			_tmp51_ = valadoc_api_field_get_cname (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_strdup_printf ("#%s.%s", _tmp49_, _tmp52_);
			_tmp54_ = _tmp53_;
			_g_free0 (_tmp52_);
			_g_free0 (_tmp49_);
			result = _tmp54_;
			_g_object_unref0 (field);
			return result;
		}
		_g_object_unref0 (field);
	}
	_tmp56_ = gtkdoc_get_cname ((ValadocApiItem*) symbol);
	_tmp55_ = _tmp56_;
	if (_tmp55_ == NULL) {
		gchar* _tmp57_;
		_tmp57_ = valadoc_api_node_get_full_name (symbol);
		_g_free0 (_tmp55_);
		_tmp55_ = _tmp57_;
	}
	_tmp58_ = _tmp55_;
	_tmp55_ = NULL;
	result = _tmp58_;
	_g_free0 (_tmp55_);
	return result;
}

gchar*
gtkdoc_get_docbook_link (ValadocApiItem* item,
                         gboolean is_dbus,
                         gboolean is_async_finish)
{
	gchar* result = NULL;
	g_return_val_if_fail (item != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_METHOD)) {
		gchar* name = NULL;
		gchar* parent = NULL;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		if (is_dbus) {
			gchar* _tmp0_;
			ValadocApiItem* _tmp1_;
			ValadocApiItem* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp0_ = valadoc_api_method_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_g_free0 (name);
			name = _tmp0_;
			_tmp1_ = valadoc_api_item_get_parent (item);
			_tmp2_ = _tmp1_;
			_tmp3_ = gtkdoc_get_dbus_interface (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_strdup_printf ("%s-", _tmp4_);
			_g_free0 (parent);
			parent = _tmp5_;
			_g_free0 (_tmp4_);
		} else {
			gchar* _tmp8_;
			if (!is_async_finish) {
				gchar* _tmp6_;
				_tmp6_ = valadoc_api_method_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
				_g_free0 (name);
				name = _tmp6_;
			} else {
				gchar* _tmp7_;
				_tmp7_ = valadoc_api_method_get_finish_function_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
				_g_free0 (name);
				name = _tmp7_;
			}
			_tmp8_ = g_strdup ("");
			_g_free0 (parent);
			parent = _tmp8_;
		}
		_tmp9_ = parent;
		_tmp10_ = gtkdoc_to_docbook_id (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = name;
		_tmp13_ = gtkdoc_to_docbook_id (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = name;
		_tmp16_ = g_strdup_printf ("<link linkend=\"%s%s\"><function>%s()</function></link>", _tmp11_, _tmp14_, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp11_);
		result = _tmp17_;
		_g_free0 (parent);
		_g_free0 (name);
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_FORMAL_PARAMETER)) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp18_ = valadoc_api_node_get_name ((ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_FORMAL_PARAMETER, ValadocApiFormalParameter));
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strdup_printf ("<parameter>%s</parameter>", _tmp19_);
			result = _tmp20_;
			return result;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_CONSTANT)) {
				gchar* cname = NULL;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				_tmp21_ = valadoc_api_constant_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_CONSTANT, ValadocApiConstant));
				cname = _tmp21_;
				_tmp22_ = cname;
				_tmp23_ = gtkdoc_to_docbook_id (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = cname;
				_tmp26_ = g_strdup_printf ("<link linkend=\"%s:CAPS\"><literal>%s</literal></link>", _tmp24_, _tmp25_);
				_tmp27_ = _tmp26_;
				_g_free0 (_tmp24_);
				result = _tmp27_;
				_g_free0 (cname);
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_ERROR_CODE)) {
					gchar* cname = NULL;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					_tmp28_ = valadoc_api_error_code_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_ERROR_CODE, ValadocApiErrorCode));
					cname = _tmp28_;
					_tmp29_ = cname;
					_tmp30_ = gtkdoc_to_docbook_id (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = cname;
					_tmp33_ = g_strdup_printf ("<link linkend=\"%s:CAPS\"><literal>%s</literal></link>", _tmp31_, _tmp32_);
					_tmp34_ = _tmp33_;
					_g_free0 (_tmp31_);
					result = _tmp34_;
					_g_free0 (cname);
					return result;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_PROPERTY)) {
						gchar* name = NULL;
						gchar* parent = NULL;
						const gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						const gchar* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						const gchar* _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						if (is_dbus) {
							gchar* _tmp35_;
							ValadocApiItem* _tmp36_;
							ValadocApiItem* _tmp37_;
							gchar* _tmp38_;
							_tmp35_ = valadoc_api_property_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
							_g_free0 (name);
							name = _tmp35_;
							_tmp36_ = valadoc_api_item_get_parent (item);
							_tmp37_ = _tmp36_;
							_tmp38_ = gtkdoc_get_dbus_interface (_tmp37_);
							_g_free0 (parent);
							parent = _tmp38_;
						} else {
							gchar* _tmp39_;
							ValadocApiItem* _tmp40_;
							ValadocApiItem* _tmp41_;
							gchar* _tmp42_;
							_tmp39_ = valadoc_api_property_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_PROPERTY, ValadocApiProperty));
							_g_free0 (name);
							name = _tmp39_;
							_tmp40_ = valadoc_api_item_get_parent (item);
							_tmp41_ = _tmp40_;
							_tmp42_ = gtkdoc_get_cname (_tmp41_);
							_g_free0 (parent);
							parent = _tmp42_;
						}
						_tmp43_ = parent;
						_tmp44_ = gtkdoc_to_docbook_id (_tmp43_);
						_tmp45_ = _tmp44_;
						_tmp46_ = name;
						_tmp47_ = gtkdoc_to_docbook_id (_tmp46_);
						_tmp48_ = _tmp47_;
						_tmp49_ = name;
						_tmp50_ = g_strdup_printf ("<link linkend=\"%s--%s\"><type>\"%s\"</type></link>", _tmp45_, _tmp48_, _tmp49_);
						_tmp51_ = _tmp50_;
						_g_free0 (_tmp48_);
						_g_free0 (_tmp45_);
						result = _tmp51_;
						_g_free0 (parent);
						_g_free0 (name);
						return result;
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (item, VALADOC_API_TYPE_SIGNAL)) {
							gchar* name = NULL;
							gchar* parent = NULL;
							const gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							const gchar* _tmp65_;
							gchar* _tmp66_;
							gchar* _tmp67_;
							const gchar* _tmp68_;
							gchar* _tmp69_;
							gchar* _tmp70_;
							if (is_dbus) {
								gchar* _tmp52_;
								ValadocApiItem* _tmp53_;
								ValadocApiItem* _tmp54_;
								gchar* _tmp55_;
								_tmp52_ = valadoc_api_signal_get_dbus_name (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
								_g_free0 (name);
								name = _tmp52_;
								_tmp53_ = valadoc_api_item_get_parent (item);
								_tmp54_ = _tmp53_;
								_tmp55_ = gtkdoc_get_dbus_interface (_tmp54_);
								_g_free0 (parent);
								parent = _tmp55_;
							} else {
								gchar* _tmp56_;
								const gchar* _tmp57_;
								gchar* _tmp58_;
								ValadocApiItem* _tmp59_;
								ValadocApiItem* _tmp60_;
								gchar* _tmp61_;
								_tmp56_ = valadoc_api_signal_get_cname (G_TYPE_CHECK_INSTANCE_CAST (item, VALADOC_API_TYPE_SIGNAL, ValadocApiSignal));
								_g_free0 (name);
								name = _tmp56_;
								_tmp57_ = name;
								_tmp58_ = string_replace (_tmp57_, "_", "-");
								_g_free0 (name);
								name = _tmp58_;
								_tmp59_ = valadoc_api_item_get_parent (item);
								_tmp60_ = _tmp59_;
								_tmp61_ = gtkdoc_get_cname (_tmp60_);
								_g_free0 (parent);
								parent = _tmp61_;
							}
							_tmp62_ = parent;
							_tmp63_ = gtkdoc_to_docbook_id (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = name;
							_tmp66_ = gtkdoc_to_docbook_id (_tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = name;
							_tmp69_ = g_strdup_printf ("<link linkend=\"%s-%s\"><type>\"%s\"</type></link>", _tmp64_, _tmp67_, _tmp68_);
							_tmp70_ = _tmp69_;
							_g_free0 (_tmp67_);
							_g_free0 (_tmp64_);
							result = _tmp70_;
							_g_free0 (parent);
							_g_free0 (name);
							return result;
						} else {
							gchar* cname = NULL;
							gchar* _tmp71_;
							const gchar* _tmp72_;
							_tmp71_ = gtkdoc_get_cname (item);
							cname = _tmp71_;
							_tmp72_ = cname;
							if (_tmp72_ != NULL) {
								const gchar* _tmp73_;
								gchar* _tmp74_;
								gchar* _tmp75_;
								const gchar* _tmp76_;
								gchar* _tmp77_;
								gchar* _tmp78_;
								_tmp73_ = cname;
								_tmp74_ = gtkdoc_to_docbook_id (_tmp73_);
								_tmp75_ = _tmp74_;
								_tmp76_ = cname;
								_tmp77_ = g_strdup_printf ("<link linkend=\"%s\"><type>%s</type></link>", _tmp75_, _tmp76_);
								_tmp78_ = _tmp77_;
								_g_free0 (_tmp75_);
								result = _tmp78_;
								_g_free0 (cname);
								return result;
							}
							_g_free0 (cname);
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

gdouble
gtkdoc_get_parameter_pos (ValadocApiNode* node,
                          const gchar* name)
{
	gdouble pos = 0.0;
	gdouble result = 0.0;
	g_return_val_if_fail (node != NULL, 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	pos = (gdouble) 1;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = valadoc_api_node_get_children_by_type (node, VALADOC_API_NODE_TYPE_FORMAL_PARAMETER, TRUE);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			ValadocApiNode* param = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValadocApiNode* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gdouble _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp4_ = _param_list;
			_tmp5_ = vala_list_get (_tmp4_, _param_index);
			param = (ValadocApiNode*) _tmp5_;
			_tmp6_ = param;
			_tmp7_ = valadoc_api_node_get_name (_tmp6_);
			_tmp8_ = _tmp7_;
			if (g_strcmp0 (_tmp8_, name) == 0) {
				result = pos;
				_g_object_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_tmp9_ = pos;
			pos = _tmp9_ + 1;
			_g_object_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (gdouble) -1;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gchar*
gtkdoc_to_lower_case (const gchar* camel)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean last_upper = FALSE;
	GString* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result = NULL;
	g_return_val_if_fail (camel != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	last_upper = TRUE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = strlen (camel);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				if (g_ascii_isupper (string_get (camel, (glong) i))) {
					GString* _tmp6_;
					if (!last_upper) {
						GString* _tmp5_;
						_tmp5_ = builder;
						g_string_append_c (_tmp5_, '_');
					}
					_tmp6_ = builder;
					g_string_append_unichar (_tmp6_, (gunichar) g_ascii_tolower (string_get (camel, (glong) i)));
					last_upper = TRUE;
				} else {
					GString* _tmp7_;
					_tmp7_ = builder;
					g_string_append_unichar (_tmp7_, (gunichar) string_get (camel, (glong) i));
					last_upper = FALSE;
				}
			}
		}
	}
	_tmp8_ = builder;
	_tmp9_ = _tmp8_->str;
	_tmp10_ = g_strdup (_tmp9_);
	result = _tmp10_;
	_g_string_free0 (builder);
	return result;
}

gchar*
gtkdoc_to_docbook_id (const gchar* name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = string_replace (name, ".", "-");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "_", "-");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gboolean
gtkdoc_package_exists (const gchar* package_name,
                       ValadocErrorReporter* reporter)
{
	gchar* pc = NULL;
	gchar* _tmp0_;
	gint exit_status = 0;
	gboolean _tmp5_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (package_name != NULL, FALSE);
	g_return_val_if_fail (reporter != NULL, FALSE);
	_tmp0_ = g_strconcat ("pkg-config --exists ", package_name, NULL);
	pc = _tmp0_;
	{
		gint _tmp1_ = 0;
		g_spawn_command_line_sync (pc, NULL, NULL, &_tmp1_, &_inner_error0_);
		exit_status = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp2_ = FALSE;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch11_g_spawn_error;
			}
			_g_free0 (pc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
		result = 0 == exit_status;
		_g_free0 (pc);
		return result;
	}
	goto __finally11;
	__catch11_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		valadoc_error_reporter_simple_warning (reporter, "GtkDoc", "Error pkg-config --exists %s: %s", package_name, _tmp4_);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (pc);
		return result;
	}
	__finally11:
	_g_free0 (pc);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp5_;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gboolean
gtkdoc_is_generated_by_vala (const gchar* filename)
{
	FILE* stream = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_fopen (filename, "r");
	stream = _tmp0_;
	_tmp1_ = stream;
	if (_tmp1_ != NULL) {
		gchar* line = NULL;
		FILE* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = stream;
		_tmp3_ = g_file_stream_read_line (_tmp2_);
		line = _tmp3_;
		_tmp4_ = line;
		if (_tmp4_ != NULL) {
			const gchar* _tmp5_;
			_tmp5_ = line;
			result = string_index_of (_tmp5_, "generated by valac", 0) >= 0;
			_g_free0 (line);
			_fclose0 (stream);
			return result;
		}
		_g_free0 (line);
	}
	result = FALSE;
	_fclose0 (stream);
	return result;
}

static inline gpointer
gtkdoc_text_writer_get_instance_private (GtkdocTextWriter* self)
{
	return G_STRUCT_MEMBER_P (self, GtkdocTextWriter_private_offset);
}

GtkdocTextWriter*
gtkdoc_text_writer_construct (GType object_type,
                              const gchar* filename,
                              const gchar* mode)
{
	GtkdocTextWriter* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (filename != NULL, NULL);
	g_return_val_if_fail (mode != NULL, NULL);
	self = (GtkdocTextWriter*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (filename);
	_g_free0 (self->filename);
	self->filename = _tmp0_;
	_tmp1_ = g_strdup (mode);
	_g_free0 (self->mode);
	self->mode = _tmp1_;
	return self;
}

GtkdocTextWriter*
gtkdoc_text_writer_new (const gchar* filename,
                        const gchar* mode)
{
	return gtkdoc_text_writer_construct (GTKDOC_TYPE_TEXT_WRITER, filename, mode);
}

gboolean
gtkdoc_text_writer_open (GtkdocTextWriter* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FILE* _tmp2_;
	FILE* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->filename;
	_tmp1_ = self->mode;
	_tmp2_ = g_fopen (_tmp0_, _tmp1_);
	_fclose0 (self->priv->stream);
	self->priv->stream = _tmp2_;
	_tmp3_ = self->priv->stream;
	result = _tmp3_ != NULL;
	return result;
}

void
gtkdoc_text_writer_close (GtkdocTextWriter* self)
{
	g_return_if_fail (self != NULL);
	_fclose0 (self->priv->stream);
	self->priv->stream = NULL;
}

void
gtkdoc_text_writer_write_line (GtkdocTextWriter* self,
                               const gchar* line)
{
	FILE* _tmp0_;
	FILE* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_tmp0_ = self->priv->stream;
	fputs (line, _tmp0_);
	_tmp1_ = self->priv->stream;
	fputc ('\n', _tmp1_);
}

static void
gtkdoc_value_text_writer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gtkdoc_value_text_writer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gtkdoc_text_writer_unref (value->data[0].v_pointer);
	}
}

static void
gtkdoc_value_text_writer_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gtkdoc_text_writer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gtkdoc_value_text_writer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gtkdoc_value_text_writer_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GtkdocTextWriter * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gtkdoc_text_writer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gtkdoc_value_text_writer_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	GtkdocTextWriter ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gtkdoc_text_writer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gtkdoc_param_spec_text_writer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	GtkdocParamSpecTextWriter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GTKDOC_TYPE_TEXT_WRITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gtkdoc_value_get_text_writer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_TEXT_WRITER), NULL);
	return value->data[0].v_pointer;
}

void
gtkdoc_value_set_text_writer (GValue* value,
                              gpointer v_object)
{
	GtkdocTextWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_TEXT_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_TEXT_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gtkdoc_text_writer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_text_writer_unref (old);
	}
}

void
gtkdoc_value_take_text_writer (GValue* value,
                               gpointer v_object)
{
	GtkdocTextWriter * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GTKDOC_TYPE_TEXT_WRITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GTKDOC_TYPE_TEXT_WRITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gtkdoc_text_writer_unref (old);
	}
}

static void
gtkdoc_text_writer_class_init (GtkdocTextWriterClass * klass,
                               gpointer klass_data)
{
	gtkdoc_text_writer_parent_class = g_type_class_peek_parent (klass);
	((GtkdocTextWriterClass *) klass)->finalize = gtkdoc_text_writer_finalize;
	g_type_class_adjust_private_offset (klass, &GtkdocTextWriter_private_offset);
}

static void
gtkdoc_text_writer_instance_init (GtkdocTextWriter * self,
                                  gpointer klass)
{
	self->priv = gtkdoc_text_writer_get_instance_private (self);
	self->ref_count = 1;
}

static void
gtkdoc_text_writer_finalize (GtkdocTextWriter * obj)
{
	GtkdocTextWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_TEXT_WRITER, GtkdocTextWriter);
	g_signal_handlers_destroy (self);
	_g_free0 (self->filename);
	_g_free0 (self->mode);
	_fclose0 (self->priv->stream);
}

GType
gtkdoc_text_writer_get_type (void)
{
	static volatile gsize gtkdoc_text_writer_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_text_writer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gtkdoc_value_text_writer_init, gtkdoc_value_text_writer_free_value, gtkdoc_value_text_writer_copy_value, gtkdoc_value_text_writer_peek_pointer, "p", gtkdoc_value_text_writer_collect_value, "p", gtkdoc_value_text_writer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocTextWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_text_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocTextWriter), 0, (GInstanceInitFunc) gtkdoc_text_writer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gtkdoc_text_writer_type_id;
		gtkdoc_text_writer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GtkdocTextWriter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		GtkdocTextWriter_private_offset = g_type_add_instance_private (gtkdoc_text_writer_type_id, sizeof (GtkdocTextWriterPrivate));
		g_once_init_leave (&gtkdoc_text_writer_type_id__volatile, gtkdoc_text_writer_type_id);
	}
	return gtkdoc_text_writer_type_id__volatile;
}

gpointer
gtkdoc_text_writer_ref (gpointer instance)
{
	GtkdocTextWriter * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gtkdoc_text_writer_unref (gpointer instance)
{
	GtkdocTextWriter * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GTKDOC_TEXT_WRITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

