/* commentconverter.c generated by valac, the Vala compiler
 * generated from commentconverter.vala, do not modify */

/* commentconverter.vala
 *
 * Copyright (C) 2010 Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Luca Bruno <lethalman88@gmail.com>
 */

#include <valadoc.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <float.h>
#include <math.h>

#define GTKDOC_TYPE_COMMENT_CONVERTER (gtkdoc_comment_converter_get_type ())
#define GTKDOC_COMMENT_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverter))
#define GTKDOC_COMMENT_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverterClass))
#define GTKDOC_IS_COMMENT_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_COMMENT_CONVERTER))
#define GTKDOC_IS_COMMENT_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_COMMENT_CONVERTER))
#define GTKDOC_COMMENT_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverterClass))

typedef struct _GtkdocCommentConverter GtkdocCommentConverter;
typedef struct _GtkdocCommentConverterClass GtkdocCommentConverterClass;
typedef struct _GtkdocCommentConverterPrivate GtkdocCommentConverterPrivate;

#define GTKDOC_TYPE_HEADER (gtkdoc_header_get_type ())
#define GTKDOC_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTKDOC_TYPE_HEADER, GtkdocHeader))
#define GTKDOC_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))
#define GTKDOC_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTKDOC_TYPE_HEADER))
#define GTKDOC_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTKDOC_TYPE_HEADER))
#define GTKDOC_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GTKDOC_TYPE_HEADER, GtkdocHeaderClass))

typedef struct _GtkdocHeader GtkdocHeader;
typedef struct _GtkdocHeaderClass GtkdocHeaderClass;
enum  {
	GTKDOC_COMMENT_CONVERTER_0_PROPERTY,
	GTKDOC_COMMENT_CONVERTER_NUM_PROPERTIES
};
static GParamSpec* gtkdoc_comment_converter_properties[GTKDOC_COMMENT_CONVERTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _gtkdoc_header_unref0(var) ((var == NULL) ? NULL : (var = (gtkdoc_header_unref (var), NULL)))

struct _GtkdocCommentConverter {
	ValadocContentContentVisitor parent_instance;
	ValadocApiNode* node_reference;
	gboolean is_dbus;
	gchar* brief_comment;
	gchar* long_comment;
	gchar* returns;
	ValaList* parameters;
	ValaList* versioning;
	gchar** see_also;
	gint see_also_length1;
	GtkdocCommentConverterPrivate * priv;
};

struct _GtkdocCommentConverterClass {
	ValadocContentContentVisitorClass parent_class;
};

struct _GtkdocCommentConverterPrivate {
	GString* current_builder;
	gboolean in_brief_comment;
	ValadocErrorReporter* reporter;
};

static gint GtkdocCommentConverter_private_offset;
static gpointer gtkdoc_comment_converter_parent_class = NULL;

GType gtkdoc_comment_converter_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocCommentConverter, g_object_unref)
gpointer gtkdoc_header_ref (gpointer instance);
void gtkdoc_header_unref (gpointer instance);
GParamSpec* gtkdoc_param_spec_header (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
void gtkdoc_value_set_header (GValue* value,
                              gpointer v_object);
void gtkdoc_value_take_header (GValue* value,
                               gpointer v_object);
gpointer gtkdoc_value_get_header (const GValue* value);
GType gtkdoc_header_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GtkdocHeader, gtkdoc_header_unref)
GtkdocCommentConverter* gtkdoc_comment_converter_new (ValadocErrorReporter* reporter,
                                                      ValadocApiNode* node_reference);
GtkdocCommentConverter* gtkdoc_comment_converter_construct (GType object_type,
                                                            ValadocErrorReporter* reporter,
                                                            ValadocApiNode* node_reference);
void gtkdoc_comment_converter_convert (GtkdocCommentConverter* self,
                                       ValadocContentComment* comment,
                                       gboolean is_dbus);
static void gtkdoc_comment_converter_real_visit_comment (ValadocContentContentVisitor* base,
                                                  ValadocContentComment* c);
static void gtkdoc_comment_converter_real_visit_embedded (ValadocContentContentVisitor* base,
                                                   ValadocContentEmbedded* em);
static void gtkdoc_comment_converter_real_visit_headline (ValadocContentContentVisitor* base,
                                                   ValadocContentHeadline* hl);
static void gtkdoc_comment_converter_real_visit_wiki_link (ValadocContentContentVisitor* base,
                                                    ValadocContentWikiLink* link);
static void gtkdoc_comment_converter_real_visit_link (ValadocContentContentVisitor* base,
                                               ValadocContentLink* link);
static void gtkdoc_comment_converter_real_visit_symbol_link (ValadocContentContentVisitor* base,
                                                      ValadocContentSymbolLink* sl);
gchar* gtkdoc_get_docbook_link (ValadocApiItem* item,
                                gboolean is_dbus,
                                gboolean is_async_finish);
static void gtkdoc_comment_converter_real_visit_list (ValadocContentContentVisitor* base,
                                               ValadocContentList* list);
static void gtkdoc_comment_converter_real_visit_list_item (ValadocContentContentVisitor* base,
                                                    ValadocContentListItem* item);
static void gtkdoc_comment_converter_real_visit_paragraph (ValadocContentContentVisitor* base,
                                                    ValadocContentParagraph* para);
static void gtkdoc_comment_converter_real_visit_warning (ValadocContentContentVisitor* base,
                                                  ValadocContentWarning* element);
static void gtkdoc_comment_converter_real_visit_note (ValadocContentContentVisitor* base,
                                               ValadocContentNote* element);
static void gtkdoc_comment_converter_real_visit_page (ValadocContentContentVisitor* base,
                                               ValadocContentPage* page);
static void gtkdoc_comment_converter_real_visit_run (ValadocContentContentVisitor* base,
                                              ValadocContentRun* run);
static void gtkdoc_comment_converter_real_visit_source_code (ValadocContentContentVisitor* base,
                                                      ValadocContentSourceCode* code);
static void gtkdoc_comment_converter_real_visit_table (ValadocContentContentVisitor* base,
                                                ValadocContentTable* t);
static void gtkdoc_comment_converter_real_visit_table_row (ValadocContentContentVisitor* base,
                                                    ValadocContentTableRow* row);
static void gtkdoc_comment_converter_real_visit_table_cell (ValadocContentContentVisitor* base,
                                                     ValadocContentTableCell* cell);
static void gtkdoc_comment_converter_real_visit_taglet (ValadocContentContentVisitor* base,
                                                 ValadocContentTaglet* t);
gdouble gtkdoc_get_parameter_pos (ValadocApiNode* node,
                                  const gchar* name);
GtkdocHeader* gtkdoc_header_new (const gchar* name,
                                 const gchar* value,
                                 gdouble pos,
                                 gboolean block);
GtkdocHeader* gtkdoc_header_construct (GType object_type,
                                       const gchar* name,
                                       const gchar* value,
                                       gdouble pos,
                                       gboolean block);
static gchar** _vala_array_dup1 (gchar** self,
                          int length);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static gchar** _vala_array_dup2 (gchar** self,
                          int length);
static void gtkdoc_comment_converter_real_visit_text (ValadocContentContentVisitor* base,
                                               ValadocContentText* t);
static void gtkdoc_comment_converter_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gtkdoc_comment_converter_get_instance_private (GtkdocCommentConverter* self)
{
	return G_STRUCT_MEMBER_P (self, GtkdocCommentConverter_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GtkdocCommentConverter*
gtkdoc_comment_converter_construct (GType object_type,
                                    ValadocErrorReporter* reporter,
                                    ValadocApiNode* node_reference)
{
	GtkdocCommentConverter * self = NULL;
	ValadocApiNode* _tmp0_;
	ValadocErrorReporter* _tmp1_;
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (GtkdocCommentConverter*) valadoc_content_content_visitor_construct (object_type);
	_tmp0_ = _g_object_ref0 (node_reference);
	_g_object_unref0 (self->node_reference);
	self->node_reference = _tmp0_;
	_tmp1_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->priv->reporter);
	self->priv->reporter = _tmp1_;
	return self;
}

GtkdocCommentConverter*
gtkdoc_comment_converter_new (ValadocErrorReporter* reporter,
                              ValadocApiNode* node_reference)
{
	return gtkdoc_comment_converter_construct (GTKDOC_TYPE_COMMENT_CONVERTER, reporter, node_reference);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}

void
gtkdoc_comment_converter_convert (GtkdocCommentConverter* self,
                                  ValadocContentComment* comment,
                                  gboolean is_dbus)
{
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	self->is_dbus = is_dbus;
	valadoc_content_content_element_accept ((ValadocContentContentElement*) comment, (ValadocContentContentVisitor*) self);
	_tmp0_ = self->priv->current_builder;
	_tmp1_ = _tmp0_->str;
	_tmp2_ = string_strip (_tmp1_);
	_g_free0 (self->long_comment);
	self->long_comment = _tmp2_;
	_tmp3_ = self->long_comment;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		_g_free0 (self->long_comment);
		self->long_comment = NULL;
	}
}

static void
gtkdoc_comment_converter_real_visit_comment (ValadocContentContentVisitor* base,
                                             ValadocContentComment* c)
{
	GtkdocCommentConverter * self;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (c != NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) c, (ValadocContentContentVisitor*) self);
}

static void
gtkdoc_comment_converter_real_visit_embedded (ValadocContentContentVisitor* base,
                                              ValadocContentEmbedded* em)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GString* _tmp14_;
	GString* _tmp15_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (em != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<figure>");
	_tmp1_ = valadoc_content_embedded_get_caption (em);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GString* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->current_builder;
		_tmp4_ = valadoc_content_embedded_get_caption (em);
		_tmp5_ = _tmp4_;
		g_string_append_printf (_tmp3_, "<title>%s</title>", _tmp5_);
	}
	_tmp6_ = self->priv->current_builder;
	_tmp7_ = valadoc_content_embedded_get_url (em);
	_tmp8_ = _tmp7_;
	g_string_append_printf (_tmp6_, "<mediaobject><imageobject><imagedata fileref=\"%s\"/></imageobject>", _tmp8_);
	_tmp9_ = valadoc_content_embedded_get_caption (em);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		GString* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp11_ = self->priv->current_builder;
		_tmp12_ = valadoc_content_embedded_get_caption (em);
		_tmp13_ = _tmp12_;
		g_string_append_printf (_tmp11_, "<textobject><phrase>%s</phrase></textobject>", _tmp13_);
	}
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) em, (ValadocContentContentVisitor*) self);
	_tmp14_ = self->priv->current_builder;
	g_string_append (_tmp14_, "</mediaobject>");
	_tmp15_ = self->priv->current_builder;
	g_string_append (_tmp15_, "</figure>");
}

static void
gtkdoc_comment_converter_real_visit_headline (ValadocContentContentVisitor* base,
                                              ValadocContentHeadline* hl)
{
	GtkdocCommentConverter * self;
	ValadocErrorReporter* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (hl != NULL);
	_tmp0_ = self->priv->reporter;
	valadoc_error_reporter_simple_warning (_tmp0_, "GtkDoc", "Headline elements not supported");
	_tmp1_ = self->priv->current_builder;
	g_string_append (_tmp1_, "\n");
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) hl, (ValadocContentContentVisitor*) self);
	_tmp2_ = self->priv->current_builder;
	g_string_append (_tmp2_, "\n");
}

static void
gtkdoc_comment_converter_real_visit_wiki_link (ValadocContentContentVisitor* base,
                                               ValadocContentWikiLink* link)
{
	GtkdocCommentConverter * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (link != NULL);
	_tmp0_ = valadoc_content_inline_content_get_content ((ValadocContentInlineContent*) link);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		valadoc_content_content_element_accept_children ((ValadocContentContentElement*) link, (ValadocContentContentVisitor*) self);
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->current_builder;
		_tmp5_ = valadoc_content_wiki_link_get_name (link);
		_tmp6_ = _tmp5_;
		g_string_append (_tmp4_, _tmp6_);
	}
}

static void
gtkdoc_comment_converter_real_visit_link (ValadocContentContentVisitor* base,
                                          ValadocContentLink* link)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GString* _tmp3_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (link != NULL);
	_tmp0_ = self->priv->current_builder;
	_tmp1_ = valadoc_content_link_get_url (link);
	_tmp2_ = _tmp1_;
	g_string_append_printf (_tmp0_, "<ulink url=\"%s\">", _tmp2_);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) link, (ValadocContentContentVisitor*) self);
	_tmp3_ = self->priv->current_builder;
	g_string_append (_tmp3_, "</ulink>");
}

static void
gtkdoc_comment_converter_real_visit_symbol_link (ValadocContentContentVisitor* base,
                                                 ValadocContentSymbolLink* sl)
{
	GtkdocCommentConverter * self;
	ValadocApiNode* _tmp0_;
	ValadocApiNode* _tmp1_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (sl != NULL);
	_tmp0_ = valadoc_content_symbol_link_get_symbol (sl);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ValadocApiNode* _tmp5_;
		ValadocApiNode* _tmp6_;
		_tmp5_ = valadoc_content_symbol_link_get_symbol (sl);
		_tmp6_ = _tmp5_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALADOC_API_TYPE_METHOD)) {
			ValadocApiNode* _tmp7_;
			ValadocApiNode* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp7_ = valadoc_content_symbol_link_get_symbol (sl);
			_tmp8_ = _tmp7_;
			_tmp9_ = valadoc_api_method_get_is_constructor (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_tmp10_ = _tmp9_;
			_tmp4_ = _tmp10_;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValadocApiNode* _tmp11_;
			ValadocApiNode* _tmp12_;
			ValadocApiItem* _tmp13_;
			ValadocApiItem* _tmp14_;
			_tmp11_ = valadoc_content_symbol_link_get_symbol (sl);
			_tmp12_ = _tmp11_;
			_tmp13_ = valadoc_api_item_get_parent ((ValadocApiItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_tmp14_ = _tmp13_;
			_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALADOC_API_TYPE_CLASS);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			ValadocApiNode* _tmp15_;
			ValadocApiNode* _tmp16_;
			ValadocApiItem* _tmp17_;
			ValadocApiItem* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = valadoc_content_symbol_link_get_symbol (sl);
			_tmp16_ = _tmp15_;
			_tmp17_ = valadoc_api_item_get_parent ((ValadocApiItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_tmp18_ = _tmp17_;
			_tmp19_ = valadoc_api_class_get_is_abstract (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp20_ = _tmp19_;
			_tmp2_ = _tmp20_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			gchar* _tmp21_ = NULL;
			ValadocApiNode* _tmp22_;
			ValadocApiNode* _tmp23_;
			ValadocApiItem* _tmp24_;
			ValadocApiItem* _tmp25_;
			gchar* _tmp26_;
			GString* _tmp30_;
			_tmp22_ = valadoc_content_symbol_link_get_symbol (sl);
			_tmp23_ = _tmp22_;
			_tmp24_ = valadoc_api_item_get_parent ((ValadocApiItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALADOC_API_TYPE_METHOD, ValadocApiMethod));
			_tmp25_ = _tmp24_;
			_tmp26_ = gtkdoc_get_docbook_link (_tmp25_, self->is_dbus, FALSE);
			_tmp21_ = _tmp26_;
			if (_tmp21_ == NULL) {
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp27_ = valadoc_content_symbol_link_get_given_symbol_name (sl);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strdup (_tmp28_);
				_g_free0 (_tmp21_);
				_tmp21_ = _tmp29_;
			}
			_tmp30_ = self->priv->current_builder;
			g_string_append (_tmp30_, _tmp21_);
			_g_free0 (_tmp21_);
		} else {
			gchar* _tmp31_ = NULL;
			ValadocApiNode* _tmp32_;
			ValadocApiNode* _tmp33_;
			gchar* _tmp34_;
			GString* _tmp38_;
			_tmp32_ = valadoc_content_symbol_link_get_symbol (sl);
			_tmp33_ = _tmp32_;
			_tmp34_ = gtkdoc_get_docbook_link ((ValadocApiItem*) _tmp33_, self->is_dbus, FALSE);
			_tmp31_ = _tmp34_;
			if (_tmp31_ == NULL) {
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp35_ = valadoc_content_symbol_link_get_given_symbol_name (sl);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strdup (_tmp36_);
				_g_free0 (_tmp31_);
				_tmp31_ = _tmp37_;
			}
			_tmp38_ = self->priv->current_builder;
			g_string_append (_tmp38_, _tmp31_);
			_g_free0 (_tmp31_);
		}
	} else {
		GString* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp39_ = self->priv->current_builder;
		_tmp40_ = valadoc_content_symbol_link_get_given_symbol_name (sl);
		_tmp41_ = _tmp40_;
		g_string_append (_tmp39_, _tmp41_);
	}
}

static void
gtkdoc_comment_converter_real_visit_list (ValadocContentContentVisitor* base,
                                          ValadocContentList* list)
{
	GtkdocCommentConverter * self;
	gchar* tag = NULL;
	gchar* _tmp0_;
	ValadocContentListBullet _tmp1_;
	ValadocContentListBullet _tmp2_;
	GString* _tmp17_;
	const gchar* _tmp18_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (list != NULL);
	_tmp0_ = g_strdup ("orderedlist");
	tag = _tmp0_;
	_tmp1_ = valadoc_content_list_get_bullet (list);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case VALADOC_CONTENT_LIST_BULLET_NONE:
		{
			GString* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = self->priv->current_builder;
			g_string_append (_tmp3_, "<itemizedlist mark=\"none\">");
			_tmp4_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp4_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_UNORDERED:
		{
			GString* _tmp5_;
			gchar* _tmp6_;
			_tmp5_ = self->priv->current_builder;
			g_string_append (_tmp5_, "<itemizedlist>");
			_tmp6_ = g_strdup ("itemizedlist");
			_g_free0 (tag);
			tag = _tmp6_;
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED:
		{
			GString* _tmp7_;
			_tmp7_ = self->priv->current_builder;
			g_string_append (_tmp7_, "<orderedlist>");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_NUMBER:
		{
			GString* _tmp8_;
			_tmp8_ = self->priv->current_builder;
			g_string_append (_tmp8_, "<orderedlist numeration=\"arabic\">");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ALPHA:
		{
			GString* _tmp9_;
			_tmp9_ = self->priv->current_builder;
			g_string_append (_tmp9_, "<orderedlist numeration=\"loweralpha\">");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ALPHA:
		{
			GString* _tmp10_;
			_tmp10_ = self->priv->current_builder;
			g_string_append (_tmp10_, "<orderedlist numeration=\"upperalpha\">");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_LOWER_CASE_ROMAN:
		{
			GString* _tmp11_;
			_tmp11_ = self->priv->current_builder;
			g_string_append (_tmp11_, "<orderedlist numeration=\"lowerroman\">");
			break;
		}
		case VALADOC_CONTENT_LIST_BULLET_ORDERED_UPPER_CASE_ROMAN:
		{
			GString* _tmp12_;
			_tmp12_ = self->priv->current_builder;
			g_string_append (_tmp12_, "<orderedlist numeration=\"upperroman\">");
			break;
		}
		default:
		{
			ValadocErrorReporter* _tmp13_;
			ValadocContentListBullet _tmp14_;
			ValadocContentListBullet _tmp15_;
			const gchar* _tmp16_;
			_tmp13_ = self->priv->reporter;
			_tmp14_ = valadoc_content_list_get_bullet (list);
			_tmp15_ = _tmp14_;
			_tmp16_ = valadoc_content_list_bullet_to_string (_tmp15_);
			valadoc_error_reporter_simple_warning (_tmp13_, "GtkDoc", "unsupported list type: '%s'", _tmp16_);
			break;
		}
	}
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) list, (ValadocContentContentVisitor*) self);
	_tmp17_ = self->priv->current_builder;
	_tmp18_ = tag;
	g_string_append_printf (_tmp17_, "</%s>", _tmp18_);
	_g_free0 (tag);
}

static void
gtkdoc_comment_converter_real_visit_list_item (ValadocContentContentVisitor* base,
                                               ValadocContentListItem* item)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	GString* _tmp1_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<listitem>");
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) item, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->current_builder;
	g_string_append (_tmp1_, "</listitem>");
}

static void
gtkdoc_comment_converter_real_visit_paragraph (ValadocContentContentVisitor* base,
                                               ValadocContentParagraph* para)
{
	GtkdocCommentConverter * self;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (para != NULL);
	if (!self->priv->in_brief_comment) {
		GString* _tmp0_;
		_tmp0_ = self->priv->current_builder;
		g_string_append (_tmp0_, "<para>");
	}
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) para, (ValadocContentContentVisitor*) self);
	if (self->priv->in_brief_comment) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		GString* _tmp4_;
		_tmp1_ = self->priv->current_builder;
		_tmp2_ = _tmp1_->str;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (self->brief_comment);
		self->brief_comment = _tmp3_;
		_tmp4_ = g_string_new ("");
		_g_string_free0 (self->priv->current_builder);
		self->priv->current_builder = _tmp4_;
		self->priv->in_brief_comment = FALSE;
	} else {
		GString* _tmp5_;
		_tmp5_ = self->priv->current_builder;
		g_string_append (_tmp5_, "</para>");
	}
}

static void
gtkdoc_comment_converter_real_visit_warning (ValadocContentContentVisitor* base,
                                             ValadocContentWarning* element)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	GString* _tmp1_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<warning>");
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->current_builder;
	g_string_append (_tmp1_, "</warning>");
}

static void
gtkdoc_comment_converter_real_visit_note (ValadocContentContentVisitor* base,
                                          ValadocContentNote* element)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	GString* _tmp1_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (element != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<note>");
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) element, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->current_builder;
	g_string_append (_tmp1_, "</note>");
}

static void
gtkdoc_comment_converter_real_visit_page (ValadocContentContentVisitor* base,
                                          ValadocContentPage* page)
{
	GtkdocCommentConverter * self;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (page != NULL);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) page, (ValadocContentContentVisitor*) self);
}

static void
gtkdoc_comment_converter_real_visit_run (ValadocContentContentVisitor* base,
                                         ValadocContentRun* run)
{
	GtkdocCommentConverter * self;
	gchar* tag = NULL;
	ValadocContentRunStyle _tmp0_;
	ValadocContentRunStyle _tmp1_;
	const gchar* _tmp10_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (run != NULL);
	tag = NULL;
	_tmp0_ = valadoc_content_run_get_style (run);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALADOC_CONTENT_RUN_STYLE_BOLD:
		{
			GString* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = self->priv->current_builder;
			g_string_append (_tmp2_, "<emphasis role=\"bold\">");
			_tmp3_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp3_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_ITALIC:
		{
			GString* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = self->priv->current_builder;
			g_string_append (_tmp4_, "<emphasis>");
			_tmp5_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp5_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_UNDERLINED:
		{
			GString* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = self->priv->current_builder;
			g_string_append (_tmp6_, "<emphasis role=\"underline\">");
			_tmp7_ = g_strdup ("emphasis");
			_g_free0 (tag);
			tag = _tmp7_;
			break;
		}
		case VALADOC_CONTENT_RUN_STYLE_MONOSPACED:
		{
			GString* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = self->priv->current_builder;
			g_string_append (_tmp8_, "<code>");
			_tmp9_ = g_strdup ("code");
			_g_free0 (tag);
			tag = _tmp9_;
			break;
		}
		default:
		{
			break;
		}
	}
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) run, (ValadocContentContentVisitor*) self);
	_tmp10_ = tag;
	if (_tmp10_ != NULL) {
		GString* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = self->priv->current_builder;
		_tmp12_ = tag;
		g_string_append_printf (_tmp11_, "</%s>", _tmp12_);
	}
	_g_free0 (tag);
}

static void
gtkdoc_comment_converter_real_visit_source_code (ValadocContentContentVisitor* base,
                                                 ValadocContentSourceCode* code)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GString* _tmp6_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (code != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "\n|[\n");
	_tmp1_ = self->priv->current_builder;
	_tmp2_ = valadoc_content_source_code_get_code (code);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) -1);
	_tmp5_ = _tmp4_;
	g_string_append (_tmp1_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->current_builder;
	g_string_append (_tmp6_, "\n]|\n");
}

static void
gtkdoc_comment_converter_real_visit_table (ValadocContentContentVisitor* base,
                                           ValadocContentTable* t)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	GString* _tmp1_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<table>");
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) t, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->current_builder;
	g_string_append (_tmp1_, "</table>");
}

static void
gtkdoc_comment_converter_real_visit_table_row (ValadocContentContentVisitor* base,
                                               ValadocContentTableRow* row)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	GString* _tmp1_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (row != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<tr>");
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) row, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->current_builder;
	g_string_append (_tmp1_, "</tr>");
}

static void
gtkdoc_comment_converter_real_visit_table_cell (ValadocContentContentVisitor* base,
                                                ValadocContentTableCell* cell)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	GString* _tmp1_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (cell != NULL);
	_tmp0_ = self->priv->current_builder;
	g_string_append (_tmp0_, "<td>");
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) cell, (ValadocContentContentVisitor*) self);
	_tmp1_ = self->priv->current_builder;
	g_string_append (_tmp1_, "</td>");
}

static gchar**
_vala_array_dup1 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

static void
gtkdoc_comment_converter_real_visit_taglet (ValadocContentContentVisitor* base,
                                            ValadocContentTaglet* t)
{
	GtkdocCommentConverter * self;
	GString* old_builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp71_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->current_builder;
	self->priv->current_builder = NULL;
	old_builder = _tmp0_;
	_tmp1_ = g_string_new ("");
	_g_string_free0 (self->priv->current_builder);
	self->priv->current_builder = _tmp1_;
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) t, (ValadocContentContentVisitor*) self);
	if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALADOC_TAGLETS_TYPE_PARAM)) {
		gdouble pos = 0.0;
		gchar* param_name = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		ValadocApiNode* _tmp5_;
		GtkdocHeader* header = NULL;
		const gchar* _tmp8_;
		GString* _tmp9_;
		const gchar* _tmp10_;
		GtkdocHeader* _tmp11_;
		ValaList* _tmp12_;
		GtkdocHeader* _tmp13_;
		pos = DBL_MAX;
		_tmp2_ = valadoc_taglets_param_get_parameter_name (G_TYPE_CHECK_INSTANCE_CAST (t, VALADOC_TAGLETS_TYPE_PARAM, ValadocTagletsParam));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		param_name = _tmp4_;
		_tmp5_ = self->node_reference;
		if (_tmp5_ != NULL) {
			ValadocApiNode* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->node_reference;
			_tmp7_ = param_name;
			pos = gtkdoc_get_parameter_pos (_tmp6_, _tmp7_);
		}
		_tmp8_ = param_name;
		_tmp9_ = self->priv->current_builder;
		_tmp10_ = _tmp9_->str;
		_tmp11_ = gtkdoc_header_new (_tmp8_, _tmp10_, pos, TRUE);
		header = _tmp11_;
		_tmp12_ = self->parameters;
		_tmp13_ = header;
		vala_collection_add ((ValaCollection*) _tmp12_, _tmp13_);
		_gtkdoc_header_unref0 (header);
		_g_free0 (param_name);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALADOC_TAGLETS_TYPE_INHERIT_DOC)) {
			ValadocContentContentElement* _tmp14_;
			ValadocContentContentElement* _tmp15_;
			_tmp14_ = valadoc_content_inline_taglet_produce_content ((ValadocContentInlineTaglet*) G_TYPE_CHECK_INSTANCE_CAST (t, VALADOC_TAGLETS_TYPE_INHERIT_DOC, ValadocTagletsInheritDoc));
			_tmp15_ = _tmp14_;
			valadoc_content_content_element_accept (_tmp15_, (ValadocContentContentVisitor*) self);
			_g_object_unref0 (_tmp15_);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALADOC_TAGLETS_TYPE_RETURN)) {
				GString* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp16_ = self->priv->current_builder;
				_tmp17_ = _tmp16_->str;
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (self->returns);
				self->returns = _tmp18_;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALADOC_TAGLETS_TYPE_SINCE)) {
					GtkdocHeader* header = NULL;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					GtkdocHeader* _tmp21_;
					ValaList* _tmp22_;
					GtkdocHeader* _tmp23_;
					_tmp19_ = valadoc_taglets_since_get_version (G_TYPE_CHECK_INSTANCE_CAST (t, VALADOC_TAGLETS_TYPE_SINCE, ValadocTagletsSince));
					_tmp20_ = _tmp19_;
					_tmp21_ = gtkdoc_header_new ("Since", _tmp20_, DBL_MAX, TRUE);
					header = _tmp21_;
					_tmp22_ = self->versioning;
					_tmp23_ = header;
					vala_collection_add ((ValaCollection*) _tmp22_, _tmp23_);
					_gtkdoc_header_unref0 (header);
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALADOC_TAGLETS_TYPE_DEPRECATED)) {
						GtkdocHeader* header = NULL;
						GString* _tmp24_;
						const gchar* _tmp25_;
						GtkdocHeader* _tmp26_;
						ValaList* _tmp27_;
						GtkdocHeader* _tmp28_;
						_tmp24_ = self->priv->current_builder;
						_tmp25_ = _tmp24_->str;
						_tmp26_ = gtkdoc_header_new ("Deprecated", _tmp25_, DBL_MAX, TRUE);
						header = _tmp26_;
						_tmp27_ = self->versioning;
						_tmp28_ = header;
						vala_collection_add ((ValaCollection*) _tmp27_, _tmp28_);
						_gtkdoc_header_unref0 (header);
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALADOC_TAGLETS_TYPE_SEE)) {
							ValadocTagletsSee* see = NULL;
							ValadocTagletsSee* _tmp29_;
							gchar** see_also = NULL;
							gchar** _tmp30_;
							gint _tmp30__length1;
							gchar** _tmp31_;
							gint _tmp31__length1;
							gint see_also_length1;
							gint _see_also_size_;
							ValadocTagletsSee* _tmp32_;
							ValadocApiNode* _tmp33_;
							ValadocApiNode* _tmp34_;
							gchar** _tmp51_;
							gint _tmp51__length1;
							gchar** _tmp52_;
							gint _tmp52__length1;
							_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (t, VALADOC_TAGLETS_TYPE_SEE, ValadocTagletsSee));
							see = _tmp29_;
							_tmp30_ = self->see_also;
							_tmp30__length1 = self->see_also_length1;
							_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup1 (_tmp30_, _tmp30__length1) : ((gpointer) _tmp30_);
							_tmp31__length1 = _tmp30__length1;
							see_also = _tmp31_;
							see_also_length1 = _tmp31__length1;
							_see_also_size_ = see_also_length1;
							_tmp32_ = see;
							_tmp33_ = valadoc_taglets_see_get_symbol (_tmp32_);
							_tmp34_ = _tmp33_;
							if (_tmp34_ != NULL) {
								gchar* _tmp35_ = NULL;
								ValadocTagletsSee* _tmp36_;
								ValadocApiNode* _tmp37_;
								ValadocApiNode* _tmp38_;
								gchar* _tmp39_;
								gchar** _tmp44_;
								gint _tmp44__length1;
								gchar* _tmp45_;
								_tmp36_ = see;
								_tmp37_ = valadoc_taglets_see_get_symbol (_tmp36_);
								_tmp38_ = _tmp37_;
								_tmp39_ = gtkdoc_get_docbook_link ((ValadocApiItem*) _tmp38_, self->is_dbus, FALSE);
								_tmp35_ = _tmp39_;
								if (_tmp35_ == NULL) {
									ValadocTagletsSee* _tmp40_;
									const gchar* _tmp41_;
									const gchar* _tmp42_;
									gchar* _tmp43_;
									_tmp40_ = see;
									_tmp41_ = valadoc_taglets_see_get_symbol_name (_tmp40_);
									_tmp42_ = _tmp41_;
									_tmp43_ = g_strdup (_tmp42_);
									_g_free0 (_tmp35_);
									_tmp35_ = _tmp43_;
								}
								_tmp44_ = see_also;
								_tmp44__length1 = see_also_length1;
								_tmp45_ = _tmp35_;
								_tmp35_ = NULL;
								_vala_array_add1 (&see_also, &see_also_length1, &_see_also_size_, _tmp45_);
								_g_free0 (_tmp35_);
							} else {
								gchar** _tmp46_;
								gint _tmp46__length1;
								ValadocTagletsSee* _tmp47_;
								const gchar* _tmp48_;
								const gchar* _tmp49_;
								gchar* _tmp50_;
								_tmp46_ = see_also;
								_tmp46__length1 = see_also_length1;
								_tmp47_ = see;
								_tmp48_ = valadoc_taglets_see_get_symbol_name (_tmp47_);
								_tmp49_ = _tmp48_;
								_tmp50_ = g_strdup (_tmp49_);
								_vala_array_add2 (&see_also, &see_also_length1, &_see_also_size_, _tmp50_);
							}
							_tmp51_ = see_also;
							_tmp51__length1 = see_also_length1;
							_tmp52_ = (_tmp51_ != NULL) ? _vala_array_dup2 (_tmp51_, _tmp51__length1) : ((gpointer) _tmp51_);
							_tmp52__length1 = _tmp51__length1;
							self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
							self->see_also = _tmp52_;
							self->see_also_length1 = _tmp52__length1;
							see_also = (_vala_array_free (see_also, see_also_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (see);
						} else {
							if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALADOC_TAGLETS_TYPE_LINK)) {
								ValadocContentContentElement* _tmp53_;
								ValadocContentContentElement* _tmp54_;
								_tmp53_ = valadoc_content_inline_taglet_produce_content ((ValadocContentInlineTaglet*) G_TYPE_CHECK_INSTANCE_CAST (t, VALADOC_TAGLETS_TYPE_LINK, ValadocTagletsLink));
								_tmp54_ = _tmp53_;
								valadoc_content_content_element_accept (_tmp54_, (ValadocContentContentVisitor*) self);
								_g_object_unref0 (_tmp54_);
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALADOC_TAGLETS_TYPE_THROWS)) {
									ValadocTagletsThrows* taglet = NULL;
									ValadocTagletsThrows* _tmp55_;
									gchar* _tmp56_ = NULL;
									ValadocTagletsThrows* _tmp57_;
									ValadocApiNode* _tmp58_;
									ValadocApiNode* _tmp59_;
									gchar* _tmp60_;
									gchar* link = NULL;
									gchar* _tmp65_;
									GString* _tmp66_;
									const gchar* _tmp67_;
									GString* _tmp68_;
									const gchar* _tmp69_;
									_tmp55_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (t, VALADOC_TAGLETS_TYPE_THROWS, ValadocTagletsThrows));
									taglet = _tmp55_;
									_tmp57_ = taglet;
									_tmp58_ = valadoc_taglets_throws_get_error_domain (_tmp57_);
									_tmp59_ = _tmp58_;
									_tmp60_ = gtkdoc_get_docbook_link ((ValadocApiItem*) _tmp59_, FALSE, FALSE);
									_tmp56_ = _tmp60_;
									if (_tmp56_ == NULL) {
										ValadocTagletsThrows* _tmp61_;
										const gchar* _tmp62_;
										const gchar* _tmp63_;
										gchar* _tmp64_;
										_tmp61_ = taglet;
										_tmp62_ = valadoc_taglets_throws_get_error_domain_name (_tmp61_);
										_tmp63_ = _tmp62_;
										_tmp64_ = g_strdup (_tmp63_);
										_g_free0 (_tmp56_);
										_tmp56_ = _tmp64_;
									}
									_tmp65_ = g_strdup (_tmp56_);
									link = _tmp65_;
									_tmp66_ = old_builder;
									_tmp67_ = link;
									_tmp68_ = self->priv->current_builder;
									_tmp69_ = _tmp68_->str;
									g_string_append_printf (_tmp66_, "\n<para>%s will be returned in @error %s</para>", _tmp67_, _tmp69_);
									_g_free0 (link);
									_g_free0 (_tmp56_);
									_g_object_unref0 (taglet);
								} else {
									ValadocErrorReporter* _tmp70_;
									_tmp70_ = self->priv->reporter;
									valadoc_error_reporter_simple_warning (_tmp70_, "GtkDoc", "Taglet not supported");
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp71_ = old_builder;
	old_builder = NULL;
	_g_string_free0 (self->priv->current_builder);
	self->priv->current_builder = _tmp71_;
	_g_string_free0 (old_builder);
}

static void
gtkdoc_comment_converter_real_visit_text (ValadocContentContentVisitor* base,
                                          ValadocContentText* t)
{
	GtkdocCommentConverter * self;
	GString* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = (GtkdocCommentConverter*) base;
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->current_builder;
	_tmp1_ = valadoc_content_text_get_content (t);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_markup_escape_text (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	g_string_append (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	valadoc_content_content_element_accept_children ((ValadocContentContentElement*) t, (ValadocContentContentVisitor*) self);
}

static void
gtkdoc_comment_converter_class_init (GtkdocCommentConverterClass * klass,
                                     gpointer klass_data)
{
	gtkdoc_comment_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GtkdocCommentConverter_private_offset);
	((ValadocContentContentVisitorClass *) klass)->visit_comment = (void (*) (ValadocContentContentVisitor*, ValadocContentComment*)) gtkdoc_comment_converter_real_visit_comment;
	((ValadocContentContentVisitorClass *) klass)->visit_embedded = (void (*) (ValadocContentContentVisitor*, ValadocContentEmbedded*)) gtkdoc_comment_converter_real_visit_embedded;
	((ValadocContentContentVisitorClass *) klass)->visit_headline = (void (*) (ValadocContentContentVisitor*, ValadocContentHeadline*)) gtkdoc_comment_converter_real_visit_headline;
	((ValadocContentContentVisitorClass *) klass)->visit_wiki_link = (void (*) (ValadocContentContentVisitor*, ValadocContentWikiLink*)) gtkdoc_comment_converter_real_visit_wiki_link;
	((ValadocContentContentVisitorClass *) klass)->visit_link = (void (*) (ValadocContentContentVisitor*, ValadocContentLink*)) gtkdoc_comment_converter_real_visit_link;
	((ValadocContentContentVisitorClass *) klass)->visit_symbol_link = (void (*) (ValadocContentContentVisitor*, ValadocContentSymbolLink*)) gtkdoc_comment_converter_real_visit_symbol_link;
	((ValadocContentContentVisitorClass *) klass)->visit_list = (void (*) (ValadocContentContentVisitor*, ValadocContentList*)) gtkdoc_comment_converter_real_visit_list;
	((ValadocContentContentVisitorClass *) klass)->visit_list_item = (void (*) (ValadocContentContentVisitor*, ValadocContentListItem*)) gtkdoc_comment_converter_real_visit_list_item;
	((ValadocContentContentVisitorClass *) klass)->visit_paragraph = (void (*) (ValadocContentContentVisitor*, ValadocContentParagraph*)) gtkdoc_comment_converter_real_visit_paragraph;
	((ValadocContentContentVisitorClass *) klass)->visit_warning = (void (*) (ValadocContentContentVisitor*, ValadocContentWarning*)) gtkdoc_comment_converter_real_visit_warning;
	((ValadocContentContentVisitorClass *) klass)->visit_note = (void (*) (ValadocContentContentVisitor*, ValadocContentNote*)) gtkdoc_comment_converter_real_visit_note;
	((ValadocContentContentVisitorClass *) klass)->visit_page = (void (*) (ValadocContentContentVisitor*, ValadocContentPage*)) gtkdoc_comment_converter_real_visit_page;
	((ValadocContentContentVisitorClass *) klass)->visit_run = (void (*) (ValadocContentContentVisitor*, ValadocContentRun*)) gtkdoc_comment_converter_real_visit_run;
	((ValadocContentContentVisitorClass *) klass)->visit_source_code = (void (*) (ValadocContentContentVisitor*, ValadocContentSourceCode*)) gtkdoc_comment_converter_real_visit_source_code;
	((ValadocContentContentVisitorClass *) klass)->visit_table = (void (*) (ValadocContentContentVisitor*, ValadocContentTable*)) gtkdoc_comment_converter_real_visit_table;
	((ValadocContentContentVisitorClass *) klass)->visit_table_row = (void (*) (ValadocContentContentVisitor*, ValadocContentTableRow*)) gtkdoc_comment_converter_real_visit_table_row;
	((ValadocContentContentVisitorClass *) klass)->visit_table_cell = (void (*) (ValadocContentContentVisitor*, ValadocContentTableCell*)) gtkdoc_comment_converter_real_visit_table_cell;
	((ValadocContentContentVisitorClass *) klass)->visit_taglet = (void (*) (ValadocContentContentVisitor*, ValadocContentTaglet*)) gtkdoc_comment_converter_real_visit_taglet;
	((ValadocContentContentVisitorClass *) klass)->visit_text = (void (*) (ValadocContentContentVisitor*, ValadocContentText*)) gtkdoc_comment_converter_real_visit_text;
	G_OBJECT_CLASS (klass)->finalize = gtkdoc_comment_converter_finalize;
}

static void
gtkdoc_comment_converter_instance_init (GtkdocCommentConverter * self,
                                        gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	gchar** _tmp4_;
	GString* _tmp5_;
	self->priv = gtkdoc_comment_converter_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp0_);
	self->parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (GTKDOC_TYPE_HEADER, (GBoxedCopyFunc) gtkdoc_header_ref, (GDestroyNotify) gtkdoc_header_unref, _tmp2_);
	self->versioning = (ValaList*) _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	self->see_also = _tmp4_;
	self->see_also_length1 = 0;
	_tmp5_ = g_string_new ("");
	self->priv->current_builder = _tmp5_;
	self->priv->in_brief_comment = TRUE;
}

static void
gtkdoc_comment_converter_finalize (GObject * obj)
{
	GtkdocCommentConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GTKDOC_TYPE_COMMENT_CONVERTER, GtkdocCommentConverter);
	_g_object_unref0 (self->node_reference);
	_g_free0 (self->brief_comment);
	_g_free0 (self->long_comment);
	_g_free0 (self->returns);
	_vala_iterable_unref0 (self->parameters);
	_vala_iterable_unref0 (self->versioning);
	self->see_also = (_vala_array_free (self->see_also, self->see_also_length1, (GDestroyNotify) g_free), NULL);
	_g_string_free0 (self->priv->current_builder);
	_g_object_unref0 (self->priv->reporter);
	G_OBJECT_CLASS (gtkdoc_comment_converter_parent_class)->finalize (obj);
}

GType
gtkdoc_comment_converter_get_type (void)
{
	static volatile gsize gtkdoc_comment_converter_type_id__volatile = 0;
	if (g_once_init_enter (&gtkdoc_comment_converter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GtkdocCommentConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gtkdoc_comment_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GtkdocCommentConverter), 0, (GInstanceInitFunc) gtkdoc_comment_converter_instance_init, NULL };
		GType gtkdoc_comment_converter_type_id;
		gtkdoc_comment_converter_type_id = g_type_register_static (VALADOC_CONTENT_TYPE_CONTENT_VISITOR, "GtkdocCommentConverter", &g_define_type_info, 0);
		GtkdocCommentConverter_private_offset = g_type_add_instance_private (gtkdoc_comment_converter_type_id, sizeof (GtkdocCommentConverterPrivate));
		g_once_init_leave (&gtkdoc_comment_converter_type_id__volatile, gtkdoc_comment_converter_type_id);
	}
	return gtkdoc_comment_converter_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

