/* valaswitchsection.c generated by valac, the Vala compiler
 * generated from valaswitchsection.vala, do not modify */

/* valaswitchsection.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaSwitchSectionPrivate {
	ValaList* labels;
};

static gint ValaSwitchSection_private_offset;
static gpointer vala_switch_section_parent_class = NULL;

static void vala_switch_section_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_switch_section_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static gboolean vala_switch_section_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_switch_section_real_emit (ValaCodeNode* base,
                                    ValaCodeGenerator* codegen);
static void vala_switch_section_finalize (ValaCodeNode * obj);

static inline gpointer
vala_switch_section_get_instance_private (ValaSwitchSection* self)
{
	return G_STRUCT_MEMBER_P (self, ValaSwitchSection_private_offset);
}

/**
 * Creates a new switch section.
 *
 * @param source_reference reference to source code
 * @return                 newly created switch section
 */
ValaSwitchSection*
vala_switch_section_construct (GType object_type,
                               ValaSourceReference* source_reference)
{
	ValaSwitchSection* self = NULL;
	self = (ValaSwitchSection*) vala_block_construct (object_type, source_reference);
	return self;
}

ValaSwitchSection*
vala_switch_section_new (ValaSourceReference* source_reference)
{
	return vala_switch_section_construct (VALA_TYPE_SWITCH_SECTION, source_reference);
}

/**
 * Appends the specified label to the list of switch labels.
 *
 * @param label a switch label
 */
void
vala_switch_section_add_label (ValaSwitchSection* self,
                               ValaSwitchLabel* label)
{
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaList* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = self->priv->labels;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		ValaSourceReference* _tmp3_;
		ValaSourceReference* _tmp4_;
		_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) label);
		_tmp4_ = _tmp3_;
		vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp4_);
	}
	_tmp5_ = self->priv->labels;
	vala_collection_add ((ValaCollection*) _tmp5_, label);
	vala_code_node_set_parent_node ((ValaCodeNode*) label, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of switch labels.
 *
 * @return switch label list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

ValaList*
vala_switch_section_get_labels (ValaSwitchSection* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->labels;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
vala_switch_section_has_default_label (ValaSwitchSection* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaSwitchLabel* _tmp7_;
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp5_ = _label_list;
			_tmp6_ = vala_list_get (_tmp5_, _label_index);
			label = (ValaSwitchLabel*) _tmp6_;
			_tmp7_ = label;
			_tmp8_ = vala_switch_label_get_expression (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_ == NULL) {
				result = TRUE;
				_vala_code_node_unref0 (label);
				_vala_iterable_unref0 (_label_list);
				return result;
			}
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	result = FALSE;
	return result;
}

static void
vala_switch_section_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_switch_section (visitor, self);
}

static void
vala_switch_section_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaSwitchLabel* _tmp7_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp5_ = _label_list;
			_tmp6_ = vala_list_get (_tmp5_, _label_index);
			label = (ValaSwitchLabel*) _tmp6_;
			_tmp7_ = label;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), visitor);
}

static gboolean
vala_switch_section_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaSwitchSection * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean result = FALSE;
	self = (ValaSwitchSection*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp4_;
		gint _label_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _label_index = 0;
		_tmp4_ = vala_switch_section_get_labels (self);
		_label_list = _tmp4_;
		_tmp5_ = _label_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_label_size = _tmp7_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaSwitchLabel* _tmp10_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp8_ = _label_list;
			_tmp9_ = vala_list_get (_tmp8_, _label_index);
			label = (ValaSwitchLabel*) _tmp9_;
			_tmp10_ = label;
			vala_code_node_check ((ValaCodeNode*) _tmp10_, context);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	if (!VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp12_ = _tmp11_;
	result = !_tmp12_;
	return result;
}

static void
vala_switch_section_real_emit (ValaCodeNode* base,
                               ValaCodeGenerator* codegen)
{
	ValaSwitchSection * self;
	self = (ValaSwitchSection*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _label_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _label_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _label_index = 0;
		_tmp0_ = self->priv->labels;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_label_list = _tmp1_;
		_tmp2_ = _label_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_label_size = _tmp4_;
		_label_index = -1;
		while (TRUE) {
			ValaSwitchLabel* label = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaSwitchLabel* _tmp7_;
			_label_index = _label_index + 1;
			if (!(_label_index < _label_size)) {
				break;
			}
			_tmp5_ = _label_list;
			_tmp6_ = vala_list_get (_tmp5_, _label_index);
			label = (ValaSwitchLabel*) _tmp6_;
			_tmp7_ = label;
			vala_code_node_emit ((ValaCodeNode*) _tmp7_, codegen);
			_vala_code_node_unref0 (label);
		}
		_vala_iterable_unref0 (_label_list);
	}
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->emit ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_BLOCK, ValaBlock), codegen);
}

static void
vala_switch_section_class_init (ValaSwitchSectionClass * klass,
                                gpointer klass_data)
{
	vala_switch_section_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_switch_section_finalize;
	g_type_class_adjust_private_offset (klass, &ValaSwitchSection_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_switch_section_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_switch_section_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_switch_section_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_switch_section_real_emit;
}

static void
vala_switch_section_instance_init (ValaSwitchSection * self,
                                   gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_switch_section_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_SWITCH_LABEL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->labels = (ValaList*) _tmp1_;
}

static void
vala_switch_section_finalize (ValaCodeNode * obj)
{
	ValaSwitchSection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SWITCH_SECTION, ValaSwitchSection);
	_vala_iterable_unref0 (self->priv->labels);
	VALA_CODE_NODE_CLASS (vala_switch_section_parent_class)->finalize (obj);
}

/**
 * Represents a switch section in the source code.
 */
GType
vala_switch_section_get_type (void)
{
	static volatile gsize vala_switch_section_type_id__volatile = 0;
	if (g_once_init_enter (&vala_switch_section_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchSection), 0, (GInstanceInitFunc) vala_switch_section_instance_init, NULL };
		GType vala_switch_section_type_id;
		vala_switch_section_type_id = g_type_register_static (VALA_TYPE_BLOCK, "ValaSwitchSection", &g_define_type_info, 0);
		ValaSwitchSection_private_offset = g_type_add_instance_private (vala_switch_section_type_id, sizeof (ValaSwitchSectionPrivate));
		g_once_init_leave (&vala_switch_section_type_id__volatile, vala_switch_section_type_id);
	}
	return vala_switch_section_type_id__volatile;
}

