// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

#[cfg(feature = "futures")]
use futures::future;
use gio_sys;
use glib;
use glib::object::IsA;
use glib::translate::*;
use glib_sys;
use gobject_sys;
#[cfg(feature = "futures")]
use std::boxed::Box as Box_;
use std::fmt;
use std::ptr;
use Cancellable;
use Error;
use IOStream;
use Socket;
use SocketAddress;
use SocketFamily;
use SocketType;

glib_wrapper! {
    pub struct SocketConnection(Object<gio_sys::GSocketConnection, gio_sys::GSocketConnectionClass, SocketConnectionClass>) @extends IOStream;

    match fn {
        get_type => || gio_sys::g_socket_connection_get_type(),
    }
}

impl SocketConnection {
    pub fn factory_lookup_type(
        family: SocketFamily,
        type_: SocketType,
        protocol_id: i32,
    ) -> glib::types::Type {
        unsafe {
            from_glib(gio_sys::g_socket_connection_factory_lookup_type(
                family.to_glib(),
                type_.to_glib(),
                protocol_id,
            ))
        }
    }

    pub fn factory_register_type(
        g_type: glib::types::Type,
        family: SocketFamily,
        type_: SocketType,
        protocol: i32,
    ) {
        unsafe {
            gio_sys::g_socket_connection_factory_register_type(
                g_type.to_glib(),
                family.to_glib(),
                type_.to_glib(),
                protocol,
            );
        }
    }
}

pub const NONE_SOCKET_CONNECTION: Option<&SocketConnection> = None;

pub trait SocketConnectionExt: 'static {
    fn connect<P: IsA<SocketAddress>, Q: IsA<Cancellable>>(
        &self,
        address: &P,
        cancellable: Option<&Q>,
    ) -> Result<(), Error>;

    fn connect_async<
        P: IsA<SocketAddress>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), Error>) + Send + 'static,
    >(
        &self,
        address: &P,
        cancellable: Option<&Q>,
        callback: R,
    );

    #[cfg(feature = "futures")]
    fn connect_async_future<P: IsA<SocketAddress> + Clone + 'static>(
        &self,
        address: &P,
    ) -> Box_<dyn future::Future<Output = Result<(), Error>> + std::marker::Unpin>;

    fn get_local_address(&self) -> Result<SocketAddress, Error>;

    fn get_remote_address(&self) -> Result<SocketAddress, Error>;

    fn get_socket(&self) -> Option<Socket>;

    fn is_connected(&self) -> bool;
}

impl<O: IsA<SocketConnection>> SocketConnectionExt for O {
    fn connect<P: IsA<SocketAddress>, Q: IsA<Cancellable>>(
        &self,
        address: &P,
        cancellable: Option<&Q>,
    ) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = gio_sys::g_socket_connection_connect(
                self.as_ref().to_glib_none().0,
                address.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn connect_async<
        P: IsA<SocketAddress>,
        Q: IsA<Cancellable>,
        R: FnOnce(Result<(), Error>) + Send + 'static,
    >(
        &self,
        address: &P,
        cancellable: Option<&Q>,
        callback: R,
    ) {
        let user_data: Box<R> = Box::new(callback);
        unsafe extern "C" fn connect_async_trampoline<
            R: FnOnce(Result<(), Error>) + Send + 'static,
        >(
            _source_object: *mut gobject_sys::GObject,
            res: *mut gio_sys::GAsyncResult,
            user_data: glib_sys::gpointer,
        ) {
            let mut error = ptr::null_mut();
            let _ = gio_sys::g_socket_connection_connect_finish(
                _source_object as *mut _,
                res,
                &mut error,
            );
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box<R> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = connect_async_trampoline::<R>;
        unsafe {
            gio_sys::g_socket_connection_connect_async(
                self.as_ref().to_glib_none().0,
                address.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box::into_raw(user_data) as *mut _,
            );
        }
    }

    #[cfg(feature = "futures")]
    fn connect_async_future<P: IsA<SocketAddress> + Clone + 'static>(
        &self,
        address: &P,
    ) -> Box_<dyn future::Future<Output = Result<(), Error>> + std::marker::Unpin> {
        use fragile::Fragile;
        use GioFuture;

        let address = address.clone();
        GioFuture::new(self, move |obj, send| {
            let cancellable = Cancellable::new();
            let send = Fragile::new(send);
            obj.connect_async(&address, Some(&cancellable), move |res| {
                let _ = send.into_inner().send(res);
            });

            cancellable
        })
    }

    fn get_local_address(&self) -> Result<SocketAddress, Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_socket_connection_get_local_address(
                self.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn get_remote_address(&self) -> Result<SocketAddress, Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = gio_sys::g_socket_connection_get_remote_address(
                self.as_ref().to_glib_none().0,
                &mut error,
            );
            if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn get_socket(&self) -> Option<Socket> {
        unsafe {
            from_glib_none(gio_sys::g_socket_connection_get_socket(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_connected(&self) -> bool {
        unsafe {
            from_glib(gio_sys::g_socket_connection_is_connected(
                self.as_ref().to_glib_none().0,
            ))
        }
    }
}

impl fmt::Display for SocketConnection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "SocketConnection")
    }
}
