/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static gboolean vala_method_compatible_internal (ValaMethod* self,
                                          ValaMethod* base_method,
                                          gchar* * invalid_match,
                                          ValaCodeNode* node_reference);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaList* result = NULL;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp15_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				ValaScope* _tmp10_;
				ValaScope* _tmp11_;
				ValaParameter* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = param;
				_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_scope_remove (_tmp11_, _tmp14_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp15_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp15_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp23_;
	ValaLocalVariable* _tmp32_;
	ValaLocalVariable* _tmp33_;
	ValaList* _tmp36_;
	ValaList* _tmp45_;
	ValaBlock* _tmp54_;
	ValaBlock* _tmp55_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaTypeParameter* _tmp6_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp4_ = _p_list;
			_tmp5_ = vala_list_get (_tmp4_, _p_index);
			p = (ValaTypeParameter*) _tmp5_;
			_tmp6_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp7_ = vala_method_get_base_interface_type (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		_tmp9_ = vala_method_get_base_interface_type (self);
		_tmp10_ = _tmp9_;
		vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
	}
	_tmp11_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp13_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _param_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _param_index = 0;
		_tmp15_ = self->priv->parameters;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_param_list = _tmp16_;
		_tmp17_ = _param_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_param_size = _tmp19_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaParameter* _tmp22_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp20_ = _param_list;
			_tmp21_ = vala_list_get (_tmp20_, _param_index);
			param = (ValaParameter*) _tmp21_;
			_tmp22_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp23_ = self->error_types;
	if (_tmp23_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			gint _error_type_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _error_type_index = 0;
			_tmp24_ = self->error_types;
			_tmp25_ = _vala_iterable_ref0 (_tmp24_);
			_error_type_list = _tmp25_;
			_tmp26_ = _error_type_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_error_type_size = _tmp28_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp29_;
				gpointer _tmp30_;
				ValaDataType* _tmp31_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp29_ = _error_type_list;
				_tmp30_ = vala_list_get (_tmp29_, _error_type_index);
				error_type = (ValaDataType*) _tmp30_;
				_tmp31_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp32_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaLocalVariable* _tmp34_;
		ValaLocalVariable* _tmp35_;
		_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp35_ = _tmp34_;
		vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
	}
	_tmp36_ = self->priv->preconditions;
	if (_tmp36_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			gint _precondition_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _precondition_index = 0;
			_tmp37_ = self->priv->preconditions;
			_tmp38_ = _vala_iterable_ref0 (_tmp37_);
			_precondition_list = _tmp38_;
			_tmp39_ = _precondition_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_precondition_size = _tmp41_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp42_;
				gpointer _tmp43_;
				ValaExpression* _tmp44_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp42_ = _precondition_list;
				_tmp43_ = vala_list_get (_tmp42_, _precondition_index);
				precondition = (ValaExpression*) _tmp43_;
				_tmp44_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp45_ = self->priv->postconditions;
	if (_tmp45_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp46_;
			ValaList* _tmp47_;
			gint _postcondition_size = 0;
			ValaList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _postcondition_index = 0;
			_tmp46_ = self->priv->postconditions;
			_tmp47_ = _vala_iterable_ref0 (_tmp46_);
			_postcondition_list = _tmp47_;
			_tmp48_ = _postcondition_list;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_postcondition_size = _tmp50_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				ValaExpression* _tmp53_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp51_ = _postcondition_list;
				_tmp52_ = vala_list_get (_tmp51_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp52_;
				_tmp53_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp53_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp54_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		ValaBlock* _tmp56_;
		ValaBlock* _tmp57_;
		_tmp56_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp57_ = _tmp56_;
		vala_code_node_accept ((ValaCodeNode*) _tmp57_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	_tmp1_ = vala_method_compatible_internal (self, base_method, &_tmp0_, (ValaCodeNode*) self);
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = _tmp0_;
	result = _tmp1_;
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible_no_error (ValaMethod* self,
                                 ValaMethod* base_method)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	result = vala_method_compatible_internal (self, base_method, NULL, NULL);
	return result;
}

static gboolean
vala_method_compatible_internal (ValaMethod* self,
                                 ValaMethod* base_method,
                                 gchar* * invalid_match,
                                 ValaCodeNode* node_reference)
{
	gchar* _vala_invalid_match = NULL;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	ValaList* method_type_args = NULL;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaObjectType* _tmp57_;
	ValaList* _tmp58_;
	ValaDataType* _tmp59_;
	ValaDataType* _tmp60_;
	ValaDataType* _tmp61_;
	ValaDataType* _tmp62_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp71_;
	ValaIterator* _tmp72_;
	gint param_index = 0;
	ValaIterator* _tmp120_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp122_;
	ValaArrayList* _tmp123_;
	ValaArrayList* _tmp124_;
	ValaList* _tmp125_;
	gboolean _tmp146_;
	gboolean _tmp147_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp15_;
				gpointer _tmp16_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp17_;
				ValaGenericType* _tmp18_;
				ValaGenericType* _tmp19_;
				ValaObjectType* _tmp20_;
				ValaGenericType* _tmp21_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp15_ = _type_parameter_list;
				_tmp16_ = vala_list_get (_tmp15_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp16_;
				_tmp17_ = type_parameter;
				_tmp18_ = vala_generic_type_new (_tmp17_);
				type_arg = _tmp18_;
				_tmp19_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp19_, TRUE);
				_tmp20_ = object_type;
				_tmp21_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp20_, (ValaDataType*) _tmp21_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp22_ = vala_method_get_type_parameters (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_method_get_type_parameters (base_method);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp25_ < _tmp29_;
	_vala_iterable_unref0 (_tmp27_);
	_vala_iterable_unref0 (_tmp23_);
	if (_tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp31_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp32_;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gboolean _tmp40_;
		_tmp32_ = vala_method_get_type_parameters (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_method_get_type_parameters (base_method);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp35_ > _tmp39_;
		_vala_iterable_unref0 (_tmp37_);
		_vala_iterable_unref0 (_tmp33_);
		if (_tmp40_) {
			gchar* _tmp41_;
			_tmp41_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp41_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp42_;
		ValaArrayList* _tmp43_;
		_tmp42_ = g_direct_equal;
		_tmp43_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp42_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp43_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp44_;
			gint _type_parameter_size = 0;
			ValaList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _type_parameter_index = 0;
			_tmp44_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp44_;
			_tmp45_ = _type_parameter_list;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_type_parameter_size = _tmp47_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp48_;
				gpointer _tmp49_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp50_;
				ValaGenericType* _tmp51_;
				ValaGenericType* _tmp52_;
				ValaList* _tmp53_;
				ValaGenericType* _tmp54_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp48_ = _type_parameter_list;
				_tmp49_ = vala_list_get (_tmp48_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp49_;
				_tmp50_ = type_parameter;
				_tmp51_ = vala_generic_type_new (_tmp50_);
				type_arg = _tmp51_;
				_tmp52_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp52_, TRUE);
				_tmp53_ = method_type_args;
				_tmp54_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp53_, (ValaDataType*) _tmp54_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp55_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp56_ = _tmp55_;
	_tmp57_ = object_type;
	_tmp58_ = method_type_args;
	_tmp59_ = vala_data_type_get_actual_type (_tmp56_, (ValaDataType*) _tmp57_, _tmp58_, node_reference);
	actual_base_type = _tmp59_;
	_tmp60_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = actual_base_type;
	if (!vala_data_type_equals (_tmp61_, _tmp62_)) {
		ValaDataType* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp63_ = actual_base_type;
		_tmp64_ = vala_data_type_to_prototype_string (_tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_data_type_to_prototype_string (_tmp67_, NULL);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp65_, _tmp69_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp70_;
		_g_free0 (_tmp69_);
		_g_free0 (_tmp65_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp71_ = self->priv->parameters;
	_tmp72_ = vala_iterable_iterator ((ValaIterable*) _tmp71_);
	method_params_it = _tmp72_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp73_;
		ValaList* _tmp74_;
		gint _base_param_size = 0;
		ValaList* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _base_param_index = 0;
		_tmp73_ = base_method->priv->parameters;
		_tmp74_ = _vala_iterable_ref0 (_tmp73_);
		_base_param_list = _tmp74_;
		_tmp75_ = _base_param_list;
		_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
		_tmp77_ = _tmp76_;
		_base_param_size = _tmp77_;
		_base_param_index = -1;
		while (TRUE) {
			ValaParameter* base_param = NULL;
			ValaList* _tmp78_;
			gpointer _tmp79_;
			ValaIterator* _tmp80_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp82_;
			gpointer _tmp83_;
			ValaParameter* _tmp84_;
			gboolean _tmp85_;
			gboolean _tmp86_;
			ValaParameter* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			ValaParameter* _tmp91_;
			gboolean _tmp92_;
			gboolean _tmp93_;
			ValaParameter* _tmp94_;
			gboolean _tmp95_;
			gboolean _tmp96_;
			ValaParameter* _tmp98_;
			gboolean _tmp99_;
			gboolean _tmp100_;
			gint _tmp119_;
			_base_param_index = _base_param_index + 1;
			if (!(_base_param_index < _base_param_size)) {
				break;
			}
			_tmp78_ = _base_param_list;
			_tmp79_ = vala_list_get (_tmp78_, _base_param_index);
			base_param = (ValaParameter*) _tmp79_;
			_tmp80_ = method_params_it;
			if (!vala_iterator_next (_tmp80_)) {
				gchar* _tmp81_;
				_tmp81_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp81_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp82_ = method_params_it;
			_tmp83_ = vala_iterator_get (_tmp82_);
			param = (ValaParameter*) _tmp83_;
			_tmp84_ = base_param;
			_tmp85_ = vala_parameter_get_ellipsis (_tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = param;
			_tmp88_ = vala_parameter_get_ellipsis (_tmp87_);
			_tmp89_ = _tmp88_;
			if (_tmp86_ != _tmp89_) {
				gchar* _tmp90_;
				_tmp90_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp90_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp91_ = base_param;
			_tmp92_ = vala_parameter_get_params_array (_tmp91_);
			_tmp93_ = _tmp92_;
			_tmp94_ = param;
			_tmp95_ = vala_parameter_get_params_array (_tmp94_);
			_tmp96_ = _tmp95_;
			if (_tmp93_ != _tmp96_) {
				gchar* _tmp97_;
				_tmp97_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp97_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp98_ = base_param;
			_tmp99_ = vala_parameter_get_ellipsis (_tmp98_);
			_tmp100_ = _tmp99_;
			if (!_tmp100_) {
				ValaParameter* _tmp101_;
				ValaParameterDirection _tmp102_;
				ValaParameterDirection _tmp103_;
				ValaParameter* _tmp104_;
				ValaParameterDirection _tmp105_;
				ValaParameterDirection _tmp106_;
				ValaParameter* _tmp108_;
				ValaDataType* _tmp109_;
				ValaDataType* _tmp110_;
				ValaObjectType* _tmp111_;
				ValaList* _tmp112_;
				ValaDataType* _tmp113_;
				ValaDataType* _tmp114_;
				ValaParameter* _tmp115_;
				ValaDataType* _tmp116_;
				ValaDataType* _tmp117_;
				_tmp101_ = base_param;
				_tmp102_ = vala_parameter_get_direction (_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = param;
				_tmp105_ = vala_parameter_get_direction (_tmp104_);
				_tmp106_ = _tmp105_;
				if (_tmp103_ != _tmp106_) {
					gchar* _tmp107_;
					_tmp107_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp107_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp108_ = base_param;
				_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) _tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = object_type;
				_tmp112_ = method_type_args;
				_tmp113_ = vala_data_type_get_actual_type (_tmp110_, (ValaDataType*) _tmp111_, _tmp112_, node_reference);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp113_;
				_tmp114_ = actual_base_type;
				_tmp115_ = param;
				_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
				_tmp117_ = _tmp116_;
				if (!vala_data_type_equals (_tmp114_, _tmp117_)) {
					gchar* _tmp118_;
					_tmp118_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp118_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp119_ = param_index;
			param_index = _tmp119_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp120_ = method_params_it;
	if (vala_iterator_next (_tmp120_)) {
		gchar* _tmp121_;
		_tmp121_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp121_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp122_ = g_direct_equal;
	_tmp123_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp122_);
	base_method_errors = _tmp123_;
	_tmp124_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp124_, NULL);
	_tmp125_ = self->error_types;
	if (_tmp125_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp126_;
			ValaList* _tmp127_;
			gint _method_error_type_size = 0;
			ValaList* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			gint _method_error_type_index = 0;
			_tmp126_ = self->error_types;
			_tmp127_ = _vala_iterable_ref0 (_tmp126_);
			_method_error_type_list = _tmp127_;
			_tmp128_ = _method_error_type_list;
			_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
			_tmp130_ = _tmp129_;
			_method_error_type_size = _tmp130_;
			_method_error_type_index = -1;
			while (TRUE) {
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp131_;
				gpointer _tmp132_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				if (!(_method_error_type_index < _method_error_type_size)) {
					break;
				}
				_tmp131_ = _method_error_type_list;
				_tmp132_ = vala_list_get (_tmp131_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp132_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp133_;
					ValaArrayList* _tmp134_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp135_;
					gint _tmp136_;
					gint _tmp137_;
					gint _base_method_error_type_index = 0;
					_tmp133_ = base_method_errors;
					_tmp134_ = _vala_iterable_ref0 (_tmp133_);
					_base_method_error_type_list = _tmp134_;
					_tmp135_ = _base_method_error_type_list;
					_tmp136_ = vala_collection_get_size ((ValaCollection*) _tmp135_);
					_tmp137_ = _tmp136_;
					_base_method_error_type_size = _tmp137_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp138_;
						gpointer _tmp139_;
						ValaDataType* _tmp140_;
						ValaDataType* _tmp141_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						if (!(_base_method_error_type_index < _base_method_error_type_size)) {
							break;
						}
						_tmp138_ = _base_method_error_type_list;
						_tmp139_ = vala_list_get ((ValaList*) _tmp138_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp139_;
						_tmp140_ = method_error_type;
						_tmp141_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp140_, _tmp141_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp142_;
					gchar* _tmp143_;
					gchar* _tmp144_;
					gchar* _tmp145_;
					_tmp142_ = method_error_type;
					_tmp143_ = vala_code_node_to_string ((ValaCodeNode*) _tmp142_);
					_tmp144_ = _tmp143_;
					_tmp145_ = g_strdup_printf ("incompatible error type `%s'", _tmp144_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp145_;
					_g_free0 (_tmp144_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp146_ = base_method->priv->_coroutine;
	_tmp147_ = self->priv->_coroutine;
	if (_tmp146_ != _tmp147_) {
		gchar* _tmp148_;
		_tmp148_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp148_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_type_parameter_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_type_parameter_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	ValaList* _tmp0_;
	gint i = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->preconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->postconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp6_ = _error_type_list;
				_tmp7_ = vala_list_get (_tmp6_, _error_type_index);
				error_type = (ValaDataType*) _tmp7_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp8_;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					_tmp8_ = error_type;
					_tmp9_ = vala_data_type_copy (_tmp8_);
					type = _tmp9_;
					_tmp10_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp10_, source_reference);
					_tmp11_ = type;
					vala_collection_add (collection, _tmp11_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp12_;
					_tmp12_ = error_type;
					vala_collection_add (collection, _tmp12_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (VALA_IS_CLASS (_tmp1_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_INTERFACE (_tmp12_)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp12_;
	ValaClass* _tmp37_;
	ValaClass* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaSignal* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp7_;
		_tmp8_ = sig;
		_tmp9_ = vala_signal_get_default_handler (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (sym);
		sym = _tmp11_;
		_vala_code_node_unref0 (sig);
	}
	_tmp12_ = sym;
	if (VALA_IS_METHOD (_tmp12_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp13_;
		ValaMethod* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaMethod* _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = sym;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
		base_method = _tmp14_;
		_tmp16_ = base_method;
		_tmp17_ = _tmp16_->priv->_is_abstract;
		if (_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			_tmp18_ = base_method;
			_tmp19_ = _tmp18_->priv->_is_virtual;
			_tmp15_ = _tmp19_;
		}
		if (_tmp15_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp20_;
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			ValaMethod* _tmp35_;
			ValaMethod* _tmp36_;
			_tmp20_ = base_method;
			_tmp22_ = vala_method_compatible (self, _tmp20_, &_tmp21_);
			_g_free0 (invalid_match);
			invalid_match = _tmp21_;
			if (!_tmp22_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp23_;
				ValaMethodType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				ValaMethodType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = base_method;
				_tmp24_ = vala_method_type_new (_tmp23_);
				base_method_type = _tmp24_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = base_method_type;
				_tmp30_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = invalid_match;
				_tmp33_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp28_, _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_method);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp35_ = base_method;
			self->priv->_base_method = _tmp35_;
			_tmp36_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp36_, "CCode", "instance_pos");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_method);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp37_ = vala_class_get_base_class (cl);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaClass* _tmp39_;
		ValaClass* _tmp40_;
		_tmp39_ = vala_class_get_base_class (cl);
		_tmp40_ = _tmp39_;
		vala_method_find_base_class_method (self, _tmp40_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaMethod* base_match = NULL;
	gchar* invalid_error = NULL;
	ValaMethod* invalid_base_match = NULL;
	ValaMethod* _tmp67_;
	ValaDataType* _tmp83_;
	ValaDataType* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	base_match = NULL;
	invalid_error = NULL;
	invalid_base_match = NULL;
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp4_ = _type_list;
			_tmp5_ = vala_list_get (_tmp4_, _type_index);
			type = (ValaDataType*) _tmp5_;
			_tmp6_ = type;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			if (VALA_IS_INTERFACE (_tmp8_)) {
				gboolean _tmp9_ = FALSE;
				ValaDataType* _tmp10_;
				ValaDataType* _tmp11_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp19_;
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaScope* _tmp22_;
				ValaScope* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp34_;
				_tmp10_ = vala_method_get_base_interface_type (self);
				_tmp11_ = _tmp10_;
				if (_tmp11_ != NULL) {
					ValaDataType* _tmp12_;
					ValaDataType* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaDataType* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					_tmp12_ = vala_method_get_base_interface_type (self);
					_tmp13_ = _tmp12_;
					_tmp14_ = vala_data_type_get_data_type (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = type;
					_tmp17_ = vala_data_type_get_data_type (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp9_ = _tmp15_ != _tmp18_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp19_ = type;
				_tmp20_ = vala_data_type_get_data_type (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_scope_lookup (_tmp23_, _tmp25_);
				sym = _tmp26_;
				_tmp27_ = sym;
				if (VALA_IS_SIGNAL (_tmp27_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp28_;
					ValaSignal* _tmp29_;
					ValaSignal* _tmp30_;
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaSymbol* _tmp33_;
					_tmp28_ = sym;
					_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp29_;
					_tmp30_ = sig;
					_tmp31_ = vala_signal_get_default_handler (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp32_);
					_vala_code_node_unref0 (sym);
					sym = _tmp33_;
					_vala_code_node_unref0 (sig);
				}
				_tmp34_ = sym;
				if (VALA_IS_METHOD (_tmp34_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp35_;
					ValaMethod* _tmp36_;
					gboolean _tmp37_ = FALSE;
					ValaMethod* _tmp38_;
					gboolean _tmp39_;
					_tmp35_ = sym;
					_tmp36_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod));
					base_method = _tmp36_;
					_tmp38_ = base_method;
					_tmp39_ = _tmp38_->priv->_is_abstract;
					if (_tmp39_) {
						_tmp37_ = TRUE;
					} else {
						ValaMethod* _tmp40_;
						gboolean _tmp41_;
						_tmp40_ = base_method;
						_tmp41_ = _tmp40_->priv->_is_virtual;
						_tmp37_ = _tmp41_;
					}
					if (_tmp37_) {
						ValaDataType* _tmp42_;
						ValaDataType* _tmp43_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp58_;
						gchar* _tmp59_ = NULL;
						gboolean _tmp60_;
						_tmp42_ = vala_method_get_base_interface_type (self);
						_tmp43_ = _tmp42_;
						if (_tmp43_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp44_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									ValaMethod* m = NULL;
									ValaList* _tmp48_;
									gpointer _tmp49_;
									gboolean _tmp50_ = FALSE;
									ValaMethod* _tmp51_;
									ValaDataType* _tmp52_;
									ValaDataType* _tmp53_;
									_m_index = _m_index + 1;
									if (!(_m_index < _m_size)) {
										break;
									}
									_tmp48_ = _m_list;
									_tmp49_ = vala_list_get (_tmp48_, _m_index);
									m = (ValaMethod*) _tmp49_;
									_tmp51_ = m;
									_tmp52_ = vala_method_get_base_interface_type (_tmp51_);
									_tmp53_ = _tmp52_;
									if (_tmp53_ != NULL) {
										ValaMethod* _tmp54_;
										ValaMethod* _tmp55_;
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										_tmp54_ = base_method;
										_tmp55_ = m;
										_tmp56_ = vala_method_get_base_interface_method (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp50_ = _tmp54_ == _tmp57_;
									} else {
										_tmp50_ = FALSE;
									}
									if (_tmp50_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (base_method);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp58_ = base_method;
						_tmp60_ = vala_method_compatible (self, _tmp58_, &_tmp59_);
						_g_free0 (invalid_match);
						invalid_match = _tmp59_;
						if (!_tmp60_) {
							const gchar* _tmp61_;
							gchar* _tmp62_;
							ValaMethod* _tmp63_;
							ValaMethod* _tmp64_;
							_tmp61_ = invalid_match;
							_tmp62_ = g_strdup (_tmp61_);
							_g_free0 (invalid_error);
							invalid_error = _tmp62_;
							_tmp63_ = base_method;
							_tmp64_ = _vala_code_node_ref0 (_tmp63_);
							_vala_code_node_unref0 (invalid_base_match);
							invalid_base_match = _tmp64_;
						} else {
							ValaMethod* _tmp65_;
							ValaMethod* _tmp66_;
							_tmp65_ = base_method;
							_tmp66_ = _vala_code_node_ref0 (_tmp65_);
							_vala_code_node_unref0 (base_match);
							base_match = _tmp66_;
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_method);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							break;
						}
						_g_free0 (invalid_match);
					}
					_vala_code_node_unref0 (base_method);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp67_ = base_match;
	if (_tmp67_ != NULL) {
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		_tmp68_ = base_match;
		self->priv->_base_interface_method = _tmp68_;
		_tmp69_ = base_match;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp69_, "CCode", "instance_pos");
		_vala_code_node_unref0 (invalid_base_match);
		_g_free0 (invalid_error);
		_vala_code_node_unref0 (base_match);
		return;
	} else {
		ValaMethod* _tmp70_;
		_tmp70_ = invalid_base_match;
		if (_tmp70_ != NULL) {
			ValaMethodType* base_method_type = NULL;
			ValaMethod* _tmp71_;
			ValaMethodType* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaSourceReference* _tmp74_;
			gchar* _tmp75_;
			gchar* _tmp76_;
			ValaMethodType* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			const gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp71_ = invalid_base_match;
			_tmp72_ = vala_method_type_new (_tmp71_);
			base_method_type = _tmp72_;
			_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp74_ = _tmp73_;
			_tmp75_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp76_ = _tmp75_;
			_tmp77_ = base_method_type;
			_tmp78_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp77_, NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = invalid_error;
			_tmp81_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp76_, _tmp79_, _tmp80_);
			_tmp82_ = _tmp81_;
			vala_report_error (_tmp74_, _tmp82_);
			_g_free0 (_tmp82_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp76_);
			_vala_code_node_unref0 (base_method_type);
			_vala_code_node_unref0 (invalid_base_match);
			_g_free0 (invalid_error);
			_vala_code_node_unref0 (base_match);
			return;
		}
	}
	_tmp83_ = vala_method_get_base_interface_type (self);
	_tmp84_ = _tmp83_;
	if (_tmp84_ != NULL) {
		ValaSourceReference* _tmp85_;
		ValaSourceReference* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp86_ = _tmp85_;
		_tmp87_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp88_);
		_tmp90_ = _tmp89_;
		vala_report_error (_tmp86_, _tmp90_);
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
	}
	_vala_code_node_unref0 (invalid_base_match);
	_g_free0 (invalid_error);
	_vala_code_node_unref0 (base_match);
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp103_ = FALSE;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp110_;
	ValaSemanticAnalyzer* _tmp111_;
	ValaSourceFile* _tmp112_;
	ValaSourceFile* _tmp113_;
	ValaSourceFile* _tmp114_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp115_;
	ValaSemanticAnalyzer* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSymbol* _tmp118_;
	ValaSymbol* _tmp119_;
	ValaSourceReference* _tmp120_;
	ValaSourceReference* _tmp121_;
	ValaSemanticAnalyzer* _tmp128_;
	ValaSemanticAnalyzer* _tmp129_;
	ValaDataType* _tmp130_;
	ValaDataType* _tmp131_;
	gboolean _tmp132_;
	gboolean _tmp133_;
	ValaDataType* _tmp134_;
	ValaDataType* _tmp135_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp136_;
	ValaAttribute* _tmp137_;
	ValaAttribute* _tmp138_;
	ValaDataType* _tmp145_;
	ValaDataType* _tmp146_;
	gboolean _tmp149_ = FALSE;
	gboolean _tmp150_ = FALSE;
	gboolean _tmp151_ = FALSE;
	ValaList* _tmp152_;
	gint _tmp153_;
	gint _tmp154_;
	gboolean optional_param = FALSE;
	gboolean _tmp221_;
	ValaList* _tmp235_;
	ValaLocalVariable* _tmp256_;
	ValaLocalVariable* _tmp257_;
	ValaList* _tmp260_;
	ValaList* _tmp269_;
	ValaBlock* _tmp278_;
	ValaBlock* _tmp279_;
	ValaSemanticAnalyzer* _tmp282_;
	ValaSemanticAnalyzer* _tmp283_;
	ValaStruct* _tmp284_;
	ValaStruct* _tmp285_;
	gboolean _tmp324_ = FALSE;
	gboolean _tmp325_ = FALSE;
	ValaDataType* _tmp326_;
	ValaDataType* _tmp327_;
	ValaSemanticAnalyzer* _tmp371_;
	ValaSemanticAnalyzer* _tmp372_;
	ValaSourceFile* _tmp373_;
	ValaSemanticAnalyzer* _tmp374_;
	ValaSemanticAnalyzer* _tmp375_;
	ValaSymbol* _tmp376_;
	gboolean _tmp377_ = FALSE;
	gboolean _tmp378_ = FALSE;
	gboolean _tmp379_ = FALSE;
	gboolean _tmp380_;
	gboolean _tmp381_;
	ValaSemanticAnalyzer* _tmp397_;
	ValaSemanticAnalyzer* _tmp398_;
	ValaDataType* _tmp399_;
	ValaDataType* _tmp400_;
	ValaBlock* _tmp447_;
	ValaBlock* _tmp448_;
	gboolean _tmp485_ = FALSE;
	gboolean _tmp486_ = FALSE;
	gboolean _tmp487_ = FALSE;
	gboolean _tmp488_ = FALSE;
	gboolean _tmp489_ = FALSE;
	ValaAttribute* _tmp547_;
	gboolean _tmp548_;
	gboolean _tmp549_;
	gboolean result = FALSE;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp5_ = self->priv->_this_parameter;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) _tmp5_);
		_tmp7_ = _tmp6_;
		vala_data_type_set_value_owned (_tmp7_, TRUE);
	}
	_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp8_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp11_ = _tmp10_;
	if (VALA_IS_CLASS (_tmp11_)) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp13_ = self->priv->_is_abstract;
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			_tmp12_ = _tmp14_;
		}
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaClass* _tmp17_;
		gboolean _tmp18_ = FALSE;
		ValaClass* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp17_;
		_tmp19_ = cl;
		_tmp20_ = vala_class_get_is_compact (_tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			ValaClass* _tmp22_;
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			_tmp22_ = cl;
			_tmp23_ = vala_class_get_base_class (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ != NULL;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		_tmp29_ = self->priv->_is_abstract;
		if (_tmp29_) {
			_tmp28_ = TRUE;
		} else {
			gboolean _tmp30_;
			_tmp30_ = self->priv->_is_virtual;
			_tmp28_ = _tmp30_;
		}
		_tmp27_ = _tmp28_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = _tmp31_;
		vala_report_error (_tmp32_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...'.");
		result = FALSE;
		return result;
	}
	_tmp33_ = self->priv->_is_abstract;
	if (_tmp33_) {
		ValaSymbol* _tmp34_;
		ValaSymbol* _tmp35_;
		_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		if (VALA_IS_CLASS (_tmp35_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaClass* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp38_;
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!VALA_IS_INTERFACE (_tmp45_)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!VALA_IS_CLASS (_tmp51_)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !VALA_IS_INTERFACE (_tmp53_);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!VALA_IS_CLASS (_tmp58_)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!VALA_IS_CLASS (_tmp65_)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !VALA_IS_INTERFACE (_tmp67_);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_;
		_tmp78_ = self->priv->_is_abstract;
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			gboolean _tmp79_;
			_tmp79_ = self->priv->_is_virtual;
			_tmp77_ = _tmp79_;
		}
		if (_tmp77_) {
			gboolean _tmp80_;
			gboolean _tmp81_;
			_tmp80_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp81_ = _tmp80_;
			_tmp76_ = _tmp81_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp82_;
			ValaSourceReference* _tmp83_;
			_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp83_ = _tmp82_;
			vala_report_error (_tmp83_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp84_ = FALSE;
			gboolean _tmp85_;
			gboolean _tmp86_;
			_tmp85_ = vala_symbol_get_is_extern ((ValaSymbol*) self);
			_tmp86_ = _tmp85_;
			if (_tmp86_) {
				ValaBlock* _tmp87_;
				ValaBlock* _tmp88_;
				_tmp87_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp88_ = _tmp87_;
				_tmp84_ = _tmp88_ != NULL;
			} else {
				_tmp84_ = FALSE;
			}
			if (_tmp84_) {
				ValaSourceReference* _tmp89_;
				ValaSourceReference* _tmp90_;
				_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp90_ = _tmp89_;
				vala_report_error (_tmp90_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_;
				_tmp94_ = self->priv->_is_abstract;
				if (!_tmp94_) {
					gboolean _tmp95_;
					gboolean _tmp96_;
					_tmp95_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp96_ = _tmp95_;
					_tmp93_ = !_tmp96_;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaSourceFileType _tmp97_;
					ValaSourceFileType _tmp98_;
					_tmp97_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp98_ = _tmp97_;
					_tmp92_ = _tmp98_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					ValaBlock* _tmp99_;
					ValaBlock* _tmp100_;
					_tmp99_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp100_ = _tmp99_;
					_tmp91_ = _tmp100_ == NULL;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaSourceReference* _tmp101_;
					ValaSourceReference* _tmp102_;
					_tmp101_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp102_ = _tmp101_;
					vala_report_error (_tmp102_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp105_ = self->priv->_coroutine;
	if (_tmp105_) {
		gboolean _tmp106_;
		gboolean _tmp107_;
		_tmp106_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp107_ = _tmp106_;
		_tmp104_ = !_tmp107_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		_tmp103_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		ValaSourceReference* _tmp108_;
		ValaSourceReference* _tmp109_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp109_ = _tmp108_;
		vala_report_error (_tmp109_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp110_ = vala_code_context_get_analyzer (context);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_semantic_analyzer_get_current_source_file (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = _vala_source_file_ref0 (_tmp113_);
	old_source_file = _tmp114_;
	_tmp115_ = vala_code_context_get_analyzer (context);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_semantic_analyzer_get_current_symbol (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = _vala_code_node_ref0 (_tmp118_);
	old_symbol = _tmp119_;
	_tmp120_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp121_ = _tmp120_;
	if (_tmp121_ != NULL) {
		ValaSemanticAnalyzer* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaSourceReference* _tmp124_;
		ValaSourceReference* _tmp125_;
		ValaSourceFile* _tmp126_;
		ValaSourceFile* _tmp127_;
		_tmp122_ = vala_code_context_get_analyzer (context);
		_tmp123_ = _tmp122_;
		_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp125_ = _tmp124_;
		_tmp126_ = vala_source_reference_get_file (_tmp125_);
		_tmp127_ = _tmp126_;
		vala_semantic_analyzer_set_current_source_file (_tmp123_, _tmp127_);
	}
	_tmp128_ = vala_code_context_get_analyzer (context);
	_tmp129_ = _tmp128_;
	vala_semantic_analyzer_set_current_symbol (_tmp129_, (ValaSymbol*) self);
	_tmp130_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp131_ = _tmp130_;
	_tmp132_ = vala_method_get_returns_floating_reference (self);
	_tmp133_ = _tmp132_;
	vala_data_type_set_floating_reference (_tmp131_, _tmp133_);
	_tmp134_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp135_ = _tmp134_;
	vala_code_node_check ((ValaCodeNode*) _tmp135_, context);
	_tmp136_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp137_ = _vala_code_node_ref0 (_tmp136_);
	init_attr = _tmp137_;
	_tmp138_ = init_attr;
	if (_tmp138_ != NULL) {
		ValaSourceReference* _tmp139_;
		ValaSourceReference* _tmp140_;
		ValaSourceFile* _tmp141_;
		ValaSourceFile* _tmp142_;
		ValaCodeContext* _tmp143_;
		ValaCodeContext* _tmp144_;
		_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp140_ = _tmp139_;
		_tmp141_ = vala_source_reference_get_file (_tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = vala_source_file_get_context (_tmp142_);
		_tmp144_ = _tmp143_;
		vala_code_context_set_module_init_method (_tmp144_, self);
	}
	_tmp145_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp146_ = _tmp145_;
	if (_tmp146_ != NULL) {
		ValaDataType* _tmp147_;
		ValaDataType* _tmp148_;
		_tmp147_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp148_ = _tmp147_;
		vala_code_node_check ((ValaCodeNode*) _tmp148_, context);
	}
	_tmp152_ = self->priv->parameters;
	_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
	_tmp154_ = _tmp153_;
	if (_tmp154_ == 1) {
		ValaList* _tmp155_;
		gpointer _tmp156_;
		ValaParameter* _tmp157_;
		gboolean _tmp158_;
		gboolean _tmp159_;
		_tmp155_ = self->priv->parameters;
		_tmp156_ = vala_list_get (_tmp155_, 0);
		_tmp157_ = (ValaParameter*) _tmp156_;
		_tmp158_ = vala_parameter_get_ellipsis (_tmp157_);
		_tmp159_ = _tmp158_;
		_tmp151_ = _tmp159_;
		_vala_code_node_unref0 (_tmp157_);
	} else {
		_tmp151_ = FALSE;
	}
	if (_tmp151_) {
		ValaBlock* _tmp160_;
		ValaBlock* _tmp161_;
		_tmp160_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp161_ = _tmp160_;
		_tmp150_ = _tmp161_ != NULL;
	} else {
		_tmp150_ = FALSE;
	}
	if (_tmp150_) {
		ValaMemberBinding _tmp162_;
		_tmp162_ = self->priv->_binding;
		_tmp149_ = _tmp162_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		ValaList* _tmp163_;
		gpointer _tmp164_;
		ValaParameter* _tmp165_;
		ValaSourceReference* _tmp166_;
		ValaSourceReference* _tmp167_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp163_ = self->priv->parameters;
		_tmp164_ = vala_list_get (_tmp163_, 0);
		_tmp165_ = (ValaParameter*) _tmp164_;
		_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp165_);
		_tmp167_ = _tmp166_;
		vala_report_error (_tmp167_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp165_);
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp168_;
		ValaList* _tmp169_;
		gint _param_size = 0;
		ValaList* _tmp170_;
		gint _tmp171_;
		gint _tmp172_;
		gint _param_index = 0;
		_tmp168_ = self->priv->parameters;
		_tmp169_ = _vala_iterable_ref0 (_tmp168_);
		_param_list = _tmp169_;
		_tmp170_ = _param_list;
		_tmp171_ = vala_collection_get_size ((ValaCollection*) _tmp170_);
		_tmp172_ = _tmp171_;
		_param_size = _tmp172_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp173_;
			gpointer _tmp174_;
			ValaParameter* _tmp175_;
			gboolean _tmp176_ = FALSE;
			gboolean _tmp177_;
			gboolean _tmp184_ = FALSE;
			gboolean _tmp185_ = FALSE;
			gboolean _tmp186_;
			gboolean _tmp187_;
			gboolean _tmp206_;
			gboolean _tmp207_ = FALSE;
			gboolean _tmp208_ = FALSE;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp173_ = _param_list;
			_tmp174_ = vala_list_get (_tmp173_, _param_index);
			param = (ValaParameter*) _tmp174_;
			_tmp175_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp175_, context);
			_tmp177_ = self->priv->_coroutine;
			if (_tmp177_) {
				ValaParameter* _tmp178_;
				ValaParameterDirection _tmp179_;
				ValaParameterDirection _tmp180_;
				_tmp178_ = param;
				_tmp179_ = vala_parameter_get_direction (_tmp178_);
				_tmp180_ = _tmp179_;
				_tmp176_ = _tmp180_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp176_ = FALSE;
			}
			if (_tmp176_) {
				ValaParameter* _tmp181_;
				ValaSourceReference* _tmp182_;
				ValaSourceReference* _tmp183_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp181_ = param;
				_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp181_);
				_tmp183_ = _tmp182_;
				vala_report_error (_tmp183_, "Reference parameters are not supported for async methods");
			}
			_tmp186_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp187_ = _tmp186_;
			if (!_tmp187_) {
				gboolean _tmp188_;
				_tmp188_ = self->priv->_coroutine;
				_tmp185_ = _tmp188_;
			} else {
				_tmp185_ = FALSE;
			}
			if (_tmp185_) {
				gboolean _tmp189_ = FALSE;
				ValaParameter* _tmp190_;
				gboolean _tmp191_;
				gboolean _tmp192_;
				_tmp190_ = param;
				_tmp191_ = vala_parameter_get_ellipsis (_tmp190_);
				_tmp192_ = _tmp191_;
				if (_tmp192_) {
					_tmp189_ = TRUE;
				} else {
					ValaParameter* _tmp193_;
					ValaDataType* _tmp194_;
					ValaDataType* _tmp195_;
					ValaTypeSymbol* _tmp196_;
					ValaTypeSymbol* _tmp197_;
					ValaSemanticAnalyzer* _tmp198_;
					ValaSemanticAnalyzer* _tmp199_;
					ValaDataType* _tmp200_;
					ValaTypeSymbol* _tmp201_;
					ValaTypeSymbol* _tmp202_;
					_tmp193_ = param;
					_tmp194_ = vala_variable_get_variable_type ((ValaVariable*) _tmp193_);
					_tmp195_ = _tmp194_;
					_tmp196_ = vala_data_type_get_data_type (_tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_code_context_get_analyzer (context);
					_tmp199_ = _tmp198_;
					_tmp200_ = _tmp199_->va_list_type;
					_tmp201_ = vala_data_type_get_data_type (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp189_ = _tmp197_ == _tmp202_;
				}
				_tmp184_ = _tmp189_;
			} else {
				_tmp184_ = FALSE;
			}
			if (_tmp184_) {
				ValaParameter* _tmp203_;
				ValaSourceReference* _tmp204_;
				ValaSourceReference* _tmp205_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp203_ = param;
				_tmp204_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp203_);
				_tmp205_ = _tmp204_;
				vala_report_error (_tmp205_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp206_ = self->priv->_coroutine;
			if (_tmp206_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp209_;
				ValaExpression* _tmp210_;
				ValaExpression* _tmp211_;
				_tmp209_ = param;
				_tmp210_ = vala_variable_get_initializer ((ValaVariable*) _tmp209_);
				_tmp211_ = _tmp210_;
				_tmp208_ = _tmp211_ == NULL;
			} else {
				_tmp208_ = FALSE;
			}
			if (_tmp208_) {
				ValaParameter* _tmp212_;
				gboolean _tmp213_;
				gboolean _tmp214_;
				_tmp212_ = param;
				_tmp213_ = vala_parameter_get_ellipsis (_tmp212_);
				_tmp214_ = _tmp213_;
				_tmp207_ = !_tmp214_;
			} else {
				_tmp207_ = FALSE;
			}
			if (_tmp207_) {
				ValaParameter* _tmp215_;
				ValaSourceReference* _tmp216_;
				ValaSourceReference* _tmp217_;
				_tmp215_ = param;
				_tmp216_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp215_);
				_tmp217_ = _tmp216_;
				vala_report_warning (_tmp217_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp218_;
				ValaExpression* _tmp219_;
				ValaExpression* _tmp220_;
				_tmp218_ = param;
				_tmp219_ = vala_variable_get_initializer ((ValaVariable*) _tmp218_);
				_tmp220_ = _tmp219_;
				if (_tmp220_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp221_ = self->priv->_coroutine;
	if (_tmp221_) {
		gboolean requires_pointer = FALSE;
		requires_pointer = FALSE;
		{
			gint i = 0;
			ValaList* _tmp222_;
			gint _tmp223_;
			gint _tmp224_;
			_tmp222_ = self->priv->parameters;
			_tmp223_ = vala_collection_get_size ((ValaCollection*) _tmp222_);
			_tmp224_ = _tmp223_;
			i = _tmp224_ - 1;
			{
				gboolean _tmp225_ = FALSE;
				_tmp225_ = TRUE;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp227_;
					gpointer _tmp228_;
					ValaParameter* _tmp229_;
					ValaParameterDirection _tmp230_;
					ValaParameterDirection _tmp231_;
					if (!_tmp225_) {
						gint _tmp226_;
						_tmp226_ = i;
						i = _tmp226_ - 1;
					}
					_tmp225_ = FALSE;
					if (!(i >= 0)) {
						break;
					}
					_tmp227_ = self->priv->parameters;
					_tmp228_ = vala_list_get (_tmp227_, i);
					param = (ValaParameter*) _tmp228_;
					_tmp229_ = param;
					_tmp230_ = vala_parameter_get_direction (_tmp229_);
					_tmp231_ = _tmp230_;
					if (_tmp231_ == VALA_PARAMETER_DIRECTION_IN) {
						requires_pointer = TRUE;
					} else {
						if (requires_pointer) {
							ValaParameter* _tmp232_;
							ValaSourceReference* _tmp233_;
							ValaSourceReference* _tmp234_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp232_ = param;
							_tmp233_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp232_);
							_tmp234_ = _tmp233_;
							vala_report_error (_tmp234_, "Synchronous out-parameters are not supported in async methods");
						}
					}
					_vala_code_node_unref0 (param);
				}
			}
		}
	}
	_tmp235_ = self->error_types;
	if (_tmp235_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp236_;
			ValaList* _tmp237_;
			gint _error_type_size = 0;
			ValaList* _tmp238_;
			gint _tmp239_;
			gint _tmp240_;
			gint _error_type_index = 0;
			_tmp236_ = self->error_types;
			_tmp237_ = _vala_iterable_ref0 (_tmp236_);
			_error_type_list = _tmp237_;
			_tmp238_ = _error_type_list;
			_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
			_tmp240_ = _tmp239_;
			_error_type_size = _tmp240_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp241_;
				gpointer _tmp242_;
				ValaDataType* _tmp243_;
				ValaSemanticAnalyzer* _tmp244_;
				ValaSemanticAnalyzer* _tmp245_;
				ValaDataType* _tmp246_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp241_ = _error_type_list;
				_tmp242_ = vala_list_get (_tmp241_, _error_type_index);
				error_type = (ValaDataType*) _tmp242_;
				_tmp243_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp243_, context);
				_tmp244_ = vala_code_context_get_analyzer (context);
				_tmp245_ = _tmp244_;
				_tmp246_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp245_, (ValaSymbol*) self, _tmp246_)) {
					ValaSourceReference* _tmp247_;
					ValaSourceReference* _tmp248_;
					ValaDataType* _tmp249_;
					gchar* _tmp250_;
					gchar* _tmp251_;
					gchar* _tmp252_;
					gchar* _tmp253_;
					gchar* _tmp254_;
					gchar* _tmp255_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp248_ = _tmp247_;
					_tmp249_ = error_type;
					_tmp250_ = vala_code_node_to_string ((ValaCodeNode*) _tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp253_ = _tmp252_;
					_tmp254_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp251_, _tmp253_);
					_tmp255_ = _tmp254_;
					vala_report_error (_tmp248_, _tmp255_);
					_g_free0 (_tmp255_);
					_g_free0 (_tmp253_);
					_g_free0 (_tmp251_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp256_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp257_ = _tmp256_;
	if (_tmp257_ != NULL) {
		ValaLocalVariable* _tmp258_;
		ValaLocalVariable* _tmp259_;
		_tmp258_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp259_ = _tmp258_;
		vala_code_node_check ((ValaCodeNode*) _tmp259_, context);
	}
	_tmp260_ = self->priv->preconditions;
	if (_tmp260_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp261_;
			ValaList* _tmp262_;
			gint _precondition_size = 0;
			ValaList* _tmp263_;
			gint _tmp264_;
			gint _tmp265_;
			gint _precondition_index = 0;
			_tmp261_ = self->priv->preconditions;
			_tmp262_ = _vala_iterable_ref0 (_tmp261_);
			_precondition_list = _tmp262_;
			_tmp263_ = _precondition_list;
			_tmp264_ = vala_collection_get_size ((ValaCollection*) _tmp263_);
			_tmp265_ = _tmp264_;
			_precondition_size = _tmp265_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp266_;
				gpointer _tmp267_;
				ValaExpression* _tmp268_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp266_ = _precondition_list;
				_tmp267_ = vala_list_get (_tmp266_, _precondition_index);
				precondition = (ValaExpression*) _tmp267_;
				_tmp268_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp268_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp269_ = self->priv->postconditions;
	if (_tmp269_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp270_;
			ValaList* _tmp271_;
			gint _postcondition_size = 0;
			ValaList* _tmp272_;
			gint _tmp273_;
			gint _tmp274_;
			gint _postcondition_index = 0;
			_tmp270_ = self->priv->postconditions;
			_tmp271_ = _vala_iterable_ref0 (_tmp270_);
			_postcondition_list = _tmp271_;
			_tmp272_ = _postcondition_list;
			_tmp273_ = vala_collection_get_size ((ValaCollection*) _tmp272_);
			_tmp274_ = _tmp273_;
			_postcondition_size = _tmp274_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp275_;
				gpointer _tmp276_;
				ValaExpression* _tmp277_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp275_ = _postcondition_list;
				_tmp276_ = vala_list_get (_tmp275_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp276_;
				_tmp277_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp277_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp278_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp279_ = _tmp278_;
	if (_tmp279_ != NULL) {
		ValaBlock* _tmp280_;
		ValaBlock* _tmp281_;
		_tmp280_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp281_ = _tmp280_;
		vala_code_node_check ((ValaCodeNode*) _tmp281_, context);
	}
	_tmp282_ = vala_code_context_get_analyzer (context);
	_tmp283_ = _tmp282_;
	_tmp284_ = vala_semantic_analyzer_get_current_struct (_tmp283_);
	_tmp285_ = _tmp284_;
	if (_tmp285_ != NULL) {
		gboolean _tmp286_ = FALSE;
		gboolean _tmp287_ = FALSE;
		gboolean _tmp288_;
		_tmp288_ = self->priv->_is_abstract;
		if (_tmp288_) {
			_tmp287_ = TRUE;
		} else {
			gboolean _tmp289_;
			_tmp289_ = self->priv->_is_virtual;
			_tmp287_ = _tmp289_;
		}
		if (_tmp287_) {
			_tmp286_ = TRUE;
		} else {
			gboolean _tmp290_;
			_tmp290_ = self->priv->_overrides;
			_tmp286_ = _tmp290_;
		}
		if (_tmp286_) {
			ValaSourceReference* _tmp291_;
			ValaSourceReference* _tmp292_;
			gchar* _tmp293_;
			gchar* _tmp294_;
			gchar* _tmp295_;
			gchar* _tmp296_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp291_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp292_ = _tmp291_;
			_tmp293_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp294_ = _tmp293_;
			_tmp295_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp294_);
			_tmp296_ = _tmp295_;
			vala_report_error (_tmp292_, _tmp296_);
			_g_free0 (_tmp296_);
			_g_free0 (_tmp294_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp297_ = FALSE;
		gboolean _tmp298_ = FALSE;
		gboolean _tmp299_;
		_tmp299_ = self->priv->_overrides;
		if (_tmp299_) {
			ValaMethod* _tmp300_;
			ValaMethod* _tmp301_;
			_tmp300_ = vala_method_get_base_method (self);
			_tmp301_ = _tmp300_;
			_tmp298_ = _tmp301_ == NULL;
		} else {
			_tmp298_ = FALSE;
		}
		if (_tmp298_) {
			ValaMethod* _tmp302_;
			ValaMethod* _tmp303_;
			_tmp302_ = vala_method_get_base_interface_method (self);
			_tmp303_ = _tmp302_;
			_tmp297_ = _tmp303_ == NULL;
		} else {
			_tmp297_ = FALSE;
		}
		if (_tmp297_) {
			ValaSourceReference* _tmp304_;
			ValaSourceReference* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			gchar* _tmp308_;
			gchar* _tmp309_;
			_tmp304_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp305_ = _tmp304_;
			_tmp306_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp307_ = _tmp306_;
			_tmp308_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp307_);
			_tmp309_ = _tmp308_;
			vala_report_error (_tmp305_, _tmp309_);
			_g_free0 (_tmp309_);
			_g_free0 (_tmp307_);
		} else {
			gboolean _tmp310_ = FALSE;
			gboolean _tmp311_ = FALSE;
			gboolean _tmp312_ = FALSE;
			gboolean _tmp313_;
			_tmp313_ = self->priv->_is_abstract;
			if (_tmp313_) {
				_tmp312_ = TRUE;
			} else {
				gboolean _tmp314_;
				_tmp314_ = self->priv->_is_virtual;
				_tmp312_ = _tmp314_;
			}
			if (_tmp312_) {
				_tmp311_ = TRUE;
			} else {
				gboolean _tmp315_;
				_tmp315_ = self->priv->_overrides;
				_tmp311_ = _tmp315_;
			}
			if (_tmp311_) {
				ValaSymbolAccessibility _tmp316_;
				ValaSymbolAccessibility _tmp317_;
				_tmp316_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp317_ = _tmp316_;
				_tmp310_ = _tmp317_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp310_ = FALSE;
			}
			if (_tmp310_) {
				ValaSourceReference* _tmp318_;
				ValaSourceReference* _tmp319_;
				gchar* _tmp320_;
				gchar* _tmp321_;
				gchar* _tmp322_;
				gchar* _tmp323_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp318_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp319_ = _tmp318_;
				_tmp320_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp321_ = _tmp320_;
				_tmp322_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp321_);
				_tmp323_ = _tmp322_;
				vala_report_error (_tmp319_, _tmp323_);
				_g_free0 (_tmp323_);
				_g_free0 (_tmp321_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp326_ = vala_method_get_base_interface_type (self);
	_tmp327_ = _tmp326_;
	if (_tmp327_ != NULL) {
		ValaMethod* _tmp328_;
		ValaMethod* _tmp329_;
		_tmp328_ = vala_method_get_base_interface_method (self);
		_tmp329_ = _tmp328_;
		_tmp325_ = _tmp329_ != NULL;
	} else {
		_tmp325_ = FALSE;
	}
	if (_tmp325_) {
		ValaSymbol* _tmp330_;
		ValaSymbol* _tmp331_;
		_tmp330_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp331_ = _tmp330_;
		_tmp324_ = VALA_IS_CLASS (_tmp331_);
	} else {
		_tmp324_ = FALSE;
	}
	if (_tmp324_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp332_;
		ValaSymbol* _tmp333_;
		ValaClass* _tmp334_;
		_tmp332_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp333_ = _tmp332_;
		_tmp334_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp333_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp334_;
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp335_;
			ValaList* _tmp336_;
			gint _m_size = 0;
			ValaList* _tmp337_;
			gint _tmp338_;
			gint _tmp339_;
			gint _m_index = 0;
			_tmp335_ = cl;
			_tmp336_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp335_);
			_m_list = _tmp336_;
			_tmp337_ = _m_list;
			_tmp338_ = vala_collection_get_size ((ValaCollection*) _tmp337_);
			_tmp339_ = _tmp338_;
			_m_size = _tmp339_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp340_;
				gpointer _tmp341_;
				gboolean _tmp342_ = FALSE;
				ValaMethod* _tmp343_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp340_ = _m_list;
				_tmp341_ = vala_list_get (_tmp340_, _m_index);
				m = (ValaMethod*) _tmp341_;
				_tmp343_ = m;
				if (_tmp343_ != self) {
					ValaMethod* _tmp344_;
					ValaMethod* _tmp345_;
					ValaMethod* _tmp346_;
					ValaMethod* _tmp347_;
					ValaMethod* _tmp348_;
					_tmp344_ = m;
					_tmp345_ = vala_method_get_base_interface_method (_tmp344_);
					_tmp346_ = _tmp345_;
					_tmp347_ = vala_method_get_base_interface_method (self);
					_tmp348_ = _tmp347_;
					_tmp342_ = _tmp346_ == _tmp348_;
				} else {
					_tmp342_ = FALSE;
				}
				if (_tmp342_) {
					ValaMethod* _tmp349_;
					ValaMethod* _tmp350_;
					ValaSourceReference* _tmp351_;
					ValaSourceReference* _tmp352_;
					ValaClass* _tmp353_;
					gchar* _tmp354_;
					gchar* _tmp355_;
					ValaMethod* _tmp356_;
					ValaMethod* _tmp357_;
					gchar* _tmp358_;
					gchar* _tmp359_;
					gchar* _tmp360_;
					gchar* _tmp361_;
					ValaMethod* _tmp362_;
					ValaSourceReference* _tmp363_;
					ValaSourceReference* _tmp364_;
					ValaMethod* _tmp365_;
					ValaMethod* _tmp366_;
					gchar* _tmp367_;
					gchar* _tmp368_;
					gchar* _tmp369_;
					gchar* _tmp370_;
					_tmp349_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp349_, TRUE);
					_tmp350_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp350_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp351_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp352_ = _tmp351_;
					_tmp353_ = cl;
					_tmp354_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp353_);
					_tmp355_ = _tmp354_;
					_tmp356_ = vala_method_get_base_interface_method (self);
					_tmp357_ = _tmp356_;
					_tmp358_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp357_);
					_tmp359_ = _tmp358_;
					_tmp360_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp355_, _tmp359_);
					_tmp361_ = _tmp360_;
					vala_report_error (_tmp352_, _tmp361_);
					_g_free0 (_tmp361_);
					_g_free0 (_tmp359_);
					_g_free0 (_tmp355_);
					_tmp362_ = m;
					_tmp363_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp362_);
					_tmp364_ = _tmp363_;
					_tmp365_ = vala_method_get_base_interface_method (self);
					_tmp366_ = _tmp365_;
					_tmp367_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp366_);
					_tmp368_ = _tmp367_;
					_tmp369_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp368_);
					_tmp370_ = _tmp369_;
					vala_report_notice (_tmp364_, _tmp370_);
					_g_free0 (_tmp370_);
					_g_free0 (_tmp368_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp371_ = vala_code_context_get_analyzer (context);
	_tmp372_ = _tmp371_;
	_tmp373_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp372_, _tmp373_);
	_tmp374_ = vala_code_context_get_analyzer (context);
	_tmp375_ = _tmp374_;
	_tmp376_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp375_, _tmp376_);
	_tmp380_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp381_ = _tmp380_;
	if (!_tmp381_) {
		gboolean _tmp382_;
		_tmp382_ = self->priv->_overrides;
		_tmp379_ = !_tmp382_;
	} else {
		_tmp379_ = FALSE;
	}
	if (_tmp379_) {
		gboolean _tmp383_;
		gboolean _tmp384_;
		_tmp383_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp384_ = _tmp383_;
		_tmp378_ = !_tmp384_;
	} else {
		_tmp378_ = FALSE;
	}
	if (_tmp378_) {
		ValaSymbol* _tmp385_;
		ValaSymbol* _tmp386_;
		_tmp385_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp386_ = _tmp385_;
		_tmp377_ = _tmp386_ != NULL;
		_vala_code_node_unref0 (_tmp386_);
	} else {
		_tmp377_ = FALSE;
	}
	if (_tmp377_) {
		ValaSourceReference* _tmp387_;
		ValaSourceReference* _tmp388_;
		gchar* _tmp389_;
		gchar* _tmp390_;
		ValaSymbol* _tmp391_;
		ValaSymbol* _tmp392_;
		gchar* _tmp393_;
		gchar* _tmp394_;
		gchar* _tmp395_;
		gchar* _tmp396_;
		_tmp387_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp388_ = _tmp387_;
		_tmp389_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp390_ = _tmp389_;
		_tmp391_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp392_ = _tmp391_;
		_tmp393_ = vala_symbol_get_full_name (_tmp392_);
		_tmp394_ = _tmp393_;
		_tmp395_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp390_, _tmp394_);
		_tmp396_ = _tmp395_;
		vala_report_warning (_tmp388_, _tmp396_);
		_g_free0 (_tmp396_);
		_g_free0 (_tmp394_);
		_vala_code_node_unref0 (_tmp392_);
		_g_free0 (_tmp390_);
	}
	_tmp397_ = vala_code_context_get_analyzer (context);
	_tmp398_ = _tmp397_;
	_tmp399_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp400_ = _tmp399_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp398_, (ValaSymbol*) self, _tmp400_)) {
		ValaSourceReference* _tmp401_;
		ValaSourceReference* _tmp402_;
		ValaDataType* _tmp403_;
		ValaDataType* _tmp404_;
		gchar* _tmp405_;
		gchar* _tmp406_;
		gchar* _tmp407_;
		gchar* _tmp408_;
		gchar* _tmp409_;
		gchar* _tmp410_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp401_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp402_ = _tmp401_;
		_tmp403_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp404_ = _tmp403_;
		_tmp405_ = vala_code_node_to_string ((ValaCodeNode*) _tmp404_);
		_tmp406_ = _tmp405_;
		_tmp407_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp408_ = _tmp407_;
		_tmp409_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp406_, _tmp408_);
		_tmp410_ = _tmp409_;
		vala_report_error (_tmp402_, _tmp410_);
		_g_free0 (_tmp410_);
		_g_free0 (_tmp408_);
		_g_free0 (_tmp406_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp411_;
		gint _precondition_size = 0;
		ValaList* _tmp412_;
		gint _tmp413_;
		gint _tmp414_;
		gint _precondition_index = 0;
		_tmp411_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp411_;
		_tmp412_ = _precondition_list;
		_tmp413_ = vala_collection_get_size ((ValaCollection*) _tmp412_);
		_tmp414_ = _tmp413_;
		_precondition_size = _tmp414_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp415_;
			gpointer _tmp416_;
			ValaExpression* _tmp417_;
			gboolean _tmp418_;
			gboolean _tmp419_;
			ValaExpression* _tmp420_;
			ValaDataType* _tmp421_;
			ValaDataType* _tmp422_;
			ValaSemanticAnalyzer* _tmp423_;
			ValaSemanticAnalyzer* _tmp424_;
			ValaDataType* _tmp425_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp415_ = _precondition_list;
			_tmp416_ = vala_list_get (_tmp415_, _precondition_index);
			precondition = (ValaExpression*) _tmp416_;
			_tmp417_ = precondition;
			_tmp418_ = vala_code_node_get_error ((ValaCodeNode*) _tmp417_);
			_tmp419_ = _tmp418_;
			if (_tmp419_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp420_ = precondition;
			_tmp421_ = vala_expression_get_value_type (_tmp420_);
			_tmp422_ = _tmp421_;
			_tmp423_ = vala_code_context_get_analyzer (context);
			_tmp424_ = _tmp423_;
			_tmp425_ = _tmp424_->bool_type;
			if (!vala_data_type_compatible (_tmp422_, _tmp425_)) {
				ValaExpression* _tmp426_;
				ValaSourceReference* _tmp427_;
				ValaSourceReference* _tmp428_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp426_ = precondition;
				_tmp427_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp426_);
				_tmp428_ = _tmp427_;
				vala_report_error (_tmp428_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp429_;
		gint _postcondition_size = 0;
		ValaList* _tmp430_;
		gint _tmp431_;
		gint _tmp432_;
		gint _postcondition_index = 0;
		_tmp429_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp429_;
		_tmp430_ = _postcondition_list;
		_tmp431_ = vala_collection_get_size ((ValaCollection*) _tmp430_);
		_tmp432_ = _tmp431_;
		_postcondition_size = _tmp432_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp433_;
			gpointer _tmp434_;
			ValaExpression* _tmp435_;
			gboolean _tmp436_;
			gboolean _tmp437_;
			ValaExpression* _tmp438_;
			ValaDataType* _tmp439_;
			ValaDataType* _tmp440_;
			ValaSemanticAnalyzer* _tmp441_;
			ValaSemanticAnalyzer* _tmp442_;
			ValaDataType* _tmp443_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp433_ = _postcondition_list;
			_tmp434_ = vala_list_get (_tmp433_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp434_;
			_tmp435_ = postcondition;
			_tmp436_ = vala_code_node_get_error ((ValaCodeNode*) _tmp435_);
			_tmp437_ = _tmp436_;
			if (_tmp437_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp438_ = postcondition;
			_tmp439_ = vala_expression_get_value_type (_tmp438_);
			_tmp440_ = _tmp439_;
			_tmp441_ = vala_code_context_get_analyzer (context);
			_tmp442_ = _tmp441_;
			_tmp443_ = _tmp442_->bool_type;
			if (!vala_data_type_compatible (_tmp440_, _tmp443_)) {
				ValaExpression* _tmp444_;
				ValaSourceReference* _tmp445_;
				ValaSourceReference* _tmp446_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp444_ = postcondition;
				_tmp445_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp444_);
				_tmp446_ = _tmp445_;
				vala_report_error (_tmp446_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp447_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp448_ = _tmp447_;
	if (_tmp448_ != NULL) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp449_;
		ValaArrayList* _tmp450_;
		ValaBlock* _tmp451_;
		ValaBlock* _tmp452_;
		ValaArrayList* _tmp453_;
		_tmp449_ = g_direct_equal;
		_tmp450_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp449_);
		body_errors = _tmp450_;
		_tmp451_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp452_ = _tmp451_;
		_tmp453_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp452_, (ValaCollection*) _tmp453_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp454_;
			ValaArrayList* _tmp455_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp456_;
			gint _tmp457_;
			gint _tmp458_;
			gint _body_error_type_index = 0;
			_tmp454_ = body_errors;
			_tmp455_ = _vala_iterable_ref0 (_tmp454_);
			_body_error_type_list = _tmp455_;
			_tmp456_ = _body_error_type_list;
			_tmp457_ = vala_collection_get_size ((ValaCollection*) _tmp456_);
			_tmp458_ = _tmp457_;
			_body_error_type_size = _tmp458_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp459_;
				gpointer _tmp460_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp461_;
				gboolean _tmp471_ = FALSE;
				ValaDataType* _tmp472_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp476_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp459_ = _body_error_type_list;
				_tmp460_ = vala_list_get ((ValaList*) _tmp459_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp460_;
				can_propagate_error = FALSE;
				_tmp461_ = self->error_types;
				if (_tmp461_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp462_;
						ValaList* _tmp463_;
						gint _method_error_type_size = 0;
						ValaList* _tmp464_;
						gint _tmp465_;
						gint _tmp466_;
						gint _method_error_type_index = 0;
						_tmp462_ = self->error_types;
						_tmp463_ = _vala_iterable_ref0 (_tmp462_);
						_method_error_type_list = _tmp463_;
						_tmp464_ = _method_error_type_list;
						_tmp465_ = vala_collection_get_size ((ValaCollection*) _tmp464_);
						_tmp466_ = _tmp465_;
						_method_error_type_size = _tmp466_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp467_;
							gpointer _tmp468_;
							ValaDataType* _tmp469_;
							ValaDataType* _tmp470_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp467_ = _method_error_type_list;
							_tmp468_ = vala_list_get (_tmp467_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp468_;
							_tmp469_ = body_error_type;
							_tmp470_ = method_error_type;
							if (vala_data_type_compatible (_tmp469_, _tmp470_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp472_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp472_)) {
					ValaDataType* _tmp473_;
					gboolean _tmp474_;
					gboolean _tmp475_;
					_tmp473_ = body_error_type;
					_tmp474_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp473_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp475_ = _tmp474_;
					_tmp471_ = _tmp475_;
				} else {
					_tmp471_ = FALSE;
				}
				is_dynamic_error = _tmp471_;
				if (!can_propagate_error) {
					_tmp476_ = !is_dynamic_error;
				} else {
					_tmp476_ = FALSE;
				}
				if (_tmp476_) {
					ValaDataType* _tmp477_;
					ValaSourceReference* _tmp478_;
					ValaSourceReference* _tmp479_;
					ValaDataType* _tmp480_;
					gchar* _tmp481_;
					gchar* _tmp482_;
					gchar* _tmp483_;
					gchar* _tmp484_;
					_tmp477_ = body_error_type;
					_tmp478_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp477_);
					_tmp479_ = _tmp478_;
					_tmp480_ = body_error_type;
					_tmp481_ = vala_code_node_to_string ((ValaCodeNode*) _tmp480_);
					_tmp482_ = _tmp481_;
					_tmp483_ = g_strdup_printf ("unhandled error `%s'", _tmp482_);
					_tmp484_ = _tmp483_;
					vala_report_warning (_tmp479_, _tmp484_);
					_g_free0 (_tmp484_);
					_g_free0 (_tmp482_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp490_;
		_tmp490_ = self->priv->_binding;
		_tmp489_ = _tmp490_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp489_ = FALSE;
	}
	if (_tmp489_) {
		gboolean _tmp491_;
		_tmp491_ = self->priv->_overrides;
		_tmp488_ = !_tmp491_;
	} else {
		_tmp488_ = FALSE;
	}
	if (_tmp488_) {
		ValaSymbolAccessibility _tmp492_;
		ValaSymbolAccessibility _tmp493_;
		_tmp492_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp493_ = _tmp492_;
		_tmp487_ = _tmp493_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp487_ = FALSE;
	}
	if (_tmp487_) {
		ValaSymbol* _tmp494_;
		ValaSymbol* _tmp495_;
		_tmp494_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp495_ = _tmp494_;
		_tmp486_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp495_);
	} else {
		_tmp486_ = FALSE;
	}
	if (_tmp486_) {
		ValaSymbol* _tmp496_;
		ValaSymbol* _tmp497_;
		ValaAttribute* _tmp498_;
		_tmp496_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp497_ = _tmp496_;
		_tmp498_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp497_, "DBus");
		_tmp485_ = _tmp498_ != NULL;
	} else {
		_tmp485_ = FALSE;
	}
	if (_tmp485_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp499_;
		ValaAttribute* _tmp500_;
		gboolean _tmp501_ = FALSE;
		ValaAttribute* _tmp502_;
		_tmp499_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp500_ = _vala_code_node_ref0 (_tmp499_);
		dbus_attr = _tmp500_;
		_tmp502_ = dbus_attr;
		if (_tmp502_ == NULL) {
			_tmp501_ = TRUE;
		} else {
			ValaAttribute* _tmp503_;
			_tmp503_ = dbus_attr;
			_tmp501_ = vala_attribute_get_bool (_tmp503_, "visible", TRUE);
		}
		if (_tmp501_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp504_;
			ValaArrayList* _tmp505_;
			ValaArrayList* _tmp506_;
			gboolean _tmp523_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp504_ = g_direct_equal;
			_tmp505_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp504_);
			error_types = _tmp505_;
			_tmp506_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp506_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp507_;
				ValaArrayList* _tmp508_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp509_;
				gint _tmp510_;
				gint _tmp511_;
				gint _error_type_index = 0;
				_tmp507_ = error_types;
				_tmp508_ = _vala_iterable_ref0 (_tmp507_);
				_error_type_list = _tmp508_;
				_tmp509_ = _error_type_list;
				_tmp510_ = vala_collection_get_size ((ValaCollection*) _tmp509_);
				_tmp511_ = _tmp510_;
				_error_type_size = _tmp511_;
				_error_type_index = -1;
				while (TRUE) {
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp512_;
					gpointer _tmp513_;
					ValaDataType* _tmp514_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp515_;
					ValaErrorDomain* _tmp516_;
					ValaErrorDomain* _tmp517_;
					ValaErrorDomain* _tmp518_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp519_;
					gchar* _tmp520_;
					const gchar* _tmp521_;
					_error_type_index = _error_type_index + 1;
					if (!(_error_type_index < _error_type_size)) {
						break;
					}
					_tmp512_ = _error_type_list;
					_tmp513_ = vala_list_get ((ValaList*) _tmp512_, _error_type_index);
					error_type = (ValaDataType*) _tmp513_;
					_tmp514_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp514_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp515_ = error_type;
					_tmp516_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp515_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp517_ = _tmp516_;
					error_domain = _tmp517_;
					_tmp518_ = error_domain;
					if (_tmp518_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp519_ = error_domain;
					_tmp520_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp519_);
					full_error_domain = _tmp520_;
					_tmp521_ = full_error_domain;
					if (g_strcmp0 (_tmp521_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp522_;
						_tmp522_ = full_error_domain;
						if (g_strcmp0 (_tmp522_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp524_ = FALSE;
				if (throws_gioerror) {
					_tmp524_ = throws_gdbuserror;
				} else {
					_tmp524_ = FALSE;
				}
				_tmp523_ = !_tmp524_;
			} else {
				_tmp523_ = FALSE;
			}
			if (_tmp523_) {
				ValaSourceReference* _tmp525_;
				ValaSourceReference* _tmp526_;
				_tmp525_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp526_ = _tmp525_;
				vala_report_warning (_tmp526_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp527_;
		ValaMethod* _tmp528_;
		gboolean _tmp537_;
		gboolean _tmp538_;
		gboolean _tmp541_;
		gboolean _tmp544_;
		_tmp527_ = vala_code_context_get_entry_point (context);
		_tmp528_ = _tmp527_;
		if (_tmp528_ != NULL) {
			ValaSourceReference* _tmp529_;
			ValaSourceReference* _tmp530_;
			ValaMethod* _tmp531_;
			ValaMethod* _tmp532_;
			gchar* _tmp533_;
			gchar* _tmp534_;
			gchar* _tmp535_;
			gchar* _tmp536_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp529_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp530_ = _tmp529_;
			_tmp531_ = vala_code_context_get_entry_point (context);
			_tmp532_ = _tmp531_;
			_tmp533_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp532_);
			_tmp534_ = _tmp533_;
			_tmp535_ = g_strdup_printf ("program already has an entry point `%s'", _tmp534_);
			_tmp536_ = _tmp535_;
			vala_report_error (_tmp530_, _tmp536_);
			_g_free0 (_tmp536_);
			_g_free0 (_tmp534_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp537_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp538_ = _tmp537_;
		if (_tmp538_) {
			ValaSourceReference* _tmp539_;
			ValaSourceReference* _tmp540_;
			_tmp539_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp540_ = _tmp539_;
			vala_report_error (_tmp540_, "\"main\" method cannot throw errors");
		}
		_tmp541_ = self->priv->_is_inline;
		if (_tmp541_) {
			ValaSourceReference* _tmp542_;
			ValaSourceReference* _tmp543_;
			_tmp542_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp543_ = _tmp542_;
			vala_report_error (_tmp543_, "\"main\" method cannot be inline");
		}
		_tmp544_ = self->priv->_coroutine;
		if (_tmp544_) {
			ValaSourceReference* _tmp545_;
			ValaSourceReference* _tmp546_;
			_tmp545_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp546_ = _tmp545_;
			vala_report_error (_tmp546_, "\"main\" method cannot be async");
		}
	}
	_tmp547_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp547_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp548_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp549_ = _tmp548_;
	result = !_tmp549_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp33_;
	ValaIterator* _tmp34_;
	ValaIterator* _tmp35_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp36_;
	gpointer _tmp37_;
	ValaParameter* _tmp38_;
	ValaParameterDirection _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameter* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaArrayType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_data_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	params = _tmp26_;
	_tmp27_ = params;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp30_ = params;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp33_ = params;
	_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
	params_it = _tmp34_;
	_tmp35_ = params_it;
	vala_iterator_next (_tmp35_);
	_tmp36_ = params_it;
	_tmp37_ = vala_iterator_get (_tmp36_);
	param = (ValaParameter*) _tmp37_;
	_tmp38_ = param;
	_tmp39_ = vala_parameter_get_direction (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp41_ = param;
	_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (!VALA_IS_ARRAY_TYPE (_tmp43_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp44_ = param;
	_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp47_;
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_data_type (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint n = 0;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaParameter* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gint _tmp14_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp8_ = param;
			_tmp9_ = vala_variable_get_initializer ((ValaVariable*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaParameter* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp14_ = n;
			n = _tmp14_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp31_;
	ValaMethod* _tmp32_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp30_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaMethod* _tmp18_;
				ValaParameter* _tmp19_;
				ValaParameter* _tmp20_;
				ValaParameter* _tmp21_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp16_ = _param_list;
				_tmp17_ = vala_list_get (_tmp16_, _param_index);
				param = (ValaParameter*) _tmp17_;
				_tmp18_ = self->priv->end_method;
				_tmp19_ = param;
				_tmp20_ = vala_parameter_copy (_tmp19_);
				_tmp21_ = _tmp20_;
				vala_callable_add_parameter ((ValaCallable*) _tmp18_, _tmp21_);
				_vala_code_node_unref0 (_tmp21_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp22_;
			gint _param_size = 0;
			ValaList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _param_index = 0;
			_tmp22_ = vala_method_get_type_parameters (self);
			_param_list = _tmp22_;
			_tmp23_ = _param_list;
			_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_param_size = _tmp25_;
			_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* param = NULL;
				ValaList* _tmp26_;
				gpointer _tmp27_;
				ValaMethod* _tmp28_;
				ValaTypeParameter* _tmp29_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp26_ = _param_list;
				_tmp27_ = vala_list_get (_tmp26_, _param_index);
				param = (ValaTypeParameter*) _tmp27_;
				_tmp28_ = self->priv->end_method;
				_tmp29_ = param;
				vala_method_add_type_parameter (_tmp28_, _tmp29_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp30_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp30_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp31_ = self->priv->end_method;
	_tmp32_ = _vala_code_node_ref0 (_tmp31_);
	result = _tmp32_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	ValaMethod* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaDelegate* _tmp32_;
	ValaDelegateType* _tmp33_;
	ValaDelegateType* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameter* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaNullLiteral* _tmp43_;
	ValaNullLiteral* _tmp44_;
	ValaParameter* _tmp45_;
	ValaExpression* _tmp46_;
	ValaExpression* _tmp47_;
	ValaDelegateType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaParameter* _tmp51_;
	ValaParameter* _tmp52_;
	ValaArrayList* _tmp53_;
	ValaParameter* _tmp54_;
	ValaParameter* _tmp55_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaParameter* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp16_ = _param_list;
			_tmp17_ = vala_list_get (_tmp16_, _param_index);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_ellipsis (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				_tmp21_ = param;
				_tmp22_ = _vala_code_node_ref0 (_tmp21_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp22_;
			} else {
				ValaParameter* _tmp23_;
				ValaParameterDirection _tmp24_;
				ValaParameterDirection _tmp25_;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_get_direction (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp26_;
					ValaParameter* _tmp27_;
					_tmp26_ = params;
					_tmp27_ = param;
					vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "AsyncReadyCallback");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp33_ = vala_delegate_type_new (_tmp32_);
	_tmp34_ = _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	callback_type = _tmp34_;
	_tmp35_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp35_, TRUE);
	_tmp36_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp36_, TRUE);
	_tmp37_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp37_, TRUE);
	_tmp38_ = callback_type;
	_tmp39_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp38_, NULL);
	callback_param = _tmp39_;
	_tmp40_ = callback_param;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_null_literal_new (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_variable_set_initializer ((ValaVariable*) _tmp40_, (ValaExpression*) _tmp44_);
	_vala_code_node_unref0 (_tmp44_);
	_tmp45_ = callback_param;
	_tmp46_ = vala_variable_get_initializer ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = callback_type;
	_tmp49_ = vala_data_type_copy ((ValaDataType*) _tmp48_);
	_tmp50_ = _tmp49_;
	vala_expression_set_target_type (_tmp47_, _tmp50_);
	_vala_code_node_unref0 (_tmp50_);
	_tmp51_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp51_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp52_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp52_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp53_ = params;
	_tmp54_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
	_tmp55_ = ellipsis;
	if (_tmp55_ != NULL) {
		ValaArrayList* _tmp56_;
		ValaParameter* _tmp57_;
		_tmp56_ = params;
		_tmp57_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameterDirection _tmp31_;
			ValaParameterDirection _tmp32_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp28_ = _param_list;
			_tmp29_ = vala_list_get (_tmp28_, _param_index);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			_tmp31_ = vala_parameter_get_direction (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp33_;
				ValaParameter* _tmp34_;
				_tmp33_ = params;
				_tmp34_ = param;
				vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				ValaLocalVariable* local = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaLocalVariable* _tmp8_;
				_local_index = _local_index + 1;
				if (!(_local_index < _local_size)) {
					break;
				}
				_tmp6_ = _local_list;
				_tmp7_ = vala_list_get (_tmp6_, _local_index);
				local = (ValaLocalVariable*) _tmp7_;
				_tmp8_ = local;
				vala_collection_add (variables, _tmp8_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	ValaLocalVariable* _tmp0_;
	ValaLocalVariable* _tmp1_;
	gboolean _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaLocalVariable* _tmp2_;
		ValaLocalVariable* _tmp3_;
		_tmp2_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp3_ = _tmp2_;
		vala_collection_add (collection, (ValaVariable*) _tmp3_);
	}
	_tmp4_ = self->priv->_closure;
	if (_tmp4_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

static void
vala_method_class_init (ValaMethodClass * klass,
                        gpointer klass_data)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface,
                                          gpointer iface_data)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self,
                           gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

