/* functions.c generated by valac 0.44.7, the Vala compiler
 * generated from functions.vala, do not modify */

/* functions.vala
 *
 * Copyright (C) 2009  Didier Villevalois, Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

typedef gboolean (*GeeEqualDataFunc) (gconstpointer a, gconstpointer b, gpointer user_data);

#define GEE_TYPE_HASHABLE (gee_hashable_get_type ())
#define GEE_HASHABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASHABLE, GeeHashable))
#define GEE_IS_HASHABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASHABLE))
#define GEE_HASHABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_HASHABLE, GeeHashableIface))

typedef struct _GeeHashable GeeHashable;
typedef struct _GeeHashableIface GeeHashableIface;

#define GEE_TYPE_COMPARABLE (gee_comparable_get_type ())
#define GEE_COMPARABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COMPARABLE, GeeComparable))
#define GEE_IS_COMPARABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COMPARABLE))
#define GEE_COMPARABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COMPARABLE, GeeComparableIface))

typedef struct _GeeComparable GeeComparable;
typedef struct _GeeComparableIface GeeComparableIface;
typedef guint (*GeeHashDataFunc) (gconstpointer v, gpointer user_data);

#define GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE (gee_functions_equal_data_func_closure_get_type ())
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosure))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_EQUAL_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosureClass))

typedef struct _GeeFunctionsEqualDataFuncClosure GeeFunctionsEqualDataFuncClosure;
typedef struct _GeeFunctionsEqualDataFuncClosureClass GeeFunctionsEqualDataFuncClosureClass;
typedef struct _GeeFunctionsEqualDataFuncClosurePrivate GeeFunctionsEqualDataFuncClosurePrivate;
typedef struct _GeeFunctionsParamSpecEqualDataFuncClosure GeeFunctionsParamSpecEqualDataFuncClosure;

#define GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE (gee_functions_hash_data_func_closure_get_type ())
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosure))
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_HASH_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_HASH_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosureClass))

typedef struct _GeeFunctionsHashDataFuncClosure GeeFunctionsHashDataFuncClosure;
typedef struct _GeeFunctionsHashDataFuncClosureClass GeeFunctionsHashDataFuncClosureClass;
typedef struct _GeeFunctionsHashDataFuncClosurePrivate GeeFunctionsHashDataFuncClosurePrivate;
typedef struct _GeeFunctionsParamSpecHashDataFuncClosure GeeFunctionsParamSpecHashDataFuncClosure;

#define GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE (gee_functions_compare_data_func_closure_get_type ())
#define GEE_FUNCTIONS_COMPARE_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE, GeeFunctionsCompareDataFuncClosure))
#define GEE_FUNCTIONS_COMPARE_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE, GeeFunctionsCompareDataFuncClosureClass))
#define GEE_FUNCTIONS_IS_COMPARE_DATA_FUNC_CLOSURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_IS_COMPARE_DATA_FUNC_CLOSURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE))
#define GEE_FUNCTIONS_COMPARE_DATA_FUNC_CLOSURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE, GeeFunctionsCompareDataFuncClosureClass))

typedef struct _GeeFunctionsCompareDataFuncClosure GeeFunctionsCompareDataFuncClosure;
typedef struct _GeeFunctionsCompareDataFuncClosureClass GeeFunctionsCompareDataFuncClosureClass;
typedef struct _GeeFunctionsCompareDataFuncClosurePrivate GeeFunctionsCompareDataFuncClosurePrivate;
typedef struct _GeeFunctionsParamSpecCompareDataFuncClosure GeeFunctionsParamSpecCompareDataFuncClosure;

struct _GeeHashableIface {
	GTypeInterface parent_iface;
	guint (*hash) (GeeHashable* self);
	gboolean (*equal_to) (GeeHashable* self, gconstpointer object);
};

struct _GeeComparableIface {
	GTypeInterface parent_iface;
	gint (*compare_to) (GeeComparable* self, gconstpointer object);
};

struct _GeeFunctionsEqualDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsEqualDataFuncClosurePrivate * priv;
	GeeEqualDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsEqualDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsEqualDataFuncClosure *self);
};

struct _GeeFunctionsEqualDataFuncClosurePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeFunctionsParamSpecEqualDataFuncClosure {
	GParamSpec parent_instance;
};

struct _GeeFunctionsHashDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsHashDataFuncClosurePrivate * priv;
	GeeHashDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsHashDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsHashDataFuncClosure *self);
};

struct _GeeFunctionsHashDataFuncClosurePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeFunctionsParamSpecHashDataFuncClosure {
	GParamSpec parent_instance;
};

struct _GeeFunctionsCompareDataFuncClosure {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GeeFunctionsCompareDataFuncClosurePrivate * priv;
	GCompareDataFunc func;
	gpointer func_target;
	GDestroyNotify func_target_destroy_notify;
};

struct _GeeFunctionsCompareDataFuncClosureClass {
	GTypeClass parent_class;
	void (*finalize) (GeeFunctionsCompareDataFuncClosure *self);
};

struct _GeeFunctionsCompareDataFuncClosurePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeFunctionsParamSpecCompareDataFuncClosure {
	GParamSpec parent_instance;
};

static gint GeeFunctionsEqualDataFuncClosure_private_offset;
static gpointer gee_functions_equal_data_func_closure_parent_class = NULL;
static gint GeeFunctionsHashDataFuncClosure_private_offset;
static gpointer gee_functions_hash_data_func_closure_parent_class = NULL;
static gint GeeFunctionsCompareDataFuncClosure_private_offset;
static gpointer gee_functions_compare_data_func_closure_parent_class = NULL;

GeeEqualDataFunc gee_functions_get_equal_func_for (GType t,
                                                   gpointer* result_target,
                                                   GDestroyNotify* result_target_destroy_notify);
static gboolean ___lambda30_ (gconstpointer a,
                       gconstpointer b);
static gboolean ____lambda30__gee_equal_data_func (gconstpointer a,
                                            gconstpointer b,
                                            gpointer self);
GType gee_hashable_get_type (void) G_GNUC_CONST;
static gboolean ____lambda31_ (gconstpointer a,
                        gconstpointer b);
gboolean gee_hashable_equal_to (GeeHashable* self,
                                gconstpointer object);
static gboolean _____lambda31__gee_equal_data_func (gconstpointer a,
                                             gconstpointer b,
                                             gpointer self);
GType gee_comparable_get_type (void) G_GNUC_CONST;
static gboolean _____lambda32_ (gconstpointer a,
                         gconstpointer b);
gint gee_comparable_compare_to (GeeComparable* self,
                                gconstpointer object);
static gboolean ______lambda32__gee_equal_data_func (gconstpointer a,
                                              gconstpointer b,
                                              gpointer self);
static gboolean _____lambda33_ (gconstpointer a,
                         gconstpointer b);
static gboolean ______lambda33__gee_equal_data_func (gconstpointer a,
                                              gconstpointer b,
                                              gpointer self);
GeeHashDataFunc gee_functions_get_hash_func_for (GType t,
                                                 gpointer* result_target,
                                                 GDestroyNotify* result_target_destroy_notify);
static guint ___lambda41_ (gconstpointer a);
static guint ____lambda41__gee_hash_data_func (gconstpointer v,
                                        gpointer self);
static guint ____lambda42_ (gconstpointer a);
guint gee_hashable_hash (GeeHashable* self);
static guint _____lambda42__gee_hash_data_func (gconstpointer v,
                                         gpointer self);
static guint ____lambda43_ (gconstpointer a);
static guint _____lambda43__gee_hash_data_func (gconstpointer v,
                                         gpointer self);
GCompareDataFunc gee_functions_get_compare_func_for (GType t,
                                                     gpointer* result_target,
                                                     GDestroyNotify* result_target_destroy_notify);
static gint ___lambda44_ (gconstpointer a,
                   gconstpointer b);
static gint ____lambda44__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static gint ____lambda45_ (gconstpointer a,
                    gconstpointer b);
static gint _____lambda45__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint ____lambda46_ (gconstpointer _val1,
                    gconstpointer _val2);
static gint _____lambda46__gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
G_GNUC_INTERNAL gpointer gee_functions_equal_data_func_closure_ref (gpointer instance);
G_GNUC_INTERNAL void gee_functions_equal_data_func_closure_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* gee_functions_param_spec_equal_data_func_closure (const gchar* name,
                                                              const gchar* nick,
                                                              const gchar* blurb,
                                                              GType object_type,
                                                              GParamFlags flags);
G_GNUC_INTERNAL void gee_functions_value_set_equal_data_func_closure (GValue* value,
                                                      gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void gee_functions_value_take_equal_data_func_closure (GValue* value,
                                                       gpointer v_object);
G_GNUC_INTERNAL gpointer gee_functions_value_get_equal_data_func_closure (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType gee_functions_equal_data_func_closure_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_new (GType g_type,
                                                                             GBoxedCopyFunc g_dup_func,
                                                                             GDestroyNotify g_destroy_func,
                                                                             GeeEqualDataFunc func,
                                                                             gpointer func_target,
                                                                             GDestroyNotify func_target_destroy_notify);
G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure* gee_functions_equal_data_func_closure_construct (GType object_type,
                                                                                   GType g_type,
                                                                                   GBoxedCopyFunc g_dup_func,
                                                                                   GDestroyNotify g_destroy_func,
                                                                                   GeeEqualDataFunc func,
                                                                                   gpointer func_target,
                                                                                   GDestroyNotify func_target_destroy_notify);
G_GNUC_INTERNAL GeeEqualDataFunc gee_functions_equal_data_func_closure_clone_func (GeeFunctionsEqualDataFuncClosure* self,
                                                                   gpointer* result_target,
                                                                   GDestroyNotify* result_target_destroy_notify);
static gboolean __lambda29_ (GeeFunctionsEqualDataFuncClosure* self,
                      gconstpointer a,
                      gconstpointer b);
static gboolean ___lambda29__gee_equal_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
static void gee_functions_equal_data_func_closure_finalize (GeeFunctionsEqualDataFuncClosure * obj);
G_GNUC_INTERNAL gpointer gee_functions_hash_data_func_closure_ref (gpointer instance);
G_GNUC_INTERNAL void gee_functions_hash_data_func_closure_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* gee_functions_param_spec_hash_data_func_closure (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags);
G_GNUC_INTERNAL void gee_functions_value_set_hash_data_func_closure (GValue* value,
                                                     gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void gee_functions_value_take_hash_data_func_closure (GValue* value,
                                                      gpointer v_object);
G_GNUC_INTERNAL gpointer gee_functions_value_get_hash_data_func_closure (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType gee_functions_hash_data_func_closure_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_GNUC_INTERNAL GeeFunctionsHashDataFuncClosure* gee_functions_hash_data_func_closure_new (GType g_type,
                                                                           GBoxedCopyFunc g_dup_func,
                                                                           GDestroyNotify g_destroy_func,
                                                                           GeeHashDataFunc func,
                                                                           gpointer func_target,
                                                                           GDestroyNotify func_target_destroy_notify);
G_GNUC_INTERNAL GeeFunctionsHashDataFuncClosure* gee_functions_hash_data_func_closure_construct (GType object_type,
                                                                                 GType g_type,
                                                                                 GBoxedCopyFunc g_dup_func,
                                                                                 GDestroyNotify g_destroy_func,
                                                                                 GeeHashDataFunc func,
                                                                                 gpointer func_target,
                                                                                 GDestroyNotify func_target_destroy_notify);
G_GNUC_INTERNAL GeeHashDataFunc gee_functions_hash_data_func_closure_clone_func (GeeFunctionsHashDataFuncClosure* self,
                                                                 gpointer* result_target,
                                                                 GDestroyNotify* result_target_destroy_notify);
static guint __lambda40_ (GeeFunctionsHashDataFuncClosure* self,
                   gconstpointer a);
static guint ___lambda40__gee_hash_data_func (gconstpointer v,
                                       gpointer self);
static void gee_functions_hash_data_func_closure_finalize (GeeFunctionsHashDataFuncClosure * obj);
G_GNUC_INTERNAL gpointer gee_functions_compare_data_func_closure_ref (gpointer instance);
G_GNUC_INTERNAL void gee_functions_compare_data_func_closure_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* gee_functions_param_spec_compare_data_func_closure (const gchar* name,
                                                                const gchar* nick,
                                                                const gchar* blurb,
                                                                GType object_type,
                                                                GParamFlags flags);
G_GNUC_INTERNAL void gee_functions_value_set_compare_data_func_closure (GValue* value,
                                                        gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void gee_functions_value_take_compare_data_func_closure (GValue* value,
                                                         gpointer v_object);
G_GNUC_INTERNAL gpointer gee_functions_value_get_compare_data_func_closure (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType gee_functions_compare_data_func_closure_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_GNUC_INTERNAL GeeFunctionsCompareDataFuncClosure* gee_functions_compare_data_func_closure_new (GType g_type,
                                                                                 GBoxedCopyFunc g_dup_func,
                                                                                 GDestroyNotify g_destroy_func,
                                                                                 GCompareDataFunc func,
                                                                                 gpointer func_target,
                                                                                 GDestroyNotify func_target_destroy_notify);
G_GNUC_INTERNAL GeeFunctionsCompareDataFuncClosure* gee_functions_compare_data_func_closure_construct (GType object_type,
                                                                                       GType g_type,
                                                                                       GBoxedCopyFunc g_dup_func,
                                                                                       GDestroyNotify g_destroy_func,
                                                                                       GCompareDataFunc func,
                                                                                       gpointer func_target,
                                                                                       GDestroyNotify func_target_destroy_notify);
G_GNUC_INTERNAL GCompareDataFunc gee_functions_compare_data_func_closure_clone_func (GeeFunctionsCompareDataFuncClosure* self,
                                                                     gpointer* result_target,
                                                                     GDestroyNotify* result_target_destroy_notify);
static gint __lambda49_ (GeeFunctionsCompareDataFuncClosure* self,
                  gconstpointer a,
                  gconstpointer b);
static gint ___lambda49__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void gee_functions_compare_data_func_closure_finalize (GeeFunctionsCompareDataFuncClosure * obj);

/**
 * Get a equality testing function for a given type.
 *
 * @param t the type which to get an equality testing function for.
 *
 * @return the equality testing function corresponding to the given type.
 */
static gboolean
___lambda30_ (gconstpointer a,
              gconstpointer b)
{
	gboolean result = FALSE;
	if (a == b) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (a == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = b == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		} else {
			GEqualFunc _tmp1_;
			_tmp1_ = g_str_equal;
			result = _tmp1_ ((const gchar*) a, (const gchar*) b);
			return result;
		}
	}
}

static gboolean
____lambda30__gee_equal_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gboolean result;
	result = ___lambda30_ (a, b);
	return result;
}

static gboolean
____lambda31_ (gconstpointer a,
               gconstpointer b)
{
	gboolean result = FALSE;
	if (a == b) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (a == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = b == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		} else {
			result = gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_HASHABLE, GeeHashable), G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_HASHABLE, GeeHashable));
			return result;
		}
	}
}

static gboolean
_____lambda31__gee_equal_data_func (gconstpointer a,
                                    gconstpointer b,
                                    gpointer self)
{
	gboolean result;
	result = ____lambda31_ (a, b);
	return result;
}

static gboolean
_____lambda32_ (gconstpointer a,
                gconstpointer b)
{
	gboolean result = FALSE;
	if (a == b) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		if (a == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = b == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		} else {
			result = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_COMPARABLE, GeeComparable)) == 0;
			return result;
		}
	}
}

static gboolean
______lambda32__gee_equal_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self)
{
	gboolean result;
	result = _____lambda32_ (a, b);
	return result;
}

static gboolean
_____lambda33_ (gconstpointer a,
                gconstpointer b)
{
	gboolean result = FALSE;
	GEqualFunc _tmp0_;
	_tmp0_ = g_direct_equal;
	result = _tmp0_ (a, b);
	return result;
}

static gboolean
______lambda33__gee_equal_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self)
{
	gboolean result;
	result = _____lambda33_ (a, b);
	return result;
}

GeeEqualDataFunc
gee_functions_get_equal_func_for (GType t,
                                  gpointer* result_target,
                                  GDestroyNotify* result_target_destroy_notify)
{
	GeeEqualDataFunc result = NULL;
	if (t == G_TYPE_STRING) {
		GeeEqualDataFunc _tmp0_;
		gpointer _tmp0__target;
		GDestroyNotify _tmp0__target_destroy_notify;
		_tmp0_ = ____lambda30__gee_equal_data_func;
		_tmp0__target = NULL;
		_tmp0__target_destroy_notify = NULL;
		*result_target = _tmp0__target;
		*result_target_destroy_notify = _tmp0__target_destroy_notify;
		result = _tmp0_;
		return result;
	} else {
		if (g_type_is_a (t, GEE_TYPE_HASHABLE)) {
			GeeEqualDataFunc _tmp1_;
			gpointer _tmp1__target;
			GDestroyNotify _tmp1__target_destroy_notify;
			_tmp1_ = _____lambda31__gee_equal_data_func;
			_tmp1__target = NULL;
			_tmp1__target_destroy_notify = NULL;
			*result_target = _tmp1__target;
			*result_target_destroy_notify = _tmp1__target_destroy_notify;
			result = _tmp1_;
			return result;
		} else {
			if (g_type_is_a (t, GEE_TYPE_COMPARABLE)) {
				GeeEqualDataFunc _tmp2_;
				gpointer _tmp2__target;
				GDestroyNotify _tmp2__target_destroy_notify;
				_tmp2_ = ______lambda32__gee_equal_data_func;
				_tmp2__target = NULL;
				_tmp2__target_destroy_notify = NULL;
				*result_target = _tmp2__target;
				*result_target_destroy_notify = _tmp2__target_destroy_notify;
				result = _tmp2_;
				return result;
			} else {
				GeeEqualDataFunc _tmp3_;
				gpointer _tmp3__target;
				GDestroyNotify _tmp3__target_destroy_notify;
				_tmp3_ = ______lambda33__gee_equal_data_func;
				_tmp3__target = NULL;
				_tmp3__target_destroy_notify = NULL;
				*result_target = _tmp3__target;
				*result_target_destroy_notify = _tmp3__target_destroy_notify;
				result = _tmp3_;
				return result;
			}
		}
	}
}

/**
 * Get a hash function for a given type.
 *
 * @param t the type which to get the hash function for.
 *
 * @return the hash function corresponding to the given type.
 */
static guint
___lambda41_ (gconstpointer a)
{
	guint result = 0U;
	if (a == NULL) {
		result = (guint) 0xdeadbeefLL;
		return result;
	} else {
		GHashFunc _tmp0_;
		_tmp0_ = g_str_hash;
		result = _tmp0_ ((const gchar*) a);
		return result;
	}
}

static guint
____lambda41__gee_hash_data_func (gconstpointer v,
                                  gpointer self)
{
	guint result;
	result = ___lambda41_ (v);
	return result;
}

static guint
____lambda42_ (gconstpointer a)
{
	guint result = 0U;
	if (a == NULL) {
		result = (guint) 0xdeadbeefLL;
		return result;
	} else {
		result = gee_hashable_hash (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_HASHABLE, GeeHashable));
		return result;
	}
}

static guint
_____lambda42__gee_hash_data_func (gconstpointer v,
                                   gpointer self)
{
	guint result;
	result = ____lambda42_ (v);
	return result;
}

static guint
____lambda43_ (gconstpointer a)
{
	guint result = 0U;
	GHashFunc _tmp0_;
	_tmp0_ = g_direct_hash;
	result = _tmp0_ (a);
	return result;
}

static guint
_____lambda43__gee_hash_data_func (gconstpointer v,
                                   gpointer self)
{
	guint result;
	result = ____lambda43_ (v);
	return result;
}

GeeHashDataFunc
gee_functions_get_hash_func_for (GType t,
                                 gpointer* result_target,
                                 GDestroyNotify* result_target_destroy_notify)
{
	GeeHashDataFunc result = NULL;
	if (t == G_TYPE_STRING) {
		GeeHashDataFunc _tmp0_;
		gpointer _tmp0__target;
		GDestroyNotify _tmp0__target_destroy_notify;
		_tmp0_ = ____lambda41__gee_hash_data_func;
		_tmp0__target = NULL;
		_tmp0__target_destroy_notify = NULL;
		*result_target = _tmp0__target;
		*result_target_destroy_notify = _tmp0__target_destroy_notify;
		result = _tmp0_;
		return result;
	} else {
		if (g_type_is_a (t, GEE_TYPE_HASHABLE)) {
			GeeHashDataFunc _tmp1_;
			gpointer _tmp1__target;
			GDestroyNotify _tmp1__target_destroy_notify;
			_tmp1_ = _____lambda42__gee_hash_data_func;
			_tmp1__target = NULL;
			_tmp1__target_destroy_notify = NULL;
			*result_target = _tmp1__target;
			*result_target_destroy_notify = _tmp1__target_destroy_notify;
			result = _tmp1_;
			return result;
		} else {
			GeeHashDataFunc _tmp2_;
			gpointer _tmp2__target;
			GDestroyNotify _tmp2__target_destroy_notify;
			_tmp2_ = _____lambda43__gee_hash_data_func;
			_tmp2__target = NULL;
			_tmp2__target_destroy_notify = NULL;
			*result_target = _tmp2__target;
			*result_target_destroy_notify = _tmp2__target_destroy_notify;
			result = _tmp2_;
			return result;
		}
	}
}

/**
 * Get a comparator function for a given type.
 *
 * @param t the type which to get a comparator function for.
 *
 * @return the comparator function corresponding to the given type.
 */
static gint
___lambda44_ (gconstpointer a,
              gconstpointer b)
{
	gint result = 0;
	if (a == b) {
		result = 0;
		return result;
	} else {
		if (a == NULL) {
			result = -1;
			return result;
		} else {
			if (b == NULL) {
				result = 1;
				return result;
			} else {
				GCompareFunc _tmp0_;
				_tmp0_ = ((GCompareFunc) g_strcmp0);
				result = _tmp0_ ((const gchar*) a, (const gchar*) b);
				return result;
			}
		}
	}
}

static gint
____lambda44__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = ___lambda44_ (a, b);
	return result;
}

static gint
____lambda45_ (gconstpointer a,
               gconstpointer b)
{
	gint result = 0;
	if (a == b) {
		result = 0;
		return result;
	} else {
		if (a == NULL) {
			result = -1;
			return result;
		} else {
			if (b == NULL) {
				result = 1;
				return result;
			} else {
				result = gee_comparable_compare_to (G_TYPE_CHECK_INSTANCE_CAST (a, GEE_TYPE_COMPARABLE, GeeComparable), G_TYPE_CHECK_INSTANCE_CAST (b, GEE_TYPE_COMPARABLE, GeeComparable));
				return result;
			}
		}
	}
}

static gint
_____lambda45__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ____lambda45_ (a, b);
	return result;
}

static gint
____lambda46_ (gconstpointer _val1,
               gconstpointer _val2)
{
	gint result = 0;
	glong val1 = 0L;
	glong val2 = 0L;
	val1 = (glong) _val1;
	val2 = (glong) _val2;
	if (val1 > val2) {
		result = 1;
		return result;
	} else {
		if (val1 == val2) {
			result = 0;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
}

static gint
_____lambda46__gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = ____lambda46_ (a, b);
	return result;
}

GCompareDataFunc
gee_functions_get_compare_func_for (GType t,
                                    gpointer* result_target,
                                    GDestroyNotify* result_target_destroy_notify)
{
	GCompareDataFunc result = NULL;
	if (t == G_TYPE_STRING) {
		GCompareDataFunc _tmp0_;
		gpointer _tmp0__target;
		GDestroyNotify _tmp0__target_destroy_notify;
		_tmp0_ = ____lambda44__gcompare_data_func;
		_tmp0__target = NULL;
		_tmp0__target_destroy_notify = NULL;
		*result_target = _tmp0__target;
		*result_target_destroy_notify = _tmp0__target_destroy_notify;
		result = _tmp0_;
		return result;
	} else {
		if (g_type_is_a (t, GEE_TYPE_COMPARABLE)) {
			GCompareDataFunc _tmp1_;
			gpointer _tmp1__target;
			GDestroyNotify _tmp1__target_destroy_notify;
			_tmp1_ = _____lambda45__gcompare_data_func;
			_tmp1__target = NULL;
			_tmp1__target_destroy_notify = NULL;
			*result_target = _tmp1__target;
			*result_target_destroy_notify = _tmp1__target_destroy_notify;
			result = _tmp1_;
			return result;
		} else {
			GCompareDataFunc _tmp2_;
			gpointer _tmp2__target;
			GDestroyNotify _tmp2__target_destroy_notify;
			_tmp2_ = _____lambda46__gcompare_data_func;
			_tmp2__target = NULL;
			_tmp2__target_destroy_notify = NULL;
			*result_target = _tmp2__target;
			*result_target_destroy_notify = _tmp2__target_destroy_notify;
			result = _tmp2_;
			return result;
		}
	}
}

static inline gpointer
gee_functions_equal_data_func_closure_get_instance_private (GeeFunctionsEqualDataFuncClosure* self)
{
	return G_STRUCT_MEMBER_P (self, GeeFunctionsEqualDataFuncClosure_private_offset);
}

G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure*
gee_functions_equal_data_func_closure_construct (GType object_type,
                                                 GType g_type,
                                                 GBoxedCopyFunc g_dup_func,
                                                 GDestroyNotify g_destroy_func,
                                                 GeeEqualDataFunc func,
                                                 gpointer func_target,
                                                 GDestroyNotify func_target_destroy_notify)
{
	GeeFunctionsEqualDataFuncClosure* self = NULL;
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	self = (GeeFunctionsEqualDataFuncClosure*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = func;
	_tmp0__target = func_target;
	_tmp0__target_destroy_notify = func_target_destroy_notify;
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
	self->func = _tmp0_;
	self->func_target = _tmp0__target;
	self->func_target_destroy_notify = _tmp0__target_destroy_notify;
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	return self;
}

G_GNUC_INTERNAL GeeFunctionsEqualDataFuncClosure*
gee_functions_equal_data_func_closure_new (GType g_type,
                                           GBoxedCopyFunc g_dup_func,
                                           GDestroyNotify g_destroy_func,
                                           GeeEqualDataFunc func,
                                           gpointer func_target,
                                           GDestroyNotify func_target_destroy_notify)
{
	return gee_functions_equal_data_func_closure_construct (GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, g_type, g_dup_func, g_destroy_func, func, func_target, func_target_destroy_notify);
}

static gboolean
__lambda29_ (GeeFunctionsEqualDataFuncClosure* self,
             gconstpointer a,
             gconstpointer b)
{
	gboolean result = FALSE;
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	_tmp0_ = self->func;
	_tmp0__target = self->func_target;
	result = _tmp0_ (a, b, _tmp0__target);
	return result;
}

static gboolean
___lambda29__gee_equal_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gboolean result;
	result = __lambda29_ ((GeeFunctionsEqualDataFuncClosure*) self, a, b);
	return result;
}

G_GNUC_INTERNAL GeeEqualDataFunc
gee_functions_equal_data_func_closure_clone_func (GeeFunctionsEqualDataFuncClosure* self,
                                                  gpointer* result_target,
                                                  GDestroyNotify* result_target_destroy_notify)
{
	GeeEqualDataFunc result = NULL;
	GeeEqualDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ___lambda29__gee_equal_data_func;
	_tmp0__target = gee_functions_equal_data_func_closure_ref (self);
	_tmp0__target_destroy_notify = gee_functions_equal_data_func_closure_unref;
	*result_target = _tmp0__target;
	*result_target_destroy_notify = _tmp0__target_destroy_notify;
	result = _tmp0_;
	return result;
}

static void
gee_functions_value_equal_data_func_closure_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gee_functions_value_equal_data_func_closure_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gee_functions_equal_data_func_closure_unref (value->data[0].v_pointer);
	}
}

static void
gee_functions_value_equal_data_func_closure_copy_value (const GValue* src_value,
                                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_functions_equal_data_func_closure_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gee_functions_value_equal_data_func_closure_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gee_functions_value_equal_data_func_closure_collect_value (GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GeeFunctionsEqualDataFuncClosure * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_functions_equal_data_func_closure_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gee_functions_value_equal_data_func_closure_lcopy_value (const GValue* value,
                                                         guint n_collect_values,
                                                         GTypeCValue* collect_values,
                                                         guint collect_flags)
{
	GeeFunctionsEqualDataFuncClosure ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_functions_equal_data_func_closure_ref (value->data[0].v_pointer);
	}
	return NULL;
}

G_GNUC_INTERNAL GParamSpec*
gee_functions_param_spec_equal_data_func_closure (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags)
{
	GeeFunctionsParamSpecEqualDataFuncClosure* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

G_GNUC_INTERNAL gpointer
gee_functions_value_get_equal_data_func_closure (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE), NULL);
	return value->data[0].v_pointer;
}

G_GNUC_INTERNAL void
gee_functions_value_set_equal_data_func_closure (GValue* value,
                                                 gpointer v_object)
{
	GeeFunctionsEqualDataFuncClosure * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_functions_equal_data_func_closure_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_functions_equal_data_func_closure_unref (old);
	}
}

G_GNUC_INTERNAL void
gee_functions_value_take_equal_data_func_closure (GValue* value,
                                                  gpointer v_object)
{
	GeeFunctionsEqualDataFuncClosure * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_functions_equal_data_func_closure_unref (old);
	}
}

static void
gee_functions_equal_data_func_closure_class_init (GeeFunctionsEqualDataFuncClosureClass * klass,
                                                  gpointer klass_data)
{
	gee_functions_equal_data_func_closure_parent_class = g_type_class_peek_parent (klass);
	((GeeFunctionsEqualDataFuncClosureClass *) klass)->finalize = gee_functions_equal_data_func_closure_finalize;
	g_type_class_adjust_private_offset (klass, &GeeFunctionsEqualDataFuncClosure_private_offset);
}

static void
gee_functions_equal_data_func_closure_instance_init (GeeFunctionsEqualDataFuncClosure * self,
                                                     gpointer klass)
{
	self->priv = gee_functions_equal_data_func_closure_get_instance_private (self);
	self->ref_count = 1;
}

static void
gee_functions_equal_data_func_closure_finalize (GeeFunctionsEqualDataFuncClosure * obj)
{
	GeeFunctionsEqualDataFuncClosure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_FUNCTIONS_TYPE_EQUAL_DATA_FUNC_CLOSURE, GeeFunctionsEqualDataFuncClosure);
	g_signal_handlers_destroy (self);
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
}

G_GNUC_INTERNAL GType
gee_functions_equal_data_func_closure_get_type (void)
{
	static volatile gsize gee_functions_equal_data_func_closure_type_id__volatile = 0;
	if (g_once_init_enter (&gee_functions_equal_data_func_closure_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_functions_value_equal_data_func_closure_init, gee_functions_value_equal_data_func_closure_free_value, gee_functions_value_equal_data_func_closure_copy_value, gee_functions_value_equal_data_func_closure_peek_pointer, "p", gee_functions_value_equal_data_func_closure_collect_value, "p", gee_functions_value_equal_data_func_closure_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeeFunctionsEqualDataFuncClosureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_functions_equal_data_func_closure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeFunctionsEqualDataFuncClosure), 0, (GInstanceInitFunc) gee_functions_equal_data_func_closure_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_functions_equal_data_func_closure_type_id;
		gee_functions_equal_data_func_closure_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeeFunctionsEqualDataFuncClosure", &g_define_type_info, &g_define_type_fundamental_info, 0);
		GeeFunctionsEqualDataFuncClosure_private_offset = g_type_add_instance_private (gee_functions_equal_data_func_closure_type_id, sizeof (GeeFunctionsEqualDataFuncClosurePrivate));
		g_once_init_leave (&gee_functions_equal_data_func_closure_type_id__volatile, gee_functions_equal_data_func_closure_type_id);
	}
	return gee_functions_equal_data_func_closure_type_id__volatile;
}

G_GNUC_INTERNAL gpointer
gee_functions_equal_data_func_closure_ref (gpointer instance)
{
	GeeFunctionsEqualDataFuncClosure * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

G_GNUC_INTERNAL void
gee_functions_equal_data_func_closure_unref (gpointer instance)
{
	GeeFunctionsEqualDataFuncClosure * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_FUNCTIONS_EQUAL_DATA_FUNC_CLOSURE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
gee_functions_hash_data_func_closure_get_instance_private (GeeFunctionsHashDataFuncClosure* self)
{
	return G_STRUCT_MEMBER_P (self, GeeFunctionsHashDataFuncClosure_private_offset);
}

G_GNUC_INTERNAL GeeFunctionsHashDataFuncClosure*
gee_functions_hash_data_func_closure_construct (GType object_type,
                                                GType g_type,
                                                GBoxedCopyFunc g_dup_func,
                                                GDestroyNotify g_destroy_func,
                                                GeeHashDataFunc func,
                                                gpointer func_target,
                                                GDestroyNotify func_target_destroy_notify)
{
	GeeFunctionsHashDataFuncClosure* self = NULL;
	GeeHashDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	self = (GeeFunctionsHashDataFuncClosure*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = func;
	_tmp0__target = func_target;
	_tmp0__target_destroy_notify = func_target_destroy_notify;
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
	self->func = _tmp0_;
	self->func_target = _tmp0__target;
	self->func_target_destroy_notify = _tmp0__target_destroy_notify;
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	return self;
}

G_GNUC_INTERNAL GeeFunctionsHashDataFuncClosure*
gee_functions_hash_data_func_closure_new (GType g_type,
                                          GBoxedCopyFunc g_dup_func,
                                          GDestroyNotify g_destroy_func,
                                          GeeHashDataFunc func,
                                          gpointer func_target,
                                          GDestroyNotify func_target_destroy_notify)
{
	return gee_functions_hash_data_func_closure_construct (GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, g_type, g_dup_func, g_destroy_func, func, func_target, func_target_destroy_notify);
}

static guint
__lambda40_ (GeeFunctionsHashDataFuncClosure* self,
             gconstpointer a)
{
	guint result = 0U;
	GeeHashDataFunc _tmp0_;
	gpointer _tmp0__target;
	_tmp0_ = self->func;
	_tmp0__target = self->func_target;
	result = _tmp0_ (a, _tmp0__target);
	return result;
}

static guint
___lambda40__gee_hash_data_func (gconstpointer v,
                                 gpointer self)
{
	guint result;
	result = __lambda40_ ((GeeFunctionsHashDataFuncClosure*) self, v);
	return result;
}

G_GNUC_INTERNAL GeeHashDataFunc
gee_functions_hash_data_func_closure_clone_func (GeeFunctionsHashDataFuncClosure* self,
                                                 gpointer* result_target,
                                                 GDestroyNotify* result_target_destroy_notify)
{
	GeeHashDataFunc result = NULL;
	GeeHashDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ___lambda40__gee_hash_data_func;
	_tmp0__target = gee_functions_hash_data_func_closure_ref (self);
	_tmp0__target_destroy_notify = gee_functions_hash_data_func_closure_unref;
	*result_target = _tmp0__target;
	*result_target_destroy_notify = _tmp0__target_destroy_notify;
	result = _tmp0_;
	return result;
}

static void
gee_functions_value_hash_data_func_closure_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gee_functions_value_hash_data_func_closure_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gee_functions_hash_data_func_closure_unref (value->data[0].v_pointer);
	}
}

static void
gee_functions_value_hash_data_func_closure_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_functions_hash_data_func_closure_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gee_functions_value_hash_data_func_closure_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gee_functions_value_hash_data_func_closure_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GeeFunctionsHashDataFuncClosure * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_functions_hash_data_func_closure_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gee_functions_value_hash_data_func_closure_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	GeeFunctionsHashDataFuncClosure ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_functions_hash_data_func_closure_ref (value->data[0].v_pointer);
	}
	return NULL;
}

G_GNUC_INTERNAL GParamSpec*
gee_functions_param_spec_hash_data_func_closure (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	GeeFunctionsParamSpecHashDataFuncClosure* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

G_GNUC_INTERNAL gpointer
gee_functions_value_get_hash_data_func_closure (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE), NULL);
	return value->data[0].v_pointer;
}

G_GNUC_INTERNAL void
gee_functions_value_set_hash_data_func_closure (GValue* value,
                                                gpointer v_object)
{
	GeeFunctionsHashDataFuncClosure * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_functions_hash_data_func_closure_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_functions_hash_data_func_closure_unref (old);
	}
}

G_GNUC_INTERNAL void
gee_functions_value_take_hash_data_func_closure (GValue* value,
                                                 gpointer v_object)
{
	GeeFunctionsHashDataFuncClosure * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_functions_hash_data_func_closure_unref (old);
	}
}

static void
gee_functions_hash_data_func_closure_class_init (GeeFunctionsHashDataFuncClosureClass * klass,
                                                 gpointer klass_data)
{
	gee_functions_hash_data_func_closure_parent_class = g_type_class_peek_parent (klass);
	((GeeFunctionsHashDataFuncClosureClass *) klass)->finalize = gee_functions_hash_data_func_closure_finalize;
	g_type_class_adjust_private_offset (klass, &GeeFunctionsHashDataFuncClosure_private_offset);
}

static void
gee_functions_hash_data_func_closure_instance_init (GeeFunctionsHashDataFuncClosure * self,
                                                    gpointer klass)
{
	self->priv = gee_functions_hash_data_func_closure_get_instance_private (self);
	self->ref_count = 1;
}

static void
gee_functions_hash_data_func_closure_finalize (GeeFunctionsHashDataFuncClosure * obj)
{
	GeeFunctionsHashDataFuncClosure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_FUNCTIONS_TYPE_HASH_DATA_FUNC_CLOSURE, GeeFunctionsHashDataFuncClosure);
	g_signal_handlers_destroy (self);
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
}

G_GNUC_INTERNAL GType
gee_functions_hash_data_func_closure_get_type (void)
{
	static volatile gsize gee_functions_hash_data_func_closure_type_id__volatile = 0;
	if (g_once_init_enter (&gee_functions_hash_data_func_closure_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_functions_value_hash_data_func_closure_init, gee_functions_value_hash_data_func_closure_free_value, gee_functions_value_hash_data_func_closure_copy_value, gee_functions_value_hash_data_func_closure_peek_pointer, "p", gee_functions_value_hash_data_func_closure_collect_value, "p", gee_functions_value_hash_data_func_closure_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeeFunctionsHashDataFuncClosureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_functions_hash_data_func_closure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeFunctionsHashDataFuncClosure), 0, (GInstanceInitFunc) gee_functions_hash_data_func_closure_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_functions_hash_data_func_closure_type_id;
		gee_functions_hash_data_func_closure_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeeFunctionsHashDataFuncClosure", &g_define_type_info, &g_define_type_fundamental_info, 0);
		GeeFunctionsHashDataFuncClosure_private_offset = g_type_add_instance_private (gee_functions_hash_data_func_closure_type_id, sizeof (GeeFunctionsHashDataFuncClosurePrivate));
		g_once_init_leave (&gee_functions_hash_data_func_closure_type_id__volatile, gee_functions_hash_data_func_closure_type_id);
	}
	return gee_functions_hash_data_func_closure_type_id__volatile;
}

G_GNUC_INTERNAL gpointer
gee_functions_hash_data_func_closure_ref (gpointer instance)
{
	GeeFunctionsHashDataFuncClosure * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

G_GNUC_INTERNAL void
gee_functions_hash_data_func_closure_unref (gpointer instance)
{
	GeeFunctionsHashDataFuncClosure * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_FUNCTIONS_HASH_DATA_FUNC_CLOSURE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
gee_functions_compare_data_func_closure_get_instance_private (GeeFunctionsCompareDataFuncClosure* self)
{
	return G_STRUCT_MEMBER_P (self, GeeFunctionsCompareDataFuncClosure_private_offset);
}

G_GNUC_INTERNAL GeeFunctionsCompareDataFuncClosure*
gee_functions_compare_data_func_closure_construct (GType object_type,
                                                   GType g_type,
                                                   GBoxedCopyFunc g_dup_func,
                                                   GDestroyNotify g_destroy_func,
                                                   GCompareDataFunc func,
                                                   gpointer func_target,
                                                   GDestroyNotify func_target_destroy_notify)
{
	GeeFunctionsCompareDataFuncClosure* self = NULL;
	GCompareDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	self = (GeeFunctionsCompareDataFuncClosure*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = func;
	_tmp0__target = func_target;
	_tmp0__target_destroy_notify = func_target_destroy_notify;
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
	self->func = _tmp0_;
	self->func_target = _tmp0__target;
	self->func_target_destroy_notify = _tmp0__target_destroy_notify;
	(func_target_destroy_notify == NULL) ? NULL : (func_target_destroy_notify (func_target), NULL);
	func = NULL;
	func_target = NULL;
	func_target_destroy_notify = NULL;
	return self;
}

G_GNUC_INTERNAL GeeFunctionsCompareDataFuncClosure*
gee_functions_compare_data_func_closure_new (GType g_type,
                                             GBoxedCopyFunc g_dup_func,
                                             GDestroyNotify g_destroy_func,
                                             GCompareDataFunc func,
                                             gpointer func_target,
                                             GDestroyNotify func_target_destroy_notify)
{
	return gee_functions_compare_data_func_closure_construct (GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE, g_type, g_dup_func, g_destroy_func, func, func_target, func_target_destroy_notify);
}

static gint
__lambda49_ (GeeFunctionsCompareDataFuncClosure* self,
             gconstpointer a,
             gconstpointer b)
{
	gint result = 0;
	GCompareDataFunc _tmp0_;
	gpointer _tmp0__target;
	_tmp0_ = self->func;
	_tmp0__target = self->func_target;
	result = _tmp0_ (a, b, _tmp0__target);
	return result;
}

static gint
___lambda49__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda49_ ((GeeFunctionsCompareDataFuncClosure*) self, a, b);
	return result;
}

G_GNUC_INTERNAL GCompareDataFunc
gee_functions_compare_data_func_closure_clone_func (GeeFunctionsCompareDataFuncClosure* self,
                                                    gpointer* result_target,
                                                    GDestroyNotify* result_target_destroy_notify)
{
	GCompareDataFunc result = NULL;
	GCompareDataFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ___lambda49__gcompare_data_func;
	_tmp0__target = gee_functions_compare_data_func_closure_ref (self);
	_tmp0__target_destroy_notify = gee_functions_compare_data_func_closure_unref;
	*result_target = _tmp0__target;
	*result_target_destroy_notify = _tmp0__target_destroy_notify;
	result = _tmp0_;
	return result;
}

static void
gee_functions_value_compare_data_func_closure_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gee_functions_value_compare_data_func_closure_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gee_functions_compare_data_func_closure_unref (value->data[0].v_pointer);
	}
}

static void
gee_functions_value_compare_data_func_closure_copy_value (const GValue* src_value,
                                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gee_functions_compare_data_func_closure_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gee_functions_value_compare_data_func_closure_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gee_functions_value_compare_data_func_closure_collect_value (GValue* value,
                                                             guint n_collect_values,
                                                             GTypeCValue* collect_values,
                                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GeeFunctionsCompareDataFuncClosure * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gee_functions_compare_data_func_closure_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gee_functions_value_compare_data_func_closure_lcopy_value (const GValue* value,
                                                           guint n_collect_values,
                                                           GTypeCValue* collect_values,
                                                           guint collect_flags)
{
	GeeFunctionsCompareDataFuncClosure ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gee_functions_compare_data_func_closure_ref (value->data[0].v_pointer);
	}
	return NULL;
}

G_GNUC_INTERNAL GParamSpec*
gee_functions_param_spec_compare_data_func_closure (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags)
{
	GeeFunctionsParamSpecCompareDataFuncClosure* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

G_GNUC_INTERNAL gpointer
gee_functions_value_get_compare_data_func_closure (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE), NULL);
	return value->data[0].v_pointer;
}

G_GNUC_INTERNAL void
gee_functions_value_set_compare_data_func_closure (GValue* value,
                                                   gpointer v_object)
{
	GeeFunctionsCompareDataFuncClosure * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gee_functions_compare_data_func_closure_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_functions_compare_data_func_closure_unref (old);
	}
}

G_GNUC_INTERNAL void
gee_functions_value_take_compare_data_func_closure (GValue* value,
                                                    gpointer v_object)
{
	GeeFunctionsCompareDataFuncClosure * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gee_functions_compare_data_func_closure_unref (old);
	}
}

static void
gee_functions_compare_data_func_closure_class_init (GeeFunctionsCompareDataFuncClosureClass * klass,
                                                    gpointer klass_data)
{
	gee_functions_compare_data_func_closure_parent_class = g_type_class_peek_parent (klass);
	((GeeFunctionsCompareDataFuncClosureClass *) klass)->finalize = gee_functions_compare_data_func_closure_finalize;
	g_type_class_adjust_private_offset (klass, &GeeFunctionsCompareDataFuncClosure_private_offset);
}

static void
gee_functions_compare_data_func_closure_instance_init (GeeFunctionsCompareDataFuncClosure * self,
                                                       gpointer klass)
{
	self->priv = gee_functions_compare_data_func_closure_get_instance_private (self);
	self->ref_count = 1;
}

static void
gee_functions_compare_data_func_closure_finalize (GeeFunctionsCompareDataFuncClosure * obj)
{
	GeeFunctionsCompareDataFuncClosure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEE_FUNCTIONS_TYPE_COMPARE_DATA_FUNC_CLOSURE, GeeFunctionsCompareDataFuncClosure);
	g_signal_handlers_destroy (self);
	(self->func_target_destroy_notify == NULL) ? NULL : (self->func_target_destroy_notify (self->func_target), NULL);
	self->func = NULL;
	self->func_target = NULL;
	self->func_target_destroy_notify = NULL;
}

G_GNUC_INTERNAL GType
gee_functions_compare_data_func_closure_get_type (void)
{
	static volatile gsize gee_functions_compare_data_func_closure_type_id__volatile = 0;
	if (g_once_init_enter (&gee_functions_compare_data_func_closure_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gee_functions_value_compare_data_func_closure_init, gee_functions_value_compare_data_func_closure_free_value, gee_functions_value_compare_data_func_closure_copy_value, gee_functions_value_compare_data_func_closure_peek_pointer, "p", gee_functions_value_compare_data_func_closure_collect_value, "p", gee_functions_value_compare_data_func_closure_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GeeFunctionsCompareDataFuncClosureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_functions_compare_data_func_closure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeFunctionsCompareDataFuncClosure), 0, (GInstanceInitFunc) gee_functions_compare_data_func_closure_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gee_functions_compare_data_func_closure_type_id;
		gee_functions_compare_data_func_closure_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GeeFunctionsCompareDataFuncClosure", &g_define_type_info, &g_define_type_fundamental_info, 0);
		GeeFunctionsCompareDataFuncClosure_private_offset = g_type_add_instance_private (gee_functions_compare_data_func_closure_type_id, sizeof (GeeFunctionsCompareDataFuncClosurePrivate));
		g_once_init_leave (&gee_functions_compare_data_func_closure_type_id__volatile, gee_functions_compare_data_func_closure_type_id);
	}
	return gee_functions_compare_data_func_closure_type_id__volatile;
}

G_GNUC_INTERNAL gpointer
gee_functions_compare_data_func_closure_ref (gpointer instance)
{
	GeeFunctionsCompareDataFuncClosure * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

G_GNUC_INTERNAL void
gee_functions_compare_data_func_closure_unref (gpointer instance)
{
	GeeFunctionsCompareDataFuncClosure * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEE_FUNCTIONS_COMPARE_DATA_FUNC_CLOSURE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

