// Generated by gmmproc 2.63.1 -- DO NOT MODIFY!
#ifndef _GTKMM_POPOVER_H
#define _GTKMM_POPOVER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2013 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <gtkmm/bin.h>
#include <gtkmm/native.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkPopover = struct _GtkPopover;
using GtkPopoverClass = struct _GtkPopoverClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class Popover_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** Context dependent bubbles.
 *
 * %Gtk::Popover is a bubble-like context window, primarily meant to
 * provide context-dependent information or options. Popovers are
 * attached to a widget, passed at construction time on %Gtk::Popover(),
 * or updated afterwards through Gtk::Popover::set_relative_to(), by
 * default they will point to the whole widget area, although this
 * behavior can be changed through Gtk::Popover::set_pointing_to().
 *
 * The position of a popover relative to the widget it is attached to
 * can also be changed through Gtk::Popover::set_position().
 *
 * By default, %Gtk::Popover performs a GTK grab, in order to ensure
 * input events get redirected to it while it is shown, and also so
 * the popover is dismissed in the expected situations (clicks outside
 * the popover, or the Esc key being pressed). If no such modal behavior
 * is desired on a popover, Gtk::Popover::set_autohide() may be called on it
 * to tweak its behavior.
 *
 * @ingroup Widgets
 * @newin{3,12}
 */

class Popover : public Bin, public Native
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Popover CppObjectType;
  typedef Popover_Class CppClassType;
  typedef GtkPopover BaseObjectType;
  typedef GtkPopoverClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  Popover(Popover&& src) noexcept;
  Popover& operator=(Popover&& src) noexcept;

  // noncopyable
  Popover(const Popover&) = delete;
  Popover& operator=(const Popover&) = delete;

  ~Popover() noexcept override;

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Popover_Class;
  static CppClassType popover_class_;

protected:
  explicit Popover(const Glib::ConstructParams& construct_params);
  explicit Popover(GtkPopover* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  /// Provides access to the underlying C GObject.
  GtkPopover*       gobj()       { return reinterpret_cast<GtkPopover*>(gobject_); }

  /// Provides access to the underlying C GObject.
  const GtkPopover* gobj() const { return reinterpret_cast<GtkPopover*>(gobject_); }

private:

  
public:
  /** @addtogroup gtkmmEnums gtkmm Enums and Flags */

  /** 
   *  @var Constraint NONE
   * Don't constrain the popover position
   * beyond what is imposed by the implementation.
   * 
   *  @var Constraint WINDOW
   * Constrain the popover to the boundaries
   * of the window that it is attached to.
   * 
   *  @enum Constraint
   * 
   * Describes constraints to positioning of popovers. More values
   * may be added to this enumeration in the future.
   *
   * @ingroup gtkmmEnums
   */
  enum class Constraint
  {
    NONE,
    WINDOW
  };


  /** Creates a new popover to point to @a relative_to
   *
   * @param relative_to The Gtk::Widget the popover is related to
   */
    explicit Popover(const Widget& relative_to);


  /// A Popover() convenience overload.
  explicit Popover();


  /** Sets a new widget to be attached to @a popover. If @a popover is
   * visible, the position will be updated.
   * 
   * @note the ownership of popovers is always given to their @a relative_to
   * widget, so if @a relative_to is set to <tt>nullptr</tt> on an attached @a popover, it
   * will be detached from its previous widget, and consequently destroyed
   * unless extra references are kept.
   * 
   * @param relative_to A Gtk::Widget.
   */
  void set_relative_to(const Widget& relative_to);
  // transfer none
  
  /** Returns the widget @a popover is currently attached to
   * 
   * @return A Gtk::Widget.
   */
  Widget* get_relative_to();
  
  /** Returns the widget @a popover is currently attached to
   * 
   * @return A Gtk::Widget.
   */
  const Widget* get_relative_to() const;

  //This cannot take NULL to mean unset.
 

  /** Sets the rectangle that @a popover will point to, in the
   * coordinate space of the widget @a popover is attached to,
   * see set_relative_to().
   * 
   * @param rect Rectangle to point to.
   */
  void set_pointing_to(const Gdk::Rectangle& rect);
 

  /** If a rectangle to point to has been set, this function will
   * return <tt>true</tt> and fill in @a rect with such rectangle, otherwise
   * it will return <tt>false</tt> and fill in @a rect with the attached
   * widget coordinates.
   * 
   * @param rect Location to store the rectangle.
   * @return <tt>true</tt> if a rectangle to point to was set.
   */
  bool get_pointing_to(Gdk::Rectangle& rect) const;

  
  /** Sets the preferred position for @a popover to appear. If the @a popover
   * is currently visible, it will be immediately updated.
   * 
   * This preference will be respected where possible, although
   * on lack of space (eg. if close to the window edges), the
   * Gtk::Popover may choose to appear on the opposite side
   * 
   * @param position Preferred popover position.
   */
  void set_position(PositionType position =  PositionType::TOP);
  
  /** Returns the preferred position of @a popover.
   * 
   * @return The preferred position.
   */
  PositionType get_position() const;

  
  /** Sets whether @a popover is modal.
   * 
   * A modal popover will grab the keyboard focus on it when being
   * displayed. Clicking outside the popover area or pressing Esc will
   * dismiss the popover.
   * 
   * @param autohide #<tt>true</tt> to dismiss the popover on outside clicks.
   */
  void set_autohide(bool autohide =  true);
  
  /** Returns whether the popover is modal.
   * 
   * See set_autohide() for the
   * implications of this.
   * 
   * @return #<tt>true</tt> if @a popover is modal.
   */
  bool get_autohide() const;

  
  /** Sets whether this popover should draw an arrow
   * pointing at the widget it is relative to.
   * 
   * @param has_arrow <tt>true</tt> to draw an arrow.
   */
  void set_has_arrow(bool has_arrow =  true);
  
  /** Gets whether this popover is showing an arrow
   * pointing at the widget that it is relative to.
   * 
   * @return Whether the popover has an arrow.
   */
  bool get_has_arrow() const;

  
  void set_default_widget(Widget& widget);

  
  /** Pops @a popover up. This is different than a Gtk::Widget::show() call
   * in that it shows the popover with a transition. If you want to show
   * the popover without a transition, use Gtk::Widget::show().
   */
  void popup();
  
  /** Pops @a popover down.This is different than a Gtk::Widget::hide() call
   * in that it shows the popover with a transition. If you want to hide
   * the popover without a transition, use Gtk::Widget::hide().
   */
  void popdown();

  /** Widget the bubble window points to.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_relative_to() ;

/** Widget the bubble window points to.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_relative_to() const;

  /** Rectangle the bubble window points to.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Gdk::Rectangle > property_pointing_to() ;

/** Rectangle the bubble window points to.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Gdk::Rectangle > property_pointing_to() const;

  /** Position to place the bubble window.
   *
   * Default value: Gtk::PositionType::BOTTOM
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< PositionType > property_position() ;

/** Position to place the bubble window.
   *
   * Default value: Gtk::PositionType::BOTTOM
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< PositionType > property_position() const;

  /** Whether to dismiss the popover on outside clicks.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_autohide() ;

/** Whether to dismiss the popover on outside clicks.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_autohide() const;

  /** Whether to draw an arrow.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_has_arrow() ;

/** Whether to draw an arrow.
   *
   * Default value: <tt>true</tt>
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_has_arrow() const;

  /** The default widget.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Widget* > property_default_widget() ;

/** The default widget.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Widget* > property_default_widget() const;


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%closed()</tt>
   *
   * Flags: Run Last
   *
   */

  Glib::SignalProxy<void()> signal_closed();

  
public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_closed().
  virtual void on_closed();


};

} // namespace Gtk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Popover::Constraint> : public Glib::Value_Enum<Gtk::Popover::Constraint>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::Popover
   */
  Gtk::Popover* wrap(GtkPopover* object, bool take_copy = false);
} //namespace Glib


#endif /* _GTKMM_POPOVER_H */

