/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_gsignal_module_parent_class = NULL;

static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                                    ValaList* params,
                                                    ValaDataType* return_type,
                                                    const gchar* prefix);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                                     ValaList* params,
                                                     ValaDataType* return_type);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                                    ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                               ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                                      ValaSignal* sig,
                                                                      ValaExpression* detail_expr,
                                                                      ValaCodeNode* node);
static ValaCCodeExpression* vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                                                    ValaSignal* sig);
static ValaCCodeExpression* vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                                                 ValaExpression* detail_expr,
                                                                 ValaCodeNode* node);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                            ValaSignal* sig);
static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                              ValaList* params,
                                              ValaDataType* return_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                                                   ValaSignal* sig,
                                                                   ValaTypeSymbol* type);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                                    ValaElementAccess* expr);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                                  ValaMethod* m);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                                   ValaMemberAccess* expr);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                                         ValaSignal* sig,
                                                         ValaExpression* signal_access,
                                                         ValaExpression* handler,
                                                         gboolean disconnect,
                                                         gboolean after,
                                                         ValaCodeNode* expr);
static GType vala_gsignal_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                             ValaList* params,
                                             ValaDataType* return_type,
                                             const gchar* prefix)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* ret = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type);
	signature = _tmp0_;
	if (prefix == NULL) {
		ValaSet* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
		_tmp2_ = signature;
		if (vala_collection_contains ((ValaCollection*) _tmp1_, _tmp2_)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp3_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_%s_", prefix, _tmp4_);
	_g_free0 (ret);
	ret = _tmp5_;
	_g_free0 (_tmp4_);
	if (params == NULL) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp8_ = _tmp7_;
		_tmp6_ = _tmp8_ == 0;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = ret;
		_tmp10_ = g_strconcat (_tmp9_, "_VOID", NULL);
		_g_free0 (ret);
		ret = _tmp10_;
	} else {
		{
			ValaList* _p_list = NULL;
			ValaList* _tmp11_;
			gint _p_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _p_index = 0;
			_tmp11_ = _vala_iterable_ref0 (params);
			_p_list = _tmp11_;
			_tmp12_ = _p_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_p_size = _tmp14_;
			_p_index = -1;
			while (TRUE) {
				ValaParameter* p = NULL;
				ValaList* _tmp15_;
				gpointer _tmp16_;
				const gchar* _tmp17_;
				ValaParameter* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_p_index = _p_index + 1;
				if (!(_p_index < _p_size)) {
					break;
				}
				_tmp15_ = _p_list;
				_tmp16_ = vala_list_get (_tmp15_, _p_index);
				p = (ValaParameter*) _tmp16_;
				_tmp17_ = ret;
				_tmp18_ = p;
				_tmp19_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = string_replace (_tmp20_, ",", "_");
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup_printf ("%s_%s", _tmp17_, _tmp22_);
				_g_free0 (ret);
				ret = _tmp23_;
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                             ValaDataType* t)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_POINTER_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gpointer");
		result = _tmp1_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VOID_TYPE)) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("void");
			result = _tmp2_;
			return result;
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			ValaDataType* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = vala_get_ccode_type_id ((ValaCodeNode*) t);
			_tmp4_ = _tmp3_;
			_tmp5_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp6_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp4_, _tmp7_) == 0;
			_g_free0 (_tmp7_);
			_g_free0 (_tmp4_);
			if (_tmp8_) {
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("const char*");
				result = _tmp9_;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp11_ = vala_data_type_get_type_symbol (t);
				_tmp12_ = _tmp11_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
					_tmp10_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					_tmp13_ = vala_data_type_get_type_symbol (t);
					_tmp14_ = _tmp13_;
					_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE);
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("gpointer");
					result = _tmp15_;
					return result;
				} else {
					gboolean _tmp16_ = FALSE;
					if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VALUE_TYPE)) {
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp17_ = vala_data_type_get_nullable (t);
						_tmp18_ = _tmp17_;
						_tmp16_ = _tmp18_;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						gchar* _tmp19_;
						_tmp19_ = g_strdup ("gpointer");
						result = _tmp19_;
						return result;
					} else {
						ValaTypeSymbol* _tmp20_;
						ValaTypeSymbol* _tmp21_;
						_tmp20_ = vala_data_type_get_type_symbol (t);
						_tmp21_ = _tmp20_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_STRUCT)) {
							ValaStruct* st = NULL;
							ValaTypeSymbol* _tmp22_;
							ValaTypeSymbol* _tmp23_;
							ValaStruct* _tmp24_;
							_tmp22_ = vala_data_type_get_type_symbol (t);
							_tmp23_ = _tmp22_;
							st = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_STRUCT, ValaStruct);
							_tmp24_ = st;
							if (vala_struct_is_simple_type (_tmp24_)) {
								ValaTypeSymbol* _tmp25_;
								ValaTypeSymbol* _tmp26_;
								gchar* _tmp27_;
								_tmp25_ = vala_data_type_get_type_symbol (t);
								_tmp26_ = _tmp25_;
								_tmp27_ = vala_get_ccode_name ((ValaCodeNode*) _tmp26_);
								result = _tmp27_;
								return result;
							} else {
								gchar* _tmp28_;
								_tmp28_ = g_strdup ("gpointer");
								result = _tmp28_;
								return result;
							}
						} else {
							ValaTypeSymbol* _tmp29_;
							ValaTypeSymbol* _tmp30_;
							_tmp29_ = vala_data_type_get_type_symbol (t);
							_tmp30_ = _tmp29_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_ENUM)) {
								ValaEnum* en = NULL;
								ValaTypeSymbol* _tmp31_;
								ValaTypeSymbol* _tmp32_;
								ValaEnum* _tmp33_;
								gboolean _tmp34_;
								gboolean _tmp35_;
								_tmp31_ = vala_data_type_get_type_symbol (t);
								_tmp32_ = _tmp31_;
								en = G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_ENUM, ValaEnum);
								_tmp33_ = en;
								_tmp34_ = vala_enum_get_is_flags (_tmp33_);
								_tmp35_ = _tmp34_;
								if (_tmp35_) {
									gchar* _tmp36_;
									_tmp36_ = g_strdup ("guint");
									result = _tmp36_;
									return result;
								} else {
									gchar* _tmp37_;
									_tmp37_ = g_strdup ("gint");
									result = _tmp37_;
									return result;
								}
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ARRAY_TYPE)) {
									gchar* _tmp38_;
									_tmp38_ = g_strdup ("gpointer");
									result = _tmp38_;
									return result;
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_DELEGATE_TYPE)) {
										gchar* _tmp39_;
										_tmp39_ = g_strdup ("gpointer");
										result = _tmp39_;
										return result;
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ERROR_TYPE)) {
											gchar* _tmp40_;
											_tmp40_ = g_strdup ("gpointer");
											result = _tmp40_;
											return result;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                        ValaParameter* p)
{
	ValaParameterDirection _tmp0_;
	ValaParameterDirection _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp4_);
		result = _tmp5_;
		return result;
	}
}

static gchar*
vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                              ValaList* params,
                                              ValaDataType* return_type)
{
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_g_free0 (signature);
	signature = _tmp2_;
	_g_free0 (_tmp1_);
	if (params == NULL) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_ == 0;
	}
	if (_tmp3_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = signature;
		_tmp7_ = g_strconcat (_tmp6_, "VOID", NULL);
		_g_free0 (signature);
		signature = _tmp7_;
	} else {
		gboolean first = FALSE;
		first = TRUE;
		{
			ValaList* _p_list = NULL;
			ValaList* _tmp8_;
			gint _p_size = 0;
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _p_index = 0;
			_tmp8_ = _vala_iterable_ref0 (params);
			_p_list = _tmp8_;
			_tmp9_ = _p_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_p_size = _tmp11_;
			_p_index = -1;
			while (TRUE) {
				ValaParameter* p = NULL;
				ValaList* _tmp12_;
				gpointer _tmp13_;
				_p_index = _p_index + 1;
				if (!(_p_index < _p_size)) {
					break;
				}
				_tmp12_ = _p_list;
				_tmp13_ = vala_list_get (_tmp12_, _p_index);
				p = (ValaParameter*) _tmp13_;
				if (first) {
					const gchar* _tmp14_;
					ValaParameter* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					_tmp14_ = signature;
					_tmp15_ = p;
					_tmp16_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strconcat (_tmp14_, _tmp17_, NULL);
					_g_free0 (signature);
					signature = _tmp18_;
					_g_free0 (_tmp17_);
					first = FALSE;
				} else {
					const gchar* _tmp19_;
					ValaParameter* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp19_ = signature;
					_tmp20_ = p;
					_tmp21_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strdup_printf ("%s,%s", _tmp19_, _tmp22_);
					_g_free0 (signature);
					signature = _tmp23_;
					_g_free0 (_tmp22_);
				}
				_vala_code_node_unref0 (p);
			}
			_vala_iterable_unref0 (_p_list);
		}
	}
	result = signature;
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                 ValaSignal* sig,
                                                 ValaExpression* detail_expr,
                                                 ValaCodeNode* node)
{
	ValaTargetValue* detail_value = NULL;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	ValaTargetValue* _tmp8_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	ValaTargetValue* _tmp11_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeExpression* _tmp20_;
	ValaCCodeExpression* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeConstant* _tmp23_;
	ValaCCodeConstant* _tmp24_;
	ValaCCodeFunction* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaTargetValue* _tmp27_;
	ValaCCodeExpression* _tmp28_;
	ValaCCodeExpression* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaTargetValue* _tmp31_;
	ValaCCodeExpression* _tmp32_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_;
		_tmp0_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (detail_expr, VALA_TYPE_STRING_LITERAL)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeExpression* _tmp4_;
		_tmp1_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (detail_expr, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, _tmp2_);
		_tmp4_ = (ValaCCodeExpression*) _tmp3_;
		_g_free0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = vala_expression_get_value_type (detail_expr);
	_tmp6_ = _tmp5_;
	_tmp7_ = TRUE;
	_tmp8_ = vala_ccode_base_module_create_temp_value ((ValaCCodeBaseModule*) self, _tmp6_, FALSE, node, &_tmp7_);
	detail_value = _tmp8_;
	_tmp9_ = vala_ccode_base_module_get_temp_ref_values ((ValaCCodeBaseModule*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = detail_value;
	vala_list_insert ((ValaList*) _tmp10_, 0, _tmp11_);
	_tmp12_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp13_);
	_tmp15_ = _tmp14_;
	_vala_ccode_node_unref0 (_tmp13_);
	ccall = _tmp15_;
	_tmp16_ = ccall;
	_tmp17_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, "");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = ccall;
	_tmp20_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	_tmp21_ = _tmp20_;
	vala_ccode_function_call_add_argument (_tmp19_, _tmp21_);
	_vala_ccode_node_unref0 (_tmp21_);
	_tmp22_ = ccall;
	_tmp23_ = vala_ccode_constant_new ("NULL");
	_tmp24_ = _tmp23_;
	vala_ccode_function_call_add_argument (_tmp22_, (ValaCCodeExpression*) _tmp24_);
	_vala_ccode_node_unref0 (_tmp24_);
	_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = detail_value;
	_tmp28_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ccall;
	vala_ccode_function_add_assignment (_tmp26_, _tmp29_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp29_);
	_tmp31_ = detail_value;
	_tmp32_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp31_);
	result = _tmp32_;
	_vala_ccode_node_unref0 (ccall);
	_vala_target_value_unref0 (detail_value);
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static ValaCCodeExpression*
vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                               ValaSignal* sig)
{
	ValaTypeSymbol* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaCCodeIdentifier* signal_array = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* signal_enum_value = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeElementAccess* _tmp17_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	cl = _tmp2_;
	_tmp3_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_signals", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_identifier_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	signal_array = _tmp8_;
	_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_identifier_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	signal_enum_value = _tmp16_;
	_tmp17_ = vala_ccode_element_access_new ((ValaCCodeExpression*) signal_array, (ValaCCodeExpression*) signal_enum_value);
	result = (ValaCCodeExpression*) _tmp17_;
	_vala_ccode_node_unref0 (signal_enum_value);
	_vala_ccode_node_unref0 (signal_array);
	_vala_code_node_unref0 (cl);
	return result;
}

static ValaCCodeExpression*
vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                            ValaExpression* detail_expr,
                                            ValaCodeNode* node)
{
	ValaCCodeExpression* detail_cexpr = NULL;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeFunctionCall* detail_ccall = NULL;
	ValaCCodeExpression* _tmp1_;
	ValaCCodeFunctionCall* _tmp8_;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail_expr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	detail_cexpr = _tmp0_;
	_tmp1_ = detail_cexpr;
	if (vala_ccode_base_module_is_constant_ccode_expression (_tmp1_)) {
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeIdentifier* _tmp3_;
		ValaCCodeFunctionCall* _tmp4_;
		_tmp2_ = vala_ccode_identifier_new ("g_quark_from_static_string");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
	} else {
		ValaCCodeIdentifier* _tmp5_;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeFunctionCall* _tmp7_;
		_tmp5_ = vala_ccode_identifier_new ("g_quark_from_string");
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp6_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp7_;
		_vala_ccode_node_unref0 (_tmp6_);
	}
	_tmp8_ = detail_ccall;
	_tmp9_ = detail_cexpr;
	vala_ccode_function_call_add_argument (_tmp8_, _tmp9_);
	result = (ValaCCodeExpression*) detail_ccall;
	_vala_ccode_node_unref0 (detail_cexpr);
	return result;
}

static void
vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                       ValaSignal* sig)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaCCodeEnum* _tmp1_;
	ValaList* _tmp31_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp1_ = ((ValaCCodeBaseModule*) self)->signal_enum;
	if (_tmp1_ != NULL) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp3_ = _tmp2_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCCodeEnum* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		ValaCCodeEnumValue* _tmp13_;
		ValaCCodeEnumValue* _tmp14_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->signal_enum;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_get_ccode_upper_case_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp8_, _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_ccode_enum_value_new (_tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_ccode_enum_add_value (_tmp4_, _tmp14_);
		_vala_ccode_node_unref0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _p_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _p_index = 0;
		_tmp15_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_p_list = _tmp16_;
		_tmp17_ = _p_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_p_size = _tmp19_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaParameter* _tmp22_;
			ValaCCodeFile* _tmp23_;
			GHashFunc _tmp24_;
			GEqualFunc _tmp25_;
			GEqualFunc _tmp26_;
			ValaHashMap* _tmp27_;
			ValaHashMap* _tmp28_;
			ValaCCodeParameter* _tmp29_;
			ValaCCodeParameter* _tmp30_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp20_ = _p_list;
			_tmp21_ = vala_list_get (_tmp20_, _p_index);
			p = (ValaParameter*) _tmp21_;
			_tmp22_ = p;
			_tmp23_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp24_ = g_direct_hash;
			_tmp25_ = g_direct_equal;
			_tmp26_ = g_direct_equal;
			_tmp27_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp24_, _tmp25_, _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, _tmp22_, _tmp23_, (ValaMap*) _tmp28_, NULL);
			_tmp30_ = _tmp29_;
			_vala_ccode_node_unref0 (_tmp30_);
			_vala_map_unref0 (_tmp28_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp31_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp32_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp33_ = _tmp32_;
	vala_gsignal_module_generate_marshaller (self, _tmp31_, _tmp33_);
}

static void
vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                         ValaList* params,
                                         ValaDataType* return_type)
{
	gchar* signature = NULL;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSet* _tmp2_;
	const gchar* _tmp3_;
	ValaCCodeFunction* signal_marshaller = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunctionDeclarator* callback_decl = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaCCodeFunctionDeclarator* _tmp32_;
	ValaCCodeFunctionDeclarator* _tmp33_;
	ValaCCodeFunctionDeclarator* _tmp34_;
	ValaCCodeParameter* _tmp35_;
	ValaCCodeParameter* _tmp36_;
	ValaCCodeFunctionDeclarator* _tmp103_;
	ValaCCodeParameter* _tmp104_;
	ValaCCodeParameter* _tmp105_;
	ValaCCodeFunction* _tmp106_;
	ValaCCodeFunction* _tmp107_;
	gchar* _tmp108_;
	gchar* _tmp109_;
	ValaCCodeFunctionDeclarator* _tmp110_;
	ValaCCodeTypeDefinition* _tmp111_;
	ValaCCodeTypeDefinition* _tmp112_;
	ValaCCodeFunction* _tmp113_;
	ValaCCodeFunction* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	ValaCCodeVariableDeclarator* _tmp117_;
	ValaCCodeVariableDeclarator* _tmp118_;
	ValaCCodeFunction* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeIdentifier* _tmp121_;
	ValaCCodeIdentifier* _tmp122_;
	ValaCCodeCastExpression* _tmp123_;
	ValaCCodeCastExpression* _tmp124_;
	ValaCCodeVariableDeclarator* _tmp125_;
	ValaCCodeVariableDeclarator* _tmp126_;
	ValaCCodeFunction* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeVariableDeclarator* _tmp129_;
	ValaCCodeVariableDeclarator* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	ValaCCodeFunction* _tmp132_;
	ValaCCodeVariableDeclarator* _tmp133_;
	ValaCCodeVariableDeclarator* _tmp134_;
	ValaCCodeFunctionCall* fc = NULL;
	gboolean _tmp135_ = FALSE;
	ValaTypeSymbol* _tmp136_;
	ValaTypeSymbol* _tmp137_;
	ValaCCodeIdentifier* _tmp157_;
	ValaCCodeIdentifier* _tmp158_;
	ValaCCodeFunctionCall* _tmp159_;
	ValaCCodeFunctionCall* _tmp160_;
	ValaCCodeIdentifier* _tmp161_;
	ValaCCodeIdentifier* _tmp162_;
	gchar* _tmp163_;
	gchar* _tmp164_;
	ValaCCodeConstant* _tmp165_;
	ValaCCodeConstant* _tmp166_;
	ValaCCodeBinaryExpression* _tmp167_;
	ValaCCodeBinaryExpression* _tmp168_;
	ValaCCodeFunction* _tmp169_;
	ValaCCodeFunction* _tmp170_;
	ValaCCodeFunctionCall* _tmp171_;
	ValaCCodeMemberAccess* data = NULL;
	ValaCCodeIdentifier* _tmp172_;
	ValaCCodeIdentifier* _tmp173_;
	ValaCCodeMemberAccess* _tmp174_;
	ValaCCodeMemberAccess* _tmp175_;
	ValaCCodeMemberAccess* param = NULL;
	ValaCCodeIdentifier* _tmp176_;
	ValaCCodeIdentifier* _tmp177_;
	ValaCCodeMemberAccess* _tmp178_;
	ValaCCodeMemberAccess* _tmp179_;
	ValaCCodeMemberAccess* _tmp180_;
	ValaCCodeMemberAccess* _tmp181_;
	ValaCCodeFunctionCall* cond = NULL;
	ValaCCodeConstant* _tmp182_;
	ValaCCodeConstant* _tmp183_;
	ValaCCodeFunctionCall* _tmp184_;
	ValaCCodeFunctionCall* _tmp185_;
	ValaCCodeFunctionCall* _tmp186_;
	ValaCCodeIdentifier* _tmp187_;
	ValaCCodeIdentifier* _tmp188_;
	ValaCCodeFunction* _tmp189_;
	ValaCCodeFunction* _tmp190_;
	ValaCCodeFunctionCall* _tmp191_;
	ValaCCodeFunction* _tmp192_;
	ValaCCodeFunction* _tmp193_;
	ValaCCodeIdentifier* _tmp194_;
	ValaCCodeIdentifier* _tmp195_;
	ValaCCodeMemberAccess* _tmp196_;
	ValaCCodeFunction* _tmp197_;
	ValaCCodeFunction* _tmp198_;
	ValaCCodeIdentifier* _tmp199_;
	ValaCCodeIdentifier* _tmp200_;
	ValaCCodeMemberAccess* _tmp201_;
	ValaCCodeFunction* _tmp202_;
	ValaCCodeFunction* _tmp203_;
	ValaCCodeFunction* _tmp204_;
	ValaCCodeFunction* _tmp205_;
	ValaCCodeIdentifier* _tmp206_;
	ValaCCodeIdentifier* _tmp207_;
	ValaCCodeMemberAccess* _tmp208_;
	ValaCCodeFunction* _tmp209_;
	ValaCCodeFunction* _tmp210_;
	ValaCCodeIdentifier* _tmp211_;
	ValaCCodeIdentifier* _tmp212_;
	ValaCCodeMemberAccess* _tmp213_;
	ValaCCodeFunction* _tmp214_;
	ValaCCodeFunction* _tmp215_;
	ValaCCodeCastExpression* c_assign_rhs = NULL;
	ValaCCodeIdentifier* _tmp216_;
	ValaCCodeIdentifier* _tmp217_;
	ValaCCodeIdentifier* _tmp218_;
	ValaCCodeIdentifier* _tmp219_;
	ValaCCodeIdentifier* _tmp220_;
	ValaCCodeIdentifier* _tmp221_;
	ValaCCodeMemberAccess* _tmp222_;
	ValaCCodeMemberAccess* _tmp223_;
	ValaCCodeConditionalExpression* _tmp224_;
	ValaCCodeConditionalExpression* _tmp225_;
	gchar* _tmp226_;
	gchar* _tmp227_;
	ValaCCodeCastExpression* _tmp228_;
	ValaCCodeCastExpression* _tmp229_;
	ValaCCodeFunction* _tmp230_;
	ValaCCodeFunction* _tmp231_;
	ValaCCodeIdentifier* _tmp232_;
	ValaCCodeIdentifier* _tmp233_;
	ValaCCodeCastExpression* _tmp234_;
	ValaCCodeIdentifier* _tmp235_;
	ValaCCodeIdentifier* _tmp236_;
	ValaCCodeFunctionCall* _tmp237_;
	ValaCCodeFunctionCall* _tmp238_;
	ValaCCodeIdentifier* _tmp239_;
	ValaCCodeIdentifier* _tmp240_;
	ValaCCodeFunctionCall* _tmp396_;
	ValaCCodeIdentifier* _tmp397_;
	ValaCCodeIdentifier* _tmp398_;
	gboolean _tmp399_ = FALSE;
	ValaTypeSymbol* _tmp400_;
	ValaTypeSymbol* _tmp401_;
	ValaCCodeFile* _tmp467_;
	ValaCCodeFunction* _tmp468_;
	ValaCCodeFile* _tmp469_;
	ValaCCodeFunction* _tmp470_;
	ValaSet* _tmp471_;
	const gchar* _tmp472_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type);
	_g_free0 (signature);
	signature = _tmp0_;
	_tmp2_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
	_tmp3_ = signature;
	if (vala_collection_contains ((ValaCollection*) _tmp2_, _tmp3_)) {
		_tmp1_ = TRUE;
	} else {
		ValaSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
		_tmp5_ = signature;
		_tmp1_ = vala_collection_contains ((ValaCollection*) _tmp4_, _tmp5_);
	}
	if (_tmp1_) {
		_g_free0 (signature);
		return;
	}
	_tmp6_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_function_new (_tmp7_, "void");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	signal_marshaller = _tmp9_;
	_tmp10_ = signal_marshaller;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp10_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp11_ = signal_marshaller;
	_tmp12_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (_tmp11_, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_tmp14_ = signal_marshaller;
	_tmp15_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (_tmp14_, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = signal_marshaller;
	_tmp18_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = signal_marshaller;
	_tmp21_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = signal_marshaller;
	_tmp24_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = signal_marshaller;
	_tmp27_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = signal_marshaller;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp30_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_function_declarator_new (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	callback_decl = _tmp33_;
	_tmp34_ = callback_decl;
	_tmp35_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp36_ = _tmp35_;
	vala_ccode_function_declarator_add_parameter (_tmp34_, _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	n_params = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp37_;
		gint _p_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _p_index = 0;
		_tmp37_ = _vala_iterable_ref0 (params);
		_p_list = _tmp37_;
		_tmp38_ = _p_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_p_size = _tmp40_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp41_;
			gpointer _tmp42_;
			ValaCCodeFunctionDeclarator* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaParameter* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			ValaCCodeParameter* _tmp49_;
			ValaCCodeParameter* _tmp50_;
			gint _tmp51_;
			ValaParameter* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp41_ = _p_list;
			_tmp42_ = vala_list_get (_tmp41_, _p_index);
			p = (ValaParameter*) _tmp42_;
			_tmp43_ = callback_decl;
			_tmp44_ = g_strdup_printf ("arg_%d", n_params);
			_tmp45_ = _tmp44_;
			_tmp46_ = p;
			_tmp47_ = vala_gsignal_module_get_value_type_name_from_parameter (self, _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_ccode_parameter_new (_tmp45_, _tmp48_);
			_tmp50_ = _tmp49_;
			vala_ccode_function_declarator_add_parameter (_tmp43_, _tmp50_);
			_vala_ccode_node_unref0 (_tmp50_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp45_);
			_tmp51_ = n_params;
			n_params = _tmp51_ + 1;
			_tmp52_ = p;
			_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) _tmp52_);
			_tmp54_ = _tmp53_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp55_;
				ValaDataType* _tmp56_;
				ValaDataType* _tmp57_;
				ValaArrayType* _tmp58_;
				gchar* length_ctype = NULL;
				ValaArrayType* _tmp59_;
				gchar* _tmp60_;
				_tmp55_ = p;
				_tmp56_ = vala_variable_get_variable_type ((ValaVariable*) _tmp55_);
				_tmp57_ = _tmp56_;
				_tmp58_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp58_;
				_tmp59_ = array_type;
				_tmp60_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp59_);
				length_ctype = _tmp60_;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp61_ = FALSE;
						_tmp61_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp63_;
							gint _tmp64_;
							gint _tmp65_;
							ValaCCodeFunctionDeclarator* _tmp66_;
							gchar* _tmp67_;
							gchar* _tmp68_;
							const gchar* _tmp69_;
							ValaCCodeParameter* _tmp70_;
							ValaCCodeParameter* _tmp71_;
							gint _tmp72_;
							if (!_tmp61_) {
								gint _tmp62_;
								_tmp62_ = j;
								j = _tmp62_ + 1;
							}
							_tmp61_ = FALSE;
							_tmp63_ = array_type;
							_tmp64_ = vala_array_type_get_rank (_tmp63_);
							_tmp65_ = _tmp64_;
							if (!(j < _tmp65_)) {
								break;
							}
							_tmp66_ = callback_decl;
							_tmp67_ = g_strdup_printf ("arg_%d", n_params);
							_tmp68_ = _tmp67_;
							_tmp69_ = length_ctype;
							_tmp70_ = vala_ccode_parameter_new (_tmp68_, _tmp69_);
							_tmp71_ = _tmp70_;
							vala_ccode_function_declarator_add_parameter (_tmp66_, _tmp71_);
							_vala_ccode_node_unref0 (_tmp71_);
							_g_free0 (_tmp68_);
							_tmp72_ = n_params;
							n_params = _tmp72_ + 1;
						}
					}
				}
				_g_free0 (length_ctype);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				_tmp73_ = p;
				_tmp74_ = vala_variable_get_variable_type ((ValaVariable*) _tmp73_);
				_tmp75_ = _tmp74_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp76_;
					ValaDataType* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDelegateType* _tmp79_;
					ValaDelegate* _tmp80_;
					ValaDelegate* _tmp81_;
					gboolean _tmp82_;
					gboolean _tmp83_;
					_tmp76_ = p;
					_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) _tmp76_);
					_tmp78_ = _tmp77_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp79_ = delegate_type;
					_tmp80_ = vala_delegate_type_get_delegate_symbol (_tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = vala_delegate_get_has_target (_tmp81_);
					_tmp83_ = _tmp82_;
					if (_tmp83_) {
						ValaCCodeFunctionDeclarator* _tmp84_;
						gchar* _tmp85_;
						gchar* _tmp86_;
						ValaDataType* _tmp87_;
						gchar* _tmp88_;
						gchar* _tmp89_;
						ValaCCodeParameter* _tmp90_;
						ValaCCodeParameter* _tmp91_;
						gint _tmp92_;
						ValaDelegateType* _tmp93_;
						_tmp84_ = callback_decl;
						_tmp85_ = g_strdup_printf ("arg_%d", n_params);
						_tmp86_ = _tmp85_;
						_tmp87_ = ((ValaCCodeBaseModule*) self)->delegate_target_type;
						_tmp88_ = vala_get_ccode_name ((ValaCodeNode*) _tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = vala_ccode_parameter_new (_tmp86_, _tmp89_);
						_tmp91_ = _tmp90_;
						vala_ccode_function_declarator_add_parameter (_tmp84_, _tmp91_);
						_vala_ccode_node_unref0 (_tmp91_);
						_g_free0 (_tmp89_);
						_g_free0 (_tmp86_);
						_tmp92_ = n_params;
						n_params = _tmp92_ + 1;
						_tmp93_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp93_)) {
							ValaCCodeFunctionDeclarator* _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							ValaDelegateType* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							ValaCCodeParameter* _tmp100_;
							ValaCCodeParameter* _tmp101_;
							gint _tmp102_;
							_tmp94_ = callback_decl;
							_tmp95_ = g_strdup_printf ("arg_%d", n_params);
							_tmp96_ = _tmp95_;
							_tmp97_ = ((ValaCCodeBaseModule*) self)->delegate_target_destroy_type;
							_tmp98_ = vala_get_ccode_name ((ValaCodeNode*) _tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = vala_ccode_parameter_new (_tmp96_, _tmp99_);
							_tmp101_ = _tmp100_;
							vala_ccode_function_declarator_add_parameter (_tmp94_, _tmp101_);
							_vala_ccode_node_unref0 (_tmp101_);
							_g_free0 (_tmp99_);
							_g_free0 (_tmp96_);
							_tmp102_ = n_params;
							n_params = _tmp102_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp103_ = callback_decl;
	_tmp104_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp105_ = _tmp104_;
	vala_ccode_function_declarator_add_parameter (_tmp103_, _tmp105_);
	_vala_ccode_node_unref0 (_tmp105_);
	_tmp106_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp107_ = _tmp106_;
	_tmp108_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp109_ = _tmp108_;
	_tmp110_ = callback_decl;
	_tmp111_ = vala_ccode_type_definition_new (_tmp109_, (ValaCCodeDeclarator*) _tmp110_);
	_tmp112_ = _tmp111_;
	vala_ccode_function_add_statement (_tmp107_, (ValaCCodeNode*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_g_free0 (_tmp109_);
	_tmp113_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp114_ = _tmp113_;
	_tmp115_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp118_ = _tmp117_;
	vala_ccode_function_add_declaration (_tmp114_, _tmp116_, (ValaCCodeDeclarator*) _tmp118_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp118_);
	_g_free0 (_tmp116_);
	_tmp119_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_identifier_new ("closure");
	_tmp122_ = _tmp121_;
	_tmp123_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp122_, "GCClosure *");
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp124_, NULL);
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_declaration (_tmp120_, "GCClosure *", (ValaCCodeDeclarator*) _tmp126_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp126_);
	_vala_ccode_node_unref0 (_tmp124_);
	_vala_ccode_node_unref0 (_tmp122_);
	_tmp127_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp130_ = _tmp129_;
	vala_ccode_function_add_declaration (_tmp128_, "gpointer", (ValaCCodeDeclarator*) _tmp130_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp130_);
	_tmp131_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp132_ = _tmp131_;
	_tmp133_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp134_ = _tmp133_;
	vala_ccode_function_add_declaration (_tmp132_, "gpointer", (ValaCCodeDeclarator*) _tmp134_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp134_);
	_tmp136_ = vala_data_type_get_type_symbol (return_type);
	_tmp137_ = _tmp136_;
	if (_tmp137_ != NULL) {
		_tmp135_ = TRUE;
	} else {
		_tmp135_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp135_) {
		ValaCCodeFunction* _tmp138_;
		ValaCCodeFunction* _tmp139_;
		gchar* _tmp140_;
		gchar* _tmp141_;
		ValaCCodeVariableDeclarator* _tmp142_;
		ValaCCodeVariableDeclarator* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaCCodeFunctionCall* _tmp147_;
		ValaCCodeIdentifier* _tmp148_;
		ValaCCodeIdentifier* _tmp149_;
		ValaCCodeConstant* _tmp150_;
		ValaCCodeConstant* _tmp151_;
		ValaCCodeBinaryExpression* _tmp152_;
		ValaCCodeBinaryExpression* _tmp153_;
		ValaCCodeFunction* _tmp154_;
		ValaCCodeFunction* _tmp155_;
		ValaCCodeFunctionCall* _tmp156_;
		_tmp138_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp143_ = _tmp142_;
		vala_ccode_function_add_declaration (_tmp139_, _tmp141_, (ValaCCodeDeclarator*) _tmp143_, 0);
		_vala_ccode_node_unref0 (_tmp143_);
		_g_free0 (_tmp141_);
		_tmp144_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (fc);
		fc = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_tmp147_ = fc;
		_tmp148_ = vala_ccode_identifier_new ("return_value");
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_constant_new ("NULL");
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp149_, (ValaCCodeExpression*) _tmp151_);
		_tmp153_ = _tmp152_;
		vala_ccode_function_call_add_argument (_tmp147_, (ValaCCodeExpression*) _tmp153_);
		_vala_ccode_node_unref0 (_tmp153_);
		_vala_ccode_node_unref0 (_tmp151_);
		_vala_ccode_node_unref0 (_tmp149_);
		_tmp154_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp155_ = _tmp154_;
		_tmp156_ = fc;
		vala_ccode_function_add_expression (_tmp155_, (ValaCCodeExpression*) _tmp156_);
	}
	_tmp157_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp158_ = _tmp157_;
	_tmp159_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp158_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp159_;
	_vala_ccode_node_unref0 (_tmp158_);
	_tmp160_ = fc;
	_tmp161_ = vala_ccode_identifier_new ("n_param_values");
	_tmp162_ = _tmp161_;
	_tmp163_ = g_strdup_printf ("%i", n_params);
	_tmp164_ = _tmp163_;
	_tmp165_ = vala_ccode_constant_new (_tmp164_);
	_tmp166_ = _tmp165_;
	_tmp167_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp162_, (ValaCCodeExpression*) _tmp166_);
	_tmp168_ = _tmp167_;
	vala_ccode_function_call_add_argument (_tmp160_, (ValaCCodeExpression*) _tmp168_);
	_vala_ccode_node_unref0 (_tmp168_);
	_vala_ccode_node_unref0 (_tmp166_);
	_g_free0 (_tmp164_);
	_vala_ccode_node_unref0 (_tmp162_);
	_tmp169_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp170_ = _tmp169_;
	_tmp171_ = fc;
	vala_ccode_function_add_expression (_tmp170_, (ValaCCodeExpression*) _tmp171_);
	_tmp172_ = vala_ccode_identifier_new ("closure");
	_tmp173_ = _tmp172_;
	_tmp174_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp173_, "data", TRUE);
	_tmp175_ = _tmp174_;
	_vala_ccode_node_unref0 (_tmp173_);
	data = _tmp175_;
	_tmp176_ = vala_ccode_identifier_new ("param_values");
	_tmp177_ = _tmp176_;
	_tmp178_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp177_, "data[0]", TRUE);
	_tmp179_ = _tmp178_;
	_tmp180_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp179_, "v_pointer", FALSE);
	_tmp181_ = _tmp180_;
	_vala_ccode_node_unref0 (_tmp179_);
	_vala_ccode_node_unref0 (_tmp177_);
	param = _tmp181_;
	_tmp182_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp183_ = _tmp182_;
	_tmp184_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp183_);
	_tmp185_ = _tmp184_;
	_vala_ccode_node_unref0 (_tmp183_);
	cond = _tmp185_;
	_tmp186_ = cond;
	_tmp187_ = vala_ccode_identifier_new ("closure");
	_tmp188_ = _tmp187_;
	vala_ccode_function_call_add_argument (_tmp186_, (ValaCCodeExpression*) _tmp188_);
	_vala_ccode_node_unref0 (_tmp188_);
	_tmp189_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp190_ = _tmp189_;
	_tmp191_ = cond;
	vala_ccode_function_open_if (_tmp190_, (ValaCCodeExpression*) _tmp191_);
	_tmp192_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp193_ = _tmp192_;
	_tmp194_ = vala_ccode_identifier_new ("data1");
	_tmp195_ = _tmp194_;
	_tmp196_ = data;
	vala_ccode_function_add_assignment (_tmp193_, (ValaCCodeExpression*) _tmp195_, (ValaCCodeExpression*) _tmp196_);
	_vala_ccode_node_unref0 (_tmp195_);
	_tmp197_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp198_ = _tmp197_;
	_tmp199_ = vala_ccode_identifier_new ("data2");
	_tmp200_ = _tmp199_;
	_tmp201_ = param;
	vala_ccode_function_add_assignment (_tmp198_, (ValaCCodeExpression*) _tmp200_, (ValaCCodeExpression*) _tmp201_);
	_vala_ccode_node_unref0 (_tmp200_);
	_tmp202_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp203_ = _tmp202_;
	vala_ccode_function_add_else (_tmp203_);
	_tmp204_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp205_ = _tmp204_;
	_tmp206_ = vala_ccode_identifier_new ("data1");
	_tmp207_ = _tmp206_;
	_tmp208_ = param;
	vala_ccode_function_add_assignment (_tmp205_, (ValaCCodeExpression*) _tmp207_, (ValaCCodeExpression*) _tmp208_);
	_vala_ccode_node_unref0 (_tmp207_);
	_tmp209_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp210_ = _tmp209_;
	_tmp211_ = vala_ccode_identifier_new ("data2");
	_tmp212_ = _tmp211_;
	_tmp213_ = data;
	vala_ccode_function_add_assignment (_tmp210_, (ValaCCodeExpression*) _tmp212_, (ValaCCodeExpression*) _tmp213_);
	_vala_ccode_node_unref0 (_tmp212_);
	_tmp214_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp215_ = _tmp214_;
	vala_ccode_function_close (_tmp215_);
	_tmp216_ = vala_ccode_identifier_new ("marshal_data");
	_tmp217_ = _tmp216_;
	_tmp218_ = vala_ccode_identifier_new ("marshal_data");
	_tmp219_ = _tmp218_;
	_tmp220_ = vala_ccode_identifier_new ("cc");
	_tmp221_ = _tmp220_;
	_tmp222_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp221_, "callback", TRUE);
	_tmp223_ = _tmp222_;
	_tmp224_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp217_, (ValaCCodeExpression*) _tmp219_, (ValaCCodeExpression*) _tmp223_);
	_tmp225_ = _tmp224_;
	_tmp226_ = vala_gsignal_module_get_marshaller_function (self, params, return_type, "GMarshalFunc");
	_tmp227_ = _tmp226_;
	_tmp228_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp225_, _tmp227_);
	_tmp229_ = _tmp228_;
	_g_free0 (_tmp227_);
	_vala_ccode_node_unref0 (_tmp225_);
	_vala_ccode_node_unref0 (_tmp223_);
	_vala_ccode_node_unref0 (_tmp221_);
	_vala_ccode_node_unref0 (_tmp219_);
	_vala_ccode_node_unref0 (_tmp217_);
	c_assign_rhs = _tmp229_;
	_tmp230_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp231_ = _tmp230_;
	_tmp232_ = vala_ccode_identifier_new ("callback");
	_tmp233_ = _tmp232_;
	_tmp234_ = c_assign_rhs;
	vala_ccode_function_add_assignment (_tmp231_, (ValaCCodeExpression*) _tmp233_, (ValaCCodeExpression*) _tmp234_);
	_vala_ccode_node_unref0 (_tmp233_);
	_tmp235_ = vala_ccode_identifier_new ("callback");
	_tmp236_ = _tmp235_;
	_tmp237_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp236_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp237_;
	_vala_ccode_node_unref0 (_tmp236_);
	_tmp238_ = fc;
	_tmp239_ = vala_ccode_identifier_new ("data1");
	_tmp240_ = _tmp239_;
	vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp240_);
	_vala_ccode_node_unref0 (_tmp240_);
	i = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp241_;
		gint _p_size = 0;
		ValaList* _tmp242_;
		gint _tmp243_;
		gint _tmp244_;
		gint _p_index = 0;
		_tmp241_ = _vala_iterable_ref0 (params);
		_p_list = _tmp241_;
		_tmp242_ = _p_list;
		_tmp243_ = vala_collection_get_size ((ValaCollection*) _tmp242_);
		_tmp244_ = _tmp243_;
		_p_size = _tmp244_;
		_p_index = -1;
		while (TRUE) {
			ValaParameter* p = NULL;
			ValaList* _tmp245_;
			gpointer _tmp246_;
			gchar* get_value_function = NULL;
			ValaParameter* _tmp247_;
			ValaParameterDirection _tmp248_;
			ValaParameterDirection _tmp249_;
			ValaCCodeFunctionCall* inner_fc = NULL;
			const gchar* _tmp298_;
			ValaCCodeIdentifier* _tmp299_;
			ValaCCodeIdentifier* _tmp300_;
			ValaCCodeFunctionCall* _tmp301_;
			ValaCCodeFunctionCall* _tmp302_;
			ValaCCodeFunctionCall* _tmp303_;
			ValaCCodeIdentifier* _tmp304_;
			ValaCCodeIdentifier* _tmp305_;
			gchar* _tmp306_;
			gchar* _tmp307_;
			ValaCCodeIdentifier* _tmp308_;
			ValaCCodeIdentifier* _tmp309_;
			ValaCCodeBinaryExpression* _tmp310_;
			ValaCCodeBinaryExpression* _tmp311_;
			ValaCCodeFunctionCall* _tmp312_;
			ValaCCodeFunctionCall* _tmp313_;
			gint _tmp314_;
			ValaParameter* _tmp315_;
			ValaDataType* _tmp316_;
			ValaDataType* _tmp317_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp245_ = _p_list;
			_tmp246_ = vala_list_get (_tmp245_, _p_index);
			p = (ValaParameter*) _tmp246_;
			_tmp247_ = p;
			_tmp248_ = vala_parameter_get_direction (_tmp247_);
			_tmp249_ = _tmp248_;
			if (_tmp249_ != VALA_PARAMETER_DIRECTION_IN) {
				gchar* _tmp250_;
				_tmp250_ = g_strdup ("g_value_get_pointer");
				_g_free0 (get_value_function);
				get_value_function = _tmp250_;
			} else {
				ValaParameter* _tmp251_;
				ValaDataType* _tmp252_;
				ValaDataType* _tmp253_;
				_tmp251_ = p;
				_tmp252_ = vala_variable_get_variable_type ((ValaVariable*) _tmp251_);
				_tmp253_ = _tmp252_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp253_, VALA_TYPE_ARRAY_TYPE)) {
					ValaParameter* _tmp254_;
					ValaDataType* _tmp255_;
					ValaDataType* _tmp256_;
					ValaDataType* _tmp257_;
					ValaDataType* _tmp258_;
					ValaTypeSymbol* _tmp259_;
					ValaTypeSymbol* _tmp260_;
					ValaDataType* _tmp261_;
					ValaTypeSymbol* _tmp262_;
					ValaTypeSymbol* _tmp263_;
					_tmp254_ = p;
					_tmp255_ = vala_variable_get_variable_type ((ValaVariable*) _tmp254_);
					_tmp256_ = _tmp255_;
					_tmp257_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp256_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp258_ = _tmp257_;
					_tmp259_ = vala_data_type_get_type_symbol (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp261_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp262_ = vala_data_type_get_type_symbol (_tmp261_);
					_tmp263_ = _tmp262_;
					if (_tmp260_ == _tmp263_) {
						gchar* _tmp264_;
						_tmp264_ = g_strdup ("g_value_get_boxed");
						_g_free0 (get_value_function);
						get_value_function = _tmp264_;
					} else {
						gchar* _tmp265_;
						_tmp265_ = g_strdup ("g_value_get_pointer");
						_g_free0 (get_value_function);
						get_value_function = _tmp265_;
					}
				} else {
					ValaParameter* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					_tmp266_ = p;
					_tmp267_ = vala_variable_get_variable_type ((ValaVariable*) _tmp266_);
					_tmp268_ = _tmp267_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp268_, VALA_TYPE_DELEGATE_TYPE)) {
						gchar* _tmp269_;
						_tmp269_ = g_strdup ("g_value_get_pointer");
						_g_free0 (get_value_function);
						get_value_function = _tmp269_;
					} else {
						gboolean _tmp270_ = FALSE;
						ValaParameter* _tmp271_;
						ValaDataType* _tmp272_;
						ValaDataType* _tmp273_;
						_tmp271_ = p;
						_tmp272_ = vala_variable_get_variable_type ((ValaVariable*) _tmp271_);
						_tmp273_ = _tmp272_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp273_, VALA_TYPE_POINTER_TYPE)) {
							_tmp270_ = TRUE;
						} else {
							ValaParameter* _tmp274_;
							ValaDataType* _tmp275_;
							ValaDataType* _tmp276_;
							_tmp274_ = p;
							_tmp275_ = vala_variable_get_variable_type ((ValaVariable*) _tmp274_);
							_tmp276_ = _tmp275_;
							_tmp270_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp276_, VALA_TYPE_GENERIC_TYPE);
						}
						if (_tmp270_) {
							gchar* _tmp277_;
							_tmp277_ = g_strdup ("g_value_get_pointer");
							_g_free0 (get_value_function);
							get_value_function = _tmp277_;
						} else {
							ValaParameter* _tmp278_;
							ValaDataType* _tmp279_;
							ValaDataType* _tmp280_;
							_tmp278_ = p;
							_tmp279_ = vala_variable_get_variable_type ((ValaVariable*) _tmp278_);
							_tmp280_ = _tmp279_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp280_, VALA_TYPE_ERROR_TYPE)) {
								gchar* _tmp281_;
								_tmp281_ = g_strdup ("g_value_get_pointer");
								_g_free0 (get_value_function);
								get_value_function = _tmp281_;
							} else {
								gboolean _tmp282_ = FALSE;
								ValaParameter* _tmp283_;
								ValaDataType* _tmp284_;
								ValaDataType* _tmp285_;
								_tmp283_ = p;
								_tmp284_ = vala_variable_get_variable_type ((ValaVariable*) _tmp283_);
								_tmp285_ = _tmp284_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp285_, VALA_TYPE_VALUE_TYPE)) {
									ValaParameter* _tmp286_;
									ValaDataType* _tmp287_;
									ValaDataType* _tmp288_;
									gboolean _tmp289_;
									gboolean _tmp290_;
									_tmp286_ = p;
									_tmp287_ = vala_variable_get_variable_type ((ValaVariable*) _tmp286_);
									_tmp288_ = _tmp287_;
									_tmp289_ = vala_data_type_get_nullable (_tmp288_);
									_tmp290_ = _tmp289_;
									_tmp282_ = _tmp290_;
								} else {
									_tmp282_ = FALSE;
								}
								if (_tmp282_) {
									gchar* _tmp291_;
									_tmp291_ = g_strdup ("g_value_get_pointer");
									_g_free0 (get_value_function);
									get_value_function = _tmp291_;
								} else {
									ValaParameter* _tmp292_;
									ValaDataType* _tmp293_;
									ValaDataType* _tmp294_;
									ValaTypeSymbol* _tmp295_;
									ValaTypeSymbol* _tmp296_;
									gchar* _tmp297_;
									_tmp292_ = p;
									_tmp293_ = vala_variable_get_variable_type ((ValaVariable*) _tmp292_);
									_tmp294_ = _tmp293_;
									_tmp295_ = vala_data_type_get_type_symbol (_tmp294_);
									_tmp296_ = _tmp295_;
									_tmp297_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp296_);
									_g_free0 (get_value_function);
									get_value_function = _tmp297_;
								}
							}
						}
					}
				}
			}
			_tmp298_ = get_value_function;
			_tmp299_ = vala_ccode_identifier_new (_tmp298_);
			_tmp300_ = _tmp299_;
			_tmp301_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp300_);
			_tmp302_ = _tmp301_;
			_vala_ccode_node_unref0 (_tmp300_);
			inner_fc = _tmp302_;
			_tmp303_ = inner_fc;
			_tmp304_ = vala_ccode_identifier_new ("param_values");
			_tmp305_ = _tmp304_;
			_tmp306_ = g_strdup_printf ("%i", i);
			_tmp307_ = _tmp306_;
			_tmp308_ = vala_ccode_identifier_new (_tmp307_);
			_tmp309_ = _tmp308_;
			_tmp310_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp305_, (ValaCCodeExpression*) _tmp309_);
			_tmp311_ = _tmp310_;
			vala_ccode_function_call_add_argument (_tmp303_, (ValaCCodeExpression*) _tmp311_);
			_vala_ccode_node_unref0 (_tmp311_);
			_vala_ccode_node_unref0 (_tmp309_);
			_g_free0 (_tmp307_);
			_vala_ccode_node_unref0 (_tmp305_);
			_tmp312_ = fc;
			_tmp313_ = inner_fc;
			vala_ccode_function_call_add_argument (_tmp312_, (ValaCCodeExpression*) _tmp313_);
			_tmp314_ = i;
			i = _tmp314_ + 1;
			_tmp315_ = p;
			_tmp316_ = vala_variable_get_variable_type ((ValaVariable*) _tmp315_);
			_tmp317_ = _tmp316_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp317_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp318_;
				ValaDataType* _tmp319_;
				ValaDataType* _tmp320_;
				ValaArrayType* _tmp321_;
				gchar* length_value_function = NULL;
				ValaArrayType* _tmp322_;
				ValaDataType* _tmp323_;
				ValaDataType* _tmp324_;
				ValaTypeSymbol* _tmp325_;
				ValaTypeSymbol* _tmp326_;
				gchar* _tmp327_;
				gboolean _tmp328_ = FALSE;
				const gchar* _tmp329_;
				_tmp318_ = p;
				_tmp319_ = vala_variable_get_variable_type ((ValaVariable*) _tmp318_);
				_tmp320_ = _tmp319_;
				_tmp321_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp320_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp321_;
				_tmp322_ = array_type;
				_tmp323_ = vala_array_type_get_length_type (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_data_type_get_type_symbol (_tmp324_);
				_tmp326_ = _tmp325_;
				_tmp327_ = vala_get_ccode_get_value_function ((ValaCodeNode*) _tmp326_);
				length_value_function = _tmp327_;
				_tmp329_ = length_value_function;
				if (_tmp329_ != NULL) {
					const gchar* _tmp330_;
					_tmp330_ = length_value_function;
					_tmp328_ = g_strcmp0 (_tmp330_, "") != 0;
				} else {
					_tmp328_ = FALSE;
				}
				_vala_assert (_tmp328_, "length_value_function != null && length_value_function != \"\"");
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp331_ = FALSE;
						_tmp331_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp333_;
							gint _tmp334_;
							gint _tmp335_;
							const gchar* _tmp336_;
							ValaCCodeIdentifier* _tmp337_;
							ValaCCodeIdentifier* _tmp338_;
							ValaCCodeFunctionCall* _tmp339_;
							ValaCCodeFunctionCall* _tmp340_;
							ValaCCodeIdentifier* _tmp341_;
							ValaCCodeIdentifier* _tmp342_;
							gchar* _tmp343_;
							gchar* _tmp344_;
							ValaCCodeIdentifier* _tmp345_;
							ValaCCodeIdentifier* _tmp346_;
							ValaCCodeBinaryExpression* _tmp347_;
							ValaCCodeBinaryExpression* _tmp348_;
							ValaCCodeFunctionCall* _tmp349_;
							ValaCCodeFunctionCall* _tmp350_;
							gint _tmp351_;
							if (!_tmp331_) {
								gint _tmp332_;
								_tmp332_ = j;
								j = _tmp332_ + 1;
							}
							_tmp331_ = FALSE;
							_tmp333_ = array_type;
							_tmp334_ = vala_array_type_get_rank (_tmp333_);
							_tmp335_ = _tmp334_;
							if (!(j < _tmp335_)) {
								break;
							}
							_tmp336_ = length_value_function;
							_tmp337_ = vala_ccode_identifier_new (_tmp336_);
							_tmp338_ = _tmp337_;
							_tmp339_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp338_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp339_;
							_vala_ccode_node_unref0 (_tmp338_);
							_tmp340_ = inner_fc;
							_tmp341_ = vala_ccode_identifier_new ("param_values");
							_tmp342_ = _tmp341_;
							_tmp343_ = g_strdup_printf ("%i", i);
							_tmp344_ = _tmp343_;
							_tmp345_ = vala_ccode_identifier_new (_tmp344_);
							_tmp346_ = _tmp345_;
							_tmp347_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp342_, (ValaCCodeExpression*) _tmp346_);
							_tmp348_ = _tmp347_;
							vala_ccode_function_call_add_argument (_tmp340_, (ValaCCodeExpression*) _tmp348_);
							_vala_ccode_node_unref0 (_tmp348_);
							_vala_ccode_node_unref0 (_tmp346_);
							_g_free0 (_tmp344_);
							_vala_ccode_node_unref0 (_tmp342_);
							_tmp349_ = fc;
							_tmp350_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp349_, (ValaCCodeExpression*) _tmp350_);
							_tmp351_ = i;
							i = _tmp351_ + 1;
						}
					}
				}
				_g_free0 (length_value_function);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp352_;
				ValaDataType* _tmp353_;
				ValaDataType* _tmp354_;
				_tmp352_ = p;
				_tmp353_ = vala_variable_get_variable_type ((ValaVariable*) _tmp352_);
				_tmp354_ = _tmp353_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp354_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp355_;
					ValaDataType* _tmp356_;
					ValaDataType* _tmp357_;
					ValaDelegateType* _tmp358_;
					ValaDelegate* _tmp359_;
					ValaDelegate* _tmp360_;
					gboolean _tmp361_;
					gboolean _tmp362_;
					_tmp355_ = p;
					_tmp356_ = vala_variable_get_variable_type ((ValaVariable*) _tmp355_);
					_tmp357_ = _tmp356_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp357_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp358_ = delegate_type;
					_tmp359_ = vala_delegate_type_get_delegate_symbol (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = vala_delegate_get_has_target (_tmp360_);
					_tmp362_ = _tmp361_;
					if (_tmp362_) {
						const gchar* _tmp363_;
						ValaCCodeIdentifier* _tmp364_;
						ValaCCodeIdentifier* _tmp365_;
						ValaCCodeFunctionCall* _tmp366_;
						ValaCCodeFunctionCall* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaCCodeIdentifier* _tmp369_;
						gchar* _tmp370_;
						gchar* _tmp371_;
						ValaCCodeIdentifier* _tmp372_;
						ValaCCodeIdentifier* _tmp373_;
						ValaCCodeBinaryExpression* _tmp374_;
						ValaCCodeBinaryExpression* _tmp375_;
						ValaCCodeFunctionCall* _tmp376_;
						ValaCCodeFunctionCall* _tmp377_;
						gint _tmp378_;
						ValaDelegateType* _tmp379_;
						_tmp363_ = get_value_function;
						_tmp364_ = vala_ccode_identifier_new (_tmp363_);
						_tmp365_ = _tmp364_;
						_tmp366_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp365_);
						_vala_ccode_node_unref0 (inner_fc);
						inner_fc = _tmp366_;
						_vala_ccode_node_unref0 (_tmp365_);
						_tmp367_ = inner_fc;
						_tmp368_ = vala_ccode_identifier_new ("param_values");
						_tmp369_ = _tmp368_;
						_tmp370_ = g_strdup_printf ("%i", i);
						_tmp371_ = _tmp370_;
						_tmp372_ = vala_ccode_identifier_new (_tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp369_, (ValaCCodeExpression*) _tmp373_);
						_tmp375_ = _tmp374_;
						vala_ccode_function_call_add_argument (_tmp367_, (ValaCCodeExpression*) _tmp375_);
						_vala_ccode_node_unref0 (_tmp375_);
						_vala_ccode_node_unref0 (_tmp373_);
						_g_free0 (_tmp371_);
						_vala_ccode_node_unref0 (_tmp369_);
						_tmp376_ = fc;
						_tmp377_ = inner_fc;
						vala_ccode_function_call_add_argument (_tmp376_, (ValaCCodeExpression*) _tmp377_);
						_tmp378_ = i;
						i = _tmp378_ + 1;
						_tmp379_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp379_)) {
							const gchar* _tmp380_;
							ValaCCodeIdentifier* _tmp381_;
							ValaCCodeIdentifier* _tmp382_;
							ValaCCodeFunctionCall* _tmp383_;
							ValaCCodeFunctionCall* _tmp384_;
							ValaCCodeIdentifier* _tmp385_;
							ValaCCodeIdentifier* _tmp386_;
							gchar* _tmp387_;
							gchar* _tmp388_;
							ValaCCodeIdentifier* _tmp389_;
							ValaCCodeIdentifier* _tmp390_;
							ValaCCodeBinaryExpression* _tmp391_;
							ValaCCodeBinaryExpression* _tmp392_;
							ValaCCodeFunctionCall* _tmp393_;
							ValaCCodeFunctionCall* _tmp394_;
							gint _tmp395_;
							_tmp380_ = get_value_function;
							_tmp381_ = vala_ccode_identifier_new (_tmp380_);
							_tmp382_ = _tmp381_;
							_tmp383_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp382_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp383_;
							_vala_ccode_node_unref0 (_tmp382_);
							_tmp384_ = inner_fc;
							_tmp385_ = vala_ccode_identifier_new ("param_values");
							_tmp386_ = _tmp385_;
							_tmp387_ = g_strdup_printf ("%i", i);
							_tmp388_ = _tmp387_;
							_tmp389_ = vala_ccode_identifier_new (_tmp388_);
							_tmp390_ = _tmp389_;
							_tmp391_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp386_, (ValaCCodeExpression*) _tmp390_);
							_tmp392_ = _tmp391_;
							vala_ccode_function_call_add_argument (_tmp384_, (ValaCCodeExpression*) _tmp392_);
							_vala_ccode_node_unref0 (_tmp392_);
							_vala_ccode_node_unref0 (_tmp390_);
							_g_free0 (_tmp388_);
							_vala_ccode_node_unref0 (_tmp386_);
							_tmp393_ = fc;
							_tmp394_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp393_, (ValaCCodeExpression*) _tmp394_);
							_tmp395_ = i;
							i = _tmp395_ + 1;
						}
					}
				}
			}
			_vala_ccode_node_unref0 (inner_fc);
			_g_free0 (get_value_function);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp396_ = fc;
	_tmp397_ = vala_ccode_identifier_new ("data2");
	_tmp398_ = _tmp397_;
	vala_ccode_function_call_add_argument (_tmp396_, (ValaCCodeExpression*) _tmp398_);
	_vala_ccode_node_unref0 (_tmp398_);
	_tmp400_ = vala_data_type_get_type_symbol (return_type);
	_tmp401_ = _tmp400_;
	if (_tmp401_ != NULL) {
		_tmp399_ = TRUE;
	} else {
		_tmp399_ = G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE);
	}
	if (_tmp399_) {
		ValaCCodeFunction* _tmp402_;
		ValaCCodeFunction* _tmp403_;
		ValaCCodeIdentifier* _tmp404_;
		ValaCCodeIdentifier* _tmp405_;
		ValaCCodeFunctionCall* _tmp406_;
		ValaCCodeFunctionCall* set_fc = NULL;
		ValaCCodeFunctionCall* _tmp455_;
		ValaCCodeIdentifier* _tmp456_;
		ValaCCodeIdentifier* _tmp457_;
		ValaCCodeFunctionCall* _tmp458_;
		ValaCCodeIdentifier* _tmp459_;
		ValaCCodeIdentifier* _tmp460_;
		ValaCCodeFunction* _tmp461_;
		ValaCCodeFunction* _tmp462_;
		ValaCCodeFunctionCall* _tmp463_;
		_tmp402_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp403_ = _tmp402_;
		_tmp404_ = vala_ccode_identifier_new ("v_return");
		_tmp405_ = _tmp404_;
		_tmp406_ = fc;
		vala_ccode_function_add_assignment (_tmp403_, (ValaCCodeExpression*) _tmp405_, (ValaCCodeExpression*) _tmp406_);
		_vala_ccode_node_unref0 (_tmp405_);
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ARRAY_TYPE)) {
			ValaDataType* _tmp407_;
			ValaDataType* _tmp408_;
			ValaTypeSymbol* _tmp409_;
			ValaTypeSymbol* _tmp410_;
			ValaDataType* _tmp411_;
			ValaTypeSymbol* _tmp412_;
			ValaTypeSymbol* _tmp413_;
			_tmp407_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (return_type, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			_tmp408_ = _tmp407_;
			_tmp409_ = vala_data_type_get_type_symbol (_tmp408_);
			_tmp410_ = _tmp409_;
			_tmp411_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp412_ = vala_data_type_get_type_symbol (_tmp411_);
			_tmp413_ = _tmp412_;
			if (_tmp410_ == _tmp413_) {
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeIdentifier* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				_tmp414_ = vala_ccode_identifier_new ("g_value_take_boxed");
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp415_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp416_;
				_vala_ccode_node_unref0 (_tmp415_);
			} else {
				ValaCCodeIdentifier* _tmp417_;
				ValaCCodeIdentifier* _tmp418_;
				ValaCCodeFunctionCall* _tmp419_;
				_tmp417_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp418_ = _tmp417_;
				_tmp419_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp418_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp419_;
				_vala_ccode_node_unref0 (_tmp418_);
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_GENERIC_TYPE)) {
				ValaCCodeIdentifier* _tmp420_;
				ValaCCodeIdentifier* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				_tmp420_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp421_ = _tmp420_;
				_tmp422_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp421_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp422_;
				_vala_ccode_node_unref0 (_tmp421_);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_ERROR_TYPE)) {
					ValaCCodeIdentifier* _tmp423_;
					ValaCCodeIdentifier* _tmp424_;
					ValaCCodeFunctionCall* _tmp425_;
					_tmp423_ = vala_ccode_identifier_new ("g_value_set_pointer");
					_tmp424_ = _tmp423_;
					_tmp425_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp424_);
					_vala_ccode_node_unref0 (set_fc);
					set_fc = _tmp425_;
					_vala_ccode_node_unref0 (_tmp424_);
				} else {
					ValaTypeSymbol* _tmp426_;
					ValaTypeSymbol* _tmp427_;
					ValaDataType* _tmp428_;
					ValaTypeSymbol* _tmp429_;
					ValaTypeSymbol* _tmp430_;
					_tmp426_ = vala_data_type_get_type_symbol (return_type);
					_tmp427_ = _tmp426_;
					_tmp428_ = ((ValaCCodeBaseModule*) self)->string_type;
					_tmp429_ = vala_data_type_get_type_symbol (_tmp428_);
					_tmp430_ = _tmp429_;
					if (_tmp427_ == _tmp430_) {
						ValaCCodeIdentifier* _tmp431_;
						ValaCCodeIdentifier* _tmp432_;
						ValaCCodeFunctionCall* _tmp433_;
						_tmp431_ = vala_ccode_identifier_new ("g_value_take_string");
						_tmp432_ = _tmp431_;
						_tmp433_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp432_);
						_vala_ccode_node_unref0 (set_fc);
						set_fc = _tmp433_;
						_vala_ccode_node_unref0 (_tmp432_);
					} else {
						gboolean _tmp434_ = FALSE;
						ValaTypeSymbol* _tmp435_;
						ValaTypeSymbol* _tmp436_;
						_tmp435_ = vala_data_type_get_type_symbol (return_type);
						_tmp436_ = _tmp435_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp436_, VALA_TYPE_CLASS)) {
							_tmp434_ = TRUE;
						} else {
							ValaTypeSymbol* _tmp437_;
							ValaTypeSymbol* _tmp438_;
							_tmp437_ = vala_data_type_get_type_symbol (return_type);
							_tmp438_ = _tmp437_;
							_tmp434_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp438_, VALA_TYPE_INTERFACE);
						}
						if (_tmp434_) {
							ValaCCodeIdentifier* _tmp439_;
							ValaCCodeIdentifier* _tmp440_;
							ValaCCodeFunctionCall* _tmp441_;
							_tmp439_ = vala_ccode_identifier_new ("g_value_take_object");
							_tmp440_ = _tmp439_;
							_tmp441_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp440_);
							_vala_ccode_node_unref0 (set_fc);
							set_fc = _tmp441_;
							_vala_ccode_node_unref0 (_tmp440_);
						} else {
							gboolean _tmp442_ = FALSE;
							if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_VALUE_TYPE)) {
								gboolean _tmp443_;
								gboolean _tmp444_;
								_tmp443_ = vala_data_type_get_nullable (return_type);
								_tmp444_ = _tmp443_;
								_tmp442_ = _tmp444_;
							} else {
								_tmp442_ = FALSE;
							}
							if (_tmp442_) {
								ValaCCodeIdentifier* _tmp445_;
								ValaCCodeIdentifier* _tmp446_;
								ValaCCodeFunctionCall* _tmp447_;
								_tmp445_ = vala_ccode_identifier_new ("g_value_set_pointer");
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp446_);
								_vala_ccode_node_unref0 (set_fc);
								set_fc = _tmp447_;
								_vala_ccode_node_unref0 (_tmp446_);
							} else {
								ValaTypeSymbol* _tmp448_;
								ValaTypeSymbol* _tmp449_;
								gchar* _tmp450_;
								gchar* _tmp451_;
								ValaCCodeIdentifier* _tmp452_;
								ValaCCodeIdentifier* _tmp453_;
								ValaCCodeFunctionCall* _tmp454_;
								_tmp448_ = vala_data_type_get_type_symbol (return_type);
								_tmp449_ = _tmp448_;
								_tmp450_ = vala_get_ccode_set_value_function ((ValaCodeNode*) _tmp449_);
								_tmp451_ = _tmp450_;
								_tmp452_ = vala_ccode_identifier_new (_tmp451_);
								_tmp453_ = _tmp452_;
								_tmp454_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp453_);
								_vala_ccode_node_unref0 (set_fc);
								set_fc = _tmp454_;
								_vala_ccode_node_unref0 (_tmp453_);
								_g_free0 (_tmp451_);
							}
						}
					}
				}
			}
		}
		_tmp455_ = set_fc;
		_tmp456_ = vala_ccode_identifier_new ("return_value");
		_tmp457_ = _tmp456_;
		vala_ccode_function_call_add_argument (_tmp455_, (ValaCCodeExpression*) _tmp457_);
		_vala_ccode_node_unref0 (_tmp457_);
		_tmp458_ = set_fc;
		_tmp459_ = vala_ccode_identifier_new ("v_return");
		_tmp460_ = _tmp459_;
		vala_ccode_function_call_add_argument (_tmp458_, (ValaCCodeExpression*) _tmp460_);
		_vala_ccode_node_unref0 (_tmp460_);
		_tmp461_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp462_ = _tmp461_;
		_tmp463_ = set_fc;
		vala_ccode_function_add_expression (_tmp462_, (ValaCCodeExpression*) _tmp463_);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeFunction* _tmp464_;
		ValaCCodeFunction* _tmp465_;
		ValaCCodeFunctionCall* _tmp466_;
		_tmp464_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp465_ = _tmp464_;
		_tmp466_ = fc;
		vala_ccode_function_add_expression (_tmp465_, (ValaCCodeExpression*) _tmp466_);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp467_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp468_ = signal_marshaller;
	vala_ccode_file_add_function_declaration (_tmp467_, _tmp468_);
	_tmp469_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp470_ = signal_marshaller;
	vala_ccode_file_add_function (_tmp469_, _tmp470_);
	_tmp471_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
	_tmp472_ = signature;
	vala_collection_add ((ValaCollection*) _tmp471_, _tmp472_);
	_vala_ccode_node_unref0 (c_assign_rhs);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static ValaCCodeExpression*
vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                              ValaSignal* sig,
                                              ValaTypeSymbol* type)
{
	ValaGSignalModule * self;
	ValaCCodeFunctionCall* csignew = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	gchar** flags = NULL;
	gchar** _tmp16_;
	gint flags_length1;
	gint _flags_size_;
	gchar* run_type = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	ValaVersionAttribute* _tmp27_;
	ValaVersionAttribute* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	ValaCCodeFunctionCall* _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gchar* _tmp34_;
	gchar* _tmp35_;
	ValaCCodeConstant* _tmp36_;
	ValaCCodeConstant* _tmp37_;
	ValaMethod* _tmp38_;
	ValaMethod* _tmp39_;
	ValaCCodeFunctionCall* _tmp68_;
	ValaCCodeConstant* _tmp69_;
	ValaCCodeConstant* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeConstant* _tmp72_;
	ValaCCodeConstant* _tmp73_;
	gchar* marshaller = NULL;
	ValaList* _tmp74_;
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	gchar* _tmp77_;
	ValaCCodeIdentifier* marshal_arg = NULL;
	const gchar* _tmp78_;
	ValaCCodeIdentifier* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaList* params = NULL;
	ValaList* _tmp82_;
	ValaList* _tmp83_;
	gboolean _tmp84_ = FALSE;
	ValaDataType* _tmp85_;
	ValaDataType* _tmp86_;
	gint params_len = 0;
	ValaCCodeFunctionCall* _tmp153_;
	gchar* _tmp154_;
	gchar* _tmp155_;
	ValaCCodeConstant* _tmp156_;
	ValaCCodeConstant* _tmp157_;
	ValaCCodeIdentifier* _tmp269_;
	const gchar* _tmp270_;
	ValaCCodeExpression* _tmp271_;
	ValaCCodeExpression* _tmp272_;
	ValaCCodeFunctionCall* _tmp273_;
	ValaCCodeAssignment* _tmp274_;
	ValaCCodeExpression* _tmp275_;
	ValaCCodeExpression* result = NULL;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_signal_new");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	csignew = _tmp3_;
	_tmp4_ = csignew;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("\"%s\"", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_constant_new (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp11_ = csignew;
	_tmp12_ = vala_get_ccode_type_id ((ValaCodeNode*) type);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_identifier_new (_tmp13_);
	_tmp15_ = _tmp14_;
	vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp16_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp17_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sig, "Signal", "run", NULL);
	run_type = _tmp17_;
	_tmp18_ = run_type;
	if (g_strcmp0 (_tmp18_, "first") == 0) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp19_);
	} else {
		const gchar* _tmp20_;
		_tmp20_ = run_type;
		if (g_strcmp0 (_tmp20_, "cleanup") == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp21_);
		} else {
			gchar* _tmp22_;
			_tmp22_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp22_);
		}
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "detailed", FALSE)) {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp23_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_recurse", FALSE)) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp24_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "action", FALSE)) {
		gchar* _tmp25_;
		_tmp25_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp25_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_hooks", FALSE)) {
		gchar* _tmp26_;
		_tmp26_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp26_);
	}
	_tmp27_ = vala_symbol_get_version ((ValaSymbol*) sig);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_version_attribute_get_deprecated (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("G_SIGNAL_DEPRECATED");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp31_);
	}
	_tmp32_ = csignew;
	_tmp33_ = flags;
	_tmp33__length1 = flags_length1;
	_tmp34_ = _vala_g_strjoinv (" | ", _tmp33_, (gint) _tmp33__length1);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_ccode_constant_new (_tmp35_);
	_tmp37_ = _tmp36_;
	vala_ccode_function_call_add_argument (_tmp32_, (ValaCCodeExpression*) _tmp37_);
	_vala_ccode_node_unref0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp38_ = vala_signal_get_default_handler (sig);
	_tmp39_ = _tmp38_;
	if (_tmp39_ == NULL) {
		ValaCCodeFunctionCall* _tmp40_;
		ValaCCodeConstant* _tmp41_;
		ValaCCodeConstant* _tmp42_;
		_tmp40_ = csignew;
		_tmp41_ = vala_ccode_constant_new ("0");
		_tmp42_ = _tmp41_;
		vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp42_);
		_vala_ccode_node_unref0 (_tmp42_);
	} else {
		ValaCCodeFunctionCall* struct_offset = NULL;
		ValaCCodeIdentifier* _tmp43_;
		ValaCCodeIdentifier* _tmp44_;
		ValaCCodeFunctionCall* _tmp45_;
		ValaCCodeFunctionCall* _tmp46_;
		ValaCCodeFunctionCall* _tmp59_;
		ValaMethod* _tmp60_;
		ValaMethod* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		ValaCCodeIdentifier* _tmp64_;
		ValaCCodeIdentifier* _tmp65_;
		ValaCCodeFunctionCall* _tmp66_;
		ValaCCodeFunctionCall* _tmp67_;
		_tmp43_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp44_);
		_tmp46_ = _tmp45_;
		_vala_ccode_node_unref0 (_tmp44_);
		struct_offset = _tmp46_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_CLASS)) {
			ValaCCodeFunctionCall* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			ValaCCodeIdentifier* _tmp52_;
			ValaCCodeIdentifier* _tmp53_;
			_tmp47_ = struct_offset;
			_tmp48_ = vala_get_ccode_name ((ValaCodeNode*) type);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strdup_printf ("%sClass", _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_ccode_identifier_new (_tmp51_);
			_tmp53_ = _tmp52_;
			vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp53_);
			_vala_ccode_node_unref0 (_tmp53_);
			_g_free0 (_tmp51_);
			_g_free0 (_tmp49_);
		} else {
			ValaCCodeFunctionCall* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			ValaCCodeIdentifier* _tmp57_;
			ValaCCodeIdentifier* _tmp58_;
			_tmp54_ = struct_offset;
			_tmp55_ = vala_get_ccode_type_name (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_INTERFACE, ValaInterface));
			_tmp56_ = _tmp55_;
			_tmp57_ = vala_ccode_identifier_new (_tmp56_);
			_tmp58_ = _tmp57_;
			vala_ccode_function_call_add_argument (_tmp54_, (ValaCCodeExpression*) _tmp58_);
			_vala_ccode_node_unref0 (_tmp58_);
			_g_free0 (_tmp56_);
		}
		_tmp59_ = struct_offset;
		_tmp60_ = vala_signal_get_default_handler (sig);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_get_ccode_vfunc_name (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_ccode_identifier_new (_tmp63_);
		_tmp65_ = _tmp64_;
		vala_ccode_function_call_add_argument (_tmp59_, (ValaCCodeExpression*) _tmp65_);
		_vala_ccode_node_unref0 (_tmp65_);
		_g_free0 (_tmp63_);
		_tmp66_ = csignew;
		_tmp67_ = struct_offset;
		vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp67_);
		_vala_ccode_node_unref0 (struct_offset);
	}
	_tmp68_ = csignew;
	_tmp69_ = vala_ccode_constant_new ("NULL");
	_tmp70_ = _tmp69_;
	vala_ccode_function_call_add_argument (_tmp68_, (ValaCCodeExpression*) _tmp70_);
	_vala_ccode_node_unref0 (_tmp70_);
	_tmp71_ = csignew;
	_tmp72_ = vala_ccode_constant_new ("NULL");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp75_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp76_ = _tmp75_;
	_tmp77_ = vala_gsignal_module_get_marshaller_function (self, _tmp74_, _tmp76_, NULL);
	marshaller = _tmp77_;
	_tmp78_ = marshaller;
	_tmp79_ = vala_ccode_identifier_new (_tmp78_);
	marshal_arg = _tmp79_;
	_tmp80_ = csignew;
	_tmp81_ = marshal_arg;
	vala_ccode_function_call_add_argument (_tmp80_, (ValaCCodeExpression*) _tmp81_);
	_tmp82_ = vala_callable_get_parameters ((ValaCallable*) sig);
	_tmp83_ = _vala_iterable_ref0 (_tmp82_);
	params = _tmp83_;
	_tmp85_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp86_ = _tmp85_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, VALA_TYPE_POINTER_TYPE)) {
		_tmp84_ = TRUE;
	} else {
		ValaDataType* _tmp87_;
		ValaDataType* _tmp88_;
		_tmp87_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp88_ = _tmp87_;
		_tmp84_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp84_) {
		ValaCCodeFunctionCall* _tmp89_;
		ValaCCodeConstant* _tmp90_;
		ValaCCodeConstant* _tmp91_;
		_tmp89_ = csignew;
		_tmp90_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp91_ = _tmp90_;
		vala_ccode_function_call_add_argument (_tmp89_, (ValaCCodeExpression*) _tmp91_);
		_vala_ccode_node_unref0 (_tmp91_);
	} else {
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		_tmp92_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp93_ = _tmp92_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, VALA_TYPE_ERROR_TYPE)) {
			ValaCCodeFunctionCall* _tmp94_;
			ValaCCodeConstant* _tmp95_;
			ValaCCodeConstant* _tmp96_;
			_tmp94_ = csignew;
			_tmp95_ = vala_ccode_constant_new ("G_TYPE_POINTER");
			_tmp96_ = _tmp95_;
			vala_ccode_function_call_add_argument (_tmp94_, (ValaCCodeExpression*) _tmp96_);
			_vala_ccode_node_unref0 (_tmp96_);
		} else {
			gboolean _tmp97_ = FALSE;
			ValaDataType* _tmp98_;
			ValaDataType* _tmp99_;
			_tmp98_ = vala_callable_get_return_type ((ValaCallable*) sig);
			_tmp99_ = _tmp98_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_VALUE_TYPE)) {
				ValaDataType* _tmp100_;
				ValaDataType* _tmp101_;
				gboolean _tmp102_;
				gboolean _tmp103_;
				_tmp100_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_data_type_get_nullable (_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp97_ = _tmp103_;
			} else {
				_tmp97_ = FALSE;
			}
			if (_tmp97_) {
				ValaCCodeFunctionCall* _tmp104_;
				ValaCCodeConstant* _tmp105_;
				ValaCCodeConstant* _tmp106_;
				_tmp104_ = csignew;
				_tmp105_ = vala_ccode_constant_new ("G_TYPE_POINTER");
				_tmp106_ = _tmp105_;
				vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (_tmp106_);
			} else {
				ValaDataType* _tmp107_;
				ValaDataType* _tmp108_;
				ValaTypeSymbol* _tmp109_;
				ValaTypeSymbol* _tmp110_;
				_tmp107_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp108_ = _tmp107_;
				_tmp109_ = vala_data_type_get_type_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				if (_tmp110_ == NULL) {
					ValaCCodeFunctionCall* _tmp111_;
					ValaCCodeConstant* _tmp112_;
					ValaCCodeConstant* _tmp113_;
					_tmp111_ = csignew;
					_tmp112_ = vala_ccode_constant_new ("G_TYPE_NONE");
					_tmp113_ = _tmp112_;
					vala_ccode_function_call_add_argument (_tmp111_, (ValaCCodeExpression*) _tmp113_);
					_vala_ccode_node_unref0 (_tmp113_);
				} else {
					ValaCCodeFunctionCall* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					ValaTypeSymbol* _tmp117_;
					ValaTypeSymbol* _tmp118_;
					gchar* _tmp119_;
					gchar* _tmp120_;
					ValaCCodeConstant* _tmp121_;
					ValaCCodeConstant* _tmp122_;
					_tmp114_ = csignew;
					_tmp115_ = vala_callable_get_return_type ((ValaCallable*) sig);
					_tmp116_ = _tmp115_;
					_tmp117_ = vala_data_type_get_type_symbol (_tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp118_);
					_tmp120_ = _tmp119_;
					_tmp121_ = vala_ccode_constant_new (_tmp120_);
					_tmp122_ = _tmp121_;
					vala_ccode_function_call_add_argument (_tmp114_, (ValaCCodeExpression*) _tmp122_);
					_vala_ccode_node_unref0 (_tmp122_);
					_g_free0 (_tmp120_);
				}
			}
		}
	}
	params_len = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp123_;
		ValaList* _tmp124_;
		gint _param_size = 0;
		ValaList* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _param_index = 0;
		_tmp123_ = params;
		_tmp124_ = _vala_iterable_ref0 (_tmp123_);
		_param_list = _tmp124_;
		_tmp125_ = _param_list;
		_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
		_tmp127_ = _tmp126_;
		_param_size = _tmp127_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp128_;
			gpointer _tmp129_;
			gint _tmp130_;
			ValaParameter* _tmp131_;
			ValaDataType* _tmp132_;
			ValaDataType* _tmp133_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp128_ = _param_list;
			_tmp129_ = vala_list_get (_tmp128_, _param_index);
			param = (ValaParameter*) _tmp129_;
			_tmp130_ = params_len;
			params_len = _tmp130_ + 1;
			_tmp131_ = param;
			_tmp132_ = vala_variable_get_variable_type ((ValaVariable*) _tmp131_);
			_tmp133_ = _tmp132_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp133_, VALA_TYPE_ARRAY_TYPE)) {
				ValaParameter* _tmp134_;
				ValaDataType* _tmp135_;
				ValaDataType* _tmp136_;
				gint _tmp137_;
				gint _tmp138_;
				_tmp134_ = param;
				_tmp135_ = vala_variable_get_variable_type ((ValaVariable*) _tmp134_);
				_tmp136_ = _tmp135_;
				_tmp137_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp138_ = _tmp137_;
				params_len += _tmp138_;
			} else {
				ValaParameter* _tmp139_;
				ValaDataType* _tmp140_;
				ValaDataType* _tmp141_;
				_tmp139_ = param;
				_tmp140_ = vala_variable_get_variable_type ((ValaVariable*) _tmp139_);
				_tmp141_ = _tmp140_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp141_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp142_;
					ValaDataType* _tmp143_;
					ValaDataType* _tmp144_;
					ValaDelegateType* _tmp145_;
					ValaDelegate* _tmp146_;
					ValaDelegate* _tmp147_;
					gboolean _tmp148_;
					gboolean _tmp149_;
					_tmp142_ = param;
					_tmp143_ = vala_variable_get_variable_type ((ValaVariable*) _tmp142_);
					_tmp144_ = _tmp143_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp144_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp145_ = delegate_type;
					_tmp146_ = vala_delegate_type_get_delegate_symbol (_tmp145_);
					_tmp147_ = _tmp146_;
					_tmp148_ = vala_delegate_get_has_target (_tmp147_);
					_tmp149_ = _tmp148_;
					if (_tmp149_) {
						gint _tmp150_;
						ValaDelegateType* _tmp151_;
						_tmp150_ = params_len;
						params_len = _tmp150_ + 1;
						_tmp151_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp151_)) {
							gint _tmp152_;
							_tmp152_ = params_len;
							params_len = _tmp152_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp153_ = csignew;
	_tmp154_ = g_strdup_printf ("%d", params_len);
	_tmp155_ = _tmp154_;
	_tmp156_ = vala_ccode_constant_new (_tmp155_);
	_tmp157_ = _tmp156_;
	vala_ccode_function_call_add_argument (_tmp153_, (ValaCCodeExpression*) _tmp157_);
	_vala_ccode_node_unref0 (_tmp157_);
	_g_free0 (_tmp155_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp158_;
		ValaList* _tmp159_;
		gint _param_size = 0;
		ValaList* _tmp160_;
		gint _tmp161_;
		gint _tmp162_;
		gint _param_index = 0;
		_tmp158_ = params;
		_tmp159_ = _vala_iterable_ref0 (_tmp158_);
		_param_list = _tmp159_;
		_tmp160_ = _param_list;
		_tmp161_ = vala_collection_get_size ((ValaCollection*) _tmp160_);
		_tmp162_ = _tmp161_;
		_param_size = _tmp162_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp163_;
			gpointer _tmp164_;
			ValaParameter* _tmp165_;
			ValaDataType* _tmp166_;
			ValaDataType* _tmp167_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp163_ = _param_list;
			_tmp164_ = vala_list_get (_tmp163_, _param_index);
			param = (ValaParameter*) _tmp164_;
			_tmp165_ = param;
			_tmp166_ = vala_variable_get_variable_type ((ValaVariable*) _tmp165_);
			_tmp167_ = _tmp166_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp167_, VALA_TYPE_ARRAY_TYPE)) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp168_;
				ValaDataType* _tmp169_;
				ValaDataType* _tmp170_;
				ValaArrayType* _tmp171_;
				ValaArrayType* _tmp172_;
				ValaDataType* _tmp173_;
				ValaDataType* _tmp174_;
				ValaTypeSymbol* _tmp175_;
				ValaTypeSymbol* _tmp176_;
				ValaDataType* _tmp177_;
				ValaTypeSymbol* _tmp178_;
				ValaTypeSymbol* _tmp179_;
				ValaArrayType* _tmp186_;
				ValaDataType* _tmp187_;
				ValaDataType* _tmp188_;
				ValaTypeSymbol* _tmp189_;
				ValaTypeSymbol* _tmp190_;
				gchar* length_type_id = NULL;
				ValaArrayType* _tmp191_;
				ValaDataType* _tmp192_;
				ValaDataType* _tmp193_;
				ValaTypeSymbol* _tmp194_;
				ValaTypeSymbol* _tmp195_;
				gchar* _tmp196_;
				_tmp168_ = param;
				_tmp169_ = vala_variable_get_variable_type ((ValaVariable*) _tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp171_;
				_tmp172_ = array_type;
				_tmp173_ = vala_array_type_get_element_type (_tmp172_);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_data_type_get_type_symbol (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp178_ = vala_data_type_get_type_symbol (_tmp177_);
				_tmp179_ = _tmp178_;
				if (_tmp176_ == _tmp179_) {
					ValaCCodeFunctionCall* _tmp180_;
					ValaCCodeConstant* _tmp181_;
					ValaCCodeConstant* _tmp182_;
					_tmp180_ = csignew;
					_tmp181_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp182_ = _tmp181_;
					vala_ccode_function_call_add_argument (_tmp180_, (ValaCCodeExpression*) _tmp182_);
					_vala_ccode_node_unref0 (_tmp182_);
				} else {
					ValaCCodeFunctionCall* _tmp183_;
					ValaCCodeConstant* _tmp184_;
					ValaCCodeConstant* _tmp185_;
					_tmp183_ = csignew;
					_tmp184_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp185_ = _tmp184_;
					vala_ccode_function_call_add_argument (_tmp183_, (ValaCCodeExpression*) _tmp185_);
					_vala_ccode_node_unref0 (_tmp185_);
				}
				_tmp186_ = array_type;
				_tmp187_ = vala_array_type_get_length_type (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp189_ = vala_data_type_get_type_symbol (_tmp188_);
				_tmp190_ = _tmp189_;
				_vala_assert (vala_get_ccode_has_type_id (_tmp190_), "get_ccode_has_type_id (array_type.length_type.type_symbol)");
				_tmp191_ = array_type;
				_tmp192_ = vala_array_type_get_length_type (_tmp191_);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_data_type_get_type_symbol (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp195_);
				length_type_id = _tmp196_;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp197_ = FALSE;
						_tmp197_ = TRUE;
						while (TRUE) {
							ValaArrayType* _tmp199_;
							gint _tmp200_;
							gint _tmp201_;
							ValaCCodeFunctionCall* _tmp202_;
							const gchar* _tmp203_;
							ValaCCodeConstant* _tmp204_;
							ValaCCodeConstant* _tmp205_;
							if (!_tmp197_) {
								gint _tmp198_;
								_tmp198_ = i;
								i = _tmp198_ + 1;
							}
							_tmp197_ = FALSE;
							_tmp199_ = array_type;
							_tmp200_ = vala_array_type_get_rank (_tmp199_);
							_tmp201_ = _tmp200_;
							if (!(i < _tmp201_)) {
								break;
							}
							_tmp202_ = csignew;
							_tmp203_ = length_type_id;
							_tmp204_ = vala_ccode_constant_new (_tmp203_);
							_tmp205_ = _tmp204_;
							vala_ccode_function_call_add_argument (_tmp202_, (ValaCCodeExpression*) _tmp205_);
							_vala_ccode_node_unref0 (_tmp205_);
						}
					}
				}
				_g_free0 (length_type_id);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaParameter* _tmp206_;
				ValaDataType* _tmp207_;
				ValaDataType* _tmp208_;
				_tmp206_ = param;
				_tmp207_ = vala_variable_get_variable_type ((ValaVariable*) _tmp206_);
				_tmp208_ = _tmp207_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp208_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp209_;
					ValaDataType* _tmp210_;
					ValaDataType* _tmp211_;
					ValaCCodeFunctionCall* _tmp212_;
					ValaCCodeConstant* _tmp213_;
					ValaCCodeConstant* _tmp214_;
					ValaDelegateType* _tmp215_;
					ValaDelegate* _tmp216_;
					ValaDelegate* _tmp217_;
					gboolean _tmp218_;
					gboolean _tmp219_;
					_tmp209_ = param;
					_tmp210_ = vala_variable_get_variable_type ((ValaVariable*) _tmp209_);
					_tmp211_ = _tmp210_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp211_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp212_ = csignew;
					_tmp213_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp214_ = _tmp213_;
					vala_ccode_function_call_add_argument (_tmp212_, (ValaCCodeExpression*) _tmp214_);
					_vala_ccode_node_unref0 (_tmp214_);
					_tmp215_ = delegate_type;
					_tmp216_ = vala_delegate_type_get_delegate_symbol (_tmp215_);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_delegate_get_has_target (_tmp217_);
					_tmp219_ = _tmp218_;
					if (_tmp219_) {
						ValaCCodeFunctionCall* _tmp220_;
						ValaCCodeConstant* _tmp221_;
						ValaCCodeConstant* _tmp222_;
						ValaDelegateType* _tmp223_;
						_tmp220_ = csignew;
						_tmp221_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp222_ = _tmp221_;
						vala_ccode_function_call_add_argument (_tmp220_, (ValaCCodeExpression*) _tmp222_);
						_vala_ccode_node_unref0 (_tmp222_);
						_tmp223_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp223_)) {
							ValaCCodeFunctionCall* _tmp224_;
							ValaCCodeConstant* _tmp225_;
							ValaCCodeConstant* _tmp226_;
							_tmp224_ = csignew;
							_tmp225_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp226_ = _tmp225_;
							vala_ccode_function_call_add_argument (_tmp224_, (ValaCCodeExpression*) _tmp226_);
							_vala_ccode_node_unref0 (_tmp226_);
						}
					}
				} else {
					gboolean _tmp227_ = FALSE;
					gboolean _tmp228_ = FALSE;
					ValaParameter* _tmp229_;
					ValaDataType* _tmp230_;
					ValaDataType* _tmp231_;
					_tmp229_ = param;
					_tmp230_ = vala_variable_get_variable_type ((ValaVariable*) _tmp229_);
					_tmp231_ = _tmp230_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp231_, VALA_TYPE_POINTER_TYPE)) {
						_tmp228_ = TRUE;
					} else {
						ValaParameter* _tmp232_;
						ValaDataType* _tmp233_;
						ValaDataType* _tmp234_;
						_tmp232_ = param;
						_tmp233_ = vala_variable_get_variable_type ((ValaVariable*) _tmp232_);
						_tmp234_ = _tmp233_;
						_tmp228_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp234_, VALA_TYPE_GENERIC_TYPE);
					}
					if (_tmp228_) {
						_tmp227_ = TRUE;
					} else {
						ValaParameter* _tmp235_;
						ValaParameterDirection _tmp236_;
						ValaParameterDirection _tmp237_;
						_tmp235_ = param;
						_tmp236_ = vala_parameter_get_direction (_tmp235_);
						_tmp237_ = _tmp236_;
						_tmp227_ = _tmp237_ != VALA_PARAMETER_DIRECTION_IN;
					}
					if (_tmp227_) {
						ValaCCodeFunctionCall* _tmp238_;
						ValaCCodeConstant* _tmp239_;
						ValaCCodeConstant* _tmp240_;
						_tmp238_ = csignew;
						_tmp239_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp240_ = _tmp239_;
						vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp240_);
						_vala_ccode_node_unref0 (_tmp240_);
					} else {
						ValaParameter* _tmp241_;
						ValaDataType* _tmp242_;
						ValaDataType* _tmp243_;
						_tmp241_ = param;
						_tmp242_ = vala_variable_get_variable_type ((ValaVariable*) _tmp241_);
						_tmp243_ = _tmp242_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp243_, VALA_TYPE_ERROR_TYPE)) {
							ValaCCodeFunctionCall* _tmp244_;
							ValaCCodeConstant* _tmp245_;
							ValaCCodeConstant* _tmp246_;
							_tmp244_ = csignew;
							_tmp245_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp246_ = _tmp245_;
							vala_ccode_function_call_add_argument (_tmp244_, (ValaCCodeExpression*) _tmp246_);
							_vala_ccode_node_unref0 (_tmp246_);
						} else {
							gboolean _tmp247_ = FALSE;
							ValaParameter* _tmp248_;
							ValaDataType* _tmp249_;
							ValaDataType* _tmp250_;
							_tmp248_ = param;
							_tmp249_ = vala_variable_get_variable_type ((ValaVariable*) _tmp248_);
							_tmp250_ = _tmp249_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp250_, VALA_TYPE_VALUE_TYPE)) {
								ValaParameter* _tmp251_;
								ValaDataType* _tmp252_;
								ValaDataType* _tmp253_;
								gboolean _tmp254_;
								gboolean _tmp255_;
								_tmp251_ = param;
								_tmp252_ = vala_variable_get_variable_type ((ValaVariable*) _tmp251_);
								_tmp253_ = _tmp252_;
								_tmp254_ = vala_data_type_get_nullable (_tmp253_);
								_tmp255_ = _tmp254_;
								_tmp247_ = _tmp255_;
							} else {
								_tmp247_ = FALSE;
							}
							if (_tmp247_) {
								ValaCCodeFunctionCall* _tmp256_;
								ValaCCodeConstant* _tmp257_;
								ValaCCodeConstant* _tmp258_;
								_tmp256_ = csignew;
								_tmp257_ = vala_ccode_constant_new ("G_TYPE_POINTER");
								_tmp258_ = _tmp257_;
								vala_ccode_function_call_add_argument (_tmp256_, (ValaCCodeExpression*) _tmp258_);
								_vala_ccode_node_unref0 (_tmp258_);
							} else {
								ValaCCodeFunctionCall* _tmp259_;
								ValaParameter* _tmp260_;
								ValaDataType* _tmp261_;
								ValaDataType* _tmp262_;
								ValaTypeSymbol* _tmp263_;
								ValaTypeSymbol* _tmp264_;
								gchar* _tmp265_;
								gchar* _tmp266_;
								ValaCCodeConstant* _tmp267_;
								ValaCCodeConstant* _tmp268_;
								_tmp259_ = csignew;
								_tmp260_ = param;
								_tmp261_ = vala_variable_get_variable_type ((ValaVariable*) _tmp260_);
								_tmp262_ = _tmp261_;
								_tmp263_ = vala_data_type_get_type_symbol (_tmp262_);
								_tmp264_ = _tmp263_;
								_tmp265_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp264_);
								_tmp266_ = _tmp265_;
								_tmp267_ = vala_ccode_constant_new (_tmp266_);
								_tmp268_ = _tmp267_;
								vala_ccode_function_call_add_argument (_tmp259_, (ValaCCodeExpression*) _tmp268_);
								_vala_ccode_node_unref0 (_tmp268_);
								_g_free0 (_tmp266_);
							}
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp269_ = marshal_arg;
	_tmp270_ = marshaller;
	vala_ccode_identifier_set_name (_tmp269_, _tmp270_);
	_tmp271_ = vala_gsignal_module_get_signal_id_cexpression (self, sig);
	_tmp272_ = _tmp271_;
	_tmp273_ = csignew;
	_tmp274_ = vala_ccode_assignment_new (_tmp272_, (ValaCCodeExpression*) _tmp273_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp275_ = (ValaCCodeExpression*) _tmp274_;
	_vala_ccode_node_unref0 (_tmp272_);
	result = _tmp275_;
	_vala_iterable_unref0 (params);
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	_g_free0 (run_type);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_vala_ccode_node_unref0 (csignew);
	return result;
}

static void
vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                               ValaElementAccess* expr)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = vala_element_access_get_container (expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp3_ = vala_element_access_get_container (expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_expression_get_symbol_reference (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_SIGNAL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		_tmp7_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD_CALL)) {
			ValaSignal* sig = NULL;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSignal* _tmp11_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaMemberAccess* _tmp14_;
			ValaExpression* detail_expr = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaCCodeFunctionCall* ccall = NULL;
			gboolean _tmp17_ = FALSE;
			ValaSignal* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			ValaCCodeFunctionCall* _tmp61_;
			_tmp9_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SIGNAL, ValaSignal));
			sig = _tmp11_;
			_tmp12_ = vala_element_access_get_container (expr);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp14_;
			_tmp15_ = vala_element_access_get_indices (expr);
			_tmp16_ = vala_list_get (_tmp15_, 0);
			detail_expr = (ValaExpression*) _tmp16_;
			_tmp18_ = sig;
			_tmp19_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			if (!_tmp20_) {
				ValaSourceReference* _tmp21_;
				ValaSourceReference* _tmp22_;
				ValaSourceFile* _tmp23_;
				ValaSourceFile* _tmp24_;
				ValaSignal* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaSourceReference* _tmp27_;
				ValaSourceFile* _tmp28_;
				ValaSourceFile* _tmp29_;
				_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_source_reference_get_file (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = sig;
				_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_source_reference_get_file (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp17_ = _tmp24_ == _tmp29_;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				ValaCCodeExpression* detail_cexpr = NULL;
				ValaExpression* _tmp30_;
				ValaCCodeExpression* _tmp31_;
				ValaCCodeIdentifier* _tmp32_;
				ValaCCodeIdentifier* _tmp33_;
				ValaCCodeFunctionCall* _tmp34_;
				ValaCCodeFunctionCall* _tmp35_;
				ValaMemberAccess* _tmp36_;
				ValaExpression* _tmp37_;
				ValaExpression* _tmp38_;
				ValaCCodeExpression* _tmp39_;
				ValaCCodeExpression* _tmp40_;
				ValaCCodeFunctionCall* _tmp41_;
				ValaSignal* _tmp42_;
				ValaCCodeExpression* _tmp43_;
				ValaCCodeExpression* _tmp44_;
				ValaCCodeFunctionCall* _tmp45_;
				ValaCCodeExpression* _tmp46_;
				_tmp30_ = detail_expr;
				_tmp31_ = vala_gsignal_module_get_detail_cexpression (self, _tmp30_, (ValaCodeNode*) expr);
				detail_cexpr = _tmp31_;
				_tmp32_ = vala_ccode_identifier_new ("g_signal_emit");
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp33_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp34_;
				_vala_ccode_node_unref0 (_tmp33_);
				_tmp35_ = ccall;
				_tmp36_ = ma;
				_tmp37_ = vala_member_access_get_inner (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp38_);
				_tmp40_ = _tmp39_;
				vala_ccode_function_call_add_argument (_tmp35_, _tmp40_);
				_vala_ccode_node_unref0 (_tmp40_);
				_tmp41_ = ccall;
				_tmp42_ = sig;
				_tmp43_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp42_);
				_tmp44_ = _tmp43_;
				vala_ccode_function_call_add_argument (_tmp41_, _tmp44_);
				_vala_ccode_node_unref0 (_tmp44_);
				_tmp45_ = ccall;
				_tmp46_ = detail_cexpr;
				vala_ccode_function_call_add_argument (_tmp45_, _tmp46_);
				_vala_ccode_node_unref0 (detail_cexpr);
			} else {
				ValaCCodeExpression* signal_name_cexpr = NULL;
				ValaSignal* _tmp47_;
				ValaExpression* _tmp48_;
				ValaCCodeExpression* _tmp49_;
				ValaCCodeIdentifier* _tmp50_;
				ValaCCodeIdentifier* _tmp51_;
				ValaCCodeFunctionCall* _tmp52_;
				ValaCCodeFunctionCall* _tmp53_;
				ValaMemberAccess* _tmp54_;
				ValaExpression* _tmp55_;
				ValaExpression* _tmp56_;
				ValaCCodeExpression* _tmp57_;
				ValaCCodeExpression* _tmp58_;
				ValaCCodeFunctionCall* _tmp59_;
				ValaCCodeExpression* _tmp60_;
				_tmp47_ = sig;
				_tmp48_ = detail_expr;
				_tmp49_ = vala_gsignal_module_get_signal_name_cexpression (self, _tmp47_, _tmp48_, (ValaCodeNode*) expr);
				signal_name_cexpr = _tmp49_;
				_tmp50_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp51_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp52_;
				_vala_ccode_node_unref0 (_tmp51_);
				_tmp53_ = ccall;
				_tmp54_ = ma;
				_tmp55_ = vala_member_access_get_inner (_tmp54_);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp56_);
				_tmp58_ = _tmp57_;
				vala_ccode_function_call_add_argument (_tmp53_, _tmp58_);
				_vala_ccode_node_unref0 (_tmp58_);
				_tmp59_ = ccall;
				_tmp60_ = signal_name_cexpr;
				vala_ccode_function_call_add_argument (_tmp59_, _tmp60_);
				_vala_ccode_node_unref0 (signal_name_cexpr);
			}
			_tmp61_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp61_);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (sig);
		} else {
		}
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}

static gboolean
vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                         ValaMethod* m)
{
	gboolean _result_ = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		_tmp2_ = vala_method_get_this_parameter (m);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_type_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_result_ = vala_typesymbol_is_subtype_of (_tmp7_, _tmp8_);
	}
	result = _result_;
	return result;
}

static void
vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                              ValaMemberAccess* expr)
{
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_SIGNAL)) {
		ValaCCodeExpression* pub_inst = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSignal* _tmp9_;
		ValaTypeSymbol* cl = NULL;
		ValaSignal* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		gboolean _tmp14_ = FALSE;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gboolean _tmp50_ = FALSE;
		ValaSignal* _tmp51_;
		gboolean _tmp52_;
		gboolean _tmp53_;
		pub_inst = NULL;
		_tmp2_ = vala_member_access_get_inner (expr);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			ValaCCodeExpression* _tmp6_;
			_tmp4_ = vala_member_access_get_inner (expr);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
			_vala_ccode_node_unref0 (pub_inst);
			pub_inst = _tmp6_;
		}
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp9_;
		_tmp10_ = sig;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		cl = _tmp13_;
		_tmp15_ = vala_member_access_get_inner (expr);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_BASE_ACCESS)) {
			ValaSignal* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = sig;
			_tmp18_ = vala_signal_get_is_virtual (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp14_ = _tmp19_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaMethod* m = NULL;
			ValaSignal* _tmp20_;
			ValaMethod* _tmp21_;
			ValaMethod* _tmp22_;
			ValaMethod* _tmp23_;
			ValaClass* base_class = NULL;
			ValaMethod* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaClass* _tmp27_;
			ValaCCodeFunctionCall* vcast = NULL;
			ValaClass* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunctionCall* _tmp33_;
			ValaCCodeFunctionCall* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaClass* _tmp36_;
			ValaClass* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeIdentifier* _tmp42_;
			ValaCCodeIdentifier* _tmp43_;
			ValaCCodeFunctionCall* _tmp44_;
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			ValaCCodeMemberAccess* _tmp48_;
			ValaCCodeMemberAccess* _tmp49_;
			_tmp20_ = sig;
			_tmp21_ = vala_signal_get_default_handler (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _vala_code_node_ref0 (_tmp22_);
			m = _tmp23_;
			_tmp24_ = m;
			_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_CLASS, ValaClass));
			base_class = _tmp27_;
			_tmp28_ = base_class;
			_tmp29_ = vala_get_ccode_class_type_function (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp32_);
			_tmp34_ = _tmp33_;
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			vcast = _tmp34_;
			_tmp35_ = vcast;
			_tmp36_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strdup_printf ("%s_parent_class", _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_identifier_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_call_add_argument (_tmp35_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_tmp44_ = vcast;
			_tmp45_ = m;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp44_, _tmp47_);
			_tmp49_ = _tmp48_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp49_);
			_vala_ccode_node_unref0 (_tmp49_);
			_vala_ccode_node_unref0 (vcast);
			_vala_code_node_unref0 (base_class);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (sig);
			_vala_ccode_node_unref0 (pub_inst);
			return;
		}
		_tmp51_ = sig;
		_tmp52_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp51_);
		_tmp53_ = _tmp52_;
		if (!_tmp53_) {
			ValaSourceReference* _tmp54_;
			ValaSourceReference* _tmp55_;
			ValaSourceFile* _tmp56_;
			ValaSourceFile* _tmp57_;
			ValaSignal* _tmp58_;
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			ValaSourceFile* _tmp61_;
			ValaSourceFile* _tmp62_;
			_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp55_ = _tmp54_;
			_tmp56_ = vala_source_reference_get_file (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = sig;
			_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = vala_source_reference_get_file (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp50_ = _tmp57_ == _tmp62_;
		} else {
			_tmp50_ = FALSE;
		}
		if (_tmp50_) {
			ValaCCodeFunctionCall* ccall = NULL;
			ValaCCodeIdentifier* _tmp63_;
			ValaCCodeIdentifier* _tmp64_;
			ValaCCodeFunctionCall* _tmp65_;
			ValaCCodeFunctionCall* _tmp66_;
			ValaCCodeFunctionCall* _tmp67_;
			ValaCCodeExpression* _tmp68_;
			ValaCCodeFunctionCall* _tmp69_;
			ValaSignal* _tmp70_;
			ValaCCodeExpression* _tmp71_;
			ValaCCodeExpression* _tmp72_;
			ValaCCodeFunctionCall* _tmp73_;
			ValaCCodeConstant* _tmp74_;
			ValaCCodeConstant* _tmp75_;
			ValaCCodeFunctionCall* _tmp76_;
			_tmp63_ = vala_ccode_identifier_new ("g_signal_emit");
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
			_tmp66_ = _tmp65_;
			_vala_ccode_node_unref0 (_tmp64_);
			ccall = _tmp66_;
			_tmp67_ = ccall;
			_tmp68_ = pub_inst;
			vala_ccode_function_call_add_argument (_tmp67_, _tmp68_);
			_tmp69_ = ccall;
			_tmp70_ = sig;
			_tmp71_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp70_);
			_tmp72_ = _tmp71_;
			vala_ccode_function_call_add_argument (_tmp69_, _tmp72_);
			_vala_ccode_node_unref0 (_tmp72_);
			_tmp73_ = ccall;
			_tmp74_ = vala_ccode_constant_new ("0");
			_tmp75_ = _tmp74_;
			vala_ccode_function_call_add_argument (_tmp73_, (ValaCCodeExpression*) _tmp75_);
			_vala_ccode_node_unref0 (_tmp75_);
			_tmp76_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp76_);
			_vala_ccode_node_unref0 (ccall);
		} else {
			ValaSignal* _tmp77_;
			_tmp77_ = sig;
			if (vala_get_ccode_has_emitter (_tmp77_)) {
				gchar* emitter_func = NULL;
				ValaSignal* _tmp78_;
				ValaMethod* _tmp79_;
				ValaMethod* _tmp80_;
				ValaCCodeFunctionCall* ccall = NULL;
				const gchar* _tmp109_;
				ValaCCodeIdentifier* _tmp110_;
				ValaCCodeIdentifier* _tmp111_;
				ValaCCodeFunctionCall* _tmp112_;
				ValaCCodeFunctionCall* _tmp113_;
				ValaCCodeFunctionCall* _tmp114_;
				ValaCCodeExpression* _tmp115_;
				ValaCCodeFunctionCall* _tmp116_;
				_tmp78_ = sig;
				_tmp79_ = vala_signal_get_emitter (_tmp78_);
				_tmp80_ = _tmp79_;
				if (_tmp80_ != NULL) {
					gboolean _tmp81_ = FALSE;
					ValaSignal* _tmp82_;
					gboolean _tmp83_;
					gboolean _tmp84_;
					ValaSignal* _tmp98_;
					ValaMethod* _tmp99_;
					ValaMethod* _tmp100_;
					gchar* _tmp101_;
					_tmp82_ = sig;
					_tmp83_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp82_);
					_tmp84_ = _tmp83_;
					if (!_tmp84_) {
						ValaSourceReference* _tmp85_;
						ValaSourceReference* _tmp86_;
						ValaSourceFile* _tmp87_;
						ValaSourceFile* _tmp88_;
						ValaSignal* _tmp89_;
						ValaSourceReference* _tmp90_;
						ValaSourceReference* _tmp91_;
						ValaSourceFile* _tmp92_;
						ValaSourceFile* _tmp93_;
						_tmp85_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp86_ = _tmp85_;
						_tmp87_ = vala_source_reference_get_file (_tmp86_);
						_tmp88_ = _tmp87_;
						_tmp89_ = sig;
						_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp89_);
						_tmp91_ = _tmp90_;
						_tmp92_ = vala_source_reference_get_file (_tmp91_);
						_tmp93_ = _tmp92_;
						_tmp81_ = _tmp88_ != _tmp93_;
					} else {
						_tmp81_ = FALSE;
					}
					if (_tmp81_) {
						ValaSignal* _tmp94_;
						ValaMethod* _tmp95_;
						ValaMethod* _tmp96_;
						ValaCCodeFile* _tmp97_;
						_tmp94_ = sig;
						_tmp95_ = vala_signal_get_emitter (_tmp94_);
						_tmp96_ = _tmp95_;
						_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
						vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
					}
					_tmp98_ = sig;
					_tmp99_ = vala_signal_get_emitter (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp100_, NULL);
					_g_free0 (emitter_func);
					emitter_func = _tmp101_;
				} else {
					ValaTypeSymbol* _tmp102_;
					gchar* _tmp103_;
					gchar* _tmp104_;
					ValaSignal* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					_tmp102_ = cl;
					_tmp103_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp102_, NULL);
					_tmp104_ = _tmp103_;
					_tmp105_ = sig;
					_tmp106_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp105_, NULL);
					_tmp107_ = _tmp106_;
					_tmp108_ = g_strdup_printf ("%s_%s", _tmp104_, _tmp107_);
					_g_free0 (emitter_func);
					emitter_func = _tmp108_;
					_g_free0 (_tmp107_);
					_g_free0 (_tmp104_);
				}
				_tmp109_ = emitter_func;
				_tmp110_ = vala_ccode_identifier_new (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp112_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp111_);
				_tmp113_ = _tmp112_;
				_vala_ccode_node_unref0 (_tmp111_);
				ccall = _tmp113_;
				_tmp114_ = ccall;
				_tmp115_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp114_, _tmp115_);
				_tmp116_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp116_);
				_vala_ccode_node_unref0 (ccall);
				_g_free0 (emitter_func);
			} else {
				ValaCCodeFunctionCall* ccall = NULL;
				ValaCCodeIdentifier* _tmp117_;
				ValaCCodeIdentifier* _tmp118_;
				ValaCCodeFunctionCall* _tmp119_;
				ValaCCodeFunctionCall* _tmp120_;
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeExpression* _tmp122_;
				ValaCCodeFunctionCall* _tmp123_;
				ValaSignal* _tmp124_;
				ValaCCodeConstant* _tmp125_;
				ValaCCodeConstant* _tmp126_;
				ValaCCodeFunctionCall* _tmp127_;
				_tmp117_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp118_ = _tmp117_;
				_tmp119_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp118_);
				_tmp120_ = _tmp119_;
				_vala_ccode_node_unref0 (_tmp118_);
				ccall = _tmp120_;
				_tmp121_ = ccall;
				_tmp122_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp121_, _tmp122_);
				_tmp123_ = ccall;
				_tmp124_ = sig;
				_tmp125_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, _tmp124_, NULL);
				_tmp126_ = _tmp125_;
				vala_ccode_function_call_add_argument (_tmp123_, (ValaCCodeExpression*) _tmp126_);
				_vala_ccode_node_unref0 (_tmp126_);
				_tmp127_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp127_);
				_vala_ccode_node_unref0 (ccall);
			}
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (sig);
		_vala_ccode_node_unref0 (pub_inst);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}

static void
vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGSignalModule * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	ValaSignal* sig = NULL;
	ValaMethodType* _tmp12_;
	ValaMethod* _tmp13_;
	ValaMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSignal* _tmp17_;
	ValaExpression* signal_access = NULL;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaExpression* handler = NULL;
	ValaList* _tmp23_;
	gpointer _tmp24_;
	gboolean disconnect = FALSE;
	ValaMethodType* _tmp25_;
	ValaMethod* _tmp26_;
	ValaMethod* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gboolean after = FALSE;
	ValaMethodType* _tmp30_;
	ValaMethod* _tmp31_;
	ValaMethod* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	ValaCCodeExpression* cexpr = NULL;
	ValaSignal* _tmp35_;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaCCodeExpression* _tmp38_;
	ValaCCodeExpression* _tmp39_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	}
	if (_tmp5_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp12_ = method_type;
	_tmp13_ = vala_method_type_get_method_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp17_;
	_tmp18_ = vala_method_call_get_call (expr);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	signal_access = _tmp22_;
	_tmp23_ = vala_method_call_get_argument_list (expr);
	_tmp24_ = vala_list_get (_tmp23_, 0);
	handler = (ValaExpression*) _tmp24_;
	_tmp25_ = method_type;
	_tmp26_ = vala_method_type_get_method_symbol (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
	_tmp29_ = _tmp28_;
	disconnect = g_strcmp0 (_tmp29_, "disconnect") == 0;
	_tmp30_ = method_type;
	_tmp31_ = vala_method_type_get_method_symbol (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_symbol_get_name ((ValaSymbol*) _tmp32_);
	_tmp34_ = _tmp33_;
	after = g_strcmp0 (_tmp34_, "connect_after") == 0;
	_tmp35_ = sig;
	_tmp36_ = signal_access;
	_tmp37_ = handler;
	_tmp38_ = vala_gsignal_module_connect_signal (self, _tmp35_, _tmp36_, _tmp37_, disconnect, after, (ValaCodeNode*) expr);
	cexpr = _tmp38_;
	_tmp39_ = cexpr;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp39_);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}

static ValaCCodeExpression*
vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                    ValaSignal* sig,
                                    ValaExpression* signal_access,
                                    ValaExpression* handler,
                                    gboolean disconnect,
                                    gboolean after,
                                    ValaCodeNode* expr)
{
	gchar* connect_func = NULL;
	ValaDelegateType* dt = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaMethod* _tmp25_;
	ValaCCodeFunctionCall* ccall = NULL;
	const gchar* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeFunctionCall* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeExpression* signal_name_cexpr = NULL;
	ValaMemberAccess* ma = NULL;
	ValaMemberAccess* _tmp65_;
	ValaExpression* _tmp66_;
	ValaExpression* _tmp67_;
	ValaCCodeFunctionCall* _tmp160_;
	ValaCCodeExpression* _tmp161_;
	ValaCCodeExpression* _tmp162_;
	ValaCCodeCastExpression* _tmp163_;
	ValaCCodeCastExpression* _tmp164_;
	gboolean _tmp165_ = FALSE;
	ValaMethod* _tmp166_;
	gboolean _tmp242_ = FALSE;
	ValaCCodeExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	dt = NULL;
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VARIABLE)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDelegateType* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValaDelegateType* _tmp8_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		_tmp2_ = vala_expression_get_symbol_reference (handler);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp5_) : NULL);
		_vala_code_node_unref0 (dt);
		dt = _tmp6_;
		_tmp8_ = dt;
		if (_tmp8_ != NULL) {
			ValaCodeContext* _tmp9_;
			ValaCodeContext* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_context_get_experimental (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = !_tmp12_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaSourceReference* _tmp13_;
			ValaSourceReference* _tmp14_;
			_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			_tmp14_ = _tmp13_;
			vala_report_warning (_tmp14_, "Connecting delegates to signals is experimental");
		}
		_tmp15_ = vala_expression_get_symbol_reference (handler);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_LAMBDA_EXPRESSION)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference (handler);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_VARIABLE, ValaVariable));
			_tmp22_ = _tmp21_;
			handler = _tmp22_;
		}
	}
	_tmp23_ = vala_expression_get_symbol_reference (handler);
	_tmp24_ = _tmp23_;
	_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp24_) : NULL);
	m = _tmp25_;
	if (!disconnect) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			if (!after) {
				gchar* _tmp26_;
				_tmp26_ = vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp26_;
			} else {
				gchar* _tmp27_;
				_tmp27_ = vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp27_;
			}
		} else {
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			ValaMethod* _tmp30_;
			_tmp30_ = m;
			if (_tmp30_ != NULL) {
				ValaMethod* _tmp31_;
				gboolean _tmp32_;
				gboolean _tmp33_;
				_tmp31_ = m;
				_tmp32_ = vala_method_get_closure (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp29_ = _tmp33_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				_tmp28_ = TRUE;
			} else {
				gboolean _tmp34_ = FALSE;
				ValaDelegateType* _tmp35_;
				_tmp35_ = dt;
				if (_tmp35_ != NULL) {
					ValaDelegateType* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_;
					_tmp36_ = dt;
					_tmp37_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp34_ = _tmp38_;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp28_ = _tmp34_;
			}
			if (_tmp28_) {
				gchar* _tmp39_;
				_tmp39_ = g_strdup ("g_signal_connect_data");
				_g_free0 (connect_func);
				connect_func = _tmp39_;
			} else {
				gboolean _tmp40_ = FALSE;
				ValaMethod* _tmp41_;
				_tmp41_ = m;
				if (_tmp41_ != NULL) {
					ValaMethod* _tmp42_;
					_tmp42_ = m;
					_tmp40_ = vala_gsignal_module_in_gobject_instance (self, _tmp42_);
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup ("g_signal_connect_object");
					_g_free0 (connect_func);
					connect_func = _tmp43_;
				} else {
					if (!after) {
						gchar* _tmp44_;
						_tmp44_ = g_strdup ("g_signal_connect");
						_g_free0 (connect_func);
						connect_func = _tmp44_;
					} else {
						gchar* _tmp45_;
						_tmp45_ = g_strdup ("g_signal_connect_after");
						_g_free0 (connect_func);
						connect_func = _tmp45_;
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gchar* _tmp46_;
			_tmp46_ = vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
			_g_free0 (connect_func);
			connect_func = _tmp46_;
		} else {
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_g_free0 (connect_func);
			connect_func = _tmp47_;
		}
	}
	_tmp48_ = connect_func;
	_tmp49_ = vala_ccode_identifier_new (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp50_);
	_tmp52_ = _tmp51_;
	_vala_ccode_node_unref0 (_tmp50_);
	ccall = _tmp52_;
	signal_name_cexpr = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
		ValaElementAccess* ea = NULL;
		ValaElementAccess* _tmp53_;
		ValaElementAccess* _tmp54_;
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaExpression* detail_expr = NULL;
		ValaElementAccess* _tmp58_;
		ValaList* _tmp59_;
		gpointer _tmp60_;
		ValaExpression* _tmp61_;
		ValaCCodeExpression* _tmp62_;
		_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
		ea = _tmp53_;
		_tmp54_ = ea;
		_tmp55_ = vala_element_access_get_container (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp57_;
		_tmp58_ = ea;
		_tmp59_ = vala_element_access_get_indices (_tmp58_);
		_tmp60_ = vala_list_get (_tmp59_, 0);
		detail_expr = (ValaExpression*) _tmp60_;
		_tmp61_ = detail_expr;
		_tmp62_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, _tmp61_, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp62_;
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp63_;
		ValaCCodeExpression* _tmp64_;
		_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp63_;
		_tmp64_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp64_;
	}
	_tmp65_ = ma;
	_tmp66_ = vala_member_access_get_inner (_tmp65_);
	_tmp67_ = _tmp66_;
	if (_tmp67_ != NULL) {
		ValaCCodeFunctionCall* _tmp68_;
		ValaMemberAccess* _tmp69_;
		ValaExpression* _tmp70_;
		ValaExpression* _tmp71_;
		ValaCCodeExpression* _tmp72_;
		ValaCCodeExpression* _tmp73_;
		_tmp68_ = ccall;
		_tmp69_ = ma;
		_tmp70_ = vala_member_access_get_inner (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp71_);
		_tmp73_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression);
		vala_ccode_function_call_add_argument (_tmp68_, _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
	} else {
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeExpression* _tmp75_;
		ValaCCodeExpression* _tmp76_;
		_tmp74_ = ccall;
		_tmp75_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp76_ = _tmp75_;
		vala_ccode_function_call_add_argument (_tmp74_, _tmp76_);
		_vala_ccode_node_unref0 (_tmp76_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
		ValaCCodeFunctionCall* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		ValaCCodeConstant* _tmp82_;
		ValaCCodeConstant* _tmp83_;
		_tmp77_ = ccall;
		_tmp78_ = vala_get_ccode_name ((ValaCodeNode*) sig);
		_tmp79_ = _tmp78_;
		_tmp80_ = g_strdup_printf ("\"%s\"", _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_ccode_constant_new (_tmp81_);
		_tmp83_ = _tmp82_;
		vala_ccode_function_call_add_argument (_tmp77_, (ValaCCodeExpression*) _tmp83_);
		_vala_ccode_node_unref0 (_tmp83_);
		_g_free0 (_tmp81_);
		_g_free0 (_tmp79_);
	} else {
		if (!disconnect) {
			ValaCCodeFunctionCall* _tmp84_;
			ValaCCodeExpression* _tmp85_;
			_tmp84_ = ccall;
			_tmp85_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp84_, _tmp85_);
		} else {
			ValaLocalVariable* temp_decl = NULL;
			ValaDataType* _tmp92_;
			ValaLocalVariable* _tmp93_;
			ValaLocalVariable* _tmp94_;
			ValaCCodeFunctionCall* parse_call = NULL;
			ValaCCodeIdentifier* _tmp95_;
			ValaCCodeIdentifier* _tmp96_;
			ValaCCodeFunctionCall* _tmp97_;
			ValaCCodeFunctionCall* _tmp98_;
			ValaCCodeFunctionCall* _tmp99_;
			ValaCCodeExpression* _tmp100_;
			ValaTypeSymbol* decl_type = NULL;
			ValaSymbol* _tmp101_;
			ValaSymbol* _tmp102_;
			ValaTypeSymbol* _tmp103_;
			ValaCCodeFunctionCall* _tmp104_;
			ValaTypeSymbol* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			ValaCCodeIdentifier* _tmp108_;
			ValaCCodeIdentifier* _tmp109_;
			ValaCCodeFunctionCall* _tmp110_;
			ValaLocalVariable* _tmp111_;
			const gchar* _tmp112_;
			const gchar* _tmp113_;
			ValaCCodeExpression* _tmp114_;
			ValaCCodeExpression* _tmp115_;
			ValaCCodeUnaryExpression* _tmp116_;
			ValaCCodeUnaryExpression* _tmp117_;
			ValaLocalVariable* detail_temp_decl = NULL;
			ValaCCodeFunction* _tmp138_;
			ValaCCodeFunction* _tmp139_;
			ValaCCodeFunctionCall* _tmp140_;
			ValaCCodeFunctionCall* _tmp141_;
			ValaLocalVariable* _tmp142_;
			const gchar* _tmp143_;
			const gchar* _tmp144_;
			ValaCCodeExpression* _tmp145_;
			ValaCCodeExpression* _tmp146_;
			ValaLocalVariable* _tmp147_;
			ValaCCodeFunctionCall* _tmp157_;
			ValaCCodeConstant* _tmp158_;
			ValaCCodeConstant* _tmp159_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp86_;
				ValaCCodeConstant* _tmp87_;
				ValaCCodeConstant* _tmp88_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp88_ = _tmp87_;
				vala_ccode_function_call_add_argument (_tmp86_, (ValaCCodeExpression*) _tmp88_);
				_vala_ccode_node_unref0 (_tmp88_);
			} else {
				ValaCCodeFunctionCall* _tmp89_;
				ValaCCodeConstant* _tmp90_;
				ValaCCodeConstant* _tmp91_;
				_tmp89_ = ccall;
				_tmp90_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp91_ = _tmp90_;
				vala_ccode_function_call_add_argument (_tmp89_, (ValaCCodeExpression*) _tmp91_);
				_vala_ccode_node_unref0 (_tmp91_);
			}
			_tmp92_ = ((ValaCCodeBaseModule*) self)->uint_type;
			_tmp93_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp92_, TRUE, NULL, FALSE);
			temp_decl = _tmp93_;
			_tmp94_ = temp_decl;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp94_, FALSE);
			_tmp95_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			_vala_ccode_node_unref0 (_tmp96_);
			parse_call = _tmp98_;
			_tmp99_ = parse_call;
			_tmp100_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp99_, _tmp100_);
			_tmp101_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp102_ = _tmp101_;
			_tmp103_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			decl_type = _tmp103_;
			_tmp104_ = parse_call;
			_tmp105_ = decl_type;
			_tmp106_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp105_);
			_tmp107_ = _tmp106_;
			_tmp108_ = vala_ccode_identifier_new (_tmp107_);
			_tmp109_ = _tmp108_;
			vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp109_);
			_vala_ccode_node_unref0 (_tmp109_);
			_g_free0 (_tmp107_);
			_tmp110_ = parse_call;
			_tmp111_ = temp_decl;
			_tmp112_ = vala_symbol_get_name ((ValaSymbol*) _tmp111_);
			_tmp113_ = _tmp112_;
			_tmp114_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp115_);
			_tmp117_ = _tmp116_;
			vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp117_);
			_vala_ccode_node_unref0 (_tmp117_);
			_vala_ccode_node_unref0 (_tmp115_);
			detail_temp_decl = NULL;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp118_;
				ValaCCodeConstant* _tmp119_;
				ValaCCodeConstant* _tmp120_;
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeConstant* _tmp122_;
				ValaCCodeConstant* _tmp123_;
				_tmp118_ = parse_call;
				_tmp119_ = vala_ccode_constant_new ("NULL");
				_tmp120_ = _tmp119_;
				vala_ccode_function_call_add_argument (_tmp118_, (ValaCCodeExpression*) _tmp120_);
				_vala_ccode_node_unref0 (_tmp120_);
				_tmp121_ = parse_call;
				_tmp122_ = vala_ccode_constant_new ("FALSE");
				_tmp123_ = _tmp122_;
				vala_ccode_function_call_add_argument (_tmp121_, (ValaCCodeExpression*) _tmp123_);
				_vala_ccode_node_unref0 (_tmp123_);
			} else {
				ValaDataType* _tmp124_;
				ValaLocalVariable* _tmp125_;
				ValaLocalVariable* _tmp126_;
				ValaCCodeFunctionCall* _tmp127_;
				ValaLocalVariable* _tmp128_;
				const gchar* _tmp129_;
				const gchar* _tmp130_;
				ValaCCodeExpression* _tmp131_;
				ValaCCodeExpression* _tmp132_;
				ValaCCodeUnaryExpression* _tmp133_;
				ValaCCodeUnaryExpression* _tmp134_;
				ValaCCodeFunctionCall* _tmp135_;
				ValaCCodeConstant* _tmp136_;
				ValaCCodeConstant* _tmp137_;
				_tmp124_ = ((ValaCCodeBaseModule*) self)->gquark_type;
				_tmp125_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp124_, TRUE, NULL, FALSE);
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp125_;
				_tmp126_ = detail_temp_decl;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp126_, FALSE);
				_tmp127_ = parse_call;
				_tmp128_ = detail_temp_decl;
				_tmp129_ = vala_symbol_get_name ((ValaSymbol*) _tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp133_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp132_);
				_tmp134_ = _tmp133_;
				vala_ccode_function_call_add_argument (_tmp127_, (ValaCCodeExpression*) _tmp134_);
				_vala_ccode_node_unref0 (_tmp134_);
				_vala_ccode_node_unref0 (_tmp132_);
				_tmp135_ = parse_call;
				_tmp136_ = vala_ccode_constant_new ("TRUE");
				_tmp137_ = _tmp136_;
				vala_ccode_function_call_add_argument (_tmp135_, (ValaCCodeExpression*) _tmp137_);
				_vala_ccode_node_unref0 (_tmp137_);
			}
			_tmp138_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp139_ = _tmp138_;
			_tmp140_ = parse_call;
			vala_ccode_function_add_expression (_tmp139_, (ValaCCodeExpression*) _tmp140_);
			_tmp141_ = ccall;
			_tmp142_ = temp_decl;
			_tmp143_ = vala_symbol_get_name ((ValaSymbol*) _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp144_);
			_tmp146_ = _tmp145_;
			vala_ccode_function_call_add_argument (_tmp141_, _tmp146_);
			_vala_ccode_node_unref0 (_tmp146_);
			_tmp147_ = detail_temp_decl;
			if (_tmp147_ == NULL) {
				ValaCCodeFunctionCall* _tmp148_;
				ValaCCodeConstant* _tmp149_;
				ValaCCodeConstant* _tmp150_;
				_tmp148_ = ccall;
				_tmp149_ = vala_ccode_constant_new ("0");
				_tmp150_ = _tmp149_;
				vala_ccode_function_call_add_argument (_tmp148_, (ValaCCodeExpression*) _tmp150_);
				_vala_ccode_node_unref0 (_tmp150_);
			} else {
				ValaCCodeFunctionCall* _tmp151_;
				ValaLocalVariable* _tmp152_;
				const gchar* _tmp153_;
				const gchar* _tmp154_;
				ValaCCodeExpression* _tmp155_;
				ValaCCodeExpression* _tmp156_;
				_tmp151_ = ccall;
				_tmp152_ = detail_temp_decl;
				_tmp153_ = vala_symbol_get_name ((ValaSymbol*) _tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp154_);
				_tmp156_ = _tmp155_;
				vala_ccode_function_call_add_argument (_tmp151_, _tmp156_);
				_vala_ccode_node_unref0 (_tmp156_);
			}
			_tmp157_ = ccall;
			_tmp158_ = vala_ccode_constant_new ("NULL");
			_tmp159_ = _tmp158_;
			vala_ccode_function_call_add_argument (_tmp157_, (ValaCCodeExpression*) _tmp159_);
			_vala_ccode_node_unref0 (_tmp159_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp160_ = ccall;
	_tmp161_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, handler);
	_tmp162_ = _tmp161_;
	_tmp163_ = vala_ccode_cast_expression_new (_tmp162_, "GCallback");
	_tmp164_ = _tmp163_;
	vala_ccode_function_call_add_argument (_tmp160_, (ValaCCodeExpression*) _tmp164_);
	_vala_ccode_node_unref0 (_tmp164_);
	_vala_ccode_node_unref0 (_tmp162_);
	_tmp166_ = m;
	if (_tmp166_ != NULL) {
		ValaMethod* _tmp167_;
		gboolean _tmp168_;
		gboolean _tmp169_;
		_tmp167_ = m;
		_tmp168_ = vala_method_get_closure (_tmp167_);
		_tmp169_ = _tmp168_;
		_tmp165_ = _tmp169_;
	} else {
		_tmp165_ = FALSE;
	}
	if (_tmp165_) {
		ValaCCodeExpression* handler_destroy_notify = NULL;
		ValaCCodeFunctionCall* _tmp170_;
		ValaCCodeExpression* _tmp171_ = NULL;
		ValaCCodeExpression* _tmp172_;
		ValaCCodeExpression* _tmp173_;
		ValaCCodeFunctionCall* _tmp174_;
		ValaCCodeExpression* _tmp175_;
		ValaCCodeCastExpression* _tmp176_;
		ValaCCodeCastExpression* _tmp177_;
		_tmp170_ = ccall;
		_tmp172_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp171_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp171_;
		_tmp173_ = _tmp172_;
		vala_ccode_function_call_add_argument (_tmp170_, _tmp173_);
		_vala_ccode_node_unref0 (_tmp173_);
		_tmp174_ = ccall;
		_tmp175_ = handler_destroy_notify;
		_tmp176_ = vala_ccode_cast_expression_new (_tmp175_, "GClosureNotify");
		_tmp177_ = _tmp176_;
		vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp177_);
		_vala_ccode_node_unref0 (_tmp177_);
		if (!after) {
			ValaCCodeFunctionCall* _tmp178_;
			ValaCCodeConstant* _tmp179_;
			ValaCCodeConstant* _tmp180_;
			_tmp178_ = ccall;
			_tmp179_ = vala_ccode_constant_new ("0");
			_tmp180_ = _tmp179_;
			vala_ccode_function_call_add_argument (_tmp178_, (ValaCCodeExpression*) _tmp180_);
			_vala_ccode_node_unref0 (_tmp180_);
		} else {
			ValaCCodeFunctionCall* _tmp181_;
			ValaCCodeConstant* _tmp182_;
			ValaCCodeConstant* _tmp183_;
			_tmp181_ = ccall;
			_tmp182_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp183_ = _tmp182_;
			vala_ccode_function_call_add_argument (_tmp181_, (ValaCCodeExpression*) _tmp183_);
			_vala_ccode_node_unref0 (_tmp183_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		gboolean _tmp184_ = FALSE;
		ValaMethod* _tmp185_;
		_tmp185_ = m;
		if (_tmp185_ != NULL) {
			ValaMethod* _tmp186_;
			ValaMemberBinding _tmp187_;
			ValaMemberBinding _tmp188_;
			_tmp186_ = m;
			_tmp187_ = vala_method_get_binding (_tmp186_);
			_tmp188_ = _tmp187_;
			_tmp184_ = _tmp188_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp184_ = FALSE;
		}
		if (_tmp184_) {
			gboolean _tmp205_ = FALSE;
			gboolean _tmp206_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* right_ma = NULL;
				ValaMemberAccess* _tmp189_;
				ValaMemberAccess* _tmp190_;
				ValaExpression* _tmp191_;
				ValaExpression* _tmp192_;
				_tmp189_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (handler, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				right_ma = _tmp189_;
				_tmp190_ = right_ma;
				_tmp191_ = vala_member_access_get_inner (_tmp190_);
				_tmp192_ = _tmp191_;
				if (_tmp192_ != NULL) {
					ValaCCodeFunctionCall* _tmp193_;
					ValaMemberAccess* _tmp194_;
					ValaExpression* _tmp195_;
					ValaExpression* _tmp196_;
					ValaCCodeExpression* _tmp197_;
					ValaCCodeExpression* _tmp198_;
					_tmp193_ = ccall;
					_tmp194_ = right_ma;
					_tmp195_ = vala_member_access_get_inner (_tmp194_);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp196_);
					_tmp198_ = _tmp197_;
					vala_ccode_function_call_add_argument (_tmp193_, _tmp198_);
					_vala_ccode_node_unref0 (_tmp198_);
				} else {
					ValaCCodeFunctionCall* _tmp199_;
					ValaCCodeExpression* _tmp200_;
					ValaCCodeExpression* _tmp201_;
					_tmp199_ = ccall;
					_tmp200_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp201_ = _tmp200_;
					vala_ccode_function_call_add_argument (_tmp199_, _tmp201_);
					_vala_ccode_node_unref0 (_tmp201_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_LAMBDA_EXPRESSION)) {
					ValaCCodeFunctionCall* _tmp202_;
					ValaCCodeExpression* _tmp203_;
					ValaCCodeExpression* _tmp204_;
					_tmp202_ = ccall;
					_tmp203_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp204_ = _tmp203_;
					vala_ccode_function_call_add_argument (_tmp202_, _tmp204_);
					_vala_ccode_node_unref0 (_tmp204_);
				}
			}
			if (!disconnect) {
				_tmp206_ = !G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL);
			} else {
				_tmp206_ = FALSE;
			}
			if (_tmp206_) {
				ValaMethod* _tmp207_;
				_tmp207_ = m;
				_tmp205_ = vala_gsignal_module_in_gobject_instance (self, _tmp207_);
			} else {
				_tmp205_ = FALSE;
			}
			if (_tmp205_) {
				if (!after) {
					ValaCCodeFunctionCall* _tmp208_;
					ValaCCodeConstant* _tmp209_;
					ValaCCodeConstant* _tmp210_;
					_tmp208_ = ccall;
					_tmp209_ = vala_ccode_constant_new ("0");
					_tmp210_ = _tmp209_;
					vala_ccode_function_call_add_argument (_tmp208_, (ValaCCodeExpression*) _tmp210_);
					_vala_ccode_node_unref0 (_tmp210_);
				} else {
					ValaCCodeFunctionCall* _tmp211_;
					ValaCCodeConstant* _tmp212_;
					ValaCCodeConstant* _tmp213_;
					_tmp211_ = ccall;
					_tmp212_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp213_ = _tmp212_;
					vala_ccode_function_call_add_argument (_tmp211_, (ValaCCodeExpression*) _tmp213_);
					_vala_ccode_node_unref0 (_tmp213_);
				}
			}
		} else {
			gboolean _tmp214_ = FALSE;
			ValaDelegateType* _tmp215_;
			_tmp215_ = dt;
			if (_tmp215_ != NULL) {
				ValaDelegateType* _tmp216_;
				ValaDelegate* _tmp217_;
				ValaDelegate* _tmp218_;
				gboolean _tmp219_;
				gboolean _tmp220_;
				_tmp216_ = dt;
				_tmp217_ = vala_delegate_type_get_delegate_symbol (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = vala_delegate_get_has_target (_tmp218_);
				_tmp220_ = _tmp219_;
				_tmp214_ = _tmp220_;
			} else {
				_tmp214_ = FALSE;
			}
			if (_tmp214_) {
				ValaCCodeExpression* handler_destroy_notify = NULL;
				ValaCCodeFunctionCall* _tmp221_;
				ValaCCodeExpression* _tmp222_ = NULL;
				ValaCCodeExpression* _tmp223_;
				ValaCCodeExpression* _tmp224_;
				gboolean _tmp225_ = FALSE;
				_tmp221_ = ccall;
				_tmp223_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp222_);
				_vala_ccode_node_unref0 (handler_destroy_notify);
				handler_destroy_notify = _tmp222_;
				_tmp224_ = _tmp223_;
				vala_ccode_function_call_add_argument (_tmp221_, _tmp224_);
				_vala_ccode_node_unref0 (_tmp224_);
				if (!disconnect) {
					ValaDelegateType* _tmp226_;
					gboolean _tmp227_;
					gboolean _tmp228_;
					_tmp226_ = dt;
					_tmp227_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp226_);
					_tmp228_ = _tmp227_;
					_tmp225_ = _tmp228_;
				} else {
					_tmp225_ = FALSE;
				}
				if (_tmp225_) {
					ValaCCodeFunctionCall* _tmp229_;
					ValaCCodeExpression* _tmp230_;
					ValaCCodeCastExpression* _tmp231_;
					ValaCCodeCastExpression* _tmp232_;
					_tmp229_ = ccall;
					_tmp230_ = handler_destroy_notify;
					_tmp231_ = vala_ccode_cast_expression_new (_tmp230_, "GClosureNotify");
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_add_argument (_tmp229_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					if (!after) {
						ValaCCodeFunctionCall* _tmp233_;
						ValaCCodeConstant* _tmp234_;
						ValaCCodeConstant* _tmp235_;
						_tmp233_ = ccall;
						_tmp234_ = vala_ccode_constant_new ("0");
						_tmp235_ = _tmp234_;
						vala_ccode_function_call_add_argument (_tmp233_, (ValaCCodeExpression*) _tmp235_);
						_vala_ccode_node_unref0 (_tmp235_);
					} else {
						ValaCCodeFunctionCall* _tmp236_;
						ValaCCodeConstant* _tmp237_;
						ValaCCodeConstant* _tmp238_;
						_tmp236_ = ccall;
						_tmp237_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
						_tmp238_ = _tmp237_;
						vala_ccode_function_call_add_argument (_tmp236_, (ValaCCodeExpression*) _tmp238_);
						_vala_ccode_node_unref0 (_tmp238_);
					}
				}
				_vala_ccode_node_unref0 (handler_destroy_notify);
			} else {
				ValaCCodeFunctionCall* _tmp239_;
				ValaCCodeConstant* _tmp240_;
				ValaCCodeConstant* _tmp241_;
				_tmp239_ = ccall;
				_tmp240_ = vala_ccode_constant_new ("NULL");
				_tmp241_ = _tmp240_;
				vala_ccode_function_call_add_argument (_tmp239_, (ValaCCodeExpression*) _tmp241_);
				_vala_ccode_node_unref0 (_tmp241_);
			}
		}
	}
	if (disconnect) {
		_tmp242_ = TRUE;
	} else {
		ValaCodeNode* _tmp243_;
		ValaCodeNode* _tmp244_;
		_tmp243_ = vala_code_node_get_parent_node (expr);
		_tmp244_ = _tmp243_;
		_tmp242_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp244_, VALA_TYPE_EXPRESSION_STATEMENT);
	}
	if (_tmp242_) {
		ValaCCodeFunction* _tmp245_;
		ValaCCodeFunction* _tmp246_;
		ValaCCodeFunctionCall* _tmp247_;
		_tmp245_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp246_ = _tmp245_;
		_tmp247_ = ccall;
		vala_ccode_function_add_expression (_tmp246_, (ValaCCodeExpression*) _tmp247_);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* temp_var = NULL;
		ValaDataType* _tmp248_;
		ValaLocalVariable* _tmp249_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp250_;
		const gchar* _tmp251_;
		const gchar* _tmp252_;
		ValaCCodeExpression* _tmp253_;
		ValaLocalVariable* _tmp254_;
		ValaCCodeFunction* _tmp255_;
		ValaCCodeFunction* _tmp256_;
		ValaCCodeExpression* _tmp257_;
		ValaCCodeFunctionCall* _tmp258_;
		_tmp248_ = ((ValaCCodeBaseModule*) self)->ulong_type;
		_tmp249_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp248_, TRUE, NULL, FALSE);
		temp_var = _tmp249_;
		_tmp250_ = temp_var;
		_tmp251_ = vala_symbol_get_name ((ValaSymbol*) _tmp250_);
		_tmp252_ = _tmp251_;
		_tmp253_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp252_);
		temp_ref = _tmp253_;
		_tmp254_ = temp_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp254_, FALSE);
		_tmp255_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp256_ = _tmp255_;
		_tmp257_ = temp_ref;
		_tmp258_ = ccall;
		vala_ccode_function_add_assignment (_tmp256_, _tmp257_, (ValaCCodeExpression*) _tmp258_);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	}
	_vala_code_node_unref0 (ma);
	_vala_ccode_node_unref0 (signal_name_cexpr);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (dt);
	_g_free0 (connect_func);
}

ValaGSignalModule*
vala_gsignal_module_construct (GType object_type)
{
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}

ValaGSignalModule*
vala_gsignal_module_new (void)
{
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}

static void
vala_gsignal_module_class_init (ValaGSignalModuleClass * klass,
                                gpointer klass_data)
{
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gsignal_module_real_visit_signal;
	((ValaCCodeBaseModuleClass *) klass)->get_signal_creation = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaSignal*, ValaTypeSymbol*)) vala_gsignal_module_real_get_signal_creation;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_gsignal_module_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) vala_gsignal_module_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gsignal_module_real_visit_method_call;
}

static void
vala_gsignal_module_instance_init (ValaGSignalModule * self,
                                   gpointer klass)
{
}

static GType
vala_gsignal_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
	GType vala_gsignal_module_type_id;
	vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
	return vala_gsignal_module_type_id;
}

GType
vala_gsignal_module_get_type (void)
{
	static volatile gsize vala_gsignal_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__volatile)) {
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = vala_gsignal_module_get_type_once ();
		g_once_init_leave (&vala_gsignal_module_type_id__volatile, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

